<?php

/**
 * @file
 * Contains database additions for openid_connect schema version 30001.
 */

use Drupal\Core\Database\Database;
use Drupal\Tests\openid_connect\Functional\Update\OpenIdConnectUpdateSettingsTest;

$connection = Database::getConnection();

// Load the extensions and enable the openid_connect module.
$extensions = $connection->select('config')
  ->fields('config', ['data'])
  ->condition('collection', '')
  ->condition('name', 'core.extension')
  ->execute()
  ->fetchField();
$extensions = unserialize($extensions);
$extensions['module']['openid_connect'] = 0;

$connection->update('config')
  ->fields(['data' => serialize($extensions)])
  ->condition('collection', '')
  ->condition('name', 'core.extension')
  ->execute();

// The starting configuration for openid_connect.settings.
$startingConfig = [
  'always_save_userinfo' => TRUE,
  'connect_existing_users' => FALSE,
  'override_registration_settings' => FALSE,
  'end_session_enabled' => TRUE,
  'user_login_display' => 'hidden',
  'redirect_login' => 'user',
  'redirect_logout' => '',
  'userinfo_mappings' => [
    'timezone' => 'zoneinfo',
  ],
  'role_mappings' => OpenIdConnectUpdateSettingsTest::PRE_UPDATE_ROLE_MAPPING,
];

// Insert the starting configuration for openid_connect.settings.
$connection->insert('config')
  ->fields([
    'collection',
    'name',
    'data',
  ])
  ->values([
    'collection' => '',
    'name' => 'openid_connect.settings',
    'data' => serialize($startingConfig),
  ])
  ->execute();


$connection->insert('key_value')
  ->fields([
    'collection',
    'name',
    'value',
  ])
  ->values([
    'collection' => 'entity.definitions.installed',
    'name' => 'openid_connect_client.entity_type',
    'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:21:"openid_connect_client";s:8:" * class";s:54:"Drupal\openid_connect\Entity\OpenIDConnectClientEntity";s:11:" * provider";s:14:"openid_connect";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:54:"Drupal\openid_connect\Entity\OpenIDConnectClientEntity";s:11:" * handlers";a:4:{s:12:"list_builder";s:63:"Drupal\openid_connect\Controller\OpenIDConnectClientListBuilder";s:4:"form";a:3:{s:3:"add";s:53:"Drupal\openid_connect\Form\OpenIDConnectClientAddForm";s:4:"edit";s:54:"Drupal\openid_connect\Form\OpenIDConnectClientEditForm";s:6:"delete";s:56:"Drupal\openid_connect\Form\OpenIDConnectClientDeleteForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:33:"administer openid connect clients";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:5:{s:9:"edit-form";s:64:"/admin/config/people/openid-connect/{openid_connect_client}/edit";s:11:"delete-form";s:66:"/admin/config/people/openid-connect/{openid_connect_client}/delete";s:6:"enable";s:66:"/admin/config/people/openid-connect/{openid_connect_client}/enable";s:7:"disable";s:67:"/admin/config/people/openid-connect/{openid_connect_client}/disable";s:10:"collection";s:35:"/admin/config/people/openid-connect";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:21:"OpenID Connect client";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:33:"config:openid_connect_client_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:6:"client";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"plugin";i:3;s:8:"settings";}s:21:" * mergedConfigExport";a:0:{}}',
  ])
  ->values([
    'collection' => 'system.schema',
    'name' => 'openid_connect',
    'value' => 'i:30001;',
  ])
  ->execute();
