<?php

namespace Drupal\unsdg_module\Controllers\Backoffice\ContactUsForms;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\FormServices\ContactUsFormService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class BackofficeContactUsFormController extends ControllerBase
{
    protected $contactUsFormService;

    public function __construct(ContactUsFormService $contactUsFormService)
    {
        $this->contactUsFormService = $contactUsFormService;
    }

    // unsdg_module.form_submissions:
    // path: '/api/backoffice/form-submissions'
    public function getFormSubmissions(Request $request)
    {
        $isAuthenticated = \Drupal::currentUser()->isAuthenticated();
        if ($isAuthenticated == false) {
            return new JsonResponse(
                "You are not authorized to view the submissions.",
                Response::HTTP_UNAUTHORIZED
            );
        }

        $pageNumber = $request->query->get('page_number', 1);
        $pageSize = $request->query->get('page_size', 10);

        if ($pageNumber < 1) {
            $pageNumber = 1;
        }

        $paginatedList = $this->contactUsFormService->getPaginated(
            $pageNumber,
            $pageSize
        );

        return new JsonResponse($paginatedList->toArray());
    }
}
