<?php

namespace Drupal\unsdg_module\Controllers\Public\ContactUsForms;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\FormServices\ContactUsFormService;
use Drupal\unsdg_module\Services\RecaptchaServices\RecaptchaService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Component\Serialization\Json;


class ContactUsFormController extends ControllerBase
{

    protected $contactUsFormService;
    protected $recaptchaService;


    public function __construct(ContactUsFormService $contactUsFormService, RecaptchaService $recaptchaService)
    {
        $this->contactUsFormService = $contactUsFormService;
        $this->recaptchaService = $recaptchaService;
    }

    public function submitContactForm(Request $request)
    {
        $post_data = $request->request->all();
        //$token = $request->query->get('recaptcha_token');
        $validated = $this->recaptchaService->validateRecaptchaV3('UNSDG Contact Us Form', $post_data, 0);
        if (!$validated) {
            return new JsonResponse(['status' => 'Recaptcha validation failed'], 400);
        }

        $response = $this->contactUsFormService->createNewContactFormSubmission($post_data);

        if ($response == true) {
            return new JsonResponse(['message' => 'Form submitted successfully'], 200);
        } else {
            return new JsonResponse(['message' => 'Failed to submit form'], 500);
        }
    }
}
