<?php

namespace Drupal\unsdg_module\Controllers\Public\Countries;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\CountryService;
use Symfony\Component\HttpFoundation\JsonResponse;

class CountryController extends ControllerBase
{

    protected $countryService;

    public function __construct(CountryService $countryService)
    {
        $this->countryService = $countryService;
    }

    public function listCountries()
    {
        $countries = $this->countryService->getCountries();

        $countryData = [];
        foreach ($countries as $country) {
            $countryData[] = [
                'id' => $country->id(),
                'title' => $country->field_country_name->value,
                'isoCode' => $country->field_country_abbreviation->value,
            ];
        }
        $statusCode = 200;
        return new JsonResponse($countryData, $statusCode);
    }
}
