<?php

namespace Drupal\unsdg_module\Controllers\Public\EpicUseCases;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\EpicUseCasesService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class EpicUseCasesController extends ControllerBase 
{
    protected $epicUseCasesService;

    public function __construct(EpicUseCasesService $epicUseCasesService)
    {
        $this->epicUseCasesService = $epicUseCasesService;
    }

    // endpoint: '/api/epic-use-cases'
    public function listEpicUseCases(Request $request)
    {
        $pageNumber = $request->query->get('page_number', 1);
        $pageSize = $request->query->get('page_size', 10);

        $pagiatedEpicUseCasesNodes = $this->epicUseCasesService->getPaginatedEpicUseCasesNodes($pageNumber, $pageSize);

        return new JsonResponse($pagiatedEpicUseCasesNodes->toArray());
    }
    

    // endpoint: '/api/epic-use-cases/related'
    public function getRelatedEpicUseCases(Request $request)
    {
        $epicUseCaseId = $request->query->get('epic_use_case_id', NULL);

        $relatedEpicUseCasesToRetrieveCount = $request->query->get('count', 3);

        $epic_use_cases_nodes = $this->epicUseCasesService->getRelatedEpicUseCasesNodes($epicUseCaseId, $relatedEpicUseCasesToRetrieveCount);

        
        $related_use_cases = $this->epicUseCasesService->getRelatedEpicUseCasesFromNodes($epic_use_cases_nodes, $epicUseCaseId);

        $response_data = [
            'data' => $related_use_cases
        ];
        $statusCode = 200;

        return new JsonResponse($response_data, $statusCode);
    }

}