<?php

namespace Drupal\unsdg_module\Controllers\Public\Goals;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\GoalService;
use Symfony\Component\HttpFoundation\JsonResponse;

class GoalController extends ControllerBase
{

    protected $goalService;

    public function __construct(GoalService $goalService)
    {
        $this->goalService = $goalService;
    }

    public function getGoals()
    {
        $goals = $this->goalService->getAllGoalsDetails();
        $statusCode = 200;
        return new JsonResponse($goals, $statusCode);
    }
}
