<?php

namespace Drupal\unsdg_module\Controllers\Public\Regions;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\RegionService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class RegionController extends ControllerBase
{

    protected $regionService;

    public function __construct(RegionService $regionService)
    {
        $this->regionService = $regionService;
    }

    public function listRegions(Request $request)
    {
        $region = $request->query->get('region');

        if($region){
            $regions = $this->regionService->getRegionByName($region);
        }

        else{
            $regions = $this->regionService->getAllRegions();
        }

        $formattedRegions = $regions;
        $statusCode = 200;
        return new JsonResponse($formattedRegions, $statusCode);
    }

 
    public function listRegionsCountriesAbbrieviations()
    {
        $regions = $this->regionService->getAllRegions();
        $formattedRegions = [];


            $formattedCountries = [];
            //return new JsonResponse($region, 200);
            foreach ($regions['countryGroups']['countries'] as $country) {
                $formattedCountries[] = $country['isoCode'];
            }

            $formattedRegions[] = [
                'id' => $regions['id'],
                'name' => $regions['name'],
                'countryAbbreviations' => $formattedCountries,
            ];

        $statusCode = 200;
        return new JsonResponse($formattedRegions, $statusCode);
    }
}
