<?php

namespace Drupal\unsdg_module\Controllers\Public\Resources;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\ResourceService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class ResourceController extends ControllerBase
{

    protected $resourceService;

    public function __construct(ResourceService $resourceService)
    {
        $this->resourceService = $resourceService;
    }

    //endpoint: /api/resources
    public function listResources(Request $request)
    {
        $resourceCategory = $request->query->get('resource_category', NULL);
        $pageNumber = $request->query->get('page_number', 1);
        $pageSize = $request->query->get('page_size', 10);

        $paginatedResourceNodes = $this->resourceService->getPaginatedResourceNodes($resourceCategory, $pageNumber, $pageSize);
        return new JsonResponse($paginatedResourceNodes->toArray());
    }

    //endpoint: /api/resources/related-resources
    public function getRelatedResources(Request $request)
    {
        $resourceId = $request->query->get('resource_id', NULL);
        $relatedResourceToRetrieveCount =  $request->query->get('count', 3);
        $resourceNodes = $this->resourceService->getRelatedResourceNodes($resourceId, $relatedResourceToRetrieveCount);
        $relatedResources = [];
        $relatedResources = $this->resourceService->getRelatedResourcesFromResourceNodes($resourceNodes, $resourceId);
        $responseData = [
            'data' => $relatedResources
        ];
        $statusCode = 200;
        return new JsonResponse($responseData, $statusCode);
    }

    //endpoint: /api/resources/tags
    public function getResourceTags()
    {
        $resourceTags = $this->resourceService->getResourcesTags();
        $statusCode = 200;
        return new JsonResponse($resourceTags, $statusCode);
    }
}
