<?php

namespace Drupal\unsdg_module\Controllers\Public\SdgDataPoints;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\GoalService;
use Drupal\unsdg_module\Services\SdgDataPointsServices\DataPointsService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class DataPointsController extends ControllerBase
{
    protected $dataPointsService;
    protected $goalService;

    public function __construct(DataPointsService $dataPointsService, GoalService $goalService)
    {
        $this->dataPointsService = $dataPointsService;
        $this->goalService = $goalService;
    }

    // SDG COUNTRY PROGRESS SECTION:
    //path: '/api/data-points/sdg-progress-tracker'
    public function getSdgCountryProgressData(Request $request)
    {
        $country = $request->query->get('country');
        $year = $this->dataPointsService->fetchLatestCountryGoalDataAvailabilityYear($country);
        $nationalDataAvailabilityIndicatorDetails = $this->dataPointsService->fetchCountryGoalProgressData($country, $year);
        $statusCode = 200;
        return new JsonResponse($nationalDataAvailabilityIndicatorDetails, $statusCode);
    }
}
