<?php

namespace Drupal\unsdg_module\Controllers\Public\SdgDataPoints;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\GoalService;
use Drupal\unsdg_module\Services\SdgDataPointsServices\DataPointsService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class NationalDataPointsController extends ControllerBase
{
    protected $dataPointsService;
    protected $goalService;

    public function __construct(DataPointsService $dataPointsService, GoalService $goalService)
    {
        $this->dataPointsService = $dataPointsService;
        $this->goalService = $goalService;
    }

    //path: '/api/data-points/national/overview/indicator-percentages'
    public function getNationalIndicatorPercentageDataByRegion(Request $request)
    {
        $area = $request->query->get('area');
        $goals = $this->goalService->getAllGoals();
        $nationalndicatorPercentageData = [];
        foreach ($goals as $goalItem) {
            $nationalndicatorPercentageData[] = $this->dataPointsService->fetchIndicatorPercentagesDataByAreaGoal($area, $goalItem->field_goal_number->value);
        }
        $summaryPercentages = $this->dataPointsService->getNationalAnalysisOverviewPerformanceSummaryData($nationalndicatorPercentageData);
        $response['summary_goals'] = $summaryPercentages;
        $response['data'] = $nationalndicatorPercentageData;
        $statusCode = 200;
        return new JsonResponse($response, $statusCode);
    }

    //path: '/api/data-points/national/overview/indicator-trends'
    public function getNationalIndicatorTrendByRegionAndGoalNumber(Request $request)
    {
        $area = $request->query->get('area');
        $targetNumber = $request->query->get('goal_number');
        $nationalndicatorTrendData = $this->dataPointsService->fetchIndicatorTrendsDataByAreaGoal($area, $targetNumber);
        $groupedData = $this->dataPointsService->groupIndicatorTrendsDataByTarget($nationalndicatorTrendData);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }

    //path: '/api/data-points/national/priorities'
    public function getNationalPrioritiesDataByRegionAndGoalNumber(Request $request)
    {
        $area = $request->query->get('area');
        $targetNumber = $request->query->get('goal_number');
        $nationalPrioritiesData = $this->dataPointsService->fetchNationalPrioritiesDataByAreaGoal($area, $targetNumber);
        $statusCode = 200;
        return new JsonResponse($nationalPrioritiesData, $statusCode);
    }

    //path: '/api/data-points/national/data-availability/summary'
    public function getNationalAnalysisDataAvailabilityOverviewSummaryData(Request $request)
    {
        $region = $request->query->get('region');
        $year = $this->dataPointsService->fetchLatestDataAvailabilityYear($region);
        $nationalDataAvailability = $this->dataPointsService->fetchNationalAnalysisDataAvailabilityOverviewData($region, $year);
        $groupedData = $this->dataPointsService->groupYearlyNationalAnalysisOverviewDataByIndicators($nationalDataAvailability);
        //$summaryData = $this->dataPointsService->calculateNationalDataAvailabilityPercentages($groupedData);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }

    //path: '/api/data-points/national/data-availability/goals'
    public function getNationalAnalysisDataAvailabilityOverviewGoalData(Request $request)
    {
        $region = $request->query->get('region');
        $year = $this->dataPointsService->fetchLatestDataAvailabilityYear($region);
        $nationalDataAvailability = $this->dataPointsService->fetchNationalAnalysisDataAvailabilityOverviewData($region, $year);
        $groupedData = $this->dataPointsService->groupNationalAnalysisOverviewDataByGoal($nationalDataAvailability);
        //$goalPercentageData = $this->dataPointsService->calculateNationalDataAvailabilityOverviewPercentages($groupedData);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }

    //path: '/api/data-points/national/data-availability/indicator-details'
    public function getNationalAnalysisDataAvailabilityIndicatorDetailsData(Request $request)
    {
        $country = $request->query->get('country');
        //$region =  $request->query->get('region');
        $goalNumber = $request->query->get('goal_number');
        $year = $this->dataPointsService->fetchLatestDataAvailabilityYear($country);
        $nationalDataAvailabilityIndicatorDetails = $this->dataPointsService->fetchNationalIndicatorDetailsDataAvailabilityByRegionGoal($country, $goalNumber, $year);
        $groupedData = $this->dataPointsService->groupNationalIndicatorDetailsDataAvailabilityByIndicator($nationalDataAvailabilityIndicatorDetails, $country, $year);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }
}
