<?php

namespace Drupal\unsdg_module\Controllers\Public\SdgDataPoints;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\ContentServices\GoalService;
use Drupal\unsdg_module\Services\ContentServices\RegionService;
use Drupal\unsdg_module\Services\SdgDataPointsServices\DataPointsService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class RegionalDataPointsController extends ControllerBase
{
    protected $dataPointsService;
    protected $goalService;
    protected $regionService;

    public function __construct(DataPointsService $dataPointsService, GoalService $goalService, RegionService $regionService)
    {
        $this->dataPointsService = $dataPointsService;
        $this->goalService = $goalService;
        $this->regionService = $regionService;
    }

    //path: '/api/data-points/regional/dashboard'
    public function getRegionalAnalysisDashboardData(Request $request)
    {
        $region = $request->query->get('region');
        $regionalDashboardData = $this->dataPointsService->fetchRegionalAnalysisDashboardData($region);
        $statusCode = 200;
        return new JsonResponse($regionalDashboardData, $statusCode);
    }

    //path: '/api/data-points/regional/dashboard-detail-chart'
    public function getRegionalAnalysisDashboardDetailChartData(Request $request)
    {
        $goalNumber = $request->query->get('goal_number');
        $region = $request->query->get('region');
        $year = $request->query->get('year');
        if (!$year) {
            $year = 2030;
        }
        $targetIndicatorData = $this->dataPointsService->getTargetIndicatorDashboardDetailData($goalNumber, $region, $year);
        $statusCode = 200;
        return new JsonResponse($targetIndicatorData, $statusCode);
    }

    //path: '/api/data-points/regional/snapshot/goals'
    public function getCurrentYearRegionalAnalysisGoalSnapshotData(Request $request)
    {
        //$goal = $request->query->get('goal_number');
        $region = $request->query->get('region');
        $goalSnapshotData = $this->dataPointsService->getAllGoalData($region);
        $statusCode = 200;
        return new JsonResponse($goalSnapshotData, $statusCode);
    }

    //path: '/api/data-points/regional/snapshot-chart'
    public function getCurrentYearRegionalAnalysisSnapshotData(Request $request)
    {
        $region = $request->query->get('region');
        $goal = $request->query->get('goal_number');
        $regionalSnapshotData = $this->dataPointsService->fetchLatestRegionalAnalysisSnapshotChartData($region, $goal);
        $statusCode = 200;
        return new JsonResponse($regionalSnapshotData, $statusCode);
    }

    //path: '/api/data-points/regional/data-availability/years'
    public function getRegionalAnalysisDataAvailabilityDataOverTime(Request $request)
    {
        $region = $request->query->get('region');
        $year = $request->query->get('year');
        $regionalDataAvailabilityData = $this->dataPointsService->fetchRegionalDataAvailabilityByRegion($region, $year);
        $groupedData = $this->dataPointsService->groupRegionalDataAvailabilityByYear($regionalDataAvailabilityData);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }

    //path: '/api/data-points/regional/data-availability/countries'
    public function getRegionalAnalysisDataAvailabilityCountriesAndTerritoriesDataOverTime(Request $request)
    {
        $region = $request->query->get('region');
        //$regionalDataAvailabilityData = $this->dataPointsService->calculateRegionalDataAvailabilityByRegionCountryGroups($region);
        $regionalDataAvailabilityData = $this->dataPointsService->fetchLatestRegionalDataAvailabilityByRegionCountry($region);
        //$upload = $this->dataPointsService->updateCountryDataAvailabilityStatistics($regionalDataAvailabilityData);
        $statusCode = 200;
        return new JsonResponse($regionalDataAvailabilityData, $statusCode);
    }

    //path: '/api/data-points/regional/data-availability/goals'
    public function getRegionalAnalysisDataAvailabilityOverviewData(Request $request)
    {
        $region = $request->query->get('region');
        $year = $this->dataPointsService->fetchLatestDataAvailabilityYear($region);
        $regionalDataAvailabilityData = $this->dataPointsService->fetchRegionalDataAvailabilityByRegion($region, $year);
        $groupedData = $this->dataPointsService->groupRegionalDataAvailabilityByGoal($regionalDataAvailabilityData);
        //$goalPercentageData = $this->dataPointsService->calculateAvailabilityPercentages($groupedData);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }

    //path: '/api/data-points/regional/data-availability/indicator-details'
    public function getRegionalAnalysisDataAvailabilityIndicatorDetailsData(Request $request)
    {
        $region = $request->query->get('region');
        $goal = $request->query->get('goal_number');
        $countryGroupAbbreviation = $this->regionService->getCountryGroupAbbreviationByCountryGroupName($region);
        $year = $this->dataPointsService->fetchLatestDataAvailabilityYear($countryGroupAbbreviation);
        $dataPoints = $this->dataPointsService->fetchRegionalIndicatorDetailsDataAvailabilityByRegionGoal($region, $goal, $year);
        if ($dataPoints === null) {
            return new JsonResponse('Region not found', 404);
        }
        //return new JsonResponse($dataPoints, 200);
        $groupedData = $this->dataPointsService->groupRegionalIndicatorDetailsDataAvailabilityByIndicator($dataPoints);
        $statusCode = 200;
        return new JsonResponse($groupedData, $statusCode);
    }


}
