<?php

namespace Drupal\unsdg_module\Controllers\Public\Validations;

use Drupal\Core\Controller\ControllerBase;
use Drupal\unsdg_module\Services\RecaptchaServices\RecaptchaService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Component\Serialization\Json;


class RecaptchaController extends ControllerBase
{

    protected $recaptchaService;

    public function __construct(RecaptchaService $recaptchaService)
    {
        $this->recaptchaService = $recaptchaService;
    }

    //endpoint: api/recaptcha/validate
    public function validateRecaptchaV3(Request $request)
    {
        $post_data = $request->request->all();
        $form_name = $request->query->get('form_name');
        $threshold_val = $request->query->get('threshold_val', 0);

        $validated = $this->recaptchaService->validateRecaptchaV3($form_name, $post_data, $threshold_val);
        if ($validated) {
            return new JsonResponse(['status' => 'success'], 200);
        } else {
            return new JsonResponse(['status' => 'fail'], 400);
        }
    }
}
