<?php

namespace Drupal\unsdg_module\Models;

class PaginatedList
{
    use CastableToArray;

    private array $items;
    private int $currentPageNumber;
    private int $pageSize;
    private int $count;
    private int $totalPages;

    public function __construct(array $items, int $currentPageNumber, int $pageSize, int $count)
    {
        $this->items = $items;
        $this->currentPageNumber = $currentPageNumber;
        $this->pageSize = $pageSize;
        $this->count = $count;
        $this->totalPages = ceil($count/$pageSize);
    }

}

trait CastableToArray
{
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}