<?php

namespace Drupal\unsdg_module\Services\BackofficeServices;

use Drupal\Core\Entity\EntityTypeManagerInterface;

class BackofficeService
{
    protected $entityTypeManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager)
    {
        $this->entityTypeManager = $entityTypeManager;
    }

    public function verifyLogin()
    {
        // Trigger entity query on the nodes
        $query = \Drupal::entityQuery('node');
        $query->accessCheck(FALSE) //Set access check to false or true where necessary.
            ->condition('type', 'country'); //Retrieve content by "type" whose machine name is "country".
        $nids = $query->execute(); //Execute the query to retrieve the node ids.
        $nodes = \Drupal::entityTypeManager()->getStorage('node')->loadMultiple($nids); //Retrieve the content of the nodes based on the ids supplied to it.
        if ($nodes) {
            return $nodes;
        } else {
            return [];
        }
    }
}
