<?php

namespace Drupal\unsdg_module\Services\ContentServices;

use Drupal\Core\Entity\EntityTypeManagerInterface;

class CountryService
{
    protected $entityTypeManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager)
    {
        $this->entityTypeManager = $entityTypeManager;
    }

    public function getCountries()
    {
        $nodeStorage = $this->entityTypeManager->getStorage('node');

        $ids = $nodeStorage->getQuery()
            ->condition('type', 'country')
            ->sort('field_country_name', 'ASC')
            ->accessCheck(false)
            ->execute();

        $countries = $nodeStorage->loadMultiple($ids);
        return $countries;
    }
}
