<?php

namespace Drupal\unsdg_module\Services\ContentServices;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\unsdg_module\Models\PaginatedList;
use Drupal\Core\Url;
use Drupal\node\Entity\Node;

class EpicUseCasesService
{
    protected $entityTypeManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager)
    {
        $this->entityTypeManager = $entityTypeManager;
    }

    public function getPaginatedEpicUseCasesNodes($pageNumber, $pageSize): PaginatedList
    {
        $nodeStorage = $this->entityTypeManager->getStorage('node');
        $query = $nodeStorage
            ->getQuery()
            ->condition('type', 'epic_use_case')
            ->accessCheck(true);

        $countQuery = clone $query;
        $count = $countQuery->count()->execute();

        $offset = ($pageNumber - 1) * $pageSize;
        $query->range($offset, $pageSize);
        $nodeIds = $query->execute();

        $nodes = [];

        foreach ($nodeIds as $nid) {
            $node = $nodeStorage->load($nid);
            if (
                isset($node->field_image)
                && $node->field_image->isEmpty() == false
            ) {
                $file_entity = $node->field_image->entity;

                if ($file_entity) {
                    $file_uri = $node->field_image->entity->uri->value;
                    $url = \Drupal::service('file_url_generator')->generateString($file_uri);
                    $node->image_url = $url;
                }
            }
            $url_object = Url::fromRoute('entity.node.canonical', ['node' => $node->id()]);
            $url = $url_object->toString();
            $node->url = $url;
            $nodes[] = $node;
        }

        foreach ($nodes as $epic_use_case) {

            $epicUseCases_data[] = [
                'id' => $epic_use_case->id(),
                'title' => $epic_use_case->label(),
                'content' => $epic_use_case->field_use_case_content->value,
                'image' => $epic_use_case->image_url,
                'url' => $epic_use_case->url
            ];
        }

        return new PaginatedList($epicUseCases_data, $pageNumber, $pageSize, $count);
    }

    public function getEpicUseCaseById($epicUseCaseId)
    {
        $epic_use_case = Node::load($epicUseCaseId);

        if ($epic_use_case->hasField('field_image') && !$epic_use_case->Get('field_image')->isEmpty())
        {
            $file_entity = $epic_use_case->entity->uri->value;
            if ($file_entity)
            {
                $file_uri = $epic_use_case->field_image->entity->uri->value;
                $url = \Drupal::service('file_url_generator')->generateString($file_uri);
                $epic_use_case->image_url = $url;
            }
        }

        $url_object = Url::fromRoute('entity.node.canonical', ['node' => $epic_use_case->id()]);
        $url = $url_object->toString();

        $epic_use_case->url = $url;

        $epicUseCaseResult[] = [
            'id' => $epic_use_case->id(),
            'title' => $epic_use_case->label(),
            'content' => $epic_use_case->field_use_case_content->value,
            'image' => $epic_use_case->image_url,
            'url' => $epic_use_case->url
        ];

        return $epicUseCaseResult;
    }

    public function getRelatedEpicUseCasesNodes($epicUseCaseId, $relatedCount = 3)
    {
        $query = $this->entityTypeManager->getStorage('node')->getQuery();

        $query->condition('type', 'epic_use_case')
            ->sort('created', 'DESC')
            ->range(0, $relatedCount);

        $query->accessCheck(FALSE);

        $epic_use_case = $this->getEpicUseCaseById($epicUseCaseId);

        $nids = $query->execute();
        $nodes = [];

        foreach ($nids as $nid)
        {
            $node = Node::load($nid);

            if ($node->hasField('field_image') && !$node->get('field_image')->isEmpty())
            {
                $file_entity = $node->field_image->entity;
                
                if ($file_entity)
                {
                    $file_uri = $node->field_image->entity->uri->value;
                    $url = \Drupal::service('file_url_generator')->generateString($file_uri);
                    $node->image_url = $url;
                }
            }

            $url_object = Url::fromRoute('entity.node.canonical', ['node' => $node->id()]);
            $url = $url_object->toString();
            $node->url = $url;
            $nodes[] = $node;
        }
        
        return $nodes;
    }

    public function getRelatedEpicUseCasesFromNodes($epicUseCasesNodes, $epicUseCaseId)
    {
        $epic_use_cases_data = [];
        
        foreach ($epicUseCasesNodes as $epic_use_case)
        {

            // skip the epic use case if its id matches $epicUseCaseId
            if ($epic_use_case->id() == $epicUseCaseId) {
                continue;
            }

            $epic_use_cases_data[] = [
                'id' => $epic_use_case->id(),
                'title' => $epic_use_case->label(),
                'image' => $epic_use_case->image_url,
                'url' =>  $epic_use_case->url
            ];
        }

        return $epic_use_cases_data;
    }

}