<?php

namespace Drupal\unsdg_module\Services\ContentServices;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\node\Entity\Node;

class GoalService
{
    protected $entityTypeManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager)
    {
        $this->entityTypeManager = $entityTypeManager;
    }

    public function getAllGoals()
    {
        $goals = [];
        $query = $this->entityTypeManager->getStorage('node')->getQuery();
        $query->accessCheck(FALSE)
            ->condition('type', 'sdg_goal');
        $nids = $query->execute();
        $goals = $this->entityTypeManager->getStorage('node')->loadMultiple($nids);
        return $goals;
    }

    public function getGoalByGoalNumber($goalNumber)
    {
        $query = $this->entityTypeManager->getStorage('node')->getQuery();
        $query->accessCheck(FALSE)
            ->condition('type', 'sdg_goal')
            ->condition('field_goal_number', $goalNumber);
        $nids = $query->execute();
        $nid = reset($nids);
        if ($nid) {
            $node = Node::load($nid);
            if ($node) {
                if ($node->hasField('field_image') && !$node->get('field_image')->isEmpty()) {
                    $file_entity = $node->field_image->entity;
                    if($file_entity){
                        $file_uri = $node->field_image->entity->uri->value;
                        $url = \Drupal::service('file_url_generator')->generateString($file_uri);
                        $node->image_url = $url;
                    }
                }
                $node->goal_name = $node->label();
                return $node;
            }
        }
        return $node;
    }

    //this collates all the details in the goal node (especially for the image url)
    public function getGoalDetailsByGoalNode($node)
    {
        //$node = Node::load($nodeId);
        if ($node) {
            if ($node->hasField('field_image') && !$node->get('field_image')->isEmpty()) {
                $file_entity = $node->field_image->entity;
                if ($file_entity) {
                    $file_uri = $node->field_image->entity->uri->value;
                    $url = \Drupal::service('file_url_generator')->generateString($file_uri);
                    $node->image_url = $url;
                }
            }
            $node->goal_name = $node->label();
            $node->goal_number = $node->field_goal_number->value;
        }
        return $node;
    }

    public function getAllGoalsDetails()
    {
        $goals = [];
        $query = $this->entityTypeManager->getStorage('node')->getQuery();
        $query->accessCheck(FALSE)
            ->condition('type', 'sdg_goal');
        $nids = $query->execute();
        foreach ($nids as $nid) {
            if ($nid) {
                $node = Node::load($nid);
                if ($node) {
                    if ($node->hasField('field_image') && !$node->get('field_image')->isEmpty()) {
                        $file_entity = $node->field_image->entity;
                        if ($file_entity) {
                            $file_uri = $node->field_image->entity->uri->value;
                            $url = \Drupal::service('file_url_generator')->generateString($file_uri);
                            $node->image_url = $url;
                        }
                    }
                    $node->goal_name = $node->label();
                    $node->goal_number = $node->get('field_goal_number')->value;
                    $goals[] = [
                        'goal_name' => $node->goal_name,
                        'goal_number' => $node->goal_number,
                        'image_url' => isset($node->image_url) ? $node->image_url : null,
                    ];
                }
            }
        }
        return $goals;
    }
}
