<?php

namespace Drupal\unsdg_module\Services\ExcelServices\Interfaces;
use PhpOffice\PhpSpreadsheet\Reader\IReadFilter;

class ChunkReadFilter implements IReadFilter
{
    private $startRow;
    private $endRow;

    /**
     * Set the rows that we want to read.
     *
     * @param int $startRow
     * @param int $chunkSize
     */
    public function setRows($startRow, $chunkSize)
    {
        $this->startRow = $startRow;
        $this->endRow = $startRow + $chunkSize -1;
    }

    /**
     * Read filter to load rows within the specified range.
     *
     * @param string $column
     * @param int $row
     * @param int|null $worksheetName
     * @return bool
     */
    public function readCell(string $columnAddress, int $row, string $worksheetName = ''): bool
    {
        return $row >= $this->startRow && $row <= $this->endRow;
    }
}


/**  Define a Read Filter class implementing \PhpOffice\PhpSpreadsheet\Reader\IReadFilter  */
// class ChunkReadFilter implements \PhpOffice\PhpSpreadsheet\Reader\IReadFilter
// {
//     private $startRow = 0;
//     private $endRow   = 0;

//     /**  Set the list of rows that we want to read  */
//     public function setRows($startRow, $chunkSize) {
//         $this->startRow = $startRow;
//         $this->endRow   = $startRow + $chunkSize;
//     }

//     public function readCell(string $columnAddress, int $row, string $worksheetName = ''): bool
//     {
//         return $row >= $this->startRow && $row <= $this->endRow;
//     }
// }
