<?php

namespace Drupal\unsdg_module\Services\FormServices;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\Query\QueryFactoryInterface;
use Drupal\Core\Database\Database;
use Drupal\unsdg_module\Models\PaginatedList;

class ContactUsFormService
{
    protected $entityTypeManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager)
    {
        $this->entityTypeManager = $entityTypeManager;
    }

    public function createNewContactFormSubmission(array $formData)
    {
        $database = Database::getConnection('default', 'custom');

        $data = [
            'purpose_of_enquiry' => $formData['purpose_of_enquiry'],
            'organisation' => $formData['organisation'],
            'email' => $formData['email'],
            'name' => $formData['name'],
            'organisation_name' => $formData['organisation_name'],
            'suggestion' => $formData['suggestion'],
            //'page_id' => $formData['page_id'],
            'page_url' => $formData['page_url'],
            //'page_name' => $formData['page_name'],
        ];
        $query = $database->insert('contact_us_form')
        ->fields($data)
        ->execute();
        if ($query !== FALSE) {
            \Drupal::logger('unsdg_module')->notice('Insert succeeded.');
            return true;
        } else {
            \Drupal::logger('unsdg_module')->error('Insert failed.');
            return false;
        }
    }

    public function getPaginated($pageNumber, $pageSize): PaginatedList
    {
        $database = Database::getConnection('default', 'custom');
        $offset = ($pageNumber - 1) * $pageSize;
        $query = $database
            ->select('contact_us_form', 'c')
            ->fields('c');

        $count = $query
            ->countQuery()
            ->execute()
            ->fetchField();
        
        $items = $query
            ->orderBy('c.submission_date', 'DESC')
            ->range($offset, $pageSize)
            ->execute()
            ->fetchAll();

        return new PaginatedList($items, $pageNumber, $pageSize, $count);
    }

}

