<?php

namespace Drupal\unsdg_module\Services\RecaptchaServices;

use Drupal\Core\Entity\EntityTypeManagerInterface;

class RecaptchaService
{
    protected $entityTypeManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager)
    {
        $this->entityTypeManager = $entityTypeManager;
    }

    public function validateRecaptchaV3($form_name, $token, $threshold_val = 0)
    {
        $validated = false;
        try {
            if (isset($token)) {

                $captcha = $_POST['g-recaptcha-response'];
                $secret_key = \Drupal::config('system.site')->get('reCAPTCHA_v3_secret_key');
                $threshold_val = ($threshold_val == 1) ? \Drupal::config('system.site')->get('reCAPTCHA_v3_threshold_val', '') : floatval($threshold_val);

                $captcharesponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=' . $secret_key . '&response=' . $captcha . '&remoteip=' . $_SERVER['REMOTE_ADDR']);
                $response = json_decode($captcharesponse);
                $success = $response->success;
                $score = $response->score;

                if ($success == true && $score >= $threshold_val) {
                    $validated = true;
                } else {
                    \Drupal::logger('unsdg_module')->error('Fail to validate captcha | Captcha response - %success | Captcha Score - %score | Post Data = %body | Form Name = %form_name', array('%score' => $score, '%success' => $captcharesponse, '%body' => json_encode($token), '%form_name' =>$form_name));
                }
            } else {
                \Drupal::logger('unsdg_module')->error('Empty Captcha response | Post Data = %body | Form Name = %form_name', array('%body' => json_encode($token), '%form_name' => $form_name));

            }
        } catch (\Exception $ex) {
            \Drupal::logger('unsdg_module')->error('Captcha exception | Post Data = %body | Form Name = %form_name | error = %error', array('%body' => json_encode($token), '%form_name' => $form_name, '%error' => $ex->getMessage()));
        }
        return $validated;
    }
}
