<?php

namespace Drupal\unsdg_module\Services\ViteServices;

use Drupal\unsdg_module\Models\ViteChunk;
use Drupal\Core\Site\Settings;

class ViteManifestService {
    public $manifestPath;

    public function getViteChunks() {
        if (!file_exists($this->manifestPath)) return [];

        $json = file_get_contents($this->manifestPath); // Invoke the method using $this
        $viteChunks = [];
        if (is_null($json) || empty($json)) {
            return $viteChunks;
        }

        $viteChunksArray = json_decode($json, true);
        foreach ($viteChunksArray as $key => $data) {
            $src = isset($data['src']) ? $data['src'] : [];
            $isEntry = isset($data['isEntry']) ? $data['isEntry'] : false;
            $isDynamicEntry = isset($data['isDynamicEntry']) ? $data['isDynamicEntry'] : false;
            $imports = isset($data['imports']) ? $data['imports'] : [];
            $css = isset($data['css']) ? $data['css'] : [];

            $viteChunk = new ViteChunk(
                $data['file'],
                $src,
                $isEntry,
                $isDynamicEntry,
                $imports,
                $css
            );
            $viteChunks[$key] = $viteChunk;
        }
        return $viteChunks; //returns array of vitechunks.
    }

    public function __construct(Settings $settings) {
        $viteBasePath = $settings->get('vite_base_path');
        $this->manifestPath =  $_SERVER['DOCUMENT_ROOT'] . $viteBasePath . '/.vite/manifest.json';
    }
}
