import {
  dispatch_default,
  interval_default,
  now,
  timeout_default,
  timer
} from "./chunk-AXVSVYA2.js";
import {
  Adder,
  InternMap,
  arrayOfIndices,
  ascending,
  bisect_default,
  bisector,
  clamp,
  clean,
  cloneDeep,
  css,
  extent,
  filterDataByRange,
  flatten,
  getBoolean,
  getExtent,
  getMax,
  getMin,
  getNearest,
  getNumber,
  getStackedData,
  getStackedExtent,
  getStackedValues,
  getString,
  getValue,
  group,
  groupBy,
  index,
  injectGlobal,
  isArray,
  isEmpty,
  isEqual,
  isFunction,
  isNil,
  isNumber,
  isNumberWithinRange,
  isObject,
  isPlainObject,
  isString,
  isUndefined,
  max,
  mean,
  merge,
  merge2,
  min,
  quantileSorted,
  range,
  shallowDiff,
  sortBy,
  sum,
  throttle,
  tickIncrement,
  tickStep,
  ticks,
  unique,
  without
} from "./chunk-MKT7XV5Q.js";
import {
  __awaiter
} from "./chunk-2SSAR4O6.js";
import {
  __commonJS,
  __export,
  __toESM
} from "./chunk-PR4QN5HX.js";

// node_modules/parse-unit/index.js
var require_parse_unit = __commonJS({
  "node_modules/parse-unit/index.js"(exports, module) {
    module.exports = function parseUnit2(str, out) {
      if (!out)
        out = [0, ""];
      str = String(str);
      var num = parseFloat(str, 10);
      out[0] = num;
      out[1] = str.match(/[\d.\-\+]*\s*(.*)/)[1] || "";
      return out;
    };
  }
});

// node_modules/to-px/browser.js
var require_browser = __commonJS({
  "node_modules/to-px/browser.js"(exports, module) {
    "use strict";
    var parseUnit2 = require_parse_unit();
    module.exports = toPX;
    var PIXELS_PER_INCH = getSizeBrutal("in", document.body);
    function getPropertyInPX(element, prop) {
      var parts = parseUnit2(getComputedStyle(element).getPropertyValue(prop));
      return parts[0] * toPX(parts[1], element);
    }
    function getSizeBrutal(unit2, element) {
      var testDIV = document.createElement("div");
      testDIV.style["height"] = "128" + unit2;
      element.appendChild(testDIV);
      var size2 = getPropertyInPX(testDIV, "height") / 128;
      element.removeChild(testDIV);
      return size2;
    }
    function toPX(str, element) {
      if (!str) return null;
      element = element || document.body;
      str = (str + "" || "px").trim().toLowerCase();
      if (element === window || element === document) {
        element = document.body;
      }
      switch (str) {
        case "%":
          return element.clientHeight / 100;
        case "ch":
        case "ex":
          return getSizeBrutal(str, element);
        case "em":
          return getPropertyInPX(element, "font-size");
        case "rem":
          return getPropertyInPX(document.body, "font-size");
        case "vw":
          return window.innerWidth / 100;
        case "vh":
          return window.innerHeight / 100;
        case "vmin":
          return Math.min(window.innerWidth, window.innerHeight) / 100;
        case "vmax":
          return Math.max(window.innerWidth, window.innerHeight) / 100;
        case "in":
          return PIXELS_PER_INCH;
        case "cm":
          return PIXELS_PER_INCH / 2.54;
        case "mm":
          return PIXELS_PER_INCH / 25.4;
        case "pt":
          return PIXELS_PER_INCH / 72;
        case "pc":
          return PIXELS_PER_INCH / 6;
        case "px":
          return 1;
      }
      var parts = parseUnit2(str);
      if (!isNaN(parts[0]) && parts[1]) {
        var px = toPX(parts[1], element);
        return typeof px === "number" ? parts[0] * px : null;
      }
      return null;
    }
  }
});

// node_modules/striptags/src/striptags.js
var require_striptags = __commonJS({
  "node_modules/striptags/src/striptags.js"(exports, module) {
    "use strict";
    (function(global2) {
      if (typeof Symbol4 !== "function") {
        var Symbol4 = function(name2) {
          return name2;
        };
        Symbol4.nonNative = true;
      }
      const STATE_PLAINTEXT = Symbol4("plaintext");
      const STATE_HTML = Symbol4("html");
      const STATE_COMMENT = Symbol4("comment");
      const ALLOWED_TAGS_REGEX = /<(\w*)>/g;
      const NORMALIZE_TAG_REGEX = /<\/?([^\s\/>]+)/;
      function striptags3(html, allowable_tags, tag_replacement) {
        html = html || "";
        allowable_tags = allowable_tags || [];
        tag_replacement = tag_replacement || "";
        let context = init_context(allowable_tags, tag_replacement);
        return striptags_internal(html, context);
      }
      function init_striptags_stream(allowable_tags, tag_replacement) {
        allowable_tags = allowable_tags || [];
        tag_replacement = tag_replacement || "";
        let context = init_context(allowable_tags, tag_replacement);
        return function striptags_stream(html) {
          return striptags_internal(html || "", context);
        };
      }
      striptags3.init_streaming_mode = init_striptags_stream;
      function init_context(allowable_tags, tag_replacement) {
        allowable_tags = parse_allowable_tags(allowable_tags);
        return {
          allowable_tags,
          tag_replacement,
          state: STATE_PLAINTEXT,
          tag_buffer: "",
          depth: 0,
          in_quote_char: ""
        };
      }
      function striptags_internal(html, context) {
        if (typeof html != "string") {
          throw new TypeError("'html' parameter must be a string");
        }
        let allowable_tags = context.allowable_tags;
        let tag_replacement = context.tag_replacement;
        let state = context.state;
        let tag_buffer = context.tag_buffer;
        let depth = context.depth;
        let in_quote_char = context.in_quote_char;
        let output = "";
        for (let idx = 0, length = html.length; idx < length; idx++) {
          let char = html[idx];
          if (state === STATE_PLAINTEXT) {
            switch (char) {
              case "<":
                state = STATE_HTML;
                tag_buffer += char;
                break;
              default:
                output += char;
                break;
            }
          } else if (state === STATE_HTML) {
            switch (char) {
              case "<":
                if (in_quote_char) {
                  break;
                }
                depth++;
                break;
              case ">":
                if (in_quote_char) {
                  break;
                }
                if (depth) {
                  depth--;
                  break;
                }
                in_quote_char = "";
                state = STATE_PLAINTEXT;
                tag_buffer += ">";
                if (allowable_tags.has(normalize_tag(tag_buffer))) {
                  output += tag_buffer;
                } else {
                  output += tag_replacement;
                }
                tag_buffer = "";
                break;
              case '"':
              case "'":
                if (char === in_quote_char) {
                  in_quote_char = "";
                } else {
                  in_quote_char = in_quote_char || char;
                }
                tag_buffer += char;
                break;
              case "-":
                if (tag_buffer === "<!-") {
                  state = STATE_COMMENT;
                }
                tag_buffer += char;
                break;
              case " ":
              case "\n":
                if (tag_buffer === "<") {
                  state = STATE_PLAINTEXT;
                  output += "< ";
                  tag_buffer = "";
                  break;
                }
                tag_buffer += char;
                break;
              default:
                tag_buffer += char;
                break;
            }
          } else if (state === STATE_COMMENT) {
            switch (char) {
              case ">":
                if (tag_buffer.slice(-2) == "--") {
                  state = STATE_PLAINTEXT;
                }
                tag_buffer = "";
                break;
              default:
                tag_buffer += char;
                break;
            }
          }
        }
        context.state = state;
        context.tag_buffer = tag_buffer;
        context.depth = depth;
        context.in_quote_char = in_quote_char;
        return output;
      }
      function parse_allowable_tags(allowable_tags) {
        let tag_set = /* @__PURE__ */ new Set();
        if (typeof allowable_tags === "string") {
          let match;
          while (match = ALLOWED_TAGS_REGEX.exec(allowable_tags)) {
            tag_set.add(match[1]);
          }
        } else if (!Symbol4.nonNative && typeof allowable_tags[Symbol4.iterator] === "function") {
          tag_set = new Set(allowable_tags);
        } else if (typeof allowable_tags.forEach === "function") {
          allowable_tags.forEach(tag_set.add, tag_set);
        }
        return tag_set;
      }
      function normalize_tag(tag_buffer) {
        let match = NORMALIZE_TAG_REGEX.exec(tag_buffer);
        return match ? match[1].toLowerCase() : null;
      }
      if (typeof define === "function" && define.amd) {
        define(function module_factory() {
          return striptags3;
        });
      } else if (typeof module === "object" && module.exports) {
        module.exports = striptags3;
      } else {
        global2.striptags = striptags3;
      }
    })(exports);
  }
});

// node_modules/d3-selection/src/namespaces.js
var xhtml = "http://www.w3.org/1999/xhtml";
var namespaces_default = {
  svg: "http://www.w3.org/2000/svg",
  xhtml,
  xlink: "http://www.w3.org/1999/xlink",
  xml: "http://www.w3.org/XML/1998/namespace",
  xmlns: "http://www.w3.org/2000/xmlns/"
};

// node_modules/d3-selection/src/namespace.js
function namespace_default(name2) {
  var prefix = name2 += "", i = prefix.indexOf(":");
  if (i >= 0 && (prefix = name2.slice(0, i)) !== "xmlns") name2 = name2.slice(i + 1);
  return namespaces_default.hasOwnProperty(prefix) ? { space: namespaces_default[prefix], local: name2 } : name2;
}

// node_modules/d3-selection/src/creator.js
function creatorInherit(name2) {
  return function() {
    var document2 = this.ownerDocument, uri = this.namespaceURI;
    return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name2) : document2.createElementNS(uri, name2);
  };
}
function creatorFixed(fullname) {
  return function() {
    return this.ownerDocument.createElementNS(fullname.space, fullname.local);
  };
}
function creator_default(name2) {
  var fullname = namespace_default(name2);
  return (fullname.local ? creatorFixed : creatorInherit)(fullname);
}

// node_modules/d3-selection/src/selector.js
function none() {
}
function selector_default(selector) {
  return selector == null ? none : function() {
    return this.querySelector(selector);
  };
}

// node_modules/d3-selection/src/selection/select.js
function select_default(select2) {
  if (typeof select2 !== "function") select2 = selector_default(select2);
  for (var groups2 = this._groups, m2 = groups2.length, subgroups = new Array(m2), j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, subgroup = subgroups[j] = new Array(n), node4, subnode, i = 0; i < n; ++i) {
      if ((node4 = group3[i]) && (subnode = select2.call(node4, node4.__data__, i, group3))) {
        if ("__data__" in node4) subnode.__data__ = node4.__data__;
        subgroup[i] = subnode;
      }
    }
  }
  return new Selection(subgroups, this._parents);
}

// node_modules/d3-selection/src/array.js
function array(x3) {
  return x3 == null ? [] : Array.isArray(x3) ? x3 : Array.from(x3);
}

// node_modules/d3-selection/src/selectorAll.js
function empty() {
  return [];
}
function selectorAll_default(selector) {
  return selector == null ? empty : function() {
    return this.querySelectorAll(selector);
  };
}

// node_modules/d3-selection/src/selection/selectAll.js
function arrayAll(select2) {
  return function() {
    return array(select2.apply(this, arguments));
  };
}
function selectAll_default(select2) {
  if (typeof select2 === "function") select2 = arrayAll(select2);
  else select2 = selectorAll_default(select2);
  for (var groups2 = this._groups, m2 = groups2.length, subgroups = [], parents = [], j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, node4, i = 0; i < n; ++i) {
      if (node4 = group3[i]) {
        subgroups.push(select2.call(node4, node4.__data__, i, group3));
        parents.push(node4);
      }
    }
  }
  return new Selection(subgroups, parents);
}

// node_modules/d3-selection/src/matcher.js
function matcher_default(selector) {
  return function() {
    return this.matches(selector);
  };
}
function childMatcher(selector) {
  return function(node4) {
    return node4.matches(selector);
  };
}

// node_modules/d3-selection/src/selection/selectChild.js
var find = Array.prototype.find;
function childFind(match) {
  return function() {
    return find.call(this.children, match);
  };
}
function childFirst() {
  return this.firstElementChild;
}
function selectChild_default(match) {
  return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
}

// node_modules/d3-selection/src/selection/selectChildren.js
var filter = Array.prototype.filter;
function children() {
  return Array.from(this.children);
}
function childrenFilter(match) {
  return function() {
    return filter.call(this.children, match);
  };
}
function selectChildren_default(match) {
  return this.selectAll(match == null ? children : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
}

// node_modules/d3-selection/src/selection/filter.js
function filter_default(match) {
  if (typeof match !== "function") match = matcher_default(match);
  for (var groups2 = this._groups, m2 = groups2.length, subgroups = new Array(m2), j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, subgroup = subgroups[j] = [], node4, i = 0; i < n; ++i) {
      if ((node4 = group3[i]) && match.call(node4, node4.__data__, i, group3)) {
        subgroup.push(node4);
      }
    }
  }
  return new Selection(subgroups, this._parents);
}

// node_modules/d3-selection/src/selection/sparse.js
function sparse_default(update) {
  return new Array(update.length);
}

// node_modules/d3-selection/src/selection/enter.js
function enter_default() {
  return new Selection(this._enter || this._groups.map(sparse_default), this._parents);
}
function EnterNode(parent, datum2) {
  this.ownerDocument = parent.ownerDocument;
  this.namespaceURI = parent.namespaceURI;
  this._next = null;
  this._parent = parent;
  this.__data__ = datum2;
}
EnterNode.prototype = {
  constructor: EnterNode,
  appendChild: function(child) {
    return this._parent.insertBefore(child, this._next);
  },
  insertBefore: function(child, next) {
    return this._parent.insertBefore(child, next);
  },
  querySelector: function(selector) {
    return this._parent.querySelector(selector);
  },
  querySelectorAll: function(selector) {
    return this._parent.querySelectorAll(selector);
  }
};

// node_modules/d3-selection/src/constant.js
function constant_default(x3) {
  return function() {
    return x3;
  };
}

// node_modules/d3-selection/src/selection/data.js
function bindIndex(parent, group3, enter, update, exit, data) {
  var i = 0, node4, groupLength = group3.length, dataLength = data.length;
  for (; i < dataLength; ++i) {
    if (node4 = group3[i]) {
      node4.__data__ = data[i];
      update[i] = node4;
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (; i < groupLength; ++i) {
    if (node4 = group3[i]) {
      exit[i] = node4;
    }
  }
}
function bindKey(parent, group3, enter, update, exit, data, key) {
  var i, node4, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group3.length, dataLength = data.length, keyValues = new Array(groupLength), keyValue;
  for (i = 0; i < groupLength; ++i) {
    if (node4 = group3[i]) {
      keyValues[i] = keyValue = key.call(node4, node4.__data__, i, group3) + "";
      if (nodeByKeyValue.has(keyValue)) {
        exit[i] = node4;
      } else {
        nodeByKeyValue.set(keyValue, node4);
      }
    }
  }
  for (i = 0; i < dataLength; ++i) {
    keyValue = key.call(parent, data[i], i, data) + "";
    if (node4 = nodeByKeyValue.get(keyValue)) {
      update[i] = node4;
      node4.__data__ = data[i];
      nodeByKeyValue.delete(keyValue);
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (i = 0; i < groupLength; ++i) {
    if ((node4 = group3[i]) && nodeByKeyValue.get(keyValues[i]) === node4) {
      exit[i] = node4;
    }
  }
}
function datum(node4) {
  return node4.__data__;
}
function data_default(value2, key) {
  if (!arguments.length) return Array.from(this, datum);
  var bind = key ? bindKey : bindIndex, parents = this._parents, groups2 = this._groups;
  if (typeof value2 !== "function") value2 = constant_default(value2);
  for (var m2 = groups2.length, update = new Array(m2), enter = new Array(m2), exit = new Array(m2), j = 0; j < m2; ++j) {
    var parent = parents[j], group3 = groups2[j], groupLength = group3.length, data = arraylike(value2.call(parent, parent && parent.__data__, j, parents)), dataLength = data.length, enterGroup = enter[j] = new Array(dataLength), updateGroup = update[j] = new Array(dataLength), exitGroup = exit[j] = new Array(groupLength);
    bind(parent, group3, enterGroup, updateGroup, exitGroup, data, key);
    for (var i0 = 0, i1 = 0, previous, next; i0 < dataLength; ++i0) {
      if (previous = enterGroup[i0]) {
        if (i0 >= i1) i1 = i0 + 1;
        while (!(next = updateGroup[i1]) && ++i1 < dataLength) ;
        previous._next = next || null;
      }
    }
  }
  update = new Selection(update, parents);
  update._enter = enter;
  update._exit = exit;
  return update;
}
function arraylike(data) {
  return typeof data === "object" && "length" in data ? data : Array.from(data);
}

// node_modules/d3-selection/src/selection/exit.js
function exit_default() {
  return new Selection(this._exit || this._groups.map(sparse_default), this._parents);
}

// node_modules/d3-selection/src/selection/join.js
function join_default(onenter, onupdate, onexit) {
  var enter = this.enter(), update = this, exit = this.exit();
  if (typeof onenter === "function") {
    enter = onenter(enter);
    if (enter) enter = enter.selection();
  } else {
    enter = enter.append(onenter + "");
  }
  if (onupdate != null) {
    update = onupdate(update);
    if (update) update = update.selection();
  }
  if (onexit == null) exit.remove();
  else onexit(exit);
  return enter && update ? enter.merge(update).order() : update;
}

// node_modules/d3-selection/src/selection/merge.js
function merge_default(context) {
  var selection2 = context.selection ? context.selection() : context;
  for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m2 = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m2; ++j) {
    for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge4 = merges[j] = new Array(n), node4, i = 0; i < n; ++i) {
      if (node4 = group0[i] || group1[i]) {
        merge4[i] = node4;
      }
    }
  }
  for (; j < m0; ++j) {
    merges[j] = groups0[j];
  }
  return new Selection(merges, this._parents);
}

// node_modules/d3-selection/src/selection/order.js
function order_default() {
  for (var groups2 = this._groups, j = -1, m2 = groups2.length; ++j < m2; ) {
    for (var group3 = groups2[j], i = group3.length - 1, next = group3[i], node4; --i >= 0; ) {
      if (node4 = group3[i]) {
        if (next && node4.compareDocumentPosition(next) ^ 4) next.parentNode.insertBefore(node4, next);
        next = node4;
      }
    }
  }
  return this;
}

// node_modules/d3-selection/src/selection/sort.js
function sort_default(compare) {
  if (!compare) compare = ascending2;
  function compareNode(a4, b) {
    return a4 && b ? compare(a4.__data__, b.__data__) : !a4 - !b;
  }
  for (var groups2 = this._groups, m2 = groups2.length, sortgroups = new Array(m2), j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, sortgroup = sortgroups[j] = new Array(n), node4, i = 0; i < n; ++i) {
      if (node4 = group3[i]) {
        sortgroup[i] = node4;
      }
    }
    sortgroup.sort(compareNode);
  }
  return new Selection(sortgroups, this._parents).order();
}
function ascending2(a4, b) {
  return a4 < b ? -1 : a4 > b ? 1 : a4 >= b ? 0 : NaN;
}

// node_modules/d3-selection/src/selection/call.js
function call_default() {
  var callback = arguments[0];
  arguments[0] = this;
  callback.apply(null, arguments);
  return this;
}

// node_modules/d3-selection/src/selection/nodes.js
function nodes_default() {
  return Array.from(this);
}

// node_modules/d3-selection/src/selection/node.js
function node_default() {
  for (var groups2 = this._groups, j = 0, m2 = groups2.length; j < m2; ++j) {
    for (var group3 = groups2[j], i = 0, n = group3.length; i < n; ++i) {
      var node4 = group3[i];
      if (node4) return node4;
    }
  }
  return null;
}

// node_modules/d3-selection/src/selection/size.js
function size_default() {
  let size2 = 0;
  for (const node4 of this) ++size2;
  return size2;
}

// node_modules/d3-selection/src/selection/empty.js
function empty_default() {
  return !this.node();
}

// node_modules/d3-selection/src/selection/each.js
function each_default(callback) {
  for (var groups2 = this._groups, j = 0, m2 = groups2.length; j < m2; ++j) {
    for (var group3 = groups2[j], i = 0, n = group3.length, node4; i < n; ++i) {
      if (node4 = group3[i]) callback.call(node4, node4.__data__, i, group3);
    }
  }
  return this;
}

// node_modules/d3-selection/src/selection/attr.js
function attrRemove(name2) {
  return function() {
    this.removeAttribute(name2);
  };
}
function attrRemoveNS(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant(name2, value2) {
  return function() {
    this.setAttribute(name2, value2);
  };
}
function attrConstantNS(fullname, value2) {
  return function() {
    this.setAttributeNS(fullname.space, fullname.local, value2);
  };
}
function attrFunction(name2, value2) {
  return function() {
    var v = value2.apply(this, arguments);
    if (v == null) this.removeAttribute(name2);
    else this.setAttribute(name2, v);
  };
}
function attrFunctionNS(fullname, value2) {
  return function() {
    var v = value2.apply(this, arguments);
    if (v == null) this.removeAttributeNS(fullname.space, fullname.local);
    else this.setAttributeNS(fullname.space, fullname.local, v);
  };
}
function attr_default(name2, value2) {
  var fullname = namespace_default(name2);
  if (arguments.length < 2) {
    var node4 = this.node();
    return fullname.local ? node4.getAttributeNS(fullname.space, fullname.local) : node4.getAttribute(fullname);
  }
  return this.each((value2 == null ? fullname.local ? attrRemoveNS : attrRemove : typeof value2 === "function" ? fullname.local ? attrFunctionNS : attrFunction : fullname.local ? attrConstantNS : attrConstant)(fullname, value2));
}

// node_modules/d3-selection/src/window.js
function window_default(node4) {
  return node4.ownerDocument && node4.ownerDocument.defaultView || node4.document && node4 || node4.defaultView;
}

// node_modules/d3-selection/src/selection/style.js
function styleRemove(name2) {
  return function() {
    this.style.removeProperty(name2);
  };
}
function styleConstant(name2, value2, priority) {
  return function() {
    this.style.setProperty(name2, value2, priority);
  };
}
function styleFunction(name2, value2, priority) {
  return function() {
    var v = value2.apply(this, arguments);
    if (v == null) this.style.removeProperty(name2);
    else this.style.setProperty(name2, v, priority);
  };
}
function style_default(name2, value2, priority) {
  return arguments.length > 1 ? this.each((value2 == null ? styleRemove : typeof value2 === "function" ? styleFunction : styleConstant)(name2, value2, priority == null ? "" : priority)) : styleValue(this.node(), name2);
}
function styleValue(node4, name2) {
  return node4.style.getPropertyValue(name2) || window_default(node4).getComputedStyle(node4, null).getPropertyValue(name2);
}

// node_modules/d3-selection/src/selection/property.js
function propertyRemove(name2) {
  return function() {
    delete this[name2];
  };
}
function propertyConstant(name2, value2) {
  return function() {
    this[name2] = value2;
  };
}
function propertyFunction(name2, value2) {
  return function() {
    var v = value2.apply(this, arguments);
    if (v == null) delete this[name2];
    else this[name2] = v;
  };
}
function property_default(name2, value2) {
  return arguments.length > 1 ? this.each((value2 == null ? propertyRemove : typeof value2 === "function" ? propertyFunction : propertyConstant)(name2, value2)) : this.node()[name2];
}

// node_modules/d3-selection/src/selection/classed.js
function classArray(string) {
  return string.trim().split(/^|\s+/);
}
function classList(node4) {
  return node4.classList || new ClassList(node4);
}
function ClassList(node4) {
  this._node = node4;
  this._names = classArray(node4.getAttribute("class") || "");
}
ClassList.prototype = {
  add: function(name2) {
    var i = this._names.indexOf(name2);
    if (i < 0) {
      this._names.push(name2);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  remove: function(name2) {
    var i = this._names.indexOf(name2);
    if (i >= 0) {
      this._names.splice(i, 1);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  contains: function(name2) {
    return this._names.indexOf(name2) >= 0;
  }
};
function classedAdd(node4, names) {
  var list = classList(node4), i = -1, n = names.length;
  while (++i < n) list.add(names[i]);
}
function classedRemove(node4, names) {
  var list = classList(node4), i = -1, n = names.length;
  while (++i < n) list.remove(names[i]);
}
function classedTrue(names) {
  return function() {
    classedAdd(this, names);
  };
}
function classedFalse(names) {
  return function() {
    classedRemove(this, names);
  };
}
function classedFunction(names, value2) {
  return function() {
    (value2.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
  };
}
function classed_default(name2, value2) {
  var names = classArray(name2 + "");
  if (arguments.length < 2) {
    var list = classList(this.node()), i = -1, n = names.length;
    while (++i < n) if (!list.contains(names[i])) return false;
    return true;
  }
  return this.each((typeof value2 === "function" ? classedFunction : value2 ? classedTrue : classedFalse)(names, value2));
}

// node_modules/d3-selection/src/selection/text.js
function textRemove() {
  this.textContent = "";
}
function textConstant(value2) {
  return function() {
    this.textContent = value2;
  };
}
function textFunction(value2) {
  return function() {
    var v = value2.apply(this, arguments);
    this.textContent = v == null ? "" : v;
  };
}
function text_default(value2) {
  return arguments.length ? this.each(value2 == null ? textRemove : (typeof value2 === "function" ? textFunction : textConstant)(value2)) : this.node().textContent;
}

// node_modules/d3-selection/src/selection/html.js
function htmlRemove() {
  this.innerHTML = "";
}
function htmlConstant(value2) {
  return function() {
    this.innerHTML = value2;
  };
}
function htmlFunction(value2) {
  return function() {
    var v = value2.apply(this, arguments);
    this.innerHTML = v == null ? "" : v;
  };
}
function html_default(value2) {
  return arguments.length ? this.each(value2 == null ? htmlRemove : (typeof value2 === "function" ? htmlFunction : htmlConstant)(value2)) : this.node().innerHTML;
}

// node_modules/d3-selection/src/selection/raise.js
function raise() {
  if (this.nextSibling) this.parentNode.appendChild(this);
}
function raise_default() {
  return this.each(raise);
}

// node_modules/d3-selection/src/selection/lower.js
function lower() {
  if (this.previousSibling) this.parentNode.insertBefore(this, this.parentNode.firstChild);
}
function lower_default() {
  return this.each(lower);
}

// node_modules/d3-selection/src/selection/append.js
function append_default(name2) {
  var create2 = typeof name2 === "function" ? name2 : creator_default(name2);
  return this.select(function() {
    return this.appendChild(create2.apply(this, arguments));
  });
}

// node_modules/d3-selection/src/selection/insert.js
function constantNull() {
  return null;
}
function insert_default(name2, before) {
  var create2 = typeof name2 === "function" ? name2 : creator_default(name2), select2 = before == null ? constantNull : typeof before === "function" ? before : selector_default(before);
  return this.select(function() {
    return this.insertBefore(create2.apply(this, arguments), select2.apply(this, arguments) || null);
  });
}

// node_modules/d3-selection/src/selection/remove.js
function remove() {
  var parent = this.parentNode;
  if (parent) parent.removeChild(this);
}
function remove_default() {
  return this.each(remove);
}

// node_modules/d3-selection/src/selection/clone.js
function selection_cloneShallow() {
  var clone = this.cloneNode(false), parent = this.parentNode;
  return parent ? parent.insertBefore(clone, this.nextSibling) : clone;
}
function selection_cloneDeep() {
  var clone = this.cloneNode(true), parent = this.parentNode;
  return parent ? parent.insertBefore(clone, this.nextSibling) : clone;
}
function clone_default(deep) {
  return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
}

// node_modules/d3-selection/src/selection/datum.js
function datum_default(value2) {
  return arguments.length ? this.property("__data__", value2) : this.node().__data__;
}

// node_modules/d3-selection/src/selection/on.js
function contextListener(listener) {
  return function(event) {
    listener.call(this, event, this.__data__);
  };
}
function parseTypenames(typenames) {
  return typenames.trim().split(/^|\s+/).map(function(t) {
    var name2 = "", i = t.indexOf(".");
    if (i >= 0) name2 = t.slice(i + 1), t = t.slice(0, i);
    return { type: t, name: name2 };
  });
}
function onRemove(typename) {
  return function() {
    var on = this.__on;
    if (!on) return;
    for (var j = 0, i = -1, m2 = on.length, o; j < m2; ++j) {
      if (o = on[j], (!typename.type || o.type === typename.type) && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
      } else {
        on[++i] = o;
      }
    }
    if (++i) on.length = i;
    else delete this.__on;
  };
}
function onAdd(typename, value2, options) {
  return function() {
    var on = this.__on, o, listener = contextListener(value2);
    if (on) for (var j = 0, m2 = on.length; j < m2; ++j) {
      if ((o = on[j]).type === typename.type && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
        this.addEventListener(o.type, o.listener = listener, o.options = options);
        o.value = value2;
        return;
      }
    }
    this.addEventListener(typename.type, listener, options);
    o = { type: typename.type, name: typename.name, value: value2, listener, options };
    if (!on) this.__on = [o];
    else on.push(o);
  };
}
function on_default(typename, value2, options) {
  var typenames = parseTypenames(typename + ""), i, n = typenames.length, t;
  if (arguments.length < 2) {
    var on = this.node().__on;
    if (on) for (var j = 0, m2 = on.length, o; j < m2; ++j) {
      for (i = 0, o = on[j]; i < n; ++i) {
        if ((t = typenames[i]).type === o.type && t.name === o.name) {
          return o.value;
        }
      }
    }
    return;
  }
  on = value2 ? onAdd : onRemove;
  for (i = 0; i < n; ++i) this.each(on(typenames[i], value2, options));
  return this;
}

// node_modules/d3-selection/src/selection/dispatch.js
function dispatchEvent(node4, type2, params) {
  var window2 = window_default(node4), event = window2.CustomEvent;
  if (typeof event === "function") {
    event = new event(type2, params);
  } else {
    event = window2.document.createEvent("Event");
    if (params) event.initEvent(type2, params.bubbles, params.cancelable), event.detail = params.detail;
    else event.initEvent(type2, false, false);
  }
  node4.dispatchEvent(event);
}
function dispatchConstant(type2, params) {
  return function() {
    return dispatchEvent(this, type2, params);
  };
}
function dispatchFunction(type2, params) {
  return function() {
    return dispatchEvent(this, type2, params.apply(this, arguments));
  };
}
function dispatch_default2(type2, params) {
  return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type2, params));
}

// node_modules/d3-selection/src/selection/iterator.js
function* iterator_default() {
  for (var groups2 = this._groups, j = 0, m2 = groups2.length; j < m2; ++j) {
    for (var group3 = groups2[j], i = 0, n = group3.length, node4; i < n; ++i) {
      if (node4 = group3[i]) yield node4;
    }
  }
}

// node_modules/d3-selection/src/selection/index.js
var root = [null];
function Selection(groups2, parents) {
  this._groups = groups2;
  this._parents = parents;
}
function selection() {
  return new Selection([[document.documentElement]], root);
}
function selection_selection() {
  return this;
}
Selection.prototype = selection.prototype = {
  constructor: Selection,
  select: select_default,
  selectAll: selectAll_default,
  selectChild: selectChild_default,
  selectChildren: selectChildren_default,
  filter: filter_default,
  data: data_default,
  enter: enter_default,
  exit: exit_default,
  join: join_default,
  merge: merge_default,
  selection: selection_selection,
  order: order_default,
  sort: sort_default,
  call: call_default,
  nodes: nodes_default,
  node: node_default,
  size: size_default,
  empty: empty_default,
  each: each_default,
  attr: attr_default,
  style: style_default,
  property: property_default,
  classed: classed_default,
  text: text_default,
  html: html_default,
  raise: raise_default,
  lower: lower_default,
  append: append_default,
  insert: insert_default,
  remove: remove_default,
  clone: clone_default,
  datum: datum_default,
  on: on_default,
  dispatch: dispatch_default2,
  [Symbol.iterator]: iterator_default
};
var selection_default = selection;

// node_modules/d3-selection/src/select.js
function select_default2(selector) {
  return typeof selector === "string" ? new Selection([[document.querySelector(selector)]], [document.documentElement]) : new Selection([[selector]], root);
}

// node_modules/d3-selection/src/local.js
var nextId = 0;
function local() {
  return new Local();
}
function Local() {
  this._ = "@" + (++nextId).toString(36);
}
Local.prototype = local.prototype = {
  constructor: Local,
  get: function(node4) {
    var id2 = this._;
    while (!(id2 in node4)) if (!(node4 = node4.parentNode)) return;
    return node4[id2];
  },
  set: function(node4, value2) {
    return node4[this._] = value2;
  },
  remove: function(node4) {
    return this._ in node4 && delete node4[this._];
  },
  toString: function() {
    return this._;
  }
};

// node_modules/d3-selection/src/sourceEvent.js
function sourceEvent_default(event) {
  let sourceEvent;
  while (sourceEvent = event.sourceEvent) event = sourceEvent;
  return event;
}

// node_modules/d3-selection/src/pointer.js
function pointer_default(event, node4) {
  event = sourceEvent_default(event);
  if (node4 === void 0) node4 = event.currentTarget;
  if (node4) {
    var svg = node4.ownerSVGElement || node4;
    if (svg.createSVGPoint) {
      var point13 = svg.createSVGPoint();
      point13.x = event.clientX, point13.y = event.clientY;
      point13 = point13.matrixTransform(node4.getScreenCTM().inverse());
      return [point13.x, point13.y];
    }
    if (node4.getBoundingClientRect) {
      var rect = node4.getBoundingClientRect();
      return [event.clientX - rect.left - node4.clientLeft, event.clientY - rect.top - node4.clientTop];
    }
  }
  return [event.pageX, event.pageY];
}

// node_modules/@unovis/ts/types/component.js
var ComponentType;
(function(ComponentType2) {
  ComponentType2[ComponentType2["SVG"] = 0] = "SVG";
  ComponentType2[ComponentType2["HTML"] = 1] = "HTML";
})(ComponentType || (ComponentType = {}));
var Sizing;
(function(Sizing2) {
  Sizing2["Fit"] = "fit";
  Sizing2["Extend"] = "extend";
  Sizing2["FitWidth"] = "fit_width";
})(Sizing || (Sizing = {}));

// node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js
var resizeObservers = [];

// node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js
var hasActiveObservations = function() {
  return resizeObservers.some(function(ro) {
    return ro.activeTargets.length > 0;
  });
};

// node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js
var hasSkippedObservations = function() {
  return resizeObservers.some(function(ro) {
    return ro.skippedTargets.length > 0;
  });
};

// node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js
var msg = "ResizeObserver loop completed with undelivered notifications.";
var deliverResizeLoopError = function() {
  var event;
  if (typeof ErrorEvent === "function") {
    event = new ErrorEvent("error", {
      message: msg
    });
  } else {
    event = document.createEvent("Event");
    event.initEvent("error", false, false);
    event.message = msg;
  }
  window.dispatchEvent(event);
};

// node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js
var ResizeObserverBoxOptions;
(function(ResizeObserverBoxOptions2) {
  ResizeObserverBoxOptions2["BORDER_BOX"] = "border-box";
  ResizeObserverBoxOptions2["CONTENT_BOX"] = "content-box";
  ResizeObserverBoxOptions2["DEVICE_PIXEL_CONTENT_BOX"] = "device-pixel-content-box";
})(ResizeObserverBoxOptions || (ResizeObserverBoxOptions = {}));

// node_modules/@juggle/resize-observer/lib/utils/freeze.js
var freeze = function(obj) {
  return Object.freeze(obj);
};

// node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js
var ResizeObserverSize = /* @__PURE__ */ function() {
  function ResizeObserverSize2(inlineSize, blockSize) {
    this.inlineSize = inlineSize;
    this.blockSize = blockSize;
    freeze(this);
  }
  return ResizeObserverSize2;
}();

// node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js
var DOMRectReadOnly = function() {
  function DOMRectReadOnly2(x3, y3, width, height) {
    this.x = x3;
    this.y = y3;
    this.width = width;
    this.height = height;
    this.top = this.y;
    this.left = this.x;
    this.bottom = this.top + this.height;
    this.right = this.left + this.width;
    return freeze(this);
  }
  DOMRectReadOnly2.prototype.toJSON = function() {
    var _a = this, x3 = _a.x, y3 = _a.y, top2 = _a.top, right3 = _a.right, bottom2 = _a.bottom, left3 = _a.left, width = _a.width, height = _a.height;
    return { x: x3, y: y3, top: top2, right: right3, bottom: bottom2, left: left3, width, height };
  };
  DOMRectReadOnly2.fromRect = function(rectangle) {
    return new DOMRectReadOnly2(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
  };
  return DOMRectReadOnly2;
}();

// node_modules/@juggle/resize-observer/lib/utils/element.js
var isSVG = function(target) {
  return target instanceof SVGElement && "getBBox" in target;
};
var isHidden = function(target) {
  if (isSVG(target)) {
    var _a = target.getBBox(), width = _a.width, height = _a.height;
    return !width && !height;
  }
  var _b = target, offsetWidth = _b.offsetWidth, offsetHeight = _b.offsetHeight;
  return !(offsetWidth || offsetHeight || target.getClientRects().length);
};
var isElement = function(obj) {
  var _a;
  if (obj instanceof Element) {
    return true;
  }
  var scope = (_a = obj === null || obj === void 0 ? void 0 : obj.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
  return !!(scope && obj instanceof scope.Element);
};
var isReplacedElement = function(target) {
  switch (target.tagName) {
    case "INPUT":
      if (target.type !== "image") {
        break;
      }
    case "VIDEO":
    case "AUDIO":
    case "EMBED":
    case "OBJECT":
    case "CANVAS":
    case "IFRAME":
    case "IMG":
      return true;
  }
  return false;
};

// node_modules/@juggle/resize-observer/lib/utils/global.js
var global = typeof window !== "undefined" ? window : {};

// node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js
var cache = /* @__PURE__ */ new WeakMap();
var scrollRegexp = /auto|scroll/;
var verticalRegexp = /^tb|vertical/;
var IE = /msie|trident/i.test(global.navigator && global.navigator.userAgent);
var parseDimension = function(pixel) {
  return parseFloat(pixel || "0");
};
var size = function(inlineSize, blockSize, switchSizes) {
  if (inlineSize === void 0) {
    inlineSize = 0;
  }
  if (blockSize === void 0) {
    blockSize = 0;
  }
  if (switchSizes === void 0) {
    switchSizes = false;
  }
  return new ResizeObserverSize((switchSizes ? blockSize : inlineSize) || 0, (switchSizes ? inlineSize : blockSize) || 0);
};
var zeroBoxes = freeze({
  devicePixelContentBoxSize: size(),
  borderBoxSize: size(),
  contentBoxSize: size(),
  contentRect: new DOMRectReadOnly(0, 0, 0, 0)
});
var calculateBoxSizes = function(target, forceRecalculation) {
  if (forceRecalculation === void 0) {
    forceRecalculation = false;
  }
  if (cache.has(target) && !forceRecalculation) {
    return cache.get(target);
  }
  if (isHidden(target)) {
    cache.set(target, zeroBoxes);
    return zeroBoxes;
  }
  var cs = getComputedStyle(target);
  var svg = isSVG(target) && target.ownerSVGElement && target.getBBox();
  var removePadding = !IE && cs.boxSizing === "border-box";
  var switchSizes = verticalRegexp.test(cs.writingMode || "");
  var canScrollVertically = !svg && scrollRegexp.test(cs.overflowY || "");
  var canScrollHorizontally = !svg && scrollRegexp.test(cs.overflowX || "");
  var paddingTop = svg ? 0 : parseDimension(cs.paddingTop);
  var paddingRight = svg ? 0 : parseDimension(cs.paddingRight);
  var paddingBottom = svg ? 0 : parseDimension(cs.paddingBottom);
  var paddingLeft = svg ? 0 : parseDimension(cs.paddingLeft);
  var borderTop2 = svg ? 0 : parseDimension(cs.borderTopWidth);
  var borderRight2 = svg ? 0 : parseDimension(cs.borderRightWidth);
  var borderBottom2 = svg ? 0 : parseDimension(cs.borderBottomWidth);
  var borderLeft2 = svg ? 0 : parseDimension(cs.borderLeftWidth);
  var horizontalPadding = paddingLeft + paddingRight;
  var verticalPadding = paddingTop + paddingBottom;
  var horizontalBorderArea = borderLeft2 + borderRight2;
  var verticalBorderArea = borderTop2 + borderBottom2;
  var horizontalScrollbarThickness = !canScrollHorizontally ? 0 : target.offsetHeight - verticalBorderArea - target.clientHeight;
  var verticalScrollbarThickness = !canScrollVertically ? 0 : target.offsetWidth - horizontalBorderArea - target.clientWidth;
  var widthReduction = removePadding ? horizontalPadding + horizontalBorderArea : 0;
  var heightReduction = removePadding ? verticalPadding + verticalBorderArea : 0;
  var contentWidth = svg ? svg.width : parseDimension(cs.width) - widthReduction - verticalScrollbarThickness;
  var contentHeight = svg ? svg.height : parseDimension(cs.height) - heightReduction - horizontalScrollbarThickness;
  var borderBoxWidth = contentWidth + horizontalPadding + verticalScrollbarThickness + horizontalBorderArea;
  var borderBoxHeight = contentHeight + verticalPadding + horizontalScrollbarThickness + verticalBorderArea;
  var boxes = freeze({
    devicePixelContentBoxSize: size(Math.round(contentWidth * devicePixelRatio), Math.round(contentHeight * devicePixelRatio), switchSizes),
    borderBoxSize: size(borderBoxWidth, borderBoxHeight, switchSizes),
    contentBoxSize: size(contentWidth, contentHeight, switchSizes),
    contentRect: new DOMRectReadOnly(paddingLeft, paddingTop, contentWidth, contentHeight)
  });
  cache.set(target, boxes);
  return boxes;
};
var calculateBoxSize = function(target, observedBox, forceRecalculation) {
  var _a = calculateBoxSizes(target, forceRecalculation), borderBoxSize = _a.borderBoxSize, contentBoxSize = _a.contentBoxSize, devicePixelContentBoxSize = _a.devicePixelContentBoxSize;
  switch (observedBox) {
    case ResizeObserverBoxOptions.DEVICE_PIXEL_CONTENT_BOX:
      return devicePixelContentBoxSize;
    case ResizeObserverBoxOptions.BORDER_BOX:
      return borderBoxSize;
    default:
      return contentBoxSize;
  }
};

// node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js
var ResizeObserverEntry = /* @__PURE__ */ function() {
  function ResizeObserverEntry2(target) {
    var boxes = calculateBoxSizes(target);
    this.target = target;
    this.contentRect = boxes.contentRect;
    this.borderBoxSize = freeze([boxes.borderBoxSize]);
    this.contentBoxSize = freeze([boxes.contentBoxSize]);
    this.devicePixelContentBoxSize = freeze([boxes.devicePixelContentBoxSize]);
  }
  return ResizeObserverEntry2;
}();

// node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js
var calculateDepthForNode = function(node4) {
  if (isHidden(node4)) {
    return Infinity;
  }
  var depth = 0;
  var parent = node4.parentNode;
  while (parent) {
    depth += 1;
    parent = parent.parentNode;
  }
  return depth;
};

// node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js
var broadcastActiveObservations = function() {
  var shallowestDepth = Infinity;
  var callbacks2 = [];
  resizeObservers.forEach(function processObserver(ro) {
    if (ro.activeTargets.length === 0) {
      return;
    }
    var entries = [];
    ro.activeTargets.forEach(function processTarget(ot) {
      var entry = new ResizeObserverEntry(ot.target);
      var targetDepth2 = calculateDepthForNode(ot.target);
      entries.push(entry);
      ot.lastReportedSize = calculateBoxSize(ot.target, ot.observedBox);
      if (targetDepth2 < shallowestDepth) {
        shallowestDepth = targetDepth2;
      }
    });
    callbacks2.push(function resizeObserverCallback() {
      ro.callback.call(ro.observer, entries, ro.observer);
    });
    ro.activeTargets.splice(0, ro.activeTargets.length);
  });
  for (var _i = 0, callbacks_1 = callbacks2; _i < callbacks_1.length; _i++) {
    var callback = callbacks_1[_i];
    callback();
  }
  return shallowestDepth;
};

// node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js
var gatherActiveObservationsAtDepth = function(depth) {
  resizeObservers.forEach(function processObserver(ro) {
    ro.activeTargets.splice(0, ro.activeTargets.length);
    ro.skippedTargets.splice(0, ro.skippedTargets.length);
    ro.observationTargets.forEach(function processTarget(ot) {
      if (ot.isActive()) {
        if (calculateDepthForNode(ot.target) > depth) {
          ro.activeTargets.push(ot);
        } else {
          ro.skippedTargets.push(ot);
        }
      }
    });
  });
};

// node_modules/@juggle/resize-observer/lib/utils/process.js
var process = function() {
  var depth = 0;
  gatherActiveObservationsAtDepth(depth);
  while (hasActiveObservations()) {
    depth = broadcastActiveObservations();
    gatherActiveObservationsAtDepth(depth);
  }
  if (hasSkippedObservations()) {
    deliverResizeLoopError();
  }
  return depth > 0;
};

// node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js
var trigger;
var callbacks = [];
var notify = function() {
  return callbacks.splice(0).forEach(function(cb) {
    return cb();
  });
};
var queueMicroTask = function(callback) {
  if (!trigger) {
    var toggle_1 = 0;
    var el_1 = document.createTextNode("");
    var config = { characterData: true };
    new MutationObserver(function() {
      return notify();
    }).observe(el_1, config);
    trigger = function() {
      el_1.textContent = "".concat(toggle_1 ? toggle_1-- : toggle_1++);
    };
  }
  callbacks.push(callback);
  trigger();
};

// node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js
var queueResizeObserver = function(cb) {
  queueMicroTask(function ResizeObserver3() {
    requestAnimationFrame(cb);
  });
};

// node_modules/@juggle/resize-observer/lib/utils/scheduler.js
var watching = 0;
var isWatching = function() {
  return !!watching;
};
var CATCH_PERIOD = 250;
var observerConfig = { attributes: true, characterData: true, childList: true, subtree: true };
var events = [
  "resize",
  "load",
  "transitionend",
  "animationend",
  "animationstart",
  "animationiteration",
  "keyup",
  "keydown",
  "mouseup",
  "mousedown",
  "mouseover",
  "mouseout",
  "blur",
  "focus"
];
var time = function(timeout) {
  if (timeout === void 0) {
    timeout = 0;
  }
  return Date.now() + timeout;
};
var scheduled = false;
var Scheduler = function() {
  function Scheduler2() {
    var _this = this;
    this.stopped = true;
    this.listener = function() {
      return _this.schedule();
    };
  }
  Scheduler2.prototype.run = function(timeout) {
    var _this = this;
    if (timeout === void 0) {
      timeout = CATCH_PERIOD;
    }
    if (scheduled) {
      return;
    }
    scheduled = true;
    var until = time(timeout);
    queueResizeObserver(function() {
      var elementsHaveResized = false;
      try {
        elementsHaveResized = process();
      } finally {
        scheduled = false;
        timeout = until - time();
        if (!isWatching()) {
          return;
        }
        if (elementsHaveResized) {
          _this.run(1e3);
        } else if (timeout > 0) {
          _this.run(timeout);
        } else {
          _this.start();
        }
      }
    });
  };
  Scheduler2.prototype.schedule = function() {
    this.stop();
    this.run();
  };
  Scheduler2.prototype.observe = function() {
    var _this = this;
    var cb = function() {
      return _this.observer && _this.observer.observe(document.body, observerConfig);
    };
    document.body ? cb() : global.addEventListener("DOMContentLoaded", cb);
  };
  Scheduler2.prototype.start = function() {
    var _this = this;
    if (this.stopped) {
      this.stopped = false;
      this.observer = new MutationObserver(this.listener);
      this.observe();
      events.forEach(function(name2) {
        return global.addEventListener(name2, _this.listener, true);
      });
    }
  };
  Scheduler2.prototype.stop = function() {
    var _this = this;
    if (!this.stopped) {
      this.observer && this.observer.disconnect();
      events.forEach(function(name2) {
        return global.removeEventListener(name2, _this.listener, true);
      });
      this.stopped = true;
    }
  };
  return Scheduler2;
}();
var scheduler = new Scheduler();
var updateCount = function(n) {
  !watching && n > 0 && scheduler.start();
  watching += n;
  !watching && scheduler.stop();
};

// node_modules/@juggle/resize-observer/lib/ResizeObservation.js
var skipNotifyOnElement = function(target) {
  return !isSVG(target) && !isReplacedElement(target) && getComputedStyle(target).display === "inline";
};
var ResizeObservation = function() {
  function ResizeObservation2(target, observedBox) {
    this.target = target;
    this.observedBox = observedBox || ResizeObserverBoxOptions.CONTENT_BOX;
    this.lastReportedSize = {
      inlineSize: 0,
      blockSize: 0
    };
  }
  ResizeObservation2.prototype.isActive = function() {
    var size2 = calculateBoxSize(this.target, this.observedBox, true);
    if (skipNotifyOnElement(this.target)) {
      this.lastReportedSize = size2;
    }
    if (this.lastReportedSize.inlineSize !== size2.inlineSize || this.lastReportedSize.blockSize !== size2.blockSize) {
      return true;
    }
    return false;
  };
  return ResizeObservation2;
}();

// node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js
var ResizeObserverDetail = /* @__PURE__ */ function() {
  function ResizeObserverDetail2(resizeObserver, callback) {
    this.activeTargets = [];
    this.skippedTargets = [];
    this.observationTargets = [];
    this.observer = resizeObserver;
    this.callback = callback;
  }
  return ResizeObserverDetail2;
}();

// node_modules/@juggle/resize-observer/lib/ResizeObserverController.js
var observerMap = /* @__PURE__ */ new WeakMap();
var getObservationIndex = function(observationTargets, target) {
  for (var i = 0; i < observationTargets.length; i += 1) {
    if (observationTargets[i].target === target) {
      return i;
    }
  }
  return -1;
};
var ResizeObserverController = function() {
  function ResizeObserverController2() {
  }
  ResizeObserverController2.connect = function(resizeObserver, callback) {
    var detail = new ResizeObserverDetail(resizeObserver, callback);
    observerMap.set(resizeObserver, detail);
  };
  ResizeObserverController2.observe = function(resizeObserver, target, options) {
    var detail = observerMap.get(resizeObserver);
    var firstObservation = detail.observationTargets.length === 0;
    if (getObservationIndex(detail.observationTargets, target) < 0) {
      firstObservation && resizeObservers.push(detail);
      detail.observationTargets.push(new ResizeObservation(target, options && options.box));
      updateCount(1);
      scheduler.schedule();
    }
  };
  ResizeObserverController2.unobserve = function(resizeObserver, target) {
    var detail = observerMap.get(resizeObserver);
    var index3 = getObservationIndex(detail.observationTargets, target);
    var lastObservation = detail.observationTargets.length === 1;
    if (index3 >= 0) {
      lastObservation && resizeObservers.splice(resizeObservers.indexOf(detail), 1);
      detail.observationTargets.splice(index3, 1);
      updateCount(-1);
    }
  };
  ResizeObserverController2.disconnect = function(resizeObserver) {
    var _this = this;
    var detail = observerMap.get(resizeObserver);
    detail.observationTargets.slice().forEach(function(ot) {
      return _this.unobserve(resizeObserver, ot.target);
    });
    detail.activeTargets.splice(0, detail.activeTargets.length);
  };
  return ResizeObserverController2;
}();

// node_modules/@juggle/resize-observer/lib/ResizeObserver.js
var ResizeObserver = function() {
  function ResizeObserver3(callback) {
    if (arguments.length === 0) {
      throw new TypeError("Failed to construct 'ResizeObserver': 1 argument required, but only 0 present.");
    }
    if (typeof callback !== "function") {
      throw new TypeError("Failed to construct 'ResizeObserver': The callback provided as parameter 1 is not a function.");
    }
    ResizeObserverController.connect(this, callback);
  }
  ResizeObserver3.prototype.observe = function(target, options) {
    if (arguments.length === 0) {
      throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': 1 argument required, but only 0 present.");
    }
    if (!isElement(target)) {
      throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': parameter 1 is not of type 'Element");
    }
    ResizeObserverController.observe(this, target, options);
  };
  ResizeObserver3.prototype.unobserve = function(target) {
    if (arguments.length === 0) {
      throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': 1 argument required, but only 0 present.");
    }
    if (!isElement(target)) {
      throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': parameter 1 is not of type 'Element");
    }
    ResizeObserverController.unobserve(this, target);
  };
  ResizeObserver3.prototype.disconnect = function() {
    ResizeObserverController.disconnect(this);
  };
  ResizeObserver3.toString = function() {
    return "function ResizeObserver () { [polyfill code] }";
  };
  return ResizeObserver3;
}();

// node_modules/@unovis/ts/utils/resize-observer.js
var ResizeObserver2 = globalThis.ResizeObserver || ResizeObserver;

// node_modules/@unovis/ts/core/container/config.js
var ContainerDefaultConfig = {
  duration: void 0,
  margin: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  padding: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  sizing: Sizing.Fit,
  width: void 0,
  height: void 0,
  svgDefs: void 0,
  ariaLabel: void 0
};

// node_modules/@unovis/ts/core/container/index.js
var ContainerCore = class _ContainerCore {
  constructor(element) {
    this._defaultConfig = ContainerDefaultConfig;
    this._isFirstRender = true;
    this._requestedAnimationFrame = null;
    this._container = element;
    const container = select_default2(this._container);
    container.attr("role", "figure");
    this.svg = container.append("svg").style("display", "block").attr("xmlns", "http://www.w3.org/2000/svg").attr("height", _ContainerCore.DEFAULT_CONTAINER_HEIGHT).attr("aria-hidden", true);
    this._svgDefs = this.svg.append("defs");
    this._svgDefsExternal = this.svg.append("defs");
    this.element = this.svg.node();
  }
  updateContainer(config) {
    this.prevConfig = this.config;
    this.config = merge2(this._defaultConfig, config);
  }
  // The `_preRender` step should be used to perform some actions before rendering.
  // For example, calculating scales, setting component sizes, etc ...
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  _preRender() {
  }
  // The `_render` step should be used to perform the actual rendering
  _render(duration) {
    const { config, prevConfig } = this;
    if (config.svgDefs !== prevConfig.svgDefs) {
      this._svgDefsExternal.selectAll("*").remove();
      this._svgDefsExternal.html(config.svgDefs);
    }
    select_default2(this._container).attr("aria-label", config.ariaLabel);
    this._isFirstRender = false;
  }
  // Warning: Some Containers (i.e. Single Container) may override this method, so if you introduce any changes here,
  // make sure to check that other containers didn't break after them.
  render(duration = this.config.duration) {
    const width = this.config.width || this.containerWidth;
    const height = this.config.height || this.containerHeight;
    this.svg.attr("width", width).attr("height", height);
    if (!this._resizeObserver)
      this._setUpResizeObserver();
    cancelAnimationFrame(this._requestedAnimationFrame);
    this._requestedAnimationFrame = requestAnimationFrame(() => {
      this._preRender();
      this._render(duration);
    });
  }
  get containerWidth() {
    return this.config.width ? this.element.clientWidth : this._container.clientWidth || this._container.getBoundingClientRect().width;
  }
  get containerHeight() {
    return this.config.height ? this.element.clientHeight : this._container.clientHeight || this._container.getBoundingClientRect().height || _ContainerCore.DEFAULT_CONTAINER_HEIGHT;
  }
  get width() {
    return clamp(this.containerWidth - this.config.margin.left - this.config.margin.right, 0, Number.POSITIVE_INFINITY);
  }
  get height() {
    return clamp(this.containerHeight - this.config.margin.top - this.config.margin.bottom, 0, Number.POSITIVE_INFINITY);
  }
  _removeAllChildren() {
    while (this.element.firstChild) {
      this.element.removeChild(this.element.firstChild);
    }
  }
  _onResize() {
    const { config } = this;
    const redrawOnResize = config.sizing === Sizing.Fit || config.sizing === Sizing.FitWidth;
    if (redrawOnResize)
      this.render(0);
  }
  _setUpResizeObserver() {
    if (this._resizeObserver)
      return;
    const containerRect = this._container.getBoundingClientRect();
    this._containerSize = { width: containerRect.width, height: containerRect.height };
    this._resizeObserver = new ResizeObserver2((entries, observer) => {
      const resizedContainerRect = this._container.getBoundingClientRect();
      const resizedContainerSize = { width: resizedContainerRect.width, height: resizedContainerRect.height };
      const hasSizeChanged = !isEqual(this._containerSize, resizedContainerSize);
      if (hasSizeChanged && resizedContainerSize.width && resizedContainerSize.height) {
        this._containerSize = resizedContainerSize;
        this._onResize();
      }
    });
    this._resizeObserver.observe(this._container);
  }
  destroy() {
    var _a;
    cancelAnimationFrame(this._requestedAnimationFrame);
    (_a = this._resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    this.svg.remove();
  }
};
ContainerCore.DEFAULT_CONTAINER_HEIGHT = 300;

// node_modules/@unovis/ts/utils/misc.js
var import_to_px = __toESM(require_browser(), 1);
function guid() {
  const s4 = () => Math.floor((1 + crypto.getRandomValues(new Uint32Array(1))[0]) * 65536).toString(16).substring(1);
  return `${s4() + s4()}-${s4()}-${s4()}-${s4()}-${s4()}${s4()}${s4()}`;
}
function isStringCSSVariable(s3) {
  return isString(s3) ? s3.substring(0, 6) === "var(--" : false;
}
function getCSSVariableValue(s3, context) {
  if (!isString(s3))
    return "";
  const variableName = s3.substr(4, s3.length - 5);
  return getComputedStyle(context).getPropertyValue(variableName);
}
function getCSSVariableValueInPixels(s3, context) {
  const val = getCSSVariableValue(s3, context);
  return (0, import_to_px.default)(val);
}
function getPixelValue(v) {
  return typeof v === "number" ? v : (0, import_to_px.default)(v);
}
function rectIntersect(rect1, rect2, tolerancePx = 0) {
  const [left1, top1, right1, bottom1] = [
    rect1.x + tolerancePx,
    rect1.y + rect1.height - 2 * tolerancePx,
    rect1.x + rect1.width - 2 * tolerancePx,
    rect1.y + tolerancePx
  ];
  const [left22, top2, right22, bottom2] = [
    rect2.x + tolerancePx,
    rect2.y + rect2.height - 2 * tolerancePx,
    rect2.x + rect2.width - 2 * tolerancePx,
    rect2.y + tolerancePx
  ];
  return !(top1 < bottom2 || top2 < bottom1 || right1 < left22 || right22 < left1);
}
function parseUnit(value2, basis2 = 0) {
  if (!value2)
    return 0;
  else if (typeof value2 === "number")
    return value2;
  else if (value2.endsWith("%"))
    return basis2 * parseFloat(value2) / 100;
  else if (value2.endsWith("px"))
    return parseFloat(value2);
  else
    return parseFloat(value2) || 0;
}

// node_modules/d3-color/src/define.js
function define_default(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}
function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key in definition) prototype[key] = definition[key];
  return prototype;
}

// node_modules/d3-color/src/color.js
function Color() {
}
var darker = 0.7;
var brighter = 1 / darker;
var reI = "\\s*([+-]?\\d+)\\s*";
var reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*";
var reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*";
var reHex = /^#([0-9a-f]{3,8})$/;
var reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`);
var reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`);
var reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`);
var reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`);
var reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`);
var reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
var named = {
  aliceblue: 15792383,
  antiquewhite: 16444375,
  aqua: 65535,
  aquamarine: 8388564,
  azure: 15794175,
  beige: 16119260,
  bisque: 16770244,
  black: 0,
  blanchedalmond: 16772045,
  blue: 255,
  blueviolet: 9055202,
  brown: 10824234,
  burlywood: 14596231,
  cadetblue: 6266528,
  chartreuse: 8388352,
  chocolate: 13789470,
  coral: 16744272,
  cornflowerblue: 6591981,
  cornsilk: 16775388,
  crimson: 14423100,
  cyan: 65535,
  darkblue: 139,
  darkcyan: 35723,
  darkgoldenrod: 12092939,
  darkgray: 11119017,
  darkgreen: 25600,
  darkgrey: 11119017,
  darkkhaki: 12433259,
  darkmagenta: 9109643,
  darkolivegreen: 5597999,
  darkorange: 16747520,
  darkorchid: 10040012,
  darkred: 9109504,
  darksalmon: 15308410,
  darkseagreen: 9419919,
  darkslateblue: 4734347,
  darkslategray: 3100495,
  darkslategrey: 3100495,
  darkturquoise: 52945,
  darkviolet: 9699539,
  deeppink: 16716947,
  deepskyblue: 49151,
  dimgray: 6908265,
  dimgrey: 6908265,
  dodgerblue: 2003199,
  firebrick: 11674146,
  floralwhite: 16775920,
  forestgreen: 2263842,
  fuchsia: 16711935,
  gainsboro: 14474460,
  ghostwhite: 16316671,
  gold: 16766720,
  goldenrod: 14329120,
  gray: 8421504,
  green: 32768,
  greenyellow: 11403055,
  grey: 8421504,
  honeydew: 15794160,
  hotpink: 16738740,
  indianred: 13458524,
  indigo: 4915330,
  ivory: 16777200,
  khaki: 15787660,
  lavender: 15132410,
  lavenderblush: 16773365,
  lawngreen: 8190976,
  lemonchiffon: 16775885,
  lightblue: 11393254,
  lightcoral: 15761536,
  lightcyan: 14745599,
  lightgoldenrodyellow: 16448210,
  lightgray: 13882323,
  lightgreen: 9498256,
  lightgrey: 13882323,
  lightpink: 16758465,
  lightsalmon: 16752762,
  lightseagreen: 2142890,
  lightskyblue: 8900346,
  lightslategray: 7833753,
  lightslategrey: 7833753,
  lightsteelblue: 11584734,
  lightyellow: 16777184,
  lime: 65280,
  limegreen: 3329330,
  linen: 16445670,
  magenta: 16711935,
  maroon: 8388608,
  mediumaquamarine: 6737322,
  mediumblue: 205,
  mediumorchid: 12211667,
  mediumpurple: 9662683,
  mediumseagreen: 3978097,
  mediumslateblue: 8087790,
  mediumspringgreen: 64154,
  mediumturquoise: 4772300,
  mediumvioletred: 13047173,
  midnightblue: 1644912,
  mintcream: 16121850,
  mistyrose: 16770273,
  moccasin: 16770229,
  navajowhite: 16768685,
  navy: 128,
  oldlace: 16643558,
  olive: 8421376,
  olivedrab: 7048739,
  orange: 16753920,
  orangered: 16729344,
  orchid: 14315734,
  palegoldenrod: 15657130,
  palegreen: 10025880,
  paleturquoise: 11529966,
  palevioletred: 14381203,
  papayawhip: 16773077,
  peachpuff: 16767673,
  peru: 13468991,
  pink: 16761035,
  plum: 14524637,
  powderblue: 11591910,
  purple: 8388736,
  rebeccapurple: 6697881,
  red: 16711680,
  rosybrown: 12357519,
  royalblue: 4286945,
  saddlebrown: 9127187,
  salmon: 16416882,
  sandybrown: 16032864,
  seagreen: 3050327,
  seashell: 16774638,
  sienna: 10506797,
  silver: 12632256,
  skyblue: 8900331,
  slateblue: 6970061,
  slategray: 7372944,
  slategrey: 7372944,
  snow: 16775930,
  springgreen: 65407,
  steelblue: 4620980,
  tan: 13808780,
  teal: 32896,
  thistle: 14204888,
  tomato: 16737095,
  turquoise: 4251856,
  violet: 15631086,
  wheat: 16113331,
  white: 16777215,
  whitesmoke: 16119285,
  yellow: 16776960,
  yellowgreen: 10145074
};
define_default(Color, color, {
  copy(channels) {
    return Object.assign(new this.constructor(), this, channels);
  },
  displayable() {
    return this.rgb().displayable();
  },
  hex: color_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHex8: color_formatHex8,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});
function color_formatHex() {
  return this.rgb().formatHex();
}
function color_formatHex8() {
  return this.rgb().formatHex8();
}
function color_formatHsl() {
  return hslConvert(this).formatHsl();
}
function color_formatRgb() {
  return this.rgb().formatRgb();
}
function color(format2) {
  var m2, l;
  format2 = (format2 + "").trim().toLowerCase();
  return (m2 = reHex.exec(format2)) ? (l = m2[1].length, m2 = parseInt(m2[1], 16), l === 6 ? rgbn(m2) : l === 3 ? new Rgb(m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, (m2 & 15) << 4 | m2 & 15, 1) : l === 8 ? rgba(m2 >> 24 & 255, m2 >> 16 & 255, m2 >> 8 & 255, (m2 & 255) / 255) : l === 4 ? rgba(m2 >> 12 & 15 | m2 >> 8 & 240, m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, ((m2 & 15) << 4 | m2 & 15) / 255) : null) : (m2 = reRgbInteger.exec(format2)) ? new Rgb(m2[1], m2[2], m2[3], 1) : (m2 = reRgbPercent.exec(format2)) ? new Rgb(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, 1) : (m2 = reRgbaInteger.exec(format2)) ? rgba(m2[1], m2[2], m2[3], m2[4]) : (m2 = reRgbaPercent.exec(format2)) ? rgba(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, m2[4]) : (m2 = reHslPercent.exec(format2)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, 1) : (m2 = reHslaPercent.exec(format2)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, m2[4]) : named.hasOwnProperty(format2) ? rgbn(named[format2]) : format2 === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
}
function rgbn(n) {
  return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
}
function rgba(r, g, b, a4) {
  if (a4 <= 0) r = g = b = NaN;
  return new Rgb(r, g, b, a4);
}
function rgbConvert(o) {
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Rgb();
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}
function rgb(r, g, b, opacity) {
  return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
}
function Rgb(r, g, b, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b;
  this.opacity = +opacity;
}
define_default(Rgb, rgb, extend(Color, {
  brighter(k4) {
    k4 = k4 == null ? brighter : Math.pow(brighter, k4);
    return new Rgb(this.r * k4, this.g * k4, this.b * k4, this.opacity);
  },
  darker(k4) {
    k4 = k4 == null ? darker : Math.pow(darker, k4);
    return new Rgb(this.r * k4, this.g * k4, this.b * k4, this.opacity);
  },
  rgb() {
    return this;
  },
  clamp() {
    return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
  },
  displayable() {
    return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatHex8: rgb_formatHex8,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));
function rgb_formatHex() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
}
function rgb_formatHex8() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
}
function rgb_formatRgb() {
  const a4 = clampa(this.opacity);
  return `${a4 === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a4 === 1 ? ")" : `, ${a4})`}`;
}
function clampa(opacity) {
  return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
}
function clampi(value2) {
  return Math.max(0, Math.min(255, Math.round(value2) || 0));
}
function hex(value2) {
  value2 = clampi(value2);
  return (value2 < 16 ? "0" : "") + value2.toString(16);
}
function hsla(h, s3, l, a4) {
  if (a4 <= 0) h = s3 = l = NaN;
  else if (l <= 0 || l >= 1) h = s3 = NaN;
  else if (s3 <= 0) h = NaN;
  return new Hsl(h, s3, l, a4);
}
function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Hsl();
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r = o.r / 255, g = o.g / 255, b = o.b / 255, min7 = Math.min(r, g, b), max8 = Math.max(r, g, b), h = NaN, s3 = max8 - min7, l = (max8 + min7) / 2;
  if (s3) {
    if (r === max8) h = (g - b) / s3 + (g < b) * 6;
    else if (g === max8) h = (b - r) / s3 + 2;
    else h = (r - g) / s3 + 4;
    s3 /= l < 0.5 ? max8 + min7 : 2 - max8 - min7;
    h *= 60;
  } else {
    s3 = l > 0 && l < 1 ? 0 : h;
  }
  return new Hsl(h, s3, l, o.opacity);
}
function hsl(h, s3, l, opacity) {
  return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s3, l, opacity == null ? 1 : opacity);
}
function Hsl(h, s3, l, opacity) {
  this.h = +h;
  this.s = +s3;
  this.l = +l;
  this.opacity = +opacity;
}
define_default(Hsl, hsl, extend(Color, {
  brighter(k4) {
    k4 = k4 == null ? brighter : Math.pow(brighter, k4);
    return new Hsl(this.h, this.s, this.l * k4, this.opacity);
  },
  darker(k4) {
    k4 = k4 == null ? darker : Math.pow(darker, k4);
    return new Hsl(this.h, this.s, this.l * k4, this.opacity);
  },
  rgb() {
    var h = this.h % 360 + (this.h < 0) * 360, s3 = isNaN(h) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s3, m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
      hsl2rgb(h, m1, m2),
      hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
      this.opacity
    );
  },
  clamp() {
    return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
  },
  displayable() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl() {
    const a4 = clampa(this.opacity);
    return `${a4 === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a4 === 1 ? ")" : `, ${a4})`}`;
  }
}));
function clamph(value2) {
  value2 = (value2 || 0) % 360;
  return value2 < 0 ? value2 + 360 : value2;
}
function clampt(value2) {
  return Math.max(0, Math.min(1, value2 || 0));
}
function hsl2rgb(h, m1, m2) {
  return (h < 60 ? m1 + (m2 - m1) * h / 60 : h < 180 ? m2 : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60 : m1) * 255;
}

// node_modules/d3-color/src/math.js
var radians = Math.PI / 180;
var degrees = 180 / Math.PI;

// node_modules/d3-color/src/lab.js
var K = 18;
var Xn = 0.96422;
var Yn = 1;
var Zn = 0.82521;
var t0 = 4 / 29;
var t1 = 6 / 29;
var t2 = 3 * t1 * t1;
var t3 = t1 * t1 * t1;
function labConvert(o) {
  if (o instanceof Lab) return new Lab(o.l, o.a, o.b, o.opacity);
  if (o instanceof Hcl) return hcl2lab(o);
  if (!(o instanceof Rgb)) o = rgbConvert(o);
  var r = rgb2lrgb(o.r), g = rgb2lrgb(o.g), b = rgb2lrgb(o.b), y3 = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn), x3, z;
  if (r === g && g === b) x3 = z = y3;
  else {
    x3 = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
    z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b) / Zn);
  }
  return new Lab(116 * y3 - 16, 500 * (x3 - y3), 200 * (y3 - z), o.opacity);
}
function lab(l, a4, b, opacity) {
  return arguments.length === 1 ? labConvert(l) : new Lab(l, a4, b, opacity == null ? 1 : opacity);
}
function Lab(l, a4, b, opacity) {
  this.l = +l;
  this.a = +a4;
  this.b = +b;
  this.opacity = +opacity;
}
define_default(Lab, lab, extend(Color, {
  brighter(k4) {
    return new Lab(this.l + K * (k4 == null ? 1 : k4), this.a, this.b, this.opacity);
  },
  darker(k4) {
    return new Lab(this.l - K * (k4 == null ? 1 : k4), this.a, this.b, this.opacity);
  },
  rgb() {
    var y3 = (this.l + 16) / 116, x3 = isNaN(this.a) ? y3 : y3 + this.a / 500, z = isNaN(this.b) ? y3 : y3 - this.b / 200;
    x3 = Xn * lab2xyz(x3);
    y3 = Yn * lab2xyz(y3);
    z = Zn * lab2xyz(z);
    return new Rgb(
      lrgb2rgb(3.1338561 * x3 - 1.6168667 * y3 - 0.4906146 * z),
      lrgb2rgb(-0.9787684 * x3 + 1.9161415 * y3 + 0.033454 * z),
      lrgb2rgb(0.0719453 * x3 - 0.2289914 * y3 + 1.4052427 * z),
      this.opacity
    );
  }
}));
function xyz2lab(t) {
  return t > t3 ? Math.pow(t, 1 / 3) : t / t2 + t0;
}
function lab2xyz(t) {
  return t > t1 ? t * t * t : t2 * (t - t0);
}
function lrgb2rgb(x3) {
  return 255 * (x3 <= 31308e-7 ? 12.92 * x3 : 1.055 * Math.pow(x3, 1 / 2.4) - 0.055);
}
function rgb2lrgb(x3) {
  return (x3 /= 255) <= 0.04045 ? x3 / 12.92 : Math.pow((x3 + 0.055) / 1.055, 2.4);
}
function hclConvert(o) {
  if (o instanceof Hcl) return new Hcl(o.h, o.c, o.l, o.opacity);
  if (!(o instanceof Lab)) o = labConvert(o);
  if (o.a === 0 && o.b === 0) return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
  var h = Math.atan2(o.b, o.a) * degrees;
  return new Hcl(h < 0 ? h + 360 : h, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
}
function hcl(h, c3, l, opacity) {
  return arguments.length === 1 ? hclConvert(h) : new Hcl(h, c3, l, opacity == null ? 1 : opacity);
}
function Hcl(h, c3, l, opacity) {
  this.h = +h;
  this.c = +c3;
  this.l = +l;
  this.opacity = +opacity;
}
function hcl2lab(o) {
  if (isNaN(o.h)) return new Lab(o.l, 0, 0, o.opacity);
  var h = o.h * radians;
  return new Lab(o.l, Math.cos(h) * o.c, Math.sin(h) * o.c, o.opacity);
}
define_default(Hcl, hcl, extend(Color, {
  brighter(k4) {
    return new Hcl(this.h, this.c, this.l + K * (k4 == null ? 1 : k4), this.opacity);
  },
  darker(k4) {
    return new Hcl(this.h, this.c, this.l - K * (k4 == null ? 1 : k4), this.opacity);
  },
  rgb() {
    return hcl2lab(this).rgb();
  }
}));

// node_modules/d3-color/src/cubehelix.js
var A = -0.14861;
var B = 1.78277;
var C = -0.29227;
var D = -0.90649;
var E = 1.97294;
var ED = E * D;
var EB = E * B;
var BC_DA = B * C - D * A;
function cubehelixConvert(o) {
  if (o instanceof Cubehelix) return new Cubehelix(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Rgb)) o = rgbConvert(o);
  var r = o.r / 255, g = o.g / 255, b = o.b / 255, l = (BC_DA * b + ED * r - EB * g) / (BC_DA + ED - EB), bl = b - l, k4 = (E * (g - l) - C * bl) / D, s3 = Math.sqrt(k4 * k4 + bl * bl) / (E * l * (1 - l)), h = s3 ? Math.atan2(k4, bl) * degrees - 120 : NaN;
  return new Cubehelix(h < 0 ? h + 360 : h, s3, l, o.opacity);
}
function cubehelix(h, s3, l, opacity) {
  return arguments.length === 1 ? cubehelixConvert(h) : new Cubehelix(h, s3, l, opacity == null ? 1 : opacity);
}
function Cubehelix(h, s3, l, opacity) {
  this.h = +h;
  this.s = +s3;
  this.l = +l;
  this.opacity = +opacity;
}
define_default(Cubehelix, cubehelix, extend(Color, {
  brighter(k4) {
    k4 = k4 == null ? brighter : Math.pow(brighter, k4);
    return new Cubehelix(this.h, this.s, this.l * k4, this.opacity);
  },
  darker(k4) {
    k4 = k4 == null ? darker : Math.pow(darker, k4);
    return new Cubehelix(this.h, this.s, this.l * k4, this.opacity);
  },
  rgb() {
    var h = isNaN(this.h) ? 0 : (this.h + 120) * radians, l = +this.l, a4 = isNaN(this.s) ? 0 : this.s * l * (1 - l), cosh3 = Math.cos(h), sinh3 = Math.sin(h);
    return new Rgb(
      255 * (l + a4 * (A * cosh3 + B * sinh3)),
      255 * (l + a4 * (C * cosh3 + D * sinh3)),
      255 * (l + a4 * (E * cosh3)),
      this.opacity
    );
  }
}));

// node_modules/@unovis/ts/styles/colors.js
var colors = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_COLORS) || ["#4D8CFD", "#FF6B7E", "#F4B83E", "#A6CC74", "#00C19A", "#6859BE"];
var colorsDark = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_COLORS_DARK) || ["#4D8CFD", "#FF6B7E", "#FFC16D", "#A6CC74", "#00C19A", "#7887E0"];
var getCSSColorVariable = (suffix) => {
  return `--vis-${isNumber(suffix) ? `color${suffix % colors.length}` : suffix}`;
};
function getLighterColor(hex2, percentage = 0.4) {
  const c3 = hsl(hex2);
  c3.l = c3.l * (1 + percentage);
  return c3.formatHex();
}
function getDarkerColor(hex2, percentageL = 0.4, percentageS = 0.6) {
  const c3 = hsl(hex2);
  c3.s = c3.s * (1 - percentageS);
  c3.l = c3.l * (1 - percentageL);
  return c3.formatHex();
}

// node_modules/@unovis/ts/styles/patterns.js
var PATTERN_SIZE_PX = 10;
var fills = [
  { id: "stripes-diagonal", svg: '<path d="M-1,1 l2,-2 M0,10 l10,-10 M9,11 l2,-2" stroke="#000"/>' },
  { id: "dots", svg: '<path d="m0-1.5a1 1 0 010 3m10-3a1 1 0 000 3M5 3.5a1 1 0 010 3 1 1 0 010-3M0 8.5 a1 1 0 010 3m10-3a1 1 0 000 3" fill"#000"/>' },
  { id: "stripes-vertical", svg: '<path d="M 5,-1 L5,11" stroke="#000"/>' },
  { id: "crosshatch", svg: '<path d="M0 0L10 10ZM10 0L0 10Z" stroke="#000"/>' },
  { id: "waves", svg: '<path d="M0 4Q2.5 1 5 4 7.5 7 10 4v2Q7.5 9 5 6 2.5 3 0 6Z" fill="#000"/>' },
  { id: "circles", svg: '<circle cx="5" cy="5" r="3" stroke="#000" fill="#fff"/>' }
];
var lines = [
  { id: "circle", marker: '<circle cx="5" cy="5" r="5"/>', dashArray: [] },
  { id: "triangle", marker: '<path d="M5,0 L10,9 L0,9Z">', dashArray: [9, 1] },
  { id: "diamond", marker: '<path d="M 0 5 L5 0 L 10 5 L 5 10 L 0 5Z">', dashArray: [2] },
  { id: "arrow", marker: '<path d="M4 0 0 0 6 5 0 10 4 10 10 5Z">', dashArray: [2, 3, 8, 3] },
  { id: "square", marker: '<rect x="1" y="1" width="8" height="8"/>', dashArray: [6] },
  { id: "star", marker: '<path d="m2 9 3-9 3 9L0 3h10Z"/>', dashArray: [1, 6] }
];
function getPatternVariable(p) {
  return `vis-${`pattern-${p.svg ? "fill" : "marker"}`}-${p.id}`;
}
var maskDef = (p) => `<mask id="${getPatternVariable(p)}">
    <pattern id="${p.id}" viewBox="0 0 10 10" width="${PATTERN_SIZE_PX}" height="${PATTERN_SIZE_PX}" patternUnits="userSpaceOnUse">
      <rect width="100%" height="100%" fill="#fff"/>
      ${p.svg}
    </pattern>
    <rect x="-50%" y="-50%" width="200%" height="200%" fill="url(#${p.id})"/>
  </mask>`;
var markerDef = (p, i) => `<marker id="${getPatternVariable(p)}"
    fill="var(${getCSSColorVariable(i)})"
    markerUnits="userSpaceOnUse"
    refX="5"
    refY="5"
    markerWidth="${PATTERN_SIZE_PX}"
    markerHeight="${PATTERN_SIZE_PX}">
    ${p.marker}
  </marker>`;
function injectSVGDefs() {
  const svgDefs = fills.map(maskDef).concat(lines.map(markerDef)).join("");
  const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
  svg.setAttribute("height", "100%");
  svg.setAttribute("width", "100%");
  svg.style.position = "fixed";
  svg.style.zIndex = "-99999999";
  svg.innerHTML = `<defs>${svgDefs}</defs>`;
  document.body.appendChild(svg);
}
if (typeof window !== "undefined")
  injectSVGDefs();

// node_modules/@unovis/ts/styles/index.js
var UNOVIS_ICON_FONT_FAMILY_DEFAULT = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_ICON_FONT_FAMILY) || "FontAwesome";
var UNOVIS_FONT_WH_RATIO_DEFAULT = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_FONT_W2H_RATIO_DEFAULT) || 0.5;
var UNOVIS_TEXT_SEPARATOR_DEFAULT = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_TEXT_SEPARATOR_DEFAULT) || [" ", "-", ".", ","];
var UNOVIS_TEXT_HYPHEN_CHARACTER_DEFAULT = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_TEXT_HYPHEN_CHARACTER_DEFAULT) || "-";
var UNOVIS_TEXT_DEFAULT = (globalThis === null || globalThis === void 0 ? void 0 : globalThis.UNOVIS_TEXT_DEFAULT) || {
  text: "",
  fontSize: 12,
  fontFamily: "var(--vis-font-family)",
  lineHeight: 1.25,
  marginTop: 0,
  marginBottom: 0
};
var variables = injectGlobal`
  :root {
    label: vis-root-styles;
    --vis-font-family: Inter, Arial, "Helvetica Neue", Helvetica, sans-serif;
    --vis-font-wh-ratio: ${UNOVIS_FONT_WH_RATIO_DEFAULT};
    --vis-color-main: var(${getCSSColorVariable(0)});
    --vis-color-main-light: ${getLighterColor(colors[0])};
    --vis-color-main-dark: ${getDarkerColor(colors[0])};
    --vis-color-grey: #2a2a2a;
    ${colors.map((c3, i) => `${getCSSColorVariable(i)}: ${c3};`)}
    ${colorsDark.map((c3, i) => `--vis-dark-color${i}: ${c3};`)}
    ${fills.map((p, i) => `
      --${getPatternVariable(p)}: url(#${getPatternVariable(p)});
      --vis-pattern-fill${i}: var(--${getPatternVariable(p)});
    `)}
    ${lines.map((p, i) => {
  var _a;
  return `
      --${getPatternVariable(p)}: url(#${getPatternVariable(p)});
      --vis-pattern-marker${i}: var(--${getPatternVariable(p)});
      --vis-pattern-dasharray${i}: ${(_a = p.dashArray) === null || _a === void 0 ? void 0 : _a.join(" ")};
    `;
})}

    body.theme-dark {
      ${colors.map((c3, i) => `${getCSSColorVariable(i)}: var(--vis-dark-color${i});`)}
    }

    body.theme-patterns {
      ${fills.map((_, i) => `path[style*="fill: var(${getCSSColorVariable(i)})"]  {
        mask: var(--vis-pattern-fill${i});
      }`)}
      ${lines.map((_, i) => `
      path[stroke="var(${getCSSColorVariable(i)})"]:not([style*="fill"]),
      path[style*="stroke: var(${getCSSColorVariable(i)})"]:not([style*="fill"]) {
        marker: var(--vis-pattern-marker${i});
        stroke-dasharray: var(--vis-pattern-dasharray${i});
      }
    `)}
}
`;
function getFontWidthToHeightRatio(context = window === null || window === void 0 ? void 0 : window.document.body) {
  return context ? +getCSSVariableValue("var(--vis-font-wh-ratio)", context) : UNOVIS_FONT_WH_RATIO_DEFAULT;
}

// node_modules/d3-transition/src/transition/schedule.js
var emptyOn = dispatch_default("start", "end", "cancel", "interrupt");
var emptyTween = [];
var CREATED = 0;
var SCHEDULED = 1;
var STARTING = 2;
var STARTED = 3;
var RUNNING = 4;
var ENDING = 5;
var ENDED = 6;
function schedule_default(node4, name2, id2, index3, group3, timing) {
  var schedules = node4.__transition;
  if (!schedules) node4.__transition = {};
  else if (id2 in schedules) return;
  create(node4, id2, {
    name: name2,
    index: index3,
    // For context during callback.
    group: group3,
    // For context during callback.
    on: emptyOn,
    tween: emptyTween,
    time: timing.time,
    delay: timing.delay,
    duration: timing.duration,
    ease: timing.ease,
    timer: null,
    state: CREATED
  });
}
function init(node4, id2) {
  var schedule = get(node4, id2);
  if (schedule.state > CREATED) throw new Error("too late; already scheduled");
  return schedule;
}
function set(node4, id2) {
  var schedule = get(node4, id2);
  if (schedule.state > STARTED) throw new Error("too late; already running");
  return schedule;
}
function get(node4, id2) {
  var schedule = node4.__transition;
  if (!schedule || !(schedule = schedule[id2])) throw new Error("transition not found");
  return schedule;
}
function create(node4, id2, self) {
  var schedules = node4.__transition, tween;
  schedules[id2] = self;
  self.timer = timer(schedule, 0, self.time);
  function schedule(elapsed) {
    self.state = SCHEDULED;
    self.timer.restart(start2, self.delay, self.time);
    if (self.delay <= elapsed) start2(elapsed - self.delay);
  }
  function start2(elapsed) {
    var i, j, n, o;
    if (self.state !== SCHEDULED) return stop();
    for (i in schedules) {
      o = schedules[i];
      if (o.name !== self.name) continue;
      if (o.state === STARTED) return timeout_default(start2);
      if (o.state === RUNNING) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("interrupt", node4, node4.__data__, o.index, o.group);
        delete schedules[i];
      } else if (+i < id2) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("cancel", node4, node4.__data__, o.index, o.group);
        delete schedules[i];
      }
    }
    timeout_default(function() {
      if (self.state === STARTED) {
        self.state = RUNNING;
        self.timer.restart(tick2, self.delay, self.time);
        tick2(elapsed);
      }
    });
    self.state = STARTING;
    self.on.call("start", node4, node4.__data__, self.index, self.group);
    if (self.state !== STARTING) return;
    self.state = STARTED;
    tween = new Array(n = self.tween.length);
    for (i = 0, j = -1; i < n; ++i) {
      if (o = self.tween[i].value.call(node4, node4.__data__, self.index, self.group)) {
        tween[++j] = o;
      }
    }
    tween.length = j + 1;
  }
  function tick2(elapsed) {
    var t = elapsed < self.duration ? self.ease.call(null, elapsed / self.duration) : (self.timer.restart(stop), self.state = ENDING, 1), i = -1, n = tween.length;
    while (++i < n) {
      tween[i].call(node4, t);
    }
    if (self.state === ENDING) {
      self.on.call("end", node4, node4.__data__, self.index, self.group);
      stop();
    }
  }
  function stop() {
    self.state = ENDED;
    self.timer.stop();
    delete schedules[id2];
    for (var i in schedules) return;
    delete node4.__transition;
  }
}

// node_modules/d3-transition/src/interrupt.js
function interrupt_default(node4, name2) {
  var schedules = node4.__transition, schedule, active, empty3 = true, i;
  if (!schedules) return;
  name2 = name2 == null ? null : name2 + "";
  for (i in schedules) {
    if ((schedule = schedules[i]).name !== name2) {
      empty3 = false;
      continue;
    }
    active = schedule.state > STARTING && schedule.state < ENDING;
    schedule.state = ENDED;
    schedule.timer.stop();
    schedule.on.call(active ? "interrupt" : "cancel", node4, node4.__data__, schedule.index, schedule.group);
    delete schedules[i];
  }
  if (empty3) delete node4.__transition;
}

// node_modules/d3-transition/src/selection/interrupt.js
function interrupt_default2(name2) {
  return this.each(function() {
    interrupt_default(this, name2);
  });
}

// node_modules/d3-interpolate/src/basis.js
function basis(t13, v0, v1, v2, v3) {
  var t22 = t13 * t13, t32 = t22 * t13;
  return ((1 - 3 * t13 + 3 * t22 - t32) * v0 + (4 - 6 * t22 + 3 * t32) * v1 + (1 + 3 * t13 + 3 * t22 - 3 * t32) * v2 + t32 * v3) / 6;
}
function basis_default(values) {
  var n = values.length - 1;
  return function(t) {
    var i = t <= 0 ? t = 0 : t >= 1 ? (t = 1, n - 1) : Math.floor(t * n), v1 = values[i], v2 = values[i + 1], v0 = i > 0 ? values[i - 1] : 2 * v1 - v2, v3 = i < n - 1 ? values[i + 2] : 2 * v2 - v1;
    return basis((t - i / n) * n, v0, v1, v2, v3);
  };
}

// node_modules/d3-interpolate/src/basisClosed.js
function basisClosed_default(values) {
  var n = values.length;
  return function(t) {
    var i = Math.floor(((t %= 1) < 0 ? ++t : t) * n), v0 = values[(i + n - 1) % n], v1 = values[i % n], v2 = values[(i + 1) % n], v3 = values[(i + 2) % n];
    return basis((t - i / n) * n, v0, v1, v2, v3);
  };
}

// node_modules/d3-interpolate/src/constant.js
var constant_default2 = (x3) => () => x3;

// node_modules/d3-interpolate/src/color.js
function linear(a4, d) {
  return function(t) {
    return a4 + t * d;
  };
}
function exponential(a4, b, y3) {
  return a4 = Math.pow(a4, y3), b = Math.pow(b, y3) - a4, y3 = 1 / y3, function(t) {
    return Math.pow(a4 + t * b, y3);
  };
}
function hue(a4, b) {
  var d = b - a4;
  return d ? linear(a4, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : constant_default2(isNaN(a4) ? b : a4);
}
function gamma(y3) {
  return (y3 = +y3) === 1 ? nogamma : function(a4, b) {
    return b - a4 ? exponential(a4, b, y3) : constant_default2(isNaN(a4) ? b : a4);
  };
}
function nogamma(a4, b) {
  var d = b - a4;
  return d ? linear(a4, d) : constant_default2(isNaN(a4) ? b : a4);
}

// node_modules/d3-interpolate/src/rgb.js
var rgb_default = function rgbGamma(y3) {
  var color2 = gamma(y3);
  function rgb2(start2, end) {
    var r = color2((start2 = rgb(start2)).r, (end = rgb(end)).r), g = color2(start2.g, end.g), b = color2(start2.b, end.b), opacity = nogamma(start2.opacity, end.opacity);
    return function(t) {
      start2.r = r(t);
      start2.g = g(t);
      start2.b = b(t);
      start2.opacity = opacity(t);
      return start2 + "";
    };
  }
  rgb2.gamma = rgbGamma;
  return rgb2;
}(1);
function rgbSpline(spline) {
  return function(colors2) {
    var n = colors2.length, r = new Array(n), g = new Array(n), b = new Array(n), i, color2;
    for (i = 0; i < n; ++i) {
      color2 = rgb(colors2[i]);
      r[i] = color2.r || 0;
      g[i] = color2.g || 0;
      b[i] = color2.b || 0;
    }
    r = spline(r);
    g = spline(g);
    b = spline(b);
    color2.opacity = 1;
    return function(t) {
      color2.r = r(t);
      color2.g = g(t);
      color2.b = b(t);
      return color2 + "";
    };
  };
}
var rgbBasis = rgbSpline(basis_default);
var rgbBasisClosed = rgbSpline(basisClosed_default);

// node_modules/d3-interpolate/src/numberArray.js
function numberArray_default(a4, b) {
  if (!b) b = [];
  var n = a4 ? Math.min(b.length, a4.length) : 0, c3 = b.slice(), i;
  return function(t) {
    for (i = 0; i < n; ++i) c3[i] = a4[i] * (1 - t) + b[i] * t;
    return c3;
  };
}
function isNumberArray(x3) {
  return ArrayBuffer.isView(x3) && !(x3 instanceof DataView);
}

// node_modules/d3-interpolate/src/array.js
function genericArray(a4, b) {
  var nb = b ? b.length : 0, na = a4 ? Math.min(nb, a4.length) : 0, x3 = new Array(na), c3 = new Array(nb), i;
  for (i = 0; i < na; ++i) x3[i] = value_default(a4[i], b[i]);
  for (; i < nb; ++i) c3[i] = b[i];
  return function(t) {
    for (i = 0; i < na; ++i) c3[i] = x3[i](t);
    return c3;
  };
}

// node_modules/d3-interpolate/src/date.js
function date_default(a4, b) {
  var d = /* @__PURE__ */ new Date();
  return a4 = +a4, b = +b, function(t) {
    return d.setTime(a4 * (1 - t) + b * t), d;
  };
}

// node_modules/d3-interpolate/src/number.js
function number_default(a4, b) {
  return a4 = +a4, b = +b, function(t) {
    return a4 * (1 - t) + b * t;
  };
}

// node_modules/d3-interpolate/src/object.js
function object_default(a4, b) {
  var i = {}, c3 = {}, k4;
  if (a4 === null || typeof a4 !== "object") a4 = {};
  if (b === null || typeof b !== "object") b = {};
  for (k4 in b) {
    if (k4 in a4) {
      i[k4] = value_default(a4[k4], b[k4]);
    } else {
      c3[k4] = b[k4];
    }
  }
  return function(t) {
    for (k4 in i) c3[k4] = i[k4](t);
    return c3;
  };
}

// node_modules/d3-interpolate/src/string.js
var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g;
var reB = new RegExp(reA.source, "g");
function zero(b) {
  return function() {
    return b;
  };
}
function one(b) {
  return function(t) {
    return b(t) + "";
  };
}
function string_default(a4, b) {
  var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i = -1, s3 = [], q = [];
  a4 = a4 + "", b = b + "";
  while ((am = reA.exec(a4)) && (bm = reB.exec(b))) {
    if ((bs = bm.index) > bi) {
      bs = b.slice(bi, bs);
      if (s3[i]) s3[i] += bs;
      else s3[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) {
      if (s3[i]) s3[i] += bm;
      else s3[++i] = bm;
    } else {
      s3[++i] = null;
      q.push({ i, x: number_default(am, bm) });
    }
    bi = reB.lastIndex;
  }
  if (bi < b.length) {
    bs = b.slice(bi);
    if (s3[i]) s3[i] += bs;
    else s3[++i] = bs;
  }
  return s3.length < 2 ? q[0] ? one(q[0].x) : zero(b) : (b = q.length, function(t) {
    for (var i2 = 0, o; i2 < b; ++i2) s3[(o = q[i2]).i] = o.x(t);
    return s3.join("");
  });
}

// node_modules/d3-interpolate/src/value.js
function value_default(a4, b) {
  var t = typeof b, c3;
  return b == null || t === "boolean" ? constant_default2(b) : (t === "number" ? number_default : t === "string" ? (c3 = color(b)) ? (b = c3, rgb_default) : string_default : b instanceof color ? rgb_default : b instanceof Date ? date_default : isNumberArray(b) ? numberArray_default : Array.isArray(b) ? genericArray : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object_default : number_default)(a4, b);
}

// node_modules/d3-interpolate/src/round.js
function round_default(a4, b) {
  return a4 = +a4, b = +b, function(t) {
    return Math.round(a4 * (1 - t) + b * t);
  };
}

// node_modules/d3-interpolate/src/transform/decompose.js
var degrees2 = 180 / Math.PI;
var identity = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1
};
function decompose_default(a4, b, c3, d, e, f) {
  var scaleX, scaleY, skewX;
  if (scaleX = Math.sqrt(a4 * a4 + b * b)) a4 /= scaleX, b /= scaleX;
  if (skewX = a4 * c3 + b * d) c3 -= a4 * skewX, d -= b * skewX;
  if (scaleY = Math.sqrt(c3 * c3 + d * d)) c3 /= scaleY, d /= scaleY, skewX /= scaleY;
  if (a4 * d < b * c3) a4 = -a4, b = -b, skewX = -skewX, scaleX = -scaleX;
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b, a4) * degrees2,
    skewX: Math.atan(skewX) * degrees2,
    scaleX,
    scaleY
  };
}

// node_modules/d3-interpolate/src/transform/parse.js
var svgNode;
function parseCss(value2) {
  const m2 = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value2 + "");
  return m2.isIdentity ? identity : decompose_default(m2.a, m2.b, m2.c, m2.d, m2.e, m2.f);
}
function parseSvg(value2) {
  if (value2 == null) return identity;
  if (!svgNode) svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value2);
  if (!(value2 = svgNode.transform.baseVal.consolidate())) return identity;
  value2 = value2.matrix;
  return decompose_default(value2.a, value2.b, value2.c, value2.d, value2.e, value2.f);
}

// node_modules/d3-interpolate/src/transform/index.js
function interpolateTransform(parse, pxComma, pxParen, degParen) {
  function pop(s3) {
    return s3.length ? s3.pop() + " " : "";
  }
  function translate(xa, ya, xb, yb, s3, q) {
    if (xa !== xb || ya !== yb) {
      var i = s3.push("translate(", null, pxComma, null, pxParen);
      q.push({ i: i - 4, x: number_default(xa, xb) }, { i: i - 2, x: number_default(ya, yb) });
    } else if (xb || yb) {
      s3.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }
  function rotate(a4, b, s3, q) {
    if (a4 !== b) {
      if (a4 - b > 180) b += 360;
      else if (b - a4 > 180) a4 += 360;
      q.push({ i: s3.push(pop(s3) + "rotate(", null, degParen) - 2, x: number_default(a4, b) });
    } else if (b) {
      s3.push(pop(s3) + "rotate(" + b + degParen);
    }
  }
  function skewX(a4, b, s3, q) {
    if (a4 !== b) {
      q.push({ i: s3.push(pop(s3) + "skewX(", null, degParen) - 2, x: number_default(a4, b) });
    } else if (b) {
      s3.push(pop(s3) + "skewX(" + b + degParen);
    }
  }
  function scale(xa, ya, xb, yb, s3, q) {
    if (xa !== xb || ya !== yb) {
      var i = s3.push(pop(s3) + "scale(", null, ",", null, ")");
      q.push({ i: i - 4, x: number_default(xa, xb) }, { i: i - 2, x: number_default(ya, yb) });
    } else if (xb !== 1 || yb !== 1) {
      s3.push(pop(s3) + "scale(" + xb + "," + yb + ")");
    }
  }
  return function(a4, b) {
    var s3 = [], q = [];
    a4 = parse(a4), b = parse(b);
    translate(a4.translateX, a4.translateY, b.translateX, b.translateY, s3, q);
    rotate(a4.rotate, b.rotate, s3, q);
    skewX(a4.skewX, b.skewX, s3, q);
    scale(a4.scaleX, a4.scaleY, b.scaleX, b.scaleY, s3, q);
    a4 = b = null;
    return function(t) {
      var i = -1, n = q.length, o;
      while (++i < n) s3[(o = q[i]).i] = o.x(t);
      return s3.join("");
    };
  };
}
var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");

// node_modules/d3-interpolate/src/zoom.js
var epsilon2 = 1e-12;
function cosh(x3) {
  return ((x3 = Math.exp(x3)) + 1 / x3) / 2;
}
function sinh(x3) {
  return ((x3 = Math.exp(x3)) - 1 / x3) / 2;
}
function tanh(x3) {
  return ((x3 = Math.exp(2 * x3)) - 1) / (x3 + 1);
}
var zoom_default = function zoomRho(rho, rho2, rho4) {
  function zoom(p0, p1) {
    var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S;
    if (d2 < epsilon2) {
      S = Math.log(w1 / w0) / rho;
      i = function(t) {
        return [
          ux0 + t * dx,
          uy0 + t * dy,
          w0 * Math.exp(rho * t * S)
        ];
      };
    } else {
      var d1 = Math.sqrt(d2), b02 = (w1 * w1 - w0 * w0 + rho4 * d2) / (2 * w0 * rho2 * d1), b12 = (w1 * w1 - w0 * w0 - rho4 * d2) / (2 * w1 * rho2 * d1), r0 = Math.log(Math.sqrt(b02 * b02 + 1) - b02), r1 = Math.log(Math.sqrt(b12 * b12 + 1) - b12);
      S = (r1 - r0) / rho;
      i = function(t) {
        var s3 = t * S, coshr0 = cosh(r0), u = w0 / (rho2 * d1) * (coshr0 * tanh(rho * s3 + r0) - sinh(r0));
        return [
          ux0 + u * dx,
          uy0 + u * dy,
          w0 * coshr0 / cosh(rho * s3 + r0)
        ];
      };
    }
    i.duration = S * 1e3 * rho / Math.SQRT2;
    return i;
  }
  zoom.rho = function(_) {
    var _1 = Math.max(1e-3, +_), _2 = _1 * _1, _4 = _2 * _2;
    return zoomRho(_1, _2, _4);
  };
  return zoom;
}(Math.SQRT2, 2, 4);

// node_modules/d3-interpolate/src/hsl.js
function hsl2(hue2) {
  return function(start2, end) {
    var h = hue2((start2 = hsl(start2)).h, (end = hsl(end)).h), s3 = nogamma(start2.s, end.s), l = nogamma(start2.l, end.l), opacity = nogamma(start2.opacity, end.opacity);
    return function(t) {
      start2.h = h(t);
      start2.s = s3(t);
      start2.l = l(t);
      start2.opacity = opacity(t);
      return start2 + "";
    };
  };
}
var hsl_default = hsl2(hue);
var hslLong = hsl2(nogamma);

// node_modules/d3-interpolate/src/hcl.js
function hcl2(hue2) {
  return function(start2, end) {
    var h = hue2((start2 = hcl(start2)).h, (end = hcl(end)).h), c3 = nogamma(start2.c, end.c), l = nogamma(start2.l, end.l), opacity = nogamma(start2.opacity, end.opacity);
    return function(t) {
      start2.h = h(t);
      start2.c = c3(t);
      start2.l = l(t);
      start2.opacity = opacity(t);
      return start2 + "";
    };
  };
}
var hcl_default = hcl2(hue);
var hclLong = hcl2(nogamma);

// node_modules/d3-interpolate/src/cubehelix.js
function cubehelix2(hue2) {
  return function cubehelixGamma(y3) {
    y3 = +y3;
    function cubehelix3(start2, end) {
      var h = hue2((start2 = cubehelix(start2)).h, (end = cubehelix(end)).h), s3 = nogamma(start2.s, end.s), l = nogamma(start2.l, end.l), opacity = nogamma(start2.opacity, end.opacity);
      return function(t) {
        start2.h = h(t);
        start2.s = s3(t);
        start2.l = l(Math.pow(t, y3));
        start2.opacity = opacity(t);
        return start2 + "";
      };
    }
    cubehelix3.gamma = cubehelixGamma;
    return cubehelix3;
  }(1);
}
var cubehelix_default = cubehelix2(hue);
var cubehelixLong = cubehelix2(nogamma);

// node_modules/d3-interpolate/src/piecewise.js
function piecewise(interpolate, values) {
  if (values === void 0) values = interpolate, interpolate = value_default;
  var i = 0, n = values.length - 1, v = values[0], I = new Array(n < 0 ? 0 : n);
  while (i < n) I[i] = interpolate(v, v = values[++i]);
  return function(t) {
    var i2 = Math.max(0, Math.min(n - 1, Math.floor(t *= n)));
    return I[i2](t - i2);
  };
}

// node_modules/d3-transition/src/transition/tween.js
function tweenRemove(id2, name2) {
  var tween0, tween1;
  return function() {
    var schedule = set(this, id2), tween = schedule.tween;
    if (tween !== tween0) {
      tween1 = tween0 = tween;
      for (var i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name2) {
          tween1 = tween1.slice();
          tween1.splice(i, 1);
          break;
        }
      }
    }
    schedule.tween = tween1;
  };
}
function tweenFunction(id2, name2, value2) {
  var tween0, tween1;
  if (typeof value2 !== "function") throw new Error();
  return function() {
    var schedule = set(this, id2), tween = schedule.tween;
    if (tween !== tween0) {
      tween1 = (tween0 = tween).slice();
      for (var t = { name: name2, value: value2 }, i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name2) {
          tween1[i] = t;
          break;
        }
      }
      if (i === n) tween1.push(t);
    }
    schedule.tween = tween1;
  };
}
function tween_default(name2, value2) {
  var id2 = this._id;
  name2 += "";
  if (arguments.length < 2) {
    var tween = get(this.node(), id2).tween;
    for (var i = 0, n = tween.length, t; i < n; ++i) {
      if ((t = tween[i]).name === name2) {
        return t.value;
      }
    }
    return null;
  }
  return this.each((value2 == null ? tweenRemove : tweenFunction)(id2, name2, value2));
}
function tweenValue(transition2, name2, value2) {
  var id2 = transition2._id;
  transition2.each(function() {
    var schedule = set(this, id2);
    (schedule.value || (schedule.value = {}))[name2] = value2.apply(this, arguments);
  });
  return function(node4) {
    return get(node4, id2).value[name2];
  };
}

// node_modules/d3-transition/src/transition/interpolate.js
function interpolate_default(a4, b) {
  var c3;
  return (typeof b === "number" ? number_default : b instanceof color ? rgb_default : (c3 = color(b)) ? (b = c3, rgb_default) : string_default)(a4, b);
}

// node_modules/d3-transition/src/transition/attr.js
function attrRemove2(name2) {
  return function() {
    this.removeAttribute(name2);
  };
}
function attrRemoveNS2(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant2(name2, interpolate, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttribute(name2);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate(string00 = string0, value1);
  };
}
function attrConstantNS2(fullname, interpolate, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttributeNS(fullname.space, fullname.local);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate(string00 = string0, value1);
  };
}
function attrFunction2(name2, interpolate, value2) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value2(this), string1;
    if (value1 == null) return void this.removeAttribute(name2);
    string0 = this.getAttribute(name2);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate(string00 = string0, value1));
  };
}
function attrFunctionNS2(fullname, interpolate, value2) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value2(this), string1;
    if (value1 == null) return void this.removeAttributeNS(fullname.space, fullname.local);
    string0 = this.getAttributeNS(fullname.space, fullname.local);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate(string00 = string0, value1));
  };
}
function attr_default2(name2, value2) {
  var fullname = namespace_default(name2), i = fullname === "transform" ? interpolateTransformSvg : interpolate_default;
  return this.attrTween(name2, typeof value2 === "function" ? (fullname.local ? attrFunctionNS2 : attrFunction2)(fullname, i, tweenValue(this, "attr." + name2, value2)) : value2 == null ? (fullname.local ? attrRemoveNS2 : attrRemove2)(fullname) : (fullname.local ? attrConstantNS2 : attrConstant2)(fullname, i, value2));
}

// node_modules/d3-transition/src/transition/attrTween.js
function attrInterpolate(name2, i) {
  return function(t) {
    this.setAttribute(name2, i.call(this, t));
  };
}
function attrInterpolateNS(fullname, i) {
  return function(t) {
    this.setAttributeNS(fullname.space, fullname.local, i.call(this, t));
  };
}
function attrTweenNS(fullname, value2) {
  var t03, i0;
  function tween() {
    var i = value2.apply(this, arguments);
    if (i !== i0) t03 = (i0 = i) && attrInterpolateNS(fullname, i);
    return t03;
  }
  tween._value = value2;
  return tween;
}
function attrTween(name2, value2) {
  var t03, i0;
  function tween() {
    var i = value2.apply(this, arguments);
    if (i !== i0) t03 = (i0 = i) && attrInterpolate(name2, i);
    return t03;
  }
  tween._value = value2;
  return tween;
}
function attrTween_default(name2, value2) {
  var key = "attr." + name2;
  if (arguments.length < 2) return (key = this.tween(key)) && key._value;
  if (value2 == null) return this.tween(key, null);
  if (typeof value2 !== "function") throw new Error();
  var fullname = namespace_default(name2);
  return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value2));
}

// node_modules/d3-transition/src/transition/delay.js
function delayFunction(id2, value2) {
  return function() {
    init(this, id2).delay = +value2.apply(this, arguments);
  };
}
function delayConstant(id2, value2) {
  return value2 = +value2, function() {
    init(this, id2).delay = value2;
  };
}
function delay_default(value2) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value2 === "function" ? delayFunction : delayConstant)(id2, value2)) : get(this.node(), id2).delay;
}

// node_modules/d3-transition/src/transition/duration.js
function durationFunction(id2, value2) {
  return function() {
    set(this, id2).duration = +value2.apply(this, arguments);
  };
}
function durationConstant(id2, value2) {
  return value2 = +value2, function() {
    set(this, id2).duration = value2;
  };
}
function duration_default(value2) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value2 === "function" ? durationFunction : durationConstant)(id2, value2)) : get(this.node(), id2).duration;
}

// node_modules/d3-transition/src/transition/ease.js
function easeConstant(id2, value2) {
  if (typeof value2 !== "function") throw new Error();
  return function() {
    set(this, id2).ease = value2;
  };
}
function ease_default(value2) {
  var id2 = this._id;
  return arguments.length ? this.each(easeConstant(id2, value2)) : get(this.node(), id2).ease;
}

// node_modules/d3-transition/src/transition/easeVarying.js
function easeVarying(id2, value2) {
  return function() {
    var v = value2.apply(this, arguments);
    if (typeof v !== "function") throw new Error();
    set(this, id2).ease = v;
  };
}
function easeVarying_default(value2) {
  if (typeof value2 !== "function") throw new Error();
  return this.each(easeVarying(this._id, value2));
}

// node_modules/d3-transition/src/transition/filter.js
function filter_default2(match) {
  if (typeof match !== "function") match = matcher_default(match);
  for (var groups2 = this._groups, m2 = groups2.length, subgroups = new Array(m2), j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, subgroup = subgroups[j] = [], node4, i = 0; i < n; ++i) {
      if ((node4 = group3[i]) && match.call(node4, node4.__data__, i, group3)) {
        subgroup.push(node4);
      }
    }
  }
  return new Transition(subgroups, this._parents, this._name, this._id);
}

// node_modules/d3-transition/src/transition/merge.js
function merge_default2(transition2) {
  if (transition2._id !== this._id) throw new Error();
  for (var groups0 = this._groups, groups1 = transition2._groups, m0 = groups0.length, m1 = groups1.length, m2 = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m2; ++j) {
    for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge4 = merges[j] = new Array(n), node4, i = 0; i < n; ++i) {
      if (node4 = group0[i] || group1[i]) {
        merge4[i] = node4;
      }
    }
  }
  for (; j < m0; ++j) {
    merges[j] = groups0[j];
  }
  return new Transition(merges, this._parents, this._name, this._id);
}

// node_modules/d3-transition/src/transition/on.js
function start(name2) {
  return (name2 + "").trim().split(/^|\s+/).every(function(t) {
    var i = t.indexOf(".");
    if (i >= 0) t = t.slice(0, i);
    return !t || t === "start";
  });
}
function onFunction(id2, name2, listener) {
  var on0, on1, sit = start(name2) ? init : set;
  return function() {
    var schedule = sit(this, id2), on = schedule.on;
    if (on !== on0) (on1 = (on0 = on).copy()).on(name2, listener);
    schedule.on = on1;
  };
}
function on_default2(name2, listener) {
  var id2 = this._id;
  return arguments.length < 2 ? get(this.node(), id2).on.on(name2) : this.each(onFunction(id2, name2, listener));
}

// node_modules/d3-transition/src/transition/remove.js
function removeFunction(id2) {
  return function() {
    var parent = this.parentNode;
    for (var i in this.__transition) if (+i !== id2) return;
    if (parent) parent.removeChild(this);
  };
}
function remove_default2() {
  return this.on("end.remove", removeFunction(this._id));
}

// node_modules/d3-transition/src/transition/select.js
function select_default3(select2) {
  var name2 = this._name, id2 = this._id;
  if (typeof select2 !== "function") select2 = selector_default(select2);
  for (var groups2 = this._groups, m2 = groups2.length, subgroups = new Array(m2), j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, subgroup = subgroups[j] = new Array(n), node4, subnode, i = 0; i < n; ++i) {
      if ((node4 = group3[i]) && (subnode = select2.call(node4, node4.__data__, i, group3))) {
        if ("__data__" in node4) subnode.__data__ = node4.__data__;
        subgroup[i] = subnode;
        schedule_default(subgroup[i], name2, id2, i, subgroup, get(node4, id2));
      }
    }
  }
  return new Transition(subgroups, this._parents, name2, id2);
}

// node_modules/d3-transition/src/transition/selectAll.js
function selectAll_default3(select2) {
  var name2 = this._name, id2 = this._id;
  if (typeof select2 !== "function") select2 = selectorAll_default(select2);
  for (var groups2 = this._groups, m2 = groups2.length, subgroups = [], parents = [], j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, node4, i = 0; i < n; ++i) {
      if (node4 = group3[i]) {
        for (var children2 = select2.call(node4, node4.__data__, i, group3), child, inherit2 = get(node4, id2), k4 = 0, l = children2.length; k4 < l; ++k4) {
          if (child = children2[k4]) {
            schedule_default(child, name2, id2, k4, children2, inherit2);
          }
        }
        subgroups.push(children2);
        parents.push(node4);
      }
    }
  }
  return new Transition(subgroups, parents, name2, id2);
}

// node_modules/d3-transition/src/transition/selection.js
var Selection2 = selection_default.prototype.constructor;
function selection_default2() {
  return new Selection2(this._groups, this._parents);
}

// node_modules/d3-transition/src/transition/style.js
function styleNull(name2, interpolate) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name2), string1 = (this.style.removeProperty(name2), styleValue(this, name2));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate(string00 = string0, string10 = string1);
  };
}
function styleRemove2(name2) {
  return function() {
    this.style.removeProperty(name2);
  };
}
function styleConstant2(name2, interpolate, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = styleValue(this, name2);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate(string00 = string0, value1);
  };
}
function styleFunction2(name2, interpolate, value2) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name2), value1 = value2(this), string1 = value1 + "";
    if (value1 == null) string1 = value1 = (this.style.removeProperty(name2), styleValue(this, name2));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate(string00 = string0, value1));
  };
}
function styleMaybeRemove(id2, name2) {
  var on0, on1, listener0, key = "style." + name2, event = "end." + key, remove2;
  return function() {
    var schedule = set(this, id2), on = schedule.on, listener = schedule.value[key] == null ? remove2 || (remove2 = styleRemove2(name2)) : void 0;
    if (on !== on0 || listener0 !== listener) (on1 = (on0 = on).copy()).on(event, listener0 = listener);
    schedule.on = on1;
  };
}
function style_default2(name2, value2, priority) {
  var i = (name2 += "") === "transform" ? interpolateTransformCss : interpolate_default;
  return value2 == null ? this.styleTween(name2, styleNull(name2, i)).on("end.style." + name2, styleRemove2(name2)) : typeof value2 === "function" ? this.styleTween(name2, styleFunction2(name2, i, tweenValue(this, "style." + name2, value2))).each(styleMaybeRemove(this._id, name2)) : this.styleTween(name2, styleConstant2(name2, i, value2), priority).on("end.style." + name2, null);
}

// node_modules/d3-transition/src/transition/styleTween.js
function styleInterpolate(name2, i, priority) {
  return function(t) {
    this.style.setProperty(name2, i.call(this, t), priority);
  };
}
function styleTween(name2, value2, priority) {
  var t, i0;
  function tween() {
    var i = value2.apply(this, arguments);
    if (i !== i0) t = (i0 = i) && styleInterpolate(name2, i, priority);
    return t;
  }
  tween._value = value2;
  return tween;
}
function styleTween_default(name2, value2, priority) {
  var key = "style." + (name2 += "");
  if (arguments.length < 2) return (key = this.tween(key)) && key._value;
  if (value2 == null) return this.tween(key, null);
  if (typeof value2 !== "function") throw new Error();
  return this.tween(key, styleTween(name2, value2, priority == null ? "" : priority));
}

// node_modules/d3-transition/src/transition/text.js
function textConstant2(value2) {
  return function() {
    this.textContent = value2;
  };
}
function textFunction2(value2) {
  return function() {
    var value1 = value2(this);
    this.textContent = value1 == null ? "" : value1;
  };
}
function text_default2(value2) {
  return this.tween("text", typeof value2 === "function" ? textFunction2(tweenValue(this, "text", value2)) : textConstant2(value2 == null ? "" : value2 + ""));
}

// node_modules/d3-transition/src/transition/textTween.js
function textInterpolate(i) {
  return function(t) {
    this.textContent = i.call(this, t);
  };
}
function textTween(value2) {
  var t03, i0;
  function tween() {
    var i = value2.apply(this, arguments);
    if (i !== i0) t03 = (i0 = i) && textInterpolate(i);
    return t03;
  }
  tween._value = value2;
  return tween;
}
function textTween_default(value2) {
  var key = "text";
  if (arguments.length < 1) return (key = this.tween(key)) && key._value;
  if (value2 == null) return this.tween(key, null);
  if (typeof value2 !== "function") throw new Error();
  return this.tween(key, textTween(value2));
}

// node_modules/d3-transition/src/transition/transition.js
function transition_default() {
  var name2 = this._name, id0 = this._id, id1 = newId();
  for (var groups2 = this._groups, m2 = groups2.length, j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, node4, i = 0; i < n; ++i) {
      if (node4 = group3[i]) {
        var inherit2 = get(node4, id0);
        schedule_default(node4, name2, id1, i, group3, {
          time: inherit2.time + inherit2.delay + inherit2.duration,
          delay: 0,
          duration: inherit2.duration,
          ease: inherit2.ease
        });
      }
    }
  }
  return new Transition(groups2, this._parents, name2, id1);
}

// node_modules/d3-transition/src/transition/end.js
function end_default() {
  var on0, on1, that = this, id2 = that._id, size2 = that.size();
  return new Promise(function(resolve, reject) {
    var cancel = { value: reject }, end = { value: function() {
      if (--size2 === 0) resolve();
    } };
    that.each(function() {
      var schedule = set(this, id2), on = schedule.on;
      if (on !== on0) {
        on1 = (on0 = on).copy();
        on1._.cancel.push(cancel);
        on1._.interrupt.push(cancel);
        on1._.end.push(end);
      }
      schedule.on = on1;
    });
    if (size2 === 0) resolve();
  });
}

// node_modules/d3-transition/src/transition/index.js
var id = 0;
function Transition(groups2, parents, name2, id2) {
  this._groups = groups2;
  this._parents = parents;
  this._name = name2;
  this._id = id2;
}
function transition(name2) {
  return selection_default().transition(name2);
}
function newId() {
  return ++id;
}
var selection_prototype = selection_default.prototype;
Transition.prototype = transition.prototype = {
  constructor: Transition,
  select: select_default3,
  selectAll: selectAll_default3,
  selectChild: selection_prototype.selectChild,
  selectChildren: selection_prototype.selectChildren,
  filter: filter_default2,
  merge: merge_default2,
  selection: selection_default2,
  transition: transition_default,
  call: selection_prototype.call,
  nodes: selection_prototype.nodes,
  node: selection_prototype.node,
  size: selection_prototype.size,
  empty: selection_prototype.empty,
  each: selection_prototype.each,
  on: on_default2,
  attr: attr_default2,
  attrTween: attrTween_default,
  style: style_default2,
  styleTween: styleTween_default,
  text: text_default2,
  textTween: textTween_default,
  remove: remove_default2,
  tween: tween_default,
  delay: delay_default,
  duration: duration_default,
  ease: ease_default,
  easeVarying: easeVarying_default,
  end: end_default,
  [Symbol.iterator]: selection_prototype[Symbol.iterator]
};

// node_modules/d3-ease/src/linear.js
var linear2 = (t) => +t;

// node_modules/d3-ease/src/cubic.js
function cubicInOut(t) {
  return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
}

// node_modules/d3-ease/src/poly.js
var exponent = 3;
var polyIn = function custom(e) {
  e = +e;
  function polyIn2(t) {
    return Math.pow(t, e);
  }
  polyIn2.exponent = custom;
  return polyIn2;
}(exponent);
var polyOut = function custom2(e) {
  e = +e;
  function polyOut2(t) {
    return 1 - Math.pow(1 - t, e);
  }
  polyOut2.exponent = custom2;
  return polyOut2;
}(exponent);
var polyInOut = function custom3(e) {
  e = +e;
  function polyInOut2(t) {
    return ((t *= 2) <= 1 ? Math.pow(t, e) : 2 - Math.pow(2 - t, e)) / 2;
  }
  polyInOut2.exponent = custom3;
  return polyInOut2;
}(exponent);

// node_modules/d3-ease/src/sin.js
var pi = Math.PI;
var halfPi = pi / 2;

// node_modules/d3-ease/src/math.js
function tpmt(x3) {
  return (Math.pow(2, -10 * x3) - 9765625e-10) * 1.0009775171065494;
}

// node_modules/d3-ease/src/bounce.js
var b1 = 4 / 11;
var b2 = 6 / 11;
var b3 = 8 / 11;
var b4 = 3 / 4;
var b5 = 9 / 11;
var b6 = 10 / 11;
var b7 = 15 / 16;
var b8 = 21 / 22;
var b9 = 63 / 64;
var b0 = 1 / b1 / b1;

// node_modules/d3-ease/src/back.js
var overshoot = 1.70158;
var backIn = function custom4(s3) {
  s3 = +s3;
  function backIn2(t) {
    return (t = +t) * t * (s3 * (t - 1) + t);
  }
  backIn2.overshoot = custom4;
  return backIn2;
}(overshoot);
var backOut = function custom5(s3) {
  s3 = +s3;
  function backOut2(t) {
    return --t * t * ((t + 1) * s3 + t) + 1;
  }
  backOut2.overshoot = custom5;
  return backOut2;
}(overshoot);
var backInOut = function custom6(s3) {
  s3 = +s3;
  function backInOut2(t) {
    return ((t *= 2) < 1 ? t * t * ((s3 + 1) * t - s3) : (t -= 2) * t * ((s3 + 1) * t + s3) + 2) / 2;
  }
  backInOut2.overshoot = custom6;
  return backInOut2;
}(overshoot);

// node_modules/d3-ease/src/elastic.js
var tau = 2 * Math.PI;
var amplitude = 1;
var period = 0.3;
var elasticIn = function custom7(a4, p) {
  var s3 = Math.asin(1 / (a4 = Math.max(1, a4))) * (p /= tau);
  function elasticIn2(t) {
    return a4 * tpmt(- --t) * Math.sin((s3 - t) / p);
  }
  elasticIn2.amplitude = function(a5) {
    return custom7(a5, p * tau);
  };
  elasticIn2.period = function(p2) {
    return custom7(a4, p2);
  };
  return elasticIn2;
}(amplitude, period);
var elasticOut = function custom8(a4, p) {
  var s3 = Math.asin(1 / (a4 = Math.max(1, a4))) * (p /= tau);
  function elasticOut2(t) {
    return 1 - a4 * tpmt(t = +t) * Math.sin((t + s3) / p);
  }
  elasticOut2.amplitude = function(a5) {
    return custom8(a5, p * tau);
  };
  elasticOut2.period = function(p2) {
    return custom8(a4, p2);
  };
  return elasticOut2;
}(amplitude, period);
var elasticInOut = function custom9(a4, p) {
  var s3 = Math.asin(1 / (a4 = Math.max(1, a4))) * (p /= tau);
  function elasticInOut2(t) {
    return ((t = t * 2 - 1) < 0 ? a4 * tpmt(-t) * Math.sin((s3 - t) / p) : 2 - a4 * tpmt(t) * Math.sin((s3 + t) / p)) / 2;
  }
  elasticInOut2.amplitude = function(a5) {
    return custom9(a5, p * tau);
  };
  elasticInOut2.period = function(p2) {
    return custom9(a4, p2);
  };
  return elasticInOut2;
}(amplitude, period);

// node_modules/d3-transition/src/selection/transition.js
var defaultTiming = {
  time: null,
  // Set on use.
  delay: 0,
  duration: 250,
  ease: cubicInOut
};
function inherit(node4, id2) {
  var timing;
  while (!(timing = node4.__transition) || !(timing = timing[id2])) {
    if (!(node4 = node4.parentNode)) {
      throw new Error(`transition ${id2} not found`);
    }
  }
  return timing;
}
function transition_default2(name2) {
  var id2, timing;
  if (name2 instanceof Transition) {
    id2 = name2._id, name2 = name2._name;
  } else {
    id2 = newId(), (timing = defaultTiming).time = now(), name2 = name2 == null ? null : name2 + "";
  }
  for (var groups2 = this._groups, m2 = groups2.length, j = 0; j < m2; ++j) {
    for (var group3 = groups2[j], n = group3.length, node4, i = 0; i < n; ++i) {
      if (node4 = group3[i]) {
        schedule_default(node4, name2, id2, i, group3, timing || inherit(node4, id2));
      }
    }
  }
  return new Transition(groups2, this._parents, name2, id2);
}

// node_modules/d3-transition/src/selection/index.js
selection_default.prototype.interrupt = interrupt_default2;
selection_default.prototype.transition = transition_default2;

// node_modules/@unovis/ts/utils/d3.js
function smartTransition(selection2, duration, easing) {
  selection2.nodes().forEach((node4) => interrupt_default(node4));
  if (duration) {
    const transition2 = selection2.transition().duration(duration);
    if (easing)
      transition2.ease(easing);
    return transition2;
  } else
    return selection2;
}

// node_modules/@unovis/ts/containers/single-container/config.js
var SingleContainerDefaultConfig = Object.assign(Object.assign({}, ContainerDefaultConfig), { tooltip: void 0, annotations: void 0 });

// node_modules/@unovis/ts/containers/single-container/index.js
var SingleContainer = class extends ContainerCore {
  constructor(element, config, data) {
    var _a;
    super(element);
    this._defaultConfig = SingleContainerDefaultConfig;
    this.config = this._defaultConfig;
    if (config) {
      this.updateContainer(config, true);
      this.component = config.component;
    }
    if (data) {
      this.setData(data, true);
    }
    if ((_a = this.component) === null || _a === void 0 ? void 0 : _a.datamodel.data)
      this.render();
  }
  setData(data, preventRender) {
    var _a;
    const { config } = this;
    if (this.component)
      this.component.setData(data);
    if (!preventRender)
      this.render();
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.hide();
  }
  updateContainer(containerConfig, preventRender) {
    super.updateContainer(containerConfig);
    this._removeAllChildren();
    this.component = containerConfig.component;
    if (containerConfig.sizing)
      this.component.sizing = containerConfig.sizing;
    this.element.appendChild(this.component.element);
    const tooltip2 = containerConfig.tooltip;
    if (tooltip2) {
      if (!tooltip2.hasContainer())
        tooltip2.setContainer(this._container);
      tooltip2.setComponents([this.component]);
    }
    const annotations = containerConfig.annotations;
    if (annotations) {
      this.element.appendChild(annotations.element);
    }
    this.element.appendChild(this._svgDefs.node());
    this.element.appendChild(this._svgDefsExternal.node());
    if (!preventRender)
      this.render();
  }
  updateComponent(componentConfig, preventRender) {
    this.component.setConfig(componentConfig);
    if (!preventRender)
      this.render();
  }
  update(containerConfig, componentConfig, data) {
    if (containerConfig)
      this.updateContainer(containerConfig, true);
    if (componentConfig)
      this.updateComponent(componentConfig, true);
    if (data)
      this.setData(data, true);
    this.render();
  }
  getFitWidthScale() {
    const { config, component } = this;
    const extendedSizeComponent = component;
    if (!extendedSizeComponent.getWidth)
      return 1;
    const componentWidth = extendedSizeComponent.getWidth() + config.margin.left + config.margin.right;
    return this.width / componentWidth;
  }
  _preRender() {
    var _a;
    super._preRender();
    this.component.setSize(this.width, this.height, this.containerWidth, this.containerHeight);
    (_a = this.config.annotations) === null || _a === void 0 ? void 0 : _a.setSize(this.width, this.height, this.containerWidth, this.containerHeight);
  }
  _render(duration) {
    var _a;
    const { config, component } = this;
    super._render(duration);
    component.g.attr("transform", `translate(${config.margin.left},${config.margin.top})`);
    component.render(duration);
    (_a = config.annotations) === null || _a === void 0 ? void 0 : _a.render(duration);
    if (config.tooltip)
      config.tooltip.update();
  }
  // Re-defining the `render()` function to handle different sizing techniques (`Sizing.Extend` and `Sizing.FitWidth`)
  // Not calling `super.render()` because we don't want it to interfere with setting the SVG size here.
  render(duration = this.config.duration) {
    const { config, component } = this;
    if (config.sizing === Sizing.Extend || config.sizing === Sizing.FitWidth) {
      const fitToWidth = config.sizing === Sizing.FitWidth;
      const extendedSizeComponent = component;
      const componentWidth = extendedSizeComponent.getWidth() + config.margin.left + config.margin.right;
      const componentHeight = extendedSizeComponent.getHeight() + config.margin.top + config.margin.bottom;
      const scale = fitToWidth ? this.getFitWidthScale() : 1;
      const currentWidth = this.svg.attr("width");
      const currentHeight = this.svg.attr("height");
      const scaledWidth = componentWidth * scale;
      const scaledHeight = componentHeight * scale;
      const animated = currentWidth || currentHeight;
      smartTransition(this.svg, animated ? duration : 0).attr("width", scaledWidth).attr("height", scaledHeight).attr("viewBox", `${0} ${0} ${componentWidth} ${fitToWidth ? scaledHeight : componentHeight}`).attr("preserveAspectRatio", "xMinYMin");
    } else {
      this.svg.attr("width", this.config.width || this.containerWidth).attr("height", this.config.height || this.containerHeight);
    }
    if (!this._resizeObserver)
      this._setUpResizeObserver();
    cancelAnimationFrame(this._requestedAnimationFrame);
    this._requestedAnimationFrame = requestAnimationFrame(() => {
      this._preRender();
      this._render(duration);
    });
  }
  _onResize() {
    var _a;
    const { config } = this;
    super._onResize();
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.hide();
  }
  destroy() {
    var _a, _b;
    const { component, config } = this;
    super.destroy();
    component === null || component === void 0 ? void 0 : component.destroy();
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.destroy();
    (_b = config.annotations) === null || _b === void 0 ? void 0 : _b.destroy();
  }
};

// node_modules/@unovis/ts/data-models/core.js
var CoreDataModel = class {
  constructor(data) {
    this.data = data;
  }
  get data() {
    return this._data;
  }
  set data(value2) {
    this._data = value2;
  }
};

// node_modules/@unovis/ts/components/axis/types.js
var AxisType;
(function(AxisType2) {
  AxisType2["X"] = "x";
  AxisType2["Y"] = "y";
})(AxisType || (AxisType = {}));

// node_modules/d3-scale/src/init.js
function initRange(domain, range3) {
  switch (arguments.length) {
    case 0:
      break;
    case 1:
      this.range(domain);
      break;
    default:
      this.range(range3).domain(domain);
      break;
  }
  return this;
}
function initInterpolator(domain, interpolator) {
  switch (arguments.length) {
    case 0:
      break;
    case 1: {
      if (typeof domain === "function") this.interpolator(domain);
      else this.range(domain);
      break;
    }
    default: {
      this.domain(domain);
      if (typeof interpolator === "function") this.interpolator(interpolator);
      else this.range(interpolator);
      break;
    }
  }
  return this;
}

// node_modules/d3-scale/src/ordinal.js
var implicit = Symbol("implicit");
function ordinal() {
  var index3 = new InternMap(), domain = [], range3 = [], unknown = implicit;
  function scale(d) {
    let i = index3.get(d);
    if (i === void 0) {
      if (unknown !== implicit) return unknown;
      index3.set(d, i = domain.push(d) - 1);
    }
    return range3[i % range3.length];
  }
  scale.domain = function(_) {
    if (!arguments.length) return domain.slice();
    domain = [], index3 = new InternMap();
    for (const value2 of _) {
      if (index3.has(value2)) continue;
      index3.set(value2, domain.push(value2) - 1);
    }
    return scale;
  };
  scale.range = function(_) {
    return arguments.length ? (range3 = Array.from(_), scale) : range3.slice();
  };
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  scale.copy = function() {
    return ordinal(domain, range3).unknown(unknown);
  };
  initRange.apply(scale, arguments);
  return scale;
}

// node_modules/d3-scale/src/band.js
function band() {
  var scale = ordinal().unknown(void 0), domain = scale.domain, ordinalRange = scale.range, r0 = 0, r1 = 1, step, bandwidth, round2 = false, paddingInner = 0, paddingOuter = 0, align = 0.5;
  delete scale.unknown;
  function rescale() {
    var n = domain().length, reverse2 = r1 < r0, start2 = reverse2 ? r1 : r0, stop = reverse2 ? r0 : r1;
    step = (stop - start2) / Math.max(1, n - paddingInner + paddingOuter * 2);
    if (round2) step = Math.floor(step);
    start2 += (stop - start2 - step * (n - paddingInner)) * align;
    bandwidth = step * (1 - paddingInner);
    if (round2) start2 = Math.round(start2), bandwidth = Math.round(bandwidth);
    var values = range(n).map(function(i) {
      return start2 + step * i;
    });
    return ordinalRange(reverse2 ? values.reverse() : values);
  }
  scale.domain = function(_) {
    return arguments.length ? (domain(_), rescale()) : domain();
  };
  scale.range = function(_) {
    return arguments.length ? ([r0, r1] = _, r0 = +r0, r1 = +r1, rescale()) : [r0, r1];
  };
  scale.rangeRound = function(_) {
    return [r0, r1] = _, r0 = +r0, r1 = +r1, round2 = true, rescale();
  };
  scale.bandwidth = function() {
    return bandwidth;
  };
  scale.step = function() {
    return step;
  };
  scale.round = function(_) {
    return arguments.length ? (round2 = !!_, rescale()) : round2;
  };
  scale.padding = function(_) {
    return arguments.length ? (paddingInner = Math.min(1, paddingOuter = +_), rescale()) : paddingInner;
  };
  scale.paddingInner = function(_) {
    return arguments.length ? (paddingInner = Math.min(1, _), rescale()) : paddingInner;
  };
  scale.paddingOuter = function(_) {
    return arguments.length ? (paddingOuter = +_, rescale()) : paddingOuter;
  };
  scale.align = function(_) {
    return arguments.length ? (align = Math.max(0, Math.min(1, _)), rescale()) : align;
  };
  scale.copy = function() {
    return band(domain(), [r0, r1]).round(round2).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align);
  };
  return initRange.apply(rescale(), arguments);
}
function pointish(scale) {
  var copy3 = scale.copy;
  scale.padding = scale.paddingOuter;
  delete scale.paddingInner;
  delete scale.paddingOuter;
  scale.copy = function() {
    return pointish(copy3());
  };
  return scale;
}
function point() {
  return pointish(band.apply(null, arguments).paddingInner(1));
}

// node_modules/d3-scale/src/constant.js
function constants(x3) {
  return function() {
    return x3;
  };
}

// node_modules/d3-scale/src/number.js
function number(x3) {
  return +x3;
}

// node_modules/d3-scale/src/continuous.js
var unit = [0, 1];
function identity2(x3) {
  return x3;
}
function normalize(a4, b) {
  return (b -= a4 = +a4) ? function(x3) {
    return (x3 - a4) / b;
  } : constants(isNaN(b) ? NaN : 0.5);
}
function clamper(a4, b) {
  var t;
  if (a4 > b) t = a4, a4 = b, b = t;
  return function(x3) {
    return Math.max(a4, Math.min(b, x3));
  };
}
function bimap(domain, range3, interpolate) {
  var d0 = domain[0], d1 = domain[1], r0 = range3[0], r1 = range3[1];
  if (d1 < d0) d0 = normalize(d1, d0), r0 = interpolate(r1, r0);
  else d0 = normalize(d0, d1), r0 = interpolate(r0, r1);
  return function(x3) {
    return r0(d0(x3));
  };
}
function polymap(domain, range3, interpolate) {
  var j = Math.min(domain.length, range3.length) - 1, d = new Array(j), r = new Array(j), i = -1;
  if (domain[j] < domain[0]) {
    domain = domain.slice().reverse();
    range3 = range3.slice().reverse();
  }
  while (++i < j) {
    d[i] = normalize(domain[i], domain[i + 1]);
    r[i] = interpolate(range3[i], range3[i + 1]);
  }
  return function(x3) {
    var i2 = bisect_default(domain, x3, 1, j) - 1;
    return r[i2](d[i2](x3));
  };
}
function copy(source, target) {
  return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp()).unknown(source.unknown());
}
function transformer() {
  var domain = unit, range3 = unit, interpolate = value_default, transform2, untransform, unknown, clamp2 = identity2, piecewise2, output, input;
  function rescale() {
    var n = Math.min(domain.length, range3.length);
    if (clamp2 !== identity2) clamp2 = clamper(domain[0], domain[n - 1]);
    piecewise2 = n > 2 ? polymap : bimap;
    output = input = null;
    return scale;
  }
  function scale(x3) {
    return x3 == null || isNaN(x3 = +x3) ? unknown : (output || (output = piecewise2(domain.map(transform2), range3, interpolate)))(transform2(clamp2(x3)));
  }
  scale.invert = function(y3) {
    return clamp2(untransform((input || (input = piecewise2(range3, domain.map(transform2), number_default)))(y3)));
  };
  scale.domain = function(_) {
    return arguments.length ? (domain = Array.from(_, number), rescale()) : domain.slice();
  };
  scale.range = function(_) {
    return arguments.length ? (range3 = Array.from(_), rescale()) : range3.slice();
  };
  scale.rangeRound = function(_) {
    return range3 = Array.from(_), interpolate = round_default, rescale();
  };
  scale.clamp = function(_) {
    return arguments.length ? (clamp2 = _ ? true : identity2, rescale()) : clamp2 !== identity2;
  };
  scale.interpolate = function(_) {
    return arguments.length ? (interpolate = _, rescale()) : interpolate;
  };
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  return function(t, u) {
    transform2 = t, untransform = u;
    return rescale();
  };
}
function continuous() {
  return transformer()(identity2, identity2);
}

// node_modules/d3-format/src/formatDecimal.js
function formatDecimal_default(x3) {
  return Math.abs(x3 = Math.round(x3)) >= 1e21 ? x3.toLocaleString("en").replace(/,/g, "") : x3.toString(10);
}
function formatDecimalParts(x3, p) {
  if ((i = (x3 = p ? x3.toExponential(p - 1) : x3.toExponential()).indexOf("e")) < 0) return null;
  var i, coefficient = x3.slice(0, i);
  return [
    coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
    +x3.slice(i + 1)
  ];
}

// node_modules/d3-format/src/exponent.js
function exponent_default(x3) {
  return x3 = formatDecimalParts(Math.abs(x3)), x3 ? x3[1] : NaN;
}

// node_modules/d3-format/src/formatGroup.js
function formatGroup_default(grouping, thousands) {
  return function(value2, width) {
    var i = value2.length, t = [], j = 0, g = grouping[0], length = 0;
    while (i > 0 && g > 0) {
      if (length + g + 1 > width) g = Math.max(1, width - length);
      t.push(value2.substring(i -= g, i + g));
      if ((length += g + 1) > width) break;
      g = grouping[j = (j + 1) % grouping.length];
    }
    return t.reverse().join(thousands);
  };
}

// node_modules/d3-format/src/formatNumerals.js
function formatNumerals_default(numerals) {
  return function(value2) {
    return value2.replace(/[0-9]/g, function(i) {
      return numerals[+i];
    });
  };
}

// node_modules/d3-format/src/formatSpecifier.js
var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
function formatSpecifier(specifier) {
  if (!(match = re.exec(specifier))) throw new Error("invalid format: " + specifier);
  var match;
  return new FormatSpecifier({
    fill: match[1],
    align: match[2],
    sign: match[3],
    symbol: match[4],
    zero: match[5],
    width: match[6],
    comma: match[7],
    precision: match[8] && match[8].slice(1),
    trim: match[9],
    type: match[10]
  });
}
formatSpecifier.prototype = FormatSpecifier.prototype;
function FormatSpecifier(specifier) {
  this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
  this.align = specifier.align === void 0 ? ">" : specifier.align + "";
  this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
  this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
  this.zero = !!specifier.zero;
  this.width = specifier.width === void 0 ? void 0 : +specifier.width;
  this.comma = !!specifier.comma;
  this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
  this.trim = !!specifier.trim;
  this.type = specifier.type === void 0 ? "" : specifier.type + "";
}
FormatSpecifier.prototype.toString = function() {
  return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
};

// node_modules/d3-format/src/formatTrim.js
function formatTrim_default(s3) {
  out: for (var n = s3.length, i = 1, i0 = -1, i1; i < n; ++i) {
    switch (s3[i]) {
      case ".":
        i0 = i1 = i;
        break;
      case "0":
        if (i0 === 0) i0 = i;
        i1 = i;
        break;
      default:
        if (!+s3[i]) break out;
        if (i0 > 0) i0 = 0;
        break;
    }
  }
  return i0 > 0 ? s3.slice(0, i0) + s3.slice(i1 + 1) : s3;
}

// node_modules/d3-format/src/formatPrefixAuto.js
var prefixExponent;
function formatPrefixAuto_default(x3, p) {
  var d = formatDecimalParts(x3, p);
  if (!d) return x3 + "";
  var coefficient = d[0], exponent2 = d[1], i = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
  return i === n ? coefficient : i > n ? coefficient + new Array(i - n + 1).join("0") : i > 0 ? coefficient.slice(0, i) + "." + coefficient.slice(i) : "0." + new Array(1 - i).join("0") + formatDecimalParts(x3, Math.max(0, p + i - 1))[0];
}

// node_modules/d3-format/src/formatRounded.js
function formatRounded_default(x3, p) {
  var d = formatDecimalParts(x3, p);
  if (!d) return x3 + "";
  var coefficient = d[0], exponent2 = d[1];
  return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
}

// node_modules/d3-format/src/formatTypes.js
var formatTypes_default = {
  "%": (x3, p) => (x3 * 100).toFixed(p),
  "b": (x3) => Math.round(x3).toString(2),
  "c": (x3) => x3 + "",
  "d": formatDecimal_default,
  "e": (x3, p) => x3.toExponential(p),
  "f": (x3, p) => x3.toFixed(p),
  "g": (x3, p) => x3.toPrecision(p),
  "o": (x3) => Math.round(x3).toString(8),
  "p": (x3, p) => formatRounded_default(x3 * 100, p),
  "r": formatRounded_default,
  "s": formatPrefixAuto_default,
  "X": (x3) => Math.round(x3).toString(16).toUpperCase(),
  "x": (x3) => Math.round(x3).toString(16)
};

// node_modules/d3-format/src/identity.js
function identity_default(x3) {
  return x3;
}

// node_modules/d3-format/src/locale.js
var map = Array.prototype.map;
var prefixes = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
function locale_default(locale3) {
  var group3 = locale3.grouping === void 0 || locale3.thousands === void 0 ? identity_default : formatGroup_default(map.call(locale3.grouping, Number), locale3.thousands + ""), currencyPrefix = locale3.currency === void 0 ? "" : locale3.currency[0] + "", currencySuffix = locale3.currency === void 0 ? "" : locale3.currency[1] + "", decimal = locale3.decimal === void 0 ? "." : locale3.decimal + "", numerals = locale3.numerals === void 0 ? identity_default : formatNumerals_default(map.call(locale3.numerals, String)), percent = locale3.percent === void 0 ? "%" : locale3.percent + "", minus = locale3.minus === void 0 ? "−" : locale3.minus + "", nan = locale3.nan === void 0 ? "NaN" : locale3.nan + "";
  function newFormat(specifier) {
    specifier = formatSpecifier(specifier);
    var fill = specifier.fill, align = specifier.align, sign5 = specifier.sign, symbol = specifier.symbol, zero2 = specifier.zero, width = specifier.width, comma = specifier.comma, precision = specifier.precision, trim = specifier.trim, type2 = specifier.type;
    if (type2 === "n") comma = true, type2 = "g";
    else if (!formatTypes_default[type2]) precision === void 0 && (precision = 12), trim = true, type2 = "g";
    if (zero2 || fill === "0" && align === "=") zero2 = true, fill = "0", align = "=";
    var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
    var formatType = formatTypes_default[type2], maybeSuffix = /[defgprs%]/.test(type2);
    precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
    function format2(value2) {
      var valuePrefix = prefix, valueSuffix = suffix, i, n, c3;
      if (type2 === "c") {
        valueSuffix = formatType(value2) + valueSuffix;
        value2 = "";
      } else {
        value2 = +value2;
        var valueNegative = value2 < 0 || 1 / value2 < 0;
        value2 = isNaN(value2) ? nan : formatType(Math.abs(value2), precision);
        if (trim) value2 = formatTrim_default(value2);
        if (valueNegative && +value2 === 0 && sign5 !== "+") valueNegative = false;
        valuePrefix = (valueNegative ? sign5 === "(" ? sign5 : minus : sign5 === "-" || sign5 === "(" ? "" : sign5) + valuePrefix;
        valueSuffix = (type2 === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign5 === "(" ? ")" : "");
        if (maybeSuffix) {
          i = -1, n = value2.length;
          while (++i < n) {
            if (c3 = value2.charCodeAt(i), 48 > c3 || c3 > 57) {
              valueSuffix = (c3 === 46 ? decimal + value2.slice(i + 1) : value2.slice(i)) + valueSuffix;
              value2 = value2.slice(0, i);
              break;
            }
          }
        }
      }
      if (comma && !zero2) value2 = group3(value2, Infinity);
      var length = valuePrefix.length + value2.length + valueSuffix.length, padding = length < width ? new Array(width - length + 1).join(fill) : "";
      if (comma && zero2) value2 = group3(padding + value2, padding.length ? width - valueSuffix.length : Infinity), padding = "";
      switch (align) {
        case "<":
          value2 = valuePrefix + value2 + valueSuffix + padding;
          break;
        case "=":
          value2 = valuePrefix + padding + value2 + valueSuffix;
          break;
        case "^":
          value2 = padding.slice(0, length = padding.length >> 1) + valuePrefix + value2 + valueSuffix + padding.slice(length);
          break;
        default:
          value2 = padding + valuePrefix + value2 + valueSuffix;
          break;
      }
      return numerals(value2);
    }
    format2.toString = function() {
      return specifier + "";
    };
    return format2;
  }
  function formatPrefix2(specifier, value2) {
    var f = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent_default(value2) / 3))) * 3, k4 = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
    return function(value3) {
      return f(k4 * value3) + prefix;
    };
  }
  return {
    format: newFormat,
    formatPrefix: formatPrefix2
  };
}

// node_modules/d3-format/src/defaultLocale.js
var locale;
var format;
var formatPrefix;
defaultLocale({
  thousands: ",",
  grouping: [3],
  currency: ["$", ""]
});
function defaultLocale(definition) {
  locale = locale_default(definition);
  format = locale.format;
  formatPrefix = locale.formatPrefix;
  return locale;
}

// node_modules/d3-format/src/precisionFixed.js
function precisionFixed_default(step) {
  return Math.max(0, -exponent_default(Math.abs(step)));
}

// node_modules/d3-format/src/precisionPrefix.js
function precisionPrefix_default(step, value2) {
  return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent_default(value2) / 3))) * 3 - exponent_default(Math.abs(step)));
}

// node_modules/d3-format/src/precisionRound.js
function precisionRound_default(step, max8) {
  step = Math.abs(step), max8 = Math.abs(max8) - step;
  return Math.max(0, exponent_default(max8) - exponent_default(step)) + 1;
}

// node_modules/d3-scale/src/tickFormat.js
function tickFormat(start2, stop, count3, specifier) {
  var step = tickStep(start2, stop, count3), precision;
  specifier = formatSpecifier(specifier == null ? ",f" : specifier);
  switch (specifier.type) {
    case "s": {
      var value2 = Math.max(Math.abs(start2), Math.abs(stop));
      if (specifier.precision == null && !isNaN(precision = precisionPrefix_default(step, value2))) specifier.precision = precision;
      return formatPrefix(specifier, value2);
    }
    case "":
    case "e":
    case "g":
    case "p":
    case "r": {
      if (specifier.precision == null && !isNaN(precision = precisionRound_default(step, Math.max(Math.abs(start2), Math.abs(stop))))) specifier.precision = precision - (specifier.type === "e");
      break;
    }
    case "f":
    case "%": {
      if (specifier.precision == null && !isNaN(precision = precisionFixed_default(step))) specifier.precision = precision - (specifier.type === "%") * 2;
      break;
    }
  }
  return format(specifier);
}

// node_modules/d3-scale/src/linear.js
function linearish(scale) {
  var domain = scale.domain;
  scale.ticks = function(count3) {
    var d = domain();
    return ticks(d[0], d[d.length - 1], count3 == null ? 10 : count3);
  };
  scale.tickFormat = function(count3, specifier) {
    var d = domain();
    return tickFormat(d[0], d[d.length - 1], count3 == null ? 10 : count3, specifier);
  };
  scale.nice = function(count3) {
    if (count3 == null) count3 = 10;
    var d = domain();
    var i0 = 0;
    var i1 = d.length - 1;
    var start2 = d[i0];
    var stop = d[i1];
    var prestep;
    var step;
    var maxIter = 10;
    if (stop < start2) {
      step = start2, start2 = stop, stop = step;
      step = i0, i0 = i1, i1 = step;
    }
    while (maxIter-- > 0) {
      step = tickIncrement(start2, stop, count3);
      if (step === prestep) {
        d[i0] = start2;
        d[i1] = stop;
        return domain(d);
      } else if (step > 0) {
        start2 = Math.floor(start2 / step) * step;
        stop = Math.ceil(stop / step) * step;
      } else if (step < 0) {
        start2 = Math.ceil(start2 * step) / step;
        stop = Math.floor(stop * step) / step;
      } else {
        break;
      }
      prestep = step;
    }
    return scale;
  };
  return scale;
}
function linear3() {
  var scale = continuous();
  scale.copy = function() {
    return copy(scale, linear3());
  };
  initRange.apply(scale, arguments);
  return linearish(scale);
}

// node_modules/d3-scale/src/identity.js
function identity3(domain) {
  var unknown;
  function scale(x3) {
    return x3 == null || isNaN(x3 = +x3) ? unknown : x3;
  }
  scale.invert = scale;
  scale.domain = scale.range = function(_) {
    return arguments.length ? (domain = Array.from(_, number), scale) : domain.slice();
  };
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  scale.copy = function() {
    return identity3(domain).unknown(unknown);
  };
  domain = arguments.length ? Array.from(domain, number) : [0, 1];
  return linearish(scale);
}

// node_modules/d3-scale/src/nice.js
function nice(domain, interval) {
  domain = domain.slice();
  var i0 = 0, i1 = domain.length - 1, x06 = domain[i0], x13 = domain[i1], t;
  if (x13 < x06) {
    t = i0, i0 = i1, i1 = t;
    t = x06, x06 = x13, x13 = t;
  }
  domain[i0] = interval.floor(x06);
  domain[i1] = interval.ceil(x13);
  return domain;
}

// node_modules/d3-scale/src/log.js
function transformLog(x3) {
  return Math.log(x3);
}
function transformExp(x3) {
  return Math.exp(x3);
}
function transformLogn(x3) {
  return -Math.log(-x3);
}
function transformExpn(x3) {
  return -Math.exp(-x3);
}
function pow10(x3) {
  return isFinite(x3) ? +("1e" + x3) : x3 < 0 ? 0 : x3;
}
function powp(base) {
  return base === 10 ? pow10 : base === Math.E ? Math.exp : (x3) => Math.pow(base, x3);
}
function logp(base) {
  return base === Math.E ? Math.log : base === 10 && Math.log10 || base === 2 && Math.log2 || (base = Math.log(base), (x3) => Math.log(x3) / base);
}
function reflect(f) {
  return (x3, k4) => -f(-x3, k4);
}
function loggish(transform2) {
  const scale = transform2(transformLog, transformExp);
  const domain = scale.domain;
  let base = 10;
  let logs;
  let pows;
  function rescale() {
    logs = logp(base), pows = powp(base);
    if (domain()[0] < 0) {
      logs = reflect(logs), pows = reflect(pows);
      transform2(transformLogn, transformExpn);
    } else {
      transform2(transformLog, transformExp);
    }
    return scale;
  }
  scale.base = function(_) {
    return arguments.length ? (base = +_, rescale()) : base;
  };
  scale.domain = function(_) {
    return arguments.length ? (domain(_), rescale()) : domain();
  };
  scale.ticks = (count3) => {
    const d = domain();
    let u = d[0];
    let v = d[d.length - 1];
    const r = v < u;
    if (r) [u, v] = [v, u];
    let i = logs(u);
    let j = logs(v);
    let k4;
    let t;
    const n = count3 == null ? 10 : +count3;
    let z = [];
    if (!(base % 1) && j - i < n) {
      i = Math.floor(i), j = Math.ceil(j);
      if (u > 0) for (; i <= j; ++i) {
        for (k4 = 1; k4 < base; ++k4) {
          t = i < 0 ? k4 / pows(-i) : k4 * pows(i);
          if (t < u) continue;
          if (t > v) break;
          z.push(t);
        }
      }
      else for (; i <= j; ++i) {
        for (k4 = base - 1; k4 >= 1; --k4) {
          t = i > 0 ? k4 / pows(-i) : k4 * pows(i);
          if (t < u) continue;
          if (t > v) break;
          z.push(t);
        }
      }
      if (z.length * 2 < n) z = ticks(u, v, n);
    } else {
      z = ticks(i, j, Math.min(j - i, n)).map(pows);
    }
    return r ? z.reverse() : z;
  };
  scale.tickFormat = (count3, specifier) => {
    if (count3 == null) count3 = 10;
    if (specifier == null) specifier = base === 10 ? "s" : ",";
    if (typeof specifier !== "function") {
      if (!(base % 1) && (specifier = formatSpecifier(specifier)).precision == null) specifier.trim = true;
      specifier = format(specifier);
    }
    if (count3 === Infinity) return specifier;
    const k4 = Math.max(1, base * count3 / scale.ticks().length);
    return (d) => {
      let i = d / pows(Math.round(logs(d)));
      if (i * base < base - 0.5) i *= base;
      return i <= k4 ? specifier(d) : "";
    };
  };
  scale.nice = () => {
    return domain(nice(domain(), {
      floor: (x3) => pows(Math.floor(logs(x3))),
      ceil: (x3) => pows(Math.ceil(logs(x3)))
    }));
  };
  return scale;
}
function log() {
  const scale = loggish(transformer()).domain([1, 10]);
  scale.copy = () => copy(scale, log()).base(scale.base());
  initRange.apply(scale, arguments);
  return scale;
}

// node_modules/d3-scale/src/symlog.js
function transformSymlog(c3) {
  return function(x3) {
    return Math.sign(x3) * Math.log1p(Math.abs(x3 / c3));
  };
}
function transformSymexp(c3) {
  return function(x3) {
    return Math.sign(x3) * Math.expm1(Math.abs(x3)) * c3;
  };
}
function symlogish(transform2) {
  var c3 = 1, scale = transform2(transformSymlog(c3), transformSymexp(c3));
  scale.constant = function(_) {
    return arguments.length ? transform2(transformSymlog(c3 = +_), transformSymexp(c3)) : c3;
  };
  return linearish(scale);
}
function symlog() {
  var scale = symlogish(transformer());
  scale.copy = function() {
    return copy(scale, symlog()).constant(scale.constant());
  };
  return initRange.apply(scale, arguments);
}

// node_modules/d3-scale/src/pow.js
function transformPow(exponent2) {
  return function(x3) {
    return x3 < 0 ? -Math.pow(-x3, exponent2) : Math.pow(x3, exponent2);
  };
}
function transformSqrt(x3) {
  return x3 < 0 ? -Math.sqrt(-x3) : Math.sqrt(x3);
}
function transformSquare(x3) {
  return x3 < 0 ? -x3 * x3 : x3 * x3;
}
function powish(transform2) {
  var scale = transform2(identity2, identity2), exponent2 = 1;
  function rescale() {
    return exponent2 === 1 ? transform2(identity2, identity2) : exponent2 === 0.5 ? transform2(transformSqrt, transformSquare) : transform2(transformPow(exponent2), transformPow(1 / exponent2));
  }
  scale.exponent = function(_) {
    return arguments.length ? (exponent2 = +_, rescale()) : exponent2;
  };
  return linearish(scale);
}
function pow() {
  var scale = powish(transformer());
  scale.copy = function() {
    return copy(scale, pow()).exponent(scale.exponent());
  };
  initRange.apply(scale, arguments);
  return scale;
}
function sqrt() {
  return pow.apply(null, arguments).exponent(0.5);
}

// node_modules/d3-scale/src/quantile.js
function quantile() {
  var domain = [], range3 = [], thresholds = [], unknown;
  function rescale() {
    var i = 0, n = Math.max(1, range3.length);
    thresholds = new Array(n - 1);
    while (++i < n) thresholds[i - 1] = quantileSorted(domain, i / n);
    return scale;
  }
  function scale(x3) {
    return x3 == null || isNaN(x3 = +x3) ? unknown : range3[bisect_default(thresholds, x3)];
  }
  scale.invertExtent = function(y3) {
    var i = range3.indexOf(y3);
    return i < 0 ? [NaN, NaN] : [
      i > 0 ? thresholds[i - 1] : domain[0],
      i < thresholds.length ? thresholds[i] : domain[domain.length - 1]
    ];
  };
  scale.domain = function(_) {
    if (!arguments.length) return domain.slice();
    domain = [];
    for (let d of _) if (d != null && !isNaN(d = +d)) domain.push(d);
    domain.sort(ascending);
    return rescale();
  };
  scale.range = function(_) {
    return arguments.length ? (range3 = Array.from(_), rescale()) : range3.slice();
  };
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  scale.quantiles = function() {
    return thresholds.slice();
  };
  scale.copy = function() {
    return quantile().domain(domain).range(range3).unknown(unknown);
  };
  return initRange.apply(scale, arguments);
}

// node_modules/d3-scale/src/quantize.js
function quantize() {
  var x06 = 0, x13 = 1, n = 1, domain = [0.5], range3 = [0, 1], unknown;
  function scale(x3) {
    return x3 != null && x3 <= x3 ? range3[bisect_default(domain, x3, 0, n)] : unknown;
  }
  function rescale() {
    var i = -1;
    domain = new Array(n);
    while (++i < n) domain[i] = ((i + 1) * x13 - (i - n) * x06) / (n + 1);
    return scale;
  }
  scale.domain = function(_) {
    return arguments.length ? ([x06, x13] = _, x06 = +x06, x13 = +x13, rescale()) : [x06, x13];
  };
  scale.range = function(_) {
    return arguments.length ? (n = (range3 = Array.from(_)).length - 1, rescale()) : range3.slice();
  };
  scale.invertExtent = function(y3) {
    var i = range3.indexOf(y3);
    return i < 0 ? [NaN, NaN] : i < 1 ? [x06, domain[0]] : i >= n ? [domain[n - 1], x13] : [domain[i - 1], domain[i]];
  };
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : scale;
  };
  scale.thresholds = function() {
    return domain.slice();
  };
  scale.copy = function() {
    return quantize().domain([x06, x13]).range(range3).unknown(unknown);
  };
  return initRange.apply(linearish(scale), arguments);
}

// node_modules/d3-scale/src/threshold.js
function threshold() {
  var domain = [0.5], range3 = [0, 1], unknown, n = 1;
  function scale(x3) {
    return x3 != null && x3 <= x3 ? range3[bisect_default(domain, x3, 0, n)] : unknown;
  }
  scale.domain = function(_) {
    return arguments.length ? (domain = Array.from(_), n = Math.min(domain.length, range3.length - 1), scale) : domain.slice();
  };
  scale.range = function(_) {
    return arguments.length ? (range3 = Array.from(_), n = Math.min(domain.length, range3.length - 1), scale) : range3.slice();
  };
  scale.invertExtent = function(y3) {
    var i = range3.indexOf(y3);
    return [domain[i - 1], domain[i]];
  };
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  scale.copy = function() {
    return threshold().domain(domain).range(range3).unknown(unknown);
  };
  return initRange.apply(scale, arguments);
}

// node_modules/d3-time/src/interval.js
var t02 = /* @__PURE__ */ new Date();
var t12 = /* @__PURE__ */ new Date();
function timeInterval(floori, offseti, count3, field) {
  function interval(date2) {
    return floori(date2 = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date2)), date2;
  }
  interval.floor = (date2) => {
    return floori(date2 = /* @__PURE__ */ new Date(+date2)), date2;
  };
  interval.ceil = (date2) => {
    return floori(date2 = new Date(date2 - 1)), offseti(date2, 1), floori(date2), date2;
  };
  interval.round = (date2) => {
    const d0 = interval(date2), d1 = interval.ceil(date2);
    return date2 - d0 < d1 - date2 ? d0 : d1;
  };
  interval.offset = (date2, step) => {
    return offseti(date2 = /* @__PURE__ */ new Date(+date2), step == null ? 1 : Math.floor(step)), date2;
  };
  interval.range = (start2, stop, step) => {
    const range3 = [];
    start2 = interval.ceil(start2);
    step = step == null ? 1 : Math.floor(step);
    if (!(start2 < stop) || !(step > 0)) return range3;
    let previous;
    do
      range3.push(previous = /* @__PURE__ */ new Date(+start2)), offseti(start2, step), floori(start2);
    while (previous < start2 && start2 < stop);
    return range3;
  };
  interval.filter = (test) => {
    return timeInterval((date2) => {
      if (date2 >= date2) while (floori(date2), !test(date2)) date2.setTime(date2 - 1);
    }, (date2, step) => {
      if (date2 >= date2) {
        if (step < 0) while (++step <= 0) {
          while (offseti(date2, -1), !test(date2)) {
          }
        }
        else while (--step >= 0) {
          while (offseti(date2, 1), !test(date2)) {
          }
        }
      }
    });
  };
  if (count3) {
    interval.count = (start2, end) => {
      t02.setTime(+start2), t12.setTime(+end);
      floori(t02), floori(t12);
      return Math.floor(count3(t02, t12));
    };
    interval.every = (step) => {
      step = Math.floor(step);
      return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval : interval.filter(field ? (d) => field(d) % step === 0 : (d) => interval.count(0, d) % step === 0);
    };
  }
  return interval;
}

// node_modules/d3-time/src/millisecond.js
var millisecond = timeInterval(() => {
}, (date2, step) => {
  date2.setTime(+date2 + step);
}, (start2, end) => {
  return end - start2;
});
millisecond.every = (k4) => {
  k4 = Math.floor(k4);
  if (!isFinite(k4) || !(k4 > 0)) return null;
  if (!(k4 > 1)) return millisecond;
  return timeInterval((date2) => {
    date2.setTime(Math.floor(date2 / k4) * k4);
  }, (date2, step) => {
    date2.setTime(+date2 + step * k4);
  }, (start2, end) => {
    return (end - start2) / k4;
  });
};
var milliseconds = millisecond.range;

// node_modules/d3-time/src/duration.js
var durationSecond = 1e3;
var durationMinute = durationSecond * 60;
var durationHour = durationMinute * 60;
var durationDay = durationHour * 24;
var durationWeek = durationDay * 7;
var durationMonth = durationDay * 30;
var durationYear = durationDay * 365;

// node_modules/d3-time/src/second.js
var second = timeInterval((date2) => {
  date2.setTime(date2 - date2.getMilliseconds());
}, (date2, step) => {
  date2.setTime(+date2 + step * durationSecond);
}, (start2, end) => {
  return (end - start2) / durationSecond;
}, (date2) => {
  return date2.getUTCSeconds();
});
var seconds = second.range;

// node_modules/d3-time/src/minute.js
var timeMinute = timeInterval((date2) => {
  date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationMinute);
}, (start2, end) => {
  return (end - start2) / durationMinute;
}, (date2) => {
  return date2.getMinutes();
});
var timeMinutes = timeMinute.range;
var utcMinute = timeInterval((date2) => {
  date2.setUTCSeconds(0, 0);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationMinute);
}, (start2, end) => {
  return (end - start2) / durationMinute;
}, (date2) => {
  return date2.getUTCMinutes();
});
var utcMinutes = utcMinute.range;

// node_modules/d3-time/src/hour.js
var timeHour = timeInterval((date2) => {
  date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond - date2.getMinutes() * durationMinute);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationHour);
}, (start2, end) => {
  return (end - start2) / durationHour;
}, (date2) => {
  return date2.getHours();
});
var timeHours = timeHour.range;
var utcHour = timeInterval((date2) => {
  date2.setUTCMinutes(0, 0, 0);
}, (date2, step) => {
  date2.setTime(+date2 + step * durationHour);
}, (start2, end) => {
  return (end - start2) / durationHour;
}, (date2) => {
  return date2.getUTCHours();
});
var utcHours = utcHour.range;

// node_modules/d3-time/src/day.js
var timeDay = timeInterval(
  (date2) => date2.setHours(0, 0, 0, 0),
  (date2, step) => date2.setDate(date2.getDate() + step),
  (start2, end) => (end - start2 - (end.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationDay,
  (date2) => date2.getDate() - 1
);
var timeDays = timeDay.range;
var utcDay = timeInterval((date2) => {
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCDate(date2.getUTCDate() + step);
}, (start2, end) => {
  return (end - start2) / durationDay;
}, (date2) => {
  return date2.getUTCDate() - 1;
});
var utcDays = utcDay.range;
var unixDay = timeInterval((date2) => {
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCDate(date2.getUTCDate() + step);
}, (start2, end) => {
  return (end - start2) / durationDay;
}, (date2) => {
  return Math.floor(date2 / durationDay);
});
var unixDays = unixDay.range;

// node_modules/d3-time/src/week.js
function timeWeekday(i) {
  return timeInterval((date2) => {
    date2.setDate(date2.getDate() - (date2.getDay() + 7 - i) % 7);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setDate(date2.getDate() + step * 7);
  }, (start2, end) => {
    return (end - start2 - (end.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationWeek;
  });
}
var timeSunday = timeWeekday(0);
var timeMonday = timeWeekday(1);
var timeTuesday = timeWeekday(2);
var timeWednesday = timeWeekday(3);
var timeThursday = timeWeekday(4);
var timeFriday = timeWeekday(5);
var timeSaturday = timeWeekday(6);
var timeSundays = timeSunday.range;
var timeMondays = timeMonday.range;
var timeTuesdays = timeTuesday.range;
var timeWednesdays = timeWednesday.range;
var timeThursdays = timeThursday.range;
var timeFridays = timeFriday.range;
var timeSaturdays = timeSaturday.range;
function utcWeekday(i) {
  return timeInterval((date2) => {
    date2.setUTCDate(date2.getUTCDate() - (date2.getUTCDay() + 7 - i) % 7);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCDate(date2.getUTCDate() + step * 7);
  }, (start2, end) => {
    return (end - start2) / durationWeek;
  });
}
var utcSunday = utcWeekday(0);
var utcMonday = utcWeekday(1);
var utcTuesday = utcWeekday(2);
var utcWednesday = utcWeekday(3);
var utcThursday = utcWeekday(4);
var utcFriday = utcWeekday(5);
var utcSaturday = utcWeekday(6);
var utcSundays = utcSunday.range;
var utcMondays = utcMonday.range;
var utcTuesdays = utcTuesday.range;
var utcWednesdays = utcWednesday.range;
var utcThursdays = utcThursday.range;
var utcFridays = utcFriday.range;
var utcSaturdays = utcSaturday.range;

// node_modules/d3-time/src/month.js
var timeMonth = timeInterval((date2) => {
  date2.setDate(1);
  date2.setHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setMonth(date2.getMonth() + step);
}, (start2, end) => {
  return end.getMonth() - start2.getMonth() + (end.getFullYear() - start2.getFullYear()) * 12;
}, (date2) => {
  return date2.getMonth();
});
var timeMonths = timeMonth.range;
var utcMonth = timeInterval((date2) => {
  date2.setUTCDate(1);
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCMonth(date2.getUTCMonth() + step);
}, (start2, end) => {
  return end.getUTCMonth() - start2.getUTCMonth() + (end.getUTCFullYear() - start2.getUTCFullYear()) * 12;
}, (date2) => {
  return date2.getUTCMonth();
});
var utcMonths = utcMonth.range;

// node_modules/d3-time/src/year.js
var timeYear = timeInterval((date2) => {
  date2.setMonth(0, 1);
  date2.setHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setFullYear(date2.getFullYear() + step);
}, (start2, end) => {
  return end.getFullYear() - start2.getFullYear();
}, (date2) => {
  return date2.getFullYear();
});
timeYear.every = (k4) => {
  return !isFinite(k4 = Math.floor(k4)) || !(k4 > 0) ? null : timeInterval((date2) => {
    date2.setFullYear(Math.floor(date2.getFullYear() / k4) * k4);
    date2.setMonth(0, 1);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setFullYear(date2.getFullYear() + step * k4);
  });
};
var timeYears = timeYear.range;
var utcYear = timeInterval((date2) => {
  date2.setUTCMonth(0, 1);
  date2.setUTCHours(0, 0, 0, 0);
}, (date2, step) => {
  date2.setUTCFullYear(date2.getUTCFullYear() + step);
}, (start2, end) => {
  return end.getUTCFullYear() - start2.getUTCFullYear();
}, (date2) => {
  return date2.getUTCFullYear();
});
utcYear.every = (k4) => {
  return !isFinite(k4 = Math.floor(k4)) || !(k4 > 0) ? null : timeInterval((date2) => {
    date2.setUTCFullYear(Math.floor(date2.getUTCFullYear() / k4) * k4);
    date2.setUTCMonth(0, 1);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCFullYear(date2.getUTCFullYear() + step * k4);
  });
};
var utcYears = utcYear.range;

// node_modules/d3-time/src/ticks.js
function ticker(year, month, week, day, hour, minute) {
  const tickIntervals = [
    [second, 1, durationSecond],
    [second, 5, 5 * durationSecond],
    [second, 15, 15 * durationSecond],
    [second, 30, 30 * durationSecond],
    [minute, 1, durationMinute],
    [minute, 5, 5 * durationMinute],
    [minute, 15, 15 * durationMinute],
    [minute, 30, 30 * durationMinute],
    [hour, 1, durationHour],
    [hour, 3, 3 * durationHour],
    [hour, 6, 6 * durationHour],
    [hour, 12, 12 * durationHour],
    [day, 1, durationDay],
    [day, 2, 2 * durationDay],
    [week, 1, durationWeek],
    [month, 1, durationMonth],
    [month, 3, 3 * durationMonth],
    [year, 1, durationYear]
  ];
  function ticks2(start2, stop, count3) {
    const reverse2 = stop < start2;
    if (reverse2) [start2, stop] = [stop, start2];
    const interval = count3 && typeof count3.range === "function" ? count3 : tickInterval(start2, stop, count3);
    const ticks3 = interval ? interval.range(start2, +stop + 1) : [];
    return reverse2 ? ticks3.reverse() : ticks3;
  }
  function tickInterval(start2, stop, count3) {
    const target = Math.abs(stop - start2) / count3;
    const i = bisector(([, , step2]) => step2).right(tickIntervals, target);
    if (i === tickIntervals.length) return year.every(tickStep(start2 / durationYear, stop / durationYear, count3));
    if (i === 0) return millisecond.every(Math.max(tickStep(start2, stop, count3), 1));
    const [t, step] = tickIntervals[target / tickIntervals[i - 1][2] < tickIntervals[i][2] / target ? i - 1 : i];
    return t.every(step);
  }
  return [ticks2, tickInterval];
}
var [utcTicks, utcTickInterval] = ticker(utcYear, utcMonth, utcSunday, unixDay, utcHour, utcMinute);
var [timeTicks, timeTickInterval] = ticker(timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute);

// node_modules/d3-time-format/src/locale.js
function localDate(d) {
  if (0 <= d.y && d.y < 100) {
    var date2 = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
    date2.setFullYear(d.y);
    return date2;
  }
  return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
}
function utcDate(d) {
  if (0 <= d.y && d.y < 100) {
    var date2 = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
    date2.setUTCFullYear(d.y);
    return date2;
  }
  return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
}
function newDate(y3, m2, d) {
  return { y: y3, m: m2, d, H: 0, M: 0, S: 0, L: 0 };
}
function formatLocale(locale3) {
  var locale_dateTime = locale3.dateTime, locale_date = locale3.date, locale_time = locale3.time, locale_periods = locale3.periods, locale_weekdays = locale3.days, locale_shortWeekdays = locale3.shortDays, locale_months = locale3.months, locale_shortMonths = locale3.shortMonths;
  var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
  var formats = {
    "a": formatShortWeekday,
    "A": formatWeekday,
    "b": formatShortMonth,
    "B": formatMonth,
    "c": null,
    "d": formatDayOfMonth,
    "e": formatDayOfMonth,
    "f": formatMicroseconds,
    "g": formatYearISO,
    "G": formatFullYearISO,
    "H": formatHour24,
    "I": formatHour12,
    "j": formatDayOfYear,
    "L": formatMilliseconds,
    "m": formatMonthNumber,
    "M": formatMinutes,
    "p": formatPeriod,
    "q": formatQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatSeconds,
    "u": formatWeekdayNumberMonday,
    "U": formatWeekNumberSunday,
    "V": formatWeekNumberISO,
    "w": formatWeekdayNumberSunday,
    "W": formatWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatYear,
    "Y": formatFullYear,
    "Z": formatZone,
    "%": formatLiteralPercent
  };
  var utcFormats = {
    "a": formatUTCShortWeekday,
    "A": formatUTCWeekday,
    "b": formatUTCShortMonth,
    "B": formatUTCMonth,
    "c": null,
    "d": formatUTCDayOfMonth,
    "e": formatUTCDayOfMonth,
    "f": formatUTCMicroseconds,
    "g": formatUTCYearISO,
    "G": formatUTCFullYearISO,
    "H": formatUTCHour24,
    "I": formatUTCHour12,
    "j": formatUTCDayOfYear,
    "L": formatUTCMilliseconds,
    "m": formatUTCMonthNumber,
    "M": formatUTCMinutes,
    "p": formatUTCPeriod,
    "q": formatUTCQuarter,
    "Q": formatUnixTimestamp,
    "s": formatUnixTimestampSeconds,
    "S": formatUTCSeconds,
    "u": formatUTCWeekdayNumberMonday,
    "U": formatUTCWeekNumberSunday,
    "V": formatUTCWeekNumberISO,
    "w": formatUTCWeekdayNumberSunday,
    "W": formatUTCWeekNumberMonday,
    "x": null,
    "X": null,
    "y": formatUTCYear,
    "Y": formatUTCFullYear,
    "Z": formatUTCZone,
    "%": formatLiteralPercent
  };
  var parses = {
    "a": parseShortWeekday,
    "A": parseWeekday,
    "b": parseShortMonth,
    "B": parseMonth,
    "c": parseLocaleDateTime,
    "d": parseDayOfMonth,
    "e": parseDayOfMonth,
    "f": parseMicroseconds,
    "g": parseYear,
    "G": parseFullYear,
    "H": parseHour24,
    "I": parseHour24,
    "j": parseDayOfYear,
    "L": parseMilliseconds,
    "m": parseMonthNumber,
    "M": parseMinutes,
    "p": parsePeriod,
    "q": parseQuarter,
    "Q": parseUnixTimestamp,
    "s": parseUnixTimestampSeconds,
    "S": parseSeconds,
    "u": parseWeekdayNumberMonday,
    "U": parseWeekNumberSunday,
    "V": parseWeekNumberISO,
    "w": parseWeekdayNumberSunday,
    "W": parseWeekNumberMonday,
    "x": parseLocaleDate,
    "X": parseLocaleTime,
    "y": parseYear,
    "Y": parseFullYear,
    "Z": parseZone,
    "%": parseLiteralPercent
  };
  formats.x = newFormat(locale_date, formats);
  formats.X = newFormat(locale_time, formats);
  formats.c = newFormat(locale_dateTime, formats);
  utcFormats.x = newFormat(locale_date, utcFormats);
  utcFormats.X = newFormat(locale_time, utcFormats);
  utcFormats.c = newFormat(locale_dateTime, utcFormats);
  function newFormat(specifier, formats2) {
    return function(date2) {
      var string = [], i = -1, j = 0, n = specifier.length, c3, pad2, format2;
      if (!(date2 instanceof Date)) date2 = /* @__PURE__ */ new Date(+date2);
      while (++i < n) {
        if (specifier.charCodeAt(i) === 37) {
          string.push(specifier.slice(j, i));
          if ((pad2 = pads[c3 = specifier.charAt(++i)]) != null) c3 = specifier.charAt(++i);
          else pad2 = c3 === "e" ? " " : "0";
          if (format2 = formats2[c3]) c3 = format2(date2, pad2);
          string.push(c3);
          j = i + 1;
        }
      }
      string.push(specifier.slice(j, i));
      return string.join("");
    };
  }
  function newParse(specifier, Z) {
    return function(string) {
      var d = newDate(1900, void 0, 1), i = parseSpecifier(d, specifier, string += "", 0), week, day;
      if (i != string.length) return null;
      if ("Q" in d) return new Date(d.Q);
      if ("s" in d) return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
      if (Z && !("Z" in d)) d.Z = 0;
      if ("p" in d) d.H = d.H % 12 + d.p * 12;
      if (d.m === void 0) d.m = "q" in d ? d.q : 0;
      if ("V" in d) {
        if (d.V < 1 || d.V > 53) return null;
        if (!("w" in d)) d.w = 1;
        if ("Z" in d) {
          week = utcDate(newDate(d.y, 0, 1)), day = week.getUTCDay();
          week = day > 4 || day === 0 ? utcMonday.ceil(week) : utcMonday(week);
          week = utcDay.offset(week, (d.V - 1) * 7);
          d.y = week.getUTCFullYear();
          d.m = week.getUTCMonth();
          d.d = week.getUTCDate() + (d.w + 6) % 7;
        } else {
          week = localDate(newDate(d.y, 0, 1)), day = week.getDay();
          week = day > 4 || day === 0 ? timeMonday.ceil(week) : timeMonday(week);
          week = timeDay.offset(week, (d.V - 1) * 7);
          d.y = week.getFullYear();
          d.m = week.getMonth();
          d.d = week.getDate() + (d.w + 6) % 7;
        }
      } else if ("W" in d || "U" in d) {
        if (!("w" in d)) d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
        day = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
        d.m = 0;
        d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
      }
      if ("Z" in d) {
        d.H += d.Z / 100 | 0;
        d.M += d.Z % 100;
        return utcDate(d);
      }
      return localDate(d);
    };
  }
  function parseSpecifier(d, specifier, string, j) {
    var i = 0, n = specifier.length, m2 = string.length, c3, parse;
    while (i < n) {
      if (j >= m2) return -1;
      c3 = specifier.charCodeAt(i++);
      if (c3 === 37) {
        c3 = specifier.charAt(i++);
        parse = parses[c3 in pads ? specifier.charAt(i++) : c3];
        if (!parse || (j = parse(d, string, j)) < 0) return -1;
      } else if (c3 != string.charCodeAt(j++)) {
        return -1;
      }
    }
    return j;
  }
  function parsePeriod(d, string, i) {
    var n = periodRe.exec(string.slice(i));
    return n ? (d.p = periodLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseShortWeekday(d, string, i) {
    var n = shortWeekdayRe.exec(string.slice(i));
    return n ? (d.w = shortWeekdayLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseWeekday(d, string, i) {
    var n = weekdayRe.exec(string.slice(i));
    return n ? (d.w = weekdayLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseShortMonth(d, string, i) {
    var n = shortMonthRe.exec(string.slice(i));
    return n ? (d.m = shortMonthLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseMonth(d, string, i) {
    var n = monthRe.exec(string.slice(i));
    return n ? (d.m = monthLookup.get(n[0].toLowerCase()), i + n[0].length) : -1;
  }
  function parseLocaleDateTime(d, string, i) {
    return parseSpecifier(d, locale_dateTime, string, i);
  }
  function parseLocaleDate(d, string, i) {
    return parseSpecifier(d, locale_date, string, i);
  }
  function parseLocaleTime(d, string, i) {
    return parseSpecifier(d, locale_time, string, i);
  }
  function formatShortWeekday(d) {
    return locale_shortWeekdays[d.getDay()];
  }
  function formatWeekday(d) {
    return locale_weekdays[d.getDay()];
  }
  function formatShortMonth(d) {
    return locale_shortMonths[d.getMonth()];
  }
  function formatMonth(d) {
    return locale_months[d.getMonth()];
  }
  function formatPeriod(d) {
    return locale_periods[+(d.getHours() >= 12)];
  }
  function formatQuarter(d) {
    return 1 + ~~(d.getMonth() / 3);
  }
  function formatUTCShortWeekday(d) {
    return locale_shortWeekdays[d.getUTCDay()];
  }
  function formatUTCWeekday(d) {
    return locale_weekdays[d.getUTCDay()];
  }
  function formatUTCShortMonth(d) {
    return locale_shortMonths[d.getUTCMonth()];
  }
  function formatUTCMonth(d) {
    return locale_months[d.getUTCMonth()];
  }
  function formatUTCPeriod(d) {
    return locale_periods[+(d.getUTCHours() >= 12)];
  }
  function formatUTCQuarter(d) {
    return 1 + ~~(d.getUTCMonth() / 3);
  }
  return {
    format: function(specifier) {
      var f = newFormat(specifier += "", formats);
      f.toString = function() {
        return specifier;
      };
      return f;
    },
    parse: function(specifier) {
      var p = newParse(specifier += "", false);
      p.toString = function() {
        return specifier;
      };
      return p;
    },
    utcFormat: function(specifier) {
      var f = newFormat(specifier += "", utcFormats);
      f.toString = function() {
        return specifier;
      };
      return f;
    },
    utcParse: function(specifier) {
      var p = newParse(specifier += "", true);
      p.toString = function() {
        return specifier;
      };
      return p;
    }
  };
}
var pads = { "-": "", "_": " ", "0": "0" };
var numberRe = /^\s*\d+/;
var percentRe = /^%/;
var requoteRe = /[\\^$*+?|[\]().{}]/g;
function pad(value2, fill, width) {
  var sign5 = value2 < 0 ? "-" : "", string = (sign5 ? -value2 : value2) + "", length = string.length;
  return sign5 + (length < width ? new Array(width - length + 1).join(fill) + string : string);
}
function requote(s3) {
  return s3.replace(requoteRe, "\\$&");
}
function formatRe(names) {
  return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
}
function formatLookup(names) {
  return new Map(names.map((name2, i) => [name2.toLowerCase(), i]));
}
function parseWeekdayNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.w = +n[0], i + n[0].length) : -1;
}
function parseWeekdayNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.u = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberSunday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.U = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberISO(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.V = +n[0], i + n[0].length) : -1;
}
function parseWeekNumberMonday(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.W = +n[0], i + n[0].length) : -1;
}
function parseFullYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 4));
  return n ? (d.y = +n[0], i + n[0].length) : -1;
}
function parseYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i + n[0].length) : -1;
}
function parseZone(d, string, i) {
  var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i, i + 6));
  return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i + n[0].length) : -1;
}
function parseQuarter(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 1));
  return n ? (d.q = n[0] * 3 - 3, i + n[0].length) : -1;
}
function parseMonthNumber(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.m = n[0] - 1, i + n[0].length) : -1;
}
function parseDayOfMonth(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.d = +n[0], i + n[0].length) : -1;
}
function parseDayOfYear(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.m = 0, d.d = +n[0], i + n[0].length) : -1;
}
function parseHour24(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.H = +n[0], i + n[0].length) : -1;
}
function parseMinutes(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.M = +n[0], i + n[0].length) : -1;
}
function parseSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 2));
  return n ? (d.S = +n[0], i + n[0].length) : -1;
}
function parseMilliseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 3));
  return n ? (d.L = +n[0], i + n[0].length) : -1;
}
function parseMicroseconds(d, string, i) {
  var n = numberRe.exec(string.slice(i, i + 6));
  return n ? (d.L = Math.floor(n[0] / 1e3), i + n[0].length) : -1;
}
function parseLiteralPercent(d, string, i) {
  var n = percentRe.exec(string.slice(i, i + 1));
  return n ? i + n[0].length : -1;
}
function parseUnixTimestamp(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.Q = +n[0], i + n[0].length) : -1;
}
function parseUnixTimestampSeconds(d, string, i) {
  var n = numberRe.exec(string.slice(i));
  return n ? (d.s = +n[0], i + n[0].length) : -1;
}
function formatDayOfMonth(d, p) {
  return pad(d.getDate(), p, 2);
}
function formatHour24(d, p) {
  return pad(d.getHours(), p, 2);
}
function formatHour12(d, p) {
  return pad(d.getHours() % 12 || 12, p, 2);
}
function formatDayOfYear(d, p) {
  return pad(1 + timeDay.count(timeYear(d), d), p, 3);
}
function formatMilliseconds(d, p) {
  return pad(d.getMilliseconds(), p, 3);
}
function formatMicroseconds(d, p) {
  return formatMilliseconds(d, p) + "000";
}
function formatMonthNumber(d, p) {
  return pad(d.getMonth() + 1, p, 2);
}
function formatMinutes(d, p) {
  return pad(d.getMinutes(), p, 2);
}
function formatSeconds(d, p) {
  return pad(d.getSeconds(), p, 2);
}
function formatWeekdayNumberMonday(d) {
  var day = d.getDay();
  return day === 0 ? 7 : day;
}
function formatWeekNumberSunday(d, p) {
  return pad(timeSunday.count(timeYear(d) - 1, d), p, 2);
}
function dISO(d) {
  var day = d.getDay();
  return day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
}
function formatWeekNumberISO(d, p) {
  d = dISO(d);
  return pad(timeThursday.count(timeYear(d), d) + (timeYear(d).getDay() === 4), p, 2);
}
function formatWeekdayNumberSunday(d) {
  return d.getDay();
}
function formatWeekNumberMonday(d, p) {
  return pad(timeMonday.count(timeYear(d) - 1, d), p, 2);
}
function formatYear(d, p) {
  return pad(d.getFullYear() % 100, p, 2);
}
function formatYearISO(d, p) {
  d = dISO(d);
  return pad(d.getFullYear() % 100, p, 2);
}
function formatFullYear(d, p) {
  return pad(d.getFullYear() % 1e4, p, 4);
}
function formatFullYearISO(d, p) {
  var day = d.getDay();
  d = day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
  return pad(d.getFullYear() % 1e4, p, 4);
}
function formatZone(d) {
  var z = d.getTimezoneOffset();
  return (z > 0 ? "-" : (z *= -1, "+")) + pad(z / 60 | 0, "0", 2) + pad(z % 60, "0", 2);
}
function formatUTCDayOfMonth(d, p) {
  return pad(d.getUTCDate(), p, 2);
}
function formatUTCHour24(d, p) {
  return pad(d.getUTCHours(), p, 2);
}
function formatUTCHour12(d, p) {
  return pad(d.getUTCHours() % 12 || 12, p, 2);
}
function formatUTCDayOfYear(d, p) {
  return pad(1 + utcDay.count(utcYear(d), d), p, 3);
}
function formatUTCMilliseconds(d, p) {
  return pad(d.getUTCMilliseconds(), p, 3);
}
function formatUTCMicroseconds(d, p) {
  return formatUTCMilliseconds(d, p) + "000";
}
function formatUTCMonthNumber(d, p) {
  return pad(d.getUTCMonth() + 1, p, 2);
}
function formatUTCMinutes(d, p) {
  return pad(d.getUTCMinutes(), p, 2);
}
function formatUTCSeconds(d, p) {
  return pad(d.getUTCSeconds(), p, 2);
}
function formatUTCWeekdayNumberMonday(d) {
  var dow = d.getUTCDay();
  return dow === 0 ? 7 : dow;
}
function formatUTCWeekNumberSunday(d, p) {
  return pad(utcSunday.count(utcYear(d) - 1, d), p, 2);
}
function UTCdISO(d) {
  var day = d.getUTCDay();
  return day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
}
function formatUTCWeekNumberISO(d, p) {
  d = UTCdISO(d);
  return pad(utcThursday.count(utcYear(d), d) + (utcYear(d).getUTCDay() === 4), p, 2);
}
function formatUTCWeekdayNumberSunday(d) {
  return d.getUTCDay();
}
function formatUTCWeekNumberMonday(d, p) {
  return pad(utcMonday.count(utcYear(d) - 1, d), p, 2);
}
function formatUTCYear(d, p) {
  return pad(d.getUTCFullYear() % 100, p, 2);
}
function formatUTCYearISO(d, p) {
  d = UTCdISO(d);
  return pad(d.getUTCFullYear() % 100, p, 2);
}
function formatUTCFullYear(d, p) {
  return pad(d.getUTCFullYear() % 1e4, p, 4);
}
function formatUTCFullYearISO(d, p) {
  var day = d.getUTCDay();
  d = day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
  return pad(d.getUTCFullYear() % 1e4, p, 4);
}
function formatUTCZone() {
  return "+0000";
}
function formatLiteralPercent() {
  return "%";
}
function formatUnixTimestamp(d) {
  return +d;
}
function formatUnixTimestampSeconds(d) {
  return Math.floor(+d / 1e3);
}

// node_modules/d3-time-format/src/defaultLocale.js
var locale2;
var timeFormat;
var timeParse;
var utcFormat;
var utcParse;
defaultLocale2({
  dateTime: "%x, %X",
  date: "%-m/%-d/%Y",
  time: "%-I:%M:%S %p",
  periods: ["AM", "PM"],
  days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
  shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
  shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
});
function defaultLocale2(definition) {
  locale2 = formatLocale(definition);
  timeFormat = locale2.format;
  timeParse = locale2.parse;
  utcFormat = locale2.utcFormat;
  utcParse = locale2.utcParse;
  return locale2;
}

// node_modules/d3-time-format/src/isoFormat.js
var isoSpecifier = "%Y-%m-%dT%H:%M:%S.%LZ";
function formatIsoNative(date2) {
  return date2.toISOString();
}
var formatIso = Date.prototype.toISOString ? formatIsoNative : utcFormat(isoSpecifier);

// node_modules/d3-time-format/src/isoParse.js
function parseIsoNative(string) {
  var date2 = new Date(string);
  return isNaN(date2) ? null : date2;
}
var parseIso = +/* @__PURE__ */ new Date("2000-01-01T00:00:00.000Z") ? parseIsoNative : utcParse(isoSpecifier);

// node_modules/d3-scale/src/time.js
function date(t) {
  return new Date(t);
}
function number2(t) {
  return t instanceof Date ? +t : +/* @__PURE__ */ new Date(+t);
}
function calendar(ticks2, tickInterval, year, month, week, day, hour, minute, second2, format2) {
  var scale = continuous(), invert = scale.invert, domain = scale.domain;
  var formatMillisecond = format2(".%L"), formatSecond = format2(":%S"), formatMinute = format2("%I:%M"), formatHour = format2("%I %p"), formatDay = format2("%a %d"), formatWeek = format2("%b %d"), formatMonth = format2("%B"), formatYear2 = format2("%Y");
  function tickFormat2(date2) {
    return (second2(date2) < date2 ? formatMillisecond : minute(date2) < date2 ? formatSecond : hour(date2) < date2 ? formatMinute : day(date2) < date2 ? formatHour : month(date2) < date2 ? week(date2) < date2 ? formatDay : formatWeek : year(date2) < date2 ? formatMonth : formatYear2)(date2);
  }
  scale.invert = function(y3) {
    return new Date(invert(y3));
  };
  scale.domain = function(_) {
    return arguments.length ? domain(Array.from(_, number2)) : domain().map(date);
  };
  scale.ticks = function(interval) {
    var d = domain();
    return ticks2(d[0], d[d.length - 1], interval == null ? 10 : interval);
  };
  scale.tickFormat = function(count3, specifier) {
    return specifier == null ? tickFormat2 : format2(specifier);
  };
  scale.nice = function(interval) {
    var d = domain();
    if (!interval || typeof interval.range !== "function") interval = tickInterval(d[0], d[d.length - 1], interval == null ? 10 : interval);
    return interval ? domain(nice(d, interval)) : scale;
  };
  scale.copy = function() {
    return copy(scale, calendar(ticks2, tickInterval, year, month, week, day, hour, minute, second2, format2));
  };
  return scale;
}
function time2() {
  return initRange.apply(calendar(timeTicks, timeTickInterval, timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute, second, timeFormat).domain([new Date(2e3, 0, 1), new Date(2e3, 0, 2)]), arguments);
}

// node_modules/d3-scale/src/utcTime.js
function utcTime() {
  return initRange.apply(calendar(utcTicks, utcTickInterval, utcYear, utcMonth, utcSunday, utcDay, utcHour, utcMinute, second, utcFormat).domain([Date.UTC(2e3, 0, 1), Date.UTC(2e3, 0, 2)]), arguments);
}

// node_modules/d3-scale/src/sequential.js
function transformer2() {
  var x06 = 0, x13 = 1, t03, t13, k10, transform2, interpolator = identity2, clamp2 = false, unknown;
  function scale(x3) {
    return x3 == null || isNaN(x3 = +x3) ? unknown : interpolator(k10 === 0 ? 0.5 : (x3 = (transform2(x3) - t03) * k10, clamp2 ? Math.max(0, Math.min(1, x3)) : x3));
  }
  scale.domain = function(_) {
    return arguments.length ? ([x06, x13] = _, t03 = transform2(x06 = +x06), t13 = transform2(x13 = +x13), k10 = t03 === t13 ? 0 : 1 / (t13 - t03), scale) : [x06, x13];
  };
  scale.clamp = function(_) {
    return arguments.length ? (clamp2 = !!_, scale) : clamp2;
  };
  scale.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale) : interpolator;
  };
  function range3(interpolate) {
    return function(_) {
      var r0, r1;
      return arguments.length ? ([r0, r1] = _, interpolator = interpolate(r0, r1), scale) : [interpolator(0), interpolator(1)];
    };
  }
  scale.range = range3(value_default);
  scale.rangeRound = range3(round_default);
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  return function(t) {
    transform2 = t, t03 = t(x06), t13 = t(x13), k10 = t03 === t13 ? 0 : 1 / (t13 - t03);
    return scale;
  };
}
function copy2(source, target) {
  return target.domain(source.domain()).interpolator(source.interpolator()).clamp(source.clamp()).unknown(source.unknown());
}
function sequential() {
  var scale = linearish(transformer2()(identity2));
  scale.copy = function() {
    return copy2(scale, sequential());
  };
  return initInterpolator.apply(scale, arguments);
}

// node_modules/d3-scale/src/diverging.js
function transformer3() {
  var x06 = 0, x13 = 0.5, x22 = 1, s3 = 1, t03, t13, t22, k10, k21, interpolator = identity2, transform2, clamp2 = false, unknown;
  function scale(x3) {
    return isNaN(x3 = +x3) ? unknown : (x3 = 0.5 + ((x3 = +transform2(x3)) - t13) * (s3 * x3 < s3 * t13 ? k10 : k21), interpolator(clamp2 ? Math.max(0, Math.min(1, x3)) : x3));
  }
  scale.domain = function(_) {
    return arguments.length ? ([x06, x13, x22] = _, t03 = transform2(x06 = +x06), t13 = transform2(x13 = +x13), t22 = transform2(x22 = +x22), k10 = t03 === t13 ? 0 : 0.5 / (t13 - t03), k21 = t13 === t22 ? 0 : 0.5 / (t22 - t13), s3 = t13 < t03 ? -1 : 1, scale) : [x06, x13, x22];
  };
  scale.clamp = function(_) {
    return arguments.length ? (clamp2 = !!_, scale) : clamp2;
  };
  scale.interpolator = function(_) {
    return arguments.length ? (interpolator = _, scale) : interpolator;
  };
  function range3(interpolate) {
    return function(_) {
      var r0, r1, r2;
      return arguments.length ? ([r0, r1, r2] = _, interpolator = piecewise(interpolate, [r0, r1, r2]), scale) : [interpolator(0), interpolator(0.5), interpolator(1)];
    };
  }
  scale.range = range3(value_default);
  scale.rangeRound = range3(round_default);
  scale.unknown = function(_) {
    return arguments.length ? (unknown = _, scale) : unknown;
  };
  return function(t) {
    transform2 = t, t03 = t(x06), t13 = t(x13), t22 = t(x22), k10 = t03 === t13 ? 0 : 0.5 / (t13 - t03), k21 = t13 === t22 ? 0 : 0.5 / (t22 - t13), s3 = t13 < t03 ? -1 : 1;
    return scale;
  };
}
function diverging() {
  var scale = linearish(transformer3()(identity2));
  scale.copy = function() {
    return copy2(scale, diverging());
  };
  return initInterpolator.apply(scale, arguments);
}

// node_modules/@unovis/ts/types/scale.js
var Scale = {
  scaleLinear: linear3,
  scalePow: pow,
  scaleSqrt: sqrt,
  scaleLog: log,
  scaleSymlog: symlog,
  scaleIdentity: identity3,
  scaleTime: time2,
  scaleUtc: utcTime,
  scaleSequential: sequential,
  scaleDiverging: diverging,
  scaleQuantize: quantize,
  scaleQuantile: quantile,
  scaleThreshold: threshold,
  scaleOrdinal: ordinal,
  scaleBand: band,
  scalePoint: point
};
var ScaleDimension;
(function(ScaleDimension2) {
  ScaleDimension2["X"] = "x";
  ScaleDimension2["Y"] = "y";
})(ScaleDimension || (ScaleDimension = {}));

// node_modules/@unovis/ts/types/direction.js
var Direction;
(function(Direction2) {
  Direction2["West"] = "west";
  Direction2["East"] = "east";
  Direction2["North"] = "north";
  Direction2["South"] = "south";
})(Direction || (Direction = {}));

// node_modules/@unovis/ts/containers/xy-container/config.js
var XYContainerDefaultConfig = Object.assign(Object.assign({}, ContainerDefaultConfig), { components: [], tooltip: void 0, crosshair: void 0, annotations: void 0, xAxis: void 0, yAxis: void 0, autoMargin: true, xScale: void 0, xDomain: void 0, xDomainMinConstraint: void 0, xDomainMaxConstraint: void 0, xRange: void 0, yScale: void 0, yDomain: void 0, yDomainMinConstraint: void 0, yDomainMaxConstraint: void 0, yRange: void 0, yDirection: Direction.North, preventEmptyDomain: null, scaleByDomain: false });

// node_modules/@unovis/ts/containers/xy-container/index.js
var XYContainer = class extends ContainerCore {
  constructor(element, config, data) {
    var _a, _b;
    super(element);
    this._defaultConfig = XYContainerDefaultConfig;
    this.datamodel = new CoreDataModel();
    this.config = this._defaultConfig;
    this._clipPathId = guid();
    this._axisMargin = { top: 0, bottom: 0, left: 0, right: 0 };
    this._firstRender = true;
    this._clipPath = this.svg.append("clipPath").attr("id", this._clipPathId);
    this._clipPath.append("rect");
    const highlightFilterId = "saturate";
    const baseUrl = window.location.href.replace(window.location.hash, "");
    this.svg.attr("class", css`
      --highlight-filter-id: url(${baseUrl}#${highlightFilterId}); // defining a css variable
    `);
    this._svgDefs.append("filter").attr("id", highlightFilterId).attr("filterUnits", "objectBoundingBox").html('<feColorMatrix type="saturate" in="SourceGraphic" values="1.35"/>');
    if (config) {
      this.updateContainer(config, true);
    }
    if (data) {
      this.setData(data, true);
    }
    if (this.config.xAxis || this.config.yAxis || ((_a = this.components) === null || _a === void 0 ? void 0 : _a.some((c3) => c3.datamodel.data))) {
      this.render();
    }
    (_b = document.fonts) === null || _b === void 0 ? void 0 : _b.ready.then(() => {
      if (!this._firstRender)
        this._renderAxes(0);
    });
  }
  get components() {
    return this.config.components;
  }
  // Overriding ContainerCore default get width method to work with axis auto margin
  get width() {
    const margin = this._getMargin();
    return clamp(this.containerWidth - margin.left - margin.right, 0, Number.POSITIVE_INFINITY);
  }
  // Overriding ContainerCore default get height method to work with axis auto margin
  get height() {
    const margin = this._getMargin();
    return clamp(this.containerHeight - margin.top - margin.bottom, 0, Number.POSITIVE_INFINITY);
  }
  setData(data, preventRender) {
    var _a, _b, _c, _d;
    const { components, config } = this;
    if (!data)
      return;
    this.datamodel.data = data;
    components.forEach((c3) => {
      c3.setData(data);
    });
    (_a = config.crosshair) === null || _a === void 0 ? void 0 : _a.setData(data);
    (_b = config.xAxis) === null || _b === void 0 ? void 0 : _b.setData(data);
    (_c = config.yAxis) === null || _c === void 0 ? void 0 : _c.setData(data);
    (_d = config.tooltip) === null || _d === void 0 ? void 0 : _d.hide();
    if (!preventRender)
      this.render();
  }
  updateContainer(containerConfig, preventRender) {
    super.updateContainer(containerConfig);
    this._removeAllChildren();
    this.setData(this.datamodel.data, true);
    if (containerConfig.xAxis) {
      this.config.xAxis.config.type = AxisType.X;
      this.element.appendChild(containerConfig.xAxis.element);
    }
    if (containerConfig.yAxis) {
      this.config.yAxis.config.type = AxisType.Y;
      this.element.appendChild(containerConfig.yAxis.element);
    }
    for (const c3 of this.components) {
      this.element.appendChild(c3.element);
    }
    const tooltip2 = containerConfig.tooltip;
    if (tooltip2) {
      if (!tooltip2.hasContainer())
        tooltip2.setContainer(this._container);
      tooltip2.setComponents(this.components);
    }
    const crosshair = containerConfig.crosshair;
    if (crosshair) {
      crosshair.setContainer(this.svg);
      crosshair.tooltip = tooltip2;
      this.element.appendChild(crosshair.element);
    }
    const annotations = containerConfig.annotations;
    if (annotations) {
      this.element.appendChild(annotations.element);
    }
    this.element.appendChild(this._clipPath.node());
    this.element.appendChild(this._svgDefs.node());
    this.element.appendChild(this._svgDefsExternal.node());
    if (!preventRender)
      this.render();
  }
  updateComponents(componentConfigs, preventRender) {
    const { config } = this;
    this.components.forEach((c3, i) => {
      const componentConfig = componentConfigs[i];
      if (componentConfig) {
        c3.setConfig(componentConfigs[i]);
      }
    });
    this._updateScales(...this.components, config.xAxis, config.yAxis, config.crosshair);
    if (!preventRender)
      this.render();
  }
  update(containerConfig, componentConfigs, data) {
    if (data)
      this.datamodel.data = data;
    if (containerConfig)
      this.updateContainer(containerConfig, true);
    if (componentConfigs)
      this.updateComponents(componentConfigs, true);
    this.render();
  }
  _preRender() {
    const { config } = this;
    super._preRender();
    if (config.autoMargin) {
      this._setAutoMargin();
    }
    const components = clean([...this.components, config.xAxis, config.yAxis, config.crosshair, config.annotations]);
    for (const c3 of components) {
      c3.setSize(this.width, this.height, this.containerWidth, this.containerHeight);
    }
    this._updateScales(...this.components, config.xAxis, config.yAxis, config.crosshair);
  }
  _render(customDuration) {
    var _a, _b, _c, _d, _e;
    const { config } = this;
    super._render();
    const margin = this._getMargin();
    for (const c3 of this.components) {
      c3.g.attr("transform", `translate(${margin.left},${margin.top})`).style("clip-path", c3.clippable ? `url(#${this._clipPathId})` : null).style("-webkit-clip-path", c3.clippable ? `url(#${this._clipPathId})` : null);
      c3.render(customDuration);
    }
    this._renderAxes(this._firstRender ? 0 : customDuration);
    const clipPathExtension = 2;
    this._clipPath.select("rect").attr("x", -clipPathExtension).attr("y", -clipPathExtension).attr("width", this.width + 2 * clipPathExtension).attr("height", this.height + 2 * clipPathExtension);
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.update();
    const crosshair = config.crosshair;
    if (crosshair) {
      const yAccessors = this.components.filter((c3) => !c3.stacked).map((c3) => c3.config.y);
      const yStackedAccessors = this.components.filter((c3) => c3.stacked).map((c3) => c3.config.y);
      const baselineComponentConfig = (_b = this.components.find((c3) => c3.config.baseline)) === null || _b === void 0 ? void 0 : _b.config;
      const baselineAccessor = baselineComponentConfig === null || baselineComponentConfig === void 0 ? void 0 : baselineComponentConfig.baseline;
      crosshair.accessors = {
        x: (_c = this.components[0]) === null || _c === void 0 ? void 0 : _c.config.x,
        y: flatten(yAccessors),
        yStacked: flatten(yStackedAccessors),
        baseline: baselineAccessor
      };
      crosshair.g.attr("transform", `translate(${margin.left},${margin.top})`).style("clip-path", `url(#${this._clipPathId})`).style("-webkit-clip-path", `url(#${this._clipPathId})`);
      crosshair.hide();
    }
    (_d = config.annotations) === null || _d === void 0 ? void 0 : _d.g.attr("transform", `translate(${margin.left},${margin.top})`);
    (_e = config.annotations) === null || _e === void 0 ? void 0 : _e.render();
    this._firstRender = false;
  }
  _updateScales(...components) {
    const c3 = clean(components || this.components);
    this._setScales(...c3);
    this._updateScalesDomain(...c3);
    this._updateScalesRange(...c3);
  }
  _setScales(...components) {
    const { config } = this;
    if (!components)
      return;
    if (config.xScale)
      components.forEach((c3) => c3.setScale(ScaleDimension.X, config.xScale));
    if (config.yScale)
      components.forEach((c3) => c3.setScale(ScaleDimension.Y, config.yScale));
  }
  _updateScalesDomain(...components) {
    const { config } = this;
    if (!components)
      return;
    const componentsWithDomain = components.filter((c3) => !c3.config.excludeFromDomainCalculation);
    Object.values(ScaleDimension).forEach((dimension) => {
      var _a, _b, _c, _d, _e, _f, _g, _h;
      const [min7, max8] = extent(merge(componentsWithDomain.map((c3) => c3.getDataExtent(dimension, config.scaleByDomain))));
      const configuredDomain = dimension === ScaleDimension.Y ? config.yDomain : config.xDomain;
      const configuredDomainMinConstraint = dimension === ScaleDimension.Y ? config.yDomainMinConstraint : config.xDomainMinConstraint;
      const configuredDomainMaxConstraint = dimension === ScaleDimension.Y ? config.yDomainMaxConstraint : config.xDomainMaxConstraint;
      const domainMin = (_b = (_a = configuredDomain === null || configuredDomain === void 0 ? void 0 : configuredDomain[0]) !== null && _a !== void 0 ? _a : min7) !== null && _b !== void 0 ? _b : 0;
      const domainMax = (_d = (_c = configuredDomain === null || configuredDomain === void 0 ? void 0 : configuredDomain[1]) !== null && _c !== void 0 ? _c : max8) !== null && _d !== void 0 ? _d : 1;
      const domain = [
        clamp(domainMin, (_e = configuredDomainMinConstraint === null || configuredDomainMinConstraint === void 0 ? void 0 : configuredDomainMinConstraint[0]) !== null && _e !== void 0 ? _e : Number.NEGATIVE_INFINITY, (_f = configuredDomainMinConstraint === null || configuredDomainMinConstraint === void 0 ? void 0 : configuredDomainMinConstraint[1]) !== null && _f !== void 0 ? _f : Number.POSITIVE_INFINITY),
        clamp(domainMax, (_g = configuredDomainMaxConstraint === null || configuredDomainMaxConstraint === void 0 ? void 0 : configuredDomainMaxConstraint[0]) !== null && _g !== void 0 ? _g : Number.NEGATIVE_INFINITY, (_h = configuredDomainMaxConstraint === null || configuredDomainMaxConstraint === void 0 ? void 0 : configuredDomainMaxConstraint[1]) !== null && _h !== void 0 ? _h : Number.POSITIVE_INFINITY)
      ];
      if (domain[0] === domain[1]) {
        const hasDataProvided = componentsWithDomain.some((c3) => {
          var _a2;
          return ((_a2 = c3.datamodel.data) === null || _a2 === void 0 ? void 0 : _a2.length) > 0;
        });
        if (config.preventEmptyDomain || config.preventEmptyDomain === null && (!hasDataProvided || dimension === ScaleDimension.Y)) {
          domain[1] = domain[0] + 1;
        }
      }
      components.forEach((c3) => c3.setScaleDomain(dimension, domain));
    });
  }
  _updateScalesRange(...components) {
    var _a, _b, _c, _d, _e, _f;
    const { config } = this;
    if (!components)
      return;
    const isYDirectionSouth = config.yDirection === Direction.South;
    const xRange = [(_a = config.padding.left) !== null && _a !== void 0 ? _a : 0, (_b = this.width - config.padding.right) !== null && _b !== void 0 ? _b : 0];
    const yRange = [(_c = this.height - config.padding.bottom) !== null && _c !== void 0 ? _c : 0, (_d = config.padding.top) !== null && _d !== void 0 ? _d : 0];
    if (isYDirectionSouth)
      yRange.reverse();
    for (const c3 of components) {
      c3.setScaleRange(ScaleDimension.X, (_e = config.xRange) !== null && _e !== void 0 ? _e : xRange);
      c3.setScaleRange(ScaleDimension.Y, (_f = config.yRange) !== null && _f !== void 0 ? _f : yRange);
    }
    const bleed = components.map((c3) => c3.bleed).reduce((bleed2, b) => {
      for (const key of Object.keys(bleed2)) {
        const k4 = key;
        if (bleed2[k4] < b[k4])
          bleed2[k4] = b[k4];
      }
      return bleed2;
    }, { top: 0, bottom: 0, left: 0, right: 0 });
    for (const c3 of components) {
      c3.setScaleRange(ScaleDimension.X, [xRange[0] + bleed.left, xRange[1] - bleed.right]);
      c3.setScaleRange(
        ScaleDimension.Y,
        isYDirectionSouth ? [yRange[0] + bleed.top, yRange[1] - bleed.bottom] : [yRange[0] - bleed.bottom, yRange[1] + bleed.top]
        // if Y axis is directed upwards
      );
    }
  }
  _renderAxes(duration) {
    const { config: { xAxis, yAxis } } = this;
    const margin = this._getMargin();
    const axes = clean([xAxis, yAxis]);
    axes.forEach((axis3) => {
      const offset = axis3.getOffset(margin);
      axis3.g.attr("transform", `translate(${offset.left},${offset.top})`);
      axis3.render(duration);
    });
  }
  _setAutoMargin() {
    const { config: { xAxis, yAxis } } = this;
    const components = clean([...this.components, xAxis, yAxis]);
    this._updateScalesDomain(...components);
    const numIterations = this._firstRender ? 2 : 1;
    for (let i = 0; i < numIterations; i += 1) {
      const axisMargin = { top: 0, bottom: 0, left: 0, right: 0 };
      this._updateScalesRange(...components);
      const axes = clean([xAxis, yAxis]);
      axes.forEach((axis3) => {
        axis3.preRender();
        const m2 = axis3.getRequiredMargin();
        if (axisMargin.top < m2.top)
          axisMargin.top = m2.top;
        if (axisMargin.bottom < m2.bottom)
          axisMargin.bottom = m2.bottom;
        if (axisMargin.left < m2.left)
          axisMargin.left = m2.left;
        if (axisMargin.right < m2.right)
          axisMargin.right = m2.right;
      });
      this._axisMargin = axisMargin;
    }
  }
  _getMargin() {
    const { config: { margin } } = this;
    return {
      top: margin.top + this._axisMargin.top,
      bottom: margin.bottom + this._axisMargin.bottom,
      left: margin.left + this._axisMargin.left,
      right: margin.right + this._axisMargin.right
    };
  }
  destroy() {
    const { components, config: { tooltip: tooltip2, crosshair, annotations, xAxis, yAxis } } = this;
    super.destroy();
    for (const c3 of components)
      c3 === null || c3 === void 0 ? void 0 : c3.destroy();
    tooltip2 === null || tooltip2 === void 0 ? void 0 : tooltip2.destroy();
    crosshair === null || crosshair === void 0 ? void 0 : crosshair.destroy();
    annotations === null || annotations === void 0 ? void 0 : annotations.destroy();
    xAxis === null || xAxis === void 0 ? void 0 : xAxis.destroy();
    yAxis === null || yAxis === void 0 ? void 0 : yAxis.destroy();
  }
};

// node_modules/@unovis/ts/core/component/config.js
var ComponentDefaultConfig = {
  duration: 600,
  events: {},
  attributes: {}
};

// node_modules/@unovis/ts/core/component/index.js
var ComponentCore = class {
  constructor(type2 = ComponentType.SVG) {
    var _a, _b;
    this.type = ComponentType.SVG;
    this.datamodel = new CoreDataModel();
    this.sizing = Sizing.Fit;
    this.events = {};
    this._defaultConfig = ComponentDefaultConfig;
    this._width = 400;
    this._height = 200;
    this._containerWidth = void 0;
    this._containerHeight = void 0;
    this._setUpComponentEventsThrottled = throttle(this._setUpComponentEvents, 500);
    this._setCustomAttributesThrottled = throttle(this._setCustomAttributes, 500);
    if (type2 === ComponentType.SVG) {
      this.element = document.createElementNS("http://www.w3.org/2000/svg", "g");
    } else {
      this.element = document.createElement("div");
    }
    this.uid = guid();
    this.g = select_default2(this.element);
    const rootClass = (_b = (_a = this.constructor) === null || _a === void 0 ? void 0 : _a["selectors"]) === null || _b === void 0 ? void 0 : _b.root;
    if (rootClass)
      this.g.attr("class", rootClass);
  }
  setConfig(config) {
    this.prevConfig = this.config;
    this.config = merge2(this._defaultConfig, config);
  }
  setData(data) {
    this.datamodel.data = data;
  }
  setSize(width, height, containerWidth, containerHeight) {
    if (isFinite(width))
      this._width = width;
    if (isFinite(height))
      this._height = height;
    if (isFinite(containerWidth))
      this._containerWidth = containerWidth;
    if (isFinite(containerHeight))
      this._containerHeight = containerHeight;
  }
  render(duration = this.config.duration) {
    this._render(duration);
    const ANIMATING_ATTR = "animating";
    if (duration) {
      this.g.attr(ANIMATING_ATTR, "");
      const transition2 = this.g.transition(ANIMATING_ATTR).duration(duration);
      transition2.on("end interrupt", () => {
        this.g.attr(ANIMATING_ATTR, null);
      });
    }
    this._setUpComponentEventsThrottled();
    this._setCustomAttributesThrottled();
  }
  get bleed() {
    return { top: 0, bottom: 0, left: 0, right: 0 };
  }
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  _render(duration = this.config.duration) {
  }
  _setCustomAttributes() {
    const attributeMap = this.config.attributes;
    Object.keys(attributeMap).forEach((className) => {
      Object.keys(attributeMap[className]).forEach((attr) => {
        const selection2 = this.g.selectAll(`.${className}`);
        selection2.attr(attr, attributeMap[className][attr]);
      });
    });
  }
  _setUpComponentEvents() {
    this._bindEvents(this.events);
    this._bindEvents(this.config.events, ".user");
  }
  _bindEvents(events2 = this.events, suffix = "") {
    Object.keys(events2).forEach((className) => {
      Object.keys(events2[className]).forEach((eventType) => {
        const selection2 = this.g.selectAll(`.${className}`);
        selection2.on(eventType + suffix, (event, d) => {
          const els = selection2.nodes();
          const i = els.indexOf(event.currentTarget);
          const eventFunction = events2[className][eventType];
          return eventFunction === null || eventFunction === void 0 ? void 0 : eventFunction(d, event, i, els);
        });
      });
    });
  }
  destroy() {
    var _a;
    (_a = this.g) === null || _a === void 0 ? void 0 : _a.remove();
    this.element = void 0;
  }
  isDestroyed() {
    return !this.element;
  }
};

// node_modules/@unovis/ts/data-models/series.js
var SeriesDataModel = class extends CoreDataModel {
  constructor(data) {
    super(data);
  }
  get data() {
    var _a;
    return (_a = this._data) !== null && _a !== void 0 ? _a : [];
  }
  set data(data) {
    if (Array.isArray(data))
      this._data = data;
  }
};

// node_modules/@unovis/ts/core/xy-component/config.js
var XYComponentDefaultConfig = Object.assign(Object.assign({}, ComponentDefaultConfig), { x: void 0, y: void 0, id: (d, i) => {
  var _a;
  return (_a = d.id) !== null && _a !== void 0 ? _a : `${i}`;
}, color: (d) => d.color, xScale: void 0, yScale: void 0, excludeFromDomainCalculation: false });

// node_modules/@unovis/ts/core/xy-component/index.js
var XYComponentCore = class extends ComponentCore {
  constructor() {
    super(...arguments);
    this.datamodel = new SeriesDataModel();
    this.clippable = true;
    this.stacked = false;
    this._defaultConfig = XYComponentDefaultConfig;
    this._xScale = Scale.scaleLinear();
    this._yScale = Scale.scaleLinear();
  }
  get xScale() {
    return this.config.xScale || this._xScale;
  }
  get yScale() {
    return this.config.yScale || this._yScale;
  }
  setConfig(config) {
    var _a, _b;
    if ((_a = this.config) === null || _a === void 0 ? void 0 : _a.xScale)
      config.xScale = this.config.xScale;
    if ((_b = this.config) === null || _b === void 0 ? void 0 : _b.yScale)
      config.yScale = this.config.yScale;
    super.setConfig(config);
  }
  setScaleDomain(dimension, domain) {
    var _a, _b;
    if (dimension === ScaleDimension.X)
      (_a = this._xScale) === null || _a === void 0 ? void 0 : _a.domain(domain);
    if (dimension === ScaleDimension.Y)
      (_b = this._yScale) === null || _b === void 0 ? void 0 : _b.domain(domain);
  }
  setScaleRange(dimension, range3) {
    var _a, _b;
    if (dimension === ScaleDimension.X)
      (_a = this._xScale) === null || _a === void 0 ? void 0 : _a.range(range3);
    if (dimension === ScaleDimension.Y)
      (_b = this._yScale) === null || _b === void 0 ? void 0 : _b.range(range3);
  }
  setScale(dimension, scale) {
    if (scale && dimension === ScaleDimension.X)
      this._xScale = scale;
    if (scale && dimension === ScaleDimension.Y)
      this._yScale = scale;
  }
  getDataExtent(dimension, scaleByVisibleData) {
    const { config, datamodel } = this;
    switch (dimension) {
      case ScaleDimension.X:
        return this.getXDataExtent();
      case ScaleDimension.Y:
        return this.getYDataExtent(scaleByVisibleData);
      default:
        return getExtent(datamodel.data, config[dimension]);
    }
  }
  getXDataExtent() {
    const { config, datamodel } = this;
    return getExtent(datamodel.data, config.x);
  }
  getYDataExtent(scaleByVisibleData) {
    const { config, datamodel } = this;
    const data = scaleByVisibleData ? filterDataByRange(datamodel.data, this.xScale.domain(), config.x) : datamodel.data;
    const yAccessors = isArray(config.y) ? config.y : [config.y];
    return getExtent(data, ...yAccessors);
  }
};

// node_modules/@unovis/ts/types/position.js
var Position;
(function(Position2) {
  Position2["Top"] = "top";
  Position2["Bottom"] = "bottom";
  Position2["Left"] = "left";
  Position2["Right"] = "right";
  Position2["Center"] = "center";
  Position2["Auto"] = "auto";
})(Position || (Position = {}));
var PositionStrategy;
(function(PositionStrategy2) {
  PositionStrategy2["Absolute"] = "absolute";
  PositionStrategy2["Fixed"] = "fixed";
})(PositionStrategy || (PositionStrategy = {}));
var Arrangement;
(function(Arrangement2) {
  Arrangement2["Inside"] = "inside";
  Arrangement2["Outside"] = "outside";
})(Arrangement || (Arrangement = {}));
var Orientation;
(function(Orientation2) {
  Orientation2["Horizontal"] = "horizontal";
  Orientation2["Vertical"] = "vertical";
})(Orientation || (Orientation = {}));

// node_modules/@unovis/ts/components/tooltip/config.js
var TooltipDefaultConfig = {
  components: [],
  container: void 0,
  horizontalPlacement: Position.Auto,
  horizontalShift: 0,
  verticalPlacement: Position.Top,
  verticalShift: 0,
  attributes: {},
  triggers: {}
};

// node_modules/@unovis/ts/components/tooltip/style.js
var style_exports = {};
__export(style_exports, {
  hidden: () => hidden,
  positionFixed: () => positionFixed,
  root: () => root2,
  show: () => show,
  tooltip: () => tooltip,
  variables: () => variables2
});
var root2 = css`
  label: tooltip;
`;
var variables2 = injectGlobal`
  :root {
    --vis-tooltip-background-color: rgba(255, 255, 255, 0.95);
    --vis-tooltip-border-color: #e5e9f7;
    --vis-tooltip-text-color: #000;
    --vis-tooltip-shadow-color: rgba(172, 179, 184, 0.35);
    --vis-tooltip-backdrop-filter: none;
    --vis-tooltip-padding: 10px 15px;

    --vis-dark-tooltip-background-color: rgba(30,30,30, 0.95);
    --vis-dark-tooltip-text-color: #e5e9f7;
    --vis-dark-tooltip-border-color: var(--vis-color-grey);
    --vis-dark-tooltip-shadow-color: rgba(0,0,0, 0.95);
  }

  body.theme-dark ${`.${root2}`} {
    --vis-tooltip-background-color: var(--vis-dark-tooltip-background-color);
    --vis-tooltip-text-color: var(--vis-dark-tooltip-text-color);
    --vis-tooltip-border-color: var(--vis-dark-tooltip-border-color);
    --vis-tooltip-shadow-color: var(--vis-dark-tooltip-shadow-color);
  }

  body.theme-dark {
    --vis-tooltip-background-color: rgba(30,30,30, 0.95);
    --vis-tooltip-text-color: #e5e9f7;
    --vis-tooltip-border-color: var(--vis-color-grey);
    --vis-tooltip-shadow-color: rgba(0,0,0, 0.95);
  }
`;
var tooltip = css`
  label: tooltip;
  display: inline-block;
  left: 0;
  bottom: 0;
  min-width: max-content;
  position: absolute;
  pointer-events: none;
  opacity: 0;
  transition: opacity;
  transition-duration: 300ms;
  user-select: none;
  z-index: 999999;
  padding: var(--vis-tooltip-padding);
  transform: translate(0, -5px);
  color: var(--vis-tooltip-text-color);

  /* object-fit: contain; */
  border-radius: 5px;
  box-shadow: 0 13px 25px 0 var(--vis-tooltip-box-shadow);
  border: solid 1px var(--vis-tooltip-border-color);
  background-color: var(--vis-tooltip-background-color);
  backdrop-filter: var(--vis-tooltip-backdrop-filter);
`;
var positionFixed = css`
  bottom: unset;
  position: fixed;
`;
var show = css`
  opacity: 1;
`;
var hidden = css`
  display: none;
`;

// node_modules/@unovis/ts/components/tooltip/index.js
var Tooltip = class {
  constructor(config = {}) {
    this._defaultConfig = TooltipDefaultConfig;
    this.config = this._defaultConfig;
    this._setUpEventsThrottled = throttle(this._setUpEvents, 500);
    this._setContainerPositionThrottled = throttle(this._setContainerPosition, 500);
    this._isShown = false;
    this.element = document.createElement("div");
    this.div = select_default2(this.element).attr("class", tooltip);
    this.setConfig(config);
    this.components = this.config.components;
  }
  setConfig(config) {
    var _a;
    this.prevConfig = this.config;
    this.config = merge2(this._defaultConfig, config);
    if (this.config.container && this.config.container !== ((_a = this.prevConfig) === null || _a === void 0 ? void 0 : _a.container)) {
      this.setContainer(this.config.container);
    }
    this._setUpAttributes();
  }
  setContainer(container) {
    var _a;
    (_a = this.element.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(this.element);
    this._container = container;
    this._container.appendChild(this.element);
    this._setContainerPositionThrottled();
  }
  getContainer() {
    return this._container;
  }
  hasContainer() {
    return !!this._container && this._container.isConnected;
  }
  setComponents(components) {
    this.components = components;
  }
  update() {
    if (!this._container)
      return;
    this._setUpEventsThrottled();
  }
  show(html, pos) {
    if (html instanceof HTMLElement) {
      const node4 = this.div.select(":first-child").node();
      if (node4 !== html)
        this.div.html("").append(() => html);
    } else {
      this.div.html(html);
    }
    this.div.classed(hidden, false).classed(show, true);
    this._isShown = true;
    this.place(pos);
  }
  hide() {
    this.div.classed(show, false).on("transitionend", () => {
      this.div.classed(hidden, !this._isShown);
    });
    this._isShown = false;
  }
  place(pos) {
    if (!this.hasContainer()) {
      console.warn("Unovis | Tooltip: Container was not set or is not initialized yet");
      return;
    }
    const { config } = this;
    const isContainerBody = this.isContainerBody();
    const width = this.element.offsetWidth;
    const height = this.element.offsetHeight;
    const containerHeight = isContainerBody ? window.innerHeight : this._container.scrollHeight;
    const containerWidth = isContainerBody ? window.innerWidth : this._container.scrollWidth;
    const horizontalPlacement = config.horizontalPlacement === Position.Auto ? pos.x > containerWidth / 2 ? Position.Left : Position.Right : config.horizontalPlacement;
    const verticalPlacement = config.verticalPlacement === Position.Auto ? pos.y > containerHeight / 2 ? Position.Top : Position.Bottom : config.verticalPlacement;
    const margin = 5;
    const dx = horizontalPlacement === Position.Left ? -width - margin - config.horizontalShift : horizontalPlacement === Position.Center ? -width / 2 : margin + config.horizontalShift;
    const dy = verticalPlacement === Position.Bottom ? height + margin + config.verticalShift : verticalPlacement === Position.Center ? height / 2 : -margin - config.verticalShift;
    const paddingX = 10;
    const hitRight = pos.x > containerWidth - width - dx - paddingX;
    const hitLeft = pos.x < -dx + paddingX;
    const constraintX = hitRight ? containerWidth - width - dx - pos.x - paddingX : hitLeft ? -dx - pos.x + paddingX : 0;
    const paddingY = 10;
    const hitBottom = pos.y > containerHeight - dy - paddingY;
    const hitTop = pos.y < height - dy + paddingY;
    const constraintY = hitBottom ? containerHeight - dy - pos.y - paddingY : hitTop ? height - dy - pos.y + paddingY : 0;
    const x3 = containerWidth < width ? 0 : pos.x + constraintX + dx;
    const y3 = containerHeight < height ? height : pos.y + constraintY + dy;
    this.div.classed(positionFixed, isContainerBody).style("top", isContainerBody ? `${y3 - height}px` : "unset").style("bottom", !isContainerBody ? `${containerHeight - y3}px` : "unset").style("left", `${x3}px`);
  }
  isContainerBody() {
    return this._container === document.body;
  }
  _setContainerPosition() {
    var _a;
    if (this._container !== document.body && ((_a = getComputedStyle(this._container)) === null || _a === void 0 ? void 0 : _a.position) === "static") {
      this._container.style.position = "relative";
    }
  }
  _setUpEvents() {
    const { config: { triggers } } = this;
    const isContainerBody = this.isContainerBody();
    this.components.forEach((component) => {
      const selection2 = select_default2(component.element);
      selection2.on("mousemove.tooltip", (e) => {
        const [x3, y3] = isContainerBody ? [e.clientX, e.clientY] : pointer_default(e, this._container);
        const path3 = e.composedPath && e.composedPath() || e.path || [e.target];
        for (const className of Object.keys(triggers)) {
          const template = triggers[className];
          if (!template)
            continue;
          const els = selection2.selectAll(`.${className}`).nodes();
          for (const el of path3) {
            if (el === selection2.node())
              break;
            if (el.classList.contains(className)) {
              const i = els.indexOf(el);
              const d = select_default2(el).datum();
              const content = template(d, i, els);
              if (content)
                this.show(content, { x: x3, y: y3 });
              else
                this.hide();
              e.stopPropagation();
              return;
            }
          }
        }
        if (this._isShown)
          this.hide();
      }).on("mouseleave.tooltip", (e) => {
        e.stopPropagation();
        this.hide();
      });
    });
  }
  _setUpAttributes() {
    const attributesMap = this.config.attributes;
    if (!attributesMap)
      return;
    Object.keys(attributesMap).forEach((attr) => {
      this.div.attr(attr, attributesMap[attr]);
    });
  }
  destroy() {
    var _a;
    (_a = this.div) === null || _a === void 0 ? void 0 : _a.remove();
  }
};
Tooltip.selectors = style_exports;

// node_modules/d3-shape/src/constant.js
function constant_default3(x3) {
  return function constant2() {
    return x3;
  };
}

// node_modules/d3-shape/src/math.js
var abs = Math.abs;
var atan2 = Math.atan2;
var cos = Math.cos;
var max2 = Math.max;
var min2 = Math.min;
var sin = Math.sin;
var sqrt2 = Math.sqrt;
var epsilon = 1e-12;
var pi2 = Math.PI;
var halfPi2 = pi2 / 2;
var tau2 = 2 * pi2;
function acos(x3) {
  return x3 > 1 ? 0 : x3 < -1 ? pi2 : Math.acos(x3);
}
function asin(x3) {
  return x3 >= 1 ? halfPi2 : x3 <= -1 ? -halfPi2 : Math.asin(x3);
}

// node_modules/d3-path/src/path.js
var pi3 = Math.PI;
var tau3 = 2 * pi3;
var epsilon3 = 1e-6;
var tauEpsilon = tau3 - epsilon3;
function append(strings) {
  this._ += strings[0];
  for (let i = 1, n = strings.length; i < n; ++i) {
    this._ += arguments[i] + strings[i];
  }
}
function appendRound(digits) {
  let d = Math.floor(digits);
  if (!(d >= 0)) throw new Error(`invalid digits: ${digits}`);
  if (d > 15) return append;
  const k4 = 10 ** d;
  return function(strings) {
    this._ += strings[0];
    for (let i = 1, n = strings.length; i < n; ++i) {
      this._ += Math.round(arguments[i] * k4) / k4 + strings[i];
    }
  };
}
var Path = class {
  constructor(digits) {
    this._x0 = this._y0 = // start of current subpath
    this._x1 = this._y1 = null;
    this._ = "";
    this._append = digits == null ? append : appendRound(digits);
  }
  moveTo(x3, y3) {
    this._append`M${this._x0 = this._x1 = +x3},${this._y0 = this._y1 = +y3}`;
  }
  closePath() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._append`Z`;
    }
  }
  lineTo(x3, y3) {
    this._append`L${this._x1 = +x3},${this._y1 = +y3}`;
  }
  quadraticCurveTo(x13, y13, x3, y3) {
    this._append`Q${+x13},${+y13},${this._x1 = +x3},${this._y1 = +y3}`;
  }
  bezierCurveTo(x13, y13, x22, y22, x3, y3) {
    this._append`C${+x13},${+y13},${+x22},${+y22},${this._x1 = +x3},${this._y1 = +y3}`;
  }
  arcTo(x13, y13, x22, y22, r) {
    x13 = +x13, y13 = +y13, x22 = +x22, y22 = +y22, r = +r;
    if (r < 0) throw new Error(`negative radius: ${r}`);
    let x06 = this._x1, y06 = this._y1, x21 = x22 - x13, y21 = y22 - y13, x01 = x06 - x13, y01 = y06 - y13, l01_2 = x01 * x01 + y01 * y01;
    if (this._x1 === null) {
      this._append`M${this._x1 = x13},${this._y1 = y13}`;
    } else if (!(l01_2 > epsilon3)) ;
    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon3) || !r) {
      this._append`L${this._x1 = x13},${this._y1 = y13}`;
    } else {
      let x20 = x22 - x06, y20 = y22 - y06, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi3 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
      if (Math.abs(t01 - 1) > epsilon3) {
        this._append`L${x13 + t01 * x01},${y13 + t01 * y01}`;
      }
      this._append`A${r},${r},0,0,${+(y01 * x20 > x01 * y20)},${this._x1 = x13 + t21 * x21},${this._y1 = y13 + t21 * y21}`;
    }
  }
  arc(x3, y3, r, a0, a1, ccw) {
    x3 = +x3, y3 = +y3, r = +r, ccw = !!ccw;
    if (r < 0) throw new Error(`negative radius: ${r}`);
    let dx = r * Math.cos(a0), dy = r * Math.sin(a0), x06 = x3 + dx, y06 = y3 + dy, cw = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
    if (this._x1 === null) {
      this._append`M${x06},${y06}`;
    } else if (Math.abs(this._x1 - x06) > epsilon3 || Math.abs(this._y1 - y06) > epsilon3) {
      this._append`L${x06},${y06}`;
    }
    if (!r) return;
    if (da < 0) da = da % tau3 + tau3;
    if (da > tauEpsilon) {
      this._append`A${r},${r},0,1,${cw},${x3 - dx},${y3 - dy}A${r},${r},0,1,${cw},${this._x1 = x06},${this._y1 = y06}`;
    } else if (da > epsilon3) {
      this._append`A${r},${r},0,${+(da >= pi3)},${cw},${this._x1 = x3 + r * Math.cos(a1)},${this._y1 = y3 + r * Math.sin(a1)}`;
    }
  }
  rect(x3, y3, w2, h) {
    this._append`M${this._x0 = this._x1 = +x3},${this._y0 = this._y1 = +y3}h${w2 = +w2}v${+h}h${-w2}Z`;
  }
  toString() {
    return this._;
  }
};
function path() {
  return new Path();
}
path.prototype = Path.prototype;

// node_modules/d3-shape/src/path.js
function withPath(shape) {
  let digits = 3;
  shape.digits = function(_) {
    if (!arguments.length) return digits;
    if (_ == null) {
      digits = null;
    } else {
      const d = Math.floor(_);
      if (!(d >= 0)) throw new RangeError(`invalid digits: ${_}`);
      digits = d;
    }
    return shape;
  };
  return () => new Path(digits);
}

// node_modules/d3-shape/src/arc.js
function arcInnerRadius(d) {
  return d.innerRadius;
}
function arcOuterRadius(d) {
  return d.outerRadius;
}
function arcStartAngle(d) {
  return d.startAngle;
}
function arcEndAngle(d) {
  return d.endAngle;
}
function arcPadAngle(d) {
  return d && d.padAngle;
}
function intersect(x06, y06, x13, y13, x22, y22, x3, y3) {
  var x10 = x13 - x06, y10 = y13 - y06, x32 = x3 - x22, y32 = y3 - y22, t = y32 * x10 - x32 * y10;
  if (t * t < epsilon) return;
  t = (x32 * (y06 - y22) - y32 * (x06 - x22)) / t;
  return [x06 + t * x10, y06 + t * y10];
}
function cornerTangents(x06, y06, x13, y13, r1, rc, cw) {
  var x01 = x06 - x13, y01 = y06 - y13, lo = (cw ? rc : -rc) / sqrt2(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x11 = x06 + ox, y11 = y06 + oy, x10 = x13 + ox, y10 = y13 + oy, x004 = (x11 + x10) / 2, y004 = (y11 + y10) / 2, dx = x10 - x11, dy = y10 - y11, d2 = dx * dx + dy * dy, r = r1 - rc, D2 = x11 * y10 - x10 * y11, d = (dy < 0 ? -1 : 1) * sqrt2(max2(0, r * r * d2 - D2 * D2)), cx0 = (D2 * dy - dx * d) / d2, cy0 = (-D2 * dx - dy * d) / d2, cx1 = (D2 * dy + dx * d) / d2, cy1 = (-D2 * dx + dy * d) / d2, dx0 = cx0 - x004, dy0 = cy0 - y004, dx1 = cx1 - x004, dy1 = cy1 - y004;
  if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;
  return {
    cx: cx0,
    cy: cy0,
    x01: -ox,
    y01: -oy,
    x11: cx0 * (r1 / r - 1),
    y11: cy0 * (r1 / r - 1)
  };
}
function arc_default() {
  var innerRadius = arcInnerRadius, outerRadius = arcOuterRadius, cornerRadius = constant_default3(0), padRadius = null, startAngle = arcStartAngle, endAngle = arcEndAngle, padAngle = arcPadAngle, context = null, path3 = withPath(arc2);
  function arc2() {
    var buffer, r, r0 = +innerRadius.apply(this, arguments), r1 = +outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) - halfPi2, a1 = endAngle.apply(this, arguments) - halfPi2, da = abs(a1 - a0), cw = a1 > a0;
    if (!context) context = buffer = path3();
    if (r1 < r0) r = r1, r1 = r0, r0 = r;
    if (!(r1 > epsilon)) context.moveTo(0, 0);
    else if (da > tau2 - epsilon) {
      context.moveTo(r1 * cos(a0), r1 * sin(a0));
      context.arc(0, 0, r1, a0, a1, !cw);
      if (r0 > epsilon) {
        context.moveTo(r0 * cos(a1), r0 * sin(a1));
        context.arc(0, 0, r0, a1, a0, cw);
      }
    } else {
      var a01 = a0, a11 = a1, a00 = a0, a10 = a1, da0 = da, da1 = da, ap = padAngle.apply(this, arguments) / 2, rp = ap > epsilon && (padRadius ? +padRadius.apply(this, arguments) : sqrt2(r0 * r0 + r1 * r1)), rc = min2(abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments)), rc0 = rc, rc1 = rc, t03, t13;
      if (rp > epsilon) {
        var p0 = asin(rp / r0 * sin(ap)), p1 = asin(rp / r1 * sin(ap));
        if ((da0 -= p0 * 2) > epsilon) p0 *= cw ? 1 : -1, a00 += p0, a10 -= p0;
        else da0 = 0, a00 = a10 = (a0 + a1) / 2;
        if ((da1 -= p1 * 2) > epsilon) p1 *= cw ? 1 : -1, a01 += p1, a11 -= p1;
        else da1 = 0, a01 = a11 = (a0 + a1) / 2;
      }
      var x01 = r1 * cos(a01), y01 = r1 * sin(a01), x10 = r0 * cos(a10), y10 = r0 * sin(a10);
      if (rc > epsilon) {
        var x11 = r1 * cos(a11), y11 = r1 * sin(a11), x004 = r0 * cos(a00), y004 = r0 * sin(a00), oc;
        if (da < pi2) {
          if (oc = intersect(x01, y01, x004, y004, x11, y11, x10, y10)) {
            var ax = x01 - oc[0], ay = y01 - oc[1], bx = x11 - oc[0], by = y11 - oc[1], kc = 1 / sin(acos((ax * bx + ay * by) / (sqrt2(ax * ax + ay * ay) * sqrt2(bx * bx + by * by))) / 2), lc = sqrt2(oc[0] * oc[0] + oc[1] * oc[1]);
            rc0 = min2(rc, (r0 - lc) / (kc - 1));
            rc1 = min2(rc, (r1 - lc) / (kc + 1));
          } else {
            rc0 = rc1 = 0;
          }
        }
      }
      if (!(da1 > epsilon)) context.moveTo(x01, y01);
      else if (rc1 > epsilon) {
        t03 = cornerTangents(x004, y004, x01, y01, r1, rc1, cw);
        t13 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);
        context.moveTo(t03.cx + t03.x01, t03.cy + t03.y01);
        if (rc1 < rc) context.arc(t03.cx, t03.cy, rc1, atan2(t03.y01, t03.x01), atan2(t13.y01, t13.x01), !cw);
        else {
          context.arc(t03.cx, t03.cy, rc1, atan2(t03.y01, t03.x01), atan2(t03.y11, t03.x11), !cw);
          context.arc(0, 0, r1, atan2(t03.cy + t03.y11, t03.cx + t03.x11), atan2(t13.cy + t13.y11, t13.cx + t13.x11), !cw);
          context.arc(t13.cx, t13.cy, rc1, atan2(t13.y11, t13.x11), atan2(t13.y01, t13.x01), !cw);
        }
      } else context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);
      if (!(r0 > epsilon) || !(da0 > epsilon)) context.lineTo(x10, y10);
      else if (rc0 > epsilon) {
        t03 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
        t13 = cornerTangents(x01, y01, x004, y004, r0, -rc0, cw);
        context.lineTo(t03.cx + t03.x01, t03.cy + t03.y01);
        if (rc0 < rc) context.arc(t03.cx, t03.cy, rc0, atan2(t03.y01, t03.x01), atan2(t13.y01, t13.x01), !cw);
        else {
          context.arc(t03.cx, t03.cy, rc0, atan2(t03.y01, t03.x01), atan2(t03.y11, t03.x11), !cw);
          context.arc(0, 0, r0, atan2(t03.cy + t03.y11, t03.cx + t03.x11), atan2(t13.cy + t13.y11, t13.cx + t13.x11), cw);
          context.arc(t13.cx, t13.cy, rc0, atan2(t13.y11, t13.x11), atan2(t13.y01, t13.x01), !cw);
        }
      } else context.arc(0, 0, r0, a10, a00, cw);
    }
    context.closePath();
    if (buffer) return context = null, buffer + "" || null;
  }
  arc2.centroid = function() {
    var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a4 = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi2 / 2;
    return [cos(a4) * r, sin(a4) * r];
  };
  arc2.innerRadius = function(_) {
    return arguments.length ? (innerRadius = typeof _ === "function" ? _ : constant_default3(+_), arc2) : innerRadius;
  };
  arc2.outerRadius = function(_) {
    return arguments.length ? (outerRadius = typeof _ === "function" ? _ : constant_default3(+_), arc2) : outerRadius;
  };
  arc2.cornerRadius = function(_) {
    return arguments.length ? (cornerRadius = typeof _ === "function" ? _ : constant_default3(+_), arc2) : cornerRadius;
  };
  arc2.padRadius = function(_) {
    return arguments.length ? (padRadius = _ == null ? null : typeof _ === "function" ? _ : constant_default3(+_), arc2) : padRadius;
  };
  arc2.startAngle = function(_) {
    return arguments.length ? (startAngle = typeof _ === "function" ? _ : constant_default3(+_), arc2) : startAngle;
  };
  arc2.endAngle = function(_) {
    return arguments.length ? (endAngle = typeof _ === "function" ? _ : constant_default3(+_), arc2) : endAngle;
  };
  arc2.padAngle = function(_) {
    return arguments.length ? (padAngle = typeof _ === "function" ? _ : constant_default3(+_), arc2) : padAngle;
  };
  arc2.context = function(_) {
    return arguments.length ? (context = _ == null ? null : _, arc2) : context;
  };
  return arc2;
}

// node_modules/d3-shape/src/array.js
var slice = Array.prototype.slice;
function array_default2(x3) {
  return typeof x3 === "object" && "length" in x3 ? x3 : Array.from(x3);
}

// node_modules/d3-shape/src/curve/linear.js
function Linear(context) {
  this._context = context;
}
Linear.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
      default:
        this._context.lineTo(x3, y3);
        break;
    }
  }
};
function linear_default(context) {
  return new Linear(context);
}

// node_modules/d3-shape/src/point.js
function x(p) {
  return p[0];
}
function y(p) {
  return p[1];
}

// node_modules/d3-shape/src/line.js
function line_default(x3, y3) {
  var defined = constant_default3(true), context = null, curve = linear_default, output = null, path3 = withPath(line5);
  x3 = typeof x3 === "function" ? x3 : x3 === void 0 ? x : constant_default3(x3);
  y3 = typeof y3 === "function" ? y3 : y3 === void 0 ? y : constant_default3(y3);
  function line5(data) {
    var i, n = (data = array_default2(data)).length, d, defined0 = false, buffer;
    if (context == null) output = curve(buffer = path3());
    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data[i], i, data)) === defined0) {
        if (defined0 = !defined0) output.lineStart();
        else output.lineEnd();
      }
      if (defined0) output.point(+x3(d, i, data), +y3(d, i, data));
    }
    if (buffer) return output = null, buffer + "" || null;
  }
  line5.x = function(_) {
    return arguments.length ? (x3 = typeof _ === "function" ? _ : constant_default3(+_), line5) : x3;
  };
  line5.y = function(_) {
    return arguments.length ? (y3 = typeof _ === "function" ? _ : constant_default3(+_), line5) : y3;
  };
  line5.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : constant_default3(!!_), line5) : defined;
  };
  line5.curve = function(_) {
    return arguments.length ? (curve = _, context != null && (output = curve(context)), line5) : curve;
  };
  line5.context = function(_) {
    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), line5) : context;
  };
  return line5;
}

// node_modules/d3-shape/src/area.js
function area_default(x06, y06, y13) {
  var x13 = null, defined = constant_default3(true), context = null, curve = linear_default, output = null, path3 = withPath(area2);
  x06 = typeof x06 === "function" ? x06 : x06 === void 0 ? x : constant_default3(+x06);
  y06 = typeof y06 === "function" ? y06 : y06 === void 0 ? constant_default3(0) : constant_default3(+y06);
  y13 = typeof y13 === "function" ? y13 : y13 === void 0 ? y : constant_default3(+y13);
  function area2(data) {
    var i, j, k4, n = (data = array_default2(data)).length, d, defined0 = false, buffer, x0z = new Array(n), y0z = new Array(n);
    if (context == null) output = curve(buffer = path3());
    for (i = 0; i <= n; ++i) {
      if (!(i < n && defined(d = data[i], i, data)) === defined0) {
        if (defined0 = !defined0) {
          j = i;
          output.areaStart();
          output.lineStart();
        } else {
          output.lineEnd();
          output.lineStart();
          for (k4 = i - 1; k4 >= j; --k4) {
            output.point(x0z[k4], y0z[k4]);
          }
          output.lineEnd();
          output.areaEnd();
        }
      }
      if (defined0) {
        x0z[i] = +x06(d, i, data), y0z[i] = +y06(d, i, data);
        output.point(x13 ? +x13(d, i, data) : x0z[i], y13 ? +y13(d, i, data) : y0z[i]);
      }
    }
    if (buffer) return output = null, buffer + "" || null;
  }
  function arealine() {
    return line_default().defined(defined).curve(curve).context(context);
  }
  area2.x = function(_) {
    return arguments.length ? (x06 = typeof _ === "function" ? _ : constant_default3(+_), x13 = null, area2) : x06;
  };
  area2.x0 = function(_) {
    return arguments.length ? (x06 = typeof _ === "function" ? _ : constant_default3(+_), area2) : x06;
  };
  area2.x1 = function(_) {
    return arguments.length ? (x13 = _ == null ? null : typeof _ === "function" ? _ : constant_default3(+_), area2) : x13;
  };
  area2.y = function(_) {
    return arguments.length ? (y06 = typeof _ === "function" ? _ : constant_default3(+_), y13 = null, area2) : y06;
  };
  area2.y0 = function(_) {
    return arguments.length ? (y06 = typeof _ === "function" ? _ : constant_default3(+_), area2) : y06;
  };
  area2.y1 = function(_) {
    return arguments.length ? (y13 = _ == null ? null : typeof _ === "function" ? _ : constant_default3(+_), area2) : y13;
  };
  area2.lineX0 = area2.lineY0 = function() {
    return arealine().x(x06).y(y06);
  };
  area2.lineY1 = function() {
    return arealine().x(x06).y(y13);
  };
  area2.lineX1 = function() {
    return arealine().x(x13).y(y06);
  };
  area2.defined = function(_) {
    return arguments.length ? (defined = typeof _ === "function" ? _ : constant_default3(!!_), area2) : defined;
  };
  area2.curve = function(_) {
    return arguments.length ? (curve = _, context != null && (output = curve(context)), area2) : curve;
  };
  area2.context = function(_) {
    return arguments.length ? (_ == null ? context = output = null : output = curve(context = _), area2) : context;
  };
  return area2;
}

// node_modules/d3-shape/src/descending.js
function descending_default(a4, b) {
  return b < a4 ? -1 : b > a4 ? 1 : b >= a4 ? 0 : NaN;
}

// node_modules/d3-shape/src/identity.js
function identity_default2(d) {
  return d;
}

// node_modules/d3-shape/src/pie.js
function pie_default() {
  var value2 = identity_default2, sortValues = descending_default, sort2 = null, startAngle = constant_default3(0), endAngle = constant_default3(tau2), padAngle = constant_default3(0);
  function pie(data) {
    var i, n = (data = array_default2(data)).length, j, k4, sum5 = 0, index3 = new Array(n), arcs = new Array(n), a0 = +startAngle.apply(this, arguments), da = Math.min(tau2, Math.max(-tau2, endAngle.apply(this, arguments) - a0)), a1, p = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)), pa = p * (da < 0 ? -1 : 1), v;
    for (i = 0; i < n; ++i) {
      if ((v = arcs[index3[i] = i] = +value2(data[i], i, data)) > 0) {
        sum5 += v;
      }
    }
    if (sortValues != null) index3.sort(function(i2, j2) {
      return sortValues(arcs[i2], arcs[j2]);
    });
    else if (sort2 != null) index3.sort(function(i2, j2) {
      return sort2(data[i2], data[j2]);
    });
    for (i = 0, k4 = sum5 ? (da - n * pa) / sum5 : 0; i < n; ++i, a0 = a1) {
      j = index3[i], v = arcs[j], a1 = a0 + (v > 0 ? v * k4 : 0) + pa, arcs[j] = {
        data: data[j],
        index: i,
        value: v,
        startAngle: a0,
        endAngle: a1,
        padAngle: p
      };
    }
    return arcs;
  }
  pie.value = function(_) {
    return arguments.length ? (value2 = typeof _ === "function" ? _ : constant_default3(+_), pie) : value2;
  };
  pie.sortValues = function(_) {
    return arguments.length ? (sortValues = _, sort2 = null, pie) : sortValues;
  };
  pie.sort = function(_) {
    return arguments.length ? (sort2 = _, sortValues = null, pie) : sort2;
  };
  pie.startAngle = function(_) {
    return arguments.length ? (startAngle = typeof _ === "function" ? _ : constant_default3(+_), pie) : startAngle;
  };
  pie.endAngle = function(_) {
    return arguments.length ? (endAngle = typeof _ === "function" ? _ : constant_default3(+_), pie) : endAngle;
  };
  pie.padAngle = function(_) {
    return arguments.length ? (padAngle = typeof _ === "function" ? _ : constant_default3(+_), pie) : padAngle;
  };
  return pie;
}

// node_modules/d3-shape/src/curve/radial.js
var curveRadialLinear = curveRadial(linear_default);
function Radial(curve) {
  this._curve = curve;
}
Radial.prototype = {
  areaStart: function() {
    this._curve.areaStart();
  },
  areaEnd: function() {
    this._curve.areaEnd();
  },
  lineStart: function() {
    this._curve.lineStart();
  },
  lineEnd: function() {
    this._curve.lineEnd();
  },
  point: function(a4, r) {
    this._curve.point(r * Math.sin(a4), r * -Math.cos(a4));
  }
};
function curveRadial(curve) {
  function radial2(context) {
    return new Radial(curve(context));
  }
  radial2._curve = curve;
  return radial2;
}

// node_modules/d3-shape/src/lineRadial.js
function lineRadial(l) {
  var c3 = l.curve;
  l.angle = l.x, delete l.x;
  l.radius = l.y, delete l.y;
  l.curve = function(_) {
    return arguments.length ? c3(curveRadial(_)) : c3()._curve;
  };
  return l;
}

// node_modules/d3-shape/src/areaRadial.js
function areaRadial_default() {
  var a4 = area_default().curve(curveRadialLinear), c3 = a4.curve, x06 = a4.lineX0, x13 = a4.lineX1, y06 = a4.lineY0, y13 = a4.lineY1;
  a4.angle = a4.x, delete a4.x;
  a4.startAngle = a4.x0, delete a4.x0;
  a4.endAngle = a4.x1, delete a4.x1;
  a4.radius = a4.y, delete a4.y;
  a4.innerRadius = a4.y0, delete a4.y0;
  a4.outerRadius = a4.y1, delete a4.y1;
  a4.lineStartAngle = function() {
    return lineRadial(x06());
  }, delete a4.lineX0;
  a4.lineEndAngle = function() {
    return lineRadial(x13());
  }, delete a4.lineX1;
  a4.lineInnerRadius = function() {
    return lineRadial(y06());
  }, delete a4.lineY0;
  a4.lineOuterRadius = function() {
    return lineRadial(y13());
  }, delete a4.lineY1;
  a4.curve = function(_) {
    return arguments.length ? c3(curveRadial(_)) : c3()._curve;
  };
  return a4;
}

// node_modules/d3-shape/src/symbol/asterisk.js
var sqrt3 = sqrt2(3);

// node_modules/d3-shape/src/symbol/circle.js
var circle_default = {
  draw(context, size2) {
    const r = sqrt2(size2 / pi2);
    context.moveTo(r, 0);
    context.arc(0, 0, r, 0, tau2);
  }
};

// node_modules/d3-shape/src/symbol/cross.js
var cross_default = {
  draw(context, size2) {
    const r = sqrt2(size2 / 5) / 2;
    context.moveTo(-3 * r, -r);
    context.lineTo(-r, -r);
    context.lineTo(-r, -3 * r);
    context.lineTo(r, -3 * r);
    context.lineTo(r, -r);
    context.lineTo(3 * r, -r);
    context.lineTo(3 * r, r);
    context.lineTo(r, r);
    context.lineTo(r, 3 * r);
    context.lineTo(-r, 3 * r);
    context.lineTo(-r, r);
    context.lineTo(-3 * r, r);
    context.closePath();
  }
};

// node_modules/d3-shape/src/symbol/diamond.js
var tan30 = sqrt2(1 / 3);
var tan30_2 = tan30 * 2;
var diamond_default = {
  draw(context, size2) {
    const y3 = sqrt2(size2 / tan30_2);
    const x3 = y3 * tan30;
    context.moveTo(0, -y3);
    context.lineTo(x3, 0);
    context.lineTo(0, y3);
    context.lineTo(-x3, 0);
    context.closePath();
  }
};

// node_modules/d3-shape/src/symbol/square.js
var square_default = {
  draw(context, size2) {
    const w2 = sqrt2(size2);
    const x3 = -w2 / 2;
    context.rect(x3, x3, w2, w2);
  }
};

// node_modules/d3-shape/src/symbol/star.js
var ka = 0.8908130915292852;
var kr = sin(pi2 / 10) / sin(7 * pi2 / 10);
var kx = sin(tau2 / 10) * kr;
var ky = -cos(tau2 / 10) * kr;
var star_default = {
  draw(context, size2) {
    const r = sqrt2(size2 * ka);
    const x3 = kx * r;
    const y3 = ky * r;
    context.moveTo(0, -r);
    context.lineTo(x3, y3);
    for (let i = 1; i < 5; ++i) {
      const a4 = tau2 * i / 5;
      const c3 = cos(a4);
      const s3 = sin(a4);
      context.lineTo(s3 * r, -c3 * r);
      context.lineTo(c3 * x3 - s3 * y3, s3 * x3 + c3 * y3);
    }
    context.closePath();
  }
};

// node_modules/d3-shape/src/symbol/triangle.js
var sqrt32 = sqrt2(3);
var triangle_default = {
  draw(context, size2) {
    const y3 = -sqrt2(size2 / (sqrt32 * 3));
    context.moveTo(0, y3 * 2);
    context.lineTo(-sqrt32 * y3, -y3);
    context.lineTo(sqrt32 * y3, -y3);
    context.closePath();
  }
};

// node_modules/d3-shape/src/symbol/triangle2.js
var sqrt33 = sqrt2(3);

// node_modules/d3-shape/src/symbol/wye.js
var c = -0.5;
var s = sqrt2(3) / 2;
var k = 1 / sqrt2(12);
var a = (k / 2 + 1) * 3;
var wye_default = {
  draw(context, size2) {
    const r = sqrt2(size2 / a);
    const x06 = r / 2, y06 = r * k;
    const x13 = x06, y13 = r * k + r;
    const x22 = -x13, y22 = y13;
    context.moveTo(x06, y06);
    context.lineTo(x13, y13);
    context.lineTo(x22, y22);
    context.lineTo(c * x06 - s * y06, s * x06 + c * y06);
    context.lineTo(c * x13 - s * y13, s * x13 + c * y13);
    context.lineTo(c * x22 - s * y22, s * x22 + c * y22);
    context.lineTo(c * x06 + s * y06, c * y06 - s * x06);
    context.lineTo(c * x13 + s * y13, c * y13 - s * x13);
    context.lineTo(c * x22 + s * y22, c * y22 - s * x22);
    context.closePath();
  }
};

// node_modules/d3-shape/src/symbol.js
function Symbol2(type2, size2) {
  let context = null, path3 = withPath(symbol);
  type2 = typeof type2 === "function" ? type2 : constant_default3(type2 || circle_default);
  size2 = typeof size2 === "function" ? size2 : constant_default3(size2 === void 0 ? 64 : +size2);
  function symbol() {
    let buffer;
    if (!context) context = buffer = path3();
    type2.apply(this, arguments).draw(context, +size2.apply(this, arguments));
    if (buffer) return context = null, buffer + "" || null;
  }
  symbol.type = function(_) {
    return arguments.length ? (type2 = typeof _ === "function" ? _ : constant_default3(_), symbol) : type2;
  };
  symbol.size = function(_) {
    return arguments.length ? (size2 = typeof _ === "function" ? _ : constant_default3(+_), symbol) : size2;
  };
  symbol.context = function(_) {
    return arguments.length ? (context = _ == null ? null : _, symbol) : context;
  };
  return symbol;
}

// node_modules/d3-shape/src/noop.js
function noop_default() {
}

// node_modules/d3-shape/src/curve/basis.js
function point2(that, x3, y3) {
  that._context.bezierCurveTo(
    (2 * that._x0 + that._x1) / 3,
    (2 * that._y0 + that._y1) / 3,
    (that._x0 + 2 * that._x1) / 3,
    (that._y0 + 2 * that._y1) / 3,
    (that._x0 + 4 * that._x1 + x3) / 6,
    (that._y0 + 4 * that._y1 + y3) / 6
  );
}
function Basis(context) {
  this._context = context;
}
Basis.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 3:
        point2(this, this._x1, this._y1);
      case 2:
        this._context.lineTo(this._x1, this._y1);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
      default:
        point2(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
  }
};
function basis_default2(context) {
  return new Basis(context);
}

// node_modules/d3-shape/src/curve/basisClosed.js
function BasisClosed(context) {
  this._context = context;
}
BasisClosed.prototype = {
  areaStart: noop_default,
  areaEnd: noop_default,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x2, this._y2);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
        this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x2, this._y2);
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        break;
      }
    }
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x2 = x3, this._y2 = y3;
        break;
      case 1:
        this._point = 2;
        this._x3 = x3, this._y3 = y3;
        break;
      case 2:
        this._point = 3;
        this._x4 = x3, this._y4 = y3;
        this._context.moveTo((this._x0 + 4 * this._x1 + x3) / 6, (this._y0 + 4 * this._y1 + y3) / 6);
        break;
      default:
        point2(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
  }
};
function basisClosed_default2(context) {
  return new BasisClosed(context);
}

// node_modules/d3-shape/src/curve/basisOpen.js
function BasisOpen(context) {
  this._context = context;
}
BasisOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        var x06 = (this._x0 + 4 * this._x1 + x3) / 6, y06 = (this._y0 + 4 * this._y1 + y3) / 6;
        this._line ? this._context.lineTo(x06, y06) : this._context.moveTo(x06, y06);
        break;
      case 3:
        this._point = 4;
      default:
        point2(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
  }
};
function basisOpen_default(context) {
  return new BasisOpen(context);
}

// node_modules/d3-shape/src/curve/bundle.js
function Bundle(context, beta) {
  this._basis = new Basis(context);
  this._beta = beta;
}
Bundle.prototype = {
  lineStart: function() {
    this._x = [];
    this._y = [];
    this._basis.lineStart();
  },
  lineEnd: function() {
    var x3 = this._x, y3 = this._y, j = x3.length - 1;
    if (j > 0) {
      var x06 = x3[0], y06 = y3[0], dx = x3[j] - x06, dy = y3[j] - y06, i = -1, t;
      while (++i <= j) {
        t = i / j;
        this._basis.point(
          this._beta * x3[i] + (1 - this._beta) * (x06 + t * dx),
          this._beta * y3[i] + (1 - this._beta) * (y06 + t * dy)
        );
      }
    }
    this._x = this._y = null;
    this._basis.lineEnd();
  },
  point: function(x3, y3) {
    this._x.push(+x3);
    this._y.push(+y3);
  }
};
var bundle_default = function custom10(beta) {
  function bundle(context) {
    return beta === 1 ? new Basis(context) : new Bundle(context, beta);
  }
  bundle.beta = function(beta2) {
    return custom10(+beta2);
  };
  return bundle;
}(0.85);

// node_modules/d3-shape/src/curve/cardinal.js
function point3(that, x3, y3) {
  that._context.bezierCurveTo(
    that._x1 + that._k * (that._x2 - that._x0),
    that._y1 + that._k * (that._y2 - that._y0),
    that._x2 + that._k * (that._x1 - x3),
    that._y2 + that._k * (that._y1 - y3),
    that._x2,
    that._y2
  );
}
function Cardinal(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}
Cardinal.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x2, this._y2);
        break;
      case 3:
        point3(this, this._x1, this._y1);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        this._x1 = x3, this._y1 = y3;
        break;
      case 2:
        this._point = 3;
      default:
        point3(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var cardinal_default = function custom11(tension) {
  function cardinal(context) {
    return new Cardinal(context, tension);
  }
  cardinal.tension = function(tension2) {
    return custom11(+tension2);
  };
  return cardinal;
}(0);

// node_modules/d3-shape/src/curve/cardinalClosed.js
function CardinalClosed(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}
CardinalClosed.prototype = {
  areaStart: noop_default,
  areaEnd: noop_default,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x3 = x3, this._y3 = y3;
        break;
      case 1:
        this._point = 2;
        this._context.moveTo(this._x4 = x3, this._y4 = y3);
        break;
      case 2:
        this._point = 3;
        this._x5 = x3, this._y5 = y3;
        break;
      default:
        point3(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var cardinalClosed_default = function custom12(tension) {
  function cardinal(context) {
    return new CardinalClosed(context, tension);
  }
  cardinal.tension = function(tension2) {
    return custom12(+tension2);
  };
  return cardinal;
}(0);

// node_modules/d3-shape/src/curve/cardinalOpen.js
function CardinalOpen(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}
CardinalOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
        break;
      case 3:
        this._point = 4;
      default:
        point3(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var cardinalOpen_default = function custom13(tension) {
  function cardinal(context) {
    return new CardinalOpen(context, tension);
  }
  cardinal.tension = function(tension2) {
    return custom13(+tension2);
  };
  return cardinal;
}(0);

// node_modules/d3-shape/src/curve/catmullRom.js
function point4(that, x3, y3) {
  var x13 = that._x1, y13 = that._y1, x22 = that._x2, y22 = that._y2;
  if (that._l01_a > epsilon) {
    var a4 = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
    x13 = (x13 * a4 - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
    y13 = (y13 * a4 - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
  }
  if (that._l23_a > epsilon) {
    var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m2 = 3 * that._l23_a * (that._l23_a + that._l12_a);
    x22 = (x22 * b + that._x1 * that._l23_2a - x3 * that._l12_2a) / m2;
    y22 = (y22 * b + that._y1 * that._l23_2a - y3 * that._l12_2a) / m2;
  }
  that._context.bezierCurveTo(x13, y13, x22, y22, that._x2, that._y2);
}
function CatmullRom(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}
CatmullRom.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x2, this._y2);
        break;
      case 3:
        this.point(this._x2, this._y2);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) {
      var x23 = this._x2 - x3, y23 = this._y2 - y3;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
      default:
        point4(this, x3, y3);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var catmullRom_default = function custom14(alpha) {
  function catmullRom(context) {
    return alpha ? new CatmullRom(context, alpha) : new Cardinal(context, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom14(+alpha2);
  };
  return catmullRom;
}(0.5);

// node_modules/d3-shape/src/curve/catmullRomClosed.js
function CatmullRomClosed(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}
CatmullRomClosed.prototype = {
  areaStart: noop_default,
  areaEnd: noop_default,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) {
      var x23 = this._x2 - x3, y23 = this._y2 - y3;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x3 = x3, this._y3 = y3;
        break;
      case 1:
        this._point = 2;
        this._context.moveTo(this._x4 = x3, this._y4 = y3);
        break;
      case 2:
        this._point = 3;
        this._x5 = x3, this._y5 = y3;
        break;
      default:
        point4(this, x3, y3);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var catmullRomClosed_default = function custom15(alpha) {
  function catmullRom(context) {
    return alpha ? new CatmullRomClosed(context, alpha) : new CardinalClosed(context, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom15(+alpha2);
  };
  return catmullRom;
}(0.5);

// node_modules/d3-shape/src/curve/catmullRomOpen.js
function CatmullRomOpen(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}
CatmullRomOpen.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) {
      var x23 = this._x2 - x3, y23 = this._y2 - y3;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
        break;
      case 3:
        this._point = 4;
      default:
        point4(this, x3, y3);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var catmullRomOpen_default = function custom16(alpha) {
  function catmullRom(context) {
    return alpha ? new CatmullRomOpen(context, alpha) : new CardinalOpen(context, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom16(+alpha2);
  };
  return catmullRom;
}(0.5);

// node_modules/d3-shape/src/curve/linearClosed.js
function LinearClosed(context) {
  this._context = context;
}
LinearClosed.prototype = {
  areaStart: noop_default,
  areaEnd: noop_default,
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._point) this._context.closePath();
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) this._context.lineTo(x3, y3);
    else this._point = 1, this._context.moveTo(x3, y3);
  }
};
function linearClosed_default(context) {
  return new LinearClosed(context);
}

// node_modules/d3-shape/src/curve/monotone.js
function sign(x3) {
  return x3 < 0 ? -1 : 1;
}
function slope3(that, x22, y22) {
  var h0 = that._x1 - that._x0, h1 = x22 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y22 - that._y1) / (h1 || h0 < 0 && -0), p = (s0 * h1 + s1 * h0) / (h0 + h1);
  return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
}
function slope2(that, t) {
  var h = that._x1 - that._x0;
  return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
}
function point5(that, t03, t13) {
  var x06 = that._x0, y06 = that._y0, x13 = that._x1, y13 = that._y1, dx = (x13 - x06) / 3;
  that._context.bezierCurveTo(x06 + dx, y06 + dx * t03, x13 - dx, y13 - dx * t13, x13, y13);
}
function MonotoneX(context) {
  this._context = context;
}
MonotoneX.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x1, this._y1);
        break;
      case 3:
        point5(this, this._t0, slope2(this, this._t0));
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    var t13 = NaN;
    x3 = +x3, y3 = +y3;
    if (x3 === this._x1 && y3 === this._y1) return;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        point5(this, slope2(this, t13 = slope3(this, x3, y3)), t13);
        break;
      default:
        point5(this, this._t0, t13 = slope3(this, x3, y3));
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
    this._t0 = t13;
  }
};
function MonotoneY(context) {
  this._context = new ReflectContext(context);
}
(MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x3, y3) {
  MonotoneX.prototype.point.call(this, y3, x3);
};
function ReflectContext(context) {
  this._context = context;
}
ReflectContext.prototype = {
  moveTo: function(x3, y3) {
    this._context.moveTo(y3, x3);
  },
  closePath: function() {
    this._context.closePath();
  },
  lineTo: function(x3, y3) {
    this._context.lineTo(y3, x3);
  },
  bezierCurveTo: function(x13, y13, x22, y22, x3, y3) {
    this._context.bezierCurveTo(y13, x13, y22, x22, y3, x3);
  }
};
function monotoneX(context) {
  return new MonotoneX(context);
}
function monotoneY(context) {
  return new MonotoneY(context);
}

// node_modules/d3-shape/src/curve/natural.js
function Natural(context) {
  this._context = context;
}
Natural.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = [];
    this._y = [];
  },
  lineEnd: function() {
    var x3 = this._x, y3 = this._y, n = x3.length;
    if (n) {
      this._line ? this._context.lineTo(x3[0], y3[0]) : this._context.moveTo(x3[0], y3[0]);
      if (n === 2) {
        this._context.lineTo(x3[1], y3[1]);
      } else {
        var px = controlPoints(x3), py = controlPoints(y3);
        for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
          this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x3[i1], y3[i1]);
        }
      }
    }
    if (this._line || this._line !== 0 && n === 1) this._context.closePath();
    this._line = 1 - this._line;
    this._x = this._y = null;
  },
  point: function(x3, y3) {
    this._x.push(+x3);
    this._y.push(+y3);
  }
};
function controlPoints(x3) {
  var i, n = x3.length - 1, m2, a4 = new Array(n), b = new Array(n), r = new Array(n);
  a4[0] = 0, b[0] = 2, r[0] = x3[0] + 2 * x3[1];
  for (i = 1; i < n - 1; ++i) a4[i] = 1, b[i] = 4, r[i] = 4 * x3[i] + 2 * x3[i + 1];
  a4[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x3[n - 1] + x3[n];
  for (i = 1; i < n; ++i) m2 = a4[i] / b[i - 1], b[i] -= m2, r[i] -= m2 * r[i - 1];
  a4[n - 1] = r[n - 1] / b[n - 1];
  for (i = n - 2; i >= 0; --i) a4[i] = (r[i] - a4[i + 1]) / b[i];
  b[n - 1] = (x3[n] + a4[n - 1]) / 2;
  for (i = 0; i < n - 1; ++i) b[i] = 2 * x3[i + 1] - a4[i + 1];
  return [a4, b];
}
function natural_default(context) {
  return new Natural(context);
}

// node_modules/d3-shape/src/curve/step.js
function Step(context, t) {
  this._context = context;
  this._t = t;
}
Step.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = this._y = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (0 < this._t && this._t < 1 && this._point === 2) this._context.lineTo(this._x, this._y);
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    if (this._line >= 0) this._t = 1 - this._t, this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
      default: {
        if (this._t <= 0) {
          this._context.lineTo(this._x, y3);
          this._context.lineTo(x3, y3);
        } else {
          var x13 = this._x * (1 - this._t) + x3 * this._t;
          this._context.lineTo(x13, this._y);
          this._context.lineTo(x13, y3);
        }
        break;
      }
    }
    this._x = x3, this._y = y3;
  }
};
function step_default(context) {
  return new Step(context, 0.5);
}
function stepBefore(context) {
  return new Step(context, 0);
}
function stepAfter(context) {
  return new Step(context, 1);
}

// node_modules/d3-interpolate-path/build/d3-interpolate-path.mjs
function ownKeys(object2, enumerableOnly) {
  var keys = Object.keys(object2);
  if (Object.getOwnPropertySymbols) {
    var symbols2 = Object.getOwnPropertySymbols(object2);
    if (enumerableOnly) {
      symbols2 = symbols2.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
      });
    }
    keys.push.apply(keys, symbols2);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    if (i % 2) {
      ownKeys(Object(source), true).forEach(function(key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }
  return target;
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function _defineProperty(obj, key, value2) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value2,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value2;
  }
  return obj;
}
function _extends() {
  _extends = Object.assign || function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}
function _createForOfIteratorHelper(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (!it) {
    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it) o = it;
      var i = 0;
      var F = function() {
      };
      return {
        s: F,
        n: function() {
          if (i >= o.length) return {
            done: true
          };
          return {
            done: false,
            value: o[i++]
          };
        },
        e: function(e) {
          throw e;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true, didErr = false, err;
  return {
    s: function() {
      it = it.call(o);
    },
    n: function() {
      var step = it.next();
      normalCompletion = step.done;
      return step;
    },
    e: function(e) {
      didErr = true;
      err = e;
    },
    f: function() {
      try {
        if (!normalCompletion && it.return != null) it.return();
      } finally {
        if (didErr) throw err;
      }
    }
  };
}
function decasteljau(points3, t) {
  var left3 = [];
  var right3 = [];
  function decasteljauRecurse(points4, t4) {
    if (points4.length === 1) {
      left3.push(points4[0]);
      right3.push(points4[0]);
    } else {
      var newPoints = Array(points4.length - 1);
      for (var i = 0; i < newPoints.length; i++) {
        if (i === 0) {
          left3.push(points4[0]);
        }
        if (i === newPoints.length - 1) {
          right3.push(points4[i + 1]);
        }
        newPoints[i] = [(1 - t4) * points4[i][0] + t4 * points4[i + 1][0], (1 - t4) * points4[i][1] + t4 * points4[i + 1][1]];
      }
      decasteljauRecurse(newPoints, t4);
    }
  }
  if (points3.length) {
    decasteljauRecurse(points3, t);
  }
  return {
    left: left3,
    right: right3.reverse()
  };
}
function pointsToCommand(points3) {
  var command = {};
  if (points3.length === 4) {
    command.x2 = points3[2][0];
    command.y2 = points3[2][1];
  }
  if (points3.length >= 3) {
    command.x1 = points3[1][0];
    command.y1 = points3[1][1];
  }
  command.x = points3[points3.length - 1][0];
  command.y = points3[points3.length - 1][1];
  if (points3.length === 4) {
    command.type = "C";
  } else if (points3.length === 3) {
    command.type = "Q";
  } else {
    command.type = "L";
  }
  return command;
}
function splitCurveAsPoints(points3, segmentCount) {
  segmentCount = segmentCount || 2;
  var segments = [];
  var remainingCurve = points3;
  var tIncrement = 1 / segmentCount;
  for (var i = 0; i < segmentCount - 1; i++) {
    var tRelative = tIncrement / (1 - tIncrement * i);
    var split = decasteljau(remainingCurve, tRelative);
    segments.push(split.left);
    remainingCurve = split.right;
  }
  segments.push(remainingCurve);
  return segments;
}
function splitCurve(commandStart, commandEnd, segmentCount) {
  var points3 = [[commandStart.x, commandStart.y]];
  if (commandEnd.x1 != null) {
    points3.push([commandEnd.x1, commandEnd.y1]);
  }
  if (commandEnd.x2 != null) {
    points3.push([commandEnd.x2, commandEnd.y2]);
  }
  points3.push([commandEnd.x, commandEnd.y]);
  return splitCurveAsPoints(points3, segmentCount).map(pointsToCommand);
}
var commandTokenRegex = /[MLCSTQAHVZmlcstqahv]|-?[\d.e+-]+/g;
var typeMap = {
  M: ["x", "y"],
  L: ["x", "y"],
  H: ["x"],
  V: ["y"],
  C: ["x1", "y1", "x2", "y2", "x", "y"],
  S: ["x2", "y2", "x", "y"],
  Q: ["x1", "y1", "x", "y"],
  T: ["x", "y"],
  A: ["rx", "ry", "xAxisRotation", "largeArcFlag", "sweepFlag", "x", "y"],
  Z: []
};
Object.keys(typeMap).forEach(function(key) {
  typeMap[key.toLowerCase()] = typeMap[key];
});
function arrayOfLength(length, value2) {
  var array3 = Array(length);
  for (var i = 0; i < length; i++) {
    array3[i] = value2;
  }
  return array3;
}
function commandToString(command) {
  return "".concat(command.type).concat(typeMap[command.type].map(function(p) {
    return command[p];
  }).join(","));
}
function convertToSameType(aCommand, bCommand) {
  var conversionMap = {
    x1: "x",
    y1: "y",
    x2: "x",
    y2: "y"
  };
  var readFromBKeys = ["xAxisRotation", "largeArcFlag", "sweepFlag"];
  if (aCommand.type !== bCommand.type && bCommand.type.toUpperCase() !== "M") {
    var aConverted = {};
    Object.keys(bCommand).forEach(function(bKey) {
      var bValue = bCommand[bKey];
      var aValue = aCommand[bKey];
      if (aValue === void 0) {
        if (readFromBKeys.includes(bKey)) {
          aValue = bValue;
        } else {
          if (aValue === void 0 && conversionMap[bKey]) {
            aValue = aCommand[conversionMap[bKey]];
          }
          if (aValue === void 0) {
            aValue = 0;
          }
        }
      }
      aConverted[bKey] = aValue;
    });
    aConverted.type = bCommand.type;
    aCommand = aConverted;
  }
  return aCommand;
}
function splitSegment(commandStart, commandEnd, segmentCount) {
  var segments = [];
  if (commandEnd.type === "L" || commandEnd.type === "Q" || commandEnd.type === "C") {
    segments = segments.concat(splitCurve(commandStart, commandEnd, segmentCount));
  } else {
    var copyCommand = _extends({}, commandStart);
    if (copyCommand.type === "M") {
      copyCommand.type = "L";
    }
    segments = segments.concat(arrayOfLength(segmentCount - 1).map(function() {
      return copyCommand;
    }));
    segments.push(commandEnd);
  }
  return segments;
}
function extend2(commandsToExtend, referenceCommands, excludeSegment) {
  var numSegmentsToExtend = commandsToExtend.length - 1;
  var numReferenceSegments = referenceCommands.length - 1;
  var segmentRatio = numSegmentsToExtend / numReferenceSegments;
  var countPointsPerSegment = arrayOfLength(numReferenceSegments).reduce(function(accum, d, i) {
    var insertIndex = Math.floor(segmentRatio * i);
    if (excludeSegment && insertIndex < commandsToExtend.length - 1 && excludeSegment(commandsToExtend[insertIndex], commandsToExtend[insertIndex + 1])) {
      var addToPriorSegment = segmentRatio * i % 1 < 0.5;
      if (accum[insertIndex]) {
        if (addToPriorSegment) {
          if (insertIndex > 0) {
            insertIndex -= 1;
          } else if (insertIndex < commandsToExtend.length - 1) {
            insertIndex += 1;
          }
        } else if (insertIndex < commandsToExtend.length - 1) {
          insertIndex += 1;
        } else if (insertIndex > 0) {
          insertIndex -= 1;
        }
      }
    }
    accum[insertIndex] = (accum[insertIndex] || 0) + 1;
    return accum;
  }, []);
  var extended = countPointsPerSegment.reduce(function(extended2, segmentCount, i) {
    if (i === commandsToExtend.length - 1) {
      var lastCommandCopies = arrayOfLength(segmentCount, _extends({}, commandsToExtend[commandsToExtend.length - 1]));
      if (lastCommandCopies[0].type === "M") {
        lastCommandCopies.forEach(function(d) {
          d.type = "L";
        });
      }
      return extended2.concat(lastCommandCopies);
    }
    return extended2.concat(splitSegment(commandsToExtend[i], commandsToExtend[i + 1], segmentCount));
  }, []);
  extended.unshift(commandsToExtend[0]);
  return extended;
}
function pathCommandsFromString(d) {
  var tokens = (d || "").match(commandTokenRegex) || [];
  var commands = [];
  var commandArgs;
  var command;
  for (var i = 0; i < tokens.length; ++i) {
    commandArgs = typeMap[tokens[i]];
    if (commandArgs) {
      command = {
        type: tokens[i]
      };
      for (var a4 = 0; a4 < commandArgs.length; ++a4) {
        command[commandArgs[a4]] = +tokens[i + a4 + 1];
      }
      i += commandArgs.length;
      commands.push(command);
    }
  }
  return commands;
}
function interpolatePathCommands(aCommandsInput, bCommandsInput, interpolateOptions) {
  var aCommands = aCommandsInput == null ? [] : aCommandsInput.slice();
  var bCommands = bCommandsInput == null ? [] : bCommandsInput.slice();
  var _ref = _typeof(interpolateOptions) === "object" ? interpolateOptions : {
    excludeSegment: interpolateOptions,
    snapEndsToInput: true
  }, excludeSegment = _ref.excludeSegment, snapEndsToInput = _ref.snapEndsToInput;
  if (!aCommands.length && !bCommands.length) {
    return function nullInterpolator() {
      return [];
    };
  }
  var addZ = (aCommands.length === 0 || aCommands[aCommands.length - 1].type === "Z") && (bCommands.length === 0 || bCommands[bCommands.length - 1].type === "Z");
  if (aCommands.length > 0 && aCommands[aCommands.length - 1].type === "Z") {
    aCommands.pop();
  }
  if (bCommands.length > 0 && bCommands[bCommands.length - 1].type === "Z") {
    bCommands.pop();
  }
  if (!aCommands.length) {
    aCommands.push(bCommands[0]);
  } else if (!bCommands.length) {
    bCommands.push(aCommands[0]);
  }
  var numPointsToExtend = Math.abs(bCommands.length - aCommands.length);
  if (numPointsToExtend !== 0) {
    if (bCommands.length > aCommands.length) {
      aCommands = extend2(aCommands, bCommands, excludeSegment);
    } else if (bCommands.length < aCommands.length) {
      bCommands = extend2(bCommands, aCommands, excludeSegment);
    }
  }
  aCommands = aCommands.map(function(aCommand, i) {
    return convertToSameType(aCommand, bCommands[i]);
  });
  var interpolatedCommands = aCommands.map(function(aCommand) {
    return _objectSpread2({}, aCommand);
  });
  if (addZ) {
    interpolatedCommands.push({
      type: "Z"
    });
    aCommands.push({
      type: "Z"
    });
  }
  return function pathCommandInterpolator(t) {
    if (t === 1 && snapEndsToInput) {
      return bCommandsInput == null ? [] : bCommandsInput;
    }
    if (t === 0) {
      return aCommands;
    }
    for (var i = 0; i < interpolatedCommands.length; ++i) {
      var aCommand = aCommands[i];
      var bCommand = bCommands[i];
      var interpolatedCommand = interpolatedCommands[i];
      var _iterator = _createForOfIteratorHelper(typeMap[interpolatedCommand.type]), _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done; ) {
          var arg = _step.value;
          interpolatedCommand[arg] = (1 - t) * aCommand[arg] + t * bCommand[arg];
          if (arg === "largeArcFlag" || arg === "sweepFlag") {
            interpolatedCommand[arg] = Math.round(interpolatedCommand[arg]);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
    return interpolatedCommands;
  };
}
function interpolatePath(a4, b, interpolateOptions) {
  var aCommands = pathCommandsFromString(a4);
  var bCommands = pathCommandsFromString(b);
  var _ref2 = _typeof(interpolateOptions) === "object" ? interpolateOptions : {
    excludeSegment: interpolateOptions,
    snapEndsToInput: true
  }, excludeSegment = _ref2.excludeSegment, snapEndsToInput = _ref2.snapEndsToInput;
  if (!aCommands.length && !bCommands.length) {
    return function nullInterpolator() {
      return "";
    };
  }
  var commandInterpolator = interpolatePathCommands(aCommands, bCommands, {
    excludeSegment,
    snapEndsToInput
  });
  return function pathStringInterpolator(t) {
    if (t === 1 && snapEndsToInput) {
      return b == null ? "" : b;
    }
    var interpolatedCommands = commandInterpolator(t);
    var interpolatedString = "";
    var _iterator2 = _createForOfIteratorHelper(interpolatedCommands), _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
        var interpolatedCommand = _step2.value;
        interpolatedString += commandToString(interpolatedCommand);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
    return interpolatedString;
  };
}

// node_modules/@unovis/ts/utils/color.js
function getColor(d, accessor, index3, dontFallbackToCssVar) {
  if (Array.isArray(accessor) && isFinite(index3))
    return accessor[index3 % accessor.length];
  const value2 = getString(d, accessor, index3);
  return value2 || (isNumber(index3) && !dontFallbackToCssVar ? `var(${getCSSColorVariable(index3)})` : null);
}
function hexToRgb(hex2) {
  const parsed = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex2);
  return parsed ? {
    r: parseInt(parsed[1], 16),
    g: parseInt(parsed[2], 16),
    b: parseInt(parsed[3], 16)
  } : { r: 0, g: 0, b: 0 };
}
function rgbToBrightness(rgb2) {
  return (0.2126 * rgb2.r + 0.7152 * rgb2.g + 0.0722 * rgb2.b) / 255;
}
function hexToBrightness(hex2) {
  const rgb2 = hexToRgb(hex2);
  return rgbToBrightness(rgb2);
}
function getHexValue(s3, context) {
  var _a;
  const hex2 = isStringCSSVariable(s3) ? getCSSVariableValue(s3, context) : s3;
  return (_a = color(hex2)) === null || _a === void 0 ? void 0 : _a.formatHex();
}
function rgbaToRgb(rgba2, backgroundColor) {
  var _a;
  const rgb2 = (_a = color(rgba2)) === null || _a === void 0 ? void 0 : _a.rgb();
  if (!rgb2 || rgb2.opacity === 1)
    return rgb2;
  const alpha = 1 - rgb2.opacity;
  const bg = color(backgroundColor !== null && backgroundColor !== void 0 ? backgroundColor : "#fff").rgb();
  return {
    r: Math.round((rgb2.opacity * (rgb2.r / 255) + alpha * (bg.r / 255)) * 255),
    g: Math.round((rgb2.opacity * (rgb2.g / 255) + alpha * (bg.g / 255)) * 255),
    b: Math.round((rgb2.opacity * (rgb2.b / 255) + alpha * (bg.b / 255)) * 255)
  };
}

// node_modules/@unovis/ts/types/curve.js
var CurveType;
(function(CurveType2) {
  CurveType2["Basis"] = "basis";
  CurveType2["BasisClosed"] = "basisClosed";
  CurveType2["BasisOpen"] = "basisOpen";
  CurveType2["Bundle"] = "bundle";
  CurveType2["Cardinal"] = "cardinal";
  CurveType2["CardinalClosed"] = "cardinalClosed";
  CurveType2["CardinalOpen"] = "cardinalOpen";
  CurveType2["CatmullRom"] = "catmullRom";
  CurveType2["CatmullRomClosed"] = "catmullRomClosed";
  CurveType2["CatmullRomOpen"] = "catmullRomOpen";
  CurveType2["Linear"] = "linear";
  CurveType2["LinearClosed"] = "linearClosed";
  CurveType2["MonotoneX"] = "monotoneX";
  CurveType2["MonotoneY"] = "monotoneY";
  CurveType2["Natural"] = "natural";
  CurveType2["Step"] = "step";
  CurveType2["StepAfter"] = "stepAfter";
  CurveType2["StepBefore"] = "stepBefore";
})(CurveType || (CurveType = {}));
var Curve = {
  [CurveType.Basis]: basis_default2,
  [CurveType.BasisClosed]: basisClosed_default2,
  [CurveType.BasisOpen]: basisOpen_default,
  [CurveType.Bundle]: bundle_default,
  [CurveType.Cardinal]: cardinal_default,
  [CurveType.CardinalClosed]: cardinalClosed_default,
  [CurveType.CardinalOpen]: cardinalOpen_default,
  [CurveType.CatmullRom]: catmullRom_default,
  [CurveType.CatmullRomClosed]: catmullRomClosed_default,
  [CurveType.CatmullRomOpen]: catmullRomOpen_default,
  [CurveType.Linear]: linear_default,
  [CurveType.LinearClosed]: linearClosed_default,
  [CurveType.MonotoneX]: monotoneX,
  [CurveType.MonotoneY]: monotoneY,
  [CurveType.Natural]: natural_default,
  [CurveType.Step]: step_default,
  [CurveType.StepAfter]: stepAfter,
  [CurveType.StepBefore]: stepBefore
};

// node_modules/@unovis/ts/components/line/config.js
var LineDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { curveType: CurveType.MonotoneX, lineWidth: 2, lineDashArray: void 0, fallbackValue: void 0, highlightOnHover: false, cursor: null });

// node_modules/@unovis/ts/components/line/style.js
var style_exports2 = {};
__export(style_exports2, {
  dim: () => dim,
  globalStyles: () => globalStyles,
  line: () => line,
  linePath: () => linePath,
  lineSelectionHelper: () => lineSelectionHelper,
  root: () => root3
});
var globalStyles = injectGlobal`
  :root {
    --vis-line-cursor: default;
    --vis-line-stroke-dasharray: none;
    --vis-line-stroke-dashoffset: 0;
  }
`;
var root3 = css`
  label: line-component;
`;
var line = css`
  label: line;
  transition: opacity 200ms;
  cursor: var(--vis-line-cursor);
`;
var linePath = css`
  label: linePath;
  fill: none;
  stroke-dasharray: var(--vis-line-stroke-dasharray);
  stroke-dashoffset: var(--vis-line-stroke-dashoffset);
`;
var lineSelectionHelper = css`
  label: lineSelectionHelper;
  fill: none;
  stroke: rgba(0, 0, 0, 0);
  stroke-width: 8px;
`;
var dim = css`
  opacity: 0.2;
`;

// node_modules/@unovis/ts/components/line/index.js
var Line = class _Line extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = LineDefaultConfig;
    this.config = this._defaultConfig;
    this.curve = Curve[CurveType.MonotoneX];
    this.events = {
      [_Line.selectors.line]: {
        mouseover: this._highlight.bind(this),
        mouseleave: this._resetHighlight.bind(this)
      }
    };
    if (config)
      this.setConfig(config);
  }
  get bleed() {
    const { config: { lineWidth } } = this;
    const yDomain = this.yScale.domain();
    const yDirection = this.yScale.range()[0] > this.yScale.range()[1] ? Direction.North : Direction.South;
    const isYDirectionSouth = yDirection === Direction.South;
    const isLineThick = lineWidth > 3;
    const isLineVeryThick = lineWidth >= 10;
    return {
      top: !isLineVeryThick && (!isYDirectionSouth && yDomain[1] === 0 || isYDirectionSouth && yDomain[0] === 0) ? 0 : lineWidth / 2,
      bottom: !isLineVeryThick && (!isYDirectionSouth && yDomain[0] === 0 || isYDirectionSouth && yDomain[1] === 0) ? 0 : lineWidth / 2,
      left: isLineThick ? lineWidth / 2 : 0,
      right: isLineThick ? lineWidth / 2 : 0
    };
  }
  _render(customDuration) {
    super._render(customDuration);
    const { config, datamodel: { data } } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    this.curve = Curve[config.curveType];
    this.lineGen = line_default().x((d) => d.x).y((d) => d.y).defined((d) => d.defined).curve(this.curve);
    const yAccessors = isArray(config.y) ? config.y : [config.y];
    const lineDataX = data.map((d, i) => this.xScale(getNumber(d, config.x, i)));
    const lineData = yAccessors.map((a4) => {
      const ld = data.map((d, i) => {
        const rawValue = getNumber(d, a4, i);
        const value2 = (isNumber(rawValue) || rawValue === null) && isFinite(rawValue) ? rawValue : config.fallbackValue;
        return {
          x: lineDataX[i],
          y: this.yScale(value2 !== null && value2 !== void 0 ? value2 : 0),
          defined: isFinite(value2),
          value: value2
        };
      });
      const defined = ld.reduce((def, d) => d.defined || def, false);
      const visible = defined && ld.some((d) => d.value !== null);
      return {
        values: ld,
        defined,
        visible
      };
    });
    const lines3 = this.g.selectAll(`.${line}`).data(lineData);
    const linesEnter = lines3.enter().append("g").attr("class", line);
    linesEnter.append("path").attr("class", linePath).attr("stroke", (d, i) => getColor(data, config.color, i)).attr("stroke-opacity", 0).attr("stroke-width", config.lineWidth);
    linesEnter.append("path").attr("class", lineSelectionHelper).attr("d", this._emptyPath());
    const linesMerged = linesEnter.merge(lines3);
    linesMerged.style("cursor", (d, i) => getString(data, config.cursor, i));
    linesMerged.each((d, i, elements) => {
      var _a;
      const group3 = select_default2(elements[i]);
      const linePath$1 = group3.select(`.${linePath}`);
      const lineSelectionHelper$1 = group3.select(`.${lineSelectionHelper}`);
      const isLineVisible = d.visible;
      const dashArray = getValue(data, config.lineDashArray, i);
      const transition2 = smartTransition(linePath$1, duration).attr("stroke", getColor(data, config.color, i)).attr("stroke-width", config.lineWidth).attr("stroke-opacity", isLineVisible ? 1 : 0).style("stroke-dasharray", (_a = dashArray === null || dashArray === void 0 ? void 0 : dashArray.join(" ")) !== null && _a !== void 0 ? _a : null);
      const hasUndefinedSegments = d.values.some((d2) => !d2.defined);
      const svgPathD = this.lineGen(d.values);
      if (duration && !hasUndefinedSegments) {
        const previous = linePath$1.attr("d") || this._emptyPath();
        const next = svgPathD || this._emptyPath();
        const t = transition2;
        t.attrTween("d", () => interpolatePath(previous, next));
      } else if (d.visible) {
        transition2.attr("d", svgPathD);
      }
      lineSelectionHelper$1.attr("d", svgPathD).attr("visibility", isLineVisible ? null : "hidden");
    });
    smartTransition(lines3.exit(), duration).style("opacity", 0).remove();
  }
  _emptyPath() {
    const xRange = this.xScale.range();
    const yRange = this.yScale.range();
    return `M${xRange[0]},${yRange[0]} L${xRange[1]},${yRange[0]}`;
  }
  _highlight(datum2) {
    const { config } = this;
    if (config.highlightOnHover) {
      this.g.selectAll(`.${line}`).classed(dim, (d) => d !== datum2);
    }
  }
  _resetHighlight() {
    const { config } = this;
    if (config.highlightOnHover) {
      this.g.selectAll(`.${line}`).classed(dim, false);
    }
  }
};
Line.selectors = style_exports2;

// node_modules/@unovis/ts/utils/path.js
function roundedRectPath({ x: x3, y: y3, w: w2, h, tl = false, tr = false, bl = false, br = false, r = 0 }) {
  let path3;
  path3 = `M${x3 + r},${y3}h${w2 - 2 * r}`;
  let roundedR = tr ? r : 0;
  let angularR = tr ? 0 : r;
  path3 += `a${roundedR},${roundedR} 0 0 1 ${roundedR},${roundedR}`;
  path3 += `h${angularR}v${angularR}`;
  path3 += `v${h - 2 * r}`;
  roundedR = br ? r : 0;
  angularR = br ? 0 : r;
  path3 += `a${roundedR},${roundedR} 0 0 1 ${-roundedR},${roundedR}`;
  path3 += `v${angularR}h${-angularR}`;
  path3 += `h${2 * r - w2}`;
  roundedR = bl ? r : 0;
  angularR = bl ? 0 : r;
  path3 += `a${roundedR},${roundedR} 0 0 1 ${-roundedR},${-roundedR}`;
  path3 += `h${-angularR}v${-angularR}`;
  path3 += `v${2 * r - h}`;
  roundedR = tl ? r : 0;
  angularR = tl ? 0 : r;
  path3 += `a${roundedR},${roundedR} 0 0 1 ${roundedR},${-roundedR}`;
  path3 += `v${-angularR}h${angularR}`;
  path3 += "z";
  return path3;
}
function polygon(size2, n = 6, endAngle = 2 * Math.PI, open = false) {
  const r = n === 4 ? Math.sqrt(0.5) * size2 : size2 / 3.6 * 2;
  const deltaAngle = n === 4 ? Math.PI / 4 : 0;
  const shiftedEndAngle = endAngle - deltaAngle;
  const completion = (shiftedEndAngle < 0 ? endAngle : shiftedEndAngle) / (2 * Math.PI);
  const nSegments = Math.ceil(n * completion);
  const centerAngle = 1 / n * Math.PI * 2;
  const baseAngle = (Math.PI - centerAngle) / 2;
  const data = range(nSegments + (shiftedEndAngle >= 0 ? 1 : 0)).map((d, i) => {
    const isLastSegment = i === nSegments || nSegments === 1 && shiftedEndAngle < 0;
    let mult = isLastSegment ? completion * n % 1 || 1 : 1;
    if (shiftedEndAngle < 0) {
      mult += 0.5;
    }
    const angle = centerAngle * (i - 1 + mult);
    let radius;
    if (isLastSegment) {
      const thirdAngle = Math.PI - baseAngle - centerAngle * mult;
      radius = r * Math.sin(baseAngle) / Math.sin(thirdAngle);
    } else {
      radius = r;
    }
    return {
      x: Math.sin(angle + deltaAngle) * radius,
      y: -Math.cos(angle + deltaAngle) * radius
    };
  });
  if (n === 4) {
    const angle = centerAngle * (-1 + 0.5);
    const thirdAngle = Math.PI * 0.5;
    const radius = r * Math.sin(baseAngle) / Math.sin(thirdAngle);
    data.unshift({
      x: Math.sin(angle + deltaAngle) * radius,
      y: -Math.cos(angle + deltaAngle) * radius
    });
  }
  const path3 = line_default().x((d) => d["x"]).y((d) => d["y"]).curve((open ? cardinal_default : cardinalClosed_default).tension(0.95));
  return path3(data);
}
function circlePath(cx, cy, r) {
  return `
    M ${cx} ${cy}
    m ${-r}, 0
    a ${r},${r} 0 1,1 ${r * 2},0
    a ${r},${r} 0 1,1 ${-r * 2},0`;
}
function scoreRectPath({ x: x3, y: y3, w: w2, h, r = 0, score: score2 = 1 }) {
  let path3;
  const side = 1 / 4;
  const halfSide = side / 2;
  let part = score2;
  const hLength = min([w2 * 0.5 * (part / halfSide) + r, w2 * 0.5 - r]);
  path3 = `M${x3 + w2 * 0.5},${y3}h${hLength}`;
  part = score2 - 1 / 8;
  if (part > 0) {
    path3 += `a${r},${r} 0 0 1 ${r},${r}`;
    const vLength = clamp(h * (part / side) - r, 0, h - 2 * r);
    path3 += `v${vLength}`;
  }
  part = score2 - 3 / 8;
  if (part > 0) {
    path3 += `a${r},${r} 0 0 1 ${-r},${r}`;
    const hLength2 = clamp(r - w2 * (part / side), 2 * r - w2, 0);
    path3 += `h${hLength2}`;
  }
  part = score2 - 5 / 8;
  if (part > 0) {
    path3 += `a${r},${r} 0 0 1 ${-r},${-r}`;
    const vLength = clamp(r - h * (part / side), 2 * r - h, 0);
    path3 += `v${vLength}`;
  }
  part = score2 - 7 / 8;
  if (part > 0) {
    path3 += `a${r},${r} 0 0 1 ${r},${-r}`;
    const hLength2 = max([w2 * 0.5 * (part / halfSide) - r, 0]);
    path3 += `h${hLength2}`;
  }
  return path3;
}
function convertLineToArc(path3, r) {
  return path3.toString().replace(/L(?<x>-?\d*\.?\d*),(?<y>-?\d+\.?\d*)/gm, (_, x3, y3) => `A ${r} ${r} 0 0 0 ${x3} ${y3}`);
}

// node_modules/@unovis/ts/components/stacked-bar/config.js
var StackedBarDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { color: void 0, barMaxWidth: void 0, barWidth: void 0, dataStep: void 0, barPadding: 0, roundedCorners: 2, cursor: null, barMinHeight1Px: false, barMinHeightZeroValue: null, orientation: Orientation.Vertical });

// node_modules/@unovis/ts/components/stacked-bar/style.js
var style_exports3 = {};
__export(style_exports3, {
  bar: () => bar,
  barGroup: () => barGroup,
  barGroupExit: () => barGroupExit,
  globalStyles: () => globalStyles2,
  root: () => root4
});
var root4 = css`
  label: stacked-bar-component;
`;
var globalStyles2 = injectGlobal`
  :root {
    --vis-stacked-bar-cursor: default;
    --vis-stacked-bar-fill-color: var(--vis-color-main);
    --vis-stacked-bar-stroke-color: none;
    --vis-stacked-bar-stroke-width: 0px;
    --vis-stacked-bar-hover-stroke-width: none;
    --vis-stacked-bar-hover-stroke-color: none;

    /* Dark Theme */
    --vis-dark-stacked-bar-stroke-color: none;
  }

  body.theme-dark ${`.${root4}`} {
    --vis-stacked-bar-stroke-color: var(--vis-dark-stacked-bar-stroke-color);
  }
`;
var bar = css`
  label: bar;
  fill: var(--vis-stacked-bar-fill-color);
  stroke: var(--vis-stacked-bar-stroke-color);
  stroke-width: var(--vis-stacked-bar-stroke-width);
  cursor: var(--vis-stacked-bar-cursor);

  &:hover {
    stroke-width: var(--vis-stacked-bar-hover-stroke-width);
    stroke: var(--vis-stacked-bar-hover-stroke-color);
  }
`;
var barGroup = css`
  label: barGroup;
`;
var barGroupExit = css`
  label: barGroupExit;
`;

// node_modules/@unovis/ts/components/stacked-bar/index.js
var StackedBar = class extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = StackedBarDefaultConfig;
    this.config = this._defaultConfig;
    this.getAccessors = () => isArray(this.config.y) ? this.config.y : [this.config.y];
    this.stacked = true;
    this.events = {};
    this._barData = [];
    if (config)
      this.setConfig(config);
  }
  get bleed() {
    this._barData = this._getVisibleData();
    if (this._barData.length === 0)
      return { top: 0, bottom: 0, left: 0, right: 0 };
    const isHorizontalAndFlipped = !this.isVertical() && this.dataScale.range()[0] > this.dataScale.range()[1];
    const dataDomain = this.dataScale.domain();
    const halfGroupWidth = this._getBarWidth() / 2;
    const dataScaleValues = this._barData.map((d, i) => getNumber(d, this.config.x, i));
    const firstDataValue = min(dataScaleValues);
    const lastDataValue = max(dataScaleValues);
    const firstValuePx = this.dataScale(firstDataValue);
    const lastValuePx = this.dataScale(lastDataValue);
    const dataDomainRequiredStart = this.dataScale.invert(firstValuePx + (isHorizontalAndFlipped ? halfGroupWidth : -halfGroupWidth));
    const dataDomainRequiredEnd = this.dataScale.invert(lastValuePx + (isHorizontalAndFlipped ? -halfGroupWidth : halfGroupWidth));
    const bleedPxStart = dataDomainRequiredStart <= dataDomain[0] ? this.dataScale(dataDomain[0]) - this.dataScale(dataDomainRequiredStart) : 0;
    const bleedPxEnd = dataDomainRequiredEnd > dataDomain[1] ? this.dataScale(dataDomainRequiredEnd) - this.dataScale(dataDomain[1]) : 0;
    return {
      top: this.isVertical() ? 0 : isHorizontalAndFlipped ? -bleedPxEnd : bleedPxStart,
      bottom: this.isVertical() ? 0 : isHorizontalAndFlipped ? -bleedPxStart : bleedPxEnd,
      left: this.isVertical() ? bleedPxStart : 0,
      right: this.isVertical() ? bleedPxEnd : 0
    };
  }
  get dataScale() {
    return this.isVertical() ? this.xScale : this.yScale;
  }
  get valueScale() {
    return this.isVertical() ? this.yScale : this.xScale;
  }
  isVertical() {
    return this.config.orientation === Orientation.Vertical;
  }
  _render(customDuration) {
    const { config } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const yAccessors = this.getAccessors();
    const stacked = getStackedData(this._barData, 0, yAccessors, this._prevNegative);
    this._prevNegative = stacked.map((s3) => !!s3.negative);
    const barGroups = this.g.selectAll(`.${barGroup}`).data(this._barData, (d, i) => {
      var _a;
      return `${(_a = getString(d, config.id, i)) !== null && _a !== void 0 ? _a : i}`;
    });
    const getBarGroupsTransform = (d, i) => {
      const v = this.dataScale(getNumber(d, config.x, i));
      const x3 = this.isVertical() ? v : 0;
      const y3 = this.isVertical() ? 0 : v;
      return `translate(${x3},${y3})`;
    };
    const barGroupsEnter = barGroups.enter().append("g").attr("class", barGroup).attr("transform", getBarGroupsTransform).style("opacity", 1);
    const barGroupsMerged = barGroupsEnter.merge(barGroups);
    smartTransition(barGroupsMerged, duration).attr("transform", getBarGroupsTransform).style("opacity", 1);
    const barGroupExit$1 = barGroups.exit().attr("class", barGroupExit);
    smartTransition(barGroupExit$1, duration).style("opacity", 0).remove();
    smartTransition(barGroupExit$1.selectAll(`.${bar}`), duration).attr("transform", this.isVertical() ? `translate(0,${this._height / 3})` : `translate(${this._width / 6},0)`);
    const bars = barGroupsMerged.selectAll(`.${bar}`).data((d, j) => stacked.map((s3) => Object.assign(Object.assign({}, d), { _stacked: s3[j], _negative: s3.negative, _ending: s3.ending })));
    const barsEnter = bars.enter().append("path").attr("class", bar).attr("d", (d, j) => this._getBarPath(d, j, true)).style("fill", (d, j) => getColor(d, config.color, j));
    const barsMerged = barsEnter.merge(bars);
    smartTransition(barsMerged, duration).attr("d", (d, j) => this._getBarPath(d, j)).style("fill", (d, j) => getColor(d, config.color, j)).style("cursor", (d, j) => getString(d, config.cursor, j));
    smartTransition(bars.exit(), duration).style("opacity", 0).remove();
  }
  _getBarWidth() {
    const { config, datamodel: { data } } = this;
    if (isEmpty(data))
      return 0;
    if (config.barWidth)
      return min([config.barWidth, config.barMaxWidth]);
    const isOrdinal = this.dataScale.bandwidth;
    const domain = this.dataScale.domain ? this.dataScale.domain() : [];
    const domainLength = isOrdinal ? domain.length : domain[1] - domain[0];
    let dataSize = 1 + domainLength / config.dataStep || !isOrdinal && data.filter((d, i) => {
      const value2 = getNumber(d, config.x, i);
      return value2 >= domain[0] && value2 <= domain[1];
    }).length || data.length;
    if (!isOrdinal && dataSize >= 2)
      dataSize += 1;
    const c3 = dataSize < 2 ? 1 : 1 - config.barPadding;
    const barWidth = c3 * (this.isVertical() ? this._width : this._height) / dataSize;
    return min([barWidth, config.barMaxWidth]);
  }
  _getVisibleData() {
    const { config, datamodel: { data } } = this;
    const groupWidth = this._getBarWidth();
    const halfGroupWidthPx = data.length < 2 ? 0 : groupWidth / 2;
    const scale = this.dataScale;
    const halfGroupWidth = Math.abs(scale.invert(halfGroupWidthPx) - scale.invert(0));
    const filtered = data === null || data === void 0 ? void 0 : data.filter((d, i) => {
      const v = getNumber(d, config.x, i);
      const domain = scale.domain();
      const domainMin = +domain[0];
      const domainMax = +domain[1];
      return v >= domainMin - halfGroupWidth && v <= domainMax + halfGroupWidth;
    });
    return filtered;
  }
  _getBarPath(d, accessorIndex, isEntering = false) {
    const { config } = this;
    const yAccessors = this.getAccessors();
    const barWidth = this._getBarWidth();
    const isNegative = d._negative;
    const isEnding = d._ending;
    const value2 = getNumber(d, yAccessors[accessorIndex]);
    const height = isEntering ? 0 : Math.abs(this.valueScale(d._stacked[0]) - this.valueScale(d._stacked[1]));
    const h = !isEntering && config.barMinHeight1Px && height < 1 && isFinite(value2) && value2 !== config.barMinHeightZeroValue ? 1 : height;
    const y3 = isEntering ? this.valueScale(0) : this.valueScale(isNegative ? d._stacked[0] : d._stacked[1]) - (height < 1 && config.barMinHeight1Px ? 1 : 0);
    const x3 = -barWidth / 2;
    const width = barWidth;
    const cornerRadius = config.roundedCorners ? isNumber(config.roundedCorners) ? +config.roundedCorners : width / 2 : 0;
    const cornerRadiusClamped = clamp(cornerRadius, 0, Math.min(height, width) / 2);
    const isNorthDirected = this.yScale.range()[0] > this.yScale.range()[1];
    return roundedRectPath({
      x: this.isVertical() ? x3 : y3 - h,
      y: this.isVertical() ? y3 + (isNorthDirected ? 0 : -h) : x3,
      w: this.isVertical() ? width : h,
      h: this.isVertical() ? h : width,
      tl: isEnding && (this.isVertical() ? !isNegative && isNorthDirected || isNegative && !isNorthDirected : isNegative),
      tr: isEnding && (this.isVertical() ? !isNegative && isNorthDirected || isNegative && !isNorthDirected : !isNegative),
      br: isEnding && (this.isVertical() ? isNegative && isNorthDirected || !isNegative && !isNorthDirected : !isNegative),
      bl: isEnding && (this.isVertical() ? isNegative && isNorthDirected || !isNegative && !isNorthDirected : isNegative),
      r: cornerRadiusClamped
    });
  }
  getValueScaleExtent(scaleByVisibleData) {
    const { datamodel } = this;
    const yAccessors = this.getAccessors();
    const data = scaleByVisibleData ? this._getVisibleData() : datamodel.data;
    return getStackedExtent(data, ...yAccessors);
  }
  getDataScaleExtent() {
    const { config, datamodel } = this;
    return getExtent(datamodel.data, config.x);
  }
  getYDataExtent(scaleByVisibleData) {
    return this.isVertical() ? this.getValueScaleExtent(scaleByVisibleData) : this.getDataScaleExtent();
  }
  getXDataExtent() {
    return this.isVertical() ? this.getDataScaleExtent() : this.getValueScaleExtent(false);
  }
};
StackedBar.selectors = style_exports3;

// node_modules/@unovis/ts/components/grouped-bar/config.js
var GroupedBarDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { color: void 0, groupMaxWidth: void 0, groupWidth: void 0, dataStep: void 0, groupPadding: 0.05, barPadding: 0, roundedCorners: 2, barMinHeight: 2, cursor: null, orientation: Orientation.Vertical });

// node_modules/@unovis/ts/components/grouped-bar/style.js
var style_exports4 = {};
__export(style_exports4, {
  bar: () => bar2,
  barGroup: () => barGroup2,
  barGroupExit: () => barGroupExit2,
  globalStyles: () => globalStyles3,
  root: () => root5
});
var root5 = css`
  label: grouped-bar-component;
`;
var globalStyles3 = injectGlobal`
  :root {
    --vis-grouped-bar-cursor: default;
    --vis-grouped-bar-fill-color: var(--vis-color-main);
    --vis-grouped-bar-stroke-color: none;
    --vis-grouped-bar-stroke-width: 0px;
    --vis-grouped-bar-hover-stroke-width: 1px;
    --vis-grouped-bar-hover-stroke-color: none;


    /* Dark Theme */
    --vis-dark-grouped-bar-stroke-color: none;
  }

  body.theme-dark ${`.${root5}`} {
    --vis-grouped-bar-stroke-color: var(--vis-dark-grouped-bar-stroke-color);
  }
`;
var bar2 = css`
  label: bar;
  fill: var(--vis-grouped-bar-fill-color);
  stroke: var(--vis-grouped-bar-stroke-color);
  stroke-width: var(--vis-grouped-bar-stroke-width);
  cursor: var(--vis-grouped-bar-cursor);

  &:hover {
    stroke-width: var(--vis-grouped-bar-hover-stroke-width);
    stroke: var(--vis-grouped-bar-hover-stroke-color);
  }
`;
var barGroup2 = css`
  label: barGroup;
`;
var barGroupExit2 = css`
  label: barGroupExit;
`;

// node_modules/@unovis/ts/components/grouped-bar/index.js
var GroupedBar = class extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = GroupedBarDefaultConfig;
    this.config = this._defaultConfig;
    this.getAccessors = () => isArray(this.config.y) ? this.config.y : [this.config.y];
    this.events = {};
    this._barData = [];
    if (config)
      this.setConfig(config);
  }
  get bleed() {
    this._barData = this._getVisibleData();
    if (this._barData.length === 0)
      return { top: 0, bottom: 0, left: 0, right: 0 };
    const isHorizontalAndFlipped = !this.isVertical() && this.dataScale.range()[0] > this.dataScale.range()[1];
    const dataDomain = this.dataScale.domain();
    const halfGroupWidth = this._getGroupWidth() / 2;
    const dataScaleValues = this._barData.map((d, i) => getNumber(d, this.config.x, i));
    const firstDataValue = min(dataScaleValues);
    const lastDataValue = max(dataScaleValues);
    const firstValuePx = this.dataScale(firstDataValue);
    const lastValuePx = this.dataScale(lastDataValue);
    const dataDomainRequiredStart = this.dataScale.invert(firstValuePx + (isHorizontalAndFlipped ? halfGroupWidth : -halfGroupWidth));
    const dataDomainRequiredEnd = this.dataScale.invert(lastValuePx + (isHorizontalAndFlipped ? -halfGroupWidth : halfGroupWidth));
    const bleedPxStart = dataDomainRequiredStart <= dataDomain[0] ? this.dataScale(dataDomain[0]) - this.dataScale(dataDomainRequiredStart) : 0;
    const bleedPxEnd = dataDomainRequiredEnd > dataDomain[1] ? this.dataScale(dataDomainRequiredEnd) - this.dataScale(dataDomain[1]) : 0;
    return {
      top: this.isVertical() ? 0 : isHorizontalAndFlipped ? -bleedPxEnd : bleedPxStart,
      bottom: this.isVertical() ? 0 : isHorizontalAndFlipped ? -bleedPxStart : bleedPxEnd,
      left: this.isVertical() ? bleedPxStart : 0,
      right: this.isVertical() ? bleedPxEnd : 0
    };
  }
  get dataScale() {
    return this.isVertical() ? this.xScale : this.yScale;
  }
  get valueScale() {
    return this.isVertical() ? this.yScale : this.xScale;
  }
  isVertical() {
    return this.config.orientation === Orientation.Vertical;
  }
  _render(customDuration) {
    const { config } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const groupWidth = this._getGroupWidth();
    const yAccessors = this.getAccessors();
    const innerBandScaleRange = [-groupWidth / 2, groupWidth / 2];
    const innerBandScale = band().domain(range(yAccessors.length)).range(innerBandScaleRange).paddingInner(config.barPadding).paddingOuter(config.barPadding);
    const barGroups = this.g.selectAll(`.${barGroup2}`).data(this._barData, (d, i) => {
      var _a;
      return `${(_a = getString(d, config.id, i)) !== null && _a !== void 0 ? _a : i}`;
    });
    const getBarGroupsTransform = (d, i) => {
      const v = this.dataScale(getNumber(d, config.x, i));
      const x3 = this.isVertical() ? v : 0;
      const y3 = this.isVertical() ? 0 : v;
      return `translate(${x3},${y3})`;
    };
    const barGroupsEnter = barGroups.enter().append("g").attr("class", barGroup2).attr("transform", getBarGroupsTransform).style("opacity", 1);
    const barGroupsMerged = barGroupsEnter.merge(barGroups);
    smartTransition(barGroupsMerged, duration).attr("transform", getBarGroupsTransform).style("opacity", 1);
    const barGroupExit$1 = barGroups.exit().attr("class", barGroupExit2);
    smartTransition(barGroupExit$1, duration).style("opacity", 0).remove();
    smartTransition(barGroupExit$1.selectAll(`.${bar2}`), duration).attr("transform", (d, i, e) => {
      return this.isVertical() ? `translate(0,${this.yScale(0)}) scale(1,0)` : `translate(${this.xScale(0)},0) scale(0,1)`;
    });
    const barWidth = innerBandScale.bandwidth();
    const bars = barGroupsMerged.selectAll(`.${bar2}`).data((d) => yAccessors.map(() => d));
    const valueAxisDirection = this._getValueAxisDirection();
    const barsEnter = bars.enter().append("path").attr("class", bar2).attr("d", (d, i) => {
      const x3 = innerBandScale(i);
      const y3 = this.valueScale(0);
      const width = barWidth;
      const height = 0;
      return this._getBarPath(x3, y3, width, height, false, valueAxisDirection);
    }).style("fill", (d, i) => getColor(d, config.color, i));
    const barsMerged = barsEnter.merge(bars);
    smartTransition(barsMerged, duration).attr("d", (d, j) => {
      const x3 = innerBandScale(j);
      const width = barWidth;
      const value2 = getNumber(d, yAccessors[j]);
      const isNegative = value2 < 0;
      let y3 = isNegative ? this.valueScale(0) : this.valueScale(value2 || 0);
      let height = Math.abs(this.valueScale(0) - this.valueScale(value2)) || 0;
      if (height < config.barMinHeight) {
        const dir = valueAxisDirection === Direction.North ? -1 : 1;
        y3 = this.valueScale(0) + dir * config.barMinHeight;
        height = config.barMinHeight;
      }
      return this._getBarPath(x3, y3, width, height, isNegative, valueAxisDirection);
    }).style("fill", (d, i) => getColor(d, config.color, i)).style("cursor", (d, i) => getString(d, config.cursor, i));
    smartTransition(bars.exit(), duration).remove();
  }
  _getValueAxisDirection() {
    return this.valueScale.range()[0] > this.valueScale.range()[1] ? Direction.North : Direction.South;
  }
  _getVisibleData() {
    const { config, datamodel: { data } } = this;
    const groupWidth = this._getGroupWidth();
    const halfGroupWidth = data.length < 2 ? 0 : groupWidth / 2;
    const dataScale = this.dataScale;
    const xHalfGroupWidth = Math.abs(dataScale.invert(halfGroupWidth) - dataScale.invert(0));
    const filtered = data === null || data === void 0 ? void 0 : data.filter((d, i) => {
      const v = getNumber(d, config.x, i);
      const domain = dataScale.domain();
      const domainMin = +domain[0];
      const domainMax = +domain[1];
      return v >= domainMin - xHalfGroupWidth && v <= domainMax + xHalfGroupWidth;
    });
    return filtered;
  }
  _getBarPath(x3, y3, width, height, isNegative, direction) {
    const { config } = this;
    const cornerRadius = config.roundedCorners ? isNumber(config.roundedCorners) ? +config.roundedCorners : width / 2 : 0;
    const cornerRadiusClamped = clamp(cornerRadius, 0, Math.min(height, width) / 2);
    const isNorthDirected = direction === Direction.North;
    const roundedTop = this.isVertical() && isNegative !== isNorthDirected;
    const roundedBottom = this.isVertical() && isNegative === isNorthDirected;
    const roundedLeft = !this.isVertical() && isNegative;
    const roundedRight = !this.isVertical() && !isNegative;
    return roundedRectPath({
      x: this.isVertical() ? x3 : y3 + (isNorthDirected ? 0 : -height),
      y: this.isVertical() ? y3 + (isNorthDirected ? 0 : -height) : x3,
      w: this.isVertical() ? width : height,
      h: this.isVertical() ? height : width,
      tl: roundedTop || roundedLeft,
      tr: roundedTop || roundedRight,
      bl: roundedBottom || roundedLeft,
      br: roundedBottom || roundedRight,
      r: cornerRadiusClamped
    });
  }
  _getGroupWidth() {
    const { config, datamodel: { data } } = this;
    if (isEmpty(data))
      return 0;
    if (config.groupWidth) {
      return min([config.groupWidth, config.groupMaxWidth]);
    }
    const isOrdinal = this.dataScale.bandwidth;
    const domain = this.dataScale.domain ? this.dataScale.domain() : [];
    const domainLength = isOrdinal ? domain.length : domain[1] - domain[0];
    let dataSize = 1 + domainLength / config.dataStep || !isOrdinal && data.filter((d, i) => {
      const value2 = getNumber(d, config.x, i);
      return value2 >= domain[0] && value2 <= domain[1];
    }).length || data.length;
    if (!isOrdinal && dataSize >= 2)
      dataSize += 1;
    const c3 = dataSize < 2 ? 1 : 1 - config.groupPadding;
    const groupWidth = c3 * (this.isVertical() ? this._width : this._height) / dataSize;
    return min([groupWidth, config.groupMaxWidth]);
  }
  getValueScaleExtent(scaleByVisibleData) {
    const { datamodel } = this;
    const yAccessors = this.getAccessors();
    const data = scaleByVisibleData ? this._getVisibleData() : datamodel.data;
    const min7 = getMin(data, ...yAccessors);
    const max8 = getMax(data, ...yAccessors);
    return [min7 > 0 ? 0 : min7, max8 < 0 ? 0 : max8];
  }
  getDataScaleExtent() {
    const { config, datamodel } = this;
    return getExtent(datamodel.data, config.x);
  }
  getYDataExtent(scaleByVisibleData) {
    return this.isVertical() ? this.getValueScaleExtent(scaleByVisibleData) : this.getDataScaleExtent();
  }
  getXDataExtent() {
    return this.isVertical() ? this.getDataScaleExtent() : this.getValueScaleExtent(false);
  }
};
GroupedBar.selectors = style_exports4;

// node_modules/d3-axis/src/identity.js
function identity_default3(x3) {
  return x3;
}

// node_modules/d3-axis/src/axis.js
var top = 1;
var right = 2;
var bottom = 3;
var left = 4;
var epsilon4 = 1e-6;
function translateX(x3) {
  return "translate(" + x3 + ",0)";
}
function translateY(y3) {
  return "translate(0," + y3 + ")";
}
function number3(scale) {
  return (d) => +scale(d);
}
function center(scale, offset) {
  offset = Math.max(0, scale.bandwidth() - offset * 2) / 2;
  if (scale.round()) offset = Math.round(offset);
  return (d) => +scale(d) + offset;
}
function entering() {
  return !this.__axis;
}
function axis(orient, scale) {
  var tickArguments = [], tickValues = null, tickFormat2 = null, tickSizeInner = 6, tickSizeOuter = 6, tickPadding = 3, offset = typeof window !== "undefined" && window.devicePixelRatio > 1 ? 0 : 0.5, k4 = orient === top || orient === left ? -1 : 1, x3 = orient === left || orient === right ? "x" : "y", transform2 = orient === top || orient === bottom ? translateX : translateY;
  function axis3(context) {
    var values = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments) : scale.domain() : tickValues, format2 = tickFormat2 == null ? scale.tickFormat ? scale.tickFormat.apply(scale, tickArguments) : identity_default3 : tickFormat2, spacing = Math.max(tickSizeInner, 0) + tickPadding, range3 = scale.range(), range0 = +range3[0] + offset, range1 = +range3[range3.length - 1] + offset, position = (scale.bandwidth ? center : number3)(scale.copy(), offset), selection2 = context.selection ? context.selection() : context, path3 = selection2.selectAll(".domain").data([null]), tick2 = selection2.selectAll(".tick").data(values, scale).order(), tickExit = tick2.exit(), tickEnter = tick2.enter().append("g").attr("class", "tick"), line5 = tick2.select("line"), text = tick2.select("text");
    path3 = path3.merge(path3.enter().insert("path", ".tick").attr("class", "domain").attr("stroke", "currentColor"));
    tick2 = tick2.merge(tickEnter);
    line5 = line5.merge(tickEnter.append("line").attr("stroke", "currentColor").attr(x3 + "2", k4 * tickSizeInner));
    text = text.merge(tickEnter.append("text").attr("fill", "currentColor").attr(x3, k4 * spacing).attr("dy", orient === top ? "0em" : orient === bottom ? "0.71em" : "0.32em"));
    if (context !== selection2) {
      path3 = path3.transition(context);
      tick2 = tick2.transition(context);
      line5 = line5.transition(context);
      text = text.transition(context);
      tickExit = tickExit.transition(context).attr("opacity", epsilon4).attr("transform", function(d) {
        return isFinite(d = position(d)) ? transform2(d + offset) : this.getAttribute("transform");
      });
      tickEnter.attr("opacity", epsilon4).attr("transform", function(d) {
        var p = this.parentNode.__axis;
        return transform2((p && isFinite(p = p(d)) ? p : position(d)) + offset);
      });
    }
    tickExit.remove();
    path3.attr("d", orient === left || orient === right ? tickSizeOuter ? "M" + k4 * tickSizeOuter + "," + range0 + "H" + offset + "V" + range1 + "H" + k4 * tickSizeOuter : "M" + offset + "," + range0 + "V" + range1 : tickSizeOuter ? "M" + range0 + "," + k4 * tickSizeOuter + "V" + offset + "H" + range1 + "V" + k4 * tickSizeOuter : "M" + range0 + "," + offset + "H" + range1);
    tick2.attr("opacity", 1).attr("transform", function(d) {
      return transform2(position(d) + offset);
    });
    line5.attr(x3 + "2", k4 * tickSizeInner);
    text.attr(x3, k4 * spacing).text(format2);
    selection2.filter(entering).attr("fill", "none").attr("font-size", 10).attr("font-family", "sans-serif").attr("text-anchor", orient === right ? "start" : orient === left ? "end" : "middle");
    selection2.each(function() {
      this.__axis = position;
    });
  }
  axis3.scale = function(_) {
    return arguments.length ? (scale = _, axis3) : scale;
  };
  axis3.ticks = function() {
    return tickArguments = Array.from(arguments), axis3;
  };
  axis3.tickArguments = function(_) {
    return arguments.length ? (tickArguments = _ == null ? [] : Array.from(_), axis3) : tickArguments.slice();
  };
  axis3.tickValues = function(_) {
    return arguments.length ? (tickValues = _ == null ? null : Array.from(_), axis3) : tickValues && tickValues.slice();
  };
  axis3.tickFormat = function(_) {
    return arguments.length ? (tickFormat2 = _, axis3) : tickFormat2;
  };
  axis3.tickSize = function(_) {
    return arguments.length ? (tickSizeInner = tickSizeOuter = +_, axis3) : tickSizeInner;
  };
  axis3.tickSizeInner = function(_) {
    return arguments.length ? (tickSizeInner = +_, axis3) : tickSizeInner;
  };
  axis3.tickSizeOuter = function(_) {
    return arguments.length ? (tickSizeOuter = +_, axis3) : tickSizeOuter;
  };
  axis3.tickPadding = function(_) {
    return arguments.length ? (tickPadding = +_, axis3) : tickPadding;
  };
  axis3.offset = function(_) {
    return arguments.length ? (offset = +_, axis3) : offset;
  };
  return axis3;
}
function axisTop(scale) {
  return axis(top, scale);
}
function axisRight(scale) {
  return axis(right, scale);
}
function axisBottom(scale) {
  return axis(bottom, scale);
}
function axisLeft(scale) {
  return axis(left, scale);
}

// node_modules/@unovis/ts/types/text.js
var TrimMode;
(function(TrimMode2) {
  TrimMode2["Start"] = "start";
  TrimMode2["Middle"] = "middle";
  TrimMode2["End"] = "end";
})(TrimMode || (TrimMode = {}));
var VerticalAlign;
(function(VerticalAlign2) {
  VerticalAlign2["Top"] = "top";
  VerticalAlign2["Middle"] = "middle";
  VerticalAlign2["Bottom"] = "bottom";
})(VerticalAlign || (VerticalAlign = {}));
var FitMode;
(function(FitMode2) {
  FitMode2["Wrap"] = "wrap";
  FitMode2["Trim"] = "trim";
})(FitMode || (FitMode = {}));
var TextAlign;
(function(TextAlign2) {
  TextAlign2["Left"] = "left";
  TextAlign2["Center"] = "center";
  TextAlign2["Right"] = "right";
})(TextAlign || (TextAlign = {}));

// node_modules/@unovis/ts/utils/text.js
var import_striptags = __toESM(require_striptags(), 1);

// node_modules/@unovis/ts/types/svg.js
function getTextAnchorFromTextAlign(textAlign) {
  switch (textAlign) {
    case TextAlign.Center:
      return "middle";
    case TextAlign.Right:
      return "end";
    case TextAlign.Left:
    default:
      return "start";
  }
}

// node_modules/@unovis/ts/utils/text.js
function kebabCaseToCamel(str) {
  return str.replace(/-([a-z])/g, (_, letter) => letter.toUpperCase());
}
function kebabCase(str) {
  var _a;
  return (_a = str.match(/[A-Z]{2,}(?=[A-Z][a-z0-9]*|\b)|[A-Z]?[a-z0-9]*|[A-Z]|[0-9]+/g)) === null || _a === void 0 ? void 0 : _a.filter(Boolean).map((x3) => x3.toLowerCase()).join("-");
}
function escapeStringKeepHash(str) {
  return str.replace(/['"]/g, "&#39;").replace(/\u0000/g, "\\0").replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\v/g, "\\v").replace(/\t/g, "\\t").replace(/\f/g, "\\f");
}
function trimStringStart(str = "", maxLength = 15) {
  return str.length > maxLength ? `…${str.substr(str.length - maxLength, maxLength)}` : str;
}
function trimStringMiddle(str = "", maxLength = 15) {
  const dist = Math.floor((maxLength - 3) / 2);
  return str.length > maxLength ? `${str.substr(0, dist)}…${str.substr(-dist, dist)}` : str;
}
function trimStringEnd(str = "", maxLength = 15) {
  return str.length > maxLength ? `${str.substr(0, maxLength)}…` : str;
}
function trimString(str = "", length = 15, type2 = TrimMode.Middle) {
  let result = trimStringEnd(str, length);
  if (type2 === TrimMode.Start)
    result = trimStringStart(str, length);
  else if (type2 === TrimMode.Middle)
    result = trimStringMiddle(str, length);
  return result;
}
function splitString(text, separators = [" "]) {
  let result = [text];
  for (let i = 0; i < separators.length; i++) {
    const sep = separators[i];
    result.forEach((d, index3) => {
      const separated = d.split(sep);
      const words = separated.map((word, j) => `${word}${j === separated.length - 1 ? "" : sep}`);
      result[index3] = words;
    });
    result = flatten(result);
  }
  return result;
}
function wrapSVGText(textElement, width, separator = [" ", "-", ".", ","]) {
  const text = textElement.text();
  if (!text)
    return;
  const separators = isArray(separator) ? separator : [separator];
  const words = splitString(text, separators);
  const x3 = parseFloat(textElement.attr("x")) || 0;
  textElement.text("");
  let tspan = textElement.append("tspan").attr("x", x3);
  let tspanContent = `${words[0]}`;
  tspan.text(tspanContent);
  words.forEach((word, i) => {
    if (i === 0)
      return;
    const tspanText = `${tspanContent}${word}`;
    tspan.text(tspanText);
    const tspanWidth = tspan.node().getComputedTextLength();
    if (tspanWidth > width) {
      tspan.text(tspanContent.trim());
      tspan = textElement.append("tspan").attr("x", x3).attr("dy", "1.2em").text(word);
      tspanContent = word;
    } else
      tspanContent += word;
  });
}
function trimSVGText(svgTextSelection, maxWidth, trimType, fastMode, fontSize, fontWidthToHeightRatio) {
  var _a;
  if (maxWidth === void 0) {
    maxWidth = 50;
  }
  if (trimType === void 0) {
    trimType = TrimMode.Middle;
  }
  if (fastMode === void 0) {
    fastMode = true;
  }
  if (fontSize === void 0) {
    fontSize = +((_a = window.getComputedStyle(svgTextSelection.node())) === null || _a === void 0 ? void 0 : _a.fontSize) || 0;
  }
  if (fontWidthToHeightRatio === void 0) {
    fontWidthToHeightRatio = getFontWidthToHeightRatio();
  }
  const text = svgTextSelection.text();
  const textLength = text.length;
  const textWidth = fastMode ? fontSize * textLength * fontWidthToHeightRatio : svgTextSelection.node().getComputedTextLength();
  const tolerance = 1.1;
  const maxCharacters = Math.ceil(textLength * maxWidth / (tolerance * textWidth));
  if (maxCharacters < textLength) {
    svgTextSelection.text(trimString(text, maxCharacters, trimType));
    return true;
  }
  return false;
}
function estimateStringPixelLength(str, fontSize, fontWidthToHeightRatio = getFontWidthToHeightRatio()) {
  return str.length * fontSize * fontWidthToHeightRatio || 0;
}
function getPreciseStringLengthPx(str, fontFamily, fontSize) {
  const svgNS = "http://www.w3.org/2000/svg";
  const svg = document.createElementNS(svgNS, "svg");
  const text = document.createElementNS(svgNS, "text");
  text.textContent = str;
  text.setAttribute("font-size", `${fontSize}`);
  text.setAttribute("font-family", fontFamily);
  svg.appendChild(text);
  document.body.appendChild(svg);
  const length = text.getComputedTextLength();
  document.body.removeChild(svg);
  return length;
}
function estimateTextSize(svgTextSelection, fontSize, dy = 0.32, fastMode = true, fontWidthToHeightRatio) {
  fontWidthToHeightRatio = fontWidthToHeightRatio || getFontWidthToHeightRatio();
  const tspanSelection = svgTextSelection.selectAll("tspan");
  const lines3 = tspanSelection.size() || 1;
  const height = svgTextSelection.text() ? 0.85 * fontSize * lines3 * (1 + dy) - dy : 0;
  let width = 0;
  if (tspanSelection.empty()) {
    const textLength = svgTextSelection.text().length;
    width = fastMode ? fontSize * textLength * fontWidthToHeightRatio : svgTextSelection.node().getComputedTextLength();
  } else {
    for (const tspan of tspanSelection.nodes()) {
      const tspanTextLength = tspan.textContent.length;
      const w2 = fastMode ? fontSize * tspanTextLength * fontWidthToHeightRatio : tspan.getComputedTextLength();
      if (w2 > width)
        width = w2;
    }
  }
  return { width, height };
}
function breakTextIntoLines(textBlock, width = void 0, fastMode = true, separator = UNOVIS_TEXT_SEPARATOR_DEFAULT, wordBreak = false) {
  const text = `${textBlock.text}`;
  if (!text)
    return [];
  const separators = Array.isArray(separator) ? separator : [separator];
  const splitByNewLine = text.split("\n");
  return splitByNewLine.map((str) => {
    const lines3 = [];
    if (!width)
      return [str];
    const words = splitString(str, separators);
    let line5 = "";
    for (let i = 0; i < words.length; i += 1) {
      const textLengthPx = fastMode ? estimateStringPixelLength(line5 + words[i], textBlock.fontSize, textBlock.fontWidthToHeightRatio) : getPreciseStringLengthPx(line5 + words[i], textBlock.fontFamily, textBlock.fontSize);
      if (textLengthPx < width || i === 0) {
        line5 += words[i];
      } else {
        lines3.push(line5.trim());
        line5 = words[i];
      }
      const minCharactersOnLine = 2;
      if (wordBreak) {
        while (line5.trim().length > minCharactersOnLine) {
          const subLineLengthPx = fastMode ? estimateStringPixelLength(line5, textBlock.fontSize, textBlock.fontWidthToHeightRatio) : getPreciseStringLengthPx(line5, textBlock.fontFamily, textBlock.fontSize);
          if (subLineLengthPx > width) {
            let breakIndex = line5.trim().length - minCharactersOnLine;
            while (breakIndex > 0) {
              const subLine = `${line5.substring(0, breakIndex)}${UNOVIS_TEXT_HYPHEN_CHARACTER_DEFAULT}`;
              const subLinePx = fastMode ? estimateStringPixelLength(subLine, textBlock.fontSize, textBlock.fontWidthToHeightRatio) : getPreciseStringLengthPx(subLine, textBlock.fontFamily, textBlock.fontSize);
              if (subLinePx <= width || breakIndex === 1) {
                lines3.push(subLine.trim());
                line5 = line5.substring(breakIndex);
                break;
              }
              breakIndex--;
            }
          } else {
            break;
          }
        }
      }
    }
    if (line5)
      lines3.push(line5.trim());
    return lines3;
  }).flat();
}
function getWrappedText(text, width = void 0, height = void 0, fastMode = true, separator = UNOVIS_TEXT_SEPARATOR_DEFAULT, wordBreak = false) {
  const textArrays = Array.isArray(text) ? text.map((t) => merge2(UNOVIS_TEXT_DEFAULT, t)) : [merge2(UNOVIS_TEXT_DEFAULT, text)];
  const textWrapped = textArrays.map((block) => breakTextIntoLines(block, width, fastMode, separator, wordBreak));
  const firstBlock = textArrays[0];
  let h = -firstBlock.fontSize * (firstBlock.lineHeight - 1);
  const blocks = [];
  textArrays.forEach((text2, i) => {
    var _a;
    let lines3 = textWrapped[i];
    const prevBlock = i > 0 ? blocks[i - 1] : void 0;
    const prevBlockMarginBottomPx = prevBlock ? prevBlock.marginBottom : 0;
    const marginTopPx = text2.marginTop;
    const effectiveMarginPx = Math.max(prevBlockMarginBottomPx, marginTopPx);
    h += effectiveMarginPx;
    const dh = text2.fontSize * text2.lineHeight;
    let maxWidth = 0;
    for (let k4 = 0; k4 < lines3.length; k4 += 1) {
      let line5 = lines3[k4];
      h += dh;
      const lineWithEllipsis = `${line5} …`;
      const textLengthPx = fastMode ? estimateStringPixelLength(lineWithEllipsis, text2.fontSize, text2.fontWidthToHeightRatio) : getPreciseStringLengthPx(lineWithEllipsis, text2.fontFamily, text2.fontSize);
      maxWidth = Math.max(textLengthPx, maxWidth);
      if (height && h + dh > height && k4 !== lines3.length - 1) {
        const lastCharacter = line5.charAt(line5.length - 1);
        if (lastCharacter === UNOVIS_TEXT_HYPHEN_CHARACTER_DEFAULT) {
          line5 = line5.substr(0, lines3[k4].length - 1);
        }
        if (textLengthPx < width) {
          lines3[k4] = lineWithEllipsis;
        } else {
          lines3[k4] = `${lines3[k4].substr(0, lines3[k4].length - 2)}…`;
        }
        lines3 = lines3.slice(0, k4 + 1);
        break;
      }
    }
    blocks.push(Object.assign(Object.assign({}, text2), { _lines: lines3, _estimatedHeight: h - ((prevBlock === null || prevBlock === void 0 ? void 0 : prevBlock._estimatedHeight) || 0), _maxWidth: Math.max(maxWidth, (_a = prevBlock === null || prevBlock === void 0 ? void 0 : prevBlock._maxWidth) !== null && _a !== void 0 ? _a : 0) }));
  });
  return blocks;
}
function renderTextToTspanStrings(blocks, x3 = 0, y3) {
  return blocks.map((b, i) => {
    const prevBlock = i > 0 ? blocks[i - 1] : void 0;
    const prevBlockMarginBottomEm = prevBlock ? prevBlock.marginBottom / prevBlock.fontSize : 0;
    const marginTopEm = b.marginTop / b.fontSize;
    const marginEm = Math.max(prevBlockMarginBottomEm, marginTopEm);
    const attributes = {
      fontSize: b.fontSize,
      fontFamily: b.fontFamily,
      fontWeight: b.fontWeight,
      fill: b.color,
      y: i === 0 && y3
    };
    const attributesString = Object.entries(attributes).filter(([_, value2]) => value2).map(([key, value2]) => `${kebabCase(key)}="${escapeStringKeepHash(value2.toString())}"`).join(" ");
    return `<tspan xmlns="http://www.w3.org/2000/svg" ${attributesString}>${b._lines.map((line5, k4) => {
      let dy;
      if (i === 0 && k4 === 0)
        dy = 0.8 + marginEm;
      else if (k4 === 0)
        dy = marginEm + b.lineHeight;
      else
        dy = b.lineHeight;
      return `<tspan x="${x3}" dy="${dy}em">${line5.length ? line5 : " "}</tspan>`;
    }).join("")}</tspan>`;
  });
}
function estimateWrappedTextHeight(blocks) {
  return sum(blocks, (b) => b._estimatedHeight);
}
var allowedSvgTextTags = ["text", "tspan", "textPath", "altGlyph", "altGlyphDef", "altGlyphItem", "glyphRef", "textRef", "textArea"];
function renderTextToSvgTextElement(textElement, text, options, trimmed) {
  var _a, _b;
  const wrappedText = getWrappedText(text, options.width, void 0, options.fastMode, options.separator, options.wordBreak);
  const textElementX = (_a = options.x) !== null && _a !== void 0 ? _a : +textElement.getAttribute("x");
  const textElementY = (_b = options.y) !== null && _b !== void 0 ? _b : +textElement.getAttribute("y");
  const x3 = textElementX !== null && textElementX !== void 0 ? textElementX : 0;
  let y3 = textElementY !== null && textElementY !== void 0 ? textElementY : 0;
  if (options.textAlign) {
    textElement.setAttribute("text-anchor", getTextAnchorFromTextAlign(options.textAlign));
  }
  if (options.verticalAlign && options.verticalAlign !== VerticalAlign.Top) {
    const height = estimateWrappedTextHeight(wrappedText);
    const dy = options.verticalAlign === VerticalAlign.Middle ? -height / 2 : options.verticalAlign === VerticalAlign.Bottom ? -height : 0;
    y3 += dy;
  }
  if (options.textRotationAngle) {
    textElement.setAttribute("transform", `rotate(${options.textRotationAngle === 0 || options.textRotationAngle ? options.textRotationAngle : 0} ${x3} ${y3})`);
  } else {
    textElement.removeAttribute("transform");
  }
  if (!trimmed) {
    const parser = new DOMParser();
    textElement.textContent = "";
    wrappedText.forEach((block) => {
      const svgCode = renderTextToTspanStrings([block], x3, y3).join("");
      const svgCodeSanitized = (0, import_striptags.default)(svgCode, allowedSvgTextTags);
      const parsedSvgCode = parser.parseFromString(svgCodeSanitized, "image/svg+xml").firstChild;
      textElement.appendChild(parsedSvgCode);
    });
  }
}
function renderTextIntoFrame(group3, text, frameOptions) {
  var _a, _b;
  const wrappedText = getWrappedText(text, frameOptions.width, frameOptions.height, frameOptions.fastMode, frameOptions.separator, frameOptions.wordBreak);
  const x3 = frameOptions.textAlign === TextAlign.Center ? frameOptions.width / 2 : frameOptions.textAlign === TextAlign.Right ? frameOptions.width : 0;
  let y3 = 0;
  const height = estimateWrappedTextHeight(wrappedText);
  const dh = frameOptions.height - height;
  y3 = frameOptions.verticalAlign === VerticalAlign.Middle ? dh / 2 : frameOptions.verticalAlign === VerticalAlign.Bottom ? dh : 0;
  const translate = frameOptions.x || frameOptions.y ? `transform="translate(${(_a = frameOptions.x) !== null && _a !== void 0 ? _a : 0},${(_b = frameOptions.y) !== null && _b !== void 0 ? _b : 0})"` : "";
  const svgCode = `<text
    xmlns="http://www.w3.org/2000/svg"
    text-anchor="${getTextAnchorFromTextAlign(frameOptions.textAlign)}"
    ${translate}
  >
    ${renderTextToTspanStrings(wrappedText, x3, y3).join("")}
  </text>`;
  const parser = new DOMParser();
  const svgCodeSanitized = (0, import_striptags.default)(svgCode, allowedSvgTextTags);
  const parsedSvgCode = parser.parseFromString(svgCodeSanitized, "image/svg+xml").firstChild;
  group3.textContent = "";
  group3.appendChild(parsedSvgCode);
}

// node_modules/@unovis/ts/components/axis/config.js
var AxisDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { position: void 0, type: void 0, label: void 0, labelFontSize: null, gridLine: true, tickLine: true, domainLine: true, numTicks: void 0, minMaxTicksOnly: false, tickTextWidth: void 0, tickTextSeparator: void 0, tickTextForceWordBreak: false, tickTextTrimType: TrimMode.Middle, tickTextFitMode: FitMode.Wrap, tickTextFontSize: null, tickTextAlign: void 0, tickTextColor: null, labelMargin: 8, labelColor: null, tickFormat: void 0, tickValues: void 0, fullSize: true, tickPadding: 8 });

// node_modules/@unovis/ts/components/axis/style.js
var style_exports5 = {};
__export(style_exports5, {
  axis: () => axis2,
  globalStyles: () => globalStyles4,
  grid: () => grid,
  hideDomain: () => hideDomain,
  hideTickLine: () => hideTickLine,
  label: () => label,
  root: () => root6,
  tick: () => tick,
  tickLabel: () => tickLabel
});
var root6 = css`
  label: axis-component;
`;
var globalStyles4 = injectGlobal`
  :root {
    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-axis-font-family: */
    --vis-axis-tick-color: #e8e9ef;
    /* --vis-axis-domain-color: // Undefined by default to allow fallback to var(--vis-axis-tick-color) */
    --vis-axis-grid-color: #e8e9ef;
    --vis-axis-label-color: #6c778c;
    --vis-axis-tick-label-color: #6c778c;
    --vis-axis-tick-label-font-size: 12px;
    --vis-axis-tick-label-cursor: default;
    --vis-axis-tick-label-text-decoration: none;
    --vis-axis-label-font-size: 14px;
    --vis-axis-tick-line-width: 1px;
    --vis-axis-grid-line-width: 1px;
    /* --vis-axis-domain-line-width: // Undefined by default to allow fallback to var(--vis-axis-grid-line-width) */

    --vis-dark-axis-tick-color: #6c778c;
    /* --vis-dark-axis-domain-color: // Undefined by default to allow fallback to var(--vis-dark-axis-tick-color) */
    --vis-dark-axis-tick-label-color: #e8e9ef;
    --vis-dark-axis-grid-color: #6c778c;
    --vis-dark-axis-label-color: #fefefe;
  }

  body.theme-dark ${`.${root6}`} {
    --vis-axis-tick-color: var(--vis-dark-axis-tick-color);
    --vis-axis-domain-color: var(--vis-dark-axis-domain-color);
    --vis-axis-tick-label-color: var(--vis-dark-axis-tick-label-color);
    --vis-axis-grid-color: var(--vis-dark-axis-grid-color);
    --vis-axis-label-color: var(--vis-dark-axis-label-color);
  }
`;
var hideTickLine = css`
  label: hide-tick-line;
`;
var hideDomain = css`
  label: hide-domain;
`;
var axis2 = css`
  label: axis;

  user-select: none;

  .domain {
    stroke: var(--vis-axis-domain-color, var(--vis-axis-tick-color));
    stroke-width: var(--vis-axis-domain-line-width, var(--vis-axis-grid-line-width));
  }

  &${`.${hideTickLine}`} {
    .tick > line {
      opacity: 0;
    }
  }

  &${`.${hideDomain}`} {
    .domain {
      opacity: 0;
    }
  }
`;
var grid = css`
  label: grid;

  .domain {
    opacity: 0;
  }

  line {
    stroke: var(--vis-axis-grid-color);
    stroke-width: var(--vis-axis-grid-line-width);
  }
`;
var tick = css`
  label: tick;

  stroke: none;
  font-size: var(--vis-axis-tick-label-font-size);

  line {
    stroke: var(--vis-axis-tick-color);
    stroke-width: var(--vis-axis-tick-line-width);
  }

  text {
    fill: var(--vis-axis-tick-label-color);
    cursor: var(--vis-axis-tick-label-cursor);
    font-family: var(--vis-axis-font-family, var(--vis-font-family));
    text-decoration: var(--vis-axis-tick-label-text-decoration);
    stroke: none;
  }

`;
var label = css`
  label: label;
  fill: var(--vis-axis-label-color);
  font-size: var(--vis-axis-label-font-size);
  font-family: var(--vis-axis-font-family, var(--vis-font-family));
  text-anchor: middle;
`;
var tickLabel = css`
  label: tick-label;
`;

// node_modules/@unovis/ts/components/axis/index.js
var Axis = class extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = AxisDefaultConfig;
    this.config = this._defaultConfig;
    this._defaultNumTicks = 3;
    this._minMaxTicksOnlyEnforceWidth = 250;
    this.events = {};
    if (config)
      this.setConfig(config);
    this.axisGroup = this.g.append("g");
    this.gridGroup = this.g.append("g").attr("class", grid);
  }
  /** Renders axis to an invisible grouped to calculate automatic chart margins */
  preRender() {
    const { config } = this;
    const axisRenderHelperGroup = this.g.append("g").attr("opacity", 0);
    this._renderAxis(axisRenderHelperGroup, 0);
    this._axisRawBBox = axisRenderHelperGroup.node().getBBox();
    if (config.tickTextAlign)
      this._alignTickLabels();
    this._renderAxisLabel(axisRenderHelperGroup);
    this._axisSizeBBox = this._getAxisSize(axisRenderHelperGroup);
    this._requiredMargin = this._getRequiredMargin(this._axisSizeBBox);
    axisRenderHelperGroup.remove();
  }
  getPosition() {
    const { config: { type: type2, position } } = this;
    return position !== null && position !== void 0 ? position : type2 === AxisType.X ? Position.Bottom : Position.Left;
  }
  _getAxisSize(selection2) {
    const bBox = selection2.node().getBBox();
    return bBox;
  }
  _getRequiredMargin(axisSize = this._axisSizeBBox) {
    const { config: { type: type2, position } } = this;
    switch (type2) {
      case AxisType.X: {
        const tolerancePx = 1;
        const xEnd = this._axisSizeBBox.x + this._axisSizeBBox.width;
        const left3 = this._axisSizeBBox.x < 0 ? Math.abs(this._axisSizeBBox.x) : 0;
        const right3 = xEnd - this._width > tolerancePx ? xEnd - this._width : 0;
        switch (position) {
          case Position.Top:
            return { top: axisSize.height, left: left3, right: right3 };
          case Position.Bottom:
          default:
            return { bottom: axisSize.height, left: left3, right: right3 };
        }
      }
      case AxisType.Y: {
        const bleedY = axisSize.height > this._height ? (axisSize.height - this._height) / 2 : 0;
        const top2 = bleedY;
        const bottom2 = bleedY;
        switch (position) {
          case Position.Right:
            return { right: axisSize.width, top: top2, bottom: bottom2 };
          case Position.Left:
          default:
            return { left: axisSize.width, top: top2, bottom: bottom2 };
        }
      }
    }
  }
  getRequiredMargin() {
    return this._requiredMargin;
  }
  /** Calculates axis transform:translate offset based on passed container margins */
  getOffset(containerMargin) {
    const { config: { type: type2, position } } = this;
    switch (type2) {
      case AxisType.X:
        switch (position) {
          case Position.Top:
            return { top: containerMargin.top, left: containerMargin.left };
          case Position.Bottom:
          default:
            return { top: containerMargin.top + this._height, left: containerMargin.left };
        }
      case AxisType.Y:
        switch (position) {
          case Position.Right:
            return { top: containerMargin.top, left: containerMargin.left + this._width };
          case Position.Left:
          default:
            return { top: containerMargin.top, left: containerMargin.left };
        }
    }
  }
  _render(duration = this.config.duration, selection2 = this.axisGroup) {
    const { config } = this;
    this._renderAxis(selection2, duration);
    this._renderAxisLabel(selection2);
    if (config.gridLine) {
      const gridGen = this._buildGrid().tickFormat(() => "");
      gridGen.tickValues(this._getConfiguredTickValues());
      this.gridGroup.selectAll("*").interrupt();
      smartTransition(this.gridGroup, duration).call(gridGen).style("opacity", 1);
    } else {
      smartTransition(this.gridGroup, duration).style("opacity", 0);
    }
    if (config.tickTextAlign)
      this._alignTickLabels();
  }
  _buildAxis() {
    const { config: { type: type2, position, tickPadding } } = this;
    const ticks2 = this._getNumTicks();
    switch (type2) {
      case AxisType.X:
        switch (position) {
          case Position.Top:
            return axisTop(this.xScale).ticks(ticks2).tickPadding(tickPadding);
          case Position.Bottom:
          default:
            return axisBottom(this.xScale).ticks(ticks2).tickPadding(tickPadding);
        }
      case AxisType.Y:
        switch (position) {
          case Position.Right:
            return axisRight(this.yScale).ticks(ticks2).tickPadding(tickPadding);
          case Position.Left:
          default:
            return axisLeft(this.yScale).ticks(ticks2).tickPadding(tickPadding);
        }
    }
  }
  _buildGrid() {
    const { config: { type: type2, position } } = this;
    const ticks2 = this._getNumTicks();
    switch (type2) {
      case AxisType.X:
        switch (position) {
          case Position.Top:
            return axisTop(this.xScale).ticks(ticks2 * 2).tickSize(-this._height).tickSizeOuter(0);
          case Position.Bottom:
          default:
            return axisBottom(this.xScale).ticks(ticks2 * 2).tickSize(-this._height).tickSizeOuter(0);
        }
      case AxisType.Y:
        switch (position) {
          case Position.Right:
            return axisRight(this.yScale).ticks(ticks2 * 2).tickSize(-this._width).tickSizeOuter(0);
          case Position.Left:
          default:
            return axisLeft(this.yScale).ticks(ticks2 * 2).tickSize(-this._width).tickSizeOuter(0);
        }
    }
  }
  _renderAxis(selection2 = this.axisGroup, duration = this.config.duration) {
    const { config } = this;
    const axisGen = this._buildAxis();
    const tickValues = this._getConfiguredTickValues() || axisGen.scale().ticks(this._getNumTicks());
    axisGen.tickValues(tickValues);
    selection2.selectAll("*").interrupt();
    smartTransition(selection2, duration).call(axisGen);
    const ticks2 = selection2.selectAll("g.tick");
    ticks2.classed(tick, true).style("font-size", config.tickTextFontSize);
    const tickText = selection2.selectAll("g.tick > text").filter((tickValue) => tickValues.some((t) => isEqual(tickValue, t))).classed(tickLabel, true).style("fill", config.tickTextColor);
    tickText.nodes().forEach((node4) => interrupt_default(node4));
    tickText.each((value2, i, elements) => {
      var _a, _b;
      let text = (_b = (_a = config.tickFormat) === null || _a === void 0 ? void 0 : _a.call(config, value2, i, tickValues)) !== null && _b !== void 0 ? _b : `${value2}`;
      const textElement = elements[i];
      const textMaxWidth = config.tickTextWidth || (config.type === AxisType.X ? this._containerWidth / (ticks2.size() + 1) : this._containerWidth / 5);
      const styleDeclaration = getComputedStyle(textElement);
      const fontSize = Number.parseFloat(styleDeclaration.fontSize);
      const fontFamily = styleDeclaration.fontFamily;
      const textOptions = {
        verticalAlign: config.type === AxisType.X ? VerticalAlign.Top : VerticalAlign.Middle,
        width: textMaxWidth,
        textRotationAngle: config.tickTextAngle,
        separator: config.tickTextSeparator,
        wordBreak: config.tickTextForceWordBreak
      };
      if (config.tickTextFitMode === FitMode.Trim) {
        const textElementSelection = select_default2(textElement).text(text);
        trimSVGText(textElementSelection, textMaxWidth, config.tickTextTrimType, true, fontSize, 0.58);
        text = select_default2(textElement).text();
      }
      const textBlock = { text, fontFamily, fontSize };
      renderTextToSvgTextElement(textElement, textBlock, textOptions);
    });
    selection2.classed(axis2, true).classed(hideTickLine, !config.tickLine).classed(hideDomain, !config.domainLine);
    if (config.fullSize) {
      const path3 = this._getFullDomainPath(0);
      smartTransition(selection2.select(".domain"), duration).attr("d", path3);
    }
  }
  _getNumTicks() {
    const { config: { type: type2, numTicks } } = this;
    if (numTicks)
      return numTicks;
    if (type2 === AxisType.X) {
      const xRange = this.xScale.range();
      const width = xRange[1] - xRange[0];
      return Math.floor(width / 175);
    }
    if (type2 === AxisType.Y) {
      const yRange = this.yScale.range();
      const height = Math.abs(yRange[0] - yRange[1]);
      return Math.pow(height, 0.85) / 25;
    }
    return this._defaultNumTicks;
  }
  _getConfiguredTickValues() {
    const { config: { tickValues, type: type2, minMaxTicksOnly } } = this;
    const scale = type2 === AxisType.X ? this.xScale : this.yScale;
    const scaleDomain = scale === null || scale === void 0 ? void 0 : scale.domain();
    if (tickValues) {
      return tickValues.filter((v) => v >= scaleDomain[0] && v <= scaleDomain[1]);
    }
    if (minMaxTicksOnly || type2 === AxisType.X && this._width < this._minMaxTicksOnlyEnforceWidth) {
      return scaleDomain;
    }
    return null;
  }
  _getFullDomainPath(tickSize = 0) {
    const { config: { type: type2 } } = this;
    switch (type2) {
      case AxisType.X:
        return `M0.5, ${tickSize} V0.5 H${this._width + 0.5} V${tickSize}`;
      case AxisType.Y:
        return `M${-tickSize}, ${this._height + 0.5} H0.5 V0.5 H${-tickSize}`;
    }
  }
  _renderAxisLabel(selection2 = this.axisGroup) {
    var _a;
    const { type: type2, label: label$1, labelMargin, labelFontSize } = this.config;
    selection2.selectAll(`.${label}`).remove();
    const axisPosition = this.getPosition();
    const { width: axisWidth, height: axisHeight } = (_a = this._axisRawBBox) !== null && _a !== void 0 ? _a : selection2.node().getBBox();
    const offsetX = type2 === AxisType.X ? this._width / 2 : Math.pow(-1, +(axisPosition === Position.Left)) * axisWidth;
    const offsetY = type2 === AxisType.X ? Math.pow(-1, +(axisPosition === Position.Top)) * axisHeight : this._height / 2;
    const marginX = type2 === AxisType.X ? 0 : Math.pow(-1, +(axisPosition === Position.Left)) * labelMargin;
    const marginY = type2 === AxisType.X ? Math.pow(-1, +(axisPosition === Position.Top)) * labelMargin : 0;
    const rotation = type2 === AxisType.Y ? -90 : 0;
    selection2.append("text").attr("class", label).text(label$1).attr("dy", `${this._getLabelDY()}em`).attr("transform", `translate(${offsetX + marginX},${offsetY + marginY}) rotate(${rotation})`).style("font-size", labelFontSize).style("fill", this.config.labelColor);
  }
  _getLabelDY() {
    const { type: type2, position } = this.config;
    switch (type2) {
      case AxisType.X:
        switch (position) {
          case Position.Top:
            return 0;
          case Position.Bottom:
          default:
            return 0.75;
        }
      case AxisType.Y:
        switch (position) {
          case Position.Right:
            return 0.75;
          case Position.Left:
          default:
            return -0.25;
        }
    }
  }
  _alignTickLabels() {
    const { config: { type: type2, tickTextAlign, tickTextAngle, position } } = this;
    const tickText = this.g.selectAll("g.tick > text");
    const textAnchor = this._getTickTextAnchor(tickTextAlign);
    const translateX2 = type2 === AxisType.X ? 0 : this._getYTickTextTranslate(tickTextAlign, position);
    tickText.attr("transform", `translate(${translateX2},0) rotate(${tickTextAngle})`).attr("text-anchor", textAnchor);
  }
  _getTickTextAnchor(textAlign) {
    switch (textAlign) {
      case TextAlign.Left:
        return "start";
      case TextAlign.Right:
        return "end";
      case TextAlign.Center:
        return "middle";
      default:
        return null;
    }
  }
  _getYTickTextTranslate(textAlign, axisPosition = Position.Left) {
    const defaultTickTextSpacingPx = 9;
    const width = this._axisRawBBox.width - defaultTickTextSpacingPx;
    switch (textAlign) {
      case TextAlign.Left:
        return axisPosition === Position.Left ? width * -1 : 0;
      case TextAlign.Right:
        return axisPosition === Position.Left ? 0 : width;
      case TextAlign.Center:
        return axisPosition === Position.Left ? width * -0.5 : width * 0.5;
      default:
        return 0;
    }
  }
};
Axis.selectors = style_exports5;

// node_modules/@unovis/ts/types/symbol.js
var SymbolType;
(function(SymbolType2) {
  SymbolType2["Circle"] = "circle";
  SymbolType2["Cross"] = "cross";
  SymbolType2["Diamond"] = "diamond";
  SymbolType2["Square"] = "square";
  SymbolType2["Star"] = "star";
  SymbolType2["Triangle"] = "triangle";
  SymbolType2["Wye"] = "wye";
})(SymbolType || (SymbolType = {}));
var Symbol3 = {
  [SymbolType.Circle]: circle_default,
  [SymbolType.Cross]: cross_default,
  [SymbolType.Diamond]: diamond_default,
  [SymbolType.Square]: square_default,
  [SymbolType.Star]: star_default,
  [SymbolType.Triangle]: triangle_default,
  [SymbolType.Wye]: wye_default
};

// node_modules/@unovis/ts/components/scatter/config.js
var ScatterDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { color: (d) => d.color, size: 10, sizeScale: Scale.scaleSqrt(), sizeRange: void 0, shape: SymbolType.Circle, label: void 0, labelColor: void 0, labelPosition: Position.Bottom, labelHideOverlapping: true, cursor: null, labelTextBrightnessRatio: 0.65, strokeColor: void 0, strokeWidth: void 0 });

// node_modules/@unovis/ts/components/scatter/modules/utils.js
function isLabelPositionCenter(labelPosition) {
  return labelPosition !== Position.Top && labelPosition !== Position.Bottom && labelPosition !== Position.Left && labelPosition !== Position.Right;
}
function getCentralLabelFontSize(pointDiameter, textLength) {
  return textLength ? 0.7 * pointDiameter / Math.pow(textLength, 0.5) : 0;
}
function getLabelShift(labelPosition, pointDiameter, labelPadding = 5) {
  switch (labelPosition) {
    case Position.Top:
      return [0, -pointDiameter / 2 - labelPadding];
    case Position.Bottom:
      return [0, pointDiameter / 2 + labelPadding];
    case Position.Left:
      return [-pointDiameter / 2 - labelPadding, 0];
    case Position.Right:
      return [pointDiameter / 2 + labelPadding, 0];
    default:
      return [0, 0];
  }
}
function getEstimatedLabelBBox(d, labelPosition, xScale, yScale, fontSizePx) {
  var _a;
  const x3 = xScale(d._point.xValue);
  const y3 = yScale(d._point.yValue);
  const pointDiameter = d._point.sizePx;
  const pointLabelText = (_a = d._point.label) !== null && _a !== void 0 ? _a : "";
  const textLength = pointLabelText.length;
  const centralLabelFontSize = getCentralLabelFontSize(pointDiameter, textLength);
  const width = estimateStringPixelLength(pointLabelText, isLabelPositionCenter(labelPosition) ? centralLabelFontSize : fontSizePx, 0.6);
  const height = fontSizePx;
  const labelShift = getLabelShift(labelPosition, pointDiameter);
  const dx = labelPosition === Position.Left ? -width : labelPosition === Position.Right ? 0 : -width / 2;
  const dy = labelPosition === Position.Top ? -height : labelPosition === Position.Bottom ? 0 : -height / 2;
  const bbox = {
    x: x3 + labelShift[0] + dx,
    y: y3 + labelShift[1] + dy,
    width,
    height
  };
  return bbox;
}
function collideLabels(selection2, config, xScale, yScale) {
  selection2.each((datum1, i, elements) => {
    const node4 = elements[i];
    node4._labelVisible = true;
  });
  selection2.each((datum1, i, elements) => {
    var _a, _b;
    const group1Node = elements[i];
    const label1Position = getValue(datum1, config.labelPosition, datum1._point.pointIndex);
    if (!group1Node._labelVisible || isLabelPositionCenter(label1Position))
      return;
    const label1 = select_default2(group1Node).select("text");
    const label1FontSize = Number.parseFloat((_a = window.getComputedStyle(label1.node())) === null || _a === void 0 ? void 0 : _a.fontSize);
    const label1BoundingRect = getEstimatedLabelBBox(datum1, label1Position, xScale, yScale, label1FontSize);
    for (let j = 0; j < elements.length; j += 1) {
      if (i === j)
        continue;
      const group2Node = elements[j];
      const group22 = select_default2(group2Node);
      const label22 = group22.select("text");
      const datum2 = group22.datum();
      const p2Pos = [xScale(datum2._point.xValue), yScale(datum2._point.yValue)];
      const p2Radius = datum2._point.sizePx / 2;
      const point2BoundingRect = {
        x: p2Pos[0] - p2Radius,
        y: p2Pos[1] - p2Radius,
        width: 2 * p2Radius,
        height: 2 * p2Radius
      };
      let intersect2 = rectIntersect(label1BoundingRect, point2BoundingRect, 2);
      const label2Visible = group2Node._labelVisible;
      if (!intersect2 && label2Visible) {
        const label2FontSize = Number.parseFloat((_b = window.getComputedStyle(label22.node())) === null || _b === void 0 ? void 0 : _b.fontSize);
        const label2Position = getValue(datum2, config.labelPosition, datum2._point.pointIndex);
        const label2BoundingRect = getEstimatedLabelBBox(datum2, label2Position, xScale, yScale, label2FontSize);
        intersect2 = rectIntersect(label1BoundingRect, label2BoundingRect, 0.25);
      }
      if (intersect2) {
        if (group1Node._forceShowLabel)
          group2Node._labelVisible = false;
        else {
          group1Node._labelVisible = false;
          break;
        }
      }
    }
  });
  selection2.each((datum1, i, elements) => {
    const node4 = elements[i];
    const label10 = select_default2(node4).select("text");
    label10.attr("opacity", node4._labelVisible ? 1 : 0);
  });
}

// node_modules/@unovis/ts/components/scatter/modules/point.js
function createPoints(selection2, xScale, yScale) {
  selection2.attr("transform", (d) => `translate(${d._point.xValue},${d._point.yValue})`);
  selection2.append("path").style("fill", (d) => d._point.color);
  selection2.append("text").style("pointer-events", "none");
  selection2.attr("transform", (d) => `translate(${xScale(d._point.xValue)},${yScale(d._point.yValue)}) scale(0)`);
}
function updatePoints(selection2, config, xScale, yScale, duration) {
  const symbolGenerator = Symbol2();
  selection2.each((d, index3, elements) => {
    var _a, _b, _c, _d;
    const group3 = select_default2(elements[index3]);
    const label10 = group3.select("text");
    const path3 = group3.select("path");
    const pointDiameter = d._point.sizePx;
    const pointColor = d._point.color;
    const pointStrokeColor = (_a = d._point.strokeColor) !== null && _a !== void 0 ? _a : null;
    const pointStrokeWidth = (_b = d._point.strokeWidthPx) !== null && _b !== void 0 ? _b : null;
    path3.attr("d", () => {
      const svgPath = d._point.shape ? symbolGenerator.size(Math.PI * pointDiameter * pointDiameter / 4).type(Symbol3[d._point.shape])() : null;
      return svgPath;
    });
    smartTransition(path3, duration).style("fill", pointColor).style("stroke", pointStrokeColor).style("stroke-width", `${pointStrokeWidth}px`);
    const labelPosition = d._point.labelPosition;
    const isLabelPositionCenter2 = labelPosition !== Position.Top && labelPosition !== Position.Bottom && labelPosition !== Position.Left && labelPosition !== Position.Right;
    const pointLabelText = (_c = d._point.label) !== null && _c !== void 0 ? _c : "";
    const textLength = pointLabelText.length;
    const centralLabelFontSize = getCentralLabelFontSize(pointDiameter, textLength);
    let labelColor = d._point.labelColor;
    if (!labelColor && isLabelPositionCenter2) {
      const c3 = pointColor || "var(--vis-scatter-fill-color)";
      const hex2 = (_d = color(isStringCSSVariable(c3) ? getCSSVariableValue(c3, group3.node()) : c3)) === null || _d === void 0 ? void 0 : _d.hex();
      const brightness = hexToBrightness(hex2);
      labelColor = brightness > config.labelTextBrightnessRatio ? "var(--vis-scatter-point-label-text-color-dark)" : "var(--vis-scatter-point-label-text-color-light)";
    }
    const labelShift = getLabelShift(labelPosition, pointDiameter);
    label10.html(pointLabelText).attr("x", labelShift[0]).attr("y", labelShift[1]).style("font-size", isLabelPositionCenter2 ? centralLabelFontSize : null).style("text-anchor", () => {
      switch (labelPosition) {
        case Position.Right:
          return null;
        case Position.Left:
          return "end";
        default:
          return "middle";
      }
    }).style("dominant-baseline", () => {
      switch (labelPosition) {
        case Position.Top:
          return null;
        case Position.Bottom:
          return "hanging";
        default:
          return "central";
      }
    });
    smartTransition(label10, duration).style("fill", labelColor);
    path3.style("cursor", d._point.cursor);
  });
  smartTransition(selection2, duration).attr("transform", (d) => `translate(${xScale(d._point.xValue)},${yScale(d._point.yValue)}) scale(1)`);
}
function removePoints(selection2, xScale, yScale, duration) {
  smartTransition(selection2, duration).attr("transform", (d) => `translate(${xScale(d._point.xValue)},${yScale(d._point.yValue)}) scale(0)`).remove();
}

// node_modules/@unovis/ts/components/scatter/style.js
var style_exports6 = {};
__export(style_exports6, {
  globalStyles: () => globalStyles5,
  point: () => point6,
  pointGroup: () => pointGroup,
  pointGroupExit: () => pointGroupExit,
  root: () => root7
});
var globalStyles5 = injectGlobal`
  :root {
    --vis-scatter-cursor: default;
    --vis-scatter-fill-color: var(--vis-color-main);
    --vis-scatter-stroke-color: 'none';
    --vis-scatter-stroke-width: 1px;
    --vis-scatter-fill-opacity: 1;
    --vis-scatter-stroke-opacity: 1;
    --vis-scatter-hover-stroke-width: 2px;

    --vis-scatter-point-label-text-color-dark: #5b5f6d;
    --vis-scatter-point-label-text-color-light: #fff;
    --vis-scatter-point-label-text-font-weight: 500;
    --vis-scatter-point-label-text-font-size: 12px;
    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-scatter-point-label-text-font-family: */
  }
`;
var root7 = css`
  label: scatter-component;
`;
var pointGroup = css`
  label: point-group;
`;
var pointGroupExit = css`
  label: point-group-exit;
`;
var point6 = css`
  label: point;

  > path {
    cursor: var(--vis-scatter-cursor);
    fill: var(--vis-scatter-fill-color);
    fill-opacity: var(--vis-scatter-fill-opacity);
    stroke-opacity: var(--vis-scatter-stroke-opacity);
    stroke-width: var(--vis-scatter-stroke-width);
    stroke: var(--vis-scatter-stroke-color);

    &:hover {
        stroke-width: var(--vis-scatter-hover-stroke-width);
    }
  }

  > text {
    font-weight: var(--vis-scatter-point-label-text-font-weight);
    font-size: var(--vis-scatter-point-label-text-font-size);
    font-family: var(--vis-scatter-point-label-text-font-family, var(--vis-font-family));
    fill: var(--vis-scatter-point-label-text-color-dark);
    user-select: none;
  }
`;

// node_modules/@unovis/ts/components/scatter/index.js
var Scatter = class _Scatter extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = ScatterDefaultConfig;
    this.config = this._defaultConfig;
    this.events = {
      [_Scatter.selectors.point]: {
        mouseenter: this._onPointMouseOver.bind(this),
        mouseleave: this._onPointMouseOut.bind(this)
      }
    };
    this._pointData = [];
    if (config)
      this.setConfig(config);
  }
  setConfig(config) {
    super.setConfig(config);
    this._updateSizeScale();
  }
  setData(data) {
    super.setData(data);
    this._updateSizeScale();
  }
  get bleed() {
    this._pointData = this._getOnScreenData();
    const pointDataFlat = flatten(this._pointData);
    const yRangeStart = min(this.yScale.range());
    const yRangeEnd = max(this.yScale.range());
    const xRangeStart = this.xScale.range()[0];
    const xRangeEnd = this.xScale.range()[1];
    const fontSizePx = getCSSVariableValueInPixels("var(--vis-scatter-point-label-text-font-size)", this.element);
    const extent2 = pointDataFlat.reduce((ext, d) => {
      const x3 = this.xScale(d._point.xValue);
      const y3 = this.yScale(d._point.yValue);
      const r = d._point.sizePx / 2;
      ext.minX = Math.min(ext.minX, x3 - r);
      ext.maxX = Math.max(ext.maxX, x3 + r);
      ext.minY = Math.min(ext.minY, y3 - r);
      ext.maxY = Math.max(ext.maxY, y3 + r);
      if (d._point.label) {
        const labelBBox = getEstimatedLabelBBox(d, d._point.labelPosition, this.xScale, this.yScale, fontSizePx);
        ext.minX = Math.min(ext.minX, labelBBox.x);
        ext.maxX = Math.max(ext.maxX, labelBBox.x + labelBBox.width);
        ext.minY = Math.min(ext.minY, labelBBox.y);
        ext.maxY = Math.max(ext.maxY, labelBBox.y + labelBBox.height);
      }
      return ext;
    }, {
      minX: Number.POSITIVE_INFINITY,
      maxX: Number.NEGATIVE_INFINITY,
      minY: Number.POSITIVE_INFINITY,
      maxY: Number.NEGATIVE_INFINITY
    });
    const coeff = 1.2;
    const top2 = extent2.minY < yRangeStart ? coeff * (yRangeStart - extent2.minY) : 0;
    const bottom2 = extent2.maxY > yRangeEnd ? coeff * (extent2.maxY - yRangeEnd) : 0;
    const left3 = extent2.minX < xRangeStart ? coeff * (xRangeStart - extent2.minX) : 0;
    const right3 = extent2.maxX > xRangeEnd ? coeff * (extent2.maxX - xRangeEnd) : 0;
    return { top: top2, bottom: bottom2, left: left3, right: right3 };
  }
  _render(customDuration) {
    const { config } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const pointGroups = this.g.selectAll(`.${pointGroup}`).data(this._pointData);
    const pointGroupsEnter = pointGroups.enter().append("g").attr("class", pointGroup);
    const pointGroupsMerged = pointGroupsEnter.merge(pointGroups);
    smartTransition(pointGroupsMerged, duration).style("opacity", 1);
    const pointGroupExit$1 = pointGroups.exit().attr("class", pointGroupExit);
    smartTransition(pointGroupExit$1, duration).style("opacity", 0).remove();
    const points3 = pointGroupsMerged.selectAll(`.${point6}`).data((d) => d, (d) => {
      var _a;
      return `${(_a = getString(d, config.id, d._point.pointIndex)) !== null && _a !== void 0 ? _a : d._point.pointIndex}`;
    });
    const pointsEnter = points3.enter().append("g").attr("class", point6);
    createPoints(pointsEnter, this.xScale, this.yScale);
    this._points = pointsEnter.merge(points3);
    updatePoints(this._points, config, this.xScale, this.yScale, duration);
    removePoints(points3.exit(), this.xScale, this.yScale, duration);
    this._resolveLabelOverlap();
  }
  _resolveLabelOverlap() {
    if (!this.config.labelHideOverlapping) {
      const label10 = this._points.selectAll("text");
      label10.attr("opacity", null);
      return;
    }
    cancelAnimationFrame(this._collideLabelsAnimFrameId);
    this._collideLabelsAnimFrameId = requestAnimationFrame(() => {
      collideLabels(this._points, this.config, this.xScale, this.yScale);
    });
  }
  _updateSizeScale() {
    var _a;
    const { config, datamodel } = this;
    this._sizeScale = config.sizeScale.copy();
    this._sizeScale.domain(getExtent(datamodel.data, config.size));
    this._sizeScale.range((_a = config.sizeRange) !== null && _a !== void 0 ? _a : [0, 0]);
  }
  _getOnScreenData() {
    const { config, datamodel: { data } } = this;
    const xDomain = this.xScale.domain().map((d) => +d);
    const yDomain = this.yScale.domain().map((d) => +d);
    const yAccessors = isArray(config.y) ? config.y : [config.y];
    const maxSizeValue = max(flatten(yAccessors.map((y3, j) => data === null || data === void 0 ? void 0 : data.map((d) => getNumber(d, config.size, j)))));
    const maxSizePx = config.sizeRange ? this._sizeScale(maxSizeValue) : maxSizeValue;
    const maxSizeXDomain = this.xScale.invert(maxSizePx) - this.xScale.invert(0);
    const maxSizeYDomain = Math.abs(this.yScale.invert(maxSizePx) - this.yScale.invert(0));
    return yAccessors.map((y3, j) => {
      var _a;
      return (_a = data === null || data === void 0 ? void 0 : data.reduce((acc, d, i) => {
        const xValue = getNumber(d, config.x, i);
        const yValue = getNumber(d, y3, j);
        const pointSize = getNumber(d, config.size, i);
        const pointSizeScaled = config.sizeRange ? this._sizeScale(pointSize) : pointSize;
        const pointSizeXDomain = this.xScale.invert(pointSizeScaled) - this.xScale.invert(0);
        const pointSizeYDomain = Math.abs(this.yScale.invert(pointSizeScaled) - this.yScale.invert(0));
        if (xValue - pointSizeXDomain / 2 >= xDomain[0] - maxSizeXDomain / 2 && xValue + pointSizeXDomain / 2 <= xDomain[1] + maxSizeXDomain / 2 && yValue - pointSizeYDomain / 2 >= yDomain[0] - maxSizeYDomain / 2 && yValue + pointSizeYDomain / 2 <= yDomain[1] + maxSizeYDomain / 2) {
          acc.push(Object.assign(Object.assign({}, d), { _point: {
            xValue,
            yValue,
            sizePx: pointSizeScaled,
            color: getColor(d, config.color, j),
            strokeColor: getColor(d, config.strokeColor, j, true),
            strokeWidthPx: getNumber(d, config.strokeWidth, j),
            shape: getString(d, config.shape, j),
            label: getString(d, config.label, j),
            labelColor: getColor(d, config.labelColor, j, true),
            labelPosition: getValue(d, config.labelPosition, i),
            cursor: getString(d, config.cursor, j),
            groupIndex: j,
            pointIndex: i
          } }));
        }
        return acc;
      }, [])) !== null && _a !== void 0 ? _a : [];
    });
  }
  _onPointMouseOver(d, event) {
    const point13 = select_default2(event.target);
    const pointNode = point13.node();
    if (pointNode)
      pointNode._forceShowLabel = true;
    point13.raise();
    this._resolveLabelOverlap();
  }
  _onPointMouseOut(d, event) {
    const pointNode = select_default2(event.target).node();
    if (pointNode)
      delete pointNode._forceShowLabel;
    this._resolveLabelOverlap();
  }
};
Scatter.selectors = style_exports6;

// node_modules/d3-drag/src/noevent.js
var nonpassive = { passive: false };
var nonpassivecapture = { capture: true, passive: false };
function nopropagation(event) {
  event.stopImmediatePropagation();
}
function noevent_default(event) {
  event.preventDefault();
  event.stopImmediatePropagation();
}

// node_modules/d3-drag/src/nodrag.js
function nodrag_default(view) {
  var root25 = view.document.documentElement, selection2 = select_default2(view).on("dragstart.drag", noevent_default, nonpassivecapture);
  if ("onselectstart" in root25) {
    selection2.on("selectstart.drag", noevent_default, nonpassivecapture);
  } else {
    root25.__noselect = root25.style.MozUserSelect;
    root25.style.MozUserSelect = "none";
  }
}
function yesdrag(view, noclick) {
  var root25 = view.document.documentElement, selection2 = select_default2(view).on("dragstart.drag", null);
  if (noclick) {
    selection2.on("click.drag", noevent_default, nonpassivecapture);
    setTimeout(function() {
      selection2.on("click.drag", null);
    }, 0);
  }
  if ("onselectstart" in root25) {
    selection2.on("selectstart.drag", null);
  } else {
    root25.style.MozUserSelect = root25.__noselect;
    delete root25.__noselect;
  }
}

// node_modules/d3-drag/src/constant.js
var constant_default4 = (x3) => () => x3;

// node_modules/d3-drag/src/event.js
function DragEvent(type2, {
  sourceEvent,
  subject,
  target,
  identifier,
  active,
  x: x3,
  y: y3,
  dx,
  dy,
  dispatch
}) {
  Object.defineProperties(this, {
    type: { value: type2, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent, enumerable: true, configurable: true },
    subject: { value: subject, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    identifier: { value: identifier, enumerable: true, configurable: true },
    active: { value: active, enumerable: true, configurable: true },
    x: { value: x3, enumerable: true, configurable: true },
    y: { value: y3, enumerable: true, configurable: true },
    dx: { value: dx, enumerable: true, configurable: true },
    dy: { value: dy, enumerable: true, configurable: true },
    _: { value: dispatch }
  });
}
DragEvent.prototype.on = function() {
  var value2 = this._.on.apply(this._, arguments);
  return value2 === this._ ? this : value2;
};

// node_modules/d3-drag/src/drag.js
function defaultFilter(event) {
  return !event.ctrlKey && !event.button;
}
function defaultContainer() {
  return this.parentNode;
}
function defaultSubject(event, d) {
  return d == null ? { x: event.x, y: event.y } : d;
}
function defaultTouchable() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function drag_default() {
  var filter3 = defaultFilter, container = defaultContainer, subject = defaultSubject, touchable = defaultTouchable, gestures = {}, listeners = dispatch_default("start", "drag", "end"), active = 0, mousedownx, mousedowny, mousemoving, touchending, clickDistance2 = 0;
  function drag(selection2) {
    selection2.on("mousedown.drag", mousedowned).filter(touchable).on("touchstart.drag", touchstarted).on("touchmove.drag", touchmoved, nonpassive).on("touchend.drag touchcancel.drag", touchended).style("touch-action", "none").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  function mousedowned(event, d) {
    if (touchending || !filter3.call(this, event, d)) return;
    var gesture = beforestart(this, container.call(this, event, d), event, d, "mouse");
    if (!gesture) return;
    select_default2(event.view).on("mousemove.drag", mousemoved, nonpassivecapture).on("mouseup.drag", mouseupped, nonpassivecapture);
    nodrag_default(event.view);
    nopropagation(event);
    mousemoving = false;
    mousedownx = event.clientX;
    mousedowny = event.clientY;
    gesture("start", event);
  }
  function mousemoved(event) {
    noevent_default(event);
    if (!mousemoving) {
      var dx = event.clientX - mousedownx, dy = event.clientY - mousedowny;
      mousemoving = dx * dx + dy * dy > clickDistance2;
    }
    gestures.mouse("drag", event);
  }
  function mouseupped(event) {
    select_default2(event.view).on("mousemove.drag mouseup.drag", null);
    yesdrag(event.view, mousemoving);
    noevent_default(event);
    gestures.mouse("end", event);
  }
  function touchstarted(event, d) {
    if (!filter3.call(this, event, d)) return;
    var touches = event.changedTouches, c3 = container.call(this, event, d), n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = beforestart(this, c3, event, d, touches[i].identifier, touches[i])) {
        nopropagation(event);
        gesture("start", event, touches[i]);
      }
    }
  }
  function touchmoved(event) {
    var touches = event.changedTouches, n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        noevent_default(event);
        gesture("drag", event, touches[i]);
      }
    }
  }
  function touchended(event) {
    var touches = event.changedTouches, n = touches.length, i, gesture;
    if (touchending) clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, 500);
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        nopropagation(event);
        gesture("end", event, touches[i]);
      }
    }
  }
  function beforestart(that, container2, event, d, identifier, touch) {
    var dispatch = listeners.copy(), p = pointer_default(touch || event, container2), dx, dy, s3;
    if ((s3 = subject.call(that, new DragEvent("beforestart", {
      sourceEvent: event,
      target: drag,
      identifier,
      active,
      x: p[0],
      y: p[1],
      dx: 0,
      dy: 0,
      dispatch
    }), d)) == null) return;
    dx = s3.x - p[0] || 0;
    dy = s3.y - p[1] || 0;
    return function gesture(type2, event2, touch2) {
      var p0 = p, n;
      switch (type2) {
        case "start":
          gestures[identifier] = gesture, n = active++;
          break;
        case "end":
          delete gestures[identifier], --active;
        case "drag":
          p = pointer_default(touch2 || event2, container2), n = active;
          break;
      }
      dispatch.call(
        type2,
        that,
        new DragEvent(type2, {
          sourceEvent: event2,
          subject: s3,
          target: drag,
          identifier,
          active: n,
          x: p[0] + dx,
          y: p[1] + dy,
          dx: p[0] - p0[0],
          dy: p[1] - p0[1],
          dispatch
        }),
        d
      );
    };
  }
  drag.filter = function(_) {
    return arguments.length ? (filter3 = typeof _ === "function" ? _ : constant_default4(!!_), drag) : filter3;
  };
  drag.container = function(_) {
    return arguments.length ? (container = typeof _ === "function" ? _ : constant_default4(_), drag) : container;
  };
  drag.subject = function(_) {
    return arguments.length ? (subject = typeof _ === "function" ? _ : constant_default4(_), drag) : subject;
  };
  drag.touchable = function(_) {
    return arguments.length ? (touchable = typeof _ === "function" ? _ : constant_default4(!!_), drag) : touchable;
  };
  drag.on = function() {
    var value2 = listeners.on.apply(listeners, arguments);
    return value2 === listeners ? drag : value2;
  };
  drag.clickDistance = function(_) {
    return arguments.length ? (clickDistance2 = (_ = +_) * _, drag) : Math.sqrt(clickDistance2);
  };
  return drag;
}

// node_modules/d3-brush/src/constant.js
var constant_default5 = (x3) => () => x3;

// node_modules/d3-brush/src/event.js
function BrushEvent(type2, {
  sourceEvent,
  target,
  selection: selection2,
  mode,
  dispatch
}) {
  Object.defineProperties(this, {
    type: { value: type2, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    selection: { value: selection2, enumerable: true, configurable: true },
    mode: { value: mode, enumerable: true, configurable: true },
    _: { value: dispatch }
  });
}

// node_modules/d3-brush/src/noevent.js
function nopropagation2(event) {
  event.stopImmediatePropagation();
}
function noevent_default2(event) {
  event.preventDefault();
  event.stopImmediatePropagation();
}

// node_modules/d3-brush/src/brush.js
var MODE_DRAG = { name: "drag" };
var MODE_SPACE = { name: "space" };
var MODE_HANDLE = { name: "handle" };
var MODE_CENTER = { name: "center" };
var { abs: abs2, max: max3, min: min3 } = Math;
function number1(e) {
  return [+e[0], +e[1]];
}
function number22(e) {
  return [number1(e[0]), number1(e[1])];
}
var X = {
  name: "x",
  handles: ["w", "e"].map(type),
  input: function(x3, e) {
    return x3 == null ? null : [[+x3[0], e[0][1]], [+x3[1], e[1][1]]];
  },
  output: function(xy) {
    return xy && [xy[0][0], xy[1][0]];
  }
};
var Y = {
  name: "y",
  handles: ["n", "s"].map(type),
  input: function(y3, e) {
    return y3 == null ? null : [[e[0][0], +y3[0]], [e[1][0], +y3[1]]];
  },
  output: function(xy) {
    return xy && [xy[0][1], xy[1][1]];
  }
};
var XY = {
  name: "xy",
  handles: ["n", "w", "e", "s", "nw", "ne", "sw", "se"].map(type),
  input: function(xy) {
    return xy == null ? null : number22(xy);
  },
  output: function(xy) {
    return xy;
  }
};
var cursors = {
  overlay: "crosshair",
  selection: "move",
  n: "ns-resize",
  e: "ew-resize",
  s: "ns-resize",
  w: "ew-resize",
  nw: "nwse-resize",
  ne: "nesw-resize",
  se: "nwse-resize",
  sw: "nesw-resize"
};
var flipX = {
  e: "w",
  w: "e",
  nw: "ne",
  ne: "nw",
  se: "sw",
  sw: "se"
};
var flipY = {
  n: "s",
  s: "n",
  nw: "sw",
  ne: "se",
  se: "ne",
  sw: "nw"
};
var signsX = {
  overlay: 1,
  selection: 1,
  n: null,
  e: 1,
  s: null,
  w: -1,
  nw: -1,
  ne: 1,
  se: 1,
  sw: -1
};
var signsY = {
  overlay: 1,
  selection: 1,
  n: -1,
  e: null,
  s: 1,
  w: null,
  nw: -1,
  ne: -1,
  se: 1,
  sw: 1
};
function type(t) {
  return { type: t };
}
function defaultFilter2(event) {
  return !event.ctrlKey && !event.button;
}
function defaultExtent() {
  var svg = this.ownerSVGElement || this;
  if (svg.hasAttribute("viewBox")) {
    svg = svg.viewBox.baseVal;
    return [[svg.x, svg.y], [svg.x + svg.width, svg.y + svg.height]];
  }
  return [[0, 0], [svg.width.baseVal.value, svg.height.baseVal.value]];
}
function defaultTouchable2() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function local2(node4) {
  while (!node4.__brush) if (!(node4 = node4.parentNode)) return;
  return node4.__brush;
}
function empty2(extent2) {
  return extent2[0][0] === extent2[1][0] || extent2[0][1] === extent2[1][1];
}
function brushX() {
  return brush(X);
}
function brushY() {
  return brush(Y);
}
function brush_default() {
  return brush(XY);
}
function brush(dim2) {
  var extent2 = defaultExtent, filter3 = defaultFilter2, touchable = defaultTouchable2, keys = true, listeners = dispatch_default("start", "brush", "end"), handleSize = 6, touchending;
  function brush5(group3) {
    var overlay = group3.property("__brush", initialize).selectAll(".overlay").data([type("overlay")]);
    overlay.enter().append("rect").attr("class", "overlay").attr("pointer-events", "all").attr("cursor", cursors.overlay).merge(overlay).each(function() {
      var extent3 = local2(this).extent;
      select_default2(this).attr("x", extent3[0][0]).attr("y", extent3[0][1]).attr("width", extent3[1][0] - extent3[0][0]).attr("height", extent3[1][1] - extent3[0][1]);
    });
    group3.selectAll(".selection").data([type("selection")]).enter().append("rect").attr("class", "selection").attr("cursor", cursors.selection).attr("fill", "#777").attr("fill-opacity", 0.3).attr("stroke", "#fff").attr("shape-rendering", "crispEdges");
    var handle = group3.selectAll(".handle").data(dim2.handles, function(d) {
      return d.type;
    });
    handle.exit().remove();
    handle.enter().append("rect").attr("class", function(d) {
      return "handle handle--" + d.type;
    }).attr("cursor", function(d) {
      return cursors[d.type];
    });
    group3.each(redraw).attr("fill", "none").attr("pointer-events", "all").on("mousedown.brush", started).filter(touchable).on("touchstart.brush", started).on("touchmove.brush", touchmoved).on("touchend.brush touchcancel.brush", touchended).style("touch-action", "none").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  brush5.move = function(group3, selection2, event) {
    if (group3.tween) {
      group3.on("start.brush", function(event2) {
        emitter(this, arguments).beforestart().start(event2);
      }).on("interrupt.brush end.brush", function(event2) {
        emitter(this, arguments).end(event2);
      }).tween("brush", function() {
        var that = this, state = that.__brush, emit = emitter(that, arguments), selection0 = state.selection, selection1 = dim2.input(typeof selection2 === "function" ? selection2.apply(this, arguments) : selection2, state.extent), i = value_default(selection0, selection1);
        function tween(t) {
          state.selection = t === 1 && selection1 === null ? null : i(t);
          redraw.call(that);
          emit.brush();
        }
        return selection0 !== null && selection1 !== null ? tween : tween(1);
      });
    } else {
      group3.each(function() {
        var that = this, args = arguments, state = that.__brush, selection1 = dim2.input(typeof selection2 === "function" ? selection2.apply(that, args) : selection2, state.extent), emit = emitter(that, args).beforestart();
        interrupt_default(that);
        state.selection = selection1 === null ? null : selection1;
        redraw.call(that);
        emit.start(event).brush(event).end(event);
      });
    }
  };
  brush5.clear = function(group3, event) {
    brush5.move(group3, null, event);
  };
  function redraw() {
    var group3 = select_default2(this), selection2 = local2(this).selection;
    if (selection2) {
      group3.selectAll(".selection").style("display", null).attr("x", selection2[0][0]).attr("y", selection2[0][1]).attr("width", selection2[1][0] - selection2[0][0]).attr("height", selection2[1][1] - selection2[0][1]);
      group3.selectAll(".handle").style("display", null).attr("x", function(d) {
        return d.type[d.type.length - 1] === "e" ? selection2[1][0] - handleSize / 2 : selection2[0][0] - handleSize / 2;
      }).attr("y", function(d) {
        return d.type[0] === "s" ? selection2[1][1] - handleSize / 2 : selection2[0][1] - handleSize / 2;
      }).attr("width", function(d) {
        return d.type === "n" || d.type === "s" ? selection2[1][0] - selection2[0][0] + handleSize : handleSize;
      }).attr("height", function(d) {
        return d.type === "e" || d.type === "w" ? selection2[1][1] - selection2[0][1] + handleSize : handleSize;
      });
    } else {
      group3.selectAll(".selection,.handle").style("display", "none").attr("x", null).attr("y", null).attr("width", null).attr("height", null);
    }
  }
  function emitter(that, args, clean2) {
    var emit = that.__brush.emitter;
    return emit && (!clean2 || !emit.clean) ? emit : new Emitter(that, args, clean2);
  }
  function Emitter(that, args, clean2) {
    this.that = that;
    this.args = args;
    this.state = that.__brush;
    this.active = 0;
    this.clean = clean2;
  }
  Emitter.prototype = {
    beforestart: function() {
      if (++this.active === 1) this.state.emitter = this, this.starting = true;
      return this;
    },
    start: function(event, mode) {
      if (this.starting) this.starting = false, this.emit("start", event, mode);
      else this.emit("brush", event);
      return this;
    },
    brush: function(event, mode) {
      this.emit("brush", event, mode);
      return this;
    },
    end: function(event, mode) {
      if (--this.active === 0) delete this.state.emitter, this.emit("end", event, mode);
      return this;
    },
    emit: function(type2, event, mode) {
      var d = select_default2(this.that).datum();
      listeners.call(
        type2,
        this.that,
        new BrushEvent(type2, {
          sourceEvent: event,
          target: brush5,
          selection: dim2.output(this.state.selection),
          mode,
          dispatch: listeners
        }),
        d
      );
    }
  };
  function started(event) {
    if (touchending && !event.touches) return;
    if (!filter3.apply(this, arguments)) return;
    var that = this, type2 = event.target.__data__.type, mode = (keys && event.metaKey ? type2 = "overlay" : type2) === "selection" ? MODE_DRAG : keys && event.altKey ? MODE_CENTER : MODE_HANDLE, signX = dim2 === Y ? null : signsX[type2], signY = dim2 === X ? null : signsY[type2], state = local2(that), extent3 = state.extent, selection2 = state.selection, W = extent3[0][0], w0, w1, N = extent3[0][1], n0, n1, E2 = extent3[1][0], e0, e1, S = extent3[1][1], s0, s1, dx = 0, dy = 0, moving, shifting = signX && signY && keys && event.shiftKey, lockX, lockY, points3 = Array.from(event.touches || [event], (t) => {
      const i = t.identifier;
      t = pointer_default(t, that);
      t.point0 = t.slice();
      t.identifier = i;
      return t;
    });
    interrupt_default(that);
    var emit = emitter(that, arguments, true).beforestart();
    if (type2 === "overlay") {
      if (selection2) moving = true;
      const pts = [points3[0], points3[1] || points3[0]];
      state.selection = selection2 = [[
        w0 = dim2 === Y ? W : min3(pts[0][0], pts[1][0]),
        n0 = dim2 === X ? N : min3(pts[0][1], pts[1][1])
      ], [
        e0 = dim2 === Y ? E2 : max3(pts[0][0], pts[1][0]),
        s0 = dim2 === X ? S : max3(pts[0][1], pts[1][1])
      ]];
      if (points3.length > 1) move(event);
    } else {
      w0 = selection2[0][0];
      n0 = selection2[0][1];
      e0 = selection2[1][0];
      s0 = selection2[1][1];
    }
    w1 = w0;
    n1 = n0;
    e1 = e0;
    s1 = s0;
    var group3 = select_default2(that).attr("pointer-events", "none");
    var overlay = group3.selectAll(".overlay").attr("cursor", cursors[type2]);
    if (event.touches) {
      emit.moved = moved;
      emit.ended = ended;
    } else {
      var view = select_default2(event.view).on("mousemove.brush", moved, true).on("mouseup.brush", ended, true);
      if (keys) view.on("keydown.brush", keydowned, true).on("keyup.brush", keyupped, true);
      nodrag_default(event.view);
    }
    redraw.call(that);
    emit.start(event, mode.name);
    function moved(event2) {
      for (const p of event2.changedTouches || [event2]) {
        for (const d of points3)
          if (d.identifier === p.identifier) d.cur = pointer_default(p, that);
      }
      if (shifting && !lockX && !lockY && points3.length === 1) {
        const point13 = points3[0];
        if (abs2(point13.cur[0] - point13[0]) > abs2(point13.cur[1] - point13[1]))
          lockY = true;
        else
          lockX = true;
      }
      for (const point13 of points3)
        if (point13.cur) point13[0] = point13.cur[0], point13[1] = point13.cur[1];
      moving = true;
      noevent_default2(event2);
      move(event2);
    }
    function move(event2) {
      const point13 = points3[0], point0 = point13.point0;
      var t;
      dx = point13[0] - point0[0];
      dy = point13[1] - point0[1];
      switch (mode) {
        case MODE_SPACE:
        case MODE_DRAG: {
          if (signX) dx = max3(W - w0, min3(E2 - e0, dx)), w1 = w0 + dx, e1 = e0 + dx;
          if (signY) dy = max3(N - n0, min3(S - s0, dy)), n1 = n0 + dy, s1 = s0 + dy;
          break;
        }
        case MODE_HANDLE: {
          if (points3[1]) {
            if (signX) w1 = max3(W, min3(E2, points3[0][0])), e1 = max3(W, min3(E2, points3[1][0])), signX = 1;
            if (signY) n1 = max3(N, min3(S, points3[0][1])), s1 = max3(N, min3(S, points3[1][1])), signY = 1;
          } else {
            if (signX < 0) dx = max3(W - w0, min3(E2 - w0, dx)), w1 = w0 + dx, e1 = e0;
            else if (signX > 0) dx = max3(W - e0, min3(E2 - e0, dx)), w1 = w0, e1 = e0 + dx;
            if (signY < 0) dy = max3(N - n0, min3(S - n0, dy)), n1 = n0 + dy, s1 = s0;
            else if (signY > 0) dy = max3(N - s0, min3(S - s0, dy)), n1 = n0, s1 = s0 + dy;
          }
          break;
        }
        case MODE_CENTER: {
          if (signX) w1 = max3(W, min3(E2, w0 - dx * signX)), e1 = max3(W, min3(E2, e0 + dx * signX));
          if (signY) n1 = max3(N, min3(S, n0 - dy * signY)), s1 = max3(N, min3(S, s0 + dy * signY));
          break;
        }
      }
      if (e1 < w1) {
        signX *= -1;
        t = w0, w0 = e0, e0 = t;
        t = w1, w1 = e1, e1 = t;
        if (type2 in flipX) overlay.attr("cursor", cursors[type2 = flipX[type2]]);
      }
      if (s1 < n1) {
        signY *= -1;
        t = n0, n0 = s0, s0 = t;
        t = n1, n1 = s1, s1 = t;
        if (type2 in flipY) overlay.attr("cursor", cursors[type2 = flipY[type2]]);
      }
      if (state.selection) selection2 = state.selection;
      if (lockX) w1 = selection2[0][0], e1 = selection2[1][0];
      if (lockY) n1 = selection2[0][1], s1 = selection2[1][1];
      if (selection2[0][0] !== w1 || selection2[0][1] !== n1 || selection2[1][0] !== e1 || selection2[1][1] !== s1) {
        state.selection = [[w1, n1], [e1, s1]];
        redraw.call(that);
        emit.brush(event2, mode.name);
      }
    }
    function ended(event2) {
      nopropagation2(event2);
      if (event2.touches) {
        if (event2.touches.length) return;
        if (touchending) clearTimeout(touchending);
        touchending = setTimeout(function() {
          touchending = null;
        }, 500);
      } else {
        yesdrag(event2.view, moving);
        view.on("keydown.brush keyup.brush mousemove.brush mouseup.brush", null);
      }
      group3.attr("pointer-events", "all");
      overlay.attr("cursor", cursors.overlay);
      if (state.selection) selection2 = state.selection;
      if (empty2(selection2)) state.selection = null, redraw.call(that);
      emit.end(event2, mode.name);
    }
    function keydowned(event2) {
      switch (event2.keyCode) {
        case 16: {
          shifting = signX && signY;
          break;
        }
        case 18: {
          if (mode === MODE_HANDLE) {
            if (signX) e0 = e1 - dx * signX, w0 = w1 + dx * signX;
            if (signY) s0 = s1 - dy * signY, n0 = n1 + dy * signY;
            mode = MODE_CENTER;
            move(event2);
          }
          break;
        }
        case 32: {
          if (mode === MODE_HANDLE || mode === MODE_CENTER) {
            if (signX < 0) e0 = e1 - dx;
            else if (signX > 0) w0 = w1 - dx;
            if (signY < 0) s0 = s1 - dy;
            else if (signY > 0) n0 = n1 - dy;
            mode = MODE_SPACE;
            overlay.attr("cursor", cursors.selection);
            move(event2);
          }
          break;
        }
        default:
          return;
      }
      noevent_default2(event2);
    }
    function keyupped(event2) {
      switch (event2.keyCode) {
        case 16: {
          if (shifting) {
            lockX = lockY = shifting = false;
            move(event2);
          }
          break;
        }
        case 18: {
          if (mode === MODE_CENTER) {
            if (signX < 0) e0 = e1;
            else if (signX > 0) w0 = w1;
            if (signY < 0) s0 = s1;
            else if (signY > 0) n0 = n1;
            mode = MODE_HANDLE;
            move(event2);
          }
          break;
        }
        case 32: {
          if (mode === MODE_SPACE) {
            if (event2.altKey) {
              if (signX) e0 = e1 - dx * signX, w0 = w1 + dx * signX;
              if (signY) s0 = s1 - dy * signY, n0 = n1 + dy * signY;
              mode = MODE_CENTER;
            } else {
              if (signX < 0) e0 = e1;
              else if (signX > 0) w0 = w1;
              if (signY < 0) s0 = s1;
              else if (signY > 0) n0 = n1;
              mode = MODE_HANDLE;
            }
            overlay.attr("cursor", cursors[type2]);
            move(event2);
          }
          break;
        }
        default:
          return;
      }
      noevent_default2(event2);
    }
  }
  function touchmoved(event) {
    emitter(this, arguments).moved(event);
  }
  function touchended(event) {
    emitter(this, arguments).ended(event);
  }
  function initialize() {
    var state = this.__brush || { selection: null };
    state.extent = number22(extent2.apply(this, arguments));
    state.dim = dim2;
    return state;
  }
  brush5.extent = function(_) {
    return arguments.length ? (extent2 = typeof _ === "function" ? _ : constant_default5(number22(_)), brush5) : extent2;
  };
  brush5.filter = function(_) {
    return arguments.length ? (filter3 = typeof _ === "function" ? _ : constant_default5(!!_), brush5) : filter3;
  };
  brush5.touchable = function(_) {
    return arguments.length ? (touchable = typeof _ === "function" ? _ : constant_default5(!!_), brush5) : touchable;
  };
  brush5.handleSize = function(_) {
    return arguments.length ? (handleSize = +_, brush5) : handleSize;
  };
  brush5.keyModifiers = function(_) {
    return arguments.length ? (keys = !!_, brush5) : keys;
  };
  brush5.on = function() {
    var value2 = listeners.on.apply(listeners, arguments);
    return value2 === listeners ? brush5 : value2;
  };
  return brush5;
}

// node_modules/@unovis/ts/components/brush/config.js
var BrushDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), {
  /* eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function */
  onBrush: (s3, e, userDriven) => {
  },
  /* eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function */
  onBrushStart: (s3, e, userDriven) => {
  },
  /* eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function */
  onBrushMove: (s3, e, userDriven) => {
  },
  /* eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-empty-function */
  onBrushEnd: (s3, e, userDriven) => {
  },
  handleWidth: 9,
  selection: null,
  draggable: false,
  handlePosition: Arrangement.Inside,
  selectionMinLength: void 0
});

// node_modules/@unovis/ts/components/brush/types.js
var BrushDirection;
(function(BrushDirection2) {
  BrushDirection2["West"] = "w";
  BrushDirection2["East"] = "e";
})(BrushDirection || (BrushDirection = {}));

// node_modules/@unovis/ts/components/brush/style.js
var style_exports7 = {};
__export(style_exports7, {
  brush: () => brush2,
  cssVarDefaults: () => cssVarDefaults,
  handleLine: () => handleLine,
  root: () => root8,
  unselected: () => unselected,
  variables: () => variables3
});

// node_modules/@unovis/ts/utils/style.js
function getCssVarNames(cssVarsObject, prefix) {
  const defaultPrefix = "--vis-";
  const entries = Object.entries(cssVarsObject);
  return Object.fromEntries(entries.map(([key]) => [kebabCaseToCamel(key.replace(prefix !== null && prefix !== void 0 ? prefix : defaultPrefix, "")), key]));
}
function injectGlobalCssVariables(cssVarsObject, componentRootClassName) {
  injectGlobal({
    ":root": cssVarsObject,
    [`body.theme-dark .${componentRootClassName}`]: Object.keys(cssVarsObject).filter((key) => key.includes("--vis-dark")).map((key) => ({
      [key.replace("--vis-dark", "--vis")]: `var(${key})`
    }))
  });
}
function cssvar(name2) {
  return `var(${name2})`;
}

// node_modules/@unovis/ts/components/brush/style.js
var root8 = css`
  label: brush-component;
`;
var cssVarDefaults = {
  "--vis-brush-selection-fill-color": "none",
  "--vis-brush-selection-stroke-color": "none",
  "--vis-brush-selection-stroke-width": "0",
  "--vis-brush-selection-opacity": "0",
  "--vis-brush-unselected-fill-color": "#0b1640",
  "--vis-brush-unselected-stroke-color": "#acb2b9",
  "--vis-brush-unselected-stroke-width": "0",
  "--vis-brush-unselected-opacity": "0.4",
  "--vis-brush-handle-fill-color": "#6d778c",
  "--vis-brush-handle-stroke-color": "#eee",
  /* Dark Theme */
  "--vis-dark-brush-selection-fill-color": "none",
  "--vis-dark-brush-selection-stroke-color": "none",
  "--vis-dark-brush-selection-stroke-width": "0",
  "--vis-dark-brush-selection-opacity": "0",
  "--vis-dark-brush-unselected-fill-color": "#acb2b9",
  "--vis-dark-brush-unselected-stroke-color": "#0b1640",
  "--vis-dark-brush-unselected-stroke-width": "0",
  "--vis-dark-brush-unselected-opacity": "0.4",
  "--vis-dark-brush-handle-fill-color": "#acb2b9",
  "--vis-dark-brush-handle-stroke-color": "var(--vis-color-grey)"
};
var variables3 = getCssVarNames(cssVarDefaults);
injectGlobalCssVariables(cssVarDefaults, root8);
var brush2 = css`
  label: brush;

  .selection {
    fill: var(${variables3.brushSelectionFillColor});
    stroke: var(${variables3.brushSelectionStrokeColor});
    stroke-width: var(${variables3.brushSelectionStrokeWidth});
    opacity: var(${variables3.brushSelectionOpacity});
  }

  .handle {
    fill: var(${variables3.brushHandleFillColor});
  }

  &.non-draggable {
    .selection, .overlay {
      pointer-events: none;
    }
  }
`;
var unselected = css`
  label: unselected;
  fill: var(${variables3.brushUnselectedFillColor});
  stroke: var(${variables3.brushUnselectedStrokeColor});
  stroke-width: var(${variables3.brushUnselectedStrokeWidth});
  stroke-opacity: var(${variables3.brushUnselectedOpacity});
  opacity: var(${variables3.brushUnselectedOpacity});
  pointer-events: none;
`;
var handleLine = css`
  label: handle-line;
  stroke: var(${variables3.brushHandleStrokeColor});
  stroke-width: 1;
  fill: none;
  pointer-events: none;
`;

// node_modules/@unovis/ts/components/brush/index.js
var Brush = class _Brush extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = BrushDefaultConfig;
    this.clippable = false;
    this.config = this._defaultConfig;
    this.brushBehaviour = brushX();
    this.events = {
      [_Brush.selectors.brush]: {}
    };
    this._selection = null;
    this._firstRender = true;
    if (config)
      this.setConfig(config);
    const directions = [{ type: BrushDirection.West }, { type: BrushDirection.East }];
    this.unselectedRange = this.g.selectAll(`.${unselected}`).data(directions).enter().append("rect").attr("class", unselected);
    this.brush = this.g.append("g").attr("class", brush2);
    this.handleLines = this.g.selectAll(`.${handleLine}`).data(directions).enter().append("line").attr("class", handleLine);
  }
  _render(customDuration) {
    var _a, _b, _c, _d;
    const { brushBehaviour, config } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const xScale = this.xScale;
    brushBehaviour.extent([[0, 0], [this._width, this._height]]).on("start", this._onBrushStart.bind(this)).on("brush", this._onBrushMove.bind(this)).on("end", this._onBrushEnd.bind(this));
    this.brush.call(brushBehaviour).classed("non-draggable", !config.draggable);
    const yRange = [this._height, 0];
    const h = yRange[0] - yRange[1];
    this.g.selectAll(".handle").attr("y", yRange[1]).attr("height", h);
    this.unselectedRange.attr("y", yRange[1]).attr("height", h);
    this.handleLines.attr("y1", yRange[1] + 10).attr("y2", yRange[1] + h - 10);
    const xRange = [0, this._width];
    const xScaleRange = xScale.range();
    xScale.range(xRange);
    const selectionMin = clamp((_b = xScale((_a = config.selection || this._selection) === null || _a === void 0 ? void 0 : _a[0])) !== null && _b !== void 0 ? _b : 0, xRange[0], xRange[1]);
    const selectionMax = clamp((_d = xScale((_c = config.selection || this._selection) === null || _c === void 0 ? void 0 : _c[1])) !== null && _d !== void 0 ? _d : 0, xRange[0], xRange[1]);
    xScale.range(xScaleRange);
    const selectionLength = selectionMax - selectionMin;
    const brushRange = selectionLength ? [selectionMin, selectionMax] : xRange;
    this._positionHandles(brushRange);
    smartTransition(this.brush, duration).call(brushBehaviour.move, brushRange).on("end interrupt", () => {
      this._firstRender = false;
    });
    if (!duration)
      this._firstRender = false;
  }
  _updateSelection(s3) {
    const xRange = [0, this._width];
    this.unselectedRange.attr("x", (d) => d.type === BrushDirection.West ? xRange[0] : s3[1]).attr("width", (d) => {
      const length = d.type === BrushDirection.West ? s3[0] - xRange[0] : xRange[1] - s3[1];
      const lengthClamped = clamp(length, 0, xRange[1] - xRange[0]);
      return lengthClamped;
    });
    this._positionHandles(s3);
    const yRange = [this._height, 0];
    const h = yRange[0] - yRange[1];
    this.g.selectAll(".handle").attr("y", yRange[1]).attr("height", h);
  }
  _positionHandles(s3) {
    const { config } = this;
    this.brush.selectAll(".handle").attr("width", config.handleWidth).attr("x", (d) => {
      if (!s3)
        return 0;
      const west = d.type === BrushDirection.West;
      const inside = config.handlePosition === Arrangement.Inside;
      if (west)
        return s3[0] + (inside ? 0 : -config.handleWidth);
      else
        return s3[1] + (inside ? -config.handleWidth : 0);
    });
    this.handleLines.attr("transform", (d) => {
      if (!s3)
        return null;
      const west = d.type === BrushDirection.West;
      const inside = config.handlePosition === Arrangement.Inside;
      return `translate(${west ? s3[0] - Math.pow(-1, Number(inside)) * config.handleWidth / 2 : s3[1] + Math.pow(-1, Number(inside)) * config.handleWidth / 2},0)`;
    });
  }
  _onBrush(event) {
    var _a;
    const { config } = this;
    const xScale = this.xScale;
    const xRange = [0, this._width];
    const s3 = (event === null || event === void 0 ? void 0 : event.selection) || xRange;
    const userDriven = !!(event === null || event === void 0 ? void 0 : event.sourceEvent);
    if (userDriven && ((event === null || event === void 0 ? void 0 : event.selection) === null || // happens when user clicks to reset the selection
    (s3 === null || s3 === void 0 ? void 0 : s3[0]) === (s3 === null || s3 === void 0 ? void 0 : s3[1]) || // happens when user drags the selection out of range
    (s3 === null || s3 === void 0 ? void 0 : s3[0]) < xRange[0] || //
    (s3 === null || s3 === void 0 ? void 0 : s3[0]) > xRange[1] || // happens when you drag the brush and the domain updates
    (s3 === null || s3 === void 0 ? void 0 : s3[1]) < xRange[0] || // to a smaller one and brush goes out of range
    (s3 === null || s3 === void 0 ? void 0 : s3[1]) > xRange[1])) {
      this.brush.call(this.brushBehaviour.move, xRange);
      return;
    }
    if (s3[0] !== s3[1] && isNumber(s3[0]) && isNumber(s3[1])) {
      const xScaleRange = xScale.range();
      xScale.range(xRange);
      const selectedDomain = s3.map((n) => +xScale.invert(n));
      if (userDriven) {
        const xDomain = xScale.domain();
        const xDomainLength = Math.abs(xDomain[1] - xDomain[0]);
        const selectionLength = Math.abs(selectedDomain[1] - selectedDomain[0]);
        if (config.selectionMinLength >= xDomainLength) {
          console.warn("Unovis | Brush: Configured `selectionMinLength` is bigger than the brush domain");
        }
        if (selectionLength < config.selectionMinLength && config.selectionMinLength < xDomainLength) {
          const selection2 = (_a = config.selection) !== null && _a !== void 0 ? _a : this._selection;
          const range3 = [xScale(selection2[0]), xScale(selection2[1])];
          this.brush.call(this.brushBehaviour.move, range3);
          xScale.range(xScaleRange);
          return;
        } else {
          this._selection = selectedDomain;
          xScale.range(xScaleRange);
        }
      }
      this._updateSelection(s3);
      if (!this._firstRender)
        config.onBrush(selectedDomain, event, userDriven);
    }
  }
  _onBrushStart(event) {
    const { config } = this;
    this._onBrush(event);
    if (!this._firstRender)
      config.onBrushStart(this._selection, event, !!(event === null || event === void 0 ? void 0 : event.sourceEvent));
  }
  _onBrushMove(event) {
    const { config } = this;
    this._onBrush(event);
    if (!this._firstRender)
      config.onBrushMove(this._selection, event, !!(event === null || event === void 0 ? void 0 : event.sourceEvent));
  }
  _onBrushEnd(event) {
    const { config } = this;
    this._onBrush(event);
    if (!this._firstRender)
      config.onBrushEnd(this._selection, event, !!(event === null || event === void 0 ? void 0 : event.sourceEvent));
  }
};
Brush.selectors = style_exports7;

// node_modules/@unovis/ts/components/bullet-legend/types.js
var BulletShape = Object.assign(Object.assign({}, SymbolType), { Line: "line" });
var BulletLegendOrientation;
(function(BulletLegendOrientation2) {
  BulletLegendOrientation2["Horizontal"] = "horizontal";
  BulletLegendOrientation2["Vertical"] = "vertical";
})(BulletLegendOrientation || (BulletLegendOrientation = {}));

// node_modules/@unovis/ts/components/bullet-legend/config.js
var BulletLegendDefaultConfig = {
  items: [],
  labelClassName: "",
  onLegendItemClick: void 0,
  labelFontSize: null,
  labelMaxWidth: null,
  bulletSize: null,
  bulletShape: (d) => {
    var _a;
    return (_a = d.shape) !== null && _a !== void 0 ? _a : BulletShape.Circle;
  },
  orientation: BulletLegendOrientation.Horizontal,
  renderIntoProvidedDomNode: false
};

// node_modules/@unovis/ts/components/bullet-legend/modules/shape.js
var BULLET_SIZE = PATTERN_SIZE_PX * 3;
var shapeScale = {
  [BulletShape.Circle]: Math.PI / 4,
  [BulletShape.Cross]: 5 / 9,
  [BulletShape.Diamond]: Math.sqrt(3) / 6,
  [BulletShape.Square]: 1,
  [BulletShape.Star]: 0.3,
  [BulletShape.Triangle]: Math.sqrt(3) / 4,
  [BulletShape.Wye]: 5 / 11
};
function createBullets(container) {
  container.each((d, i, els) => {
    select_default2(els[i]).append("svg").attr("width", "100%").attr("height", "100%").append("path");
  });
}
function updateBullets(container, config, colorAccessor) {
  container.each((d, i, els) => {
    const shape = getString(d, config.bulletShape, i);
    const color2 = getColor(d, colorAccessor, i);
    const width = BULLET_SIZE;
    const height = shape === BulletShape.Line ? BULLET_SIZE / 2.5 : BULLET_SIZE;
    const selection2 = select_default2(els[i]).select("svg").attr("viewBox", `0 0 ${width} ${height}`);
    const bulletPath = selection2.select("path").attr("stroke", color2);
    const opacity = d.inactive ? "var(--vis-legend-bullet-inactive-opacity)" : 1;
    if (shape === BulletShape.Line) {
      bulletPath.attr("d", `M0,${height / 2} L${width / 2},${height / 2} L${width},${height / 2}`).attr("transform", null).style("opacity", opacity).style("stroke-width", "3px").style("fill", null).style("fill-opacity", null).style("marker-start", "none").style("marker-end", "none");
    } else {
      const symbolGen = Symbol2().type(Symbol3[shape]).size(width * height * shapeScale[shape]);
      const scale = (width - 2) / width;
      let dy = height / 2;
      switch (shape) {
        case BulletShape.Triangle:
          dy += height / 8;
          break;
        case BulletShape.Star:
          dy += height / 16;
          break;
        case BulletShape.Wye:
          dy -= height / 16;
          break;
      }
      bulletPath.attr("d", symbolGen).attr("transform", `translate(${width / 2}, ${Math.round(dy)}) scale(${scale})`).style("stroke-width", "1px").style("opacity", null).style("fill", color2).style("fill-opacity", opacity);
    }
  });
}

// node_modules/@unovis/ts/components/bullet-legend/style.js
var style_exports8 = {};
__export(style_exports8, {
  bullet: () => bullet,
  clickable: () => clickable,
  item: () => item,
  itemVertical: () => itemVertical,
  label: () => label2,
  root: () => root9,
  variables: () => variables4
});
var root9 = css`
  label: bullet-legend-component;
`;
var variables4 = injectGlobal`
  :root {
    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-legend-font-family: */

    --vis-legend-label-color: #6c778c;
    --vis-legend-label-max-width: 300px;
    --vis-legend-label-font-size: 12px;
    --vis-legend-bullet-size: 9px;
    --vis-legend-bullet-inactive-opacity: 0.15;
    --vis-legend-item-spacing: 20px;
    --vis-legend-vertical-item-spacing: 5px;
    --vis-legend-bullet-label-spacing: 8px;

    --vis-dark-legend-label-color: #eee;
  }

  body.theme-dark ${`.${root9}`} {
    --vis-legend-label-color: var(--vis-dark-legend-label-color);
  }

  body.theme-patterns {
    --vis-legend-bullet-size: 14px;
  }
`;
var item = css`
  label: legendItem;
  display: inline-flex;
  align-items: center;
  font-family: var(--vis-legend-font-family, var(--vis-font-family));
  margin-right: var(--vis-legend-item-spacing);
  white-space: nowrap;
  cursor: default;
  user-select: none;
  max-width: min-content;
`;
var itemVertical = css`
  label: legendItemVertical;
  display: flex;
  margin-top: var(--vis-legend-vertical-item-spacing);
`;
var clickable = css`
  cursor: pointer;
`;
var label2 = css`
  label: legendItemLabel;
  font-size: var(--vis-legend-label-font-size);
  display: inline-block;
  vertical-align: middle;
  color: var(--vis-legend-label-color);
  max-width: var(--vis-legend-label-max-width);
  text-overflow: ellipsis;
  overflow: hidden;
  white-space: nowrap;
`;
var bullet = css`
  flex: 0 0 auto;
  label: legendItemBullet;
  margin-right: var(--vis-legend-bullet-label-spacing);
  height: var(--vis-legend-bullet-size);
  width: var(--vis-legend-bullet-size);

  svg {
    display: block;
  }
`;

// node_modules/@unovis/ts/components/bullet-legend/index.js
var BulletLegend = class {
  constructor(element, config) {
    this._defaultConfig = BulletLegendDefaultConfig;
    this.config = this._defaultConfig;
    this._colorAccessor = (d) => d.color;
    this._container = element;
    this.div = (config === null || config === void 0 ? void 0 : config.renderIntoProvidedDomNode) ? select_default2(this._container) : select_default2(this._container).append("div");
    this.div.classed(root9, true);
    this.element = this.div.node();
    if (config)
      this.update(config);
  }
  update(config) {
    this.prevConfig = this.config;
    this.config = merge2(this._defaultConfig, config);
    this.render();
  }
  render() {
    const { config } = this;
    const legendItems = this.div.selectAll(`.${item}`).data(config.items);
    const legendItemsEnter = legendItems.enter().append("div").on("click", this._onItemClick.bind(this));
    const legendItemsMerged = legendItemsEnter.merge(legendItems);
    legendItemsMerged.attr("class", (d) => {
      var _a;
      return `${item} ${(_a = d.className) !== null && _a !== void 0 ? _a : ""}`;
    }).classed(itemVertical, config.orientation === BulletLegendOrientation.Vertical).classed(clickable, (d) => !!config.onLegendItemClick && this._isItemClickable(d)).attr("title", (d) => d.name).style("display", (d) => d.hidden ? "none" : null);
    legendItemsEnter.append("span").attr("class", bullet).call(createBullets);
    legendItemsMerged.select(`.${bullet}`).style("width", config.bulletSize).style("height", config.bulletSize).style("box-sizing", "content-box").call(updateBullets, this.config, this._colorAccessor);
    legendItemsEnter.append("span").attr("class", label2).classed(config.labelClassName, true).style("max-width", config.labelMaxWidth).style("font-size", config.labelFontSize);
    legendItemsMerged.select(`.${label2}`).text((d) => d.name);
    legendItems.exit().remove();
  }
  _isItemClickable(item4) {
    return item4.pointer === void 0 ? true : item4.pointer;
  }
  _onItemClick(event, d) {
    const { config: { onLegendItemClick } } = this;
    const legendItems = this.div.selectAll(`.${item}`).nodes();
    const index3 = legendItems.indexOf(event.currentTarget);
    if (onLegendItemClick)
      onLegendItemClick(d, index3);
  }
  destroy() {
    if (this.element !== this._container)
      this.div.remove();
  }
};
BulletLegend.selectors = style_exports8;

// node_modules/@unovis/ts/components/flow-legend/config.js
var FlowLegendDefaultConfig = {
  customWidth: void 0,
  items: [],
  labelFontSize: 12,
  lineColor: void 0,
  labelColor: void 0,
  arrowSymbol: "▶",
  arrowColor: void 0,
  onLegendItemClick: void 0
};

// node_modules/@unovis/ts/components/flow-legend/types.js
var FlowLegendItemType;
(function(FlowLegendItemType2) {
  FlowLegendItemType2["Label"] = "label";
  FlowLegendItemType2["Symbol"] = "symbol";
})(FlowLegendItemType || (FlowLegendItemType = {}));

// node_modules/@unovis/ts/components/flow-legend/style.js
var root10 = css`
  label: flow-legend-component;

  position: relative;
  user-select: none;
`;
var globalStyles6 = injectGlobal`
  :root {
    --vis-flow-legend-label-background: #ffffff;
    --vis-flow-legend-label-color: #71788a;
    --vis-flow-legend-link-color: #E5E9F7;
    --vis-flow-legend-arrow-color: #E5E9F7;
    --vis-flow-legend-label-padding: 5px 15px;
    --vis-flow-legend-arrow-padding: 0 10px;
    /* --vis-flow-legend-arrow-font-family: Undefined by default to allow proper fallback to var(DEFAULT_ICON_FONT_FAMILY)*/

    --vis-dark-flow-legend-label-background: #292b34;
    --vis-dark-flow-legend-label-color: #E5E9F7;
    --vis-dark-flow-legend-link-color: #71788a;
    --vis-dark-flow-legend-arrow-color: #71788a;
  }

  body.theme-dark ${`.${root10}`} {
    --vis-flow-legend-label-background: var(--vis-dark-flow-legend-label-background);
    --vis-flow-legend-label-color: var(--vis-dark-flow-legend-label-color);
    --vis-flow-legend-link-color: var(--vis-dark-flow-legend-link-color);
    --vis-flow-legend-arrow-color: var(--vis-dark-flow-legend-arrow-color);
  }
`;
var line2 = (lineColor) => css`
  label: line;

  height: 2px;
  width: 100%;
  background-color: ${lineColor || "var(--vis-flow-legend-link-color)"};
  position: absolute;
  top: 50%;
`;
var labels = css`
  label: labels;

  position: relative;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
`;
var item2 = css`
  label: item;

  position: relative;
  max-width: 50px;

  padding: 10px;
`;
var clickable2 = css`
  cursor: pointer;

  &:hover {
    text-decoration: underline;
  }
`;
var label3 = (labelFontSize, labelColor) => css`
  label: label;

  transform: translate(-50%, 0%);
  margin-left: 7px;
  background-color: var(--vis-flow-legend-label-background);
  padding: var(--vis-flow-legend-label-padding);
  font-size: ${labelFontSize}px;
  color: ${labelColor || "var(--vis-flow-legend-label-color)"};
  display: inline-table;
  text-align: center;
`;
var arrow = (arrowColor) => css`
  label: arrow;

  font-family: var(--vis-flow-legend-arrow-font-family, ${UNOVIS_ICON_FONT_FAMILY_DEFAULT});
  font-size: 9px;
  vertical-align: middle;
  color: ${arrowColor || "var(--vis-flow-legend-arrow-color)"};
  background-color: var(--vis-flow-legend-label-background);
  padding: var(--vis-flow-legend-arrow-padding);
  transform: translate(-25%, 0%);
  display: inline-table;
  text-align: center;
`;

// node_modules/@unovis/ts/components/flow-legend/index.js
var FlowLegend = class {
  constructor(element, config) {
    this._defaultConfig = FlowLegendDefaultConfig;
    this.config = this._defaultConfig;
    this._container = element;
    this.div = select_default2(this._container).append("div").attr("class", root10);
    this.element = this.div.node();
    this.line = this.div.append("div");
    this.labels = this.div.append("div").attr("class", labels);
    if (config)
      this.update(config);
  }
  update(config) {
    this.prevConfig = this.config;
    this.config = merge2(this._defaultConfig, config);
    this.render();
  }
  render() {
    const { config } = this;
    if (!config.items.length)
      return;
    if (config.customWidth)
      this.div.style("width", `${config.customWidth}px`);
    const legendData = config.items.reduce((acc, label10, i) => {
      acc.push({
        text: label10,
        index: i,
        type: FlowLegendItemType.Label
      });
      if (config.arrowSymbol && acc.length !== config.items.length * 2 - 1) {
        acc.push({
          text: config.arrowSymbol,
          index: i,
          type: FlowLegendItemType.Symbol
        });
      }
      return acc;
    }, []);
    const legendItems = this.labels.selectAll(`.${item2}`).data(legendData);
    const legendItemsEnter = legendItems.enter().append("div").attr("class", item2).attr("opacity", 0);
    legendItemsEnter.filter((d) => d.type === FlowLegendItemType.Label).on("click", this._onItemClick.bind(this));
    legendItemsEnter.append("span").attr("class", (d) => d.type === FlowLegendItemType.Symbol ? arrow(config.arrowColor) : label3(config.labelFontSize, config.labelColor)).classed(clickable2, (d) => d.type === FlowLegendItemType.Label && !!config.onLegendItemClick);
    const legendItemsMerged = legendItemsEnter.merge(legendItems);
    smartTransition(legendItemsMerged, 500).attr("opacity", 1);
    legendItemsMerged.select("span").html((d) => d.text);
    legendItems.exit().remove();
    this.line.attr("class", line2(config.lineColor)).style("opacity", config.items.length > 1 ? 1 : 0);
  }
  _onItemClick(event, d) {
    const { config } = this;
    if (config.onLegendItemClick)
      config.onLegendItemClick(d.text, d.index);
  }
};

// node_modules/@unovis/ts/components/crosshair/config.js
var CrosshairDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { yStacked: void 0, baseline: null, duration: 100, tooltip: void 0, template: (d, x3) => "", hideWhenFarFromPointer: true, hideWhenFarFromPointerDistance: 100, snapToData: true, getCircles: void 0, color: void 0, strokeColor: void 0, strokeWidth: void 0 });

// node_modules/@unovis/ts/components/crosshair/style.js
var style_exports9 = {};
__export(style_exports9, {
  circle: () => circle,
  globalStyles: () => globalStyles7,
  line: () => line3,
  root: () => root11
});
var globalStyles7 = injectGlobal`
  :root {
    --vis-crosshair-line-stroke-color: #888;
    --vis-crosshair-line-stroke-width: 1px;
    --vis-crosshair-line-stroke-opacity: 1;
    --vis-crosshair-circle-stroke-color: #fff;
    --vis-crosshair-circle-stroke-width: 1px;
    --vis-crosshair-circle-stroke-opacity: 0.75;
  }
`;
var root11 = css`
  label: crosshair-component;
`;
var line3 = css`
  stroke: var(--vis-crosshair-line-stroke-color);
  stroke-width: var(--vis-crosshair-line-stroke-width);
  stroke-opacity: var(--vis-crosshair-line-stroke-opacity);
  pointer-events: none;
`;
var circle = css`
  stroke: var(--vis-crosshair-circle-stroke-color);
  stroke-width: var(--vis-crosshair-circle-stroke-width);
  stroke-opacity: var(--vis-crosshair-circle-stroke-opacity);
  pointer-events: none;
`;

// node_modules/@unovis/ts/components/crosshair/index.js
var Crosshair = class extends XYComponentCore {
  constructor(config) {
    super();
    this.clippable = true;
    this._defaultConfig = CrosshairDefaultConfig;
    this.config = this._defaultConfig;
    this.x = 0;
    this.show = false;
    this._animFrameId = null;
    this._accessors = {
      x: void 0,
      y: void 0,
      yStacked: void 0,
      baseline: void 0
    };
    if (config)
      this.setConfig(config);
    this.g.style("opacity", this.show ? 1 : 0);
    this.line = this.g.append("line").attr("class", line3);
  }
  set accessors(accessors) {
    this._accessors = accessors;
  }
  get accessors() {
    var _a;
    const { config } = this;
    const hasConfig = !!(config.x || config.y || config.yStacked);
    const x3 = hasConfig ? config.x : this._accessors.x;
    const yAcc = hasConfig ? config.y : this._accessors.y;
    const y3 = yAcc ? isArray(yAcc) ? yAcc : [yAcc] : void 0;
    const yStacked = hasConfig ? config.yStacked : this._accessors.yStacked;
    const baseline = (_a = config.baseline) !== null && _a !== void 0 ? _a : this._accessors.baseline;
    return { x: x3, y: y3, yStacked, baseline };
  }
  setContainer(containerSvg) {
    this.container = containerSvg;
    this.container.on("mousemove.crosshair", this._onMouseMove.bind(this));
    this.container.on("mouseout.crosshair", this._onMouseOut.bind(this));
  }
  _render(customDuration) {
    const { config } = this;
    if (config.snapToData && !this.datum)
      return;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    smartTransition(this.g, duration).style("opacity", this.show ? 1 : 0);
    this.line.attr("y1", 0).attr("y1", this._height);
    smartTransition(this.line, duration, linear2).attr("x1", this.x).attr("x2", this.x);
    const circleData = this.getCircleData();
    const circles = this.g.selectAll("circle").data(circleData, (d, i) => {
      var _a;
      return (_a = d.id) !== null && _a !== void 0 ? _a : i;
    });
    const circlesEnter = circles.enter().append("circle").attr("class", circle).attr("r", 0).attr("cx", this.x).attr("cy", (d) => d.y).style("fill", (d) => d.color).style("stroke", (d) => d.strokeColor).style("stroke-width", (d) => d.strokeWidth);
    smartTransition(circlesEnter.merge(circles), duration, linear2).attr("cx", this.x).attr("cy", (d) => d.y).attr("r", 4).style("opacity", (d) => d.opacity).style("fill", (d) => d.color).style("stroke", (d) => d.strokeColor).style("stroke-width", (d) => d.strokeWidth);
    circles.exit().remove();
  }
  hide() {
    this._onMouseOut();
  }
  _onMouseMove(event) {
    var _a, _b;
    const { config, datamodel, element } = this;
    if (!this.accessors.x && ((_a = datamodel.data) === null || _a === void 0 ? void 0 : _a.length)) {
      console.warn("Unovis | Crosshair: X accessor function has not been configured. Please check if it's present in the configuration object");
    }
    const [x3] = pointer_default(event, element);
    const xRange = this.xScale.range();
    if (config.snapToData) {
      if (!this.accessors.y && !this.accessors.yStacked && ((_b = datamodel.data) === null || _b === void 0 ? void 0 : _b.length)) {
        console.warn("Unovis | Crosshair: Y accessors have not been configured. Please check if they're present in the configuration object");
      }
      const scaleX = this.xScale;
      const valueX = scaleX.invert(x3);
      this.datum = getNearest(datamodel.data, valueX, this.accessors.x);
      this.datumIndex = datamodel.data.indexOf(this.datum);
      if (!this.datum)
        return;
      this.x = clamp(Math.round(scaleX(getNumber(this.datum, this.accessors.x, this.datumIndex))), 0, this._width);
      this.show = this.x >= 0 && this.x <= this._width && (!config.hideWhenFarFromPointer || Math.abs(this.x - x3) < config.hideWhenFarFromPointerDistance);
    } else {
      const tolerance = 2;
      this.x = clamp(x3, xRange[0], xRange[1]);
      this.show = x3 >= xRange[0] - tolerance && x3 <= xRange[1] + tolerance;
    }
    window.cancelAnimationFrame(this._animFrameId);
    this._animFrameId = window.requestAnimationFrame(() => {
      this._render();
    });
    if (this.show)
      this._showTooltip(event);
    else
      this._hideTooltip();
  }
  _onMouseOut() {
    this.show = false;
    window.cancelAnimationFrame(this._animFrameId);
    this._animFrameId = window.requestAnimationFrame(() => {
      this._render();
    });
    this._hideTooltip();
  }
  _showTooltip(event) {
    var _a;
    const { config } = this;
    const tooltip2 = (_a = config.tooltip) !== null && _a !== void 0 ? _a : this.tooltip;
    if (!tooltip2)
      return;
    const container = tooltip2.getContainer() || this.container.node();
    const [x3, y3] = tooltip2.isContainerBody() ? [event.clientX, event.clientY] : pointer_default(event, container);
    const content = config.template(this.datum, this.xScale.invert(this.x));
    if (content)
      tooltip2.show(content, { x: x3, y: y3 });
  }
  _hideTooltip() {
    var _a;
    const { config } = this;
    const tooltip2 = (_a = config.tooltip) !== null && _a !== void 0 ? _a : this.tooltip;
    tooltip2 === null || tooltip2 === void 0 ? void 0 : tooltip2.hide();
  }
  // We don't want Crosshair to be be taken in to account in domain calculations
  getYDataExtent() {
    return [void 0, void 0];
  }
  getCircleData() {
    var _a, _b;
    const { config, datamodel: { data } } = this;
    if (isFunction(config.getCircles))
      return config.getCircles(this.xScale.invert(this.x), data, this.yScale);
    if (config.snapToData && this.datum) {
      const yAccessors = (_a = this.accessors.y) !== null && _a !== void 0 ? _a : [];
      const yStackedAccessors = (_b = this.accessors.yStacked) !== null && _b !== void 0 ? _b : [];
      const baselineValue = getNumber(this.datum, this.accessors.baseline, this.datumIndex) || 0;
      const stackedValues = getStackedValues(this.datum, this.datumIndex, ...yStackedAccessors).map((value2, index3, arr) => ({
        y: this.yScale(value2 + baselineValue),
        opacity: isNumber(getNumber(this.datum, yStackedAccessors[index3])) ? 1 : 0,
        color: getColor(this.datum, config.color, index3),
        strokeColor: config.strokeColor ? getColor(this.datum, config.strokeColor, index3) : void 0,
        strokeWidth: config.strokeWidth ? getNumber(this.datum, config.strokeWidth, index3) : void 0
      }));
      const regularValues = yAccessors.map((a4, index3) => {
        const value2 = getNumber(this.datum, a4);
        return {
          y: this.yScale(value2),
          opacity: isNumber(value2) ? 1 : 0,
          color: getColor(this.datum, config.color, stackedValues.length + index3),
          strokeColor: config.strokeColor ? getColor(this.datum, config.strokeColor, index3) : void 0,
          strokeWidth: config.strokeWidth ? getNumber(this.datum, config.strokeWidth, index3) : void 0
        };
      });
      return stackedValues.concat(regularValues);
    }
    return [];
  }
};
Crosshair.selectors = style_exports9;

// node_modules/@unovis/ts/components/timeline/config.js
var TimelineDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { id: void 0, color: (d) => d.color, lineWidth: 8, lineCap: false, rowHeight: 22, length: (d) => d.length, type: (d) => d.type, cursor: null, labelWidth: void 0, showLabels: false, maxLabelWidth: 120, alternatingRowColors: true, onScroll: void 0, showEmptySegments: false });

// node_modules/@unovis/ts/components/timeline/style.js
var style_exports10 = {};
__export(style_exports10, {
  background: () => background,
  globalStyles: () => globalStyles8,
  label: () => label4,
  labels: () => labels2,
  line: () => line4,
  lines: () => lines2,
  root: () => root12,
  row: () => row,
  rowOdd: () => rowOdd,
  rows: () => rows,
  scrollbar: () => scrollbar,
  scrollbarBackground: () => scrollbarBackground,
  scrollbarHandle: () => scrollbarHandle
});
var root12 = css`
  label: timeline-component;
`;
var globalStyles8 = injectGlobal`
  :root {
    --vis-timeline-row-even-fill-color: #FFFFFF;
    --vis-timeline-row-odd-fill-color: #F7FAFC;
    --vis-timeline-row-background-opacity: 1;
    --vis-timeline-scrollbar-background-color: #E6E9F3;
    --vis-timeline-scrollbar-color: #9EA7B8;

    --vis-timeline-label-font-size: 12px;
    --vis-timeline-label-color: #6C778C;

    --vis-timeline-cursor: default;
    --vis-timeline-line-color: var(--vis-color-main);
    --vis-timeline-line-stroke-width: 0;
    // The line stroke color variable is not defined by default
    // to allow it to fallback to the corresponding row background color
    /* --vis-timeline-line-stroke-color: none; */

    --vis-dark-timeline-row-even-fill-color: #292B34;
    --vis-dark-timeline-row-odd-fill-color: #333742;
    --vis-dark-timeline-scrollbar-background-color: #292B34;
    --vis-dark-timeline-scrollbar-color: #6C778C;
    --vis-dark-timeline-label-color: #EFF5F8;
  }

  body.theme-dark ${`.${root12}`} {
    --vis-timeline-row-even-fill-color: var(--vis-dark-timeline-row-even-fill-color);
    --vis-timeline-row-odd-fill-color: var(--vis-dark-timeline-row-odd-fill-color);
    --vis-timeline-scrollbar-background-color: var(--vis-dark-timeline-scrollbar-background-color);
    --vis-timeline-scrollbar-color: var(--vis-dark-timeline-scrollbar-color);
    --vis-timeline-label-color: var(--vis-dark-timeline-label-color);
  }
`;
var background = css`
  label: background;
`;
var lines2 = css`
  label: lines;
`;
var line4 = css`
  label: line;
  fill: var(--vis-timeline-line-color);
  cursor: var(--vis-timeline-cursor);

  stroke: var(--vis-timeline-line-stroke-color, var(--vis-timeline-row-even-fill-color));
  stroke-width: var(--vis-timeline-line-stroke-width);

  &.odd {
    stroke: var(--vis-timeline-line-stroke-color, var(--vis-timeline-row-odd-fill-color));
  }
`;
var rows = css`
  label: rows;
`;
var row = css`
  label: row;
  fill: var(--vis-timeline-row-even-fill-color);
  opacity: var(--vis-timeline-row-background-opacity);
`;
var rowOdd = css`
  label: row-odd;
  fill: var(--vis-timeline-row-odd-fill-color);
`;
var scrollbar = css`
  label: scroll-bar;
`;
var scrollbarHandle = css`
  label: scroll-bar-handle;
  fill: var(--vis-timeline-scrollbar-color);
`;
var scrollbarBackground = css`
  label: scroll-bar-background;
  fill: var(--vis-timeline-scrollbar-background-color);
`;
var labels2 = css`
  label: labels;
`;
var label4 = css`
  label: label;
  dominant-baseline: middle;
  font-size: var(--vis-timeline-label-font-size);
  fill: var(--vis-timeline-label-color);
  text-anchor: end;
  user-select: none;
`;

// node_modules/@unovis/ts/components/timeline/index.js
var Timeline = class _Timeline extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = TimelineDefaultConfig;
    this.config = this._defaultConfig;
    this.events = {
      [_Timeline.selectors.rows]: {
        wheel: this._onMouseWheel.bind(this)
      },
      [_Timeline.selectors.line]: {
        wheel: this._onMouseWheel.bind(this)
      }
    };
    this._scrollBarWidth = 5;
    this._scrollDistance = 0;
    this._scrollBarMargin = 5;
    this._maxScroll = 0;
    this._scrollbarHeight = 0;
    this._labelMargin = 5;
    if (config)
      this.setConfig(config);
    this._background = this.g.append("rect").attr("class", background);
    this._rowsGroup = this.g.append("g").attr("class", rows);
    this._linesGroup = this.g.append("g").attr("class", lines2);
    this._labelsGroup = this.g.append("g").attr("class", labels2);
    this._scrollBarGroup = this.g.append("g").attr("class", scrollbar);
    this._scrollBarBackground = this._scrollBarGroup.append("rect").attr("class", scrollbarBackground);
    this._scrollBarHandle = this._scrollBarGroup.append("rect").attr("class", scrollbarHandle);
    const dragBehaviour = drag_default().on("drag", this._onScrollbarDrag.bind(this));
    this._scrollBarHandle.call(dragBehaviour);
  }
  get bleed() {
    const { config, datamodel: { data } } = this;
    let labelsBleed = 0;
    if (config.showLabels) {
      if (config.labelWidth)
        labelsBleed = config.labelWidth + this._labelMargin;
      else {
        const recordLabels = this._getRecordLabels(data);
        const longestLabel = recordLabels.reduce((acc, val) => acc.length > val.length ? acc : val, "");
        const label$1 = this._labelsGroup.append("text").attr("class", label4).text(longestLabel).call(trimSVGText, config.maxLabelWidth);
        const labelWidth = label$1.node().getBBox().width;
        this._labelsGroup.empty();
        const tolerance = 1.15;
        labelsBleed = labelWidth ? tolerance * labelWidth + this._labelMargin : 0;
      }
    }
    const maxLineWidth = this._getMaxLineWidth();
    return {
      top: 0,
      bottom: 0,
      left: maxLineWidth / 2 + labelsBleed,
      right: maxLineWidth / 2 + this._scrollBarWidth + this._scrollBarMargin
    };
  }
  _render(customDuration) {
    super._render(customDuration);
    const { config, datamodel: { data } } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const xRange = this.xScale.range();
    const yRange = this.yScale.range();
    const yStart = Math.min(...yRange);
    const yHeight = Math.abs(yRange[1] - yRange[0]);
    const maxLineWidth = this._getMaxLineWidth();
    const recordLabels = this._getRecordLabels(data);
    const recordLabelsUnique = unique(recordLabels);
    const numUniqueRecords = recordLabelsUnique.length;
    const ordinalScale = ordinal();
    ordinalScale.range(arrayOfIndices(numUniqueRecords));
    this._background.attr("width", this._width).attr("height", this._height).attr("opacity", 0);
    const labels4 = this._labelsGroup.selectAll(`.${label4}`).data(config.showLabels ? recordLabelsUnique : []);
    const labelsEnter = labels4.enter().append("text").attr("class", label4);
    labelsEnter.merge(labels4).attr("x", xRange[0] - maxLineWidth / 2 - this._labelMargin).attr("y", (label10, i) => yStart + (ordinalScale(label10) + 0.5) * config.rowHeight).text((label10) => label10).each((label10, i, els) => {
      trimSVGText(select_default2(els[i]), config.labelWidth || config.maxLabelWidth);
    });
    labels4.exit().remove();
    const xStart = xRange[0];
    const numRows = Math.max(Math.floor(yHeight / config.rowHeight), numUniqueRecords);
    const recordTypes = Array(numRows).fill(null).map((_, i) => recordLabelsUnique[i]);
    const rects = this._rowsGroup.selectAll(`.${row}`).data(recordTypes);
    const rectsEnter = rects.enter().append("rect").attr("class", row);
    rectsEnter.merge(rects).classed(rowOdd, config.alternatingRowColors ? (_, i) => !(i % 2) : null).attr("x", xStart - maxLineWidth / 2).attr("width", xRange[1] - xStart + maxLineWidth).attr("y", (_, i) => yStart + i * config.rowHeight).attr("height", config.rowHeight);
    rects.exit().remove();
    const lines3 = this._linesGroup.selectAll(`.${line4}`).data(data, (d, i) => {
      var _a;
      return (_a = getString(d, config.id, i)) !== null && _a !== void 0 ? _a : [
        this._getRecordType(d, i),
        getNumber(d, config.x, i)
      ].join("-");
    });
    const linesEnter = lines3.enter().append("rect").attr("class", line4).classed(rowOdd, config.alternatingRowColors ? (d, i) => !(recordLabelsUnique.indexOf(this._getRecordType(d, i)) % 2) : null).style("fill", (d, i) => getColor(d, config.color, ordinalScale(this._getRecordType(d, i)))).call(this._positionLines.bind(this), ordinalScale).attr("transform", "translate(0, 10)").style("opacity", 0);
    const linesMerged = linesEnter.merge(lines3).style("fill", (d, i) => getColor(d, config.color, ordinalScale(this._getRecordType(d, i)))).style("cursor", (d, i) => getString(d, config.cursor, i)).call(this._positionLines.bind(this), ordinalScale);
    smartTransition(linesMerged, duration).attr("transform", "translate(0, 0)").style("opacity", 1);
    smartTransition(lines3.exit(), duration).style("opacity", 0).remove();
    const contentBBox = this._rowsGroup.node().getBBox();
    const absoluteContentHeight = contentBBox.height;
    this._scrollbarHeight = yHeight * yHeight / absoluteContentHeight || 0;
    this._maxScroll = Math.max(absoluteContentHeight - yHeight, 0);
    this._scrollBarGroup.attr("transform", `translate(${this._width - this._scrollBarWidth}, ${yStart})`).attr("opacity", this._maxScroll ? 1 : 0);
    this._scrollBarBackground.attr("width", this._scrollBarWidth).attr("height", this._height).attr("rx", this._scrollBarWidth / 2).attr("ry", this._scrollBarWidth / 2);
    this._scrollBarHandle.attr("width", this._scrollBarWidth).attr("height", this._scrollbarHeight).attr("rx", this._scrollBarWidth / 2).attr("ry", this._scrollBarWidth / 2);
    this._updateScrollPosition(0);
  }
  _positionLines(selection2, ordinalScale) {
    const { config, xScale, yScale } = this;
    const yRange = yScale.range();
    const yStart = Math.min(...yRange);
    selection2.each((d, i, elements) => {
      var _a;
      const x3 = getNumber(d, config.x, i);
      const y3 = ordinalScale(this._getRecordType(d, i)) * config.rowHeight;
      const length = (_a = getNumber(d, config.length, i)) !== null && _a !== void 0 ? _a : 0;
      const height = getNumber(d, config.lineWidth, i);
      const width = xScale(x3 + length) - xScale(x3);
      if (width < 0) {
        console.warn("Unovis | Timeline: Line segments should not have negative lengths. Setting to 0.");
      }
      select_default2(elements[i]).attr("x", xScale(x3)).attr("y", yStart + y3 + (config.rowHeight - height) / 2).attr("width", config.showEmptySegments ? Math.max(config.lineCap ? height : 1, width) : Math.max(0, width)).attr("height", height).attr("rx", config.lineCap ? height / 2 : null);
    });
  }
  _onScrollbarDrag(event) {
    const yRange = this.yScale.range();
    const yHeight = Math.abs(yRange[1] - yRange[0]);
    this._updateScrollPosition(event.dy * this._maxScroll / (yHeight - this._scrollbarHeight));
  }
  _onMouseWheel(d, event) {
    var _a;
    const { config } = this;
    this._updateScrollPosition(event === null || event === void 0 ? void 0 : event.deltaY);
    if (this._scrollDistance > 0 && this._scrollDistance < this._maxScroll)
      event === null || event === void 0 ? void 0 : event.preventDefault();
    (_a = config.onScroll) === null || _a === void 0 ? void 0 : _a.call(config, this._scrollDistance);
    const e = new Event("mousemove");
    this.element.dispatchEvent(e);
  }
  _updateScrollPosition(diff) {
    const yRange = this.yScale.range();
    const yHeight = Math.abs(yRange[1] - yRange[0]);
    this._scrollDistance += diff;
    this._scrollDistance = Math.max(0, this._scrollDistance);
    this._scrollDistance = Math.min(this._maxScroll, this._scrollDistance);
    this._linesGroup.attr("transform", `translate(0,${-this._scrollDistance})`);
    this._rowsGroup.attr("transform", `translate(0,${-this._scrollDistance})`);
    this._labelsGroup.attr("transform", `translate(0,${-this._scrollDistance})`);
    const scrollBarPosition = this._scrollDistance / this._maxScroll * (yHeight - this._scrollbarHeight) || 0;
    this._scrollBarHandle.attr("y", scrollBarPosition);
  }
  _getMaxLineWidth() {
    var _a;
    const { config, datamodel: { data } } = this;
    return (_a = max(data, (d, i) => getNumber(d, config.lineWidth, i))) !== null && _a !== void 0 ? _a : 0;
  }
  _getRecordType(d, i) {
    return getString(d, this.config.type) || `__${i}`;
  }
  _getRecordLabels(data) {
    return data.map((d, i) => getString(d, this.config.type) || `${i + 1}`);
  }
  // Override the default XYComponent getXDataExtent method to take into account line lengths
  getXDataExtent() {
    const { config, datamodel } = this;
    const min7 = getMin(datamodel.data, config.x);
    const max8 = getMax(datamodel.data, (d, i) => {
      var _a;
      return getNumber(d, config.x, i) + ((_a = getNumber(d, config.length, i)) !== null && _a !== void 0 ? _a : 0);
    });
    return [min7, max8];
  }
};
Timeline.selectors = style_exports10;

// node_modules/d3-sankey/node_modules/d3-array/src/ascending.js
function ascending_default2(a4, b) {
  return a4 < b ? -1 : a4 > b ? 1 : a4 >= b ? 0 : NaN;
}

// node_modules/d3-sankey/node_modules/d3-array/src/bisector.js
function bisector_default(f) {
  let delta = f;
  let compare = f;
  if (f.length === 1) {
    delta = (d, x3) => f(d) - x3;
    compare = ascendingComparator(f);
  }
  function left3(a4, x3, lo, hi) {
    if (lo == null) lo = 0;
    if (hi == null) hi = a4.length;
    while (lo < hi) {
      const mid = lo + hi >>> 1;
      if (compare(a4[mid], x3) < 0) lo = mid + 1;
      else hi = mid;
    }
    return lo;
  }
  function right3(a4, x3, lo, hi) {
    if (lo == null) lo = 0;
    if (hi == null) hi = a4.length;
    while (lo < hi) {
      const mid = lo + hi >>> 1;
      if (compare(a4[mid], x3) > 0) hi = mid;
      else lo = mid + 1;
    }
    return lo;
  }
  function center3(a4, x3, lo, hi) {
    if (lo == null) lo = 0;
    if (hi == null) hi = a4.length;
    const i = left3(a4, x3, lo, hi - 1);
    return i > lo && delta(a4[i - 1], x3) > -delta(a4[i], x3) ? i - 1 : i;
  }
  return { left: left3, center: center3, right: right3 };
}
function ascendingComparator(f) {
  return (d, x3) => ascending_default2(f(d), x3);
}

// node_modules/d3-sankey/node_modules/d3-array/src/number.js
function number_default2(x3) {
  return x3 === null ? NaN : +x3;
}

// node_modules/d3-sankey/node_modules/d3-array/src/bisect.js
var ascendingBisect = bisector_default(ascending_default2);
var bisectRight = ascendingBisect.right;
var bisectLeft = ascendingBisect.left;
var bisectCenter = bisector_default(number_default2).center;

// node_modules/d3-sankey/node_modules/d3-array/src/array.js
var array2 = Array.prototype;
var slice2 = array2.slice;
var map2 = array2.map;

// node_modules/d3-sankey/node_modules/d3-array/src/ticks.js
var e10 = Math.sqrt(50);
var e5 = Math.sqrt(10);
var e2 = Math.sqrt(2);

// node_modules/d3-sankey/node_modules/d3-array/src/max.js
function max4(values, valueof) {
  let max8;
  if (valueof === void 0) {
    for (const value2 of values) {
      if (value2 != null && (max8 < value2 || max8 === void 0 && value2 >= value2)) {
        max8 = value2;
      }
    }
  } else {
    let index3 = -1;
    for (let value2 of values) {
      if ((value2 = valueof(value2, ++index3, values)) != null && (max8 < value2 || max8 === void 0 && value2 >= value2)) {
        max8 = value2;
      }
    }
  }
  return max8;
}

// node_modules/d3-sankey/node_modules/d3-array/src/min.js
function min4(values, valueof) {
  let min7;
  if (valueof === void 0) {
    for (const value2 of values) {
      if (value2 != null && (min7 > value2 || min7 === void 0 && value2 >= value2)) {
        min7 = value2;
      }
    }
  } else {
    let index3 = -1;
    for (let value2 of values) {
      if ((value2 = valueof(value2, ++index3, values)) != null && (min7 > value2 || min7 === void 0 && value2 >= value2)) {
        min7 = value2;
      }
    }
  }
  return min7;
}

// node_modules/d3-sankey/node_modules/d3-array/src/shuffle.js
var shuffle_default = shuffler(Math.random);
function shuffler(random) {
  return function shuffle2(array3, i0 = 0, i1 = array3.length) {
    let m2 = i1 - (i0 = +i0);
    while (m2) {
      const i = random() * m2-- | 0, t = array3[m2 + i0];
      array3[m2 + i0] = array3[i + i0];
      array3[i + i0] = t;
    }
    return array3;
  };
}

// node_modules/d3-sankey/node_modules/d3-array/src/sum.js
function sum3(values, valueof) {
  let sum5 = 0;
  if (valueof === void 0) {
    for (let value2 of values) {
      if (value2 = +value2) {
        sum5 += value2;
      }
    }
  } else {
    let index3 = -1;
    for (let value2 of values) {
      if (value2 = +valueof(value2, ++index3, values)) {
        sum5 += value2;
      }
    }
  }
  return sum5;
}

// node_modules/d3-sankey/src/align.js
function targetDepth(d) {
  return d.target.depth;
}
function left2(node4) {
  return node4.depth;
}
function right2(node4, n) {
  return n - 1 - node4.height;
}
function justify(node4, n) {
  return node4.sourceLinks.length ? node4.depth : n - 1;
}
function center2(node4) {
  return node4.targetLinks.length ? node4.depth : node4.sourceLinks.length ? min4(node4.sourceLinks, targetDepth) - 1 : 0;
}

// node_modules/d3-sankey/src/constant.js
function constant(x3) {
  return function() {
    return x3;
  };
}

// node_modules/d3-sankey/src/sankey.js
function ascendingSourceBreadth(a4, b) {
  return ascendingBreadth(a4.source, b.source) || a4.index - b.index;
}
function ascendingTargetBreadth(a4, b) {
  return ascendingBreadth(a4.target, b.target) || a4.index - b.index;
}
function ascendingBreadth(a4, b) {
  return a4.y0 - b.y0;
}
function value(d) {
  return d.value;
}
function defaultId(d) {
  return d.index;
}
function defaultNodes(graph) {
  return graph.nodes;
}
function defaultLinks(graph) {
  return graph.links;
}
function find2(nodeById, id2) {
  const node4 = nodeById.get(id2);
  if (!node4) throw new Error("missing: " + id2);
  return node4;
}
function computeLinkBreadths({ nodes: nodes4 }) {
  for (const node4 of nodes4) {
    let y06 = node4.y0;
    let y13 = y06;
    for (const link7 of node4.sourceLinks) {
      link7.y0 = y06 + link7.width / 2;
      y06 += link7.width;
    }
    for (const link7 of node4.targetLinks) {
      link7.y1 = y13 + link7.width / 2;
      y13 += link7.width;
    }
  }
}
function Sankey() {
  let x06 = 0, y06 = 0, x13 = 1, y13 = 1;
  let dx = 24;
  let dy = 8, py;
  let id2 = defaultId;
  let align = justify;
  let sort2;
  let linkSort;
  let nodes4 = defaultNodes;
  let links5 = defaultLinks;
  let iterations2 = 6;
  function sankey() {
    const graph = { nodes: nodes4.apply(null, arguments), links: links5.apply(null, arguments) };
    computeNodeLinks(graph);
    computeNodeValues(graph);
    computeNodeDepths(graph);
    computeNodeHeights(graph);
    computeNodeBreadths(graph);
    computeLinkBreadths(graph);
    return graph;
  }
  sankey.update = function(graph) {
    computeLinkBreadths(graph);
    return graph;
  };
  sankey.nodeId = function(_) {
    return arguments.length ? (id2 = typeof _ === "function" ? _ : constant(_), sankey) : id2;
  };
  sankey.nodeAlign = function(_) {
    return arguments.length ? (align = typeof _ === "function" ? _ : constant(_), sankey) : align;
  };
  sankey.nodeSort = function(_) {
    return arguments.length ? (sort2 = _, sankey) : sort2;
  };
  sankey.nodeWidth = function(_) {
    return arguments.length ? (dx = +_, sankey) : dx;
  };
  sankey.nodePadding = function(_) {
    return arguments.length ? (dy = py = +_, sankey) : dy;
  };
  sankey.nodes = function(_) {
    return arguments.length ? (nodes4 = typeof _ === "function" ? _ : constant(_), sankey) : nodes4;
  };
  sankey.links = function(_) {
    return arguments.length ? (links5 = typeof _ === "function" ? _ : constant(_), sankey) : links5;
  };
  sankey.linkSort = function(_) {
    return arguments.length ? (linkSort = _, sankey) : linkSort;
  };
  sankey.size = function(_) {
    return arguments.length ? (x06 = y06 = 0, x13 = +_[0], y13 = +_[1], sankey) : [x13 - x06, y13 - y06];
  };
  sankey.extent = function(_) {
    return arguments.length ? (x06 = +_[0][0], x13 = +_[1][0], y06 = +_[0][1], y13 = +_[1][1], sankey) : [[x06, y06], [x13, y13]];
  };
  sankey.iterations = function(_) {
    return arguments.length ? (iterations2 = +_, sankey) : iterations2;
  };
  function computeNodeLinks({ nodes: nodes5, links: links6 }) {
    for (const [i, node4] of nodes5.entries()) {
      node4.index = i;
      node4.sourceLinks = [];
      node4.targetLinks = [];
    }
    const nodeById = new Map(nodes5.map((d, i) => [id2(d, i, nodes5), d]));
    for (const [i, link7] of links6.entries()) {
      link7.index = i;
      let { source, target } = link7;
      if (typeof source !== "object") source = link7.source = find2(nodeById, source);
      if (typeof target !== "object") target = link7.target = find2(nodeById, target);
      source.sourceLinks.push(link7);
      target.targetLinks.push(link7);
    }
    if (linkSort != null) {
      for (const { sourceLinks, targetLinks } of nodes5) {
        sourceLinks.sort(linkSort);
        targetLinks.sort(linkSort);
      }
    }
  }
  function computeNodeValues({ nodes: nodes5 }) {
    for (const node4 of nodes5) {
      node4.value = node4.fixedValue === void 0 ? Math.max(sum3(node4.sourceLinks, value), sum3(node4.targetLinks, value)) : node4.fixedValue;
    }
  }
  function computeNodeDepths({ nodes: nodes5 }) {
    const n = nodes5.length;
    let current = new Set(nodes5);
    let next = /* @__PURE__ */ new Set();
    let x3 = 0;
    while (current.size) {
      for (const node4 of current) {
        node4.depth = x3;
        for (const { target } of node4.sourceLinks) {
          next.add(target);
        }
      }
      if (++x3 > n) throw new Error("circular link");
      current = next;
      next = /* @__PURE__ */ new Set();
    }
  }
  function computeNodeHeights({ nodes: nodes5 }) {
    const n = nodes5.length;
    let current = new Set(nodes5);
    let next = /* @__PURE__ */ new Set();
    let x3 = 0;
    while (current.size) {
      for (const node4 of current) {
        node4.height = x3;
        for (const { source } of node4.targetLinks) {
          next.add(source);
        }
      }
      if (++x3 > n) throw new Error("circular link");
      current = next;
      next = /* @__PURE__ */ new Set();
    }
  }
  function computeNodeLayers({ nodes: nodes5 }) {
    const x3 = max4(nodes5, (d) => d.depth) + 1;
    const kx4 = (x13 - x06 - dx) / (x3 - 1);
    const columns = new Array(x3);
    for (const node4 of nodes5) {
      const i = Math.max(0, Math.min(x3 - 1, Math.floor(align.call(null, node4, x3))));
      node4.layer = i;
      node4.x0 = x06 + i * kx4;
      node4.x1 = node4.x0 + dx;
      if (columns[i]) columns[i].push(node4);
      else columns[i] = [node4];
    }
    if (sort2) for (const column of columns) {
      column.sort(sort2);
    }
    return columns;
  }
  function initializeNodeBreadths(columns) {
    const ky3 = min4(columns, (c3) => (y13 - y06 - (c3.length - 1) * py) / sum3(c3, value));
    for (const nodes5 of columns) {
      let y3 = y06;
      for (const node4 of nodes5) {
        node4.y0 = y3;
        node4.y1 = y3 + node4.value * ky3;
        y3 = node4.y1 + py;
        for (const link7 of node4.sourceLinks) {
          link7.width = link7.value * ky3;
        }
      }
      y3 = (y13 - y3 + py) / (nodes5.length + 1);
      for (let i = 0; i < nodes5.length; ++i) {
        const node4 = nodes5[i];
        node4.y0 += y3 * (i + 1);
        node4.y1 += y3 * (i + 1);
      }
      reorderLinks(nodes5);
    }
  }
  function computeNodeBreadths(graph) {
    const columns = computeNodeLayers(graph);
    py = Math.min(dy, (y13 - y06) / (max4(columns, (c3) => c3.length) - 1));
    initializeNodeBreadths(columns);
    for (let i = 0; i < iterations2; ++i) {
      const alpha = Math.pow(0.99, i);
      const beta = Math.max(1 - alpha, (i + 1) / iterations2);
      relaxRightToLeft(columns, alpha, beta);
      relaxLeftToRight(columns, alpha, beta);
    }
  }
  function relaxLeftToRight(columns, alpha, beta) {
    for (let i = 1, n = columns.length; i < n; ++i) {
      const column = columns[i];
      for (const target of column) {
        let y3 = 0;
        let w2 = 0;
        for (const { source, value: value2 } of target.targetLinks) {
          let v = value2 * (target.layer - source.layer);
          y3 += targetTop(source, target) * v;
          w2 += v;
        }
        if (!(w2 > 0)) continue;
        let dy2 = (y3 / w2 - target.y0) * alpha;
        target.y0 += dy2;
        target.y1 += dy2;
        reorderNodeLinks(target);
      }
      if (sort2 === void 0) column.sort(ascendingBreadth);
      resolveCollisions(column, beta);
    }
  }
  function relaxRightToLeft(columns, alpha, beta) {
    for (let n = columns.length, i = n - 2; i >= 0; --i) {
      const column = columns[i];
      for (const source of column) {
        let y3 = 0;
        let w2 = 0;
        for (const { target, value: value2 } of source.sourceLinks) {
          let v = value2 * (target.layer - source.layer);
          y3 += sourceTop(source, target) * v;
          w2 += v;
        }
        if (!(w2 > 0)) continue;
        let dy2 = (y3 / w2 - source.y0) * alpha;
        source.y0 += dy2;
        source.y1 += dy2;
        reorderNodeLinks(source);
      }
      if (sort2 === void 0) column.sort(ascendingBreadth);
      resolveCollisions(column, beta);
    }
  }
  function resolveCollisions(nodes5, alpha) {
    const i = nodes5.length >> 1;
    const subject = nodes5[i];
    resolveCollisionsBottomToTop(nodes5, subject.y0 - py, i - 1, alpha);
    resolveCollisionsTopToBottom(nodes5, subject.y1 + py, i + 1, alpha);
    resolveCollisionsBottomToTop(nodes5, y13, nodes5.length - 1, alpha);
    resolveCollisionsTopToBottom(nodes5, y06, 0, alpha);
  }
  function resolveCollisionsTopToBottom(nodes5, y3, i, alpha) {
    for (; i < nodes5.length; ++i) {
      const node4 = nodes5[i];
      const dy2 = (y3 - node4.y0) * alpha;
      if (dy2 > 1e-6) node4.y0 += dy2, node4.y1 += dy2;
      y3 = node4.y1 + py;
    }
  }
  function resolveCollisionsBottomToTop(nodes5, y3, i, alpha) {
    for (; i >= 0; --i) {
      const node4 = nodes5[i];
      const dy2 = (node4.y1 - y3) * alpha;
      if (dy2 > 1e-6) node4.y0 -= dy2, node4.y1 -= dy2;
      y3 = node4.y0 - py;
    }
  }
  function reorderNodeLinks({ sourceLinks, targetLinks }) {
    if (linkSort === void 0) {
      for (const { source: { sourceLinks: sourceLinks2 } } of targetLinks) {
        sourceLinks2.sort(ascendingTargetBreadth);
      }
      for (const { target: { targetLinks: targetLinks2 } } of sourceLinks) {
        targetLinks2.sort(ascendingSourceBreadth);
      }
    }
  }
  function reorderLinks(nodes5) {
    if (linkSort === void 0) {
      for (const { sourceLinks, targetLinks } of nodes5) {
        sourceLinks.sort(ascendingTargetBreadth);
        targetLinks.sort(ascendingSourceBreadth);
      }
    }
  }
  function targetTop(source, target) {
    let y3 = source.y0 - (source.sourceLinks.length - 1) * py / 2;
    for (const { target: node4, width } of source.sourceLinks) {
      if (node4 === target) break;
      y3 += width + py;
    }
    for (const { source: node4, width } of target.targetLinks) {
      if (node4 === source) break;
      y3 -= width;
    }
    return y3;
  }
  function sourceTop(source, target) {
    let y3 = target.y0 - (target.targetLinks.length - 1) * py / 2;
    for (const { source: node4, width } of target.targetLinks) {
      if (node4 === source) break;
      y3 += width + py;
    }
    for (const { target: node4, width } of source.sourceLinks) {
      if (node4 === target) break;
      y3 -= width;
    }
    return y3;
  }
  return sankey;
}

// node_modules/d3-sankey/node_modules/d3-path/src/path.js
var pi4 = Math.PI;
var tau4 = 2 * pi4;
var epsilon5 = 1e-6;
var tauEpsilon2 = tau4 - epsilon5;
function Path2() {
  this._x0 = this._y0 = // start of current subpath
  this._x1 = this._y1 = null;
  this._ = "";
}
function path2() {
  return new Path2();
}
Path2.prototype = path2.prototype = {
  constructor: Path2,
  moveTo: function(x3, y3) {
    this._ += "M" + (this._x0 = this._x1 = +x3) + "," + (this._y0 = this._y1 = +y3);
  },
  closePath: function() {
    if (this._x1 !== null) {
      this._x1 = this._x0, this._y1 = this._y0;
      this._ += "Z";
    }
  },
  lineTo: function(x3, y3) {
    this._ += "L" + (this._x1 = +x3) + "," + (this._y1 = +y3);
  },
  quadraticCurveTo: function(x13, y13, x3, y3) {
    this._ += "Q" + +x13 + "," + +y13 + "," + (this._x1 = +x3) + "," + (this._y1 = +y3);
  },
  bezierCurveTo: function(x13, y13, x22, y22, x3, y3) {
    this._ += "C" + +x13 + "," + +y13 + "," + +x22 + "," + +y22 + "," + (this._x1 = +x3) + "," + (this._y1 = +y3);
  },
  arcTo: function(x13, y13, x22, y22, r) {
    x13 = +x13, y13 = +y13, x22 = +x22, y22 = +y22, r = +r;
    var x06 = this._x1, y06 = this._y1, x21 = x22 - x13, y21 = y22 - y13, x01 = x06 - x13, y01 = y06 - y13, l01_2 = x01 * x01 + y01 * y01;
    if (r < 0) throw new Error("negative radius: " + r);
    if (this._x1 === null) {
      this._ += "M" + (this._x1 = x13) + "," + (this._y1 = y13);
    } else if (!(l01_2 > epsilon5)) ;
    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon5) || !r) {
      this._ += "L" + (this._x1 = x13) + "," + (this._y1 = y13);
    } else {
      var x20 = x22 - x06, y20 = y22 - y06, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi4 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
      if (Math.abs(t01 - 1) > epsilon5) {
        this._ += "L" + (x13 + t01 * x01) + "," + (y13 + t01 * y01);
      }
      this._ += "A" + r + "," + r + ",0,0," + +(y01 * x20 > x01 * y20) + "," + (this._x1 = x13 + t21 * x21) + "," + (this._y1 = y13 + t21 * y21);
    }
  },
  arc: function(x3, y3, r, a0, a1, ccw) {
    x3 = +x3, y3 = +y3, r = +r, ccw = !!ccw;
    var dx = r * Math.cos(a0), dy = r * Math.sin(a0), x06 = x3 + dx, y06 = y3 + dy, cw = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
    if (r < 0) throw new Error("negative radius: " + r);
    if (this._x1 === null) {
      this._ += "M" + x06 + "," + y06;
    } else if (Math.abs(this._x1 - x06) > epsilon5 || Math.abs(this._y1 - y06) > epsilon5) {
      this._ += "L" + x06 + "," + y06;
    }
    if (!r) return;
    if (da < 0) da = da % tau4 + tau4;
    if (da > tauEpsilon2) {
      this._ += "A" + r + "," + r + ",0,1," + cw + "," + (x3 - dx) + "," + (y3 - dy) + "A" + r + "," + r + ",0,1," + cw + "," + (this._x1 = x06) + "," + (this._y1 = y06);
    } else if (da > epsilon5) {
      this._ += "A" + r + "," + r + ",0," + +(da >= pi4) + "," + cw + "," + (this._x1 = x3 + r * Math.cos(a1)) + "," + (this._y1 = y3 + r * Math.sin(a1));
    }
  },
  rect: function(x3, y3, w2, h) {
    this._ += "M" + (this._x0 = this._x1 = +x3) + "," + (this._y0 = this._y1 = +y3) + "h" + +w2 + "v" + +h + "h" + -w2 + "Z";
  },
  toString: function() {
    return this._;
  }
};

// node_modules/d3-sankey/node_modules/d3-shape/src/math.js
var epsilon6 = 1e-12;
var pi5 = Math.PI;
var halfPi3 = pi5 / 2;
var tau5 = 2 * pi5;

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/linear.js
function Linear2(context) {
  this._context = context;
}
Linear2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
      default:
        this._context.lineTo(x3, y3);
        break;
    }
  }
};
function linear_default2(context) {
  return new Linear2(context);
}

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/radial.js
var curveRadialLinear2 = curveRadial2(linear_default2);
function Radial2(curve) {
  this._curve = curve;
}
Radial2.prototype = {
  areaStart: function() {
    this._curve.areaStart();
  },
  areaEnd: function() {
    this._curve.areaEnd();
  },
  lineStart: function() {
    this._curve.lineStart();
  },
  lineEnd: function() {
    this._curve.lineEnd();
  },
  point: function(a4, r) {
    this._curve.point(r * Math.sin(a4), r * -Math.cos(a4));
  }
};
function curveRadial2(curve) {
  function radial2(context) {
    return new Radial2(curve(context));
  }
  radial2._curve = curve;
  return radial2;
}

// node_modules/d3-sankey/node_modules/d3-shape/src/array.js
var slice3 = Array.prototype.slice;

// node_modules/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js
var tan302 = Math.sqrt(1 / 3);
var tan30_22 = tan302 * 2;

// node_modules/d3-sankey/node_modules/d3-shape/src/symbol/star.js
var kr2 = Math.sin(pi5 / 10) / Math.sin(7 * pi5 / 10);
var kx2 = Math.sin(tau5 / 10) * kr2;
var ky2 = -Math.cos(tau5 / 10) * kr2;

// node_modules/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js
var sqrt34 = Math.sqrt(3);

// node_modules/d3-sankey/node_modules/d3-shape/src/symbol/wye.js
var s2 = Math.sqrt(3) / 2;
var k2 = 1 / Math.sqrt(12);
var a2 = (k2 / 2 + 1) * 3;

// node_modules/d3-sankey/node_modules/d3-shape/src/noop.js
function noop_default2() {
}

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/basis.js
function point7(that, x3, y3) {
  that._context.bezierCurveTo(
    (2 * that._x0 + that._x1) / 3,
    (2 * that._y0 + that._y1) / 3,
    (that._x0 + 2 * that._x1) / 3,
    (that._y0 + 2 * that._y1) / 3,
    (that._x0 + 4 * that._x1 + x3) / 6,
    (that._y0 + 4 * that._y1 + y3) / 6
  );
}
function Basis2(context) {
  this._context = context;
}
Basis2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 3:
        point7(this, this._x1, this._y1);
      case 2:
        this._context.lineTo(this._x1, this._y1);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
      default:
        point7(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
  }
};

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/basisClosed.js
function BasisClosed2(context) {
  this._context = context;
}
BasisClosed2.prototype = {
  areaStart: noop_default2,
  areaEnd: noop_default2,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x2, this._y2);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
        this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x2, this._y2);
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        break;
      }
    }
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x2 = x3, this._y2 = y3;
        break;
      case 1:
        this._point = 2;
        this._x3 = x3, this._y3 = y3;
        break;
      case 2:
        this._point = 3;
        this._x4 = x3, this._y4 = y3;
        this._context.moveTo((this._x0 + 4 * this._x1 + x3) / 6, (this._y0 + 4 * this._y1 + y3) / 6);
        break;
      default:
        point7(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
  }
};

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/basisOpen.js
function BasisOpen2(context) {
  this._context = context;
}
BasisOpen2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        var x06 = (this._x0 + 4 * this._x1 + x3) / 6, y06 = (this._y0 + 4 * this._y1 + y3) / 6;
        this._line ? this._context.lineTo(x06, y06) : this._context.moveTo(x06, y06);
        break;
      case 3:
        this._point = 4;
      default:
        point7(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
  }
};

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/bundle.js
function Bundle2(context, beta) {
  this._basis = new Basis2(context);
  this._beta = beta;
}
Bundle2.prototype = {
  lineStart: function() {
    this._x = [];
    this._y = [];
    this._basis.lineStart();
  },
  lineEnd: function() {
    var x3 = this._x, y3 = this._y, j = x3.length - 1;
    if (j > 0) {
      var x06 = x3[0], y06 = y3[0], dx = x3[j] - x06, dy = y3[j] - y06, i = -1, t;
      while (++i <= j) {
        t = i / j;
        this._basis.point(
          this._beta * x3[i] + (1 - this._beta) * (x06 + t * dx),
          this._beta * y3[i] + (1 - this._beta) * (y06 + t * dy)
        );
      }
    }
    this._x = this._y = null;
    this._basis.lineEnd();
  },
  point: function(x3, y3) {
    this._x.push(+x3);
    this._y.push(+y3);
  }
};
var bundle_default2 = function custom17(beta) {
  function bundle(context) {
    return beta === 1 ? new Basis2(context) : new Bundle2(context, beta);
  }
  bundle.beta = function(beta2) {
    return custom17(+beta2);
  };
  return bundle;
}(0.85);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js
function point8(that, x3, y3) {
  that._context.bezierCurveTo(
    that._x1 + that._k * (that._x2 - that._x0),
    that._y1 + that._k * (that._y2 - that._y0),
    that._x2 + that._k * (that._x1 - x3),
    that._y2 + that._k * (that._y1 - y3),
    that._x2,
    that._y2
  );
}
function Cardinal2(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}
Cardinal2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x2, this._y2);
        break;
      case 3:
        point8(this, this._x1, this._y1);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        this._x1 = x3, this._y1 = y3;
        break;
      case 2:
        this._point = 3;
      default:
        point8(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var cardinal_default2 = function custom18(tension) {
  function cardinal(context) {
    return new Cardinal2(context, tension);
  }
  cardinal.tension = function(tension2) {
    return custom18(+tension2);
  };
  return cardinal;
}(0);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js
function CardinalClosed2(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}
CardinalClosed2.prototype = {
  areaStart: noop_default2,
  areaEnd: noop_default2,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x3 = x3, this._y3 = y3;
        break;
      case 1:
        this._point = 2;
        this._context.moveTo(this._x4 = x3, this._y4 = y3);
        break;
      case 2:
        this._point = 3;
        this._x5 = x3, this._y5 = y3;
        break;
      default:
        point8(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var cardinalClosed_default2 = function custom19(tension) {
  function cardinal(context) {
    return new CardinalClosed2(context, tension);
  }
  cardinal.tension = function(tension2) {
    return custom19(+tension2);
  };
  return cardinal;
}(0);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js
function CardinalOpen2(context, tension) {
  this._context = context;
  this._k = (1 - tension) / 6;
}
CardinalOpen2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
        break;
      case 3:
        this._point = 4;
      default:
        point8(this, x3, y3);
        break;
    }
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var cardinalOpen_default2 = function custom20(tension) {
  function cardinal(context) {
    return new CardinalOpen2(context, tension);
  }
  cardinal.tension = function(tension2) {
    return custom20(+tension2);
  };
  return cardinal;
}(0);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js
function point9(that, x3, y3) {
  var x13 = that._x1, y13 = that._y1, x22 = that._x2, y22 = that._y2;
  if (that._l01_a > epsilon6) {
    var a4 = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
    x13 = (x13 * a4 - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
    y13 = (y13 * a4 - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
  }
  if (that._l23_a > epsilon6) {
    var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m2 = 3 * that._l23_a * (that._l23_a + that._l12_a);
    x22 = (x22 * b + that._x1 * that._l23_2a - x3 * that._l12_2a) / m2;
    y22 = (y22 * b + that._y1 * that._l23_2a - y3 * that._l12_2a) / m2;
  }
  that._context.bezierCurveTo(x13, y13, x22, y22, that._x2, that._y2);
}
function CatmullRom2(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}
CatmullRom2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x2, this._y2);
        break;
      case 3:
        this.point(this._x2, this._y2);
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) {
      var x23 = this._x2 - x3, y23 = this._y2 - y3;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
      default:
        point9(this, x3, y3);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var catmullRom_default2 = function custom21(alpha) {
  function catmullRom(context) {
    return alpha ? new CatmullRom2(context, alpha) : new Cardinal2(context, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom21(+alpha2);
  };
  return catmullRom;
}(0.5);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/catmullRomClosed.js
function CatmullRomClosed2(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}
CatmullRomClosed2.prototype = {
  areaStart: noop_default2,
  areaEnd: noop_default2,
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 1: {
        this._context.moveTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 2: {
        this._context.lineTo(this._x3, this._y3);
        this._context.closePath();
        break;
      }
      case 3: {
        this.point(this._x3, this._y3);
        this.point(this._x4, this._y4);
        this.point(this._x5, this._y5);
        break;
      }
    }
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) {
      var x23 = this._x2 - x3, y23 = this._y2 - y3;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        this._x3 = x3, this._y3 = y3;
        break;
      case 1:
        this._point = 2;
        this._context.moveTo(this._x4 = x3, this._y4 = y3);
        break;
      case 2:
        this._point = 3;
        this._x5 = x3, this._y5 = y3;
        break;
      default:
        point9(this, x3, y3);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var catmullRomClosed_default2 = function custom22(alpha) {
  function catmullRom(context) {
    return alpha ? new CatmullRomClosed2(context, alpha) : new CardinalClosed2(context, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom22(+alpha2);
  };
  return catmullRom;
}(0.5);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/catmullRomOpen.js
function CatmullRomOpen2(context, alpha) {
  this._context = context;
  this._alpha = alpha;
}
CatmullRomOpen2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
    this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
  },
  lineEnd: function() {
    if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) {
      var x23 = this._x2 - x3, y23 = this._y2 - y3;
      this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
    }
    switch (this._point) {
      case 0:
        this._point = 1;
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
        break;
      case 3:
        this._point = 4;
      default:
        point9(this, x3, y3);
        break;
    }
    this._l01_a = this._l12_a, this._l12_a = this._l23_a;
    this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
    this._x0 = this._x1, this._x1 = this._x2, this._x2 = x3;
    this._y0 = this._y1, this._y1 = this._y2, this._y2 = y3;
  }
};
var catmullRomOpen_default2 = function custom23(alpha) {
  function catmullRom(context) {
    return alpha ? new CatmullRomOpen2(context, alpha) : new CardinalOpen2(context, 0);
  }
  catmullRom.alpha = function(alpha2) {
    return custom23(+alpha2);
  };
  return catmullRom;
}(0.5);

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/linearClosed.js
function LinearClosed2(context) {
  this._context = context;
}
LinearClosed2.prototype = {
  areaStart: noop_default2,
  areaEnd: noop_default2,
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._point) this._context.closePath();
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    if (this._point) this._context.lineTo(x3, y3);
    else this._point = 1, this._context.moveTo(x3, y3);
  }
};

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/monotone.js
function sign2(x3) {
  return x3 < 0 ? -1 : 1;
}
function slope32(that, x22, y22) {
  var h0 = that._x1 - that._x0, h1 = x22 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y22 - that._y1) / (h1 || h0 < 0 && -0), p = (s0 * h1 + s1 * h0) / (h0 + h1);
  return (sign2(s0) + sign2(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
}
function slope22(that, t) {
  var h = that._x1 - that._x0;
  return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
}
function point10(that, t03, t13) {
  var x06 = that._x0, y06 = that._y0, x13 = that._x1, y13 = that._y1, dx = (x13 - x06) / 3;
  that._context.bezierCurveTo(x06 + dx, y06 + dx * t03, x13 - dx, y13 - dx * t13, x13, y13);
}
function MonotoneX2(context) {
  this._context = context;
}
MonotoneX2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    switch (this._point) {
      case 2:
        this._context.lineTo(this._x1, this._y1);
        break;
      case 3:
        point10(this, this._t0, slope22(this, this._t0));
        break;
    }
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    var t13 = NaN;
    x3 = +x3, y3 = +y3;
    if (x3 === this._x1 && y3 === this._y1) return;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
        break;
      case 2:
        this._point = 3;
        point10(this, slope22(this, t13 = slope32(this, x3, y3)), t13);
        break;
      default:
        point10(this, this._t0, t13 = slope32(this, x3, y3));
        break;
    }
    this._x0 = this._x1, this._x1 = x3;
    this._y0 = this._y1, this._y1 = y3;
    this._t0 = t13;
  }
};
function MonotoneY2(context) {
  this._context = new ReflectContext2(context);
}
(MonotoneY2.prototype = Object.create(MonotoneX2.prototype)).point = function(x3, y3) {
  MonotoneX2.prototype.point.call(this, y3, x3);
};
function ReflectContext2(context) {
  this._context = context;
}
ReflectContext2.prototype = {
  moveTo: function(x3, y3) {
    this._context.moveTo(y3, x3);
  },
  closePath: function() {
    this._context.closePath();
  },
  lineTo: function(x3, y3) {
    this._context.lineTo(y3, x3);
  },
  bezierCurveTo: function(x13, y13, x22, y22, x3, y3) {
    this._context.bezierCurveTo(y13, x13, y22, x22, y3, x3);
  }
};

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/natural.js
function Natural2(context) {
  this._context = context;
}
Natural2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = [];
    this._y = [];
  },
  lineEnd: function() {
    var x3 = this._x, y3 = this._y, n = x3.length;
    if (n) {
      this._line ? this._context.lineTo(x3[0], y3[0]) : this._context.moveTo(x3[0], y3[0]);
      if (n === 2) {
        this._context.lineTo(x3[1], y3[1]);
      } else {
        var px = controlPoints2(x3), py = controlPoints2(y3);
        for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
          this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x3[i1], y3[i1]);
        }
      }
    }
    if (this._line || this._line !== 0 && n === 1) this._context.closePath();
    this._line = 1 - this._line;
    this._x = this._y = null;
  },
  point: function(x3, y3) {
    this._x.push(+x3);
    this._y.push(+y3);
  }
};
function controlPoints2(x3) {
  var i, n = x3.length - 1, m2, a4 = new Array(n), b = new Array(n), r = new Array(n);
  a4[0] = 0, b[0] = 2, r[0] = x3[0] + 2 * x3[1];
  for (i = 1; i < n - 1; ++i) a4[i] = 1, b[i] = 4, r[i] = 4 * x3[i] + 2 * x3[i + 1];
  a4[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x3[n - 1] + x3[n];
  for (i = 1; i < n; ++i) m2 = a4[i] / b[i - 1], b[i] -= m2, r[i] -= m2 * r[i - 1];
  a4[n - 1] = r[n - 1] / b[n - 1];
  for (i = n - 2; i >= 0; --i) a4[i] = (r[i] - a4[i + 1]) / b[i];
  b[n - 1] = (x3[n] + a4[n - 1]) / 2;
  for (i = 0; i < n - 1; ++i) b[i] = 2 * x3[i + 1] - a4[i + 1];
  return [a4, b];
}

// node_modules/d3-sankey/node_modules/d3-shape/src/curve/step.js
function Step2(context, t) {
  this._context = context;
  this._t = t;
}
Step2.prototype = {
  areaStart: function() {
    this._line = 0;
  },
  areaEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._x = this._y = NaN;
    this._point = 0;
  },
  lineEnd: function() {
    if (0 < this._t && this._t < 1 && this._point === 2) this._context.lineTo(this._x, this._y);
    if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
    if (this._line >= 0) this._t = 1 - this._t, this._line = 1 - this._line;
  },
  point: function(x3, y3) {
    x3 = +x3, y3 = +y3;
    switch (this._point) {
      case 0:
        this._point = 1;
        this._line ? this._context.lineTo(x3, y3) : this._context.moveTo(x3, y3);
        break;
      case 1:
        this._point = 2;
      default: {
        if (this._t <= 0) {
          this._context.lineTo(this._x, y3);
          this._context.lineTo(x3, y3);
        } else {
          var x13 = this._x * (1 - this._t) + x3 * this._t;
          this._context.lineTo(x13, this._y);
          this._context.lineTo(x13, y3);
        }
        break;
      }
    }
    this._x = x3, this._y = y3;
  }
};

// node_modules/@unovis/ts/data-models/graph.js
var GraphDataModel = class extends CoreDataModel {
  constructor() {
    super(...arguments);
    this._nodes = [];
    this._links = [];
    this._inputNodesMap = /* @__PURE__ */ new Map();
    this._nodeIds = /* @__PURE__ */ new Map();
    this.nodeId = (n) => isString(n.id) || isFinite(n.id) ? `${n.id}` : void 0;
    this.linkId = (l) => isString(l.id) || isFinite(l.id) ? `${l.id}` : void 0;
  }
  getNodeFromId(id2) {
    return this._nodeIds.get(id2);
  }
  get data() {
    return this._data;
  }
  set data(inputData) {
    var _a, _b;
    if (!inputData)
      return;
    this._data = inputData;
    const prevNodes = this.nodes;
    const prevLinks = this.links;
    this._inputNodesMap.clear();
    this._nodeIds.clear();
    const nodes4 = cloneDeep((_a = inputData === null || inputData === void 0 ? void 0 : inputData.nodes) !== null && _a !== void 0 ? _a : []);
    const links5 = cloneDeep((_b = inputData === null || inputData === void 0 ? void 0 : inputData.links) !== null && _b !== void 0 ? _b : []);
    this.transferState(nodes4, prevNodes, this.nodeId);
    this.transferState(links5, prevLinks, this.linkId);
    nodes4.forEach((node4, i) => {
      node4._index = i;
      node4._id = this.nodeId(node4) || `${i}`;
      this._inputNodesMap.set(node4, inputData.nodes[i]);
      this._nodeIds.set(node4._id, node4);
    });
    if (isFunction(this.nodeSort))
      nodes4.sort(this.nodeSort);
    links5.forEach((link7, i) => {
      link7._indexGlobal = i;
      link7.source = this.findNode(nodes4, link7.source);
      link7.target = this.findNode(nodes4, link7.target);
    });
    links5.forEach((link7, i) => {
      if (!isUndefined(link7._index) && !isUndefined(link7._neighbours))
        return;
      const linksFiltered = links5.filter((l) => link7.source === l.source && link7.target === l.target || link7.source === l.target && link7.target === l.source);
      linksFiltered.forEach((l, i2) => {
        var _a2, _b2;
        l._index = i2;
        l._id = this.linkId(l) || `${(_a2 = l.source) === null || _a2 === void 0 ? void 0 : _a2._id}-${(_b2 = l.target) === null || _b2 === void 0 ? void 0 : _b2._id}-${i2}`;
        l._neighbours = linksFiltered.length;
        l._direction = link7.source === l.source && link7.target === l.target ? 1 : -1;
      });
    });
    nodes4.forEach((d) => {
      d.links = links5.filter((l) => l.source === d || l.target === d);
      d._isConnected = d.links.length !== 0;
    });
    this._nonConnectedNodes = nodes4.filter((d) => !d._isConnected);
    this._connectedNodes = without(nodes4, ...this._nonConnectedNodes);
    this._nodes = nodes4;
    this._links = links5.filter((l) => l.source && l.target);
  }
  get nodes() {
    return this._nodes;
  }
  get links() {
    return this._links;
  }
  get connectedNodes() {
    return this._connectedNodes;
  }
  get nonConnectedNodes() {
    return this._nonConnectedNodes;
  }
  findNode(nodes4, nodeIdentifier) {
    let foundNode;
    if (isNumber(nodeIdentifier))
      foundNode = nodes4[nodeIdentifier];
    else if (isString(nodeIdentifier))
      foundNode = nodes4.find((node4) => this.nodeId(node4) === nodeIdentifier);
    else if (isObject(nodeIdentifier))
      foundNode = nodes4.find((node4) => isEqual(this._inputNodesMap.get(node4), nodeIdentifier));
    if (!foundNode) {
      console.warn(`Node ${nodeIdentifier} is missing from the nodes list`);
    }
    return foundNode;
  }
  transferState(items2, itemsPrev, getId) {
    for (const item4 of items2) {
      const dPrev = itemsPrev.find((dp) => getId(dp) === getId(item4));
      if (dPrev)
        item4._state = Object.assign({}, dPrev._state);
      else
        item4._state = {};
    }
  }
};

// node_modules/@unovis/ts/components/sankey/types.js
var SankeySubLabelPlacement;
(function(SankeySubLabelPlacement2) {
  SankeySubLabelPlacement2["Inline"] = "inline";
  SankeySubLabelPlacement2["Below"] = "below";
})(SankeySubLabelPlacement || (SankeySubLabelPlacement = {}));
var SankeyNodeAlign;
(function(SankeyNodeAlign2) {
  SankeyNodeAlign2["Left"] = "left";
  SankeyNodeAlign2["Right"] = "right";
  SankeyNodeAlign2["Center"] = "center";
  SankeyNodeAlign2["Justify"] = "justify";
})(SankeyNodeAlign || (SankeyNodeAlign = {}));
var SankeyLayout = {
  [SankeyNodeAlign.Left]: left2,
  [SankeyNodeAlign.Right]: right2,
  [SankeyNodeAlign.Center]: center2,
  [SankeyNodeAlign.Justify]: justify
};
var SankeyExitTransitionType;
(function(SankeyExitTransitionType2) {
  SankeyExitTransitionType2["Default"] = "default";
  SankeyExitTransitionType2["ToAncestor"] = "to ancestor";
})(SankeyExitTransitionType || (SankeyExitTransitionType = {}));
var SankeyEnterTransitionType;
(function(SankeyEnterTransitionType2) {
  SankeyEnterTransitionType2["Default"] = "default";
  SankeyEnterTransitionType2["FromAncestor"] = "from ancestor";
})(SankeyEnterTransitionType || (SankeyEnterTransitionType = {}));

// node_modules/@unovis/ts/components/sankey/config.js
var SankeyDefaultConfig = Object.assign(Object.assign({}, ComponentDefaultConfig), {
  heightNormalizationCoeff: 1 / 16,
  exitTransitionType: SankeyExitTransitionType.Default,
  enterTransitionType: SankeyEnterTransitionType.Default,
  id: (d, i) => {
    var _a;
    return (_a = d._id) !== null && _a !== void 0 ? _a : `${i}`;
  },
  highlightSubtreeOnHover: false,
  highlightDuration: 300,
  highlightDelay: 1e3,
  iterations: 32,
  nodeSort: void 0,
  nodeWidth: 25,
  nodeAlign: SankeyNodeAlign.Justify,
  nodeHorizontalSpacing: 150,
  nodeMinHeight: 20,
  nodeMaxHeight: 100,
  nodePadding: 2,
  nodeColor: (d) => d.color,
  nodeFixedValue: (d) => d.fixedValue,
  showSingleNode: true,
  nodeCursor: void 0,
  nodeIcon: void 0,
  nodeIconColor: void 0,
  label: (d) => d.label,
  labelPosition: Position.Auto,
  labelVerticalAlign: VerticalAlign.Middle,
  labelBackground: false,
  labelTextSeparator: [" ", "-"],
  labelFit: FitMode.Trim,
  labelTrimMode: TrimMode.Middle,
  labelForceWordBreak: true,
  labelFontSize: void 0,
  labelCursor: void 0,
  labelColor: void 0,
  labelMaxWidth: 70,
  labelExpandTrimmedOnHover: true,
  labelVisibility: void 0,
  subLabel: void 0,
  subLabelFontSize: void 0,
  subLabelColor: void 0,
  subLabelPlacement: SankeySubLabelPlacement.Below,
  subLabelToLabelInlineWidthRatio: 0.4,
  linkValue: (d) => d.value,
  linkColor: (d) => d.color,
  linkCursor: void 0,
  // https://stackoverflow.com/a/21648197/2040291
  init: function() {
    this.linkSort = (link22, link1) => getNumber(link1, this.linkValue) - getNumber(link22, this.linkValue);
    delete this.init;
    return this;
  }
}).init();

// node_modules/@unovis/ts/components/sankey/style.js
var style_exports11 = {};
__export(style_exports11, {
  SANKEY_ICON_SIZE: () => SANKEY_ICON_SIZE,
  background: () => background2,
  forceShow: () => forceShow,
  hidden: () => hidden2,
  label: () => label5,
  labelBackground: () => labelBackground,
  labelGroup: () => labelGroup,
  labelTrimmed: () => labelTrimmed,
  link: () => link2,
  linkPath: () => linkPath,
  linkSelectionHelper: () => linkSelectionHelper,
  links: () => links,
  node: () => node,
  nodeExit: () => nodeExit,
  nodeGroup: () => nodeGroup,
  nodeIcon: () => nodeIcon,
  nodes: () => nodes,
  root: () => root13,
  sublabel: () => sublabel,
  variables: () => variables5
});
var SANKEY_ICON_SIZE = 22;
var root13 = css`
  label: sankey-component;
`;
var variables5 = injectGlobal`
  :root {
     /* Links */
    --vis-sankey-link-cursor: default;
    --vis-sankey-link-color: var(--vis-color-main-light);
    --vis-sankey-link-opacity: 0.5;
    --vis-sankey-link-hover-opacity: 1.0;
    /* Nodes */
    --vis-sankey-node-cursor: default;
    --vis-sankey-node-color: var(--vis-color-main);
    --vis-sankey-node-label-color: #575c65;
    --vis-sankey-node-opacity: 0.9;
    --vis-sankey-node-hover-opacity: 1.0;
    /* Node Labels */
    --vis-sankey-node-label-background-fill-color: #ffffff;
    --vis-sankey-node-label-background-stroke-color: #eaeaea;
    --vis-sankey-node-label-background-opacity: 0.9;
    --vis-sankey-node-label-color: #575c65;
    --vis-sankey-node-label-cursor: default;
    --vis-sankey-node-label-font-weight: 600;
    --vis-sankey-node-label-font-size: 12px;
    --vis-sankey-node-label-text-decoration: none;

    --vis-sankey-node-sublabel-font-size: 10px;
    --vis-sankey-node-sublabel-font-weight: 500;

    /* Icons */
    --vis-sankey-icon-size: ${SANKEY_ICON_SIZE}px;
    --vis-sankey-icon-color: #ffffff;
    --vis-sankey-icon-stroke-opacity: 0.6;
    --vis-sankey-icon-font-family: ${UNOVIS_ICON_FONT_FAMILY_DEFAULT};

    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-sankey-label-font-family: */

    /* Dark Theme */
    --vis-dark-sankey-link-color: var(--vis-color-main-dark);
    --vis-dark-sankey-node-color: var(--vis-color-main);
    --vis-dark-sankey-node-label-color: #eaeaea;
    --vis-dark-sankey-node-label-background-fill-color: #292b34;
    --vis-dark-sankey-node-label-background-stroke-color: #575c65;
    --vis-dark-sankey-icon-color: #292b34;
  }

  body.theme-dark ${`.${root13}`} {
    --vis-sankey-node-color: var(--vis-dark-sankey-node-color);
    --vis-sankey-link-color: var(--vis-dark-sankey-link-color);
    --vis-sankey-node-label-color: var(--vis-dark-sankey-node-label-color);
    --vis-sankey-node-label-background-fill-color: var(--vis-dark-sankey-label-background-fill-color);
    --vis-sankey-node-label-background-stroke-color: var(--vis-dark-sankey-label-background-stroke-color);
    --vis-sankey-icon-color: var(--vis-dark-sankey-icon-color);
  }
`;
var links = css`
  label: links;
`;
var nodes = css`
  label: nodes;
`;
var link2 = css`
  label: link;

  path {
    cursor: var(--vis-sankey-link-cursor);
    fill: var(--vis-sankey-link-color);
    fill-opacity: var(--vis-sankey-link-opacity);
  }

  &:hover {
    path {
      fill-opacity: var(--vis-sankey-link-hover-opacity);
    }
  }
`;
var linkPath = css`
  label: visible;
`;
var linkSelectionHelper = css`
  label: transparent;
  opacity: 0;
`;
var labelGroup = css`
  label: label-group;
  cursor: var(--vis-sankey-node-label-cursor);
`;
var labelTrimmed = css`
  label: label-trimmed;
`;
var label5 = css`
  label: label;
  dominant-baseline: hanging;

  fill: var(--vis-sankey-node-label-color);
  text-decoration: var(--vis-sankey-node-label-text-decoration);
  font-weight: var(--vis-sankey-node-label-font-weight);
  user-select: none;

  &, tspan {
    font-family: var(--vis-sankey-label-font-family, var(--vis-font-family));
    dominant-baseline: hanging;
  }
`;
var sublabel = css`
  label: sub-label;
  dominant-baseline: hanging;

  fill: var(--vis-sankey-node-label-color);
  user-select: none;

  &, tspan {
    font-family: var(--vis-sankey-label-font-family, var(--vis-font-family));
    font-weight: var(--vis-sankey-node-sublabel-font-weight);
    dominant-baseline: hanging;
  }
`;
var labelBackground = css`
  label: label-background;
  stroke: var(--vis-sankey-node-label-background-stroke-color);
  fill: var(--vis-sankey-node-label-background-fill-color);
  opacity: var(--vis-sankey-node-label-background-opacity);
`;
var hidden2 = css`
  label: hidden;
  visibility: hidden;
`;
var forceShow = css`
  label: forceShow;
  visibility: visible;
`;
var nodeGroup = css`
  label: node-group;
`;
var node = css`
  label: node;

  cursor: var(--vis-sankey-node-cursor);
  fill: var(--vis-sankey-node-color);
  opacity: var(--vis-sankey-node-opacity);

  &:hover {
    opacity: var(--vis-sankey-node-hover-opacity);
  }
`;
var nodeIcon = css`
  label: icon;

  font-family: var(--vis-sankey-icon-font-family);
  text-anchor: middle;
  font-size: var(--vis-sankey-icon-size);
  fill: var(--vis-sankey-node-icon-color);
  stroke: var(--vis-sankey-node-color);
  stroke-opacity: var(--vis-sankey-icon-stroke-opacity);
  user-select: none;
  pointer-events: none;
`;
var nodeExit = css`
  label: node-exit;
`;
var background2 = css`
  label: background;
`;

// node_modules/@unovis/ts/components/sankey/modules/link.js
function linkPath2({ x0: x06, x1: x13, y0: y06, y1: y13, width }) {
  const top0 = y06 - width / 2;
  const top1 = y13 - width / 2;
  const bottom0 = y06 + width / 2;
  const bottom1 = y13 + width / 2;
  const centerX = (x06 + x13) / 2;
  return `
    M ${x06}, ${top0}

    C ${centerX}, ${top0}
      ${centerX}, ${top1}
      ${x13}, ${top1}

    L ${x13}, ${bottom1}

    C ${centerX}, ${bottom1}
      ${centerX}, ${bottom0}
      ${x06}, ${bottom0}
    z
  `;
}
function createLinks(sel) {
  sel.append("path").attr("class", linkPath).attr("d", (d, i, el) => {
    el[i]._animState = {
      x0: d.source.x1,
      x1: d.target.x0,
      y0: d.y0,
      y1: d.y1,
      width: Math.max(1, d.width)
    };
    return linkPath2(el[i]._animState);
  });
  sel.append("path").attr("class", linkSelectionHelper);
  sel.style("opacity", 0);
}
function updateLinks(sel, config, duration) {
  smartTransition(sel, duration).style("opacity", (d) => d._state.greyout ? 0.2 : 1);
  const linkSelection = sel.select(`.${linkPath}`).style("cursor", (d) => getString(d, config.linkCursor));
  const selectionTransition = smartTransition(linkSelection, duration).style("fill", (link7) => getColor(link7, config.linkColor));
  if (duration) {
    selectionTransition.attrTween("d", (d, i, el) => {
      const previous = el[i]._animState;
      const next = {
        x0: d.source.x1,
        x1: d.target.x0,
        y0: d.y0,
        y1: d.y1,
        width: Math.max(1, d.width)
      };
      const interpolator = {
        x0: number_default(previous.x0, next.x0),
        x1: number_default(previous.x1, next.x1),
        y0: number_default(previous.y0, next.y0),
        y1: number_default(previous.y1, next.y1),
        width: number_default(previous.width, next.width)
      };
      el[i]._animState = next;
      return function(t) {
        return linkPath2({
          x0: interpolator.x0(t),
          x1: interpolator.x1(t),
          y0: interpolator.y0(t),
          y1: interpolator.y1(t),
          width: interpolator.width(t)
        });
      };
    });
  } else {
    linkSelection.attr("d", (d) => linkPath2({
      x0: d.source.x1,
      x1: d.target.x0,
      y0: d.y0,
      y1: d.y1,
      width: Math.max(1, d.width)
    }));
  }
  sel.select(`.${linkSelectionHelper}`).attr("d", (d) => linkPath2({
    x0: d.source.x1,
    x1: d.target.x0,
    y0: d.y0,
    y1: d.y1,
    width: Math.max(10, d.width)
  })).style("cursor", (d) => getString(d, config.linkCursor));
}
function removeLinks(sel) {
  sel.remove();
}

// node_modules/@unovis/ts/components/sankey/modules/label.js
var NODE_LABEL_SPACING = 10;
var LABEL_BLOCK_PADDING = 6.5;
function getLabelBackground(width, height, orientation, arrowWidth = 5, arrowHeight = 8) {
  const halfHeight = height / 2;
  const halfArrowHeight = arrowHeight / 2;
  if (orientation === Position.Left) {
    const rightArrowPos = `L 0 ${halfHeight - halfArrowHeight}   L   ${+arrowWidth} ${halfHeight} L 0 ${halfHeight + halfArrowHeight}`;
    return `
      M 0 0
      ${rightArrowPos}
      L 0  ${height}
      L ${-width} ${height}
      L ${-width} 0
      L 0 0 `;
  } else {
    const leftArrowPos = `L 0 ${halfHeight - halfArrowHeight}   L   ${-arrowWidth} ${halfHeight} L 0 ${halfHeight + halfArrowHeight}`;
    return `
      M 0 0
      ${leftArrowPos}
      L 0  ${height}
      L ${width} ${height}
      L ${width} 0
      L 0 0 `;
  }
}
function getLabelOrientation(d, sankeyWidth, labelPosition) {
  let orientation = getValue(d, labelPosition);
  if (orientation === Position.Auto || !orientation) {
    orientation = d.x0 < sankeyWidth / 2 ? Position.Left : Position.Right;
  }
  return orientation;
}
var requiredLabelSpace = (labelWidth, labelFontSize) => {
  return {
    height: labelFontSize * 2.5 + 2 * LABEL_BLOCK_PADDING,
    width: labelWidth + 2 * NODE_LABEL_SPACING + 2 * LABEL_BLOCK_PADDING
  };
};
function getLabelGroupXTranslate(d, config, width) {
  const orientation = getLabelOrientation(d, width, config.labelPosition);
  switch (orientation) {
    case Position.Right:
      return config.nodeWidth + NODE_LABEL_SPACING;
    case Position.Left:
    default:
      return -NODE_LABEL_SPACING;
  }
}
function getLabelGroupYTranslate(d, labelGroupHeight, config) {
  const nodeHeight = d.y1 - d.y0;
  if (config.labelBackground && nodeHeight < labelGroupHeight)
    return (nodeHeight - labelGroupHeight) / 2;
  switch (config.labelVerticalAlign) {
    case VerticalAlign.Bottom:
      return nodeHeight - labelGroupHeight;
    case VerticalAlign.Middle:
      return nodeHeight / 2 - labelGroupHeight / 2;
    case VerticalAlign.Top:
    default:
      return 0;
  }
}
function getLabelTextAnchor(d, config, width) {
  const orientation = getLabelOrientation(d, width, config.labelPosition);
  switch (orientation) {
    case Position.Right:
      return "start";
    case Position.Left:
    default:
      return "end";
  }
}
function getSubLabelTextAnchor(d, config, width) {
  const isSublabelInline = config.subLabelPlacement === SankeySubLabelPlacement.Inline;
  const orientation = getLabelOrientation(d, width, config.labelPosition);
  switch (orientation) {
    case Position.Right:
      return isSublabelInline ? "end" : "start";
    case Position.Left:
    default:
      return isSublabelInline ? "start" : "end";
  }
}
function renderLabel(labelGroup3, d, config, width, duration, forceExpand = false) {
  var _a, _b;
  const labelTextSelection = labelGroup3.select(`.${label5}`);
  const labelShowBackground = config.labelBackground || forceExpand;
  const sublabelTextSelection = labelGroup3.select(`.${sublabel}`);
  const labelPadding = labelShowBackground ? LABEL_BLOCK_PADDING : 0;
  const isSublabelInline = config.subLabelPlacement === SankeySubLabelPlacement.Inline;
  const separator = config.labelForceWordBreak ? "" : config.labelTextSeparator;
  const fastEstimatesMode = true;
  const fontWidthToHeightRatio = 0.52;
  const dy = 0.32;
  const labelOrientation = getLabelOrientation(d, width, config.labelPosition);
  const labelOrientationMult = labelOrientation === Position.Left ? -1 : 1;
  const labelText4 = getString(d, config.label);
  const sublabelText = getString(d, config.subLabel);
  let wasTrimmed = false;
  const labelFontSize = (_a = config.labelFontSize) !== null && _a !== void 0 ? _a : getCSSVariableValueInPixels("var(--vis-sankey-node-label-font-size)", labelGroup3.node());
  const subLabelFontSize = (_b = config.subLabelFontSize) !== null && _b !== void 0 ? _b : getCSSVariableValueInPixels("var(--vis-sankey-node-sublabel-font-size)", labelGroup3.node());
  const labelsFontSizeDifference = sublabelText ? labelFontSize - subLabelFontSize : 0;
  const labelTranslateY = labelPadding + (isSublabelInline && labelsFontSizeDifference < 0 ? -0.6 * labelsFontSizeDifference : 0);
  labelTextSelection.text(labelText4).attr("font-size", labelFontSize).style("fill", getColor(d, config.labelColor)).attr("transform", `translate(${labelOrientationMult * labelPadding},${labelTranslateY})`).style("cursor", (d2) => getString(d2, config.labelCursor));
  const labelMaxWidth = isSublabelInline ? config.labelMaxWidth * (1 - (sublabelText ? config.subLabelToLabelInlineWidthRatio : 0)) : config.labelMaxWidth;
  if (config.labelFit === FitMode.Wrap || forceExpand)
    wrapSVGText(labelTextSelection, labelMaxWidth, separator);
  else
    wasTrimmed = trimSVGText(labelTextSelection, labelMaxWidth, config.labelTrimMode, fastEstimatesMode, labelFontSize, fontWidthToHeightRatio);
  const labelSize = estimateTextSize(labelTextSelection, labelFontSize, dy, fastEstimatesMode, fontWidthToHeightRatio);
  const sublabelTranslateX = labelOrientationMult * (labelPadding + (isSublabelInline ? config.labelMaxWidth : 0));
  const sublabelMarginTop = 0;
  const sublabelTranslateY = labelPadding + (isSublabelInline ? labelsFontSizeDifference > 0 ? 0.6 * labelsFontSizeDifference : 0 : labelSize.height + sublabelMarginTop);
  sublabelTextSelection.text(sublabelText).attr("font-size", subLabelFontSize).style("fill", getColor(d, config.subLabelColor)).attr("transform", `translate(${sublabelTranslateX},${sublabelTranslateY})`).style("cursor", (d2) => getString(d2, config.labelCursor));
  const sublabelMaxWidth = isSublabelInline ? config.labelMaxWidth * config.subLabelToLabelInlineWidthRatio : config.labelMaxWidth;
  if (config.labelFit === FitMode.Wrap || forceExpand)
    wrapSVGText(sublabelTextSelection, sublabelMaxWidth, separator);
  else
    wasTrimmed = wasTrimmed || trimSVGText(sublabelTextSelection, sublabelMaxWidth, config.labelTrimMode, fastEstimatesMode, subLabelFontSize, fontWidthToHeightRatio);
  labelGroup3.classed(labelTrimmed, wasTrimmed);
  const sublabelSize = estimateTextSize(sublabelTextSelection, subLabelFontSize, dy, fastEstimatesMode, fontWidthToHeightRatio);
  const labelGroupHeight = (isSublabelInline ? Math.max(labelSize.height, sublabelSize.height) : labelSize.height + sublabelSize.height) + 2 * labelPadding;
  const labelBackground$1 = labelGroup3.select(`.${labelBackground}`);
  labelBackground$1.attr("d", labelShowBackground ? getLabelBackground(config.labelMaxWidth + 2 * labelPadding, labelGroupHeight, labelOrientation) : null);
  const labelTextAnchor = getLabelTextAnchor(d, config, width);
  const sublabelTextAnchor = getSubLabelTextAnchor(d, config, width);
  const xTranslate = getLabelGroupXTranslate(d, config, width);
  const yTranslate = getLabelGroupYTranslate(d, labelGroupHeight, config);
  labelTextSelection.attr("text-anchor", labelTextAnchor);
  sublabelTextSelection.attr("text-anchor", sublabelTextAnchor);
  const hasTransform = !!labelGroup3.attr("transform");
  smartTransition(labelGroup3, hasTransform ? duration : 0).attr("transform", `translate(${xTranslate},${yTranslate})`);
  return {
    x: d.x0 + xTranslate,
    y: d.y0 + yTranslate,
    width: config.labelMaxWidth,
    height: labelGroupHeight,
    layer: d.layer,
    selection: labelGroup3
  };
}

// node_modules/@unovis/ts/components/sankey/modules/node.js
function createNodes(sel, config, width, bleed) {
  const { enterTransitionType } = config;
  sel.append("rect").attr("class", node).attr("width", config.nodeWidth).attr("height", (d) => d.y1 - d.y0).style("fill", (node4) => getColor(node4, config.nodeColor));
  const labelGroup$1 = sel.append("g").attr("class", labelGroup);
  labelGroup$1.append("path").attr("class", labelBackground);
  labelGroup$1.append("text").attr("class", label5);
  labelGroup$1.append("text").attr("class", sublabel);
  sel.append("text").attr("class", nodeIcon).attr("text-anchor", "middle").attr("dy", "0.5px");
  sel.attr("transform", (d) => {
    var _a;
    const x3 = enterTransitionType === SankeyEnterTransitionType.FromAncestor && ((_a = d.targetLinks) === null || _a === void 0 ? void 0 : _a[0]) ? d.targetLinks[0].source.x0 : d.x0;
    return `translate(${sel.size() === 1 ? width * 0.5 - bleed.left : x3}, ${d.y0})`;
  }).style("opacity", 0);
}
function getNodeXPos(d, config, width, bleed, hasLinks) {
  if (hasLinks)
    return d.x0;
  switch (config.nodeAlign) {
    case SankeyNodeAlign.Left:
      return d.x0;
    case SankeyNodeAlign.Right:
      return width - bleed.right;
    case SankeyNodeAlign.Center:
    case SankeyNodeAlign.Justify:
    default:
      return width * 0.5 - bleed.left;
  }
}
function updateNodes(sel, config, width, bleed, hasLinks, duration) {
  smartTransition(sel, duration).attr("transform", (d) => `translate(${getNodeXPos(d, config, width, bleed, hasLinks)},${d.y0})`).style("opacity", (d) => d._state.greyout ? 0.2 : 1);
  smartTransition(sel.select(`.${node}`), duration).attr("width", config.nodeWidth).attr("height", (d) => d.y1 - d.y0).style("cursor", (d) => getString(d, config.nodeCursor)).style("fill", (d) => getColor(d, config.nodeColor));
  renderNodeLabels(sel, config, width, duration);
  const nodeIcon$1 = sel.select(`.${nodeIcon}`);
  if (config.nodeIcon) {
    nodeIcon$1.attr("visibility", null).attr("text-anchor", "middle").style("dominant-baseline", "central").style("stroke", (d) => getColor(d, config.nodeIconColor)).style("fill", (d) => getColor(d, config.nodeIconColor)).style("font-size", (d) => {
      const nodeHeight = d.y1 - d.y0;
      return nodeHeight < SANKEY_ICON_SIZE ? `${nodeHeight * 0.65}px` : null;
    }).html((d) => getString(d, config.nodeIcon));
    smartTransition(nodeIcon$1, duration).attr("x", config.nodeWidth / 2).attr("y", (d) => (d.y1 - d.y0) / 2);
  } else {
    nodeIcon$1.attr("visibility", "hidden");
  }
}
function renderNodeLabels(sel, config, width, duration, enforceNodeVisibility) {
  const labelGroupSelection = sel.select(`.${labelGroup}`);
  const labelGroupEls = labelGroupSelection.nodes() || [];
  const labelGroupBBoxes = labelGroupEls.map((g) => {
    const gSelection = select_default2(g);
    const datum2 = gSelection.datum();
    return renderLabel(gSelection, datum2, config, width, duration, enforceNodeVisibility === datum2);
  });
  if (config.labelVisibility) {
    for (const b of labelGroupBBoxes) {
      const datum2 = b.selection.datum();
      const box = { x: b.x, y: b.y, width: b.width, height: b.height };
      b.hidden = !config.labelVisibility(datum2, box, enforceNodeVisibility === datum2);
    }
  } else {
    const maxLayer = Math.max(...labelGroupBBoxes.map((b) => b.layer));
    for (let layer = 0; layer <= maxLayer; layer += 1) {
      const boxes = labelGroupBBoxes.filter((b) => b.layer === layer);
      boxes.sort((a4, b) => a4.y - b.y);
      let lastVisibleIdx = 0;
      for (let i = 1; i < boxes.length; i += 1) {
        const b02 = boxes[lastVisibleIdx];
        const b12 = boxes[i];
        const shouldBeHidden = b12.y < b02.y + b02.height;
        if (shouldBeHidden) {
          if (b12.selection.datum() === enforceNodeVisibility)
            b02.hidden = true;
          else
            b12.hidden = true;
        }
        if (!b12.hidden)
          lastVisibleIdx = i;
      }
    }
  }
  for (const b of labelGroupBBoxes) {
    b.selection.classed(hidden2, b.hidden);
  }
}
function removeNodes(selection2, config, duration) {
  const { exitTransitionType } = config;
  selection2.each((d, i, els) => {
    var _a;
    const node4 = select_default2(els[i]);
    const transition2 = smartTransition(node4, duration);
    if (exitTransitionType === SankeyExitTransitionType.ToAncestor && ((_a = d.targetLinks) === null || _a === void 0 ? void 0 : _a[0])) {
      transition2.attr("transform", `translate(${d.targetLinks[0].source.x0},${d.y0})`);
    }
    transition2.style("opacity", 0).remove();
  });
}
function onNodeMouseOver(d, nodeSelection2, config, width) {
  const labelGroup$1 = nodeSelection2.raise().select(`.${labelGroup}`);
  if (config.labelExpandTrimmedOnHover && labelGroup$1.classed(labelTrimmed) || labelGroup$1.classed(hidden2)) {
    renderLabel(labelGroup$1, d, config, width, 0, true);
  }
  labelGroup$1.classed(forceShow, true);
}
function onNodeMouseOut(d, nodeSelection2, config, width) {
  const labelGroup$1 = nodeSelection2.select(`.${labelGroup}`);
  if (config.labelExpandTrimmedOnHover || labelGroup$1.classed(hidden2)) {
    renderLabel(labelGroup$1, d, config, width, 0);
  }
  labelGroup$1.classed(forceShow, false);
}

// node_modules/@unovis/ts/components/sankey/index.js
var Sankey2 = class _Sankey extends ComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = SankeyDefaultConfig;
    this.config = this._defaultConfig;
    this.datamodel = new GraphDataModel();
    this._extendedWidth = void 0;
    this._extendedHeight = void 0;
    this._extendedHeightIncreased = void 0;
    this._sankey = Sankey();
    this._highlightTimeoutId = null;
    this._highlightActive = false;
    this.events = {
      [_Sankey.selectors.nodeGroup]: {
        mouseenter: this._onNodeMouseOver.bind(this),
        mouseleave: this._onNodeMouseOut.bind(this)
      },
      [_Sankey.selectors.node]: {
        mouseenter: this._onNodeRectMouseOver.bind(this),
        mouseleave: this._onNodeRectMouseOut.bind(this)
      },
      [_Sankey.selectors.link]: {
        mouseenter: this._onLinkMouseOver.bind(this),
        mouseleave: this._onLinkMouseOut.bind(this)
      }
    };
    if (config)
      this.setConfig(config);
    this._backgroundRect = this.g.append("rect").attr("class", background2);
    this._linksGroup = this.g.append("g").attr("class", links);
    this._nodesGroup = this.g.append("g").attr("class", nodes);
  }
  get bleed() {
    var _a;
    const { config, datamodel: { nodes: nodes4, links: links5 } } = this;
    const labelFontSize = (_a = config.labelFontSize) !== null && _a !== void 0 ? _a : getCSSVariableValueInPixels("var(--vis-sankey-label-font-size)", this.element);
    const labelSize = requiredLabelSpace(config.labelMaxWidth, labelFontSize);
    let left3 = 0;
    let right3 = 0;
    if (nodes4.length) {
      const sankeyProbeSize = 1e3;
      this._populateLinkAndNodeValues();
      this._sankey.size([sankeyProbeSize, sankeyProbeSize]);
      this._sankey({ nodes: nodes4, links: links5 });
      const maxDepth2 = max(nodes4, (d) => d.depth);
      const zeroDepthNodes = nodes4.filter((d) => d.depth === 0);
      const maxDepthNodes = nodes4.filter((d) => d.depth === maxDepth2);
      left3 = zeroDepthNodes.some((d) => getLabelOrientation(d, sankeyProbeSize, config.labelPosition) === Position.Left) ? labelSize.width : 0;
      right3 = maxDepthNodes.some((d) => getLabelOrientation(d, sankeyProbeSize, config.labelPosition) === Position.Right) ? labelSize.width : 0;
    }
    const top2 = config.labelVerticalAlign === VerticalAlign.Top ? 0 : config.labelVerticalAlign === VerticalAlign.Bottom ? labelSize.height : labelSize.height / 2;
    const bottom2 = config.labelVerticalAlign === VerticalAlign.Top ? labelSize.height : config.labelVerticalAlign === VerticalAlign.Bottom ? 0 : labelSize.height / 2;
    return { top: top2, bottom: bottom2, left: left3, right: right3 };
  }
  setData(data) {
    super.setData(data);
    if (this.sizing !== Sizing.Fit || !this._hasLinks())
      this._preCalculateComponentSize();
  }
  setConfig(config) {
    super.setConfig(config);
    if (this.sizing !== Sizing.Fit || !this._hasLinks())
      this._preCalculateComponentSize();
    const nodeId = (d, i) => getString(d, this.config.id, i);
    this._sankey.linkSort(this.config.linkSort);
    this._sankey.nodeId(nodeId).nodeWidth(this.config.nodeWidth).nodePadding(this.config.nodePadding).nodeAlign(SankeyLayout[this.config.nodeAlign]).nodeSort(this.config.nodeSort).iterations(this.config.iterations);
  }
  _render(customDuration) {
    const { config, bleed, datamodel: { nodes: nodes4, links: links5 } } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    if (nodes4.length === 0 || nodes4.length === 1 && links5.length > 0 || nodes4.length === 1 && !config.showSingleNode || nodes4.length > 1 && links5.length === 0) {
      this._linksGroup.selectAll(`.${link2}`).call(removeLinks, duration);
      this._nodesGroup.selectAll(`.${nodeGroup}`).call(removeNodes, config, duration);
    }
    this._prepareLayout();
    smartTransition(this._linksGroup, duration).attr("transform", `translate(${bleed.left},${bleed.top})`);
    const linkSelection = this._linksGroup.selectAll(`.${link2}`).data(links5, (d, i) => {
      var _a;
      return (_a = config.id(d, i)) !== null && _a !== void 0 ? _a : i;
    });
    const linkSelectionEnter = linkSelection.enter().append("g").attr("class", link2);
    linkSelectionEnter.call(createLinks);
    linkSelection.merge(linkSelectionEnter).call(updateLinks, config, duration);
    linkSelection.exit().call(removeLinks);
    smartTransition(this._nodesGroup, duration).attr("transform", `translate(${bleed.left},${bleed.top})`);
    const nodeSelection2 = this._nodesGroup.selectAll(`.${nodeGroup}`).data(nodes4, (d, i) => {
      var _a;
      return (_a = config.id(d, i)) !== null && _a !== void 0 ? _a : i;
    });
    const nodeSelectionEnter = nodeSelection2.enter().append("g").attr("class", nodeGroup);
    nodeSelectionEnter.call(createNodes, this.config, this._width, bleed);
    nodeSelection2.merge(nodeSelectionEnter).call(updateNodes, config, this._width, bleed, this._hasLinks(), duration);
    nodeSelection2.exit().attr("class", nodeExit).call(removeNodes, config, duration);
    this._backgroundRect.attr("width", this.getWidth()).attr("height", this.getHeight()).attr("opacity", 0);
  }
  _populateLinkAndNodeValues() {
    const { config, datamodel } = this;
    const nodes4 = datamodel.nodes;
    const links5 = datamodel.links;
    links5.forEach((link7, i) => {
      link7.value = getNumber(link7, (d) => getNumber(d, config.linkValue, i));
    });
    nodes4.forEach((node4, i) => {
      node4.fixedValue = getNumber(node4, config.nodeFixedValue, i);
    });
  }
  _preCalculateComponentSize() {
    const { bleed, config, datamodel } = this;
    const nodes4 = datamodel.nodes;
    if (nodes4.length) {
      this._populateLinkAndNodeValues();
      this._sankey(datamodel);
    }
    const scaleExtent = extent(nodes4, (d) => d.value || void 0);
    const scaleRange = [config.nodeMinHeight, config.nodeMaxHeight];
    const scale = linear3().domain(scaleExtent).range(scaleRange).clamp(true);
    nodes4.forEach((n) => {
      n._state.precalculatedHeight = scale(n.value) || config.nodeMinHeight;
    });
    const groupedByColumn = groupBy(nodes4, (d) => d.layer);
    const values = Object.values(groupedByColumn).map((group3) => sum(group3.map((n) => n._state.precalculatedHeight + config.nodePadding)) - config.nodePadding);
    const height = max(values) || config.nodeMinHeight;
    this._extendedHeight = height + bleed.top + bleed.bottom;
    this._extendedWidth = Math.max(0, (config.nodeWidth + config.nodeHorizontalSpacing) * Object.keys(groupedByColumn).length - config.nodeHorizontalSpacing + bleed.left + bleed.right);
  }
  _prepareLayout() {
    var _a, _b;
    const { config, bleed, datamodel } = this;
    const isExtendedSize = this.sizing === Sizing.Extend;
    const sankeyHeight = this.sizing === Sizing.Fit ? this._height : this._extendedHeight;
    const sankeyWidth = this.sizing === Sizing.Fit ? this._width : this._extendedWidth;
    this._sankey.size([
      Math.max(sankeyWidth - bleed.left - bleed.right, 0),
      Math.max(sankeyHeight - bleed.top - bleed.bottom, 0)
    ]);
    const nodes4 = datamodel.nodes;
    const links5 = datamodel.links;
    if (!this._hasLinks()) {
      let y3 = 0;
      const nodesTotalHeight = sum(nodes4, (n) => n._state.precalculatedHeight || 1);
      for (const node4 of nodes4) {
        const sankeyHeight2 = this.getHeight() - bleed.top - bleed.bottom;
        const nodeHeight = node4._state.precalculatedHeight || 1;
        const h = isExtendedSize ? nodeHeight : (sankeyHeight2 - config.nodePadding * (nodes4.length - 1)) * nodeHeight / nodesTotalHeight;
        node4.width = Math.max(10, config.nodeWidth);
        node4.x0 = 0;
        node4.x1 = node4.width;
        node4.y0 = y3;
        node4.y1 = y3 + Math.max(1, h);
        node4.layer = 0;
        y3 = node4.y1 + config.nodePadding;
      }
      this._extendedHeightIncreased = void 0;
      return;
    }
    this._populateLinkAndNodeValues();
    this._sankey({ nodes: nodes4, links: links5 });
    for (const node4 of nodes4) {
      const singleExtendedSize = isExtendedSize && !((_a = node4.sourceLinks) === null || _a === void 0 ? void 0 : _a.length) && !((_b = node4.targetLinks) === null || _b === void 0 ? void 0 : _b.length);
      const h = Math.max(singleExtendedSize ? config.nodeMinHeight : 1, node4.y1 - node4.y0);
      const y3 = (node4.y0 + node4.y1) / 2;
      node4.y0 = y3 - h / 2;
      node4.y1 = y3 + h / 2;
    }
    if (isExtendedSize) {
      const height = max(nodes4, (d) => d.y1);
      this._extendedHeightIncreased = height + bleed.top + bleed.bottom;
    }
  }
  getWidth() {
    return this.sizing === Sizing.Fit ? this._width : this._extendedWidth || 0;
  }
  getHeight() {
    return this.sizing === Sizing.Fit ? this._height : Math.max(this._extendedHeightIncreased || 0, this._extendedHeight || 0);
  }
  getLayoutWidth() {
    return this.sizing === Sizing.Fit ? this._width : this._extendedWidth;
  }
  getLayoutHeight() {
    return this.sizing === Sizing.Fit ? this._height : this._extendedHeightIncreased || this._extendedHeight;
  }
  getColumnCenters() {
    const { datamodel } = this;
    const nodes4 = datamodel.nodes;
    const centers = nodes4.reduce((pos, node4) => {
      const idx = node4.layer;
      if (!isFinite(pos[idx])) {
        pos[idx] = (node4.x0 + node4.x1) / 2;
      }
      return pos;
    }, []);
    return centers;
  }
  highlightSubtree(node4) {
    const { config, datamodel } = this;
    clearTimeout(this._highlightTimeoutId);
    this._highlightTimeoutId = setTimeout(() => {
      for (const n of datamodel.nodes)
        n._state.greyout = true;
      for (const l of datamodel.links)
        l._state.greyout = true;
      this.recursiveSetSubtreeState(node4, "sourceLinks", "target", "greyout", false);
      this.recursiveSetSubtreeState(node4, "targetLinks", "source", "greyout", false);
      this._render(config.highlightDuration);
      this._highlightActive = true;
    }, config.highlightDelay);
  }
  recursiveSetSubtreeState(node4, linksKey, nodeKey, key, value2) {
    node4._state[key] = value2;
    for (const l of node4[linksKey]) {
      l._state[key] = value2;
      this.recursiveSetSubtreeState(l[nodeKey], linksKey, nodeKey, key, value2);
    }
  }
  disableHighlight() {
    const { config, datamodel } = this;
    clearTimeout(this._highlightTimeoutId);
    if (this._highlightActive) {
      this._highlightActive = false;
      for (const n of datamodel.nodes)
        n._state.greyout = false;
      for (const l of datamodel.links)
        l._state.greyout = false;
      this._render(config.highlightDuration);
    }
  }
  _hasLinks() {
    const { datamodel } = this;
    return datamodel.links.length > 0;
  }
  _onNodeMouseOver(d, event) {
    onNodeMouseOver(d, select_default2(event.currentTarget), this.config, this._width);
  }
  _onNodeMouseOut(d, event) {
    onNodeMouseOut(d, select_default2(event.currentTarget), this.config, this._width);
  }
  _onNodeRectMouseOver(d) {
    const { config } = this;
    if (config.highlightSubtreeOnHover)
      this.highlightSubtree(d);
  }
  _onNodeRectMouseOut(d) {
    this.disableHighlight();
  }
  _onLinkMouseOver(d, event) {
    const { config } = this;
    if (config.highlightSubtreeOnHover)
      this.highlightSubtree(d.target);
  }
  _onLinkMouseOut(d, event) {
    this.disableHighlight();
  }
};
Sankey2.selectors = style_exports11;

// node_modules/@unovis/ts/components/area/config.js
var AreaDefaultConfig = Object.assign(Object.assign({}, XYComponentDefaultConfig), { color: void 0, curveType: CurveType.MonotoneX, baseline: () => 0, opacity: 1, cursor: null, minHeight1Px: false });

// node_modules/@unovis/ts/components/area/style.js
var style_exports12 = {};
__export(style_exports12, {
  area: () => area,
  globalStyles: () => globalStyles9,
  root: () => root14
});
var root14 = css`
  label: area-component;
`;
var globalStyles9 = injectGlobal`
  :root {
    --vis-area-cursor: default;
    --vis-area-fill-opacity: 1;
    --vis-area-stroke-color: none;
    --vis-area-stroke-width: 0px;
    --vis-area-stroke-dasharray: none;
    --vis-area-stroke-opacity: 1;
    --vis-area-hover-fill-opacity: none;
    --vis-area-hover-stroke-width: none;

    /* Dark Theme */
    --vis-dark-area-stroke-color: none;
  }

  body.theme-dark ${`.${root14}`} {
    --vis-area-stroke-color: var(--vis-dark-area-stroke-color);
  }

`;
var area = css`
  label: area;
  cursor: var(--vis-area-cursor);
  fill-opacity: var(--vis-area-fill-opacity);
  stroke-width: var(--vis-area-stroke-width);
  stroke-dasharray: var(--vis-area-stroke-dasharray);
  stroke: var(--vis-area-stroke-color);
  stroke-opacity: var(--vis-area-stroke-opacity);

  &:hover {
    fill-opacity: var(--vis-area-hover-fill-opacity);
    stroke-width: var(--vis-area-hover-stroke-width);
  }
`;

// node_modules/@unovis/ts/components/area/index.js
var Area = class _Area extends XYComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = AreaDefaultConfig;
    this.config = this._defaultConfig;
    this.stacked = true;
    this.events = {
      [_Area.selectors.area]: {}
    };
    if (config)
      this.setConfig(config);
    this.stacked = Array.isArray(this.config.y);
  }
  _render(customDuration) {
    super._render(customDuration);
    const { config, datamodel: { data } } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const curveGen = Curve[config.curveType];
    this._areaGen = area_default().x((d) => d.x).y0((d) => d.y0).y1((d) => {
      const isSmallerThanPixel = Math.abs(d.y1 - d.y0) < 1;
      return d.y1 - (isSmallerThanPixel && config.minHeight1Px ? 1 : 0);
    }).curve(curveGen);
    const yAccessors = isArray(config.y) ? config.y : [config.y];
    const areaDataX = data.map((d, i) => this.xScale(getNumber(d, config.x, i)));
    const stacked = getStackedData(data, config.baseline, yAccessors, this._prevNegative);
    this._prevNegative = stacked.map((s3) => !!s3.negative);
    const stackedData = stacked.map((arr) => arr.map((d, j) => ({
      y0: this.yScale(d[0]),
      y1: this.yScale(d[1]),
      x: areaDataX[j]
    })));
    const areaMaxIdx = stackedData.length - 1;
    const stackedDataReversed = stackedData.reverse();
    const areas = this.g.selectAll(`.${area}`).data(stackedDataReversed);
    const areasEnter = areas.enter().append("path").attr("class", area).attr("d", (d) => this._areaGen(d) || this._emptyPath()).style("opacity", 0).style("fill", (d, i) => getColor(data, config.color, areaMaxIdx - i));
    const areasMerged = smartTransition(areasEnter.merge(areas), duration).style("opacity", (d, i) => {
      const isDefined = d.some((p) => p.y0 - p.y1 !== 0);
      return isDefined ? getNumber(data, config.opacity, areaMaxIdx - i) : 0;
    }).style("fill", (d, i) => getColor(data, config.color, areaMaxIdx - i)).style("cursor", (d, i) => getString(data, config.cursor, areaMaxIdx - i));
    if (duration) {
      const transition2 = areasMerged;
      transition2.attrTween("d", (d, i, el) => {
        const previous = select_default2(el[i]).attr("d");
        const next = this._areaGen(d) || this._emptyPath();
        return interpolatePath(previous, next);
      });
    } else {
      areasMerged.attr("d", (d) => this._areaGen(d) || this._emptyPath());
    }
    smartTransition(areas.exit(), duration).style("opacity", 0).remove();
  }
  getYDataExtent(scaleByVisibleData) {
    const { config, datamodel } = this;
    const yAccessors = isArray(config.y) ? config.y : [config.y];
    const data = scaleByVisibleData ? filterDataByRange(datamodel.data, this.xScale.domain(), config.x) : datamodel.data;
    return getStackedExtent(data, config.baseline, ...yAccessors);
  }
  _emptyPath() {
    const xRange = this.xScale.range();
    const yDomain = this.yScale.domain();
    const y06 = this.yScale((yDomain[0] + yDomain[1]) / 2);
    const y13 = y06;
    return this._areaGen([
      { y0: y06, y1: y13, x: xRange[0] },
      { y0: y06, y1: y13, x: xRange[1] }
    ]);
  }
};
Area.selectors = style_exports12;

// node_modules/d3-zoom/src/constant.js
var constant_default8 = (x3) => () => x3;

// node_modules/d3-zoom/src/event.js
function ZoomEvent(type2, {
  sourceEvent,
  target,
  transform: transform2,
  dispatch
}) {
  Object.defineProperties(this, {
    type: { value: type2, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    transform: { value: transform2, enumerable: true, configurable: true },
    _: { value: dispatch }
  });
}

// node_modules/d3-zoom/src/transform.js
function Transform(k4, x3, y3) {
  this.k = k4;
  this.x = x3;
  this.y = y3;
}
Transform.prototype = {
  constructor: Transform,
  scale: function(k4) {
    return k4 === 1 ? this : new Transform(this.k * k4, this.x, this.y);
  },
  translate: function(x3, y3) {
    return x3 === 0 & y3 === 0 ? this : new Transform(this.k, this.x + this.k * x3, this.y + this.k * y3);
  },
  apply: function(point13) {
    return [point13[0] * this.k + this.x, point13[1] * this.k + this.y];
  },
  applyX: function(x3) {
    return x3 * this.k + this.x;
  },
  applyY: function(y3) {
    return y3 * this.k + this.y;
  },
  invert: function(location) {
    return [(location[0] - this.x) / this.k, (location[1] - this.y) / this.k];
  },
  invertX: function(x3) {
    return (x3 - this.x) / this.k;
  },
  invertY: function(y3) {
    return (y3 - this.y) / this.k;
  },
  rescaleX: function(x3) {
    return x3.copy().domain(x3.range().map(this.invertX, this).map(x3.invert, x3));
  },
  rescaleY: function(y3) {
    return y3.copy().domain(y3.range().map(this.invertY, this).map(y3.invert, y3));
  },
  toString: function() {
    return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
  }
};
var identity4 = new Transform(1, 0, 0);
transform.prototype = Transform.prototype;
function transform(node4) {
  while (!node4.__zoom) if (!(node4 = node4.parentNode)) return identity4;
  return node4.__zoom;
}

// node_modules/d3-zoom/src/noevent.js
function nopropagation3(event) {
  event.stopImmediatePropagation();
}
function noevent_default3(event) {
  event.preventDefault();
  event.stopImmediatePropagation();
}

// node_modules/d3-zoom/src/zoom.js
function defaultFilter3(event) {
  return (!event.ctrlKey || event.type === "wheel") && !event.button;
}
function defaultExtent2() {
  var e = this;
  if (e instanceof SVGElement) {
    e = e.ownerSVGElement || e;
    if (e.hasAttribute("viewBox")) {
      e = e.viewBox.baseVal;
      return [[e.x, e.y], [e.x + e.width, e.y + e.height]];
    }
    return [[0, 0], [e.width.baseVal.value, e.height.baseVal.value]];
  }
  return [[0, 0], [e.clientWidth, e.clientHeight]];
}
function defaultTransform() {
  return this.__zoom || identity4;
}
function defaultWheelDelta(event) {
  return -event.deltaY * (event.deltaMode === 1 ? 0.05 : event.deltaMode ? 1 : 2e-3) * (event.ctrlKey ? 10 : 1);
}
function defaultTouchable3() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function defaultConstrain(transform2, extent2, translateExtent) {
  var dx0 = transform2.invertX(extent2[0][0]) - translateExtent[0][0], dx1 = transform2.invertX(extent2[1][0]) - translateExtent[1][0], dy0 = transform2.invertY(extent2[0][1]) - translateExtent[0][1], dy1 = transform2.invertY(extent2[1][1]) - translateExtent[1][1];
  return transform2.translate(
    dx1 > dx0 ? (dx0 + dx1) / 2 : Math.min(0, dx0) || Math.max(0, dx1),
    dy1 > dy0 ? (dy0 + dy1) / 2 : Math.min(0, dy0) || Math.max(0, dy1)
  );
}
function zoom_default2() {
  var filter3 = defaultFilter3, extent2 = defaultExtent2, constrain = defaultConstrain, wheelDelta = defaultWheelDelta, touchable = defaultTouchable3, scaleExtent = [0, Infinity], translateExtent = [[-Infinity, -Infinity], [Infinity, Infinity]], duration = 250, interpolate = zoom_default, listeners = dispatch_default("start", "zoom", "end"), touchstarting, touchfirst, touchending, touchDelay = 500, wheelDelay = 150, clickDistance2 = 0, tapDistance = 10;
  function zoom(selection2) {
    selection2.property("__zoom", defaultTransform).on("wheel.zoom", wheeled, { passive: false }).on("mousedown.zoom", mousedowned).on("dblclick.zoom", dblclicked).filter(touchable).on("touchstart.zoom", touchstarted).on("touchmove.zoom", touchmoved).on("touchend.zoom touchcancel.zoom", touchended).style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  zoom.transform = function(collection, transform2, point13, event) {
    var selection2 = collection.selection ? collection.selection() : collection;
    selection2.property("__zoom", defaultTransform);
    if (collection !== selection2) {
      schedule(collection, transform2, point13, event);
    } else {
      selection2.interrupt().each(function() {
        gesture(this, arguments).event(event).start().zoom(null, typeof transform2 === "function" ? transform2.apply(this, arguments) : transform2).end();
      });
    }
  };
  zoom.scaleBy = function(selection2, k4, p, event) {
    zoom.scaleTo(selection2, function() {
      var k0 = this.__zoom.k, k1 = typeof k4 === "function" ? k4.apply(this, arguments) : k4;
      return k0 * k1;
    }, p, event);
  };
  zoom.scaleTo = function(selection2, k4, p, event) {
    zoom.transform(selection2, function() {
      var e = extent2.apply(this, arguments), t03 = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p, p1 = t03.invert(p0), k1 = typeof k4 === "function" ? k4.apply(this, arguments) : k4;
      return constrain(translate(scale(t03, k1), p0, p1), e, translateExtent);
    }, p, event);
  };
  zoom.translateBy = function(selection2, x3, y3, event) {
    zoom.transform(selection2, function() {
      return constrain(this.__zoom.translate(
        typeof x3 === "function" ? x3.apply(this, arguments) : x3,
        typeof y3 === "function" ? y3.apply(this, arguments) : y3
      ), extent2.apply(this, arguments), translateExtent);
    }, null, event);
  };
  zoom.translateTo = function(selection2, x3, y3, p, event) {
    zoom.transform(selection2, function() {
      var e = extent2.apply(this, arguments), t = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p;
      return constrain(identity4.translate(p0[0], p0[1]).scale(t.k).translate(
        typeof x3 === "function" ? -x3.apply(this, arguments) : -x3,
        typeof y3 === "function" ? -y3.apply(this, arguments) : -y3
      ), e, translateExtent);
    }, p, event);
  };
  function scale(transform2, k4) {
    k4 = Math.max(scaleExtent[0], Math.min(scaleExtent[1], k4));
    return k4 === transform2.k ? transform2 : new Transform(k4, transform2.x, transform2.y);
  }
  function translate(transform2, p0, p1) {
    var x3 = p0[0] - p1[0] * transform2.k, y3 = p0[1] - p1[1] * transform2.k;
    return x3 === transform2.x && y3 === transform2.y ? transform2 : new Transform(transform2.k, x3, y3);
  }
  function centroid(extent3) {
    return [(+extent3[0][0] + +extent3[1][0]) / 2, (+extent3[0][1] + +extent3[1][1]) / 2];
  }
  function schedule(transition2, transform2, point13, event) {
    transition2.on("start.zoom", function() {
      gesture(this, arguments).event(event).start();
    }).on("interrupt.zoom end.zoom", function() {
      gesture(this, arguments).event(event).end();
    }).tween("zoom", function() {
      var that = this, args = arguments, g = gesture(that, args).event(event), e = extent2.apply(that, args), p = point13 == null ? centroid(e) : typeof point13 === "function" ? point13.apply(that, args) : point13, w2 = Math.max(e[1][0] - e[0][0], e[1][1] - e[0][1]), a4 = that.__zoom, b = typeof transform2 === "function" ? transform2.apply(that, args) : transform2, i = interpolate(a4.invert(p).concat(w2 / a4.k), b.invert(p).concat(w2 / b.k));
      return function(t) {
        if (t === 1) t = b;
        else {
          var l = i(t), k4 = w2 / l[2];
          t = new Transform(k4, p[0] - l[0] * k4, p[1] - l[1] * k4);
        }
        g.zoom(null, t);
      };
    });
  }
  function gesture(that, args, clean2) {
    return !clean2 && that.__zooming || new Gesture(that, args);
  }
  function Gesture(that, args) {
    this.that = that;
    this.args = args;
    this.active = 0;
    this.sourceEvent = null;
    this.extent = extent2.apply(that, args);
    this.taps = 0;
  }
  Gesture.prototype = {
    event: function(event) {
      if (event) this.sourceEvent = event;
      return this;
    },
    start: function() {
      if (++this.active === 1) {
        this.that.__zooming = this;
        this.emit("start");
      }
      return this;
    },
    zoom: function(key, transform2) {
      if (this.mouse && key !== "mouse") this.mouse[1] = transform2.invert(this.mouse[0]);
      if (this.touch0 && key !== "touch") this.touch0[1] = transform2.invert(this.touch0[0]);
      if (this.touch1 && key !== "touch") this.touch1[1] = transform2.invert(this.touch1[0]);
      this.that.__zoom = transform2;
      this.emit("zoom");
      return this;
    },
    end: function() {
      if (--this.active === 0) {
        delete this.that.__zooming;
        this.emit("end");
      }
      return this;
    },
    emit: function(type2) {
      var d = select_default2(this.that).datum();
      listeners.call(
        type2,
        this.that,
        new ZoomEvent(type2, {
          sourceEvent: this.sourceEvent,
          target: zoom,
          type: type2,
          transform: this.that.__zoom,
          dispatch: listeners
        }),
        d
      );
    }
  };
  function wheeled(event, ...args) {
    if (!filter3.apply(this, arguments)) return;
    var g = gesture(this, args).event(event), t = this.__zoom, k4 = Math.max(scaleExtent[0], Math.min(scaleExtent[1], t.k * Math.pow(2, wheelDelta.apply(this, arguments)))), p = pointer_default(event);
    if (g.wheel) {
      if (g.mouse[0][0] !== p[0] || g.mouse[0][1] !== p[1]) {
        g.mouse[1] = t.invert(g.mouse[0] = p);
      }
      clearTimeout(g.wheel);
    } else if (t.k === k4) return;
    else {
      g.mouse = [p, t.invert(p)];
      interrupt_default(this);
      g.start();
    }
    noevent_default3(event);
    g.wheel = setTimeout(wheelidled, wheelDelay);
    g.zoom("mouse", constrain(translate(scale(t, k4), g.mouse[0], g.mouse[1]), g.extent, translateExtent));
    function wheelidled() {
      g.wheel = null;
      g.end();
    }
  }
  function mousedowned(event, ...args) {
    if (touchending || !filter3.apply(this, arguments)) return;
    var currentTarget = event.currentTarget, g = gesture(this, args, true).event(event), v = select_default2(event.view).on("mousemove.zoom", mousemoved, true).on("mouseup.zoom", mouseupped, true), p = pointer_default(event, currentTarget), x06 = event.clientX, y06 = event.clientY;
    nodrag_default(event.view);
    nopropagation3(event);
    g.mouse = [p, this.__zoom.invert(p)];
    interrupt_default(this);
    g.start();
    function mousemoved(event2) {
      noevent_default3(event2);
      if (!g.moved) {
        var dx = event2.clientX - x06, dy = event2.clientY - y06;
        g.moved = dx * dx + dy * dy > clickDistance2;
      }
      g.event(event2).zoom("mouse", constrain(translate(g.that.__zoom, g.mouse[0] = pointer_default(event2, currentTarget), g.mouse[1]), g.extent, translateExtent));
    }
    function mouseupped(event2) {
      v.on("mousemove.zoom mouseup.zoom", null);
      yesdrag(event2.view, g.moved);
      noevent_default3(event2);
      g.event(event2).end();
    }
  }
  function dblclicked(event, ...args) {
    if (!filter3.apply(this, arguments)) return;
    var t03 = this.__zoom, p0 = pointer_default(event.changedTouches ? event.changedTouches[0] : event, this), p1 = t03.invert(p0), k1 = t03.k * (event.shiftKey ? 0.5 : 2), t13 = constrain(translate(scale(t03, k1), p0, p1), extent2.apply(this, args), translateExtent);
    noevent_default3(event);
    if (duration > 0) select_default2(this).transition().duration(duration).call(schedule, t13, p0, event);
    else select_default2(this).call(zoom.transform, t13, p0, event);
  }
  function touchstarted(event, ...args) {
    if (!filter3.apply(this, arguments)) return;
    var touches = event.touches, n = touches.length, g = gesture(this, args, event.changedTouches.length === n).event(event), started, i, t, p;
    nopropagation3(event);
    for (i = 0; i < n; ++i) {
      t = touches[i], p = pointer_default(t, this);
      p = [p, this.__zoom.invert(p), t.identifier];
      if (!g.touch0) g.touch0 = p, started = true, g.taps = 1 + !!touchstarting;
      else if (!g.touch1 && g.touch0[2] !== p[2]) g.touch1 = p, g.taps = 0;
    }
    if (touchstarting) touchstarting = clearTimeout(touchstarting);
    if (started) {
      if (g.taps < 2) touchfirst = p[0], touchstarting = setTimeout(function() {
        touchstarting = null;
      }, touchDelay);
      interrupt_default(this);
      g.start();
    }
  }
  function touchmoved(event, ...args) {
    if (!this.__zooming) return;
    var g = gesture(this, args).event(event), touches = event.changedTouches, n = touches.length, i, t, p, l;
    noevent_default3(event);
    for (i = 0; i < n; ++i) {
      t = touches[i], p = pointer_default(t, this);
      if (g.touch0 && g.touch0[2] === t.identifier) g.touch0[0] = p;
      else if (g.touch1 && g.touch1[2] === t.identifier) g.touch1[0] = p;
    }
    t = g.that.__zoom;
    if (g.touch1) {
      var p0 = g.touch0[0], l0 = g.touch0[1], p1 = g.touch1[0], l1 = g.touch1[1], dp = (dp = p1[0] - p0[0]) * dp + (dp = p1[1] - p0[1]) * dp, dl = (dl = l1[0] - l0[0]) * dl + (dl = l1[1] - l0[1]) * dl;
      t = scale(t, Math.sqrt(dp / dl));
      p = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2];
      l = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2];
    } else if (g.touch0) p = g.touch0[0], l = g.touch0[1];
    else return;
    g.zoom("touch", constrain(translate(t, p, l), g.extent, translateExtent));
  }
  function touchended(event, ...args) {
    if (!this.__zooming) return;
    var g = gesture(this, args).event(event), touches = event.changedTouches, n = touches.length, i, t;
    nopropagation3(event);
    if (touchending) clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, touchDelay);
    for (i = 0; i < n; ++i) {
      t = touches[i];
      if (g.touch0 && g.touch0[2] === t.identifier) delete g.touch0;
      else if (g.touch1 && g.touch1[2] === t.identifier) delete g.touch1;
    }
    if (g.touch1 && !g.touch0) g.touch0 = g.touch1, delete g.touch1;
    if (g.touch0) g.touch0[1] = this.__zoom.invert(g.touch0[0]);
    else {
      g.end();
      if (g.taps === 2) {
        t = pointer_default(t, this);
        if (Math.hypot(touchfirst[0] - t[0], touchfirst[1] - t[1]) < tapDistance) {
          var p = select_default2(this).on("dblclick.zoom");
          if (p) p.apply(this, arguments);
        }
      }
    }
  }
  zoom.wheelDelta = function(_) {
    return arguments.length ? (wheelDelta = typeof _ === "function" ? _ : constant_default8(+_), zoom) : wheelDelta;
  };
  zoom.filter = function(_) {
    return arguments.length ? (filter3 = typeof _ === "function" ? _ : constant_default8(!!_), zoom) : filter3;
  };
  zoom.touchable = function(_) {
    return arguments.length ? (touchable = typeof _ === "function" ? _ : constant_default8(!!_), zoom) : touchable;
  };
  zoom.extent = function(_) {
    return arguments.length ? (extent2 = typeof _ === "function" ? _ : constant_default8([[+_[0][0], +_[0][1]], [+_[1][0], +_[1][1]]]), zoom) : extent2;
  };
  zoom.scaleExtent = function(_) {
    return arguments.length ? (scaleExtent[0] = +_[0], scaleExtent[1] = +_[1], zoom) : [scaleExtent[0], scaleExtent[1]];
  };
  zoom.translateExtent = function(_) {
    return arguments.length ? (translateExtent[0][0] = +_[0][0], translateExtent[1][0] = +_[1][0], translateExtent[0][1] = +_[0][1], translateExtent[1][1] = +_[1][1], zoom) : [[translateExtent[0][0], translateExtent[0][1]], [translateExtent[1][0], translateExtent[1][1]]];
  };
  zoom.constrain = function(_) {
    return arguments.length ? (constrain = _, zoom) : constrain;
  };
  zoom.duration = function(_) {
    return arguments.length ? (duration = +_, zoom) : duration;
  };
  zoom.interpolate = function(_) {
    return arguments.length ? (interpolate = _, zoom) : interpolate;
  };
  zoom.on = function() {
    var value2 = listeners.on.apply(listeners, arguments);
    return value2 === listeners ? zoom : value2;
  };
  zoom.clickDistance = function(_) {
    return arguments.length ? (clickDistance2 = (_ = +_) * _, zoom) : Math.sqrt(clickDistance2);
  };
  zoom.tapDistance = function(_) {
    return arguments.length ? (tapDistance = +_, zoom) : tapDistance;
  };
  return zoom;
}

// node_modules/d3-geo/src/math.js
var epsilon7 = 1e-6;
var epsilon22 = 1e-12;
var pi6 = Math.PI;
var halfPi4 = pi6 / 2;
var quarterPi = pi6 / 4;
var tau6 = pi6 * 2;
var degrees3 = 180 / pi6;
var radians2 = pi6 / 180;
var abs4 = Math.abs;
var atan = Math.atan;
var atan23 = Math.atan2;
var cos3 = Math.cos;
var exp = Math.exp;
var log2 = Math.log;
var pow2 = Math.pow;
var sin3 = Math.sin;
var sign3 = Math.sign || function(x3) {
  return x3 > 0 ? 1 : x3 < 0 ? -1 : 0;
};
var sqrt5 = Math.sqrt;
var tan = Math.tan;
function acos3(x3) {
  return x3 > 1 ? 0 : x3 < -1 ? pi6 : Math.acos(x3);
}
function asin3(x3) {
  return x3 > 1 ? halfPi4 : x3 < -1 ? -halfPi4 : Math.asin(x3);
}

// node_modules/d3-geo/src/noop.js
function noop() {
}

// node_modules/d3-geo/src/stream.js
function streamGeometry(geometry, stream) {
  if (geometry && streamGeometryType.hasOwnProperty(geometry.type)) {
    streamGeometryType[geometry.type](geometry, stream);
  }
}
var streamObjectType = {
  Feature: function(object2, stream) {
    streamGeometry(object2.geometry, stream);
  },
  FeatureCollection: function(object2, stream) {
    var features2 = object2.features, i = -1, n = features2.length;
    while (++i < n) streamGeometry(features2[i].geometry, stream);
  }
};
var streamGeometryType = {
  Sphere: function(object2, stream) {
    stream.sphere();
  },
  Point: function(object2, stream) {
    object2 = object2.coordinates;
    stream.point(object2[0], object2[1], object2[2]);
  },
  MultiPoint: function(object2, stream) {
    var coordinates = object2.coordinates, i = -1, n = coordinates.length;
    while (++i < n) object2 = coordinates[i], stream.point(object2[0], object2[1], object2[2]);
  },
  LineString: function(object2, stream) {
    streamLine(object2.coordinates, stream, 0);
  },
  MultiLineString: function(object2, stream) {
    var coordinates = object2.coordinates, i = -1, n = coordinates.length;
    while (++i < n) streamLine(coordinates[i], stream, 0);
  },
  Polygon: function(object2, stream) {
    streamPolygon(object2.coordinates, stream);
  },
  MultiPolygon: function(object2, stream) {
    var coordinates = object2.coordinates, i = -1, n = coordinates.length;
    while (++i < n) streamPolygon(coordinates[i], stream);
  },
  GeometryCollection: function(object2, stream) {
    var geometries = object2.geometries, i = -1, n = geometries.length;
    while (++i < n) streamGeometry(geometries[i], stream);
  }
};
function streamLine(coordinates, stream, closed) {
  var i = -1, n = coordinates.length - closed, coordinate;
  stream.lineStart();
  while (++i < n) coordinate = coordinates[i], stream.point(coordinate[0], coordinate[1], coordinate[2]);
  stream.lineEnd();
}
function streamPolygon(coordinates, stream) {
  var i = -1, n = coordinates.length;
  stream.polygonStart();
  while (++i < n) streamLine(coordinates[i], stream, 1);
  stream.polygonEnd();
}
function stream_default(object2, stream) {
  if (object2 && streamObjectType.hasOwnProperty(object2.type)) {
    streamObjectType[object2.type](object2, stream);
  } else {
    streamGeometry(object2, stream);
  }
}

// node_modules/d3-geo/src/area.js
var areaRingSum = new Adder();
var areaSum = new Adder();

// node_modules/d3-geo/src/cartesian.js
function spherical(cartesian2) {
  return [atan23(cartesian2[1], cartesian2[0]), asin3(cartesian2[2])];
}
function cartesian(spherical2) {
  var lambda = spherical2[0], phi2 = spherical2[1], cosPhi = cos3(phi2);
  return [cosPhi * cos3(lambda), cosPhi * sin3(lambda), sin3(phi2)];
}
function cartesianDot(a4, b) {
  return a4[0] * b[0] + a4[1] * b[1] + a4[2] * b[2];
}
function cartesianCross(a4, b) {
  return [a4[1] * b[2] - a4[2] * b[1], a4[2] * b[0] - a4[0] * b[2], a4[0] * b[1] - a4[1] * b[0]];
}
function cartesianAddInPlace(a4, b) {
  a4[0] += b[0], a4[1] += b[1], a4[2] += b[2];
}
function cartesianScale(vector, k4) {
  return [vector[0] * k4, vector[1] * k4, vector[2] * k4];
}
function cartesianNormalizeInPlace(d) {
  var l = sqrt5(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
  d[0] /= l, d[1] /= l, d[2] /= l;
}

// node_modules/d3-geo/src/compose.js
function compose_default(a4, b) {
  function compose(x3, y3) {
    return x3 = a4(x3, y3), b(x3[0], x3[1]);
  }
  if (a4.invert && b.invert) compose.invert = function(x3, y3) {
    return x3 = b.invert(x3, y3), x3 && a4.invert(x3[0], x3[1]);
  };
  return compose;
}

// node_modules/d3-geo/src/rotation.js
function rotationIdentity(lambda, phi2) {
  if (abs4(lambda) > pi6) lambda -= Math.round(lambda / tau6) * tau6;
  return [lambda, phi2];
}
rotationIdentity.invert = rotationIdentity;
function rotateRadians(deltaLambda, deltaPhi, deltaGamma) {
  return (deltaLambda %= tau6) ? deltaPhi || deltaGamma ? compose_default(rotationLambda(deltaLambda), rotationPhiGamma(deltaPhi, deltaGamma)) : rotationLambda(deltaLambda) : deltaPhi || deltaGamma ? rotationPhiGamma(deltaPhi, deltaGamma) : rotationIdentity;
}
function forwardRotationLambda(deltaLambda) {
  return function(lambda, phi2) {
    lambda += deltaLambda;
    if (abs4(lambda) > pi6) lambda -= Math.round(lambda / tau6) * tau6;
    return [lambda, phi2];
  };
}
function rotationLambda(deltaLambda) {
  var rotation = forwardRotationLambda(deltaLambda);
  rotation.invert = forwardRotationLambda(-deltaLambda);
  return rotation;
}
function rotationPhiGamma(deltaPhi, deltaGamma) {
  var cosDeltaPhi = cos3(deltaPhi), sinDeltaPhi = sin3(deltaPhi), cosDeltaGamma = cos3(deltaGamma), sinDeltaGamma = sin3(deltaGamma);
  function rotation(lambda, phi2) {
    var cosPhi = cos3(phi2), x3 = cos3(lambda) * cosPhi, y3 = sin3(lambda) * cosPhi, z = sin3(phi2), k4 = z * cosDeltaPhi + x3 * sinDeltaPhi;
    return [
      atan23(y3 * cosDeltaGamma - k4 * sinDeltaGamma, x3 * cosDeltaPhi - z * sinDeltaPhi),
      asin3(k4 * cosDeltaGamma + y3 * sinDeltaGamma)
    ];
  }
  rotation.invert = function(lambda, phi2) {
    var cosPhi = cos3(phi2), x3 = cos3(lambda) * cosPhi, y3 = sin3(lambda) * cosPhi, z = sin3(phi2), k4 = z * cosDeltaGamma - y3 * sinDeltaGamma;
    return [
      atan23(y3 * cosDeltaGamma + z * sinDeltaGamma, x3 * cosDeltaPhi + k4 * sinDeltaPhi),
      asin3(k4 * cosDeltaPhi - x3 * sinDeltaPhi)
    ];
  };
  return rotation;
}
function rotation_default(rotate) {
  rotate = rotateRadians(rotate[0] * radians2, rotate[1] * radians2, rotate.length > 2 ? rotate[2] * radians2 : 0);
  function forward(coordinates) {
    coordinates = rotate(coordinates[0] * radians2, coordinates[1] * radians2);
    return coordinates[0] *= degrees3, coordinates[1] *= degrees3, coordinates;
  }
  forward.invert = function(coordinates) {
    coordinates = rotate.invert(coordinates[0] * radians2, coordinates[1] * radians2);
    return coordinates[0] *= degrees3, coordinates[1] *= degrees3, coordinates;
  };
  return forward;
}

// node_modules/d3-geo/src/circle.js
function circleStream(stream, radius, delta, direction, t03, t13) {
  if (!delta) return;
  var cosRadius = cos3(radius), sinRadius = sin3(radius), step = direction * delta;
  if (t03 == null) {
    t03 = radius + direction * tau6;
    t13 = radius - step / 2;
  } else {
    t03 = circleRadius(cosRadius, t03);
    t13 = circleRadius(cosRadius, t13);
    if (direction > 0 ? t03 < t13 : t03 > t13) t03 += direction * tau6;
  }
  for (var point13, t = t03; direction > 0 ? t > t13 : t < t13; t -= step) {
    point13 = spherical([cosRadius, -sinRadius * cos3(t), -sinRadius * sin3(t)]);
    stream.point(point13[0], point13[1]);
  }
}
function circleRadius(cosRadius, point13) {
  point13 = cartesian(point13), point13[0] -= cosRadius;
  cartesianNormalizeInPlace(point13);
  var radius = acos3(-point13[1]);
  return ((-point13[2] < 0 ? -radius : radius) + tau6 - epsilon7) % tau6;
}

// node_modules/d3-geo/src/clip/buffer.js
function buffer_default() {
  var lines3 = [], line5;
  return {
    point: function(x3, y3, m2) {
      line5.push([x3, y3, m2]);
    },
    lineStart: function() {
      lines3.push(line5 = []);
    },
    lineEnd: noop,
    rejoin: function() {
      if (lines3.length > 1) lines3.push(lines3.pop().concat(lines3.shift()));
    },
    result: function() {
      var result = lines3;
      lines3 = [];
      line5 = null;
      return result;
    }
  };
}

// node_modules/d3-geo/src/pointEqual.js
function pointEqual_default(a4, b) {
  return abs4(a4[0] - b[0]) < epsilon7 && abs4(a4[1] - b[1]) < epsilon7;
}

// node_modules/d3-geo/src/clip/rejoin.js
function Intersection(point13, points3, other, entry) {
  this.x = point13;
  this.z = points3;
  this.o = other;
  this.e = entry;
  this.v = false;
  this.n = this.p = null;
}
function rejoin_default(segments, compareIntersection2, startInside, interpolate, stream) {
  var subject = [], clip = [], i, n;
  segments.forEach(function(segment3) {
    if ((n2 = segment3.length - 1) <= 0) return;
    var n2, p0 = segment3[0], p1 = segment3[n2], x3;
    if (pointEqual_default(p0, p1)) {
      if (!p0[2] && !p1[2]) {
        stream.lineStart();
        for (i = 0; i < n2; ++i) stream.point((p0 = segment3[i])[0], p0[1]);
        stream.lineEnd();
        return;
      }
      p1[0] += 2 * epsilon7;
    }
    subject.push(x3 = new Intersection(p0, segment3, null, true));
    clip.push(x3.o = new Intersection(p0, null, x3, false));
    subject.push(x3 = new Intersection(p1, segment3, null, false));
    clip.push(x3.o = new Intersection(p1, null, x3, true));
  });
  if (!subject.length) return;
  clip.sort(compareIntersection2);
  link3(subject);
  link3(clip);
  for (i = 0, n = clip.length; i < n; ++i) {
    clip[i].e = startInside = !startInside;
  }
  var start2 = subject[0], points3, point13;
  while (1) {
    var current = start2, isSubject = true;
    while (current.v) if ((current = current.n) === start2) return;
    points3 = current.z;
    stream.lineStart();
    do {
      current.v = current.o.v = true;
      if (current.e) {
        if (isSubject) {
          for (i = 0, n = points3.length; i < n; ++i) stream.point((point13 = points3[i])[0], point13[1]);
        } else {
          interpolate(current.x, current.n.x, 1, stream);
        }
        current = current.n;
      } else {
        if (isSubject) {
          points3 = current.p.z;
          for (i = points3.length - 1; i >= 0; --i) stream.point((point13 = points3[i])[0], point13[1]);
        } else {
          interpolate(current.x, current.p.x, -1, stream);
        }
        current = current.p;
      }
      current = current.o;
      points3 = current.z;
      isSubject = !isSubject;
    } while (!current.v);
    stream.lineEnd();
  }
}
function link3(array3) {
  if (!(n = array3.length)) return;
  var n, i = 0, a4 = array3[0], b;
  while (++i < n) {
    a4.n = b = array3[i];
    b.p = a4;
    a4 = b;
  }
  a4.n = b = array3[0];
  b.p = a4;
}

// node_modules/d3-geo/src/polygonContains.js
function longitude(point13) {
  return abs4(point13[0]) <= pi6 ? point13[0] : sign3(point13[0]) * ((abs4(point13[0]) + pi6) % tau6 - pi6);
}
function polygonContains_default(polygon2, point13) {
  var lambda = longitude(point13), phi2 = point13[1], sinPhi = sin3(phi2), normal = [sin3(lambda), -cos3(lambda), 0], angle = 0, winding = 0;
  var sum5 = new Adder();
  if (sinPhi === 1) phi2 = halfPi4 + epsilon7;
  else if (sinPhi === -1) phi2 = -halfPi4 - epsilon7;
  for (var i = 0, n = polygon2.length; i < n; ++i) {
    if (!(m2 = (ring = polygon2[i]).length)) continue;
    var ring, m2, point0 = ring[m2 - 1], lambda0 = longitude(point0), phi02 = point0[1] / 2 + quarterPi, sinPhi0 = sin3(phi02), cosPhi0 = cos3(phi02);
    for (var j = 0; j < m2; ++j, lambda0 = lambda1, sinPhi0 = sinPhi1, cosPhi0 = cosPhi1, point0 = point1) {
      var point1 = ring[j], lambda1 = longitude(point1), phi1 = point1[1] / 2 + quarterPi, sinPhi1 = sin3(phi1), cosPhi1 = cos3(phi1), delta = lambda1 - lambda0, sign5 = delta >= 0 ? 1 : -1, absDelta = sign5 * delta, antimeridian = absDelta > pi6, k4 = sinPhi0 * sinPhi1;
      sum5.add(atan23(k4 * sign5 * sin3(absDelta), cosPhi0 * cosPhi1 + k4 * cos3(absDelta)));
      angle += antimeridian ? delta + sign5 * tau6 : delta;
      if (antimeridian ^ lambda0 >= lambda ^ lambda1 >= lambda) {
        var arc2 = cartesianCross(cartesian(point0), cartesian(point1));
        cartesianNormalizeInPlace(arc2);
        var intersection2 = cartesianCross(normal, arc2);
        cartesianNormalizeInPlace(intersection2);
        var phiArc = (antimeridian ^ delta >= 0 ? -1 : 1) * asin3(intersection2[2]);
        if (phi2 > phiArc || phi2 === phiArc && (arc2[0] || arc2[1])) {
          winding += antimeridian ^ delta >= 0 ? 1 : -1;
        }
      }
    }
  }
  return (angle < -epsilon7 || angle < epsilon7 && sum5 < -epsilon22) ^ winding & 1;
}

// node_modules/d3-geo/src/clip/index.js
function clip_default(pointVisible, clipLine, interpolate, start2) {
  return function(sink) {
    var line5 = clipLine(sink), ringBuffer = buffer_default(), ringSink = clipLine(ringBuffer), polygonStarted = false, polygon2, segments, ring;
    var clip = {
      point: point13,
      lineStart,
      lineEnd,
      polygonStart: function() {
        clip.point = pointRing;
        clip.lineStart = ringStart;
        clip.lineEnd = ringEnd;
        segments = [];
        polygon2 = [];
      },
      polygonEnd: function() {
        clip.point = point13;
        clip.lineStart = lineStart;
        clip.lineEnd = lineEnd;
        segments = merge(segments);
        var startInside = polygonContains_default(polygon2, start2);
        if (segments.length) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          rejoin_default(segments, compareIntersection, startInside, interpolate, sink);
        } else if (startInside) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          interpolate(null, null, 1, sink);
          sink.lineEnd();
        }
        if (polygonStarted) sink.polygonEnd(), polygonStarted = false;
        segments = polygon2 = null;
      },
      sphere: function() {
        sink.polygonStart();
        sink.lineStart();
        interpolate(null, null, 1, sink);
        sink.lineEnd();
        sink.polygonEnd();
      }
    };
    function point13(lambda, phi2) {
      if (pointVisible(lambda, phi2)) sink.point(lambda, phi2);
    }
    function pointLine(lambda, phi2) {
      line5.point(lambda, phi2);
    }
    function lineStart() {
      clip.point = pointLine;
      line5.lineStart();
    }
    function lineEnd() {
      clip.point = point13;
      line5.lineEnd();
    }
    function pointRing(lambda, phi2) {
      ring.push([lambda, phi2]);
      ringSink.point(lambda, phi2);
    }
    function ringStart() {
      ringSink.lineStart();
      ring = [];
    }
    function ringEnd() {
      pointRing(ring[0][0], ring[0][1]);
      ringSink.lineEnd();
      var clean2 = ringSink.clean(), ringSegments = ringBuffer.result(), i, n = ringSegments.length, m2, segment3, point14;
      ring.pop();
      polygon2.push(ring);
      ring = null;
      if (!n) return;
      if (clean2 & 1) {
        segment3 = ringSegments[0];
        if ((m2 = segment3.length - 1) > 0) {
          if (!polygonStarted) sink.polygonStart(), polygonStarted = true;
          sink.lineStart();
          for (i = 0; i < m2; ++i) sink.point((point14 = segment3[i])[0], point14[1]);
          sink.lineEnd();
        }
        return;
      }
      if (n > 1 && clean2 & 2) ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));
      segments.push(ringSegments.filter(validSegment));
    }
    return clip;
  };
}
function validSegment(segment3) {
  return segment3.length > 1;
}
function compareIntersection(a4, b) {
  return ((a4 = a4.x)[0] < 0 ? a4[1] - halfPi4 - epsilon7 : halfPi4 - a4[1]) - ((b = b.x)[0] < 0 ? b[1] - halfPi4 - epsilon7 : halfPi4 - b[1]);
}

// node_modules/d3-geo/src/clip/antimeridian.js
var antimeridian_default = clip_default(
  function() {
    return true;
  },
  clipAntimeridianLine,
  clipAntimeridianInterpolate,
  [-pi6, -halfPi4]
);
function clipAntimeridianLine(stream) {
  var lambda0 = NaN, phi02 = NaN, sign0 = NaN, clean2;
  return {
    lineStart: function() {
      stream.lineStart();
      clean2 = 1;
    },
    point: function(lambda1, phi1) {
      var sign1 = lambda1 > 0 ? pi6 : -pi6, delta = abs4(lambda1 - lambda0);
      if (abs4(delta - pi6) < epsilon7) {
        stream.point(lambda0, phi02 = (phi02 + phi1) / 2 > 0 ? halfPi4 : -halfPi4);
        stream.point(sign0, phi02);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi02);
        stream.point(lambda1, phi02);
        clean2 = 0;
      } else if (sign0 !== sign1 && delta >= pi6) {
        if (abs4(lambda0 - sign0) < epsilon7) lambda0 -= sign0 * epsilon7;
        if (abs4(lambda1 - sign1) < epsilon7) lambda1 -= sign1 * epsilon7;
        phi02 = clipAntimeridianIntersect(lambda0, phi02, lambda1, phi1);
        stream.point(sign0, phi02);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi02);
        clean2 = 0;
      }
      stream.point(lambda0 = lambda1, phi02 = phi1);
      sign0 = sign1;
    },
    lineEnd: function() {
      stream.lineEnd();
      lambda0 = phi02 = NaN;
    },
    clean: function() {
      return 2 - clean2;
    }
  };
}
function clipAntimeridianIntersect(lambda0, phi02, lambda1, phi1) {
  var cosPhi0, cosPhi1, sinLambda0Lambda1 = sin3(lambda0 - lambda1);
  return abs4(sinLambda0Lambda1) > epsilon7 ? atan((sin3(phi02) * (cosPhi1 = cos3(phi1)) * sin3(lambda1) - sin3(phi1) * (cosPhi0 = cos3(phi02)) * sin3(lambda0)) / (cosPhi0 * cosPhi1 * sinLambda0Lambda1)) : (phi02 + phi1) / 2;
}
function clipAntimeridianInterpolate(from, to, direction, stream) {
  var phi2;
  if (from == null) {
    phi2 = direction * halfPi4;
    stream.point(-pi6, phi2);
    stream.point(0, phi2);
    stream.point(pi6, phi2);
    stream.point(pi6, 0);
    stream.point(pi6, -phi2);
    stream.point(0, -phi2);
    stream.point(-pi6, -phi2);
    stream.point(-pi6, 0);
    stream.point(-pi6, phi2);
  } else if (abs4(from[0] - to[0]) > epsilon7) {
    var lambda = from[0] < to[0] ? pi6 : -pi6;
    phi2 = direction * lambda / 2;
    stream.point(-lambda, phi2);
    stream.point(0, phi2);
    stream.point(lambda, phi2);
  } else {
    stream.point(to[0], to[1]);
  }
}

// node_modules/d3-geo/src/clip/circle.js
function circle_default3(radius) {
  var cr = cos3(radius), delta = 2 * radians2, smallRadius = cr > 0, notHemisphere = abs4(cr) > epsilon7;
  function interpolate(from, to, direction, stream) {
    circleStream(stream, radius, delta, direction, from, to);
  }
  function visible(lambda, phi2) {
    return cos3(lambda) * cos3(phi2) > cr;
  }
  function clipLine(stream) {
    var point0, c0, v0, v00, clean2;
    return {
      lineStart: function() {
        v00 = v0 = false;
        clean2 = 1;
      },
      point: function(lambda, phi2) {
        var point1 = [lambda, phi2], point22, v = visible(lambda, phi2), c3 = smallRadius ? v ? 0 : code(lambda, phi2) : v ? code(lambda + (lambda < 0 ? pi6 : -pi6), phi2) : 0;
        if (!point0 && (v00 = v0 = v)) stream.lineStart();
        if (v !== v0) {
          point22 = intersect2(point0, point1);
          if (!point22 || pointEqual_default(point0, point22) || pointEqual_default(point1, point22))
            point1[2] = 1;
        }
        if (v !== v0) {
          clean2 = 0;
          if (v) {
            stream.lineStart();
            point22 = intersect2(point1, point0);
            stream.point(point22[0], point22[1]);
          } else {
            point22 = intersect2(point0, point1);
            stream.point(point22[0], point22[1], 2);
            stream.lineEnd();
          }
          point0 = point22;
        } else if (notHemisphere && point0 && smallRadius ^ v) {
          var t;
          if (!(c3 & c0) && (t = intersect2(point1, point0, true))) {
            clean2 = 0;
            if (smallRadius) {
              stream.lineStart();
              stream.point(t[0][0], t[0][1]);
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
            } else {
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
              stream.lineStart();
              stream.point(t[0][0], t[0][1], 3);
            }
          }
        }
        if (v && (!point0 || !pointEqual_default(point0, point1))) {
          stream.point(point1[0], point1[1]);
        }
        point0 = point1, v0 = v, c0 = c3;
      },
      lineEnd: function() {
        if (v0) stream.lineEnd();
        point0 = null;
      },
      // Rejoin first and last segments if there were intersections and the first
      // and last points were visible.
      clean: function() {
        return clean2 | (v00 && v0) << 1;
      }
    };
  }
  function intersect2(a4, b, two) {
    var pa = cartesian(a4), pb = cartesian(b);
    var n1 = [1, 0, 0], n2 = cartesianCross(pa, pb), n2n2 = cartesianDot(n2, n2), n1n2 = n2[0], determinant = n2n2 - n1n2 * n1n2;
    if (!determinant) return !two && a4;
    var c1 = cr * n2n2 / determinant, c22 = -cr * n1n2 / determinant, n1xn2 = cartesianCross(n1, n2), A6 = cartesianScale(n1, c1), B3 = cartesianScale(n2, c22);
    cartesianAddInPlace(A6, B3);
    var u = n1xn2, w2 = cartesianDot(A6, u), uu = cartesianDot(u, u), t22 = w2 * w2 - uu * (cartesianDot(A6, A6) - 1);
    if (t22 < 0) return;
    var t = sqrt5(t22), q = cartesianScale(u, (-w2 - t) / uu);
    cartesianAddInPlace(q, A6);
    q = spherical(q);
    if (!two) return q;
    var lambda0 = a4[0], lambda1 = b[0], phi02 = a4[1], phi1 = b[1], z;
    if (lambda1 < lambda0) z = lambda0, lambda0 = lambda1, lambda1 = z;
    var delta2 = lambda1 - lambda0, polar = abs4(delta2 - pi6) < epsilon7, meridian = polar || delta2 < epsilon7;
    if (!polar && phi1 < phi02) z = phi02, phi02 = phi1, phi1 = z;
    if (meridian ? polar ? phi02 + phi1 > 0 ^ q[1] < (abs4(q[0] - lambda0) < epsilon7 ? phi02 : phi1) : phi02 <= q[1] && q[1] <= phi1 : delta2 > pi6 ^ (lambda0 <= q[0] && q[0] <= lambda1)) {
      var q1 = cartesianScale(u, (-w2 + t) / uu);
      cartesianAddInPlace(q1, A6);
      return [q, spherical(q1)];
    }
  }
  function code(lambda, phi2) {
    var r = smallRadius ? radius : pi6 - radius, code2 = 0;
    if (lambda < -r) code2 |= 1;
    else if (lambda > r) code2 |= 2;
    if (phi2 < -r) code2 |= 4;
    else if (phi2 > r) code2 |= 8;
    return code2;
  }
  return clip_default(visible, clipLine, interpolate, smallRadius ? [0, -radius] : [-pi6, radius - pi6]);
}

// node_modules/d3-geo/src/clip/line.js
function line_default3(a4, b, x06, y06, x13, y13) {
  var ax = a4[0], ay = a4[1], bx = b[0], by = b[1], t03 = 0, t13 = 1, dx = bx - ax, dy = by - ay, r;
  r = x06 - ax;
  if (!dx && r > 0) return;
  r /= dx;
  if (dx < 0) {
    if (r < t03) return;
    if (r < t13) t13 = r;
  } else if (dx > 0) {
    if (r > t13) return;
    if (r > t03) t03 = r;
  }
  r = x13 - ax;
  if (!dx && r < 0) return;
  r /= dx;
  if (dx < 0) {
    if (r > t13) return;
    if (r > t03) t03 = r;
  } else if (dx > 0) {
    if (r < t03) return;
    if (r < t13) t13 = r;
  }
  r = y06 - ay;
  if (!dy && r > 0) return;
  r /= dy;
  if (dy < 0) {
    if (r < t03) return;
    if (r < t13) t13 = r;
  } else if (dy > 0) {
    if (r > t13) return;
    if (r > t03) t03 = r;
  }
  r = y13 - ay;
  if (!dy && r < 0) return;
  r /= dy;
  if (dy < 0) {
    if (r > t13) return;
    if (r > t03) t03 = r;
  } else if (dy > 0) {
    if (r < t03) return;
    if (r < t13) t13 = r;
  }
  if (t03 > 0) a4[0] = ax + t03 * dx, a4[1] = ay + t03 * dy;
  if (t13 < 1) b[0] = ax + t13 * dx, b[1] = ay + t13 * dy;
  return true;
}

// node_modules/d3-geo/src/clip/rectangle.js
var clipMax = 1e9;
var clipMin = -clipMax;
function clipRectangle(x06, y06, x13, y13) {
  function visible(x3, y3) {
    return x06 <= x3 && x3 <= x13 && y06 <= y3 && y3 <= y13;
  }
  function interpolate(from, to, direction, stream) {
    var a4 = 0, a1 = 0;
    if (from == null || (a4 = corner(from, direction)) !== (a1 = corner(to, direction)) || comparePoint(from, to) < 0 ^ direction > 0) {
      do
        stream.point(a4 === 0 || a4 === 3 ? x06 : x13, a4 > 1 ? y13 : y06);
      while ((a4 = (a4 + direction + 4) % 4) !== a1);
    } else {
      stream.point(to[0], to[1]);
    }
  }
  function corner(p, direction) {
    return abs4(p[0] - x06) < epsilon7 ? direction > 0 ? 0 : 3 : abs4(p[0] - x13) < epsilon7 ? direction > 0 ? 2 : 1 : abs4(p[1] - y06) < epsilon7 ? direction > 0 ? 1 : 0 : direction > 0 ? 3 : 2;
  }
  function compareIntersection2(a4, b) {
    return comparePoint(a4.x, b.x);
  }
  function comparePoint(a4, b) {
    var ca = corner(a4, 1), cb = corner(b, 1);
    return ca !== cb ? ca - cb : ca === 0 ? b[1] - a4[1] : ca === 1 ? a4[0] - b[0] : ca === 2 ? a4[1] - b[1] : b[0] - a4[0];
  }
  return function(stream) {
    var activeStream = stream, bufferStream = buffer_default(), segments, polygon2, ring, x__, y__, v__, x_, y_, v_, first, clean2;
    var clipStream = {
      point: point13,
      lineStart,
      lineEnd,
      polygonStart,
      polygonEnd
    };
    function point13(x3, y3) {
      if (visible(x3, y3)) activeStream.point(x3, y3);
    }
    function polygonInside() {
      var winding = 0;
      for (var i = 0, n = polygon2.length; i < n; ++i) {
        for (var ring2 = polygon2[i], j = 1, m2 = ring2.length, point14 = ring2[0], a0, a1, b02 = point14[0], b12 = point14[1]; j < m2; ++j) {
          a0 = b02, a1 = b12, point14 = ring2[j], b02 = point14[0], b12 = point14[1];
          if (a1 <= y13) {
            if (b12 > y13 && (b02 - a0) * (y13 - a1) > (b12 - a1) * (x06 - a0)) ++winding;
          } else {
            if (b12 <= y13 && (b02 - a0) * (y13 - a1) < (b12 - a1) * (x06 - a0)) --winding;
          }
        }
      }
      return winding;
    }
    function polygonStart() {
      activeStream = bufferStream, segments = [], polygon2 = [], clean2 = true;
    }
    function polygonEnd() {
      var startInside = polygonInside(), cleanInside = clean2 && startInside, visible2 = (segments = merge(segments)).length;
      if (cleanInside || visible2) {
        stream.polygonStart();
        if (cleanInside) {
          stream.lineStart();
          interpolate(null, null, 1, stream);
          stream.lineEnd();
        }
        if (visible2) {
          rejoin_default(segments, compareIntersection2, startInside, interpolate, stream);
        }
        stream.polygonEnd();
      }
      activeStream = stream, segments = polygon2 = ring = null;
    }
    function lineStart() {
      clipStream.point = linePoint;
      if (polygon2) polygon2.push(ring = []);
      first = true;
      v_ = false;
      x_ = y_ = NaN;
    }
    function lineEnd() {
      if (segments) {
        linePoint(x__, y__);
        if (v__ && v_) bufferStream.rejoin();
        segments.push(bufferStream.result());
      }
      clipStream.point = point13;
      if (v_) activeStream.lineEnd();
    }
    function linePoint(x3, y3) {
      var v = visible(x3, y3);
      if (polygon2) ring.push([x3, y3]);
      if (first) {
        x__ = x3, y__ = y3, v__ = v;
        first = false;
        if (v) {
          activeStream.lineStart();
          activeStream.point(x3, y3);
        }
      } else {
        if (v && v_) activeStream.point(x3, y3);
        else {
          var a4 = [x_ = Math.max(clipMin, Math.min(clipMax, x_)), y_ = Math.max(clipMin, Math.min(clipMax, y_))], b = [x3 = Math.max(clipMin, Math.min(clipMax, x3)), y3 = Math.max(clipMin, Math.min(clipMax, y3))];
          if (line_default3(a4, b, x06, y06, x13, y13)) {
            if (!v_) {
              activeStream.lineStart();
              activeStream.point(a4[0], a4[1]);
            }
            activeStream.point(b[0], b[1]);
            if (!v) activeStream.lineEnd();
            clean2 = false;
          } else if (v) {
            activeStream.lineStart();
            activeStream.point(x3, y3);
            clean2 = false;
          }
        }
      }
      x_ = x3, y_ = y3, v_ = v;
    }
    return clipStream;
  };
}

// node_modules/d3-geo/src/identity.js
var identity_default6 = (x3) => x3;

// node_modules/d3-geo/src/path/area.js
var areaSum2 = new Adder();
var areaRingSum2 = new Adder();
var x00;
var y00;
var x0;
var y0;
var areaStream2 = {
  point: noop,
  lineStart: noop,
  lineEnd: noop,
  polygonStart: function() {
    areaStream2.lineStart = areaRingStart;
    areaStream2.lineEnd = areaRingEnd;
  },
  polygonEnd: function() {
    areaStream2.lineStart = areaStream2.lineEnd = areaStream2.point = noop;
    areaSum2.add(abs4(areaRingSum2));
    areaRingSum2 = new Adder();
  },
  result: function() {
    var area2 = areaSum2 / 2;
    areaSum2 = new Adder();
    return area2;
  }
};
function areaRingStart() {
  areaStream2.point = areaPointFirst;
}
function areaPointFirst(x3, y3) {
  areaStream2.point = areaPoint;
  x00 = x0 = x3, y00 = y0 = y3;
}
function areaPoint(x3, y3) {
  areaRingSum2.add(y0 * x3 - x0 * y3);
  x0 = x3, y0 = y3;
}
function areaRingEnd() {
  areaPoint(x00, y00);
}
var area_default3 = areaStream2;

// node_modules/d3-geo/src/path/bounds.js
var x02 = Infinity;
var y02 = x02;
var x1 = -x02;
var y1 = x1;
var boundsStream = {
  point: boundsPoint,
  lineStart: noop,
  lineEnd: noop,
  polygonStart: noop,
  polygonEnd: noop,
  result: function() {
    var bounds = [[x02, y02], [x1, y1]];
    x1 = y1 = -(y02 = x02 = Infinity);
    return bounds;
  }
};
function boundsPoint(x3, y3) {
  if (x3 < x02) x02 = x3;
  if (x3 > x1) x1 = x3;
  if (y3 < y02) y02 = y3;
  if (y3 > y1) y1 = y3;
}
var bounds_default = boundsStream;

// node_modules/d3-geo/src/path/centroid.js
var X0 = 0;
var Y0 = 0;
var Z0 = 0;
var X1 = 0;
var Y1 = 0;
var Z1 = 0;
var X2 = 0;
var Y2 = 0;
var Z2 = 0;
var x002;
var y002;
var x03;
var y03;
var centroidStream = {
  point: centroidPoint,
  lineStart: centroidLineStart,
  lineEnd: centroidLineEnd,
  polygonStart: function() {
    centroidStream.lineStart = centroidRingStart;
    centroidStream.lineEnd = centroidRingEnd;
  },
  polygonEnd: function() {
    centroidStream.point = centroidPoint;
    centroidStream.lineStart = centroidLineStart;
    centroidStream.lineEnd = centroidLineEnd;
  },
  result: function() {
    var centroid = Z2 ? [X2 / Z2, Y2 / Z2] : Z1 ? [X1 / Z1, Y1 / Z1] : Z0 ? [X0 / Z0, Y0 / Z0] : [NaN, NaN];
    X0 = Y0 = Z0 = X1 = Y1 = Z1 = X2 = Y2 = Z2 = 0;
    return centroid;
  }
};
function centroidPoint(x3, y3) {
  X0 += x3;
  Y0 += y3;
  ++Z0;
}
function centroidLineStart() {
  centroidStream.point = centroidPointFirstLine;
}
function centroidPointFirstLine(x3, y3) {
  centroidStream.point = centroidPointLine;
  centroidPoint(x03 = x3, y03 = y3);
}
function centroidPointLine(x3, y3) {
  var dx = x3 - x03, dy = y3 - y03, z = sqrt5(dx * dx + dy * dy);
  X1 += z * (x03 + x3) / 2;
  Y1 += z * (y03 + y3) / 2;
  Z1 += z;
  centroidPoint(x03 = x3, y03 = y3);
}
function centroidLineEnd() {
  centroidStream.point = centroidPoint;
}
function centroidRingStart() {
  centroidStream.point = centroidPointFirstRing;
}
function centroidRingEnd() {
  centroidPointRing(x002, y002);
}
function centroidPointFirstRing(x3, y3) {
  centroidStream.point = centroidPointRing;
  centroidPoint(x002 = x03 = x3, y002 = y03 = y3);
}
function centroidPointRing(x3, y3) {
  var dx = x3 - x03, dy = y3 - y03, z = sqrt5(dx * dx + dy * dy);
  X1 += z * (x03 + x3) / 2;
  Y1 += z * (y03 + y3) / 2;
  Z1 += z;
  z = y03 * x3 - x03 * y3;
  X2 += z * (x03 + x3);
  Y2 += z * (y03 + y3);
  Z2 += z * 3;
  centroidPoint(x03 = x3, y03 = y3);
}
var centroid_default = centroidStream;

// node_modules/d3-geo/src/path/context.js
function PathContext(context) {
  this._context = context;
}
PathContext.prototype = {
  _radius: 4.5,
  pointRadius: function(_) {
    return this._radius = _, this;
  },
  polygonStart: function() {
    this._line = 0;
  },
  polygonEnd: function() {
    this._line = NaN;
  },
  lineStart: function() {
    this._point = 0;
  },
  lineEnd: function() {
    if (this._line === 0) this._context.closePath();
    this._point = NaN;
  },
  point: function(x3, y3) {
    switch (this._point) {
      case 0: {
        this._context.moveTo(x3, y3);
        this._point = 1;
        break;
      }
      case 1: {
        this._context.lineTo(x3, y3);
        break;
      }
      default: {
        this._context.moveTo(x3 + this._radius, y3);
        this._context.arc(x3, y3, this._radius, 0, tau6);
        break;
      }
    }
  },
  result: noop
};

// node_modules/d3-geo/src/path/measure.js
var lengthSum = new Adder();
var lengthRing;
var x003;
var y003;
var x04;
var y04;
var lengthStream = {
  point: noop,
  lineStart: function() {
    lengthStream.point = lengthPointFirst;
  },
  lineEnd: function() {
    if (lengthRing) lengthPoint(x003, y003);
    lengthStream.point = noop;
  },
  polygonStart: function() {
    lengthRing = true;
  },
  polygonEnd: function() {
    lengthRing = null;
  },
  result: function() {
    var length = +lengthSum;
    lengthSum = new Adder();
    return length;
  }
};
function lengthPointFirst(x3, y3) {
  lengthStream.point = lengthPoint;
  x003 = x04 = x3, y003 = y04 = y3;
}
function lengthPoint(x3, y3) {
  x04 -= x3, y04 -= y3;
  lengthSum.add(sqrt5(x04 * x04 + y04 * y04));
  x04 = x3, y04 = y3;
}
var measure_default = lengthStream;

// node_modules/d3-geo/src/path/string.js
var cacheDigits;
var cacheAppend;
var cacheRadius;
var cacheCircle;
var PathString = class {
  constructor(digits) {
    this._append = digits == null ? append2 : appendRound2(digits);
    this._radius = 4.5;
    this._ = "";
  }
  pointRadius(_) {
    this._radius = +_;
    return this;
  }
  polygonStart() {
    this._line = 0;
  }
  polygonEnd() {
    this._line = NaN;
  }
  lineStart() {
    this._point = 0;
  }
  lineEnd() {
    if (this._line === 0) this._ += "Z";
    this._point = NaN;
  }
  point(x3, y3) {
    switch (this._point) {
      case 0: {
        this._append`M${x3},${y3}`;
        this._point = 1;
        break;
      }
      case 1: {
        this._append`L${x3},${y3}`;
        break;
      }
      default: {
        this._append`M${x3},${y3}`;
        if (this._radius !== cacheRadius || this._append !== cacheAppend) {
          const r = this._radius;
          const s3 = this._;
          this._ = "";
          this._append`m0,${r}a${r},${r} 0 1,1 0,${-2 * r}a${r},${r} 0 1,1 0,${2 * r}z`;
          cacheRadius = r;
          cacheAppend = this._append;
          cacheCircle = this._;
          this._ = s3;
        }
        this._ += cacheCircle;
        break;
      }
    }
  }
  result() {
    const result = this._;
    this._ = "";
    return result.length ? result : null;
  }
};
function append2(strings) {
  let i = 1;
  this._ += strings[0];
  for (const j = strings.length; i < j; ++i) {
    this._ += arguments[i] + strings[i];
  }
}
function appendRound2(digits) {
  const d = Math.floor(digits);
  if (!(d >= 0)) throw new RangeError(`invalid digits: ${digits}`);
  if (d > 15) return append2;
  if (d !== cacheDigits) {
    const k4 = 10 ** d;
    cacheDigits = d;
    cacheAppend = function append3(strings) {
      let i = 1;
      this._ += strings[0];
      for (const j = strings.length; i < j; ++i) {
        this._ += Math.round(arguments[i] * k4) / k4 + strings[i];
      }
    };
  }
  return cacheAppend;
}

// node_modules/d3-geo/src/path/index.js
function path_default2(projection2, context) {
  let digits = 3, pointRadius = 4.5, projectionStream, contextStream;
  function path3(object2) {
    if (object2) {
      if (typeof pointRadius === "function") contextStream.pointRadius(+pointRadius.apply(this, arguments));
      stream_default(object2, projectionStream(contextStream));
    }
    return contextStream.result();
  }
  path3.area = function(object2) {
    stream_default(object2, projectionStream(area_default3));
    return area_default3.result();
  };
  path3.measure = function(object2) {
    stream_default(object2, projectionStream(measure_default));
    return measure_default.result();
  };
  path3.bounds = function(object2) {
    stream_default(object2, projectionStream(bounds_default));
    return bounds_default.result();
  };
  path3.centroid = function(object2) {
    stream_default(object2, projectionStream(centroid_default));
    return centroid_default.result();
  };
  path3.projection = function(_) {
    if (!arguments.length) return projection2;
    projectionStream = _ == null ? (projection2 = null, identity_default6) : (projection2 = _).stream;
    return path3;
  };
  path3.context = function(_) {
    if (!arguments.length) return context;
    contextStream = _ == null ? (context = null, new PathString(digits)) : new PathContext(context = _);
    if (typeof pointRadius !== "function") contextStream.pointRadius(pointRadius);
    return path3;
  };
  path3.pointRadius = function(_) {
    if (!arguments.length) return pointRadius;
    pointRadius = typeof _ === "function" ? _ : (contextStream.pointRadius(+_), +_);
    return path3;
  };
  path3.digits = function(_) {
    if (!arguments.length) return digits;
    if (_ == null) digits = null;
    else {
      const d = Math.floor(_);
      if (!(d >= 0)) throw new RangeError(`invalid digits: ${_}`);
      digits = d;
    }
    if (context === null) contextStream = new PathString(digits);
    return path3;
  };
  return path3.projection(projection2).digits(digits).context(context);
}

// node_modules/d3-geo/src/transform.js
function transformer4(methods) {
  return function(stream) {
    var s3 = new TransformStream();
    for (var key in methods) s3[key] = methods[key];
    s3.stream = stream;
    return s3;
  };
}
function TransformStream() {
}
TransformStream.prototype = {
  constructor: TransformStream,
  point: function(x3, y3) {
    this.stream.point(x3, y3);
  },
  sphere: function() {
    this.stream.sphere();
  },
  lineStart: function() {
    this.stream.lineStart();
  },
  lineEnd: function() {
    this.stream.lineEnd();
  },
  polygonStart: function() {
    this.stream.polygonStart();
  },
  polygonEnd: function() {
    this.stream.polygonEnd();
  }
};

// node_modules/d3-geo/src/projection/fit.js
function fit(projection2, fitBounds, object2) {
  var clip = projection2.clipExtent && projection2.clipExtent();
  projection2.scale(150).translate([0, 0]);
  if (clip != null) projection2.clipExtent(null);
  stream_default(object2, projection2.stream(bounds_default));
  fitBounds(bounds_default.result());
  if (clip != null) projection2.clipExtent(clip);
  return projection2;
}
function fitExtent(projection2, extent2, object2) {
  return fit(projection2, function(b) {
    var w2 = extent2[1][0] - extent2[0][0], h = extent2[1][1] - extent2[0][1], k4 = Math.min(w2 / (b[1][0] - b[0][0]), h / (b[1][1] - b[0][1])), x3 = +extent2[0][0] + (w2 - k4 * (b[1][0] + b[0][0])) / 2, y3 = +extent2[0][1] + (h - k4 * (b[1][1] + b[0][1])) / 2;
    projection2.scale(150 * k4).translate([x3, y3]);
  }, object2);
}
function fitSize(projection2, size2, object2) {
  return fitExtent(projection2, [[0, 0], size2], object2);
}
function fitWidth(projection2, width, object2) {
  return fit(projection2, function(b) {
    var w2 = +width, k4 = w2 / (b[1][0] - b[0][0]), x3 = (w2 - k4 * (b[1][0] + b[0][0])) / 2, y3 = -k4 * b[0][1];
    projection2.scale(150 * k4).translate([x3, y3]);
  }, object2);
}
function fitHeight(projection2, height, object2) {
  return fit(projection2, function(b) {
    var h = +height, k4 = h / (b[1][1] - b[0][1]), x3 = -k4 * b[0][0], y3 = (h - k4 * (b[1][1] + b[0][1])) / 2;
    projection2.scale(150 * k4).translate([x3, y3]);
  }, object2);
}

// node_modules/d3-geo/src/projection/resample.js
var maxDepth = 16;
var cosMinDistance = cos3(30 * radians2);
function resample_default(project, delta2) {
  return +delta2 ? resample(project, delta2) : resampleNone(project);
}
function resampleNone(project) {
  return transformer4({
    point: function(x3, y3) {
      x3 = project(x3, y3);
      this.stream.point(x3[0], x3[1]);
    }
  });
}
function resample(project, delta2) {
  function resampleLineTo(x06, y06, lambda0, a0, b02, c0, x13, y13, lambda1, a1, b12, c1, depth, stream) {
    var dx = x13 - x06, dy = y13 - y06, d2 = dx * dx + dy * dy;
    if (d2 > 4 * delta2 && depth--) {
      var a4 = a0 + a1, b = b02 + b12, c3 = c0 + c1, m2 = sqrt5(a4 * a4 + b * b + c3 * c3), phi2 = asin3(c3 /= m2), lambda2 = abs4(abs4(c3) - 1) < epsilon7 || abs4(lambda0 - lambda1) < epsilon7 ? (lambda0 + lambda1) / 2 : atan23(b, a4), p = project(lambda2, phi2), x22 = p[0], y22 = p[1], dx2 = x22 - x06, dy2 = y22 - y06, dz = dy * dx2 - dx * dy2;
      if (dz * dz / d2 > delta2 || abs4((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3 || a0 * a1 + b02 * b12 + c0 * c1 < cosMinDistance) {
        resampleLineTo(x06, y06, lambda0, a0, b02, c0, x22, y22, lambda2, a4 /= m2, b /= m2, c3, depth, stream);
        stream.point(x22, y22);
        resampleLineTo(x22, y22, lambda2, a4, b, c3, x13, y13, lambda1, a1, b12, c1, depth, stream);
      }
    }
  }
  return function(stream) {
    var lambda00, x004, y004, a00, b00, c00, lambda0, x06, y06, a0, b02, c0;
    var resampleStream = {
      point: point13,
      lineStart,
      lineEnd,
      polygonStart: function() {
        stream.polygonStart();
        resampleStream.lineStart = ringStart;
      },
      polygonEnd: function() {
        stream.polygonEnd();
        resampleStream.lineStart = lineStart;
      }
    };
    function point13(x3, y3) {
      x3 = project(x3, y3);
      stream.point(x3[0], x3[1]);
    }
    function lineStart() {
      x06 = NaN;
      resampleStream.point = linePoint;
      stream.lineStart();
    }
    function linePoint(lambda, phi2) {
      var c3 = cartesian([lambda, phi2]), p = project(lambda, phi2);
      resampleLineTo(x06, y06, lambda0, a0, b02, c0, x06 = p[0], y06 = p[1], lambda0 = lambda, a0 = c3[0], b02 = c3[1], c0 = c3[2], maxDepth, stream);
      stream.point(x06, y06);
    }
    function lineEnd() {
      resampleStream.point = point13;
      stream.lineEnd();
    }
    function ringStart() {
      lineStart();
      resampleStream.point = ringPoint;
      resampleStream.lineEnd = ringEnd;
    }
    function ringPoint(lambda, phi2) {
      linePoint(lambda00 = lambda, phi2), x004 = x06, y004 = y06, a00 = a0, b00 = b02, c00 = c0;
      resampleStream.point = linePoint;
    }
    function ringEnd() {
      resampleLineTo(x06, y06, lambda0, a0, b02, c0, x004, y004, lambda00, a00, b00, c00, maxDepth, stream);
      resampleStream.lineEnd = lineEnd;
      lineEnd();
    }
    return resampleStream;
  };
}

// node_modules/d3-geo/src/projection/index.js
var transformRadians = transformer4({
  point: function(x3, y3) {
    this.stream.point(x3 * radians2, y3 * radians2);
  }
});
function transformRotate(rotate) {
  return transformer4({
    point: function(x3, y3) {
      var r = rotate(x3, y3);
      return this.stream.point(r[0], r[1]);
    }
  });
}
function scaleTranslate(k4, dx, dy, sx, sy) {
  function transform2(x3, y3) {
    x3 *= sx;
    y3 *= sy;
    return [dx + k4 * x3, dy - k4 * y3];
  }
  transform2.invert = function(x3, y3) {
    return [(x3 - dx) / k4 * sx, (dy - y3) / k4 * sy];
  };
  return transform2;
}
function scaleTranslateRotate(k4, dx, dy, sx, sy, alpha) {
  if (!alpha) return scaleTranslate(k4, dx, dy, sx, sy);
  var cosAlpha = cos3(alpha), sinAlpha = sin3(alpha), a4 = cosAlpha * k4, b = sinAlpha * k4, ai = cosAlpha / k4, bi = sinAlpha / k4, ci = (sinAlpha * dy - cosAlpha * dx) / k4, fi = (sinAlpha * dx + cosAlpha * dy) / k4;
  function transform2(x3, y3) {
    x3 *= sx;
    y3 *= sy;
    return [a4 * x3 - b * y3 + dx, dy - b * x3 - a4 * y3];
  }
  transform2.invert = function(x3, y3) {
    return [sx * (ai * x3 - bi * y3 + ci), sy * (fi - bi * x3 - ai * y3)];
  };
  return transform2;
}
function projection(project) {
  return projectionMutator(function() {
    return project;
  })();
}
function projectionMutator(projectAt) {
  var project, k4 = 150, x3 = 480, y3 = 250, lambda = 0, phi2 = 0, deltaLambda = 0, deltaPhi = 0, deltaGamma = 0, rotate, alpha = 0, sx = 1, sy = 1, theta = null, preclip = antimeridian_default, x06 = null, y06, x13, y13, postclip = identity_default6, delta2 = 0.5, projectResample, projectTransform, projectRotateTransform, cache2, cacheStream;
  function projection2(point13) {
    return projectRotateTransform(point13[0] * radians2, point13[1] * radians2);
  }
  function invert(point13) {
    point13 = projectRotateTransform.invert(point13[0], point13[1]);
    return point13 && [point13[0] * degrees3, point13[1] * degrees3];
  }
  projection2.stream = function(stream) {
    return cache2 && cacheStream === stream ? cache2 : cache2 = transformRadians(transformRotate(rotate)(preclip(projectResample(postclip(cacheStream = stream)))));
  };
  projection2.preclip = function(_) {
    return arguments.length ? (preclip = _, theta = void 0, reset()) : preclip;
  };
  projection2.postclip = function(_) {
    return arguments.length ? (postclip = _, x06 = y06 = x13 = y13 = null, reset()) : postclip;
  };
  projection2.clipAngle = function(_) {
    return arguments.length ? (preclip = +_ ? circle_default3(theta = _ * radians2) : (theta = null, antimeridian_default), reset()) : theta * degrees3;
  };
  projection2.clipExtent = function(_) {
    return arguments.length ? (postclip = _ == null ? (x06 = y06 = x13 = y13 = null, identity_default6) : clipRectangle(x06 = +_[0][0], y06 = +_[0][1], x13 = +_[1][0], y13 = +_[1][1]), reset()) : x06 == null ? null : [[x06, y06], [x13, y13]];
  };
  projection2.scale = function(_) {
    return arguments.length ? (k4 = +_, recenter()) : k4;
  };
  projection2.translate = function(_) {
    return arguments.length ? (x3 = +_[0], y3 = +_[1], recenter()) : [x3, y3];
  };
  projection2.center = function(_) {
    return arguments.length ? (lambda = _[0] % 360 * radians2, phi2 = _[1] % 360 * radians2, recenter()) : [lambda * degrees3, phi2 * degrees3];
  };
  projection2.rotate = function(_) {
    return arguments.length ? (deltaLambda = _[0] % 360 * radians2, deltaPhi = _[1] % 360 * radians2, deltaGamma = _.length > 2 ? _[2] % 360 * radians2 : 0, recenter()) : [deltaLambda * degrees3, deltaPhi * degrees3, deltaGamma * degrees3];
  };
  projection2.angle = function(_) {
    return arguments.length ? (alpha = _ % 360 * radians2, recenter()) : alpha * degrees3;
  };
  projection2.reflectX = function(_) {
    return arguments.length ? (sx = _ ? -1 : 1, recenter()) : sx < 0;
  };
  projection2.reflectY = function(_) {
    return arguments.length ? (sy = _ ? -1 : 1, recenter()) : sy < 0;
  };
  projection2.precision = function(_) {
    return arguments.length ? (projectResample = resample_default(projectTransform, delta2 = _ * _), reset()) : sqrt5(delta2);
  };
  projection2.fitExtent = function(extent2, object2) {
    return fitExtent(projection2, extent2, object2);
  };
  projection2.fitSize = function(size2, object2) {
    return fitSize(projection2, size2, object2);
  };
  projection2.fitWidth = function(width, object2) {
    return fitWidth(projection2, width, object2);
  };
  projection2.fitHeight = function(height, object2) {
    return fitHeight(projection2, height, object2);
  };
  function recenter() {
    var center3 = scaleTranslateRotate(k4, 0, 0, sx, sy, alpha).apply(null, project(lambda, phi2)), transform2 = scaleTranslateRotate(k4, x3 - center3[0], y3 - center3[1], sx, sy, alpha);
    rotate = rotateRadians(deltaLambda, deltaPhi, deltaGamma);
    projectTransform = compose_default(project, transform2);
    projectRotateTransform = compose_default(rotate, projectTransform);
    projectResample = resample_default(projectTransform, delta2);
    return reset();
  }
  function reset() {
    cache2 = cacheStream = null;
    return projection2;
  }
  return function() {
    project = projectAt.apply(this, arguments);
    projection2.invert = project.invert && invert;
    return recenter();
  };
}

// node_modules/d3-geo/src/projection/conic.js
function conicProjection(projectAt) {
  var phi02 = 0, phi1 = pi6 / 3, m2 = projectionMutator(projectAt), p = m2(phi02, phi1);
  p.parallels = function(_) {
    return arguments.length ? m2(phi02 = _[0] * radians2, phi1 = _[1] * radians2) : [phi02 * degrees3, phi1 * degrees3];
  };
  return p;
}

// node_modules/d3-geo/src/projection/cylindricalEqualArea.js
function cylindricalEqualAreaRaw(phi02) {
  var cosPhi0 = cos3(phi02);
  function forward(lambda, phi2) {
    return [lambda * cosPhi0, sin3(phi2) / cosPhi0];
  }
  forward.invert = function(x3, y3) {
    return [x3 / cosPhi0, asin3(y3 * cosPhi0)];
  };
  return forward;
}

// node_modules/d3-geo/src/projection/conicEqualArea.js
function conicEqualAreaRaw(y06, y13) {
  var sy0 = sin3(y06), n = (sy0 + sin3(y13)) / 2;
  if (abs4(n) < epsilon7) return cylindricalEqualAreaRaw(y06);
  var c3 = 1 + sy0 * (2 * n - sy0), r0 = sqrt5(c3) / n;
  function project(x3, y3) {
    var r = sqrt5(c3 - 2 * n * sin3(y3)) / n;
    return [r * sin3(x3 *= n), r0 - r * cos3(x3)];
  }
  project.invert = function(x3, y3) {
    var r0y = r0 - y3, l = atan23(x3, abs4(r0y)) * sign3(r0y);
    if (r0y * n < 0)
      l -= pi6 * sign3(x3) * sign3(r0y);
    return [l / n, asin3((c3 - (x3 * x3 + r0y * r0y) * n * n) / (2 * n))];
  };
  return project;
}
function conicEqualArea_default() {
  return conicProjection(conicEqualAreaRaw).scale(155.424).center([0, 33.6442]);
}

// node_modules/d3-geo/src/projection/albers.js
function albers_default() {
  return conicEqualArea_default().parallels([29.5, 45.5]).scale(1070).translate([480, 250]).rotate([96, 0]).center([-0.6, 38.7]);
}

// node_modules/d3-geo/src/projection/albersUsa.js
function multiplex(streams) {
  var n = streams.length;
  return {
    point: function(x3, y3) {
      var i = -1;
      while (++i < n) streams[i].point(x3, y3);
    },
    sphere: function() {
      var i = -1;
      while (++i < n) streams[i].sphere();
    },
    lineStart: function() {
      var i = -1;
      while (++i < n) streams[i].lineStart();
    },
    lineEnd: function() {
      var i = -1;
      while (++i < n) streams[i].lineEnd();
    },
    polygonStart: function() {
      var i = -1;
      while (++i < n) streams[i].polygonStart();
    },
    polygonEnd: function() {
      var i = -1;
      while (++i < n) streams[i].polygonEnd();
    }
  };
}
function albersUsa_default() {
  var cache2, cacheStream, lower48 = albers_default(), lower48Point, alaska = conicEqualArea_default().rotate([154, 0]).center([-2, 58.5]).parallels([55, 65]), alaskaPoint, hawaii = conicEqualArea_default().rotate([157, 0]).center([-3, 19.9]).parallels([8, 18]), hawaiiPoint, point13, pointStream = { point: function(x3, y3) {
    point13 = [x3, y3];
  } };
  function albersUsa(coordinates) {
    var x3 = coordinates[0], y3 = coordinates[1];
    return point13 = null, (lower48Point.point(x3, y3), point13) || (alaskaPoint.point(x3, y3), point13) || (hawaiiPoint.point(x3, y3), point13);
  }
  albersUsa.invert = function(coordinates) {
    var k4 = lower48.scale(), t = lower48.translate(), x3 = (coordinates[0] - t[0]) / k4, y3 = (coordinates[1] - t[1]) / k4;
    return (y3 >= 0.12 && y3 < 0.234 && x3 >= -0.425 && x3 < -0.214 ? alaska : y3 >= 0.166 && y3 < 0.234 && x3 >= -0.214 && x3 < -0.115 ? hawaii : lower48).invert(coordinates);
  };
  albersUsa.stream = function(stream) {
    return cache2 && cacheStream === stream ? cache2 : cache2 = multiplex([lower48.stream(cacheStream = stream), alaska.stream(stream), hawaii.stream(stream)]);
  };
  albersUsa.precision = function(_) {
    if (!arguments.length) return lower48.precision();
    lower48.precision(_), alaska.precision(_), hawaii.precision(_);
    return reset();
  };
  albersUsa.scale = function(_) {
    if (!arguments.length) return lower48.scale();
    lower48.scale(_), alaska.scale(_ * 0.35), hawaii.scale(_);
    return albersUsa.translate(lower48.translate());
  };
  albersUsa.translate = function(_) {
    if (!arguments.length) return lower48.translate();
    var k4 = lower48.scale(), x3 = +_[0], y3 = +_[1];
    lower48Point = lower48.translate(_).clipExtent([[x3 - 0.455 * k4, y3 - 0.238 * k4], [x3 + 0.455 * k4, y3 + 0.238 * k4]]).stream(pointStream);
    alaskaPoint = alaska.translate([x3 - 0.307 * k4, y3 + 0.201 * k4]).clipExtent([[x3 - 0.425 * k4 + epsilon7, y3 + 0.12 * k4 + epsilon7], [x3 - 0.214 * k4 - epsilon7, y3 + 0.234 * k4 - epsilon7]]).stream(pointStream);
    hawaiiPoint = hawaii.translate([x3 - 0.205 * k4, y3 + 0.212 * k4]).clipExtent([[x3 - 0.214 * k4 + epsilon7, y3 + 0.166 * k4 + epsilon7], [x3 - 0.115 * k4 - epsilon7, y3 + 0.234 * k4 - epsilon7]]).stream(pointStream);
    return reset();
  };
  albersUsa.fitExtent = function(extent2, object2) {
    return fitExtent(albersUsa, extent2, object2);
  };
  albersUsa.fitSize = function(size2, object2) {
    return fitSize(albersUsa, size2, object2);
  };
  albersUsa.fitWidth = function(width, object2) {
    return fitWidth(albersUsa, width, object2);
  };
  albersUsa.fitHeight = function(height, object2) {
    return fitHeight(albersUsa, height, object2);
  };
  function reset() {
    cache2 = cacheStream = null;
    return albersUsa;
  }
  return albersUsa.scale(1070);
}

// node_modules/d3-geo/src/projection/azimuthal.js
function azimuthalRaw(scale) {
  return function(x3, y3) {
    var cx = cos3(x3), cy = cos3(y3), k4 = scale(cx * cy);
    if (k4 === Infinity) return [2, 0];
    return [
      k4 * cy * sin3(x3),
      k4 * sin3(y3)
    ];
  };
}
function azimuthalInvert(angle) {
  return function(x3, y3) {
    var z = sqrt5(x3 * x3 + y3 * y3), c3 = angle(z), sc = sin3(c3), cc = cos3(c3);
    return [
      atan23(x3 * sc, z * cc),
      asin3(z && y3 * sc / z)
    ];
  };
}

// node_modules/d3-geo/src/projection/azimuthalEqualArea.js
var azimuthalEqualAreaRaw = azimuthalRaw(function(cxcy) {
  return sqrt5(2 / (1 + cxcy));
});
azimuthalEqualAreaRaw.invert = azimuthalInvert(function(z) {
  return 2 * asin3(z / 2);
});
function azimuthalEqualArea_default() {
  return projection(azimuthalEqualAreaRaw).scale(124.75).clipAngle(180 - 1e-3);
}

// node_modules/d3-geo/src/projection/azimuthalEquidistant.js
var azimuthalEquidistantRaw = azimuthalRaw(function(c3) {
  return (c3 = acos3(c3)) && c3 / sin3(c3);
});
azimuthalEquidistantRaw.invert = azimuthalInvert(function(z) {
  return z;
});
function azimuthalEquidistant_default() {
  return projection(azimuthalEquidistantRaw).scale(79.4188).clipAngle(180 - 1e-3);
}

// node_modules/d3-geo/src/projection/mercator.js
function mercatorRaw(lambda, phi2) {
  return [lambda, log2(tan((halfPi4 + phi2) / 2))];
}
mercatorRaw.invert = function(x3, y3) {
  return [x3, 2 * atan(exp(y3)) - halfPi4];
};
function mercator_default() {
  return mercatorProjection(mercatorRaw).scale(961 / tau6);
}
function mercatorProjection(project) {
  var m2 = projection(project), center3 = m2.center, scale = m2.scale, translate = m2.translate, clipExtent = m2.clipExtent, x06 = null, y06, x13, y13;
  m2.scale = function(_) {
    return arguments.length ? (scale(_), reclip()) : scale();
  };
  m2.translate = function(_) {
    return arguments.length ? (translate(_), reclip()) : translate();
  };
  m2.center = function(_) {
    return arguments.length ? (center3(_), reclip()) : center3();
  };
  m2.clipExtent = function(_) {
    return arguments.length ? (_ == null ? x06 = y06 = x13 = y13 = null : (x06 = +_[0][0], y06 = +_[0][1], x13 = +_[1][0], y13 = +_[1][1]), reclip()) : x06 == null ? null : [[x06, y06], [x13, y13]];
  };
  function reclip() {
    var k4 = pi6 * scale(), t = m2(rotation_default(m2.rotate()).invert([0, 0]));
    return clipExtent(x06 == null ? [[t[0] - k4, t[1] - k4], [t[0] + k4, t[1] + k4]] : project === mercatorRaw ? [[Math.max(t[0] - k4, x06), y06], [Math.min(t[0] + k4, x13), y13]] : [[x06, Math.max(t[1] - k4, y06)], [x13, Math.min(t[1] + k4, y13)]]);
  }
  return reclip();
}

// node_modules/d3-geo/src/projection/conicConformal.js
function tany(y3) {
  return tan((halfPi4 + y3) / 2);
}
function conicConformalRaw(y06, y13) {
  var cy0 = cos3(y06), n = y06 === y13 ? sin3(y06) : log2(cy0 / cos3(y13)) / log2(tany(y13) / tany(y06)), f = cy0 * pow2(tany(y06), n) / n;
  if (!n) return mercatorRaw;
  function project(x3, y3) {
    if (f > 0) {
      if (y3 < -halfPi4 + epsilon7) y3 = -halfPi4 + epsilon7;
    } else {
      if (y3 > halfPi4 - epsilon7) y3 = halfPi4 - epsilon7;
    }
    var r = f / pow2(tany(y3), n);
    return [r * sin3(n * x3), f - r * cos3(n * x3)];
  }
  project.invert = function(x3, y3) {
    var fy = f - y3, r = sign3(n) * sqrt5(x3 * x3 + fy * fy), l = atan23(x3, abs4(fy)) * sign3(fy);
    if (fy * n < 0)
      l -= pi6 * sign3(x3) * sign3(fy);
    return [l / n, 2 * atan(pow2(f / r, 1 / n)) - halfPi4];
  };
  return project;
}
function conicConformal_default() {
  return conicProjection(conicConformalRaw).scale(109.5).parallels([30, 30]);
}

// node_modules/d3-geo/src/projection/equirectangular.js
function equirectangularRaw(lambda, phi2) {
  return [lambda, phi2];
}
equirectangularRaw.invert = equirectangularRaw;
function equirectangular_default() {
  return projection(equirectangularRaw).scale(152.63);
}

// node_modules/d3-geo/src/projection/conicEquidistant.js
function conicEquidistantRaw(y06, y13) {
  var cy0 = cos3(y06), n = y06 === y13 ? sin3(y06) : (cy0 - cos3(y13)) / (y13 - y06), g = cy0 / n + y06;
  if (abs4(n) < epsilon7) return equirectangularRaw;
  function project(x3, y3) {
    var gy = g - y3, nx = n * x3;
    return [gy * sin3(nx), g - gy * cos3(nx)];
  }
  project.invert = function(x3, y3) {
    var gy = g - y3, l = atan23(x3, abs4(gy)) * sign3(gy);
    if (gy * n < 0)
      l -= pi6 * sign3(x3) * sign3(gy);
    return [l / n, g - sign3(n) * sqrt5(x3 * x3 + gy * gy)];
  };
  return project;
}
function conicEquidistant_default() {
  return conicProjection(conicEquidistantRaw).scale(131.154).center([0, 13.9389]);
}

// node_modules/d3-geo/src/projection/equalEarth.js
var A1 = 1.340264;
var A2 = -0.081106;
var A3 = 893e-6;
var A4 = 3796e-6;
var M = sqrt5(3) / 2;
var iterations = 12;
function equalEarthRaw(lambda, phi2) {
  var l = asin3(M * sin3(phi2)), l2 = l * l, l6 = l2 * l2 * l2;
  return [
    lambda * cos3(l) / (M * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2))),
    l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2))
  ];
}
equalEarthRaw.invert = function(x3, y3) {
  var l = y3, l2 = l * l, l6 = l2 * l2 * l2;
  for (var i = 0, delta, fy, fpy; i < iterations; ++i) {
    fy = l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2)) - y3;
    fpy = A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2);
    l -= delta = fy / fpy, l2 = l * l, l6 = l2 * l2 * l2;
    if (abs4(delta) < epsilon22) break;
  }
  return [
    M * x3 * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2)) / cos3(l),
    asin3(sin3(l) / M)
  ];
};
function equalEarth_default() {
  return projection(equalEarthRaw).scale(177.158);
}

// node_modules/d3-geo/src/projection/gnomonic.js
function gnomonicRaw(x3, y3) {
  var cy = cos3(y3), k4 = cos3(x3) * cy;
  return [cy * sin3(x3) / k4, sin3(y3) / k4];
}
gnomonicRaw.invert = azimuthalInvert(atan);
function gnomonic_default() {
  return projection(gnomonicRaw).scale(144.049).clipAngle(60);
}

// node_modules/d3-geo/src/projection/naturalEarth1.js
function naturalEarth1Raw(lambda, phi2) {
  var phi22 = phi2 * phi2, phi4 = phi22 * phi22;
  return [
    lambda * (0.8707 - 0.131979 * phi22 + phi4 * (-0.013791 + phi4 * (3971e-6 * phi22 - 1529e-6 * phi4))),
    phi2 * (1.007226 + phi22 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi22 - 5916e-6 * phi4)))
  ];
}
naturalEarth1Raw.invert = function(x3, y3) {
  var phi2 = y3, i = 25, delta;
  do {
    var phi22 = phi2 * phi2, phi4 = phi22 * phi22;
    phi2 -= delta = (phi2 * (1.007226 + phi22 * (0.015085 + phi4 * (-0.044475 + 0.028874 * phi22 - 5916e-6 * phi4))) - y3) / (1.007226 + phi22 * (0.015085 * 3 + phi4 * (-0.044475 * 7 + 0.028874 * 9 * phi22 - 5916e-6 * 11 * phi4)));
  } while (abs4(delta) > epsilon7 && --i > 0);
  return [
    x3 / (0.8707 + (phi22 = phi2 * phi2) * (-0.131979 + phi22 * (-0.013791 + phi22 * phi22 * phi22 * (3971e-6 - 1529e-6 * phi22)))),
    phi2
  ];
};
function naturalEarth1_default() {
  return projection(naturalEarth1Raw).scale(175.295);
}

// node_modules/d3-geo/src/projection/orthographic.js
function orthographicRaw(x3, y3) {
  return [cos3(y3) * sin3(x3), sin3(y3)];
}
orthographicRaw.invert = azimuthalInvert(asin3);
function orthographic_default() {
  return projection(orthographicRaw).scale(249.5).clipAngle(90 + epsilon7);
}

// node_modules/d3-geo/src/projection/stereographic.js
function stereographicRaw(x3, y3) {
  var cy = cos3(y3), k4 = 1 + cos3(x3) * cy;
  return [cy * sin3(x3) / k4, sin3(y3) / k4];
}
stereographicRaw.invert = azimuthalInvert(function(z) {
  return 2 * atan(z);
});
function stereographic_default() {
  return projection(stereographicRaw).scale(250).clipAngle(142);
}

// node_modules/d3-geo/src/projection/transverseMercator.js
function transverseMercatorRaw(lambda, phi2) {
  return [log2(tan((halfPi4 + phi2) / 2)), -lambda];
}
transverseMercatorRaw.invert = function(x3, y3) {
  return [-y3, 2 * atan(exp(x3)) - halfPi4];
};
function transverseMercator_default() {
  var m2 = mercatorProjection(transverseMercatorRaw), center3 = m2.center, rotate = m2.rotate;
  m2.center = function(_) {
    return arguments.length ? center3([-_[1], _[0]]) : (_ = center3(), [_[1], -_[0]]);
  };
  m2.rotate = function(_) {
    return arguments.length ? rotate([_[0], _[1], _.length > 2 ? _[2] + 90 : 90]) : (_ = rotate(), [_[0], _[1], _[2] - 90]);
  };
  return rotate([0, 0, 90]).scale(159.155);
}

// node_modules/topojson-client/src/identity.js
function identity_default8(x3) {
  return x3;
}

// node_modules/topojson-client/src/transform.js
function transform_default2(transform2) {
  if (transform2 == null) return identity_default8;
  var x06, y06, kx4 = transform2.scale[0], ky3 = transform2.scale[1], dx = transform2.translate[0], dy = transform2.translate[1];
  return function(input, i) {
    if (!i) x06 = y06 = 0;
    var j = 2, n = input.length, output = new Array(n);
    output[0] = (x06 += input[0]) * kx4 + dx;
    output[1] = (y06 += input[1]) * ky3 + dy;
    while (j < n) output[j] = input[j], ++j;
    return output;
  };
}

// node_modules/topojson-client/src/reverse.js
function reverse_default3(array3, n) {
  var t, j = array3.length, i = j - n;
  while (i < --j) t = array3[i], array3[i++] = array3[j], array3[j] = t;
}

// node_modules/topojson-client/src/feature.js
function feature_default(topology, o) {
  if (typeof o === "string") o = topology.objects[o];
  return o.type === "GeometryCollection" ? { type: "FeatureCollection", features: o.geometries.map(function(o2) {
    return feature(topology, o2);
  }) } : feature(topology, o);
}
function feature(topology, o) {
  var id2 = o.id, bbox = o.bbox, properties = o.properties == null ? {} : o.properties, geometry = object(topology, o);
  return id2 == null && bbox == null ? { type: "Feature", properties, geometry } : bbox == null ? { type: "Feature", id: id2, properties, geometry } : { type: "Feature", id: id2, bbox, properties, geometry };
}
function object(topology, o) {
  var transformPoint = transform_default2(topology.transform), arcs = topology.arcs;
  function arc2(i, points3) {
    if (points3.length) points3.pop();
    for (var a4 = arcs[i < 0 ? ~i : i], k4 = 0, n = a4.length; k4 < n; ++k4) {
      points3.push(transformPoint(a4[k4], k4));
    }
    if (i < 0) reverse_default3(points3, n);
  }
  function point13(p) {
    return transformPoint(p);
  }
  function line5(arcs2) {
    var points3 = [];
    for (var i = 0, n = arcs2.length; i < n; ++i) arc2(arcs2[i], points3);
    if (points3.length < 2) points3.push(points3[0]);
    return points3;
  }
  function ring(arcs2) {
    var points3 = line5(arcs2);
    while (points3.length < 4) points3.push(points3[0]);
    return points3;
  }
  function polygon2(arcs2) {
    return arcs2.map(ring);
  }
  function geometry(o2) {
    var type2 = o2.type, coordinates;
    switch (type2) {
      case "GeometryCollection":
        return { type: type2, geometries: o2.geometries.map(geometry) };
      case "Point":
        coordinates = point13(o2.coordinates);
        break;
      case "MultiPoint":
        coordinates = o2.coordinates.map(point13);
        break;
      case "LineString":
        coordinates = line5(o2.arcs);
        break;
      case "MultiLineString":
        coordinates = o2.arcs.map(line5);
        break;
      case "Polygon":
        coordinates = polygon2(o2.arcs);
        break;
      case "MultiPolygon":
        coordinates = o2.arcs.map(polygon2);
        break;
      default:
        return null;
    }
    return { type: type2, coordinates };
  }
  return geometry(o);
}

// node_modules/@unovis/ts/data-models/map-graph.js
var MapGraphDataModel = class extends CoreDataModel {
  constructor() {
    super(...arguments);
    this._areas = [];
    this._points = [];
    this._links = [];
    this.pointId = (n) => n.id;
    this.linkSource = (l) => l.source;
    this.linkTarget = (l) => l.target;
  }
  get data() {
    return this._data;
  }
  set data(data) {
    var _a, _b, _c;
    if (!data)
      return;
    this._data = data;
    this._areas = cloneDeep((_a = data === null || data === void 0 ? void 0 : data.areas) !== null && _a !== void 0 ? _a : []);
    this._points = cloneDeep((_b = data === null || data === void 0 ? void 0 : data.points) !== null && _b !== void 0 ? _b : []);
    this._links = cloneDeep((_c = data === null || data === void 0 ? void 0 : data.links) !== null && _c !== void 0 ? _c : []).reduce((arr, link7) => {
      const source = this.findPoint(this.points, this.linkSource(link7));
      const target = this.findPoint(this.points, this.linkTarget(link7));
      if (source && target)
        arr.push({ source, target });
      return arr;
    }, []);
  }
  get areas() {
    return this._areas;
  }
  get points() {
    return this._points;
  }
  get links() {
    return this._links;
  }
  findPoint(points3, pointIdentifier) {
    let foundPoint;
    if (isNumber(pointIdentifier))
      foundPoint = points3[pointIdentifier];
    else if (isString(pointIdentifier))
      foundPoint = points3.find((node4, i) => this.pointId(node4, i) === pointIdentifier);
    else if (isObject(pointIdentifier))
      foundPoint = points3.find((node4) => node4 === pointIdentifier);
    if (!foundPoint) {
      console.warn(`Point ${pointIdentifier} is missing from the points list`);
    }
    return foundPoint;
  }
};

// node_modules/d3-geo-projection/src/math.js
var abs5 = Math.abs;
var atan3 = Math.atan;
var atan24 = Math.atan2;
var cos4 = Math.cos;
var exp2 = Math.exp;
var floor = Math.floor;
var log3 = Math.log;
var max6 = Math.max;
var min6 = Math.min;
var pow3 = Math.pow;
var sign4 = Math.sign || function(x3) {
  return x3 > 0 ? 1 : x3 < 0 ? -1 : 0;
};
var sin4 = Math.sin;
var tan2 = Math.tan;
var epsilon8 = 1e-6;
var epsilon23 = 1e-12;
var pi7 = Math.PI;
var halfPi5 = pi7 / 2;
var quarterPi2 = pi7 / 4;
var sqrt1_2 = Math.SQRT1_2;
var sqrt22 = sqrt6(2);
var sqrtPi = sqrt6(pi7);
var tau7 = pi7 * 2;
var degrees4 = 180 / pi7;
var radians3 = pi7 / 180;
function sinci(x3) {
  return x3 ? x3 / Math.sin(x3) : 1;
}
function asin4(x3) {
  return x3 > 1 ? halfPi5 : x3 < -1 ? -halfPi5 : Math.asin(x3);
}
function acos4(x3) {
  return x3 > 1 ? 0 : x3 < -1 ? pi7 : Math.acos(x3);
}
function sqrt6(x3) {
  return x3 > 0 ? Math.sqrt(x3) : 0;
}
function tanh2(x3) {
  x3 = exp2(2 * x3);
  return (x3 - 1) / (x3 + 1);
}
function sinh2(x3) {
  return (exp2(x3) - exp2(-x3)) / 2;
}
function cosh2(x3) {
  return (exp2(x3) + exp2(-x3)) / 2;
}
function arsinh(x3) {
  return log3(x3 + sqrt6(x3 * x3 + 1));
}
function arcosh(x3) {
  return log3(x3 + sqrt6(x3 * x3 - 1));
}

// node_modules/d3-geo-projection/src/aitoff.js
function aitoffRaw(x3, y3) {
  var cosy = cos4(y3), sincia = sinci(acos4(cosy * cos4(x3 /= 2)));
  return [2 * cosy * sin4(x3) * sincia, sin4(y3) * sincia];
}
aitoffRaw.invert = function(x3, y3) {
  if (x3 * x3 + 4 * y3 * y3 > pi7 * pi7 + epsilon8) return;
  var x13 = x3, y13 = y3, i = 25;
  do {
    var sinx = sin4(x13), sinx_2 = sin4(x13 / 2), cosx_2 = cos4(x13 / 2), siny = sin4(y13), cosy = cos4(y13), sin_2y = sin4(2 * y13), sin2y = siny * siny, cos2y = cosy * cosy, sin2x_2 = sinx_2 * sinx_2, c3 = 1 - cos2y * cosx_2 * cosx_2, e = c3 ? acos4(cosy * cosx_2) * sqrt6(f = 1 / c3) : f = 0, f, fx = 2 * e * cosy * sinx_2 - x3, fy = e * siny - y3, dxdx = f * (cos2y * sin2x_2 + e * cosy * cosx_2 * sin2y), dxdy = f * (0.5 * sinx * sin_2y - e * 2 * siny * sinx_2), dydx = f * 0.25 * (sin_2y * sinx_2 - e * siny * cos2y * sinx), dydy = f * (sin2y * cosx_2 + e * sin2x_2 * cosy), z = dxdy * dydx - dydy * dxdx;
    if (!z) break;
    var dx = (fy * dxdy - fx * dydy) / z, dy = (fx * dydx - fy * dxdx) / z;
    x13 -= dx, y13 -= dy;
  } while ((abs5(dx) > epsilon8 || abs5(dy) > epsilon8) && --i > 0);
  return [x13, y13];
};
function aitoff_default() {
  return projection(aitoffRaw).scale(152.63);
}

// node_modules/d3-geo-projection/src/armadillo.js
function armadilloRaw(phi02) {
  var sinPhi0 = sin4(phi02), cosPhi0 = cos4(phi02), sPhi0 = phi02 >= 0 ? 1 : -1, tanPhi0 = tan2(sPhi0 * phi02), k4 = (1 + sinPhi0 - cosPhi0) / 2;
  function forward(lambda, phi2) {
    var cosPhi = cos4(phi2), cosLambda = cos4(lambda /= 2);
    return [
      (1 + cosPhi) * sin4(lambda),
      (sPhi0 * phi2 > -atan24(cosLambda, tanPhi0) - 1e-3 ? 0 : -sPhi0 * 10) + k4 + sin4(phi2) * cosPhi0 - (1 + cosPhi) * sinPhi0 * cosLambda
      // TODO D3 core should allow null or [NaN, NaN] to be returned.
    ];
  }
  forward.invert = function(x3, y3) {
    var lambda = 0, phi2 = 0, i = 50;
    do {
      var cosLambda = cos4(lambda), sinLambda = sin4(lambda), cosPhi = cos4(phi2), sinPhi = sin4(phi2), A6 = 1 + cosPhi, fx = A6 * sinLambda - x3, fy = k4 + sinPhi * cosPhi0 - A6 * sinPhi0 * cosLambda - y3, dxdLambda = A6 * cosLambda / 2, dxdPhi = -sinLambda * sinPhi, dydLambda = sinPhi0 * A6 * sinLambda / 2, dydPhi = cosPhi0 * cosPhi + sinPhi0 * cosLambda * sinPhi, denominator = dxdPhi * dydLambda - dydPhi * dxdLambda, dLambda = (fy * dxdPhi - fx * dydPhi) / denominator / 2, dPhi = (fx * dydLambda - fy * dxdLambda) / denominator;
      if (abs5(dPhi) > 2) dPhi /= 2;
      lambda -= dLambda, phi2 -= dPhi;
    } while ((abs5(dLambda) > epsilon8 || abs5(dPhi) > epsilon8) && --i > 0);
    return sPhi0 * phi2 > -atan24(cos4(lambda), tanPhi0) - 1e-3 ? [lambda * 2, phi2] : null;
  };
  return forward;
}
function armadillo_default() {
  var phi02 = 20 * radians3, sPhi0 = phi02 >= 0 ? 1 : -1, tanPhi0 = tan2(sPhi0 * phi02), m2 = projectionMutator(armadilloRaw), p = m2(phi02), stream_ = p.stream;
  p.parallel = function(_) {
    if (!arguments.length) return phi02 * degrees4;
    tanPhi0 = tan2((sPhi0 = (phi02 = _ * radians3) >= 0 ? 1 : -1) * phi02);
    return m2(phi02);
  };
  p.stream = function(stream) {
    var rotate = p.rotate(), rotateStream = stream_(stream), sphereStream = (p.rotate([0, 0]), stream_(stream)), precision = p.precision();
    p.rotate(rotate);
    rotateStream.sphere = function() {
      sphereStream.polygonStart(), sphereStream.lineStart();
      for (var lambda = sPhi0 * -180; sPhi0 * lambda < 180; lambda += sPhi0 * 90)
        sphereStream.point(lambda, sPhi0 * 90);
      if (phi02) while (sPhi0 * (lambda -= 3 * sPhi0 * precision) >= -180) {
        sphereStream.point(lambda, sPhi0 * -atan24(cos4(lambda * radians3 / 2), tanPhi0) * degrees4);
      }
      sphereStream.lineEnd(), sphereStream.polygonEnd();
    };
    return rotateStream;
  };
  return p.scale(218.695).center([0, 28.0974]);
}

// node_modules/d3-geo-projection/src/august.js
function augustRaw(lambda, phi2) {
  var tanPhi = tan2(phi2 / 2), k4 = sqrt6(1 - tanPhi * tanPhi), c3 = 1 + k4 * cos4(lambda /= 2), x3 = sin4(lambda) * k4 / c3, y3 = tanPhi / c3, x22 = x3 * x3, y22 = y3 * y3;
  return [
    4 / 3 * x3 * (3 + x22 - 3 * y22),
    4 / 3 * y3 * (3 + 3 * x22 - y22)
  ];
}
augustRaw.invert = function(x3, y3) {
  x3 *= 3 / 8, y3 *= 3 / 8;
  if (!x3 && abs5(y3) > 1) return null;
  var x22 = x3 * x3, y22 = y3 * y3, s3 = 1 + x22 + y22, sin3Eta = sqrt6((s3 - sqrt6(s3 * s3 - 4 * y3 * y3)) / 2), eta = asin4(sin3Eta) / 3, xi = sin3Eta ? arcosh(abs5(y3 / sin3Eta)) / 3 : arsinh(abs5(x3)) / 3, cosEta = cos4(eta), coshXi = cosh2(xi), d = coshXi * coshXi - cosEta * cosEta;
  return [
    sign4(x3) * 2 * atan24(sinh2(xi) * cosEta, 0.25 - d),
    sign4(y3) * 2 * atan24(coshXi * sin4(eta), 0.25 + d)
  ];
};

// node_modules/d3-geo-projection/src/baker.js
var sqrt8 = sqrt6(8);
var phi0 = log3(1 + sqrt22);
function bakerRaw(lambda, phi2) {
  var phi02 = abs5(phi2);
  return phi02 < quarterPi2 ? [lambda, log3(tan2(quarterPi2 + phi2 / 2))] : [lambda * cos4(phi02) * (2 * sqrt22 - 1 / sin4(phi02)), sign4(phi2) * (2 * sqrt22 * (phi02 - quarterPi2) - log3(tan2(phi02 / 2)))];
}
bakerRaw.invert = function(x3, y3) {
  if ((y06 = abs5(y3)) < phi0) return [x3, 2 * atan3(exp2(y3)) - halfPi5];
  var phi2 = quarterPi2, i = 25, delta, y06;
  do {
    var cosPhi_2 = cos4(phi2 / 2), tanPhi_2 = tan2(phi2 / 2);
    phi2 -= delta = (sqrt8 * (phi2 - quarterPi2) - log3(tanPhi_2) - y06) / (sqrt8 - cosPhi_2 * cosPhi_2 / (2 * tanPhi_2));
  } while (abs5(delta) > epsilon23 && --i > 0);
  return [x3 / (cos4(phi2) * (sqrt8 - 1 / sin4(phi2))), sign4(y3) * phi2];
};
function baker_default() {
  return projection(bakerRaw).scale(112.314);
}

// node_modules/d3-geo-projection/src/hammer.js
function hammerQuarticAuthalicRaw(lambda, phi2) {
  return [
    lambda * cos4(phi2) / cos4(phi2 /= 2),
    2 * sin4(phi2)
  ];
}
hammerQuarticAuthalicRaw.invert = function(x3, y3) {
  var phi2 = 2 * asin4(y3 / 2);
  return [
    x3 * cos4(phi2 / 2) / cos4(phi2),
    phi2
  ];
};

// node_modules/d3-geo-projection/src/newton.js
function solve(f, y3, x3) {
  var steps = 100, delta, f0, f1;
  x3 = x3 === void 0 ? 0 : +x3;
  y3 = +y3;
  do {
    f0 = f(x3);
    f1 = f(x3 + epsilon8);
    if (f0 === f1) f1 = f0 + epsilon8;
    x3 -= delta = -1 * epsilon8 * (f0 - y3) / (f0 - f1);
  } while (steps-- > 0 && abs5(delta) > epsilon8);
  return steps < 0 ? NaN : x3;
}

// node_modules/d3-geo-projection/src/mollweide.js
function mollweideBromleyTheta(cp, phi2) {
  var cpsinPhi = cp * sin4(phi2), i = 30, delta;
  do
    phi2 -= delta = (phi2 + sin4(phi2) - cpsinPhi) / (1 + cos4(phi2));
  while (abs5(delta) > epsilon8 && --i > 0);
  return phi2 / 2;
}
function mollweideBromleyRaw(cx, cy, cp) {
  function forward(lambda, phi2) {
    return [cx * lambda * cos4(phi2 = mollweideBromleyTheta(cp, phi2)), cy * sin4(phi2)];
  }
  forward.invert = function(x3, y3) {
    return y3 = asin4(y3 / cy), [x3 / (cx * cos4(y3)), asin4((2 * y3 + sin4(2 * y3)) / cp)];
  };
  return forward;
}
var mollweideRaw = mollweideBromleyRaw(sqrt22 / halfPi5, sqrt22, pi7);

// node_modules/d3-geo-projection/src/boggs.js
var k3 = 2.00276;
var w = 1.11072;
function boggsRaw(lambda, phi2) {
  var theta = mollweideBromleyTheta(pi7, phi2);
  return [k3 * lambda / (1 / cos4(phi2) + w / cos4(theta)), (phi2 + sqrt22 * sin4(theta)) / k3];
}
boggsRaw.invert = function(x3, y3) {
  var ky3 = k3 * y3, theta = y3 < 0 ? -quarterPi2 : quarterPi2, i = 25, delta, phi2;
  do {
    phi2 = ky3 - sqrt22 * sin4(theta);
    theta -= delta = (sin4(2 * theta) + 2 * theta - pi7 * sin4(phi2)) / (2 * cos4(2 * theta) + 2 + pi7 * cos4(phi2) * sqrt22 * cos4(theta));
  } while (abs5(delta) > epsilon8 && --i > 0);
  phi2 = ky3 - sqrt22 * sin4(theta);
  return [x3 * (1 / cos4(phi2) + w / cos4(theta)) / k3, phi2];
};
function boggs_default() {
  return projection(boggsRaw).scale(160.857);
}

// node_modules/d3-geo-projection/src/parallel1.js
function parallel1_default(projectAt) {
  var phi02 = 0, m2 = projectionMutator(projectAt), p = m2(phi02);
  p.parallel = function(_) {
    return arguments.length ? m2(phi02 = _ * radians3) : phi02 * degrees4;
  };
  return p;
}

// node_modules/d3-geo-projection/src/sinusoidal.js
function sinusoidalRaw(lambda, phi2) {
  return [lambda * cos4(phi2), phi2];
}
sinusoidalRaw.invert = function(x3, y3) {
  return [x3 / cos4(y3), y3];
};

// node_modules/d3-geo-projection/src/bromley.js
var bromleyRaw = mollweideBromleyRaw(1, 4 / pi7, pi7);
function bromley_default() {
  return projection(bromleyRaw).scale(152.63);
}

// node_modules/d3-geo-projection/src/collignon.js
function collignonRaw(lambda, phi2) {
  var alpha = sqrt6(1 - sin4(phi2));
  return [2 / sqrtPi * lambda * alpha, sqrtPi * (1 - alpha)];
}
collignonRaw.invert = function(x3, y3) {
  var lambda = (lambda = y3 / sqrtPi - 1) * lambda;
  return [lambda > 0 ? x3 * sqrt6(pi7 / lambda) / 2 : 0, asin4(1 - lambda)];
};

// node_modules/d3-geo-projection/src/craster.js
var sqrt35 = sqrt6(3);
function crasterRaw(lambda, phi2) {
  return [sqrt35 * lambda * (2 * cos4(2 * phi2 / 3) - 1) / sqrtPi, sqrt35 * sqrtPi * sin4(phi2 / 3)];
}
crasterRaw.invert = function(x3, y3) {
  var phi2 = 3 * asin4(y3 / (sqrt35 * sqrtPi));
  return [sqrtPi * x3 / (sqrt35 * (2 * cos4(2 * phi2 / 3) - 1)), phi2];
};
function craster_default() {
  return projection(crasterRaw).scale(156.19);
}

// node_modules/d3-geo-projection/src/cylindricalEqualArea.js
function cylindricalEqualAreaRaw2(phi02) {
  var cosPhi0 = cos4(phi02);
  function forward(lambda, phi2) {
    return [lambda * cosPhi0, sin4(phi2) / cosPhi0];
  }
  forward.invert = function(x3, y3) {
    return [x3 / cosPhi0, asin4(y3 * cosPhi0)];
  };
  return forward;
}

// node_modules/d3-geo-projection/src/cylindricalStereographic.js
function cylindricalStereographicRaw(phi02) {
  var cosPhi0 = cos4(phi02);
  function forward(lambda, phi2) {
    return [lambda * cosPhi0, (1 + cosPhi0) * tan2(phi2 / 2)];
  }
  forward.invert = function(x3, y3) {
    return [x3 / cosPhi0, atan3(y3 / (1 + cosPhi0)) * 2];
  };
  return forward;
}
function cylindricalStereographic_default() {
  return parallel1_default(cylindricalStereographicRaw).scale(124.75);
}

// node_modules/d3-geo-projection/src/eckert1.js
function eckert1Raw(lambda, phi2) {
  var alpha = sqrt6(8 / (3 * pi7));
  return [
    alpha * lambda * (1 - abs5(phi2) / pi7),
    alpha * phi2
  ];
}
eckert1Raw.invert = function(x3, y3) {
  var alpha = sqrt6(8 / (3 * pi7)), phi2 = y3 / alpha;
  return [
    x3 / (alpha * (1 - abs5(phi2) / pi7)),
    phi2
  ];
};
function eckert1_default() {
  return projection(eckert1Raw).scale(165.664);
}

// node_modules/d3-geo-projection/src/eckert2.js
function eckert2Raw(lambda, phi2) {
  var alpha = sqrt6(4 - 3 * sin4(abs5(phi2)));
  return [
    2 / sqrt6(6 * pi7) * lambda * alpha,
    sign4(phi2) * sqrt6(2 * pi7 / 3) * (2 - alpha)
  ];
}
eckert2Raw.invert = function(x3, y3) {
  var alpha = 2 - abs5(y3) / sqrt6(2 * pi7 / 3);
  return [
    x3 * sqrt6(6 * pi7) / (2 * alpha),
    sign4(y3) * asin4((4 - alpha * alpha) / 3)
  ];
};

// node_modules/d3-geo-projection/src/eckert3.js
function eckert3Raw(lambda, phi2) {
  var k4 = sqrt6(pi7 * (4 + pi7));
  return [
    2 / k4 * lambda * (1 + sqrt6(1 - 4 * phi2 * phi2 / (pi7 * pi7))),
    4 / k4 * phi2
  ];
}
eckert3Raw.invert = function(x3, y3) {
  var k4 = sqrt6(pi7 * (4 + pi7)) / 2;
  return [
    x3 * k4 / (1 + sqrt6(1 - y3 * y3 * (4 + pi7) / (4 * pi7))),
    y3 * k4 / 2
  ];
};
function eckert3_default() {
  return projection(eckert3Raw).scale(180.739);
}

// node_modules/d3-geo-projection/src/eckert4.js
function eckert4Raw(lambda, phi2) {
  var k4 = (2 + halfPi5) * sin4(phi2);
  phi2 /= 2;
  for (var i = 0, delta = Infinity; i < 10 && abs5(delta) > epsilon8; i++) {
    var cosPhi = cos4(phi2);
    phi2 -= delta = (phi2 + sin4(phi2) * (cosPhi + 2) - k4) / (2 * cosPhi * (1 + cosPhi));
  }
  return [
    2 / sqrt6(pi7 * (4 + pi7)) * lambda * (1 + cos4(phi2)),
    2 * sqrt6(pi7 / (4 + pi7)) * sin4(phi2)
  ];
}
eckert4Raw.invert = function(x3, y3) {
  var A6 = y3 * sqrt6((4 + pi7) / pi7) / 2, k4 = asin4(A6), c3 = cos4(k4);
  return [
    x3 / (2 / sqrt6(pi7 * (4 + pi7)) * (1 + c3)),
    asin4((k4 + A6 * (c3 + 2)) / (2 + halfPi5))
  ];
};

// node_modules/d3-geo-projection/src/eckert5.js
function eckert5Raw(lambda, phi2) {
  return [
    lambda * (1 + cos4(phi2)) / sqrt6(2 + pi7),
    2 * phi2 / sqrt6(2 + pi7)
  ];
}
eckert5Raw.invert = function(x3, y3) {
  var k4 = sqrt6(2 + pi7), phi2 = y3 * k4 / 2;
  return [
    k4 * x3 / (1 + cos4(phi2)),
    phi2
  ];
};

// node_modules/d3-geo-projection/src/eckert6.js
function eckert6Raw(lambda, phi2) {
  var k4 = (1 + halfPi5) * sin4(phi2);
  for (var i = 0, delta = Infinity; i < 10 && abs5(delta) > epsilon8; i++) {
    phi2 -= delta = (phi2 + sin4(phi2) - k4) / (1 + cos4(phi2));
  }
  k4 = sqrt6(2 + pi7);
  return [
    lambda * (1 + cos4(phi2)) / k4,
    2 * phi2 / k4
  ];
}
eckert6Raw.invert = function(x3, y3) {
  var j = 1 + halfPi5, k4 = sqrt6(j / 2);
  return [
    x3 * 2 * k4 / (1 + cos4(y3 *= k4)),
    asin4((y3 + sin4(y3)) / j)
  ];
};

// node_modules/d3-geo-projection/src/eisenlohr.js
var eisenlohrK = 3 + 2 * sqrt22;
function eisenlohrRaw(lambda, phi2) {
  var s0 = sin4(lambda /= 2), c0 = cos4(lambda), k4 = sqrt6(cos4(phi2)), c1 = cos4(phi2 /= 2), t = sin4(phi2) / (c1 + sqrt22 * c0 * k4), c3 = sqrt6(2 / (1 + t * t)), v = sqrt6((sqrt22 * c1 + (c0 + s0) * k4) / (sqrt22 * c1 + (c0 - s0) * k4));
  return [
    eisenlohrK * (c3 * (v - 1 / v) - 2 * log3(v)),
    eisenlohrK * (c3 * t * (v + 1 / v) - 2 * atan3(t))
  ];
}
eisenlohrRaw.invert = function(x3, y3) {
  if (!(p = augustRaw.invert(x3 / 1.2, y3 * 1.065))) return null;
  var lambda = p[0], phi2 = p[1], i = 20, p;
  x3 /= eisenlohrK, y3 /= eisenlohrK;
  do {
    var _0 = lambda / 2, _1 = phi2 / 2, s0 = sin4(_0), c0 = cos4(_0), s1 = sin4(_1), c1 = cos4(_1), cos1 = cos4(phi2), k4 = sqrt6(cos1), t = s1 / (c1 + sqrt22 * c0 * k4), t22 = t * t, c3 = sqrt6(2 / (1 + t22)), v0 = sqrt22 * c1 + (c0 + s0) * k4, v1 = sqrt22 * c1 + (c0 - s0) * k4, v2 = v0 / v1, v = sqrt6(v2), vm1v = v - 1 / v, vp1v = v + 1 / v, fx = c3 * vm1v - 2 * log3(v) - x3, fy = c3 * t * vp1v - 2 * atan3(t) - y3, deltatDeltaLambda = s1 && sqrt1_2 * k4 * s0 * t22 / s1, deltatDeltaPhi = (sqrt22 * c0 * c1 + k4) / (2 * (c1 + sqrt22 * c0 * k4) * (c1 + sqrt22 * c0 * k4) * k4), deltacDeltat = -0.5 * t * c3 * c3 * c3, deltacDeltaLambda = deltacDeltat * deltatDeltaLambda, deltacDeltaPhi = deltacDeltat * deltatDeltaPhi, A6 = (A6 = 2 * c1 + sqrt22 * k4 * (c0 - s0)) * A6 * v, deltavDeltaLambda = (sqrt22 * c0 * c1 * k4 + cos1) / A6, deltavDeltaPhi = -(sqrt22 * s0 * s1) / (k4 * A6), deltaxDeltaLambda = vm1v * deltacDeltaLambda - 2 * deltavDeltaLambda / v + c3 * (deltavDeltaLambda + deltavDeltaLambda / v2), deltaxDeltaPhi = vm1v * deltacDeltaPhi - 2 * deltavDeltaPhi / v + c3 * (deltavDeltaPhi + deltavDeltaPhi / v2), deltayDeltaLambda = t * vp1v * deltacDeltaLambda - 2 * deltatDeltaLambda / (1 + t22) + c3 * vp1v * deltatDeltaLambda + c3 * t * (deltavDeltaLambda - deltavDeltaLambda / v2), deltayDeltaPhi = t * vp1v * deltacDeltaPhi - 2 * deltatDeltaPhi / (1 + t22) + c3 * vp1v * deltatDeltaPhi + c3 * t * (deltavDeltaPhi - deltavDeltaPhi / v2), denominator = deltaxDeltaPhi * deltayDeltaLambda - deltayDeltaPhi * deltaxDeltaLambda;
    if (!denominator) break;
    var deltaLambda = (fy * deltaxDeltaPhi - fx * deltayDeltaPhi) / denominator, deltaPhi = (fx * deltayDeltaLambda - fy * deltaxDeltaLambda) / denominator;
    lambda -= deltaLambda;
    phi2 = max6(-halfPi5, min6(halfPi5, phi2 - deltaPhi));
  } while ((abs5(deltaLambda) > epsilon8 || abs5(deltaPhi) > epsilon8) && --i > 0);
  return abs5(abs5(phi2) - halfPi5) < epsilon8 ? [0, phi2] : i && [lambda, phi2];
};

// node_modules/d3-geo-projection/src/fahey.js
var faheyK = cos4(35 * radians3);
function faheyRaw(lambda, phi2) {
  var t = tan2(phi2 / 2);
  return [lambda * faheyK * sqrt6(1 - t * t), (1 + faheyK) * t];
}
faheyRaw.invert = function(x3, y3) {
  var t = y3 / (1 + faheyK);
  return [x3 && x3 / (faheyK * sqrt6(1 - t * t)), 2 * atan3(t)];
};
function fahey_default() {
  return projection(faheyRaw).scale(137.152);
}

// node_modules/d3-geo-projection/src/foucaut.js
function foucautRaw(lambda, phi2) {
  var k4 = phi2 / 2, cosk = cos4(k4);
  return [2 * lambda / sqrtPi * cos4(phi2) * cosk * cosk, sqrtPi * tan2(k4)];
}
foucautRaw.invert = function(x3, y3) {
  var k4 = atan3(y3 / sqrtPi), cosk = cos4(k4), phi2 = 2 * k4;
  return [x3 * sqrtPi / 2 / (cos4(phi2) * cosk * cosk), phi2];
};

// node_modules/d3-geo-projection/src/foucautSinusoidal.js
function foucautSinusoidalRaw(alpha) {
  var beta = 1 - alpha, equatorial = raw(pi7, 0)[0] - raw(-pi7, 0)[0], polar = raw(0, halfPi5)[1] - raw(0, -halfPi5)[1], ratio = sqrt6(2 * polar / equatorial);
  function raw(lambda, phi2) {
    var cosphi = cos4(phi2), sinphi = sin4(phi2);
    return [
      cosphi / (beta + alpha * cosphi) * lambda,
      beta * phi2 + alpha * sinphi
    ];
  }
  function forward(lambda, phi2) {
    var p = raw(lambda, phi2);
    return [p[0] * ratio, p[1] / ratio];
  }
  function forwardMeridian(phi2) {
    return forward(0, phi2)[1];
  }
  forward.invert = function(x3, y3) {
    var phi2 = solve(forwardMeridian, y3), lambda = x3 / ratio * (alpha + beta / cos4(phi2));
    return [lambda, phi2];
  };
  return forward;
}
function foucautSinusoidal_default() {
  var alpha = 0.5, m2 = projectionMutator(foucautSinusoidalRaw), p = m2(alpha);
  p.alpha = function(_) {
    return arguments.length ? m2(alpha = +_) : alpha;
  };
  return p.scale(168.725);
}

// node_modules/d3-geo-projection/src/ginzburgPolyconic.js
function ginzburgPolyconic_default(a4, b, c3, d, e, f, g, h) {
  if (arguments.length < 8) h = 0;
  function forward(lambda, phi2) {
    if (!phi2) return [a4 * lambda / pi7, 0];
    var phi22 = phi2 * phi2, xB = a4 + phi22 * (b + phi22 * (c3 + phi22 * d)), yB = phi2 * (e - 1 + phi22 * (f - h + phi22 * g)), m2 = (xB * xB + yB * yB) / (2 * yB), alpha = lambda * asin4(xB / m2) / pi7;
    return [m2 * sin4(alpha), phi2 * (1 + phi22 * h) + m2 * (1 - cos4(alpha))];
  }
  forward.invert = function(x3, y3) {
    var lambda = pi7 * x3 / a4, phi2 = y3, deltaLambda, deltaPhi, i = 50;
    do {
      var phi22 = phi2 * phi2, xB = a4 + phi22 * (b + phi22 * (c3 + phi22 * d)), yB = phi2 * (e - 1 + phi22 * (f - h + phi22 * g)), p = xB * xB + yB * yB, q = 2 * yB, m2 = p / q, m22 = m2 * m2, dAlphadLambda = asin4(xB / m2) / pi7, alpha = lambda * dAlphadLambda, xB2 = xB * xB, dxBdPhi = (2 * b + phi22 * (4 * c3 + phi22 * 6 * d)) * phi2, dyBdPhi = e + phi22 * (3 * f + phi22 * 5 * g), dpdPhi = 2 * (xB * dxBdPhi + yB * (dyBdPhi - 1)), dqdPhi = 2 * (dyBdPhi - 1), dmdPhi = (dpdPhi * q - p * dqdPhi) / (q * q), cosAlpha = cos4(alpha), sinAlpha = sin4(alpha), mcosAlpha = m2 * cosAlpha, msinAlpha = m2 * sinAlpha, dAlphadPhi = lambda / pi7 * (1 / sqrt6(1 - xB2 / m22)) * (dxBdPhi * m2 - xB * dmdPhi) / m22, fx = msinAlpha - x3, fy = phi2 * (1 + phi22 * h) + m2 - mcosAlpha - y3, deltaxDeltaPhi = dmdPhi * sinAlpha + mcosAlpha * dAlphadPhi, deltaxDeltaLambda = mcosAlpha * dAlphadLambda, deltayDeltaPhi = 1 + dmdPhi - (dmdPhi * cosAlpha - msinAlpha * dAlphadPhi), deltayDeltaLambda = msinAlpha * dAlphadLambda, denominator = deltaxDeltaPhi * deltayDeltaLambda - deltayDeltaPhi * deltaxDeltaLambda;
      if (!denominator) break;
      lambda -= deltaLambda = (fy * deltaxDeltaPhi - fx * deltayDeltaPhi) / denominator;
      phi2 -= deltaPhi = (fx * deltayDeltaLambda - fy * deltaxDeltaLambda) / denominator;
    } while ((abs5(deltaLambda) > epsilon8 || abs5(deltaPhi) > epsilon8) && --i > 0);
    return [lambda, phi2];
  };
  return forward;
}

// node_modules/d3-geo-projection/src/ginzburg4.js
var ginzburg4Raw = ginzburgPolyconic_default(2.8284, -1.6988, 0.75432, -0.18071, 1.76003, -0.38914, 0.042555);

// node_modules/d3-geo-projection/src/ginzburg5.js
var ginzburg5Raw = ginzburgPolyconic_default(2.583819, -0.835827, 0.170354, -0.038094, 1.543313, -0.411435, 0.082742);

// node_modules/d3-geo-projection/src/ginzburg6.js
var ginzburg6Raw = ginzburgPolyconic_default(5 / 6 * pi7, -0.62636, -0.0344, 0, 1.3493, -0.05524, 0, 0.045);

// node_modules/d3-geo-projection/src/ginzburg8.js
function ginzburg8Raw(lambda, phi2) {
  var lambda2 = lambda * lambda, phi22 = phi2 * phi2;
  return [
    lambda * (1 - 0.162388 * phi22) * (0.87 - 952426e-9 * lambda2 * lambda2),
    phi2 * (1 + phi22 / 12)
  ];
}
ginzburg8Raw.invert = function(x3, y3) {
  var lambda = x3, phi2 = y3, i = 50, delta;
  do {
    var phi22 = phi2 * phi2;
    phi2 -= delta = (phi2 * (1 + phi22 / 12) - y3) / (1 + phi22 / 4);
  } while (abs5(delta) > epsilon8 && --i > 0);
  i = 50;
  x3 /= 1 - 0.162388 * phi22;
  do {
    var lambda4 = (lambda4 = lambda * lambda) * lambda4;
    lambda -= delta = (lambda * (0.87 - 952426e-9 * lambda4) - x3) / (0.87 - 476213e-8 * lambda4);
  } while (abs5(delta) > epsilon8 && --i > 0);
  return [lambda, phi2];
};

// node_modules/d3-geo-projection/src/ginzburg9.js
var ginzburg9Raw = ginzburgPolyconic_default(2.6516, -0.76534, 0.19123, -0.047094, 1.36289, -0.13965, 0.031762);

// node_modules/d3-geo-projection/src/gringorten.js
function gringortenRaw(lambda, phi2) {
  var sLambda = sign4(lambda), sPhi = sign4(phi2), cosPhi = cos4(phi2), x3 = cos4(lambda) * cosPhi, y3 = sin4(lambda) * cosPhi, z = sin4(sPhi * phi2);
  lambda = abs5(atan24(y3, z));
  phi2 = asin4(x3);
  if (abs5(lambda - halfPi5) > epsilon8) lambda %= halfPi5;
  var point13 = gringortenHexadecant(lambda > pi7 / 4 ? halfPi5 - lambda : lambda, phi2);
  if (lambda > pi7 / 4) z = point13[0], point13[0] = -point13[1], point13[1] = -z;
  return point13[0] *= sLambda, point13[1] *= -sPhi, point13;
}
gringortenRaw.invert = function(x3, y3) {
  if (abs5(x3) > 1) x3 = sign4(x3) * 2 - x3;
  if (abs5(y3) > 1) y3 = sign4(y3) * 2 - y3;
  var sx = sign4(x3), sy = sign4(y3), x06 = -sx * x3, y06 = -sy * y3, t = y06 / x06 < 1, p = gringortenHexadecantInvert(t ? y06 : x06, t ? x06 : y06), lambda = p[0], phi2 = p[1], cosPhi = cos4(phi2);
  if (t) lambda = -halfPi5 - lambda;
  return [sx * (atan24(sin4(lambda) * cosPhi, -sin4(phi2)) + pi7), sy * asin4(cos4(lambda) * cosPhi)];
};
function gringortenHexadecant(lambda, phi2) {
  if (phi2 === halfPi5) return [0, 0];
  var sinPhi = sin4(phi2), r = sinPhi * sinPhi, r2 = r * r, j = 1 + r2, k4 = 1 + 3 * r2, q = 1 - r2, z = asin4(1 / sqrt6(j)), v = q + r * j * z, p2 = (1 - sinPhi) / v, p = sqrt6(p2), a22 = p2 * j, a4 = sqrt6(a22), h = p * q, x3, i;
  if (lambda === 0) return [0, -(h + r * a4)];
  var cosPhi = cos4(phi2), secPhi = 1 / cosPhi, drdPhi = 2 * sinPhi * cosPhi, dvdPhi = (-3 * r + z * k4) * drdPhi, dp2dPhi = (-v * cosPhi - (1 - sinPhi) * dvdPhi) / (v * v), dpdPhi = 0.5 * dp2dPhi / p, dhdPhi = q * dpdPhi - 2 * r * p * drdPhi, dra2dPhi = r * j * dp2dPhi + p2 * k4 * drdPhi, mu = -secPhi * drdPhi, nu = -secPhi * dra2dPhi, zeta = -2 * secPhi * dhdPhi, lambda1 = 4 * lambda / pi7, delta;
  if (lambda > 0.222 * pi7 || phi2 < pi7 / 4 && lambda > 0.175 * pi7) {
    x3 = (h + r * sqrt6(a22 * (1 + r2) - h * h)) / (1 + r2);
    if (lambda > pi7 / 4) return [x3, x3];
    var x13 = x3, x06 = 0.5 * x3;
    x3 = 0.5 * (x06 + x13), i = 50;
    do {
      var g = sqrt6(a22 - x3 * x3), f = x3 * (zeta + mu * g) + nu * asin4(x3 / a4) - lambda1;
      if (!f) break;
      if (f < 0) x06 = x3;
      else x13 = x3;
      x3 = 0.5 * (x06 + x13);
    } while (abs5(x13 - x06) > epsilon8 && --i > 0);
  } else {
    x3 = epsilon8, i = 25;
    do {
      var x22 = x3 * x3, g2 = sqrt6(a22 - x22), zetaMug = zeta + mu * g2, f2 = x3 * zetaMug + nu * asin4(x3 / a4) - lambda1, df = zetaMug + (nu - mu * x22) / g2;
      x3 -= delta = g2 ? f2 / df : 0;
    } while (abs5(delta) > epsilon8 && --i > 0);
  }
  return [x3, -h - r * sqrt6(a22 - x3 * x3)];
}
function gringortenHexadecantInvert(x3, y3) {
  var x06 = 0, x13 = 1, r = 0.5, i = 50;
  while (true) {
    var r2 = r * r, sinPhi = sqrt6(r), z = asin4(1 / sqrt6(1 + r2)), v = 1 - r2 + r * (1 + r2) * z, p2 = (1 - sinPhi) / v, p = sqrt6(p2), a22 = p2 * (1 + r2), h = p * (1 - r2), g2 = a22 - x3 * x3, g = sqrt6(g2), y06 = y3 + h + r * g;
    if (abs5(x13 - x06) < epsilon23 || --i === 0 || y06 === 0) break;
    if (y06 > 0) x06 = r;
    else x13 = r;
    r = 0.5 * (x06 + x13);
  }
  if (!i) return null;
  var phi2 = asin4(sinPhi), cosPhi = cos4(phi2), secPhi = 1 / cosPhi, drdPhi = 2 * sinPhi * cosPhi, dvdPhi = (-3 * r + z * (1 + 3 * r2)) * drdPhi, dp2dPhi = (-v * cosPhi - (1 - sinPhi) * dvdPhi) / (v * v), dpdPhi = 0.5 * dp2dPhi / p, dhdPhi = (1 - r2) * dpdPhi - 2 * r * p * drdPhi, zeta = -2 * secPhi * dhdPhi, mu = -secPhi * drdPhi, nu = -secPhi * (r * (1 + r2) * dp2dPhi + p2 * (1 + 3 * r2) * drdPhi);
  return [pi7 / 4 * (x3 * (zeta + mu * g) + nu * asin4(x3 / sqrt6(a22))), phi2];
}

// node_modules/d3-geo-projection/src/elliptic.js
function ellipticJi(u, v, m2) {
  var a4, b, c3;
  if (!u) {
    b = ellipticJ(v, 1 - m2);
    return [
      [0, b[0] / b[1]],
      [1 / b[1], 0],
      [b[2] / b[1], 0]
    ];
  }
  a4 = ellipticJ(u, m2);
  if (!v) return [[a4[0], 0], [a4[1], 0], [a4[2], 0]];
  b = ellipticJ(v, 1 - m2);
  c3 = b[1] * b[1] + m2 * a4[0] * a4[0] * b[0] * b[0];
  return [
    [a4[0] * b[2] / c3, a4[1] * a4[2] * b[0] * b[1] / c3],
    [a4[1] * b[1] / c3, -a4[0] * a4[2] * b[0] * b[2] / c3],
    [a4[2] * b[1] * b[2] / c3, -m2 * a4[0] * a4[1] * b[0] / c3]
  ];
}
function ellipticJ(u, m2) {
  var ai, b, phi2, t, twon;
  if (m2 < epsilon8) {
    t = sin4(u);
    b = cos4(u);
    ai = m2 * (u - t * b) / 4;
    return [
      t - ai * b,
      b + ai * t,
      1 - m2 * t * t / 2,
      u - ai
    ];
  }
  if (m2 >= 1 - epsilon8) {
    ai = (1 - m2) / 4;
    b = cosh2(u);
    t = tanh2(u);
    phi2 = 1 / b;
    twon = b * sinh2(u);
    return [
      t + ai * (twon - u) / (b * b),
      phi2 - ai * t * phi2 * (twon - u),
      phi2 + ai * t * phi2 * (twon + u),
      2 * atan3(exp2(u)) - halfPi5 + ai * (twon - u) / b
    ];
  }
  var a4 = [1, 0, 0, 0, 0, 0, 0, 0, 0], c3 = [sqrt6(m2), 0, 0, 0, 0, 0, 0, 0, 0], i = 0;
  b = sqrt6(1 - m2);
  twon = 1;
  while (abs5(c3[i] / a4[i]) > epsilon8 && i < 8) {
    ai = a4[i++];
    c3[i] = (ai - b) / 2;
    a4[i] = (ai + b) / 2;
    b = sqrt6(ai * b);
    twon *= 2;
  }
  phi2 = twon * a4[i] * u;
  do {
    t = c3[i] * sin4(b = phi2) / a4[i];
    phi2 = (asin4(t) + phi2) / 2;
  } while (--i);
  return [sin4(phi2), t = cos4(phi2), t / cos4(phi2 - b), phi2];
}
function ellipticFi(phi2, psi, m2) {
  var r = abs5(phi2), i = abs5(psi), sinhPsi = sinh2(i);
  if (r) {
    var cscPhi = 1 / sin4(r), cotPhi2 = 1 / (tan2(r) * tan2(r)), b = -(cotPhi2 + m2 * (sinhPsi * sinhPsi * cscPhi * cscPhi) - 1 + m2), c3 = (m2 - 1) * cotPhi2, cotLambda2 = (-b + sqrt6(b * b - 4 * c3)) / 2;
    return [
      ellipticF(atan3(1 / sqrt6(cotLambda2)), m2) * sign4(phi2),
      ellipticF(atan3(sqrt6((cotLambda2 / cotPhi2 - 1) / m2)), 1 - m2) * sign4(psi)
    ];
  }
  return [
    0,
    ellipticF(atan3(sinhPsi), 1 - m2) * sign4(psi)
  ];
}
function ellipticF(phi2, m2) {
  if (!m2) return phi2;
  if (m2 === 1) return log3(tan2(phi2 / 2 + quarterPi2));
  var a4 = 1, b = sqrt6(1 - m2), c3 = sqrt6(m2);
  for (var i = 0; abs5(c3) > epsilon8; i++) {
    if (phi2 % pi7) {
      var dPhi = atan3(b * tan2(phi2) / a4);
      if (dPhi < 0) dPhi += pi7;
      phi2 += dPhi + ~~(phi2 / pi7) * pi7;
    } else phi2 += phi2;
    c3 = (a4 + b) / 2;
    b = sqrt6(a4 * b);
    c3 = ((a4 = c3) - b) / 2;
  }
  return phi2 / (pow3(2, i) * a4);
}

// node_modules/d3-geo-projection/src/guyou.js
function guyouRaw(lambda, phi2) {
  var k_ = (sqrt22 - 1) / (sqrt22 + 1), k4 = sqrt6(1 - k_ * k_), K4 = ellipticF(halfPi5, k4 * k4), f = -1, psi = log3(tan2(pi7 / 4 + abs5(phi2) / 2)), r = exp2(f * psi) / sqrt6(k_), at = guyouComplexAtan(r * cos4(f * lambda), r * sin4(f * lambda)), t = ellipticFi(at[0], at[1], k4 * k4);
  return [-t[1], (phi2 >= 0 ? 1 : -1) * (0.5 * K4 - t[0])];
}
function guyouComplexAtan(x3, y3) {
  var x22 = x3 * x3, y_1 = y3 + 1, t = 1 - x22 - y3 * y3;
  return [
    0.5 * ((x3 >= 0 ? halfPi5 : -halfPi5) - atan24(t, 2 * x3)),
    -0.25 * log3(t * t + 4 * x22) + 0.5 * log3(y_1 * y_1 + x22)
  ];
}
function guyouComplexDivide(a4, b) {
  var denominator = b[0] * b[0] + b[1] * b[1];
  return [
    (a4[0] * b[0] + a4[1] * b[1]) / denominator,
    (a4[1] * b[0] - a4[0] * b[1]) / denominator
  ];
}
guyouRaw.invert = function(x3, y3) {
  var k_ = (sqrt22 - 1) / (sqrt22 + 1), k4 = sqrt6(1 - k_ * k_), K4 = ellipticF(halfPi5, k4 * k4), f = -1, j = ellipticJi(0.5 * K4 - y3, -x3, k4 * k4), tn = guyouComplexDivide(j[0], j[1]), lambda = atan24(tn[1], tn[0]) / f;
  return [
    lambda,
    2 * atan3(exp2(0.5 / f * log3(k_ * tn[0] * tn[0] + k_ * tn[1] * tn[1]))) - halfPi5
  ];
};

// node_modules/d3-geo-projection/src/healpix.js
var K2 = 3;
var healpixParallel = asin4(1 - 1 / K2) * degrees4;
var healpixLambert = cylindricalEqualAreaRaw2(0);

// node_modules/d3-geo-projection/src/sinuMollweide.js
var sinuMollweidePhi = 0.7109889596207567;
var sinuMollweideY = 0.0528035274542;
function sinuMollweideRaw(lambda, phi2) {
  return phi2 > -sinuMollweidePhi ? (lambda = mollweideRaw(lambda, phi2), lambda[1] += sinuMollweideY, lambda) : sinusoidalRaw(lambda, phi2);
}
sinuMollweideRaw.invert = function(x3, y3) {
  return y3 > -sinuMollweidePhi ? mollweideRaw.invert(x3, y3 - sinuMollweideY) : sinusoidalRaw.invert(x3, y3);
};

// node_modules/d3-geo-projection/src/homolosine.js
function homolosineRaw(lambda, phi2) {
  return abs5(phi2) > sinuMollweidePhi ? (lambda = mollweideRaw(lambda, phi2), lambda[1] -= phi2 > 0 ? sinuMollweideY : -sinuMollweideY, lambda) : sinusoidalRaw(lambda, phi2);
}
homolosineRaw.invert = function(x3, y3) {
  return abs5(y3) > sinuMollweidePhi ? mollweideRaw.invert(x3, y3 + (y3 > 0 ? sinuMollweideY : -sinuMollweideY)) : sinusoidalRaw.invert(x3, y3);
};

// node_modules/d3-geo-projection/src/hufnagel.js
function hufnagelRaw(a4, b, psiMax, ratio) {
  var k4 = sqrt6(
    4 * pi7 / (2 * psiMax + (1 + a4 - b / 2) * sin4(2 * psiMax) + (a4 + b) / 2 * sin4(4 * psiMax) + b / 2 * sin4(6 * psiMax))
  ), c3 = sqrt6(
    ratio * sin4(psiMax) * sqrt6((1 + a4 * cos4(2 * psiMax) + b * cos4(4 * psiMax)) / (1 + a4 + b))
  ), M2 = psiMax * mapping(1);
  function radius(psi) {
    return sqrt6(1 + a4 * cos4(2 * psi) + b * cos4(4 * psi));
  }
  function mapping(t) {
    var psi = t * psiMax;
    return (2 * psi + (1 + a4 - b / 2) * sin4(2 * psi) + (a4 + b) / 2 * sin4(4 * psi) + b / 2 * sin4(6 * psi)) / psiMax;
  }
  function inversemapping(psi) {
    return radius(psi) * sin4(psi);
  }
  var forward = function(lambda, phi2) {
    var psi = psiMax * solve(mapping, M2 * sin4(phi2) / psiMax, phi2 / pi7);
    if (isNaN(psi)) psi = psiMax * sign4(phi2);
    var kr3 = k4 * radius(psi);
    return [kr3 * c3 * lambda / pi7 * cos4(psi), kr3 / c3 * sin4(psi)];
  };
  forward.invert = function(x3, y3) {
    var psi = solve(inversemapping, y3 * c3 / k4);
    return [
      x3 * pi7 / (cos4(psi) * k4 * c3 * radius(psi)),
      asin4(psiMax * mapping(psi / psiMax) / M2)
    ];
  };
  if (psiMax === 0) {
    k4 = sqrt6(ratio / pi7);
    forward = function(lambda, phi2) {
      return [lambda * k4, sin4(phi2) / k4];
    };
    forward.invert = function(x3, y3) {
      return [x3 / k4, asin4(y3 * k4)];
    };
  }
  return forward;
}
function hufnagel_default() {
  var a4 = 1, b = 0, psiMax = 45 * radians3, ratio = 2, mutate = projectionMutator(hufnagelRaw), projection2 = mutate(a4, b, psiMax, ratio);
  projection2.a = function(_) {
    return arguments.length ? mutate(a4 = +_, b, psiMax, ratio) : a4;
  };
  projection2.b = function(_) {
    return arguments.length ? mutate(a4, b = +_, psiMax, ratio) : b;
  };
  projection2.psiMax = function(_) {
    return arguments.length ? mutate(a4, b, psiMax = +_ * radians3, ratio) : psiMax * degrees4;
  };
  projection2.ratio = function(_) {
    return arguments.length ? mutate(a4, b, psiMax, ratio = +_) : ratio;
  };
  return projection2.scale(180.739);
}

// node_modules/d3-geo-projection/src/kavrayskiy7.js
function kavrayskiy7Raw(lambda, phi2) {
  return [3 / tau7 * lambda * sqrt6(pi7 * pi7 / 3 - phi2 * phi2), phi2];
}
kavrayskiy7Raw.invert = function(x3, y3) {
  return [tau7 / 3 * x3 / sqrt6(pi7 * pi7 / 3 - y3 * y3), y3];
};
function kavrayskiy7_default() {
  return projection(kavrayskiy7Raw).scale(158.837);
}

// node_modules/d3-geo-projection/src/larrivee.js
var pi_sqrt2 = pi7 / sqrt22;
function larriveeRaw(lambda, phi2) {
  return [
    lambda * (1 + sqrt6(cos4(phi2))) / 2,
    phi2 / (cos4(phi2 / 2) * cos4(lambda / 6))
  ];
}
larriveeRaw.invert = function(x3, y3) {
  var x06 = abs5(x3), y06 = abs5(y3), lambda = epsilon8, phi2 = halfPi5;
  if (y06 < pi_sqrt2) phi2 *= y06 / pi_sqrt2;
  else lambda += 6 * acos4(pi_sqrt2 / y06);
  for (var i = 0; i < 25; i++) {
    var sinPhi = sin4(phi2), sqrtcosPhi = sqrt6(cos4(phi2)), sinPhi_2 = sin4(phi2 / 2), cosPhi_2 = cos4(phi2 / 2), sinLambda_6 = sin4(lambda / 6), cosLambda_6 = cos4(lambda / 6), f0 = 0.5 * lambda * (1 + sqrtcosPhi) - x06, f1 = phi2 / (cosPhi_2 * cosLambda_6) - y06, df0dPhi = sqrtcosPhi ? -0.25 * lambda * sinPhi / sqrtcosPhi : 0, df0dLambda = 0.5 * (1 + sqrtcosPhi), df1dPhi = (1 + 0.5 * phi2 * sinPhi_2 / cosPhi_2) / (cosPhi_2 * cosLambda_6), df1dLambda = phi2 / cosPhi_2 * (sinLambda_6 / 6) / (cosLambda_6 * cosLambda_6), denom = df0dPhi * df1dLambda - df1dPhi * df0dLambda, dPhi = (f0 * df1dLambda - f1 * df0dLambda) / denom, dLambda = (f1 * df0dPhi - f0 * df1dPhi) / denom;
    phi2 -= dPhi;
    lambda -= dLambda;
    if (abs5(dPhi) < epsilon8 && abs5(dLambda) < epsilon8) break;
  }
  return [x3 < 0 ? -lambda : lambda, y3 < 0 ? -phi2 : phi2];
};

// node_modules/d3-geo-projection/src/laskowski.js
function laskowskiRaw(lambda, phi2) {
  var lambda2 = lambda * lambda, phi22 = phi2 * phi2;
  return [
    lambda * (0.975534 + phi22 * (-0.119161 + lambda2 * -0.0143059 + phi22 * -0.0547009)),
    phi2 * (1.00384 + lambda2 * (0.0802894 + phi22 * -0.02855 + lambda2 * 199025e-9) + phi22 * (0.0998909 + phi22 * -0.0491032))
  ];
}
laskowskiRaw.invert = function(x3, y3) {
  var lambda = sign4(x3) * pi7, phi2 = y3 / 2, i = 50;
  do {
    var lambda2 = lambda * lambda, phi22 = phi2 * phi2, lambdaPhi = lambda * phi2, fx = lambda * (0.975534 + phi22 * (-0.119161 + lambda2 * -0.0143059 + phi22 * -0.0547009)) - x3, fy = phi2 * (1.00384 + lambda2 * (0.0802894 + phi22 * -0.02855 + lambda2 * 199025e-9) + phi22 * (0.0998909 + phi22 * -0.0491032)) - y3, deltaxDeltaLambda = 0.975534 - phi22 * (0.119161 + 3 * lambda2 * 0.0143059 + phi22 * 0.0547009), deltaxDeltaPhi = -lambdaPhi * (2 * 0.119161 + 4 * 0.0547009 * phi22 + 2 * 0.0143059 * lambda2), deltayDeltaLambda = lambdaPhi * (2 * 0.0802894 + 4 * 199025e-9 * lambda2 + 2 * -0.02855 * phi22), deltayDeltaPhi = 1.00384 + lambda2 * (0.0802894 + 199025e-9 * lambda2) + phi22 * (3 * (0.0998909 - 0.02855 * lambda2) - 5 * 0.0491032 * phi22), denominator = deltaxDeltaPhi * deltayDeltaLambda - deltayDeltaPhi * deltaxDeltaLambda, deltaLambda = (fy * deltaxDeltaPhi - fx * deltayDeltaPhi) / denominator, deltaPhi = (fx * deltayDeltaLambda - fy * deltaxDeltaLambda) / denominator;
    lambda -= deltaLambda, phi2 -= deltaPhi;
  } while ((abs5(deltaLambda) > epsilon8 || abs5(deltaPhi) > epsilon8) && --i > 0);
  return i && [lambda, phi2];
};

// node_modules/d3-geo-projection/src/littrow.js
function littrowRaw(lambda, phi2) {
  return [
    sin4(lambda) / cos4(phi2),
    tan2(phi2) * cos4(lambda)
  ];
}
littrowRaw.invert = function(x3, y3) {
  var x22 = x3 * x3, y22 = y3 * y3, y2_1 = y22 + 1, x2_y2_1 = x22 + y2_1, cosPhi = x3 ? sqrt1_2 * sqrt6((x2_y2_1 - sqrt6(x2_y2_1 * x2_y2_1 - 4 * x22)) / x22) : 1 / sqrt6(y2_1);
  return [
    asin4(x3 * cosPhi),
    sign4(y3) * acos4(cosPhi)
  ];
};

// node_modules/d3-geo-projection/src/miller.js
function millerRaw(lambda, phi2) {
  return [lambda, 1.25 * log3(tan2(quarterPi2 + 0.4 * phi2))];
}
millerRaw.invert = function(x3, y3) {
  return [x3, 2.5 * atan3(exp2(0.8 * y3)) - 0.625 * pi7];
};

// node_modules/d3-geo-projection/src/mtFlatPolarParabolic.js
var sqrt62 = sqrt6(6);
var sqrt7 = sqrt6(7);
function mtFlatPolarParabolicRaw(lambda, phi2) {
  var theta = asin4(7 * sin4(phi2) / (3 * sqrt62));
  return [
    sqrt62 * lambda * (2 * cos4(2 * theta / 3) - 1) / sqrt7,
    9 * sin4(theta / 3) / sqrt7
  ];
}
mtFlatPolarParabolicRaw.invert = function(x3, y3) {
  var theta = 3 * asin4(y3 * sqrt7 / 9);
  return [
    x3 * sqrt7 / (sqrt62 * (2 * cos4(2 * theta / 3) - 1)),
    asin4(sin4(theta) * 3 * sqrt62 / 7)
  ];
};

// node_modules/d3-geo-projection/src/mtFlatPolarQuartic.js
function mtFlatPolarQuarticRaw(lambda, phi2) {
  var k4 = (1 + sqrt1_2) * sin4(phi2), theta = phi2;
  for (var i = 0, delta; i < 25; i++) {
    theta -= delta = (sin4(theta / 2) + sin4(theta) - k4) / (0.5 * cos4(theta / 2) + cos4(theta));
    if (abs5(delta) < epsilon8) break;
  }
  return [
    lambda * (1 + 2 * cos4(theta) / cos4(theta / 2)) / (3 * sqrt22),
    2 * sqrt6(3) * sin4(theta / 2) / sqrt6(2 + sqrt22)
  ];
}
mtFlatPolarQuarticRaw.invert = function(x3, y3) {
  var sinTheta_2 = y3 * sqrt6(2 + sqrt22) / (2 * sqrt6(3)), theta = 2 * asin4(sinTheta_2);
  return [
    3 * sqrt22 * x3 / (1 + 2 * cos4(theta) / cos4(theta / 2)),
    asin4((sinTheta_2 + sin4(theta)) / (1 + sqrt1_2))
  ];
};

// node_modules/d3-geo-projection/src/mtFlatPolarSinusoidal.js
function mtFlatPolarSinusoidalRaw(lambda, phi2) {
  var A6 = sqrt6(6 / (4 + pi7)), k4 = (1 + pi7 / 4) * sin4(phi2), theta = phi2 / 2;
  for (var i = 0, delta; i < 25; i++) {
    theta -= delta = (theta / 2 + sin4(theta) - k4) / (0.5 + cos4(theta));
    if (abs5(delta) < epsilon8) break;
  }
  return [
    A6 * (0.5 + cos4(theta)) * lambda / 1.5,
    A6 * theta
  ];
}
mtFlatPolarSinusoidalRaw.invert = function(x3, y3) {
  var A6 = sqrt6(6 / (4 + pi7)), theta = y3 / A6;
  if (abs5(abs5(theta) - halfPi5) < epsilon8) theta = theta < 0 ? -halfPi5 : halfPi5;
  return [
    1.5 * x3 / (A6 * (0.5 + cos4(theta))),
    asin4((theta / 2 + sin4(theta)) / (1 + pi7 / 4))
  ];
};

// node_modules/d3-geo-projection/src/naturalEarth2.js
function naturalEarth2Raw(lambda, phi2) {
  var phi22 = phi2 * phi2, phi4 = phi22 * phi22, phi6 = phi22 * phi4;
  return [
    lambda * (0.84719 - 0.13063 * phi22 + phi6 * phi6 * (-0.04515 + 0.05494 * phi22 - 0.02326 * phi4 + 331e-5 * phi6)),
    phi2 * (1.01183 + phi4 * phi4 * (-0.02625 + 0.01926 * phi22 - 396e-5 * phi4))
  ];
}
naturalEarth2Raw.invert = function(x3, y3) {
  var phi2 = y3, i = 25, delta, phi22, phi4, phi6;
  do {
    phi22 = phi2 * phi2;
    phi4 = phi22 * phi22;
    phi2 -= delta = (phi2 * (1.01183 + phi4 * phi4 * (-0.02625 + 0.01926 * phi22 - 396e-5 * phi4)) - y3) / (1.01183 + phi4 * phi4 * (9 * -0.02625 + 11 * 0.01926 * phi22 + 13 * -396e-5 * phi4));
  } while (abs5(delta) > epsilon23 && --i > 0);
  phi22 = phi2 * phi2;
  phi4 = phi22 * phi22;
  phi6 = phi22 * phi4;
  return [
    x3 / (0.84719 - 0.13063 * phi22 + phi6 * phi6 * (-0.04515 + 0.05494 * phi22 - 0.02326 * phi4 + 331e-5 * phi6)),
    phi2
  ];
};
function naturalEarth2_default() {
  return projection(naturalEarth2Raw).scale(175.295);
}

// node_modules/d3-geo-projection/src/nellHammer.js
function nellHammerRaw(lambda, phi2) {
  return [
    lambda * (1 + cos4(phi2)) / 2,
    2 * (phi2 - tan2(phi2 / 2))
  ];
}
nellHammerRaw.invert = function(x3, y3) {
  var p = y3 / 2;
  for (var i = 0, delta = Infinity; i < 10 && abs5(delta) > epsilon8; ++i) {
    var c3 = cos4(y3 / 2);
    y3 -= delta = (y3 - tan2(y3 / 2) - p) / (1 - 0.5 / (c3 * c3));
  }
  return [
    2 * x3 / (1 + cos4(y3)),
    y3
  ];
};

// node_modules/d3-geo-projection/src/nicolosi.js
function nicolosiRaw(lambda, phi2) {
  var sinPhi = sin4(phi2), q = cos4(phi2), s3 = sign4(lambda);
  if (lambda === 0 || abs5(phi2) === halfPi5) return [0, phi2];
  else if (phi2 === 0) return [lambda, 0];
  else if (abs5(lambda) === halfPi5) return [lambda * q, halfPi5 * sinPhi];
  var b = pi7 / (2 * lambda) - 2 * lambda / pi7, c3 = 2 * phi2 / pi7, d = (1 - c3 * c3) / (sinPhi - c3);
  var b22 = b * b, d2 = d * d, b2d2 = 1 + b22 / d2, d2b2 = 1 + d2 / b22;
  var M2 = (b * sinPhi / d - b / 2) / b2d2, N = (d2 * sinPhi / b22 + d / 2) / d2b2, m2 = M2 * M2 + q * q / b2d2, n = N * N - (d2 * sinPhi * sinPhi / b22 + d * sinPhi - 1) / d2b2;
  return [
    halfPi5 * (M2 + sqrt6(m2) * s3),
    halfPi5 * (N + sqrt6(n < 0 ? 0 : n) * sign4(-phi2 * b) * s3)
  ];
}
nicolosiRaw.invert = function(x3, y3) {
  x3 /= halfPi5;
  y3 /= halfPi5;
  var x22 = x3 * x3, y22 = y3 * y3, x2y2 = x22 + y22, pi22 = pi7 * pi7;
  return [
    x3 ? (x2y2 - 1 + sqrt6((1 - x2y2) * (1 - x2y2) + 4 * x22)) / (2 * x3) * halfPi5 : 0,
    solve(function(phi2) {
      return x2y2 * (pi7 * sin4(phi2) - 2 * phi2) * pi7 + 4 * phi2 * phi2 * (y3 - sin4(phi2)) + 2 * pi7 * phi2 - pi22 * y3;
    }, 0)
  ];
};

// node_modules/d3-geo-projection/src/patterson.js
var pattersonK1 = 1.0148;
var pattersonK2 = 0.23185;
var pattersonK3 = -0.14499;
var pattersonK4 = 0.02406;
var pattersonC1 = pattersonK1;
var pattersonC2 = 5 * pattersonK2;
var pattersonC3 = 7 * pattersonK3;
var pattersonC4 = 9 * pattersonK4;
var pattersonYmax = 1.790857183;
function pattersonRaw(lambda, phi2) {
  var phi22 = phi2 * phi2;
  return [
    lambda,
    phi2 * (pattersonK1 + phi22 * phi22 * (pattersonK2 + phi22 * (pattersonK3 + pattersonK4 * phi22)))
  ];
}
pattersonRaw.invert = function(x3, y3) {
  if (y3 > pattersonYmax) y3 = pattersonYmax;
  else if (y3 < -pattersonYmax) y3 = -pattersonYmax;
  var yc = y3, delta;
  do {
    var y22 = yc * yc;
    yc -= delta = (yc * (pattersonK1 + y22 * y22 * (pattersonK2 + y22 * (pattersonK3 + pattersonK4 * y22))) - y3) / (pattersonC1 + y22 * y22 * (pattersonC2 + y22 * (pattersonC3 + pattersonC4 * y22)));
  } while (abs5(delta) > epsilon8);
  return [x3, yc];
};

// node_modules/d3-geo-projection/src/polyconic.js
function polyconicRaw(lambda, phi2) {
  if (abs5(phi2) < epsilon8) return [lambda, 0];
  var tanPhi = tan2(phi2), k4 = lambda * sin4(phi2);
  return [
    sin4(k4) / tanPhi,
    phi2 + (1 - cos4(k4)) / tanPhi
  ];
}
polyconicRaw.invert = function(x3, y3) {
  if (abs5(y3) < epsilon8) return [x3, 0];
  var k4 = x3 * x3 + y3 * y3, phi2 = y3 * 0.5, i = 10, delta;
  do {
    var tanPhi = tan2(phi2), secPhi = 1 / cos4(phi2), j = k4 - 2 * y3 * phi2 + phi2 * phi2;
    phi2 -= delta = (tanPhi * j + 2 * (phi2 - y3)) / (2 + j * secPhi * secPhi + 2 * (phi2 - y3) * tanPhi);
  } while (abs5(delta) > epsilon8 && --i > 0);
  tanPhi = tan2(phi2);
  return [
    (abs5(y3) < abs5(phi2 + 1 / tanPhi) ? asin4(x3 * tanPhi) : sign4(y3) * sign4(x3) * (acos4(abs5(x3 * tanPhi)) + halfPi5)) / sin4(phi2),
    phi2
  ];
};

// node_modules/d3-geo-projection/src/polyhedral/octahedron.js
var octahedron = [
  [0, 90],
  [-90, 0],
  [0, 0],
  [90, 0],
  [180, 0],
  [0, -90]
];
var octahedron_default = [
  [0, 2, 1],
  [0, 3, 2],
  [5, 1, 2],
  [5, 2, 3],
  [0, 1, 4],
  [0, 4, 3],
  [5, 4, 1],
  [5, 3, 4]
].map(function(face) {
  return face.map(function(i) {
    return octahedron[i];
  });
});

// node_modules/d3-geo-projection/src/polyhedral/collignon.js
var kx3 = 2 / sqrt6(3);
function collignonK(a4, b) {
  var p = collignonRaw(a4, b);
  return [p[0] * kx3, p[1]];
}
collignonK.invert = function(x3, y3) {
  return collignonRaw.invert(x3 / kx3, y3);
};

// node_modules/d3-geo-projection/src/robinson.js
var K3 = [
  [0.9986, -0.062],
  [1, 0],
  [0.9986, 0.062],
  [0.9954, 0.124],
  [0.99, 0.186],
  [0.9822, 0.248],
  [0.973, 0.31],
  [0.96, 0.372],
  [0.9427, 0.434],
  [0.9216, 0.4958],
  [0.8962, 0.5571],
  [0.8679, 0.6176],
  [0.835, 0.6769],
  [0.7986, 0.7346],
  [0.7597, 0.7903],
  [0.7186, 0.8435],
  [0.6732, 0.8936],
  [0.6213, 0.9394],
  [0.5722, 0.9761],
  [0.5322, 1]
];
K3.forEach(function(d) {
  d[1] *= 1.593415793900743;
});
function robinsonRaw(lambda, phi2) {
  var i = min6(18, abs5(phi2) * 36 / pi7), i0 = floor(i), di = i - i0, ax = (k4 = K3[i0])[0], ay = k4[1], bx = (k4 = K3[++i0])[0], by = k4[1], cx = (k4 = K3[min6(19, ++i0)])[0], cy = k4[1], k4;
  return [
    lambda * (bx + di * (cx - ax) / 2 + di * di * (cx - 2 * bx + ax) / 2),
    sign4(phi2) * (by + di * (cy - ay) / 2 + di * di * (cy - 2 * by + ay) / 2)
  ];
}
robinsonRaw.invert = function(x3, y3) {
  var phi2 = y3 * 90, i = min6(18, abs5(phi2 / 5)), i0 = max6(0, floor(i));
  do {
    var ay = K3[i0][1], by = K3[i0 + 1][1], cy = K3[min6(19, i0 + 2)][1], u = cy - ay, v = cy - 2 * by + ay, t = 2 * (abs5(y3) - by) / u, c3 = v / u, di = t * (1 - c3 * t * (1 - 2 * c3 * t));
    if (di >= 0 || i0 === 1) {
      phi2 = (y3 >= 0 ? 5 : -5) * (di + i);
      var j = 50, delta;
      do {
        i = min6(18, abs5(phi2) / 5);
        i0 = floor(i);
        di = i - i0;
        ay = K3[i0][1];
        by = K3[i0 + 1][1];
        cy = K3[min6(19, i0 + 2)][1];
        phi2 -= (delta = sign4(y3) * (by + di * (cy - ay) / 2 + di * di * (cy - 2 * by + ay) / 2) - y3) * degrees4;
      } while (abs5(delta) > epsilon23 && --j > 0);
      break;
    }
  } while (--i0 >= 0);
  var ax = K3[i0][0], bx = K3[i0 + 1][0], cx = K3[min6(19, i0 + 2)][0];
  return [
    x3 / (bx + di * (cx - ax) / 2 + di * di * (cx - 2 * bx + ax) / 2),
    phi2 * radians3
  ];
};
function robinson_default() {
  return projection(robinsonRaw).scale(152.63);
}

// node_modules/d3-geo-projection/src/stitch.js
var epsilon9 = 1e-4;
var x05 = -180;
var x0e = x05 + epsilon9;
var x12 = 180;
var x1e = x12 - epsilon9;
var y05 = -90;
var y0e = y05 + epsilon9;
var y12 = 90;
var y1e = y12 - epsilon9;

// node_modules/d3-geo-projection/src/times.js
function timesRaw(lambda, phi2) {
  var t = tan2(phi2 / 2), s3 = sin4(quarterPi2 * t);
  return [
    lambda * (0.74482 - 0.34588 * s3 * s3),
    1.70711 * t
  ];
}
timesRaw.invert = function(x3, y3) {
  var t = y3 / 1.70711, s3 = sin4(quarterPi2 * t);
  return [
    x3 / (0.74482 - 0.34588 * s3 * s3),
    2 * atan3(t)
  ];
};

// node_modules/d3-geo-projection/src/vanDerGrinten.js
function vanDerGrintenRaw(lambda, phi2) {
  if (abs5(phi2) < epsilon8) return [lambda, 0];
  var sinTheta = abs5(phi2 / halfPi5), theta = asin4(sinTheta);
  if (abs5(lambda) < epsilon8 || abs5(abs5(phi2) - halfPi5) < epsilon8) return [0, sign4(phi2) * pi7 * tan2(theta / 2)];
  var cosTheta = cos4(theta), A6 = abs5(pi7 / lambda - lambda / pi7) / 2, A22 = A6 * A6, G = cosTheta / (sinTheta + cosTheta - 1), P = G * (2 / sinTheta - 1), P2 = P * P, P2_A2 = P2 + A22, G_P2 = G - P2, Q = A22 + G;
  return [
    sign4(lambda) * pi7 * (A6 * G_P2 + sqrt6(A22 * G_P2 * G_P2 - P2_A2 * (G * G - P2))) / P2_A2,
    sign4(phi2) * pi7 * (P * Q - A6 * sqrt6((A22 + 1) * P2_A2 - Q * Q)) / P2_A2
  ];
}
vanDerGrintenRaw.invert = function(x3, y3) {
  if (abs5(y3) < epsilon8) return [x3, 0];
  if (abs5(x3) < epsilon8) return [0, halfPi5 * sin4(2 * atan3(y3 / pi7))];
  var x22 = (x3 /= pi7) * x3, y22 = (y3 /= pi7) * y3, x2_y2 = x22 + y22, z = x2_y2 * x2_y2, c1 = -abs5(y3) * (1 + x2_y2), c22 = c1 - 2 * y22 + x22, c3 = -2 * c1 + 1 + 2 * y22 + z, d = y22 / c3 + (2 * c22 * c22 * c22 / (c3 * c3 * c3) - 9 * c1 * c22 / (c3 * c3)) / 27, a1 = (c1 - c22 * c22 / (3 * c3)) / c3, m1 = 2 * sqrt6(-a1 / 3), theta1 = acos4(3 * d / (a1 * m1)) / 3;
  return [
    pi7 * (x2_y2 - 1 + sqrt6(1 + 2 * (x22 - y22) + z)) / (2 * x3),
    sign4(y3) * pi7 * (-m1 * cos4(theta1 + pi7 / 3) - c22 / (3 * c3))
  ];
};

// node_modules/d3-geo-projection/src/vanDerGrinten2.js
function vanDerGrinten2Raw(lambda, phi2) {
  if (abs5(phi2) < epsilon8) return [lambda, 0];
  var sinTheta = abs5(phi2 / halfPi5), theta = asin4(sinTheta);
  if (abs5(lambda) < epsilon8 || abs5(abs5(phi2) - halfPi5) < epsilon8) return [0, sign4(phi2) * pi7 * tan2(theta / 2)];
  var cosTheta = cos4(theta), A6 = abs5(pi7 / lambda - lambda / pi7) / 2, A22 = A6 * A6, x13 = cosTheta * (sqrt6(1 + A22) - A6 * cosTheta) / (1 + A22 * sinTheta * sinTheta);
  return [
    sign4(lambda) * pi7 * x13,
    sign4(phi2) * pi7 * sqrt6(1 - x13 * (2 * A6 + x13))
  ];
}
vanDerGrinten2Raw.invert = function(x3, y3) {
  if (!x3) return [0, halfPi5 * sin4(2 * atan3(y3 / pi7))];
  var x13 = abs5(x3 / pi7), A6 = (1 - x13 * x13 - (y3 /= pi7) * y3) / (2 * x13), A22 = A6 * A6, B3 = sqrt6(A22 + 1);
  return [
    sign4(x3) * pi7 * (B3 - A6),
    sign4(y3) * halfPi5 * sin4(2 * atan24(sqrt6((1 - 2 * A6 * x13) * (A6 + B3) - x13), sqrt6(B3 + A6 + x13)))
  ];
};

// node_modules/d3-geo-projection/src/vanDerGrinten3.js
function vanDerGrinten3Raw(lambda, phi2) {
  if (abs5(phi2) < epsilon8) return [lambda, 0];
  var sinTheta = phi2 / halfPi5, theta = asin4(sinTheta);
  if (abs5(lambda) < epsilon8 || abs5(abs5(phi2) - halfPi5) < epsilon8) return [0, pi7 * tan2(theta / 2)];
  var A6 = (pi7 / lambda - lambda / pi7) / 2, y13 = sinTheta / (1 + cos4(theta));
  return [
    pi7 * (sign4(lambda) * sqrt6(A6 * A6 + 1 - y13 * y13) - A6),
    pi7 * y13
  ];
}
vanDerGrinten3Raw.invert = function(x3, y3) {
  if (!y3) return [x3, 0];
  var y13 = y3 / pi7, A6 = (pi7 * pi7 * (1 - y13 * y13) - x3 * x3) / (2 * pi7 * x3);
  return [
    x3 ? pi7 * (sign4(x3) * sqrt6(A6 * A6 + 1) - A6) : 0,
    halfPi5 * sin4(2 * atan3(y13))
  ];
};

// node_modules/d3-geo-projection/src/vanDerGrinten4.js
function vanDerGrinten4Raw(lambda, phi2) {
  if (!phi2) return [lambda, 0];
  var phi02 = abs5(phi2);
  if (!lambda || phi02 === halfPi5) return [0, phi2];
  var B3 = phi02 / halfPi5, B22 = B3 * B3, C2 = (8 * B3 - B22 * (B22 + 2) - 5) / (2 * B22 * (B3 - 1)), C22 = C2 * C2, BC = B3 * C2, B_C2 = B22 + C22 + 2 * BC, B_3C = B3 + 3 * C2, lambda0 = lambda / halfPi5, lambda1 = lambda0 + 1 / lambda0, D2 = sign4(abs5(lambda) - halfPi5) * sqrt6(lambda1 * lambda1 - 4), D22 = D2 * D2, F = B_C2 * (B22 + C22 * D22 - 1) + (1 - B22) * (B22 * (B_3C * B_3C + 4 * C22) + 12 * BC * C22 + 4 * C22 * C22), x13 = (D2 * (B_C2 + C22 - 1) + 2 * sqrt6(F)) / (4 * B_C2 + D22);
  return [
    sign4(lambda) * halfPi5 * x13,
    sign4(phi2) * halfPi5 * sqrt6(1 + D2 * abs5(x13) - x13 * x13)
  ];
}
vanDerGrinten4Raw.invert = function(x3, y3) {
  var delta;
  if (!x3 || !y3) return [x3, y3];
  var sy = sign4(y3);
  y3 = abs5(y3) / pi7;
  var x13 = sign4(x3) * x3 / halfPi5, D2 = (x13 * x13 - 1 + 4 * y3 * y3) / abs5(x13), D22 = D2 * D2, B3 = y3 * (2 - (y3 > 0.5 ? min6(y3, abs5(x3)) : 0)), r = x3 * x3 + y3 * y3, i = 50;
  do {
    var B22 = B3 * B3, C2 = (8 * B3 - B22 * (B22 + 2) - 5) / (2 * B22 * (B3 - 1)), C_ = (3 * B3 - B22 * B3 - 10) / (2 * B22 * B3), C22 = C2 * C2, BC = B3 * C2, B_C = B3 + C2, B_C2 = B_C * B_C, B_3C = B3 + 3 * C2, F = B_C2 * (B22 + C22 * D22 - 1) + (1 - B22) * (B22 * (B_3C * B_3C + 4 * C22) + C22 * (12 * BC + 4 * C22)), F_ = -2 * B_C * (4 * BC * C22 + (1 - 4 * B22 + 3 * B22 * B22) * (1 + C_) + C22 * (-6 + 14 * B22 - D22 + (-8 + 8 * B22 - 2 * D22) * C_) + BC * (-8 + 12 * B22 + (-10 + 10 * B22 - D22) * C_)), sqrtF = sqrt6(F), f = D2 * (B_C2 + C22 - 1) + 2 * sqrtF - x13 * (4 * B_C2 + D22), f_ = D2 * (2 * C2 * C_ + 2 * B_C * (1 + C_)) + F_ / sqrtF - 8 * B_C * (D2 * (-1 + C22 + B_C2) + 2 * sqrtF) * (1 + C_) / (D22 + 4 * B_C2);
    B3 -= delta = f / f_;
  } while (delta * r * r > epsilon8 && --i > 0);
  return [
    sign4(x3) * (sqrt6(D2 * D2 + 4) + D2) * pi7 / 4,
    sy * halfPi5 * B3
  ];
};

// node_modules/d3-geo-projection/src/wagner4.js
var A5 = 4 * pi7 + 3 * sqrt6(3);
var B2 = 2 * sqrt6(2 * pi7 * sqrt6(3) / A5);
var wagner4Raw = mollweideBromleyRaw(B2 * sqrt6(3) / pi7, B2, A5 / 6);

// node_modules/d3-geo-projection/src/wagner6.js
function wagner6Raw(lambda, phi2) {
  return [lambda * sqrt6(1 - 3 * phi2 * phi2 / (pi7 * pi7)), phi2];
}
wagner6Raw.invert = function(x3, y3) {
  return [x3 / sqrt6(1 - 3 * y3 * y3 / (pi7 * pi7)), y3];
};

// node_modules/d3-geo-projection/src/wiechel.js
function wiechelRaw(lambda, phi2) {
  var cosPhi = cos4(phi2), sinPhi = cos4(lambda) * cosPhi, sin1_Phi = 1 - sinPhi, cosLambda = cos4(lambda = atan24(sin4(lambda) * cosPhi, -sin4(phi2))), sinLambda = sin4(lambda);
  cosPhi = sqrt6(1 - sinPhi * sinPhi);
  return [
    sinLambda * cosPhi - cosLambda * sin1_Phi,
    -cosLambda * cosPhi - sinLambda * sin1_Phi
  ];
}
wiechelRaw.invert = function(x3, y3) {
  var w2 = (x3 * x3 + y3 * y3) / -2, k4 = sqrt6(-w2 * (2 + w2)), b = y3 * w2 + x3 * k4, a4 = x3 * w2 - y3 * k4, D2 = sqrt6(a4 * a4 + b * b);
  return [
    atan24(k4 * b, D2 * (1 + w2)),
    D2 ? -asin4(k4 * a4 / D2) : 0
  ];
};

// node_modules/d3-geo-projection/src/winkel3.js
function winkel3Raw(lambda, phi2) {
  var coordinates = aitoffRaw(lambda, phi2);
  return [
    (coordinates[0] + lambda / halfPi5) / 2,
    (coordinates[1] + phi2) / 2
  ];
}
winkel3Raw.invert = function(x3, y3) {
  var lambda = x3, phi2 = y3, i = 25;
  do {
    var cosphi = cos4(phi2), sinphi = sin4(phi2), sin_2phi = sin4(2 * phi2), sin2phi = sinphi * sinphi, cos2phi = cosphi * cosphi, sinlambda = sin4(lambda), coslambda_2 = cos4(lambda / 2), sinlambda_2 = sin4(lambda / 2), sin2lambda_2 = sinlambda_2 * sinlambda_2, C2 = 1 - cos2phi * coslambda_2 * coslambda_2, E2 = C2 ? acos4(cosphi * coslambda_2) * sqrt6(F = 1 / C2) : F = 0, F, fx = 0.5 * (2 * E2 * cosphi * sinlambda_2 + lambda / halfPi5) - x3, fy = 0.5 * (E2 * sinphi + phi2) - y3, dxdlambda = 0.5 * F * (cos2phi * sin2lambda_2 + E2 * cosphi * coslambda_2 * sin2phi) + 0.5 / halfPi5, dxdphi = F * (sinlambda * sin_2phi / 4 - E2 * sinphi * sinlambda_2), dydlambda = 0.125 * F * (sin_2phi * sinlambda_2 - E2 * sinphi * cos2phi * sinlambda), dydphi = 0.5 * F * (sin2phi * coslambda_2 + E2 * sin2lambda_2 * cosphi) + 0.5, denominator = dxdphi * dydlambda - dydphi * dxdlambda, dlambda = (fy * dxdphi - fx * dydphi) / denominator, dphi = (fx * dydlambda - fy * dxdlambda) / denominator;
    lambda -= dlambda, phi2 -= dphi;
  } while ((abs5(dlambda) > epsilon8 || abs5(dphi) > epsilon8) && --i > 0);
  return [lambda, phi2];
};

// node_modules/@unovis/ts/components/topojson-map/types.js
var MapPointLabelPosition;
(function(MapPointLabelPosition2) {
  MapPointLabelPosition2["Center"] = "center";
  MapPointLabelPosition2["Bottom"] = "bottom";
})(MapPointLabelPosition || (MapPointLabelPosition = {}));
var MapProjectionKind;
(function(MapProjectionKind2) {
  MapProjectionKind2["Mercator"] = "Mercator";
  MapProjectionKind2["Equirectangular"] = "Equirectangular";
  MapProjectionKind2["AzimuthalEqualArea"] = "AzimuthalEqualArea";
  MapProjectionKind2["AzimuthalEquidistant"] = "AzimuthalEquidistant";
  MapProjectionKind2["Gnomonic"] = "Gnomonic";
  MapProjectionKind2["Orthographic"] = "Orthographic";
  MapProjectionKind2["Stereographic"] = "Stereographic";
  MapProjectionKind2["EqualEarth"] = "EqualEarth";
  MapProjectionKind2["AlbersUsa"] = "AlbersUsa";
  MapProjectionKind2["Albers"] = "Albers";
  MapProjectionKind2["ConicConformal"] = "ConicConformal";
  MapProjectionKind2["ConicEqualArea"] = "ConicEqualArea";
  MapProjectionKind2["ConicEquidistant"] = "ConicEquidistant";
  MapProjectionKind2["TransverseMercator"] = "TransverseMercator";
  MapProjectionKind2["NaturalEarth1"] = "NaturalEarth1";
  MapProjectionKind2["Bromley"] = "Bromley";
  MapProjectionKind2["NaturalEarth2"] = "NaturalEarth2";
  MapProjectionKind2["Kavrayskiy7"] = "Kavrayskiy7";
  MapProjectionKind2["Hufnagel"] = "Hufnagel";
  MapProjectionKind2["FoucautSinusoidal"] = "FoucautSinusoidal";
  MapProjectionKind2["Eckert1"] = "Eckert1";
  MapProjectionKind2["Eckert3"] = "Eckert3";
  MapProjectionKind2["Boggs"] = "Boggs";
  MapProjectionKind2["CylindricalStereographic"] = "CylindricalStereographic";
  MapProjectionKind2["Craster"] = "Craster";
  MapProjectionKind2["Baker"] = "Baker";
  MapProjectionKind2["Armadillo"] = "Armadillo";
  MapProjectionKind2["Aitoff"] = "Aitoff";
  MapProjectionKind2["Fahey"] = "Fahey";
  MapProjectionKind2["Robinson"] = "Robinson";
})(MapProjectionKind || (MapProjectionKind = {}));
var MapProjection = {
  // Projections form `d3-geo`
  [MapProjectionKind.Mercator]: mercator_default,
  [MapProjectionKind.Equirectangular]: equirectangular_default,
  [MapProjectionKind.AzimuthalEqualArea]: azimuthalEqualArea_default,
  [MapProjectionKind.AzimuthalEquidistant]: azimuthalEquidistant_default,
  [MapProjectionKind.Gnomonic]: gnomonic_default,
  [MapProjectionKind.Orthographic]: orthographic_default,
  [MapProjectionKind.Stereographic]: stereographic_default,
  [MapProjectionKind.EqualEarth]: equalEarth_default,
  [MapProjectionKind.AlbersUsa]: albersUsa_default,
  [MapProjectionKind.Albers]: albers_default,
  [MapProjectionKind.ConicConformal]: conicConformal_default,
  [MapProjectionKind.ConicEqualArea]: conicEqualArea_default,
  [MapProjectionKind.ConicEquidistant]: conicEquidistant_default,
  [MapProjectionKind.TransverseMercator]: transverseMercator_default,
  [MapProjectionKind.NaturalEarth1]: naturalEarth1_default,
  // Projections form `d3-geo-projection`
  [MapProjectionKind.Bromley]: bromley_default,
  [MapProjectionKind.NaturalEarth2]: naturalEarth2_default,
  [MapProjectionKind.Kavrayskiy7]: kavrayskiy7_default,
  [MapProjectionKind.Hufnagel]: hufnagel_default,
  [MapProjectionKind.FoucautSinusoidal]: foucautSinusoidal_default,
  [MapProjectionKind.Eckert1]: eckert1_default,
  [MapProjectionKind.Eckert3]: eckert3_default,
  [MapProjectionKind.Boggs]: boggs_default,
  [MapProjectionKind.CylindricalStereographic]: cylindricalStereographic_default,
  [MapProjectionKind.Craster]: craster_default,
  [MapProjectionKind.Baker]: baker_default,
  [MapProjectionKind.Armadillo]: armadillo_default,
  [MapProjectionKind.Aitoff]: aitoff_default,
  [MapProjectionKind.Fahey]: fahey_default,
  [MapProjectionKind.Robinson]: robinson_default
};

// node_modules/@unovis/ts/components/topojson-map/config.js
var TopoJSONMapDefaultConfig = Object.assign(Object.assign({}, ComponentDefaultConfig), { projection: MapProjection.Kavrayskiy7(), duration: 1500, topojson: void 0, mapFeatureName: "countries", mapFitToPoints: false, zoomExtent: [0.5, 6], zoomDuration: 400, disableZoom: false, zoomFactor: void 0, linkWidth: (d) => {
  var _a;
  return (_a = d.width) !== null && _a !== void 0 ? _a : 1;
}, linkColor: (d) => {
  var _a;
  return (_a = d.color) !== null && _a !== void 0 ? _a : null;
}, linkCursor: null, linkId: (d, i) => {
  var _a;
  return `${(_a = d.id) !== null && _a !== void 0 ? _a : i}`;
}, linkSource: (d) => d.source, linkTarget: (d) => d.target, areaId: (d) => {
  var _a;
  return (_a = d.id) !== null && _a !== void 0 ? _a : "";
}, areaColor: (d) => {
  var _a;
  return (_a = d.color) !== null && _a !== void 0 ? _a : null;
}, areaCursor: null, longitude: (d) => d.longitude, latitude: (d) => d.latitude, pointColor: (d) => {
  var _a;
  return (_a = d.color) !== null && _a !== void 0 ? _a : null;
}, pointRadius: (d) => {
  var _a;
  return (_a = d.radius) !== null && _a !== void 0 ? _a : 8;
}, pointStrokeWidth: (d) => {
  var _a;
  return (_a = d.strokeWidth) !== null && _a !== void 0 ? _a : 0;
}, pointCursor: null, pointLabel: void 0, pointLabelPosition: MapPointLabelPosition.Bottom, pointLabelTextBrightnessRatio: 0.65, pointId: (d) => d.id, heatmapMode: false, heatmapModeBlurStdDeviation: 8, heatmapModeZoomLevelThreshold: 2.5 });

// node_modules/@unovis/ts/components/topojson-map/utils.js
function getLonLat(d, pointLongitude, pointLatitude) {
  const lat = getNumber(d, pointLatitude);
  const lon = getNumber(d, pointLongitude);
  return [lon, lat];
}
function arc(source, target, curvature) {
  if (!target || !source)
    return "M0,0,l0,0z";
  const d = 3;
  const angleOffset = curvature || 0;
  const s3 = { x: source[0], y: source[1] };
  const t = { x: target[0], y: target[1] };
  const ds = { x: (t.x - s3.x) / d, y: (t.y - s3.y) / d };
  const dt = { x: (s3.x - t.x) / d, y: (s3.y - t.y) / d };
  let angle = 0.16667 * Math.PI * (1 + angleOffset);
  if (s3.x < t.x)
    angle = -angle;
  const cs = Math.cos(angle);
  const ss = Math.sin(angle);
  const ct = Math.cos(-angle);
  const st = Math.sin(-angle);
  const dds = { x: cs * ds.x - ss * ds.y, y: ss * ds.x + cs * ds.y };
  const ddt = { x: ct * dt.x - st * dt.y, y: st * dt.x + ct * dt.y };
  return `M${s3.x},${s3.y} C${s3.x + dds.x},${s3.y + dds.y} ${t.x + ddt.x},${t.y + ddt.y} ${t.x},${t.y}`;
}

// node_modules/@unovis/ts/components/topojson-map/style.js
var style_exports13 = {};
__export(style_exports13, {
  background: () => background3,
  feature: () => feature2,
  features: () => features,
  link: () => link4,
  links: () => links2,
  point: () => point11,
  pointCircle: () => pointCircle,
  pointLabel: () => pointLabel,
  points: () => points,
  root: () => root15,
  variables: () => variables6
});
var root15 = css`
  label: topojson-map-component;

  &.draggable {
    &:active {
      cursor: grabbing;
      cursor: -moz-grabbing;
      cursor: -webkit-grabbing;
    }
  }
`;
var variables6 = injectGlobal`
  :root {
    --vis-map-feature-color: #dce3eb;
    --vis-map-boundary-color: #ffffff;

    --vis-map-point-label-text-color-dark: #5b5f6d;
    --vis-map-point-label-text-color-light: #fff;

    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-map-point-label-font-family: */
    --vis-map-point-label-font-weight: 600;
    --vis-map-point-label-font-size: 12px;

    /* Dark Theme */
    --vis-dark-map-feature-color: #5b5f6d;
    --vis-dark-map-boundary-color: #2a2a2a;
    --vis-dark-map-point-label-text-color-dark: #fff;
    --vis-dark-map-point-label-text-color-light:#5b5f6d;
  }

  body.theme-dark ${`.${root15}`} {
    --vis-map-feature-color: var(--vis-dark-map-feature-color);
    --vis-map-boundary-color: var(--vis-dark-map-boundary-color);
    --vis-map-point-label-text-color-dark: var(--vis-dark-map-point-label-text-color-dark);
    --vis-map-point-label-text-color-light: var(--vis-dark-map-point-label-text-color-light);
  }
`;
var features = css`
  label: features;
`;
var feature2 = css`
  label: feature;
  fill: var(--vis-map-feature-color);
  stroke: var(--vis-map-boundary-color);
  stroke-opacity: 0.5;
`;
var background3 = css`
  label: background;

  fill-opacity: 0;
  pointer-events: all;
`;
var points = css`
  label: points;
`;
var point11 = css`
  label: point;
`;
var pointCircle = css`
  label: point;

  stroke-opacity: 0.4;
  pointer-events: fill;

  &:active {
    cursor: default;
  }
`;
var pointLabel = css`
  label: label;

  text-anchor: middle;
  cursor: default;
  pointer-events:none;

  font-size: var(--vis-map-point-label-font-size);
  font-family: var(--vis-map-point-label-font-family, var(--vis-font-family));
  font-weight: var(--vis-map-point-label-font-weight);
  fill: var(--vis-map-point-label-text-color-dark);
`;
var links2 = css`
  label: links;
`;
var link4 = css`
  label: link;

  fill: none;
  stroke-opacity: .50;
  stroke-linecap: round;

  &:hover {
    stroke-opacity: .90;
  }
`;

// node_modules/@unovis/ts/components/topojson-map/index.js
var TopoJSONMap = class _TopoJSONMap extends ComponentCore {
  constructor(config, data) {
    super();
    this._defaultConfig = TopoJSONMapDefaultConfig;
    this.config = this._defaultConfig;
    this.datamodel = new MapGraphDataModel();
    this._firstRender = true;
    this._isResizing = false;
    this._initialScale = void 0;
    this._currentZoomLevel = void 0;
    this._path = path_default2();
    this._zoomBehavior = zoom_default2();
    this._backgroundRect = this.g.append("rect").attr("class", background3);
    this._featuresGroup = this.g.append("g").attr("class", features);
    this._linksGroup = this.g.append("g").attr("class", links2);
    this._pointsGroup = this.g.append("g").attr("class", points);
    this.events = {
      [_TopoJSONMap.selectors.point]: {},
      [_TopoJSONMap.selectors.feature]: {}
    };
    this._zoomBehavior.on("zoom", this._onZoom.bind(this));
    if (config)
      this.setConfig(config);
    if (data)
      this.setData(data);
    this.g.append("defs").append("filter").attr("id", "heatmapFilter").html(`
        <feGaussianBlur in="SourceGraphic" stdDeviation="${this.config.heatmapModeBlurStdDeviation}" color-interpolation-filters="sRGB" result="blur"></feGaussianBlur>
        <feColorMatrix class="blurValues" in="blur" mode="matrix" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 20 -4"></feColorMatrix>
      `);
  }
  setData(data) {
    const { config } = this;
    this.datamodel.pointId = config.pointId;
    this.datamodel.linkSource = config.linkSource;
    this.datamodel.linkTarget = config.linkTarget;
    this.datamodel.data = data;
  }
  setConfig(config) {
    super.setConfig(config);
    const newProjection = this.config.projection;
    if (this._projection) {
      newProjection.scale(this._projection.scale()).translate(this._projection.translate());
    }
    this._projection = newProjection;
  }
  _render(customDuration) {
    const { config } = this;
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    this._renderBackground();
    this._renderMap(duration);
    this._renderGroups(duration);
    this._renderLinks(duration);
    this._renderPoints(duration);
    if (duration && !config.disableZoom) {
      this.g.on(".zoom", null);
      timeout_default(() => {
        this.g.call(this._zoomBehavior);
      }, duration);
    }
    this.g.classed("draggable", !config.disableZoom);
    this._firstRender = false;
  }
  _renderBackground() {
    this._backgroundRect.attr("width", "100%").attr("height", "100%").attr("transform", `translate(${-this.bleed.left}, ${-this.bleed.top})`);
  }
  _renderGroups(duration) {
    const transformString = this._transform.toString();
    smartTransition(this._featuresGroup, duration).attr("transform", transformString).attr("stroke-width", 1 / this._currentZoomLevel);
    smartTransition(this._linksGroup, duration).attr("transform", transformString);
    smartTransition(this._pointsGroup, duration).attr("transform", transformString);
  }
  _renderMap(duration) {
    var _a, _b, _c;
    const { bleed, config, datamodel } = this;
    this.g.attr("transform", `translate(${bleed.left}, ${bleed.top})`);
    const mapData = config.topojson;
    const featureName = config.mapFeatureName;
    const featureObject = (_a = mapData === null || mapData === void 0 ? void 0 : mapData.objects) === null || _a === void 0 ? void 0 : _a[featureName];
    if (!featureObject)
      return;
    this._featureCollection = feature_default(mapData, featureObject);
    const featureData = (_c = (_b = this._featureCollection) === null || _b === void 0 ? void 0 : _b.features) !== null && _c !== void 0 ? _c : [];
    if (this._firstRender) {
      this._projection.fitExtent([[0, 0], [this._width, this._height]], this._featureCollection);
      this._initialScale = this._projection.scale();
      this._center = this._projection.translate();
      if (config.mapFitToPoints) {
        this._fitToPoints();
      }
      const zoomExtent = config.zoomExtent;
      this._zoomBehavior.scaleExtent([zoomExtent[0] * this._initialScale, zoomExtent[1] * this._initialScale]);
      this.setZoom(config.zoomFactor || 1);
      if (!config.disableZoom) {
        this.g.call(this._zoomBehavior);
        this._applyZoom();
      }
      this._prevWidth = this._width;
      this._prevHeight = this._height;
    }
    if (this._prevWidth !== this._width || this._prevHeight !== this._height) {
      this._onResize();
    }
    this._path.projection(this._projection);
    const areaData = datamodel.areas;
    areaData.forEach((a4) => {
      const feature3 = featureData.find((f) => f.id.toString() === getString(a4, config.areaId).toString());
      if (feature3)
        feature3.data = a4;
      else if (this._firstRender)
        console.warn(`Can't find feature by area code ${getString(a4, config.areaId)}`);
    });
    const features2 = this._featuresGroup.selectAll(`.${feature2}`).data(featureData);
    const featuresEnter = features2.enter().append("path").attr("class", feature2);
    smartTransition(featuresEnter.merge(features2), duration).attr("d", this._path).style("fill", (d, i) => d.data ? getColor(d.data, config.areaColor, i) : null).style("cursor", (d) => d.data ? getString(d.data, config.areaCursor) : null);
    features2.exit().remove();
  }
  _renderLinks(duration) {
    const { config, datamodel } = this;
    const links5 = datamodel.links;
    const edges = this._linksGroup.selectAll(`.${link4}`).data(links5, (d, i) => getString(d, config.linkId, i));
    const edgesEnter = edges.enter().append("path").attr("class", link4).style("stroke-width", 0);
    smartTransition(edgesEnter.merge(edges), duration).attr("d", (link7) => {
      const source = this._projection(getLonLat(link7.source, config.longitude, config.latitude));
      const target = this._projection(getLonLat(link7.target, config.longitude, config.latitude));
      return arc(source, target);
    }).style("stroke-width", (link7) => getNumber(link7, config.linkWidth) / this._currentZoomLevel).style("cursor", (link7) => getString(link7, config.linkCursor)).style("stroke", (link7, i) => getColor(link7, config.linkColor, i));
    edges.exit().remove();
  }
  _renderPoints(duration) {
    const { config, datamodel } = this;
    const pointData = datamodel.points;
    const points3 = this._pointsGroup.selectAll(`.${point11}`).data(pointData, (d, i) => getString(d, config.pointId, i));
    const pointsEnter = points3.enter().append("g").attr("class", point11).attr("transform", (d) => {
      const pos = this._projection(getLonLat(d, config.longitude, config.latitude));
      return `translate(${pos[0]},${pos[1]})`;
    });
    pointsEnter.append("circle").attr("class", pointCircle).attr("r", 0).style("fill", (d, i) => getColor(d, config.pointColor, i)).style("stroke-width", (d) => getNumber(d, config.pointStrokeWidth));
    pointsEnter.append("text").attr("class", pointLabel).style("opacity", 0);
    const pointsMerged = pointsEnter.merge(points3);
    smartTransition(pointsMerged, duration).attr("transform", (d) => {
      const pos = this._projection(getLonLat(d, config.longitude, config.latitude));
      return `translate(${pos[0]},${pos[1]})`;
    }).style("cursor", (d) => getString(d, config.pointCursor));
    smartTransition(pointsMerged.select(`.${pointCircle}`), duration).attr("r", (d) => getNumber(d, config.pointRadius) / this._currentZoomLevel).style("fill", (d, i) => getColor(d, config.pointColor, i)).style("stroke", (d, i) => getColor(d, config.pointColor, i)).style("stroke-width", (d) => getNumber(d, config.pointStrokeWidth) / this._currentZoomLevel);
    const pointLabelsMerged = pointsMerged.select(`.${pointLabel}`);
    pointLabelsMerged.text((d) => {
      var _a;
      return (_a = getString(d, config.pointLabel)) !== null && _a !== void 0 ? _a : "";
    }).style("font-size", (d) => {
      if (config.pointLabelPosition === MapPointLabelPosition.Bottom) {
        return `calc(var(--vis-map-point-label-font-size) / ${this._currentZoomLevel}`;
      }
      const pointDiameter = 2 * getNumber(d, config.pointRadius);
      const pointLabelText = getString(d, config.pointLabel) || "";
      const textLength = pointLabelText.length;
      const fontSize = 0.5 * pointDiameter / Math.pow(textLength, 0.4);
      return clamp(fontSize, fontSize, 16);
    }).attr("y", (d) => {
      if (config.pointLabelPosition === MapPointLabelPosition.Center)
        return null;
      const pointRadius = getNumber(d, config.pointRadius) / this._currentZoomLevel;
      return pointRadius;
    }).attr("dy", config.pointLabelPosition === MapPointLabelPosition.Center ? "0.32em" : "1em");
    smartTransition(pointLabelsMerged, duration).style("fill", (d, i) => {
      var _a;
      if (config.pointLabelPosition === MapPointLabelPosition.Bottom)
        return null;
      const pointColor = getColor(d, config.pointColor, i);
      const hex2 = (_a = color(isStringCSSVariable(pointColor) ? getCSSVariableValue(pointColor, this.element) : pointColor)) === null || _a === void 0 ? void 0 : _a.hex();
      if (!hex2)
        return null;
      const brightness = hexToBrightness(hex2);
      return brightness > config.pointLabelTextBrightnessRatio ? "var(--vis-map-point-label-text-color-dark)" : "var(--vis-map-point-label-text-color-light)";
    }).style("opacity", 1);
    points3.exit().remove();
    this._pointsGroup.style("filter", config.heatmapMode && this._currentZoomLevel < config.heatmapModeZoomLevelThreshold ? "url(#heatmapFilter)" : null);
    this._pointsGroup.selectAll(`.${pointLabel}`).style("display", config.heatmapMode && this._currentZoomLevel < config.heatmapModeZoomLevelThreshold ? "none" : null);
  }
  _fitToPoints(points3, pad2 = 0.1) {
    const { config, datamodel } = this;
    const pointData = points3 || datamodel.points;
    if (pointData.length === 0)
      return;
    const featureCollection = {
      type: "FeatureCollection",
      features: [{
        type: "Feature",
        properties: {},
        geometry: {
          type: "MultiPoint",
          coordinates: pointData.map((p) => {
            return [
              getNumber(p, (d) => getNumber(d, config.longitude)),
              getNumber(p, (d) => getNumber(d, config.latitude))
            ];
          })
        }
      }]
    };
    this._projection.fitExtent([
      [this._width * pad2, this._height * pad2],
      [this._width * (1 - pad2), this._height * (1 - pad2)]
    ], featureCollection);
    const maxScale = config.zoomExtent[1] * this._initialScale;
    if (this._projection.scale() > maxScale)
      this._projection.scale(maxScale);
    this._applyZoom();
  }
  _applyZoom() {
    var _a;
    const translate = (_a = this._center) !== null && _a !== void 0 ? _a : this._projection.translate();
    const scale = this._initialScale * this._currentZoomLevel;
    this.g.call(this._zoomBehavior.transform, identity4.translate(translate[0], translate[1]).scale(scale));
  }
  _onResize() {
    this._isResizing = true;
    const prevTranslate = this._projection.translate();
    this._projection.fitExtent([[0, 0], [this._width, this._height]], this._featureCollection);
    this._initialScale = this._projection.scale();
    this._center = [
      this._projection.translate()[0] * this._center[0] / prevTranslate[0],
      this._projection.translate()[1] * this._center[1] / prevTranslate[1]
    ];
    this._applyZoom();
    this._isResizing = false;
    this._prevWidth = this._width;
    this._prevHeight = this._height;
  }
  _onZoom(event) {
    if (this._firstRender)
      return;
    const isMouseEvent = event.sourceEvent !== void 0;
    const isExternalEvent = !(event === null || event === void 0 ? void 0 : event.sourceEvent) && !this._isResizing;
    window.cancelAnimationFrame(this._animFrameId);
    this._animFrameId = window.requestAnimationFrame(this._onZoomHandler.bind(this, event.transform, isMouseEvent, isExternalEvent));
    if (isMouseEvent) {
      this._center = [event.transform.x, event.transform.y];
    }
    this._currentZoomLevel = (event === null || event === void 0 ? void 0 : event.transform.k) / this._initialScale || 1;
  }
  _onZoomHandler(transform2, isMouseEvent, isExternalEvent) {
    const scale = transform2.k / this._initialScale || 1;
    const center3 = this._projection.translate();
    this._transform = identity4.translate(transform2.x - center3[0] * scale, transform2.y - center3[1] * scale).scale(scale);
    const customDuration = isExternalEvent ? this.config.zoomDuration : isMouseEvent ? 0 : null;
    this._renderGroups(customDuration);
    this._renderLinks(customDuration);
    this._renderPoints(customDuration);
  }
  zoomIn(increment = 0.5) {
    this.setZoom(this._currentZoomLevel + increment);
  }
  zoomOut(increment = 0.5) {
    this.setZoom(this._currentZoomLevel - increment);
  }
  setZoom(zoomLevel) {
    const { config } = this;
    this._currentZoomLevel = clamp(zoomLevel, config.zoomExtent[0], config.zoomExtent[1]);
    this._transform = identity4.translate(this._center[0] * (1 - this._currentZoomLevel), this._center[1] * (1 - this._currentZoomLevel)).scale(this._currentZoomLevel);
    this._applyZoom();
  }
  fitView() {
    var _a;
    this._projection.fitExtent([[0, 0], [this._width, this._height]], this._featureCollection);
    this._currentZoomLevel = ((_a = this._projection) === null || _a === void 0 ? void 0 : _a.scale()) / this._initialScale || 1;
    this._center = this._projection.translate();
    this._applyZoom();
  }
  destroy() {
    window.cancelAnimationFrame(this._animFrameId);
  }
};
TopoJSONMap.selectors = style_exports13;

// node_modules/d3-hierarchy/src/hierarchy/count.js
function count2(node4) {
  var sum5 = 0, children2 = node4.children, i = children2 && children2.length;
  if (!i) sum5 = 1;
  else while (--i >= 0) sum5 += children2[i].value;
  node4.value = sum5;
}
function count_default() {
  return this.eachAfter(count2);
}

// node_modules/d3-hierarchy/src/hierarchy/each.js
function each_default2(callback, that) {
  let index3 = -1;
  for (const node4 of this) {
    callback.call(that, node4, ++index3, this);
  }
  return this;
}

// node_modules/d3-hierarchy/src/hierarchy/eachBefore.js
function eachBefore_default(callback, that) {
  var node4 = this, nodes4 = [node4], children2, i, index3 = -1;
  while (node4 = nodes4.pop()) {
    callback.call(that, node4, ++index3, this);
    if (children2 = node4.children) {
      for (i = children2.length - 1; i >= 0; --i) {
        nodes4.push(children2[i]);
      }
    }
  }
  return this;
}

// node_modules/d3-hierarchy/src/hierarchy/eachAfter.js
function eachAfter_default(callback, that) {
  var node4 = this, nodes4 = [node4], next = [], children2, i, n, index3 = -1;
  while (node4 = nodes4.pop()) {
    next.push(node4);
    if (children2 = node4.children) {
      for (i = 0, n = children2.length; i < n; ++i) {
        nodes4.push(children2[i]);
      }
    }
  }
  while (node4 = next.pop()) {
    callback.call(that, node4, ++index3, this);
  }
  return this;
}

// node_modules/d3-hierarchy/src/hierarchy/find.js
function find_default(callback, that) {
  let index3 = -1;
  for (const node4 of this) {
    if (callback.call(that, node4, ++index3, this)) {
      return node4;
    }
  }
}

// node_modules/d3-hierarchy/src/hierarchy/sum.js
function sum_default(value2) {
  return this.eachAfter(function(node4) {
    var sum5 = +value2(node4.data) || 0, children2 = node4.children, i = children2 && children2.length;
    while (--i >= 0) sum5 += children2[i].value;
    node4.value = sum5;
  });
}

// node_modules/d3-hierarchy/src/hierarchy/sort.js
function sort_default2(compare) {
  return this.eachBefore(function(node4) {
    if (node4.children) {
      node4.children.sort(compare);
    }
  });
}

// node_modules/d3-hierarchy/src/hierarchy/path.js
function path_default3(end) {
  var start2 = this, ancestor = leastCommonAncestor(start2, end), nodes4 = [start2];
  while (start2 !== ancestor) {
    start2 = start2.parent;
    nodes4.push(start2);
  }
  var k4 = nodes4.length;
  while (end !== ancestor) {
    nodes4.splice(k4, 0, end);
    end = end.parent;
  }
  return nodes4;
}
function leastCommonAncestor(a4, b) {
  if (a4 === b) return a4;
  var aNodes = a4.ancestors(), bNodes = b.ancestors(), c3 = null;
  a4 = aNodes.pop();
  b = bNodes.pop();
  while (a4 === b) {
    c3 = a4;
    a4 = aNodes.pop();
    b = bNodes.pop();
  }
  return c3;
}

// node_modules/d3-hierarchy/src/hierarchy/ancestors.js
function ancestors_default() {
  var node4 = this, nodes4 = [node4];
  while (node4 = node4.parent) {
    nodes4.push(node4);
  }
  return nodes4;
}

// node_modules/d3-hierarchy/src/hierarchy/descendants.js
function descendants_default() {
  return Array.from(this);
}

// node_modules/d3-hierarchy/src/hierarchy/leaves.js
function leaves_default() {
  var leaves = [];
  this.eachBefore(function(node4) {
    if (!node4.children) {
      leaves.push(node4);
    }
  });
  return leaves;
}

// node_modules/d3-hierarchy/src/hierarchy/links.js
function links_default() {
  var root25 = this, links5 = [];
  root25.each(function(node4) {
    if (node4 !== root25) {
      links5.push({ source: node4.parent, target: node4 });
    }
  });
  return links5;
}

// node_modules/d3-hierarchy/src/hierarchy/iterator.js
function* iterator_default2() {
  var node4 = this, current, next = [node4], children2, i, n;
  do {
    current = next.reverse(), next = [];
    while (node4 = current.pop()) {
      yield node4;
      if (children2 = node4.children) {
        for (i = 0, n = children2.length; i < n; ++i) {
          next.push(children2[i]);
        }
      }
    }
  } while (next.length);
}

// node_modules/d3-hierarchy/src/hierarchy/index.js
function hierarchy(data, children2) {
  if (data instanceof Map) {
    data = [void 0, data];
    if (children2 === void 0) children2 = mapChildren;
  } else if (children2 === void 0) {
    children2 = objectChildren;
  }
  var root25 = new Node(data), node4, nodes4 = [root25], child, childs, i, n;
  while (node4 = nodes4.pop()) {
    if ((childs = children2(node4.data)) && (n = (childs = Array.from(childs)).length)) {
      node4.children = childs;
      for (i = n - 1; i >= 0; --i) {
        nodes4.push(child = childs[i] = new Node(childs[i]));
        child.parent = node4;
        child.depth = node4.depth + 1;
      }
    }
  }
  return root25.eachBefore(computeHeight);
}
function node_copy() {
  return hierarchy(this).eachBefore(copyData);
}
function objectChildren(d) {
  return d.children;
}
function mapChildren(d) {
  return Array.isArray(d) ? d[1] : null;
}
function copyData(node4) {
  if (node4.data.value !== void 0) node4.value = node4.data.value;
  node4.data = node4.data.data;
}
function computeHeight(node4) {
  var height = 0;
  do
    node4.height = height;
  while ((node4 = node4.parent) && node4.height < ++height);
}
function Node(data) {
  this.data = data;
  this.depth = this.height = 0;
  this.parent = null;
}
Node.prototype = hierarchy.prototype = {
  constructor: Node,
  count: count_default,
  each: each_default2,
  eachAfter: eachAfter_default,
  eachBefore: eachBefore_default,
  find: find_default,
  sum: sum_default,
  sort: sort_default2,
  path: path_default3,
  ancestors: ancestors_default,
  descendants: descendants_default,
  leaves: leaves_default,
  links: links_default,
  copy: node_copy,
  [Symbol.iterator]: iterator_default2
};

// node_modules/d3-hierarchy/src/lcg.js
var a3 = 1664525;
var c2 = 1013904223;
var m = 4294967296;
function lcg_default() {
  let s3 = 1;
  return () => (s3 = (a3 * s3 + c2) % m) / m;
}

// node_modules/d3-hierarchy/src/array.js
function array_default3(x3) {
  return typeof x3 === "object" && "length" in x3 ? x3 : Array.from(x3);
}
function shuffle(array3, random) {
  let m2 = array3.length, t, i;
  while (m2) {
    i = random() * m2-- | 0;
    t = array3[m2];
    array3[m2] = array3[i];
    array3[i] = t;
  }
  return array3;
}

// node_modules/d3-hierarchy/src/pack/enclose.js
function packEncloseRandom(circles, random) {
  var i = 0, n = (circles = shuffle(Array.from(circles), random)).length, B3 = [], p, e;
  while (i < n) {
    p = circles[i];
    if (e && enclosesWeak(e, p)) ++i;
    else e = encloseBasis(B3 = extendBasis(B3, p)), i = 0;
  }
  return e;
}
function extendBasis(B3, p) {
  var i, j;
  if (enclosesWeakAll(p, B3)) return [p];
  for (i = 0; i < B3.length; ++i) {
    if (enclosesNot(p, B3[i]) && enclosesWeakAll(encloseBasis2(B3[i], p), B3)) {
      return [B3[i], p];
    }
  }
  for (i = 0; i < B3.length - 1; ++i) {
    for (j = i + 1; j < B3.length; ++j) {
      if (enclosesNot(encloseBasis2(B3[i], B3[j]), p) && enclosesNot(encloseBasis2(B3[i], p), B3[j]) && enclosesNot(encloseBasis2(B3[j], p), B3[i]) && enclosesWeakAll(encloseBasis3(B3[i], B3[j], p), B3)) {
        return [B3[i], B3[j], p];
      }
    }
  }
  throw new Error();
}
function enclosesNot(a4, b) {
  var dr = a4.r - b.r, dx = b.x - a4.x, dy = b.y - a4.y;
  return dr < 0 || dr * dr < dx * dx + dy * dy;
}
function enclosesWeak(a4, b) {
  var dr = a4.r - b.r + Math.max(a4.r, b.r, 1) * 1e-9, dx = b.x - a4.x, dy = b.y - a4.y;
  return dr > 0 && dr * dr > dx * dx + dy * dy;
}
function enclosesWeakAll(a4, B3) {
  for (var i = 0; i < B3.length; ++i) {
    if (!enclosesWeak(a4, B3[i])) {
      return false;
    }
  }
  return true;
}
function encloseBasis(B3) {
  switch (B3.length) {
    case 1:
      return encloseBasis1(B3[0]);
    case 2:
      return encloseBasis2(B3[0], B3[1]);
    case 3:
      return encloseBasis3(B3[0], B3[1], B3[2]);
  }
}
function encloseBasis1(a4) {
  return {
    x: a4.x,
    y: a4.y,
    r: a4.r
  };
}
function encloseBasis2(a4, b) {
  var x13 = a4.x, y13 = a4.y, r1 = a4.r, x22 = b.x, y22 = b.y, r2 = b.r, x21 = x22 - x13, y21 = y22 - y13, r21 = r2 - r1, l = Math.sqrt(x21 * x21 + y21 * y21);
  return {
    x: (x13 + x22 + x21 / l * r21) / 2,
    y: (y13 + y22 + y21 / l * r21) / 2,
    r: (l + r1 + r2) / 2
  };
}
function encloseBasis3(a4, b, c3) {
  var x13 = a4.x, y13 = a4.y, r1 = a4.r, x22 = b.x, y22 = b.y, r2 = b.r, x3 = c3.x, y3 = c3.y, r3 = c3.r, a22 = x13 - x22, a32 = x13 - x3, b22 = y13 - y22, b32 = y13 - y3, c22 = r2 - r1, c32 = r3 - r1, d1 = x13 * x13 + y13 * y13 - r1 * r1, d2 = d1 - x22 * x22 - y22 * y22 + r2 * r2, d3 = d1 - x3 * x3 - y3 * y3 + r3 * r3, ab = a32 * b22 - a22 * b32, xa = (b22 * d3 - b32 * d2) / (ab * 2) - x13, xb = (b32 * c22 - b22 * c32) / ab, ya = (a32 * d2 - a22 * d3) / (ab * 2) - y13, yb = (a22 * c32 - a32 * c22) / ab, A6 = xb * xb + yb * yb - 1, B3 = 2 * (r1 + xa * xb + ya * yb), C2 = xa * xa + ya * ya - r1 * r1, r = -(Math.abs(A6) > 1e-6 ? (B3 + Math.sqrt(B3 * B3 - 4 * A6 * C2)) / (2 * A6) : C2 / B3);
  return {
    x: x13 + xa + xb * r,
    y: y13 + ya + yb * r,
    r
  };
}

// node_modules/d3-hierarchy/src/pack/siblings.js
function place(b, a4, c3) {
  var dx = b.x - a4.x, x3, a22, dy = b.y - a4.y, y3, b22, d2 = dx * dx + dy * dy;
  if (d2) {
    a22 = a4.r + c3.r, a22 *= a22;
    b22 = b.r + c3.r, b22 *= b22;
    if (a22 > b22) {
      x3 = (d2 + b22 - a22) / (2 * d2);
      y3 = Math.sqrt(Math.max(0, b22 / d2 - x3 * x3));
      c3.x = b.x - x3 * dx - y3 * dy;
      c3.y = b.y - x3 * dy + y3 * dx;
    } else {
      x3 = (d2 + a22 - b22) / (2 * d2);
      y3 = Math.sqrt(Math.max(0, a22 / d2 - x3 * x3));
      c3.x = a4.x + x3 * dx - y3 * dy;
      c3.y = a4.y + x3 * dy + y3 * dx;
    }
  } else {
    c3.x = a4.x + c3.r;
    c3.y = a4.y;
  }
}
function intersects(a4, b) {
  var dr = a4.r + b.r - 1e-6, dx = b.x - a4.x, dy = b.y - a4.y;
  return dr > 0 && dr * dr > dx * dx + dy * dy;
}
function score(node4) {
  var a4 = node4._, b = node4.next._, ab = a4.r + b.r, dx = (a4.x * b.r + b.x * a4.r) / ab, dy = (a4.y * b.r + b.y * a4.r) / ab;
  return dx * dx + dy * dy;
}
function Node2(circle2) {
  this._ = circle2;
  this.next = null;
  this.previous = null;
}
function packSiblingsRandom(circles, random) {
  if (!(n = (circles = array_default3(circles)).length)) return 0;
  var a4, b, c3, n, aa, ca, i, j, k4, sj, sk;
  a4 = circles[0], a4.x = 0, a4.y = 0;
  if (!(n > 1)) return a4.r;
  b = circles[1], a4.x = -b.r, b.x = a4.r, b.y = 0;
  if (!(n > 2)) return a4.r + b.r;
  place(b, a4, c3 = circles[2]);
  a4 = new Node2(a4), b = new Node2(b), c3 = new Node2(c3);
  a4.next = c3.previous = b;
  b.next = a4.previous = c3;
  c3.next = b.previous = a4;
  pack: for (i = 3; i < n; ++i) {
    place(a4._, b._, c3 = circles[i]), c3 = new Node2(c3);
    j = b.next, k4 = a4.previous, sj = b._.r, sk = a4._.r;
    do {
      if (sj <= sk) {
        if (intersects(j._, c3._)) {
          b = j, a4.next = b, b.previous = a4, --i;
          continue pack;
        }
        sj += j._.r, j = j.next;
      } else {
        if (intersects(k4._, c3._)) {
          a4 = k4, a4.next = b, b.previous = a4, --i;
          continue pack;
        }
        sk += k4._.r, k4 = k4.previous;
      }
    } while (j !== k4.next);
    c3.previous = a4, c3.next = b, a4.next = b.previous = b = c3;
    aa = score(a4);
    while ((c3 = c3.next) !== b) {
      if ((ca = score(c3)) < aa) {
        a4 = c3, aa = ca;
      }
    }
    b = a4.next;
  }
  a4 = [b._], c3 = b;
  while ((c3 = c3.next) !== b) a4.push(c3._);
  c3 = packEncloseRandom(a4, random);
  for (i = 0; i < n; ++i) a4 = circles[i], a4.x -= c3.x, a4.y -= c3.y;
  return c3.r;
}
function siblings_default(circles) {
  packSiblingsRandom(circles, lcg_default());
  return circles;
}

// node_modules/d3-hierarchy/src/treemap/round.js
function round_default2(node4) {
  node4.x0 = Math.round(node4.x0);
  node4.y0 = Math.round(node4.y0);
  node4.x1 = Math.round(node4.x1);
  node4.y1 = Math.round(node4.y1);
}

// node_modules/d3-hierarchy/src/treemap/dice.js
function dice_default(parent, x06, y06, x13, y13) {
  var nodes4 = parent.children, node4, i = -1, n = nodes4.length, k4 = parent.value && (x13 - x06) / parent.value;
  while (++i < n) {
    node4 = nodes4[i], node4.y0 = y06, node4.y1 = y13;
    node4.x0 = x06, node4.x1 = x06 += node4.value * k4;
  }
}

// node_modules/d3-hierarchy/src/partition.js
function partition_default() {
  var dx = 1, dy = 1, padding = 0, round2 = false;
  function partition(root25) {
    var n = root25.height + 1;
    root25.x0 = root25.y0 = padding;
    root25.x1 = dx;
    root25.y1 = dy / n;
    root25.eachBefore(positionNode(dy, n));
    if (round2) root25.eachBefore(round_default2);
    return root25;
  }
  function positionNode(dy2, n) {
    return function(node4) {
      if (node4.children) {
        dice_default(node4, node4.x0, dy2 * (node4.depth + 1) / n, node4.x1, dy2 * (node4.depth + 2) / n);
      }
      var x06 = node4.x0, y06 = node4.y0, x13 = node4.x1 - padding, y13 = node4.y1 - padding;
      if (x13 < x06) x06 = x13 = (x06 + x13) / 2;
      if (y13 < y06) y06 = y13 = (y06 + y13) / 2;
      node4.x0 = x06;
      node4.y0 = y06;
      node4.x1 = x13;
      node4.y1 = y13;
    };
  }
  partition.round = function(x3) {
    return arguments.length ? (round2 = !!x3, partition) : round2;
  };
  partition.size = function(x3) {
    return arguments.length ? (dx = +x3[0], dy = +x3[1], partition) : [dx, dy];
  };
  partition.padding = function(x3) {
    return arguments.length ? (padding = +x3, partition) : padding;
  };
  return partition;
}

// node_modules/d3-hierarchy/src/tree.js
function TreeNode(node4, i) {
  this._ = node4;
  this.parent = null;
  this.children = null;
  this.A = null;
  this.a = this;
  this.z = 0;
  this.m = 0;
  this.c = 0;
  this.s = 0;
  this.t = null;
  this.i = i;
}
TreeNode.prototype = Object.create(Node.prototype);

// node_modules/d3-hierarchy/src/treemap/slice.js
function slice_default(parent, x06, y06, x13, y13) {
  var nodes4 = parent.children, node4, i = -1, n = nodes4.length, k4 = parent.value && (y13 - y06) / parent.value;
  while (++i < n) {
    node4 = nodes4[i], node4.x0 = x06, node4.x1 = x13;
    node4.y0 = y06, node4.y1 = y06 += node4.value * k4;
  }
}

// node_modules/d3-hierarchy/src/treemap/squarify.js
var phi = (1 + Math.sqrt(5)) / 2;
function squarifyRatio(ratio, parent, x06, y06, x13, y13) {
  var rows2 = [], nodes4 = parent.children, row2, nodeValue, i0 = 0, i1 = 0, n = nodes4.length, dx, dy, value2 = parent.value, sumValue, minValue, maxValue, newRatio, minRatio, alpha, beta;
  while (i0 < n) {
    dx = x13 - x06, dy = y13 - y06;
    do
      sumValue = nodes4[i1++].value;
    while (!sumValue && i1 < n);
    minValue = maxValue = sumValue;
    alpha = Math.max(dy / dx, dx / dy) / (value2 * ratio);
    beta = sumValue * sumValue * alpha;
    minRatio = Math.max(maxValue / beta, beta / minValue);
    for (; i1 < n; ++i1) {
      sumValue += nodeValue = nodes4[i1].value;
      if (nodeValue < minValue) minValue = nodeValue;
      if (nodeValue > maxValue) maxValue = nodeValue;
      beta = sumValue * sumValue * alpha;
      newRatio = Math.max(maxValue / beta, beta / minValue);
      if (newRatio > minRatio) {
        sumValue -= nodeValue;
        break;
      }
      minRatio = newRatio;
    }
    rows2.push(row2 = { value: sumValue, dice: dx < dy, children: nodes4.slice(i0, i1) });
    if (row2.dice) dice_default(row2, x06, y06, x13, value2 ? y06 += dy * sumValue / value2 : y13);
    else slice_default(row2, x06, y06, value2 ? x06 += dx * sumValue / value2 : x13, y13);
    value2 -= sumValue, i0 = i1;
  }
  return rows2;
}
var squarify_default = function custom24(ratio) {
  function squarify(parent, x06, y06, x13, y13) {
    squarifyRatio(ratio, parent, x06, y06, x13, y13);
  }
  squarify.ratio = function(x3) {
    return custom24((x3 = +x3) > 1 ? x3 : 1);
  };
  return squarify;
}(phi);

// node_modules/d3-hierarchy/src/treemap/resquarify.js
var resquarify_default = function custom25(ratio) {
  function resquarify(parent, x06, y06, x13, y13) {
    if ((rows2 = parent._squarify) && rows2.ratio === ratio) {
      var rows2, row2, nodes4, i, j = -1, n, m2 = rows2.length, value2 = parent.value;
      while (++j < m2) {
        row2 = rows2[j], nodes4 = row2.children;
        for (i = row2.value = 0, n = nodes4.length; i < n; ++i) row2.value += nodes4[i].value;
        if (row2.dice) dice_default(row2, x06, y06, x13, value2 ? y06 += (y13 - y06) * row2.value / value2 : y13);
        else slice_default(row2, x06, y06, value2 ? x06 += (x13 - x06) * row2.value / value2 : x13, y13);
        value2 -= row2.value;
      }
    } else {
      parent._squarify = rows2 = squarifyRatio(ratio, parent, x06, y06, x13, y13);
      rows2.ratio = ratio;
    }
  }
  resquarify.ratio = function(x3) {
    return custom25((x3 = +x3) > 1 ? x3 : 1);
  };
  return resquarify;
}(phi);

// node_modules/@unovis/ts/utils/map.js
function getDataLatLngBounds(data, pointLatitude, pointLongitude, paddingDegrees = 1) {
  const northWest = {
    lat: max(data !== null && data !== void 0 ? data : [], (d) => getNumber(d, pointLatitude)),
    lng: min(data !== null && data !== void 0 ? data : [], (d) => getNumber(d, pointLongitude))
  };
  const southEast = {
    lat: min(data !== null && data !== void 0 ? data : [], (d) => getNumber(d, pointLatitude)),
    lng: max(data !== null && data !== void 0 ? data : [], (d) => getNumber(d, pointLongitude))
  };
  return [
    [northWest.lat + paddingDegrees || 90, northWest.lng - paddingDegrees || -180],
    [southEast.lat - paddingDegrees || -70, southEast.lng + paddingDegrees || 180]
  ];
}

// node_modules/@unovis/ts/data-models/map.js
var MapDataModel = class extends CoreDataModel {
  getDataLatLngBounds(pointLatitude, pointLongitude, paddingDegrees = 1) {
    return getDataLatLngBounds(this.data, pointLatitude, pointLongitude, paddingDegrees);
  }
};

// node_modules/@unovis/ts/components/leaflet-map/renderer/mapboxgl-utils.js
function constraintMapView(map5, latMin = -75, latMax = 85) {
  const bounds = map5.getBounds();
  const northEast = bounds.getNorthEast();
  const southWest = bounds.getSouthWest();
  if (northEast.lat > latMax && southWest.lat < latMin) {
    map5.fitBounds([
      [latMin, 0],
      [latMax, 0]
    ]);
  }
}
function mapboxglWheelEvent(map5, layer, event) {
  const { deltaY } = event;
  if (!layer || !layer.getMaplibreMap)
    return;
  const mapboxmap = layer.getMaplibreMap();
  const delta = deltaY * -1;
  const bounds = map5.getBounds();
  const northEast = bounds.getNorthEast();
  const southWest = bounds.getSouthWest();
  const latMin = -70;
  const latMax = 80;
  if (delta < 0 && northEast.lat > latMax && southWest.lat < latMin) {
    constraintMapView(map5);
    return;
  }
  const zoom = mapboxmap.getZoom() + delta * 1e-3;
  const xy = map5.mouseEventToLayerPoint(event);
  map5.setZoomAround(xy, zoom + 1, { animate: false });
}
var mapboxglWheelEventThrottled = throttle(mapboxglWheelEvent, 32);
var constraintMapViewThrottled = throttle(constraintMapView, 1e3);

// node_modules/kdbush/src/sort.js
function sortKD(ids, coords, nodeSize, left3, right3, depth) {
  if (right3 - left3 <= nodeSize) return;
  const m2 = left3 + right3 >> 1;
  select(ids, coords, m2, left3, right3, depth % 2);
  sortKD(ids, coords, nodeSize, left3, m2 - 1, depth + 1);
  sortKD(ids, coords, nodeSize, m2 + 1, right3, depth + 1);
}
function select(ids, coords, k4, left3, right3, inc) {
  while (right3 > left3) {
    if (right3 - left3 > 600) {
      const n = right3 - left3 + 1;
      const m2 = k4 - left3 + 1;
      const z = Math.log(n);
      const s3 = 0.5 * Math.exp(2 * z / 3);
      const sd = 0.5 * Math.sqrt(z * s3 * (n - s3) / n) * (m2 - n / 2 < 0 ? -1 : 1);
      const newLeft = Math.max(left3, Math.floor(k4 - m2 * s3 / n + sd));
      const newRight = Math.min(right3, Math.floor(k4 + (n - m2) * s3 / n + sd));
      select(ids, coords, k4, newLeft, newRight, inc);
    }
    const t = coords[2 * k4 + inc];
    let i = left3;
    let j = right3;
    swapItem(ids, coords, left3, k4);
    if (coords[2 * right3 + inc] > t) swapItem(ids, coords, left3, right3);
    while (i < j) {
      swapItem(ids, coords, i, j);
      i++;
      j--;
      while (coords[2 * i + inc] < t) i++;
      while (coords[2 * j + inc] > t) j--;
    }
    if (coords[2 * left3 + inc] === t) swapItem(ids, coords, left3, j);
    else {
      j++;
      swapItem(ids, coords, j, right3);
    }
    if (j <= k4) left3 = j + 1;
    if (k4 <= j) right3 = j - 1;
  }
}
function swapItem(ids, coords, i, j) {
  swap(ids, i, j);
  swap(coords, 2 * i, 2 * j);
  swap(coords, 2 * i + 1, 2 * j + 1);
}
function swap(arr, i, j) {
  const tmp = arr[i];
  arr[i] = arr[j];
  arr[j] = tmp;
}

// node_modules/kdbush/src/range.js
function range2(ids, coords, minX, minY, maxX, maxY, nodeSize) {
  const stack = [0, ids.length - 1, 0];
  const result = [];
  let x3, y3;
  while (stack.length) {
    const axis3 = stack.pop();
    const right3 = stack.pop();
    const left3 = stack.pop();
    if (right3 - left3 <= nodeSize) {
      for (let i = left3; i <= right3; i++) {
        x3 = coords[2 * i];
        y3 = coords[2 * i + 1];
        if (x3 >= minX && x3 <= maxX && y3 >= minY && y3 <= maxY) result.push(ids[i]);
      }
      continue;
    }
    const m2 = Math.floor((left3 + right3) / 2);
    x3 = coords[2 * m2];
    y3 = coords[2 * m2 + 1];
    if (x3 >= minX && x3 <= maxX && y3 >= minY && y3 <= maxY) result.push(ids[m2]);
    const nextAxis = (axis3 + 1) % 2;
    if (axis3 === 0 ? minX <= x3 : minY <= y3) {
      stack.push(left3);
      stack.push(m2 - 1);
      stack.push(nextAxis);
    }
    if (axis3 === 0 ? maxX >= x3 : maxY >= y3) {
      stack.push(m2 + 1);
      stack.push(right3);
      stack.push(nextAxis);
    }
  }
  return result;
}

// node_modules/kdbush/src/within.js
function within(ids, coords, qx, qy, r, nodeSize) {
  const stack = [0, ids.length - 1, 0];
  const result = [];
  const r2 = r * r;
  while (stack.length) {
    const axis3 = stack.pop();
    const right3 = stack.pop();
    const left3 = stack.pop();
    if (right3 - left3 <= nodeSize) {
      for (let i = left3; i <= right3; i++) {
        if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) result.push(ids[i]);
      }
      continue;
    }
    const m2 = Math.floor((left3 + right3) / 2);
    const x3 = coords[2 * m2];
    const y3 = coords[2 * m2 + 1];
    if (sqDist(x3, y3, qx, qy) <= r2) result.push(ids[m2]);
    const nextAxis = (axis3 + 1) % 2;
    if (axis3 === 0 ? qx - r <= x3 : qy - r <= y3) {
      stack.push(left3);
      stack.push(m2 - 1);
      stack.push(nextAxis);
    }
    if (axis3 === 0 ? qx + r >= x3 : qy + r >= y3) {
      stack.push(m2 + 1);
      stack.push(right3);
      stack.push(nextAxis);
    }
  }
  return result;
}
function sqDist(ax, ay, bx, by) {
  const dx = ax - bx;
  const dy = ay - by;
  return dx * dx + dy * dy;
}

// node_modules/kdbush/src/index.js
var defaultGetX = (p) => p[0];
var defaultGetY = (p) => p[1];
var KDBush = class {
  constructor(points3, getX3 = defaultGetX, getY3 = defaultGetY, nodeSize = 64, ArrayType = Float64Array) {
    this.nodeSize = nodeSize;
    this.points = points3;
    const IndexArrayType = points3.length < 65536 ? Uint16Array : Uint32Array;
    const ids = this.ids = new IndexArrayType(points3.length);
    const coords = this.coords = new ArrayType(points3.length * 2);
    for (let i = 0; i < points3.length; i++) {
      ids[i] = i;
      coords[2 * i] = getX3(points3[i]);
      coords[2 * i + 1] = getY3(points3[i]);
    }
    sortKD(ids, coords, nodeSize, 0, ids.length - 1, 0);
  }
  range(minX, minY, maxX, maxY) {
    return range2(this.ids, this.coords, minX, minY, maxX, maxY, this.nodeSize);
  }
  within(x3, y3, r) {
    return within(this.ids, this.coords, x3, y3, r, this.nodeSize);
  }
};

// node_modules/supercluster/index.js
var defaultOptions = {
  minZoom: 0,
  // min zoom to generate clusters on
  maxZoom: 16,
  // max zoom level to cluster the points on
  minPoints: 2,
  // minimum points to form a cluster
  radius: 40,
  // cluster radius in pixels
  extent: 512,
  // tile extent (radius is calculated relative to it)
  nodeSize: 64,
  // size of the KD-tree leaf node, affects performance
  log: false,
  // whether to log timing info
  // whether to generate numeric ids for input features (in vector tiles)
  generateId: false,
  // a reduce function for calculating custom cluster properties
  reduce: null,
  // (accumulated, props) => { accumulated.sum += props.sum; }
  // properties to use for individual points when running the reducer
  map: (props) => props
  // props => ({sum: props.my_value})
};
var fround = Math.fround || /* @__PURE__ */ ((tmp) => (x3) => {
  tmp[0] = +x3;
  return tmp[0];
})(new Float32Array(1));
var Supercluster = class {
  constructor(options) {
    this.options = extend3(Object.create(defaultOptions), options);
    this.trees = new Array(this.options.maxZoom + 1);
  }
  load(points3) {
    const { log: log4, minZoom, maxZoom, nodeSize } = this.options;
    if (log4) console.time("total time");
    const timerId = `prepare ${points3.length} points`;
    if (log4) console.time(timerId);
    this.points = points3;
    let clusters = [];
    for (let i = 0; i < points3.length; i++) {
      if (!points3[i].geometry) continue;
      clusters.push(createPointCluster(points3[i], i));
    }
    this.trees[maxZoom + 1] = new KDBush(clusters, getX, getY, nodeSize, Float32Array);
    if (log4) console.timeEnd(timerId);
    for (let z = maxZoom; z >= minZoom; z--) {
      const now2 = +Date.now();
      clusters = this._cluster(clusters, z);
      this.trees[z] = new KDBush(clusters, getX, getY, nodeSize, Float32Array);
      if (log4) console.log("z%d: %d clusters in %dms", z, clusters.length, +Date.now() - now2);
    }
    if (log4) console.timeEnd("total time");
    return this;
  }
  getClusters(bbox, zoom) {
    let minLng = ((bbox[0] + 180) % 360 + 360) % 360 - 180;
    const minLat = Math.max(-90, Math.min(90, bbox[1]));
    let maxLng = bbox[2] === 180 ? 180 : ((bbox[2] + 180) % 360 + 360) % 360 - 180;
    const maxLat = Math.max(-90, Math.min(90, bbox[3]));
    if (bbox[2] - bbox[0] >= 360) {
      minLng = -180;
      maxLng = 180;
    } else if (minLng > maxLng) {
      const easternHem = this.getClusters([minLng, minLat, 180, maxLat], zoom);
      const westernHem = this.getClusters([-180, minLat, maxLng, maxLat], zoom);
      return easternHem.concat(westernHem);
    }
    const tree = this.trees[this._limitZoom(zoom)];
    const ids = tree.range(lngX(minLng), latY(maxLat), lngX(maxLng), latY(minLat));
    const clusters = [];
    for (const id2 of ids) {
      const c3 = tree.points[id2];
      clusters.push(c3.numPoints ? getClusterJSON(c3) : this.points[c3.index]);
    }
    return clusters;
  }
  getChildren(clusterId) {
    const originId = this._getOriginId(clusterId);
    const originZoom = this._getOriginZoom(clusterId);
    const errorMsg = "No cluster with the specified id.";
    const index3 = this.trees[originZoom];
    if (!index3) throw new Error(errorMsg);
    const origin = index3.points[originId];
    if (!origin) throw new Error(errorMsg);
    const r = this.options.radius / (this.options.extent * Math.pow(2, originZoom - 1));
    const ids = index3.within(origin.x, origin.y, r);
    const children2 = [];
    for (const id2 of ids) {
      const c3 = index3.points[id2];
      if (c3.parentId === clusterId) {
        children2.push(c3.numPoints ? getClusterJSON(c3) : this.points[c3.index]);
      }
    }
    if (children2.length === 0) throw new Error(errorMsg);
    return children2;
  }
  getLeaves(clusterId, limit, offset) {
    limit = limit || 10;
    offset = offset || 0;
    const leaves = [];
    this._appendLeaves(leaves, clusterId, limit, offset, 0);
    return leaves;
  }
  getTile(z, x3, y3) {
    const tree = this.trees[this._limitZoom(z)];
    const z2 = Math.pow(2, z);
    const { extent: extent2, radius } = this.options;
    const p = radius / extent2;
    const top2 = (y3 - p) / z2;
    const bottom2 = (y3 + 1 + p) / z2;
    const tile = {
      features: []
    };
    this._addTileFeatures(
      tree.range((x3 - p) / z2, top2, (x3 + 1 + p) / z2, bottom2),
      tree.points,
      x3,
      y3,
      z2,
      tile
    );
    if (x3 === 0) {
      this._addTileFeatures(
        tree.range(1 - p / z2, top2, 1, bottom2),
        tree.points,
        z2,
        y3,
        z2,
        tile
      );
    }
    if (x3 === z2 - 1) {
      this._addTileFeatures(
        tree.range(0, top2, p / z2, bottom2),
        tree.points,
        -1,
        y3,
        z2,
        tile
      );
    }
    return tile.features.length ? tile : null;
  }
  getClusterExpansionZoom(clusterId) {
    let expansionZoom = this._getOriginZoom(clusterId) - 1;
    while (expansionZoom <= this.options.maxZoom) {
      const children2 = this.getChildren(clusterId);
      expansionZoom++;
      if (children2.length !== 1) break;
      clusterId = children2[0].properties.cluster_id;
    }
    return expansionZoom;
  }
  _appendLeaves(result, clusterId, limit, offset, skipped) {
    const children2 = this.getChildren(clusterId);
    for (const child of children2) {
      const props = child.properties;
      if (props && props.cluster) {
        if (skipped + props.point_count <= offset) {
          skipped += props.point_count;
        } else {
          skipped = this._appendLeaves(result, props.cluster_id, limit, offset, skipped);
        }
      } else if (skipped < offset) {
        skipped++;
      } else {
        result.push(child);
      }
      if (result.length === limit) break;
    }
    return skipped;
  }
  _addTileFeatures(ids, points3, x3, y3, z2, tile) {
    for (const i of ids) {
      const c3 = points3[i];
      const isCluster = c3.numPoints;
      let tags, px, py;
      if (isCluster) {
        tags = getClusterProperties(c3);
        px = c3.x;
        py = c3.y;
      } else {
        const p = this.points[c3.index];
        tags = p.properties;
        px = lngX(p.geometry.coordinates[0]);
        py = latY(p.geometry.coordinates[1]);
      }
      const f = {
        type: 1,
        geometry: [[
          Math.round(this.options.extent * (px * z2 - x3)),
          Math.round(this.options.extent * (py * z2 - y3))
        ]],
        tags
      };
      let id2;
      if (isCluster) {
        id2 = c3.id;
      } else if (this.options.generateId) {
        id2 = c3.index;
      } else if (this.points[c3.index].id) {
        id2 = this.points[c3.index].id;
      }
      if (id2 !== void 0) f.id = id2;
      tile.features.push(f);
    }
  }
  _limitZoom(z) {
    return Math.max(this.options.minZoom, Math.min(Math.floor(+z), this.options.maxZoom + 1));
  }
  _cluster(points3, zoom) {
    const clusters = [];
    const { radius, extent: extent2, reduce: reduce2, minPoints } = this.options;
    const r = radius / (extent2 * Math.pow(2, zoom));
    for (let i = 0; i < points3.length; i++) {
      const p = points3[i];
      if (p.zoom <= zoom) continue;
      p.zoom = zoom;
      const tree = this.trees[zoom + 1];
      const neighborIds = tree.within(p.x, p.y, r);
      const numPointsOrigin = p.numPoints || 1;
      let numPoints = numPointsOrigin;
      for (const neighborId of neighborIds) {
        const b = tree.points[neighborId];
        if (b.zoom > zoom) numPoints += b.numPoints || 1;
      }
      if (numPoints > numPointsOrigin && numPoints >= minPoints) {
        let wx = p.x * numPointsOrigin;
        let wy = p.y * numPointsOrigin;
        let clusterProperties = reduce2 && numPointsOrigin > 1 ? this._map(p, true) : null;
        const id2 = (i << 5) + (zoom + 1) + this.points.length;
        for (const neighborId of neighborIds) {
          const b = tree.points[neighborId];
          if (b.zoom <= zoom) continue;
          b.zoom = zoom;
          const numPoints2 = b.numPoints || 1;
          wx += b.x * numPoints2;
          wy += b.y * numPoints2;
          b.parentId = id2;
          if (reduce2) {
            if (!clusterProperties) clusterProperties = this._map(p, true);
            reduce2(clusterProperties, this._map(b));
          }
        }
        p.parentId = id2;
        clusters.push(createCluster(wx / numPoints, wy / numPoints, id2, numPoints, clusterProperties));
      } else {
        clusters.push(p);
        if (numPoints > 1) {
          for (const neighborId of neighborIds) {
            const b = tree.points[neighborId];
            if (b.zoom <= zoom) continue;
            b.zoom = zoom;
            clusters.push(b);
          }
        }
      }
    }
    return clusters;
  }
  // get index of the point from which the cluster originated
  _getOriginId(clusterId) {
    return clusterId - this.points.length >> 5;
  }
  // get zoom of the point from which the cluster originated
  _getOriginZoom(clusterId) {
    return (clusterId - this.points.length) % 32;
  }
  _map(point13, clone) {
    if (point13.numPoints) {
      return clone ? extend3({}, point13.properties) : point13.properties;
    }
    const original = this.points[point13.index].properties;
    const result = this.options.map(original);
    return clone && result === original ? extend3({}, result) : result;
  }
};
function createCluster(x3, y3, id2, numPoints, properties) {
  return {
    x: fround(x3),
    // weighted cluster center; round for consistency with Float32Array index
    y: fround(y3),
    zoom: Infinity,
    // the last zoom the cluster was processed at
    id: id2,
    // encodes index of the first child of the cluster and its zoom level
    parentId: -1,
    // parent cluster id
    numPoints,
    properties
  };
}
function createPointCluster(p, id2) {
  const [x3, y3] = p.geometry.coordinates;
  return {
    x: fround(lngX(x3)),
    // projected point coordinates
    y: fround(latY(y3)),
    zoom: Infinity,
    // the last zoom the point was processed at
    index: id2,
    // index of the source feature in the original input array,
    parentId: -1
    // parent cluster id
  };
}
function getClusterJSON(cluster2) {
  return {
    type: "Feature",
    id: cluster2.id,
    properties: getClusterProperties(cluster2),
    geometry: {
      type: "Point",
      coordinates: [xLng(cluster2.x), yLat(cluster2.y)]
    }
  };
}
function getClusterProperties(cluster2) {
  const count3 = cluster2.numPoints;
  const abbrev = count3 >= 1e4 ? `${Math.round(count3 / 1e3)}k` : count3 >= 1e3 ? `${Math.round(count3 / 100) / 10}k` : count3;
  return extend3(extend3({}, cluster2.properties), {
    cluster: true,
    cluster_id: cluster2.id,
    point_count: count3,
    point_count_abbreviated: abbrev
  });
}
function lngX(lng) {
  return lng / 360 + 0.5;
}
function latY(lat) {
  const sin6 = Math.sin(lat * Math.PI / 180);
  const y3 = 0.5 - 0.25 * Math.log((1 + sin6) / (1 - sin6)) / Math.PI;
  return y3 < 0 ? 0 : y3 > 1 ? 1 : y3;
}
function xLng(x3) {
  return (x3 - 0.5) * 360;
}
function yLat(y3) {
  const y22 = (180 - y3 * 360) * Math.PI / 180;
  return 360 * Math.atan(Math.exp(y22)) / Math.PI - 90;
}
function extend3(dest, src) {
  for (const id2 in src) dest[id2] = src[id2];
  return dest;
}
function getX(p) {
  return p.x;
}
function getY(p) {
  return p.y;
}

// node_modules/@unovis/ts/utils/html.js
function getHTMLTransform(el) {
  const styleTransform = select_default2(el).style("transform");
  const match3D = styleTransform.match(/matrix3d\((.*?)\)/);
  const match2D = styleTransform.match(/matrix\((.*?)\)/);
  if (!match3D && !match2D)
    return [0, 0, 0];
  if (match3D) {
    const values2 = match3D[1].split(",").map((d) => parseFloat(d.trim()));
    return values2.slice(0, 3);
  }
  const values = match2D[1].split(",").map((d) => parseFloat(d.trim()));
  values.push(0);
  return values.slice(0, 3);
}

// node_modules/@unovis/ts/components/leaflet-map/types.js
var LeafletMapRenderer;
(function(LeafletMapRenderer2) {
  LeafletMapRenderer2["Raster"] = "raster";
  LeafletMapRenderer2["MapLibre"] = "maplibre";
})(LeafletMapRenderer || (LeafletMapRenderer = {}));
var LeafletMapPointShape;
(function(LeafletMapPointShape2) {
  LeafletMapPointShape2["Square"] = "square";
  LeafletMapPointShape2["Circle"] = "circle";
  LeafletMapPointShape2["Triangle"] = "triangle";
  LeafletMapPointShape2["Ring"] = "ring";
})(LeafletMapPointShape || (LeafletMapPointShape = {}));

// node_modules/@unovis/ts/components/leaflet-map/modules/utils.js
function bBoxMerge(bBoxArray) {
  let box = { x1: 0, x2: 0, y1: 0, y2: 0 };
  bBoxArray.forEach((coords) => {
    if (!box) {
      box = Object.assign({}, coords);
    } else {
      if (box.x1 > coords.x1)
        box.x1 = coords.x1;
      if (box.y1 > coords.y1)
        box.y1 = coords.y1;
      if (box.x2 < coords.x2)
        box.x2 = coords.x2;
      if (box.y2 < coords.y2)
        box.y2 = coords.y2;
    }
  });
  return {
    x: box.x1,
    y: box.y1,
    width: box.x2 - box.x1,
    height: box.y2 - box.y1
  };
}
var getNextZoomLevelOnClusterClick = (level) => clamp(1 + level * 1.5, level, 12);
function projectPoint(geoJSONPoint, leafletMap) {
  const lat = geoJSONPoint.geometry.coordinates[1];
  const lon = geoJSONPoint.geometry.coordinates[0];
  const projected = leafletMap.latLngToLayerPoint([lat, lon]);
  return projected;
}
function getPointRadius(geoPoint, pointRadius, zoomLevel) {
  const isDynamic = !pointRadius;
  const radius = isDynamic ? 1 + 2 * Math.pow(zoomLevel, 0.8) : getNumber(geoPoint.properties, pointRadius);
  const isCluster = geoPoint.properties.cluster;
  return isCluster && isDynamic ? clamp(Math.pow(geoPoint.properties.point_count, 0.35) * radius, radius * 1.1, radius * 3) : radius;
}
function getPointPos(point13, leafletMap) {
  const properties = point13.properties;
  const isFromCluster = !!properties.expandedClusterPoint;
  if (isFromCluster) {
    const { x: x3, y: y3 } = projectPoint(properties.expandedClusterPoint, leafletMap);
    return {
      x: x3 + properties.dx,
      y: y3 + properties.dy
    };
  } else {
    return projectPoint(point13, leafletMap);
  }
}
function toGeoJSONPoint(d, i, pointLatitude, pointLongitude) {
  const lat = getNumber(d, pointLatitude);
  const lon = getNumber(d, pointLongitude);
  return {
    type: "Feature",
    properties: Object.assign(Object.assign({}, d), { _index: i }),
    geometry: {
      type: "Point",
      coordinates: [lon, lat]
    }
  };
}
function calculateClusterIndex(data, config, maxClusterZoomLevel = 23) {
  const { colorMap, pointShape, pointLatitude, pointLongitude, clusteringDistance } = config;
  return new Supercluster({
    radius: clusteringDistance,
    maxZoom: maxClusterZoomLevel,
    map: (d) => {
      const shape = getString(d, pointShape);
      const clusterPoint = { shape };
      for (const key of Object.keys(colorMap)) {
        clusterPoint[key] = d[key] || 0;
      }
      return clusterPoint;
    },
    reduce: (acc, clusterPoint) => {
      var _a, _b;
      acc.shape = acc.shape === clusterPoint.shape ? acc.shape : LeafletMapPointShape.Circle;
      acc.value = ((_a = acc.value) !== null && _a !== void 0 ? _a : 0) + ((_b = clusterPoint.value) !== null && _b !== void 0 ? _b : 0);
      for (const key of Object.keys(colorMap)) {
        acc[key] += clusterPoint[key];
      }
    }
  }).load(data.map((d, i) => toGeoJSONPoint(d, i, pointLatitude, pointLongitude)));
}
function getNodePathData({ x: x3, y: y3 }, radius, shape) {
  switch (shape) {
    case LeafletMapPointShape.Triangle:
      return polygon(radius * 2, 3);
    case LeafletMapPointShape.Square:
      return polygon(radius * 2, 4);
    case LeafletMapPointShape.Circle:
    case LeafletMapPointShape.Ring:
    default:
      return circlePath(x3, y3, radius);
  }
}
function getDonutData(d, colorMap) {
  return Object.keys(colorMap).map((key) => ({
    name: key,
    value: d[key],
    color: colorMap[key].color,
    className: colorMap[key].className
  }));
}
function geoJsonPointToScreenPoint(geoPoint, i, leafletMap, config) {
  var _a;
  const zoomLevel = leafletMap.getZoom();
  const isCluster = geoPoint.properties.cluster;
  const clusterIndex = geoPoint.properties.clusterIndex;
  const clusterPoints = isCluster ? clusterIndex.getLeaves(geoPoint.properties.cluster_id, Infinity).map((d) => d.properties) : void 0;
  const { x: x3, y: y3 } = getPointPos(geoPoint, leafletMap);
  const id2 = isCluster ? `cluster-${geoPoint.id}` : (_a = getString(geoPoint.properties, config.pointId)) !== null && _a !== void 0 ? _a : geoPoint.geometry.coordinates.join("");
  const pointColor = getColor(geoPoint.properties, isCluster ? config.clusterColor : config.pointColor);
  const radius = getPointRadius(geoPoint, isCluster ? config.clusterRadius : config.pointRadius, zoomLevel);
  const shape = isCluster ? LeafletMapPointShape.Circle : getString(geoPoint.properties, config.pointShape);
  const isRing = shape === LeafletMapPointShape.Ring;
  const donutData = getDonutData(geoPoint.properties, config.colorMap);
  const maxValue = max(donutData, (d) => d.value);
  const maxValueIndex = donutData.map((d) => d.value).indexOf(maxValue);
  const biggestDatum = donutData[maxValueIndex !== null && maxValueIndex !== void 0 ? maxValueIndex : 0];
  const color2 = isCluster ? pointColor : isRing ? null : pointColor !== null && pointColor !== void 0 ? pointColor : biggestDatum === null || biggestDatum === void 0 ? void 0 : biggestDatum.color;
  const bbox = { x1: x3 - radius, y1: y3 - radius, x2: x3 + radius, y2: y3 + radius };
  const path3 = getNodePathData({ x: 0, y: 0 }, radius, shape);
  const _zIndex = 0;
  const screenPoint = Object.assign(Object.assign({}, geoPoint), {
    id: id2,
    bbox,
    radius,
    donutData,
    path: path3,
    color: color2,
    isCluster,
    clusterIndex,
    clusterPoints,
    _zIndex
  });
  return screenPoint;
}
function shouldClusterExpand(cluster2, zoomLevel, midLevel = 4, maxLevel = 8, maxClusterZoomLevel = 23) {
  if (!cluster2)
    return false;
  const clusterExpansionZoomLevel = cluster2.clusterIndex.getClusterExpansionZoom(cluster2.properties.cluster_id);
  return zoomLevel >= maxLevel || zoomLevel >= midLevel && (cluster2.properties.point_count < 20 || clusterExpansionZoomLevel >= maxClusterZoomLevel);
}
function findPointAndClusterByPointId(points3, id2, pointId) {
  let point13;
  let cluster2;
  points3.forEach((p) => {
    var _a;
    if (p.isCluster) {
      const leaves = (_a = p.clusterIndex.getLeaves(p.properties.cluster_id, Infinity)) !== null && _a !== void 0 ? _a : [];
      const foundPoint = leaves.find((d) => getString(d.properties, pointId) === id2);
      if (foundPoint) {
        point13 = foundPoint;
        cluster2 = p;
      }
    }
  });
  return { point: point13, cluster: cluster2 };
}
function getNodeRelativePosition(d, leafletMap) {
  const paneTransform = getHTMLTransform(leafletMap.getPane("mapPane"));
  const { x: x3, y: y3 } = getPointPos(d, leafletMap);
  return { x: x3 + paneTransform[0], y: y3 + paneTransform[1] };
}
function getClusterRadius(cluster2) {
  const { points: points3 } = cluster2;
  const minX = min(points3.map((d) => d.properties.dx - d.properties.r));
  const maxX = max(points3.map((d) => d.properties.dx + d.properties.r));
  const minY = min(points3.map((d) => d.properties.dy - d.properties.r));
  const maxY = max(points3.map((d) => d.properties.dy + d.properties.r));
  return Math.sqrt(Math.pow(maxX - minX, 2) + Math.pow(maxY - minY, 2)) * 0.5;
}
function getClustersAndPoints(clusterIndex, leafletMap, customBounds) {
  const leafletBounds = leafletMap.getBounds();
  const southWest = leafletBounds.getSouthWest();
  const northEast = leafletBounds.getNorthEast();
  const bounds = customBounds || [southWest.lng, southWest.lat, northEast.lng, northEast.lat];
  const zoom = Math.round(leafletMap.getZoom());
  const points3 = clusterIndex.getClusters(bounds, zoom);
  for (const p of points3) {
    const point13 = p;
    const isCluster = point13.properties.cluster;
    if (isCluster) {
      point13.properties.clusterIndex = clusterIndex;
      point13.properties.clusterPoints = clusterIndex.getLeaves(point13.properties.cluster_id, Infinity).map((d) => d.properties);
    }
  }
  return points3;
}

// node_modules/@unovis/ts/components/leaflet-map/config.js
var LeafletMapDefaultConfig = Object.assign(Object.assign({}, ComponentDefaultConfig), {
  // General
  width: void 0,
  height: void 0,
  flyToDuration: 1500,
  fitViewPadding: [150, 150],
  zoomDuration: 800,
  initialBounds: void 0,
  fitBoundsOnUpdate: void 0,
  fitViewOnInit: true,
  fitViewOnUpdate: false,
  attribution: ['<a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap contributors</a>'],
  accessToken: "",
  style: void 0,
  styleDarkTheme: void 0,
  renderer: LeafletMapRenderer.MapLibre,
  // Map events
  onMapInitialized: void 0,
  onMapMoveZoom: void 0,
  onMapMoveStart: void 0,
  onMapMoveEnd: void 0,
  onMapZoomStart: void 0,
  onMapZoomEnd: void 0,
  onMapClick: void 0,
  // Point
  pointLongitude: (d) => d.longitude,
  pointLatitude: (d) => d.latitude,
  pointId: (d) => d.id,
  pointShape: (d) => d.shape,
  pointColor: (d) => d.color,
  pointRadius: void 0,
  pointLabel: void 0,
  pointLabelColor: void 0,
  pointBottomLabel: "",
  pointCursor: null,
  pointRingWidth: 1.25,
  selectedPointId: void 0,
  // Cluster
  clusterColor: void 0,
  clusterRadius: void 0,
  clusterLabel: (d) => `${d.point_count}`,
  clusterLabelColor: void 0,
  clusterBottomLabel: "",
  clusterRingWidth: 1.25,
  clusterBackground: true,
  clusterExpandOnClick: true,
  clusteringDistance: 55,
  colorMap: {},
  // TopoJSON Overlay
  topoJSONLayer: {
    sources: void 0,
    fillOpacity: 0.6,
    strokeOpacity: 0.8,
    strokeWidth: 1,
    featureName: void 0,
    fillProperty: void 0,
    strokeProperty: void 0
  },
  // Misc
  tooltip: void 0,
  ariaLabel: void 0
});

// node_modules/@unovis/ts/components/leaflet-map/style.js
var style_exports14 = {};
__export(style_exports14, {
  background: () => background4,
  backgroundRect: () => backgroundRect,
  bottomLabel: () => bottomLabel,
  clusterBackground: () => clusterBackground,
  donutCluster: () => donutCluster,
  innerLabel: () => innerLabel,
  innerLabelCluster: () => innerLabelCluster,
  map: () => map4,
  mapboxglCanvas: () => mapboxglCanvas,
  onFeatureHover: () => onFeatureHover,
  point: () => point12,
  pointPath: () => pointPath,
  pointPathCluster: () => pointPathCluster,
  pointPathRing: () => pointPathRing,
  pointSelection: () => pointSelection,
  pointSelectionRing: () => pointSelectionRing,
  points: () => points2,
  root: () => root16,
  svgOverlay: () => svgOverlay,
  variables: () => variables7
});

// node_modules/@unovis/ts/components/leaflet-map/leaflet.css.js
var css_248z = '.leaflet-image-layer,.leaflet-layer,.leaflet-marker-icon,.leaflet-marker-shadow,.leaflet-pane,.leaflet-pane>canvas,.leaflet-pane>svg,.leaflet-tile,.leaflet-tile-container,.leaflet-zoom-box{left:0;position:absolute;top:0}.leaflet-container{overflow:hidden}.leaflet-marker-icon,.leaflet-marker-shadow,.leaflet-tile{-webkit-user-drag:none;-webkit-user-select:none;-moz-user-select:none;user-select:none}.leaflet-safari .leaflet-tile{image-rendering:-webkit-optimize-contrast}.leaflet-safari .leaflet-tile-container{height:1600px;-webkit-transform-origin:0 0;width:1600px}.leaflet-marker-icon,.leaflet-marker-shadow{display:block}.leaflet-container .leaflet-marker-pane img,.leaflet-container .leaflet-overlay-pane svg,.leaflet-container .leaflet-shadow-pane img,.leaflet-container .leaflet-tile,.leaflet-container .leaflet-tile-pane img,.leaflet-container img.leaflet-image-layer{max-height:none!important;max-width:none!important}.leaflet-container.leaflet-touch-zoom{-ms-touch-action:pan-x pan-y;touch-action:pan-x pan-y}.leaflet-container.leaflet-touch-drag{-ms-touch-action:pinch-zoom;touch-action:none;touch-action:pinch-zoom}.leaflet-container.leaflet-touch-drag.leaflet-touch-zoom{-ms-touch-action:none;touch-action:none}.leaflet-container{-webkit-tap-highlight-color:transparent}.leaflet-container a{-webkit-tap-highlight-color:rgba(51,181,229,.4)}.leaflet-tile{filter:inherit;visibility:hidden}.leaflet-tile-loaded{visibility:inherit}.leaflet-zoom-box{-moz-box-sizing:border-box;box-sizing:border-box;height:0;width:0;z-index:800}.leaflet-overlay-pane svg{-moz-user-select:none}.leaflet-overlay-pane{z-index:1}.leaflet-vml-shape{height:1px;width:1px}.lvml{behavior:url(#default#VML);display:inline-block;position:absolute}.leaflet-control{pointer-events:visiblePainted;pointer-events:auto;position:relative;z-index:800}.leaflet-bottom,.leaflet-top{pointer-events:none;position:absolute;z-index:1}.leaflet-top{top:0}.leaflet-right{right:0}.leaflet-bottom{bottom:0}.leaflet-left{left:0}.leaflet-control{clear:both;float:left}.leaflet-right .leaflet-control{float:right}.leaflet-top .leaflet-control{margin-top:10px}.leaflet-bottom .leaflet-control{margin-bottom:10px}.leaflet-left .leaflet-control{margin-left:10px}.leaflet-right .leaflet-control{margin-right:10px}.leaflet-fade-anim .leaflet-tile{will-change:opacity}.leaflet-fade-anim .leaflet-popup{opacity:0;-webkit-transition:opacity .2s linear;-moz-transition:opacity .2s linear;transition:opacity .2s linear}.leaflet-fade-anim .leaflet-map-pane .leaflet-popup{opacity:1}.leaflet-zoom-animated{-webkit-transform-origin:0 0;-ms-transform-origin:0 0;transform-origin:0 0}.leaflet-zoom-anim .leaflet-zoom-animated{-webkit-transition:-webkit-transform .25s cubic-bezier(0,0,.25,1);-moz-transition:-moz-transform .25s cubic-bezier(0,0,.25,1);transition:transform .25s cubic-bezier(0,0,.25,1);will-change:transform}.leaflet-pan-anim .leaflet-tile,.leaflet-zoom-anim .leaflet-tile{-webkit-transition:none;-moz-transition:none;transition:none}.leaflet-zoom-anim .leaflet-zoom-hide{visibility:hidden}.leaflet-interactive{cursor:pointer}.leaflet-grab{cursor:-webkit-grab;cursor:-moz-grab;cursor:grab}.leaflet-crosshair,.leaflet-crosshair .leaflet-interactive{cursor:crosshair}.leaflet-control,.leaflet-popup-pane{cursor:auto}.leaflet-dragging .leaflet-grab,.leaflet-dragging .leaflet-grab .leaflet-interactive,.leaflet-dragging .leaflet-marker-draggable{cursor:move;cursor:-webkit-grabbing;cursor:-moz-grabbing;cursor:grabbing}.leaflet-image-layer,.leaflet-marker-icon,.leaflet-marker-shadow,.leaflet-pane>svg path,.leaflet-tile-container{pointer-events:none}.leaflet-image-layer.leaflet-interactive,.leaflet-marker-icon.leaflet-interactive,.leaflet-pane>svg path.leaflet-interactive{pointer-events:visiblePainted;pointer-events:auto}.leaflet-container{background:#dfe5eb;outline:0}.leaflet-container a{color:#0078a8}.leaflet-container a.leaflet-active{outline:2px solid orange}.leaflet-zoom-box{background:rgba(255,255,255,.5);border:2px dotted #38f}.leaflet-container{font:12px/1.5 Helvetica Neue,Arial,Helvetica,sans-serif}.leaflet-bar{border-radius:4px;box-shadow:0 1px 5px rgba(0,0,0,.65)}.leaflet-bar a,.leaflet-bar a:hover{background-color:#fff;border-bottom:1px solid rgba(130,130,130,.2);color:#000;display:block;height:26px;line-height:26px;text-align:center;text-decoration:none;width:26px}.leaflet-bar a,.leaflet-control-layers-toggle{background-position:50% 50%;background-repeat:no-repeat;display:block}.leaflet-bar a:hover{background-color:#f4f4f4}.leaflet-bar a:first-child{border-top-left-radius:4px;border-top-right-radius:4px}.leaflet-bar a:last-child{border-bottom:none;border-bottom-left-radius:4px;border-bottom-right-radius:4px}.leaflet-bar a.leaflet-disabled{background-color:#f4f4f4;color:#bbb;cursor:default}.leaflet-touch .leaflet-bar a{height:30px;line-height:30px;width:30px}.leaflet-touch .leaflet-bar a:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.leaflet-touch .leaflet-bar a:last-child{border-bottom-left-radius:2px;border-bottom-right-radius:2px}.leaflet-control-zoom-in,.leaflet-control-zoom-out{font:700 18px Lucida Console,Monaco,monospace;text-indent:1px}.leaflet-touch .leaflet-control-zoom-in,.leaflet-touch .leaflet-control-zoom-out{font-size:22px}.leaflet-control-layers{background:#fff;border-radius:5px;box-shadow:0 1px 5px rgba(0,0,0,.4)}.leaflet-touch .leaflet-control-layers-toggle{height:44px;width:44px}.leaflet-control-layers-expanded .leaflet-control-layers-toggle,.leaflet-control-layers .leaflet-control-layers-list{display:none}.leaflet-control-layers-expanded .leaflet-control-layers-list{display:block;position:relative}.leaflet-control-layers-expanded{background:#fff;color:#333;padding:6px 10px 6px 6px}.leaflet-control-layers-scrollbar{overflow-x:hidden;overflow-y:scroll;padding-right:5px}.leaflet-control-layers-selector{margin-top:2px;position:relative;top:1px}.leaflet-control-layers label{display:block}.leaflet-control-layers-separator{border-top:1px solid #ddd;height:0;margin:5px -10px 5px -6px}.leaflet-container .leaflet-control-attribution{background:#fff;background:hsla(0,0%,100%,.7);margin:0}.leaflet-control-attribution,.leaflet-control-scale-line{color:#333;padding:0 5px}.leaflet-control-attribution a{color:#333;font-size:7pt;opacity:.6;text-decoration:none}.leaflet-control-attribution a:hover{text-decoration:underline}.leaflet-container .leaflet-control-attribution,.leaflet-container .leaflet-control-scale{font-size:11px}.leaflet-left .leaflet-control-scale{margin-left:5px}.leaflet-bottom .leaflet-control-scale{margin-bottom:5px}.leaflet-control-scale-line{background:#fff;background:hsla(0,0%,100%,.5);border:2px solid #777;border-top:none;-moz-box-sizing:border-box;box-sizing:border-box;font-size:11px;line-height:1.1;overflow:hidden;padding:2px 5px 1px;white-space:nowrap}.leaflet-control-scale-line:not(:first-child){border-bottom:none;border-top:2px solid #777;margin-top:-2px}.leaflet-control-scale-line:not(:first-child):not(:last-child){border-bottom:2px solid #777}.leaflet-touch .leaflet-bar,.leaflet-touch .leaflet-control-attribution,.leaflet-touch .leaflet-control-layers{box-shadow:none}.leaflet-touch .leaflet-bar,.leaflet-touch .leaflet-control-layers{background-clip:padding-box;border:1px solid rgba(0,0,0,.15)}.leaflet-popup{margin-bottom:20px;position:absolute;text-align:center}.leaflet-popup-content-wrapper{border-radius:12px;padding:1px;text-align:left}.leaflet-popup-content{line-height:1.4;margin:13px 19px}.leaflet-popup-content p{margin:18px 0}.leaflet-popup-tip-container{height:20px;left:50%;margin-left:-20px;overflow:hidden;pointer-events:none;position:absolute;width:40px}.leaflet-popup-tip{height:17px;margin:-10px auto 0;padding:1px;-webkit-transform:rotate(45deg);-moz-transform:rotate(45deg);-ms-transform:rotate(45deg);transform:rotate(45deg);width:17px}.leaflet-popup-content-wrapper,.leaflet-popup-tip{background:#fff;box-shadow:0 3px 14px rgba(0,0,0,.4);color:#333}.leaflet-container a.leaflet-popup-close-button{background:transparent;border:none;color:#c3c3c3;font:16px/14px Tahoma,Verdana,sans-serif;font-weight:700;height:14px;padding:4px 4px 0 0;position:absolute;right:0;text-align:center;text-decoration:none;top:0;width:18px}.leaflet-container a.leaflet-popup-close-button:hover{color:#999}.leaflet-popup-scrolled{border-bottom:1px solid #ddd;border-top:1px solid #ddd;overflow:auto}.leaflet-oldie .leaflet-popup-content-wrapper{zoom:1}.leaflet-oldie .leaflet-popup-tip{-ms-filter:"progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=0.70710678, M21=-0.70710678, M22=0.70710678)";filter:progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678,M12=0.70710678,M21=-0.70710678,M22=0.70710678);margin:0 auto;width:24px}.leaflet-oldie .leaflet-popup-tip-container{margin-top:-1px}.leaflet-oldie .leaflet-control-layers,.leaflet-oldie .leaflet-control-zoom,.leaflet-oldie .leaflet-popup-content-wrapper,.leaflet-oldie .leaflet-popup-tip{border:1px solid #999}.leaflet-div-icon{background:#fff;border:1px solid #666}.leaflet-tooltip{background-color:#fff;border:1px solid #fff;border-radius:3px;box-shadow:0 1px 3px rgba(0,0,0,.4);color:#222;padding:6px;pointer-events:none;position:absolute;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;white-space:nowrap}.leaflet-tooltip.leaflet-clickable{cursor:pointer;pointer-events:auto}.leaflet-tooltip-bottom:before,.leaflet-tooltip-left:before,.leaflet-tooltip-right:before,.leaflet-tooltip-top:before{background:transparent;border:6px solid transparent;content:"";pointer-events:none;position:absolute}.leaflet-tooltip-bottom{margin-top:6px}.leaflet-tooltip-top{margin-top:-6px}.leaflet-tooltip-bottom:before,.leaflet-tooltip-top:before{left:50%;margin-left:-6px}.leaflet-tooltip-top:before{border-top-color:#fff;bottom:0;margin-bottom:-12px}.leaflet-tooltip-bottom:before{border-bottom-color:#fff;margin-left:-6px;margin-top:-12px;top:0}.leaflet-tooltip-left{margin-left:-6px}.leaflet-tooltip-right{margin-left:6px}.leaflet-tooltip-left:before,.leaflet-tooltip-right:before{margin-top:-6px;top:50%}.leaflet-tooltip-left:before{border-left-color:#fff;margin-right:-12px;right:0}.leaflet-tooltip-right:before{border-right-color:#fff;left:0;margin-left:-12px}';

// node_modules/@unovis/ts/components/leaflet-map/style.js
injectGlobal(css_248z);
var cssVarDefaults2 = {
  "--vis-map-container-background-color": "#dfe5eb",
  /* Undefined by default to allow proper fallback to var(--vis-font-family) */
  "--vis-map-label-font-family": void 0,
  "--vis-map-point-default-fill-color": "#B9BEC3",
  "--vis-map-point-ring-fill-color": "#ffffff",
  "--vis-map-point-default-stroke-color": "#959da3",
  "--vis-map-point-default-stroke-width": "0px",
  "--vis-map-point-default-cursor": "default",
  "--vis-map-cluster-default-fill-color": "#fff",
  "--vis-map-cluster-default-stroke-color": "#B9BEC3",
  "--vis-map-cluster-default-stroke-width": "1.5px",
  "--vis-map-cluster-donut-fill-color": "#959da3",
  "--vis-map-cluster-inner-label-text-color-dark": "#5b5f6d",
  "--vis-map-cluster-inner-label-text-color-light": "#fff",
  "--vis-map-point-inner-label-text-color-dark": "#5b5f6d",
  "--vis-map-point-inner-label-text-color-light": "#fff",
  "--vis-map-point-bottom-label-text-color": "#5b5f6d",
  "--vis-map-point-bottom-label-font-size": "10px",
  "--vis-map-cluster-expanded-background-fill-color": "#fff",
  /* Dark Theme */
  "--vis-dark-map-container-background-color": "#dfe5eb",
  "--vis-dark-map-point-default-fill-color": "#B9BEC3",
  "--vis-dark-map-point-default-stroke-color": "#959da3",
  "--vis-dark-map-point-ring-fill-color": "#5b5f6d",
  "--vis-dark-map-cluster-default-fill-color": "#5b5f6d",
  "--vis-dark-map-cluster-default-stroke-color": "#B9BEC3",
  "--vis-dark-map-cluster-donut-fill-color": "#959da3",
  "--vis-dark-map-cluster-inner-label-text-color-dark": "#5b5f6d",
  "--vis-dark-map-cluster-inner-label-text-color-light": "#fff",
  "--vis-dark-map-point-inner-label-text-color-dark": "#5b5f6d",
  "--vis-dark-map-point-inner-label-text-color-light": "#fff",
  "--vis-dark-map-point-bottom-label-text-color": "#5b5f6d",
  "--vis-dark-map-cluster-expanded-background-fill-color": "#fff"
};
var root16 = css`
  label: leaflet-map-component;

  width: 100%;
  height: 100%;
  position: absolute;
  background-color: var(--vis-map-container-background-color);

  canvas {
    pointer-events: all;
  }
`;
var variables7 = getCssVarNames(cssVarDefaults2);
injectGlobalCssVariables(cssVarDefaults2, root16);
var background4 = `${root16} canvas`;
var points2 = css`
  label: g-points;
`;
var point12 = css`
  label: g-point;
`;
var pointPath = css`
  label: point-path;

  stroke-opacity: 1;
  fill-opacity: 1.0;
  fill: var(${variables7.mapPointDefaultFillColor});
  stroke: var(${variables7.mapPointDefaultStrokeColor});
  stroke-width: var(${variables7.mapPointDefaultStrokeWidth});
  pointer-events: fill !important;
  transition: .2s stroke-width, .3s transform;
  cursor: var(${variables7.mapPointDefaultCursor});

  &:hover {
    stroke-width: 2;
    fill-opacity: 1;
    animation: none;
    transform: scale(1.1);
  }
`;
var pointPathRing = css`
  label: point-path-ring;
  fill: var(${variables7.mapPointRingFillColor});
`;
var pointPathCluster = css`
  label: point-path-cluster;
  fill-opacity: 0.9;
  stroke: none;
  animation: none;
  fill: var(${variables7.mapClusterDefaultFillColor});
  stroke: var(${variables7.mapClusterDefaultStrokeColor});
  stroke-width: var(${variables7.mapClusterDefaultStrokeWidth});
`;
var pointSelectionRing = css`
  label: point-selection-ring;
  stroke: var(${variables7.mapPointDefaultFillColor});
`;
var pointSelection = css`
  label: point-selection;

  opacity: 0;
  transform: scale(1);

  &.active {
    transition: all 400ms cubic-bezier(0.230, 1.000, 0.320, 1.000);
    opacity: 1;
    transform: scale(1.25);
  }
`;
var innerLabel = css`
  label: inner-label;

  text-anchor: middle;
  fill: var(${variables7.mapPointInnerLabelTextColorDark});
  font-family: var(${variables7.mapLabelFontFamily}, var(--vis-font-family));
  pointer-events: none;
  font-weight: 600;
`;
var innerLabelCluster = css`
  label: inner-label-cluster;
  fill: var(${variables7.mapPointInnerLabelTextColorDark});
`;
var bottomLabel = css`
  label: bottom-label;

  text-anchor: middle;
  fill: var(${variables7.mapPointBottomLabelTextColor});
  font-family: var(${variables7.mapLabelFontFamily}, var(--vis-font-family));
  pointer-events: none;
  font-weight: 600;
`;
var donutCluster = css`
  label: donut-cluster;

  transform: scale(1);
  transition: .3s transform;
  path {
    fill: var(${variables7.mapClusterDonutFillColor});
    stroke-width: 0.5;
  }

  &:hover {
    transform: scale(1.1);
  }
`;
var svgOverlay = css`
  label: svg-overlay;
  position: absolute;
  pointer-events: none;
`;
var backgroundRect = css`
  label: background-rect;

  opacity: 0;
`;
var clusterBackground = css`
  label: cluster-background;

  fill: var(${variables7.mapClusterExpandedBackgroundFillColor});
  opacity: 0.6;
  visibility: hidden;

  &.active {
    visibility: visible;
  }
`;
var onFeatureHover = css`
  label: feature-hovered;
`;
var mapboxglCanvas = css`
  pointer-events: all;
  cursor: grab;

  &${`.${onFeatureHover}`} {
    cursor: default;
  }
`;
var map4 = css`
  label: map;
`;

// node_modules/@unovis/ts/components/leaflet-map/modules/map.js
var initialMapCenter = [36, 14];
var initialMapZoom = 1.9;
function updateTopoJson(maplibreMap, config) {
  var _a, _b;
  const { topoJSONLayer } = config;
  if (topoJSONLayer.sources) {
    const featureObject = (_b = (_a = topoJSONLayer.sources) === null || _a === void 0 ? void 0 : _a.objects) === null || _b === void 0 ? void 0 : _b[topoJSONLayer.featureName];
    if (featureObject) {
      const mapSource = maplibreMap.getSource(topoJSONLayer.featureName);
      const featureCollection = feature_default(topoJSONLayer.sources, featureObject);
      if (mapSource) {
        mapSource.setData(featureCollection);
      } else {
        maplibreMap.addSource(topoJSONLayer.featureName, { type: "geojson", data: featureCollection });
      }
    }
  }
  const fillLayer = maplibreMap.getLayer(`${topoJSONLayer.featureName}-area`);
  if (topoJSONLayer.fillProperty) {
    if (!fillLayer) {
      maplibreMap.addLayer({
        id: `${topoJSONLayer.featureName}-area`,
        type: "fill",
        source: topoJSONLayer.featureName,
        paint: {
          // eslint-disable-next-line @typescript-eslint/naming-convention
          "fill-antialias": false,
          // eslint-disable-next-line @typescript-eslint/naming-convention
          "fill-opacity": topoJSONLayer.fillOpacity
        }
      });
    }
    maplibreMap.setPaintProperty(`${topoJSONLayer.featureName}-area`, "fill-color", [
      "case",
      ["!", ["has", topoJSONLayer.fillProperty]],
      "rgba(255, 255, 255, 0)",
      ["get", topoJSONLayer.fillProperty]
    ]);
  } else if (fillLayer)
    maplibreMap.removeLayer(`${topoJSONLayer.featureName}-area`);
  const strokeLayer = maplibreMap.getLayer(`${topoJSONLayer.featureName}-stroke`);
  if (topoJSONLayer.strokeProperty) {
    if (!strokeLayer) {
      maplibreMap.addLayer({
        id: `${topoJSONLayer.featureName}-stroke`,
        type: "line",
        source: topoJSONLayer.featureName,
        paint: {
          // eslint-disable-next-line @typescript-eslint/naming-convention
          "line-opacity": topoJSONLayer.strokeOpacity,
          // eslint-disable-next-line @typescript-eslint/naming-convention
          "line-width": topoJSONLayer.strokeWidth
        }
      });
    }
    maplibreMap.setPaintProperty(`${topoJSONLayer.featureName}-stroke`, "line-color", [
      "case",
      ["!", ["has", topoJSONLayer.strokeProperty]],
      "rgba(255, 255, 255, 0)",
      ["get", topoJSONLayer.strokeProperty]
    ]);
  } else if (strokeLayer) {
    maplibreMap.removeLayer(`${topoJSONLayer.featureName}-stroke`);
  }
}
function setupMap(mapContainer, config) {
  var _a, _b;
  return __awaiter(this, void 0, void 0, function* () {
    const { style, renderer, topoJSONLayer } = config;
    const leaflet = yield import("./leaflet-src-V42BQYZT.js");
    const L = leaflet.default;
    if (!style) {
      console.error("Unovis | Leaflet Map: Please provide style settings in the map configuration object");
      return;
    }
    const leafletMap = L.map(mapContainer, {
      scrollWheelZoom: renderer === LeafletMapRenderer.Raster,
      zoomControl: false,
      zoomDelta: renderer === LeafletMapRenderer.Raster ? 1 : 0.5,
      zoomSnap: renderer === LeafletMapRenderer.Raster ? 1 : 0,
      attributionControl: true,
      center: initialMapCenter,
      zoom: initialMapZoom,
      minZoom: Math.sqrt(mapContainer.offsetWidth) / 17,
      maxZoom: 23,
      maxBounds: L.latLngBounds([-75, -290], [85, 290]),
      maxBoundsViscosity: 1
    });
    for (const attr of config.attribution) {
      leafletMap.attributionControl.addAttribution(attr);
    }
    let layer;
    let maplibreMap = null;
    switch (renderer) {
      case LeafletMapRenderer.MapLibre:
        const maplibre = yield import("./maplibre-gl-SEF6VRNR.js");
        const { getMaplibreGLLayer } = yield import("./mapboxgl-layer-TNHDVCXR.js");
        layer = getMaplibreGLLayer(config, L, maplibre.default);
        maplibreMap = (_b = (_a = layer).getMaplibreMap) === null || _b === void 0 ? void 0 : _b.call(_a);
        select_default2(mapContainer).on("wheel", (event) => {
          event.preventDefault();
          mapboxglWheelEventThrottled(leafletMap, layer, event);
        });
        break;
      case LeafletMapRenderer.Raster:
        layer = L.tileLayer(style);
        break;
    }
    layer.addTo(leafletMap);
    constraintMapView(leafletMap);
    if (maplibreMap && (topoJSONLayer === null || topoJSONLayer === void 0 ? void 0 : topoJSONLayer.sources)) {
      const canvas = maplibreMap.getCanvas();
      const canvasSelection = select_default2(canvas).classed(mapboxglCanvas, true);
      const tilePaneSelection = select_default2(leafletMap.getPanes().tilePane);
      maplibreMap.on("mousemove", (event) => {
        const layerName = `${topoJSONLayer.featureName}-area`;
        const layer2 = maplibreMap.getLayer(layerName);
        if (!layer2)
          return;
        const features2 = maplibreMap.queryRenderedFeatures(event.point, { layers: [layerName] });
        tilePaneSelection.datum(features2[0]);
        canvasSelection.classed(onFeatureHover, Boolean(features2[0]));
      });
      maplibreMap.on("load", () => {
        updateTopoJson(maplibreMap, config);
      });
    }
    const svgOverlay2 = select_default2(leafletMap.getPanes().overlayPane).append("svg");
    const svgGroup = svgOverlay2.append("g");
    return {
      leaflet: leafletMap,
      layer,
      svgOverlay: svgOverlay2,
      svgGroup
    };
  });
}

// node_modules/@unovis/ts/components/leaflet-map/modules/donut.js
var pieConstructor = pie_default().sort(null).value((d) => d.value);
function updateDonut(selection2, data, radius, arcWidth = 2, padAngle = 0.05) {
  pieConstructor.padAngle(padAngle);
  const arcs = pieConstructor(data.filter((d) => d.value));
  const arcPathGen = arc_default().innerRadius(arcWidth ? radius - arcWidth / 2 : 0).outerRadius(arcWidth ? radius + arcWidth / 2 : radius);
  const donuts = selection2.selectAll("path").data(arcs);
  donuts.exit().remove();
  donuts.enter().append("path").merge(donuts).attr("class", (d) => {
    var _a;
    return (_a = d.data.className) !== null && _a !== void 0 ? _a : null;
  }).attr("d", arcPathGen).style("fill", (d) => {
    var _a;
    return (_a = d.data.color) !== null && _a !== void 0 ? _a : null;
  }).style("stroke", (d) => {
    var _a;
    return (_a = d.data.color) !== null && _a !== void 0 ? _a : null;
  });
}

// node_modules/@unovis/ts/components/leaflet-map/modules/node.js
var BOTTOM_LABEL_TOP_MARGIN = 10;
function createNodes2(selection2) {
  selection2.append("path").attr("class", pointPath).attr("id", (d) => `point-${d.id}`).style("opacity", 0);
  selection2.append("g").attr("class", donutCluster);
  selection2.append("text").attr("class", innerLabel).classed(innerLabelCluster, (d) => d.properties.cluster).attr("id", (d) => `label-${d.id}`).attr("dy", "0.32em");
  selection2.append("text").attr("class", bottomLabel).attr("dy", "0.32em").attr("opacity", 1);
}
function updateNodes2(selection2, config, leafletMap, mapMoveZoomUpdateOnly) {
  selection2.each((d, i, elements) => {
    var _a, _b, _c;
    const group3 = select_default2(elements[i]);
    const node4 = group3.select(`.${pointPath}`);
    const innerLabel$1 = group3.select(`.${innerLabel}`);
    const bottomLabel$1 = group3.select(`.${bottomLabel}`);
    const { x: x3, y: y3 } = getPointPos(d, leafletMap);
    const donutData = d.donutData;
    const isCluster = d.properties.cluster;
    const fromExpandedCluster = !!d.properties.expandedClusterPoint;
    const innerLabelText = (_a = isCluster ? getString(d.properties, config.clusterLabel) : getString(d.properties, config.pointLabel)) !== null && _a !== void 0 ? _a : "";
    const innerLabelColor = (_b = isCluster ? getString(d.properties, config.clusterLabelColor) : getString(d.properties, config.pointLabelColor)) !== null && _b !== void 0 ? _b : null;
    const bottomLabelText = (_c = isCluster ? getString(d.properties, config.clusterBottomLabel) : getString(d.properties, config.pointBottomLabel)) !== null && _c !== void 0 ? _c : "";
    const pointCursor = getString(d.properties, config.pointCursor);
    const pointShape = getString(d.properties, config.pointShape);
    const isRing = pointShape === LeafletMapPointShape.Ring;
    const isCircular = pointShape === LeafletMapPointShape.Circle || isRing || isCluster || !pointShape;
    const ringWidth = isCluster && config.clusterRingWidth || isRing && config.pointRingWidth || 0;
    group3.attr("transform", `translate(${x3},${y3})`);
    group3.select(`.${donutCluster}`).call(updateDonut, donutData, isCircular ? d.radius : 0, ringWidth);
    node4.attr("d", d.path);
    node4.style("cursor", isCluster ? "pointer" : pointCursor);
    bottomLabel$1.attr("transform", `translate(0,${d.radius + BOTTOM_LABEL_TOP_MARGIN})`);
    innerLabel$1.attr("font-size", () => {
      const fontSize = d.radius / Math.pow(innerLabelText.length, 0.4);
      return clamp(fontSize, fontSize, 16);
    });
    if (mapMoveZoomUpdateOnly)
      return;
    node4.classed(pointPathCluster, isCluster).classed(pointPathRing, isRing).style("fill", d.color).style("stroke", d.color).style("stroke-width", ringWidth).style("opacity", 1);
    innerLabel$1.text(innerLabelText || null).attr("visibility", innerLabelText ? null : "hidden").style("fill", () => {
      var _a2;
      if (innerLabelColor)
        return innerLabelColor;
      const c3 = getComputedStyle(node4.node()).fill;
      const hex2 = (_a2 = color(c3)) === null || _a2 === void 0 ? void 0 : _a2.hex();
      if (!hex2)
        return null;
      const brightness = hexToBrightness(hex2);
      return brightness > 0.5 ? isCluster ? cssvar(variables7.mapClusterInnerLabelTextColorDark) : cssvar(variables7.mapPointInnerLabelTextColorDark) : isCluster ? cssvar(variables7.mapClusterInnerLabelTextColorLight) : cssvar(variables7.mapPointInnerLabelTextColorLight);
    });
    const bottomLabelTextTrimmed = trimStringMiddle(bottomLabelText, 15);
    bottomLabel$1.text(bottomLabelTextTrimmed).attr("font-size", getCSSVariableValueInPixels(cssvar(variables7.mapPointBottomLabelFontSize), selection2.node())).attr("visibility", fromExpandedCluster ? "hidden" : null);
  });
}
function collideLabels2(selection2, leafletMap) {
  selection2.each((datum1, i, elements) => {
    const group1LabelElement = elements[i];
    const group1 = select_default2(group1LabelElement);
    const label1 = group1.select(`.${bottomLabel}`);
    group1LabelElement.labelVisible = true;
    const bottomLabelFontSizePx = getCSSVariableValueInPixels(cssvar(variables7.mapPointBottomLabelFontSize), selection2.node());
    const p1Pos = getPointPos(datum1, leafletMap);
    const label1Size = estimateTextSize(label1, bottomLabelFontSizePx, 0.32, true, 0.6);
    const label1BoundingRect = {
      x: p1Pos.x - label1Size.width / 2,
      y: p1Pos.y - label1Size.height / 2 + datum1.radius + BOTTOM_LABEL_TOP_MARGIN,
      width: label1Size.width,
      height: label1Size.height
    };
    for (let j = 0; j < elements.length; j += 1) {
      if (i === j)
        continue;
      const group2LabelElement = elements[j];
      const group22 = select_default2(group2LabelElement);
      const label22 = group22.select(`.${bottomLabel}`);
      const datum2 = group22.datum();
      const p2Pos = getPointPos(datum2, leafletMap);
      const point2BoundingRect = {
        x: p2Pos.x - datum2.radius,
        y: p2Pos.y - datum2.radius,
        width: 2 * datum2.radius,
        height: 2 * datum2.radius
      };
      let intersect2 = rectIntersect(label1BoundingRect, point2BoundingRect);
      const label2Visible = group2LabelElement.labelVisible;
      if (!intersect2 && label2Visible) {
        const label2Size = estimateTextSize(label22, bottomLabelFontSizePx, 0.32, true, 0.6);
        intersect2 = rectIntersect(label1BoundingRect, {
          x: p2Pos.x - label2Size.width / 2,
          y: p2Pos.y + datum2.radius + BOTTOM_LABEL_TOP_MARGIN - label2Size.height / 2,
          width: label2Size.width,
          height: label2Size.height
        });
      }
      if (intersect2) {
        group1LabelElement.labelVisible = false;
        break;
      }
    }
    smartTransition(label1, 0).attr("opacity", group1LabelElement.labelVisible ? 1 : 0);
  });
}
function removeNodes2(selection2) {
  selection2.remove();
}

// node_modules/@unovis/ts/components/leaflet-map/modules/selectionRing.js
function createNodeSelectionRing(selection2) {
  selection2.datum({ _zIndex: 3 });
  selection2.append("path").attr("class", pointSelection);
}
function updateNodeSelectionRing(selection2, selectedPoint, pointData, config, leafletMap) {
  selection2.attr("class", pointSelectionRing);
  const pointSelection$1 = selection2.select(`.${pointSelection}`);
  if (selectedPoint) {
    const isCluster = selectedPoint.isCluster;
    const selectedPointId = getString(selectedPoint.properties, config.pointId);
    const foundPoint = pointData.find((d) => isCluster ? d.id === selectedPoint.id : selectedPointId && getString(d.properties, config.pointId) === selectedPointId);
    selection2.attr("transform", (d) => {
      const { x: x3, y: y3 } = getPointPos(foundPoint !== null && foundPoint !== void 0 ? foundPoint : selectedPoint, leafletMap);
      return `translate(${x3},${y3})`;
    }).classed(`${selectedPoint.properties.shape}`, true);
    pointSelection$1.classed("active", Boolean(foundPoint)).attr("d", foundPoint ? foundPoint.path : null).style("fill", "transparent").style("stroke-width", 1).style("stroke", (d) => {
      const node4 = foundPoint || selectedPoint;
      return node4 === null || node4 === void 0 ? void 0 : node4.color;
    });
  } else {
    pointSelection$1.classed("active", false);
  }
}

// node_modules/@unovis/ts/components/leaflet-map/modules/clusterBackground.js
function createBackgroundNode(selection2) {
  selection2.datum({ _zIndex: 1 });
  selection2.append("path");
}
function updateBackgroundNode(selection2, expandedCluster, config, leafletMap, clusterBackgroundRadius) {
  const { clusterBackground: clusterBackground2 } = config;
  if (expandedCluster && clusterBackground2) {
    const node4 = cloneDeep(expandedCluster.cluster);
    const { x: x3, y: y3 } = getPointPos(node4, leafletMap);
    const path3 = getNodePathData({ x: 0, y: 0 }, clusterBackgroundRadius, LeafletMapPointShape.Circle);
    selection2.select("path").attr("d", (d) => path3);
    selection2.classed("active", true).attr("transform", `translate(${x3},${y3})`);
  } else {
    selection2.classed("active", false);
  }
}

// node_modules/@unovis/ts/components/leaflet-map/index.js
var LeafletMap = class _LeafletMap extends ComponentCore {
  constructor(container, config, data) {
    super(ComponentType.HTML);
    this._defaultConfig = LeafletMapDefaultConfig;
    this.config = this._defaultConfig;
    this.type = ComponentType.HTML;
    this.datamodel = new MapDataModel();
    this._expandedCluster = null;
    this._cancelBackgroundClick = false;
    this._hasBeenMoved = false;
    this._hasBeenZoomed = false;
    this._isMoving = false;
    this._isZooming = false;
    this._eventInitiatedByComponent = false;
    this._triggerBackgroundClick = false;
    this._externallySelectedPoint = null;
    this._zoomingToExternallySelectedPoint = false;
    this._forceExpandCluster = false;
    this._clusterBackgroundRadius = 0;
    this._selectedPoint = null;
    this._currentZoomLevel = null;
    this._firstRender = true;
    this._isDarkThemeActive = false;
    this._renderDataAnimationFrameId = null;
    this._flyToBoundsAnimationFrameId = null;
    this.events = {
      [_LeafletMap.selectors.point]: {
        mouseup: this._onPointMouseUp.bind(this),
        mousedown: this._onPointMouseDown.bind(this),
        click: this._onPointClick.bind(this)
      }
    };
    this._container = container;
    this._containerSelection = select_default2(this._container).attr("role", "figure");
    this._container.appendChild(this.element);
    this.g.attr("class", root16).attr("aria-hidden", true);
    if (config)
      this.setConfig(config);
    if (!this._container.clientWidth) {
      console.warn("Unovis | Leaflet Map: The width of the container is not set. Setting to 100%.");
      this._containerSelection.style("width", "100%");
    }
    if (!this._container.clientHeight) {
      console.warn(`Unovis | Leaflet Map: The height of the container is not set. Setting to ${_LeafletMap.DEFAULT_CONTAINER_HEIGHT}px.`);
      this._containerSelection.style("height", `${_LeafletMap.DEFAULT_CONTAINER_HEIGHT}px`);
    }
    this._leafletInitializationPromise = new Promise((resolve) => {
      setupMap(this.element, this.config).then((map$1) => {
        var _a, _b;
        select_default2(map$1.leaflet.getPanes().tilePane).classed(map4, true);
        if (config)
          this.setConfig(config);
        this._map = map$1;
        this._map.leaflet.on("drag", this._onMapDragLeaflet.bind(this));
        this._map.leaflet.on("move", this._onMapMove.bind(this));
        this._map.leaflet.on("movestart", this._onMapMoveStart.bind(this));
        this._map.leaflet.on("moveend", this._onMapMoveEnd.bind(this));
        this._map.leaflet.on("zoom", this._onMapZoom.bind(this));
        this._map.leaflet.on("zoomstart", this._onMapZoomStart.bind(this));
        this._map.leaflet.on("zoomend", this._onMapZoomEnd.bind(this));
        this._map.leaflet.on("mousedown", () => {
          if (!this._cancelBackgroundClick)
            this._triggerBackgroundClick = true;
        });
        this._map.leaflet.on("mouseup", (e) => {
          if (this._triggerBackgroundClick) {
            this._triggerBackgroundClick = false;
            const originalEvent = e.originalEvent;
            this._onBackgroundClick(originalEvent.target, originalEvent);
          }
        });
        this._map.svgOverlay.attr("class", svgOverlay).insert("rect", ":first-child").attr("class", backgroundRect).attr("width", "100%").attr("height", "100%");
        this._pointGroup = this._map.svgGroup.append("g").attr("class", points2);
        this._clusterBackground = this._pointGroup.append("g").attr("class", clusterBackground).call(createBackgroundNode);
        this._pointSelectionRing = this._pointGroup.append("g").attr("class", pointSelectionRing).call(createNodeSelectionRing);
        this._map.leaflet.setView(initialMapCenter, initialMapZoom);
        if (document.body.classList.contains("theme-dark") && config.styleDarkTheme) {
          this._isDarkThemeActive = true;
          this.setTheme(config.styleDarkTheme);
        }
        (_b = (_a = this.config).onMapInitialized) === null || _b === void 0 ? void 0 : _b.call(_a);
        resolve(this._map.leaflet);
      });
    });
    this.setData(data !== null && data !== void 0 ? data : []);
    this.resizeObserver = new ResizeObserver2(() => {
      var _a, _b, _c;
      (_b = (_a = this._map) === null || _a === void 0 ? void 0 : _a.leaflet) === null || _b === void 0 ? void 0 : _b.invalidateSize();
      (_c = this.config.tooltip) === null || _c === void 0 ? void 0 : _c.hide();
    });
    this.resizeObserver.observe(container);
    if (this.config.styleDarkTheme) {
      this.themeObserver = new MutationObserver((mutations) => {
        mutations.forEach((change) => {
          if (change.attributeName === "class") {
            const isDarkTheme = change.target.classList.contains("theme-dark");
            if (this._isDarkThemeActive !== isDarkTheme) {
              this.setTheme(isDarkTheme ? this.config.styleDarkTheme : this.config.style);
              this._isDarkThemeActive = isDarkTheme;
            }
          }
        });
      });
      this.themeObserver.observe(document.body, { attributes: true });
    }
  }
  setConfig(config) {
    super.setConfig(config);
    if (config.width)
      this._containerSelection.style("width", isString(config.width) ? config.width : `${config.width}px`);
    if (config.height)
      this._containerSelection.style("height", isString(config.height) ? config.height : `${config.height}px`);
    if (this._map && config.renderer === LeafletMapRenderer.MapLibre) {
      const layer = this._map.layer;
      const maplibreMap = layer.getMaplibreMap();
      if (maplibreMap.isStyleLoaded())
        updateTopoJson(maplibreMap, this.config);
    }
    if (this.config.tooltip) {
      this.config.tooltip.setContainer(this._container);
      this.config.tooltip.setComponents([this]);
      this.config.tooltip.update();
    }
    this._containerSelection.attr("aria-label", config.ariaLabel);
  }
  setData(data) {
    const { config, datamodel } = this;
    const dataValid = data.filter((d) => {
      const lat = getNumber(d, config.pointLatitude);
      const lon = getNumber(d, config.pointLongitude);
      const valid = isFinite(lat) && isFinite(lon);
      if (!valid)
        console.warn("Unovis | Leaflet Map: Invalid point coordinates", d);
      return valid;
    });
    datamodel.data = dataValid;
    this._clusterIndex = calculateClusterIndex(dataValid, this.config);
    if (this._expandedCluster && this._map.leaflet) {
      const expandedCluster = this._expandedCluster;
      this._resetExpandedCluster();
      const pointData = this._getPointData();
      const expandedClusterCenterPx = projectPoint(expandedCluster.cluster, this._map.leaflet);
      const expandedClusterRadiusPx = expandedCluster.cluster.radius;
      const cluster2 = pointData.find((c3) => {
        if (!c3.isCluster)
          return false;
        const pos = projectPoint(c3, this._map.leaflet);
        const r = c3.radius;
        const distance = Math.sqrt(Math.pow(expandedClusterCenterPx.x - pos.x, 2) + Math.pow(expandedClusterCenterPx.y - pos.y, 2));
        return distance < expandedClusterRadiusPx + r;
      });
      if (cluster2)
        this._expandCluster(cluster2, true);
    }
    this._leafletInitializationPromise.then(() => {
      this.render();
    });
  }
  setTheme(theme) {
    var _a;
    const layer = this._map.layer;
    if (this.config.renderer === LeafletMapRenderer.MapLibre) {
      const maplibreMap = layer.getMaplibreMap();
      (_a = maplibreMap.setStyle) === null || _a === void 0 ? void 0 : _a.call(maplibreMap, theme);
      updateTopoJson(maplibreMap, this.config);
    } else {
      if (typeof theme !== "string") {
        console.warn("Unovis | Leaflet Map: Invalid style. Provide a URL string for raster rendering mode.");
        return;
      }
      layer.setUrl(theme);
    }
  }
  // We redefine the ComponentCore render function to bind event to newly created elements in this._renderData(),
  // which is being called after almost every map interaction
  render() {
    const { config } = this;
    if (!this._map)
      return;
    this._renderData();
    if (this._firstRender) {
      if (config.initialBounds)
        this.fitToBounds(config.initialBounds);
      else if (config.fitViewOnInit)
        this.fitToPoints(0, config.fitViewPadding);
    } else {
      if (config.fitViewOnUpdate)
        this.fitToPoints(0, config.fitViewPadding);
      else if (config.fitBoundsOnUpdate)
        this.fitToBounds(config.fitBoundsOnUpdate);
    }
    this._firstRender = false;
  }
  getLeafletInstancePromise() {
    return this._leafletInitializationPromise;
  }
  fitToPoints(duration = this.config.flyToDuration, padding = this.config.fitViewPadding) {
    const { config, datamodel, datamodel: { data } } = this;
    if (!this._map || !this._map.leaflet)
      return;
    if (!(data === null || data === void 0 ? void 0 : data.length))
      return;
    const bounds = datamodel.getDataLatLngBounds(config.pointLatitude, config.pointLongitude);
    this._flyToBoundsAnimationFrameId = requestAnimationFrame(() => this._flyToBounds(bounds, duration, padding));
  }
  fitToBounds(bounds, duration = this.config.flyToDuration, padding = this.config.fitViewPadding) {
    const { northEast, southWest } = bounds;
    if (isNil(northEast) || isNil(southWest))
      return;
    if (isNil(northEast.lat) || isNil(northEast.lng))
      return;
    if (isNil(southWest.lat) || isNil(southWest.lng))
      return;
    if (!this._map || !this._map.leaflet)
      return;
    this._flyToBoundsAnimationFrameId = requestAnimationFrame(() => this._flyToBounds([
      [northEast.lat, southWest.lng],
      [southWest.lat, northEast.lng]
    ], duration, padding));
  }
  /* Select a point by id and optionally center the map view.
   * This method was designed to be used mainly with the `[LeafletMap.selectors.point]` click events
   * (when the user actually clicks on a point) and the specified point is inside one of the collapsed
   * clusters it won't be selected. You can use the `zoomToPointById` method to achieve that.
   */
  selectPointById(id2, centerView = false) {
    var _a, _b, _c;
    const { config } = this;
    const pointData = this._getPointData();
    const foundPoint = pointData.find((d) => d.properties.id === id2);
    if (!foundPoint) {
      console.warn(`Unovis | Leaflet Map: Node with id ${id2} can not be found`);
      return;
    }
    if ((_a = foundPoint.properties) === null || _a === void 0 ? void 0 : _a.cluster) {
      console.warn("Unovis | Leaflet Map: Cluster can't be selected");
      return;
    }
    this._selectedPoint = foundPoint;
    const isPointInsideExpandedCluster = (_c = (_b = this._expandedCluster) === null || _b === void 0 ? void 0 : _b.points) === null || _c === void 0 ? void 0 : _c.find((d) => getString(d.properties, config.pointId) === id2);
    if (!isPointInsideExpandedCluster)
      this._resetExpandedCluster();
    if (centerView) {
      const coordinates = {
        lng: getNumber(foundPoint.properties, config.pointLongitude),
        lat: getNumber(foundPoint.properties, config.pointLatitude)
      };
      const zoomLevel = this._map.leaflet.getZoom();
      this._eventInitiatedByComponent = true;
      this._map.leaflet.flyTo(coordinates, zoomLevel, { duration: 0 });
    } else {
      this._renderData();
    }
  }
  /* Get the id of the selected point */
  getSelectedPointId() {
    var _a;
    return (_a = this._selectedPoint) === null || _a === void 0 ? void 0 : _a.id;
  }
  /* Unselect point if it was selected before */
  unselectPoint() {
    this._selectedPoint = null;
    this._externallySelectedPoint = null;
    this.render();
  }
  /** Get the currently expanded cluster */
  getExpandedCluster() {
    var _a, _b;
    if (!this._expandedCluster)
      return;
    const id2 = (_a = this._expandedCluster.cluster) === null || _a === void 0 ? void 0 : _a.id;
    const points3 = (_b = this._expandedCluster.cluster) === null || _b === void 0 ? void 0 : _b.clusterPoints.map((d) => this.datamodel.data[d._index]);
    return { id: id2, points: points3 };
  }
  /* Zoom to a point by id and optionally select it.
   * If the point is inside a cluster, it'll be automatically expanded to show the enclosed point.
   * You can also force set the zoom level by providing the `customZoomLevel` argument.
   */
  zoomToPointById(id2, selectPoint = false, customZoomLevel) {
    var _a, _b, _c;
    const { config, datamodel } = this;
    if (!datamodel.data.length) {
      console.warn("Unovis | Leaflet Map: There are no points on the map");
      return;
    }
    const dataBoundsAll = datamodel.getDataLatLngBounds(config.pointLatitude, config.pointLongitude);
    const bounds = [dataBoundsAll[0][1], dataBoundsAll[1][0], dataBoundsAll[1][1], dataBoundsAll[0][0]];
    const pointDataAll = this._getPointData(bounds);
    let foundPoint = pointDataAll.find((d) => getString(d.properties, config.pointId) === id2);
    if ((_a = foundPoint === null || foundPoint === void 0 ? void 0 : foundPoint.properties) === null || _a === void 0 ? void 0 : _a.cluster) {
      console.warn("Unovis | Leaflet Map: Cluster can't be zoomed in");
      return;
    }
    if (!foundPoint) {
      const { point: point13 } = findPointAndClusterByPointId(pointDataAll, id2, config.pointId);
      foundPoint = point13;
    }
    if (foundPoint) {
      const isPointInsideExpandedCluster = (_c = (_b = this._expandedCluster) === null || _b === void 0 ? void 0 : _b.points) === null || _c === void 0 ? void 0 : _c.find((d) => getString(d.properties, config.pointId) === id2);
      if (isPointInsideExpandedCluster && selectPoint) {
        this._selectedPoint = foundPoint;
        this._renderData();
        return;
      }
      this._externallySelectedPoint = foundPoint;
      this._zoomingToExternallySelectedPoint = true;
      this._forceExpandCluster = !isNil(customZoomLevel);
      if (selectPoint)
        this._selectedPoint = foundPoint;
      const zoomLevel = isNil(customZoomLevel) ? this._map.leaflet.getZoom() : customZoomLevel;
      const pointDatum = foundPoint.properties;
      const coordinates = {
        lng: getNumber(pointDatum, config.pointLongitude),
        lat: getNumber(pointDatum, config.pointLatitude)
      };
      this._eventInitiatedByComponent = true;
      this._map.leaflet.flyTo(coordinates, zoomLevel, { duration: 0 });
    } else {
      console.warn(`Unovis | Leaflet Map: Node with id ${id2} can not be found`);
    }
  }
  getNodeRelativePosition(node4) {
    return getNodeRelativePosition(node4, this._map.leaflet);
  }
  hasBeenZoomed() {
    return this._hasBeenZoomed;
  }
  hasBeenMoved() {
    return this._hasBeenMoved;
  }
  isZooming() {
    return this._isZooming;
  }
  isMoving() {
    return this._isMoving;
  }
  _flyToBounds(bounds, durationMs, paddingPx) {
    this._eventInitiatedByComponent = true;
    const duration = durationMs / 1e3;
    const padding = paddingPx ? [
      paddingPx[0] < this._container.clientWidth / 2 ? paddingPx[0] : this._container.clientWidth / 2,
      paddingPx[1] < this._container.clientHeight / 2 ? paddingPx[1] : this._container.clientHeight / 2
    ] : void 0;
    if (duration) {
      this._map.leaflet.flyToBounds(bounds, { duration, padding });
    } else {
      this._map.leaflet.fitBounds(bounds, { padding });
    }
  }
  _renderData(mapMoveZoomUpdateOnly = false) {
    var _a;
    const { config } = this;
    const pointData = this._getPointData();
    const contentBBox = pointData.length ? bBoxMerge(pointData.map((d) => d.bbox)) : { x: 0, y: 0, width: 0, height: 0 };
    const svgExtraPadding = 40 + this._clusterBackgroundRadius;
    const dx = contentBBox.x - svgExtraPadding;
    const dy = contentBBox.y - svgExtraPadding;
    this._map.svgOverlay.attr("width", contentBBox.width + 2 * svgExtraPadding).attr("height", contentBBox.height + 2 * svgExtraPadding).style("left", `${dx}px`).style("top", `${dy}px`);
    this._map.svgGroup.attr("transform", `translate(${-dx},${-dy})`);
    const points3 = this._pointGroup.selectAll(`.${point12}:not(.exit)`).data(pointData, (d, i) => `${d.id || d.geometry.coordinates.join("")}`);
    points3.exit().classed("exit", true).call(removeNodes2);
    const pointsEnter = points3.enter().append("g").attr("class", point12).call(createNodes2);
    const pointsMerged = points3.merge(pointsEnter);
    pointsEnter.call(updateNodes2, config, this._map.leaflet);
    points3.call(updateNodes2, config, this._map.leaflet, mapMoveZoomUpdateOnly);
    pointsMerged.call(collideLabels2, this._map.leaflet);
    this._clusterBackground.call(updateBackgroundNode, this._expandedCluster, config, this._map.leaflet, this._clusterBackgroundRadius);
    if (this._expandedCluster && config.clusterBackground) {
      pointData.forEach((d, i) => {
        var _a2;
        d._zIndex = ((_a2 = d.properties) === null || _a2 === void 0 ? void 0 : _a2.expandedClusterPoint) ? 2 : 0;
      });
      this._pointGroup.selectAll(`.${point12}, .${clusterBackground}, .${pointSelectionRing}`).sort((a4, b) => a4._zIndex - b._zIndex);
    }
    if (config.selectedPointId) {
      const foundPoint = pointData.find((d) => getString(d.properties, config.pointId) === config.selectedPointId);
      const { cluster: cluster2 } = findPointAndClusterByPointId(pointData, config.selectedPointId, config.pointId);
      if (foundPoint)
        this._selectedPoint = foundPoint;
      else
        this._selectedPoint = cluster2;
    }
    this._pointSelectionRing.call(updateNodeSelectionRing, this._selectedPoint, pointData, config, this._map.leaflet);
    this._setUpComponentEventsThrottled();
    this._setCustomAttributesThrottled();
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.update();
  }
  _zoomToExternallySelectedPoint() {
    const { config } = this;
    if (!this._externallySelectedPoint)
      return;
    const externallySelectedPointDatum = this._externallySelectedPoint.properties;
    const externallySelectedPointId = getString(externallySelectedPointDatum, config.pointId);
    const pointData = this._getPointData();
    const foundPoint = pointData.find((d) => getString(d.properties, config.pointId) === externallySelectedPointId);
    if (foundPoint) {
      this._zoomingToExternallySelectedPoint = false;
      this._currentZoomLevel = null;
    } else {
      const { cluster: cluster2 } = findPointAndClusterByPointId(pointData, externallySelectedPointId, config.pointId);
      if (!cluster2)
        return;
      const zoomLevel = this._map.leaflet.getZoom();
      if (this._forceExpandCluster || shouldClusterExpand(cluster2, zoomLevel, 8, 13)) {
        this._expandCluster(cluster2);
      } else {
        const newZoomLevel = getNextZoomLevelOnClusterClick(zoomLevel);
        const coordinates = {
          lng: getNumber(externallySelectedPointDatum, config.pointLongitude),
          lat: getNumber(externallySelectedPointDatum, config.pointLatitude)
        };
        if (this._currentZoomLevel !== newZoomLevel) {
          this._currentZoomLevel = newZoomLevel;
          this._eventInitiatedByComponent = true;
          this._map.leaflet.flyTo(coordinates, newZoomLevel, { duration: 0 });
        }
      }
    }
  }
  _expandCluster(clusterPoint, preventRender) {
    var _a;
    const { config, config: { clusterBackground: clusterBackground2 } } = this;
    const padding = 1;
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.hide();
    this._forceExpandCluster = false;
    if (clusterPoint) {
      const points3 = clusterPoint.clusterIndex.getLeaves(clusterPoint.properties.cluster_id, Infinity);
      const packPoints = points3.map((p) => ({
        x: null,
        y: null,
        r: getPointRadius(p, config.pointRadius, this._map.leaflet.getZoom()) + padding
      }));
      siblings_default(packPoints);
      points3.forEach((p, i) => {
        p.properties.expandedClusterPoint = clusterPoint;
        p.properties.r = packPoints[i].r;
        p.properties.dx = packPoints[i].x;
        p.properties.dy = packPoints[i].y;
      });
      this._resetExpandedCluster();
      this._expandedCluster = {
        cluster: clusterPoint,
        points: points3
      };
      if (clusterBackground2)
        this._clusterBackgroundRadius = getClusterRadius(this._expandedCluster);
      if (!preventRender)
        this._renderData();
    }
    this._zoomingToExternallySelectedPoint = false;
  }
  _resetExpandedCluster() {
    var _a, _b;
    (_b = (_a = this._expandedCluster) === null || _a === void 0 ? void 0 : _a.points) === null || _b === void 0 ? void 0 : _b.forEach((d) => {
      delete d.properties.expandedClusterPoint;
    });
    this._expandedCluster = null;
  }
  _getPointData(customBounds) {
    const { config, datamodel: { data } } = this;
    if (!data || !this._clusterIndex)
      return [];
    let geoJSONPoints = getClustersAndPoints(this._clusterIndex, this._map.leaflet, customBounds);
    if (this._expandedCluster) {
      geoJSONPoints = geoJSONPoints.filter((c3) => c3.properties.cluster_id !== this._expandedCluster.cluster.properties.cluster_id);
      geoJSONPoints = geoJSONPoints.concat(this._expandedCluster.points);
    }
    const pointData = geoJSONPoints.map((d, i) => {
      return geoJsonPointToScreenPoint(d, i, this._map.leaflet, config);
    });
    return pointData;
  }
  _getMapZoomState() {
    const leafletBounds = this._map.leaflet.getBounds();
    const southWest = leafletBounds.getSouthWest();
    const northEast = leafletBounds.getNorthEast();
    return {
      mapCenter: this._map.leaflet.getCenter(),
      zoomLevel: this._map.leaflet.getZoom(),
      bounds: { southWest, northEast },
      userDriven: !this._eventInitiatedByComponent
    };
  }
  _onMapDragLeaflet() {
    this._cancelBackgroundClick = true;
  }
  _onMapMove() {
    var _a;
    const { config } = this;
    if (!this._map)
      return;
    this._hasBeenMoved = true;
    this._renderDataAnimationFrameId = requestAnimationFrame(() => {
      this._renderData(true);
    });
    (_a = config.onMapMoveZoom) === null || _a === void 0 ? void 0 : _a.call(config, this._getMapZoomState());
  }
  _onMapMoveStart() {
    var _a;
    const { config } = this;
    if (!this._map)
      return;
    this._isMoving = true;
    (_a = config.onMapMoveStart) === null || _a === void 0 ? void 0 : _a.call(config, this._getMapZoomState());
  }
  _onMapMoveEnd() {
    var _a, _b;
    const { config } = this;
    if (!this._map)
      return;
    (_a = this._onMapMoveEndInternal) === null || _a === void 0 ? void 0 : _a.call(this, this._map.leaflet);
    (_b = config.onMapMoveEnd) === null || _b === void 0 ? void 0 : _b.call(config, this._getMapZoomState());
    constraintMapViewThrottled(this._map.leaflet);
    const events2 = this._map.layer.getEvents();
    if (events2.zoomend) {
      const zoomEndEvent = events2.zoomend.bind(this._map.layer);
      zoomEndEvent(null);
    }
    if (this._externallySelectedPoint || this._zoomingToExternallySelectedPoint) {
      this._zoomToExternallySelectedPoint();
    }
    this._isMoving = false;
    this._eventInitiatedByComponent = false;
  }
  _onMapZoomStart() {
    var _a;
    const { config } = this;
    if (!this._map)
      return;
    this._isZooming = true;
    (_a = config.onMapZoomStart) === null || _a === void 0 ? void 0 : _a.call(config, this._getMapZoomState());
  }
  _onMapZoomEnd() {
    var _a;
    const { config } = this;
    if (!this._map)
      return;
    (_a = config.onMapZoomEnd) === null || _a === void 0 ? void 0 : _a.call(config, this._getMapZoomState());
    this._isZooming = false;
    if (!this._isMoving)
      this._eventInitiatedByComponent = false;
  }
  _onMapZoom() {
    var _a, _b;
    const { config } = this;
    if (!this._map)
      return;
    this._hasBeenZoomed = true;
    if (!this._externallySelectedPoint)
      this._resetExpandedCluster();
    else if (!this._zoomingToExternallySelectedPoint) {
      this._externallySelectedPoint = null;
    }
    (_a = config.tooltip) === null || _a === void 0 ? void 0 : _a.hide();
    (_b = config.onMapMoveZoom) === null || _b === void 0 ? void 0 : _b.call(config, this._getMapZoomState());
  }
  _onBackgroundClick(el, event) {
    var _a;
    const { config } = this;
    if (this._cancelBackgroundClick) {
      this._cancelBackgroundClick = false;
      return;
    }
    this._externallySelectedPoint = null;
    this._resetExpandedCluster();
    this._renderData();
    (_a = config.onMapClick) === null || _a === void 0 ? void 0 : _a.call(config, this._getMapZoomState());
  }
  _onPointClick(d, event) {
    const { config: { flyToDuration, clusterExpandOnClick } } = this;
    this._externallySelectedPoint = null;
    event.stopPropagation();
    if (d.properties.cluster) {
      const zoomLevel = this._map.leaflet.getZoom();
      const coordinates = { lng: d.geometry.coordinates[0], lat: d.geometry.coordinates[1] };
      if (clusterExpandOnClick && shouldClusterExpand(d, zoomLevel))
        this._expandCluster(d);
      else {
        const newZoomLevel = getNextZoomLevelOnClusterClick(zoomLevel);
        this._eventInitiatedByComponent = true;
        this._map.leaflet.flyTo(coordinates, newZoomLevel, { duration: flyToDuration / 1e3 });
      }
    }
  }
  _onPointMouseDown(d, event) {
    this._cancelBackgroundClick = true;
  }
  _onPointMouseUp(d, event) {
    this._cancelBackgroundClick = false;
  }
  zoomIn(increment = 1) {
    var _a;
    if (!((_a = this._map) === null || _a === void 0 ? void 0 : _a.leaflet))
      return;
    this.setZoom(this._map.leaflet.getZoom() + increment);
  }
  zoomOut(increment = 1) {
    var _a;
    if (!((_a = this._map) === null || _a === void 0 ? void 0 : _a.leaflet))
      return;
    this.setZoom(this._map.leaflet.getZoom() - increment);
  }
  setZoom(zoomLevel) {
    var _a;
    const leaflet = (_a = this._map) === null || _a === void 0 ? void 0 : _a.leaflet;
    if (!leaflet)
      return;
    this._eventInitiatedByComponent = true;
    leaflet.flyTo(leaflet.getCenter(), clamp(zoomLevel, leaflet.getMinZoom(), leaflet.getMaxZoom()), { duration: this.config.zoomDuration / 1e3 });
  }
  fitView() {
    this.fitToPoints();
  }
  destroy() {
    var _a, _b;
    constraintMapViewThrottled.cancel();
    cancelAnimationFrame(this._renderDataAnimationFrameId);
    cancelAnimationFrame(this._flyToBoundsAnimationFrameId);
    const map5 = (_a = this._map) === null || _a === void 0 ? void 0 : _a.leaflet;
    this._map = void 0;
    map5 === null || map5 === void 0 ? void 0 : map5.stop();
    map5 === null || map5 === void 0 ? void 0 : map5.remove();
    this.g.remove();
    this.resizeObserver.disconnect();
    (_b = this.themeObserver) === null || _b === void 0 ? void 0 : _b.disconnect();
  }
};
LeafletMap.selectors = style_exports14;
LeafletMap.cssVariables = variables7;
LeafletMap.DEFAULT_CONTAINER_HEIGHT = 600;

// node_modules/@unovis/ts/components/leaflet-map/renderer/mapboxgl/mapboxgl-settings.json.js
var bearing = 0;
var name = "F5XC Map Light";
var owner = "F5, Inc.";
var glyphs = "https://api.maptiler.com/fonts/{fontstack}/{range}.pbf";
var sources = {
  openmaptiles: {
    url: "https://api.maptiler.com/tiles/v3/tiles.json",
    type: "vector"
  }
};
var layers = [
  {
    id: "park_outline",
    type: "line",
    source: "openmaptiles",
    "source-layer": "park",
    filter: [
      "all"
    ],
    layout: {},
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-dasharray": [
        1,
        1.5
      ],
      "line-opacity": 1
    }
  },
  {
    id: "landuse_residential",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landuse",
    maxzoom: 8,
    filter: [
      "all",
      [
        "in",
        "class",
        "residential",
        "suburbs",
        "neighbourhood"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-color": {
        stops: [
          [
            9,
            "rgba(236, 236, 236, 0.8)"
          ],
          [
            12,
            "rgba(236, 236, 236, 0.8)"
          ]
        ]
      }
    }
  },
  {
    id: "landcover_wood",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landcover",
    filter: [
      "all",
      [
        "==",
        "class",
        "wood"
      ]
    ],
    paint: {
      "fill-antialias": false,
      "fill-color": "rgba(255, 255, 255, 0.7)",
      "fill-opacity": 0.4
    }
  },
  {
    id: "landcover_grass",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landcover",
    filter: [
      "all",
      [
        "==",
        "class",
        "grass"
      ]
    ],
    paint: {
      "fill-antialias": false,
      "fill-color": "rgb(255, 255, 255)",
      "fill-opacity": 0.3
    }
  },
  {
    id: "landuse_cemetery",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landuse",
    filter: [
      "==",
      "class",
      "cemetery"
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-color": "rgb(221, 221, 221)"
    }
  },
  {
    id: "landuse_hospital",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landuse",
    filter: [
      "==",
      "class",
      "hospital"
    ],
    paint: {
      "fill-color": "rgb(249, 249, 249)"
    }
  },
  {
    id: "landuse_school",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landuse",
    filter: [
      "==",
      "class",
      "school"
    ],
    paint: {
      "fill-color": "rgb(236, 236, 236)"
    }
  },
  {
    id: "landuse_stadium",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landuse",
    filter: [
      "all",
      [
        "in",
        "class",
        "stadium",
        "pitch",
        "track"
      ]
    ],
    paint: {
      "fill-color": "rgb(236, 236, 236)"
    }
  },
  {
    id: "waterway_tunnel",
    type: "line",
    source: "openmaptiles",
    "source-layer": "waterway",
    minzoom: 14,
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-cap": "round"
    },
    paint: {
      "line-color": "rgb(236, 237, 238)",
      "line-dasharray": [
        2,
        4
      ],
      "line-width": {
        base: 1.3,
        stops: [
          [
            13,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "waterway_river",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "waterway",
    filter: [
      "all",
      [
        "==",
        "class",
        "river"
      ],
      [
        "!=",
        "brunnel",
        "tunnel"
      ],
      [
        "!=",
        "intermittent",
        1
      ]
    ],
    layout: {
      "line-cap": "round"
    },
    paint: {
      "line-color": "rgb(236, 237, 238)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            11,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "waterway_river_intermittent",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "waterway",
    filter: [
      "all",
      [
        "==",
        "class",
        "river"
      ],
      [
        "!=",
        "brunnel",
        "tunnel"
      ],
      [
        "==",
        "intermittent",
        1
      ]
    ],
    layout: {
      "line-cap": "round"
    },
    paint: {
      "line-color": "#a0c8f0",
      "line-dasharray": [
        3,
        2
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            11,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "waterway_other",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "waterway",
    filter: [
      "all",
      [
        "!=",
        "class",
        "river"
      ],
      [
        "!=",
        "brunnel",
        "tunnel"
      ],
      [
        "!=",
        "intermittent",
        1
      ]
    ],
    layout: {
      "line-cap": "round"
    },
    paint: {
      "line-color": "rgb(236, 237, 238)",
      "line-width": {
        base: 1.3,
        stops: [
          [
            13,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "waterway_other_intermittent",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "waterway",
    filter: [
      "all",
      [
        "!=",
        "class",
        "river"
      ],
      [
        "!=",
        "brunnel",
        "tunnel"
      ],
      [
        "==",
        "intermittent",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "#a0c8f0",
      "line-dasharray": [
        4,
        3
      ],
      "line-width": {
        base: 1.3,
        stops: [
          [
            13,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "water_intermittent",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "water",
    filter: [
      "all",
      [
        "==",
        "intermittent",
        1
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-color": "rgba(172, 218, 251, 1)",
      "fill-opacity": 0.85
    }
  },
  {
    id: "landcover_sand",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landcover",
    filter: [
      "all",
      [
        "in",
        "class",
        "sand"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-antialias": false,
      "fill-color": "rgb(222, 222, 222)",
      "fill-opacity": 1
    }
  },
  {
    id: "landcover_sand_outline",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "landcover",
    filter: [
      "all",
      [
        "in",
        "class",
        "sand"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "line-color": "#f2e9ac",
      "line-width": 2
    }
  },
  {
    id: "aeroway_fill",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "aeroway",
    minzoom: 11,
    filter: [
      "==",
      "$type",
      "Polygon"
    ],
    paint: {
      "fill-color": "rgb(241, 241, 241)",
      "fill-opacity": 0.7
    }
  },
  {
    id: "aeroway_runway",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "aeroway",
    minzoom: 11,
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "class",
        "runway"
      ]
    ],
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            11,
            3
          ],
          [
            20,
            16
          ]
        ]
      }
    }
  },
  {
    id: "aeroway_taxiway",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "aeroway",
    minzoom: 11,
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "class",
        "taxiway"
      ]
    ],
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            11,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "ferry",
    type: "line",
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "in",
        "class",
        "ferry"
      ]
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(182, 182, 182)",
      "line-dasharray": [
        2,
        2
      ],
      "line-width": 1.1
    }
  },
  {
    id: "tunnel_motorway_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(233, 160, 182)",
      "line-dasharray": [
        0.5,
        0.25
      ],
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            1
          ],
          [
            13,
            3
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_service_track_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "service",
        "track"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(225, 225, 225)",
      "line-dasharray": [
        0.5,
        0.25
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            15,
            1
          ],
          [
            16,
            4
          ],
          [
            20,
            11
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "ramp",
        "1"
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(233, 160, 182)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            1
          ],
          [
            13,
            3
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_street_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "street",
        "street_limited"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(225, 225, 225)",
      "line-opacity": {
        stops: [
          [
            12,
            0
          ],
          [
            12.5,
            1
          ]
        ]
      },
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            0.5
          ],
          [
            13,
            1
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_secondary_tertiary_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "secondary",
        "tertiary"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(212, 212, 212)",
      "line-dasharray": [
        0.5,
        0.25
      ],
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            8,
            1.5
          ],
          [
            20,
            17
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_trunk_primary_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(233, 160, 182)",
      "line-dasharray": [
        0.5,
        0.25
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0.4
          ],
          [
            6,
            0.7
          ],
          [
            7,
            1.75
          ],
          [
            20,
            22
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_motorway_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(233, 160, 182)",
      "line-dasharray": [
        0.5,
        0.25
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0.4
          ],
          [
            6,
            0.7
          ],
          [
            7,
            1.75
          ],
          [
            20,
            22
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_path_pedestrian",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "path",
        "pedestrian"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(216, 205, 206, 0.45)",
      "line-dasharray": [
        1,
        0.75
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            14,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_motorway_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway_link"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(251, 181, 195)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            12.5,
            0
          ],
          [
            13,
            1.5
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_service_track",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "service",
        "track"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            15.5,
            0
          ],
          [
            16,
            2
          ],
          [
            20,
            7.5
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "ramp",
        "1"
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(254, 240, 240)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            12.5,
            0
          ],
          [
            13,
            1.5
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_minor",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "minor"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            13.5,
            0
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_secondary_tertiary",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "secondary",
        "tertiary"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            6.5,
            0
          ],
          [
            8,
            0.5
          ],
          [
            20,
            13
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_trunk_primary",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(254, 240, 240)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            1
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_motorway",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "brunnel",
        "tunnel"
      ]
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(253, 209, 217)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            1
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_major_rail",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "in",
        "class",
        "rail"
      ]
    ],
    paint: {
      "line-color": "rgb(208, 208, 208)",
      "line-width": {
        base: 1.4,
        stops: [
          [
            14,
            0.4
          ],
          [
            15,
            0.75
          ],
          [
            20,
            2
          ]
        ]
      }
    }
  },
  {
    id: "tunnel_major_rail_hatching",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "tunnel"
      ],
      [
        "==",
        "class",
        "rail"
      ]
    ],
    paint: {
      "line-color": "rgb(208, 208, 208)",
      "line-dasharray": [
        0.2,
        8
      ],
      "line-width": {
        base: 1.4,
        stops: [
          [
            14.5,
            0
          ],
          [
            15,
            3
          ],
          [
            20,
            8
          ]
        ]
      }
    }
  },
  {
    id: "road_area_pier",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "Polygon"
      ],
      [
        "==",
        "class",
        "pier"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-antialias": true,
      "fill-color": "rgb(252, 252, 252)"
    }
  },
  {
    id: "road_pier",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "in",
        "class",
        "pier"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(246, 241, 229, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            15,
            1
          ],
          [
            17,
            4
          ]
        ]
      }
    }
  },
  {
    id: "road_area_bridge",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "Polygon"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-antialias": true,
      "fill-color": "rgba(255, 255, 255, 0.6)"
    }
  },
  {
    id: "road_area_pattern",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "Polygon"
      ],
      [
        "!has",
        "brunnel"
      ],
      [
        "!in",
        "class",
        "bridge",
        "pier"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-color": "rgba(252, 252, 252, 1.0)"
    }
  },
  {
    id: "road_service_track_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "in",
        "class",
        "service",
        "track"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(225, 225, 225)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            15,
            1
          ],
          [
            16,
            4
          ],
          [
            20,
            11
          ]
        ]
      }
    }
  },
  {
    id: "road_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 13,
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "!in",
        "class",
        "motorway",
        "trunk",
        "primary",
        "pedestrian",
        "path",
        "track",
        "service"
      ],
      [
        "==",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(233, 160, 182)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            1
          ],
          [
            13,
            3
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "road_trunk_primary_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-cap": "butt",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            0.7
          ],
          [
            20,
            14
          ]
        ]
      }
    }
  },
  {
    id: "road_motorway_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 12,
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "butt",
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            1
          ],
          [
            13,
            3
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "road_minor_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "in",
        "class",
        "minor"
      ],
      [
        "!=",
        "ramp",
        "1"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(225, 225, 225)",
      "line-opacity": {
        stops: [
          [
            12,
            0
          ],
          [
            12.5,
            1
          ]
        ]
      },
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            0.5
          ],
          [
            13,
            1
          ],
          [
            14,
            4
          ],
          [
            20,
            20
          ]
        ]
      }
    }
  },
  {
    id: "road_secondary_tertiary_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "in",
        "class",
        "secondary",
        "tertiary"
      ],
      [
        "!=",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "none"
    },
    paint: {
      "line-color": "rgb(212, 212, 212)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            8,
            1.5
          ],
          [
            20,
            17
          ]
        ]
      }
    }
  },
  {
    id: "road_trunk_primary_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "!=",
        "ramp",
        1
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ],
      [
        "!=",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "butt",
      "line-join": "round",
      visibility: "none"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0.4
          ],
          [
            6,
            0.7
          ],
          [
            7,
            1.75
          ],
          [
            20,
            22
          ]
        ]
      }
    }
  },
  {
    id: "road_motorway_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 5,
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "!=",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "butt",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(163, 213, 217, .)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0.4
          ],
          [
            6,
            0.7
          ],
          [
            7,
            1.75
          ],
          [
            20,
            22
          ]
        ]
      }
    }
  },
  {
    id: "road_path_pedestrian",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 14,
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "in",
        "class",
        "path",
        "pedestrian"
      ]
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(216, 205, 206, 0.45)",
      "line-dasharray": [
        1,
        1
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            14,
            1
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "road_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 13,
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "!in",
        "class",
        "motorway",
        "trunk",
        "primary",
        "pedestrian",
        "path",
        "track",
        "service"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            12.5,
            0
          ],
          [
            13,
            1.5
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "road_trunk_primary_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            0.5
          ],
          [
            20,
            10
          ]
        ]
      }
    }
  },
  {
    id: "road_motorway_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 12,
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            12.5,
            0
          ],
          [
            13,
            1.5
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "road_service_track",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "in",
        "class",
        "service",
        "track"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            15.5,
            0
          ],
          [
            16,
            2
          ],
          [
            20,
            7.5
          ]
        ]
      }
    }
  },
  {
    id: "road_minor",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "all",
        [
          "!in",
          "brunnel",
          "bridge",
          "tunnel"
        ],
        [
          "in",
          "class",
          "minor"
        ]
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "none"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            13.5,
            0
          ],
          [
            14,
            2.5
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "road_secondary_tertiary",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "in",
        "class",
        "secondary",
        "tertiary"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "none"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            6.5,
            0
          ],
          [
            8,
            0.5
          ],
          [
            20,
            13
          ]
        ]
      }
    }
  },
  {
    id: "road_trunk_primary",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "!=",
        "ramp",
        1
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgba(246, 241, 232, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            1
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "road_motorway",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 5,
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "!=",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": {
        stops: [
          [
            5,
            "rgba(246, 241, 232, 1)"
          ],
          [
            6,
            "rgba(246, 241, 232, 1)"
          ]
        ]
      },
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            1
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "road_major_rail",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "class",
        "rail"
      ]
    ],
    paint: {
      "line-color": "rgb(208, 208, 208)",
      "line-width": {
        base: 1.4,
        stops: [
          [
            14,
            0.4
          ],
          [
            15,
            0.75
          ],
          [
            20,
            2
          ]
        ]
      }
    }
  },
  {
    id: "road_major_rail_hatching",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "!in",
        "brunnel",
        "bridge",
        "tunnel"
      ],
      [
        "==",
        "class",
        "rail"
      ]
    ],
    paint: {
      "line-color": "rgb(208, 208, 208)",
      "line-dasharray": [
        0.2,
        8
      ],
      "line-width": {
        base: 1.4,
        stops: [
          [
            14.5,
            0
          ],
          [
            15,
            3
          ],
          [
            20,
            8
          ]
        ]
      }
    }
  },
  {
    id: "building",
    type: "fill",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "building",
    minzoom: 13,
    maxzoom: 14,
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-color": "rgba(181, 181, 181, 0.3)",
      "fill-outline-color": {
        stops: [
          [
            13,
            "rgba(198, 197, 197, 0.32)"
          ],
          [
            14,
            "rgb(198, 197, 197)"
          ]
        ]
      }
    }
  },
  {
    id: "building-3d",
    type: "fill-extrusion",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "building",
    minzoom: 14,
    filter: [
      "all",
      [
        "!has",
        "hide_3d"
      ]
    ],
    layout: {
      visibility: "visible"
    },
    paint: {
      "fill-extrusion-base": {
        property: "render_min_height",
        type: "identity"
      },
      "fill-extrusion-color": "rgb(181, 181, 181)",
      "fill-extrusion-height": {
        property: "render_height",
        type: "identity"
      },
      "fill-extrusion-opacity": 0.3
    }
  },
  {
    id: "waterway-bridge-case",
    type: "line",
    source: "openmaptiles",
    "source-layer": "waterway",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      "line-cap": "butt",
      "line-join": "miter"
    },
    paint: {
      "line-color": "rgb(224, 224, 224)",
      "line-gap-width": {
        base: 1.3,
        stops: [
          [
            13,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      },
      "line-width": {
        base: 1.6,
        stops: [
          [
            12,
            0.5
          ],
          [
            20,
            5
          ]
        ]
      }
    }
  },
  {
    id: "waterway-bridge",
    type: "line",
    source: "openmaptiles",
    "source-layer": "waterway",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(223, 229, 235)",
      "line-width": {
        base: 1.3,
        stops: [
          [
            13,
            0.5
          ],
          [
            20,
            6
          ]
        ]
      }
    }
  },
  {
    id: "bridge_motorway_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            1
          ],
          [
            13,
            3
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "bridge_service_track_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "service",
        "track"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(225, 225, 225)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            15,
            1
          ],
          [
            16,
            4
          ],
          [
            20,
            11
          ]
        ]
      }
    }
  },
  {
    id: "bridge_link_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "link"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            1
          ],
          [
            13,
            3
          ],
          [
            14,
            4
          ],
          [
            20,
            15
          ]
        ]
      }
    }
  },
  {
    id: "bridge_street_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "street",
        "street_limited"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(209, 209, 209)",
      "line-opacity": {
        stops: [
          [
            12,
            0
          ],
          [
            12.5,
            1
          ]
        ]
      },
      "line-width": {
        base: 1.2,
        stops: [
          [
            12,
            0.5
          ],
          [
            13,
            1
          ],
          [
            14,
            4
          ],
          [
            20,
            25
          ]
        ]
      }
    }
  },
  {
    id: "bridge_path_pedestrian_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "path",
        "pedestrian"
      ]
    ],
    layout: {
      "line-join": "miter",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(225, 225, 225)",
      "line-dasharray": [
        1,
        0
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            14,
            1.5
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "bridge_secondary_tertiary_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "secondary",
        "tertiary"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(212, 212, 212)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            8,
            1.5
          ],
          [
            20,
            17
          ]
        ]
      }
    }
  },
  {
    id: "bridge_trunk_primary_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0.4
          ],
          [
            6,
            0.7
          ],
          [
            7,
            1.75
          ],
          [
            20,
            22
          ]
        ]
      }
    }
  },
  {
    id: "bridge_motorway_casing",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "!=",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0.4
          ],
          [
            6,
            0.7
          ],
          [
            7,
            1.75
          ],
          [
            20,
            22
          ]
        ]
      }
    }
  },
  {
    id: "bridge_path_pedestrian",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "path",
        "pedestrian"
      ]
    ],
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-dasharray": [
        1,
        0.3
      ],
      "line-width": {
        base: 1.2,
        stops: [
          [
            14,
            0.5
          ],
          [
            20,
            10
          ]
        ]
      }
    }
  },
  {
    id: "bridge_motorway_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "ramp",
        1
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            12.5,
            0
          ],
          [
            13,
            1.5
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "bridge_service_track",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "service",
        "track"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            15.5,
            0
          ],
          [
            16,
            2
          ],
          [
            20,
            7.5
          ]
        ]
      }
    }
  },
  {
    id: "bridge_link",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "link"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            12.5,
            0
          ],
          [
            13,
            1.5
          ],
          [
            14,
            2.5
          ],
          [
            20,
            11.5
          ]
        ]
      }
    }
  },
  {
    id: "bridge_street",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "minor"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-opacity": 1,
      "line-width": {
        base: 1.2,
        stops: [
          [
            13.5,
            0
          ],
          [
            14,
            2.5
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "bridge_secondary_tertiary",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "secondary",
        "tertiary"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgb(255, 255, 255)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            6.5,
            0
          ],
          [
            8,
            0.5
          ],
          [
            20,
            13
          ]
        ]
      }
    }
  },
  {
    id: "bridge_trunk_primary",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "in",
        "class",
        "primary",
        "trunk"
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            1
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "bridge_motorway",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "motorway"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ],
      [
        "!=",
        "ramp",
        1
      ]
    ],
    layout: {
      "line-join": "round"
    },
    paint: {
      "line-color": "rgba(223, 219, 202, 1)",
      "line-width": {
        base: 1.2,
        stops: [
          [
            5,
            0
          ],
          [
            7,
            1
          ],
          [
            20,
            18
          ]
        ]
      }
    }
  },
  {
    id: "bridge_major_rail",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "rail"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    paint: {
      "line-color": "rgb(208, 208, 208)",
      "line-width": {
        base: 1.4,
        stops: [
          [
            14,
            0.4
          ],
          [
            15,
            0.75
          ],
          [
            20,
            2
          ]
        ]
      }
    }
  },
  {
    id: "bridge_major_rail_hatching",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation",
    filter: [
      "all",
      [
        "==",
        "class",
        "rail"
      ],
      [
        "==",
        "brunnel",
        "bridge"
      ]
    ],
    paint: {
      "line-color": "rgb(208, 208, 208)",
      "line-dasharray": [
        0.2,
        8
      ],
      "line-width": {
        base: 1.4,
        stops: [
          [
            14.5,
            0
          ],
          [
            15,
            3
          ],
          [
            20,
            8
          ]
        ]
      }
    }
  },
  {
    id: "cablecar",
    type: "line",
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 13,
    filter: [
      "==",
      "class",
      "cable_car"
    ],
    layout: {
      "line-cap": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(199, 199, 199)",
      "line-width": {
        base: 1,
        stops: [
          [
            11,
            1
          ],
          [
            19,
            2.5
          ]
        ]
      }
    }
  },
  {
    id: "cablecar-dash",
    type: "line",
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 13,
    filter: [
      "==",
      "class",
      "cable_car"
    ],
    layout: {
      "line-cap": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(199, 199, 199)",
      "line-dasharray": [
        2,
        3
      ],
      "line-width": {
        base: 1,
        stops: [
          [
            11,
            3
          ],
          [
            19,
            5.5
          ]
        ]
      }
    }
  },
  {
    id: "boundary_3",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "boundary",
    filter: [
      "match",
      [
        "get",
        "admin_level"
      ],
      [
        3,
        4
      ],
      true,
      false
    ],
    layout: {
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(197, 208, 216)",
      "line-dasharray": [
        1,
        1
      ],
      "line-width": {
        base: 1,
        stops: [
          [
            4,
            0.4
          ],
          [
            5,
            1
          ],
          [
            12,
            1.8
          ]
        ]
      },
      "line-opacity": 0.5
    }
  },
  {
    id: "boundary_2",
    type: "line",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "boundary",
    filter: [
      "all",
      [
        "==",
        "admin_level",
        2
      ],
      [
        "!=",
        "disputed",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(197, 208, 216)",
      "line-opacity": {
        base: 1,
        stops: [
          [
            0,
            0.4
          ],
          [
            4,
            0.8
          ]
        ]
      },
      "line-width": {
        base: 1,
        stops: [
          [
            3,
            1
          ],
          [
            5,
            1.2
          ],
          [
            12,
            3
          ]
        ]
      }
    }
  },
  {
    id: "boundary_disputed_level_2",
    type: "line",
    source: "openmaptiles",
    "source-layer": "boundary",
    minzoom: 0,
    filter: [
      "all",
      [
        "<=",
        "admin_level",
        2
      ],
      [
        "==",
        "disputed",
        1
      ]
    ],
    layout: {
      "line-cap": "round",
      "line-join": "round",
      visibility: "visible"
    },
    paint: {
      "line-color": "rgb(197, 208, 216)",
      "line-width": 1,
      "line-opacity": 0.7,
      "line-dasharray": [
        6,
        6
      ]
    }
  },
  {
    id: "water_name_line",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "water_name",
    minzoom: 0,
    filter: [
      "all",
      [
        "==",
        "$type",
        "LineString"
      ]
    ],
    layout: {
      "symbol-placement": "line",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-max-width": 5,
      "text-size": 12
    },
    paint: {
      "text-color": "rgb(178, 178, 178)",
      "text-halo-color": "rgba(255, 255, 255, 0.7)",
      "text-halo-width": 1
    }
  },
  {
    id: "water_name_point",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "water_name",
    minzoom: 2,
    maxzoom: 24,
    filter: [
      "all",
      [
        "==",
        "$type",
        "Point"
      ],
      [
        "!=",
        "class",
        "ocean"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-max-width": 5,
      "text-size": 12
    },
    paint: {
      "text-color": "rgba(159, 178, 195, 0.8)",
      "text-halo-color": "rgba(255, 255, 255, 0)",
      "text-halo-width": 1
    }
  },
  {
    id: "water_ocean_name_point",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "water_name",
    minzoom: 0,
    filter: [
      "all",
      [
        "==",
        "$type",
        "Point"
      ],
      [
        "==",
        "class",
        "ocean"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-max-width": 5,
      "text-size": 12
    },
    paint: {
      "text-color": "rgba(159, 178, 195, 0.6)",
      "text-halo-color": "rgba(255, 255, 255, 0)",
      "text-halo-width": 1
    }
  },
  {
    id: "poi_z16_subclass",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "poi",
    minzoom: 16,
    filter: [
      "all",
      [
        "==",
        "$type",
        "Point"
      ],
      [
        ">=",
        "rank",
        20
      ],
      [
        "any",
        [
          "all",
          [
            "in",
            "class",
            "pitch"
          ],
          [
            "in",
            "subclass",
            "soccer",
            "tennis",
            "baseball",
            "basketball",
            "swimming",
            "golf"
          ]
        ]
      ],
      [
        "any",
        [
          "!has",
          "level"
        ],
        [
          "==",
          "level",
          0
        ]
      ]
    ],
    layout: {
      "text-anchor": "top",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 9,
      "text-offset": [
        0,
        0.6
      ],
      "text-padding": 2,
      "text-size": 12,
      visibility: "none"
    },
    paint: {
      "text-color": "#666",
      "text-halo-blur": 0.5,
      "text-halo-color": "#ffffff",
      "text-halo-width": 1
    }
  },
  {
    id: "poi_z16",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "poi",
    minzoom: 16,
    filter: [
      "all",
      [
        "==",
        "$type",
        "Point"
      ],
      [
        ">=",
        "rank",
        20
      ],
      [
        "none",
        [
          "all",
          [
            "in",
            "class",
            "pitch"
          ],
          [
            "in",
            "subclass",
            "soccer",
            "tennis",
            "baseball",
            "basketball",
            "swimming",
            "golf"
          ]
        ]
      ],
      [
        "any",
        [
          "!has",
          "level"
        ],
        [
          "==",
          "level",
          0
        ]
      ]
    ],
    layout: {
      "text-anchor": "top",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 9,
      "text-offset": [
        0,
        0.6
      ],
      "text-padding": 2,
      "text-size": 12,
      visibility: "none"
    },
    paint: {
      "text-color": "rgb(216, 220, 223)",
      "text-halo-blur": 0.5,
      "text-halo-color": "rgb(255, 255, 255)",
      "text-halo-width": 1
    }
  },
  {
    id: "poi_z15",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "poi",
    minzoom: 15,
    filter: [
      "all",
      [
        "==",
        "$type",
        "Point"
      ],
      [
        ">=",
        "rank",
        7
      ],
      [
        "<",
        "rank",
        20
      ],
      [
        "any",
        [
          "!has",
          "level"
        ],
        [
          "==",
          "level",
          0
        ]
      ]
    ],
    layout: {
      "text-anchor": "top",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 9,
      "text-offset": [
        0,
        0.6
      ],
      "text-padding": 2,
      "text-size": 12,
      visibility: "none"
    },
    paint: {
      "text-color": "rgb(216, 220, 223)",
      "text-halo-blur": 0.5,
      "text-halo-color": "rgb(255, 255, 255)",
      "text-halo-width": 1
    }
  },
  {
    id: "poi_z14",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "poi",
    minzoom: 14.2,
    filter: [
      "all",
      [
        "==",
        "$type",
        "Point"
      ],
      [
        "any",
        [
          "<",
          "rank",
          7
        ]
      ],
      [
        "any",
        [
          "!has",
          "level"
        ],
        [
          "==",
          "level",
          0
        ]
      ]
    ],
    layout: {
      "icon-size": 0.9,
      "text-anchor": "top",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 9,
      "text-offset": [
        0,
        0.6
      ],
      "text-padding": 2,
      "text-size": 12,
      visibility: "none"
    },
    paint: {
      "text-color": "rgb(216, 220, 223)",
      "text-halo-blur": 0.5,
      "text-halo-color": "rgb(255, 255, 255)",
      "text-halo-width": 1
    }
  },
  {
    id: "poi_transit",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "poi",
    minzoom: 15,
    filter: [
      "all",
      [
        "in",
        "class",
        "bus",
        "railway",
        "airport"
      ],
      [
        "==",
        "subclass",
        "station"
      ]
    ],
    layout: {
      "icon-size": 0.9,
      "text-anchor": "left",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 9,
      "text-offset": [
        0.9,
        0
      ],
      "text-padding": 2,
      "text-size": 12,
      visibility: "visible"
    },
    paint: {
      "text-color": "rgb(216, 220, 223)",
      "text-halo-blur": 0.5,
      "text-halo-color": "rgb(255, 255, 255)",
      "text-halo-width": 1
    }
  },
  {
    id: "road_oneway",
    type: "symbol",
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 15,
    filter: [
      "all",
      [
        "==",
        "oneway",
        1
      ],
      [
        "in",
        "class",
        "motorway",
        "trunk",
        "primary",
        "secondary",
        "tertiary",
        "minor",
        "service"
      ]
    ],
    layout: {
      "icon-padding": 2,
      "icon-rotate": 90,
      "icon-rotation-alignment": "map",
      "icon-size": {
        stops: [
          [
            15,
            0.5
          ],
          [
            19,
            1
          ]
        ]
      },
      "symbol-placement": "line",
      "symbol-spacing": 75
    },
    paint: {
      "icon-opacity": 0.5
    }
  },
  {
    id: "road_oneway_opposite",
    type: "symbol",
    source: "openmaptiles",
    "source-layer": "transportation",
    minzoom: 15,
    filter: [
      "all",
      [
        "==",
        "oneway",
        -1
      ],
      [
        "in",
        "class",
        "motorway",
        "trunk",
        "primary",
        "secondary",
        "tertiary",
        "minor",
        "service"
      ]
    ],
    layout: {
      "icon-padding": 2,
      "icon-rotate": -90,
      "icon-rotation-alignment": "map",
      "icon-size": {
        stops: [
          [
            15,
            0.5
          ],
          [
            19,
            1
          ]
        ]
      },
      "symbol-placement": "line",
      "symbol-spacing": 75
    },
    paint: {
      "icon-opacity": 0.5
    }
  },
  {
    id: "road_label",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "transportation_name",
    filter: [
      "all"
    ],
    layout: {
      "symbol-placement": "line",
      "text-anchor": "center",
      "text-field": "{name_en} ",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-offset": [
        0,
        0.15
      ],
      "text-size": {
        base: 1,
        stops: [
          [
            13,
            12
          ],
          [
            14,
            13
          ]
        ]
      }
    },
    paint: {
      "text-color": "rgba(161, 169, 176, 1)",
      "text-halo-blur": 0.5,
      "text-halo-width": 1
    }
  },
  {
    id: "highway-shield",
    type: "symbol",
    source: "openmaptiles",
    "source-layer": "transportation_name",
    minzoom: 8,
    filter: [
      "all",
      [
        "<=",
        "ref_length",
        6
      ],
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "!in",
        "network",
        "us-interstate",
        "us-highway",
        "us-state"
      ]
    ],
    layout: {
      "icon-rotation-alignment": "viewport",
      "icon-size": 1,
      "symbol-avoid-edges": true,
      "symbol-placement": {
        base: 1,
        stops: [
          [
            10,
            "point"
          ],
          [
            11,
            "line"
          ]
        ]
      },
      "symbol-spacing": 200,
      "text-field": "{ref}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-rotation-alignment": "viewport",
      "text-size": 10,
      visibility: "none"
    },
    paint: {
      "icon-color": "rgba(161, 169, 176, 1)",
      "text-color": "rgba(161, 169, 176, 1)"
    }
  },
  {
    id: "highway-shield-us-interstate",
    type: "symbol",
    source: "openmaptiles",
    "source-layer": "transportation_name",
    minzoom: 7,
    filter: [
      "all",
      [
        "<=",
        "ref_length",
        6
      ],
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "in",
        "network",
        "us-interstate"
      ]
    ],
    layout: {
      "icon-rotation-alignment": "viewport",
      "icon-size": 1,
      "symbol-avoid-edges": true,
      "symbol-placement": {
        base: 1,
        stops: [
          [
            7,
            "point"
          ],
          [
            7,
            "line"
          ],
          [
            8,
            "line"
          ]
        ]
      },
      "symbol-spacing": 200,
      "text-field": "{ref}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-rotation-alignment": "viewport",
      "text-size": 9,
      visibility: "none"
    },
    paint: {
      "text-color": "rgb(255, 255, 255)"
    }
  },
  {
    id: "highway-shield-us-other",
    type: "symbol",
    source: "openmaptiles",
    "source-layer": "transportation_name",
    minzoom: 9,
    filter: [
      "all",
      [
        "<=",
        "ref_length",
        6
      ],
      [
        "==",
        "$type",
        "LineString"
      ],
      [
        "in",
        "network",
        "us-highway",
        "us-state"
      ]
    ],
    layout: {
      "icon-rotation-alignment": "viewport",
      "icon-size": 1,
      "symbol-avoid-edges": true,
      "symbol-placement": {
        base: 1,
        stops: [
          [
            10,
            "point"
          ],
          [
            11,
            "line"
          ]
        ]
      },
      "symbol-spacing": 200,
      "text-field": "{ref}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-rotation-alignment": "viewport",
      "text-size": 9,
      visibility: "none"
    },
    paint: {
      "text-color": "rgb(57, 57, 57)"
    }
  },
  {
    id: "place_other",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    filter: [
      "all",
      [
        "in",
        "class",
        "hamlet",
        "island",
        "islet",
        "neighbourhood",
        "suburb"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-letter-spacing": 0.1,
      "text-max-width": 9,
      "text-size": {
        base: 1.2,
        stops: [
          [
            12,
            10
          ],
          [
            15,
            14
          ]
        ]
      },
      "text-transform": "uppercase",
      visibility: "visible"
    },
    paint: {
      "text-color": "rgb(173, 182, 190)",
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 1.2
    }
  },
  {
    id: "place_village",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    filter: [
      "all",
      [
        "==",
        "class",
        "village"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-max-width": 8,
      "text-size": {
        base: 1.2,
        stops: [
          [
            10,
            12
          ],
          [
            15,
            22
          ]
        ]
      },
      visibility: "none"
    },
    paint: {
      "text-color": "rgb(161, 169, 176)",
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 1.2
    }
  },
  {
    id: "place_town",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    filter: [
      "all",
      [
        "==",
        "class",
        "town"
      ]
    ],
    layout: {
      "text-anchor": "bottom",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Regular"
      ],
      "text-max-width": 8,
      "text-offset": [
        0,
        0
      ],
      "text-size": {
        base: 1.2,
        stops: [
          [
            7,
            12
          ],
          [
            11,
            16
          ]
        ]
      }
    },
    paint: {
      "text-color": "rgba(161, 169, 176, 0.8)",
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 1.2
    }
  },
  {
    id: "place_city",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    minzoom: 5,
    filter: [
      "all",
      [
        "==",
        "class",
        "city"
      ]
    ],
    layout: {
      "icon-allow-overlap": true,
      "icon-optional": false,
      "text-anchor": "bottom",
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Semibold"
      ],
      "text-max-width": 8,
      "text-offset": [
        0,
        0
      ],
      "text-size": {
        base: 1.2,
        stops: [
          [
            7,
            14
          ],
          [
            11,
            24
          ]
        ]
      }
    },
    paint: {
      "text-color": "rgba(161, 169, 176, 0.8)",
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 1.2
    }
  },
  {
    id: "country_other",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    filter: [
      "all",
      [
        "==",
        "class",
        "country"
      ],
      [
        "!has",
        "iso_a2"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 6.25,
      "text-size": {
        stops: [
          [
            3,
            9
          ],
          [
            7,
            15
          ]
        ]
      },
      "text-transform": "none"
    },
    paint: {
      "text-color": "rgba(159, 178, 195, 0.55)",
      "text-halo-blur": 1,
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 0.8
    }
  },
  {
    id: "country_3",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    minzoom: 2,
    filter: [
      "all",
      [
        ">=",
        "rank",
        3
      ],
      [
        "==",
        "class",
        "country"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 6.25,
      "text-size": {
        stops: [
          [
            3,
            11
          ],
          [
            7,
            17
          ]
        ]
      },
      "text-transform": "none",
      visibility: "visible"
    },
    paint: {
      "text-color": "rgba(159, 178, 195, 0.55)",
      "text-halo-blur": 1,
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 0.8
    }
  },
  {
    id: "country_2",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    minzoom: 2,
    filter: [
      "all",
      [
        "==",
        "rank",
        2
      ],
      [
        "==",
        "class",
        "country"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 6.25,
      "text-size": {
        stops: [
          [
            2,
            11
          ],
          [
            5,
            17
          ]
        ]
      },
      "text-transform": "none",
      visibility: "visible"
    },
    paint: {
      "text-color": "rgba(159, 178, 195, 0.55)",
      "text-halo-blur": 1,
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 0.8
    }
  },
  {
    id: "country_1",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    minzoom: 2,
    filter: [
      "all",
      [
        "==",
        "rank",
        1
      ],
      [
        "==",
        "class",
        "country"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-max-width": 6.25,
      "text-size": {
        stops: [
          [
            1,
            11
          ],
          [
            4,
            17
          ]
        ]
      },
      "text-transform": "none",
      visibility: "visible"
    },
    paint: {
      "text-color": "rgba(159, 178, 195, 0.55)",
      "text-halo-blur": 1,
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 0.8
    }
  },
  {
    id: "continent",
    type: "symbol",
    metadata: {},
    source: "openmaptiles",
    "source-layer": "place",
    maxzoom: 1,
    filter: [
      "all",
      [
        "==",
        "class",
        "continent"
      ]
    ],
    layout: {
      "text-field": "{name_en}",
      "text-font": [
        "Open Sans Italic"
      ],
      "text-justify": "center",
      "text-size": 13,
      "text-transform": "uppercase"
    },
    paint: {
      "text-color": "rgb(168, 196, 220)",
      "text-halo-color": "rgba(255, 255, 255, 0.6)",
      "text-halo-width": 1
    }
  }
];
var version = 8;
var mapLibreBaseSettings = {
  bearing,
  name,
  owner,
  glyphs,
  sources,
  layers,
  version
};

// node_modules/@unovis/ts/components/leaflet-map/renderer/mapboxgl/mapboxgl-dark-theme.json.js
var layers2 = [
  {
    id: "background",
    layout: {
      visibility: "visible"
    },
    paint: {
      "background-color": "#5C627A"
    },
    type: "background"
  },
  {
    filter: [
      "all",
      [
        "!=",
        "intermittent",
        1
      ]
    ],
    id: "water",
    layout: {
      visibility: "visible"
    },
    metadata: {},
    paint: {
      "fill-color": "#2A2D39"
    },
    source: "openmaptiles",
    "source-layer": "water",
    type: "fill"
  }
];
var mapLibreDarkTheme = {
  layers: layers2
};

// node_modules/@unovis/ts/components/leaflet-map/renderer/mapboxgl/mapboxgl-light-theme.json.js
var layers3 = [
  {
    id: "background",
    layout: {
      visibility: "visible"
    },
    paint: {
      "background-color": "rgba(255, 255, 255, 1)"
    },
    type: "background"
  },
  {
    filter: [
      "all",
      [
        "!=",
        "intermittent",
        1
      ]
    ],
    id: "water",
    layout: {
      visibility: "visible"
    },
    metadata: {},
    paint: {
      "fill-color": "rgb(223, 229, 235)"
    },
    source: "openmaptiles",
    "source-layer": "water",
    type: "fill"
  }
];
var mapLibreLightTheme = {
  layers: layers3
};

// node_modules/@unovis/ts/components/leaflet-map/renderer/map-style.js
var MapLibreArcticDark = Object.assign(Object.assign({}, mapLibreBaseSettings), { layers: [
  ...mapLibreDarkTheme.layers,
  ...mapLibreBaseSettings.layers
] });
var MapLibreArcticLight = Object.assign(Object.assign({}, mapLibreBaseSettings), { layers: [
  ...mapLibreLightTheme.layers,
  ...mapLibreBaseSettings.layers
] });

// node_modules/@unovis/ts/components/leaflet-flow-map/config.js
var LeafletFlowMapDefaultConfig = Object.assign(Object.assign({}, LeafletMapDefaultConfig), { sourceLongitude: (f) => f.sourceLongitude, sourceLatitude: (f) => f.sourceLatitude, targetLongitude: (f) => f.targetLongitude, targetLatitude: (f) => f.targetLatitude, sourcePointRadius: 3, sourcePointColor: "#88919f", flowParticleColor: "#949dad", flowParticleRadius: 1.1, flowParticleSpeed: 0.07, flowParticleDensity: 0.6, onSourcePointClick: void 0, onSourcePointMouseEnter: void 0, onSourcePointMouseLeave: void 0 });

// node_modules/@unovis/ts/components/leaflet-flow-map/index.js
var LeafletFlowMap = class extends ComponentCore {
  constructor(container, config, data) {
    var _a;
    super(ComponentType.HTML);
    this._defaultConfig = LeafletFlowMapDefaultConfig;
    this.config = this._defaultConfig;
    this.type = ComponentType.HTML;
    this.flows = [];
    this.points = [];
    this.onCanvasMouseMoveBound = throttle(this.onCanvasMouseMove.bind(this), 60);
    this.onCanvasClickBound = this.onCanvasClick.bind(this);
    this.panningOffset = { x: 0, y: 0 };
    this.particles = [];
    this.leafletMap = new LeafletMap(container, config, (_a = data === null || data === void 0 ? void 0 : data.points) !== null && _a !== void 0 ? _a : []);
    const rendererImportPromise = import("./renderer-GS4VGC4S.js");
    Promise.all([rendererImportPromise, this.leafletMap.getLeafletInstancePromise()]).then((imports) => {
      const [{ PointRenderer }, leaflet] = imports;
      this.leafletMapInstance = leaflet;
      const canvasContainer = this.leafletMapInstance.getPanes().overlayPane;
      const canvas = select_default2(canvasContainer).insert("canvas", ":first-child");
      this.canvasElement = canvas.node();
      this.renderer = new PointRenderer(canvasContainer, container.offsetWidth, container.offsetHeight, this.canvasElement);
      this.canvasElement.addEventListener("mousemove", this.onCanvasMouseMoveBound);
      this.canvasElement.addEventListener("click", this.onCanvasClickBound);
      this.leafletMap._onMapMoveEndInternal = this.onMapMove.bind(this);
      this.resizeObserver = new ResizeObserver2(() => {
        this.renderer.setSize(container.offsetWidth, container.offsetHeight);
      });
      this.resizeObserver.observe(container);
      if (config)
        this.setConfig(config);
      if (data)
        this.setData(data);
      this.animate();
    });
  }
  setConfig(config) {
    super.setConfig(config);
    this.leafletMap.setConfig(Object.assign(Object.assign({}, config), { clusteringDistance: 0 }));
  }
  setData(data) {
    super.setData(data);
    this.flows = data.flows;
    this.points = data.points;
    this.initParticles();
    this.leafletMap.setData(this.points);
    this.render();
  }
  render() {
    super.render();
  }
  initParticles() {
    var _a;
    this.clearParticles();
    for (const flow of this.flows) {
      const source = {
        lat: getNumber(flow, this.config.sourceLatitude),
        lon: getNumber(flow, this.config.sourceLongitude)
      };
      const target = {
        lat: getNumber(flow, this.config.targetLatitude),
        lon: getNumber(flow, this.config.targetLongitude)
      };
      const sourcePointRadius = getNumber(flow, this.config.sourcePointRadius);
      const sourcePointColor = getColor(flow, this.config.sourcePointColor);
      this.addParticle(source, source, source, 0, sourcePointRadius, sourcePointColor);
      const dist = Math.sqrt(Math.pow(target.lat - source.lat, 2) + Math.pow(target.lon - source.lon, 2));
      const numParticles = Math.round(dist * getNumber(flow, this.config.flowParticleDensity));
      const velocity = getNumber(flow, this.config.flowParticleSpeed);
      const r = getNumber(flow, this.config.flowParticleRadius);
      const color2 = getColor(flow, this.config.flowParticleColor);
      for (let i = 0; i < numParticles; i += 1) {
        const location = {
          lat: source.lat + (target.lat - source.lat) * i / numParticles,
          lon: source.lon + (target.lon - source.lon) * i / numParticles
        };
        this.addParticle(source, target, location, velocity, r, color2);
      }
    }
    (_a = this.renderer) === null || _a === void 0 ? void 0 : _a.update(this.particles);
  }
  addParticle(source, target, location = source, velocity = 0.05, r = 0.75, color2) {
    const x3 = 0;
    const y3 = 0;
    this.particles.push({ x: x3, y: y3, source, target, location, velocity, r, color: color2 });
  }
  clearParticles() {
    this.particles = [];
  }
  animate() {
    const map5 = this.leafletMapInstance;
    requestAnimationFrame(() => {
      const zoomLevel = map5 === null || map5 === void 0 ? void 0 : map5.getZoom();
      for (const p of this.particles) {
        const fullDist = Math.sqrt(Math.pow(p.target.lat - p.source.lat, 2) + Math.pow(p.target.lon - p.source.lon, 2));
        const remainedDist = Math.sqrt(Math.pow(p.target.lat - p.location.lat, 2) + Math.pow(p.target.lon - p.location.lon, 2));
        const angle = Math.atan2(p.target.lat - p.source.lat, p.target.lon - p.source.lon);
        p.location.lat += p.velocity * Math.sin(angle);
        p.location.lon += p.velocity * Math.cos(angle);
        if (p.target.lat > p.source.lat && p.location.lat > p.target.lat || p.target.lon > p.source.lon && p.location.lon > p.target.lon || (p.target.lat < p.source.lat && p.location.lat < p.target.lat || p.target.lon < p.source.lon && p.location.lon < p.target.lon)) {
          p.location.lat = p.source.lat;
          p.location.lon = p.source.lon;
        }
        const pos = map5 === null || map5 === void 0 ? void 0 : map5.latLngToLayerPoint([p.location.lat, p.location.lon]);
        const orthogonalArcShift = -(Math.pow(zoomLevel, 2) * fullDist / 8) * Math.cos(Math.PI / 2 * (fullDist / 2 - remainedDist) / (fullDist / 2)) || 0;
        p.x = (pos === null || pos === void 0 ? void 0 : pos.x) - this.panningOffset.x;
        p.y = (pos === null || pos === void 0 ? void 0 : pos.y) + orthogonalArcShift - this.panningOffset.y;
      }
      this.renderer.updatePointsPosition(this.particles);
      this.renderer.draw();
      this.animate();
    });
  }
  getPointByScreenPos(x3, y3) {
    const map5 = this.leafletMapInstance;
    for (const flow of this.flows) {
      const lat = getNumber(flow, this.config.sourceLatitude);
      const lon = getNumber(flow, this.config.sourceLongitude);
      const r = getNumber(flow, this.config.sourcePointRadius);
      const pos = map5 === null || map5 === void 0 ? void 0 : map5.latLngToLayerPoint([lat, lon]);
      const posX = pos.x - this.panningOffset.x;
      const posY = pos.y - this.panningOffset.y;
      if (Math.abs(x3 - posX) < r && Math.abs(y3 - posY) < r) {
        return [flow, posX, posY];
      }
    }
    return [];
  }
  onCanvasMouseMove(event) {
    var _a, _b;
    const { config } = this;
    this.canvasElement.style.removeProperty("cursor");
    const [hoveredPoint, x3, y3] = this.getPointByScreenPos(event.offsetX, event.offsetY);
    if (hoveredPoint)
      this.canvasElement.style.cursor = "default";
    if (this.hoveredSourcePoint !== hoveredPoint) {
      if (hoveredPoint)
        (_a = config.onSourcePointMouseEnter) === null || _a === void 0 ? void 0 : _a.call(config, hoveredPoint, x3, y3, event);
      if (this.hoveredSourcePoint)
        (_b = config.onSourcePointMouseLeave) === null || _b === void 0 ? void 0 : _b.call(config, this.hoveredSourcePoint, event);
      this.hoveredSourcePoint = hoveredPoint;
    }
  }
  onCanvasClick(event) {
    var _a;
    const { config } = this;
    const [clickedPoint, x3, y3] = this.getPointByScreenPos(event.offsetX, event.offsetY);
    if (clickedPoint)
      (_a = config.onSourcePointClick) === null || _a === void 0 ? void 0 : _a.call(config, clickedPoint, x3, y3, event);
  }
  onMapMove(leaflet) {
    const shift = leaflet.containerPointToLayerPoint([0, 0]);
    this.panningOffset.x = shift.x;
    this.panningOffset.y = shift.y;
    this.canvasElement.style.transform = `translate(${shift.x}px, ${shift.y}px)`;
  }
  destroy() {
    var _a, _b, _c, _d;
    (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    (_b = this.renderer) === null || _b === void 0 ? void 0 : _b.destroy();
    (_c = this.canvasElement) === null || _c === void 0 ? void 0 : _c.removeEventListener("mousemove", this.onCanvasMouseMoveBound);
    (_d = this.canvasElement) === null || _d === void 0 ? void 0 : _d.removeEventListener("click", this.onCanvasClickBound);
    super.destroy();
  }
  // Leaflet Map useful methods
  selectPointById(id2, centerPoint = false) {
    this.leafletMap.selectPointById(id2, centerPoint);
  }
  getSelectedPointId() {
    return this.leafletMap.getSelectedPointId();
  }
  unselectPoint() {
    this.leafletMap.unselectPoint();
  }
  zoomToPointById(id2, selectNode = false, customZoomLevel) {
    this.leafletMap.zoomToPointById(id2, selectNode, customZoomLevel);
  }
  zoomIn(increment = 1) {
    this.leafletMap.zoomIn(increment);
  }
  zoomOut(increment = 1) {
    this.leafletMap.zoomOut(increment);
  }
  setZoom(zoomLevel) {
    this.leafletMap.setZoom(zoomLevel);
  }
  fitView() {
    const points3 = [];
    for (const point13 of this.points) {
      points3.push({
        lat: getNumber(point13, this.config.pointLatitude),
        lon: getNumber(point13, this.config.pointLongitude)
      });
    }
    for (const flow of this.flows) {
      const source = {
        lat: getNumber(flow, this.config.sourceLatitude),
        lon: getNumber(flow, this.config.sourceLongitude)
      };
      const target = {
        lat: getNumber(flow, this.config.targetLatitude),
        lon: getNumber(flow, this.config.targetLongitude)
      };
      points3.push(source);
      points3.push(target);
    }
    const boundsArray = getDataLatLngBounds(points3, (d) => d.lat, (d) => d.lon, 0);
    const bounds = {
      northEast: { lat: boundsArray[0][0], lng: boundsArray[1][1] },
      southWest: { lat: boundsArray[1][0], lng: boundsArray[0][1] }
    };
    this.leafletMap.fitToBounds(bounds);
  }
};
LeafletFlowMap.selectors = LeafletMap.selectors;

// node_modules/@unovis/ts/components/chord-diagram/types.js
var ChordLabelAlignment;
(function(ChordLabelAlignment2) {
  ChordLabelAlignment2["Along"] = "along";
  ChordLabelAlignment2["Perpendicular"] = "perpendicular";
})(ChordLabelAlignment || (ChordLabelAlignment = {}));

// node_modules/@unovis/ts/components/chord-diagram/config.js
var ChordDiagramDefaultConfig = Object.assign(Object.assign({}, ComponentDefaultConfig), { duration: 800, highlightedNodeId: void 0, highlightedLinkIds: [], linkColor: void 0, linkValue: (d) => d.value, nodeLevels: [], nodeWidth: 15, nodeColor: (d) => d.color, nodeLabel: (d) => {
  var _a;
  return (_a = d.label) !== null && _a !== void 0 ? _a : d.key;
}, nodeLabelColor: void 0, nodeLabelAlignment: ChordLabelAlignment.Along, padAngle: 0.02, cornerRadius: 2, angleRange: [0, 2 * Math.PI], radiusScaleExponent: 2 });

// node_modules/@unovis/ts/components/chord-diagram/modules/node.js
function createNode(selection2) {
  selection2.style("opacity", 0).each((d, i, els) => {
    const arcNode = els[i];
    const angleCenter = (d.x0 + d.x1) / 2;
    const angleHalfWidth = (d.x1 - d.x0) / 2;
    arcNode._animState = {
      x0: angleCenter - angleHalfWidth * 0.8,
      x1: angleCenter + angleHalfWidth * 0.8,
      y0: d.y0,
      y1: d.y1
    };
  });
}
function updateNode(selection2, config, arcGen, duration) {
  const nodeColor = (d) => getColor(d.data, config.nodeColor, d.height);
  selection2.attr("id", (d) => d.uid).style("transition", `fill ${duration}ms`).style("fill", nodeColor).style("stroke", nodeColor);
  if (duration) {
    const transition2 = smartTransition(selection2, duration).style("opacity", 1);
    transition2.attrTween("d", (d, i, els) => {
      const arcNode = els[i];
      const nextAnimState = { x0: d.x0, x1: d.x1, y0: d.y0, y1: d.y1 };
      const datum2 = value_default(arcNode._animState, nextAnimState);
      return (t) => {
        arcNode._animState = datum2(t);
        return arcGen(arcNode._animState);
      };
    });
  } else {
    selection2.attr("d", (d) => arcGen(d)).style("opacity", 1);
  }
}
function removeNode(selection2, duration) {
  smartTransition(selection2, duration).style("opacity", 0).remove();
}

// node_modules/@unovis/ts/components/chord-diagram/style.js
var style_exports15 = {};
__export(style_exports15, {
  background: () => background5,
  highlightedLink: () => highlightedLink,
  highlightedNode: () => highlightedNode,
  label: () => label6,
  labelExit: () => labelExit,
  labelText: () => labelText,
  labels: () => labels3,
  link: () => link5,
  links: () => links3,
  node: () => node2,
  nodes: () => nodes2,
  root: () => root17,
  transparent: () => transparent,
  variables: () => variables8
});
var root17 = css`
  label: chord-diagram-component;
`;
var variables8 = injectGlobal`
  :root {
    --vis-chord-diagram-link-fill-color: #cad5f6;
    --vis-chord-diagram-link-stroke-color: #777777;
    --vis-chord-diagram-link-opacity: 0.5;
    --vis-chord-diagram-link-stroke-opacity: 0.15;
    --vis-chord-diagram-link-highlighted-opacity: 0.9;
    --vis-chord-diagram-link-dimmed-opacity: 0.25;

    --vis-chord-diagram-node-highlighted-opacity: 0.9;
    --vis-chord-diagram-node-dimmed-opacity: 0.25;

    --vis-chord-diagram-label-text-fill-color-bright: #ffffff;
    --vis-chord-diagram-label-text-fill-color-dark: #a5abb2;
    --vis-chord-diagram-label-text-font-size: 1em;

    --vis-dark-chord-diagram-link-fill-color: #575c65;
  }

  body.theme-dark ${`.${root17}`} {
    --vis-chord-diagram-link-fill-color: var(--vis-dark-chord-diagram-link-fill-color);
  }
`;
var background5 = css`
  label: background;
`;
var nodes2 = css`
  label: nodes;
`;
var links3 = css`
  label: links;
`;
var labels3 = css`
  label: labels;
`;
var node2 = css`
  label: node;
  stroke-width: 0;
  fill: var(--vis-color-main);
  stroke: var(--vis-color-main);
  transition: .1s fill-opacity;
`;
var highlightedNode = css`
  label: highlighted;
  fill-opacity: var(--vis-chord-diagram-node-highlighted-opacity);
  stroke-width: 1.5;
`;
var label6 = css`
  label: label;
`;
var labelText = css`
  label: label-text;

  dominant-baseline: middle;
  user-select: none;
  font-size: var(--vis-chord-diagram-label-text-font-size);
  
  > textPath {
    dominant-baseline: central;
  }
`;
var labelExit = css`
  label: label-exit;
`;
var link5 = css`
  label: link;

  fill: var(--vis-chord-diagram-link-fill-color);
  fill-opacity: var(--vis-chord-diagram-link-opacity);
  stroke: var(--vis-chord-diagram-link-stroke-color);
  stroke-opacity:  var(--vis-chord-diagram-link-stroke-opacity);
  transition: .1s fill-opacity;
`;
var highlightedLink = css`
  label: highlighted;
  fill-opacity: var(--vis-chord-diagram-link-highlighted-opacity);
`;
var transparent = css`
  label: transparent;

  ${`.${link5}`}:not(${`.${highlightedLink}`}) {
    fill-opacity: var(--vis-chord-diagram-link-dimmed-opacity);
  }

  ${`.${node2}`}:not(${`.${highlightedNode}`}) {
    fill-opacity: var(--vis-chord-diagram-node-dimmed-opacity);
  }
`;

// node_modules/@unovis/ts/components/chord-diagram/modules/label.js
var LABEL_PADDING = 3;
function getLabelFillColor(d, config) {
  var _a;
  const nodeLabelAlignment = (_a = getValue(d.data, config.nodeLabelAlignment)) !== null && _a !== void 0 ? _a : ChordLabelAlignment.Along;
  switch (nodeLabelAlignment) {
    case ChordLabelAlignment.Perpendicular: {
      return getColor(d.data, config.nodeColor, d.height);
    }
    case ChordLabelAlignment.Along: {
      const c3 = getColor(d.data, config.nodeColor, d.height);
      const colorParsed = color(c3);
      const brightness = colorParsed ? hexToBrightness(colorParsed.hex()) : 0;
      return brightness > 0.65 ? "var(--vis-chord-diagram-label-text-fill-color-dark)" : "var(--vis-chord-diagram-label-text-fill-color-bright)";
    }
  }
}
function getLabelTextAnchor2(d, config) {
  var _a;
  const nodeLabelAlignment = (_a = getValue(d.data, config.nodeLabelAlignment)) !== null && _a !== void 0 ? _a : ChordLabelAlignment.Along;
  switch (nodeLabelAlignment) {
    case ChordLabelAlignment.Perpendicular: {
      const angleCenter = (d.x0 + d.x1) / 2;
      const angleDegree = angleCenter * 180 / Math.PI;
      return angleDegree < 180 ? "start" : "end";
    }
    case ChordLabelAlignment.Along: {
      return null;
    }
  }
}
function getLabelTransform(d, config, radiusScale) {
  var _a;
  const nodeLabelAlignment = (_a = getValue(d.data, config.nodeLabelAlignment)) !== null && _a !== void 0 ? _a : ChordLabelAlignment.Along;
  switch (nodeLabelAlignment) {
    case ChordLabelAlignment.Perpendicular: {
      const r = radiusScale(d.y1) + LABEL_PADDING;
      const angleCenter = (d.x0 + d.x1) / 2;
      const angle = angleCenter - Math.PI / 2;
      const x3 = r * Math.cos(angle);
      const y3 = r * Math.sin(angle);
      return `translate(${x3}, ${y3})`;
    }
    case ChordLabelAlignment.Along:
      return null;
  }
}
function createLabel(selection2, config, radiusScale) {
  selection2.style("opacity", 0).attr("transform", (d) => getLabelTransform(d, config, radiusScale));
  selection2.append("text").attr("class", labelText).style("fill", (d) => getColor(d.data, config.nodeColor, d.height));
}
function updateLabel(selection2, config, width, radiusScale, duration) {
  const { nodeLabel, nodeLabelColor, nodeWidth } = config;
  smartTransition(selection2, duration).attr("transform", (d) => getLabelTransform(d, config, radiusScale)).style("opacity", 1);
  const label10 = selection2.select(`.${labelText}`);
  label10.selectAll("textPath").remove();
  label10.text((d) => getString(d.data, nodeLabel)).style("transition", `fill ${duration}ms`).style("fill", (d) => {
    var _a;
    return (_a = getColor(d.data, nodeLabelColor)) !== null && _a !== void 0 ? _a : getLabelFillColor(d, config);
  }).style("text-anchor", (d) => getLabelTextAnchor2(d, config)).each((d, i, elements) => {
    var _a;
    const nodeLabelAlignment = (_a = getValue(d.data, config.nodeLabelAlignment)) !== null && _a !== void 0 ? _a : ChordLabelAlignment.Along;
    const radianArcLength = d.x1 - d.x0 - getNumber(d.data, config.padAngle) * 2;
    const radius = radiusScale(d.y1) - getNumber(d, config.nodeWidth) / 2;
    const arcLength = radius * radianArcLength;
    const maxWidth = nodeLabelAlignment === ChordLabelAlignment.Along ? arcLength : width - LABEL_PADDING * 2;
    const textElement = select_default2(elements[i]).call(trimSVGText, maxWidth).attr("dx", nodeLabelAlignment === ChordLabelAlignment.Along ? LABEL_PADDING : null).attr("dy", nodeLabelAlignment === ChordLabelAlignment.Along ? getNumber(d.data, nodeWidth) / 2 : null);
    const textWidth = textElement.node().getComputedTextLength();
    const labelText4 = textElement.text();
    if (nodeLabelAlignment === ChordLabelAlignment.Along) {
      textElement.text("");
      if (textWidth <= maxWidth) {
        textElement.append("textPath").attr("href", `#${d.uid}`).text(labelText4);
      }
    }
  });
  smartTransition(label10, duration).attr("transform", (d) => {
    const nodeLabelAlignment = getValue(d.data, config.nodeLabelAlignment);
    if (nodeLabelAlignment !== ChordLabelAlignment.Perpendicular)
      return null;
    const angleCenter = (d.x0 + d.x1) / 2;
    const angleDegree = angleCenter * 180 / Math.PI;
    return `rotate(${angleDegree < 180 ? angleDegree - 90 : angleDegree + 90})`;
  });
}
function removeLabel(selection2, duration) {
  smartTransition(selection2, duration).style("opacity", 0).remove();
}

// node_modules/@unovis/ts/components/chord-diagram/modules/layout.js
function transformData(node4) {
  const { height, depth } = node4;
  if (height > 0) {
    const d = node4.data;
    const n = node4;
    n.data = { key: d[0], values: d[1], depth, height, ancestors: n.ancestors().map((d2) => d2.data.key) };
  }
}
function getHierarchyNodes(data, value2, levels = []) {
  const nodeLevels = levels.map((level) => (d) => d[level]);
  const nestedData = levels.length ? group(data, ...nodeLevels) : { key: "root", children: data };
  const root25 = hierarchy(nestedData).sum((d) => getNumber(d, value2)).each(transformData);
  return root25;
}
function positionChildren(node4, padding, scalingCoeff = 0.95) {
  if (!node4.children)
    return;
  const containsLinks = node4.value > 0;
  const length = node4.x1 - node4.x0;
  const scaledLength = length * (node4.y0 === 0 ? 1 : scalingCoeff);
  const delta = length - scaledLength;
  const padAngle = containsLinks ? padding : scaledLength / node4.children.length;
  const positions = pie_default().startAngle(node4.x0 + delta / 2).endAngle(node4.x1 - delta / 2).padAngle(padAngle).value((d) => containsLinks ? d.value : 1).sort((a4, b) => node4.children.indexOf(a4) - node4.children.indexOf(b))(node4.children);
  node4.children.forEach((child, i) => {
    const x06 = positions[i].startAngle;
    const x13 = positions[i].endAngle;
    const childDelta = (x13 - x06) * (1 - scalingCoeff);
    const xmid = (x06 + x13) / 2;
    child.x0 = containsLinks ? x06 + childDelta / 2 : xmid - padding / 2;
    child.x1 = containsLinks ? x13 - childDelta / 2 : xmid + padding / 2;
  });
}
function getRibbons(data, links5, padding) {
  const groupedBySource = groupBy(links5, (d) => d.source._id);
  const groupedByTarget = groupBy(links5, (d) => d.target._id);
  const leafNodes = data.leaves();
  const leafNodesById = index(leafNodes, (d) => d.data._id);
  const getNodesInRibbon = (source, target, partitionHeight, nodes4 = []) => {
    nodes4[source.height] = source;
    nodes4[partitionHeight * 2 - target.height] = target;
    if (source.parent && target.parent)
      getNodesInRibbon(source.parent, target.parent, partitionHeight, nodes4);
    return nodes4;
  };
  const calculatePoints = (links6, type2, depth, maxDepth2) => {
    links6.forEach((link7) => {
      var _a;
      if (!link7._state.points)
        link7._state.points = [];
      const sourceLeaf = leafNodesById.get(link7.source._id);
      const targetLeaf = leafNodesById.get(link7.target._id);
      const nodesInRibbon = getNodesInRibbon(type2 === "out" ? sourceLeaf : targetLeaf, type2 === "out" ? targetLeaf : sourceLeaf, maxDepth2);
      const currNode = nodesInRibbon[depth];
      const len = currNode.x1 - currNode.x0 - padding;
      const x06 = (_a = currNode._prevX1) !== null && _a !== void 0 ? _a : currNode.x0 + padding / 2;
      const x13 = x06 + len * link7._state.value / currNode.value;
      currNode._prevX1 = x13;
      const pointIdx = type2 === "out" ? depth : maxDepth2 * 2 - 1 - depth;
      link7._state.points[pointIdx] = { a0: x06, a1: x13, r: currNode.y1 };
    });
  };
  leafNodes.forEach((leafNode) => {
    const outLinks = groupedBySource[leafNode.data._id] || [];
    const inLinks = groupedByTarget[leafNode.data._id] || [];
    for (let depth = 0; depth < leafNode.depth; depth += 1) {
      calculatePoints(outLinks, "out", depth, leafNode.depth);
      calculatePoints(inLinks, "in", depth, leafNode.depth);
    }
  });
  return links5.map((l) => ({
    source: leafNodesById.get(l.source._id),
    target: leafNodesById.get(l.target._id),
    data: l,
    points: l._state.points,
    _state: {}
  }));
}

// node_modules/d3-chord/src/math.js
var abs6 = Math.abs;
var cos5 = Math.cos;
var sin5 = Math.sin;
var pi8 = Math.PI;
var halfPi6 = pi8 / 2;
var tau8 = pi8 * 2;
var epsilon10 = 1e-12;

// node_modules/d3-chord/src/array.js
var slice4 = Array.prototype.slice;

// node_modules/d3-chord/src/constant.js
function constant_default11(x3) {
  return function() {
    return x3;
  };
}

// node_modules/d3-chord/src/ribbon.js
function defaultSource(d) {
  return d.source;
}
function defaultTarget(d) {
  return d.target;
}
function defaultRadius(d) {
  return d.radius;
}
function defaultStartAngle(d) {
  return d.startAngle;
}
function defaultEndAngle(d) {
  return d.endAngle;
}
function defaultPadAngle() {
  return 0;
}
function ribbon(headRadius) {
  var source = defaultSource, target = defaultTarget, sourceRadius = defaultRadius, targetRadius = defaultRadius, startAngle = defaultStartAngle, endAngle = defaultEndAngle, padAngle = defaultPadAngle, context = null;
  function ribbon2() {
    var buffer, s3 = source.apply(this, arguments), t = target.apply(this, arguments), ap = padAngle.apply(this, arguments) / 2, argv = slice4.call(arguments), sr = +sourceRadius.apply(this, (argv[0] = s3, argv)), sa0 = startAngle.apply(this, argv) - halfPi6, sa1 = endAngle.apply(this, argv) - halfPi6, tr = +targetRadius.apply(this, (argv[0] = t, argv)), ta0 = startAngle.apply(this, argv) - halfPi6, ta1 = endAngle.apply(this, argv) - halfPi6;
    if (!context) context = buffer = path();
    if (ap > epsilon10) {
      if (abs6(sa1 - sa0) > ap * 2 + epsilon10) sa1 > sa0 ? (sa0 += ap, sa1 -= ap) : (sa0 -= ap, sa1 += ap);
      else sa0 = sa1 = (sa0 + sa1) / 2;
      if (abs6(ta1 - ta0) > ap * 2 + epsilon10) ta1 > ta0 ? (ta0 += ap, ta1 -= ap) : (ta0 -= ap, ta1 += ap);
      else ta0 = ta1 = (ta0 + ta1) / 2;
    }
    context.moveTo(sr * cos5(sa0), sr * sin5(sa0));
    context.arc(0, 0, sr, sa0, sa1);
    if (sa0 !== ta0 || sa1 !== ta1) {
      if (headRadius) {
        var hr = +headRadius.apply(this, arguments), tr2 = tr - hr, ta2 = (ta0 + ta1) / 2;
        context.quadraticCurveTo(0, 0, tr2 * cos5(ta0), tr2 * sin5(ta0));
        context.lineTo(tr * cos5(ta2), tr * sin5(ta2));
        context.lineTo(tr2 * cos5(ta1), tr2 * sin5(ta1));
      } else {
        context.quadraticCurveTo(0, 0, tr * cos5(ta0), tr * sin5(ta0));
        context.arc(0, 0, tr, ta0, ta1);
      }
    }
    context.quadraticCurveTo(0, 0, sr * cos5(sa0), sr * sin5(sa0));
    context.closePath();
    if (buffer) return context = null, buffer + "" || null;
  }
  if (headRadius) ribbon2.headRadius = function(_) {
    return arguments.length ? (headRadius = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : headRadius;
  };
  ribbon2.radius = function(_) {
    return arguments.length ? (sourceRadius = targetRadius = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : sourceRadius;
  };
  ribbon2.sourceRadius = function(_) {
    return arguments.length ? (sourceRadius = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : sourceRadius;
  };
  ribbon2.targetRadius = function(_) {
    return arguments.length ? (targetRadius = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : targetRadius;
  };
  ribbon2.startAngle = function(_) {
    return arguments.length ? (startAngle = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : startAngle;
  };
  ribbon2.endAngle = function(_) {
    return arguments.length ? (endAngle = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : endAngle;
  };
  ribbon2.padAngle = function(_) {
    return arguments.length ? (padAngle = typeof _ === "function" ? _ : constant_default11(+_), ribbon2) : padAngle;
  };
  ribbon2.source = function(_) {
    return arguments.length ? (source = _, ribbon2) : source;
  };
  ribbon2.target = function(_) {
    return arguments.length ? (target = _, ribbon2) : target;
  };
  ribbon2.context = function(_) {
    return arguments.length ? (context = _ == null ? null : _, ribbon2) : context;
  };
  return ribbon2;
}
function ribbon_default() {
  return ribbon();
}

// node_modules/@unovis/ts/components/chord-diagram/modules/link.js
function emptyPath() {
  return "M0,0 L0,0";
}
var ribbonGen = ribbon_default().source((d) => d[0]).target((d) => d[d.length - 1]).startAngle((d) => d.a0).endAngle((d) => d.a1);
var areaGen = areaRadial_default().curve(Curve.catmullRom.alpha(0.5)).startAngle((d, i, points3) => i < points3.length / 2 ? d.a1 : d.a0).endAngle((d, i, points3) => i < points3.length / 2 ? d.a0 : d.a1);
function linkGen(points3, radiusScale) {
  var _a;
  const link7 = points3.length === 2 ? ribbonGen : areaGen;
  link7.radius((d) => radiusScale(d.r));
  const linkPath3 = link7(points3);
  if (points3.length === 2)
    return linkPath3;
  const area2 = linkPath3.slice(0, -1);
  const path3 = area2.concat(`L${(_a = area2.match(/M-?\d*\.?\d*[,\s*]-?\d*\.?\d*/)) === null || _a === void 0 ? void 0 : _a[0].slice(1)}`);
  const radius = Math.max(radiusScale(points3[0].r), 0);
  return convertLineToArc(path3, radius);
}
function createLink(selection2, radiusScale) {
  selection2.attr("d", (d) => linkGen(d.points, radiusScale) || emptyPath()).style("opacity", 0);
}
function updateLink(selection2, config, radiusScale, duration) {
  selection2.style("transition", `fill ${duration}ms`).style("fill", (d) => getColor(d.data, config.linkColor)).style("stroke", (d) => getColor(d.data, config.linkColor));
  const transition2 = smartTransition(selection2, duration).style("opacity", 1);
  if (duration) {
    transition2.attrTween("d", (d, i, el) => {
      const previous = select_default2(el[i]).attr("d");
      const next = linkGen(d.points, radiusScale) || emptyPath();
      return interpolatePath(previous, next);
    });
  } else {
    transition2.attr("d", (d) => linkGen(d.points, radiusScale) || emptyPath());
  }
}
function removeLink(selection2, duration) {
  smartTransition(selection2, duration).style("opacity", 0).remove();
}

// node_modules/@unovis/ts/components/chord-diagram/index.js
var ChordDiagram = class _ChordDiagram extends ComponentCore {
  constructor(config) {
    super();
    this._defaultConfig = ChordDiagramDefaultConfig;
    this.config = this._defaultConfig;
    this.datamodel = new GraphDataModel();
    this.arcGen = arc_default();
    this.radiusScale = pow();
    this.events = {
      [_ChordDiagram.selectors.node]: {
        mouseover: this._onNodeMouseOver.bind(this),
        mouseout: this._onNodeMouseOut.bind(this)
      },
      [_ChordDiagram.selectors.link]: {
        mouseover: this._onLinkMouseOver.bind(this),
        mouseout: this._onLinkMouseOut.bind(this)
      },
      [_ChordDiagram.selectors.label]: {
        mouseover: this._onNodeMouseOver.bind(this),
        mouseout: this._onNodeMouseOut.bind(this)
      }
    };
    this._nodes = [];
    this._links = [];
    if (config)
      this.setConfig(config);
    this.background = this.g.append("rect").attr("class", background5);
    this.linkGroup = this.g.append("g").attr("class", links3);
    this.nodeGroup = this.g.append("g").attr("class", nodes2);
    this.labelGroup = this.g.append("g").attr("class", labels3);
  }
  get _forceHighlight() {
    var _a;
    return this.config.highlightedNodeId !== void 0 || ((_a = this.config.highlightedLinkIds) === null || _a === void 0 ? void 0 : _a.length) > 0;
  }
  get bleed() {
    const { config } = this;
    const padding = LABEL_PADDING * 2;
    let top2 = 0;
    let bottom2 = 0;
    let right3 = 0;
    let left3 = 0;
    this._nodes.forEach((n) => {
      var _a;
      const nodeLabelAlignment = getValue(n.data, config.nodeLabelAlignment);
      if (n.height === 0 && nodeLabelAlignment === ChordLabelAlignment.Perpendicular) {
        const label10 = (_a = getString(n.data, config.nodeLabel)) !== null && _a !== void 0 ? _a : "";
        const fontSize = getCSSVariableValueInPixels("var(--vis-chord-diagram-label-text-font-size)", this.element);
        const labelWidth = estimateStringPixelLength(label10, fontSize);
        const [x3, y3] = this.arcGen.centroid(n);
        if (x3 < 0)
          left3 = Math.max(left3, labelWidth);
        else
          right3 = Math.max(right3, labelWidth);
        if (y3 < 0)
          top2 = Math.max(top2, labelWidth);
        else
          bottom2 = Math.max(bottom2, labelWidth);
      }
    });
    left3 += padding;
    right3 += padding;
    bottom2 += padding;
    top2 += padding;
    return { top: top2, bottom: bottom2, left: left3, right: right3 };
  }
  setSize(width, height, containerWidth, containerHeight) {
    super.setSize(width, height, containerWidth, containerHeight);
    this.radiusScale.exponent(this.config.radiusScaleExponent).range([0, Math.min(width, height) / 2]);
  }
  setData(data) {
    super.setData(data);
    this._layoutData();
  }
  _layoutData() {
    const { nodes: nodes4, links: links5 } = this.datamodel;
    const { padAngle, linkValue, nodeLevels } = this.config;
    nodes4.forEach((n) => {
      delete n._state.value;
    });
    links5.forEach((l) => {
      delete l._state.points;
      l._state.value = getNumber(l, linkValue);
      l.source._state.value = (l.source._state.value || 0) + getNumber(l, linkValue);
      l.target._state.value = (l.target._state.value || 0) + getNumber(l, linkValue);
    });
    const root25 = getHierarchyNodes(nodes4, (d) => {
      var _a;
      return (_a = d._state) === null || _a === void 0 ? void 0 : _a.value;
    }, nodeLevels);
    const partitionData = partition_default().size([this.config.angleRange[1], 1])(root25);
    partitionData.each((n, i) => {
      positionChildren(n, padAngle);
      n.uid = `${this.uid.substr(0, 4)}-${i}`;
      n.x0 = Number.isNaN(n.x0) ? 0 : n.x0;
      n.x1 = Number.isNaN(n.x1) ? 0 : n.x1;
      n._state = {};
    });
    const partitionDataWithRoot = partitionData.descendants();
    this._rootNode = partitionDataWithRoot.find((d) => d.depth === 0);
    this._nodes = partitionDataWithRoot.filter((d) => d.depth !== 0);
    this._links = getRibbons(partitionData, links5, padAngle);
  }
  _render(customDuration) {
    var _a;
    super._render(customDuration);
    const { config, bleed } = this;
    this._layoutData();
    const duration = isNumber(customDuration) ? customDuration : config.duration;
    const size2 = Math.min(this._width, this._height);
    const radius = size2 / 2 - max([bleed.top, bleed.bottom, bleed.left, bleed.right]);
    const numLevels = 1 + ((_a = config.nodeLevels) === null || _a === void 0 ? void 0 : _a.length);
    const maxSpace = config.nodeWidth * numLevels;
    const nodeWidth = radius > maxSpace ? config.nodeWidth : Math.max(radius / numLevels, 0);
    this.radiusScale.range([0, Math.max(radius, 0)]);
    this.arcGen.startAngle((d) => d.x0 + config.padAngle / 2 - (d.value ? 0 : Math.PI / 360)).endAngle((d) => d.x1 - config.padAngle / 2 + (d.value ? 0 : Math.PI / 360)).cornerRadius((d) => getNumber(d.data, config.cornerRadius)).innerRadius((d) => Math.max(this.radiusScale(d.y1) - nodeWidth, 0)).outerRadius((d) => this.radiusScale(d.y1));
    this.g.classed(transparent, this._forceHighlight);
    this.background.attr("width", this._width).attr("height", this._height).style("opacity", 0);
    this.nodeGroup.attr("transform", `translate(${this._width / 2},${this._height / 2})`);
    this.labelGroup.attr("transform", `translate(${this._width / 2},${this._height / 2})`);
    this.linkGroup.attr("transform", `translate(${this._width / 2},${this._height / 2})`);
    const linksSelection = this.linkGroup.selectAll(`.${link5}`).data(this._links, (d) => String(d.data._id));
    const linksEnter = linksSelection.enter().append("path").attr("class", link5).call(createLink, this.radiusScale);
    const linksMerged = linksSelection.merge(linksEnter).classed(highlightedLink, (l) => {
      var _a2, _b;
      const linkId = (_a2 = l.data.id) !== null && _a2 !== void 0 ? _a2 : l.data._indexGlobal;
      return (_b = config.highlightedLinkIds) === null || _b === void 0 ? void 0 : _b.includes(linkId);
    });
    linksMerged.call(updateLink, config, this.radiusScale, duration);
    linksSelection.exit().call(removeLink, duration);
    const nodesSelection = this.nodeGroup.selectAll(`.${node2}`).data(this._nodes, (d) => String(d.uid));
    const nodesEnter = nodesSelection.enter().append("path").attr("class", node2).call(createNode, config);
    const nodesMerged = nodesSelection.merge(nodesEnter).classed(highlightedNode, (d) => config.highlightedNodeId === d.data._id);
    nodesMerged.call(updateNode, config, this.arcGen, duration, this.bleed);
    nodesSelection.exit().call(removeNode, duration);
    const labelWidth = size2 - radius;
    const labels4 = this.labelGroup.selectAll(`.${label6}`).data(this._nodes, (d) => String(d.uid));
    const labelEnter = labels4.enter().append("g").attr("class", label6).call(createLabel, config, this.radiusScale);
    const labelsMerged = labels4.merge(labelEnter);
    labelsMerged.call(updateLabel, config, labelWidth, this.radiusScale, duration);
    labels4.exit().attr("class", labelExit).call(removeLabel, duration);
  }
  _onNodeMouseOver(d) {
    let ribbons;
    if (d.children) {
      const leaves = d.leaves();
      ribbons = this._links.filter((l) => leaves.find((leaf) => l.source.data.id === leaf.data.id || l.target.data.id === leaf.data.id));
    } else {
      const leaf = d;
      ribbons = this._links.filter((l) => l.source.data.id === leaf.data.id || l.target.data.id === leaf.data.id);
    }
    if (!ribbons.length)
      d._state.hovered = true;
    this._highlightOnHover(ribbons);
  }
  _onNodeMouseOut() {
    this._highlightOnHover();
  }
  _onLinkMouseOver(d) {
    this._highlightOnHover([d]);
  }
  _onLinkMouseOut() {
    this._highlightOnHover();
  }
  _highlightOnHover(links5) {
    if (this._forceHighlight)
      return;
    if (links5) {
      links5.forEach((l) => {
        l._state.hovered = true;
        const sourcePath = l.source.path(this._rootNode);
        const targetPath = l.target.path(this._rootNode);
        sourcePath.forEach((n) => {
          if (n.depth)
            n._state.hovered = true;
        });
        targetPath.forEach((n) => {
          if (n.depth)
            n._state.hovered = true;
        });
      });
    } else {
      this._nodes.forEach((n) => {
        delete n._state.hovered;
      });
      this._links.forEach((l) => {
        delete l._state.hovered;
      });
    }
    this.nodeGroup.selectAll(`.${node2}`).classed(highlightedNode, (d) => d._state.hovered);
    this.linkGroup.selectAll(`.${link5}`).classed(highlightedLink, (d) => d._state.hovered);
    this.g.classed(transparent, !!links5);
  }
};
ChordDiagram.selectors = style_exports15;

// node_modules/@unovis/ts/components/graph/types.js
var GraphLayoutType;
(function(GraphLayoutType2) {
  GraphLayoutType2["Circular"] = "circular";
  GraphLayoutType2["Concentric"] = "concentric";
  GraphLayoutType2["Parallel"] = "parallel";
  GraphLayoutType2["ParallelHorizontal"] = "parallel horizontal";
  GraphLayoutType2["Dagre"] = "dagre";
  GraphLayoutType2["Force"] = "force";
  GraphLayoutType2["Elk"] = "elk";
  GraphLayoutType2["Precalculated"] = "precalculated";
})(GraphLayoutType || (GraphLayoutType = {}));
var GraphLinkStyle;
(function(GraphLinkStyle2) {
  GraphLinkStyle2["Dashed"] = "dashed";
  GraphLinkStyle2["Solid"] = "solid";
})(GraphLinkStyle || (GraphLinkStyle = {}));
var GraphLinkArrowStyle;
(function(GraphLinkArrowStyle2) {
  GraphLinkArrowStyle2["Single"] = "single";
  GraphLinkArrowStyle2["Double"] = "double";
})(GraphLinkArrowStyle || (GraphLinkArrowStyle = {}));
var GraphNodeShape;
(function(GraphNodeShape2) {
  GraphNodeShape2["Circle"] = "circle";
  GraphNodeShape2["Square"] = "square";
  GraphNodeShape2["Hexagon"] = "hexagon";
  GraphNodeShape2["Triangle"] = "triangle";
})(GraphNodeShape || (GraphNodeShape = {}));

// node_modules/@unovis/ts/components/graph/config.js
var GraphDefaultConfig = Object.assign(Object.assign({}, ComponentDefaultConfig), { duration: 1e3, zoomScaleExtent: [0.35, 1.25], disableZoom: false, disableDrag: false, disableBrush: false, zoomThrottledUpdateNodeThreshold: 100, layoutType: GraphLayoutType.Force, layoutAutofit: true, layoutAutofitTolerance: 8, layoutNonConnectedAside: false, layoutGroupOrder: [], layoutParallelSubGroupsPerRow: 1, layoutParallelNodesPerColumn: 6, layoutParallelGroupSpacing: void 0, layoutParallelSortConnectionsByGroup: void 0, layoutNodeGroup: (n) => n.group, layoutParallelNodeSubGroup: (n) => n.subgroup, forceLayoutSettings: {
  linkDistance: 60,
  linkStrength: 0.45,
  charge: -500,
  forceXStrength: 0.15,
  forceYStrength: 0.25,
  numIterations: void 0,
  fixNodePositionAfterSimulation: false
}, dagreLayoutSettings: {
  rankdir: "BT",
  ranker: "longest-path"
}, layoutElkSettings: void 0, layoutElkNodeGroups: void 0, linkFlowAnimDuration: 2e4, linkFlowParticleSize: 2, linkWidth: 1, linkStyle: GraphLinkStyle.Solid, linkBandWidth: 0, linkArrow: void 0, linkStroke: void 0, linkFlow: false, linkLabel: void 0, linkLabelShiftFromCenter: true, linkNeighborSpacing: 8, linkDisabled: false, linkCurvature: 0, selectedLinkId: void 0, nodeGaugeAnimDuration: 1500, nodeSize: 30, nodeStrokeWidth: 3, nodeShape: GraphNodeShape.Circle, nodeGaugeValue: 0, nodeIcon: (n) => n.icon, nodeIconSize: void 0, nodeLabel: (n) => n.label, nodeLabelTrim: true, nodeLabelTrimLength: 15, nodeLabelTrimMode: TrimMode.Middle, nodeSubLabel: "", nodeSubLabelTrim: true, nodeSubLabelTrimLength: 15, nodeSubLabelTrimMode: TrimMode.Middle, nodeSideLabels: void 0, nodeBottomIcon: void 0, nodeDisabled: false, nodeFill: (n) => n.fill, nodeGaugeFill: void 0, nodeStroke: (n) => n.stroke, nodeEnterPosition: void 0, nodeEnterScale: 0.75, nodeExitPosition: void 0, nodeExitScale: 0.75, nodeSort: void 0, selectedNodeId: void 0, selectedNodeIds: void 0, panels: void 0, onNodeDragStart: void 0, onNodeDrag: void 0, onNodeDragEnd: void 0, onZoom: void 0, onLayoutCalculated: void 0, onNodeSelectionBrush: void 0, onNodeSelectionDrag: void 0 });

// node_modules/@unovis/ts/components/graph/modules/node/style.js
var style_exports16 = {};
__export(style_exports16, {
  brushable: () => brushable,
  brushed: () => brushed,
  customNode: () => customNode,
  draggable: () => draggable,
  gNode: () => gNode,
  gNodeExit: () => gNodeExit,
  greyedOutNode: () => greyedOutNode,
  label: () => label7,
  labelBackground: () => labelBackground2,
  labelText: () => labelText2,
  labelTextContent: () => labelTextContent,
  node: () => node3,
  nodeBottomIcon: () => nodeBottomIcon,
  nodeGauge: () => nodeGauge,
  nodeIcon: () => nodeIcon2,
  nodeIsDragged: () => nodeIsDragged,
  nodePolygon: () => nodePolygon,
  nodeSelection: () => nodeSelection,
  nodeSelectionActive: () => nodeSelectionActive,
  nodes: () => nodes3,
  sideLabel: () => sideLabel,
  sideLabelBackground: () => sideLabelBackground,
  sideLabelGroup: () => sideLabelGroup,
  sideLabelsGroup: () => sideLabelsGroup,
  subLabelTextContent: () => subLabelTextContent,
  variables: () => variables9
});
var nodes3 = css`
  label: nodes;
`;
var variables9 = injectGlobal`
  :root {
    /* Node Fill */
    --vis-graph-node-stroke-color: rgb(206, 211, 222);
    --vis-graph-node-fill-color: #fff;
    --vis-graph-node-gauge-color: #adb4c2;
    --vis-graph-node-selection-color: #acb3b8;

    --vis-dark-graph-node-stroke-color: rgba(30,30,30,.25);
    --vis-dark-graph-node-fill-color: #494b56;
    --vis-dark-graph-node-gauge-color: #989aa3;
    --vis-dark-graph-node-selection-color: #494b56;

    /* Node Central Icon */
    --vis-graph-node-icon-fill-color-bright: #ffffff;
    --vis-graph-node-icon-fill-color-dark: var(--vis-color-grey);
    --vis-graph-node-icon-fill-color: #9ea7b8;

    --vis-dark-graph-node-icon-fill-color: var(--vis-graph-node-icon-fill-color-bright);

    /* Node Bottom Icon */
    --vis-graph-node-bottom-icon-font-size: 14pt;
    --vis-graph-node-bottom-icon-fill-color: #a0a6ad;
    --vis-graph-node-bottom-icon-stroke-color: #fff;
    --vis-graph-node-bottom-icon-stroke-width: 2px;

    --vis-dark-graph-node-bottom-icon-fill-color: #a0a6ad;
    --vis-dark-graph-node-bottom-icon-stroke-color: #fff;

    /* Node Label */
    --vis-graph-node-label-font-size: 9pt;
    --vis-graph-node-label-background: #ffffff;
    --vis-graph-node-label-text-color: #0F1E57;
    --vis-graph-node-sublabel-text-color: #989aa3;
    --vis-graph-node-sublabel-font-size: 8pt;
    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-graph-node-label-font-family: */

    --vis-dark-graph-node-label-background: var(--vis-color-grey);
    --vis-dark-graph-node-label-text-color: #ffffff;
    --vis-dark-graph-node-sublabel-text-color: #989aa3;

    /* Node Side Labels (circular labels)*/
    --vis-graph-node-side-label-background-fill-color: #a0a9af;
    --vis-graph-node-side-label-background-stroke-color: #ffffff;
    --vis-graph-node-side-label-fill-color-bright: #ffffff;
    --vis-graph-node-side-label-fill-color-dark: #494b56;

    --vis-dark-graph-node-side-label-background-fill-color: #989aa3;
    --vis-dark-graph-node-side-label-background-stroke-color: var(--vis-color-grey);
    --vis-dark-graph-node-side-label-fill-color-bright: #f1f4f7;
    --vis-dark-graph-node-side-label-fill-color-dark: var(--vis-color-grey);

    /* Greyout */
    --vis-graph-node-greyout-opacity: 0.9;
    --vis-graph-node-greyout-filter: none;
    --vis-graph-node-greyout-color: #ebeff7;
    --vis-graph-node-icon-greyout-color: #c6cad1;
    --vis-graph-node-side-label-background-greyout-color: #f1f4f7;

    --vis-dark-graph-node-greyout-color: #494b56;
    --vis-dark-graph-node-icon-greyout-color: var(--vis-color-grey);
    --vis-dark-graph-node-side-label-background-greyout-color: #494B56;

    /* Brushed */
    --vis-graph-brushed-node-stroke-color: var(--vis-color-main);
    --vis-graph-brushed-node-label-text-color: var(--vis-color-main);
    --vis-graph-brushed-node-icon-fill-color: var(--vis-color-main);
    
    /* Misc */
    --vis-graph-node-dominant-baseline: middle;
  }

  body.theme-dark ${`.${nodes3}`} {
    --vis-graph-node-stroke-color: var(--vis-dark-graph-node-stroke-color);
    --vis-graph-node-fill-color: var(--vis-dark-graph-node-fill-color);
    --vis-graph-node-gauge-color: var(--vis-dark-graph-node-gauge-color);
    --vis-graph-node-selection-color: var(--vis-dark-graph-node-selection-color);

    --vis-graph-node-icon-fill-color: var(--vis-dark-graph-node-icon-fill-color);

    --vis-graph-node-bottom-icon-fill-color: var(--vis-dark-graph-node-bottom-icon-fill-color);
    --vis-graph-node-bottom-icon-stroke-color: var(--vis-dark-graph-node-bottom-icon-stroke-color);

    --vis-graph-node-label-background: var(--vis-dark-graph-node-label-background);
    --vis-graph-node-label-text-color: var(--vis-dark-graph-node-label-text-color);
    --vis-graph-node-sublabel-text-color: var(--vis-dark-graph-node-sublabel-text-color);

    --vis-graph-node-side-label-background-fill-color: var(--vis-dark-graph-node-side-label-background-fill-color);
    --vis-graph-node-side-label-background-stroke-color: var(--vis-dark-graph-side-label-background-stroke-color);
    --vis-graph-node-side-label-fill-color-bright: var(--vis-dark-graph-node-side-label-fill-color-bright);
    --vis-graph-node-side-label-fill-color-dark: var(vis-dark-graph-node-side-label-fill-color-dark);

    --vis-graph-node-greyout-color: var(--vis-dark-graph-node-greyout-color);
    --vis-graph-node-icon-greyout-color: var(--vis-dark-graph-node-icon-greyout-color);
    --vis-graph-node-side-label-background-greyout-color: var(--vis-dark-graph-node-side-label-background-greyout-color);
  }
`;
var brushable = css`
  label: brushable;
`;
var node3 = css`
  label: node-shape;

  stroke: var(--vis-graph-node-stroke-color);
  fill: var(--vis-graph-node-fill-color);

  :not(.${brushable}) {
    transition: .4s fill, 4s stroke;
  }
`;
var nodeIcon2 = css`
  label: icon;

  font-family: var(--vis-graph-icon-font-family), var(--vis-font-family);
  dominant-baseline: var(--vis-graph-node-dominant-baseline);
  text-anchor: middle;
  pointer-events: none;
  fill: var(--vis-graph-node-icon-fill-color);

  :not(.${brushable}) {
    transition: .4s all;
  }
`;
var nodeBottomIcon = css`
  label: node-bottom-icon;
  font-family: var(--vis-graph-icon-font-family), var(--vis-font-family);
  font-size: var(--vis-graph-node-bottom-icon-font-size);
  dominant-baseline: var(--vis-graph-node-dominant-baseline);
  text-anchor: middle;
  pointer-events: none;
  fill: var(--vis-graph-node-bottom-icon-fill-color);
  stroke: var(--vis-graph-node-bottom-icon-stroke-color);
  stroke-width: var(--vis-graph-node-bottom-icon-stroke-width);

  :not(.${brushable}) {
    transition: .4s all;
  }
`;
var nodeIsDragged = css`
  label: dragged;
`;
var label7 = css`
  label: label;

  text-anchor: middle;
  font-weight: 300;
  font-size: var(--vis-graph-node-label-font-size);
`;
var labelBackground2 = css`
  label: background;

  opacity: 0.9;
  -webkit-backdrop-filter: blur(2px);
  backdrop-filter: blur(2px);
  fill: var(--vis-graph-node-label-background);
`;
var labelText2 = css`
  label: label-text;
`;
var labelTextContent = css`
  label: label-text-content;

  fill: var(--vis-graph-node-label-text-color);
  font-family: var(--vis-graph-node-label-font-family, var(--vis-font-family));
`;
var subLabelTextContent = css`
  label: sublabel-text-content;

  fill: var(--vis-graph-node-sublabel-text-color);
  font-family: var(--vis-graph-node-label-font-family, var(--vis-font-family));
  font-size: var(--vis-graph-node-sublabel-font-size);
`;
var sideLabelsGroup = css`
  label: side-labels-group;
`;
var sideLabelBackground = css`
  label: side-label-background;

  stroke-opacity: 0.8;
  stroke: var(--vis-graph-node-side-label-background-stroke-color);
  fill: var(--vis-graph-node-side-label-background-fill-color);
`;
var sideLabel = css`
  label: side-label;

  font-family: var(--vis-graph-icon-font-family), var(--vis-font-family);
  dominant-baseline: var(--vis-graph-node-dominant-baseline);
  text-anchor: middle;
  font-size: 16px;
  fill: var(--vis-graph-node-side-label-fill-color-bright);
`;
var sideLabelGroup = css`
  label: side-label-group;
  cursor: default;
`;
var gNode = css`
  label: g-node;

  transition: .25s opacity;
`;
var draggable = css`
  label: draggable;

  &:hover {
    cursor: grab;
  }

  &${`.${nodeIsDragged}`} {
    cursor: grabbing;
  }
`;
var gNodeExit = css`
  label: g-node-exit;
  pointer-events: none;
`;
var nodeSelectionActive = css`
  label: active;
`;
var nodeSelection = css`
  label: node-selection;

  fill: none;
  stroke-width: 1;
  stroke-dasharray: 3 3;
  opacity: 0;
  transition: 350ms cubic-bezier(0.165, 0.840, 0.440, 1.000);
  transform: scale(.5);
  fill: var(--vis-graph-node-selection-color);
  fill-opacity: 0.1;
  stroke: var(--vis-graph-node-selection-color);
  stroke-opacity: 0.75;

  &${`.${nodeSelectionActive}`} {
    opacity: 1;
    transform: scale(1.2);
  }
`;
var nodeGauge = css`
  label: node-gauge;

  fill: var(--vis-graph-node-gauge-color);
  transition: .4s fill;
`;
var nodePolygon = css`
  label: polygon;

  ${`.${nodeGauge}`} {
    fill-opacity: 0;
    stroke-linecap: round;
    pointer-events: none;
  }
`;
var customNode = css`
  label: custom-node;

  stroke-width: 0;
`;
var greyedOutNode = css`
  label: greyed-out;
  opacity: var(--vis-graph-node-greyout-opacity);
  filter: var(--vis-graph-node-greyout-filter);

  ${`.${node3}`} {
    fill: var(--vis-graph-node-greyout-color) !important;
    stroke: var(--vis-graph-node-greyout-color) !important;
  }

  ${`.${nodeIcon2}`} {
     fill: var(--vis-graph-node-icon-greyout-color) !important;
  }

  ${`.${nodeGauge}`} {
    fill: var(--vis-graph-node-greyout-color) !important;
    stroke: var(--vis-graph-node-greyout-color) !important;
  }

  ${`.${label7}`} {
    opacity: 0.5;
  }

  ${`.${sideLabelBackground}`} {
     fill: var(--vis-graph-node-side-label-background-greyout-color) !important;
     stroke-opacity: 0.5;
   }

   ${`.${sideLabel}`} {
    fill: var(--vis-graph-node-side-label-fill-color-bright) !important;
    opacity: 0.25;
  }
`;
var brushed = css`
  label: brushed-node;

  ${`.${node3}`} {
    stroke: var(--vis-graph-brushed-node-stroke-color);
  }
  ${`.${nodeIcon2}`} {
    fill: var(--vis-graph-brushed-node-icon-fill-color);
  }
  ${`.${labelTextContent}`} {
    fill: var(--vis-graph-brushed-node-label-text-color);
  }
`;

// node_modules/@unovis/ts/components/graph/modules/link/style.js
var links4 = css`
  label: links;
`;
var variables10 = injectGlobal`
  :root {
    --vis-graph-link-stroke-color: #e6e9f3;
    --vis-graph-link-stroke-opacity: 1.0;
    --vis-graph-link-greyout-opacity: 0.3;
    --vis-graph-link-dashed-stroke-dasharray: 6 6;

    --vis-graph-link-label-font-size: 9pt;
    --vis-graph-link-label-background: #e6e9f3;
    --vis-graph-link-label-text-color-dark: #18181B;
    --vis-graph-link-label-text-color-bright: #fff;
    --vis-graph-link-label-text-color: var(--vis-graph-link-label-text-color-dark);

    --vis-graph-link-band-opacity: 0.35;
    --vis-graph-link-support-stroke-width: 10px;

    --vis-dark-graph-link-stroke-color: #494b56;
    --vis-dark-graph-link-label-background: #3f3f45;
    --vis-dark-graph-link-label-text-color: var(--vis-graph-link-label-text-color-bright);

    --vis-graph-link-dominant-baseline: middle;
  }

  body.theme-dark ${`.${links4}`} {
    --vis-graph-link-stroke-color: var(--vis-dark-graph-link-stroke-color);
    --vis-graph-link-label-stroke-color: var(--vis-dark-graph-link-label-stroke-color);
    --vis-graph-link-label-text-color: var(--vis-dark-graph-link-label-text-color);
    --vis-graph-link-label-background: var(--vis-dark-graph-link-label-background);
  }
`;
var linkSupport = css`
  label: link-support;

  fill: none;
  stroke-linecap: round;
  pointer-events: stroke;
  stroke-width: var(--vis-graph-link-support-stroke-width);
  stroke-opacity: 0;
  stroke: var(--vis-graph-link-stroke-color);
  transition: stroke-opacity 0.2s;
`;
var link6 = css`
  label: link;

  fill: none;
  stroke: var(--vis-graph-link-stroke-color);
  stroke-opacity: var(--vis-graph-link-stroke-opacity);
  transition: stroke 800ms;
  stroke-linecap: round;
  pointer-events: none;
`;
var linkDashed = css`
  label: dashed;

  ${`.${link6}`} {
    stroke-dasharray: var(--vis-graph-link-dashed-stroke-dasharray);
  }
`;
var linkArrow = css`
  label: link-arrow;
  fill: var(--vis-graph-link-stroke-color);
`;
var gLink = css`
  label: g-link;
`;
var gLinkExit = css`
  label: g-link-exit;
  pointer-events: none;
`;
var greyedOutLink = css`
  label: greyed-out;
  opacity: var(--vis-graph-link-greyout-opacity);
`;
var linkBand = css`
  label: link-band;

  stroke-opacity: var(--vis-graph-link-band-opacity);
  pointer-events: none;
  stroke: var(--vis-graph-node-stroke-color);
  fill: none;
`;
var flowGroup = css`
  label: flow-group;

  pointer-events: none;
`;
var flowCircle = css`
  label: flow-circle;

  fill: var(--vis-graph-link-stroke-color);
`;
var linkLabelGroup = css`
  label: label-group;
  pointer-events: all;
`;
var linkLabelBackground = css`
  label: label-background;

  fill: var(--vis-graph-link-label-background);
`;
var linkLabelContent = css`
  label: label-content;

  font-size: var(--vis-graph-link-label-font-size);
  font-family: var(--vis-font-family);
  fill: var(--vis-graph-link-label-text-color);
  text-anchor: middle;
  dominant-baseline: var(--vis-graph-link-dominant-baseline);
  user-select: none;
`;

// node_modules/@unovis/ts/components/graph/style.js
var variables11 = injectGlobal`
  :root {
    --vis-graph-icon-font-family: ${UNOVIS_ICON_FONT_FAMILY_DEFAULT};

    /* Brush */
    --vis-graph-brush-selection-opacity: 0.2;
  }
`;
var root18 = css`
  label: graph-component;
`;
var background6 = css`
  label: background;
`;
var graphGroup = css`
  label: graph-group;
`;
var brush3 = css`
  label: brush;

  :not(.active) {
    display: none;
  }

  .active {
    .selection {
      fill-opacity: 0;
      stroke: none;
    }

    .handle {
      display: none;
    }
  }
`;
var zoomOutLevel1 = css`
  label: zoom-out-level-1;

  ${`.${label7}`} {
    rect {
      stroke: none;
    }
  }
`;
var zoomOutLevel2 = css`
  label: zoom-out-level-2;

  ${`.${label7}`} {
    visibility: visible;
  }

  ${`.${nodeGauge}`} {
    visibility: visible;
  }

  ${`.${node3}`} {
    stroke-width: 4px;
  }

  rect${`.${node3}`} {
    stroke-width: 2px;
  }

  ${`.${gLink}`} {
    animation: none;
    stroke-dasharray: none;
  }

  ${`.${flowCircle}`} {
    display: none;
  }

  ${`.${nodeSelection}`} {
    &${`.${nodeSelectionActive}`} {
      transform: scale(1.15);
    }
  }
`;

// node_modules/@unovis/ts/components/graph/modules/panel/style.js
var panels = css`
  label: panels;
`;
var variables12 = injectGlobal`
  :root {
    --vis-graph-panel-border-color: #E6E9F3;
    --vis-graph-panel-border-opacity: 0.9;
    --vis-graph-panel-fill-color: #ffffff;

    --vis-graph-panel-label-color: #6c778c;
    --vis-graph-panel-label-background: #ffffff;

    // Undefined by default to allow proper fallback to var(--vis-font-family)
    /* --vis-graph-panel-label-font-family: */
    --vis-graph-panel-label-font-size: 10pt;
    --vis-graph-panel-label-font-weight: 300;

    --vis-graph-panel-dashed-outline-color: #b7b7b7;

    --vis-graph-panel-side-icon-symbol-color: #9ea7b8;
    --vis-graph-panel-side-icon-shape-fill-color: #ffffff;

    --vis-dark-graph-panel-border-color: var(--vis-color-grey);
    --vis-dark-graph-panel-fill-color: #292b34;
    --vis-dark-graph-panel-label-color: #E6E9F3;
    --vis-dark-graph-panel-label-background: var(--vis-color-grey);
    --vis-dark-graph-panel-side-icon-symbol-color: #ffffff;
    --vis-dark-graph-panel-side-icon-shape-fill-color: #6c778c;
    --vis-dark-graph-panel-border-color: #a0a6ad;
  }

  body.theme-dark ${`.${panels}`} {
    --vis-graph-panel-border-color: var(--vis-dark-graph-panel-border-color);
    --vis-graph-panel-fill-color: var(--vis-dark-graph-panel-fill-color);
    --vis-graph-panel-label-color: var(--vis-dark-graph-panel-label-color);
    --vis-graph-panel-label-background: var(--vis-dark-graph-panel-label-background);
    --vis-graph-panel-side-icon-symbol-color: var(--vis-dark-graph-panel-side-icon-symbol-color);
    --vis-graph-panel-side-icon-shape-fill-color: var(--vis-dark-graph-panel-side-icon-shape-fill-color);
    --vis-graph-panel-border-color:  var(--vis-dark-graph-panel-border-color);
  }
`;
var gPanel = css`
  label: g-panel;
`;
var panel = css`
  label: panel;

  stroke: var(--vis-graph-panel-border-color);
  stroke-opacity: var(--vis-graph-panel-border-opacity);
  fill: var(--vis-graph-panel-fill-color);
`;
var label8 = css`
  label: label;

  fill: var(--vis-graph-panel-label-color);
`;
var background7 = css`
  label: background;

  opacity: 0.9;
  -webkit-backdrop-filter: blur(2px);
  backdrop-filter: blur(2px);
  fill: var(--vis-graph-panel-label-background);
  stroke: none;
`;
var labelText3 = css`
  label: label-text;

  text-anchor: middle;
  font-size: var(--vis-graph-panel-label-font-size);
  font-weight: var(--vis-graph-panel-label-font-weight);;
  cursor: default;
  stroke: none;
  font-family: var(--vis-graph-panel-label-font-family, var(--vis-font-family));
`;
var panelSelectionActive = css`
  label: active;
`;
var panelSelection = css`
  label: panel-selection-outline;

  opacity: 0;
  stroke-width: 1;
  stroke-dasharray: 3 3;
  fill: var(--vis-graph-node-selection-color);
  fill-opacity: 0.1;
  stroke: var(--vis-graph-panel-dashed-outline-color);
  stroke-opacity: 0;

  &${`.${panelSelectionActive}`} {
    opacity: 1;
    stroke-opacity: 0.75;
  }
`;
var greyout = css`
  label: greyout;
  opacity: 0.4;
`;
var sideIconGroup = css`
  label: side-icon-group;
`;
var sideIconShape = css`
  label: side-icon-shape;

  fill: var(--vis-graph-panel-side-icon-shape-fill-color);
  stroke-width: 2px;
`;
var customSideIcon = css`
  label: side-icon-custom;
`;
var sideIconSymbol = css`
  label: side-label-icon-text;
  font-family: var(--vis-graph-icon-font-family), var(--vis-font-family);
  fill: var(--vis-graph-panel-side-icon-symbol-color);
  stroke: none;
  dominant-baseline: middle;
  text-anchor: middle;
  pointer-events: none;
  cursor: default;
`;

// node_modules/@unovis/ts/utils/svg.js
var import_striptags2 = __toESM(require_striptags(), 1);
var allowedSvgTags = [
  "svg",
  "g",
  "path",
  "rect",
  "circle",
  "ellipse",
  "line",
  "polyline",
  "polygon",
  "defs",
  "clipPath",
  "use",
  "symbol",
  "image",
  "marker",
  "style",
  "mask",
  ...allowedSvgTextTags
];
function sanitizeSvgString(svgString, allowedTags = allowedSvgTags) {
  return (0, import_striptags2.default)(svgString, allowedTags);
}
function isStringSvg(input) {
  const svgElementsRegex = new RegExp(`<(${allowedSvgTags.join("|")})\\b`, "i");
  const svgAttributesRegex = /\b(d|fill|stroke|transform|viewBox)=/i;
  return svgElementsRegex.test(input) || svgAttributesRegex.test(input);
}

// node_modules/@unovis/ts/components/graph/modules/node/helper.js
var NODE_SIZE = 30;
var LABEL_RECT_HORIZONTAL_PADDING = 10;
var LABEL_RECT_VERTICAL_PADDING = 4;
function getNodeSize(d, nodeSizeAccessor, index3) {
  return getNumber(d, nodeSizeAccessor, index3) || NODE_SIZE;
}
function _setInitialAnimState(el, index3) {
  el._animState = {
    endAngle: 0,
    nodeIndex: index3
  };
}
function arcTween(d, config, arcConstructor, el) {
  var _a;
  const { nodeStrokeWidth, nodeSize, nodeGaugeValue } = config;
  if (!el._animState)
    _setInitialAnimState(el, d._index);
  const i = value_default(el._animState, {
    endAngle: 2 * Math.PI * ((_a = getNumber(d, nodeGaugeValue, d._index)) !== null && _a !== void 0 ? _a : 0) / 100,
    nodeIndex: d._index,
    nodeSize: getNodeSize(d, nodeSize, d._index),
    borderWidth: getNumber(d, nodeStrokeWidth, d._index)
  });
  el._animState = i(0);
  return (t) => {
    el._animState = i(t);
    return arcConstructor(el._animState);
  };
}
function polyTween(d, config, polygonConstructor, el) {
  var _a;
  const { nodeShape, nodeGaugeValue } = config;
  const nodeSize = getNodeSize(d, config.nodeSize, d._index);
  let n;
  switch (getString(d, nodeShape, d._index)) {
    case GraphNodeShape.Square:
      n = 4;
      break;
    case GraphNodeShape.Triangle:
      n = 3;
      break;
    case GraphNodeShape.Hexagon:
    default:
      n = 6;
  }
  if (!el._animState)
    _setInitialAnimState(el, d._index);
  const i = value_default(el._animState, {
    endAngle: 2 * Math.PI * ((_a = getNumber(d, nodeGaugeValue, d._index)) !== null && _a !== void 0 ? _a : 0) / 100,
    nodeIndex: d._index
  });
  el._animState = i(0);
  return (t) => {
    el._animState = i(t);
    return n === 4 ? scoreRectPath({
      x: -nodeSize / 2,
      y: -nodeSize / 2,
      w: nodeSize,
      h: nodeSize,
      r: 5,
      score: el._animState.endAngle / (2 * Math.PI)
    }) : polygonConstructor(nodeSize, n, el._animState.endAngle, true);
  };
}
function setLabelRect(labelSelection, label10, selector) {
  const labelIsEmpty = isEmpty(label10);
  const labelTextSelection = labelSelection.select(`.${selector}`);
  const labelTextBBox = labelTextSelection.node().getBBox();
  const backgroundRect2 = labelSelection.select("rect").attr("visibility", labelIsEmpty ? "hidden" : null).attr("rx", 4).attr("ry", 4).attr("x", -labelTextBBox.width / 2 - LABEL_RECT_HORIZONTAL_PADDING).attr("y", "-0.64em").attr("width", labelTextBBox.width + 2 * LABEL_RECT_HORIZONTAL_PADDING).attr("height", labelTextBBox.height + 2 * LABEL_RECT_VERTICAL_PADDING).style("transform", `translateY(${-LABEL_RECT_VERTICAL_PADDING}px)`);
  return backgroundRect2;
}
function getX2(node4) {
  return node4._state && !isNil(node4._state.fx) ? node4._state.fx : node4.x;
}
function getY2(node4) {
  return node4._state && !isNil(node4._state.fy) ? node4._state.fy : node4.y;
}
function configuredNodeSize(nodeSizeAccessor) {
  return typeof nodeSizeAccessor === "number" ? nodeSizeAccessor : NODE_SIZE;
}
function getMaxNodeSize(data, nodeSize) {
  return max(data || [], (d, i) => getNodeSize(d, nodeSize, i)) || NODE_SIZE;
}
function getAverageNodeSize(data, nodeSize) {
  return mean(data || [], (d, i) => getNodeSize(d, nodeSize, i)) || NODE_SIZE;
}
function getSideLabelTextColor(label10, context) {
  if (!label10.color)
    return null;
  const hex2 = getHexValue(label10.color, context);
  const brightness = hexToBrightness(hex2);
  return brightness > 0.65 ? "var(--vis-graph-node-side-label-fill-color-dark)" : "var(--vis-graph-node-side-label-fill-color-bright)";
}
function getNodeColor(d, colorAccessor, index3) {
  var _a;
  return (_a = getColor(d, colorAccessor, index3, true)) !== null && _a !== void 0 ? _a : null;
}
function getNodeIconColor(d, colorAccessor, index3, context) {
  const nodeColor = getNodeColor(d, colorAccessor, index3);
  if (!nodeColor)
    return null;
  const hex2 = getHexValue(nodeColor, context);
  const brightness = hexToBrightness(hex2);
  return brightness > 0.65 ? "var(--vis-graph-node-icon-fill-color-dark)" : "var(--vis-graph-node-icon-fill-color-bright)";
}
function isInternalHref(str) {
  return /^#[^]+/.test(str);
}

// node_modules/@unovis/ts/components/graph/modules/shape.js
function appendShape(selection2, shapeAccessor, shapeSelector, customShapeSelector, index3, insertSelector = ":last-child") {
  selection2.each((d, i, elements) => {
    const element = select_default2(elements[i]);
    const shape = getString(d, shapeAccessor, index3);
    let shapeElement;
    const isCustomShape = isStringSvg(shape);
    if (isCustomShape) {
      shapeElement = element.insert("g", insertSelector).html(sanitizeSvgString(shape));
    } else {
      switch (shape) {
        case GraphNodeShape.Square:
          shapeElement = element.insert("rect", insertSelector).attr("rx", 5).attr("ry", 5);
          break;
        case GraphNodeShape.Hexagon:
        case GraphNodeShape.Triangle:
          shapeElement = element.insert("path", insertSelector);
          break;
        case GraphNodeShape.Circle:
        default:
          shapeElement = element.insert("circle", insertSelector);
      }
    }
    shapeElement.classed(customShapeSelector, isCustomShape);
    return shapeElement.attr("class", shapeSelector);
  });
}
function updateShape(selection2, shape, size2, index3) {
  if (selection2.size() === 0)
    return;
  const d = selection2.datum();
  const nodeSize = getNodeSize(d, size2, index3);
  selection2.filter("circle").attr("r", nodeSize / 2);
  selection2.filter("rect").attr("width", nodeSize).attr("height", nodeSize).attr("x", -nodeSize / 2).attr("y", -nodeSize / 2);
  selection2.filter("path").attr("d", () => {
    let n;
    switch (getString(d, shape, index3)) {
      case GraphNodeShape.Square:
        n = 4;
        break;
      case GraphNodeShape.Triangle:
        n = 3;
        break;
      case GraphNodeShape.Hexagon:
      default:
        n = 6;
    }
    return polygon(nodeSize, n);
  });
  selection2.filter("g").filter(() => !isStringSvg(getString(d, shape, index3))).html(getString(d, shape, index3));
  selection2.filter("g").each((d2, i, elements) => {
    const el = select_default2(elements[i]);
    const bBox = el.node().getBBox();
    el.attr("transform", `translate(${-bBox.width / 2},${-bBox.height / 2})`);
  });
}

// node_modules/@unovis/ts/components/graph/modules/zoom-levels.js
var ZoomLevel;
(function(ZoomLevel2) {
  ZoomLevel2[ZoomLevel2["Level0"] = 1] = "Level0";
  ZoomLevel2[ZoomLevel2["Level1"] = 0.6] = "Level1";
  ZoomLevel2[ZoomLevel2["Level2"] = 0.4] = "Level2";
  ZoomLevel2[ZoomLevel2["Level3"] = 0.2] = "Level3";
})(ZoomLevel || (ZoomLevel = {}));

// node_modules/@unovis/ts/components/graph/modules/node/index.js
var SIDE_LABEL_DEFAULT_RADIUS = 10;
function createNodes3(selection2, config) {
  const { nodeShape } = config;
  selection2.each((d, i, elements) => {
    const element = elements[i];
    const group3 = select_default2(element);
    group3.attr("transform", (d2, i2) => {
      var _a, _b, _c;
      const configuredPosition = getValue(d2, config.nodeEnterPosition, i2);
      const scale = (_a = getNumber(d2, config.nodeEnterScale, i2)) !== null && _a !== void 0 ? _a : 0;
      const x3 = (_b = configuredPosition === null || configuredPosition === void 0 ? void 0 : configuredPosition[0]) !== null && _b !== void 0 ? _b : getX2(d2);
      const y3 = (_c = configuredPosition === null || configuredPosition === void 0 ? void 0 : configuredPosition[1]) !== null && _c !== void 0 ? _c : getY2(d2);
      return `translate(${x3}, ${y3}) scale(${scale})`;
    }).attr("opacity", 0);
    const shape = getString(d, nodeShape, d._index);
    element.nodeShape = shape;
    appendShape(group3, shape, node3, customNode, d._index);
    appendShape(group3, shape, nodeSelection, customNode, d._index);
    group3.append("path").attr("class", nodeGauge);
    group3.append("g").attr("class", nodeIcon2);
    const label$1 = group3.append("g").attr("class", label7);
    label$1.append("rect").attr("class", labelBackground2);
    const labelText$1 = label$1.append("text").attr("class", labelText2).attr("dy", "0.32em");
    labelText$1.append("tspan").attr("class", labelTextContent);
    labelText$1.append("tspan").attr("class", subLabelTextContent).attr("dy", "1.1em").attr("x", "0");
    group3.append("g").attr("class", sideLabelsGroup);
    group3.append("text").attr("class", nodeBottomIcon);
  });
}
function updateSelectedNodes(selection2, config) {
  const { nodeDisabled } = config;
  selection2.each((d, i, elements) => {
    const group3 = select_default2(elements[i]);
    const isGreyout = getBoolean(d, nodeDisabled, d._index) || d._state.greyout;
    group3.classed(greyedOutNode, isGreyout && !d._state.brushed).classed(draggable, !config.disableDrag);
    const nodeSelectionOutline = group3.selectAll(`.${nodeSelection}`);
    nodeSelectionOutline.classed(nodeSelectionActive, d._state.selected || d._state.brushed);
    group3.selectAll(`.${sideLabel}`).style("fill", (l) => isGreyout ? null : getSideLabelTextColor(l, selection2.node()));
    group3.selectAll(`.${sideLabelBackground}`).style("fill", (l) => isGreyout ? null : l.color);
  });
}
function updateNodes3(selection2, config, duration, scale = 1) {
  const { nodeGaugeAnimDuration, nodeStrokeWidth, nodeShape, nodeSize, nodeGaugeValue, nodeGaugeFill, nodeIcon: nodeIcon$1, nodeIconSize, nodeLabel, nodeLabelTrim, nodeLabelTrimMode, nodeLabelTrimLength, nodeSubLabel, nodeSubLabelTrim, nodeSubLabelTrimMode, nodeSubLabelTrimLength, nodeSideLabels, nodeStroke, nodeFill, nodeBottomIcon: nodeBottomIcon$1 } = config;
  selection2.each((d, i, elements) => {
    const element = elements[i];
    const group3 = select_default2(element);
    const shape = getString(d, nodeShape, d._index);
    if (element.nodeShape !== shape) {
      group3.select(`.${node3}`).remove();
      appendShape(group3, nodeShape, node3, customNode, d._index, `.${nodeSelection}`);
      group3.select(`.${nodeSelection}`).remove();
      appendShape(group3, shape, nodeSelection, null, d._index, `.${nodeGauge}`);
      element.nodeShape = shape;
    }
  });
  selection2.each((d, i, elements) => {
    var _a, _b, _c;
    const groupElement = elements[i];
    const group3 = select_default2(groupElement);
    const node$1 = group3.select(`.${node3}`);
    const nodeArc = group3.select(`.${nodeGauge}`);
    const icon = group3.select(`.${nodeIcon2}`);
    const sideLabelsGroup$1 = group3.select(`.${sideLabelsGroup}`);
    const label$1 = group3.select(`.${label7}`);
    const labelTextContent$1 = label$1.select(`.${labelTextContent}`);
    const sublabelTextContent = label$1.select(`.${subLabelTextContent}`);
    const bottomIcon = group3.select(`.${nodeBottomIcon}`);
    const nodeSelectionOutline = group3.select(`.${nodeSelection}`);
    const nodeSizeValue = getNodeSize(d, nodeSize, d._index);
    const arcGenerator = arc_default().innerRadius((state) => state.nodeSize / 2 - state.borderWidth / 2).outerRadius((state) => state.nodeSize / 2 + state.borderWidth / 2).startAngle(0 * (Math.PI / 180)).endAngle((a4) => a4["endAngle"]);
    group3.classed(zoomOutLevel2, scale < ZoomLevel.Level2).classed(nodeIsDragged, (d2) => d2._state.isDragged);
    group3.classed(nodePolygon, () => {
      const shape = getString(d, nodeShape, d._index);
      return shape === GraphNodeShape.Triangle || shape === GraphNodeShape.Hexagon || shape === GraphNodeShape.Square;
    });
    node$1.call(updateShape, nodeShape, nodeSize, d._index).attr("stroke-width", (_a = getNumber(d, nodeStrokeWidth, d._index)) !== null && _a !== void 0 ? _a : 0).style("fill", getNodeColor(d, nodeFill, d._index)).style("stroke", (_b = getColor(d, nodeStroke, d._index, true)) !== null && _b !== void 0 ? _b : null);
    const nodeBBox = node$1.node().getBBox();
    nodeArc.attr("stroke-width", getNumber(d, nodeStrokeWidth, d._index)).style("display", !getNumber(d, nodeGaugeValue, d._index) ? "none" : null).style("fill", getNodeColor(d, nodeGaugeFill, d._index)).style("stroke", getNodeColor(d, nodeGaugeFill, d._index)).style("stroke-opacity", (d2) => getString(d2, nodeShape, d2._index) === GraphNodeShape.Circle ? 0 : null);
    nodeArc.transition().duration(nodeGaugeAnimDuration).attrTween("d", (d2, j, arr) => {
      switch (getString(d2, nodeShape, d2._index)) {
        case GraphNodeShape.Circle:
          return arcTween(d2, config, arcGenerator, arr[j]);
        case GraphNodeShape.Hexagon:
          return polyTween(d2, config, polygon, arr[j]);
        case GraphNodeShape.Square:
          return polyTween(d2, config, polygon, arr[j]);
        case GraphNodeShape.Triangle:
          return polyTween(d2, config, polygon, arr[j]);
        default:
          return null;
      }
    });
    updateShape(nodeSelectionOutline, nodeShape, nodeSize, d._index);
    const nodeIconContent = getString(d, nodeIcon$1, d._index);
    const nodeIconSizeValue = (_c = getNumber(d, nodeIconSize, d._index)) !== null && _c !== void 0 ? _c : 2.5 * Math.sqrt(nodeSizeValue);
    const nodeIconColor = getNodeIconColor(d, nodeFill, d._index, selection2.node());
    icon.selectAll("*").remove();
    if (isInternalHref(nodeIconContent)) {
      icon.append("use").attr("href", nodeIconContent).attr("x", -nodeIconSizeValue / 2).attr("y", -nodeIconSizeValue / 2).attr("width", nodeIconSizeValue).attr("height", nodeIconSizeValue).style("fill", nodeIconColor);
    } else {
      icon.append("text").style("font-size", `${nodeIconSizeValue}px`).attr("dy", "0.1em").style("fill", nodeIconColor).html(nodeIconContent);
    }
    const sideLabelsData = getValue(d, nodeSideLabels, d._index) || [];
    const sideLabels = sideLabelsGroup$1.selectAll("g").data(sideLabelsData);
    const sideLabelsEnter = sideLabels.enter().append("g").attr("class", sideLabelGroup);
    sideLabelsEnter.append("circle").attr("class", sideLabelBackground).attr("r", (l) => {
      var _a2;
      return (_a2 = l.radius) !== null && _a2 !== void 0 ? _a2 : SIDE_LABEL_DEFAULT_RADIUS;
    });
    sideLabelsEnter.append("text").attr("class", sideLabel);
    const sideLabelsUpdate = sideLabels.merge(sideLabelsEnter).style("cursor", (l) => {
      var _a2;
      return (_a2 = l.cursor) !== null && _a2 !== void 0 ? _a2 : null;
    });
    sideLabelsUpdate.select(`.${sideLabel}`).html((d2) => d2.text).attr("dy", "0.1em").style("fill", (l) => {
      var _a2;
      return (_a2 = l.textColor) !== null && _a2 !== void 0 ? _a2 : getSideLabelTextColor(l, selection2.node());
    }).style("font-size", (l) => {
      var _a2, _b2;
      return (_a2 = l.fontSize) !== null && _a2 !== void 0 ? _a2 : `${(2 + ((_b2 = l.radius) !== null && _b2 !== void 0 ? _b2 : SIDE_LABEL_DEFAULT_RADIUS)) / Math.pow(l.text.toString().length, 0.3)}px`;
    });
    sideLabelsUpdate.select(`.${sideLabelBackground}`).style("fill", (l) => l.color);
    sideLabelsUpdate.attr("transform", (l, j) => {
      var _a2;
      if (sideLabelsData.length === 1)
        return `translate(${nodeSizeValue / 2.5}, ${-nodeSizeValue / 2.5})`;
      const r = 1.05 * nodeSizeValue / 2;
      const angle = j * 1.15 * 2 * Math.atan2((_a2 = l.radius) !== null && _a2 !== void 0 ? _a2 : SIDE_LABEL_DEFAULT_RADIUS, r) - Math.PI / 3;
      return `translate(${r * Math.cos(angle)}, ${r * Math.sin(angle)})`;
    });
    sideLabels.exit().remove();
    const labelText$1 = getString(d, nodeLabel, d._index);
    const sublabelText = getString(d, nodeSubLabel, d._index);
    const labelTextTrimmed = getBoolean(d, nodeLabelTrim, d._index) ? trimString(labelText$1, getNumber(d, nodeLabelTrimLength, d._index), getValue(d, nodeLabelTrimMode, d._index)) : labelText$1;
    const sublabelTextTrimmed = getBoolean(d, nodeSubLabelTrim, d._index) ? trimString(sublabelText, getNumber(d, nodeSubLabelTrimLength, d._index), getValue(d, nodeSubLabelTrimMode, d._index)) : sublabelText;
    labelTextContent$1.text(labelTextTrimmed);
    sublabelTextContent.text(sublabelTextTrimmed);
    group3.on("mouseenter", () => {
      labelTextContent$1.text(labelText$1);
      sublabelTextContent.text(sublabelText);
      setLabelRect(label$1, labelText$1, labelText2);
      group3.raise();
    }).on("mouseleave", () => {
      labelTextContent$1.text(labelTextTrimmed);
      sublabelTextContent.text(sublabelTextTrimmed);
      setLabelRect(label$1, labelTextTrimmed, labelText2);
    });
    const labelFontSize = parseFloat(window.getComputedStyle(groupElement).getPropertyValue("--vis-graph-node-label-font-size")) || 12;
    const labelMargin = LABEL_RECT_VERTICAL_PADDING + 1.25 * Math.pow(labelFontSize, 1.03);
    const nodeHeight = isStringSvg(getString(d, nodeShape, d._index)) ? nodeBBox.height : nodeSizeValue;
    label$1.attr("transform", `translate(0, ${nodeHeight / 2 + labelMargin})`);
    if (scale >= ZoomLevel.Level3)
      setLabelRect(label$1, getString(d, nodeLabel, d._index), labelText2);
    bottomIcon.html(getString(d, nodeBottomIcon$1, d._index)).attr("transform", `translate(0, ${nodeHeight / 2})`);
  });
  updateSelectedNodes(selection2, config);
  return smartTransition(selection2, duration).attr("transform", (d) => `translate(${getX2(d)}, ${getY2(d)}) scale(1)`).attr("opacity", 1);
}
function removeNodes3(selection2, config, duration) {
  smartTransition(selection2, duration / 2).attr("opacity", 0).attr("transform", (d, i) => {
    var _a, _b, _c;
    const configuredPosition = getValue(d, config.nodeExitPosition, i);
    const scale = (_a = getNumber(d, config.nodeExitScale, i)) !== null && _a !== void 0 ? _a : 0;
    const x3 = (_b = configuredPosition === null || configuredPosition === void 0 ? void 0 : configuredPosition[0]) !== null && _b !== void 0 ? _b : getX2(d);
    const y3 = (_c = configuredPosition === null || configuredPosition === void 0 ? void 0 : configuredPosition[1]) !== null && _c !== void 0 ? _c : getY2(d);
    return `translate(${x3}, ${y3}) scale(${scale})`;
  }).remove();
}
function setLabelBackgroundRect(selection2, config) {
  const { nodeLabel } = config;
  selection2.each((d, i, elements) => {
    const group3 = select_default2(elements[i]);
    const label$1 = group3.select(`.${label7}`);
    setLabelRect(label$1, getString(d, nodeLabel, i), labelText2);
  });
}
var setLabelBackgroundRectThrottled = throttle(setLabelBackgroundRect, 1e3);
function zoomNodes(selection2, config, scale) {
  selection2.classed(zoomOutLevel1, scale < ZoomLevel.Level1);
  selection2.classed(zoomOutLevel2, scale < ZoomLevel.Level2);
  selection2.selectAll(`${sideLabelBackground}`).attr("transform", `scale(${1 / Math.pow(scale, 0.35)})`);
  selection2.selectAll(`.${sideLabel}`).attr("transform", `scale(${1 / Math.pow(scale, 0.45)})`);
  if (scale >= ZoomLevel.Level3)
    selection2.call(setLabelBackgroundRectThrottled, config);
}
var zoomNodesThrottled = throttle(zoomNodes, 500);

// node_modules/@unovis/ts/components/graph/modules/link/index.js
var import_to_px2 = __toESM(require_browser(), 1);

// node_modules/@unovis/ts/components/graph/modules/link/helper.js
var LINK_MARKER_WIDTH = 9;
var LINK_MARKER_HEIGHT = 7;
function getLinkShift(link7, spacing) {
  const sourceNode = link7.source;
  const targetNode = link7.target;
  const angle = Math.atan2(getY2(targetNode) - getY2(sourceNode), getX2(targetNode) - getX2(sourceNode)) - Math.PI / 2;
  const dx = Math.cos(angle) * spacing * link7._direction * (link7._index - (link7._neighbours - 1) / 2);
  const dy = Math.sin(angle) * spacing * link7._direction * (link7._index - (link7._neighbours - 1) / 2);
  return { dx, dy };
}
function getLinkShiftTransform(link7, spacing) {
  const { dx, dy } = getLinkShift(link7, spacing);
  return `translate(${dx}, ${dy})`;
}
function getLinkStrokeWidth(d, scale, config) {
  const m2 = getNumber(d, config.linkWidth, d._indexGlobal);
  return m2 / Math.pow(scale, 0.5);
}
function getLinkBandWidth(d, scale, config) {
  const { nodeSize, linkBandWidth } = config;
  const sourceNodeSize = getNumber(d.source, nodeSize, d.source._index);
  const targetNodeSize = getNumber(d.target, nodeSize, d.target._index);
  const minNodeSize = Math.min(sourceNodeSize, targetNodeSize);
  return Math.min(minNodeSize, getNumber(d, linkBandWidth, d._indexGlobal) / Math.pow(scale || 1, 0.5)) || 0;
}
function getLinkColor(link7, config) {
  var _a;
  const { linkStroke } = config;
  const c3 = (_a = getColor(link7, linkStroke, link7._indexGlobal, true)) !== null && _a !== void 0 ? _a : "var(--vis-graph-link-stroke-color)";
  return c3 || null;
}
function getLinkArrowStyle(d, config) {
  const linkArrowValue = getValue(d, config.linkArrow, d._indexGlobal);
  if (!linkArrowValue)
    return void 0;
  else if (linkArrowValue === GraphLinkArrowStyle.Double)
    return linkArrowValue;
  else
    return GraphLinkArrowStyle.Single;
}
function getArrowPath() {
  return `M${-LINK_MARKER_WIDTH / 2},${-LINK_MARKER_HEIGHT / 2} V${LINK_MARKER_HEIGHT / 2} L${LINK_MARKER_WIDTH / 2},0 Z`;
}
function getDoubleArrowPath() {
  return `M${-LINK_MARKER_WIDTH / 2},0 L${LINK_MARKER_WIDTH / 2},${-LINK_MARKER_HEIGHT / 2} L${LINK_MARKER_WIDTH * 1.5},0 L${LINK_MARKER_WIDTH / 2},${LINK_MARKER_HEIGHT / 2} Z`;
}
function getLinkLabelTextColor(label10) {
  if (!label10.color)
    return null;
  const hex2 = color(label10.color).hex();
  const brightness = hexToBrightness(hex2);
  return brightness > 0.65 ? "var(--vis-graph-link-label-text-color-dark)" : "var(--vis-graph-link-label-text-color-bright)";
}

// node_modules/@unovis/ts/components/graph/modules/link/index.js
function createLinks2(selection2) {
  selection2.attr("opacity", 0);
  selection2.append("path").attr("class", linkSupport);
  selection2.append("path").attr("class", link6);
  selection2.append("path").attr("class", linkBand);
  selection2.append("use").attr("class", linkArrow);
  selection2.append("g").attr("class", flowGroup).selectAll(`.${flowCircle}`).data(range(0, 6)).enter().append("circle").attr("class", flowCircle);
  const linkLabelGroup$1 = selection2.append("g").attr("class", linkLabelGroup);
  linkLabelGroup$1.append("rect").attr("class", linkLabelBackground);
  linkLabelGroup$1.append("text").attr("class", linkLabelContent);
}
function updateSelectedLinks(selection2, config, scale) {
  const isGreyedOut = (d, i) => getBoolean(d, config.linkDisabled, i) || d._state.greyout;
  selection2.classed(greyedOutLink, (d, i) => isGreyedOut(d, i));
  selection2.each((d, i, elements) => {
    const element = elements[i];
    const group3 = select_default2(element);
    group3.select(`.${link6}`);
    group3.select(`.${linkBand}`);
    const linkSupport$1 = group3.select(`.${linkSupport}`);
    linkSupport$1.style("stroke-opacity", d._state.hovered || d._state.selected ? 0.2 : 0).style("stroke-width", d._state.selected ? getLinkBandWidth(d, scale, config) + 5 : d._state.hovered ? getLinkBandWidth(d, scale, config) + 10 : null);
  });
}
function updateLinks2(selection2, config, duration, scale = 1, getLinkArrowDefId) {
  const { linkFlowParticleSize, linkStyle, linkFlow, linkLabel, linkLabelShiftFromCenter } = config;
  if (!selection2.size())
    return;
  selection2.classed(linkDashed, (d) => getValue(d, linkStyle, d._indexGlobal) === GraphLinkStyle.Dashed);
  selection2.each((d, i, elements) => {
    var _a, _b, _c, _d, _e;
    const element = elements[i];
    const linkGroup = select_default2(element);
    const link$1 = linkGroup.select(`.${link6}`);
    const linkBand$1 = linkGroup.select(`.${linkBand}`);
    const linkSupport$1 = linkGroup.select(`.${linkSupport}`);
    const linkArrow$1 = linkGroup.select(`.${linkArrow}`);
    const flowGroup$1 = linkGroup.select(`.${flowGroup}`);
    const linkColor = getLinkColor(d, config);
    const linkShiftTransform = getLinkShiftTransform(d, config.linkNeighborSpacing);
    const linkLabelDatum = getValue(d, linkLabel, d._indexGlobal);
    const linkLabelText = linkLabelDatum ? (_a = linkLabelDatum.text) === null || _a === void 0 ? void 0 : _a.toString() : void 0;
    const x13 = getX2(d.source);
    const y13 = getY2(d.source);
    const x22 = getX2(d.target);
    const y22 = getY2(d.target);
    const curvature = (_b = getNumber(d, config.linkCurvature, i)) !== null && _b !== void 0 ? _b : 0;
    const cp1x = x13 + (x22 - x13) * 0.5 * curvature;
    const cp1y = y13 + (y22 - y13) * 0 * curvature;
    const cp2x = x13 + (x22 - x13) * 0.5 * curvature;
    const cp2y = y13 + (y22 - y13) * 1 * curvature;
    const pathData = `M${x13},${y13} C${cp1x},${cp1y} ${cp2x},${cp2y} ${x22},${y22}`;
    link$1.attr("class", link6).style("stroke-width", getLinkStrokeWidth(d, scale, config)).style("stroke", linkColor).attr("transform", linkShiftTransform);
    smartTransition(link$1, duration).attr("d", pathData);
    linkBand$1.attr("class", linkBand).attr("transform", linkShiftTransform).style("stroke-width", getLinkBandWidth(d, scale, config)).style("stroke", linkColor);
    smartTransition(linkBand$1, duration).attr("d", pathData);
    linkSupport$1.style("stroke", linkColor).attr("transform", linkShiftTransform).attr("d", pathData);
    const linkArrowStyle = getLinkArrowStyle(d, config);
    const linkPathElement = linkSupport$1.node();
    const pathLength = linkPathElement.getTotalLength();
    if (linkArrowStyle) {
      const arrowPos = pathLength * (linkLabelText ? 0.65 : 0.5);
      const p1 = linkPathElement.getPointAtLength(arrowPos);
      const p2 = linkPathElement.getPointAtLength(arrowPos + 1);
      const angle = Math.atan2(p2.y - p1.y, p2.x - p1.x) * (180 / Math.PI);
      const arrowWasShownBefore = linkArrow$1.attr("href");
      linkArrow$1.attr("href", `#${getLinkArrowDefId(linkArrowStyle)}`);
      smartTransition(linkArrow$1, arrowWasShownBefore ? duration : 0).attr("fill", linkColor).attr("transform", `translate(${p1.x}, ${p1.y}) rotate(${angle})`);
    } else {
      linkArrow$1.attr("href", null);
    }
    flowGroup$1.attr("transform", linkShiftTransform).style("display", getBoolean(d, linkFlow, d._indexGlobal) ? null : "none").style("opacity", 0);
    flowGroup$1.selectAll(`.${flowCircle}`).attr("r", linkFlowParticleSize / scale).style("fill", linkColor);
    smartTransition(flowGroup$1, duration).style("opacity", scale < ZoomLevel.Level2 ? 0 : 1);
    const linkLabelGroup$1 = linkGroup.select(`.${linkLabelGroup}`);
    if (linkLabelText) {
      const linkMarkerWidth = linkArrowStyle ? LINK_MARKER_WIDTH * 2 : 0;
      const linkLabelShift = getBoolean(d, linkLabelShiftFromCenter, d._indexGlobal) ? -linkMarkerWidth + 4 : 0;
      const linkLabelPos = linkPathElement.getPointAtLength(pathLength / 2 + linkLabelShift);
      const linkLabelTranslate = `translate(${linkLabelPos.x}, ${linkLabelPos.y})`;
      const linkLabelBackground$1 = linkLabelGroup$1.select(`.${linkLabelBackground}`);
      const linkLabelContent$1 = linkLabelGroup$1.select(`.${linkLabelContent}`);
      if (!linkLabelContent$1.text() || linkLabelContent$1.attr("hidden")) {
        linkLabelGroup$1.attr("transform", linkLabelTranslate);
      }
      linkLabelGroup$1.attr("hidden", null).style("cursor", linkLabelDatum.cursor);
      smartTransition(linkLabelGroup$1, duration).attr("transform", linkLabelTranslate).style("opacity", 1);
      linkLabelContent$1.text(linkLabelText).attr("dy", "0.1em").style("font-size", linkLabelDatum.fontSize).style("fill", (_c = linkLabelDatum.textColor) !== null && _c !== void 0 ? _c : getLinkLabelTextColor(linkLabelDatum));
      const shouldBeRenderedAsCircle = linkLabelText.length <= 2;
      const linkLabelPaddingVertical = 4;
      const linkLabelPaddingHorizontal = shouldBeRenderedAsCircle ? linkLabelPaddingVertical : 8;
      const linkLabelFontSize = (_d = (0, import_to_px2.default)(linkLabelDatum.fontSize)) !== null && _d !== void 0 ? _d : getCSSVariableValueInPixels("var(--vis-graph-link-label-font-size)", linkLabelContent$1.node());
      const linkLabelWidthPx = estimateStringPixelLength(linkLabelText, linkLabelFontSize);
      const linkLabelBackgroundBorderRadius = (_e = linkLabelDatum.radius) !== null && _e !== void 0 ? _e : shouldBeRenderedAsCircle ? linkLabelFontSize : 4;
      const linkLabelBackgroundWidth = shouldBeRenderedAsCircle ? linkLabelFontSize : linkLabelWidthPx;
      linkLabelBackground$1.attr("x", -linkLabelBackgroundWidth / 2 - linkLabelPaddingHorizontal).attr("y", -linkLabelFontSize / 2 - linkLabelPaddingVertical).attr("width", linkLabelBackgroundWidth + linkLabelPaddingHorizontal * 2).attr("height", linkLabelFontSize + linkLabelPaddingVertical * 2).attr("rx", linkLabelBackgroundBorderRadius).style("fill", linkLabelDatum.color);
    } else {
      linkLabelGroup$1.attr("hidden", true);
    }
  });
  if (duration > 0) {
    selection2.attr("pointer-events", "none");
    const t = smartTransition(selection2, duration);
    t.attr("opacity", 1).on("end interrupt", (d, i, elements) => {
      select_default2(elements[i]).attr("pointer-events", "stroke").attr("opacity", 1);
    });
  } else {
    selection2.attr("opacity", 1);
  }
  updateSelectedLinks(selection2, config, scale);
}
function removeLinks2(selection2, config, duration) {
  smartTransition(selection2, duration / 2).attr("opacity", 0).remove();
}
function animateLinkFlow(selection2, config, scale) {
  const { linkFlow } = config;
  if (scale < ZoomLevel.Level2)
    return;
  selection2.each((d, i, elements) => {
    const element = elements[i];
    const linkGroup = select_default2(element);
    const flowGroup$1 = linkGroup.select(`.${flowGroup}`);
    const linkPathElement = linkGroup.select(`.${linkSupport}`).node();
    const pathLength = linkPathElement.getTotalLength();
    if (!getBoolean(d, linkFlow, d._indexGlobal))
      return;
    const t = d._state.flowAnimTime;
    const circles = flowGroup$1.selectAll(`.${flowCircle}`);
    circles.attr("transform", (index3) => {
      const tt = (t + +index3 / (circles.size() - 1)) % 1;
      const p = linkPathElement.getPointAtLength(tt * pathLength);
      return `translate(${p.x}, ${p.y})`;
    });
  });
}
function zoomLinks(selection2, config, scale) {
  const { linkFlowParticleSize } = config;
  selection2.classed(zoomOutLevel2, scale < ZoomLevel.Level2);
  selection2.selectAll(`.${flowCircle}`).attr("r", linkFlowParticleSize / scale);
  const linkElements = selection2.selectAll(`.${link6}`);
  linkElements.style("stroke-width", (d) => getLinkStrokeWidth(d, scale, config));
  const linkBandElements = selection2.selectAll(`.${linkBand}`);
  linkBandElements.style("stroke-width", (d) => getLinkBandWidth(d, scale, config));
}
var zoomLinksThrottled = throttle(zoomLinks, 500);

// node_modules/@unovis/ts/components/graph/modules/panel/helper.js
var DEFAULT_PADDING = 15;
var DEFAULT_LABEL_MARGIN = 16;
var OUTLINE_SELECTION_PADDING = 5;
var DEFAULT_SIDE_LABEL_SIZE = 25;
function getPanelPadding(padding) {
  var _a, _b, _c, _d;
  const isPaddingAnObject = isPlainObject(padding);
  return {
    left: (_a = isPaddingAnObject ? padding.left : padding) !== null && _a !== void 0 ? _a : DEFAULT_PADDING,
    right: (_b = isPaddingAnObject ? padding.right : padding) !== null && _b !== void 0 ? _b : DEFAULT_PADDING,
    top: (_c = isPaddingAnObject ? padding.top : padding) !== null && _c !== void 0 ? _c : DEFAULT_PADDING,
    bottom: (_d = isPaddingAnObject ? padding.bottom : padding) !== null && _d !== void 0 ? _d : DEFAULT_PADDING
  };
}
function initPanels(panelsConfig) {
  const panels2 = (panelsConfig !== null && panelsConfig !== void 0 ? panelsConfig : []).map((p) => Object.assign(Object.assign({}, p), { _padding: getPanelPadding(p.padding) }));
  return panels2;
}
function setPanelForNodes(panels2, nodes4, config) {
  if (!panels2)
    return;
  nodes4.forEach((node4) => {
    const nodePanels = panels2.filter((panel2) => panel2.nodes && panel2.nodes.includes(node4._id));
    node4._panels = nodePanels;
  });
}
function setPanelBBox(panelConfig, panelNodes, nodeSizeAccessor, nodeDisabledAccessor) {
  const selection2 = panelNodes.select(`.${node3}`);
  if (selection2.empty())
    return;
  const labelApprxHeight = 40;
  const labelApprxWidth = 110;
  const labelMargin = 10;
  let box;
  selection2.each((d, i) => {
    const nodeSize = getNodeSize(d, nodeSizeAccessor, i);
    const w2 = Math.max(nodeSize, labelApprxWidth);
    const h = nodeSize + labelMargin + labelApprxHeight;
    const yShift = 10;
    const coords = {
      x1: getX2(d) - w2 / 2,
      y1: getY2(d) - h / 2 + yShift,
      x2: getX2(d) + w2 / 2,
      y2: getY2(d) + h / 2 + yShift
    };
    if (!box) {
      box = Object.assign({}, coords);
    } else {
      if (box.x1 > coords.x1)
        box.x1 = coords.x1;
      if (box.y1 > coords.y1)
        box.y1 = coords.y1;
      if (box.x2 < coords.x2)
        box.x2 = coords.x2;
      if (box.y2 < coords.y2)
        box.y2 = coords.y2;
    }
  });
  panelConfig._x = box.x1 - panelConfig._padding.left;
  panelConfig._y = box.y1 - panelConfig._padding.top;
  panelConfig._width = box.x2 - box.x1 + panelConfig._padding.left + panelConfig._padding.right;
  panelConfig._height = box.y2 - box.y1 + panelConfig._padding.top + panelConfig._padding.bottom;
  panelConfig._disabled = selection2.data().map((node4, i) => getBoolean(node4, nodeDisabledAccessor, node4._index) || node4._state.greyout).every((d) => d);
}
function setPanelNumNodes(panelConfig, panelNodes) {
  panelConfig._numNodes = panelNodes.size();
}
function updatePanelBBoxSize(nodesSelection, panels2, config) {
  const { layoutNonConnectedAside } = config;
  if (!panels2)
    return;
  panels2.forEach((panelConfig) => {
    const panelNodes = nodesSelection.filter((node4) => {
      return (!layoutNonConnectedAside || node4._isConnected) && panelConfig.nodes.includes(node4._id);
    });
    setPanelBBox(panelConfig, panelNodes, config.nodeSize, config.nodeDisabled);
  });
}
function updatePanelNumNodes(nodesSelection, panels2, config) {
  const { layoutNonConnectedAside } = config;
  if (!panels2)
    return;
  panels2.forEach((panelConfig) => {
    const panelNodes = nodesSelection.filter((node4) => {
      return (!layoutNonConnectedAside || node4._isConnected) && panelConfig.nodes.includes(node4._id);
    });
    setPanelNumNodes(panelConfig, panelNodes);
  });
}
function getLabelTranslateTransform(panel2) {
  const x3 = panel2._width / 2;
  const dy = DEFAULT_LABEL_MARGIN + (panel2.dashedOutline ? OUTLINE_SELECTION_PADDING : 0);
  const y3 = panel2.labelPosition === Position.Bottom ? panel2._height + dy : -dy;
  return `translate(${x3}, ${y3})`;
}

// node_modules/@unovis/ts/components/graph/modules/panel/index.js
function createPanels(selection2) {
  selection2.attr("transform", (d) => `translate(${d._x}, ${d._y})`).style("opacity", 0);
  selection2.append("rect").attr("class", panelSelection).attr("rx", 9).attr("ry", 9).attr("width", (d) => d._width).attr("height", (d) => d._height);
  selection2.append("rect").attr("class", panel).attr("rx", 7).attr("ry", 7).attr("width", (d) => d._width).attr("height", (d) => d._height);
  const panelLabel = selection2.append("g").attr("class", label8).attr("transform", getLabelTranslateTransform);
  panelLabel.append("rect").attr("class", background7);
  panelLabel.append("text").attr("class", labelText3).attr("dy", "0.32em");
  const sideIcon = selection2.append("g").attr("class", sideIconGroup).attr("transform", (d, i, elements) => {
    const dx = -OUTLINE_SELECTION_PADDING;
    const dy = -OUTLINE_SELECTION_PADDING;
    return `translate(${d._width + dx}, ${-dy})`;
  });
  appendShape(sideIcon, (d) => d.sideIconShape, sideIconShape, customSideIcon);
  sideIcon.append("text").attr("class", sideIconSymbol);
}
function updatePanels(selection2, config, duration) {
  smartTransition(selection2, duration).attr("transform", (d) => `translate(${d._x}, ${d._y})`).style("opacity", (d) => d._disabled ? 0.4 : 1);
  const panels2 = selection2.selectAll(`.${panel}`).data((d) => [d]);
  smartTransition(panels2, duration).attr("width", (d) => d._width).attr("height", (d) => d._height).style("stroke", (d) => d.borderColor).style("stroke-width", (d) => d.borderWidth);
  const panelSelection$1 = selection2.select(`.${panelSelection}`).classed(panelSelectionActive, (d) => d.dashedOutline);
  smartTransition(panelSelection$1, duration).attr("x", (d) => -OUTLINE_SELECTION_PADDING).attr("y", (d) => -OUTLINE_SELECTION_PADDING).attr("width", (d) => d._width + OUTLINE_SELECTION_PADDING * 2).attr("height", (d) => d._height + OUTLINE_SELECTION_PADDING * 2);
  const sideIcon = selection2.select(`.${sideIconGroup}`);
  sideIcon.select(`.${sideIconShape}`).call(updateShape, (d) => d.sideIconShape, (d) => {
    var _a;
    return (_a = d.sideIconShapeSize) !== null && _a !== void 0 ? _a : DEFAULT_SIDE_LABEL_SIZE;
  }).style("stroke", (d) => d.sideIconShapeStroke).style("cursor", (d) => {
    var _a;
    return (_a = d.sideIconCursor) !== null && _a !== void 0 ? _a : null;
  }).style("opacity", (d) => d.sideIconShape ? 1 : 0);
  sideIcon.select(`.${sideIconSymbol}`).html((d) => d.sideIconSymbol).attr("dy", 1).style("fill", (d) => d.sideIconSymbolColor).style("font-size", (d) => {
    var _a, _b;
    return (_a = d.sideIconFontSize) !== null && _a !== void 0 ? _a : ((_b = d.sideIconShapeSize) !== null && _b !== void 0 ? _b : DEFAULT_SIDE_LABEL_SIZE) / 2.5;
  });
  smartTransition(sideIcon, duration).attr("transform", (d) => {
    const dx = -OUTLINE_SELECTION_PADDING;
    const dy = -OUTLINE_SELECTION_PADDING;
    return `translate(${d._width + dx}, ${-dy})`;
  });
  const panelLabel = selection2.select(`.${label8}`);
  panelLabel.select(`.${labelText3}`).text((d) => trimString(d.label));
  smartTransition(panelLabel, duration).attr("transform", getLabelTranslateTransform);
  panelLabel.on("mouseover", (event, d) => {
    const label10 = select_default2(event.currentTarget);
    const labelContent = d.label;
    label10.select("text").text(labelContent);
    setLabelRect(label10, labelContent, labelText3);
  }).on("mouseleave", (event, d) => {
    const label10 = select_default2(event.currentTarget);
    const labelContent = trimString(d.label);
    label10.select("text").text(labelContent);
    setLabelRect(label10, labelContent, labelText3);
  });
}
function removePanels(selection2, config, duration) {
  smartTransition(selection2, duration / 2).style("opacity", 0).remove();
}

// node_modules/@unovis/ts/components/graph/modules/layout-helpers.js
var DEFAULT_ELK_SETTINGS = {
  hierarchyHandling: "INCLUDE_CHILDREN",
  "nodePlacement.strategy": "NETWORK_SIMPLEX",
  "elk.padding": "[top=15.0,left=15.0,bottom=15.0,right=15.0]",
  "spacing.nodeNodeBetweenLayers": "50",
  "spacing.edgeNodeBetweenLayers": "50",
  "spacing.nodeNode": "10"
};
function positionNonConnectedNodes(nodes4, y3, spacing, width, xStart = 0) {
  nodes4.forEach((d, i) => {
    const x3 = spacing / 2 + i * spacing;
    const rowIdx = width ? Math.floor(x3 / width) : 0;
    d.y = y3 + rowIdx * spacing || 0;
    d.x = width ? x3 % width + xStart : x3 + xStart;
  });
}
function toElkHierarchy(d, layoutOptions) {
  if (!(d instanceof Map))
    return d;
  const hierarchyNode = Array.from(d.entries()).map(([key, value2]) => {
    const children2 = toElkHierarchy(value2, layoutOptions);
    if (key) {
      const layoutOps = isPlainObject(layoutOptions) ? DEFAULT_ELK_SETTINGS : merge2(DEFAULT_ELK_SETTINGS, getValue(key, layoutOptions));
      return {
        id: key,
        layoutOptions: layoutOps,
        children: children2
      };
    } else {
      return children2;
    }
  }).flat();
  return hierarchyNode;
}
function adjustElkHierarchyCoordinates(node4) {
  var _a, _b;
  const parentX = node4.x;
  const parentY = node4.y;
  (_a = node4.edges) === null || _a === void 0 ? void 0 : _a.forEach((edge) => {
    var _a2, _b2;
    (_a2 = edge.sections) === null || _a2 === void 0 ? void 0 : _a2.forEach((section) => {
      var _a3;
      section.startPoint.x += parentX;
      section.startPoint.y += parentY;
      section.endPoint.x += parentX;
      section.endPoint.y += parentY;
      (_a3 = section.bendPoints) === null || _a3 === void 0 ? void 0 : _a3.forEach((bendPoint) => {
        bendPoint.x += parentX;
        bendPoint.y += parentY;
      });
    });
    (_b2 = edge.labels) === null || _b2 === void 0 ? void 0 : _b2.forEach((label10) => {
      label10.x += parentX;
      label10.y += parentY;
    });
  });
  (_b = node4.children) === null || _b === void 0 ? void 0 : _b.forEach((child) => {
    child.x += parentX;
    child.y += parentY;
    adjustElkHierarchyCoordinates(child);
  });
}

// node_modules/@unovis/ts/components/graph/modules/layout.js
function applyLayoutCircular(datamodel, config, width, height) {
  const { nonConnectedNodes, connectedNodes, nodes: nodes4 } = datamodel;
  const { layoutNonConnectedAside, nodeSize } = config;
  const activeWidth = width;
  const activeHeight = height;
  const layoutNodes = layoutNonConnectedAside ? connectedNodes : nodes4;
  const maxNodeSize = getMaxNodeSize(layoutNodes, nodeSize);
  const yRatio = activeHeight / maxNodeSize;
  const yScaling = yRatio < layoutNodes.length / 2 ? layoutNodes.length / 2 / yRatio : 1;
  const xRatio = activeWidth / maxNodeSize;
  const xScaling = xRatio < layoutNodes.length / 2 ? layoutNodes.length / 2 / xRatio : 1;
  const scaling = Math.max(xScaling, yScaling);
  layoutNodes.forEach((d, i) => {
    const rX = scaling * activeWidth / 2;
    const rY = scaling * activeHeight / 2;
    const angle = 2 * i * Math.PI / layoutNodes.length;
    d.x = activeWidth / 2 + rX * Math.cos(angle);
    d.y = activeHeight / 2 + rY * Math.sin(angle);
  });
  if (layoutNonConnectedAside) {
    const maxSize = getMaxNodeSize(nonConnectedNodes, nodeSize);
    const maxY = max(connectedNodes.map((d) => d.y));
    const maxX = max(connectedNodes.map((d) => d.x));
    const minX = min(connectedNodes.map((d) => d.x));
    const graphWidth = maxX - minX;
    positionNonConnectedNodes(nonConnectedNodes, maxY + maxSize * 3, maxSize * 2.25, Math.max(graphWidth, width), minX);
  }
}
function applyLayoutParallel(datamodel, config, width, height, orientation) {
  const { nonConnectedNodes, connectedNodes, nodes: nodes4 } = datamodel;
  const { layoutNonConnectedAside, layoutGroupOrder, layoutParallelSortConnectionsByGroup, layoutParallelNodesPerColumn, layoutParallelSubGroupsPerRow, nodeSize, layoutNodeGroup, layoutParallelNodeSubGroup, layoutParallelGroupSpacing } = config;
  const activeWidth = width - configuredNodeSize(nodeSize);
  const activeHeight = height - configuredNodeSize(nodeSize) - (nonConnectedNodes.length ? configuredNodeSize(nodeSize) * 5 : 0);
  const layoutNodes = layoutNonConnectedAside ? connectedNodes : nodes4;
  const groupNames = unique(layoutNodes.map((d) => getString(d, layoutNodeGroup, d._index)));
  const groupNamesSorted = sortBy(groupNames, (d) => layoutGroupOrder.indexOf(d));
  const groups2 = groupNamesSorted.map((groupName) => {
    const groupNodes = layoutNodes.filter((d) => getString(d, layoutNodeGroup, d._index) === groupName);
    const groupedBySubgroup = groupBy(groupNodes, (d) => getString(d, layoutParallelNodeSubGroup, d._index));
    const subgroups = Object.keys(groupedBySubgroup).map((name2) => ({
      nodes: groupedBySubgroup[name2],
      name: name2
    }));
    return {
      name: groupName,
      nodes: groupNodes,
      subgroups
    };
  });
  const group3 = groups2.find((g) => g.name === layoutParallelSortConnectionsByGroup);
  if (group3) {
    const sortMap = {};
    let idx = 0;
    group3.subgroups.forEach((subgroup) => {
      subgroup.nodes.forEach((node4) => {
        node4.links.forEach((link7) => {
          const linkTargetId = link7 === null || link7 === void 0 ? void 0 : link7.target._id;
          sortMap[linkTargetId] = idx;
          idx = idx + 1;
        });
      });
    });
    without(groups2, group3).forEach((g) => {
      g.subgroups.forEach((subgroup) => {
        subgroup.nodes.sort((a4, b) => {
          return (sortMap[a4._id] || 0) - (sortMap[b._id] || 0);
        });
      });
    });
  }
  const maxN = max(groups2, (d) => {
    var _a;
    return (_a = d.nodes) === null || _a === void 0 ? void 0 : _a.length;
  });
  const labelApprxHeight = 40;
  const labelMargin = 10;
  const subgroupMargin = 40;
  const maxNodeSize = getMaxNodeSize(layoutNodes, nodeSize);
  if (orientation === "horizontal") {
    const minHorizontalStep = 2 * maxNodeSize + labelMargin;
    const maxHorizontalStep = 3.5 * maxNodeSize + labelMargin;
    const horizontalStep = clamp(activeWidth / (maxN - 1), minHorizontalStep, maxHorizontalStep);
    const maxVerticalStep = maxNodeSize * 4 + labelApprxHeight;
    const minVerticalStep = maxNodeSize * 1.5 + labelApprxHeight;
    const verticalStep = maxNodeSize + layoutParallelGroupSpacing || clamp(activeHeight / (groups2.length - 1), minVerticalStep, maxVerticalStep);
    const subgroupNodeStep = maxNodeSize + labelApprxHeight + labelMargin;
    let y06 = groups2.length < 2 ? height / 2 : 0;
    groups2.forEach((group4) => {
      let x06 = 0;
      let dy = 0;
      let subgroupMaxWidth = 0;
      let groupWidth = 0;
      let groupHeight = 0;
      let k4 = 0;
      group4.subgroups.forEach((subgroup) => {
        const subgroupRows = Math.ceil(subgroup.nodes.length / layoutParallelNodesPerColumn);
        let n = 0;
        let x3 = x06;
        let y3 = y06 + dy;
        subgroup.nodes.forEach((d) => {
          x3 = x3 + horizontalStep;
          d.x = x3;
          d.y = y3;
          groupWidth = Math.max(groupWidth, x3);
          n = n + 1;
          if (n >= layoutParallelNodesPerColumn) {
            n = 0;
            y3 += subgroupNodeStep;
            x3 = x06;
          }
        });
        const subgroupWidth = Math.min(subgroup.nodes.length, layoutParallelNodesPerColumn) * horizontalStep;
        const subgroupHeight = subgroupRows * subgroupNodeStep;
        subgroupMaxWidth = Math.max(subgroupMaxWidth, subgroupWidth);
        dy = dy + subgroupHeight + subgroupMargin;
        k4 = k4 + 1;
        if (k4 >= layoutParallelSubGroupsPerRow) {
          k4 = 0;
          dy = 0;
          x06 = x06 + subgroupMaxWidth + subgroupMargin;
          subgroupMaxWidth = 0;
        }
        groupHeight = Math.max(groupHeight, y3);
      });
      group4.subgroups.forEach((subgroup) => {
        subgroup.nodes.forEach((d) => {
          d.x -= groupWidth / 2;
        });
      });
      groupWidth = 0;
      y06 = groupHeight + verticalStep;
    });
  } else {
    const minHorizontalStep = 6 * maxNodeSize + labelMargin;
    const maxHorizontalStep = 10 * maxNodeSize + labelMargin;
    const horizontalStep = maxNodeSize + layoutParallelGroupSpacing || clamp(activeWidth / (maxN - 1), minHorizontalStep, maxHorizontalStep);
    const maxVerticalStep = maxNodeSize * 2 + labelApprxHeight;
    const minVerticalStep = maxNodeSize * 1.5 + labelApprxHeight;
    const verticalStep = clamp(activeHeight / (groups2.length - 1), minVerticalStep, maxVerticalStep);
    const subgroupNodeStep = maxNodeSize * 2;
    let x06 = groups2.length < 2 ? width / 2 : 0;
    groups2.forEach((group4) => {
      let y06 = 0;
      let dx = 0;
      let subgroupMaxHeight = 0;
      let groupWidth = 0;
      let groupHeight = 0;
      let k4 = 0;
      group4.subgroups.forEach((subgroup) => {
        const subgroupColumns = Math.ceil(subgroup.nodes.length / layoutParallelNodesPerColumn);
        let n = 0;
        let y3 = y06;
        let x3 = x06 + dx;
        subgroup.nodes.forEach((d) => {
          y3 = y3 + verticalStep;
          d.x = x3;
          d.y = y3;
          groupHeight = Math.max(groupHeight, y3);
          n = n + 1;
          if (n >= layoutParallelNodesPerColumn) {
            n = 0;
            x3 += subgroupNodeStep;
            y3 = y06;
          }
        });
        const subgroupHeight = Math.min(subgroup.nodes.length, layoutParallelNodesPerColumn) * verticalStep;
        const subgroupWidth = subgroupColumns * subgroupNodeStep;
        subgroupMaxHeight = Math.max(subgroupMaxHeight, subgroupHeight);
        dx = dx + subgroupWidth + subgroupMargin;
        k4 = k4 + 1;
        if (k4 >= layoutParallelSubGroupsPerRow) {
          k4 = 0;
          dx = 0;
          y06 = y06 + subgroupMaxHeight + subgroupMargin;
          subgroupMaxHeight = 0;
        }
        groupWidth = Math.max(groupWidth, x3);
      });
      group4.subgroups.forEach((subgroup) => {
        subgroup.nodes.forEach((d) => {
          d.y -= groupHeight / 2;
        });
      });
      groupHeight = 0;
      x06 = groupWidth + horizontalStep;
    });
  }
  if (layoutNonConnectedAside) {
    const maxSize = getMaxNodeSize(nonConnectedNodes, nodeSize);
    const maxY = max(connectedNodes.map((d) => d.y)) || 0;
    const maxX = max(connectedNodes.map((d) => d.x)) || 0;
    const minX = min(connectedNodes.map((d) => d.x)) || 0;
    const graphWidth = maxX - minX || width;
    positionNonConnectedNodes(nonConnectedNodes, maxY + maxSize * 3, maxSize * 2.25, Math.max(graphWidth, width));
  }
}
function applyLayoutDagre(datamodel, config, width) {
  return __awaiter(this, void 0, void 0, function* () {
    const { nonConnectedNodes, connectedNodes, nodes: nodes4, links: links5 } = datamodel;
    const { nodeSize, layoutNonConnectedAside, dagreLayoutSettings, nodeStrokeWidth, nodeLabel } = config;
    const { Graph: Graph2 } = yield import("./dist-HGASM7XE.js");
    const { layout } = yield import("./dist-324TQEBI.js");
    const dagreGraph = new Graph2();
    dagreGraph.setGraph(dagreLayoutSettings);
    dagreGraph.setDefaultEdgeLabel(() => ({}));
    const labelApprxHeight = 40;
    const nds = layoutNonConnectedAside ? connectedNodes : nodes4;
    nds.forEach((node4) => {
      dagreGraph.setNode(`${node4._index}`, {
        label: getString(node4, nodeLabel, node4._index),
        width: getNumber(node4, nodeSize, node4._index) * 1.5 + getNumber(node4, nodeStrokeWidth, node4._index),
        height: labelApprxHeight + getNumber(node4, nodeSize, node4._index) * 1.5,
        originalNode: node4
      });
    });
    links5.forEach((link7) => {
      dagreGraph.setEdge(`${link7.source._index}`, `${link7.target._index}`);
    });
    layout(dagreGraph);
    dagreGraph.nodes().forEach((d) => {
      const node4 = dagreGraph.node(d);
      node4.originalNode.x = node4.x;
      node4.originalNode.y = node4.y;
    });
    if (layoutNonConnectedAside) {
      const maxNodeSize = getMaxNodeSize(nonConnectedNodes, nodeSize);
      const maxY = max(connectedNodes.map((d) => d.y));
      const maxX = max(connectedNodes.map((d) => d.x));
      const minX = min(connectedNodes.map((d) => d.x));
      const graphWidth = maxX - minX;
      positionNonConnectedNodes(nonConnectedNodes, maxY + maxNodeSize * 3, maxNodeSize * 2.25, Math.max(graphWidth, width), 0);
    }
  });
}
function applyLayoutConcentric(datamodel, config, width, height) {
  var _a, _b;
  const { nonConnectedNodes, connectedNodes, nodes: nodes4 } = datamodel;
  const { layoutNonConnectedAside, layoutGroupOrder, nodeSize, layoutNodeGroup } = config;
  const layoutNodes = layoutNonConnectedAside ? connectedNodes : nodes4;
  const groupNames = unique(layoutNodes.map((d) => getString(d, layoutNodeGroup, d._index)));
  const groupNamesSorted = sortBy(groupNames, (d) => layoutGroupOrder.indexOf(d));
  const groups2 = groupNamesSorted.map((groupName) => ({
    name: groupName,
    nodes: layoutNodes.filter((d) => getString(d, layoutNodeGroup, d._index) === groupName)
  }));
  let r = 2 * getAverageNodeSize((_b = (_a = groups2[0]) === null || _a === void 0 ? void 0 : _a.nodes) !== null && _b !== void 0 ? _b : [], nodeSize);
  const widthToHeightRatio = width / height;
  groups2.forEach((group3, i) => {
    const avgNodeSize = getAverageNodeSize(group3.nodes, nodeSize);
    const requiredRadius = 1.1 * avgNodeSize * group3.nodes.length / Math.PI;
    if (r < requiredRadius)
      r = requiredRadius;
    group3.nodes.forEach((node4, j) => {
      if (i === 0 && group3.nodes.length === 1) {
        node4.x = width / 2;
        node4.y = height / 2;
      } else {
        let dAngle = 0;
        if (i === 0 && group3.nodes.length === 3)
          dAngle = Math.PI / 6;
        if (i === 0 && group3.nodes.length === 4)
          dAngle = Math.PI / 4;
        const angle = 2 * j * Math.PI / group3.nodes.length + i * Math.PI / 12 + dAngle;
        node4.x = width / 2 + r * Math.cos(angle) * widthToHeightRatio;
        node4.y = height / 2 + r * Math.sin(angle);
      }
    });
    const groupSpacing = avgNodeSize * 3;
    r += groupSpacing;
  });
  if (layoutNonConnectedAside) {
    const maxSize = getMaxNodeSize(nonConnectedNodes, nodeSize);
    const maxY = max(connectedNodes.map((d) => d.y));
    const maxX = max(connectedNodes.map((d) => d.x));
    const minX = min(connectedNodes.map((d) => d.x));
    const graphWidth = maxX - minX;
    positionNonConnectedNodes(nonConnectedNodes, maxY + maxSize * 3, maxSize * 2.25, graphWidth, minX);
  }
}
function applyLayoutForce(datamodel, config, width) {
  var _a;
  return __awaiter(this, void 0, void 0, function* () {
    const { layoutNonConnectedAside, forceLayoutSettings, nodeSize } = config;
    const { forceSimulation, forceLink, forceManyBody, forceX, forceY, forceCollide } = yield import("./src-ATWJTNOT.js");
    const { nonConnectedNodes, connectedNodes, nodes: nodes4, links: links5 } = datamodel;
    if (forceLayoutSettings.fixNodePositionAfterSimulation) {
      nodes4.forEach((d) => {
        d.fx = isNil(d._state.fx) ? void 0 : d._state.fx;
        d.fy = isNil(d._state.fy) ? void 0 : d._state.fy;
      });
    } else {
      nodes4.forEach((d) => {
        delete d._state.fx;
        delete d._state.fy;
      });
    }
    const simulation = forceSimulation(layoutNonConnectedAside ? connectedNodes : nodes4).force("link", forceLink(links5).id((d) => String(d._id)).distance((l, i) => isFunction(forceLayoutSettings.linkDistance) ? forceLayoutSettings.linkDistance(l, i) : forceLayoutSettings.linkDistance).strength((l, i) => isFunction(forceLayoutSettings.linkStrength) ? forceLayoutSettings.linkStrength(l, i) : forceLayoutSettings.linkStrength)).force("charge", forceManyBody().strength((d, i) => {
      if (isFunction(forceLayoutSettings.charge)) {
        return forceLayoutSettings.charge(d, i);
      } else {
        const linkCount = links5.reduce((count3, l) => count3 + Number(l.source === d || l.target === d), 0);
        return forceLayoutSettings.charge * Math.sqrt(linkCount);
      }
    })).force("x", forceX().strength(forceLayoutSettings.forceXStrength)).force("y", forceY().strength(forceLayoutSettings.forceYStrength)).force("collide", forceCollide().radius((d, i) => getNodeSize(d, nodeSize, i)).iterations(1)).stop();
    const numIterations = (_a = forceLayoutSettings.numIterations) !== null && _a !== void 0 ? _a : Math.ceil(Math.log(simulation.alphaMin()) / Math.log(1 - simulation.alphaDecay()));
    for (let i = 0, n = numIterations; i < n; ++i) {
      simulation.tick();
    }
    if (forceLayoutSettings.fixNodePositionAfterSimulation) {
      nodes4.forEach((d) => {
        delete d.fx;
        delete d.fy;
        d._state.fx = d.x;
        d._state.fy = d.y;
      });
    }
    if (layoutNonConnectedAside) {
      const maxSize = getMaxNodeSize(nonConnectedNodes, nodeSize);
      const maxY = max(connectedNodes.map((d) => d.y));
      const maxX = max(connectedNodes.map((d) => d.x));
      const minX = min(connectedNodes.map((d) => d.x));
      const graphWidth = maxX - minX;
      positionNonConnectedNodes(nonConnectedNodes, maxY + maxSize * 6, maxSize * 2.25, Math.max(graphWidth, width), minX);
    }
  });
}
function applyELKLayout(datamodel, config, width) {
  return __awaiter(this, void 0, void 0, function* () {
    const ELK = (yield import("./elk.bundled-ZU46KOCZ.js")).default;
    const elk = new ELK();
    const labelApprxHeight = 30;
    const nodes4 = datamodel.nodes.map((n) => Object.assign(Object.assign({}, n), { id: n._id, width: getNumber(n, config.nodeSize, n._index) + getNumber(n, config.nodeStrokeWidth, n._index), height: getNumber(n, config.nodeSize, n._index) + labelApprxHeight }));
    let elkNodes;
    if (config.layoutElkNodeGroups) {
      const groupingFunctions = config.layoutElkNodeGroups.map((accessor) => (d) => getString(d, accessor, d._index));
      const grouped = group(nodes4, ...groupingFunctions);
      elkNodes = toElkHierarchy(grouped, config.layoutElkSettings);
   