import {
  Comment,
  Fragment,
  Teleport,
  camelize,
  cloneVNode,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createTextVNode,
  createVNode,
  customRef,
  defineComponent,
  effectScope,
  getCurrentInstance,
  getCurrentScope,
  guardReactiveProps,
  h,
  inject,
  isRef,
  markRaw,
  mergeDefaults,
  mergeProps,
  nextTick,
  normalizeProps,
  normalizeStyle,
  onBeforeMount,
  onBeforeUnmount,
  onBeforeUpdate,
  onMounted,
  onScopeDispose,
  onUnmounted,
  onUpdated,
  openBlock,
  provide,
  reactive,
  readonly,
  ref,
  renderList,
  renderSlot,
  resolveDynamicComponent,
  shallowReadonly,
  shallowRef,
  toDisplayString,
  toHandlerKey,
  toHandlers,
  toRaw,
  toRef,
  toRefs,
  triggerRef,
  unref,
  useSlots,
  vModelSelect,
  vShow,
  watch,
  watchEffect,
  withCtx,
  withDirectives,
  withKeys,
  withModifiers
} from "./chunk-6PAIEJPD.js";
import "./chunk-PR4QN5HX.js";

// node_modules/@internationalized/date/dist/utils.mjs
function $2b4dce13dd5a17fa$export$842a2cf37af977e1(amount, numerator) {
  return amount - numerator * Math.floor(amount / numerator);
}

// node_modules/@internationalized/date/dist/GregorianCalendar.mjs
var $3b62074eb05584b2$var$EPOCH = 1721426;
function $3b62074eb05584b2$export$f297eb839006d339(era, year, month, day) {
  year = $3b62074eb05584b2$export$c36e0ecb2d4fa69d(era, year);
  let y1 = year - 1;
  let monthOffset = -2;
  if (month <= 2) monthOffset = 0;
  else if ($3b62074eb05584b2$export$553d7fa8e3805fc0(year)) monthOffset = -1;
  return $3b62074eb05584b2$var$EPOCH - 1 + 365 * y1 + Math.floor(y1 / 4) - Math.floor(y1 / 100) + Math.floor(y1 / 400) + Math.floor((367 * month - 362) / 12 + monthOffset + day);
}
function $3b62074eb05584b2$export$553d7fa8e3805fc0(year) {
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
function $3b62074eb05584b2$export$c36e0ecb2d4fa69d(era, year) {
  return era === "BC" ? 1 - year : year;
}
function $3b62074eb05584b2$export$4475b7e617eb123c(year) {
  let era = "AD";
  if (year <= 0) {
    era = "BC";
    year = 1 - year;
  }
  return [
    era,
    year
  ];
}
var $3b62074eb05584b2$var$daysInMonth = {
  standard: [
    31,
    28,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
  ],
  leapyear: [
    31,
    29,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
  ]
};
var $3b62074eb05584b2$export$80ee6245ec4f29ec = class {
  fromJulianDay(jd2) {
    let jd0 = jd2;
    let depoch = jd0 - $3b62074eb05584b2$var$EPOCH;
    let quadricent = Math.floor(depoch / 146097);
    let dqc = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(depoch, 146097);
    let cent = Math.floor(dqc / 36524);
    let dcent = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(dqc, 36524);
    let quad = Math.floor(dcent / 1461);
    let dquad = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(dcent, 1461);
    let yindex = Math.floor(dquad / 365);
    let extendedYear = quadricent * 400 + cent * 100 + quad * 4 + yindex + (cent !== 4 && yindex !== 4 ? 1 : 0);
    let [era, year] = $3b62074eb05584b2$export$4475b7e617eb123c(extendedYear);
    let yearDay = jd0 - $3b62074eb05584b2$export$f297eb839006d339(era, year, 1, 1);
    let leapAdj = 2;
    if (jd0 < $3b62074eb05584b2$export$f297eb839006d339(era, year, 3, 1)) leapAdj = 0;
    else if ($3b62074eb05584b2$export$553d7fa8e3805fc0(year)) leapAdj = 1;
    let month = Math.floor(((yearDay + leapAdj) * 12 + 373) / 367);
    let day = jd0 - $3b62074eb05584b2$export$f297eb839006d339(era, year, month, 1) + 1;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, month, day);
  }
  toJulianDay(date) {
    return $3b62074eb05584b2$export$f297eb839006d339(date.era, date.year, date.month, date.day);
  }
  getDaysInMonth(date) {
    return $3b62074eb05584b2$var$daysInMonth[$3b62074eb05584b2$export$553d7fa8e3805fc0(date.year) ? "leapyear" : "standard"][date.month - 1];
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getMonthsInYear(date) {
    return 12;
  }
  getDaysInYear(date) {
    return $3b62074eb05584b2$export$553d7fa8e3805fc0(date.year) ? 366 : 365;
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getYearsInEra(date) {
    return 9999;
  }
  getEras() {
    return [
      "BC",
      "AD"
    ];
  }
  isInverseEra(date) {
    return date.era === "BC";
  }
  balanceDate(date) {
    if (date.year <= 0) {
      date.era = date.era === "BC" ? "AD" : "BC";
      date.year = 1 - date.year;
    }
  }
  constructor() {
    this.identifier = "gregory";
  }
};

// node_modules/@internationalized/date/dist/weekStartData.mjs
var $2fe286d2fb449abb$export$7a5acbd77d414bd9 = {
  "001": 1,
  AD: 1,
  AE: 6,
  AF: 6,
  AI: 1,
  AL: 1,
  AM: 1,
  AN: 1,
  AR: 1,
  AT: 1,
  AU: 1,
  AX: 1,
  AZ: 1,
  BA: 1,
  BE: 1,
  BG: 1,
  BH: 6,
  BM: 1,
  BN: 1,
  BY: 1,
  CH: 1,
  CL: 1,
  CM: 1,
  CN: 1,
  CR: 1,
  CY: 1,
  CZ: 1,
  DE: 1,
  DJ: 6,
  DK: 1,
  DZ: 6,
  EC: 1,
  EE: 1,
  EG: 6,
  ES: 1,
  FI: 1,
  FJ: 1,
  FO: 1,
  FR: 1,
  GB: 1,
  GE: 1,
  GF: 1,
  GP: 1,
  GR: 1,
  HR: 1,
  HU: 1,
  IE: 1,
  IQ: 6,
  IR: 6,
  IS: 1,
  IT: 1,
  JO: 6,
  KG: 1,
  KW: 6,
  KZ: 1,
  LB: 1,
  LI: 1,
  LK: 1,
  LT: 1,
  LU: 1,
  LV: 1,
  LY: 6,
  MC: 1,
  MD: 1,
  ME: 1,
  MK: 1,
  MN: 1,
  MQ: 1,
  MV: 5,
  MY: 1,
  NL: 1,
  NO: 1,
  NZ: 1,
  OM: 6,
  PL: 1,
  QA: 6,
  RE: 1,
  RO: 1,
  RS: 1,
  RU: 1,
  SD: 6,
  SE: 1,
  SI: 1,
  SK: 1,
  SM: 1,
  SY: 6,
  TJ: 1,
  TM: 1,
  TR: 1,
  UA: 1,
  UY: 1,
  UZ: 1,
  VA: 1,
  VN: 1,
  XK: 1
};

// node_modules/@internationalized/date/dist/queries.mjs
function $14e0f24ef4ac5c92$export$ea39ec197993aef0(a2, b2) {
  b2 = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b2, a2.calendar);
  return a2.era === b2.era && a2.year === b2.year && a2.month === b2.month && a2.day === b2.day;
}
function $14e0f24ef4ac5c92$export$a18c89cbd24170ff(a2, b2) {
  b2 = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b2, a2.calendar);
  a2 = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(a2);
  b2 = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(b2);
  return a2.era === b2.era && a2.year === b2.year && a2.month === b2.month;
}
function $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(a2, b2) {
  return a2.calendar.identifier === b2.calendar.identifier && a2.era === b2.era && a2.year === b2.year && a2.month === b2.month && a2.day === b2.day;
}
function $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(a2, b2) {
  a2 = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(a2);
  b2 = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(b2);
  return a2.calendar.identifier === b2.calendar.identifier && a2.era === b2.era && a2.year === b2.year && a2.month === b2.month;
}
function $14e0f24ef4ac5c92$export$629b0a497aa65267(date, timeZone) {
  return $14e0f24ef4ac5c92$export$ea39ec197993aef0(date, $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3(timeZone));
}
function $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale) {
  let julian = date.calendar.toJulianDay(date);
  let dayOfWeek = Math.ceil(julian + 1 - $14e0f24ef4ac5c92$var$getWeekStart(locale)) % 7;
  if (dayOfWeek < 0) dayOfWeek += 7;
  return dayOfWeek;
}
function $14e0f24ef4ac5c92$export$461939dd4422153(timeZone) {
  return (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(Date.now(), timeZone);
}
function $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3(timeZone) {
  return (0, $11d87f3f76e88657$export$93522d1a439f3617)($14e0f24ef4ac5c92$export$461939dd4422153(timeZone));
}
function $14e0f24ef4ac5c92$export$68781ddf31c0090f(a2, b2) {
  return a2.calendar.toJulianDay(a2) - b2.calendar.toJulianDay(b2);
}
function $14e0f24ef4ac5c92$export$c19a80a9721b80f6(a2, b2) {
  return $14e0f24ef4ac5c92$var$timeToMs(a2) - $14e0f24ef4ac5c92$var$timeToMs(b2);
}
function $14e0f24ef4ac5c92$var$timeToMs(a2) {
  return a2.hour * 36e5 + a2.minute * 6e4 + a2.second * 1e3 + a2.millisecond;
}
var $14e0f24ef4ac5c92$var$localTimeZone = null;
function $14e0f24ef4ac5c92$export$aa8b41735afcabd2() {
  if ($14e0f24ef4ac5c92$var$localTimeZone == null) $14e0f24ef4ac5c92$var$localTimeZone = new Intl.DateTimeFormat().resolvedOptions().timeZone;
  return $14e0f24ef4ac5c92$var$localTimeZone;
}
function $14e0f24ef4ac5c92$export$a5a3b454ada2268e(date) {
  return date.subtract({
    days: date.day - 1
  });
}
function $14e0f24ef4ac5c92$export$a2258d9c4118825c(date) {
  return date.add({
    days: date.calendar.getDaysInMonth(date) - date.day
  });
}
var $14e0f24ef4ac5c92$var$cachedRegions = /* @__PURE__ */ new Map();
function $14e0f24ef4ac5c92$var$getRegion(locale) {
  if (Intl.Locale) {
    let region = $14e0f24ef4ac5c92$var$cachedRegions.get(locale);
    if (!region) {
      region = new Intl.Locale(locale).maximize().region;
      if (region) $14e0f24ef4ac5c92$var$cachedRegions.set(locale, region);
    }
    return region;
  }
  let part = locale.split("-")[1];
  return part === "u" ? void 0 : part;
}
function $14e0f24ef4ac5c92$var$getWeekStart(locale) {
  let region = $14e0f24ef4ac5c92$var$getRegion(locale);
  return region ? (0, $2fe286d2fb449abb$export$7a5acbd77d414bd9)[region] || 0 : 0;
}

// node_modules/@internationalized/date/dist/conversion.mjs
function $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) {
  date = $11d87f3f76e88657$export$b4a036af3fc0b032(date, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
  let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(date.era, date.year);
  return $11d87f3f76e88657$var$epochFromParts(year, date.month, date.day, date.hour, date.minute, date.second, date.millisecond);
}
function $11d87f3f76e88657$var$epochFromParts(year, month, day, hour, minute, second, millisecond) {
  let date = /* @__PURE__ */ new Date();
  date.setUTCHours(hour, minute, second, millisecond);
  date.setUTCFullYear(year, month - 1, day);
  return date.getTime();
}
function $11d87f3f76e88657$export$59c99f3515d3493f(ms2, timeZone) {
  if (timeZone === "UTC") return 0;
  if (ms2 > 0 && timeZone === (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)()) return new Date(ms2).getTimezoneOffset() * -6e4;
  let { year, month, day, hour, minute, second } = $11d87f3f76e88657$var$getTimeZoneParts(ms2, timeZone);
  let utc = $11d87f3f76e88657$var$epochFromParts(year, month, day, hour, minute, second, 0);
  return utc - Math.floor(ms2 / 1e3) * 1e3;
}
var $11d87f3f76e88657$var$formattersByTimeZone = /* @__PURE__ */ new Map();
function $11d87f3f76e88657$var$getTimeZoneParts(ms2, timeZone) {
  let formatter = $11d87f3f76e88657$var$formattersByTimeZone.get(timeZone);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat("en-US", {
      timeZone,
      hour12: false,
      era: "short",
      year: "numeric",
      month: "numeric",
      day: "numeric",
      hour: "numeric",
      minute: "numeric",
      second: "numeric"
    });
    $11d87f3f76e88657$var$formattersByTimeZone.set(timeZone, formatter);
  }
  let parts = formatter.formatToParts(new Date(ms2));
  let namedParts = {};
  for (let part of parts) if (part.type !== "literal") namedParts[part.type] = part.value;
  return {
    // Firefox returns B instead of BC... https://bugzilla.mozilla.org/show_bug.cgi?id=1752253
    year: namedParts.era === "BC" || namedParts.era === "B" ? -namedParts.year + 1 : +namedParts.year,
    month: +namedParts.month,
    day: +namedParts.day,
    hour: namedParts.hour === "24" ? 0 : +namedParts.hour,
    minute: +namedParts.minute,
    second: +namedParts.second
  };
}
var $11d87f3f76e88657$var$DAYMILLIS = 864e5;
function $11d87f3f76e88657$var$getValidWallTimes(date, timeZone, earlier, later) {
  let found = earlier === later ? [
    earlier
  ] : [
    earlier,
    later
  ];
  return found.filter((absolute) => $11d87f3f76e88657$var$isValidWallTime(date, timeZone, absolute));
}
function $11d87f3f76e88657$var$isValidWallTime(date, timeZone, absolute) {
  let parts = $11d87f3f76e88657$var$getTimeZoneParts(absolute, timeZone);
  return date.year === parts.year && date.month === parts.month && date.day === parts.day && date.hour === parts.hour && date.minute === parts.minute && date.second === parts.second;
}
function $11d87f3f76e88657$export$5107c82f94518f5c(date, timeZone, disambiguation = "compatible") {
  let dateTime = $11d87f3f76e88657$export$b21e0b124e224484(date);
  if (timeZone === "UTC") return $11d87f3f76e88657$export$bd4fb2bc8bb06fb(dateTime);
  if (timeZone === (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)() && disambiguation === "compatible") {
    dateTime = $11d87f3f76e88657$export$b4a036af3fc0b032(dateTime, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
    let date2 = /* @__PURE__ */ new Date();
    let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(dateTime.era, dateTime.year);
    date2.setFullYear(year, dateTime.month - 1, dateTime.day);
    date2.setHours(dateTime.hour, dateTime.minute, dateTime.second, dateTime.millisecond);
    return date2.getTime();
  }
  let ms2 = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(dateTime);
  let offsetBefore = $11d87f3f76e88657$export$59c99f3515d3493f(ms2 - $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let offsetAfter = $11d87f3f76e88657$export$59c99f3515d3493f(ms2 + $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let valid = $11d87f3f76e88657$var$getValidWallTimes(dateTime, timeZone, ms2 - offsetBefore, ms2 - offsetAfter);
  if (valid.length === 1) return valid[0];
  if (valid.length > 1) switch (disambiguation) {
    case "compatible":
    case "earlier":
      return valid[0];
    case "later":
      return valid[valid.length - 1];
    case "reject":
      throw new RangeError("Multiple possible absolute times found");
  }
  switch (disambiguation) {
    case "earlier":
      return Math.min(ms2 - offsetBefore, ms2 - offsetAfter);
    case "compatible":
    case "later":
      return Math.max(ms2 - offsetBefore, ms2 - offsetAfter);
    case "reject":
      throw new RangeError("No such absolute time found");
  }
}
function $11d87f3f76e88657$export$e67a095c620b86fe(dateTime, timeZone, disambiguation = "compatible") {
  return new Date($11d87f3f76e88657$export$5107c82f94518f5c(dateTime, timeZone, disambiguation));
}
function $11d87f3f76e88657$export$1b96692a1ba042ac(ms2, timeZone) {
  let offset3 = $11d87f3f76e88657$export$59c99f3515d3493f(ms2, timeZone);
  let date = new Date(ms2 + offset3);
  let year = date.getUTCFullYear();
  let month = date.getUTCMonth() + 1;
  let day = date.getUTCDate();
  let hour = date.getUTCHours();
  let minute = date.getUTCMinutes();
  let second = date.getUTCSeconds();
  let millisecond = date.getUTCMilliseconds();
  return new (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)(year, month, day, timeZone, offset3, hour, minute, second, millisecond);
}
function $11d87f3f76e88657$export$93522d1a439f3617(dateTime) {
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(dateTime.calendar, dateTime.era, dateTime.year, dateTime.month, dateTime.day);
}
function $11d87f3f76e88657$export$b21e0b124e224484(date, time) {
  let hour = 0, minute = 0, second = 0, millisecond = 0;
  if ("timeZone" in date) ({ hour, minute, second, millisecond } = date);
  else if ("hour" in date && !time) return date;
  if (time) ({ hour, minute, second, millisecond } = time);
  return new (0, $35ea8db9cb2ccb90$export$ca871e8dbb80966f)(date.calendar, date.era, date.year, date.month, date.day, hour, minute, second, millisecond);
}
function $11d87f3f76e88657$export$b4a036af3fc0b032(date, calendar) {
  if (date.calendar.identifier === calendar.identifier) return date;
  let calendarDate = calendar.fromJulianDay(date.calendar.toJulianDay(date));
  let copy = date.copy();
  copy.calendar = calendar;
  copy.era = calendarDate.era;
  copy.year = calendarDate.year;
  copy.month = calendarDate.month;
  copy.day = calendarDate.day;
  (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(copy);
  return copy;
}
function $11d87f3f76e88657$export$84c95a83c799e074(date, timeZone, disambiguation) {
  if (date instanceof (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)) {
    if (date.timeZone === timeZone) return date;
    return $11d87f3f76e88657$export$538b00033cc11c75(date, timeZone);
  }
  let ms2 = $11d87f3f76e88657$export$5107c82f94518f5c(date, timeZone, disambiguation);
  return $11d87f3f76e88657$export$1b96692a1ba042ac(ms2, timeZone);
}
function $11d87f3f76e88657$export$83aac07b4c37b25(date) {
  let ms2 = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) - date.offset;
  return new Date(ms2);
}
function $11d87f3f76e88657$export$538b00033cc11c75(date, timeZone) {
  let ms2 = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) - date.offset;
  return $11d87f3f76e88657$export$b4a036af3fc0b032($11d87f3f76e88657$export$1b96692a1ba042ac(ms2, timeZone), date.calendar);
}

// node_modules/@internationalized/date/dist/manipulation.mjs
var $735220c2d4774dd3$var$ONE_HOUR = 36e5;
function $735220c2d4774dd3$export$e16d8520af44a096(date, duration) {
  let mutableDate = date.copy();
  let days = "hour" in mutableDate ? $735220c2d4774dd3$var$addTimeFields(mutableDate, duration) : 0;
  $735220c2d4774dd3$var$addYears(mutableDate, duration.years || 0);
  if (mutableDate.calendar.balanceYearMonth) mutableDate.calendar.balanceYearMonth(mutableDate, date);
  mutableDate.month += duration.months || 0;
  $735220c2d4774dd3$var$balanceYearMonth(mutableDate);
  $735220c2d4774dd3$var$constrainMonthDay(mutableDate);
  mutableDate.day += (duration.weeks || 0) * 7;
  mutableDate.day += duration.days || 0;
  mutableDate.day += days;
  $735220c2d4774dd3$var$balanceDay(mutableDate);
  if (mutableDate.calendar.balanceDate) mutableDate.calendar.balanceDate(mutableDate);
  if (mutableDate.year < 1) {
    mutableDate.year = 1;
    mutableDate.month = 1;
    mutableDate.day = 1;
  }
  let maxYear = mutableDate.calendar.getYearsInEra(mutableDate);
  if (mutableDate.year > maxYear) {
    var _mutableDate_calendar_isInverseEra, _mutableDate_calendar;
    let isInverseEra = (_mutableDate_calendar_isInverseEra = (_mutableDate_calendar = mutableDate.calendar).isInverseEra) === null || _mutableDate_calendar_isInverseEra === void 0 ? void 0 : _mutableDate_calendar_isInverseEra.call(_mutableDate_calendar, mutableDate);
    mutableDate.year = maxYear;
    mutableDate.month = isInverseEra ? 1 : mutableDate.calendar.getMonthsInYear(mutableDate);
    mutableDate.day = isInverseEra ? 1 : mutableDate.calendar.getDaysInMonth(mutableDate);
  }
  if (mutableDate.month < 1) {
    mutableDate.month = 1;
    mutableDate.day = 1;
  }
  let maxMonth = mutableDate.calendar.getMonthsInYear(mutableDate);
  if (mutableDate.month > maxMonth) {
    mutableDate.month = maxMonth;
    mutableDate.day = mutableDate.calendar.getDaysInMonth(mutableDate);
  }
  mutableDate.day = Math.max(1, Math.min(mutableDate.calendar.getDaysInMonth(mutableDate), mutableDate.day));
  return mutableDate;
}
function $735220c2d4774dd3$var$addYears(date, years) {
  var _date_calendar_isInverseEra, _date_calendar;
  if ((_date_calendar_isInverseEra = (_date_calendar = date.calendar).isInverseEra) === null || _date_calendar_isInverseEra === void 0 ? void 0 : _date_calendar_isInverseEra.call(_date_calendar, date)) years = -years;
  date.year += years;
}
function $735220c2d4774dd3$var$balanceYearMonth(date) {
  while (date.month < 1) {
    $735220c2d4774dd3$var$addYears(date, -1);
    date.month += date.calendar.getMonthsInYear(date);
  }
  let monthsInYear = 0;
  while (date.month > (monthsInYear = date.calendar.getMonthsInYear(date))) {
    date.month -= monthsInYear;
    $735220c2d4774dd3$var$addYears(date, 1);
  }
}
function $735220c2d4774dd3$var$balanceDay(date) {
  while (date.day < 1) {
    date.month--;
    $735220c2d4774dd3$var$balanceYearMonth(date);
    date.day += date.calendar.getDaysInMonth(date);
  }
  while (date.day > date.calendar.getDaysInMonth(date)) {
    date.day -= date.calendar.getDaysInMonth(date);
    date.month++;
    $735220c2d4774dd3$var$balanceYearMonth(date);
  }
}
function $735220c2d4774dd3$var$constrainMonthDay(date) {
  date.month = Math.max(1, Math.min(date.calendar.getMonthsInYear(date), date.month));
  date.day = Math.max(1, Math.min(date.calendar.getDaysInMonth(date), date.day));
}
function $735220c2d4774dd3$export$c4e2ecac49351ef2(date) {
  if (date.calendar.constrainDate) date.calendar.constrainDate(date);
  date.year = Math.max(1, Math.min(date.calendar.getYearsInEra(date), date.year));
  $735220c2d4774dd3$var$constrainMonthDay(date);
}
function $735220c2d4774dd3$export$3e2544e88a25bff8(duration) {
  let inverseDuration = {};
  for (let key in duration) if (typeof duration[key] === "number") inverseDuration[key] = -duration[key];
  return inverseDuration;
}
function $735220c2d4774dd3$export$4e2d2ead65e5f7e3(date, duration) {
  return $735220c2d4774dd3$export$e16d8520af44a096(date, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
function $735220c2d4774dd3$export$adaa4cf7ef1b65be(date, fields) {
  let mutableDate = date.copy();
  if (fields.era != null) mutableDate.era = fields.era;
  if (fields.year != null) mutableDate.year = fields.year;
  if (fields.month != null) mutableDate.month = fields.month;
  if (fields.day != null) mutableDate.day = fields.day;
  $735220c2d4774dd3$export$c4e2ecac49351ef2(mutableDate);
  return mutableDate;
}
function $735220c2d4774dd3$export$e5d5e1c1822b6e56(value, fields) {
  let mutableValue = value.copy();
  if (fields.hour != null) mutableValue.hour = fields.hour;
  if (fields.minute != null) mutableValue.minute = fields.minute;
  if (fields.second != null) mutableValue.second = fields.second;
  if (fields.millisecond != null) mutableValue.millisecond = fields.millisecond;
  $735220c2d4774dd3$export$7555de1e070510cb(mutableValue);
  return mutableValue;
}
function $735220c2d4774dd3$var$balanceTime(time) {
  time.second += Math.floor(time.millisecond / 1e3);
  time.millisecond = $735220c2d4774dd3$var$nonNegativeMod(time.millisecond, 1e3);
  time.minute += Math.floor(time.second / 60);
  time.second = $735220c2d4774dd3$var$nonNegativeMod(time.second, 60);
  time.hour += Math.floor(time.minute / 60);
  time.minute = $735220c2d4774dd3$var$nonNegativeMod(time.minute, 60);
  let days = Math.floor(time.hour / 24);
  time.hour = $735220c2d4774dd3$var$nonNegativeMod(time.hour, 24);
  return days;
}
function $735220c2d4774dd3$export$7555de1e070510cb(time) {
  time.millisecond = Math.max(0, Math.min(time.millisecond, 1e3));
  time.second = Math.max(0, Math.min(time.second, 59));
  time.minute = Math.max(0, Math.min(time.minute, 59));
  time.hour = Math.max(0, Math.min(time.hour, 23));
}
function $735220c2d4774dd3$var$nonNegativeMod(a2, b2) {
  let result = a2 % b2;
  if (result < 0) result += b2;
  return result;
}
function $735220c2d4774dd3$var$addTimeFields(time, duration) {
  time.hour += duration.hours || 0;
  time.minute += duration.minutes || 0;
  time.second += duration.seconds || 0;
  time.millisecond += duration.milliseconds || 0;
  return $735220c2d4774dd3$var$balanceTime(time);
}
function $735220c2d4774dd3$export$d52ced6badfb9a4c(value, field, amount, options) {
  let mutable = value.copy();
  switch (field) {
    case "era": {
      let eras = value.calendar.getEras();
      let eraIndex = eras.indexOf(value.era);
      if (eraIndex < 0) throw new Error("Invalid era: " + value.era);
      eraIndex = $735220c2d4774dd3$var$cycleValue(eraIndex, amount, 0, eras.length - 1, options === null || options === void 0 ? void 0 : options.round);
      mutable.era = eras[eraIndex];
      $735220c2d4774dd3$export$c4e2ecac49351ef2(mutable);
      break;
    }
    case "year":
      var _mutable_calendar_isInverseEra, _mutable_calendar;
      if ((_mutable_calendar_isInverseEra = (_mutable_calendar = mutable.calendar).isInverseEra) === null || _mutable_calendar_isInverseEra === void 0 ? void 0 : _mutable_calendar_isInverseEra.call(_mutable_calendar, mutable)) amount = -amount;
      mutable.year = $735220c2d4774dd3$var$cycleValue(value.year, amount, -Infinity, 9999, options === null || options === void 0 ? void 0 : options.round);
      if (mutable.year === -Infinity) mutable.year = 1;
      if (mutable.calendar.balanceYearMonth) mutable.calendar.balanceYearMonth(mutable, value);
      break;
    case "month":
      mutable.month = $735220c2d4774dd3$var$cycleValue(value.month, amount, 1, value.calendar.getMonthsInYear(value), options === null || options === void 0 ? void 0 : options.round);
      break;
    case "day":
      mutable.day = $735220c2d4774dd3$var$cycleValue(value.day, amount, 1, value.calendar.getDaysInMonth(value), options === null || options === void 0 ? void 0 : options.round);
      break;
    default:
      throw new Error("Unsupported field " + field);
  }
  if (value.calendar.balanceDate) value.calendar.balanceDate(mutable);
  $735220c2d4774dd3$export$c4e2ecac49351ef2(mutable);
  return mutable;
}
function $735220c2d4774dd3$export$dd02b3e0007dfe28(value, field, amount, options) {
  let mutable = value.copy();
  switch (field) {
    case "hour": {
      let hours = value.hour;
      let min2 = 0;
      let max2 = 23;
      if ((options === null || options === void 0 ? void 0 : options.hourCycle) === 12) {
        let isPM = hours >= 12;
        min2 = isPM ? 12 : 0;
        max2 = isPM ? 23 : 11;
      }
      mutable.hour = $735220c2d4774dd3$var$cycleValue(hours, amount, min2, max2, options === null || options === void 0 ? void 0 : options.round);
      break;
    }
    case "minute":
      mutable.minute = $735220c2d4774dd3$var$cycleValue(value.minute, amount, 0, 59, options === null || options === void 0 ? void 0 : options.round);
      break;
    case "second":
      mutable.second = $735220c2d4774dd3$var$cycleValue(value.second, amount, 0, 59, options === null || options === void 0 ? void 0 : options.round);
      break;
    case "millisecond":
      mutable.millisecond = $735220c2d4774dd3$var$cycleValue(value.millisecond, amount, 0, 999, options === null || options === void 0 ? void 0 : options.round);
      break;
    default:
      throw new Error("Unsupported field " + field);
  }
  return mutable;
}
function $735220c2d4774dd3$var$cycleValue(value, amount, min2, max2, round2 = false) {
  if (round2) {
    value += Math.sign(amount);
    if (value < min2) value = max2;
    let div = Math.abs(amount);
    if (amount > 0) value = Math.ceil(value / div) * div;
    else value = Math.floor(value / div) * div;
    if (value > max2) value = min2;
  } else {
    value += amount;
    if (value < min2) value = max2 - (min2 - value - 1);
    else if (value > max2) value = min2 + (value - max2 - 1);
  }
  return value;
}
function $735220c2d4774dd3$export$96b1d28349274637(dateTime, duration) {
  let ms2;
  if (duration.years != null && duration.years !== 0 || duration.months != null && duration.months !== 0 || duration.weeks != null && duration.weeks !== 0 || duration.days != null && duration.days !== 0) {
    let res2 = $735220c2d4774dd3$export$e16d8520af44a096((0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime), {
      years: duration.years,
      months: duration.months,
      weeks: duration.weeks,
      days: duration.days
    });
    ms2 = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res2, dateTime.timeZone);
  } else
    ms2 = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(dateTime) - dateTime.offset;
  ms2 += duration.milliseconds || 0;
  ms2 += (duration.seconds || 0) * 1e3;
  ms2 += (duration.minutes || 0) * 6e4;
  ms2 += (duration.hours || 0) * 36e5;
  let res = (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone);
  return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(res, dateTime.calendar);
}
function $735220c2d4774dd3$export$6814caac34ca03c7(dateTime, duration) {
  return $735220c2d4774dd3$export$96b1d28349274637(dateTime, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
function $735220c2d4774dd3$export$9a297d111fc86b79(dateTime, field, amount, options) {
  switch (field) {
    case "hour": {
      let min2 = 0;
      let max2 = 23;
      if ((options === null || options === void 0 ? void 0 : options.hourCycle) === 12) {
        let isPM = dateTime.hour >= 12;
        min2 = isPM ? 12 : 0;
        max2 = isPM ? 23 : 11;
      }
      let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime);
      let minDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)($735220c2d4774dd3$export$e5d5e1c1822b6e56(plainDateTime, {
        hour: min2
      }), new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
      let minAbsolute = [
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(minDate, dateTime.timeZone, "earlier"),
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(minDate, dateTime.timeZone, "later")
      ].filter((ms3) => (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms3, dateTime.timeZone).day === minDate.day)[0];
      let maxDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)($735220c2d4774dd3$export$e5d5e1c1822b6e56(plainDateTime, {
        hour: max2
      }), new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
      let maxAbsolute = [
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(maxDate, dateTime.timeZone, "earlier"),
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(maxDate, dateTime.timeZone, "later")
      ].filter((ms3) => (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms3, dateTime.timeZone).day === maxDate.day).pop();
      let ms2 = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(dateTime) - dateTime.offset;
      let hours = Math.floor(ms2 / $735220c2d4774dd3$var$ONE_HOUR);
      let remainder = ms2 % $735220c2d4774dd3$var$ONE_HOUR;
      ms2 = $735220c2d4774dd3$var$cycleValue(hours, amount, Math.floor(minAbsolute / $735220c2d4774dd3$var$ONE_HOUR), Math.floor(maxAbsolute / $735220c2d4774dd3$var$ONE_HOUR), options === null || options === void 0 ? void 0 : options.round) * $735220c2d4774dd3$var$ONE_HOUR + remainder;
      return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone), dateTime.calendar);
    }
    case "minute":
    case "second":
    case "millisecond":
      return $735220c2d4774dd3$export$dd02b3e0007dfe28(dateTime, field, amount, options);
    case "era":
    case "year":
    case "month":
    case "day": {
      let res = $735220c2d4774dd3$export$d52ced6badfb9a4c((0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime), field, amount, options);
      let ms2 = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res, dateTime.timeZone);
      return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone), dateTime.calendar);
    }
    default:
      throw new Error("Unsupported field " + field);
  }
}
function $735220c2d4774dd3$export$31b5430eb18be4f8(dateTime, fields, disambiguation) {
  let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime);
  let res = $735220c2d4774dd3$export$e5d5e1c1822b6e56($735220c2d4774dd3$export$adaa4cf7ef1b65be(plainDateTime, fields), fields);
  if (res.compare(plainDateTime) === 0) return dateTime;
  let ms2 = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res, dateTime.timeZone, disambiguation);
  return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone), dateTime.calendar);
}

// node_modules/@internationalized/date/dist/string.mjs
var $fae977aafc393c5c$var$requiredDurationTimeGroups = [
  "hours",
  "minutes",
  "seconds"
];
var $fae977aafc393c5c$var$requiredDurationGroups = [
  "years",
  "months",
  "weeks",
  "days",
  ...$fae977aafc393c5c$var$requiredDurationTimeGroups
];
function $fae977aafc393c5c$export$f59dee82248f5ad4(time) {
  return `${String(time.hour).padStart(2, "0")}:${String(time.minute).padStart(2, "0")}:${String(time.second).padStart(2, "0")}${time.millisecond ? String(time.millisecond / 1e3).slice(1) : ""}`;
}
function $fae977aafc393c5c$export$60dfd74aa96791bd(date) {
  let gregorianDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(date, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
  return `${String(gregorianDate.year).padStart(4, "0")}-${String(gregorianDate.month).padStart(2, "0")}-${String(gregorianDate.day).padStart(2, "0")}`;
}
function $fae977aafc393c5c$export$4223de14708adc63(date) {
  return `${$fae977aafc393c5c$export$60dfd74aa96791bd(date)}T${$fae977aafc393c5c$export$f59dee82248f5ad4(date)}`;
}
function $fae977aafc393c5c$var$offsetToString(offset3) {
  let sign = Math.sign(offset3) < 0 ? "-" : "+";
  offset3 = Math.abs(offset3);
  let offsetHours = Math.floor(offset3 / 36e5);
  let offsetMinutes = offset3 % 36e5 / 6e4;
  return `${sign}${String(offsetHours).padStart(2, "0")}:${String(offsetMinutes).padStart(2, "0")}`;
}
function $fae977aafc393c5c$export$bf79f1ebf4b18792(date) {
  return `${$fae977aafc393c5c$export$4223de14708adc63(date)}${$fae977aafc393c5c$var$offsetToString(date.offset)}[${date.timeZone}]`;
}

// node_modules/@swc/helpers/esm/_check_private_redeclaration.js
function _check_private_redeclaration(obj, privateCollection) {
  if (privateCollection.has(obj)) {
    throw new TypeError("Cannot initialize the same private elements twice on an object");
  }
}

// node_modules/@swc/helpers/esm/_class_private_field_init.js
function _class_private_field_init(obj, privateMap, value) {
  _check_private_redeclaration(obj, privateMap);
  privateMap.set(obj, value);
}

// node_modules/@internationalized/date/dist/CalendarDate.mjs
function $35ea8db9cb2ccb90$var$shiftArgs(args) {
  let calendar = typeof args[0] === "object" ? args.shift() : new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)();
  let era;
  if (typeof args[0] === "string") era = args.shift();
  else {
    let eras = calendar.getEras();
    era = eras[eras.length - 1];
  }
  let year = args.shift();
  let month = args.shift();
  let day = args.shift();
  return [
    calendar,
    era,
    year,
    month,
    day
  ];
}
var $35ea8db9cb2ccb90$var$_type = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$99faa760c7908e4f = class _$35ea8db9cb2ccb90$export$99faa760c7908e4f {
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new _$35ea8db9cb2ccb90$export$99faa760c7908e4f(this.calendar, this.era, this.year, this.month, this.day);
    else return new _$35ea8db9cb2ccb90$export$99faa760c7908e4f(this.calendar, this.year, this.month, this.day);
  }
  /** Returns a new `CalendarDate` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$e16d8520af44a096)(this, duration);
  }
  /** Returns a new `CalendarDate` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$4e2d2ead65e5f7e3)(this, duration);
  }
  /** Returns a new `CalendarDate` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$adaa4cf7ef1b65be)(this, fields);
  }
  /**
  * Returns a new `CalendarDate` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$d52ced6badfb9a4c)(this, field, amount, options);
  }
  /** Converts the date to a native JavaScript Date object, with the time set to midnight in the given time zone. */
  toDate(timeZone) {
    return (0, $11d87f3f76e88657$export$e67a095c620b86fe)(this, timeZone);
  }
  /** Converts the date to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$60dfd74aa96791bd)(this);
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b2) {
    return (0, $14e0f24ef4ac5c92$export$68781ddf31c0090f)(this, b2);
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
};
var $35ea8db9cb2ccb90$var$_type2 = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$ca871e8dbb80966f = class _$35ea8db9cb2ccb90$export$ca871e8dbb80966f {
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new _$35ea8db9cb2ccb90$export$ca871e8dbb80966f(this.calendar, this.era, this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    else return new _$35ea8db9cb2ccb90$export$ca871e8dbb80966f(this.calendar, this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `CalendarDateTime` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$e16d8520af44a096)(this, duration);
  }
  /** Returns a new `CalendarDateTime` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$4e2d2ead65e5f7e3)(this, duration);
  }
  /** Returns a new `CalendarDateTime` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$adaa4cf7ef1b65be)((0, $735220c2d4774dd3$export$e5d5e1c1822b6e56)(this, fields), fields);
  }
  /**
  * Returns a new `CalendarDateTime` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    switch (field) {
      case "era":
      case "year":
      case "month":
      case "day":
        return (0, $735220c2d4774dd3$export$d52ced6badfb9a4c)(this, field, amount, options);
      default:
        return (0, $735220c2d4774dd3$export$dd02b3e0007dfe28)(this, field, amount, options);
    }
  }
  /** Converts the date to a native JavaScript Date object in the given time zone. */
  toDate(timeZone, disambiguation) {
    return (0, $11d87f3f76e88657$export$e67a095c620b86fe)(this, timeZone, disambiguation);
  }
  /** Converts the date to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$4223de14708adc63)(this);
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b2) {
    let res = (0, $14e0f24ef4ac5c92$export$68781ddf31c0090f)(this, b2);
    if (res === 0) return (0, $14e0f24ef4ac5c92$export$c19a80a9721b80f6)(this, (0, $11d87f3f76e88657$export$b21e0b124e224484)(b2));
    return res;
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type2, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    this.hour = args.shift() || 0;
    this.minute = args.shift() || 0;
    this.second = args.shift() || 0;
    this.millisecond = args.shift() || 0;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
};
var $35ea8db9cb2ccb90$var$_type3 = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$d3b7288e7994edea = class _$35ea8db9cb2ccb90$export$d3b7288e7994edea {
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new _$35ea8db9cb2ccb90$export$d3b7288e7994edea(this.calendar, this.era, this.year, this.month, this.day, this.timeZone, this.offset, this.hour, this.minute, this.second, this.millisecond);
    else return new _$35ea8db9cb2ccb90$export$d3b7288e7994edea(this.calendar, this.year, this.month, this.day, this.timeZone, this.offset, this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `ZonedDateTime` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$96b1d28349274637)(this, duration);
  }
  /** Returns a new `ZonedDateTime` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$6814caac34ca03c7)(this, duration);
  }
  /** Returns a new `ZonedDateTime` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields, disambiguation) {
    return (0, $735220c2d4774dd3$export$31b5430eb18be4f8)(this, fields, disambiguation);
  }
  /**
  * Returns a new `ZonedDateTime` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$9a297d111fc86b79)(this, field, amount, options);
  }
  /** Converts the date to a native JavaScript Date object. */
  toDate() {
    return (0, $11d87f3f76e88657$export$83aac07b4c37b25)(this);
  }
  /** Converts the date to an ISO 8601 formatted string, including the UTC offset and time zone identifier. */
  toString() {
    return (0, $fae977aafc393c5c$export$bf79f1ebf4b18792)(this);
  }
  /** Converts the date to an ISO 8601 formatted string in UTC. */
  toAbsoluteString() {
    return this.toDate().toISOString();
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b2) {
    return this.toDate().getTime() - (0, $11d87f3f76e88657$export$84c95a83c799e074)(b2, this.timeZone).toDate().getTime();
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type3, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    let timeZone = args.shift();
    let offset3 = args.shift();
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    this.timeZone = timeZone;
    this.offset = offset3;
    this.hour = args.shift() || 0;
    this.minute = args.shift() || 0;
    this.second = args.shift() || 0;
    this.millisecond = args.shift() || 0;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
};

// node_modules/@internationalized/date/dist/HebrewCalendar.mjs
var $7c5f6fbf42389787$var$HOUR_PARTS = 1080;
var $7c5f6fbf42389787$var$DAY_PARTS = 24 * $7c5f6fbf42389787$var$HOUR_PARTS;
var $7c5f6fbf42389787$var$MONTH_DAYS = 29;
var $7c5f6fbf42389787$var$MONTH_FRACT = 12 * $7c5f6fbf42389787$var$HOUR_PARTS + 793;
var $7c5f6fbf42389787$var$MONTH_PARTS = $7c5f6fbf42389787$var$MONTH_DAYS * $7c5f6fbf42389787$var$DAY_PARTS + $7c5f6fbf42389787$var$MONTH_FRACT;

// node_modules/@internationalized/date/dist/DateFormatter.mjs
var $fb18d541ea1ad717$var$formatterCache = /* @__PURE__ */ new Map();
var $fb18d541ea1ad717$export$ad991b66133851cf = class {
  /** Formats a date as a string according to the locale and format options passed to the constructor. */
  format(value) {
    return this.formatter.format(value);
  }
  /** Formats a date to an array of parts such as separators, numbers, punctuation, and more. */
  formatToParts(value) {
    return this.formatter.formatToParts(value);
  }
  /** Formats a date range as a string. */
  formatRange(start, end) {
    if (typeof this.formatter.formatRange === "function")
      return this.formatter.formatRange(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    return `${this.formatter.format(start)} – ${this.formatter.format(end)}`;
  }
  /** Formats a date range as an array of parts. */
  formatRangeToParts(start, end) {
    if (typeof this.formatter.formatRangeToParts === "function")
      return this.formatter.formatRangeToParts(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    let startParts = this.formatter.formatToParts(start);
    let endParts = this.formatter.formatToParts(end);
    return [
      ...startParts.map((p) => ({
        ...p,
        source: "startRange"
      })),
      {
        type: "literal",
        value: " – ",
        source: "shared"
      },
      ...endParts.map((p) => ({
        ...p,
        source: "endRange"
      }))
    ];
  }
  /** Returns the resolved formatting options based on the values passed to the constructor. */
  resolvedOptions() {
    let resolvedOptions = this.formatter.resolvedOptions();
    if ($fb18d541ea1ad717$var$hasBuggyResolvedHourCycle()) {
      if (!this.resolvedHourCycle) this.resolvedHourCycle = $fb18d541ea1ad717$var$getResolvedHourCycle(resolvedOptions.locale, this.options);
      resolvedOptions.hourCycle = this.resolvedHourCycle;
      resolvedOptions.hour12 = this.resolvedHourCycle === "h11" || this.resolvedHourCycle === "h12";
    }
    if (resolvedOptions.calendar === "ethiopic-amete-alem") resolvedOptions.calendar = "ethioaa";
    return resolvedOptions;
  }
  constructor(locale, options = {}) {
    this.formatter = $fb18d541ea1ad717$var$getCachedDateFormatter(locale, options);
    this.options = options;
  }
};
var $fb18d541ea1ad717$var$hour12Preferences = {
  true: {
    // Only Japanese uses the h11 style for 12 hour time. All others use h12.
    ja: "h11"
  },
  false: {}
};
function $fb18d541ea1ad717$var$getCachedDateFormatter(locale, options = {}) {
  if (typeof options.hour12 === "boolean" && $fb18d541ea1ad717$var$hasBuggyHour12Behavior()) {
    options = {
      ...options
    };
    let pref = $fb18d541ea1ad717$var$hour12Preferences[String(options.hour12)][locale.split("-")[0]];
    let defaultHourCycle = options.hour12 ? "h12" : "h23";
    options.hourCycle = pref !== null && pref !== void 0 ? pref : defaultHourCycle;
    delete options.hour12;
  }
  let cacheKey = locale + (options ? Object.entries(options).sort((a2, b2) => a2[0] < b2[0] ? -1 : 1).join() : "");
  if ($fb18d541ea1ad717$var$formatterCache.has(cacheKey)) return $fb18d541ea1ad717$var$formatterCache.get(cacheKey);
  let numberFormatter = new Intl.DateTimeFormat(locale, options);
  $fb18d541ea1ad717$var$formatterCache.set(cacheKey, numberFormatter);
  return numberFormatter;
}
var $fb18d541ea1ad717$var$_hasBuggyHour12Behavior = null;
function $fb18d541ea1ad717$var$hasBuggyHour12Behavior() {
  if ($fb18d541ea1ad717$var$_hasBuggyHour12Behavior == null) $fb18d541ea1ad717$var$_hasBuggyHour12Behavior = new Intl.DateTimeFormat("en-US", {
    hour: "numeric",
    hour12: false
  }).format(new Date(2020, 2, 3, 0)) === "24";
  return $fb18d541ea1ad717$var$_hasBuggyHour12Behavior;
}
var $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle = null;
function $fb18d541ea1ad717$var$hasBuggyResolvedHourCycle() {
  if ($fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle == null) $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle = new Intl.DateTimeFormat("fr", {
    hour: "numeric",
    hour12: false
  }).resolvedOptions().hourCycle === "h12";
  return $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle;
}
function $fb18d541ea1ad717$var$getResolvedHourCycle(locale, options) {
  if (!options.timeStyle && !options.hour) return void 0;
  locale = locale.replace(/(-u-)?-nu-[a-zA-Z0-9]+/, "");
  locale += (locale.includes("-u-") ? "" : "-u") + "-nu-latn";
  let formatter = $fb18d541ea1ad717$var$getCachedDateFormatter(locale, {
    ...options,
    timeZone: void 0
    // use local timezone
  });
  let min2 = parseInt(formatter.formatToParts(new Date(2020, 2, 3, 0)).find((p) => p.type === "hour").value, 10);
  let max2 = parseInt(formatter.formatToParts(new Date(2020, 2, 3, 23)).find((p) => p.type === "hour").value, 10);
  if (min2 === 0 && max2 === 23) return "h23";
  if (min2 === 24 && max2 === 23) return "h24";
  if (min2 === 0 && max2 === 11) return "h11";
  if (min2 === 12 && max2 === 11) return "h12";
  throw new Error("Unexpected hour cycle result");
}

// node_modules/radix-vue/dist/calendar-ChFCRr4K.js
function N(t, n) {
  const e = [];
  for (let r = 0; r < t.length; r += n)
    e.push(t.slice(r, r + n));
  return e;
}
function $(t, n = $14e0f24ef4ac5c92$export$aa8b41735afcabd2()) {
  return m(t) ? t.toDate() : t.toDate(n);
}
function w(t) {
  return t instanceof $35ea8db9cb2ccb90$export$ca871e8dbb80966f;
}
function m(t) {
  return t instanceof $35ea8db9cb2ccb90$export$d3b7288e7994edea;
}
function z(t) {
  return w(t) || m(t);
}
function R(t) {
  if (t instanceof Date) {
    const n = t.getFullYear(), e = t.getMonth() + 1;
    return new Date(n, e, 0).getDate();
  } else
    return t.set({ day: 100 }).day;
}
function q(t, n) {
  return t.compare(n) < 0;
}
function P(t, n) {
  return t.compare(n) > 0;
}
function W(t, n) {
  return t.compare(n) <= 0;
}
function G(t, n) {
  return t.compare(n) >= 0;
}
function V(t, n, e) {
  return G(t, n) && W(t, e);
}
function v(t, n, e) {
  return P(t, n) && q(t, e);
}
function H(t, n, e) {
  const r = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(t, e);
  return n > r ? t.subtract({ days: r + 7 - n }) : n === r ? t : t.subtract({ days: r - n });
}
function J(t, n, e) {
  const r = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(t, e), a2 = n === 0 ? 6 : n - 1;
  return r === a2 ? t : r > a2 ? t.add({ days: 7 - r + a2 }) : t.add({ days: a2 - r });
}
function b(t, n, e, r) {
  if (e === void 0 && r === void 0)
    return true;
  let a2 = t.add({ days: 1 });
  if (r != null && r(a2) || e != null && e(a2))
    return false;
  const s = n;
  for (; a2.compare(s) < 0; )
    if (a2 = a2.add({ days: 1 }), r != null && r(a2) || e != null && e(a2))
      return false;
  return true;
}
function A(t, n) {
  const e = [];
  let r = t.add({ days: 1 });
  const a2 = n;
  for (; r.compare(a2) < 0; )
    e.push(r), r = r.add({ days: 1 });
  return e;
}
function y(t) {
  const { dateObj: n, weekStartsOn: e, fixedWeeks: r, locale: a2 } = t, s = R(n), o = Array.from({ length: s }, (D, u) => n.set({ day: u + 1 })), f = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(n), i = $14e0f24ef4ac5c92$export$a2258d9c4118825c(n), x = H(f, e, a2), T = J(i, e, a2), l = A(x.subtract({ days: 1 }), f), c = A(i, T.add({ days: 1 })), g = l.length + o.length + c.length;
  if (r && g < 42) {
    const D = 42 - g;
    let u = c[c.length - 1];
    u || (u = $14e0f24ef4ac5c92$export$a2258d9c4118825c(n));
    const k = Array.from({ length: D }, (K, C) => {
      const I = C + 1;
      return u.add({ days: I });
    });
    c.push(...k);
  }
  const p = l.concat(o, c), B = N(p, 7);
  return {
    value: n,
    cells: p,
    rows: B
  };
}
function rt(t) {
  const { numberOfMonths: n, dateObj: e, ...r } = t, a2 = [];
  if (!n || n === 1)
    return a2.push(
      y({
        ...r,
        dateObj: e
      })
    ), a2;
  a2.push(
    y({
      ...r,
      dateObj: e
    })
  );
  for (let s = 1; s < n; s++) {
    const o = e.add({ months: s });
    a2.push(
      y({
        ...r,
        dateObj: o
      })
    );
  }
  return a2;
}

// node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs
var sides = ["top", "right", "bottom", "left"];
var alignments = ["start", "end"];
var placements = sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
var min = Math.min;
var max = Math.max;
var round = Math.round;
var floor = Math.floor;
var createCoords = (v2) => ({
  x: v2,
  y: v2
});
var oppositeSideMap = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
};
var oppositeAlignmentMap = {
  start: "end",
  end: "start"
};
function clamp(start, value, end) {
  return max(start, min(value, end));
}
function evaluate(value, param) {
  return typeof value === "function" ? value(param) : value;
}
function getSide(placement) {
  return placement.split("-")[0];
}
function getAlignment(placement) {
  return placement.split("-")[1];
}
function getOppositeAxis(axis) {
  return axis === "x" ? "y" : "x";
}
function getAxisLength(axis) {
  return axis === "y" ? "height" : "width";
}
function getSideAxis(placement) {
  return ["top", "bottom"].includes(getSide(placement)) ? "y" : "x";
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === "x" ? alignment === (rtl ? "end" : "start") ? "right" : "left" : alignment === "start" ? "bottom" : "top";
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, (alignment) => oppositeAlignmentMap[alignment]);
}
function getSideList(side, isStart, rtl) {
  const lr2 = ["left", "right"];
  const rl = ["right", "left"];
  const tb = ["top", "bottom"];
  const bt2 = ["bottom", "top"];
  switch (side) {
    case "top":
    case "bottom":
      if (rtl) return isStart ? rl : lr2;
      return isStart ? lr2 : rl;
    case "left":
    case "right":
      return isStart ? tb : bt2;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === "start", rtl);
  if (alignment) {
    list = list.map((side) => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, (side) => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== "number" ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  const {
    x,
    y: y2,
    width,
    height
  } = rect;
  return {
    width,
    height,
    top: y2,
    left: x,
    right: x + width,
    bottom: y2 + height,
    x,
    y: y2
  };
}

// node_modules/@floating-ui/core/dist/floating-ui.core.mjs
function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = getSideAxis(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const alignLength = getAxisLength(alignmentAxis);
  const side = getSide(placement);
  const isVertical = sideAxis === "y";
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case "top":
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case "bottom":
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case "right":
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case "left":
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case "start":
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case "end":
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}
var computePosition = async (reference, floating, config) => {
  const {
    placement = "bottom",
    strategy = "absolute",
    middleware = [],
    platform: platform2
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(floating));
  let rects = await platform2.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y: y2
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn: fn2
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn2({
      x,
      y: y2,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform: platform2,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y2 = nextY != null ? nextY : y2;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === "object") {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform2.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y: y2
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
    }
  }
  return {
    x,
    y: y2,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y: y2,
    platform: platform2,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = "clippingAncestors",
    rootBoundary = "viewport",
    elementContext = "floating",
    altBoundary = false,
    padding = 0
  } = evaluate(options, state);
  const paddingObject = getPaddingObject(padding);
  const altContext = elementContext === "floating" ? "reference" : "floating";
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform2.getClippingRect({
    element: ((_await$platform$isEle = await (platform2.isElement == null ? void 0 : platform2.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || await (platform2.getDocumentElement == null ? void 0 : platform2.getDocumentElement(elements.floating)),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === "floating" ? {
    x,
    y: y2,
    width: rects.floating.width,
    height: rects.floating.height
  } : rects.reference;
  const offsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(elements.floating));
  const offsetScale = await (platform2.isElement == null ? void 0 : platform2.isElement(offsetParent)) ? await (platform2.getScale == null ? void 0 : platform2.getScale(offsetParent)) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform2.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform2.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}
var arrow = (options) => ({
  name: "arrow",
  options,
  async fn(state) {
    const {
      x,
      y: y2,
      placement,
      rects,
      platform: platform2,
      elements,
      middlewareData
    } = state;
    const {
      element,
      padding = 0
    } = evaluate(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = getPaddingObject(padding);
    const coords = {
      x,
      y: y2
    };
    const axis = getAlignmentAxis(placement);
    const length = getAxisLength(axis);
    const arrowDimensions = await platform2.getDimensions(element);
    const isYAxis = axis === "y";
    const minProp = isYAxis ? "top" : "left";
    const maxProp = isYAxis ? "bottom" : "right";
    const clientProp = isYAxis ? "clientHeight" : "clientWidth";
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;
    if (!clientSize || !await (platform2.isElement == null ? void 0 : platform2.isElement(arrowOffsetParent))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = min(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = min(paddingObject[maxProp], largestPossiblePadding);
    const min$1 = minPadding;
    const max2 = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset3 = clamp(min$1, center, max2);
    const shouldAddOffset = !middlewareData.arrow && getAlignment(placement) != null && center !== offset3 && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max2 : 0;
    return {
      [axis]: coords[axis] + alignmentOffset,
      data: {
        [axis]: offset3,
        centerOffset: center - offset3 - alignmentOffset,
        ...shouldAddOffset && {
          alignmentOffset
        }
      },
      reset: shouldAddOffset
    };
  }
});
var flip = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: "flip",
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform: platform2,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = "bestFit",
        fallbackAxisSideDirection = "none",
        flipAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = getSide(placement);
      const initialSideAxis = getSideAxis(initialPlacement);
      const isBasePlacement = getSide(initialPlacement) === initialPlacement;
      const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
      const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== "none";
      if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {
        fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements2 = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides2 = getAlignmentSides(placement, rects, rtl);
        overflows.push(overflow[sides2[0]], overflow[sides2[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];
      if (!overflows.every((side2) => side2 <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements2[nextIndex];
        if (nextPlacement) {
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }
        let resetPlacement = (_overflowsData$filter = overflowsData.filter((d) => d.overflows[0] <= 0).sort((a2, b2) => a2.overflows[1] - b2.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case "bestFit": {
              var _overflowsData$filter2;
              const placement2 = (_overflowsData$filter2 = overflowsData.filter((d) => {
                if (hasFallbackAxisSideDirection) {
                  const currentSideAxis = getSideAxis(d.placement);
                  return currentSideAxis === initialSideAxis || // Create a bias to the `y` side axis due to horizontal
                  // reading directions favoring greater width.
                  currentSideAxis === "y";
                }
                return true;
              }).map((d) => [d.placement, d.overflows.filter((overflow2) => overflow2 > 0).reduce((acc, overflow2) => acc + overflow2, 0)]).sort((a2, b2) => a2[1] - b2[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
              if (placement2) {
                resetPlacement = placement2;
              }
              break;
            }
            case "initialPlacement":
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};
function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return sides.some((side) => overflow[side] >= 0);
}
var hide = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: "hide",
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = "referenceHidden",
        ...detectOverflowOptions
      } = evaluate(options, state);
      switch (strategy) {
        case "referenceHidden": {
          const overflow = await detectOverflow(state, {
            ...detectOverflowOptions,
            elementContext: "reference"
          });
          const offsets = getSideOffsets(overflow, rects.reference);
          return {
            data: {
              referenceHiddenOffsets: offsets,
              referenceHidden: isAnySideFullyClipped(offsets)
            }
          };
        }
        case "escaped": {
          const overflow = await detectOverflow(state, {
            ...detectOverflowOptions,
            altBoundary: true
          });
          const offsets = getSideOffsets(overflow, rects.floating);
          return {
            data: {
              escapedOffsets: offsets,
              escaped: isAnySideFullyClipped(offsets)
            }
          };
        }
        default: {
          return {};
        }
      }
    }
  };
};
async function convertValueToCoords(state, options) {
  const {
    placement,
    platform: platform2,
    elements
  } = state;
  const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getSideAxis(placement) === "y";
  const mainAxisMulti = ["left", "top"].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = evaluate(options, state);
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === "number" ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...rawValue
  };
  if (alignment && typeof alignmentAxis === "number") {
    crossAxis = alignment === "end" ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}
var offset = function(options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: "offset",
    options,
    async fn(state) {
      var _middlewareData$offse, _middlewareData$arrow;
      const {
        x,
        y: y2,
        placement,
        middlewareData
      } = state;
      const diffCoords = await convertValueToCoords(state, options);
      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      return {
        x: x + diffCoords.x,
        y: y2 + diffCoords.y,
        data: {
          ...diffCoords,
          placement
        }
      };
    }
  };
};
var shift = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: "shift",
    options,
    async fn(state) {
      const {
        x,
        y: y2,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: (_ref) => {
            let {
              x: x2,
              y: y3
            } = _ref;
            return {
              x: x2,
              y: y3
            };
          }
        },
        ...detectOverflowOptions
      } = evaluate(options, state);
      const coords = {
        x,
        y: y2
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const crossAxis = getSideAxis(getSide(placement));
      const mainAxis = getOppositeAxis(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === "y" ? "top" : "left";
        const maxSide = mainAxis === "y" ? "bottom" : "right";
        const min2 = mainAxisCoord + overflow[minSide];
        const max2 = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = clamp(min2, mainAxisCoord, max2);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === "y" ? "top" : "left";
        const maxSide = crossAxis === "y" ? "bottom" : "right";
        const min2 = crossAxisCoord + overflow[minSide];
        const max2 = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = clamp(min2, crossAxisCoord, max2);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y2
        }
      };
    }
  };
};
var limitShift = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y: y2,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset: offset3 = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = evaluate(options, state);
      const coords = {
        x,
        y: y2
      };
      const crossAxis = getSideAxis(placement);
      const mainAxis = getOppositeAxis(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = evaluate(offset3, state);
      const computedOffset = typeof rawOffset === "number" ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === "y" ? "height" : "width";
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === "y" ? "width" : "height";
        const isOriginSide = ["top", "left"].includes(getSide(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};
var size = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: "size",
    options,
    async fn(state) {
      const {
        placement,
        rects,
        platform: platform2,
        elements
      } = state;
      const {
        apply = () => {
        },
        ...detectOverflowOptions
      } = evaluate(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = getSide(placement);
      const alignment = getAlignment(placement);
      const isYAxis = getSideAxis(placement) === "y";
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === "top" || side === "bottom") {
        heightSide = side;
        widthSide = alignment === (await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating)) ? "start" : "end") ? "left" : "right";
      } else {
        widthSide = side;
        heightSide = alignment === "end" ? "top" : "bottom";
      }
      const maximumClippingHeight = height - overflow.top - overflow.bottom;
      const maximumClippingWidth = width - overflow.left - overflow.right;
      const overflowAvailableHeight = min(height - overflow[heightSide], maximumClippingHeight);
      const overflowAvailableWidth = min(width - overflow[widthSide], maximumClippingWidth);
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if (isYAxis) {
        availableWidth = alignment || noShift ? min(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
      } else {
        availableHeight = alignment || noShift ? min(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = max(overflow.left, 0);
        const xMax = max(overflow.right, 0);
        const yMin = max(overflow.top, 0);
        const yMax = max(overflow.bottom, 0);
        if (isYAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform2.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};

// node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || "").toLowerCase();
  }
  return "#document";
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (typeof ShadowRoot === "undefined") {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle2(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !["inline", "contents"].includes(display);
}
function isTableElement(element) {
  return ["table", "td", "th"].includes(getNodeName(element));
}
function isTopLayer(element) {
  return [":popover-open", ":modal"].some((selector) => {
    try {
      return element.matches(selector);
    } catch (e) {
      return false;
    }
  });
}
function isContainingBlock(element) {
  const webkit = isWebKit();
  const css = getComputedStyle2(element);
  return css.transform !== "none" || css.perspective !== "none" || (css.containerType ? css.containerType !== "normal" : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== "none" : false) || !webkit && (css.filter ? css.filter !== "none" : false) || ["transform", "perspective", "filter"].some((value) => (css.willChange || "").includes(value)) || ["paint", "layout", "strict", "content"].some((value) => (css.contain || "").includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isTopLayer(currentNode)) {
      return null;
    }
    if (isContainingBlock(currentNode)) {
      return currentNode;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === "undefined" || !CSS.supports) return false;
  return CSS.supports("-webkit-backdrop-filter", "none");
}
function isLastTraversableNode(node) {
  return ["html", "body", "#document"].includes(getNodeName(node));
}
function getComputedStyle2(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === "html") {
    return node;
  }
  const result = (
    // Step into the shadow DOM of the parent of a slotted node.
    node.assignedSlot || // DOM Element detected.
    node.parentNode || // ShadowRoot detected.
    isShadowRoot(node) && node.host || // Fallback.
    getDocumentElement(node)
  );
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], win.frameElement && traverseIframes ? getOverflowAncestors(win.frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}

// node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs
function getCssDimensions(element) {
  const css = getComputedStyle2(element);
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}
function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}
function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return createCoords(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $: $2
  } = getCssDimensions(domElement);
  let x = ($2 ? round(rect.width) : rect.width) / width;
  let y2 = ($2 ? round(rect.height) : rect.height) / height;
  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y2 || !Number.isFinite(y2)) {
    y2 = 1;
  }
  return {
    x,
    y: y2
  };
}
var noOffsets = createCoords(0);
function getVisualOffsets(element) {
  const win = getWindow(element);
  if (!isWebKit() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow(element)) {
    return false;
  }
  return isFixed;
}
function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = createCoords(1);
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : createCoords(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y2 = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = currentWin.frameElement;
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle2(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y2 *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y2 += top;
      currentWin = getWindow(currentIFrame);
      currentIFrame = currentWin.frameElement;
    }
  }
  return rectToClientRect({
    width,
    height,
    x,
    y: y2
  });
}
function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === "fixed";
  const documentElement = getDocumentElement(offsetParent);
  const topLayer = elements ? isTopLayer(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = createCoords(1);
  const offsets = createCoords(0);
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
  };
}
function getClientRects(element) {
  return Array.from(element.getClientRects());
}
function getWindowScrollBarX(element) {
  return getBoundingClientRect(getDocumentElement(element)).left + getNodeScroll(element).scrollLeft;
}
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y2 = -scroll.scrollTop;
  if (getComputedStyle2(body).direction === "rtl") {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y: y2
  };
}
function getViewportRect(element, strategy) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y2 = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isWebKit();
    if (!visualViewportBased || visualViewportBased && strategy === "fixed") {
      x = visualViewport.offsetLeft;
      y2 = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y: y2
  };
}
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === "fixed");
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : createCoords(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y2 = top * scale.y;
  return {
    width,
    height,
    x,
    y: y2
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === "viewport") {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === "document") {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      ...clippingAncestor,
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y
    };
  }
  return rectToClientRect(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle2(parentNode).position === "fixed" || hasFixedPositionAncestor(parentNode, stopNode);
}
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element, [], false).filter((el2) => isElement(el2) && getNodeName(el2) !== "body");
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle2(element).position === "fixed";
  let currentNode = elementIsFixed ? getParentNode(element) : element;
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle2(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === "fixed") {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === "static" && !!currentContainingBlockComputedStyle && ["absolute", "fixed"].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      result = result.filter((ancestor) => ancestor !== currentNode);
    } else {
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === "clippingAncestors" ? isTopLayer(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}
function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}
function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const isFixed = strategy === "fixed";
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = createCoords(0);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  const x = rect.left + scroll.scrollLeft - offsets.x;
  const y2 = rect.top + scroll.scrollTop - offsets.y;
  return {
    x,
    y: y2,
    width: rect.width,
    height: rect.height
  };
}
function isStaticPositioned(element) {
  return getComputedStyle2(element).position === "static";
}
function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle2(element).position === "fixed") {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  return element.offsetParent;
}
function getOffsetParent(element, polyfill) {
  const win = getWindow(element);
  if (isTopLayer(element)) {
    return win;
  }
  if (!isHTMLElement(element)) {
    let svgOffsetParent = getParentNode(element);
    while (svgOffsetParent && !isLastTraversableNode(svgOffsetParent)) {
      if (isElement(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
        return svgOffsetParent;
      }
      svgOffsetParent = getParentNode(svgOffsetParent);
    }
    return win;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && isStaticPositioned(offsetParent)) {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && isLastTraversableNode(offsetParent) && isStaticPositioned(offsetParent) && !isContainingBlock(offsetParent)) {
    return win;
  }
  return offsetParent || getContainingBlock(element) || win;
}
var getElementRects = async function(data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  const floatingDimensions = await getDimensionsFn(data.floating);
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      width: floatingDimensions.width,
      height: floatingDimensions.height
    }
  };
};
function isRTL(element) {
  return getComputedStyle2(element).direction === "rtl";
}
var platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement,
  isRTL
};
function observeMove(element, onMove) {
  let io2 = null;
  let timeoutId;
  const root = getDocumentElement(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io2) == null || _io.disconnect();
    io2 = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const {
      left,
      top,
      width,
      height
    } = element.getBoundingClientRect();
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = floor(top);
    const insetRight = floor(root.clientWidth - (left + width));
    const insetBottom = floor(root.clientHeight - (top + height));
    const insetLeft = floor(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: max(0, min(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 1e3);
        } else {
          refresh(false, ratio);
        }
      }
      isFirstUpdate = false;
    }
    try {
      io2 = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (e) {
      io2 = new IntersectionObserver(handleObserve, options);
    }
    io2.observe(element);
  }
  refresh(true);
  return cleanup;
}
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === "function",
    layoutShift = typeof IntersectionObserver === "function",
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...referenceEl ? getOverflowAncestors(referenceEl) : [], ...getOverflowAncestors(floating)] : [];
  ancestors.forEach((ancestor) => {
    ancestorScroll && ancestor.addEventListener("scroll", update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener("resize", update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver((_ref) => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          var _resizeObserver;
          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && (nextRefRect.x !== prevRefRect.x || nextRefRect.y !== prevRefRect.y || nextRefRect.width !== prevRefRect.width || nextRefRect.height !== prevRefRect.height)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _resizeObserver2;
    ancestors.forEach((ancestor) => {
      ancestorScroll && ancestor.removeEventListener("scroll", update);
      ancestorResize && ancestor.removeEventListener("resize", update);
    });
    cleanupIo == null || cleanupIo();
    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}
var offset2 = offset;
var shift2 = shift;
var flip2 = flip;
var size2 = size;
var hide2 = hide;
var arrow2 = arrow;
var limitShift2 = limitShift;
var computePosition2 = (reference, floating, options) => {
  const cache = /* @__PURE__ */ new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return computePosition(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};

// node_modules/@floating-ui/vue/dist/floating-ui.vue.mjs
function isComponentPublicInstance(target) {
  return target != null && typeof target === "object" && "$el" in target;
}
function unwrapElement2(target) {
  if (isComponentPublicInstance(target)) {
    const element = target.$el;
    return isNode(element) && getNodeName(element) === "#comment" ? null : element;
  }
  return target;
}
function toValue(source) {
  return typeof source === "function" ? source() : unref(source);
}
function arrow3(options) {
  return {
    name: "arrow",
    options,
    fn(args) {
      const element = unwrapElement2(toValue(options.element));
      if (element == null) {
        return {};
      }
      return arrow2({
        element,
        padding: options.padding
      }).fn(args);
    }
  };
}
function getDPR(element) {
  if (typeof window === "undefined") {
    return 1;
  }
  const win = element.ownerDocument.defaultView || window;
  return win.devicePixelRatio || 1;
}
function roundByDPR(element, value) {
  const dpr = getDPR(element);
  return Math.round(value * dpr) / dpr;
}
function useFloating(reference, floating, options) {
  if (options === void 0) {
    options = {};
  }
  const whileElementsMountedOption = options.whileElementsMounted;
  const openOption = computed(() => {
    var _toValue;
    return (_toValue = toValue(options.open)) != null ? _toValue : true;
  });
  const middlewareOption = computed(() => toValue(options.middleware));
  const placementOption = computed(() => {
    var _toValue2;
    return (_toValue2 = toValue(options.placement)) != null ? _toValue2 : "bottom";
  });
  const strategyOption = computed(() => {
    var _toValue3;
    return (_toValue3 = toValue(options.strategy)) != null ? _toValue3 : "absolute";
  });
  const transformOption = computed(() => {
    var _toValue4;
    return (_toValue4 = toValue(options.transform)) != null ? _toValue4 : true;
  });
  const referenceElement = computed(() => unwrapElement2(reference.value));
  const floatingElement = computed(() => unwrapElement2(floating.value));
  const x = ref(0);
  const y2 = ref(0);
  const strategy = ref(strategyOption.value);
  const placement = ref(placementOption.value);
  const middlewareData = shallowRef({});
  const isPositioned = ref(false);
  const floatingStyles = computed(() => {
    const initialStyles = {
      position: strategy.value,
      left: "0",
      top: "0"
    };
    if (!floatingElement.value) {
      return initialStyles;
    }
    const xVal = roundByDPR(floatingElement.value, x.value);
    const yVal = roundByDPR(floatingElement.value, y2.value);
    if (transformOption.value) {
      return {
        ...initialStyles,
        transform: "translate(" + xVal + "px, " + yVal + "px)",
        ...getDPR(floatingElement.value) >= 1.5 && {
          willChange: "transform"
        }
      };
    }
    return {
      position: strategy.value,
      left: xVal + "px",
      top: yVal + "px"
    };
  });
  let whileElementsMountedCleanup;
  function update() {
    if (referenceElement.value == null || floatingElement.value == null) {
      return;
    }
    computePosition2(referenceElement.value, floatingElement.value, {
      middleware: middlewareOption.value,
      placement: placementOption.value,
      strategy: strategyOption.value
    }).then((position) => {
      x.value = position.x;
      y2.value = position.y;
      strategy.value = position.strategy;
      placement.value = position.placement;
      middlewareData.value = position.middlewareData;
      isPositioned.value = true;
    });
  }
  function cleanup() {
    if (typeof whileElementsMountedCleanup === "function") {
      whileElementsMountedCleanup();
      whileElementsMountedCleanup = void 0;
    }
  }
  function attach() {
    cleanup();
    if (whileElementsMountedOption === void 0) {
      update();
      return;
    }
    if (referenceElement.value != null && floatingElement.value != null) {
      whileElementsMountedCleanup = whileElementsMountedOption(referenceElement.value, floatingElement.value, update);
      return;
    }
  }
  function reset() {
    if (!openOption.value) {
      isPositioned.value = false;
    }
  }
  watch([middlewareOption, placementOption, strategyOption], update, {
    flush: "sync"
  });
  watch([referenceElement, floatingElement], attach, {
    flush: "sync"
  });
  watch(openOption, reset, {
    flush: "sync"
  });
  if (getCurrentScope()) {
    onScopeDispose(cleanup);
  }
  return {
    x: shallowReadonly(x),
    y: shallowReadonly(y2),
    strategy: shallowReadonly(strategy),
    placement: shallowReadonly(placement),
    middlewareData: shallowReadonly(middlewareData),
    isPositioned: shallowReadonly(isPositioned),
    floatingStyles,
    update
  };
}

// node_modules/@internationalized/number/dist/NumberFormatter.mjs
var $488c6ddbf4ef74c2$var$formatterCache = /* @__PURE__ */ new Map();
var $488c6ddbf4ef74c2$var$supportsSignDisplay = false;
try {
  $488c6ddbf4ef74c2$var$supportsSignDisplay = new Intl.NumberFormat("de-DE", {
    signDisplay: "exceptZero"
  }).resolvedOptions().signDisplay === "exceptZero";
} catch (e) {
}
var $488c6ddbf4ef74c2$var$supportsUnit = false;
try {
  $488c6ddbf4ef74c2$var$supportsUnit = new Intl.NumberFormat("de-DE", {
    style: "unit",
    unit: "degree"
  }).resolvedOptions().style === "unit";
} catch (e) {
}
var $488c6ddbf4ef74c2$var$UNITS = {
  degree: {
    narrow: {
      default: "°",
      "ja-JP": " 度",
      "zh-TW": "度",
      "sl-SI": " °"
    }
  }
};
var $488c6ddbf4ef74c2$export$cc77c4ff7e8673c5 = class {
  /** Formats a number value as a string, according to the locale and options provided to the constructor. */
  format(value) {
    let res = "";
    if (!$488c6ddbf4ef74c2$var$supportsSignDisplay && this.options.signDisplay != null) res = $488c6ddbf4ef74c2$export$711b50b3c525e0f2(this.numberFormatter, this.options.signDisplay, value);
    else res = this.numberFormatter.format(value);
    if (this.options.style === "unit" && !$488c6ddbf4ef74c2$var$supportsUnit) {
      var _UNITS_unit;
      let { unit, unitDisplay = "short", locale } = this.resolvedOptions();
      if (!unit) return res;
      let values = (_UNITS_unit = $488c6ddbf4ef74c2$var$UNITS[unit]) === null || _UNITS_unit === void 0 ? void 0 : _UNITS_unit[unitDisplay];
      res += values[locale] || values.default;
    }
    return res;
  }
  /** Formats a number to an array of parts such as separators, digits, punctuation, and more. */
  formatToParts(value) {
    return this.numberFormatter.formatToParts(value);
  }
  /** Formats a number range as a string. */
  formatRange(start, end) {
    if (typeof this.numberFormatter.formatRange === "function")
      return this.numberFormatter.formatRange(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    return `${this.format(start)} – ${this.format(end)}`;
  }
  /** Formats a number range as an array of parts. */
  formatRangeToParts(start, end) {
    if (typeof this.numberFormatter.formatRangeToParts === "function")
      return this.numberFormatter.formatRangeToParts(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    let startParts = this.numberFormatter.formatToParts(start);
    let endParts = this.numberFormatter.formatToParts(end);
    return [
      ...startParts.map((p) => ({
        ...p,
        source: "startRange"
      })),
      {
        type: "literal",
        value: " – ",
        source: "shared"
      },
      ...endParts.map((p) => ({
        ...p,
        source: "endRange"
      }))
    ];
  }
  /** Returns the resolved formatting options based on the values passed to the constructor. */
  resolvedOptions() {
    let options = this.numberFormatter.resolvedOptions();
    if (!$488c6ddbf4ef74c2$var$supportsSignDisplay && this.options.signDisplay != null) options = {
      ...options,
      signDisplay: this.options.signDisplay
    };
    if (!$488c6ddbf4ef74c2$var$supportsUnit && this.options.style === "unit") options = {
      ...options,
      style: "unit",
      unit: this.options.unit,
      unitDisplay: this.options.unitDisplay
    };
    return options;
  }
  constructor(locale, options = {}) {
    this.numberFormatter = $488c6ddbf4ef74c2$var$getCachedNumberFormatter(locale, options);
    this.options = options;
  }
};
function $488c6ddbf4ef74c2$var$getCachedNumberFormatter(locale, options = {}) {
  let { numberingSystem } = options;
  if (numberingSystem && locale.includes("-nu-")) {
    if (!locale.includes("-u-")) locale += "-u-";
    locale += `-nu-${numberingSystem}`;
  }
  if (options.style === "unit" && !$488c6ddbf4ef74c2$var$supportsUnit) {
    var _UNITS_unit;
    let { unit, unitDisplay = "short" } = options;
    if (!unit) throw new Error('unit option must be provided with style: "unit"');
    if (!((_UNITS_unit = $488c6ddbf4ef74c2$var$UNITS[unit]) === null || _UNITS_unit === void 0 ? void 0 : _UNITS_unit[unitDisplay])) throw new Error(`Unsupported unit ${unit} with unitDisplay = ${unitDisplay}`);
    options = {
      ...options,
      style: "decimal"
    };
  }
  let cacheKey = locale + (options ? Object.entries(options).sort((a2, b2) => a2[0] < b2[0] ? -1 : 1).join() : "");
  if ($488c6ddbf4ef74c2$var$formatterCache.has(cacheKey)) return $488c6ddbf4ef74c2$var$formatterCache.get(cacheKey);
  let numberFormatter = new Intl.NumberFormat(locale, options);
  $488c6ddbf4ef74c2$var$formatterCache.set(cacheKey, numberFormatter);
  return numberFormatter;
}
function $488c6ddbf4ef74c2$export$711b50b3c525e0f2(numberFormat, signDisplay, num) {
  if (signDisplay === "auto") return numberFormat.format(num);
  else if (signDisplay === "never") return numberFormat.format(Math.abs(num));
  else {
    let needsPositiveSign = false;
    if (signDisplay === "always") needsPositiveSign = num > 0 || Object.is(num, 0);
    else if (signDisplay === "exceptZero") {
      if (Object.is(num, -0) || Object.is(num, 0)) num = Math.abs(num);
      else needsPositiveSign = num > 0;
    }
    if (needsPositiveSign) {
      let negative = numberFormat.format(-num);
      let noSign = numberFormat.format(num);
      let minus = negative.replace(noSign, "").replace(/\u200e|\u061C/, "");
      if ([
        ...minus
      ].length !== 1) console.warn("@react-aria/i18n polyfill for NumberFormat signDisplay: Unsupported case");
      let positive = negative.replace(noSign, "!!!").replace(minus, "+").replace("!!!", noSign);
      return positive;
    } else return numberFormat.format(num);
  }
}

// node_modules/@internationalized/number/dist/NumberParser.mjs
var $6c7bd7858deea686$var$CURRENCY_SIGN_REGEX = new RegExp("^.*\\(.*\\).*$");
var $6c7bd7858deea686$var$NUMBERING_SYSTEMS = [
  "latn",
  "arab",
  "hanidec"
];
var $6c7bd7858deea686$export$cd11ab140839f11d = class {
  /**
  * Parses the given string to a number. Returns NaN if a valid number could not be parsed.
  */
  parse(value) {
    return $6c7bd7858deea686$var$getNumberParserImpl(this.locale, this.options, value).parse(value);
  }
  /**
  * Returns whether the given string could potentially be a valid number. This should be used to
  * validate user input as the user types. If a `minValue` or `maxValue` is provided, the validity
  * of the minus/plus sign characters can be checked.
  */
  isValidPartialNumber(value, minValue, maxValue) {
    return $6c7bd7858deea686$var$getNumberParserImpl(this.locale, this.options, value).isValidPartialNumber(value, minValue, maxValue);
  }
  /**
  * Returns a numbering system for which the given string is valid in the current locale.
  * If no numbering system could be detected, the default numbering system for the current
  * locale is returned.
  */
  getNumberingSystem(value) {
    return $6c7bd7858deea686$var$getNumberParserImpl(this.locale, this.options, value).options.numberingSystem;
  }
  constructor(locale, options = {}) {
    this.locale = locale;
    this.options = options;
  }
};
var $6c7bd7858deea686$var$numberParserCache = /* @__PURE__ */ new Map();
function $6c7bd7858deea686$var$getNumberParserImpl(locale, options, value) {
  let defaultParser = $6c7bd7858deea686$var$getCachedNumberParser(locale, options);
  if (!locale.includes("-nu-") && !defaultParser.isValidPartialNumber(value)) {
    for (let numberingSystem of $6c7bd7858deea686$var$NUMBERING_SYSTEMS) if (numberingSystem !== defaultParser.options.numberingSystem) {
      let parser = $6c7bd7858deea686$var$getCachedNumberParser(locale + (locale.includes("-u-") ? "-nu-" : "-u-nu-") + numberingSystem, options);
      if (parser.isValidPartialNumber(value)) return parser;
    }
  }
  return defaultParser;
}
function $6c7bd7858deea686$var$getCachedNumberParser(locale, options) {
  let cacheKey = locale + (options ? Object.entries(options).sort((a2, b2) => a2[0] < b2[0] ? -1 : 1).join() : "");
  let parser = $6c7bd7858deea686$var$numberParserCache.get(cacheKey);
  if (!parser) {
    parser = new $6c7bd7858deea686$var$NumberParserImpl(locale, options);
    $6c7bd7858deea686$var$numberParserCache.set(cacheKey, parser);
  }
  return parser;
}
var $6c7bd7858deea686$var$NumberParserImpl = class {
  parse(value) {
    let fullySanitizedValue = this.sanitize(value);
    if (this.symbols.group)
      fullySanitizedValue = $6c7bd7858deea686$var$replaceAll(fullySanitizedValue, this.symbols.group, "");
    if (this.symbols.decimal) fullySanitizedValue = fullySanitizedValue.replace(this.symbols.decimal, ".");
    if (this.symbols.minusSign) fullySanitizedValue = fullySanitizedValue.replace(this.symbols.minusSign, "-");
    fullySanitizedValue = fullySanitizedValue.replace(this.symbols.numeral, this.symbols.index);
    if (this.options.style === "percent") {
      let isNegative = fullySanitizedValue.indexOf("-");
      fullySanitizedValue = fullySanitizedValue.replace("-", "");
      let index = fullySanitizedValue.indexOf(".");
      if (index === -1) index = fullySanitizedValue.length;
      fullySanitizedValue = fullySanitizedValue.replace(".", "");
      if (index - 2 === 0) fullySanitizedValue = `0.${fullySanitizedValue}`;
      else if (index - 2 === -1) fullySanitizedValue = `0.0${fullySanitizedValue}`;
      else if (index - 2 === -2) fullySanitizedValue = "0.00";
      else fullySanitizedValue = `${fullySanitizedValue.slice(0, index - 2)}.${fullySanitizedValue.slice(index - 2)}`;
      if (isNegative > -1) fullySanitizedValue = `-${fullySanitizedValue}`;
    }
    let newValue = fullySanitizedValue ? +fullySanitizedValue : NaN;
    if (isNaN(newValue)) return NaN;
    if (this.options.style === "percent") {
      var _this_options_minimumFractionDigits, _this_options_maximumFractionDigits;
      let options = {
        ...this.options,
        style: "decimal",
        minimumFractionDigits: Math.min(((_this_options_minimumFractionDigits = this.options.minimumFractionDigits) !== null && _this_options_minimumFractionDigits !== void 0 ? _this_options_minimumFractionDigits : 0) + 2, 20),
        maximumFractionDigits: Math.min(((_this_options_maximumFractionDigits = this.options.maximumFractionDigits) !== null && _this_options_maximumFractionDigits !== void 0 ? _this_options_maximumFractionDigits : 0) + 2, 20)
      };
      return new $6c7bd7858deea686$export$cd11ab140839f11d(this.locale, options).parse(new (0, $488c6ddbf4ef74c2$export$cc77c4ff7e8673c5)(this.locale, options).format(newValue));
    }
    if (this.options.currencySign === "accounting" && $6c7bd7858deea686$var$CURRENCY_SIGN_REGEX.test(value)) newValue = -1 * newValue;
    return newValue;
  }
  sanitize(value) {
    value = value.replace(this.symbols.literals, "");
    if (this.symbols.minusSign) value = value.replace("-", this.symbols.minusSign);
    if (this.options.numberingSystem === "arab") {
      if (this.symbols.decimal) {
        value = value.replace(",", this.symbols.decimal);
        value = value.replace(String.fromCharCode(1548), this.symbols.decimal);
      }
      if (this.symbols.group) value = $6c7bd7858deea686$var$replaceAll(value, ".", this.symbols.group);
    }
    if (this.options.locale === "fr-FR") value = $6c7bd7858deea686$var$replaceAll(value, ".", String.fromCharCode(8239));
    return value;
  }
  isValidPartialNumber(value, minValue = -Infinity, maxValue = Infinity) {
    value = this.sanitize(value);
    if (this.symbols.minusSign && value.startsWith(this.symbols.minusSign) && minValue < 0) value = value.slice(this.symbols.minusSign.length);
    else if (this.symbols.plusSign && value.startsWith(this.symbols.plusSign) && maxValue > 0) value = value.slice(this.symbols.plusSign.length);
    if (this.symbols.group && value.startsWith(this.symbols.group)) return false;
    if (this.symbols.decimal && value.indexOf(this.symbols.decimal) > -1 && this.options.maximumFractionDigits === 0) return false;
    if (this.symbols.group) value = $6c7bd7858deea686$var$replaceAll(value, this.symbols.group, "");
    value = value.replace(this.symbols.numeral, "");
    if (this.symbols.decimal) value = value.replace(this.symbols.decimal, "");
    return value.length === 0;
  }
  constructor(locale, options = {}) {
    this.locale = locale;
    this.formatter = new Intl.NumberFormat(locale, options);
    this.options = this.formatter.resolvedOptions();
    this.symbols = $6c7bd7858deea686$var$getSymbols(locale, this.formatter, this.options, options);
    var _this_options_minimumFractionDigits, _this_options_maximumFractionDigits;
    if (this.options.style === "percent" && (((_this_options_minimumFractionDigits = this.options.minimumFractionDigits) !== null && _this_options_minimumFractionDigits !== void 0 ? _this_options_minimumFractionDigits : 0) > 18 || ((_this_options_maximumFractionDigits = this.options.maximumFractionDigits) !== null && _this_options_maximumFractionDigits !== void 0 ? _this_options_maximumFractionDigits : 0) > 18)) console.warn("NumberParser cannot handle percentages with greater than 18 decimal places, please reduce the number in your options.");
  }
};
var $6c7bd7858deea686$var$nonLiteralParts = /* @__PURE__ */ new Set([
  "decimal",
  "fraction",
  "integer",
  "minusSign",
  "plusSign",
  "group"
]);
var $6c7bd7858deea686$var$pluralNumbers = [
  0,
  4,
  2,
  1,
  11,
  20,
  3,
  7,
  100,
  21,
  0.1,
  1.1
];
function $6c7bd7858deea686$var$getSymbols(locale, formatter, intlOptions, originalOptions) {
  var _allParts_find, _posAllParts_find, _decimalParts_find, _allParts_find1;
  let symbolFormatter = new Intl.NumberFormat(locale, {
    ...intlOptions,
    minimumSignificantDigits: 1,
    maximumSignificantDigits: 21
  });
  let allParts = symbolFormatter.formatToParts(-10000.111);
  let posAllParts = symbolFormatter.formatToParts(10000.111);
  let pluralParts = $6c7bd7858deea686$var$pluralNumbers.map((n) => symbolFormatter.formatToParts(n));
  var _allParts_find_value;
  let minusSign = (_allParts_find_value = (_allParts_find = allParts.find((p) => p.type === "minusSign")) === null || _allParts_find === void 0 ? void 0 : _allParts_find.value) !== null && _allParts_find_value !== void 0 ? _allParts_find_value : "-";
  let plusSign = (_posAllParts_find = posAllParts.find((p) => p.type === "plusSign")) === null || _posAllParts_find === void 0 ? void 0 : _posAllParts_find.value;
  if (!plusSign && ((originalOptions === null || originalOptions === void 0 ? void 0 : originalOptions.signDisplay) === "exceptZero" || (originalOptions === null || originalOptions === void 0 ? void 0 : originalOptions.signDisplay) === "always")) plusSign = "+";
  let decimalParts = new Intl.NumberFormat(locale, {
    ...intlOptions,
    minimumFractionDigits: 2,
    maximumFractionDigits: 2
  }).formatToParts(1e-3);
  let decimal = (_decimalParts_find = decimalParts.find((p) => p.type === "decimal")) === null || _decimalParts_find === void 0 ? void 0 : _decimalParts_find.value;
  let group = (_allParts_find1 = allParts.find((p) => p.type === "group")) === null || _allParts_find1 === void 0 ? void 0 : _allParts_find1.value;
  let allPartsLiterals = allParts.filter((p) => !$6c7bd7858deea686$var$nonLiteralParts.has(p.type)).map((p) => $6c7bd7858deea686$var$escapeRegex(p.value));
  let pluralPartsLiterals = pluralParts.flatMap((p) => p.filter((p2) => !$6c7bd7858deea686$var$nonLiteralParts.has(p2.type)).map((p2) => $6c7bd7858deea686$var$escapeRegex(p2.value)));
  let sortedLiterals = [
    .../* @__PURE__ */ new Set([
      ...allPartsLiterals,
      ...pluralPartsLiterals
    ])
  ].sort((a2, b2) => b2.length - a2.length);
  let literals = sortedLiterals.length === 0 ? new RegExp("[\\p{White_Space}]", "gu") : new RegExp(`${sortedLiterals.join("|")}|[\\p{White_Space}]`, "gu");
  let numerals = [
    ...new Intl.NumberFormat(intlOptions.locale, {
      useGrouping: false
    }).format(9876543210)
  ].reverse();
  let indexes = new Map(numerals.map((d, i) => [
    d,
    i
  ]));
  let numeral = new RegExp(`[${numerals.join("")}]`, "g");
  let index = (d) => String(indexes.get(d));
  return {
    minusSign,
    plusSign,
    decimal,
    group,
    literals,
    numeral,
    index
  };
}
function $6c7bd7858deea686$var$replaceAll(str, find, replace) {
  if (str.replaceAll)
    return str.replaceAll(find, replace);
  return str.split(find).join(replace);
}
function $6c7bd7858deea686$var$escapeRegex(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}

// node_modules/radix-vue/dist/index.js
function Q(a2, t) {
  const e = typeof a2 == "string" && !t ? `${a2}Context` : t, n = Symbol(e);
  return [(r) => {
    const i = inject(n, r);
    if (i || i === null)
      return i;
    throw new Error(
      `Injection \`${n.toString()}\` not found. Component must be used within ${Array.isArray(a2) ? `one of the following components: ${a2.join(
        ", "
      )}` : `\`${a2}\``}`
    );
  }, (r) => (provide(n, r), r)];
}
function zt(a2, t, e) {
  const n = e.originalEvent.target, l = new CustomEvent(a2, {
    bubbles: false,
    cancelable: true,
    detail: e
  });
  t && n.addEventListener(a2, t, { once: true }), n.dispatchEvent(l);
}
function Kt(a2, t = Number.NEGATIVE_INFINITY, e = Number.POSITIVE_INFINITY) {
  return Math.min(Math.max(a2, t), e);
}
function Sa(a2, t) {
  let e = a2;
  const n = t.toString(), l = n.indexOf("."), s = l >= 0 ? n.length - l : 0;
  if (s > 0) {
    const r = 10 ** s;
    e = Math.round(e * r) / r;
  }
  return e;
}
function Br(a2, t, e, n) {
  t = Number(t), e = Number(e);
  const l = (a2 - (Number.isNaN(t) ? 0 : t)) % n;
  let s = Sa(Math.abs(l) * 2 >= n ? a2 + Math.sign(l) * (n - Math.abs(l)) : a2 - l, n);
  return Number.isNaN(t) ? !Number.isNaN(e) && s > e && (s = Math.floor(Sa(e / n, n)) * n) : s < t ? s = t : !Number.isNaN(e) && s > e && (s = t + Math.floor(Sa((e - t) / n, n)) * n), s = Sa(s, n), s;
}
function Ir(a2) {
  return a2 && a2.__esModule && Object.prototype.hasOwnProperty.call(a2, "default") ? a2.default : a2;
}
var Tr = function a(t, e) {
  if (t === e) return true;
  if (t && e && typeof t == "object" && typeof e == "object") {
    if (t.constructor !== e.constructor) return false;
    var n, l, s;
    if (Array.isArray(t)) {
      if (n = t.length, n != e.length) return false;
      for (l = n; l-- !== 0; )
        if (!a(t[l], e[l])) return false;
      return true;
    }
    if (t.constructor === RegExp) return t.source === e.source && t.flags === e.flags;
    if (t.valueOf !== Object.prototype.valueOf) return t.valueOf() === e.valueOf();
    if (t.toString !== Object.prototype.toString) return t.toString() === e.toString();
    if (s = Object.keys(t), n = s.length, n !== Object.keys(e).length) return false;
    for (l = n; l-- !== 0; )
      if (!Object.prototype.hasOwnProperty.call(e, s[l])) return false;
    for (l = n; l-- !== 0; ) {
      var r = s[l];
      if (!a(t[r], e[r])) return false;
    }
    return true;
  }
  return t !== t && e !== e;
};
var Ye = Ir(Tr);
function Rr(a2, t) {
  if (a2.length !== t.length)
    return false;
  for (let e = 0; e < a2.length; e++)
    if (a2[e] !== t[e])
      return false;
  return true;
}
function St(a2, t, e) {
  const n = a2.findIndex((i) => Ye(i, t)), l = a2.findIndex((i) => Ye(i, e));
  if (n === -1 || l === -1)
    return [];
  const [s, r] = [n, l].sort((i, u) => i - u);
  return a2.slice(s, r + 1);
}
var va = typeof document < "u";
function Nt(a2) {
  return a2 == null;
}
function jt(a2) {
  const { defaultValue: t, defaultPlaceholder: e, granularity: n = "day" } = a2;
  if (Array.isArray(t) && t.length)
    return t.at(-1).copy();
  if (t && !Array.isArray(t))
    return t.copy();
  if (e)
    return e.copy();
  const l = /* @__PURE__ */ new Date(), s = l.getFullYear(), r = l.getMonth() + 1, i = l.getDate();
  return ["hour", "minute", "second"].includes(n ?? "day") ? new $35ea8db9cb2ccb90$export$ca871e8dbb80966f(s, r, i, 0, 0, 0) : new $35ea8db9cb2ccb90$export$99faa760c7908e4f(s, r, i);
}
var Ar = [
  "ach",
  "af",
  "am",
  "an",
  "ar",
  "ast",
  "az",
  "be",
  "bg",
  "bn",
  "br",
  "bs",
  "ca",
  "cak",
  "ckb",
  "cs",
  "cy",
  "da",
  "de",
  "dsb",
  "el",
  "en",
  "eo",
  "es",
  "et",
  "eu",
  "fa",
  "ff",
  "fi",
  "fr",
  "fy",
  "ga",
  "gd",
  "gl",
  "he",
  "hr",
  "hsb",
  "hu",
  "ia",
  "id",
  "it",
  "ja",
  "ka",
  "kk",
  "kn",
  "ko",
  "lb",
  "lo",
  "lt",
  "lv",
  "meh",
  "ml",
  "ms",
  "nl",
  "nn",
  "no",
  "oc",
  "pl",
  "pt",
  "rm",
  "ro",
  "ru",
  "sc",
  "scn",
  "sk",
  "sl",
  "sr",
  "sv",
  "szl",
  "tg",
  "th",
  "tr",
  "uk",
  "zh-CN",
  "zh-TW"
];
var Or = ["year", "month", "day"];
var vn = {
  ach: { year: "mwaka", month: "dwe", day: "nino" },
  af: { year: "jjjj", month: "mm", day: "dd" },
  am: { year: "ዓዓዓዓ", month: "ሚሜ", day: "ቀቀ" },
  an: { year: "aaaa", month: "mm", day: "dd" },
  ar: { year: "سنة", month: "شهر", day: "يوم" },
  ast: { year: "aaaa", month: "mm", day: "dd" },
  az: { year: "iiii", month: "aa", day: "gg" },
  be: { year: "гггг", month: "мм", day: "дд" },
  bg: { year: "гггг", month: "мм", day: "дд" },
  bn: { year: "yyyy", month: "মিমি", day: "dd" },
  br: { year: "bbbb", month: "mm", day: "dd" },
  bs: { year: "gggg", month: "mm", day: "dd" },
  ca: { year: "aaaa", month: "mm", day: "dd" },
  cak: { year: "jjjj", month: "ii", day: "q'q'" },
  ckb: { year: "ساڵ", month: "مانگ", day: "ڕۆژ" },
  cs: { year: "rrrr", month: "mm", day: "dd" },
  cy: { year: "bbbb", month: "mm", day: "dd" },
  da: { year: "åååå", month: "mm", day: "dd" },
  de: { year: "jjjj", month: "mm", day: "tt" },
  dsb: { year: "llll", month: "mm", day: "źź" },
  el: { year: "εεεε", month: "μμ", day: "ηη" },
  en: { year: "yyyy", month: "mm", day: "dd" },
  eo: { year: "jjjj", month: "mm", day: "tt" },
  es: { year: "aaaa", month: "mm", day: "dd" },
  et: { year: "aaaa", month: "kk", day: "pp" },
  eu: { year: "uuuu", month: "hh", day: "ee" },
  fa: { year: "سال", month: "ماه", day: "روز" },
  ff: { year: "hhhh", month: "ll", day: "ññ" },
  fi: { year: "vvvv", month: "kk", day: "pp" },
  fr: { year: "aaaa", month: "mm", day: "jj" },
  fy: { year: "jjjj", month: "mm", day: "dd" },
  ga: { year: "bbbb", month: "mm", day: "ll" },
  gd: { year: "bbbb", month: "mm", day: "ll" },
  gl: { year: "aaaa", month: "mm", day: "dd" },
  he: { year: "שנה", month: "חודש", day: "יום" },
  hr: { year: "gggg", month: "mm", day: "dd" },
  hsb: { year: "llll", month: "mm", day: "dd" },
  hu: { year: "éééé", month: "hh", day: "nn" },
  ia: { year: "aaaa", month: "mm", day: "dd" },
  id: { year: "tttt", month: "bb", day: "hh" },
  it: { year: "aaaa", month: "mm", day: "gg" },
  ja: { year: " 年 ", month: "月", day: "日" },
  ka: { year: "წწწწ", month: "თთ", day: "რრ" },
  kk: { year: "жжжж", month: "аа", day: "кк" },
  kn: { year: "ವವವವ", month: "ಮಿಮೀ", day: "ದಿದಿ" },
  ko: { year: "연도", month: "월", day: "일" },
  lb: { year: "jjjj", month: "mm", day: "dd" },
  lo: { year: "ປປປປ", month: "ດດ", day: "ວວ" },
  lt: { year: "mmmm", month: "mm", day: "dd" },
  lv: { year: "gggg", month: "mm", day: "dd" },
  meh: { year: "aaaa", month: "mm", day: "dd" },
  ml: { year: "വർഷം", month: "മാസം", day: "തീയതി" },
  ms: { year: "tttt", month: "mm", day: "hh" },
  nl: { year: "jjjj", month: "mm", day: "dd" },
  nn: { year: "åååå", month: "mm", day: "dd" },
  no: { year: "åååå", month: "mm", day: "dd" },
  oc: { year: "aaaa", month: "mm", day: "jj" },
  pl: { year: "rrrr", month: "mm", day: "dd" },
  pt: { year: "aaaa", month: "mm", day: "dd" },
  rm: { year: "oooo", month: "mm", day: "dd" },
  ro: { year: "aaaa", month: "ll", day: "zz" },
  ru: { year: "гггг", month: "мм", day: "дд" },
  sc: { year: "aaaa", month: "mm", day: "dd" },
  scn: { year: "aaaa", month: "mm", day: "jj" },
  sk: { year: "rrrr", month: "mm", day: "dd" },
  sl: { year: "llll", month: "mm", day: "dd" },
  sr: { year: "гггг", month: "мм", day: "дд" },
  sv: { year: "åååå", month: "mm", day: "dd" },
  szl: { year: "rrrr", month: "mm", day: "dd" },
  tg: { year: "сссс", month: "мм", day: "рр" },
  th: { year: "ปปปป", month: "ดด", day: "วว" },
  tr: { year: "yyyy", month: "aa", day: "gg" },
  uk: { year: "рррр", month: "мм", day: "дд" },
  "zh-CN": { year: "年", month: "月", day: "日" },
  "zh-TW": { year: "年", month: "月", day: "日" }
};
function kr(a2) {
  if (Vo(a2))
    return vn[a2];
  {
    const t = Lr(a2);
    return Vo(t) ? vn[t] : vn.en;
  }
}
function mn(a2, t, e) {
  return Mr(a2) ? kr(e)[a2] : Fr(a2) ? t : Vr(a2) ? "––" : "";
}
function Vo(a2) {
  return Ar.includes(a2);
}
function Mr(a2) {
  return Or.includes(a2);
}
function Vr(a2) {
  return a2 === "hour" || a2 === "minute" || a2 === "second";
}
function Fr(a2) {
  return a2 === "era" || a2 === "dayPeriod";
}
function Lr(a2) {
  return Intl.Locale ? new Intl.Locale(a2).language : a2.split("-")[0];
}
var Nn = ["day", "month", "year"];
var ml = ["hour", "minute", "second", "dayPeriod"];
var hl = [...Nn, ...ml];
function Nr(a2) {
  return Nn.includes(a2);
}
function yl(a2) {
  return hl.includes(a2);
}
function zr(a2, t) {
  const e = {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
    hour: "2-digit",
    minute: "2-digit",
    second: "2-digit",
    timeZoneName: "short",
    hourCycle: t === 24 ? "h24" : void 0,
    hour12: t === 24 ? false : void 0
  };
  return a2 === "day" && (delete e.second, delete e.hour, delete e.minute, delete e.timeZoneName), a2 === "hour" && (delete e.minute, delete e.second), a2 === "minute" && delete e.second, e;
}
function gl(a2) {
  const t = a2.querySelector("[data-selected]");
  if (t)
    return t.focus();
  const e = a2.querySelector("[data-today]");
  if (e)
    return e.focus();
  const n = a2.querySelector("[data-radix-vue-calendar-day]");
  if (n)
    return n.focus();
}
function Kr(a2, t) {
  var e;
  const n = shallowRef();
  return watchEffect(() => {
    n.value = a2();
  }, {
    ...t,
    flush: (e = void 0) != null ? e : "sync"
  }), readonly(n);
}
function Hr(a2, t) {
  let e, n, l;
  const s = ref(true), r = () => {
    s.value = true, l();
  };
  watch(a2, r, { flush: "sync" });
  const i = typeof t == "function" ? t : t.get, u = typeof t == "function" ? void 0 : t.set, d = customRef((p, c) => (n = p, l = c, {
    get() {
      return s.value && (e = i(), s.value = false), n(), e;
    },
    set(f) {
      u == null || u(f);
    }
  }));
  return Object.isExtensible(d) && (d.trigger = r), d;
}
function mt(a2) {
  return getCurrentScope() ? (onScopeDispose(a2), true) : false;
}
function ra() {
  const a2 = /* @__PURE__ */ new Set(), t = (l) => {
    a2.delete(l);
  };
  return {
    on: (l) => {
      a2.add(l);
      const s = () => t(l);
      return mt(s), {
        off: s
      };
    },
    off: t,
    trigger: (...l) => Promise.all(Array.from(a2).map((s) => s(...l)))
  };
}
function Wr(a2) {
  let t = false, e;
  const n = effectScope(true);
  return (...l) => (t || (e = n.run(() => a2(...l)), t = true), e);
}
function jr(a2) {
  let t = 0, e, n;
  const l = () => {
    t -= 1, n && t <= 0 && (n.stop(), e = void 0, n = void 0);
  };
  return (...s) => (t += 1, e || (n = effectScope(true), e = n.run(() => a2(...s))), mt(l), e);
}
function Ne(a2) {
  return typeof a2 == "function" ? a2() : unref(a2);
}
function Ur(a2) {
  if (!isRef(a2))
    return reactive(a2);
  const t = new Proxy({}, {
    get(e, n, l) {
      return unref(Reflect.get(a2.value, n, l));
    },
    set(e, n, l) {
      return isRef(a2.value[n]) && !isRef(l) ? a2.value[n].value = l : a2.value[n] = l, true;
    },
    deleteProperty(e, n) {
      return Reflect.deleteProperty(a2.value, n);
    },
    has(e, n) {
      return Reflect.has(a2.value, n);
    },
    ownKeys() {
      return Object.keys(a2.value);
    },
    getOwnPropertyDescriptor() {
      return {
        enumerable: true,
        configurable: true
      };
    }
  });
  return reactive(t);
}
function bl(a2) {
  return Ur(computed(a2));
}
var Je = typeof window < "u" && typeof document < "u";
typeof WorkerGlobalScope < "u" && globalThis instanceof WorkerGlobalScope;
var Gr = (a2) => typeof a2 < "u";
var qr = (a2) => a2 != null;
var Yr = Object.prototype.toString;
var Xr = (a2) => Yr.call(a2) === "[object Object]";
var Ma = () => {
};
var Fo = Zr();
function Zr() {
  var a2, t;
  return Je && ((a2 = window == null ? void 0 : window.navigator) == null ? void 0 : a2.userAgent) && (/iP(?:ad|hone|od)/.test(window.navigator.userAgent) || ((t = window == null ? void 0 : window.navigator) == null ? void 0 : t.maxTouchPoints) > 2 && /iPad|Macintosh/.test(window == null ? void 0 : window.navigator.userAgent));
}
function Cl(a2, t) {
  function e(...n) {
    return new Promise((l, s) => {
      Promise.resolve(a2(() => t.apply(this, n), { fn: t, thisArg: this, args: n })).then(l).catch(s);
    });
  }
  return e;
}
var wl = (a2) => a2();
function Jr(a2, t = {}) {
  let e, n, l = Ma;
  const s = (i) => {
    clearTimeout(i), l(), l = Ma;
  };
  return (i) => {
    const u = Ne(a2), d = Ne(t.maxWait);
    return e && s(e), u <= 0 || d !== void 0 && d <= 0 ? (n && (s(n), n = null), Promise.resolve(i())) : new Promise((p, c) => {
      l = t.rejectOnCancel ? c : p, d && !n && (n = setTimeout(() => {
        e && s(e), n = null, p(i());
      }, d)), e = setTimeout(() => {
        n && s(n), n = null, p(i());
      }, u);
    });
  };
}
function Qr(a2 = wl) {
  const t = ref(true);
  function e() {
    t.value = false;
  }
  function n() {
    t.value = true;
  }
  const l = (...s) => {
    t.value && a2(...s);
  };
  return { isActive: readonly(t), pause: e, resume: n, eventFilter: l };
}
function _l(a2) {
  return getCurrentInstance();
}
function Dt(a2, t = 1e4) {
  return customRef((e, n) => {
    let l = Ne(a2), s;
    const r = () => setTimeout(() => {
      l = Ne(a2), n();
    }, Ne(t));
    return mt(() => {
      clearTimeout(s);
    }), {
      get() {
        return e(), l;
      },
      set(i) {
        l = i, n(), clearTimeout(s), s = r();
      }
    };
  });
}
function zn(a2, t = 200, e = {}) {
  return Cl(
    Jr(t, e),
    a2
  );
}
function ei(a2, t, e = {}) {
  const {
    eventFilter: n = wl,
    ...l
  } = e;
  return watch(
    a2,
    Cl(
      n,
      t
    ),
    l
  );
}
function Lo(a2, t, e = {}) {
  const {
    eventFilter: n,
    ...l
  } = e, { eventFilter: s, pause: r, resume: i, isActive: u } = Qr(n);
  return { stop: ei(
    a2,
    t,
    {
      ...l,
      eventFilter: s
    }
  ), pause: r, resume: i, isActive: u };
}
function ti(a2, t, ...[e]) {
  const {
    flush: n = "sync",
    deep: l = false,
    immediate: s = true,
    direction: r = "both",
    transform: i = {}
  } = e || {}, u = [], d = "ltr" in i && i.ltr || ((f) => f), p = "rtl" in i && i.rtl || ((f) => f);
  return (r === "both" || r === "ltr") && u.push(Lo(
    a2,
    (f) => {
      u.forEach((v2) => v2.pause()), t.value = d(f), u.forEach((v2) => v2.resume());
    },
    { flush: n, deep: l, immediate: s }
  )), (r === "both" || r === "rtl") && u.push(Lo(
    t,
    (f) => {
      u.forEach((v2) => v2.pause()), a2.value = p(f), u.forEach((v2) => v2.resume());
    },
    { flush: n, deep: l, immediate: s }
  )), () => {
    u.forEach((f) => f.stop());
  };
}
function ai(a2, t) {
  _l() && onBeforeUnmount(a2, t);
}
function ni(a2, t = true, e) {
  _l() ? onMounted(a2, e) : t ? a2() : nextTick(a2);
}
function Kn(a2, t, e = {}) {
  const {
    immediate: n = true
  } = e, l = ref(false);
  let s = null;
  function r() {
    s && (clearTimeout(s), s = null);
  }
  function i() {
    l.value = false, r();
  }
  function u(...d) {
    r(), l.value = true, s = setTimeout(() => {
      l.value = false, s = null, a2(...d);
    }, Ne(t));
  }
  return n && (l.value = true, Je && u()), mt(i), {
    isPending: readonly(l),
    start: u,
    stop: i
  };
}
function oi(a2 = 1e3, t = {}) {
  const {
    controls: e = false,
    callback: n
  } = t, l = Kn(
    n ?? Ma,
    a2,
    t
  ), s = computed(() => !l.isPending.value);
  return e ? {
    ready: s,
    ...l
  } : s;
}
function li(a2, t, e) {
  const n = watch(a2, (...l) => (nextTick(() => n()), t(...l)), e);
  return n;
}
function Be(a2) {
  var t;
  const e = Ne(a2);
  return (t = e == null ? void 0 : e.$el) != null ? t : e;
}
var Ut = Je ? window : void 0;
function je(...a2) {
  let t, e, n, l;
  if (typeof a2[0] == "string" || Array.isArray(a2[0]) ? ([e, n, l] = a2, t = Ut) : [t, e, n, l] = a2, !t)
    return Ma;
  Array.isArray(e) || (e = [e]), Array.isArray(n) || (n = [n]);
  const s = [], r = () => {
    s.forEach((p) => p()), s.length = 0;
  }, i = (p, c, f, v2) => (p.addEventListener(c, f, v2), () => p.removeEventListener(c, f, v2)), u = watch(
    () => [Be(t), Ne(l)],
    ([p, c]) => {
      if (r(), !p)
        return;
      const f = Xr(c) ? { ...c } : c;
      s.push(
        ...e.flatMap((v2) => n.map((g) => i(p, v2, g, f)))
      );
    },
    { immediate: true, flush: "post" }
  ), d = () => {
    u(), r();
  };
  return mt(d), d;
}
function si(a2) {
  return typeof a2 == "function" ? a2 : typeof a2 == "string" ? (t) => t.key === a2 : Array.isArray(a2) ? (t) => a2.includes(t.key) : () => true;
}
function Hn(...a2) {
  let t, e, n = {};
  a2.length === 3 ? (t = a2[0], e = a2[1], n = a2[2]) : a2.length === 2 ? typeof a2[1] == "object" ? (t = true, e = a2[0], n = a2[1]) : (t = a2[0], e = a2[1]) : (t = true, e = a2[0]);
  const {
    target: l = Ut,
    eventName: s = "keydown",
    passive: r = false,
    dedupe: i = false
  } = n, u = si(t);
  return je(l, s, (p) => {
    p.repeat && Ne(i) || u(p) && e(p);
  }, r);
}
function Ha() {
  const a2 = ref(false), t = getCurrentInstance();
  return t && onMounted(() => {
    a2.value = true;
  }, t), a2;
}
function xl(a2) {
  const t = Ha();
  return computed(() => (t.value, !!a2()));
}
function Sl(a2, t, e = {}) {
  const { window: n = Ut, ...l } = e;
  let s;
  const r = xl(() => n && "MutationObserver" in n), i = () => {
    s && (s.disconnect(), s = void 0);
  }, u = computed(() => {
    const f = Ne(a2), v2 = (Array.isArray(f) ? f : [f]).map(Be).filter(qr);
    return new Set(v2);
  }), d = watch(
    () => u.value,
    (f) => {
      i(), r.value && f.size && (s = new MutationObserver(t), f.forEach((v2) => s.observe(v2, l)));
    },
    { immediate: true, flush: "post" }
  ), p = () => s == null ? void 0 : s.takeRecords(), c = () => {
    i(), d();
  };
  return mt(c), {
    isSupported: r,
    stop: c,
    takeRecords: p
  };
}
function ri(a2 = {}) {
  var t;
  const {
    window: e = Ut,
    deep: n = true,
    triggerOnRemoval: l = false
  } = a2, s = (t = a2.document) != null ? t : e == null ? void 0 : e.document, r = () => {
    var d;
    let p = s == null ? void 0 : s.activeElement;
    if (n)
      for (; p != null && p.shadowRoot; )
        p = (d = p == null ? void 0 : p.shadowRoot) == null ? void 0 : d.activeElement;
    return p;
  }, i = ref(), u = () => {
    i.value = r();
  };
  return e && (je(e, "blur", (d) => {
    d.relatedTarget === null && u();
  }, true), je(e, "focus", u, true)), l && Sl(s, (d) => {
    d.filter((p) => p.removedNodes.length).map((p) => Array.from(p.removedNodes)).flat().forEach((p) => {
      p === i.value && u();
    });
  }, {
    childList: true,
    subtree: true
  }), u(), i;
}
function El(a2, t = {}) {
  const {
    immediate: e = true,
    fpsLimit: n = void 0,
    window: l = Ut
  } = t, s = ref(false), r = n ? 1e3 / n : null;
  let i = 0, u = null;
  function d(f) {
    if (!s.value || !l)
      return;
    i || (i = f);
    const v2 = f - i;
    if (r && v2 < r) {
      u = l.requestAnimationFrame(d);
      return;
    }
    i = f, a2({ delta: v2, timestamp: f }), u = l.requestAnimationFrame(d);
  }
  function p() {
    !s.value && l && (s.value = true, i = 0, u = l.requestAnimationFrame(d));
  }
  function c() {
    s.value = false, u != null && l && (l.cancelAnimationFrame(u), u = null);
  }
  return e && p(), mt(c), {
    isActive: readonly(s),
    pause: c,
    resume: p
  };
}
function ii(a2) {
  return JSON.parse(JSON.stringify(a2));
}
function ui(a2) {
  const t = getCurrentInstance(), e = Hr(
    () => null,
    () => t.proxy.$el
  );
  return onUpdated(e.trigger), onMounted(e.trigger), e;
}
function Ze(a2, t, e = {}) {
  const { window: n = Ut, ...l } = e;
  let s;
  const r = xl(() => n && "ResizeObserver" in n), i = () => {
    s && (s.disconnect(), s = void 0);
  }, u = computed(() => Array.isArray(a2) ? a2.map((c) => Be(c)) : [Be(a2)]), d = watch(
    u,
    (c) => {
      if (i(), r.value && n) {
        s = new ResizeObserver(t);
        for (const f of c)
          f && s.observe(f, l);
      }
    },
    { immediate: true, flush: "post" }
  ), p = () => {
    i(), d();
  };
  return mt(p), {
    isSupported: r,
    stop: p
  };
}
function di(a2, t = {}) {
  const e = ri(t), n = computed(() => Be(a2));
  return { focused: computed(() => n.value && e.value ? n.value.contains(e.value) : false) };
}
function Pl(a2 = ui()) {
  const t = shallowRef(), e = () => {
    const n = Be(a2);
    n && (t.value = n.parentElement);
  };
  return ni(e), watch(() => Ne(a2), e), t;
}
function ae(a2, t, e, n = {}) {
  var l, s, r;
  const {
    clone: i = false,
    passive: u = false,
    eventName: d,
    deep: p = false,
    defaultValue: c,
    shouldEmit: f
  } = n, v2 = getCurrentInstance(), g = e || (v2 == null ? void 0 : v2.emit) || ((l = v2 == null ? void 0 : v2.$emit) == null ? void 0 : l.bind(v2)) || ((r = (s = v2 == null ? void 0 : v2.proxy) == null ? void 0 : s.$emit) == null ? void 0 : r.bind(v2 == null ? void 0 : v2.proxy));
  let m2 = d;
  t || (t = "modelValue"), m2 = m2 || `update:${t.toString()}`;
  const S = (h2) => i ? typeof i == "function" ? i(h2) : ii(h2) : h2, x = () => Gr(a2[t]) ? S(a2[t]) : c, D = (h2) => {
    f ? f(h2) && g(m2, h2) : g(m2, h2);
  };
  if (u) {
    const h2 = x(), E = ref(h2);
    let P2 = false;
    return watch(
      () => a2[t],
      ($2) => {
        P2 || (P2 = true, E.value = S($2), nextTick(() => P2 = false));
      }
    ), watch(
      E,
      ($2) => {
        !P2 && ($2 !== a2[t] || p) && D($2);
      },
      { deep: p }
    ), E;
  } else
    return computed({
      get() {
        return x();
      },
      set(h2) {
        D(h2);
      }
    });
}
function Wa(a2) {
  return a2 ? a2.flatMap((t) => t.type === Fragment ? Wa(t.children) : [t]) : [];
}
var ci = ["INPUT", "TEXTAREA"];
function $t(a2, t, e, n = {}) {
  if (!t || n.enableIgnoredElement && ci.includes(t.nodeName))
    return null;
  const {
    arrowKeyOptions: l = "both",
    attributeName: s = "[data-radix-vue-collection-item]",
    itemsArray: r = [],
    loop: i = true,
    dir: u = "ltr",
    preventScroll: d = true,
    focus: p = false
  } = n, [c, f, v2, g, m2, S] = [
    a2.key === "ArrowRight",
    a2.key === "ArrowLeft",
    a2.key === "ArrowUp",
    a2.key === "ArrowDown",
    a2.key === "Home",
    a2.key === "End"
  ], x = v2 || g, D = c || f;
  if (!m2 && !S && (!x && !D || l === "vertical" && D || l === "horizontal" && x))
    return null;
  const h2 = e ? Array.from(e.querySelectorAll(s)) : r;
  if (!h2.length)
    return null;
  d && a2.preventDefault();
  let E = null;
  return D || x ? E = Dl(h2, t, {
    goForward: x ? g : u === "ltr" ? c : f,
    loop: i
  }) : m2 ? E = h2.at(0) || null : S && (E = h2.at(-1) || null), p && (E == null || E.focus()), E;
}
function Dl(a2, t, e, n = a2.length) {
  if (--n === 0)
    return null;
  const l = a2.indexOf(t), s = e.goForward ? l + 1 : l - 1;
  if (!e.loop && (s < 0 || s >= a2.length))
    return null;
  const r = (s + a2.length) % a2.length, i = a2[r];
  return i ? i.hasAttribute("disabled") && i.getAttribute("disabled") !== "false" ? Dl(
    a2,
    i,
    e,
    n
  ) : i : null;
}
function hn(a2) {
  if (a2 === null || typeof a2 != "object")
    return false;
  const t = Object.getPrototypeOf(a2);
  return t !== null && t !== Object.prototype && Object.getPrototypeOf(t) !== null || Symbol.iterator in a2 ? false : Symbol.toStringTag in a2 ? Object.prototype.toString.call(a2) === "[object Module]" : true;
}
function Sn(a2, t, e = ".", n) {
  if (!hn(t))
    return Sn(a2, {}, e, n);
  const l = Object.assign({}, t);
  for (const s in a2) {
    if (s === "__proto__" || s === "constructor")
      continue;
    const r = a2[s];
    r != null && (n && n(l, s, r, e) || (Array.isArray(r) && Array.isArray(l[s]) ? l[s] = [...r, ...l[s]] : hn(r) && hn(l[s]) ? l[s] = Sn(
      r,
      l[s],
      (e ? `${e}.` : "") + s.toString(),
      n
    ) : l[s] = r));
  }
  return l;
}
function pi(a2) {
  return (...t) => (
    // eslint-disable-next-line unicorn/no-array-reduce
    t.reduce((e, n) => Sn(e, n, "", a2), {})
  );
}
var fi = pi();
var [ja, vi] = Q("ConfigProvider");
var lv = defineComponent({
  __name: "ConfigProvider",
  props: {
    dir: { default: "ltr" },
    scrollBody: { type: [Boolean, Object], default: true },
    nonce: { default: void 0 },
    useId: { type: Function, default: void 0 }
  },
  setup(a2) {
    const t = a2, { dir: e, scrollBody: n, nonce: l } = toRefs(t);
    return vi({
      dir: e,
      scrollBody: n,
      nonce: l,
      useId: t.useId
    }), (s, r) => renderSlot(s.$slots, "default");
  }
});
var mi = "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";
var hi = (a2 = 21) => {
  let t = "", e = a2;
  for (; e--; )
    t += mi[Math.random() * 64 | 0];
  return t;
};
var yi = jr(() => {
  const a2 = ref(/* @__PURE__ */ new Map()), t = ref(), e = computed(() => {
    for (const r of a2.value.values())
      if (r)
        return true;
    return false;
  }), n = ja({
    scrollBody: ref(true)
  });
  let l = null;
  const s = () => {
    document.body.style.paddingRight = "", document.body.style.marginRight = "", document.body.style.pointerEvents = "", document.body.style.removeProperty("--scrollbar-width"), document.body.style.overflow = t.value ?? "", Fo && (l == null || l()), t.value = void 0;
  };
  return watch(e, (r, i) => {
    var c;
    if (!Je)
      return;
    if (!r) {
      i && s();
      return;
    }
    t.value === void 0 && (t.value = document.body.style.overflow);
    const u = window.innerWidth - document.documentElement.clientWidth, d = { padding: u, margin: 0 }, p = (c = n.scrollBody) != null && c.value ? typeof n.scrollBody.value == "object" ? fi({
      padding: n.scrollBody.value.padding === true ? u : n.scrollBody.value.padding,
      margin: n.scrollBody.value.margin === true ? u : n.scrollBody.value.margin
    }, d) : d : { padding: 0, margin: 0 };
    u > 0 && (document.body.style.paddingRight = `${p.padding}px`, document.body.style.marginRight = `${p.margin}px`, document.body.style.setProperty("--scrollbar-width", `${u}px`), document.body.style.overflow = "hidden"), Fo && (l = je(
      document,
      "touchmove",
      (f) => {
        var v2;
        f.target === document.documentElement && (f.touches.length > 1 || (v2 = f.preventDefault) == null || v2.call(f));
      },
      { passive: false }
    )), nextTick(() => {
      document.body.style.pointerEvents = "none", document.body.style.overflow = "hidden";
    });
  }, { immediate: true, flush: "sync" }), a2;
});
function ma(a2) {
  const t = hi(6), e = yi();
  e.value.set(t, a2 ?? false);
  const n = computed({
    get: () => e.value.get(t) ?? false,
    set: (l) => e.value.set(t, l)
  });
  return ai(() => {
    e.value.delete(t);
  }), n;
}
var gi = "data-radix-vue-collection-item";
function Me(a2, t = gi) {
  const e = a2 ?? Symbol();
  return { createCollection: (s) => {
    const r = ref([]);
    function i() {
      const u = Be(s);
      return u ? r.value = Array.from(
        u.querySelectorAll(`[${t}]:not([data-disabled])`)
      ) : r.value = [];
    }
    return onBeforeUpdate(() => {
      r.value = [];
    }), onMounted(i), onUpdated(i), watch(() => s == null ? void 0 : s.value, i, { immediate: true }), provide(e, r), r;
  }, injectCollection: () => inject(e, ref([])) };
}
function Wn(a2) {
  const t = ref(a2);
  function e() {
    return t.value;
  }
  function n(m2) {
    t.value = m2;
  }
  function l(m2, S) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, S).format(m2);
  }
  function s(m2, S = true) {
    return z(m2) && S ? l($(m2), {
      dateStyle: "long",
      timeStyle: "long"
    }) : l($(m2), {
      dateStyle: "long"
    });
  }
  function r(m2, S = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, { month: "long", year: "numeric", ...S }).format(m2);
  }
  function i(m2, S = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, { month: "long", ...S }).format(m2);
  }
  function u() {
    const m2 = $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3($14e0f24ef4ac5c92$export$aa8b41735afcabd2());
    return [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12].map((x) => ({ label: i($(m2.set({ month: x }))), value: x }));
  }
  function d(m2, S = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, { year: "numeric", ...S }).format(m2);
  }
  function p(m2, S) {
    return m(m2) ? new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, {
      ...S,
      timeZone: m2.timeZone
    }).formatToParts($(m2)) : new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, S).formatToParts($(m2));
  }
  function c(m2, S = "narrow") {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, { weekday: S }).format(m2);
  }
  function f(m2) {
    var D;
    return ((D = new $fb18d541ea1ad717$export$ad991b66133851cf(t.value, {
      hour: "numeric",
      minute: "numeric"
    }).formatToParts(m2).find((h2) => h2.type === "dayPeriod")) == null ? void 0 : D.value) === "PM" ? "PM" : "AM";
  }
  const v2 = {
    year: "numeric",
    month: "numeric",
    day: "numeric",
    hour: "numeric",
    minute: "numeric",
    second: "numeric"
  };
  function g(m2, S, x = {}) {
    const D = { ...v2, ...x }, E = p(m2, D).find((P2) => P2.type === S);
    return E ? E.value : "";
  }
  return {
    setLocale: n,
    getLocale: e,
    fullMonth: i,
    fullYear: d,
    fullMonthAndYear: r,
    toParts: p,
    custom: l,
    part: g,
    dayPeriod: f,
    selectedDate: s,
    dayOfWeek: c,
    getMonths: u
  };
}
function Ce(a2) {
  const t = ja({
    dir: ref("ltr")
  });
  return computed(() => {
    var e;
    return (a2 == null ? void 0 : a2.value) || ((e = t.dir) == null ? void 0 : e.value) || "ltr";
  });
}
function Te(a2) {
  const t = getCurrentInstance(), e = t == null ? void 0 : t.type.emits, n = {};
  return e != null && e.length || console.warn(
    `No emitted event found. Please check component: ${t == null ? void 0 : t.type.__name}`
  ), e == null || e.forEach((l) => {
    n[toHandlerKey(camelize(l))] = (...s) => a2(l, ...s);
  }), n;
}
var yn = 0;
function jn() {
  watchEffect((a2) => {
    if (!Je)
      return;
    const t = document.querySelectorAll("[data-radix-focus-guard]");
    document.body.insertAdjacentElement(
      "afterbegin",
      t[0] ?? No()
    ), document.body.insertAdjacentElement(
      "beforeend",
      t[1] ?? No()
    ), yn++, a2(() => {
      yn === 1 && document.querySelectorAll("[data-radix-focus-guard]").forEach((e) => e.remove()), yn--;
    });
  });
}
function No() {
  const a2 = document.createElement("span");
  return a2.setAttribute("data-radix-focus-guard", ""), a2.tabIndex = 0, a2.style.cssText = "outline: none; opacity: 0; position: fixed; pointer-events: none", a2;
}
function Qe(a2) {
  return computed(() => {
    var t;
    return Ne(a2) ? !!((t = Be(a2)) != null && t.closest("form")) : true;
  });
}
function Bt(a2) {
  const t = getCurrentInstance(), e = Object.keys((t == null ? void 0 : t.type.props) ?? {}).reduce((l, s) => {
    const r = (t == null ? void 0 : t.type.props[s]).default;
    return r !== void 0 && (l[s] = r), l;
  }, {}), n = toRef(a2);
  return computed(() => {
    const l = {}, s = (t == null ? void 0 : t.vnode.props) ?? {};
    return Object.keys(s).forEach((r) => {
      l[camelize(r)] = s[r];
    }), Object.keys({ ...e, ...l }).reduce((r, i) => (n.value[i] !== void 0 && (r[i] = n.value[i]), r), {});
  });
}
function xe(a2, t) {
  const e = Bt(a2), n = t ? Te(t) : {};
  return computed(() => ({
    ...e.value,
    ...n
  }));
}
function R2() {
  const a2 = getCurrentInstance(), t = ref(), e = computed(() => {
    var r, i;
    return ["#text", "#comment"].includes((r = t.value) == null ? void 0 : r.$el.nodeName) ? (i = t.value) == null ? void 0 : i.$el.nextElementSibling : Be(t);
  }), n = Object.assign({}, a2.exposed), l = {};
  for (const r in a2.props)
    Object.defineProperty(l, r, {
      enumerable: true,
      configurable: true,
      get: () => a2.props[r]
    });
  if (Object.keys(n).length > 0)
    for (const r in n)
      Object.defineProperty(l, r, {
        enumerable: true,
        configurable: true,
        get: () => n[r]
      });
  Object.defineProperty(l, "$el", {
    enumerable: true,
    configurable: true,
    get: () => a2.vnode.el
  }), a2.exposed = l;
  function s(r) {
    t.value = r, !(r instanceof Element || !r) && (Object.defineProperty(l, "$el", {
      enumerable: true,
      configurable: true,
      get: () => r.$el
    }), a2.exposed = l);
  }
  return { forwardRef: s, currentRef: t, currentElement: e };
}
function $l(a2, t) {
  const e = Dt(false, 300), n = ref(null), l = ra();
  function s() {
    n.value = null, e.value = false;
  }
  function r(i, u) {
    const d = i.currentTarget, p = { x: i.clientX, y: i.clientY }, c = bi(p, d.getBoundingClientRect()), f = Ci(p, c), v2 = wi(u.getBoundingClientRect()), g = xi([...f, ...v2]);
    n.value = g, e.value = true;
  }
  return watchEffect((i) => {
    if (a2.value && t.value) {
      const u = (p) => r(p, t.value), d = (p) => r(p, a2.value);
      a2.value.addEventListener("pointerleave", u), t.value.addEventListener("pointerleave", d), i(() => {
        var p, c;
        (p = a2.value) == null || p.removeEventListener("pointerleave", u), (c = t.value) == null || c.removeEventListener("pointerleave", d);
      });
    }
  }), watchEffect((i) => {
    if (n.value) {
      const u = (d) => {
        var m2, S;
        if (!n.value)
          return;
        const p = d.target, c = { x: d.clientX, y: d.clientY }, f = ((m2 = a2.value) == null ? void 0 : m2.contains(p)) || ((S = t.value) == null ? void 0 : S.contains(p)), v2 = !_i(c, n.value), g = p.hasAttribute("data-grace-area-trigger");
        f ? s() : (v2 || g) && (s(), l.trigger());
      };
      document.addEventListener("pointermove", u), i(() => document.removeEventListener("pointermove", u));
    }
  }), {
    isPointerInTransit: e,
    onPointerExit: l.on
  };
}
function bi(a2, t) {
  const e = Math.abs(t.top - a2.y), n = Math.abs(t.bottom - a2.y), l = Math.abs(t.right - a2.x), s = Math.abs(t.left - a2.x);
  switch (Math.min(e, n, l, s)) {
    case s:
      return "left";
    case l:
      return "right";
    case e:
      return "top";
    case n:
      return "bottom";
    default:
      throw new Error("unreachable");
  }
}
function Ci(a2, t, e = 5) {
  const n = [];
  switch (t) {
    case "top":
      n.push(
        { x: a2.x - e, y: a2.y + e },
        { x: a2.x + e, y: a2.y + e }
      );
      break;
    case "bottom":
      n.push(
        { x: a2.x - e, y: a2.y - e },
        { x: a2.x + e, y: a2.y - e }
      );
      break;
    case "left":
      n.push(
        { x: a2.x + e, y: a2.y - e },
        { x: a2.x + e, y: a2.y + e }
      );
      break;
    case "right":
      n.push(
        { x: a2.x - e, y: a2.y - e },
        { x: a2.x - e, y: a2.y + e }
      );
      break;
  }
  return n;
}
function wi(a2) {
  const { top: t, right: e, bottom: n, left: l } = a2;
  return [
    { x: l, y: t },
    { x: e, y: t },
    { x: e, y: n },
    { x: l, y: n }
  ];
}
function _i(a2, t) {
  const { x: e, y: n } = a2;
  let l = false;
  for (let s = 0, r = t.length - 1; s < t.length; r = s++) {
    const i = t[s].x, u = t[s].y, d = t[r].x, p = t[r].y;
    u > n != p > n && e < (d - i) * (n - u) / (p - u) + i && (l = !l);
  }
  return l;
}
function xi(a2) {
  const t = a2.slice();
  return t.sort((e, n) => e.x < n.x ? -1 : e.x > n.x ? 1 : e.y < n.y ? -1 : e.y > n.y ? 1 : 0), Si(t);
}
function Si(a2) {
  if (a2.length <= 1)
    return a2.slice();
  const t = [];
  for (let n = 0; n < a2.length; n++) {
    const l = a2[n];
    for (; t.length >= 2; ) {
      const s = t[t.length - 1], r = t[t.length - 2];
      if ((s.x - r.x) * (l.y - r.y) >= (s.y - r.y) * (l.x - r.x))
        t.pop();
      else break;
    }
    t.push(l);
  }
  t.pop();
  const e = [];
  for (let n = a2.length - 1; n >= 0; n--) {
    const l = a2[n];
    for (; e.length >= 2; ) {
      const s = e[e.length - 1], r = e[e.length - 2];
      if ((s.x - r.x) * (l.y - r.y) >= (s.y - r.y) * (l.x - r.x))
        e.pop();
      else break;
    }
    e.push(l);
  }
  return e.pop(), t.length === 1 && e.length === 1 && t[0].x === e[0].x && t[0].y === e[0].y ? t : t.concat(e);
}
var Ei = function(a2) {
  if (typeof document > "u")
    return null;
  var t = Array.isArray(a2) ? a2[0] : a2;
  return t.ownerDocument.body;
};
var Vt = /* @__PURE__ */ new WeakMap();
var Ea = /* @__PURE__ */ new WeakMap();
var Pa = {};
var gn = 0;
var Bl = function(a2) {
  return a2 && (a2.host || Bl(a2.parentNode));
};
var Pi = function(a2, t) {
  return t.map(function(e) {
    if (a2.contains(e))
      return e;
    var n = Bl(e);
    return n && a2.contains(n) ? n : (console.error("aria-hidden", e, "in not contained inside", a2, ". Doing nothing"), null);
  }).filter(function(e) {
    return !!e;
  });
};
var Di = function(a2, t, e, n) {
  var l = Pi(t, Array.isArray(a2) ? a2 : [a2]);
  Pa[e] || (Pa[e] = /* @__PURE__ */ new WeakMap());
  var s = Pa[e], r = [], i = /* @__PURE__ */ new Set(), u = new Set(l), d = function(c) {
    !c || i.has(c) || (i.add(c), d(c.parentNode));
  };
  l.forEach(d);
  var p = function(c) {
    !c || u.has(c) || Array.prototype.forEach.call(c.children, function(f) {
      if (i.has(f))
        p(f);
      else
        try {
          var v2 = f.getAttribute(n), g = v2 !== null && v2 !== "false", m2 = (Vt.get(f) || 0) + 1, S = (s.get(f) || 0) + 1;
          Vt.set(f, m2), s.set(f, S), r.push(f), m2 === 1 && g && Ea.set(f, true), S === 1 && f.setAttribute(e, "true"), g || f.setAttribute(n, "true");
        } catch (x) {
          console.error("aria-hidden: cannot operate on ", f, x);
        }
    });
  };
  return p(t), i.clear(), gn++, function() {
    r.forEach(function(c) {
      var f = Vt.get(c) - 1, v2 = s.get(c) - 1;
      Vt.set(c, f), s.set(c, v2), f || (Ea.has(c) || c.removeAttribute(n), Ea.delete(c)), v2 || c.removeAttribute(e);
    }), gn--, gn || (Vt = /* @__PURE__ */ new WeakMap(), Vt = /* @__PURE__ */ new WeakMap(), Ea = /* @__PURE__ */ new WeakMap(), Pa = {});
  };
};
var $i = function(a2, t, e) {
  e === void 0 && (e = "data-aria-hidden");
  var n = Array.from(Array.isArray(a2) ? a2 : [a2]), l = Ei(a2);
  return l ? (n.push.apply(n, Array.from(l.querySelectorAll("[aria-live]"))), Di(n, l, e, "aria-hidden")) : function() {
    return null;
  };
};
function ha(a2) {
  let t;
  watch(() => Be(a2), (e) => {
    e ? t = $i(e) : t && t();
  }), onUnmounted(() => {
    t && t();
  });
}
var Bi = 0;
function me(a2, t = "radix") {
  if (a2)
    return a2;
  const { useId: e } = ja({ useId: void 0 });
  return e && typeof e == "function" ? `${t}-${e()}` : `${t}-${++Bi}`;
}
function Ii(a2, t) {
  const e = ref(), n = (s, r) => {
    if (t.multiple && Array.isArray(a2.value))
      if (t.selectionBehavior === "replace")
        a2.value = [s], e.value = s;
      else {
        const i = a2.value.findIndex((u) => r(u));
        i !== -1 ? a2.value.splice(i, 1) : a2.value.push(s);
      }
    else
      t.selectionBehavior === "replace" ? a2.value = { ...s } : !Array.isArray(a2.value) && r(a2.value) ? a2.value = void 0 : a2.value = { ...s };
    return a2.value;
  };
  function l(s, r, i, u) {
    var f;
    if (!(e != null && e.value) || !t.multiple || !Array.isArray(a2.value))
      return;
    const p = (f = i().filter((v2) => v2.ref.dataset.disabled !== "").find((v2) => v2.ref === r)) == null ? void 0 : f.value;
    if (!p)
      return;
    let c = null;
    switch (s) {
      case "prev":
      case "next": {
        c = St(u, e.value, p);
        break;
      }
      case "first": {
        c = St(u, e.value, u == null ? void 0 : u[0]);
        break;
      }
      case "last": {
        c = St(u, e.value, u == null ? void 0 : u[u.length - 1]);
        break;
      }
    }
    a2.value = c;
  }
  return {
    firstValue: e,
    onSelectItem: n,
    handleMultipleReplace: l
  };
}
function Il(a2) {
  const t = ref(), e = computed(() => {
    var l;
    return ((l = t.value) == null ? void 0 : l.width) ?? 0;
  }), n = computed(() => {
    var l;
    return ((l = t.value) == null ? void 0 : l.height) ?? 0;
  });
  return onMounted(() => {
    const l = Be(a2);
    if (l) {
      t.value = { width: l.offsetWidth, height: l.offsetHeight };
      const s = new ResizeObserver((r) => {
        if (!Array.isArray(r) || !r.length)
          return;
        const i = r[0];
        let u, d;
        if ("borderBoxSize" in i) {
          const p = i.borderBoxSize, c = Array.isArray(p) ? p[0] : p;
          u = c.inlineSize, d = c.blockSize;
        } else
          u = l.offsetWidth, d = l.offsetHeight;
        t.value = { width: u, height: d };
      });
      return s.observe(l, { box: "border-box" }), () => s.unobserve(l);
    } else
      t.value = void 0;
  }), {
    width: e,
    height: n
  };
}
function Tl(a2, t) {
  const e = ref(a2);
  function n(s) {
    return t[e.value][s] ?? e.value;
  }
  return {
    state: e,
    dispatch: (s) => {
      e.value = n(s);
    }
  };
}
function ya(a2) {
  const t = Dt("", 1e3);
  return {
    search: t,
    handleTypeaheadSearch: (l, s) => {
      var f, v2;
      if (!(a2 != null && a2.value) && !s)
        return;
      t.value = t.value + l;
      const r = (a2 == null ? void 0 : a2.value) ?? s, i = document.activeElement, u = ((v2 = (f = r.find((g) => g === i)) == null ? void 0 : f.textContent) == null ? void 0 : v2.trim()) ?? "", d = r.map((g) => {
        var m2;
        return ((m2 = g.textContent) == null ? void 0 : m2.trim()) ?? "";
      }), p = Gn(d, t.value, u), c = r.find(
        (g) => {
          var m2;
          return ((m2 = g.textContent) == null ? void 0 : m2.trim()) === p;
        }
      );
      return c && c.focus(), c;
    },
    resetTypeahead: () => {
      t.value = "";
    }
  };
}
function Un(a2, t) {
  return a2.map((e, n) => a2[(t + n) % a2.length]);
}
function Gn(a2, t, e) {
  const l = t.length > 1 && Array.from(t).every((d) => d === t[0]) ? t[0] : t, s = e ? a2.indexOf(e) : -1;
  let r = Un(a2, Math.max(s, 0));
  l.length === 1 && (r = r.filter((d) => d !== e));
  const u = r.find(
    (d) => d.toLowerCase().startsWith(l.toLowerCase())
  );
  return u !== e ? u : void 0;
}
function sv(a2, t) {
  return {
    inheritAttrs: false,
    name: `${a2.__name ?? ""}Wrapper`,
    setup(e, n) {
      return () => {
        const l = typeof (t == null ? void 0 : t.props) == "function" ? t == null ? void 0 : t.props(n.attrs) : t == null ? void 0 : t.props, { forwardRef: s } = R2(), r = mergeProps(l, n.attrs);
        return h(a2, { ...r, ref: s }, n.slots);
      };
    }
  };
}
function et() {
  return {
    ALT: "Alt",
    ARROW_DOWN: "ArrowDown",
    ARROW_LEFT: "ArrowLeft",
    ARROW_RIGHT: "ArrowRight",
    ARROW_UP: "ArrowUp",
    BACKSPACE: "Backspace",
    CAPS_LOCK: "CapsLock",
    CONTROL: "Control",
    DELETE: "Delete",
    END: "End",
    ENTER: "Enter",
    ESCAPE: "Escape",
    F1: "F1",
    F10: "F10",
    F11: "F11",
    F12: "F12",
    F2: "F2",
    F3: "F3",
    F4: "F4",
    F5: "F5",
    F6: "F6",
    F7: "F7",
    F8: "F8",
    F9: "F9",
    HOME: "Home",
    META: "Meta",
    PAGE_DOWN: "PageDown",
    PAGE_UP: "PageUp",
    SHIFT: "Shift",
    SPACE: " ",
    TAB: "Tab",
    CTRL: "Control",
    ASTERISK: "*",
    SPACE_CODE: "Space"
  };
}
var qn = defineComponent({
  name: "PrimitiveSlot",
  inheritAttrs: false,
  setup(a2, { attrs: t, slots: e }) {
    return () => {
      var u, d;
      if (!e.default)
        return null;
      const n = Wa(e.default()), l = n.findIndex((p) => p.type !== Comment);
      if (l === -1)
        return n;
      const s = n[l];
      (u = s.props) == null || delete u.ref;
      const r = s.props ? mergeProps(t, s.props) : t;
      t.class && ((d = s.props) != null && d.class) && delete s.props.class;
      const i = cloneVNode(s, r);
      for (const p in r)
        p.startsWith("on") && (i.props || (i.props = {}), i.props[p] = r[p]);
      return n.length === 1 ? i : (n[l] = i, n);
    };
  }
});
var A2 = defineComponent({
  name: "Primitive",
  inheritAttrs: false,
  props: {
    asChild: {
      type: Boolean,
      default: false
    },
    as: {
      type: [String, Object],
      default: "div"
    }
  },
  setup(a2, { attrs: t, slots: e }) {
    const n = a2.asChild ? "template" : a2.as;
    return typeof n == "string" && ["area", "img", "input"].includes(n) ? () => h(n, t) : n !== "template" ? () => h(a2.as, t, { default: e.default }) : () => h(qn, t, { default: e.default });
  }
});
function Re() {
  const a2 = ref(), t = computed(() => {
    var e, n;
    return ["#text", "#comment"].includes((e = a2.value) == null ? void 0 : e.$el.nodeName) ? (n = a2.value) == null ? void 0 : n.$el.nextElementSibling : Be(a2);
  });
  return {
    primitiveElement: a2,
    currentElement: t
  };
}
var [Rl, Ti] = Q("CollapsibleRoot");
var Ri = defineComponent({
  __name: "CollapsibleRoot",
  props: {
    defaultOpen: { type: Boolean, default: false },
    open: { type: Boolean, default: void 0 },
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:open"],
  setup(a2, { expose: t, emit: e }) {
    const n = a2, s = ae(n, "open", e, {
      defaultValue: n.defaultOpen,
      passive: n.open === void 0
    }), r = ae(n, "disabled");
    return Ti({
      contentId: "",
      disabled: r,
      open: s,
      onOpenToggle: () => {
        s.value = !s.value;
      }
    }), t({ open: s }), R2(), (i, u) => (openBlock(), createBlock(unref(A2), {
      as: i.as,
      "as-child": n.asChild,
      "data-state": n.open ? "open" : "closed",
      "data-disabled": n.disabled ? "" : void 0
    }, {
      default: withCtx(() => [
        renderSlot(i.$slots, "default", { open: unref(s) })
      ]),
      _: 3
    }, 8, ["as", "as-child", "data-state", "data-disabled"]));
  }
});
var Ai = defineComponent({
  __name: "CollapsibleTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Rl();
    return (n, l) => {
      var s, r;
      return openBlock(), createBlock(unref(A2), {
        type: n.as === "button" ? "button" : void 0,
        as: n.as,
        "as-child": t.asChild,
        "aria-controls": unref(e).contentId,
        "aria-expanded": unref(e).open.value,
        "data-state": unref(e).open.value ? "open" : "closed",
        "data-disabled": (s = unref(e).disabled) != null && s.value ? "" : void 0,
        disabled: (r = unref(e).disabled) == null ? void 0 : r.value,
        onClick: unref(e).onOpenToggle
      }, {
        default: withCtx(() => [
          renderSlot(n.$slots, "default")
        ]),
        _: 3
      }, 8, ["type", "as", "as-child", "aria-controls", "aria-expanded", "data-state", "data-disabled", "disabled", "onClick"]);
    };
  }
});
function Oi(a2, t) {
  const e = ref({}), n = ref("none"), l = a2.value ? "mounted" : "unmounted", { state: s, dispatch: r } = Tl(l, {
    mounted: {
      UNMOUNT: "unmounted",
      ANIMATION_OUT: "unmountSuspended"
    },
    unmountSuspended: {
      MOUNT: "mounted",
      ANIMATION_END: "unmounted"
    },
    unmounted: {
      MOUNT: "mounted"
    }
  }), i = (v2) => {
    var g;
    if (Je) {
      const m2 = new CustomEvent(v2, { bubbles: false, cancelable: false });
      (g = t.value) == null || g.dispatchEvent(m2);
    }
  };
  watch(
    a2,
    async (v2, g) => {
      var S;
      const m2 = g !== v2;
      if (await nextTick(), m2) {
        const x = n.value, D = Da(t.value);
        v2 ? (r("MOUNT"), i("enter"), D === "none" && i("after-enter")) : D === "none" || ((S = e.value) == null ? void 0 : S.display) === "none" ? (r("UNMOUNT"), i("leave"), i("after-leave")) : g && x !== D ? (r("ANIMATION_OUT"), i("leave")) : (r("UNMOUNT"), i("after-leave"));
      }
    },
    { immediate: true }
  );
  const u = (v2) => {
    const g = Da(t.value), m2 = g.includes(
      v2.animationName
    ), S = s.value === "mounted" ? "enter" : "leave";
    v2.target === t.value && m2 && (i(`after-${S}`), r("ANIMATION_END")), v2.target === t.value && g === "none" && r("ANIMATION_END");
  }, d = (v2) => {
    v2.target === t.value && (n.value = Da(t.value));
  }, p = watch(
    t,
    (v2, g) => {
      v2 ? (e.value = getComputedStyle(v2), v2.addEventListener("animationstart", d), v2.addEventListener("animationcancel", u), v2.addEventListener("animationend", u)) : (r("ANIMATION_END"), g == null || g.removeEventListener("animationstart", d), g == null || g.removeEventListener("animationcancel", u), g == null || g.removeEventListener("animationend", u));
    },
    { immediate: true }
  ), c = watch(s, () => {
    const v2 = Da(t.value);
    n.value = s.value === "mounted" ? v2 : "none";
  });
  return onUnmounted(() => {
    p(), c();
  }), {
    isPresent: computed(
      () => ["mounted", "unmountSuspended"].includes(s.value)
    )
  };
}
function Da(a2) {
  return a2 && getComputedStyle(a2).animationName || "none";
}
var Pe = defineComponent({
  name: "Presence",
  props: {
    present: {
      type: Boolean,
      required: true
    },
    forceMount: {
      type: Boolean
    }
  },
  slots: {},
  setup(a2, { slots: t, expose: e }) {
    var d;
    const { present: n, forceMount: l } = toRefs(a2), s = ref(), { isPresent: r } = Oi(n, s);
    e({ present: r });
    let i = t.default({ present: r });
    i = Wa(i || []);
    const u = getCurrentInstance();
    if (i && (i == null ? void 0 : i.length) > 1) {
      const p = (d = u == null ? void 0 : u.parent) != null && d.type.name ? `<${u.parent.type.name} />` : "component";
      throw new Error(
        [
          `Detected an invalid children for \`${p}\` for  \`Presence\` component.`,
          "",
          "Note: Presence works similarly to `v-if` directly, but it waits for animation/transition to finished before unmounting. So it expect only one direct child of valid VNode type.",
          "You can apply a few solutions:",
          [
            "Provide a single child element so that `presence` directive attach correctly.",
            "Ensure the first child is an actual element instead of a raw text node or comment node."
          ].map((c) => `  - ${c}`).join(`
`)
        ].join(`
`)
      );
    }
    return () => l.value || n.value || r.value ? h(t.default({ present: r })[0], {
      ref: (p) => {
        const c = Be(p);
        return typeof (c == null ? void 0 : c.hasAttribute) > "u" || (c != null && c.hasAttribute("data-radix-popper-content-wrapper") ? s.value = c.firstElementChild : s.value = c), c;
      }
    }) : null;
  }
});
var ki = defineComponent({
  inheritAttrs: false,
  __name: "CollapsibleContent",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Rl();
    e.contentId || (e.contentId = me(void 0, "radix-vue-collapsible-content"));
    const n = ref(), { forwardRef: l, currentElement: s } = R2(), r = ref(0), i = ref(0), u = computed(() => e.open.value), d = ref(u.value), p = ref();
    return watch(
      () => {
        var c;
        return [u.value, (c = n.value) == null ? void 0 : c.present];
      },
      async () => {
        await nextTick();
        const c = s.value;
        if (!c)
          return;
        p.value = p.value || {
          transitionDuration: c.style.transitionDuration,
          animationName: c.style.animationName
        }, c.style.transitionDuration = "0s", c.style.animationName = "none";
        const f = c.getBoundingClientRect();
        i.value = f.height, r.value = f.width, d.value || (c.style.transitionDuration = p.value.transitionDuration, c.style.animationName = p.value.animationName);
      },
      {
        immediate: true
      }
    ), onMounted(() => {
      requestAnimationFrame(() => {
        d.value = false;
      });
    }), (c, f) => (openBlock(), createBlock(unref(Pe), {
      ref_key: "presentRef",
      ref: n,
      present: c.forceMount || unref(e).open.value,
      "force-mount": true
    }, {
      default: withCtx(() => {
        var v2, g;
        return [
          createVNode(unref(A2), mergeProps(c.$attrs, {
            id: unref(e).contentId,
            ref: unref(l),
            "as-child": t.asChild,
            as: c.as,
            "data-state": unref(e).open.value ? "open" : "closed",
            "data-disabled": (v2 = unref(e).disabled) != null && v2.value ? "" : void 0,
            hidden: !((g = n.value) != null && g.present),
            style: {
              "--radix-collapsible-content-height": `${i.value}px`,
              "--radix-collapsible-content-width": `${r.value}px`
            }
          }), {
            default: withCtx(() => {
              var m2;
              return [
                (m2 = n.value) != null && m2.present ? renderSlot(c.$slots, "default", { key: 0 }) : createCommentVNode("", true)
              ];
            }),
            _: 3
          }, 16, ["id", "as-child", "as", "data-state", "data-disabled", "hidden", "style"])
        ];
      }),
      _: 3
    }, 8, ["present"]));
  }
});
function Al({ type: a2, defaultValue: t, modelValue: e }) {
  const n = e || t;
  if (Nt(a2) && Nt(e) && Nt(t))
    throw new Error("Either the `type` or the `value` or `default-value` prop must be defined.");
  if (e !== void 0 && t !== void 0 && typeof e != typeof t)
    throw new Error(
      `Invalid prop \`value\` of value \`${e}\` supplied, should be the same type as the \`defaultValue\` prop, which is \`${t}\`. The \`value\` prop must be:
  ${a2 === "single" ? "- a string" : a2 === "multiple" ? "- an array of strings" : `- a string
- an array of strings`}
  - \`undefined\``
    );
  const l = e !== void 0 || t !== void 0;
  if (a2 && l) {
    const s = Array.isArray(e) || Array.isArray(t), r = e !== void 0 ? "modelValue" : "defaultValue", i = r === "modelValue" ? typeof e : typeof t;
    if (a2 === "single" && s)
      return console.error(`Invalid prop \`${r}\` of type ${i} supplied with type \`single\`. The \`modelValue\` prop must be a string or \`undefined\`.
    You can remove the \`type\` prop to let the component infer the type from the ${r} prop.`), "multiple";
    if (a2 === "multiple" && !s)
      return console.error(`Invalid prop \`${r}\` of type ${i} supplied with type \`multiple\`. The \`modelValue\` prop must be an array of strings or \`undefined\`.
    You can remove the \`type\` prop to let the component infer the type from the ${r} prop.`), "single";
  }
  return l ? Array.isArray(n) ? "multiple" : "single" : a2;
}
function Mi({ type: a2, defaultValue: t, modelValue: e }) {
  return a2 || Al({ type: a2, defaultValue: t, modelValue: e });
}
function Vi({ type: a2, defaultValue: t }) {
  return t !== void 0 ? t : a2 === "single" ? void 0 : [];
}
function Ol(a2, t) {
  const e = ref(Mi(a2)), n = ae(a2, "modelValue", t, {
    defaultValue: Vi(a2),
    passive: a2.modelValue === void 0,
    deep: true
  });
  watch(
    () => [a2.type, a2.modelValue, a2.defaultValue],
    () => {
      const r = Al(a2);
      e.value !== r && (e.value = r);
    },
    { immediate: true }
  );
  function l(r) {
    if (e.value === "single")
      n.value = r === n.value ? void 0 : r;
    else {
      const i = [...n.value || []];
      if (i.includes(r)) {
        const u = i.findIndex((d) => d === r);
        i.splice(u, 1);
      } else
        i.push(r);
      n.value = i;
    }
  }
  const s = computed(() => e.value === "single");
  return {
    modelValue: n,
    type: e,
    changeModelValue: l,
    isSingle: s
  };
}
var [Ua, Fi] = Q("AccordionRoot");
var rv = defineComponent({
  __name: "AccordionRoot",
  props: {
    collapsible: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    dir: {},
    orientation: { default: "vertical" },
    asChild: { type: Boolean },
    as: {},
    type: {},
    modelValue: {},
    defaultValue: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { dir: l, disabled: s } = toRefs(e), r = Ce(l), { modelValue: i, changeModelValue: u, isSingle: d } = Ol(e, n), { forwardRef: p, currentElement: c } = R2();
    return Fi({
      disabled: s,
      direction: r,
      orientation: e.orientation,
      parentElement: c,
      isSingle: d,
      collapsible: e.collapsible,
      modelValue: i,
      changeModelValue: u
    }), (f, v2) => (openBlock(), createBlock(unref(A2), {
      ref: unref(p),
      "as-child": f.asChild,
      as: f.as
    }, {
      default: withCtx(() => [
        renderSlot(f.$slots, "default", { modelValue: unref(i) })
      ]),
      _: 3
    }, 8, ["as-child", "as"]));
  }
});
var [Yn, Li] = Q("AccordionItem");
var iv = defineComponent({
  __name: "AccordionItem",
  props: {
    disabled: { type: Boolean },
    value: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2, { expose: t }) {
    const e = a2, n = Ua(), l = computed(
      () => n.isSingle.value ? e.value === n.modelValue.value : Array.isArray(n.modelValue.value) && n.modelValue.value.includes(e.value)
    ), s = computed(() => n.disabled.value || e.disabled || n.isSingle.value && l.value && !n.collapsible), r = computed(() => s.value ? "" : void 0), i = computed(
      () => l.value ? "open" : "closed"
      /* Closed */
    );
    t({ open: l, dataDisabled: r });
    const { currentRef: u, currentElement: d } = R2();
    Li({
      open: l,
      dataState: i,
      disabled: s,
      dataDisabled: r,
      triggerId: "",
      currentRef: u,
      currentElement: d,
      value: computed(() => e.value)
    });
    function p(c) {
      $t(
        c,
        d.value,
        n.parentElement.value,
        {
          arrowKeyOptions: n.orientation,
          dir: n.direction.value,
          focus: true
        }
      );
    }
    return (c, f) => (openBlock(), createBlock(unref(Ri), {
      "data-orientation": unref(n).orientation,
      "data-disabled": r.value,
      "data-state": i.value,
      disabled: s.value,
      open: l.value,
      as: e.as,
      "as-child": e.asChild,
      onKeydown: withKeys(p, ["up", "down", "left", "right", "home", "end"])
    }, {
      default: withCtx(() => [
        renderSlot(c.$slots, "default", { open: l.value })
      ]),
      _: 3
    }, 8, ["data-orientation", "data-disabled", "data-state", "disabled", "open", "as", "as-child"]));
  }
});
var uv = defineComponent({
  __name: "AccordionContent",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Ua(), n = Yn();
    return R2(), (l, s) => (openBlock(), createBlock(unref(ki), {
      role: "region",
      hidden: !unref(n).open.value,
      "as-child": t.asChild,
      "aria-labelledby": unref(n).triggerId,
      "data-state": unref(n).dataState.value,
      "data-disabled": unref(n).dataDisabled.value,
      "data-orientation": unref(e).orientation,
      style: { "--radix-accordion-content-width": "var(--radix-collapsible-content-width)", "--radix-accordion-content-height": "var(--radix-collapsible-content-height)" }
    }, {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 8, ["hidden", "as-child", "aria-labelledby", "data-state", "data-disabled", "data-orientation"]));
  }
});
var dv = defineComponent({
  __name: "AccordionHeader",
  props: {
    asChild: { type: Boolean },
    as: { default: "h3" }
  },
  setup(a2) {
    const t = a2, e = Ua(), n = Yn();
    return R2(), (l, s) => (openBlock(), createBlock(unref(A2), {
      as: t.as,
      "as-child": t.asChild,
      "data-orientation": unref(e).orientation,
      "data-state": unref(n).dataState.value,
      "data-disabled": unref(n).dataDisabled.value
    }, {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "as-child", "data-orientation", "data-state", "data-disabled"]));
  }
});
var cv = defineComponent({
  __name: "AccordionTrigger",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Ua(), n = Yn();
    n.triggerId || (n.triggerId = me(void 0, "radix-vue-accordion-trigger"));
    function l() {
      n.disabled.value || e.changeModelValue(n.value.value);
    }
    return (s, r) => (openBlock(), createBlock(unref(Ai), {
      id: unref(n).triggerId,
      ref: unref(n).currentRef,
      "data-radix-vue-collection-item": "",
      as: t.as,
      "as-child": t.asChild,
      "aria-disabled": unref(n).disabled.value || void 0,
      "aria-expanded": unref(n).open.value || false,
      "data-disabled": unref(n).dataDisabled.value,
      "data-orientation": unref(e).orientation,
      "data-state": unref(n).dataState.value,
      disabled: unref(n).disabled.value,
      onClick: l
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 8, ["id", "as", "as-child", "aria-disabled", "aria-expanded", "data-disabled", "data-orientation", "data-state", "disabled"]));
  }
});
var [tt, Ni] = Q("DialogRoot");
var zi = defineComponent({
  __name: "DialogRoot",
  props: {
    open: { type: Boolean, default: void 0 },
    defaultOpen: { type: Boolean, default: false },
    modal: { type: Boolean, default: true }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "open", t, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    }), s = ref(), r = ref(), { modal: i } = toRefs(e);
    return Ni({
      open: l,
      modal: i,
      openModal: () => {
        l.value = true;
      },
      onOpenChange: (u) => {
        l.value = u;
      },
      onOpenToggle: () => {
        l.value = !l.value;
      },
      contentId: "",
      titleId: "",
      descriptionId: "",
      triggerElement: s,
      contentElement: r
    }), (u, d) => renderSlot(u.$slots, "default", { open: unref(l) });
  }
});
var Ki = defineComponent({
  __name: "DialogTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = tt(), { forwardRef: n, currentElement: l } = R2();
    return e.contentId || (e.contentId = me(void 0, "radix-vue-dialog-content")), onMounted(() => {
      e.triggerElement.value = l.value;
    }), (s, r) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      ref: unref(n),
      type: s.as === "button" ? "button" : void 0,
      "aria-haspopup": "dialog",
      "aria-expanded": unref(e).open.value || false,
      "aria-controls": unref(e).open.value ? unref(e).contentId : void 0,
      "data-state": unref(e).open.value ? "open" : "closed",
      onClick: unref(e).onOpenToggle
    }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16, ["type", "aria-expanded", "aria-controls", "data-state", "onClick"]));
  }
});
var ht = defineComponent({
  __name: "Teleport",
  props: {
    to: { default: "body" },
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = Ha();
    return (e, n) => unref(t) || e.forceMount ? (openBlock(), createBlock(Teleport, {
      key: 0,
      to: e.to,
      disabled: e.disabled
    }, [
      renderSlot(e.$slots, "default")
    ], 8, ["to", "disabled"])) : createCommentVNode("", true);
  }
});
var pv = defineComponent({
  __name: "DialogPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Hi = "dismissableLayer.pointerDownOutside";
var Wi = "dismissableLayer.focusOutside";
function kl(a2, t) {
  const e = t.closest(
    "[data-dismissable-layer]"
  ), n = a2.dataset.dismissableLayer === "" ? a2 : a2.querySelector(
    "[data-dismissable-layer]"
  ), l = Array.from(
    a2.ownerDocument.querySelectorAll("[data-dismissable-layer]")
  );
  return !!(e && n === e || l.indexOf(n) < l.indexOf(e));
}
function Ml(a2, t) {
  var s;
  const e = ((s = t == null ? void 0 : t.value) == null ? void 0 : s.ownerDocument) ?? (globalThis == null ? void 0 : globalThis.document), n = ref(false), l = ref(() => {
  });
  return watchEffect((r) => {
    if (!Je)
      return;
    const i = async (d) => {
      const p = d.target;
      if (t != null && t.value) {
        if (kl(t.value, p)) {
          n.value = false;
          return;
        }
        if (d.target && !n.value) {
          let c = function() {
            zt(
              Hi,
              a2,
              f
            );
          };
          const f = { originalEvent: d };
          d.pointerType === "touch" ? (e.removeEventListener("click", l.value), l.value = c, e.addEventListener("click", l.value, {
            once: true
          })) : c();
        } else
          e.removeEventListener("click", l.value);
        n.value = false;
      }
    }, u = window.setTimeout(() => {
      e.addEventListener("pointerdown", i);
    }, 0);
    r(() => {
      window.clearTimeout(u), e.removeEventListener("pointerdown", i), e.removeEventListener("click", l.value);
    });
  }), {
    onPointerDownCapture: () => n.value = true
  };
}
function Vl(a2, t) {
  var l;
  const e = ((l = t == null ? void 0 : t.value) == null ? void 0 : l.ownerDocument) ?? (globalThis == null ? void 0 : globalThis.document), n = ref(false);
  return watchEffect((s) => {
    if (!Je)
      return;
    const r = async (i) => {
      t != null && t.value && (await nextTick(), !(!t.value || kl(t.value, i.target)) && i.target && !n.value && zt(
        Wi,
        a2,
        { originalEvent: i }
      ));
    };
    e.addEventListener("focusin", r), s(() => e.removeEventListener("focusin", r));
  }), {
    onFocusCapture: () => n.value = true,
    onBlurCapture: () => n.value = false
  };
}
var We = reactive({
  layersRoot: /* @__PURE__ */ new Set(),
  layersWithOutsidePointerEventsDisabled: /* @__PURE__ */ new Set(),
  branches: /* @__PURE__ */ new Set()
});
var yt = defineComponent({
  __name: "DismissableLayer",
  props: {
    disableOutsidePointerEvents: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "dismiss"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l, currentElement: s } = R2(), r = computed(
      () => {
        var g;
        return ((g = s.value) == null ? void 0 : g.ownerDocument) ?? globalThis.document;
      }
    ), i = computed(() => We.layersRoot), u = computed(() => s.value ? Array.from(i.value).indexOf(s.value) : -1), d = computed(() => We.layersWithOutsidePointerEventsDisabled.size > 0), p = computed(() => {
      const g = Array.from(i.value), [m2] = [...We.layersWithOutsidePointerEventsDisabled].slice(-1), S = g.indexOf(m2);
      return u.value >= S;
    }), c = Ml(async (g) => {
      const m2 = [...We.branches].some(
        (S) => S.contains(g.target)
      );
      !p.value || m2 || (n("pointerDownOutside", g), n("interactOutside", g), await nextTick(), g.defaultPrevented || n("dismiss"));
    }, s), f = Vl((g) => {
      [...We.branches].some(
        (S) => S.contains(g.target)
      ) || (n("focusOutside", g), n("interactOutside", g), g.defaultPrevented || n("dismiss"));
    }, s);
    Hn("Escape", (g) => {
      u.value === i.value.size - 1 && (n("escapeKeyDown", g), g.defaultPrevented || n("dismiss"));
    });
    let v2;
    return watchEffect((g) => {
      s.value && (e.disableOutsidePointerEvents && (We.layersWithOutsidePointerEventsDisabled.size === 0 && (v2 = r.value.body.style.pointerEvents, r.value.body.style.pointerEvents = "none"), We.layersWithOutsidePointerEventsDisabled.add(s.value)), i.value.add(s.value), g(() => {
        e.disableOutsidePointerEvents && We.layersWithOutsidePointerEventsDisabled.size === 1 && (r.value.body.style.pointerEvents = v2);
      }));
    }), watchEffect((g) => {
      g(() => {
        s.value && (i.value.delete(s.value), We.layersWithOutsidePointerEventsDisabled.delete(s.value));
      });
    }), (g, m2) => (openBlock(), createBlock(unref(A2), {
      ref: unref(l),
      "as-child": g.asChild,
      as: g.as,
      "data-dismissable-layer": "",
      style: normalizeStyle({
        pointerEvents: d.value ? p.value ? "auto" : "none" : void 0
      }),
      onFocusCapture: unref(f).onFocusCapture,
      onBlurCapture: unref(f).onBlurCapture,
      onPointerdownCapture: unref(c).onPointerDownCapture
    }, {
      default: withCtx(() => [
        renderSlot(g.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as", "style", "onFocusCapture", "onBlurCapture", "onPointerdownCapture"]));
  }
});
var ji = defineComponent({
  __name: "DismissableLayerBranch",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e, currentElement: n } = R2();
    return onMounted(() => {
      We.branches.add(n.value);
    }), onUnmounted(() => {
      We.branches.delete(n.value);
    }), (l, s) => (openBlock(), createBlock(unref(A2), mergeProps({ ref: unref(e) }, t), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var bn = "focusScope.autoFocusOnMount";
var Cn = "focusScope.autoFocusOnUnmount";
var zo = { bubbles: false, cancelable: true };
function Aa(a2, { select: t = false } = {}) {
  const e = document.activeElement;
  for (const n of a2)
    if (dt(n, { select: t }), document.activeElement !== e)
      return true;
}
function Ui(a2) {
  const t = Xn(a2), e = Ko(t, a2), n = Ko(t.reverse(), a2);
  return [e, n];
}
function Xn(a2) {
  const t = [], e = document.createTreeWalker(a2, NodeFilter.SHOW_ELEMENT, {
    acceptNode: (n) => {
      const l = n.tagName === "INPUT" && n.type === "hidden";
      return n.disabled || n.hidden || l ? NodeFilter.FILTER_SKIP : n.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }
  });
  for (; e.nextNode(); ) t.push(e.currentNode);
  return t;
}
function Ko(a2, t) {
  for (const e of a2)
    if (!Gi(e, { upTo: t }))
      return e;
}
function Gi(a2, { upTo: t }) {
  if (getComputedStyle(a2).visibility === "hidden")
    return true;
  for (; a2; ) {
    if (t !== void 0 && a2 === t)
      return false;
    if (getComputedStyle(a2).display === "none")
      return true;
    a2 = a2.parentElement;
  }
  return false;
}
function qi(a2) {
  return a2 instanceof HTMLInputElement && "select" in a2;
}
function dt(a2, { select: t = false } = {}) {
  if (a2 && a2.focus) {
    const e = document.activeElement;
    a2.focus({ preventScroll: true }), a2 !== e && qi(a2) && t && a2.select();
  }
}
var Yi = Wr(() => ref([]));
function Xi() {
  const a2 = Yi();
  return {
    add(t) {
      const e = a2.value[0];
      t !== e && (e == null || e.pause()), a2.value = Ho(a2.value, t), a2.value.unshift(t);
    },
    remove(t) {
      var e;
      a2.value = Ho(a2.value, t), (e = a2.value[0]) == null || e.resume();
    }
  };
}
function Ho(a2, t) {
  const e = [...a2], n = e.indexOf(t);
  return n !== -1 && e.splice(n, 1), e;
}
function Zi(a2) {
  return a2.filter((t) => t.tagName !== "A");
}
var Ga = defineComponent({
  __name: "FocusScope",
  props: {
    loop: { type: Boolean, default: false },
    trapped: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["mountAutoFocus", "unmountAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { currentRef: l, currentElement: s } = R2(), r = ref(null), i = Xi(), u = reactive({
      paused: false,
      pause() {
        this.paused = true;
      },
      resume() {
        this.paused = false;
      }
    });
    watchEffect((p) => {
      if (!Je)
        return;
      const c = s.value;
      if (!e.trapped)
        return;
      function f(S) {
        if (u.paused || !c)
          return;
        const x = S.target;
        c.contains(x) ? r.value = x : dt(r.value, { select: true });
      }
      function v2(S) {
        if (u.paused || !c)
          return;
        const x = S.relatedTarget;
        x !== null && (c.contains(x) || dt(r.value, { select: true }));
      }
      function g(S) {
        c.contains(r.value) || dt(c);
      }
      document.addEventListener("focusin", f), document.addEventListener("focusout", v2);
      const m2 = new MutationObserver(g);
      c && m2.observe(c, { childList: true, subtree: true }), p(() => {
        document.removeEventListener("focusin", f), document.removeEventListener("focusout", v2), m2.disconnect();
      });
    }), watchEffect(async (p) => {
      const c = s.value;
      if (await nextTick(), !c)
        return;
      i.add(u);
      const f = document.activeElement;
      if (!c.contains(f)) {
        const g = new CustomEvent(bn, zo);
        c.addEventListener(bn, (m2) => n("mountAutoFocus", m2)), c.dispatchEvent(g), g.defaultPrevented || (Aa(Zi(Xn(c)), {
          select: true
        }), document.activeElement === f && dt(c));
      }
      p(() => {
        c.removeEventListener(bn, (S) => n("mountAutoFocus", S));
        const g = new CustomEvent(Cn, zo), m2 = (S) => {
          n("unmountAutoFocus", S);
        };
        c.addEventListener(Cn, m2), c.dispatchEvent(g), setTimeout(() => {
          g.defaultPrevented || dt(f ?? document.body, { select: true }), c.removeEventListener(Cn, m2), i.remove(u);
        }, 0);
      });
    });
    function d(p) {
      if (!e.loop && !e.trapped || u.paused)
        return;
      const c = p.key === "Tab" && !p.altKey && !p.ctrlKey && !p.metaKey, f = document.activeElement;
      if (c && f) {
        const v2 = p.currentTarget, [g, m2] = Ui(v2);
        g && m2 ? !p.shiftKey && f === m2 ? (p.preventDefault(), e.loop && dt(g, { select: true })) : p.shiftKey && f === g && (p.preventDefault(), e.loop && dt(m2, { select: true })) : f === v2 && p.preventDefault();
      }
    }
    return (p, c) => (openBlock(), createBlock(unref(A2), {
      ref_key: "currentRef",
      ref: l,
      tabindex: "-1",
      "as-child": p.asChild,
      as: p.as,
      onKeydown: d
    }, {
      default: withCtx(() => [
        renderSlot(p.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as"]));
  }
});
var Ji = "menu.itemSelect";
var En = ["Enter", " "];
var Qi = ["ArrowDown", "PageUp", "Home"];
var Fl = ["ArrowUp", "PageDown", "End"];
var eu = [...Qi, ...Fl];
var tu = {
  ltr: [...En, "ArrowRight"],
  rtl: [...En, "ArrowLeft"]
};
var au = {
  ltr: ["ArrowLeft"],
  rtl: ["ArrowRight"]
};
function Zn(a2) {
  return a2 ? "open" : "closed";
}
function Va(a2) {
  return a2 === "indeterminate";
}
function Jn(a2) {
  return Va(a2) ? "indeterminate" : a2 ? "checked" : "unchecked";
}
function Pn(a2) {
  const t = document.activeElement;
  for (const e of a2)
    if (e === t || (e.focus(), document.activeElement !== t))
      return;
}
function nu(a2, t) {
  const { x: e, y: n } = a2;
  let l = false;
  for (let s = 0, r = t.length - 1; s < t.length; r = s++) {
    const i = t[s].x, u = t[s].y, d = t[r].x, p = t[r].y;
    u > n != p > n && e < (d - i) * (n - u) / (p - u) + i && (l = !l);
  }
  return l;
}
function ou(a2, t) {
  if (!t)
    return false;
  const e = { x: a2.clientX, y: a2.clientY };
  return nu(e, t);
}
function ia(a2) {
  return a2.pointerType === "mouse";
}
var lu = "DialogTitle";
var su = "DialogContent";
function ru({
  titleName: a2 = lu,
  contentName: t = su,
  componentLink: e = "dialog.html#title",
  titleId: n,
  descriptionId: l,
  contentElement: s
}) {
  const r = `Warning: \`${t}\` requires a \`${a2}\` for the component to be accessible for screen reader users.

If you want to hide the \`${a2}\`, you can wrap it with our VisuallyHidden component.

For more information, see https://www.radix-vue.com/components/${e}`, i = `Warning: Missing \`Description\` or \`aria-describedby="undefined"\` for ${t}.`;
  onMounted(() => {
    var p;
    document.getElementById(n) || console.warn(r);
    const d = (p = s.value) == null ? void 0 : p.getAttribute("aria-describedby");
    l && !d && (document.getElementById(l) || console.warn(i));
  });
}
var Ll = defineComponent({
  __name: "DialogContentImpl",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = tt(), { forwardRef: s, currentElement: r } = R2();
    return l.titleId || (l.titleId = me(void 0, "radix-vue-dialog-title")), l.descriptionId || (l.descriptionId = me(void 0, "radix-vue-dialog-description")), onMounted(() => {
      l.contentElement = r, document.activeElement !== document.body && (l.triggerElement.value = document.activeElement);
    }), ru({
      titleName: "DialogTitle",
      contentName: "DialogContent",
      componentLink: "dialog.html#title",
      titleId: l.titleId,
      descriptionId: l.descriptionId,
      contentElement: l.contentElement
    }), (i, u) => (openBlock(), createBlock(unref(Ga), {
      "as-child": "",
      loop: "",
      trapped: e.trapFocus,
      onMountAutoFocus: u[5] || (u[5] = (d) => n("openAutoFocus", d)),
      onUnmountAutoFocus: u[6] || (u[6] = (d) => n("closeAutoFocus", d))
    }, {
      default: withCtx(() => [
        createVNode(unref(yt), mergeProps({
          id: unref(l).contentId,
          ref: unref(s),
          as: i.as,
          "as-child": i.asChild,
          "disable-outside-pointer-events": i.disableOutsidePointerEvents,
          role: "dialog",
          "aria-describedby": unref(l).descriptionId,
          "aria-labelledby": unref(l).titleId,
          "data-state": unref(Zn)(unref(l).open.value)
        }, i.$attrs, {
          onDismiss: u[0] || (u[0] = (d) => unref(l).onOpenChange(false)),
          onEscapeKeyDown: u[1] || (u[1] = (d) => n("escapeKeyDown", d)),
          onFocusOutside: u[2] || (u[2] = (d) => n("focusOutside", d)),
          onInteractOutside: u[3] || (u[3] = (d) => n("interactOutside", d)),
          onPointerDownOutside: u[4] || (u[4] = (d) => n("pointerDownOutside", d))
        }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16, ["id", "as", "as-child", "disable-outside-pointer-events", "aria-describedby", "aria-labelledby", "data-state"])
      ]),
      _: 3
    }, 8, ["trapped"]));
  }
});
var iu = defineComponent({
  __name: "DialogContentModal",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = tt(), s = Te(n), { forwardRef: r, currentElement: i } = R2();
    return ha(i), (u, d) => (openBlock(), createBlock(Ll, mergeProps({ ...e, ...unref(s) }, {
      ref: unref(r),
      "trap-focus": unref(l).open.value,
      "disable-outside-pointer-events": true,
      onCloseAutoFocus: d[0] || (d[0] = (p) => {
        var c;
        p.defaultPrevented || (p.preventDefault(), (c = unref(l).triggerElement.value) == null || c.focus());
      }),
      onPointerDownOutside: d[1] || (d[1] = (p) => {
        const c = p.detail.originalEvent, f = c.button === 0 && c.ctrlKey === true;
        (c.button === 2 || f) && p.preventDefault();
      }),
      onFocusOutside: d[2] || (d[2] = (p) => {
        p.preventDefault();
      })
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16, ["trap-focus"]));
  }
});
var uu = defineComponent({
  __name: "DialogContentNonModal",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    R2();
    const s = tt(), r = ref(false), i = ref(false);
    return (u, d) => (openBlock(), createBlock(Ll, mergeProps({ ...e, ...unref(l) }, {
      "trap-focus": false,
      "disable-outside-pointer-events": false,
      onCloseAutoFocus: d[0] || (d[0] = (p) => {
        var c;
        p.defaultPrevented || (r.value || (c = unref(s).triggerElement.value) == null || c.focus(), p.preventDefault()), r.value = false, i.value = false;
      }),
      onInteractOutside: d[1] || (d[1] = (p) => {
        var v2;
        p.defaultPrevented || (r.value = true, p.detail.originalEvent.type === "pointerdown" && (i.value = true));
        const c = p.target;
        ((v2 = unref(s).triggerElement.value) == null ? void 0 : v2.contains(c)) && p.preventDefault(), p.detail.originalEvent.type === "focusin" && i.value && p.preventDefault();
      })
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var du = defineComponent({
  __name: "DialogContent",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = tt(), s = Te(n), { forwardRef: r } = R2();
    return (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(l).open.value
    }, {
      default: withCtx(() => [
        unref(l).modal.value ? (openBlock(), createBlock(iu, mergeProps({
          key: 0,
          ref: unref(r)
        }, { ...e, ...unref(s), ...i.$attrs }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16)) : (openBlock(), createBlock(uu, mergeProps({
          key: 1,
          ref: unref(r)
        }, { ...e, ...unref(s), ...i.$attrs }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16))
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var cu = defineComponent({
  __name: "DialogOverlayImpl",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = tt();
    return ma(true), R2(), (e, n) => (openBlock(), createBlock(unref(A2), {
      as: e.as,
      "as-child": e.asChild,
      "data-state": unref(t).open.value ? "open" : "closed",
      style: { "pointer-events": "auto" }
    }, {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "as-child", "data-state"]));
  }
});
var pu = defineComponent({
  __name: "DialogOverlay",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = tt(), { forwardRef: e } = R2();
    return (n, l) => {
      var s;
      return (s = unref(t)) != null && s.modal.value ? (openBlock(), createBlock(unref(Pe), {
        key: 0,
        present: n.forceMount || unref(t).open.value
      }, {
        default: withCtx(() => [
          createVNode(cu, mergeProps(n.$attrs, {
            ref: unref(e),
            as: n.as,
            "as-child": n.asChild
          }), {
            default: withCtx(() => [
              renderSlot(n.$slots, "default")
            ]),
            _: 3
          }, 16, ["as", "as-child"])
        ]),
        _: 3
      }, 8, ["present"])) : createCommentVNode("", true);
    };
  }
});
var Nl = defineComponent({
  __name: "DialogClose",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = tt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      type: n.as === "button" ? "button" : void 0,
      onClick: l[0] || (l[0] = (s) => unref(e).onOpenChange(false))
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["type"]));
  }
});
var fu = defineComponent({
  __name: "DialogTitle",
  props: {
    asChild: { type: Boolean },
    as: { default: "h2" }
  },
  setup(a2) {
    const t = a2, e = tt();
    return R2(), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).titleId
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var vu = defineComponent({
  __name: "DialogDescription",
  props: {
    asChild: { type: Boolean },
    as: { default: "p" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = tt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).descriptionId
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var fv = defineComponent({
  __name: "AlertDialogRoot",
  props: {
    open: { type: Boolean },
    defaultOpen: { type: Boolean }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(zi), mergeProps(unref(l), { modal: true }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var vv = defineComponent({
  __name: "AlertDialogTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(Ki), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var mv = defineComponent({
  __name: "AlertDialogPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [mu, hu] = Q("AlertDialogContent");
var hv = defineComponent({
  __name: "AlertDialogContent",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    R2();
    const s = ref();
    return hu({
      onCancelElementChange: (r) => {
        s.value = r;
      }
    }), (r, i) => (openBlock(), createBlock(unref(du), mergeProps({ ...e, ...unref(l) }, {
      role: "alertdialog",
      onPointerDownOutside: i[0] || (i[0] = withModifiers(() => {
      }, ["prevent"])),
      onInteractOutside: i[1] || (i[1] = withModifiers(() => {
      }, ["prevent"])),
      onOpenAutoFocus: i[2] || (i[2] = () => {
        nextTick(() => {
          var u;
          (u = s.value) == null || u.focus({
            preventScroll: true
          });
        });
      })
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var yv = defineComponent({
  __name: "AlertDialogOverlay",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(pu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var gv = defineComponent({
  __name: "AlertDialogCancel",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = mu(), { forwardRef: n, currentElement: l } = R2();
    return onMounted(() => {
      e.onCancelElementChange(l.value);
    }), (s, r) => (openBlock(), createBlock(unref(Nl), mergeProps(t, { ref: unref(n) }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var bv = defineComponent({
  __name: "AlertDialogTitle",
  props: {
    asChild: { type: Boolean },
    as: { default: "h2" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(fu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Cv = defineComponent({
  __name: "AlertDialogDescription",
  props: {
    asChild: { type: Boolean },
    as: { default: "p" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(vu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var wv = defineComponent({
  __name: "AlertDialogAction",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(Nl), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var _v = defineComponent({
  inheritAttrs: false,
  __name: "AspectRatio",
  props: {
    ratio: { default: 1 },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), n = computed(() => 1 / t.ratio * 100);
    return (l, s) => (openBlock(), createElementBlock("div", {
      style: normalizeStyle(`position: relative; width: 100%; padding-bottom: ${n.value}%`),
      "data-radix-aspect-ratio-wrapper": ""
    }, [
      createVNode(unref(A2), mergeProps({
        ref: unref(e),
        "as-child": l.asChild,
        as: l.as,
        style: { position: "absolute", inset: "0px" }
      }, l.$attrs), {
        default: withCtx(() => [
          renderSlot(l.$slots, "default", { aspect: n.value })
        ]),
        _: 3
      }, 16, ["as-child", "as"])
    ], 4));
  }
});
var [zl, yu] = Q("AvatarRoot");
var xv = defineComponent({
  __name: "AvatarRoot",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    return R2(), yu({
      imageLoadingStatus: ref("loading")
    }), (t, e) => (openBlock(), createBlock(unref(A2), {
      "as-child": t.asChild,
      as: t.as
    }, {
      default: withCtx(() => [
        renderSlot(t.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as"]));
  }
});
function gu(a2) {
  const t = ref("idle"), e = ref(false), n = (l) => () => {
    e.value && (t.value = l);
  };
  return onMounted(() => {
    e.value = true, watch(a2, (l) => {
      if (!l)
        t.value = "error";
      else {
        const s = new window.Image();
        t.value = "loading", s.onload = n("loaded"), s.onerror = n("error"), s.src = l;
      }
    }, { immediate: true });
  }), onUnmounted(() => {
    e.value = false;
  }), t;
}
var Sv = defineComponent({
  __name: "AvatarImage",
  props: {
    src: {},
    asChild: { type: Boolean },
    as: { default: "img" }
  },
  emits: ["loadingStatusChange"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { src: l } = toRefs(e);
    R2();
    const s = zl(), r = gu(l);
    return watch(
      r,
      (i) => {
        n("loadingStatusChange", i), i !== "idle" && (s.imageLoadingStatus.value = i);
      },
      { immediate: true }
    ), (i, u) => withDirectives((openBlock(), createBlock(unref(A2), {
      role: "img",
      "as-child": i.asChild,
      as: i.as,
      src: unref(l)
    }, {
      default: withCtx(() => [
        renderSlot(i.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as", "src"])), [
      [vShow, unref(r) === "loaded"]
    ]);
  }
});
var Ev = defineComponent({
  __name: "AvatarFallback",
  props: {
    delayMs: { default: 0 },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, e = zl();
    R2();
    const n = ref(false);
    let l;
    return watch(e.imageLoadingStatus, (s) => {
      s === "loading" && (n.value = false, t.delayMs ? l = setTimeout(() => {
        n.value = true, clearTimeout(l);
      }, t.delayMs) : n.value = true);
    }, { immediate: true }), (s, r) => n.value && unref(e).imageLoadingStatus.value !== "loaded" ? (openBlock(), createBlock(unref(A2), {
      key: 0,
      "as-child": s.asChild,
      as: s.as
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as"])) : createCommentVNode("", true);
  }
});
function bu(a2) {
  function t(n) {
    return Array.isArray(a2.date.value) ? a2.date.value.some((l) => $14e0f24ef4ac5c92$export$ea39ec197993aef0(l, n)) : a2.date.value ? $14e0f24ef4ac5c92$export$ea39ec197993aef0(a2.date.value, n) : false;
  }
  const e = computed(
    () => {
      var n, l, s, r;
      if (Array.isArray(a2.date.value)) {
        if (!a2.date.value.length)
          return false;
        for (const i of a2.date.value)
          if ((n = a2.isDateDisabled) != null && n.call(a2, i) || (l = a2.isDateUnavailable) != null && l.call(a2, i))
            return true;
      } else {
        if (!a2.date.value)
          return false;
        if ((s = a2.isDateDisabled) != null && s.call(a2, a2.date.value) || (r = a2.isDateUnavailable) != null && r.call(a2, a2.date.value))
          return true;
      }
      return false;
    }
  );
  return {
    isDateSelected: t,
    isInvalid: e
  };
}
function Cu(a2, t) {
  const e = t(a2), n = e.compare(a2), l = {};
  return n >= 7 && (l.day = 1), n >= R(a2) && (l.month = 1), e.set({ ...l });
}
function wu(a2, t) {
  const e = t(a2), n = a2.compare(e), l = {};
  return n >= 7 && (l.day = 35), n >= R(a2) && (l.month = 13), e.set({ ...l });
}
function _u(a2, t) {
  return t(a2);
}
function xu(a2, t) {
  return t(a2);
}
function Kl(a2) {
  const t = Wn(a2.locale.value), e = computed(() => {
    const m2 = {
      calendar: a2.placeholder.value.calendar.identifier
    };
    return a2.placeholder.value.calendar.identifier === "gregory" && a2.placeholder.value.era === "BC" && (m2.era = "short"), m2;
  }), n = ref(rt({
    dateObj: a2.placeholder.value,
    weekStartsOn: a2.weekStartsOn.value,
    locale: a2.locale.value,
    fixedWeeks: a2.fixedWeeks.value,
    numberOfMonths: a2.numberOfMonths.value
  })), l = computed(() => n.value.map((m2) => m2.value));
  function s(m2) {
    return !l.value.some((S) => $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(m2, S));
  }
  const r = (m2 = "month", S) => {
    if (!a2.maxValue.value || !n.value.length)
      return false;
    if (a2.disabled.value)
      return true;
    const x = n.value[n.value.length - 1].value;
    if (S || a2.nextPage.value) {
      const h2 = Cu(x, S || a2.nextPage.value);
      return P(h2, a2.maxValue.value);
    }
    if (m2 === "year") {
      const h2 = x.add({ years: 1 }).set({ day: 1, month: 1 });
      return P(h2, a2.maxValue.value);
    }
    const D = x.add({ months: 1 }).set({ day: 1 });
    return P(D, a2.maxValue.value);
  }, i = (m2 = "month", S) => {
    if (!a2.minValue.value || !n.value.length)
      return false;
    if (a2.disabled.value)
      return true;
    const x = n.value[0].value;
    if (S || a2.prevPage.value) {
      const h2 = wu(x, S || a2.prevPage.value);
      return q(h2, a2.minValue.value);
    }
    if (m2 === "year") {
      const h2 = x.subtract({ years: 1 }).set({ day: 35, month: 13 });
      return q(h2, a2.minValue.value);
    }
    const D = x.subtract({ months: 1 }).set({ day: 35 });
    return q(D, a2.minValue.value);
  };
  function u(m2) {
    var S;
    return !!((S = a2.isDateDisabled) != null && S.call(a2, m2) || a2.disabled.value || a2.maxValue.value && P(m2, a2.maxValue.value) || a2.minValue.value && q(m2, a2.minValue.value));
  }
  const d = (m2) => {
    var S;
    return !!((S = a2.isDateUnavailable) != null && S.call(a2, m2));
  }, p = computed(() => n.value.length ? n.value[0].rows[0].map((m2) => t.dayOfWeek($(m2), a2.weekdayFormat.value)) : []), c = (m2 = "month", S) => {
    const x = n.value[0].value;
    if (S || a2.nextPage.value) {
      const E = _u(x, S || a2.nextPage.value), P2 = rt({
        dateObj: E,
        weekStartsOn: a2.weekStartsOn.value,
        locale: a2.locale.value,
        fixedWeeks: a2.fixedWeeks.value,
        numberOfMonths: a2.numberOfMonths.value
      });
      n.value = P2;
      const $2 = {};
      if (!S) {
        const I = P2[0].value.compare(x);
        I >= R(x) && ($2.day = 1), I >= 365 && ($2.month = 1);
      }
      a2.placeholder.value = P2[0].value.set({ ...$2 });
      return;
    }
    const D = m2 === "month" ? x.add({ months: a2.pagedNavigation.value ? a2.numberOfMonths.value : 1 }) : x.add({ years: 1 }), h2 = rt({
      dateObj: D,
      weekStartsOn: a2.weekStartsOn.value,
      locale: a2.locale.value,
      fixedWeeks: a2.fixedWeeks.value,
      numberOfMonths: a2.numberOfMonths.value
    });
    n.value = h2, a2.placeholder.value = h2[0].value.set({ day: 1 });
  }, f = (m2 = "month", S) => {
    const x = n.value[0].value;
    if (S || a2.prevPage.value) {
      const E = xu(x, S || a2.prevPage.value), P2 = rt({
        dateObj: E,
        weekStartsOn: a2.weekStartsOn.value,
        locale: a2.locale.value,
        fixedWeeks: a2.fixedWeeks.value,
        numberOfMonths: a2.numberOfMonths.value
      });
      n.value = P2;
      const $2 = {};
      if (!S) {
        const I = x.compare(P2[0].value);
        I >= R(x) && ($2.day = 1), I >= 365 && ($2.month = 1);
      }
      a2.placeholder.value = P2[0].value.set({ ...$2 });
      return;
    }
    const D = m2 === "month" ? x.subtract({ months: a2.pagedNavigation.value ? a2.numberOfMonths.value : 1 }) : x.subtract({ years: 1 }), h2 = rt({
      dateObj: D,
      weekStartsOn: a2.weekStartsOn.value,
      locale: a2.locale.value,
      fixedWeeks: a2.fixedWeeks.value,
      numberOfMonths: a2.numberOfMonths.value
    });
    n.value = h2, a2.placeholder.value = h2[0].value.set({ day: 1 });
  };
  watch(a2.placeholder, (m2) => {
    l.value.some((S) => $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(S, m2)) || (n.value = rt({
      dateObj: m2,
      weekStartsOn: a2.weekStartsOn.value,
      locale: a2.locale.value,
      fixedWeeks: a2.fixedWeeks.value,
      numberOfMonths: a2.numberOfMonths.value
    }));
  }), watch([a2.locale, a2.weekStartsOn, a2.fixedWeeks, a2.numberOfMonths], () => {
    n.value = rt({
      dateObj: a2.placeholder.value,
      weekStartsOn: a2.weekStartsOn.value,
      locale: a2.locale.value,
      fixedWeeks: a2.fixedWeeks.value,
      numberOfMonths: a2.numberOfMonths.value
    });
  });
  const v2 = computed(() => {
    if (!n.value.length)
      return "";
    if (a2.locale.value !== t.getLocale() && t.setLocale(a2.locale.value), n.value.length === 1) {
      const $2 = n.value[0].value;
      return `${t.fullMonthAndYear($($2), e.value)}`;
    }
    const m2 = $(n.value[0].value), S = $(n.value[n.value.length - 1].value), x = t.fullMonth(m2, e.value), D = t.fullMonth(S, e.value), h2 = t.fullYear(m2, e.value), E = t.fullYear(S, e.value);
    return h2 === E ? `${x} - ${D} ${E}` : `${x} ${h2} - ${D} ${E}`;
  }), g = computed(() => `${a2.calendarLabel.value ?? "Event Date"}, ${v2.value}`);
  return {
    isDateDisabled: u,
    isDateUnavailable: d,
    isNextButtonDisabled: r,
    isPrevButtonDisabled: i,
    grid: n,
    weekdays: p,
    visibleView: l,
    isOutsideVisibleView: s,
    formatter: t,
    nextPage: c,
    prevPage: f,
    headingValue: v2,
    fullCalendarLabel: g
  };
}
var Su = { style: { border: "0px", clip: "rect(0px, 0px, 0px, 0px)", "clip-path": "inset(50%)", height: "1px", margin: "-1px", overflow: "hidden", padding: "0px", position: "absolute", "white-space": "nowrap", width: "1px" } };
var Eu = {
  role: "heading",
  "aria-level": "2"
};
var [Gt, Pu] = Q("CalendarRoot");
var Du = defineComponent({
  __name: "CalendarRoot",
  props: {
    modelValue: {},
    multiple: { type: Boolean, default: false },
    defaultValue: { default: void 0 },
    defaultPlaceholder: {},
    placeholder: { default: void 0 },
    pagedNavigation: { type: Boolean, default: false },
    preventDeselect: { type: Boolean, default: false },
    weekStartsOn: { default: 0 },
    weekdayFormat: { default: "narrow" },
    calendarLabel: {},
    fixedWeeks: { type: Boolean, default: false },
    maxValue: {},
    minValue: {},
    locale: { default: "en" },
    numberOfMonths: { default: 1 },
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    initialFocus: { type: Boolean, default: false },
    isDateDisabled: { type: Function, default: void 0 },
    isDateUnavailable: { type: Function, default: void 0 },
    dir: {},
    nextPage: {},
    prevPage: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  emits: ["update:modelValue", "update:placeholder"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, {
      locale: l,
      disabled: s,
      readonly: r,
      initialFocus: i,
      pagedNavigation: u,
      weekStartsOn: d,
      weekdayFormat: p,
      fixedWeeks: c,
      multiple: f,
      minValue: v2,
      maxValue: g,
      numberOfMonths: m2,
      preventDeselect: S,
      isDateDisabled: x,
      isDateUnavailable: D,
      calendarLabel: h2,
      defaultValue: E,
      nextPage: P2,
      prevPage: $2,
      dir: I
    } = toRefs(e), { primitiveElement: k, currentElement: L } = Re(), O = Ce(I), V2 = ae(e, "modelValue", n, {
      defaultValue: E.value,
      passive: e.modelValue === void 0
    }), H2 = jt({
      defaultPlaceholder: e.placeholder,
      defaultValue: V2.value
    }), Y = ae(e, "placeholder", n, {
      defaultValue: e.defaultPlaceholder ?? H2.copy(),
      passive: e.placeholder === void 0
    });
    function J2(ue) {
      Y.value = ue.copy();
    }
    const {
      fullCalendarLabel: N2,
      headingValue: F,
      isDateDisabled: W2,
      isDateUnavailable: z2,
      isNextButtonDisabled: Z,
      isPrevButtonDisabled: U,
      weekdays: X,
      isOutsideVisibleView: ee,
      nextPage: fe,
      prevPage: G2,
      formatter: oe,
      grid: he
    } = Kl({
      locale: l,
      placeholder: Y,
      weekStartsOn: d,
      fixedWeeks: c,
      numberOfMonths: m2,
      minValue: v2,
      maxValue: g,
      disabled: s,
      weekdayFormat: p,
      pagedNavigation: u,
      isDateDisabled: x.value,
      isDateUnavailable: D.value,
      calendarLabel: h2,
      nextPage: P2,
      prevPage: $2
    }), {
      isInvalid: we,
      isDateSelected: ge
    } = bu({
      date: V2,
      isDateDisabled: W2,
      isDateUnavailable: z2
    });
    watch(V2, (ue) => {
      if (Array.isArray(ue) && ue.length) {
        const Se = ue[ue.length - 1];
        Se && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(Y.value, Se) && J2(Se);
      } else !Array.isArray(ue) && ue && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(Y.value, ue) && J2(ue);
    });
    function De(ue) {
      if (f.value) {
        if (Array.isArray(V2.value)) {
          if (!V2.value) {
            V2.value = [ue.copy()];
            return;
          }
          if (V2.value.findIndex((Ve) => $14e0f24ef4ac5c92$export$ea39ec197993aef0(Ve, ue)) === -1)
            V2.value = [...V2.value, ue];
          else if (!S.value) {
            const Ve = V2.value.filter((Ke) => !$14e0f24ef4ac5c92$export$ea39ec197993aef0(Ke, ue));
            if (!Ve.length) {
              Y.value = ue.copy(), V2.value = void 0;
              return;
            }
            V2.value = Ve.map((Ke) => Ke.copy());
          }
        }
      } else {
        if (!V2.value) {
          V2.value = ue.copy();
          return;
        }
        !S.value && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(V2.value, ue) ? (Y.value = ue.copy(), V2.value = void 0) : V2.value = ue.copy();
      }
    }
    return onMounted(() => {
      i.value && gl(L.value);
    }), Pu({
      isDateUnavailable: z2,
      dir: O,
      isDateDisabled: W2,
      locale: l,
      formatter: oe,
      modelValue: V2,
      placeholder: Y,
      disabled: s,
      initialFocus: i,
      pagedNavigation: u,
      weekStartsOn: d,
      weekdayFormat: p,
      fixedWeeks: c,
      multiple: f,
      numberOfMonths: m2,
      readonly: r,
      preventDeselect: S,
      fullCalendarLabel: N2,
      headingValue: F,
      isInvalid: we,
      isDateSelected: ge,
      isNextButtonDisabled: Z,
      isPrevButtonDisabled: U,
      isOutsideVisibleView: ee,
      nextPage: fe,
      prevPage: G2,
      parentElement: L,
      onPlaceholderChange: J2,
      onDateChange: De
    }), (ue, Se) => (openBlock(), createBlock(unref(A2), {
      ref_key: "primitiveElement",
      ref: k,
      as: ue.as,
      "as-child": ue.asChild,
      role: "application",
      "aria-label": unref(N2),
      "data-readonly": unref(r) ? "" : void 0,
      "data-disabled": unref(s) ? "" : void 0,
      "data-invalid": unref(we) ? "" : void 0,
      dir: unref(O)
    }, {
      default: withCtx(() => [
        renderSlot(ue.$slots, "default", {
          date: unref(Y),
          grid: unref(he),
          weekDays: unref(X),
          weekStartsOn: unref(d),
          locale: unref(l),
          fixedWeeks: unref(c)
        }),
        createBaseVNode("div", Su, [
          createBaseVNode("div", Eu, toDisplayString(unref(N2)), 1)
        ])
      ]),
      _: 3
    }, 8, ["as", "as-child", "aria-label", "data-readonly", "data-disabled", "data-invalid", "dir"]));
  }
});
var $u = defineComponent({
  __name: "CalendarHeader",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Bu = defineComponent({
  __name: "CalendarHeading",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = Gt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "data-disabled": unref(e).disabled.value ? "" : void 0
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {
          headingValue: unref(e).headingValue.value
        }, () => [
          createTextVNode(toDisplayString(unref(e).headingValue.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["data-disabled"]));
  }
});
var Iu = defineComponent({
  __name: "CalendarGrid",
  props: {
    asChild: { type: Boolean },
    as: { default: "table" }
  },
  setup(a2) {
    const t = a2, e = Gt(), n = computed(() => e.disabled.value ? true : void 0), l = computed(() => e.readonly.value ? true : void 0);
    return (s, r) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      tabindex: "-1",
      role: "grid",
      "aria-readonly": l.value,
      "aria-disabled": n.value,
      "data-readonly": l.value && "",
      "data-disabled": n.value && ""
    }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-readonly", "aria-disabled", "data-readonly", "data-disabled"]));
  }
});
var Tu = defineComponent({
  __name: "CalendarCell",
  props: {
    date: {},
    asChild: { type: Boolean },
    as: { default: "td" }
  },
  setup(a2) {
    const t = Gt();
    return (e, n) => {
      var l, s;
      return openBlock(), createBlock(unref(A2), {
        as: e.as,
        "as-child": e.asChild,
        role: "gridcell",
        "aria-selected": unref(t).isDateSelected(e.date) ? true : void 0,
        "aria-disabled": unref(t).isDateDisabled(e.date) || ((s = (l = unref(t)).isDateUnavailable) == null ? void 0 : s.call(l, e.date)),
        "data-disabled": unref(t).isDateDisabled(e.date) ? "" : void 0
      }, {
        default: withCtx(() => [
          renderSlot(e.$slots, "default")
        ]),
        _: 3
      }, 8, ["as", "as-child", "aria-selected", "aria-disabled", "data-disabled"]);
    };
  }
});
var Ru = defineComponent({
  __name: "CalendarHeadCell",
  props: {
    asChild: { type: Boolean },
    as: { default: "th" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Au = defineComponent({
  __name: "CalendarNext",
  props: {
    step: { default: "month" },
    nextPage: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Gt();
    return (n, l) => (openBlock(), createBlock(unref(A2), {
      as: t.as,
      "as-child": t.asChild,
      "aria-label": "Next page",
      type: n.as === "button" ? "button" : void 0,
      "aria-disabled": unref(e).isNextButtonDisabled(t.step, t.nextPage) || void 0,
      "data-disabled": unref(e).isNextButtonDisabled(t.step, t.nextPage) || void 0,
      disabled: unref(e).isNextButtonDisabled(t.step, t.nextPage),
      onClick: l[0] || (l[0] = (s) => unref(e).nextPage(t.step, t.nextPage))
    }, {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Next page")
        ])
      ]),
      _: 3
    }, 8, ["as", "as-child", "type", "aria-disabled", "data-disabled", "disabled"]));
  }
});
var Ou = defineComponent({
  __name: "CalendarPrev",
  props: {
    step: { default: "month" },
    prevPage: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Gt();
    return (n, l) => (openBlock(), createBlock(unref(A2), {
      "aria-label": "Previous page",
      as: t.as,
      "as-child": t.asChild,
      type: n.as === "button" ? "button" : void 0,
      "aria-disabled": unref(e).isPrevButtonDisabled(t.step, t.prevPage) || void 0,
      "data-disabled": unref(e).isPrevButtonDisabled(t.step, t.prevPage) || void 0,
      disabled: unref(e).isPrevButtonDisabled(t.step, t.prevPage),
      onClick: l[0] || (l[0] = (s) => unref(e).prevPage(t.step, t.prevPage))
    }, {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Prev page")
        ])
      ]),
      _: 3
    }, 8, ["as", "as-child", "type", "aria-disabled", "data-disabled", "disabled"]));
  }
});
var ku = defineComponent({
  __name: "CalendarGridHead",
  props: {
    asChild: { type: Boolean },
    as: { default: "thead" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, { "aria-hidden": "true" }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Mu = defineComponent({
  __name: "CalendarGridBody",
  props: {
    asChild: { type: Boolean },
    as: { default: "tbody" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Vu = defineComponent({
  __name: "CalendarGridRow",
  props: {
    asChild: { type: Boolean },
    as: { default: "tr" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Fu = defineComponent({
  __name: "CalendarCellTrigger",
  props: {
    day: {},
    month: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = et(), n = Gt(), { primitiveElement: l, currentElement: s } = Re(), r = computed(() => t.day.day.toLocaleString(n.locale.value)), i = computed(() => n.formatter.custom($(t.day), {
      weekday: "long",
      month: "long",
      day: "numeric",
      year: "numeric"
    })), u = computed(() => n.isDateDisabled(t.day)), d = computed(
      () => {
        var h2;
        return (h2 = n.isDateUnavailable) == null ? void 0 : h2.call(n, t.day);
      }
    ), p = computed(() => $14e0f24ef4ac5c92$export$629b0a497aa65267(t.day, $14e0f24ef4ac5c92$export$aa8b41735afcabd2())), c = computed(() => !$14e0f24ef4ac5c92$export$a18c89cbd24170ff(t.day, t.month)), f = computed(
      () => n.isOutsideVisibleView(t.day)
    ), v2 = computed(() => $14e0f24ef4ac5c92$export$ea39ec197993aef0(t.day, n.placeholder.value)), g = computed(() => n.isDateSelected(t.day)), m2 = "[data-radix-vue-calendar-cell-trigger]:not([data-disabled]):not([data-outside-month]):not([data-outside-visible-months])";
    function S(h2) {
      var E;
      n.readonly.value || n.isDateDisabled(h2) || (E = n.isDateUnavailable) != null && E.call(n, h2) || n.onDateChange(h2);
    }
    function x() {
      S(t.day);
    }
    function D(h2) {
      h2.preventDefault(), h2.stopPropagation();
      const E = n.parentElement.value, P2 = E ? Array.from(E.querySelectorAll(m2)) : [];
      let I = P2.indexOf(s.value);
      const k = 7, L = n.dir.value === "rtl" ? -1 : 1;
      switch (h2.code) {
        case e.ARROW_RIGHT:
          I += L;
          break;
        case e.ARROW_LEFT:
          I -= L;
          break;
        case e.ARROW_UP:
          I -= k;
          break;
        case e.ARROW_DOWN:
          I += k;
          break;
        case e.ENTER:
        case e.SPACE_CODE:
          S(t.day);
          return;
        default:
          return;
      }
      if (I >= 0 && I < P2.length) {
        P2[I].focus();
        return;
      }
      if (I < 0) {
        if (n.isPrevButtonDisabled("month"))
          return;
        n.prevPage(), nextTick(() => {
          const O = E ? Array.from(E.querySelectorAll(m2)) : [];
          O[O.length - Math.abs(I)].focus();
        });
        return;
      }
      if (I >= P2.length) {
        if (n.isNextButtonDisabled("month"))
          return;
        n.nextPage(), nextTick(() => {
          (E ? Array.from(E.querySelectorAll(m2)) : [])[I - P2.length].focus();
        });
      }
    }
    return (h2, E) => (openBlock(), createBlock(unref(A2), mergeProps({
      ref_key: "primitiveElement",
      ref: l
    }, t, {
      role: "button",
      "aria-label": i.value,
      "data-radix-vue-calendar-cell-trigger": "",
      "aria-disabled": c.value || u.value || d.value ? true : void 0,
      "data-selected": g.value ? true : void 0,
      "data-value": h2.day.toString(),
      "data-disabled": u.value || c.value ? "" : void 0,
      "data-unavailable": d.value ? "" : void 0,
      "data-today": p.value ? "" : void 0,
      "data-outside-view": c.value ? "" : void 0,
      "data-outside-visible-view": f.value ? "" : void 0,
      "data-focused": v2.value ? "" : void 0,
      tabindex: v2.value ? 0 : c.value || u.value ? void 0 : -1,
      onClick: x,
      onKeydown: [
        withKeys(D, ["up", "down", "left", "right", "space", "enter"]),
        E[0] || (E[0] = withKeys(withModifiers(() => {
        }, ["prevent"]), ["enter"]))
      ]
    }), {
      default: withCtx(() => [
        renderSlot(h2.$slots, "default", { dayValue: r.value }, () => [
          createTextVNode(toDisplayString(r.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["aria-label", "aria-disabled", "data-selected", "data-value", "data-disabled", "data-unavailable", "data-today", "data-outside-view", "data-outside-visible-view", "data-focused", "tabindex"]));
  }
});
function Fa(a2) {
  return a2 === "indeterminate";
}
function Hl(a2) {
  return Fa(a2) ? "indeterminate" : a2 ? "checked" : "unchecked";
}
var Lu = ["value", "checked", "name", "disabled", "required"];
var [Nu, zu] = Q("CheckboxRoot");
var Pv = defineComponent({
  inheritAttrs: false,
  __name: "CheckboxRoot",
  props: {
    defaultChecked: { type: Boolean },
    checked: { type: [Boolean, String], default: void 0 },
    disabled: { type: Boolean },
    required: { type: Boolean },
    name: {},
    value: { default: "on" },
    id: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  emits: ["update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { disabled: l } = toRefs(e), s = ae(e, "checked", n, {
      defaultValue: e.defaultChecked,
      passive: e.checked === void 0
    }), { forwardRef: r, currentElement: i } = R2(), u = Qe(i), d = computed(() => {
      var p;
      return e.id && i.value ? (p = document.querySelector(`[for="${e.id}"]`)) == null ? void 0 : p.innerText : void 0;
    });
    return zu({
      disabled: l,
      state: s
    }), (p, c) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps(p.$attrs, {
        id: p.id,
        ref: unref(r),
        role: "checkbox",
        "as-child": e.asChild,
        as: p.as,
        type: p.as === "button" ? "button" : void 0,
        "aria-checked": unref(Fa)(unref(s)) ? "mixed" : unref(s),
        "aria-required": false,
        "aria-label": p.$attrs["aria-label"] || d.value,
        "data-state": unref(Hl)(unref(s)),
        "data-disabled": unref(l) ? "" : void 0,
        disabled: unref(l),
        onKeydown: withKeys(withModifiers(() => {
        }, ["prevent"]), ["enter"]),
        onClick: c[0] || (c[0] = (f) => s.value = unref(Fa)(unref(s)) ? true : !unref(s))
      }), {
        default: withCtx(() => [
          renderSlot(p.$slots, "default", { checked: unref(s) })
        ]),
        _: 3
      }, 16, ["id", "as-child", "as", "type", "aria-checked", "aria-label", "data-state", "data-disabled", "disabled", "onKeydown"]),
      unref(u) ? (openBlock(), createElementBlock("input", {
        key: 0,
        type: "checkbox",
        tabindex: "-1",
        "aria-hidden": "",
        value: p.value,
        checked: !!unref(s),
        name: e.name,
        disabled: e.disabled,
        required: e.required,
        style: {
          transform: "translateX(-100%)",
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        }
      }, null, 8, Lu)) : createCommentVNode("", true)
    ], 64));
  }
});
var Dv = defineComponent({
  __name: "CheckboxIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const { forwardRef: t } = R2(), e = Nu();
    return (n, l) => (openBlock(), createBlock(unref(Pe), {
      present: n.forceMount || unref(Fa)(unref(e).state.value) || unref(e).state.value === true
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(t),
          "data-state": unref(Hl)(unref(e).state.value),
          "data-disabled": unref(e).disabled.value ? "" : void 0,
          style: { pointerEvents: "none" },
          "as-child": n.asChild,
          as: n.as
        }, n.$attrs), {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 16, ["data-state", "data-disabled", "as-child", "as"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var [Wl, Ku] = Q("PopperRoot");
var It = defineComponent({
  __name: "PopperRoot",
  setup(a2) {
    const t = ref();
    return Ku({
      anchor: t,
      onAnchorChange: (e) => t.value = e
    }), (e, n) => renderSlot(e.$slots, "default");
  }
});
var Tt = defineComponent({
  __name: "PopperAnchor",
  props: {
    element: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e, currentElement: n } = R2(), l = Wl();
    return watch(n, () => {
      l.onAnchorChange(t.element ?? n.value);
    }), (s, r) => (openBlock(), createBlock(unref(A2), {
      ref: unref(e),
      as: s.as,
      "as-child": s.asChild
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "as-child"]));
  }
});
function Hu(a2) {
  return a2 !== null;
}
function Wu(a2) {
  return {
    name: "transformOrigin",
    options: a2,
    fn(t) {
      var S, x, D;
      const { placement: e, rects: n, middlewareData: l } = t, r = ((S = l.arrow) == null ? void 0 : S.centerOffset) !== 0, i = r ? 0 : a2.arrowWidth, u = r ? 0 : a2.arrowHeight, [d, p] = Dn(e), c = { start: "0%", center: "50%", end: "100%" }[p], f = (((x = l.arrow) == null ? void 0 : x.x) ?? 0) + i / 2, v2 = (((D = l.arrow) == null ? void 0 : D.y) ?? 0) + u / 2;
      let g = "", m2 = "";
      return d === "bottom" ? (g = r ? c : `${f}px`, m2 = `${-u}px`) : d === "top" ? (g = r ? c : `${f}px`, m2 = `${n.floating.height + u}px`) : d === "right" ? (g = `${-u}px`, m2 = r ? c : `${v2}px`) : d === "left" && (g = `${n.floating.width + u}px`, m2 = r ? c : `${v2}px`), { data: { x: g, y: m2 } };
    }
  };
}
function Dn(a2) {
  const [t, e = "center"] = a2.split("-");
  return [t, e];
}
var jl = {
  side: "bottom",
  sideOffset: 0,
  align: "center",
  alignOffset: 0,
  arrowPadding: 0,
  avoidCollisions: true,
  collisionBoundary: () => [],
  collisionPadding: 0,
  sticky: "partial",
  hideWhenDetached: false,
  updatePositionStrategy: "optimized",
  prioritizePosition: false
};
var [ju, Uu] = Q("PopperContent");
var Pt = defineComponent({
  inheritAttrs: false,
  __name: "PopperContent",
  props: mergeDefaults({
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  }, {
    ...jl
  }),
  emits: ["placed"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Wl(), { forwardRef: s, currentElement: r } = R2(), i = ref(), u = ref(), { width: d, height: p } = Il(u), c = computed(
      () => e.side + (e.align !== "center" ? `-${e.align}` : "")
    ), f = computed(() => typeof e.collisionPadding == "number" ? e.collisionPadding : { top: 0, right: 0, bottom: 0, left: 0, ...e.collisionPadding }), v2 = computed(() => Array.isArray(e.collisionBoundary) ? e.collisionBoundary : [e.collisionBoundary]), g = computed(() => ({
      padding: f.value,
      boundary: v2.value.filter(Hu),
      // with `strategy: 'fixed'`, this is the only way to get it to respect boundaries
      altBoundary: v2.value.length > 0
    })), m2 = Kr(() => [
      offset2({
        mainAxis: e.sideOffset + p.value,
        alignmentAxis: e.alignOffset
      }),
      e.prioritizePosition && e.avoidCollisions && flip2({
        ...g.value
      }),
      e.avoidCollisions && shift2({
        mainAxis: true,
        crossAxis: !!e.prioritizePosition,
        limiter: e.sticky === "partial" ? limitShift2() : void 0,
        ...g.value
      }),
      !e.prioritizePosition && e.avoidCollisions && flip2({
        ...g.value
      }),
      size2({
        ...g.value,
        apply: ({ elements: O, rects: V2, availableWidth: H2, availableHeight: Y }) => {
          const { width: J2, height: N2 } = V2.reference, F = O.floating.style;
          Object.assign(O.floating.style, {
            maxWidth: `${H2}px`,
            maxHeight: `${Y}px`
          }), F.setProperty(
            "--radix-popper-available-width",
            `${H2}px`
          ), F.setProperty(
            "--radix-popper-available-height",
            `${Y}px`
          ), F.setProperty(
            "--radix-popper-anchor-width",
            `${J2}px`
          ), F.setProperty(
            "--radix-popper-anchor-height",
            `${N2}px`
          );
        }
      }),
      u.value && arrow3({ element: u.value, padding: e.arrowPadding }),
      Wu({
        arrowWidth: d.value,
        arrowHeight: p.value
      }),
      e.hideWhenDetached && hide2({ strategy: "referenceHidden", ...g.value })
    ]), { floatingStyles: S, placement: x, isPositioned: D, middlewareData: h2 } = useFloating(
      l.anchor,
      i,
      {
        strategy: "fixed",
        placement: c,
        whileElementsMounted: (...O) => autoUpdate(...O, {
          animationFrame: e.updatePositionStrategy === "always"
        }),
        middleware: m2
      }
    ), E = computed(
      () => Dn(x.value)[0]
    ), P2 = computed(
      () => Dn(x.value)[1]
    );
    watchEffect(() => {
      D.value && n("placed");
    });
    const $2 = computed(
      () => {
        var O;
        return ((O = h2.value.arrow) == null ? void 0 : O.centerOffset) !== 0;
      }
    ), I = ref("");
    watchEffect(() => {
      r.value && (I.value = window.getComputedStyle(r.value).zIndex);
    });
    const k = computed(() => {
      var O;
      return ((O = h2.value.arrow) == null ? void 0 : O.x) ?? 0;
    }), L = computed(() => {
      var O;
      return ((O = h2.value.arrow) == null ? void 0 : O.y) ?? 0;
    });
    return Uu({
      placedSide: E,
      onArrowChange: (O) => u.value = O,
      arrowX: k,
      arrowY: L,
      shouldHideArrow: $2
    }), (O, V2) => {
      var H2, Y, J2;
      return openBlock(), createElementBlock("div", {
        ref_key: "floatingRef",
        ref: i,
        "data-radix-popper-content-wrapper": "",
        style: normalizeStyle({
          ...unref(S),
          transform: unref(D) ? unref(S).transform : "translate(0, -200%)",
          // keep off the page when measuring
          minWidth: "max-content",
          zIndex: I.value,
          "--radix-popper-transform-origin": [
            (H2 = unref(h2).transformOrigin) == null ? void 0 : H2.x,
            (Y = unref(h2).transformOrigin) == null ? void 0 : Y.y
          ].join(" "),
          // hide the content if using the hide middleware and should be hidden
          // set visibility to hidden and disable pointer events so the UI behaves
          // as if the PopperContent isn't there at all
          ...((J2 = unref(h2).hide) == null ? void 0 : J2.referenceHidden) && {
            visibility: "hidden",
            pointerEvents: "none"
          }
        })
      }, [
        createVNode(unref(A2), mergeProps({ ref: unref(s) }, O.$attrs, {
          "as-child": e.asChild,
          as: O.as,
          "data-side": E.value,
          "data-align": P2.value,
          style: {
            // if the PopperContent hasn't been placed yet (not all measurements done)
            // we prevent animations so that users's animation don't kick in too early referring wrong sides
            animation: unref(D) ? void 0 : "none"
          }
        }), {
          default: withCtx(() => [
            renderSlot(O.$slots, "default")
          ]),
          _: 3
        }, 16, ["as-child", "as", "data-side", "data-align", "style"])
      ], 4);
    };
  }
});
var Gu = createBaseVNode("polygon", { points: "0,0 30,0 15,10" }, null, -1);
var qu = defineComponent({
  __name: "Arrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      width: e.width,
      height: e.height,
      viewBox: e.asChild ? void 0 : "0 0 30 10",
      preserveAspectRatio: e.asChild ? void 0 : "none"
    }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default", {}, () => [
          Gu
        ])
      ]),
      _: 3
    }, 16, ["width", "height", "viewBox", "preserveAspectRatio"]));
  }
});
var Yu = {
  top: "bottom",
  right: "left",
  bottom: "top",
  left: "right"
};
var qt = defineComponent({
  inheritAttrs: false,
  __name: "PopperArrow",
  props: {
    width: {},
    height: {},
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const { forwardRef: t } = R2(), e = ju(), n = computed(() => Yu[e.placedSide.value]);
    return (l, s) => {
      var r, i, u, d;
      return openBlock(), createElementBlock("span", {
        ref: (p) => {
          unref(e).onArrowChange(p);
        },
        style: normalizeStyle({
          position: "absolute",
          left: (r = unref(e).arrowX) != null && r.value ? `${(i = unref(e).arrowX) == null ? void 0 : i.value}px` : void 0,
          top: (u = unref(e).arrowY) != null && u.value ? `${(d = unref(e).arrowY) == null ? void 0 : d.value}px` : void 0,
          [n.value]: 0,
          transformOrigin: {
            top: "",
            right: "0 0",
            bottom: "center 0",
            left: "100% 0"
          }[unref(e).placedSide.value],
          transform: {
            top: "translateY(100%)",
            right: "translateY(50%) rotate(90deg) translateX(-50%)",
            bottom: "rotate(180deg)",
            left: "translateY(50%) rotate(-90deg) translateX(50%)"
          }[unref(e).placedSide.value],
          visibility: unref(e).shouldHideArrow.value ? "hidden" : void 0
        })
      }, [
        createVNode(qu, mergeProps(l.$attrs, {
          ref: unref(t),
          style: {
            display: "block"
          },
          as: l.as,
          "as-child": l.asChild,
          width: l.width,
          height: l.height
        }), {
          default: withCtx(() => [
            renderSlot(l.$slots, "default")
          ]),
          _: 3
        }, 16, ["as", "as-child", "width", "height"])
      ], 4);
    };
  }
});
var Yt = defineComponent({
  __name: "VisuallyHidden",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    return R2(), (t, e) => (openBlock(), createBlock(unref(A2), {
      as: t.as,
      "as-child": t.asChild,
      style: {
        // See: https://github.com/twbs/bootstrap/blob/master/scss/mixins/_screen-reader.scss
        position: "absolute",
        border: 0,
        width: "1px",
        display: "inline-block",
        height: "1px",
        padding: 0,
        margin: "-1px",
        overflow: "hidden",
        clip: "rect(0, 0, 0, 0)",
        whiteSpace: "nowrap",
        wordWrap: "normal"
      }
    }, {
      default: withCtx(() => [
        renderSlot(t.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "as-child"]));
  }
});
var Qn = defineComponent({
  __name: "VisuallyHiddenInput",
  props: {
    name: {},
    value: {},
    required: { type: Boolean },
    disabled: { type: Boolean }
  },
  setup(a2) {
    const t = a2, e = computed(() => typeof t.value == "string" || typeof t.value == "number" || typeof t.value == "boolean" ? [{ name: t.name, value: t.value }] : typeof t.value == "object" && Array.isArray(t.value) ? t.value.flatMap((n, l) => typeof n == "object" ? Object.entries(n).map(([s, r]) => ({ name: `[${l}][${t.name}][${s}]`, value: r })) : { name: `[${t.name}][${l}]`, value: n }) : t.value !== null && typeof t.value == "object" && !Array.isArray(t.value) ? Object.entries(t.value).map(([n, l]) => ({ name: `[${t.name}][${n}]`, value: l })) : []);
    return (n, l) => (openBlock(true), createElementBlock(Fragment, null, renderList(e.value, (s) => (openBlock(), createBlock(Yt, {
      key: s.name,
      as: "input",
      type: "hidden",
      hidden: "",
      readonly: "",
      name: s.name,
      value: s.value,
      required: n.required,
      disabled: n.disabled
    }, null, 8, ["name", "value", "required", "disabled"]))), 128));
  }
});
var Xu = "data-radix-vue-collection-item";
var [eo, Zu] = Q("CollectionProvider");
function ga(a2 = Xu) {
  const t = ref(/* @__PURE__ */ new Map()), e = ref(), n = Zu({
    collectionRef: e,
    itemMap: t,
    attrName: a2
  }), { getItems: l } = Zt(n), s = computed(() => Array.from(n.itemMap.value.values())), r = computed(() => n.itemMap.value.size);
  return { getItems: l, reactiveItems: s, itemMapSize: r };
}
var ba = defineComponent({
  name: "CollectionSlot",
  setup(a2, { slots: t }) {
    const e = eo(), { primitiveElement: n, currentElement: l } = Re();
    return watch(l, () => {
      e.collectionRef.value = l.value;
    }), () => h(qn, { ref: n }, t);
  }
});
var Xt = defineComponent({
  name: "CollectionItem",
  inheritAttrs: false,
  setup(a2, { slots: t, attrs: e }) {
    const n = eo(), { primitiveElement: l, currentElement: s } = Re(), { value: r, ...i } = e;
    return watchEffect((u) => {
      if (s.value) {
        const d = markRaw(s.value);
        n.itemMap.value.set(d, { ref: s.value, value: r }), u(() => n.itemMap.value.delete(d));
      }
    }), () => h(qn, { ...i, [n.attrName]: "", ref: l }, t);
  }
});
function Zt(a2) {
  const t = a2 ?? eo();
  return { getItems: () => {
    const n = t.collectionRef.value;
    if (!n)
      return [];
    const l = Array.from(n.querySelectorAll(`[${t.attrName}]`));
    return Array.from(t.itemMap.value.values()).sort(
      (i, u) => l.indexOf(i.ref) - l.indexOf(u.ref)
    );
  } };
}
var [nt, Ju] = Q("ComboboxRoot");
var $v = defineComponent({
  __name: "ComboboxRoot",
  props: {
    modelValue: {},
    defaultValue: {},
    open: { type: Boolean, default: void 0 },
    defaultOpen: { type: Boolean },
    searchTerm: {},
    selectedValue: {},
    multiple: { type: Boolean },
    disabled: { type: Boolean },
    name: {},
    dir: {},
    filterFunction: {},
    displayValue: {},
    resetSearchTermOnBlur: { type: Boolean, default: true },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "update:open", "update:searchTerm", "update:selectedValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { multiple: l, disabled: s, dir: r } = toRefs(e), i = Ce(r), u = ae(e, "searchTerm", n, {
      // @ts-expect-error ignore the type error here
      defaultValue: "",
      passive: e.searchTerm === void 0
    }), d = ae(e, "modelValue", n, {
      // @ts-expect-error ignore the type error here
      defaultValue: e.defaultValue ?? l.value ? [] : void 0,
      passive: e.modelValue === void 0,
      deep: true
    }), p = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    }), c = ae(e, "selectedValue", n, {
      defaultValue: void 0,
      passive: e.selectedValue === void 0
    });
    async function f(N2) {
      var F, W2;
      p.value = N2, await nextTick(), N2 ? (d.value && (Array.isArray(d.value) && l.value ? c.value = (F = h2().find((z2) => {
        var Z, U;
        return ((U = (Z = z2.ref) == null ? void 0 : Z.dataset) == null ? void 0 : U.state) === "checked";
      })) == null ? void 0 : F.value : c.value = d.value), (W2 = m2.value) == null || W2.focus(), Y()) : (g.value = false, e.resetSearchTermOnBlur && k());
    }
    function v2(N2) {
      if (Array.isArray(d.value) && l.value) {
        const F = d.value.findIndex((z2) => Ye(z2, N2)), W2 = [...d.value];
        F === -1 ? W2.push(N2) : W2.splice(F, 1), d.value = W2;
      } else
        d.value = N2, f(false);
    }
    const g = ref(false), m2 = ref(), S = ref(), { forwardRef: x, currentElement: D } = R2(), { getItems: h2, reactiveItems: E, itemMapSize: P2 } = ga("data-radix-vue-combobox-item"), $2 = ref([]);
    watch(() => P2.value, () => {
      $2.value = h2().map((N2) => N2.value);
    }, {
      immediate: true,
      flush: "post"
    });
    const I = computed(() => {
      if (g.value) {
        if (e.filterFunction)
          return e.filterFunction($2.value, u.value);
        const N2 = $2.value.filter((F) => typeof F == "string");
        if (N2.length)
          return N2.filter((F) => {
            var W2;
            return F.toLowerCase().includes((W2 = u.value) == null ? void 0 : W2.toLowerCase());
          });
      }
      return $2.value;
    });
    function k() {
      !l.value && d.value && !Array.isArray(d.value) ? e.displayValue ? u.value = e.displayValue(d.value) : typeof d.value != "object" ? u.value = d.value.toString() : u.value = "" : u.value = "";
    }
    const L = computed(() => I.value.findIndex((N2) => Ye(N2, c.value))), O = computed(() => {
      var N2;
      return (N2 = E.value.find((F) => Ye(F.value, c.value))) == null ? void 0 : N2.ref;
    }), V2 = computed(() => JSON.stringify(d.value));
    watch(V2, async () => {
      await nextTick(), await nextTick(), k();
    }, {
      // If searchTerm is provided with value during initialization, we don't reset it immediately
      immediate: !e.searchTerm
    }), watch(() => [I.value.length, u.value.length], async ([N2, F], [W2, z2]) => {
      await nextTick(), await nextTick(), N2 && (z2 > F || L.value === -1) && (c.value = I.value[0]);
    });
    const H2 = Qe(D);
    function Y() {
      O.value instanceof Element && O.value.scrollIntoView({ block: "nearest" });
    }
    function J2() {
      O.value instanceof Element && O.value.focus && O.value.focus();
    }
    return Ju({
      searchTerm: u,
      modelValue: d,
      // @ts-expect-error ignoring
      onValueChange: v2,
      isUserInputted: g,
      multiple: l,
      disabled: s,
      open: p,
      onOpenChange: f,
      filteredOptions: I,
      contentId: "",
      inputElement: m2,
      selectedElement: O,
      onInputElementChange: (N2) => m2.value = N2,
      onInputNavigation: async (N2) => {
        const F = L.value;
        F === 0 && N2 === "up" || F === I.value.length - 1 && N2 === "down" || (F === -1 && I.value.length || N2 === "home" ? c.value = I.value[0] : N2 === "end" ? c.value = I.value[I.value.length - 1] : c.value = I.value[N2 === "up" ? F - 1 : F + 1], Y(), J2(), nextTick(() => {
          var W2;
          return (W2 = m2.value) == null ? void 0 : W2.focus({ preventScroll: true });
        }));
      },
      onInputEnter: async () => {
        var N2;
        I.value.length && c.value && O.value instanceof Element && ((N2 = O.value) == null || N2.click());
      },
      selectedValue: c,
      onSelectedValueChange: (N2) => c.value = N2,
      parentElement: D,
      contentElement: S,
      onContentElementChange: (N2) => S.value = N2
    }), (N2, F) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(x),
          style: {
            pointerEvents: unref(p) ? "auto" : void 0
          },
          as: N2.as,
          "as-child": N2.asChild,
          dir: unref(i)
        }, N2.$attrs), {
          default: withCtx(() => [
            renderSlot(N2.$slots, "default", {
              open: unref(p),
              modelValue: unref(d)
            }),
            unref(H2) && e.name ? (openBlock(), createBlock(unref(Qn), {
              key: 0,
              name: e.name,
              value: unref(d)
            }, null, 8, ["name", "value"])) : createCommentVNode("", true)
          ]),
          _: 3
        }, 16, ["style", "as", "as-child", "dir"])
      ]),
      _: 3
    }));
  }
});
var Bv = defineComponent({
  __name: "ComboboxInput",
  props: {
    type: { default: "text" },
    disabled: { type: Boolean },
    autoFocus: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  setup(a2) {
    const t = a2, e = nt(), { forwardRef: n, currentElement: l } = R2();
    onMounted(() => {
      const d = l.value.nodeName === "INPUT" ? l.value : l.value.querySelector("input");
      d && (e.onInputElementChange(d), setTimeout(() => {
        t.autoFocus && (d == null || d.focus());
      }, 1));
    });
    const s = computed(() => t.disabled || e.disabled.value || false);
    function r(d) {
      e.open.value ? e.onInputNavigation(d.key === "ArrowUp" ? "up" : "down") : e.onOpenChange(true);
    }
    function i(d) {
      e.open.value && e.onInputNavigation(d.key === "Home" ? "home" : "end");
    }
    function u(d) {
      var p;
      e.searchTerm.value = (p = d.target) == null ? void 0 : p.value, e.open.value || e.onOpenChange(true), e.isUserInputted.value = true;
    }
    return (d, p) => {
      var c;
      return openBlock(), createBlock(unref(A2), {
        ref: unref(n),
        as: d.as,
        "as-child": d.asChild,
        type: d.type,
        disabled: s.value,
        value: unref(e).searchTerm.value,
        "aria-expanded": unref(e).open.value,
        "aria-controls": unref(e).contentId,
        "aria-disabled": s.value ?? void 0,
        "aria-activedescendant": (c = unref(e).selectedElement.value) == null ? void 0 : c.id,
        "aria-autocomplete": "list",
        role: "combobox",
        autocomplete: "false",
        onInput: u,
        onKeydown: [
          withKeys(withModifiers(r, ["prevent"]), ["down", "up"]),
          withKeys(unref(e).onInputEnter, ["enter"]),
          withKeys(withModifiers(i, ["prevent"]), ["home", "end"])
        ]
      }, {
        default: withCtx(() => [
          renderSlot(d.$slots, "default")
        ]),
        _: 3
      }, 8, ["as", "as-child", "type", "disabled", "value", "aria-expanded", "aria-controls", "aria-disabled", "aria-activedescendant", "onKeydown"]);
    };
  }
});
var Iv = defineComponent({
  __name: "ComboboxAnchor",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const { forwardRef: t } = R2();
    return (e, n) => (openBlock(), createBlock(unref(Tt), { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(t),
          "as-child": e.asChild,
          as: e.as
        }, e.$attrs), {
          default: withCtx(() => [
            renderSlot(e.$slots, "default")
          ]),
          _: 3
        }, 16, ["as-child", "as"])
      ]),
      _: 3
    }));
  }
});
var Tv = defineComponent({
  __name: "ComboboxTrigger",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = nt(), n = computed(() => t.disabled || e.disabled.value || false);
    return (l, s) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      type: l.as === "button" ? "button" : void 0,
      tabindex: "-1",
      "aria-label": "Show popup",
      "aria-haspopup": "listbox",
      "aria-expanded": unref(e).open.value,
      "aria-controls": unref(e).contentId,
      "data-state": unref(e).open.value ? "open" : "closed",
      disabled: n.value,
      "data-disabled": n.value ? "" : void 0,
      "aria-disabled": n.value ?? void 0,
      onClick: s[0] || (s[0] = (r) => unref(e).onOpenChange(!unref(e).open.value))
    }), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16, ["type", "aria-expanded", "aria-controls", "data-state", "disabled", "data-disabled", "aria-disabled"]));
  }
});
var Rv = defineComponent({
  __name: "ComboboxCancel",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = nt();
    function n() {
      var l;
      e.searchTerm.value = "", (l = e.inputElement.value) == null || l.focus();
    }
    return (l, s) => (openBlock(), createBlock(unref(A2), mergeProps({
      type: l.as === "button" ? "button" : void 0
    }, t, {
      tabindex: "-1",
      onClick: n
    }), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16, ["type"]));
  }
});
var [Ul, Qu] = Q("ComboboxGroup");
var Av = defineComponent({
  __name: "ComboboxGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { currentRef: e, currentElement: n } = R2(), l = me(void 0, "radix-vue-combobox-group"), s = nt(), r = ref(false);
    function i() {
      if (!n.value)
        return;
      const u = n.value.querySelectorAll("[data-radix-vue-combobox-item]:not([data-hidden])");
      r.value = !!u.length;
    }
    return Sl(n, () => {
      nextTick(() => {
        i();
      });
    }, { childList: true }), watch(() => s.searchTerm.value, () => {
      nextTick(() => {
        i();
      });
    }, { immediate: true }), Qu({
      id: l
    }), (u, d) => withDirectives((openBlock(), createBlock(unref(A2), mergeProps(t, {
      ref_key: "currentRef",
      ref: e,
      role: "group",
      "aria-labelledby": unref(l)
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-labelledby"])), [
      [vShow, r.value]
    ]);
  }
});
var Ov = defineComponent({
  __name: "ComboboxLabel",
  props: {
    for: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Ul({ id: "" });
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).id
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var [ed, td] = Q("ComboboxContent");
var ad = defineComponent({
  __name: "ComboboxContentImpl",
  props: {
    position: { default: "inline" },
    bodyLock: { type: Boolean },
    dismissable: { type: Boolean, default: true },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { position: l } = toRefs(e), s = nt();
    ma(e.bodyLock);
    const { forwardRef: r, currentElement: i } = R2();
    ha(i);
    const u = computed(() => e.position === "popper" ? e : {}), d = Bt(u.value);
    function p(f) {
      s.onSelectedValueChange("");
    }
    onMounted(() => {
      s.onContentElementChange(i.value);
    });
    const c = {
      // Ensure border-box for floating-ui calculations
      boxSizing: "border-box",
      "--radix-combobox-content-transform-origin": "var(--radix-popper-transform-origin)",
      "--radix-combobox-content-available-width": "var(--radix-popper-available-width)",
      "--radix-combobox-content-available-height": "var(--radix-popper-available-height)",
      "--radix-combobox-trigger-width": "var(--radix-popper-anchor-width)",
      "--radix-combobox-trigger-height": "var(--radix-popper-anchor-height)"
    };
    return td({ position: l }), (f, v2) => (openBlock(), createBlock(unref(ba), null, {
      default: withCtx(() => [
        f.dismissable ? (openBlock(), createBlock(unref(yt), {
          key: 0,
          "as-child": "",
          "disable-outside-pointer-events": f.disableOutsidePointerEvents,
          onDismiss: v2[0] || (v2[0] = (g) => unref(s).onOpenChange(false)),
          onFocusOutside: v2[1] || (v2[1] = (g) => {
            var m2;
            (m2 = unref(s).parentElement.value) != null && m2.contains(g.target) && g.preventDefault(), n("focusOutside", g);
          }),
          onInteractOutside: v2[2] || (v2[2] = (g) => n("interactOutside", g)),
          onEscapeKeyDown: v2[3] || (v2[3] = (g) => n("escapeKeyDown", g)),
          onPointerDownOutside: v2[4] || (v2[4] = (g) => {
            var m2;
            (m2 = unref(s).parentElement.value) != null && m2.contains(g.target) && g.preventDefault(), n("pointerDownOutside", g);
          })
        }, {
          default: withCtx(() => [
            (openBlock(), createBlock(resolveDynamicComponent(unref(l) === "popper" ? unref(Pt) : unref(A2)), mergeProps({ ...f.$attrs, ...unref(d) }, {
              id: unref(s).contentId,
              ref: unref(r),
              role: "listbox",
              "data-state": unref(s).open.value ? "open" : "closed",
              style: {
                // flex layout so we can place the scroll buttons properly
                display: "flex",
                flexDirection: "column",
                // reset the outline by default as the content MAY get focused
                outline: "none",
                ...unref(l) === "popper" ? c : {}
              },
              onPointerleave: p
            }), {
              default: withCtx(() => [
                renderSlot(f.$slots, "default")
              ]),
              _: 3
            }, 16, ["id", "data-state", "style"]))
          ]),
          _: 3
        }, 8, ["disable-outside-pointer-events"])) : (openBlock(), createBlock(resolveDynamicComponent(unref(l) === "popper" ? unref(Pt) : unref(A2)), mergeProps({ key: 1 }, { ...f.$attrs, ...u.value }, {
          id: unref(s).contentId,
          ref: unref(r),
          role: "listbox",
          "data-state": unref(s).open.value ? "open" : "closed",
          style: {
            // flex layout so we can place the scroll buttons properly
            display: "flex",
            flexDirection: "column",
            // reset the outline by default as the content MAY get focused
            outline: "none",
            ...unref(l) === "popper" ? c : {}
          },
          onPointerleave: p
        }), {
          default: withCtx(() => [
            renderSlot(f.$slots, "default")
          ]),
          _: 3
        }, 16, ["id", "data-state", "style"]))
      ]),
      _: 3
    }));
  }
});
var kv = defineComponent({
  __name: "ComboboxContent",
  props: {
    forceMount: { type: Boolean },
    position: {},
    bodyLock: { type: Boolean },
    dismissable: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t), { forwardRef: s } = R2(), r = nt();
    return r.contentId || (r.contentId = me(void 0, "radix-vue-combobox-content")), (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(r).open.value
    }, {
      default: withCtx(() => [
        createVNode(ad, mergeProps({ ...unref(l), ...i.$attrs }, { ref: unref(s) }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var Mv = defineComponent({
  __name: "ComboboxEmpty",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = nt(), n = computed(() => e.filteredOptions.value.length === 0);
    return (l, s) => n.value ? (openBlock(), createBlock(unref(A2), normalizeProps(mergeProps({ key: 0 }, t)), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default", {}, () => [
          createTextVNode("No options")
        ])
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
function qa(a2) {
  const t = ja({
    nonce: ref()
  });
  return computed(() => {
    var e;
    return (a2 == null ? void 0 : a2.value) || ((e = t.nonce) == null ? void 0 : e.value);
  });
}
var Vv = defineComponent({
  __name: "ComboboxViewport",
  props: {
    nonce: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), { nonce: n } = toRefs(t), l = qa(n);
    return (s, r) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps({ ...s.$attrs, ...t }, {
        ref: unref(e),
        "data-radix-combobox-viewport": "",
        role: "presentation",
        style: {
          // we use position: 'relative' here on the `viewport` so that when we call
          // `selectedItem.offsetTop` in calculations, the offset is relative to the viewport
          // (independent of the scrollUpButton).
          position: "relative",
          flex: 1,
          overflow: "auto"
        }
      }), {
        default: withCtx(() => [
          renderSlot(s.$slots, "default")
        ]),
        _: 3
      }, 16),
      createVNode(unref(A2), {
        as: "style",
        nonce: unref(l)
      }, {
        default: withCtx(() => [
          createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-radix-combobox-viewport] { scrollbar-width:none; -ms-overflow-style: none; -webkit-overflow-scrolling: touch; } [data-radix-combobox-viewport]::-webkit-scrollbar { display: none; } ")
        ]),
        _: 1
      }, 8, ["nonce"])
    ], 64));
  }
});
var [nd, od] = Q("ComboboxItem");
var ld = "combobox.select";
var Fv = defineComponent({
  __name: "ComboboxItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { disabled: l } = toRefs(e), s = nt();
    Ul({ id: "", options: ref([]) });
    const { forwardRef: r } = R2(), i = computed(
      () => {
        var m2, S;
        return s.multiple.value && Array.isArray(s.modelValue.value) ? (m2 = s.modelValue.value) == null ? void 0 : m2.some((x) => Ye(x, e.value)) : Ye((S = s.modelValue) == null ? void 0 : S.value, e.value);
      }
    ), u = computed(() => Ye(s.selectedValue.value, e.value)), d = me(void 0, "radix-vue-combobox-item"), p = me(void 0, "radix-vue-combobox-option"), c = computed(() => s.isUserInputted.value ? s.searchTerm.value === "" || !!s.filteredOptions.value.find((m2) => Ye(m2, e.value)) : true);
    async function f(m2) {
      n("select", m2), !(m2 != null && m2.defaultPrevented) && !l.value && m2 && s.onValueChange(e.value);
    }
    function v2(m2) {
      if (!m2)
        return;
      const S = { originalEvent: m2, value: e.value };
      zt(ld, f, S);
    }
    async function g(m2) {
      await nextTick(), !m2.defaultPrevented && s.onSelectedValueChange(e.value);
    }
    if (e.value === "")
      throw new Error(
        "A <ComboboxItem /> must have a value prop that is not an empty string. This is because the Combobox value can be set to an empty string to clear the selection and show the placeholder."
      );
    return od({
      isSelected: i
    }), (m2, S) => (openBlock(), createBlock(unref(Xt), { value: m2.value }, {
      default: withCtx(() => [
        withDirectives(createVNode(unref(A2), {
          id: unref(p),
          ref: unref(r),
          role: "option",
          tabindex: "-1",
          "aria-labelledby": unref(d),
          "data-highlighted": u.value ? "" : void 0,
          "aria-selected": i.value,
          "data-state": i.value ? "checked" : "unchecked",
          "aria-disabled": unref(l) || void 0,
          "data-disabled": unref(l) ? "" : void 0,
          as: m2.as,
          "as-child": m2.asChild,
          "data-hidden": c.value ? void 0 : true,
          onClick: v2,
          onPointermove: g
        }, {
          default: withCtx(() => [
            renderSlot(m2.$slots, "default", {}, () => [
              createTextVNode(toDisplayString(m2.value), 1)
            ])
          ]),
          _: 3
        }, 8, ["id", "aria-labelledby", "data-highlighted", "aria-selected", "data-state", "aria-disabled", "data-disabled", "as", "as-child", "data-hidden"]), [
          [vShow, c.value]
        ])
      ]),
      _: 3
    }, 8, ["value"]));
  }
});
var Lv = defineComponent({
  __name: "ComboboxItemIndicator",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = nd();
    return (n, l) => unref(e).isSelected.value ? (openBlock(), createBlock(unref(A2), mergeProps({
      key: 0,
      "aria-hidden": ""
    }, t), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
var Nv = defineComponent({
  __name: "ComboboxSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, { "aria-hidden": "" }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var zv = defineComponent({
  __name: "ComboboxArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2, e = nt(), n = ed();
    return R2(), (l, s) => unref(e).open.value && unref(n).position.value === "popper" ? (openBlock(), createBlock(unref(qt), normalizeProps(mergeProps({ key: 0 }, t)), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
var Kv = defineComponent({
  __name: "ComboboxPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Ya = defineComponent({
  __name: "MenuAnchor",
  props: {
    element: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Tt), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var to = defineComponent({
  __name: "MenuArrow",
  props: {
    width: {},
    height: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(qt), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [Rt, Gl] = Q(["MenuRoot", "MenuSub"], "MenuContext");
var [Ca, sd] = Q("MenuRoot");
var ao = defineComponent({
  __name: "MenuRoot",
  props: {
    open: { type: Boolean, default: false },
    dir: {},
    modal: { type: Boolean, default: true }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { modal: l, dir: s } = toRefs(e), r = Ce(s), i = ae(e, "open", n), u = ref(), d = ref(false);
    return watchEffect((p) => {
      if (!Je)
        return;
      const c = () => {
        d.value = true, document.addEventListener("pointerdown", f, {
          capture: true,
          once: true
        }), document.addEventListener("pointermove", f, {
          capture: true,
          once: true
        });
      }, f = () => d.value = false;
      document.addEventListener("keydown", c, { capture: true }), p(() => {
        document.removeEventListener("keydown", c, { capture: true }), document.removeEventListener("pointerdown", f, {
          capture: true
        }), document.removeEventListener("pointermove", f, {
          capture: true
        });
      });
    }), Gl({
      open: i,
      onOpenChange: (p) => {
        i.value = p;
      },
      content: u,
      onContentChange: (p) => {
        u.value = p;
      }
    }), sd({
      onClose: () => {
        i.value = false;
      },
      isUsingKeyboardRef: d,
      dir: r,
      modal: l
    }), (p, c) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        renderSlot(p.$slots, "default")
      ]),
      _: 3
    }));
  }
});
var rd = "rovingFocusGroup.onEntryFocus";
var id = { bubbles: false, cancelable: true };
var Xa = {
  ArrowLeft: "prev",
  ArrowUp: "prev",
  ArrowRight: "next",
  ArrowDown: "next",
  PageUp: "first",
  Home: "first",
  PageDown: "last",
  End: "last"
};
function ud(a2, t) {
  return t !== "rtl" ? a2 : a2 === "ArrowLeft" ? "ArrowRight" : a2 === "ArrowRight" ? "ArrowLeft" : a2;
}
function ql(a2, t, e) {
  const n = ud(a2.key, e);
  if (!(t === "vertical" && ["ArrowLeft", "ArrowRight"].includes(n)) && !(t === "horizontal" && ["ArrowUp", "ArrowDown"].includes(n)))
    return Xa[n];
}
function Yl(a2, t = false) {
  const e = document.activeElement;
  for (const n of a2)
    if (n === e || (n.focus({ preventScroll: t }), document.activeElement !== e))
      return;
}
function dd(a2, t) {
  return a2.map((e, n) => a2[(t + n) % a2.length]);
}
var [cd, pd] = Q("RovingFocusGroup");
var At = defineComponent({
  __name: "RovingFocusGroup",
  props: {
    orientation: { default: void 0 },
    dir: {},
    loop: { type: Boolean, default: false },
    currentTabStopId: {},
    defaultCurrentTabStopId: {},
    preventScrollOnEntryFocus: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["entryFocus", "update:currentTabStopId"],
  setup(a2, { expose: t, emit: e }) {
    const n = a2, l = e, { loop: s, orientation: r, dir: i } = toRefs(n), u = Ce(i), d = ae(n, "currentTabStopId", l, {
      defaultValue: n.defaultCurrentTabStopId,
      passive: n.currentTabStopId === void 0
    }), p = ref(false), c = ref(false), f = ref(0), { getItems: v2 } = ga();
    function g(m2) {
      const S = !c.value;
      if (m2.currentTarget && m2.target === m2.currentTarget && S && !p.value) {
        const x = new CustomEvent(rd, id);
        if (m2.currentTarget.dispatchEvent(x), l("entryFocus", x), !x.defaultPrevented) {
          const D = v2().map(($2) => $2.ref).filter(($2) => $2.dataset.disabled !== ""), h2 = D.find(($2) => $2.getAttribute("data-active") === "true"), E = D.find(
            ($2) => $2.id === d.value
          ), P2 = [h2, E, ...D].filter(
            Boolean
          );
          Yl(P2, n.preventScrollOnEntryFocus);
        }
      }
      c.value = false;
    }
    return t({
      getItems: v2
    }), pd({
      loop: s,
      dir: u,
      orientation: r,
      currentTabStopId: d,
      onItemFocus: (m2) => {
        d.value = m2;
      },
      onItemShiftTab: () => {
        p.value = true;
      },
      onFocusableItemAdd: () => {
        f.value++;
      },
      onFocusableItemRemove: () => {
        f.value--;
      }
    }), (m2, S) => (openBlock(), createBlock(unref(ba), null, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          tabindex: p.value || f.value === 0 ? -1 : 0,
          "data-orientation": unref(r),
          as: m2.as,
          "as-child": m2.asChild,
          dir: unref(u),
          style: { outline: "none" },
          onMousedown: S[0] || (S[0] = (x) => c.value = true),
          onFocus: g,
          onBlur: S[1] || (S[1] = (x) => p.value = false)
        }, {
          default: withCtx(() => [
            renderSlot(m2.$slots, "default")
          ]),
          _: 3
        }, 8, ["tabindex", "data-orientation", "as", "as-child", "dir"])
      ]),
      _: 3
    }));
  }
});
var Ot = defineComponent({
  __name: "RovingFocusItem",
  props: {
    tabStopId: {},
    focusable: { type: Boolean, default: true },
    active: { type: Boolean, default: true },
    allowShiftKey: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, e = cd(), n = computed(() => t.tabStopId || me()), l = computed(
      () => e.currentTabStopId.value === n.value
    ), { getItems: s } = Zt();
    onMounted(() => {
      t.focusable && e.onFocusableItemAdd();
    }), onUnmounted(() => {
      t.focusable && e.onFocusableItemRemove();
    });
    function r(i) {
      if (i.key === "Tab" && i.shiftKey) {
        e.onItemShiftTab();
        return;
      }
      if (i.target !== i.currentTarget)
        return;
      const u = ql(
        i,
        e.orientation.value,
        e.dir.value
      );
      if (u !== void 0) {
        if (i.metaKey || i.ctrlKey || i.altKey || !t.allowShiftKey && i.shiftKey)
          return;
        i.preventDefault();
        let d = [...s().map((p) => p.ref).filter((p) => p.dataset.disabled !== "")];
        if (u === "last")
          d.reverse();
        else if (u === "prev" || u === "next") {
          u === "prev" && d.reverse();
          const p = d.indexOf(
            i.currentTarget
          );
          d = e.loop.value ? dd(d, p + 1) : d.slice(p + 1);
        }
        nextTick(() => Yl(d));
      }
    }
    return (i, u) => (openBlock(), createBlock(unref(Xt), null, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          tabindex: l.value ? 0 : -1,
          "data-orientation": unref(e).orientation.value,
          "data-active": i.active,
          "data-disabled": i.focusable ? void 0 : "",
          as: i.as,
          "as-child": i.asChild,
          onMousedown: u[0] || (u[0] = (d) => {
            i.focusable ? unref(e).onItemFocus(n.value) : d.preventDefault();
          }),
          onFocus: u[1] || (u[1] = (d) => unref(e).onItemFocus(n.value)),
          onKeydown: r
        }, {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 8, ["tabindex", "data-orientation", "data-active", "data-disabled", "as", "as-child"])
      ]),
      _: 3
    }));
  }
});
var [no, fd] = Q("MenuContent");
var oo = defineComponent({
  __name: "MenuContentImpl",
  props: mergeDefaults({
    loop: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    disableOutsideScroll: { type: Boolean },
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  }, {
    ...jl
  }),
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus", "dismiss"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Rt(), s = Ca(), { trapFocus: r, disableOutsidePointerEvents: i, loop: u } = toRefs(e);
    jn(), ma(i.value);
    const d = ref(""), p = ref(0), c = ref(0), f = ref(null), v2 = ref("right"), g = ref(0), m2 = ref(null), { createCollection: S } = Me(), { forwardRef: x, currentElement: D } = R2(), h2 = S(D);
    watch(D, (O) => {
      l.onContentChange(O);
    });
    const { handleTypeaheadSearch: E } = ya(h2);
    onUnmounted(() => {
      window.clearTimeout(p.value);
    });
    function P2(O) {
      var H2, Y;
      return v2.value === ((H2 = f.value) == null ? void 0 : H2.side) && ou(O, (Y = f.value) == null ? void 0 : Y.area);
    }
    async function $2(O) {
      var V2;
      n("openAutoFocus", O), !O.defaultPrevented && (O.preventDefault(), (V2 = D.value) == null || V2.focus({
        preventScroll: true
      }));
    }
    function I(O) {
      if (O.defaultPrevented)
        return;
      const H2 = O.target.closest("[data-radix-menu-content]") === O.currentTarget, Y = O.ctrlKey || O.altKey || O.metaKey, J2 = O.key.length === 1, N2 = $t(
        O,
        document.activeElement,
        D.value,
        {
          loop: u.value,
          arrowKeyOptions: "vertical",
          dir: s == null ? void 0 : s.dir.value,
          focus: true,
          attributeName: "[data-radix-vue-collection-item]:not([data-disabled])"
        }
      );
      if (N2)
        return N2 == null ? void 0 : N2.focus();
      if (O.code === "Space" || (H2 && (O.key === "Tab" && O.preventDefault(), !Y && J2 && E(O.key)), O.target !== D.value) || !eu.includes(O.key))
        return;
      O.preventDefault();
      const F = h2.value;
      Fl.includes(O.key) && F.reverse(), Pn(F);
    }
    function k(O) {
      var V2, H2;
      (H2 = (V2 = O == null ? void 0 : O.currentTarget) == null ? void 0 : V2.contains) != null && H2.call(V2, O.target) || (window.clearTimeout(p.value), d.value = "");
    }
    function L(O) {
      var Y;
      if (!ia(O))
        return;
      const V2 = O.target, H2 = g.value !== O.clientX;
      if ((Y = O == null ? void 0 : O.currentTarget) != null && Y.contains(V2) && H2) {
        const J2 = O.clientX > g.value ? "right" : "left";
        v2.value = J2, g.value = O.clientX;
      }
    }
    return fd({
      onItemEnter: (O) => !!P2(O),
      onItemLeave: (O) => {
        var V2;
        P2(O) || ((V2 = D.value) == null || V2.focus(), m2.value = null);
      },
      onTriggerLeave: (O) => !!P2(O),
      searchRef: d,
      pointerGraceTimerRef: c,
      onPointerGraceIntentChange: (O) => {
        f.value = O;
      }
    }), (O, V2) => (openBlock(), createBlock(unref(Ga), {
      "as-child": "",
      trapped: unref(r),
      onMountAutoFocus: $2,
      onUnmountAutoFocus: V2[7] || (V2[7] = (H2) => n("closeAutoFocus", H2))
    }, {
      default: withCtx(() => [
        createVNode(unref(yt), {
          "as-child": "",
          "disable-outside-pointer-events": unref(i),
          onEscapeKeyDown: V2[2] || (V2[2] = (H2) => n("escapeKeyDown", H2)),
          onPointerDownOutside: V2[3] || (V2[3] = (H2) => n("pointerDownOutside", H2)),
          onFocusOutside: V2[4] || (V2[4] = (H2) => n("focusOutside", H2)),
          onInteractOutside: V2[5] || (V2[5] = (H2) => n("interactOutside", H2)),
          onDismiss: V2[6] || (V2[6] = (H2) => n("dismiss"))
        }, {
          default: withCtx(() => [
            createVNode(unref(At), {
              "current-tab-stop-id": m2.value,
              "onUpdate:currentTabStopId": V2[0] || (V2[0] = (H2) => m2.value = H2),
              "as-child": "",
              orientation: "vertical",
              dir: unref(s).dir.value,
              loop: unref(u),
              onEntryFocus: V2[1] || (V2[1] = (H2) => {
                n("entryFocus", H2), unref(s).isUsingKeyboardRef.value || H2.preventDefault();
              })
            }, {
              default: withCtx(() => [
                createVNode(unref(Pt), {
                  ref: unref(x),
                  role: "menu",
                  as: O.as,
                  "as-child": O.asChild,
                  "aria-orientation": "vertical",
                  "data-radix-menu-content": "",
                  "data-state": unref(Zn)(unref(l).open.value),
                  dir: unref(s).dir.value,
                  side: O.side,
                  "side-offset": O.sideOffset,
                  align: O.align,
                  "align-offset": O.alignOffset,
                  "avoid-collisions": O.avoidCollisions,
                  "collision-boundary": O.collisionBoundary,
                  "collision-padding": O.collisionPadding,
                  "arrow-padding": O.arrowPadding,
                  "prioritize-position": O.prioritizePosition,
                  sticky: O.sticky,
                  "hide-when-detached": O.hideWhenDetached,
                  onKeydown: I,
                  onBlur: k,
                  onPointermove: L
                }, {
                  default: withCtx(() => [
                    renderSlot(O.$slots, "default")
                  ]),
                  _: 3
                }, 8, ["as", "as-child", "data-state", "dir", "side", "side-offset", "align", "align-offset", "avoid-collisions", "collision-boundary", "collision-padding", "arrow-padding", "prioritize-position", "sticky", "hide-when-detached"])
              ]),
              _: 3
            }, 8, ["current-tab-stop-id", "dir", "loop"])
          ]),
          _: 3
        }, 8, ["disable-outside-pointer-events"])
      ]),
      _: 3
    }, 8, ["trapped"]));
  }
});
var Xl = defineComponent({
  inheritAttrs: false,
  __name: "MenuItemImpl",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = no(), { forwardRef: n } = R2(), l = ref(false);
    async function s(i) {
      if (!i.defaultPrevented && ia(i)) {
        if (t.disabled)
          e.onItemLeave(i);
        else if (!e.onItemEnter(i)) {
          const d = i.currentTarget;
          d == null || d.focus({ preventScroll: true });
        }
      }
    }
    async function r(i) {
      await nextTick(), !i.defaultPrevented && ia(i) && e.onItemLeave(i);
    }
    return (i, u) => (openBlock(), createBlock(unref(Xt), null, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(n),
          role: "menuitem",
          tabindex: "-1"
        }, i.$attrs, {
          as: i.as,
          "as-child": i.asChild,
          "data-radix-vue-collection-item": "",
          "aria-disabled": i.disabled || void 0,
          "data-disabled": i.disabled ? "" : void 0,
          "data-highlighted": l.value ? "" : void 0,
          onPointermove: s,
          onPointerleave: r,
          onFocus: u[0] || (u[0] = async (d) => {
            await nextTick(), !(d.defaultPrevented || i.disabled) && (l.value = true);
          }),
          onBlur: u[1] || (u[1] = async (d) => {
            await nextTick(), !d.defaultPrevented && (l.value = false);
          })
        }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16, ["as", "as-child", "aria-disabled", "data-disabled", "data-highlighted"])
      ]),
      _: 3
    }));
  }
});
var wa = defineComponent({
  __name: "MenuItem",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l, currentElement: s } = R2(), r = Ca(), i = no(), u = ref(false);
    async function d() {
      const p = s.value;
      if (!e.disabled && p) {
        const c = new CustomEvent(Ji, {
          bubbles: true,
          cancelable: true
        });
        n("select", c), await nextTick(), c.defaultPrevented ? u.value = false : r.onClose();
      }
    }
    return (p, c) => (openBlock(), createBlock(Xl, mergeProps(e, {
      ref: unref(l),
      onClick: d,
      onPointerdown: c[0] || (c[0] = () => {
        u.value = true;
      }),
      onPointerup: c[1] || (c[1] = async (f) => {
        var v2;
        await nextTick(), !f.defaultPrevented && (u.value || (v2 = f.currentTarget) == null || v2.click());
      }),
      onKeydown: c[2] || (c[2] = async (f) => {
        const v2 = unref(i).searchRef.value !== "";
        p.disabled || v2 && f.key === " " || unref(En).includes(f.key) && (f.currentTarget.click(), f.preventDefault());
      })
    }), {
      default: withCtx(() => [
        renderSlot(p.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [vd, Zl] = Q(
  ["MenuCheckboxItem", "MenuRadioItem"],
  "MenuItemIndicatorContext"
);
var lo = defineComponent({
  __name: "MenuItemIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = vd({
      checked: ref(false)
    });
    return (e, n) => (openBlock(), createBlock(unref(Pe), {
      present: e.forceMount || unref(Va)(unref(t).checked.value) || unref(t).checked.value === true
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          as: e.as,
          "as-child": e.asChild,
          "data-state": unref(Jn)(unref(t).checked.value)
        }, {
          default: withCtx(() => [
            renderSlot(e.$slots, "default")
          ]),
          _: 3
        }, 8, ["as", "as-child", "data-state"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var so = defineComponent({
  __name: "MenuCheckboxItem",
  props: {
    checked: { type: [Boolean, String], default: false },
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select", "update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = ae(e, "checked", n);
    return Zl({ checked: l }), (s, r) => (openBlock(), createBlock(wa, mergeProps({ role: "menuitemcheckbox" }, e, {
      "aria-checked": unref(Va)(unref(l)) ? "mixed" : unref(l),
      "data-state": unref(Jn)(unref(l)),
      onSelect: r[0] || (r[0] = async (i) => {
        n("select", i), unref(Va)(unref(l)) ? l.value = true : l.value = !unref(l);
      })
    }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default", { checked: unref(l) })
      ]),
      _: 3
    }, 16, ["aria-checked", "data-state"]));
  }
});
var md = defineComponent({
  __name: "MenuRootContentModal",
  props: {
    loop: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = xe(e, n), s = Rt(), { forwardRef: r, currentElement: i } = R2();
    return ha(i), (u, d) => (openBlock(), createBlock(oo, mergeProps(unref(l), {
      ref: unref(r),
      "trap-focus": unref(s).open.value,
      "disable-outside-pointer-events": unref(s).open.value,
      "disable-outside-scroll": true,
      onDismiss: d[0] || (d[0] = (p) => unref(s).onOpenChange(false)),
      onFocusOutside: d[1] || (d[1] = withModifiers((p) => n("focusOutside", p), ["prevent"]))
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16, ["trap-focus", "disable-outside-pointer-events"]));
  }
});
var hd = defineComponent({
  __name: "MenuRootContentNonModal",
  props: {
    loop: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t), s = Rt();
    return (r, i) => (openBlock(), createBlock(oo, mergeProps(unref(l), {
      "trap-focus": false,
      "disable-outside-pointer-events": false,
      "disable-outside-scroll": false,
      onDismiss: i[0] || (i[0] = (u) => unref(s).onOpenChange(false))
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var ro = defineComponent({
  __name: "MenuContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t), s = Rt(), r = Ca();
    return (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(s).open.value
    }, {
      default: withCtx(() => [
        unref(r).modal.value ? (openBlock(), createBlock(md, normalizeProps(mergeProps({ key: 0 }, { ...i.$attrs, ...unref(l) })), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16)) : (openBlock(), createBlock(hd, normalizeProps(mergeProps({ key: 1 }, { ...i.$attrs, ...unref(l) })), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16))
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var Za = defineComponent({
  __name: "MenuGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), mergeProps({ role: "group" }, t), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var io = defineComponent({
  __name: "MenuLabel",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var uo = defineComponent({
  __name: "MenuPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [yd, gd] = Q("MenuRadioGroup");
var co = defineComponent({
  __name: "MenuRadioGroup",
  props: {
    modelValue: { default: "" },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "modelValue", t);
    return gd({
      modelValue: l,
      onValueChange: (s) => {
        l.value = s;
      }
    }), (s, r) => (openBlock(), createBlock(Za, normalizeProps(guardReactiveProps(e)), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default", { modelValue: unref(l) })
      ]),
      _: 3
    }, 16));
  }
});
var po = defineComponent({
  __name: "MenuRadioItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { value: l } = toRefs(e), s = yd(), r = computed(
      () => s.modelValue.value === (l == null ? void 0 : l.value)
    );
    return Zl({ checked: r }), (i, u) => (openBlock(), createBlock(wa, mergeProps({ role: "menuitemradio" }, e, {
      "aria-checked": r.value,
      "data-state": unref(Jn)(r.value),
      onSelect: u[0] || (u[0] = async (d) => {
        n("select", d), unref(s).onValueChange(unref(l));
      })
    }), {
      default: withCtx(() => [
        renderSlot(i.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-checked", "data-state"]));
  }
});
var fo = defineComponent({
  __name: "MenuSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      role: "separator",
      "aria-orientation": "horizontal"
    }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [Jl, bd] = Q("MenuSub");
var vo = defineComponent({
  __name: "MenuSub",
  props: {
    open: { type: Boolean, default: void 0 }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "open", t, {
      defaultValue: false,
      passive: e.open === void 0
    }), s = Rt(), r = ref(), i = ref();
    return watchEffect((u) => {
      (s == null ? void 0 : s.open.value) === false && (l.value = false), u(() => l.value = false);
    }), Gl({
      open: l,
      onOpenChange: (u) => {
        l.value = u;
      },
      content: i,
      onContentChange: (u) => {
        i.value = u;
      }
    }), bd({
      triggerId: "",
      contentId: "",
      trigger: r,
      onTriggerChange: (u) => {
        r.value = u;
      }
    }), (u, d) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }));
  }
});
var mo = defineComponent({
  __name: "MenuSubContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    sideOffset: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean, default: true },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t), s = Rt(), r = Ca(), i = Jl(), { forwardRef: u, currentElement: d } = R2();
    return i.contentId || (i.contentId = me(void 0, "radix-vue-menu-sub-content")), (p, c) => (openBlock(), createBlock(unref(Pe), {
      present: p.forceMount || unref(s).open.value
    }, {
      default: withCtx(() => [
        createVNode(oo, mergeProps(unref(l), {
          id: unref(i).contentId,
          ref: unref(u),
          "aria-labelledby": unref(i).triggerId,
          align: "start",
          side: unref(r).dir.value === "rtl" ? "left" : "right",
          "disable-outside-pointer-events": false,
          "disable-outside-scroll": false,
          "trap-focus": false,
          onOpenAutoFocus: c[0] || (c[0] = withModifiers((f) => {
            var v2;
            unref(r).isUsingKeyboardRef.value && ((v2 = unref(d)) == null || v2.focus());
          }, ["prevent"])),
          onCloseAutoFocus: c[1] || (c[1] = withModifiers(() => {
          }, ["prevent"])),
          onFocusOutside: c[2] || (c[2] = (f) => {
            f.defaultPrevented || f.target !== unref(i).trigger.value && unref(s).onOpenChange(false);
          }),
          onEscapeKeyDown: c[3] || (c[3] = (f) => {
            unref(r).onClose(), f.preventDefault();
          }),
          onKeydown: c[4] || (c[4] = (f) => {
            var m2, S;
            const v2 = (m2 = f.currentTarget) == null ? void 0 : m2.contains(f.target), g = unref(au)[unref(r).dir.value].includes(f.key);
            v2 && g && (unref(s).onOpenChange(false), (S = unref(i).trigger.value) == null || S.focus(), f.preventDefault());
          })
        }), {
          default: withCtx(() => [
            renderSlot(p.$slots, "default")
          ]),
          _: 3
        }, 16, ["id", "aria-labelledby", "side"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var ho = defineComponent({
  __name: "MenuSubTrigger",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Rt(), n = Ca(), l = Jl(), s = no(), r = ref(null);
    l.triggerId || (l.triggerId = me(void 0, "radix-vue-menu-sub-trigger"));
    function i() {
      r.value && window.clearTimeout(r.value), r.value = null;
    }
    onUnmounted(() => {
      i();
    });
    function u(c) {
      !ia(c) || s.onItemEnter(c) || !t.disabled && !e.open.value && !r.value && (s.onPointerGraceIntentChange(null), r.value = window.setTimeout(() => {
        e.onOpenChange(true), i();
      }, 100));
    }
    async function d(c) {
      var v2, g;
      if (!ia(c))
        return;
      i();
      const f = (v2 = e.content.value) == null ? void 0 : v2.getBoundingClientRect();
      if (f != null && f.width) {
        const m2 = (g = e.content.value) == null ? void 0 : g.dataset.side, S = m2 === "right", x = S ? -5 : 5, D = f[S ? "left" : "right"], h2 = f[S ? "right" : "left"];
        s.onPointerGraceIntentChange({
          area: [
            // Apply a bleed on clientX to ensure that our exit point is
            // consistently within polygon bounds
            { x: c.clientX + x, y: c.clientY },
            { x: D, y: f.top },
            { x: h2, y: f.top },
            { x: h2, y: f.bottom },
            { x: D, y: f.bottom }
          ],
          side: m2
        }), window.clearTimeout(s.pointerGraceTimerRef.value), s.pointerGraceTimerRef.value = window.setTimeout(
          () => s.onPointerGraceIntentChange(null),
          300
        );
      } else {
        if (s.onTriggerLeave(c))
          return;
        s.onPointerGraceIntentChange(null);
      }
    }
    async function p(c) {
      var v2;
      const f = s.searchRef.value !== "";
      t.disabled || f && c.key === " " || tu[n.dir.value].includes(c.key) && (e.onOpenChange(true), await nextTick(), (v2 = e.content.value) == null || v2.focus(), c.preventDefault());
    }
    return (c, f) => (openBlock(), createBlock(Ya, { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(Xl, mergeProps(t, {
          id: unref(l).triggerId,
          ref: (v2) => {
            var g;
            (g = unref(l)) == null || g.onTriggerChange(v2 == null ? void 0 : v2.$el);
          },
          "aria-haspopup": "menu",
          "aria-expanded": unref(e).open.value,
          "aria-controls": unref(l).contentId,
          "data-state": unref(Zn)(unref(e).open.value),
          onClick: f[0] || (f[0] = async (v2) => {
            t.disabled || v2.defaultPrevented || (v2.currentTarget.focus(), unref(e).open.value || unref(e).onOpenChange(true));
          }),
          onPointermove: u,
          onPointerleave: d,
          onKeydown: p
        }), {
          default: withCtx(() => [
            renderSlot(c.$slots, "default")
          ]),
          _: 3
        }, 16, ["id", "aria-expanded", "aria-controls", "data-state"])
      ]),
      _: 3
    }));
  }
});
var [Ql, Cd] = Q("ContextMenuRoot");
var Hv = defineComponent({
  inheritAttrs: false,
  __name: "ContextMenuRoot",
  props: {
    dir: {},
    modal: { type: Boolean, default: true }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { dir: l, modal: s } = toRefs(e);
    R2();
    const r = Ce(l), i = ref(false);
    return Cd({
      open: i,
      onOpenChange: (u) => {
        i.value = u;
      },
      dir: r,
      modal: s
    }), watch(i, (u) => {
      n("update:open", u);
    }), (u, d) => (openBlock(), createBlock(unref(ao), {
      open: i.value,
      "onUpdate:open": d[0] || (d[0] = (p) => i.value = p),
      dir: unref(r),
      modal: unref(s)
    }, {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 8, ["open", "dir", "modal"]));
  }
});
function Wo(a2) {
  return a2.pointerType !== "mouse";
}
var Wv = defineComponent({
  inheritAttrs: false,
  __name: "ContextMenuTrigger",
  props: {
    disabled: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, { disabled: e } = toRefs(t), { forwardRef: n } = R2(), l = Ql(), s = ref({ x: 0, y: 0 }), r = computed(() => ({
      getBoundingClientRect: () => ({
        width: 0,
        height: 0,
        left: s.value.x,
        right: s.value.x,
        top: s.value.y,
        bottom: s.value.y,
        ...s.value
      })
    })), i = ref(0);
    function u() {
      window.clearTimeout(i.value);
    }
    function d(v2) {
      s.value = { x: v2.clientX, y: v2.clientY }, l.onOpenChange(true);
    }
    async function p(v2) {
      e.value || (await nextTick(), v2.defaultPrevented || (u(), d(v2), v2.preventDefault()));
    }
    async function c(v2) {
      e.value || (await nextTick(), Wo(v2) && !v2.defaultPrevented && (u(), i.value = window.setTimeout(() => d(v2), 700)));
    }
    async function f(v2) {
      e.value || (await nextTick(), Wo(v2) && !v2.defaultPrevented && u());
    }
    return (v2, g) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(Ya), {
        as: "template",
        element: r.value
      }, null, 8, ["element"]),
      createVNode(unref(A2), mergeProps({
        ref: unref(n),
        as: v2.as,
        "as-child": v2.asChild,
        "data-state": unref(l).open.value ? "open" : "closed",
        "data-disabled": unref(e) ? "" : void 0,
        style: {
          WebkitTouchCallout: "none"
        }
      }, v2.$attrs, {
        onContextmenu: p,
        onPointerdown: c,
        onPointermove: f,
        onPointercancel: f,
        onPointerup: f
      }), {
        default: withCtx(() => [
          renderSlot(v2.$slots, "default")
        ]),
        _: 3
      }, 16, ["as", "as-child", "data-state", "data-disabled"])
    ], 64));
  }
});
var jv = defineComponent({
  __name: "ContextMenuPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(uo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Uv = defineComponent({
  __name: "ContextMenuContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    alignOffset: { default: 0 },
    avoidCollisions: { type: Boolean, default: true },
    collisionBoundary: { default: () => [] },
    collisionPadding: { default: 0 },
    sticky: { default: "partial" },
    hideWhenDetached: { type: Boolean, default: false },
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    R2();
    const s = Ql(), r = ref(false);
    return (i, u) => (openBlock(), createBlock(unref(ro), mergeProps(unref(l), {
      side: "right",
      "side-offset": 2,
      align: "start",
      style: {
        "--radix-context-menu-content-transform-origin": "var(--radix-popper-transform-origin)",
        "--radix-context-menu-content-available-width": "var(--radix-popper-available-width)",
        "--radix-context-menu-content-available-height": "var(--radix-popper-available-height)",
        "--radix-context-menu-trigger-width": "var(--radix-popper-anchor-width)",
        "--radix-context-menu-trigger-height": "var(--radix-popper-anchor-height)"
      },
      onCloseAutoFocus: u[0] || (u[0] = (d) => {
        !d.defaultPrevented && r.value && d.preventDefault(), r.value = false;
      }),
      onInteractOutside: u[1] || (u[1] = (d) => {
        !d.defaultPrevented && !unref(s).modal.value && (r.value = true);
      })
    }), {
      default: withCtx(() => [
        renderSlot(i.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Gv = defineComponent({
  __name: "ContextMenuArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(to), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var qv = defineComponent({
  __name: "ContextMenuItem",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(wa), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Yv = defineComponent({
  __name: "ContextMenuGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(Za), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Xv = defineComponent({
  __name: "ContextMenuSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(fo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Zv = defineComponent({
  __name: "ContextMenuCheckboxItem",
  props: {
    checked: { type: [Boolean, String] },
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select", "update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(so), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Jv = defineComponent({
  __name: "ContextMenuItemIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(lo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Qv = defineComponent({
  __name: "ContextMenuLabel",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(io), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var em = defineComponent({
  __name: "ContextMenuRadioGroup",
  props: {
    modelValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(co), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var tm = defineComponent({
  __name: "ContextMenuRadioItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(po), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var am = defineComponent({
  __name: "ContextMenuSub",
  props: {
    defaultOpen: { type: Boolean },
    open: { type: Boolean, default: void 0 }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    const l = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    });
    return (s, r) => (openBlock(), createBlock(unref(vo), {
      open: unref(l),
      "onUpdate:open": r[0] || (r[0] = (i) => isRef(l) ? l.value = i : null)
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default", { open: unref(l) })
      ]),
      _: 3
    }, 8, ["open"]));
  }
});
var nm = defineComponent({
  __name: "ContextMenuSubContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    sideOffset: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(mo), mergeProps(unref(l), { style: {
      "--radix-context-menu-content-transform-origin": "var(--radix-popper-transform-origin)",
      "--radix-context-menu-content-available-width": "var(--radix-popper-available-width)",
      "--radix-context-menu-content-available-height": "var(--radix-popper-available-height)",
      "--radix-context-menu-trigger-width": "var(--radix-popper-anchor-width)",
      "--radix-context-menu-trigger-height": "var(--radix-popper-anchor-height)"
    } }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var om = defineComponent({
  __name: "ContextMenuSubTrigger",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(ho), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var wd = ["hour", "minute", "second"];
function Ft(a2) {
  const { formatter: t } = a2, e = Nn.map((n) => [n, a2.value[n]]);
  if ("hour" in a2.value) {
    const n = ml.map((s) => s === "dayPeriod" ? [s, t.dayPeriod($(a2.value))] : [s, a2.value[s]]), l = [...e, ...n];
    return Object.fromEntries(l);
  }
  return Object.fromEntries(e);
}
function es(a2) {
  const t = hl.map((e) => e === "dayPeriod" ? [e, "AM"] : [e, null]).filter(([e]) => e === "literal" || e === null ? false : a2 === "day" ? !wd.includes(e) : true);
  return Object.fromEntries(t);
}
function _d(a2) {
  const { segmentValues: t, formatter: e, locale: n } = a2;
  function l(r) {
    if ("hour" in t) {
      const i = t[r];
      return i !== null ? r === "day" && t.month !== null ? e.part(a2.dateRef.set({ [r]: i, month: t.month }), r, {
        hourCycle: a2.hourCycle === 24 ? "h24" : void 0
      }) : e.part(a2.dateRef.set({ [r]: i }), r, {
        hourCycle: a2.hourCycle === 24 ? "h24" : void 0
      }) : mn(r, "", n.value);
    } else {
      if (Nr(r)) {
        const i = t[r];
        return i !== null ? r === "day" && t.month !== null ? e.part(a2.dateRef.set({ [r]: i, month: t.month }), r) : e.part(a2.dateRef.set({ [r]: i }), r) : mn(r, "", n.value);
      }
      return "";
    }
  }
  return Object.keys(t).reduce((r, i) => {
    if (!yl(i))
      return r;
    if ("hour" in t && i === "dayPeriod") {
      const u = t[i];
      u !== null ? r[i] = u : r[i] = mn(i, "AM", n.value);
    } else
      r[i] = l(i);
    return r;
  }, {});
}
function xd(a2) {
  const { granularity: t, formatter: e, contentObj: n, hideTimeZone: l, hourCycle: s } = a2;
  return e.toParts(a2.dateRef, zr(t, s)).map((u) => ["literal", "timeZoneName", null].includes(u.type) || !yl(u.type) ? {
    part: u.type,
    value: u.value
  } : {
    part: u.type,
    value: n[u.type]
  }).filter((u) => !(u.part === null || u.value === null || u.part === "timeZoneName" && (!m(a2.dateRef) || l)));
}
function $n(a2) {
  const t = _d(a2), e = xd({
    contentObj: t,
    ...a2
  });
  return {
    obj: t,
    arr: e
  };
}
function qe(a2) {
  const t = et();
  return a2 === t.ARROW_RIGHT || a2 === t.ARROW_LEFT;
}
function _t(a2) {
  return !Number.isNaN(Number.parseInt(a2));
}
function st(a2) {
  const t = et();
  return !!([
    t.ENTER,
    t.ARROW_UP,
    t.ARROW_DOWN,
    t.ARROW_LEFT,
    t.ARROW_RIGHT,
    t.BACKSPACE,
    t.SPACE,
    "a",
    "A",
    "p",
    "P"
  ].includes(a2) || _t(a2));
}
var Sd = ["id", "value", "name", "disabled", "required"];
var [Ed, Pd] = Q("DateFieldRoot");
var Dd = defineComponent({
  inheritAttrs: false,
  __name: "DateFieldRoot",
  props: {
    defaultValue: { default: void 0 },
    defaultPlaceholder: {},
    placeholder: { default: void 0 },
    modelValue: {},
    hourCycle: {},
    granularity: {},
    hideTimeZone: { type: Boolean },
    maxValue: {},
    minValue: {},
    locale: { default: "en" },
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    isDateUnavailable: { type: Function, default: void 0 },
    name: {},
    required: { type: Boolean },
    id: {},
    dir: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "update:placeholder"],
  setup(a2, { expose: t, emit: e }) {
    const n = a2, l = e, { locale: s, disabled: r, readonly: i, isDateUnavailable: u, granularity: d, defaultValue: p, dir: c } = toRefs(n), f = Wn(n.locale), v2 = Ce(c), { primitiveElement: g, currentElement: m2 } = Re(), S = ref(/* @__PURE__ */ new Set());
    onMounted(() => {
      Array.from(m2.value.querySelectorAll("[data-radix-vue-date-field-segment]")).filter((z2) => z2.getAttribute("data-radix-vue-date-field-segment") !== "literal").forEach((z2) => S.value.add(z2));
    });
    const x = ae(n, "modelValue", l, {
      defaultValue: p.value,
      passive: n.modelValue === void 0
    }), D = jt({
      defaultPlaceholder: n.placeholder,
      granularity: d.value,
      defaultValue: x.value
    }), h2 = ae(n, "placeholder", l, {
      defaultValue: n.defaultPlaceholder ?? D.copy(),
      passive: n.placeholder === void 0
    }), E = computed(() => n.granularity ? z(h2.value) ? n.granularity : "day" : z(h2.value) ? "minute" : "day"), P2 = computed(() => {
      var z2;
      return x.value ? !!((z2 = u.value) != null && z2.call(u, x.value) || n.minValue && q(x.value, n.minValue) || n.maxValue && q(n.maxValue, x.value)) : false;
    }), $2 = es(E.value), I = ref(x.value ? { ...Ft({ value: x.value, formatter: f }) } : { ...$2 }), k = computed(() => $n({
      granularity: E.value,
      dateRef: h2.value,
      formatter: f,
      hideTimeZone: n.hideTimeZone,
      hourCycle: n.hourCycle,
      segmentValues: I.value,
      locale: s
    })), L = computed(() => k.value.arr), O = computed(() => L.value.filter(({ part: z2 }) => z2 !== "literal"));
    watch(s, (z2) => {
      f.getLocale() !== z2 && f.setLocale(z2);
    }), watch(x, (z2) => {
      z2 !== void 0 && (!$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(h2.value, z2) || h2.value.compare(z2) !== 0) && (h2.value = z2.copy());
    }), watch([x, s], ([z2]) => {
      z2 !== void 0 ? I.value = { ...Ft({ value: z2, formatter: f }) } : I.value = { ...$2 };
    });
    const V2 = ref(null), H2 = computed(() => Array.from(S.value).findIndex((z2) => {
      var Z;
      return z2.getAttribute("data-radix-vue-date-field-segment") === ((Z = V2.value) == null ? void 0 : Z.getAttribute("data-radix-vue-date-field-segment"));
    })), Y = computed(() => {
      const z2 = v2.value === "rtl" ? -1 : 1;
      return (z2 < 0 ? H2.value < 0 : H2.value > S.value.size - 1) ? null : Array.from(S.value)[H2.value + z2];
    }), J2 = computed(() => {
      const z2 = v2.value === "rtl" ? -1 : 1;
      return (z2 > 0 ? H2.value < 0 : H2.value > S.value.size - 1) ? null : Array.from(S.value)[H2.value - z2];
    }), N2 = et();
    function F(z2) {
      var Z, U;
      qe(z2.key) && (z2.key === N2.ARROW_LEFT && ((Z = J2.value) == null || Z.focus()), z2.key === N2.ARROW_RIGHT && ((U = Y.value) == null || U.focus()));
    }
    function W2(z2) {
      V2.value = z2;
    }
    return Pd({
      isDateUnavailable: u.value,
      locale: s,
      modelValue: x,
      placeholder: h2,
      disabled: r,
      formatter: f,
      hourCycle: n.hourCycle,
      readonly: i,
      segmentValues: I,
      isInvalid: P2,
      segmentContents: O,
      elements: S,
      setFocusedElement: W2,
      focusNext() {
        var z2;
        (z2 = Y.value) == null || z2.focus();
      }
    }), t({
      /** Helper to set the focused element inside the DateField */
      setFocusedElement: W2
    }), (z2, Z) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps(z2.$attrs, {
        ref_key: "primitiveElement",
        ref: g,
        role: "group",
        "aria-disabled": unref(r) ? true : void 0,
        "data-disabled": unref(r) ? "" : void 0,
        "data-readonly": unref(i) ? "" : void 0,
        "data-invalid": P2.value ? "" : void 0,
        dir: unref(v2),
        onKeydown: withKeys(F, ["left", "right"])
      }), {
        default: withCtx(() => [
          renderSlot(z2.$slots, "default", {
            modelValue: unref(x),
            segments: L.value,
            isInvalid: P2.value
          })
        ]),
        _: 3
      }, 16, ["aria-disabled", "data-disabled", "data-readonly", "data-invalid", "dir"]),
      createBaseVNode("input", {
        id: z2.id,
        type: "text",
        tabindex: "-1",
        "aria-hidden": "",
        value: unref(x) ? unref(x).toString() : "",
        name: z2.name,
        disabled: unref(r),
        required: z2.required,
        style: {
          transform: "translateX(-100%)",
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        },
        onFocus: Z[0] || (Z[0] = (U) => {
          var X, ee;
          return (ee = (X = Array.from(S.value)) == null ? void 0 : X[0]) == null ? void 0 : ee.focus();
        })
      }, null, 40, Sd)
    ], 64));
  }
});
var kt = {
  role: "spinbutton",
  contenteditable: true,
  tabindex: 0,
  spellcheck: false,
  inputmode: "numeric",
  autocorrect: "off",
  enterkeyhint: "next",
  style: "caret-color: transparent;"
};
function $d(a2) {
  const { segmentValues: t, placeholder: e } = a2, n = t.day === null, l = t.day ? e.set({ day: t.day }) : e, s = l.day, r = 1, i = R(l), u = n ? "Empty" : `${s}`;
  return {
    ...kt,
    "aria-label": "day,",
    "aria-valuemin": r,
    "aria-valuemax": i,
    "aria-valuenow": s,
    "aria-valuetext": u,
    "data-placeholder": n ? "" : void 0
  };
}
function Bd(a2) {
  const { segmentValues: t, placeholder: e, formatter: n } = a2, l = t.month === null, s = t.month ? e.set({ month: t.month }) : e, r = s.month, i = 1, u = 12, d = l ? "Empty" : `${r} - ${n.fullMonth($(s))}`;
  return {
    ...kt,
    "aria-label": "month, ",
    contenteditable: true,
    "aria-valuemin": i,
    "aria-valuemax": u,
    "aria-valuenow": r,
    "aria-valuetext": d,
    "data-placeholder": l ? "" : void 0
  };
}
function Id(a2) {
  const { segmentValues: t, placeholder: e } = a2, n = t.year === null, l = t.year ? e.set({ year: t.year }) : e, s = 1, r = 9999, i = l.year, u = n ? "Empty" : `${i}`;
  return {
    ...kt,
    "aria-label": "year, ",
    "aria-valuemin": s,
    "aria-valuemax": r,
    "aria-valuenow": i,
    "aria-valuetext": u,
    "data-placeholder": n ? "" : void 0
  };
}
function Td(a2) {
  const { segmentValues: t, hourCycle: e, placeholder: n } = a2;
  if (!("hour" in t) || !("hour" in n))
    return {};
  const l = t.hour === null, s = t.hour ? n.set({ hour: t.hour }) : n, r = e === 12 ? 1 : 0, i = e === 12 ? 12 : 23, u = s.hour, d = l ? "Empty" : `${u} ${t.dayPeriod ?? ""}`;
  return {
    ...kt,
    "aria-label": "hour, ",
    "aria-valuemin": r,
    "aria-valuemax": i,
    "aria-valuenow": u,
    "aria-valuetext": d,
    "data-placeholder": l ? "" : void 0
  };
}
function Rd(a2) {
  const { segmentValues: t, placeholder: e } = a2;
  if (!("minute" in t) || !("minute" in e))
    return {};
  const n = t.minute === null, s = (t.minute ? e.set({ minute: t.minute }) : e).minute, r = 0, i = 59, u = n ? "Empty" : `${s}`;
  return {
    ...kt,
    "aria-label": "minute, ",
    "aria-valuemin": r,
    "aria-valuemax": i,
    "aria-valuenow": s,
    "aria-valuetext": u,
    "data-placeholder": n ? "" : void 0
  };
}
function Ad(a2) {
  const { segmentValues: t, placeholder: e } = a2;
  if (!("second" in t) || !("second" in e))
    return {};
  const n = t.second === null, s = (t.second ? e.set({ second: t.second }) : e).second, r = 0, i = 59, u = n ? "Empty" : `${s}`;
  return {
    ...kt,
    "aria-label": "second, ",
    "aria-valuemin": r,
    "aria-valuemax": i,
    "aria-valuenow": s,
    "aria-valuetext": u,
    "data-placeholder": n ? "" : void 0
  };
}
function Od(a2) {
  const { segmentValues: t } = a2;
  if (!("dayPeriod" in t))
    return {};
  const e = 0, n = 12, l = t.hour ? t.hour > 12 ? t.hour - 12 : t.hour : 0, s = t.dayPeriod ?? "AM";
  return {
    ...kt,
    inputmode: "text",
    "aria-label": "AM/PM",
    "aria-valuemin": e,
    "aria-valuemax": n,
    "aria-valuenow": l,
    "aria-valuetext": s
  };
}
function kd(a2) {
  return {
    "aria-hidden": true,
    "data-segment": "literal"
  };
}
function Md(a2) {
  return {
    role: "textbox",
    "aria-label": "timezone, ",
    "data-readonly": true,
    "data-segment": "timeZoneName",
    tabindex: 0,
    style: "caret-color: transparent;"
  };
}
var Vd = {
  day: {
    attrs: $d
  },
  month: {
    attrs: Bd
  },
  year: {
    attrs: Id
  },
  hour: {
    attrs: Td
  },
  minute: {
    attrs: Rd
  },
  second: {
    attrs: Ad
  },
  dayPeriod: {
    attrs: Od
  },
  literal: {
    attrs: kd
  },
  timeZoneName: {
    attrs: Md
  }
};
function ts(a2) {
  const t = et();
  function e({ e: h2, part: E, dateRef: P2, prevValue: $2 }) {
    const I = h2.key === t.ARROW_UP ? 1 : -1, k = 0, L = 59;
    if ($2 === null)
      return I > 0 ? k : L;
    const O = [E, I];
    return P2.set({ [E]: $2 }).cycle(...O)[E];
  }
  function n(h2) {
    if (a2.hasLeftFocus.value = false, h2 === null)
      return h2;
    const E = h2.toString();
    return E.length === 1 ? null : Number.parseInt(E.slice(0, -1));
  }
  function l({ e: h2, part: E, dateRef: P2, prevValue: $2, hourCycle: I }) {
    const k = h2.key === t.ARROW_UP ? 1 : -1;
    if ($2 === null)
      return P2[E];
    if (E === "hour" && "hour" in P2) {
      const O = [E, k, { hourCycle: I }];
      return P2.set({ [E]: $2 }).cycle(...O)[E];
    }
    const L = [E, k];
    return E === "day" && a2.segmentValues.value.month !== null ? P2.set({ [E]: $2, month: a2.segmentValues.value.month }).cycle(...L)[E] : P2.set({ [E]: $2 }).cycle(...L)[E];
  }
  function s(h2, E, P2) {
    let $2 = false;
    const I = Math.floor(h2 / 10);
    if (a2.hasLeftFocus.value && (a2.hasLeftFocus.value = false, P2 = null), P2 === null)
      return E === 0 ? (a2.lastKeyZero.value = true, { value: null, moveToNext: $2 }) : ((a2.lastKeyZero.value || E > I) && ($2 = true), a2.lastKeyZero.value = false, { value: E, moveToNext: $2 });
    const k = P2.toString().length, L = Number.parseInt(P2.toString() + E.toString());
    return k === 2 || L > h2 ? ((E > I || L > h2) && ($2 = true), { value: E, moveToNext: $2 }) : ($2 = true, { value: L, moveToNext: $2 });
  }
  function r(h2, E) {
    let $2 = false;
    const I = Math.floor(59 / 10);
    if (a2.hasLeftFocus.value && (a2.hasLeftFocus.value = false, E = null), E === null)
      return h2 === 0 ? (a2.lastKeyZero.value = true, { value: 0, moveToNext: $2 }) : ((a2.lastKeyZero.value || h2 > I) && ($2 = true), a2.lastKeyZero.value = false, { value: h2, moveToNext: $2 });
    const k = E.toString().length, L = Number.parseInt(E.toString() + h2.toString());
    return k === 2 || L > 59 ? (h2 > I && ($2 = true), { value: h2, moveToNext: $2 }) : ($2 = true, { value: L, moveToNext: $2 });
  }
  function i(h2, E) {
    let $2 = false;
    const I = Math.floor(24 / 10);
    if (a2.hasLeftFocus.value && (a2.hasLeftFocus.value = false, E = null), E === null)
      return h2 === 0 ? (a2.lastKeyZero.value = true, { value: null, moveToNext: $2 }) : ((a2.lastKeyZero.value || h2 > I) && ($2 = true), a2.lastKeyZero.value = false, { value: h2, moveToNext: $2 });
    const k = E.toString().length, L = Number.parseInt(E.toString() + h2.toString());
    return k === 2 || L > 24 ? (h2 > I && ($2 = true), { value: h2, moveToNext: $2 }) : ($2 = true, { value: L, moveToNext: $2 });
  }
  function u(h2, E) {
    let P2 = false;
    if (a2.hasLeftFocus.value && (a2.hasLeftFocus.value = false, E = null), E === null)
      return { value: h2 === 0 ? 1 : h2, moveToNext: P2 };
    const $2 = E.toString() + h2.toString();
    return $2.length > 4 ? { value: h2 === 0 ? 1 : h2, moveToNext: P2 } : ($2.length === 4 && (P2 = true), { value: Number.parseInt($2), moveToNext: P2 });
  }
  const d = computed(() => Vd[a2.part].attrs({
    placeholder: a2.placeholder.value,
    hourCycle: a2.hourCycle,
    segmentValues: a2.segmentValues.value,
    formatter: a2.formatter
  }));
  function p(h2) {
    if (!st(h2.key) || qe(h2.key))
      return;
    const E = a2.segmentValues.value.day;
    if (h2.key === t.ARROW_DOWN || h2.key === t.ARROW_UP) {
      a2.segmentValues.value.day = l({ e: h2, part: "day", dateRef: a2.placeholder.value, prevValue: E });
      return;
    }
    if (_t(h2.key)) {
      const P2 = Number.parseInt(h2.key), $2 = a2.segmentValues.value.month, I = $2 ? R(a2.placeholder.value.set({ month: $2 })) : R(a2.placeholder.value), { value: k, moveToNext: L } = s(I, P2, E);
      a2.segmentValues.value.day = k, L && a2.focusNext();
    }
    h2.key === t.BACKSPACE && (a2.hasLeftFocus.value = false, a2.segmentValues.value.day = n(E));
  }
  function c(h2) {
    if (!st(h2.key) || qe(h2.key))
      return;
    const E = a2.segmentValues.value.month;
    if (h2.key === t.ARROW_DOWN || h2.key === t.ARROW_UP) {
      a2.segmentValues.value.month = l({ e: h2, part: "month", dateRef: a2.placeholder.value, prevValue: E });
      return;
    }
    if (_t(h2.key)) {
      const P2 = Number.parseInt(h2.key), { value: $2, moveToNext: I } = s(12, P2, E);
      a2.segmentValues.value.month = $2, I && a2.focusNext();
    }
    h2.key === t.BACKSPACE && (a2.hasLeftFocus.value = false, a2.segmentValues.value.month = n(E));
  }
  function f(h2) {
    if (!st(h2.key) || qe(h2.key))
      return;
    const E = a2.segmentValues.value.year;
    if (h2.key === t.ARROW_DOWN || h2.key === t.ARROW_UP) {
      a2.segmentValues.value.year = l({ e: h2, part: "year", dateRef: a2.placeholder.value, prevValue: E });
      return;
    }
    if (_t(h2.key)) {
      const P2 = Number.parseInt(h2.key), { value: $2, moveToNext: I } = u(P2, E);
      a2.segmentValues.value.year = $2, I && a2.focusNext();
    }
    h2.key === t.BACKSPACE && (a2.hasLeftFocus.value = false, a2.segmentValues.value.year = n(E));
  }
  function v2(h2) {
    const E = a2.placeholder.value;
    if (!st(h2.key) || qe(h2.key) || !("hour" in E) || !("hour" in a2.segmentValues.value))
      return;
    const P2 = a2.segmentValues.value.hour, $2 = a2.hourCycle;
    if (h2.key === t.ARROW_UP || h2.key === t.ARROW_DOWN) {
      a2.segmentValues.value.hour = l({ e: h2, part: "hour", dateRef: a2.placeholder.value, prevValue: P2, hourCycle: $2 }), "dayPeriod" in a2.segmentValues.value && (a2.segmentValues.value.hour < 12 ? a2.segmentValues.value.dayPeriod = "AM" : a2.segmentValues.value.hour && (a2.segmentValues.value.dayPeriod = "PM"));
      return;
    }
    if (_t(h2.key)) {
      const I = Number.parseInt(h2.key), { value: k, moveToNext: L } = i(I, P2);
      "dayPeriod" in a2.segmentValues.value && k && k > 12 ? a2.segmentValues.value.dayPeriod = "PM" : "dayPeriod" in a2.segmentValues.value && k && (a2.segmentValues.value.dayPeriod = "AM"), a2.segmentValues.value.hour = k, L && a2.focusNext();
    }
    h2.key === t.BACKSPACE && (a2.hasLeftFocus.value = false, a2.segmentValues.value.hour = n(P2));
  }
  function g(h2) {
    const E = a2.placeholder.value;
    if (!st(h2.key) || qe(h2.key) || !("minute" in E) || !("minute" in a2.segmentValues.value))
      return;
    const P2 = a2.segmentValues.value.minute;
    if (a2.segmentValues.value.minute = e({ e: h2, part: "minute", dateRef: a2.placeholder.value, prevValue: P2 }), _t(h2.key)) {
      const $2 = Number.parseInt(h2.key), { value: I, moveToNext: k } = r($2, P2);
      a2.segmentValues.value.minute = I, k && a2.focusNext();
    }
    h2.key === t.BACKSPACE && (a2.hasLeftFocus.value = false, a2.segmentValues.value.minute = n(P2));
  }
  function m2(h2) {
    const E = a2.placeholder.value;
    if (!st(h2.key) || qe(h2.key) || !("second" in E) || !("second" in a2.segmentValues.value))
      return;
    const P2 = a2.segmentValues.value.second;
    if (a2.segmentValues.value.second = e({ e: h2, part: "second", dateRef: a2.placeholder.value, prevValue: P2 }), _t(h2.key)) {
      const $2 = Number.parseInt(h2.key), { value: I, moveToNext: k } = r($2, P2);
      a2.segmentValues.value.second = I, k && a2.focusNext();
    }
    h2.key === t.BACKSPACE && (a2.hasLeftFocus.value = false, a2.segmentValues.value.second = n(P2));
  }
  function S(h2) {
    if (!((!st(h2.key) || qe(h2.key)) && h2.key !== "a" && h2.key !== "p" || !("hour" in a2.placeholder.value) || !("dayPeriod" in a2.segmentValues.value))) {
      if (h2.key === t.ARROW_UP || h2.key === t.ARROW_DOWN) {
        if (a2.segmentValues.value.dayPeriod === "AM") {
          a2.segmentValues.value.dayPeriod = "PM", a2.segmentValues.value.hour = a2.segmentValues.value.hour + 12;
          return;
        }
        a2.segmentValues.value.dayPeriod = "AM", a2.segmentValues.value.hour = a2.segmentValues.value.hour - 12;
        return;
      }
      if (["a", "A"].includes(h2.key) && a2.segmentValues.value.dayPeriod !== "AM") {
        a2.segmentValues.value.dayPeriod = "AM", a2.segmentValues.value.hour = a2.segmentValues.value.hour - 12;
        return;
      }
      ["p", "P"].includes(h2.key) && a2.segmentValues.value.dayPeriod !== "PM" && (a2.segmentValues.value.dayPeriod = "PM", a2.segmentValues.value.hour = a2.segmentValues.value.hour + 12);
    }
  }
  function x(h2) {
    a2.disabled.value && h2.preventDefault();
  }
  function D(h2) {
    const E = a2.disabled.value, P2 = a2.readonly.value;
    if (h2.key !== t.TAB && h2.preventDefault(), E || P2)
      return;
    if ({
      day: p,
      month: c,
      year: f,
      hour: v2,
      minute: g,
      second: m2,
      dayPeriod: S,
      timeZoneName: () => {
      }
    }[a2.part](h2), !qe(h2.key) && h2.key !== t.TAB && h2.key !== t.SHIFT && st(h2.key) && Object.values(a2.segmentValues.value).every((I) => I !== null)) {
      const I = { ...a2.segmentValues.value };
      let k = a2.placeholder.value.copy();
      Object.keys(I).forEach((L) => {
        const O = I[L];
        k = k.set({ [L]: O });
      }), a2.modelValue.value = k.copy();
    }
  }
  return {
    handleSegmentClick: x,
    handleSegmentKeydown: D,
    attributes: d
  };
}
var Fd = defineComponent({
  __name: "DateFieldInput",
  props: {
    part: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Ed(), n = ref(true), l = ref(false), {
      handleSegmentClick: s,
      handleSegmentKeydown: r,
      attributes: i
    } = ts({
      hasLeftFocus: n,
      lastKeyZero: l,
      placeholder: e.placeholder,
      hourCycle: e.hourCycle,
      segmentValues: e.segmentValues,
      formatter: e.formatter,
      part: t.part,
      disabled: e.disabled,
      readonly: e.readonly,
      focusNext: e.focusNext,
      modelValue: e.modelValue
    }), u = computed(() => e.disabled.value), d = computed(() => e.readonly.value), p = computed(() => e.isInvalid.value);
    return (c, f) => (openBlock(), createBlock(unref(A2), mergeProps({
      as: c.as,
      "as-child": c.asChild
    }, unref(i), {
      contenteditable: u.value || d.value ? false : c.part !== "literal",
      "data-radix-vue-date-field-segment": c.part,
      "aria-disabled": u.value ? true : void 0,
      "aria-readonly": d.value ? true : void 0,
      "data-disabled": u.value ? "" : void 0,
      "data-invalid": p.value ? "" : void 0,
      "aria-invalid": p.value ? true : void 0
    }, toHandlers(c.part !== "literal" ? {
      mousedown: unref(s),
      keydown: unref(r),
      focusout: () => {
        n.value = true;
      },
      focusin: (v2) => {
        unref(e).setFocusedElement(v2.target);
      }
    } : {})), {
      default: withCtx(() => [
        renderSlot(c.$slots, "default")
      ]),
      _: 3
    }, 16, ["as", "as-child", "contenteditable", "data-radix-vue-date-field-segment", "aria-disabled", "aria-readonly", "data-disabled", "data-invalid", "aria-invalid"]));
  }
});
var lm = defineComponent({
  __name: "DatePickerHeader",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref($u), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var sm = defineComponent({
  __name: "DatePickerHeading",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Bu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(({ headingValue: l }) => [
        renderSlot(e.$slots, "default", { headingValue: l }, () => [
          createTextVNode(toDisplayString(l), 1)
        ])
      ]),
      _: 3
    }, 16));
  }
});
var rm = defineComponent({
  __name: "DatePickerGrid",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Iu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var im = defineComponent({
  __name: "DatePickerCell",
  props: {
    date: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Tu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var um = defineComponent({
  __name: "DatePickerHeadCell",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Ru), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var dm = defineComponent({
  __name: "DatePickerNext",
  props: {
    step: {},
    nextPage: { type: Function },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Au), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var cm = defineComponent({
  __name: "DatePickerPrev",
  props: {
    step: {},
    prevPage: { type: Function },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Ou), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var pm = defineComponent({
  __name: "DatePickerGridHead",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ku), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var fm = defineComponent({
  __name: "DatePickerGridBody",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Mu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var vm = defineComponent({
  __name: "DatePickerGridRow",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Vu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var mm = defineComponent({
  __name: "DatePickerCellTrigger",
  props: {
    day: {},
    month: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Fu), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var hm = defineComponent({
  __name: "DatePickerInput",
  props: {
    part: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Fd), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [yo, Ld] = Q("DatePickerRoot");
var ym = defineComponent({
  inheritAttrs: false,
  __name: "DatePickerRoot",
  props: {
    defaultValue: { default: void 0 },
    defaultPlaceholder: {},
    placeholder: { default: void 0 },
    modelValue: {},
    hourCycle: {},
    granularity: {},
    hideTimeZone: { type: Boolean },
    maxValue: {},
    minValue: {},
    locale: { default: "en" },
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    isDateUnavailable: { type: Function, default: void 0 },
    name: {},
    required: { type: Boolean },
    id: {},
    dir: {},
    asChild: { type: Boolean },
    as: {},
    defaultOpen: { type: Boolean, default: false },
    open: { type: Boolean, default: void 0 },
    modal: { type: Boolean, default: false },
    isDateDisabled: { type: Function, default: void 0 },
    pagedNavigation: { type: Boolean, default: false },
    weekStartsOn: { default: 0 },
    weekdayFormat: { default: "narrow" },
    fixedWeeks: { type: Boolean, default: false },
    numberOfMonths: { default: 1 },
    preventDeselect: { type: Boolean, default: false }
  },
  emits: ["update:modelValue", "update:placeholder", "update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, {
      locale: l,
      disabled: s,
      readonly: r,
      pagedNavigation: i,
      weekStartsOn: u,
      weekdayFormat: d,
      fixedWeeks: p,
      numberOfMonths: c,
      preventDeselect: f,
      isDateDisabled: v2,
      isDateUnavailable: g,
      defaultOpen: m2,
      modal: S,
      id: x,
      name: D,
      required: h2,
      minValue: E,
      maxValue: P2,
      granularity: $2,
      hideTimeZone: I,
      hourCycle: k,
      defaultValue: L,
      dir: O
    } = toRefs(e), V2 = Ce(O), H2 = ae(e, "modelValue", n, {
      defaultValue: L.value,
      passive: e.modelValue === void 0
    }), Y = computed(() => jt({
      defaultPlaceholder: e.placeholder,
      granularity: e.granularity,
      defaultValue: H2.value
    })), J2 = ae(e, "placeholder", n, {
      defaultValue: e.defaultPlaceholder ?? Y.value.copy(),
      passive: e.placeholder === void 0
    }), N2 = ae(e, "open", n, {
      defaultValue: m2.value,
      passive: e.open === void 0
    }), F = ref();
    return Ld({
      isDateUnavailable: g.value,
      isDateDisabled: v2.value,
      locale: l,
      disabled: s,
      pagedNavigation: i,
      weekStartsOn: u,
      weekdayFormat: d,
      fixedWeeks: p,
      numberOfMonths: c,
      readonly: r,
      preventDeselect: f,
      modelValue: H2,
      placeholder: J2,
      defaultOpen: m2,
      modal: S,
      open: N2,
      id: x,
      name: D,
      required: h2,
      minValue: E,
      maxValue: P2,
      granularity: $2,
      hideTimeZone: I,
      hourCycle: k,
      dateFieldRef: F,
      dir: V2,
      onDateChange(W2) {
        !W2 || !H2.value ? H2.value = W2 : !f.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(H2.value, W2) ? H2.value = void 0 : H2.value = W2.copy();
      },
      onPlaceholderChange(W2) {
        $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(W2, J2.value) || (J2.value = W2.copy());
      }
    }), (W2, z2) => (openBlock(), createBlock(unref(ds), {
      open: unref(N2),
      "onUpdate:open": z2[0] || (z2[0] = (Z) => isRef(N2) ? N2.value = Z : null),
      "default-open": unref(m2),
      modal: unref(S)
    }, {
      default: withCtx(() => [
        renderSlot(W2.$slots, "default")
      ]),
      _: 3
    }, 8, ["open", "default-open", "modal"]));
  }
});
var gm = defineComponent({
  __name: "DatePickerCalendar",
  setup(a2) {
    const t = yo();
    return (e, n) => (openBlock(), createBlock(unref(Du), mergeProps({
      isDateDisabled: unref(t).isDateDisabled,
      isDateUnavailable: unref(t).isDateUnavailable,
      minValue: unref(t).minValue.value,
      maxValue: unref(t).maxValue.value,
      locale: unref(t).locale.value,
      disabled: unref(t).disabled.value,
      pagedNavigation: unref(t).pagedNavigation.value,
      weekStartsOn: unref(t).weekStartsOn.value,
      weekdayFormat: unref(t).weekdayFormat.value,
      fixedWeeks: unref(t).fixedWeeks.value,
      numberOfMonths: unref(t).numberOfMonths.value,
      readonly: unref(t).readonly.value,
      preventDeselect: unref(t).preventDeselect.value,
      dir: unref(t).dir.value
    }, {
      "model-value": unref(t).modelValue.value,
      placeholder: unref(t).placeholder.value,
      "initial-focus": "",
      multiple: false,
      "onUpdate:modelValue": n[0] || (n[0] = (l) => {
        l && unref(t).modelValue.value && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(l, unref(t).modelValue.value) || unref(t).onDateChange(l);
      }),
      "onUpdate:placeholder": n[1] || (n[1] = (l) => {
        unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(l, unref(t).placeholder.value) || unref(t).onPlaceholderChange(l);
      })
    }), {
      default: withCtx(({ weekDays: l, grid: s, date: r, weekStartsOn: i, locale: u, fixedWeeks: d }) => [
        renderSlot(e.$slots, "default", {
          date: r,
          grid: s,
          weekDays: l,
          weekStartsOn: i,
          locale: u,
          fixedWeeks: d
        })
      ]),
      _: 3
    }, 16, ["model-value", "placeholder"]));
  }
});
var bm = defineComponent({
  __name: "DatePickerField",
  setup(a2) {
    const t = yo();
    return (e, n) => (openBlock(), createBlock(unref(Dd), mergeProps({
      ref: unref(t).dateFieldRef,
      "model-value": unref(t).modelValue.value,
      placeholder: unref(t).placeholder.value
    }, {
      id: unref(t).id.value,
      name: unref(t).name.value,
      disabled: unref(t).disabled.value,
      minValue: unref(t).minValue.value,
      maxValue: unref(t).maxValue.value,
      readonly: unref(t).readonly.value,
      hourCycle: unref(t).hourCycle.value,
      granularity: unref(t).granularity.value,
      hideTimeZone: unref(t).hideTimeZone.value,
      locale: unref(t).locale.value,
      isDateUnavailable: unref(t).isDateUnavailable,
      required: unref(t).required.value,
      dir: unref(t).dir.value
    }, {
      "onUpdate:modelValue": n[0] || (n[0] = (l) => {
        l && unref(t).modelValue.value && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(unref(t).modelValue.value, l) && l.compare(unref(t).modelValue.value) === 0 || unref(t).onDateChange(l);
      }),
      "onUpdate:placeholder": n[1] || (n[1] = (l) => {
        unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(unref(t).placeholder.value, l) && l.compare(unref(t).placeholder.value) === 0 || unref(t).onPlaceholderChange(l);
      })
    }), {
      default: withCtx(({ segments: l, modelValue: s }) => [
        renderSlot(e.$slots, "default", {
          segments: l,
          modelValue: s
        })
      ]),
      _: 3
    }, 16, ["model-value", "placeholder"]));
  }
});
var Cm = defineComponent({
  __name: "DatePickerAnchor",
  props: {
    element: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ys), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var wm = defineComponent({
  __name: "DatePickerArrow",
  props: {
    width: {},
    height: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ms), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var _m = defineComponent({
  __name: "DatePickerClose",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(hs), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var xm = defineComponent({
  __name: "DatePickerTrigger",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = yo();
    return (n, l) => (openBlock(), createBlock(unref(cs), mergeProps({ "data-radix-vue-date-field-segment": "trigger" }, t, {
      onFocusin: l[0] || (l[0] = (s) => {
        var r;
        (r = unref(e).dateFieldRef.value) == null || r.setFocusedElement(s.target);
      })
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Sm = defineComponent({
  __name: "DatePickerContent",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return (s, r) => (openBlock(), createBlock(unref(ps), null, {
      default: withCtx(() => [
        createVNode(unref(vs), normalizeProps(guardReactiveProps({ ...unref(l), ...s.$attrs })), {
          default: withCtx(() => [
            renderSlot(s.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }));
  }
});
var Em = defineComponent({
  __name: "DateRangePickerHeader",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Jc), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Pm = defineComponent({
  __name: "DateRangePickerHeading",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(Qc), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(({ headingValue: l }) => [
        renderSlot(e.$slots, "default", { headingValue: l }, () => [
          createTextVNode(toDisplayString(l), 1)
        ])
      ]),
      _: 3
    }, 16));
  }
});
var Dm = defineComponent({
  __name: "DateRangePickerGrid",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ep), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var $m = defineComponent({
  __name: "DateRangePickerCell",
  props: {
    date: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(tp), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Bm = defineComponent({
  __name: "DateRangePickerHeadCell",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ap), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Im = defineComponent({
  __name: "DateRangePickerNext",
  props: {
    step: {},
    nextPage: { type: Function },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(np), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Tm = defineComponent({
  __name: "DateRangePickerPrev",
  props: {
    step: {},
    prevPage: { type: Function },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(op), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Rm = defineComponent({
  __name: "DateRangePickerGridHead",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(lp), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Am = defineComponent({
  __name: "DateRangePickerGridBody",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(sp), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Om = defineComponent({
  __name: "DateRangePickerGridRow",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(rp), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var km = defineComponent({
  __name: "DateRangePickerCellTrigger",
  props: {
    day: {},
    month: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ip), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Mm = defineComponent({
  __name: "DateRangePickerInput",
  props: {
    part: {},
    type: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(jd), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [go, Nd] = Q("DateRangePickerRoot");
var Vm = defineComponent({
  inheritAttrs: false,
  __name: "DateRangePickerRoot",
  props: {
    defaultValue: { default: () => ({ start: void 0, end: void 0 }) },
    defaultPlaceholder: {},
    placeholder: { default: void 0 },
    modelValue: {},
    hourCycle: {},
    granularity: {},
    hideTimeZone: { type: Boolean },
    maxValue: {},
    minValue: {},
    locale: { default: "en" },
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    isDateUnavailable: { type: Function, default: void 0 },
    name: {},
    required: { type: Boolean },
    id: {},
    dir: {},
    asChild: { type: Boolean },
    as: {},
    defaultOpen: { type: Boolean, default: false },
    open: { type: Boolean, default: void 0 },
    modal: { type: Boolean, default: false },
    isDateDisabled: { type: Function, default: void 0 },
    pagedNavigation: { type: Boolean, default: false },
    weekStartsOn: { default: 0 },
    weekdayFormat: { default: "narrow" },
    fixedWeeks: { type: Boolean, default: false },
    numberOfMonths: { default: 1 },
    preventDeselect: { type: Boolean, default: false }
  },
  emits: ["update:modelValue", "update:placeholder", "update:startValue", "update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, {
      locale: l,
      disabled: s,
      readonly: r,
      pagedNavigation: i,
      weekStartsOn: u,
      weekdayFormat: d,
      fixedWeeks: p,
      numberOfMonths: c,
      preventDeselect: f,
      isDateDisabled: v2,
      isDateUnavailable: g,
      defaultOpen: m2,
      modal: S,
      id: x,
      name: D,
      required: h2,
      minValue: E,
      maxValue: P2,
      granularity: $2,
      hideTimeZone: I,
      hourCycle: k,
      dir: L
    } = toRefs(e), O = Ce(L), V2 = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), H2 = jt({
      defaultPlaceholder: e.placeholder,
      granularity: e.granularity,
      defaultValue: V2.value.start
    }), Y = ae(e, "placeholder", n, {
      defaultValue: e.defaultPlaceholder ?? H2.copy(),
      passive: e.placeholder === void 0
    }), J2 = ae(e, "open", n, {
      defaultValue: m2.value,
      passive: e.open === void 0
    }), N2 = ref();
    return Nd({
      isDateUnavailable: g.value,
      isDateDisabled: v2.value,
      locale: l,
      disabled: s,
      pagedNavigation: i,
      weekStartsOn: u,
      weekdayFormat: d,
      fixedWeeks: p,
      numberOfMonths: c,
      readonly: r,
      preventDeselect: f,
      modelValue: V2,
      placeholder: Y,
      defaultOpen: m2,
      modal: S,
      open: J2,
      id: x,
      name: D,
      required: h2,
      minValue: E,
      maxValue: P2,
      granularity: $2,
      hideTimeZone: I,
      hourCycle: k,
      dateFieldRef: N2,
      dir: O,
      onStartValueChange(F) {
        n("update:startValue", F);
      },
      onDateChange(F) {
        var W2, z2;
        V2.value = { start: (W2 = F.start) == null ? void 0 : W2.copy(), end: (z2 = F.end) == null ? void 0 : z2.copy() };
      },
      onPlaceholderChange(F) {
        Y.value = F.copy();
      }
    }), (F, W2) => (openBlock(), createBlock(unref(ds), {
      open: unref(J2),
      "onUpdate:open": W2[0] || (W2[0] = (z2) => isRef(J2) ? J2.value = z2 : null),
      "default-open": unref(m2),
      modal: unref(S)
    }, {
      default: withCtx(() => [
        renderSlot(F.$slots, "default")
      ]),
      _: 3
    }, 8, ["open", "default-open", "modal"]));
  }
});
var Fm = defineComponent({
  __name: "DateRangePickerCalendar",
  setup(a2) {
    const t = go();
    return (e, n) => (openBlock(), createBlock(unref(Zc), mergeProps({
      isDateDisabled: unref(t).isDateDisabled,
      isDateUnavailable: unref(t).isDateUnavailable,
      locale: unref(t).locale.value,
      disabled: unref(t).disabled.value,
      pagedNavigation: unref(t).pagedNavigation.value,
      weekStartsOn: unref(t).weekStartsOn.value,
      weekdayFormat: unref(t).weekdayFormat.value,
      fixedWeeks: unref(t).fixedWeeks.value,
      numberOfMonths: unref(t).numberOfMonths.value,
      readonly: unref(t).readonly.value,
      preventDeselect: unref(t).preventDeselect.value,
      minValue: unref(t).minValue.value,
      maxValue: unref(t).maxValue.value,
      dir: unref(t).dir.value
    }, {
      "initial-focus": "",
      "model-value": unref(t).modelValue.value,
      placeholder: unref(t).placeholder.value,
      "onUpdate:startValue": n[0] || (n[0] = (l) => {
        unref(t).onStartValueChange(l);
      }),
      "onUpdate:modelValue": n[1] || (n[1] = (l) => {
        l.start && unref(t).modelValue.value.start && l.end && unref(t).modelValue.value.end && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(l.start, unref(t).modelValue.value.start) && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(l.end, unref(t).modelValue.value.end) || unref(t).onDateChange(l);
      }),
      "onUpdate:placeholder": n[2] || (n[2] = (l) => {
        unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(l, unref(t).placeholder.value) || unref(t).onPlaceholderChange(l);
      })
    }), {
      default: withCtx(({ weekDays: l, grid: s, date: r, weekStartsOn: i, locale: u, fixedWeeks: d }) => [
        renderSlot(e.$slots, "default", {
          date: r,
          grid: s,
          weekDays: l,
          weekStartsOn: i,
          locale: u,
          fixedWeeks: d
        })
      ]),
      _: 3
    }, 16, ["model-value", "placeholder"]));
  }
});
var Lm = defineComponent({
  __name: "DateRangePickerField",
  setup(a2) {
    const t = go();
    return (e, n) => (openBlock(), createBlock(unref(Wd), mergeProps({
      ref: unref(t).dateFieldRef,
      "model-value": unref(t).modelValue.value,
      placeholder: unref(t).placeholder.value
    }, {
      id: unref(t).id.value,
      name: unref(t).name.value,
      disabled: unref(t).disabled.value,
      minValue: unref(t).minValue.value,
      maxValue: unref(t).maxValue.value,
      readonly: unref(t).readonly.value,
      hourCycle: unref(t).hourCycle.value,
      granularity: unref(t).granularity.value,
      hideTimeZone: unref(t).hideTimeZone.value,
      locale: unref(t).locale.value,
      isDateUnavailable: unref(t).isDateUnavailable,
      required: unref(t).required.value,
      dir: unref(t).dir.value
    }, {
      "onUpdate:modelValue": n[0] || (n[0] = (l) => {
        l.start && unref(t).modelValue.value.start && l.end && unref(t).modelValue.value.end && l.start.compare(unref(t).modelValue.value.start) === 0 && l.end.compare(unref(t).modelValue.value.end) === 0 || unref(t).onDateChange(l);
      }),
      "onUpdate:placeholder": n[1] || (n[1] = (l) => {
        unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(l, unref(t).placeholder.value) && l.compare(unref(t).placeholder.value) === 0 || unref(t).onPlaceholderChange(l);
      })
    }), {
      default: withCtx(({ segments: l, modelValue: s }) => [
        renderSlot(e.$slots, "default", {
          segments: l,
          modelValue: s
        })
      ]),
      _: 3
    }, 16, ["model-value", "placeholder"]));
  }
});
var Nm = defineComponent({
  __name: "DateRangePickerAnchor",
  props: {
    element: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ys), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var zm = defineComponent({
  __name: "DateRangePickerArrow",
  props: {
    width: {},
    height: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ms), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Km = defineComponent({
  __name: "DateRangePickerClose",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(hs), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Hm = defineComponent({
  __name: "DateRangePickerTrigger",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = go();
    return (n, l) => (openBlock(), createBlock(unref(cs), mergeProps({ "data-radix-vue-date-field-segment": "trigger" }, t, {
      onFocusin: l[0] || (l[0] = (s) => {
        var r;
        (r = unref(e).dateFieldRef.value) == null || r.setFocusedElement(s.target);
      })
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Wm = defineComponent({
  __name: "DateRangePickerContent",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return (s, r) => (openBlock(), createBlock(unref(ps), null, {
      default: withCtx(() => [
        createVNode(unref(vs), normalizeProps(guardReactiveProps({ ...unref(l), ...s.$attrs })), {
          default: withCtx(() => [
            renderSlot(s.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }));
  }
});
var zd = ["id", "value", "name", "disabled", "required"];
var [Kd, Hd] = Q("DateRangeFieldRoot");
var Wd = defineComponent({
  inheritAttrs: false,
  __name: "DateRangeFieldRoot",
  props: {
    defaultValue: { default: void 0 },
    defaultPlaceholder: {},
    placeholder: { default: void 0 },
    modelValue: {},
    hourCycle: {},
    granularity: {},
    hideTimeZone: { type: Boolean },
    maxValue: {},
    minValue: {},
    locale: { default: "en" },
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    isDateUnavailable: { type: Function, default: void 0 },
    name: {},
    required: { type: Boolean },
    id: {},
    dir: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "update:placeholder"],
  setup(a2, { expose: t, emit: e }) {
    var ee, fe;
    const n = a2, l = e, { locale: s, disabled: r, readonly: i, isDateUnavailable: u, dir: d } = toRefs(n), p = Wn(n.locale), { primitiveElement: c, currentElement: f } = Re(), v2 = ref(/* @__PURE__ */ new Set()), g = Ce(d);
    onMounted(() => {
      Array.from(f.value.querySelectorAll("[data-radix-vue-date-field-segment]")).filter((G2) => G2.getAttribute("data-radix-vue-date-field-segment") !== "literal").forEach((G2) => v2.value.add(G2));
    });
    const m2 = ae(n, "modelValue", l, {
      defaultValue: n.defaultValue ?? { start: void 0, end: void 0 },
      passive: n.modelValue === void 0
    }), S = jt({
      defaultPlaceholder: n.placeholder,
      granularity: n.granularity,
      defaultValue: m2.value.start
    }), x = ae(n, "placeholder", l, {
      defaultValue: n.defaultPlaceholder ?? S.copy(),
      passive: n.placeholder === void 0
    }), D = computed(() => n.granularity ? z(x.value) ? n.granularity : "day" : z(x.value) ? "minute" : "day"), h2 = computed(() => {
      var G2;
      return m2.value.start ? !!((G2 = u.value) != null && G2.call(u, m2.value.start) || n.minValue && q(m2.value.start, n.minValue) || n.maxValue && q(n.maxValue, m2.value.start)) : false;
    }), E = computed(() => {
      var G2;
      return m2.value.end ? !!((G2 = u.value) != null && G2.call(u, m2.value.end) || n.minValue && q(m2.value.end, n.minValue) || n.maxValue && q(n.maxValue, m2.value.end)) : false;
    }), P2 = computed(() => h2.value || E.value ? true : !m2.value.start || !m2.value.end ? false : !q(m2.value.start, m2.value.end) || u.value !== void 0 && !b(
      m2.value.start,
      m2.value.end,
      u.value,
      void 0
    )), $2 = es(D.value), I = ref(m2.value.start ? { ...Ft({ value: m2.value.start, formatter: p }) } : { ...$2 }), k = ref(m2.value.end ? { ...Ft({ value: m2.value.end, formatter: p }) } : { ...$2 }), L = computed(() => $n({
      granularity: D.value,
      dateRef: x.value,
      formatter: p,
      hideTimeZone: n.hideTimeZone,
      hourCycle: n.hourCycle,
      segmentValues: I.value,
      locale: s
    })), O = computed(() => $n({
      granularity: D.value,
      dateRef: x.value,
      formatter: p,
      hideTimeZone: n.hideTimeZone,
      hourCycle: n.hourCycle,
      segmentValues: k.value,
      locale: s
    })), V2 = computed(() => ({
      start: L.value.arr,
      end: O.value.arr
    })), H2 = computed(() => ({ start: V2.value.start.filter(({ part: G2 }) => G2 !== "literal"), end: V2.value.end.filter(({ part: G2 }) => G2 !== "literal") })), Y = ref((ee = m2.value.start) == null ? void 0 : ee.copy()), J2 = ref((fe = m2.value.end) == null ? void 0 : fe.copy());
    watch([Y, J2], ([G2, oe]) => {
      var we, ge;
      const he = m2.value;
      if (!(he.start && he.end && G2 && oe && he.start.compare(G2) === 0 && he.end.compare(oe) === 0))
        if (G2 && oe) {
          if (((we = m2.value.start) == null ? void 0 : we.compare(G2)) === 0 && ((ge = m2.value.end) == null ? void 0 : ge.compare(oe)) === 0)
            return;
          m2.value = { start: G2.copy(), end: oe.copy() };
        } else m2.value.start && m2.value.end && (m2.value = { start: void 0, end: void 0 });
    }), watch(m2, (G2) => {
      G2.start && G2.end && ((!Y.value || G2.start.compare(Y.value) !== 0) && (Y.value = G2.start.copy()), (!J2.value || G2.end.compare(J2.value) !== 0) && (J2.value = G2.end.copy()));
    }), watch([Y, s], ([G2]) => {
      G2 !== void 0 ? I.value = { ...Ft({ value: G2, formatter: p }) } : I.value = { ...$2 };
    }), watch(s, (G2) => {
      p.getLocale() !== G2 && p.setLocale(G2);
    }), watch(m2, (G2) => {
      G2.start !== void 0 && (!$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(x.value, G2.start) || x.value.compare(G2.start) !== 0) && (x.value = G2.start.copy());
    }), watch([J2, s], ([G2]) => {
      G2 !== void 0 ? k.value = { ...Ft({ value: G2, formatter: p }) } : k.value = { ...$2 };
    });
    const N2 = ref(null), F = computed(() => Array.from(v2.value).findIndex((G2) => {
      var oe, he;
      return G2.getAttribute("data-radix-vue-date-field-segment") === ((oe = N2.value) == null ? void 0 : oe.getAttribute("data-radix-vue-date-field-segment")) && G2.getAttribute("data-radix-vue-date-range-field-segment-type") === ((he = N2.value) == null ? void 0 : he.getAttribute("data-radix-vue-date-range-field-segment-type"));
    })), W2 = computed(() => {
      const G2 = g.value === "rtl" ? -1 : 1;
      return (G2 < 0 ? F.value < 0 : F.value > v2.value.size - 1) ? null : Array.from(v2.value)[F.value + G2];
    }), z2 = computed(() => {
      const G2 = g.value === "rtl" ? -1 : 1;
      return (G2 > 0 ? F.value < 0 : F.value > v2.value.size - 1) ? null : Array.from(v2.value)[F.value - G2];
    }), Z = et();
    function U(G2) {
      var oe, he;
      qe(G2.key) && (G2.key === Z.ARROW_LEFT && ((oe = z2.value) == null || oe.focus()), G2.key === Z.ARROW_RIGHT && ((he = W2.value) == null || he.focus()));
    }
    function X(G2) {
      N2.value = G2;
    }
    return Hd({
      isDateUnavailable: u.value,
      locale: s,
      startValue: Y,
      endValue: J2,
      placeholder: x,
      disabled: r,
      formatter: p,
      hourCycle: n.hourCycle,
      readonly: i,
      segmentValues: { start: I, end: k },
      isInvalid: P2,
      segmentContents: H2,
      elements: v2,
      setFocusedElement: X,
      focusNext() {
        var G2;
        (G2 = W2.value) == null || G2.focus();
      }
    }), t({
      setFocusedElement: X
    }), (G2, oe) => {
      var he, we;
      return openBlock(), createElementBlock(Fragment, null, [
        createVNode(unref(A2), mergeProps(G2.$attrs, {
          ref_key: "primitiveElement",
          ref: c,
          role: "group",
          "aria-disabled": unref(r) ? true : void 0,
          "data-disabled": unref(r) ? "" : void 0,
          "data-readonly": unref(i) ? "" : void 0,
          "data-invalid": P2.value ? "" : void 0,
          dir: unref(g),
          onKeydown: withKeys(U, ["left", "right"])
        }), {
          default: withCtx(() => [
            renderSlot(G2.$slots, "default", {
              modelValue: unref(m2),
              segments: V2.value
            })
          ]),
          _: 3
        }, 16, ["aria-disabled", "data-disabled", "data-readonly", "data-invalid", "dir"]),
        createBaseVNode("input", {
          id: G2.id,
          type: "text",
          tabindex: "-1",
          "aria-hidden": "",
          value: `${(he = unref(m2).start) == null ? void 0 : he.toString()} - ${(we = unref(m2).end) == null ? void 0 : we.toString()}`,
          name: G2.name,
          disabled: unref(r),
          required: G2.required,
          style: {
            transform: "translateX(-100%)",
            position: "absolute",
            pointerEvents: "none",
            opacity: 0,
            margin: 0
          },
          onFocus: oe[0] || (oe[0] = (ge) => {
            var De, ue;
            return (ue = (De = Array.from(v2.value)) == null ? void 0 : De[0]) == null ? void 0 : ue.focus();
          })
        }, null, 40, zd)
      ], 64);
    };
  }
});
var jd = defineComponent({
  __name: "DateRangeFieldInput",
  props: {
    part: {},
    type: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Kd(), n = ref(true), l = ref(false), {
      handleSegmentClick: s,
      handleSegmentKeydown: r,
      attributes: i
    } = ts({
      hasLeftFocus: n,
      lastKeyZero: l,
      placeholder: e.placeholder,
      hourCycle: e.hourCycle,
      segmentValues: e.segmentValues[t.type],
      formatter: e.formatter,
      part: t.part,
      disabled: e.disabled,
      readonly: e.readonly,
      focusNext: e.focusNext,
      modelValue: t.type === "start" ? e.startValue : e.endValue
    }), u = computed(() => e.disabled.value), d = computed(() => e.readonly.value), p = computed(() => e.isInvalid.value);
    return (c, f) => (openBlock(), createBlock(unref(A2), mergeProps({
      as: c.as,
      "as-child": c.asChild
    }, unref(i), {
      contenteditable: u.value || d.value ? false : c.part !== "literal",
      "data-radix-vue-date-field-segment": c.part,
      "aria-disabled": u.value ? true : void 0,
      "aria-readonly": d.value ? true : void 0,
      "data-disabled": u.value ? "" : void 0,
      "data-radix-vue-date-range-field-segment-type": c.type,
      "data-invalid": p.value ? "" : void 0,
      "aria-invalid": p.value ? true : void 0
    }, toHandlers(c.part !== "literal" ? {
      mousedown: unref(s),
      keydown: unref(r),
      focusout: () => {
        n.value = true;
      },
      focusin: (v2) => {
        unref(e).setFocusedElement(v2.target);
      }
    } : {})), {
      default: withCtx(() => [
        renderSlot(c.$slots, "default")
      ]),
      _: 3
    }, 16, ["as", "as-child", "contenteditable", "data-radix-vue-date-field-segment", "aria-disabled", "aria-readonly", "data-disabled", "data-radix-vue-date-range-field-segment-type", "data-invalid", "aria-invalid"]));
  }
});
var [as, Ud] = Q("DropdownMenuRoot");
var jm = defineComponent({
  __name: "DropdownMenuRoot",
  props: {
    defaultOpen: { type: Boolean },
    open: { type: Boolean, default: void 0 },
    dir: {},
    modal: { type: Boolean, default: true }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    const l = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    }), s = ref(), { modal: r, dir: i } = toRefs(e), u = Ce(i);
    return Ud({
      open: l,
      onOpenChange: (d) => {
        l.value = d;
      },
      onOpenToggle: () => {
        l.value = !l.value;
      },
      triggerId: "",
      triggerElement: s,
      contentId: "",
      modal: r,
      dir: u
    }), (d, p) => (openBlock(), createBlock(unref(ao), {
      open: unref(l),
      "onUpdate:open": p[0] || (p[0] = (c) => isRef(l) ? l.value = c : null),
      dir: unref(u),
      modal: unref(r)
    }, {
      default: withCtx(() => [
        renderSlot(d.$slots, "default", { open: unref(l) })
      ]),
      _: 3
    }, 8, ["open", "dir", "modal"]));
  }
});
var Um = defineComponent({
  __name: "DropdownMenuTrigger",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = as(), { forwardRef: n, currentElement: l } = R2();
    return onMounted(() => {
      e.triggerElement = l;
    }), e.triggerId || (e.triggerId = me(void 0, "radix-vue-dropdown-menu-trigger")), (s, r) => (openBlock(), createBlock(unref(Ya), { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          id: unref(e).triggerId,
          ref: unref(n),
          type: s.as === "button" ? "button" : void 0,
          "as-child": t.asChild,
          as: s.as,
          "aria-haspopup": "menu",
          "aria-expanded": unref(e).open.value,
          "aria-controls": unref(e).open.value ? unref(e).contentId : void 0,
          "data-disabled": s.disabled ? "" : void 0,
          disabled: s.disabled,
          "data-state": unref(e).open.value ? "open" : "closed",
          onClick: r[0] || (r[0] = async (i) => {
            var u;
            !s.disabled && i.button === 0 && i.ctrlKey === false && ((u = unref(e)) == null || u.onOpenToggle(), await nextTick(), unref(e).open.value && i.preventDefault());
          }),
          onKeydown: r[1] || (r[1] = withKeys(
            (i) => {
              s.disabled || (["Enter", " "].includes(i.key) && unref(e).onOpenToggle(), i.key === "ArrowDown" && unref(e).onOpenChange(true), ["Enter", " ", "ArrowDown"].includes(i.key) && i.preventDefault());
            },
            ["enter", "space", "arrow-down"]
          ))
        }, {
          default: withCtx(() => [
            renderSlot(s.$slots, "default")
          ]),
          _: 3
        }, 8, ["id", "type", "as-child", "as", "aria-expanded", "aria-controls", "data-disabled", "disabled", "data-state"])
      ]),
      _: 3
    }));
  }
});
var Gm = defineComponent({
  __name: "DropdownMenuPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(uo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var qm = defineComponent({
  __name: "DropdownMenuContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    R2();
    const s = as(), r = ref(false);
    function i(u) {
      u.defaultPrevented || (r.value || setTimeout(() => {
        var d;
        (d = s.triggerElement.value) == null || d.focus();
      }, 0), r.value = false, u.preventDefault());
    }
    return s.contentId || (s.contentId = me(void 0, "radix-vue-dropdown-menu-content")), (u, d) => {
      var p;
      return openBlock(), createBlock(unref(ro), mergeProps(unref(l), {
        id: unref(s).contentId,
        "aria-labelledby": (p = unref(s)) == null ? void 0 : p.triggerId,
        style: {
          "--radix-dropdown-menu-content-transform-origin": "var(--radix-popper-transform-origin)",
          "--radix-dropdown-menu-content-available-width": "var(--radix-popper-available-width)",
          "--radix-dropdown-menu-content-available-height": "var(--radix-popper-available-height)",
          "--radix-dropdown-menu-trigger-width": "var(--radix-popper-anchor-width)",
          "--radix-dropdown-menu-trigger-height": "var(--radix-popper-anchor-height)"
        },
        onCloseAutoFocus: i,
        onInteractOutside: d[0] || (d[0] = (c) => {
          var m2;
          if (c.defaultPrevented) return;
          const f = c.detail.originalEvent, v2 = f.button === 0 && f.ctrlKey === true, g = f.button === 2 || v2;
          (!unref(s).modal.value || g) && (r.value = true), (m2 = unref(s).triggerElement.value) != null && m2.contains(c.target) && c.preventDefault();
        })
      }), {
        default: withCtx(() => [
          renderSlot(u.$slots, "default")
        ]),
        _: 3
      }, 16, ["id", "aria-labelledby"]);
    };
  }
});
var Ym = defineComponent({
  __name: "DropdownMenuArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(to), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Xm = defineComponent({
  __name: "DropdownMenuItem",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(wa), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Zm = defineComponent({
  __name: "DropdownMenuGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(Za), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Jm = defineComponent({
  __name: "DropdownMenuSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(fo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Qm = defineComponent({
  __name: "DropdownMenuCheckboxItem",
  props: {
    checked: { type: [Boolean, String] },
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select", "update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(so), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var eh = defineComponent({
  __name: "DropdownMenuItemIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(lo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var th = defineComponent({
  __name: "DropdownMenuLabel",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(io), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var ah = defineComponent({
  __name: "DropdownMenuRadioGroup",
  props: {
    modelValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(co), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var nh = defineComponent({
  __name: "DropdownMenuRadioItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(po), normalizeProps(guardReactiveProps(unref(l))), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var oh = defineComponent({
  __name: "DropdownMenuSub",
  props: {
    defaultOpen: { type: Boolean },
    open: { type: Boolean, default: void 0 }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "open", t, {
      passive: e.open === void 0,
      defaultValue: e.defaultOpen ?? false
    });
    return R2(), (s, r) => (openBlock(), createBlock(unref(vo), {
      open: unref(l),
      "onUpdate:open": r[0] || (r[0] = (i) => isRef(l) ? l.value = i : null)
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default", { open: unref(l) })
      ]),
      _: 3
    }, 8, ["open"]));
  }
});
var lh = defineComponent({
  __name: "DropdownMenuSubContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    sideOffset: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(mo), mergeProps(unref(l), { style: {
      "--radix-dropdown-menu-content-transform-origin": "var(--radix-popper-transform-origin)",
      "--radix-dropdown-menu-content-available-width": "var(--radix-popper-available-width)",
      "--radix-dropdown-menu-content-available-height": "var(--radix-popper-available-height)",
      "--radix-dropdown-menu-trigger-width": "var(--radix-popper-anchor-width)",
      "--radix-dropdown-menu-trigger-height": "var(--radix-popper-anchor-height)"
    } }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var sh = defineComponent({
  __name: "DropdownMenuSubTrigger",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(ho), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Gd = ["value", "name", "disabled", "required"];
var [Jt, qd] = Q("EditableRoot");
var rh = defineComponent({
  inheritAttrs: false,
  __name: "EditableRoot",
  props: {
    defaultValue: {},
    modelValue: {},
    placeholder: { default: "Enter text..." },
    dir: {},
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean },
    activationMode: { default: "focus" },
    selectOnFocus: { type: Boolean, default: false },
    submitMode: { default: "blur" },
    startWithEditMode: { type: Boolean },
    maxLength: {},
    autoResize: { type: Boolean, default: false },
    id: {},
    name: {},
    required: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  emits: ["update:modelValue", "submit", "update:state"],
  setup(a2, { expose: t, emit: e }) {
    const n = a2, l = e, {
      id: s,
      name: r,
      defaultValue: i,
      startWithEditMode: u,
      placeholder: d,
      maxLength: p,
      disabled: c,
      dir: f,
      submitMode: v2,
      activationMode: g,
      selectOnFocus: m2,
      readonly: S,
      autoResize: x,
      required: D
    } = toRefs(n), h2 = ref(), E = Ce(f), P2 = ref(u.value ?? false), $2 = ae(n, "modelValue", l, {
      defaultValue: i.value ?? "",
      passive: n.modelValue === void 0
    }), { primitiveElement: I, currentElement: k } = Re(), L = Qe(k), O = computed(() => typeof d.value == "string" ? { edit: d.value, preview: d.value } : d.value), V2 = ref($2.value);
    function H2() {
      $2.value = V2.value, P2.value = false, l("update:state", "cancel");
    }
    function Y() {
      P2.value = true, l("update:state", "edit");
    }
    function J2() {
      V2.value = $2.value, P2.value = false, l("update:state", "submit"), l("submit", $2.value);
    }
    function N2() {
      P2.value && (v2.value === "blur" || v2.value === "both" ? J2() : H2());
    }
    const F = Ml(() => N2(), k), W2 = Vl(() => N2(), k), z2 = computed(() => $2.value === "");
    return t({
      /** Function to submit the value of the editable */
      submit: J2,
      /** Function to cancel the value of the editable */
      cancel: H2,
      /** Function to set the editable in edit mode */
      edit: Y
    }), qd({
      id: s,
      name: r,
      disabled: c,
      isEditing: P2,
      maxLength: p,
      modelValue: $2,
      placeholder: O,
      edit: Y,
      cancel: H2,
      submit: J2,
      activationMode: g,
      submitMode: v2,
      selectOnFocus: m2,
      inputRef: h2,
      startWithEditMode: u,
      isEmpty: z2,
      readonly: S,
      autoResize: x
    }), (Z, U) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps(Z.$attrs, {
        ref_key: "primitiveElement",
        ref: I,
        as: Z.as,
        "as-child": Z.asChild,
        dir: unref(E),
        onFocusCapture: unref(W2).onFocusCapture,
        onBlurCapture: unref(W2).onBlurCapture,
        onPointerdownCapture: unref(F).onPointerDownCapture
      }), {
        default: withCtx(() => [
          renderSlot(Z.$slots, "default", {
            modelValue: unref($2),
            isEditing: P2.value,
            isEmpty: z2.value,
            submit: J2,
            cancel: H2,
            edit: Y
          })
        ]),
        _: 3
      }, 16, ["as", "as-child", "dir", "onFocusCapture", "onBlurCapture", "onPointerdownCapture"]),
      unref(L) ? (openBlock(), createElementBlock("input", {
        key: 0,
        type: "text",
        tabindex: "-1",
        "aria-hidden": "",
        value: unref($2),
        name: unref(r),
        disabled: unref(c),
        required: unref(D),
        style: {
          transform: "translateX(-100%)",
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        }
      }, null, 8, Gd)) : createCommentVNode("", true)
    ], 64));
  }
});
var ih = defineComponent({
  __name: "EditableArea",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = Jt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "data-placeholder-shown": unref(e).isEditing.value ? void 0 : "",
      "data-focus": unref(e).isEditing.value ? "" : void 0,
      "data-focused": unref(e).isEditing.value ? "" : void 0,
      "data-empty": unref(e).isEmpty.value ? "" : void 0,
      "data-readonly": unref(e).readonly.value ? "" : void 0,
      "data-disabled": unref(e).disabled.value ? "" : void 0,
      style: unref(e).autoResize.value ? { display: "inline-grid" } : void 0
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["data-placeholder-shown", "data-focus", "data-focused", "data-empty", "data-readonly", "data-disabled", "style"]));
  }
});
var uh = defineComponent({
  __name: "EditableInput",
  props: {
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  setup(a2) {
    const t = a2, e = et(), n = Jt(), l = computed(() => n.disabled.value), s = computed(() => {
      var d;
      return (d = n.placeholder.value) == null ? void 0 : d.edit;
    }), { primitiveElement: r, currentElement: i } = Re();
    onMounted(() => {
      var d, p;
      n.inputRef.value = i.value, n.startWithEditMode.value && ((d = n.inputRef.value) == null || d.focus({ preventScroll: true }), n.selectOnFocus.value && ((p = n.inputRef.value) == null || p.select()));
    }), watch(n.isEditing, (d) => {
      d && nextTick(() => {
        var p, c;
        (p = n.inputRef.value) == null || p.focus({ preventScroll: true }), n.selectOnFocus.value && ((c = n.inputRef.value) == null || c.select());
      });
    });
    function u(d) {
      (n.submitMode.value === "enter" || n.submitMode.value === "both") && d.key === e.ENTER && !d.shiftKey && !d.metaKey && n.submit();
    }
    return (d, p) => (openBlock(), createBlock(unref(A2), mergeProps({
      ref_key: "primitiveElement",
      ref: r
    }, t, {
      value: unref(n).modelValue.value,
      placeholder: s.value,
      disabled: l.value,
      "data-disabled": l.value ? "" : void 0,
      "data-readonly": unref(n).readonly.value ? "" : void 0,
      readonly: unref(n).readonly.value,
      "aria-label": "editable input",
      hidden: unref(n).autoResize.value ? void 0 : !unref(n).isEditing.value,
      style: unref(n).autoResize.value ? { all: "unset", gridArea: "1 / 1 / auto / auto", visibility: unref(n).isEditing.value ? void 0 : "hidden" } : void 0,
      onInput: p[0] || (p[0] = (c) => unref(n).modelValue.value = c.target.value),
      onKeydown: [
        withKeys(u, ["enter", "space"]),
        withKeys(unref(n).cancel, ["esc"])
      ]
    }), {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 16, ["value", "placeholder", "disabled", "data-disabled", "data-readonly", "readonly", "hidden", "style", "onKeydown"]));
  }
});
var dh = defineComponent({
  __name: "EditablePreview",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, e = Jt(), n = computed(() => {
      var r;
      return (r = e.placeholder.value) == null ? void 0 : r.preview;
    });
    function l() {
      e.activationMode.value === "focus" && e.edit();
    }
    function s() {
      e.activationMode.value === "dblclick" && e.edit();
    }
    return (r, i) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      tabindex: "0",
      "data-placeholder-shown": unref(e).isEditing.value ? void 0 : "",
      hidden: unref(e).autoResize.value ? void 0 : unref(e).isEditing.value,
      style: unref(e).autoResize.value ? {
        whiteSpace: "pre",
        userSelect: "none",
        gridArea: "1 / 1 / auto / auto",
        visibility: unref(e).isEditing.value ? "hidden" : void 0,
        overflow: "hidden",
        textOverflow: "ellipsis"
      } : void 0,
      onFocusin: l,
      onDblclick: s
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(unref(e).modelValue.value || n.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["data-placeholder-shown", "hidden", "style"]));
  }
});
var ch = defineComponent({
  __name: "EditableSubmitTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Jt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "submit",
      "aria-disabled": unref(e).disabled.value ? "" : void 0,
      "data-disabled": unref(e).disabled.value ? "" : void 0,
      disabled: unref(e).disabled.value,
      type: n.as === "button" ? "button" : void 0,
      hidden: unref(e).isEditing.value ? void 0 : "",
      onClick: unref(e).submit
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Submit")
        ])
      ]),
      _: 3
    }, 16, ["aria-disabled", "data-disabled", "disabled", "type", "hidden", "onClick"]));
  }
});
var ph = defineComponent({
  __name: "EditableCancelTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Jt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "cancel",
      "aria-disabled": unref(e).disabled.value ? "" : void 0,
      "data-disabled": unref(e).disabled.value ? "" : void 0,
      disabled: unref(e).disabled.value,
      type: n.as === "button" ? "button" : void 0,
      hidden: unref(e).isEditing.value ? void 0 : "",
      onClick: unref(e).cancel
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Cancel")
        ])
      ]),
      _: 3
    }, 16, ["aria-disabled", "data-disabled", "disabled", "type", "hidden", "onClick"]));
  }
});
var fh = defineComponent({
  __name: "EditableEditTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Jt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "edit",
      "aria-disabled": unref(e).disabled.value ? "" : void 0,
      "data-disabled": unref(e).disabled.value ? "" : void 0,
      disabled: unref(e).disabled.value,
      type: n.as === "button" ? "button" : void 0,
      hidden: unref(e).isEditing.value ? "" : void 0,
      onClick: unref(e).edit
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Edit")
        ])
      ]),
      _: 3
    }, 16, ["aria-disabled", "data-disabled", "disabled", "type", "hidden", "onClick"]));
  }
});
var [bo, Yd] = Q("HoverCardRoot");
var vh = defineComponent({
  __name: "HoverCardRoot",
  props: {
    defaultOpen: { type: Boolean, default: false },
    open: { type: Boolean, default: void 0 },
    openDelay: { default: 700 },
    closeDelay: { default: 300 }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { openDelay: l, closeDelay: s } = toRefs(e);
    R2();
    const r = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    }), i = ref(0), u = ref(0), d = ref(false), p = ref(false), c = ref(false), f = ref();
    function v2() {
      clearTimeout(u.value), i.value = window.setTimeout(() => r.value = true, l.value);
    }
    function g() {
      clearTimeout(i.value), !d.value && !p.value && (u.value = window.setTimeout(() => r.value = false, s.value));
    }
    function m2() {
      r.value = false;
    }
    return Yd({
      open: r,
      onOpenChange(S) {
        r.value = S;
      },
      onOpen: v2,
      onClose: g,
      onDismiss: m2,
      hasSelectionRef: d,
      isPointerDownOnContentRef: p,
      isPointerInTransitRef: c,
      triggerElement: f
    }), (S, x) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        renderSlot(S.$slots, "default", { open: unref(r) })
      ]),
      _: 3
    }));
  }
});
function Bn(a2) {
  return (t) => t.pointerType === "touch" ? void 0 : a2();
}
function Xd(a2) {
  const t = [], e = document.createTreeWalker(a2, NodeFilter.SHOW_ELEMENT, {
    acceptNode: (n) => n.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP
  });
  for (; e.nextNode(); ) t.push(e.currentNode);
  return t;
}
var mh = defineComponent({
  __name: "HoverCardTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "a" }
  },
  setup(a2) {
    const { forwardRef: t, currentElement: e } = R2(), n = bo();
    n.triggerElement = e;
    function l() {
      setTimeout(() => {
        !n.isPointerInTransitRef.value && !n.open.value && n.onClose();
      }, 0);
    }
    return (s, r) => (openBlock(), createBlock(unref(Tt), { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(t),
          "as-child": s.asChild,
          as: s.as,
          "data-state": unref(n).open.value ? "open" : "closed",
          "data-grace-area-trigger": "",
          onPointerenter: r[0] || (r[0] = (i) => unref(Bn)(unref(n).onOpen)(i)),
          onPointerleave: r[1] || (r[1] = (i) => unref(Bn)(l)(i)),
          onFocus: r[2] || (r[2] = (i) => unref(n).onOpen()),
          onBlur: r[3] || (r[3] = (i) => unref(n).onClose())
        }, {
          default: withCtx(() => [
            renderSlot(s.$slots, "default")
          ]),
          _: 3
        }, 8, ["as-child", "as", "data-state"])
      ]),
      _: 3
    }));
  }
});
var hh = defineComponent({
  __name: "HoverCardPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Zd = defineComponent({
  __name: "HoverCardContentImpl",
  props: {
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Bt(e), { forwardRef: s, currentElement: r } = R2(), i = bo(), { isPointerInTransit: u, onPointerExit: d } = $l(i.triggerElement, r);
    ti(i.isPointerInTransitRef, u, { direction: "rtl" }), d(() => {
      i.onClose();
    });
    const p = ref(false);
    let c;
    watchEffect((v2) => {
      if (p.value) {
        const g = document.body;
        c = g.style.userSelect || g.style.webkitUserSelect, g.style.userSelect = "none", g.style.webkitUserSelect = "none", v2(() => {
          g.style.userSelect = c, g.style.webkitUserSelect = c;
        });
      }
    });
    function f() {
      p.value = false, i.isPointerDownOnContentRef.value = false, nextTick(() => {
        var g;
        ((g = document.getSelection()) == null ? void 0 : g.toString()) !== "" && (i.hasSelectionRef.value = true);
      });
    }
    return onMounted(() => {
      r.value && (document.addEventListener("pointerup", f), Xd(r.value).forEach((g) => g.setAttribute("tabindex", "-1")));
    }), onUnmounted(() => {
      document.removeEventListener("pointerup", f), i.hasSelectionRef.value = false, i.isPointerDownOnContentRef.value = false;
    }), (v2, g) => (openBlock(), createBlock(unref(yt), {
      "as-child": "",
      "disable-outside-pointer-events": false,
      onEscapeKeyDown: g[1] || (g[1] = (m2) => n("escapeKeyDown", m2)),
      onPointerDownOutside: g[2] || (g[2] = (m2) => n("pointerDownOutside", m2)),
      onFocusOutside: g[3] || (g[3] = withModifiers((m2) => n("focusOutside", m2), ["prevent"])),
      onDismiss: unref(i).onDismiss
    }, {
      default: withCtx(() => [
        createVNode(unref(Pt), mergeProps({ ...unref(l), ...v2.$attrs }, {
          ref: unref(s),
          "data-state": unref(i).open.value ? "open" : "closed",
          style: {
            userSelect: p.value ? "text" : void 0,
            // Safari requires prefix
            WebkitUserSelect: p.value ? "text" : void 0,
            // re-namespace exposed content custom properties
            "--radix-hover-card-content-transform-origin": "var(--radix-popper-transform-origin)",
            "--radix-hover-card-content-available-width": "var(--radix-popper-available-width)",
            "--radix-hover-card-content-available-height": "var(--radix-popper-available-height)",
            "--radix-hover-card-trigger-width": "var(--radix-popper-anchor-width)",
            "--radix-hover-card-trigger-height": "var(--radix-popper-anchor-height)"
          },
          onPointerdown: g[0] || (g[0] = (m2) => {
            m2.currentTarget.contains(m2.target) && (p.value = true), unref(i).hasSelectionRef.value = false, unref(i).isPointerDownOnContentRef.value = true;
          })
        }), {
          default: withCtx(() => [
            renderSlot(v2.$slots, "default")
          ]),
          _: 3
        }, 16, ["data-state", "style"])
      ]),
      _: 3
    }, 8, ["onDismiss"]));
  }
});
var yh = defineComponent({
  __name: "HoverCardContent",
  props: {
    forceMount: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t), { forwardRef: s } = R2(), r = bo();
    return (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(r).open.value
    }, {
      default: withCtx(() => [
        createVNode(Zd, mergeProps(unref(l), {
          ref: unref(s),
          onPointerenter: u[0] || (u[0] = (d) => unref(Bn)(unref(r).onOpen)(d))
        }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var gh = defineComponent({
  __name: "HoverCardArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(qt), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var bh = defineComponent({
  __name: "Label",
  props: {
    for: {},
    asChild: { type: Boolean },
    as: { default: "label" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      onMousedown: n[0] || (n[0] = (l) => {
        !l.defaultPrevented && l.detail > 1 && l.preventDefault();
      })
    }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
function Jd(a2) {
  return a2 == null ? void 0 : a2.querySelector("[data-state=checked]");
}
function Qd(a2, t, e) {
  return a2 === void 0 ? false : Array.isArray(a2) ? a2.some((n) => Ht(n, t, e)) : Ht(a2, t, e);
}
function Ht(a2, t, e) {
  return a2 === void 0 || t === void 0 ? false : typeof a2 == "string" ? a2 === t : typeof e == "function" ? e(a2, t) : typeof e == "string" ? (a2 == null ? void 0 : a2[e]) === (t == null ? void 0 : t[e]) : Ye(a2, t);
}
var [Ja, ec] = Q("ListboxRoot");
var Ch = defineComponent({
  __name: "ListboxRoot",
  props: {
    modelValue: {},
    defaultValue: {},
    multiple: { type: Boolean },
    orientation: { default: "vertical" },
    dir: {},
    disabled: { type: Boolean },
    selectionBehavior: { default: "toggle" },
    highlightOnHover: { type: Boolean },
    by: {},
    name: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "highlight", "entryFocus", "leave"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { multiple: l, highlightOnHover: s, orientation: r, disabled: i, selectionBehavior: u, dir: d } = toRefs(e), { getItems: p } = ga(), { handleTypeaheadSearch: c } = ya(), { primitiveElement: f, currentElement: v2 } = Re(), g = et(), m2 = Ce(d), S = Qe(v2), x = ref(), D = ref(false), h2 = ref(true), E = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue ?? (l.value ? [] : void 0),
      passive: e.modelValue === void 0,
      deep: true
    });
    function P2(U) {
      if (D.value = true, Array.isArray(E.value)) {
        const X = E.value.findIndex((ee) => Ht(ee, U, e.by));
        if (e.selectionBehavior === "toggle") {
          const ee = [...E.value];
          X === -1 ? ee.push(U) : ee.splice(X, 1), E.value = ee;
        } else
          E.value = [U], x.value = U;
      } else
        e.selectionBehavior === "toggle" && Ht(E.value, U, e.by) ? E.value = void 0 : E.value = U;
      setTimeout(() => {
        D.value = false;
      }, 1);
    }
    const $2 = ref(null), I = ref(null), k = ref(false), L = ra(), O = ra();
    function V2() {
      return p().map((U) => U.ref).filter((U) => U.dataset.disabled !== "");
    }
    function H2(U) {
      $2.value = U, $2.value.focus(), $2.value.scrollIntoView({ block: "nearest" });
      const X = p().find((ee) => ee.ref === U);
      n("highlight", X);
    }
    function Y(U) {
      $2.value && $2.value.click();
    }
    function J2(U) {
      if (D.value = true, k.value)
        O.trigger(U);
      else {
        const X = U.altKey || U.ctrlKey || U.metaKey;
        if (X && U.key === "a" && l.value) {
          const ee = p(), fe = ee.map((G2) => G2.value);
          E.value = [...fe], U.preventDefault(), H2(ee[ee.length - 1].ref);
        } else if (!X) {
          const ee = c(U.key, V2());
          ee && H2(ee);
        }
      }
      setTimeout(() => {
        D.value = false;
      }, 1);
    }
    function N2(U) {
      I.value = $2.value, $2.value = null, n("leave", U);
    }
    function F(U) {
      var ee, fe;
      const X = new CustomEvent("listbox.entryFocus", { bubbles: false, cancelable: true });
      if ((ee = U.currentTarget) == null || ee.dispatchEvent(X), n("entryFocus", X), !X.defaultPrevented)
        if (I.value)
          H2(I.value);
        else {
          const G2 = (fe = V2()) == null ? void 0 : fe[0];
          H2(G2);
        }
    }
    function W2(U) {
      const X = ql(U, r.value, m2.value);
      if (!X)
        return;
      let ee = V2();
      if ($2.value) {
        if (X === "last")
          ee.reverse();
        else if (X === "prev" || X === "next") {
          X === "prev" && ee.reverse();
          const fe = ee.indexOf($2.value);
          ee = ee.slice(fe + 1);
        }
        z2(U, ee[0]);
      }
      if (ee.length) {
        const fe = !$2.value && X === "prev" ? ee.length - 1 : 0;
        H2(ee[fe]);
      }
      if (k.value)
        return O.trigger(U);
    }
    function z2(U, X) {
      var fe;
      if (!(k.value || e.selectionBehavior !== "replace" || !l.value || !Array.isArray(E.value) || (U.altKey || U.ctrlKey || U.metaKey) && !U.shiftKey) && U.shiftKey) {
        const G2 = p().filter((we) => we.ref.dataset.disabled !== "");
        let oe = (fe = G2.find((we) => we.ref === X)) == null ? void 0 : fe.value;
        if (U.key === g.END ? oe = G2[G2.length - 1].value : U.key === g.HOME && (oe = G2[0].value), !oe || !x.value)
          return;
        const he = St(G2.map((we) => we.value), x.value, oe);
        E.value = he;
      }
    }
    async function Z(U) {
      if (k.value)
        L.trigger(U);
      else {
        await nextTick();
        const ee = V2().find((fe) => fe.dataset.state === "checked");
        ee && H2(ee);
      }
    }
    return watch(E, () => {
      D.value || nextTick(() => {
        Z();
      });
    }, { immediate: true, deep: true }), ec({
      modelValue: E,
      // @ts-expect-error ignoring
      onValueChange: P2,
      multiple: l,
      orientation: r,
      dir: m2,
      disabled: i,
      highlightOnHover: s,
      highlightedElement: $2,
      isVirtual: k,
      virtualFocusHook: L,
      virtualKeydownHook: O,
      by: e.by,
      firstValue: x,
      selectionBehavior: u,
      focusable: h2,
      onLeave: N2,
      onEnter: F,
      onChangeHighlight: H2,
      onKeydownEnter: Y,
      onKeydownNavigation: W2,
      onKeydownTypeAhead: J2
    }), (U, X) => (openBlock(), createBlock(unref(A2), {
      ref_key: "primitiveElement",
      ref: f,
      as: U.as,
      "as-child": U.asChild,
      dir: unref(m2),
      "data-disabled": unref(i) ? "" : void 0,
      onPointerleave: N2,
      onFocusout: X[0] || (X[0] = (ee) => {
        const fe = ee.relatedTarget || ee.target;
        $2.value && !unref(v2).contains(fe) && N2(ee);
      })
    }, {
      default: withCtx(() => [
        renderSlot(U.$slots, "default", { modelValue: unref(E) }),
        unref(S) && e.name ? (openBlock(), createBlock(unref(Qn), {
          key: 0,
          name: e.name,
          value: unref(E)
        }, null, 8, ["name", "value"])) : createCommentVNode("", true)
      ]),
      _: 3
    }, 8, ["as", "as-child", "dir", "data-disabled"]));
  }
});
var wh = defineComponent({
  __name: "ListboxContent",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = Ja(), e = Dt(false, 10);
    return (n, l) => (openBlock(), createBlock(unref(ba), null, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          role: "listbox",
          as: n.as,
          "as-child": n.asChild,
          tabindex: unref(t).focusable.value ? unref(t).highlightedElement.value ? "-1" : "0" : void 0,
          "data-orientation": unref(t).orientation.value,
          onMousedown: l[0] || (l[0] = withModifiers((s) => e.value = true, ["left"])),
          onFocus: l[1] || (l[1] = (s) => {
            unref(e) || unref(t).onEnter(s);
          }),
          onKeydown: [
            l[2] || (l[2] = withKeys(withModifiers((s) => {
              unref(t).focusable.value && unref(t).onKeydownNavigation(s);
            }, ["prevent"]), ["down", "up", "home", "end"])),
            withKeys(unref(t).onKeydownEnter, ["enter"]),
            unref(t).onKeydownTypeAhead
          ]
        }, {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 8, ["as", "as-child", "tabindex", "data-orientation", "onKeydown"])
      ]),
      _: 3
    }));
  }
});
var _h = defineComponent({
  __name: "ListboxFilter",
  props: {
    modelValue: {},
    autoFocus: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "modelValue", t, {
      defaultValue: "",
      passive: e.modelValue === void 0
    }), s = Ja();
    s.focusable.value = false;
    const { primitiveElement: r, currentElement: i } = Re();
    return onMounted(() => {
      setTimeout(() => {
        var u;
        e.autoFocus && ((u = i.value) == null || u.focus());
      }, 1);
    }), (u, d) => (openBlock(), createBlock(unref(A2), {
      ref_key: "primitiveElement",
      ref: r,
      as: u.as,
      "as-child": u.asChild,
      value: unref(l),
      disabled: unref(s).disabled.value ? "" : void 0,
      "data-disabled": unref(s).disabled.value ? "" : void 0,
      type: "text",
      onKeydown: [
        withKeys(withModifiers(unref(s).onKeydownNavigation, ["prevent"]), ["down", "up", "home", "end"]),
        withKeys(unref(s).onKeydownEnter, ["enter"])
      ],
      onInput: d[0] || (d[0] = (p) => {
        l.value = p.target.value;
      })
    }, {
      default: withCtx(() => [
        renderSlot(u.$slots, "default", { modelValue: unref(l) })
      ]),
      _: 3
    }, 8, ["as", "as-child", "value", "disabled", "data-disabled", "onKeydown"]));
  }
});
var tc = "listbox.select";
var [ac, nc] = Q("ListboxItem");
var xh = defineComponent({
  __name: "ListboxItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l, currentElement: s } = R2(), r = me(void 0, "radix-vue-listbox-item"), i = Ja(), u = computed(() => s.value === i.highlightedElement.value), d = computed(() => Qd(i.modelValue.value, e.value, i.by)), p = computed(() => i.disabled.value || e.disabled);
    async function c(v2) {
      n("select", v2), !(v2 != null && v2.defaultPrevented) && !p.value && v2 && (i.onValueChange(e.value), i.onChangeHighlight(v2.target));
    }
    function f(v2) {
      const g = { originalEvent: v2, value: e.value };
      zt(tc, c, g);
    }
    return nc({
      isSelected: d
    }), (v2, g) => (openBlock(), createBlock(unref(Xt), { value: v2.value }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          id: unref(r),
          ref: unref(l),
          role: "option",
          tabindex: unref(i).focusable.value ? u.value ? "0" : "-1" : void 0,
          "aria-selected": d.value,
          as: v2.as,
          "as-child": v2.asChild,
          disabled: p.value ? "" : void 0,
          "data-disabled": p.value ? "" : void 0,
          "data-highlighted": u.value ? "" : void 0,
          "data-state": d.value ? "checked" : "unchecked",
          onClick: f,
          onKeydown: withKeys(withModifiers(f, ["prevent"]), ["space"]),
          onPointermove: g[0] || (g[0] = (m2) => {
            unref(i).highlightOnHover.value ? unref(i).onChangeHighlight(unref(s)) : unref(i).focusable.value || unref(i).onChangeHighlight(unref(s));
          })
        }, {
          default: withCtx(() => [
            renderSlot(v2.$slots, "default")
          ]),
          _: 3
        }, 8, ["id", "tabindex", "aria-selected", "as", "as-child", "disabled", "data-disabled", "data-highlighted", "data-state", "onKeydown"])
      ]),
      _: 3
    }, 8, ["value"]));
  }
});
var Sh = defineComponent({
  __name: "ListboxItemIndicator",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = ac();
    return (n, l) => unref(e).isSelected.value ? (openBlock(), createBlock(unref(A2), mergeProps({
      key: 0,
      "aria-hidden": ""
    }, t), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
function aa(a2, t, e) {
  let n = e.initialDeps ?? [], l;
  return () => {
    var s, r, i, u;
    let d;
    e.key && ((s = e.debug) != null && s.call(e)) && (d = Date.now());
    const p = a2();
    if (!(p.length !== n.length || p.some((v2, g) => n[g] !== v2)))
      return l;
    n = p;
    let f;
    if (e.key && ((r = e.debug) != null && r.call(e)) && (f = Date.now()), l = t(...p), e.key && ((i = e.debug) != null && i.call(e))) {
      const v2 = Math.round((Date.now() - d) * 100) / 100, g = Math.round((Date.now() - f) * 100) / 100, m2 = g / 16, S = (x, D) => {
        for (x = String(x); x.length < D; )
          x = " " + x;
        return x;
      };
      console.info(
        `%c⏱ ${S(g, 5)} /${S(v2, 5)} ms`,
        `
            font-size: .6rem;
            font-weight: bold;
            color: hsl(${Math.max(
          0,
          Math.min(120 - 120 * m2, 120)
        )}deg 100% 31%);`,
        e == null ? void 0 : e.key
      );
    }
    return (u = e == null ? void 0 : e.onChange) == null || u.call(e, l), l;
  };
}
function wn(a2, t) {
  if (a2 === void 0)
    throw new Error("Unexpected undefined");
  return a2;
}
var oc = (a2, t) => Math.abs(a2 - t) < 1;
var lc = (a2, t, e) => {
  let n;
  return function(...l) {
    a2.clearTimeout(n), n = a2.setTimeout(() => t.apply(this, l), e);
  };
};
var sc = (a2) => a2;
var rc = (a2) => {
  const t = Math.max(a2.startIndex - a2.overscan, 0), e = Math.min(a2.endIndex + a2.overscan, a2.count - 1), n = [];
  for (let l = t; l <= e; l++)
    n.push(l);
  return n;
};
var ic = (a2, t) => {
  const e = a2.scrollElement;
  if (!e)
    return;
  const n = a2.targetWindow;
  if (!n)
    return;
  const l = (r) => {
    const { width: i, height: u } = r;
    t({ width: Math.round(i), height: Math.round(u) });
  };
  if (l(e.getBoundingClientRect()), !n.ResizeObserver)
    return () => {
    };
  const s = new n.ResizeObserver((r) => {
    const i = r[0];
    if (i != null && i.borderBoxSize) {
      const u = i.borderBoxSize[0];
      if (u) {
        l({ width: u.inlineSize, height: u.blockSize });
        return;
      }
    }
    l(e.getBoundingClientRect());
  });
  return s.observe(e, { box: "border-box" }), () => {
    s.unobserve(e);
  };
};
var jo = {
  passive: true
};
var uc = typeof window > "u" ? true : "onscrollend" in window;
var dc = (a2, t) => {
  const e = a2.scrollElement;
  if (!e)
    return;
  const n = a2.targetWindow;
  if (!n)
    return;
  let l = 0;
  const s = uc ? () => {
  } : lc(
    n,
    () => {
      t(l, false);
    },
    a2.options.isScrollingResetDelay
  ), r = (d) => () => {
    l = e[a2.options.horizontal ? "scrollLeft" : "scrollTop"], s(), t(l, d);
  }, i = r(true), u = r(false);
  return u(), e.addEventListener("scroll", i, jo), e.addEventListener("scrollend", u, jo), () => {
    e.removeEventListener("scroll", i), e.removeEventListener("scrollend", u);
  };
};
var cc = (a2, t, e) => {
  if (t != null && t.borderBoxSize) {
    const n = t.borderBoxSize[0];
    if (n)
      return Math.round(
        n[e.options.horizontal ? "inlineSize" : "blockSize"]
      );
  }
  return Math.round(
    a2.getBoundingClientRect()[e.options.horizontal ? "width" : "height"]
  );
};
var pc = (a2, {
  adjustments: t = 0,
  behavior: e
}, n) => {
  var l, s;
  const r = a2 + t;
  (s = (l = n.scrollElement) == null ? void 0 : l.scrollTo) == null || s.call(l, {
    [n.options.horizontal ? "left" : "top"]: r,
    behavior: e
  });
};
var fc = class {
  constructor(t) {
    this.unsubs = [], this.scrollElement = null, this.targetWindow = null, this.isScrolling = false, this.scrollToIndexTimeoutId = null, this.measurementsCache = [], this.itemSizeCache = /* @__PURE__ */ new Map(), this.pendingMeasuredCacheIndexes = [], this.scrollRect = null, this.scrollOffset = null, this.scrollDirection = null, this.scrollAdjustments = 0, this.elementsCache = /* @__PURE__ */ new Map(), this.observer = /* @__PURE__ */ (() => {
      let e = null;
      const n = () => e || (!this.targetWindow || !this.targetWindow.ResizeObserver ? null : e = new this.targetWindow.ResizeObserver((l) => {
        l.forEach((s) => {
          this._measureElement(s.target, s);
        });
      }));
      return {
        disconnect: () => {
          var l;
          return (l = n()) == null ? void 0 : l.disconnect();
        },
        observe: (l) => {
          var s;
          return (s = n()) == null ? void 0 : s.observe(l, { box: "border-box" });
        },
        unobserve: (l) => {
          var s;
          return (s = n()) == null ? void 0 : s.unobserve(l);
        }
      };
    })(), this.range = null, this.setOptions = (e) => {
      Object.entries(e).forEach(([n, l]) => {
        typeof l > "u" && delete e[n];
      }), this.options = {
        debug: false,
        initialOffset: 0,
        overscan: 1,
        paddingStart: 0,
        paddingEnd: 0,
        scrollPaddingStart: 0,
        scrollPaddingEnd: 0,
        horizontal: false,
        getItemKey: sc,
        rangeExtractor: rc,
        onChange: () => {
        },
        measureElement: cc,
        initialRect: { width: 0, height: 0 },
        scrollMargin: 0,
        gap: 0,
        indexAttribute: "data-index",
        initialMeasurementsCache: [],
        lanes: 1,
        isScrollingResetDelay: 150,
        enabled: true,
        ...e
      };
    }, this.notify = (e, n) => {
      var l, s;
      const { startIndex: r, endIndex: i } = this.range ?? {
        startIndex: void 0,
        endIndex: void 0
      }, u = this.calculateRange();
      (e || r !== (u == null ? void 0 : u.startIndex) || i !== (u == null ? void 0 : u.endIndex)) && ((s = (l = this.options).onChange) == null || s.call(l, this, n));
    }, this.cleanup = () => {
      this.unsubs.filter(Boolean).forEach((e) => e()), this.unsubs = [], this.scrollElement = null, this.targetWindow = null, this.observer.disconnect(), this.elementsCache.clear();
    }, this._didMount = () => () => {
      this.cleanup();
    }, this._willUpdate = () => {
      var e;
      const n = this.options.enabled ? this.options.getScrollElement() : null;
      if (this.scrollElement !== n) {
        if (this.cleanup(), !n) {
          this.notify(false, false);
          return;
        }
        this.scrollElement = n, this.scrollElement && "ownerDocument" in this.scrollElement ? this.targetWindow = this.scrollElement.ownerDocument.defaultView : this.targetWindow = ((e = this.scrollElement) == null ? void 0 : e.window) ?? null, this._scrollToOffset(this.getScrollOffset(), {
          adjustments: void 0,
          behavior: void 0
        }), this.unsubs.push(
          this.options.observeElementRect(this, (l) => {
            this.scrollRect = l, this.notify(false, false);
          })
        ), this.unsubs.push(
          this.options.observeElementOffset(this, (l, s) => {
            this.scrollAdjustments = 0, this.scrollDirection = s ? this.getScrollOffset() < l ? "forward" : "backward" : null, this.scrollOffset = l;
            const r = this.isScrolling;
            this.isScrolling = s, this.notify(r !== s, s);
          })
        );
      }
    }, this.getSize = () => this.options.enabled ? (this.scrollRect = this.scrollRect ?? this.options.initialRect, this.scrollRect[this.options.horizontal ? "width" : "height"]) : (this.scrollRect = null, 0), this.getScrollOffset = () => this.options.enabled ? (this.scrollOffset = this.scrollOffset ?? (typeof this.options.initialOffset == "function" ? this.options.initialOffset() : this.options.initialOffset), this.scrollOffset) : (this.scrollOffset = null, 0), this.getFurthestMeasurement = (e, n) => {
      const l = /* @__PURE__ */ new Map(), s = /* @__PURE__ */ new Map();
      for (let r = n - 1; r >= 0; r--) {
        const i = e[r];
        if (l.has(i.lane))
          continue;
        const u = s.get(
          i.lane
        );
        if (u == null || i.end > u.end ? s.set(i.lane, i) : i.end < u.end && l.set(i.lane, true), l.size === this.options.lanes)
          break;
      }
      return s.size === this.options.lanes ? Array.from(s.values()).sort((r, i) => r.end === i.end ? r.index - i.index : r.end - i.end)[0] : void 0;
    }, this.getMeasurementOptions = aa(
      () => [
        this.options.count,
        this.options.paddingStart,
        this.options.scrollMargin,
        this.options.getItemKey,
        this.options.enabled
      ],
      (e, n, l, s, r) => (this.pendingMeasuredCacheIndexes = [], {
        count: e,
        paddingStart: n,
        scrollMargin: l,
        getItemKey: s,
        enabled: r
      }),
      {
        key: false
      }
    ), this.getMeasurements = aa(
      () => [this.getMeasurementOptions(), this.itemSizeCache],
      ({ count: e, paddingStart: n, scrollMargin: l, getItemKey: s, enabled: r }, i) => {
        var u;
        if (!r)
          return this.measurementsCache = [], this.itemSizeCache.clear(), [];
        this.measurementsCache.length === 0 && (this.measurementsCache = this.options.initialMeasurementsCache, this.measurementsCache.forEach((c) => {
          this.itemSizeCache.set(c.key, c.size);
        }));
        const d = this.pendingMeasuredCacheIndexes.length > 0 ? Math.min(...this.pendingMeasuredCacheIndexes) : 0;
        this.pendingMeasuredCacheIndexes = [];
        const p = this.measurementsCache.slice(0, d);
        for (let c = d; c < e; c++) {
          let f = (u = this.measurementsCache[c]) == null ? void 0 : u.measureElement;
          f || (f = (E) => {
            const P2 = s(c), $2 = this.elementsCache.get(P2);
            if (!E) {
              $2 && (this.observer.unobserve($2), this.elementsCache.delete(P2));
              return;
            }
            $2 !== E && ($2 && this.observer.unobserve($2), this.observer.observe(E), this.elementsCache.set(P2, E)), E.isConnected && this.resizeItem(
              c,
              this.options.measureElement(E, void 0, this)
            );
          });
          const v2 = s(c), g = this.options.lanes === 1 ? p[c - 1] : this.getFurthestMeasurement(p, c), m2 = g ? g.end + this.options.gap : n + l, S = i.get(v2), x = typeof S == "number" ? S : this.options.estimateSize(c), D = m2 + x, h2 = g ? g.lane : c % this.options.lanes;
          p[c] = {
            index: c,
            start: m2,
            size: x,
            end: D,
            key: v2,
            lane: h2,
            measureElement: f
          };
        }
        return this.measurementsCache = p, p;
      },
      {
        key: "getMeasurements",
        debug: () => this.options.debug
      }
    ), this.calculateRange = aa(
      () => [this.getMeasurements(), this.getSize(), this.getScrollOffset()],
      (e, n, l) => this.range = e.length > 0 && n > 0 ? vc({
        measurements: e,
        outerSize: n,
        scrollOffset: l
      }) : null,
      {
        key: "calculateRange",
        debug: () => this.options.debug
      }
    ), this.getIndexes = aa(
      () => [
        this.options.rangeExtractor,
        this.calculateRange(),
        this.options.overscan,
        this.options.count
      ],
      (e, n, l, s) => n === null ? [] : e({
        startIndex: n.startIndex,
        endIndex: n.endIndex,
        overscan: l,
        count: s
      }),
      {
        key: "getIndexes",
        debug: () => this.options.debug
      }
    ), this.indexFromElement = (e) => {
      const n = this.options.indexAttribute, l = e.getAttribute(n);
      return l ? parseInt(l, 10) : (console.warn(
        `Missing attribute name '${n}={index}' on measured element.`
      ), -1);
    }, this._measureElement = (e, n) => {
      const l = this.indexFromElement(e), s = this.getMeasurements()[l];
      if (!s || !e.isConnected) {
        this.elementsCache.forEach((i, u) => {
          i === e && (this.observer.unobserve(e), this.elementsCache.delete(u));
        });
        return;
      }
      const r = this.elementsCache.get(s.key);
      r !== e && (r && this.observer.unobserve(r), this.observer.observe(e), this.elementsCache.set(s.key, e)), this.resizeItem(l, this.options.measureElement(e, n, this));
    }, this.resizeItem = (e, n) => {
      const l = this.getMeasurements()[e];
      if (!l)
        return;
      const s = this.itemSizeCache.get(l.key) ?? l.size, r = n - s;
      r !== 0 && ((this.shouldAdjustScrollPositionOnItemSizeChange !== void 0 ? this.shouldAdjustScrollPositionOnItemSizeChange(l, r, this) : l.start < this.getScrollOffset() + this.scrollAdjustments) && (this.options.debug && console.info("correction", r), this._scrollToOffset(this.getScrollOffset(), {
        adjustments: this.scrollAdjustments += r,
        behavior: void 0
      })), this.pendingMeasuredCacheIndexes.push(l.index), this.itemSizeCache = new Map(this.itemSizeCache.set(l.key, n)), this.notify(true, false));
    }, this.measureElement = (e) => {
      e && this._measureElement(e, void 0);
    }, this.getVirtualItems = aa(
      () => [this.getIndexes(), this.getMeasurements()],
      (e, n) => {
        const l = [];
        for (let s = 0, r = e.length; s < r; s++) {
          const i = e[s], u = n[i];
          l.push(u);
        }
        return l;
      },
      {
        key: "getIndexes",
        debug: () => this.options.debug
      }
    ), this.getVirtualItemForOffset = (e) => {
      const n = this.getMeasurements();
      if (n.length !== 0)
        return wn(
          n[ns(
            0,
            n.length - 1,
            (l) => wn(n[l]).start,
            e
          )]
        );
    }, this.getOffsetForAlignment = (e, n) => {
      const l = this.getSize(), s = this.getScrollOffset();
      n === "auto" && (e <= s ? n = "start" : e >= s + l ? n = "end" : n = "start"), n === "start" ? e = e : n === "end" ? e = e - l : n === "center" && (e = e - l / 2);
      const r = this.options.horizontal ? "scrollWidth" : "scrollHeight", u = (this.scrollElement ? "document" in this.scrollElement ? this.scrollElement.document.documentElement[r] : this.scrollElement[r] : 0) - l;
      return Math.max(Math.min(u, e), 0);
    }, this.getOffsetForIndex = (e, n = "auto") => {
      e = Math.max(0, Math.min(e, this.options.count - 1));
      const l = this.getMeasurements()[e];
      if (!l)
        return;
      const s = this.getSize(), r = this.getScrollOffset();
      if (n === "auto")
        if (l.end >= r + s - this.options.scrollPaddingEnd)
          n = "end";
        else if (l.start <= r + this.options.scrollPaddingStart)
          n = "start";
        else
          return [r, n];
      const i = n === "end" ? l.end + this.options.scrollPaddingEnd : l.start - this.options.scrollPaddingStart;
      return [this.getOffsetForAlignment(i, n), n];
    }, this.isDynamicMode = () => this.elementsCache.size > 0, this.cancelScrollToIndex = () => {
      this.scrollToIndexTimeoutId !== null && this.targetWindow && (this.targetWindow.clearTimeout(this.scrollToIndexTimeoutId), this.scrollToIndexTimeoutId = null);
    }, this.scrollToOffset = (e, { align: n = "start", behavior: l } = {}) => {
      this.cancelScrollToIndex(), l === "smooth" && this.isDynamicMode() && console.warn(
        "The `smooth` scroll behavior is not fully supported with dynamic size."
      ), this._scrollToOffset(this.getOffsetForAlignment(e, n), {
        adjustments: void 0,
        behavior: l
      });
    }, this.scrollToIndex = (e, { align: n = "auto", behavior: l } = {}) => {
      e = Math.max(0, Math.min(e, this.options.count - 1)), this.cancelScrollToIndex(), l === "smooth" && this.isDynamicMode() && console.warn(
        "The `smooth` scroll behavior is not fully supported with dynamic size."
      );
      const s = this.getOffsetForIndex(e, n);
      if (!s) return;
      const [r, i] = s;
      this._scrollToOffset(r, { adjustments: void 0, behavior: l }), l !== "smooth" && this.isDynamicMode() && this.targetWindow && (this.scrollToIndexTimeoutId = this.targetWindow.setTimeout(() => {
        if (this.scrollToIndexTimeoutId = null, this.elementsCache.has(
          this.options.getItemKey(e)
        )) {
          const [d] = wn(
            this.getOffsetForIndex(e, i)
          );
          oc(d, this.getScrollOffset()) || this.scrollToIndex(e, { align: i, behavior: l });
        } else
          this.scrollToIndex(e, { align: i, behavior: l });
      }));
    }, this.scrollBy = (e, { behavior: n } = {}) => {
      this.cancelScrollToIndex(), n === "smooth" && this.isDynamicMode() && console.warn(
        "The `smooth` scroll behavior is not fully supported with dynamic size."
      ), this._scrollToOffset(this.getScrollOffset() + e, {
        adjustments: void 0,
        behavior: n
      });
    }, this.getTotalSize = () => {
      var e;
      const n = this.getMeasurements();
      let l;
      return n.length === 0 ? l = this.options.paddingStart : l = this.options.lanes === 1 ? ((e = n[n.length - 1]) == null ? void 0 : e.end) ?? 0 : Math.max(
        ...n.slice(-this.options.lanes).map((s) => s.end)
      ), l - this.options.scrollMargin + this.options.paddingEnd;
    }, this._scrollToOffset = (e, {
      adjustments: n,
      behavior: l
    }) => {
      this.options.scrollToFn(e, { behavior: l, adjustments: n }, this);
    }, this.measure = () => {
      var e, n;
      this.itemSizeCache = /* @__PURE__ */ new Map(), (n = (e = this.options).onChange) == null || n.call(e, this, false);
    }, this.setOptions(t);
  }
};
var ns = (a2, t, e, n) => {
  for (; a2 <= t; ) {
    const l = (a2 + t) / 2 | 0, s = e(l);
    if (s < n)
      a2 = l + 1;
    else if (s > n)
      t = l - 1;
    else
      return l;
  }
  return a2 > 0 ? a2 - 1 : 0;
};
function vc({
  measurements: a2,
  outerSize: t,
  scrollOffset: e
}) {
  const n = a2.length - 1, s = ns(0, n, (i) => a2[i].start, e);
  let r = s;
  for (; r < n && a2[r].end < e + t; )
    r++;
  return { startIndex: s, endIndex: r };
}
function mc(a2) {
  const t = new fc(unref(a2)), e = shallowRef(t), n = t._didMount();
  return watch(
    () => unref(a2).getScrollElement(),
    (l) => {
      l && t._willUpdate();
    },
    {
      immediate: true
    }
  ), watch(
    () => unref(a2),
    (l) => {
      t.setOptions({
        ...l,
        onChange: (s, r) => {
          var i;
          triggerRef(e), (i = l.onChange) == null || i.call(l, s, r);
        }
      }), t._willUpdate(), triggerRef(e);
    },
    {
      immediate: true
    }
  ), onScopeDispose(n), e;
}
function os(a2) {
  return mc(
    computed(() => ({
      observeElementRect: ic,
      observeElementOffset: dc,
      scrollToFn: pc,
      ...unref(a2)
    }))
  );
}
var Eh = defineComponent({
  __name: "ListboxVirtualizer",
  props: {
    options: {},
    estimateSize: {},
    textContent: { type: Function }
  },
  setup(a2) {
    const t = a2, e = useSlots(), n = Ja(), l = Pl(), { getItems: s } = Zt();
    n.isVirtual.value = true;
    const r = computed(() => {
      const f = l.value;
      if (f) {
        const v2 = window.getComputedStyle(f);
        return {
          start: Number.parseFloat(v2.paddingBlockStart || v2.paddingTop),
          end: Number.parseFloat(v2.paddingBlockEnd || v2.paddingBottom)
        };
      } else
        return { start: 0, end: 0 };
    }), i = os(
      {
        get scrollPaddingStart() {
          return r.value.start;
        },
        get scrollPaddingEnd() {
          return r.value.end;
        },
        get count() {
          return t.options.length;
        },
        get horizontal() {
          return n.orientation.value === "horizontal";
        },
        estimateSize() {
          return t.estimateSize ?? 28;
        },
        getScrollElement() {
          return l.value;
        },
        overscan: 12
      }
    ), u = computed(() => i.value.getVirtualItems().map((f) => ({
      item: f,
      is: cloneVNode(e.default({
        option: t.options[f.index]
      })[0], {
        key: `${f.key}`,
        "data-index": f.index,
        "aria-setsize": t.options.length,
        "aria-posinset": f.index + 1,
        style: {
          position: "absolute",
          top: 0,
          left: 0,
          transform: `translateY(${f.start}px)`,
          overflowAnchor: "none"
        }
      })
    })));
    n.virtualFocusHook.on((f) => {
      const v2 = t.options.findIndex((g) => Array.isArray(n.modelValue.value) ? Ht(g, n.modelValue.value[0], n.by) : Ht(g, n.modelValue.value, n.by));
      v2 !== -1 && (f == null || f.preventDefault(), i.value.scrollToIndex(v2, { align: "start" }), requestAnimationFrame(() => {
        const g = Jd(l.value);
        g && f && (g == null || g.focus());
      }));
    });
    const d = Dt("", 1e3), p = computed(() => {
      const f = (v2) => t.textContent ? t.textContent(v2) : v2.toString().toLowerCase();
      return t.options.map((v2, g) => ({
        index: g,
        textContent: f(v2)
      }));
    });
    function c(f, v2) {
      var x, D, h2, E;
      if (!((x = n.firstValue) != null && x.value) || !n.multiple.value || !Array.isArray(n.modelValue.value))
        return;
      const m2 = (D = s().filter((P2) => P2.ref.dataset.disabled !== "").find((P2) => P2.ref === n.highlightedElement.value)) == null ? void 0 : D.value;
      if (!m2)
        return;
      let S = null;
      switch (v2) {
        case "prev":
        case "next": {
          S = St(t.options, n.firstValue.value, m2);
          break;
        }
        case "first": {
          S = St(t.options, n.firstValue.value, (h2 = t.options) == null ? void 0 : h2[0]);
          break;
        }
        case "last": {
          S = St(t.options, n.firstValue.value, (E = t.options) == null ? void 0 : E[t.options.length - 1]);
          break;
        }
      }
      n.modelValue.value = S;
    }
    return n.virtualKeydownHook.on((f) => {
      var S;
      const v2 = f.altKey || f.ctrlKey || f.metaKey;
      if (f.key === "Tab" && !v2)
        return;
      let m2 = Xa[f.key];
      if (v2 && f.key === "a" && n.multiple.value ? (f.preventDefault(), n.modelValue.value = [...t.options], m2 = "last") : f.shiftKey && m2 && c(f, m2), ["first", "last"].includes(m2)) {
        f.preventDefault();
        const x = m2 === "first" ? 0 : t.options.length - 1;
        i.value.scrollToIndex(x), requestAnimationFrame(() => {
          const D = s(), h2 = m2 === "first" ? D[0] : D[D.length - 1];
          n.onChangeHighlight(h2.ref);
        });
      } else if (!m2 && !v2) {
        d.value += f.key;
        const x = Number((S = document.activeElement) == null ? void 0 : S.getAttribute("data-index")), D = p.value[x].textContent, h2 = p.value.map(($2) => $2.textContent), E = Gn(h2, d.value, D), P2 = p.value.find(($2) => $2.textContent === E);
        P2 && (i.value.scrollToIndex(P2.index, { align: "start" }), requestAnimationFrame(() => {
          const $2 = l.value.querySelector(`[data-index="${P2.index}"]`);
          $2 instanceof HTMLElement && n.onChangeHighlight($2);
        }));
      }
    }), (f, v2) => (openBlock(), createElementBlock("div", {
      "data-radix-vue-virtualizer": "",
      style: normalizeStyle({
        position: "relative",
        width: "100%",
        height: `${unref(i).getTotalSize()}px`
      })
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(u.value, ({ is: g, item: m2 }) => (openBlock(), createBlock(resolveDynamicComponent(g), {
        key: m2.index
      }))), 128))
    ], 4));
  }
});
var [hc, yc] = Q("ListboxGroup");
var Ph = defineComponent({
  __name: "ListboxGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = me(void 0, "radix-vue-listbox-group");
    return yc({ id: e }), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps({ role: "group" }, t, { "aria-labelledby": unref(e) }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-labelledby"]));
  }
});
var Dh = defineComponent({
  __name: "ListboxGroupLabel",
  props: {
    for: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = hc({ id: "" });
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).id
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var [Qa, gc] = Q("MenubarRoot");
var $h = defineComponent({
  __name: "MenubarRoot",
  props: {
    modelValue: {},
    defaultValue: {},
    dir: {},
    loop: { type: Boolean, default: false }
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l, currentElement: s } = R2(), { createCollection: r } = Me("menubar");
    r(s);
    const i = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue ?? "",
      passive: e.modelValue === void 0
    }), u = ref(null), { dir: d, loop: p } = toRefs(e), c = Ce(d);
    return gc({
      modelValue: i,
      dir: c,
      loop: p,
      onMenuOpen: (f) => {
        i.value = f, u.value = f;
      },
      onMenuClose: () => {
        i.value = "";
      },
      onMenuToggle: (f) => {
        i.value = i.value ? "" : f, u.value = f;
      }
    }), (f, v2) => (openBlock(), createBlock(unref(At), {
      "current-tab-stop-id": u.value,
      "onUpdate:currentTabStopId": v2[0] || (v2[0] = (g) => u.value = g),
      orientation: "horizontal",
      loop: unref(p),
      dir: unref(c),
      "as-child": ""
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(l),
          role: "menubar"
        }, {
          default: withCtx(() => [
            renderSlot(f.$slots, "default", { modelValue: unref(i) })
          ]),
          _: 3
        }, 512)
      ]),
      _: 3
    }, 8, ["current-tab-stop-id", "loop", "dir"]));
  }
});
var [Co, bc] = Q("MenubarMenu");
var Bh = defineComponent({
  __name: "MenubarMenu",
  props: {
    value: {}
  },
  setup(a2) {
    const e = me(a2.value), n = Qa();
    R2();
    const l = ref(), s = ref(false), r = computed(() => n.modelValue.value === e);
    return watch(r, () => {
      r.value || (s.value = false);
    }), bc({
      value: e,
      triggerElement: l,
      triggerId: e,
      contentId: "",
      wasKeyboardTriggerOpenRef: s
    }), (i, u) => (openBlock(), createBlock(unref(ao), {
      open: r.value,
      modal: false,
      dir: unref(n).dir.value,
      "onUpdate:open": u[0] || (u[0] = (d) => {
        d || unref(n).onMenuClose();
      })
    }, {
      default: withCtx(() => [
        renderSlot(i.$slots, "default")
      ]),
      _: 3
    }, 8, ["open", "dir"]));
  }
});
var Ih = defineComponent({
  __name: "MenubarTrigger",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = Qa(), e = Co(), { forwardRef: n, currentElement: l } = R2(), s = ref(false), r = computed(() => t.modelValue.value === e.value);
    return onMounted(() => {
      e.triggerElement = l;
    }), (i, u) => (openBlock(), createBlock(unref(Ot), {
      "as-child": "",
      focusable: !i.disabled,
      "tab-stop-id": unref(e).value
    }, {
      default: withCtx(() => [
        createVNode(unref(Ya), { "as-child": "" }, {
          default: withCtx(() => [
            createVNode(unref(A2), {
              id: unref(e).triggerId,
              ref: unref(n),
              as: i.as,
              type: i.as === "button" ? "button" : void 0,
              role: "menuitem",
              "aria-haspopup": "menu",
              "aria-expanded": r.value,
              "aria-controls": r.value ? unref(e).contentId : void 0,
              "data-highlighted": s.value ? "" : void 0,
              "data-state": r.value ? "open" : "closed",
              "data-disabled": i.disabled ? "" : void 0,
              disabled: i.disabled,
              "data-value": unref(e).value,
              "data-radix-vue-collection-item": "",
              onPointerdown: u[0] || (u[0] = (d) => {
                !i.disabled && d.button === 0 && d.ctrlKey === false && (unref(t).onMenuOpen(unref(e).value), r.value || d.preventDefault());
              }),
              onPointerenter: u[1] || (u[1] = () => {
                var p;
                !!unref(t).modelValue.value && !r.value && (unref(t).onMenuOpen(unref(e).value), (p = unref(l)) == null || p.focus());
              }),
              onKeydown: u[2] || (u[2] = withKeys((d) => {
                i.disabled || (["Enter", " "].includes(d.key) && unref(t).onMenuToggle(unref(e).value), d.key === "ArrowDown" && unref(t).onMenuOpen(unref(e).value), ["Enter", " ", "ArrowDown"].includes(d.key) && (unref(e).wasKeyboardTriggerOpenRef.value = true, d.preventDefault()));
              }, ["enter", "space", "arrow-down"])),
              onFocus: u[3] || (u[3] = (d) => s.value = true),
              onBlur: u[4] || (u[4] = (d) => s.value = false)
            }, {
              default: withCtx(() => [
                renderSlot(i.$slots, "default")
              ]),
              _: 3
            }, 8, ["id", "as", "type", "aria-expanded", "aria-controls", "data-highlighted", "data-state", "data-disabled", "disabled", "data-value"])
          ]),
          _: 3
        })
      ]),
      _: 3
    }, 8, ["focusable", "tab-stop-id"]));
  }
});
var Th = defineComponent({
  __name: "MenubarPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(uo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Rh = defineComponent({
  __name: "MenubarContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    side: {},
    sideOffset: {},
    align: { default: "start" },
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    R2();
    const s = Qa(), r = Co();
    r.contentId || (r.contentId = me(void 0, "radix-vue-menubar-content"));
    const { injectCollection: i } = Me("menubar"), u = i(), d = ref(false);
    function p(c) {
      const v2 = c.target.hasAttribute(
        "data-radix-menubar-subtrigger"
      ), m2 = (s.dir.value === "rtl" ? "ArrowRight" : "ArrowLeft") === c.key;
      if (!m2 && v2)
        return;
      let x = u.value.map((E) => E.dataset.value);
      m2 && x.reverse();
      const D = x.indexOf(r.value);
      x = s.loop.value ? Un(x, D + 1) : x.slice(D + 1);
      const [h2] = x;
      h2 && s.onMenuOpen(h2);
    }
    return (c, f) => (openBlock(), createBlock(unref(ro), mergeProps(unref(l), {
      id: unref(r).contentId,
      "data-radix-menubar-content": "",
      "aria-labelledby": unref(r).triggerId,
      style: {
        "--radix-menubar-content-transform-origin": "var(--radix-popper-transform-origin)",
        "--radix-menubar-content-available-width": "var(--radix-popper-available-width)",
        "--radix-menubar-content-available-height": "var(--radix-popper-available-height)",
        "--radix-menubar-trigger-width": "var(--radix-popper-anchor-width)",
        "--radix-menubar-trigger-height": "var(--radix-popper-anchor-height)"
      },
      onCloseAutoFocus: f[0] || (f[0] = (v2) => {
        var m2;
        !!!unref(s).modelValue.value && !d.value && ((m2 = unref(r).triggerElement.value) == null || m2.focus()), d.value = false, v2.preventDefault();
      }),
      onFocusOutside: f[1] || (f[1] = (v2) => {
        const g = v2.target;
        unref(u).some((S) => S.contains(g)) && v2.preventDefault();
      }),
      onInteractOutside: f[2] || (f[2] = (v2) => {
        d.value = true;
      }),
      onEntryFocus: f[3] || (f[3] = (v2) => {
        unref(r).wasKeyboardTriggerOpenRef.value || v2.preventDefault();
      }),
      onKeydown: withKeys(p, ["arrow-right", "arrow-left"])
    }), {
      default: withCtx(() => [
        renderSlot(c.$slots, "default")
      ]),
      _: 3
    }, 16, ["id", "aria-labelledby"]));
  }
});
var Ah = defineComponent({
  __name: "MenubarArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(to), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Oh = defineComponent({
  __name: "MenubarItem",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(wa), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var kh = defineComponent({
  __name: "MenubarGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(Za), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Mh = defineComponent({
  __name: "MenubarSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(fo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Vh = defineComponent({
  __name: "MenubarCheckboxItem",
  props: {
    checked: { type: [Boolean, String] },
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select", "update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(so), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Fh = defineComponent({
  __name: "MenubarItemIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(lo), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Lh = defineComponent({
  __name: "MenubarLabel",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(io), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Nh = defineComponent({
  __name: "MenubarRadioGroup",
  props: {
    modelValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = Te(t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(co), normalizeProps(guardReactiveProps({ ...e, ...unref(l) })), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var zh = defineComponent({
  __name: "MenubarRadioItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    return R2(), (s, r) => (openBlock(), createBlock(unref(po), normalizeProps(guardReactiveProps(unref(l))), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Kh = defineComponent({
  __name: "MenubarSub",
  props: {
    defaultOpen: { type: Boolean },
    open: { type: Boolean, default: void 0 }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    const l = ae(e, "open", n, {
      defaultValue: e.defaultOpen ?? false,
      passive: e.open === void 0
    });
    return (s, r) => (openBlock(), createBlock(unref(vo), {
      open: unref(l),
      "onUpdate:open": r[0] || (r[0] = (i) => isRef(l) ? l.value = i : null)
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default", { open: unref(l) })
      ]),
      _: 3
    }, 8, ["open"]));
  }
});
var Hh = defineComponent({
  __name: "MenubarSubContent",
  props: {
    forceMount: { type: Boolean },
    loop: { type: Boolean },
    sideOffset: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "entryFocus", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const l = xe(a2, t);
    R2();
    const { injectCollection: s } = Me("menubar"), r = Qa(), i = Co(), u = s();
    function d(p) {
      if (p.target.hasAttribute(
        "data-radix-menubar-subtrigger"
      ))
        return;
      let v2 = u.value.map((S) => S.dataset.value);
      const g = v2.indexOf(i.value);
      v2 = r.loop.value ? Un(v2, g + 1) : v2.slice(g + 1);
      const [m2] = v2;
      m2 && r.onMenuOpen(m2);
    }
    return (p, c) => (openBlock(), createBlock(unref(mo), mergeProps(unref(l), {
      "data-radix-menubar-content": "",
      style: {
        "--radix-menubar-content-transform-origin": "var(--radix-popper-transform-origin)",
        "--radix-menubar-content-available-width": "var(--radix-popper-available-width)",
        "--radix-menubar-content-available-height": "var(--radix-popper-available-height)",
        "--radix-menubar-trigger-width": "var(--radix-popper-anchor-width)",
        "--radix-menubar-trigger-height": "var(--radix-popper-anchor-height)"
      },
      onKeydown: withKeys(d, ["arrow-right"])
    }), {
      default: withCtx(() => [
        renderSlot(p.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Wh = defineComponent({
  __name: "MenubarSubTrigger",
  props: {
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(ho), mergeProps(t, { "data-radix-menubar-subtrigger": "" }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [gt, ls] = Q(["NavigationMenuRoot", "NavigationMenuSub"], "NavigationMenuContext");
var jh = defineComponent({
  __name: "NavigationMenuRoot",
  props: {
    modelValue: { default: void 0 },
    defaultValue: {},
    dir: {},
    orientation: { default: "horizontal" },
    delayDuration: { default: 200 },
    skipDelayDuration: { default: 300 },
    disableClickTrigger: { type: Boolean, default: false },
    disableHoverTrigger: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: { default: "nav" }
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "modelValue", t, {
      defaultValue: e.defaultValue ?? "",
      passive: e.modelValue === void 0
    }), s = ref(""), { forwardRef: r, currentElement: i } = R2(), u = ref(), d = ref(), { createCollection: p } = Me("nav");
    p(u);
    const { delayDuration: c, skipDelayDuration: f, dir: v2, disableClickTrigger: g, disableHoverTrigger: m2 } = toRefs(e), S = Ce(v2), x = Dt(false, f), D = computed(() => l.value !== "" || x.value ? 150 : c.value), h2 = zn((E) => {
      s.value = l.value, l.value = E;
    }, D);
    return ls({
      isRootMenu: true,
      modelValue: l,
      previousValue: s,
      baseId: me(void 0, "radix-navigation-menu"),
      disableClickTrigger: g,
      disableHoverTrigger: m2,
      dir: S,
      orientation: e.orientation,
      rootNavigationMenu: i,
      indicatorTrack: u,
      onIndicatorTrackChange: (E) => {
        u.value = E;
      },
      viewport: d,
      onViewportChange: (E) => {
        d.value = E;
      },
      onTriggerEnter: (E) => {
        h2(E);
      },
      onTriggerLeave: () => {
        x.value = true, h2("");
      },
      onContentEnter: (E) => {
        h2(E);
      },
      onContentLeave: () => {
        h2("");
      },
      onItemSelect: (E) => {
        s.value = l.value, l.value = E;
      },
      onItemDismiss: () => {
        s.value = l.value, l.value = "";
      }
    }), (E, P2) => (openBlock(), createBlock(unref(A2), {
      ref: unref(r),
      "aria-label": "Main",
      as: E.as,
      "as-child": E.asChild,
      "data-orientation": E.orientation,
      dir: unref(S)
    }, {
      default: withCtx(() => [
        renderSlot(E.$slots, "default", { modelValue: unref(l) })
      ]),
      _: 3
    }, 8, ["as", "as-child", "data-orientation", "dir"]));
  }
});
function en(a2) {
  return a2 ? "open" : "closed";
}
function ss(a2, t) {
  return `${a2}-trigger-${t}`;
}
function wo(a2, t) {
  return `${a2}-content-${t}`;
}
var Oa = "navigationMenu.rootContentDismiss";
function In(a2) {
  const t = [], e = document.createTreeWalker(a2, NodeFilter.SHOW_ELEMENT, {
    acceptNode: (n) => {
      const l = n.tagName === "INPUT" && n.type === "hidden";
      return n.disabled || n.hidden || l ? NodeFilter.FILTER_SKIP : n.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }
  });
  for (; e.nextNode(); ) t.push(e.currentNode);
  return t;
}
function rs(a2) {
  const t = document.activeElement;
  return a2.some((e) => e === t ? true : (e.focus(), document.activeElement !== t));
}
function Cc(a2) {
  return a2.forEach((t) => {
    t.dataset.tabindex = t.getAttribute("tabindex") || "", t.setAttribute("tabindex", "-1");
  }), () => {
    a2.forEach((t) => {
      const e = t.dataset.tabindex;
      t.setAttribute("tabindex", e);
    });
  };
}
function is(a2) {
  return (t) => t.pointerType === "mouse" ? a2(t) : void 0;
}
var [_o, wc] = Q("NavigationMenuItem");
var Uh = defineComponent({
  __name: "NavigationMenuItem",
  props: {
    value: {},
    asChild: { type: Boolean },
    as: { default: "li" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const { injectCollection: e } = Me("nav"), n = e(), l = gt(), s = me(t.value), r = ref(), i = ref(), u = wo(l.baseId, s);
    let d = () => ({});
    const p = ref(false);
    async function c(m2 = "start") {
      const S = document.getElementById(u);
      if (S) {
        d();
        const x = In(S);
        x.length && rs(m2 === "start" ? x : x.reverse());
      }
    }
    function f() {
      const m2 = document.getElementById(u);
      if (m2) {
        const S = In(m2);
        S.length && (d = Cc(S));
      }
    }
    wc({
      value: s,
      contentId: u,
      triggerRef: r,
      focusProxyRef: i,
      wasEscapeCloseRef: p,
      onEntryKeyDown: c,
      onFocusProxyEnter: c,
      onContentFocusOutside: f,
      onRootContentClose: f
    });
    function v2() {
      var m2;
      l.onItemDismiss(), (m2 = r.value) == null || m2.focus();
    }
    function g(m2) {
      const S = document.activeElement;
      if (m2.keyCode === 32 || m2.key === "Enter")
        if (l.modelValue.value === s) {
          v2(), m2.preventDefault();
          return;
        } else {
          m2.target.click(), m2.preventDefault();
          return;
        }
      const x = n.value.filter(
        (h2) => {
          var E;
          return (E = h2.parentElement) == null ? void 0 : E.hasAttribute("data-menu-item");
        }
      ), D = $t(m2, S, void 0, {
        itemsArray: x,
        loop: false
      });
      D && (D == null || D.focus()), m2.preventDefault(), m2.stopPropagation();
    }
    return (m2, S) => (openBlock(), createBlock(unref(A2), {
      "as-child": m2.asChild,
      as: m2.as,
      "data-menu-item": "",
      onKeydown: withKeys(g, ["up", "down", "left", "right", "home", "end", "space"])
    }, {
      default: withCtx(() => [
        renderSlot(m2.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as"]));
  }
});
var _c = defineComponent({
  __name: "NavigationMenuContentImpl",
  props: {
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { injectCollection: l } = Me("nav"), s = l(), { forwardRef: r, currentElement: i } = R2(), u = gt(), d = _o(), p = ss(u.baseId, d.value), c = wo(u.baseId, d.value), f = ref(null), v2 = computed(() => {
      const E = s.value.map((O) => O.id.split("trigger-")[1]);
      u.dir.value === "rtl" && E.reverse();
      const P2 = E.indexOf(u.modelValue.value), $2 = E.indexOf(u.previousValue.value), I = d.value === u.modelValue.value, k = $2 === E.indexOf(d.value);
      if (!I && !k)
        return f.value;
      const L = (() => {
        if (P2 !== $2) {
          if (I && $2 !== -1)
            return P2 > $2 ? "from-end" : "from-start";
          if (k && P2 !== -1)
            return P2 > $2 ? "to-start" : "to-end";
        }
        return null;
      })();
      return f.value = L, L;
    });
    function g(h2) {
      var E, P2;
      if (n("focusOutside", h2), n("interactOutside", h2), !h2.defaultPrevented) {
        d.onContentFocusOutside();
        const $2 = h2.target;
        (P2 = (E = u.rootNavigationMenu) == null ? void 0 : E.value) != null && P2.contains($2) && h2.preventDefault();
      }
    }
    function m2(h2) {
      var E;
      if (n("pointerDownOutside", h2), !h2.defaultPrevented) {
        const P2 = h2.target, $2 = s.value.some(
          (k) => k.contains(P2)
        ), I = u.isRootMenu && ((E = u.viewport.value) == null ? void 0 : E.contains(P2));
        ($2 || I || !u.isRootMenu) && h2.preventDefault();
      }
    }
    watchEffect((h2) => {
      const E = i.value;
      if (u.isRootMenu && E) {
        const P2 = () => {
          var $2;
          u.onItemDismiss(), d.onRootContentClose(), E.contains(document.activeElement) && (($2 = d.triggerRef.value) == null || $2.focus());
        };
        E.addEventListener(Oa, P2), h2(
          () => E.removeEventListener(Oa, P2)
        );
      }
    });
    function S(h2) {
      var E, P2;
      n("escapeKeyDown", h2), h2.defaultPrevented || (u.onItemDismiss(), (P2 = (E = d.triggerRef) == null ? void 0 : E.value) == null || P2.focus(), d.wasEscapeCloseRef.value = true);
    }
    function x(h2) {
      var k;
      const E = h2.altKey || h2.ctrlKey || h2.metaKey, P2 = h2.key === "Tab" && !E, $2 = In(h2.currentTarget);
      if (P2) {
        const L = document.activeElement, O = $2.findIndex(
          (Y) => Y === L
        ), H2 = h2.shiftKey ? $2.slice(0, O).reverse() : $2.slice(O + 1, $2.length);
        if (rs(H2))
          h2.preventDefault();
        else {
          (k = d.focusProxyRef.value) == null || k.focus();
          return;
        }
      }
      const I = $t(
        h2,
        document.activeElement,
        void 0,
        { itemsArray: $2, loop: false, enableIgnoredElement: true }
      );
      I == null || I.focus();
    }
    function D() {
      var E;
      const h2 = new Event(Oa, {
        bubbles: true,
        cancelable: true
      });
      (E = i.value) == null || E.dispatchEvent(h2);
    }
    return (h2, E) => (openBlock(), createBlock(unref(yt), mergeProps({
      id: unref(c),
      ref: unref(r),
      "aria-labelledby": unref(p),
      "data-motion": v2.value,
      "data-state": unref(en)(unref(u).modelValue.value === unref(d).value),
      "data-orientation": unref(u).orientation
    }, e, {
      onKeydown: x,
      onEscapeKeyDown: S,
      onPointerDownOutside: m2,
      onFocusOutside: g,
      onDismiss: D
    }), {
      default: withCtx(() => [
        renderSlot(h2.$slots, "default")
      ]),
      _: 3
    }, 16, ["id", "aria-labelledby", "data-motion", "data-state", "data-orientation"]));
  }
});
var Gh = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuContent",
  props: {
    forceMount: { type: Boolean },
    disableOutsidePointerEvents: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Te(n), { forwardRef: s } = R2(), r = Ha(), i = gt(), u = _o(), d = computed(() => u.value === i.modelValue.value), p = computed(() => i.viewport.value && !i.modelValue.value && i.previousValue.value ? i.previousValue.value === u.value : false);
    return (c, f) => unref(r) ? (openBlock(), createBlock(Teleport, {
      key: 0,
      to: unref(i).viewport.value,
      disabled: !unref(i).viewport.value
    }, [
      createVNode(unref(Pe), {
        present: c.forceMount || d.value || p.value
      }, {
        default: withCtx(() => [
          createVNode(_c, mergeProps({
            ref: unref(s),
            "data-state": unref(en)(d.value),
            style: {
              pointerEvents: !d.value && unref(i).isRootMenu ? "none" : void 0
            }
          }, { ...c.$attrs, ...e, ...unref(l) }, {
            onPointerenter: f[0] || (f[0] = (v2) => unref(i).onContentEnter(unref(u).value)),
            onPointerleave: f[1] || (f[1] = (v2) => unref(is)(() => unref(i).onContentLeave())(v2)),
            onPointerDownOutside: f[2] || (f[2] = (v2) => n("pointerDownOutside", v2)),
            onFocusOutside: f[3] || (f[3] = (v2) => n("focusOutside", v2)),
            onInteractOutside: f[4] || (f[4] = (v2) => n("interactOutside", v2))
          }), {
            default: withCtx(() => [
              renderSlot(c.$slots, "default")
            ]),
            _: 3
          }, 16, ["data-state", "style"])
        ]),
        _: 3
      }, 8, ["present"])
    ], 8, ["to", "disabled"])) : createCommentVNode("", true);
  }
});
var qh = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), { injectCollection: n } = Me("nav"), l = n(), s = gt(), r = ref(), i = computed(() => s.orientation === "horizontal"), u = computed(() => !!s.modelValue.value), d = ref();
    function p() {
      d.value && (r.value = {
        size: i.value ? d.value.offsetWidth : d.value.offsetHeight,
        offset: i.value ? d.value.offsetLeft : d.value.offsetTop
      });
    }
    return watchEffect(() => {
      if (!s.modelValue.value) {
        r.value = void 0;
        return;
      }
      const c = l.value;
      d.value = c.find(
        (f) => f.id.includes(s.modelValue.value)
      ), p();
    }), Ze(d, p), Ze(s.indicatorTrack, p), (c, f) => unref(s).indicatorTrack.value ? (openBlock(), createBlock(Teleport, {
      key: 0,
      to: unref(s).indicatorTrack.value
    }, [
      createVNode(unref(Pe), {
        present: c.forceMount || u.value
      }, {
        default: withCtx(() => {
          var v2, g, m2, S;
          return [
            createVNode(unref(A2), mergeProps({
              ref: unref(e),
              "aria-hidden": "",
              "data-state": u.value ? "visible" : "hidden",
              "data-orientation": unref(s).orientation,
              "as-child": t.asChild,
              as: c.as,
              style: {
                position: "absolute",
                ...i.value ? {
                  left: 0,
                  width: `${(v2 = r.value) == null ? void 0 : v2.size}px`,
                  transform: `translateX(${(g = r.value) == null ? void 0 : g.offset}px)`
                } : {
                  top: 0,
                  height: `${(m2 = r.value) == null ? void 0 : m2.size}px`,
                  transform: `translateY(${(S = r.value) == null ? void 0 : S.offset}px)`
                }
              }
            }, c.$attrs), {
              default: withCtx(() => [
                renderSlot(c.$slots, "default")
              ]),
              _: 3
            }, 16, ["data-state", "data-orientation", "as-child", "as", "style"])
          ];
        }),
        _: 3
      }, 8, ["present"])
    ], 8, ["to"])) : createCommentVNode("", true);
  }
});
var Yh = defineComponent({
  __name: "NavigationMenuLink",
  props: {
    active: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "a" }
  },
  emits: ["select"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    async function l(s) {
      var r;
      if (n("select", s), await nextTick(), !s.defaultPrevented && !s.metaKey) {
        const i = new CustomEvent(
          Oa,
          {
            bubbles: true,
            cancelable: true
          }
        );
        (r = s.target) == null || r.dispatchEvent(i);
      }
    }
    return (s, r) => (openBlock(), createBlock(unref(A2), {
      as: s.as,
      "data-active": s.active ? "" : void 0,
      "aria-current": s.active ? "page" : void 0,
      "as-child": e.asChild,
      "data-radix-vue-collection-item": "",
      onClick: l
    }, {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "data-active", "aria-current", "as-child"]));
  }
});
var Xh = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuList",
  props: {
    asChild: { type: Boolean },
    as: { default: "ul" }
  },
  setup(a2) {
    const t = a2, e = gt(), { forwardRef: n, currentElement: l } = R2();
    return onMounted(() => {
      e.onIndicatorTrackChange(l.value);
    }), (s, r) => (openBlock(), createBlock(unref(A2), {
      ref: unref(n),
      style: { position: "relative" }
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps(s.$attrs, {
          "as-child": t.asChild,
          as: s.as,
          "data-orientation": unref(e).orientation
        }), {
          default: withCtx(() => [
            renderSlot(s.$slots, "default")
          ]),
          _: 3
        }, 16, ["as-child", "as", "data-orientation"])
      ]),
      _: 3
    }, 512));
  }
});
var Zh = defineComponent({
  __name: "NavigationMenuSub",
  props: {
    modelValue: {},
    defaultValue: {},
    orientation: { default: "horizontal" },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "modelValue", t, {
      defaultValue: e.defaultValue ?? "",
      passive: e.modelValue === void 0
    }), s = ref(""), r = gt(), { forwardRef: i, currentElement: u } = R2(), d = ref(), p = ref(), { createCollection: c } = Me("nav");
    return c(d), ls({
      ...r,
      isRootMenu: false,
      modelValue: l,
      previousValue: s,
      orientation: e.orientation,
      rootNavigationMenu: u,
      indicatorTrack: d,
      onIndicatorTrackChange: (f) => {
        d.value = f;
      },
      viewport: p,
      onViewportChange: (f) => {
        p.value = f;
      },
      onTriggerEnter: (f) => {
        l.value = f;
      },
      onTriggerLeave: () => {
      },
      onContentEnter: () => {
      },
      onContentLeave: () => {
      },
      onItemSelect: (f) => {
        l.value = f;
      },
      onItemDismiss: () => {
        l.value = "";
      }
    }), (f, v2) => (openBlock(), createBlock(unref(A2), {
      ref: unref(i),
      "data-orientation": f.orientation,
      "as-child": e.asChild,
      as: f.as
    }, {
      default: withCtx(() => [
        renderSlot(f.$slots, "default", { modelValue: unref(l) })
      ]),
      _: 3
    }, 8, ["data-orientation", "as-child", "as"]));
  }
});
var xc = ["aria-owns"];
var Jh = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuTrigger",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = gt(), n = _o(), { forwardRef: l, currentElement: s } = R2(), r = ref(""), i = ref(""), u = Dt(false, 300), d = ref(false), p = computed(() => n.value === e.modelValue.value);
    onMounted(() => {
      n.triggerRef = s, r.value = ss(e.baseId, n.value), i.value = wo(e.baseId, n.value);
    });
    function c() {
      e.disableHoverTrigger.value || (d.value = false, n.wasEscapeCloseRef.value = false);
    }
    function f(D) {
      if (!e.disableHoverTrigger.value && D.pointerType === "mouse") {
        if (t.disabled || d.value || n.wasEscapeCloseRef.value || u.value)
          return;
        e.onTriggerEnter(n.value), u.value = true;
      }
    }
    function v2(D) {
      if (!e.disableHoverTrigger.value && D.pointerType === "mouse") {
        if (t.disabled)
          return;
        e.onTriggerLeave(), u.value = false;
      }
    }
    function g(D) {
      D.pointerType === "mouse" && e.disableClickTrigger.value || u.value || (p.value ? e.onItemSelect("") : e.onItemSelect(n.value), d.value = p.value);
    }
    function m2(D) {
      const E = { horizontal: "ArrowDown", vertical: e.dir.value === "rtl" ? "ArrowLeft" : "ArrowRight" }[e.orientation];
      p.value && D.key === E && (n.onEntryKeyDown(), D.preventDefault(), D.stopPropagation());
    }
    function S(D) {
      n.focusProxyRef.value = Be(D);
    }
    function x(D) {
      const h2 = document.getElementById(n.contentId), E = D.relatedTarget, P2 = E === s.value, $2 = h2 == null ? void 0 : h2.contains(E);
      (P2 || !$2) && n.onFocusProxyEnter(P2 ? "start" : "end");
    }
    return (D, h2) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps({
        id: r.value,
        ref: unref(l),
        disabled: D.disabled,
        "data-disabled": D.disabled ? "" : void 0,
        "data-state": unref(en)(p.value),
        "aria-expanded": p.value,
        "aria-controls": i.value,
        "as-child": t.asChild,
        as: D.as
      }, D.$attrs, {
        "data-radix-vue-collection-item": "",
        onPointerenter: c,
        onPointermove: f,
        onPointerleave: v2,
        onClick: g,
        onKeydown: m2
      }), {
        default: withCtx(() => [
          renderSlot(D.$slots, "default")
        ]),
        _: 3
      }, 16, ["id", "disabled", "data-disabled", "data-state", "aria-expanded", "aria-controls", "as-child", "as"]),
      p.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        createVNode(unref(Yt), {
          ref: S,
          "aria-hidden": "",
          tabindex: 0,
          onFocus: x
        }),
        unref(e).viewport ? (openBlock(), createElementBlock("span", {
          key: 0,
          "aria-owns": i.value
        }, null, 8, xc)) : createCommentVNode("", true)
      ], 64)) : createCommentVNode("", true)
    ], 64));
  }
});
var Qh = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuViewport",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const { forwardRef: t, currentElement: e } = R2(), n = gt(), l = ref(), s = computed(() => !!n.modelValue.value), r = computed(() => n.modelValue.value);
    watch(e, () => {
      e.value && n.onViewportChange(e.value);
    });
    const i = ref();
    return watch([r, s], async () => {
      var d, p;
      if (await nextTick(), !e.value)
        return;
      const u = (p = (d = e.value.querySelector("[data-state=open]")) == null ? void 0 : d.children) == null ? void 0 : p[0];
      i.value = u;
    }, { immediate: true }), Ze(i, () => {
      i.value && (l.value = {
        width: i.value.offsetWidth,
        height: i.value.offsetHeight
      });
    }), (u, d) => (openBlock(), createBlock(unref(Pe), {
      present: u.forceMount || s.value
    }, {
      default: withCtx(() => {
        var p, c;
        return [
          createVNode(unref(A2), mergeProps(u.$attrs, {
            ref: unref(t),
            as: u.as,
            "as-child": u.asChild,
            "data-state": unref(en)(s.value),
            "data-orientation": unref(n).orientation,
            style: {
              // Prevent interaction when animating out
              pointerEvents: !s.value && unref(n).isRootMenu ? "none" : void 0,
              "--radix-navigation-menu-viewport-width": l.value ? `${(p = l.value) == null ? void 0 : p.width}px` : void 0,
              "--radix-navigation-menu-viewport-height": l.value ? `${(c = l.value) == null ? void 0 : c.height}px` : void 0
            },
            onPointerenter: d[0] || (d[0] = (f) => unref(n).onContentEnter(unref(n).modelValue.value)),
            onPointerleave: d[1] || (d[1] = (f) => unref(is)(() => unref(n).onContentLeave())(f))
          }), {
            default: withCtx(() => [
              renderSlot(u.$slots, "default")
            ]),
            _: 3
          }, 16, ["as", "as-child", "data-state", "data-orientation", "style"])
        ];
      }),
      _: 3
    }, 8, ["present"]));
  }
});
function us(a2) {
  const { disabled: t } = a2, e = ref(), n = ra(), l = () => window.clearTimeout(e.value), s = (f) => {
    l(), !t.value && (n.trigger(), e.value = window.setTimeout(() => {
      s(60);
    }, f));
  }, r = () => {
    s(400);
  }, i = () => {
    l();
  }, u = ref(false), d = computed(() => Be(a2.target) || window), p = (f) => {
    f.button !== 0 || u.value || (f.preventDefault(), u.value = true, r());
  }, c = () => {
    u.value = false, i();
  };
  return je(d, "pointerdown", p), window && (je(window, "pointerup", c), je(window, "pointercancel", c)), {
    isPressed: u,
    onTrigger: n.on
  };
}
function Uo(a2, t = ref({})) {
  return bl(() => new $488c6ddbf4ef74c2$export$cc77c4ff7e8673c5(a2.value, t.value));
}
function Sc(a2, t = ref({})) {
  return bl(() => new $6c7bd7858deea686$export$cd11ab140839f11d(a2.value, t.value));
}
function Go(a2, t, e) {
  let n = a2 === "+" ? t + e : t - e;
  if (t % 1 !== 0 || e % 1 !== 0) {
    const l = t.toString().split("."), s = e.toString().split("."), r = l[1] && l[1].length || 0, i = s[1] && s[1].length || 0, u = 10 ** Math.max(r, i);
    t = Math.round(t * u), e = Math.round(e * u), n = a2 === "+" ? t + e : t - e, n /= u;
  }
  return n;
}
var Ec = ["value", "name", "disabled", "required"];
var [xo, Pc] = Q("NumberFieldRoot");
var ey = defineComponent({
  inheritAttrs: false,
  __name: "NumberFieldRoot",
  props: {
    defaultValue: { default: void 0 },
    modelValue: {},
    min: {},
    max: {},
    step: { default: 1 },
    formatOptions: {},
    locale: { default: "en-US" },
    disabled: { type: Boolean },
    required: { type: Boolean },
    name: {},
    id: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { disabled: l, min: s, max: r, step: i, locale: u, formatOptions: d, id: p } = toRefs(e), c = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), { primitiveElement: f, currentElement: v2 } = Re(), g = Qe(v2), m2 = ref(), S = computed(
      () => Y(c.value) === s.value || (s.value && !isNaN(c.value) ? Go("-", c.value, i.value) < s.value : false)
    ), x = computed(
      () => Y(c.value) === r.value || (r.value && !isNaN(c.value) ? Go("+", c.value, i.value) > r.value : false)
    );
    function D(N2, F = 1) {
      var z2;
      const W2 = I.parse(((z2 = m2.value) == null ? void 0 : z2.value) ?? "");
      e.disabled || (isNaN(W2) ? c.value = s.value ?? 0 : N2 === "increase" ? c.value = Y(W2 + (i.value ?? 1) * F) : c.value = Y(W2 - (i.value ?? 1) * F));
    }
    function h2(N2 = 1) {
      D("increase", N2);
    }
    function E(N2 = 1) {
      D("decrease", N2);
    }
    function P2(N2) {
      N2 === "min" && s.value !== void 0 ? c.value = Y(s.value) : N2 === "max" && r.value !== void 0 && (c.value = Y(r.value));
    }
    const $2 = Uo(u, d), I = Sc(u, d), k = computed(() => $2.resolvedOptions().maximumFractionDigits > 0 ? "decimal" : "numeric"), L = Uo(u, d), O = computed(() => isNaN(c.value) ? "" : L.format(c.value));
    function V2(N2) {
      return I.isValidPartialNumber(N2, s.value, r.value);
    }
    function H2(N2) {
      m2.value && (m2.value.value = N2);
    }
    function Y(N2) {
      let F;
      return i.value === void 0 || isNaN(i.value) ? F = Kt(N2, s.value, r.value) : F = Br(N2, s.value, r.value, i.value), F = I.parse($2.format(F)), F;
    }
    function J2(N2) {
      const F = I.parse(N2);
      return c.value = Y(F), N2.length ? (isNaN(F), H2(O.value)) : H2(N2);
    }
    return Pc({
      modelValue: c,
      handleDecrease: E,
      handleIncrease: h2,
      handleMinMaxValue: P2,
      inputMode: k,
      inputEl: m2,
      onInputElement: (N2) => m2.value = N2,
      textValue: O,
      validate: V2,
      applyInputValue: J2,
      disabled: l,
      max: r,
      min: s,
      isDecreaseDisabled: S,
      isIncreaseDisabled: x,
      id: p
    }), (N2, F) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps(N2.$attrs, {
        ref_key: "primitiveElement",
        ref: f,
        role: "group",
        as: N2.as,
        "as-child": N2.asChild
      }), {
        default: withCtx(() => [
          renderSlot(N2.$slots, "default", {
            modelValue: unref(c),
            textValue: O.value
          })
        ]),
        _: 3
      }, 16, ["as", "as-child"]),
      unref(g) ? (openBlock(), createElementBlock("input", {
        key: 0,
        type: "text",
        tabindex: "-1",
        "aria-hidden": "",
        value: unref(c),
        name: e.name,
        disabled: e.disabled,
        required: e.required,
        style: {
          transform: "translateX(-100%)",
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        }
      }, null, 8, Ec)) : createCommentVNode("", true)
    ], 64));
  }
});
var ty = defineComponent({
  __name: "NumberFieldInput",
  props: {
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  setup(a2) {
    const t = a2, { primitiveElement: e, currentElement: n } = Re(), l = xo();
    function s(r) {
      r.target === document.activeElement && (Math.abs(r.deltaY) <= Math.abs(r.deltaX) || (r.preventDefault(), r.deltaY > 0 ? l.handleIncrease() : r.deltaY < 0 && l.handleDecrease()));
    }
    return onMounted(() => {
      l.onInputElement(n.value);
    }), (r, i) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(l).id.value,
      ref_key: "primitiveElement",
      ref: e,
      role: "spinbutton",
      type: "text",
      tabindex: "0",
      value: unref(l).textValue.value,
      inputmode: unref(l).inputMode.value,
      disabled: unref(l).disabled.value ? "" : void 0,
      "data-disabled": unref(l).disabled.value ? "" : void 0,
      autocomplete: "off",
      autocorrect: "off",
      spellcheck: "false",
      "aria-roledescription": "Number field",
      "aria-valuenow": unref(l).modelValue.value,
      "aria-valuemin": unref(l).min.value,
      "aria-valuemax": unref(l).max.value,
      onKeydown: [
        i[0] || (i[0] = withKeys(withModifiers((u) => unref(l).handleIncrease(), ["prevent"]), ["up"])),
        i[1] || (i[1] = withKeys(withModifiers((u) => unref(l).handleDecrease(), ["prevent"]), ["down"])),
        i[2] || (i[2] = withKeys(withModifiers((u) => unref(l).handleIncrease(10), ["prevent"]), ["page-up"])),
        i[3] || (i[3] = withKeys(withModifiers((u) => unref(l).handleDecrease(10), ["prevent"]), ["page-down"])),
        i[4] || (i[4] = withKeys(withModifiers((u) => unref(l).handleMinMaxValue("min"), ["prevent"]), ["home"])),
        i[5] || (i[5] = withKeys(withModifiers((u) => unref(l).handleMinMaxValue("max"), ["prevent"]), ["end"]))
      ],
      onWheel: s,
      onBeforeinput: i[6] || (i[6] = (u) => {
        const d = u.target;
        let p = d.value.slice(0, d.selectionStart ?? void 0) + (u.data ?? "") + d.value.slice(d.selectionEnd ?? void 0);
        unref(l).validate(p) || u.preventDefault();
      }),
      onBlur: i[7] || (i[7] = (u) => {
        var d;
        return unref(l).applyInputValue((d = u.target) == null ? void 0 : d.value);
      })
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16, ["id", "value", "inputmode", "disabled", "data-disabled", "aria-valuenow", "aria-valuemin", "aria-valuemax"]));
  }
});
var ay = defineComponent({
  __name: "NumberFieldIncrement",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = xo(), n = computed(() => {
      var u;
      return ((u = e.disabled) == null ? void 0 : u.value) || t.disabled || e.isIncreaseDisabled.value;
    }), { primitiveElement: l, currentElement: s } = Re(), { isPressed: r, onTrigger: i } = us({ target: s, disabled: n });
    return i(() => {
      e.handleIncrease();
    }), (u, d) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      ref_key: "primitiveElement",
      ref: l,
      tabindex: "-1",
      "aria-label": "Increase",
      type: u.as === "button" ? "button" : void 0,
      style: {
        userSelect: unref(r) ? "none" : void 0
      },
      disabled: n.value ? "" : void 0,
      "data-disabled": n.value ? "" : void 0,
      "data-pressed": unref(r) ? "true" : void 0,
      onContextmenu: d[0] || (d[0] = withModifiers(() => {
      }, ["prevent"]))
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16, ["type", "style", "disabled", "data-disabled", "data-pressed"]));
  }
});
var ny = defineComponent({
  __name: "NumberFieldDecrement",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = xo(), n = computed(() => {
      var u;
      return ((u = e.disabled) == null ? void 0 : u.value) || t.disabled || e.isDecreaseDisabled.value;
    }), { primitiveElement: l, currentElement: s } = Re(), { isPressed: r, onTrigger: i } = us({ target: s, disabled: n });
    return i(() => {
      e.handleDecrease();
    }), (u, d) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      ref_key: "primitiveElement",
      ref: l,
      tabindex: "-1",
      "aria-label": "Decrease",
      type: u.as === "button" ? "button" : void 0,
      style: {
        userSelect: unref(r) ? "none" : void 0
      },
      disabled: n.value ? "" : void 0,
      "data-disabled": n.value ? "" : void 0,
      "data-pressed": unref(r) ? "true" : void 0,
      onContextmenu: d[0] || (d[0] = withModifiers(() => {
      }, ["prevent"]))
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16, ["type", "style", "disabled", "data-disabled", "data-pressed"]));
  }
});
var [Qt, Dc] = Q("PaginationRoot");
var oy = defineComponent({
  __name: "PaginationRoot",
  props: {
    page: {},
    defaultPage: { default: 1 },
    itemsPerPage: { default: 10 },
    total: { default: 0 },
    siblingCount: { default: 2 },
    disabled: { type: Boolean },
    showEdges: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: { default: "nav" }
  },
  emits: ["update:page"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { siblingCount: l, disabled: s, showEdges: r } = toRefs(e);
    R2();
    const i = ae(e, "page", n, {
      defaultValue: e.defaultPage,
      passive: e.page === void 0
    }), u = computed(() => Math.max(1, Math.ceil(e.total / e.itemsPerPage)));
    return Dc({
      page: i,
      onPageChange(d) {
        i.value = d;
      },
      pageCount: u,
      siblingCount: l,
      disabled: s,
      showEdges: r
    }), (d, p) => (openBlock(), createBlock(unref(A2), {
      as: d.as,
      "as-child": d.asChild
    }, {
      default: withCtx(() => [
        renderSlot(d.$slots, "default", {
          page: unref(i),
          pageCount: u.value
        })
      ]),
      _: 3
    }, 8, ["as", "as-child"]));
  }
});
var ly = defineComponent({
  __name: "PaginationEllipsis",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, { "data-type": "ellipsis" }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default", {}, () => [
          createTextVNode("…")
        ])
      ]),
      _: 3
    }, 16));
  }
});
var sy = defineComponent({
  __name: "PaginationFirst",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Qt();
    return R2(), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "First Page",
      type: n.as === "button" ? "button" : void 0,
      disabled: unref(e).page.value === 1 || unref(e).disabled.value,
      onClick: l[0] || (l[0] = (s) => unref(e).onPageChange(1))
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("First page")
        ])
      ]),
      _: 3
    }, 16, ["type", "disabled"]));
  }
});
var ry = defineComponent({
  __name: "PaginationLast",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Qt();
    return R2(), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "Last Page",
      type: n.as === "button" ? "button" : void 0,
      disabled: unref(e).page.value === unref(e).pageCount.value || unref(e).disabled.value,
      onClick: l[0] || (l[0] = (s) => unref(e).onPageChange(unref(e).pageCount.value))
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Last page")
        ])
      ]),
      _: 3
    }, 16, ["type", "disabled"]));
  }
});
function rt2(a2, t) {
  const e = t - a2 + 1;
  return Array.from({ length: e }, (n, l) => l + a2);
}
function $c(a2) {
  return a2.map((t) => typeof t == "number" ? { type: "page", value: t } : { type: "ellipsis" });
}
var $a = "ellipsis";
function Bc(a2, t, e, n) {
  const s = t, r = Math.max(a2 - e, 1), i = Math.min(a2 + e, s);
  if (n) {
    const d = Math.min(2 * e + 5, t) - 2, p = r > 3 && Math.abs(s - d - 1 + 1) > 2 && Math.abs(r - 1) > 2, c = i < s - 2 && Math.abs(s - d) > 2 && Math.abs(s - i) > 2;
    if (!p && c)
      return [...rt2(1, d), $a, s];
    if (p && !c) {
      const v2 = rt2(s - d + 1, s);
      return [1, $a, ...v2];
    }
    if (p && c) {
      const v2 = rt2(r, i);
      return [1, $a, ...v2, $a, s];
    }
    return rt2(1, s);
  } else {
    const u = e * 2 + 1;
    return t < u ? rt2(1, s) : a2 <= e + 1 ? rt2(1, u) : t - a2 <= e ? rt2(t - u + 1, s) : rt2(r, i);
  }
}
var iy = defineComponent({
  __name: "PaginationList",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Qt(), n = computed(() => $c(
      Bc(
        e.page.value,
        e.pageCount.value,
        e.siblingCount.value,
        e.showEdges.value
      )
    ));
    return (l, s) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default", { items: n.value })
      ]),
      _: 3
    }, 16));
  }
});
var uy = defineComponent({
  __name: "PaginationListItem",
  props: {
    value: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Qt(), n = computed(() => e.page.value === t.value);
    return (l, s) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "data-type": "page",
      "aria-label": `Page ${l.value}`,
      "aria-current": n.value ? "page" : void 0,
      "data-selected": n.value ? "true" : void 0,
      disabled: unref(e).disabled.value,
      type: l.as === "button" ? "button" : void 0,
      onClick: s[0] || (s[0] = (r) => unref(e).onPageChange(l.value))
    }), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(l.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["aria-label", "aria-current", "data-selected", "disabled", "type"]));
  }
});
var dy = defineComponent({
  __name: "PaginationNext",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Qt();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "Next Page",
      type: n.as === "button" ? "button" : void 0,
      disabled: unref(e).page.value === unref(e).pageCount.value || unref(e).disabled.value,
      onClick: l[0] || (l[0] = (s) => unref(e).onPageChange(unref(e).page.value + 1))
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Next page")
        ])
      ]),
      _: 3
    }, 16, ["type", "disabled"]));
  }
});
var cy = defineComponent({
  __name: "PaginationPrev",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Qt();
    return (n, l) => {
      var s;
      return openBlock(), createBlock(unref(A2), mergeProps(t, {
        "aria-label": "Previous Page",
        type: n.as === "button" ? "button" : void 0,
        disabled: unref(e).page.value === 1 || ((s = unref(e).disabled) == null ? void 0 : s.value),
        onClick: l[0] || (l[0] = (r) => unref(e).onPageChange(unref(e).page.value - 1))
      }), {
        default: withCtx(() => [
          renderSlot(n.$slots, "default", {}, () => [
            createTextVNode("Prev page")
          ])
        ]),
        _: 3
      }, 16, ["type", "disabled"]);
    };
  }
});
var Ic = ["id", "value", "name", "disabled", "required"];
var [Tc, Rc] = Q("PinInputRoot");
var py = defineComponent({
  inheritAttrs: false,
  __name: "PinInputRoot",
  props: {
    modelValue: {},
    defaultValue: {},
    placeholder: { default: "" },
    mask: { type: Boolean },
    otp: { type: Boolean },
    type: { default: "text" },
    dir: {},
    name: {},
    disabled: { type: Boolean },
    required: { type: Boolean },
    id: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "complete"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { mask: l, otp: s, placeholder: r, type: i, disabled: u, dir: d } = toRefs(e), { forwardRef: p } = R2(), c = Ce(d), f = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue ?? [],
      passive: e.modelValue === void 0
    }), v2 = ref(/* @__PURE__ */ new Set());
    function g(S) {
      v2.value.add(S);
    }
    const m2 = computed(() => f.value.filter((x) => !!x).length === v2.value.size);
    return watch(f, () => {
      m2.value && n("complete", f.value);
    }, { deep: true }), Rc({
      modelValue: f,
      mask: l,
      otp: s,
      placeholder: r,
      type: i,
      dir: c,
      disabled: u,
      isCompleted: m2,
      inputElements: v2,
      onInputElementChange: g
    }), (S, x) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps(S.$attrs, {
        ref: unref(p),
        dir: unref(c),
        "data-complete": m2.value ? "" : void 0,
        "data-disabled": unref(u) ? "" : void 0
      }), {
        default: withCtx(() => [
          renderSlot(S.$slots, "default", { modelValue: unref(f) })
        ]),
        _: 3
      }, 16, ["dir", "data-complete", "data-disabled"]),
      createBaseVNode("input", {
        id: S.id,
        type: "text",
        tabindex: "-1",
        "aria-hidden": "",
        value: unref(f).join(""),
        name: S.name,
        disabled: unref(u),
        required: S.required,
        style: {
          transform: "translateX(-100%)",
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        },
        onFocus: x[0] || (x[0] = (D) => {
          var h2, E;
          return (E = (h2 = Array.from(v2.value)) == null ? void 0 : h2[0]) == null ? void 0 : E.focus();
        })
      }, null, 40, Ic)
    ], 64));
  }
});
var Ac = ["autocomplete", "type", "inputmode", "pattern", "placeholder", "value", "disabled", "data-disabled", "data-complete", "aria-label"];
var fy = defineComponent({
  __name: "PinInputInput",
  props: {
    index: {},
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  setup(a2) {
    const t = a2, e = Tc(), n = computed(() => Array.from(e.inputElements.value)), l = computed(() => t.disabled || e.disabled.value), s = computed(() => e.otp.value), r = computed(() => e.type.value === "number"), i = computed(() => e.mask.value), u = ref();
    function d(h2) {
      var $2;
      const E = h2.target;
      if (((($2 = h2.data) == null ? void 0 : $2.length) ?? 0) > 1) {
        S(E.value);
        return;
      }
      if (r.value && !/^\d*$/.test(E.value)) {
        E.value = E.value.replace(/\D/g, "");
        return;
      }
      E.value = E.value.slice(-1), D(t.index, E.value);
      const P2 = n.value[t.index + 1];
      P2 && P2.focus();
    }
    function p(h2) {
      $t(h2, document.activeElement, void 0, {
        itemsArray: n.value,
        focus: true,
        loop: false,
        arrowKeyOptions: "horizontal",
        dir: e.dir.value
      });
    }
    function c(h2) {
      if (h2.preventDefault(), h2.target.value)
        D(t.index, "");
      else {
        const $2 = n.value[t.index - 1];
        $2 && ($2.focus(), D(t.index - 1, ""));
      }
    }
    function f(h2) {
      h2.key === "Delete" && (h2.preventDefault(), D(t.index, ""));
    }
    function v2(h2) {
      const E = h2.target;
      E.setSelectionRange(1, 1), E.value || (E.placeholder = "");
    }
    function g(h2) {
      const E = h2.target;
      nextTick(() => {
        E.value || (E.placeholder = e.placeholder.value);
      });
    }
    function m2(h2) {
      h2.preventDefault();
      const E = h2.clipboardData;
      if (!E)
        return;
      const P2 = E.getData("text");
      S(P2);
    }
    function S(h2) {
      var I;
      const E = [...e.modelValue.value], P2 = h2.length >= n.value.length ? 0 : t.index, $2 = Math.min(P2 + h2.length, n.value.length);
      for (let k = P2; k < $2; k++) {
        const L = n.value[k], O = h2[k - P2];
        r.value && !/^\d*$/.test(O) || (E[k] = O, L.focus());
      }
      e.modelValue.value = E, (I = n.value[$2]) == null || I.focus();
    }
    function x(h2) {
      let E = h2.length - 1;
      for (; E >= 0 && h2[E] === ""; )
        h2.pop(), E--;
      return h2;
    }
    function D(h2, E) {
      const P2 = [...e.modelValue.value];
      P2[h2] = E, e.modelValue.value = x(P2);
    }
    return onMounted(() => {
      e.onInputElementChange(u.value);
    }), onUnmounted(() => {
      var h2;
      (h2 = e.inputElements) == null || h2.value.delete(u.value);
    }), (h2, E) => (openBlock(), createElementBlock("input", {
      ref_key: "inputRef",
      ref: u,
      autocapitalize: "none",
      autocomplete: s.value ? "one-time-code" : "false",
      type: i.value ? "password" : "text",
      inputmode: r.value ? "numeric" : "text",
      pattern: r.value ? "[0-9]*" : void 0,
      placeholder: unref(e).placeholder.value,
      value: unref(e).modelValue.value.at(h2.index),
      disabled: l.value,
      "data-disabled": l.value ? "" : void 0,
      "data-complete": unref(e).isCompleted.value ? "" : void 0,
      "aria-label": `pin input ${h2.index + 1} of ${n.value.length}`,
      onInput: E[0] || (E[0] = (P2) => d(P2)),
      onKeydown: [
        withKeys(p, ["left", "right", "up", "down", "home", "end"]),
        withKeys(c, ["backspace"]),
        withKeys(f, ["delete"])
      ],
      onFocus: v2,
      onBlur: g,
      onPaste: m2
    }, null, 40, Ac));
  }
});
var [Mt, Oc] = Q("PopoverRoot");
var ds = defineComponent({
  __name: "PopoverRoot",
  props: {
    defaultOpen: { type: Boolean, default: false },
    open: { type: Boolean, default: void 0 },
    modal: { type: Boolean, default: false }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { modal: l } = toRefs(e), s = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    }), r = ref(), i = ref(false);
    return Oc({
      contentId: "",
      modal: l,
      open: s,
      onOpenChange: (u) => {
        s.value = u;
      },
      onOpenToggle: () => {
        s.value = !s.value;
      },
      triggerElement: r,
      hasCustomAnchor: i
    }), (u, d) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        renderSlot(u.$slots, "default", { open: unref(s) })
      ]),
      _: 3
    }));
  }
});
var cs = defineComponent({
  __name: "PopoverTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Mt(), { forwardRef: n, currentElement: l } = R2();
    return onMounted(() => {
      e.triggerElement.value = l.value;
    }), (s, r) => (openBlock(), createBlock(resolveDynamicComponent(unref(e).hasCustomAnchor.value ? unref(A2) : unref(Tt)), { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(n),
          type: s.as === "button" ? "button" : void 0,
          "aria-haspopup": "dialog",
          "aria-expanded": unref(e).open.value,
          "aria-controls": unref(e).contentId,
          "data-state": unref(e).open.value ? "open" : "closed",
          as: s.as,
          "as-child": t.asChild,
          onClick: unref(e).onOpenToggle
        }, {
          default: withCtx(() => [
            renderSlot(s.$slots, "default")
          ]),
          _: 3
        }, 8, ["type", "aria-expanded", "aria-controls", "data-state", "as", "as-child", "onClick"])
      ]),
      _: 3
    }));
  }
});
var ps = defineComponent({
  __name: "PopoverPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var fs = defineComponent({
  __name: "PopoverContentImpl",
  props: {
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Bt(e), { forwardRef: s } = R2(), r = Mt();
    return jn(), (i, u) => (openBlock(), createBlock(unref(Ga), {
      "as-child": "",
      loop: "",
      trapped: i.trapFocus,
      onMountAutoFocus: u[5] || (u[5] = (d) => n("openAutoFocus", d)),
      onUnmountAutoFocus: u[6] || (u[6] = (d) => n("closeAutoFocus", d))
    }, {
      default: withCtx(() => [
        createVNode(unref(yt), {
          "as-child": "",
          "disable-outside-pointer-events": i.disableOutsidePointerEvents,
          onPointerDownOutside: u[0] || (u[0] = (d) => n("pointerDownOutside", d)),
          onInteractOutside: u[1] || (u[1] = (d) => n("interactOutside", d)),
          onEscapeKeyDown: u[2] || (u[2] = (d) => n("escapeKeyDown", d)),
          onFocusOutside: u[3] || (u[3] = (d) => n("focusOutside", d)),
          onDismiss: u[4] || (u[4] = (d) => unref(r).onOpenChange(false))
        }, {
          default: withCtx(() => [
            createVNode(unref(Pt), mergeProps(unref(l), {
              id: unref(r).contentId,
              ref: unref(s),
              "data-state": unref(r).open.value ? "open" : "closed",
              role: "dialog",
              style: {
                "--radix-popover-content-transform-origin": "var(--radix-popper-transform-origin)",
                "--radix-popover-content-available-width": "var(--radix-popper-available-width)",
                "--radix-popover-content-available-height": "var(--radix-popper-available-height)",
                "--radix-popover-trigger-width": "var(--radix-popper-anchor-width)",
                "--radix-popover-trigger-height": "var(--radix-popper-anchor-height)"
              }
            }), {
              default: withCtx(() => [
                renderSlot(i.$slots, "default")
              ]),
              _: 3
            }, 16, ["id", "data-state"])
          ]),
          _: 3
        }, 8, ["disable-outside-pointer-events"])
      ]),
      _: 3
    }, 8, ["trapped"]));
  }
});
var kc = defineComponent({
  __name: "PopoverContentModal",
  props: {
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Mt(), s = ref(false);
    ma(true);
    const r = xe(e, n), { forwardRef: i, currentElement: u } = R2();
    return ha(u), (d, p) => (openBlock(), createBlock(fs, mergeProps(unref(r), {
      ref: unref(i),
      "trap-focus": unref(l).open.value,
      "disable-outside-pointer-events": "",
      onCloseAutoFocus: p[0] || (p[0] = withModifiers(
        (c) => {
          var f;
          n("closeAutoFocus", c), s.value || (f = unref(l).triggerElement.value) == null || f.focus();
        },
        ["prevent"]
      )),
      onPointerDownOutside: p[1] || (p[1] = (c) => {
        n("pointerDownOutside", c);
        const f = c.detail.originalEvent, v2 = f.button === 0 && f.ctrlKey === true, g = f.button === 2 || v2;
        s.value = g;
      }),
      onFocusOutside: p[2] || (p[2] = withModifiers(() => {
      }, ["prevent"]))
    }), {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 16, ["trap-focus"]));
  }
});
var Mc = defineComponent({
  __name: "PopoverContentNonModal",
  props: {
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Mt(), s = ref(false), r = ref(false), i = xe(e, n);
    return (u, d) => (openBlock(), createBlock(fs, mergeProps(unref(i), {
      "trap-focus": false,
      "disable-outside-pointer-events": false,
      onCloseAutoFocus: d[0] || (d[0] = (p) => {
        var c;
        n("closeAutoFocus", p), p.defaultPrevented || (s.value || (c = unref(l).triggerElement.value) == null || c.focus(), p.preventDefault()), s.value = false, r.value = false;
      }),
      onInteractOutside: d[1] || (d[1] = async (p) => {
        var v2;
        n("interactOutside", p), p.defaultPrevented || (s.value = true, p.detail.originalEvent.type === "pointerdown" && (r.value = true));
        const c = p.target;
        ((v2 = unref(l).triggerElement.value) == null ? void 0 : v2.contains(c)) && p.preventDefault(), p.detail.originalEvent.type === "focusin" && r.value && p.preventDefault();
      })
    }), {
      default: withCtx(() => [
        renderSlot(u.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var vs = defineComponent({
  __name: "PopoverContent",
  props: {
    forceMount: { type: Boolean },
    trapFocus: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    disableOutsidePointerEvents: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside", "focusOutside", "interactOutside", "openAutoFocus", "closeAutoFocus"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = Mt(), s = xe(e, n), { forwardRef: r } = R2();
    return l.contentId || (l.contentId = me(void 0, "radix-vue-popover-content")), (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(l).open.value
    }, {
      default: withCtx(() => [
        unref(l).modal.value ? (openBlock(), createBlock(kc, mergeProps({ key: 0 }, unref(s), { ref: unref(r) }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16)) : (openBlock(), createBlock(Mc, mergeProps({ key: 1 }, unref(s), { ref: unref(r) }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16))
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var ms = defineComponent({
  __name: "PopoverArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(qt), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var hs = defineComponent({
  __name: "PopoverClose",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Mt();
    return (n, l) => (openBlock(), createBlock(unref(A2), {
      type: n.as === "button" ? "button" : void 0,
      as: n.as,
      "as-child": t.asChild,
      onClick: l[0] || (l[0] = (s) => unref(e).onOpenChange(false))
    }, {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 8, ["type", "as", "as-child"]));
  }
});
var ys = defineComponent({
  __name: "PopoverAnchor",
  props: {
    element: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = Mt();
    return onBeforeMount(() => {
      e.hasCustomAnchor.value = true;
    }), onUnmounted(() => {
      e.hasCustomAnchor.value = false;
    }), (n, l) => (openBlock(), createBlock(unref(Tt), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var ua = 100;
var [Vc, Fc] = Q("ProgressRoot");
var So = (a2) => typeof a2 == "number";
function Lc(a2, t) {
  return Nt(a2) || So(a2) && !Number.isNaN(a2) && a2 <= t && a2 >= 0 ? a2 : (console.error(`Invalid prop \`value\` of value \`${a2}\` supplied to \`ProgressRoot\`. The \`value\` prop must be:
  - a positive number
  - less than the value passed to \`max\` (or ${ua} if no \`max\` prop is set)
  - \`null\`  or \`undefined\` if the progress is indeterminate.

Defaulting to \`null\`.`), null);
}
function Nc(a2) {
  return So(a2) && !Number.isNaN(a2) && a2 > 0 ? a2 : (console.error(
    `Invalid prop \`max\` of value \`${a2}\` supplied to \`ProgressRoot\`. Only numbers greater than 0 are valid max values. Defaulting to \`${ua}\`.`
  ), ua);
}
var vy = defineComponent({
  __name: "ProgressRoot",
  props: {
    modelValue: {},
    max: { default: ua },
    getValueLabel: { type: Function, default: (a2, t) => `${Math.round(a2 / t * ua)}%` },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "update:max"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    const l = ae(e, "modelValue", n, {
      passive: e.modelValue === void 0
    }), s = ae(e, "max", n, {
      passive: e.max === void 0
    });
    watch(
      () => l.value,
      async (i) => {
        const u = Lc(i, e.max);
        u !== i && (await nextTick(), l.value = u);
      },
      { immediate: true }
    ), watch(
      () => e.max,
      (i) => {
        const u = Nc(e.max);
        u !== i && (s.value = u);
      },
      { immediate: true }
    );
    const r = computed(() => Nt(l.value) ? "indeterminate" : l.value === s.value ? "complete" : "loading");
    return Fc({
      modelValue: l,
      max: s,
      progressState: r
    }), (i, u) => (openBlock(), createBlock(unref(A2), {
      "as-child": i.asChild,
      as: i.as,
      "aria-valuemax": unref(s),
      "aria-valuemin": 0,
      "aria-valuenow": So(unref(l)) ? unref(l) : void 0,
      "aria-valuetext": i.getValueLabel(unref(l), unref(s)),
      "aria-label": i.getValueLabel(unref(l), unref(s)),
      role: "progressbar",
      "data-state": r.value,
      "data-value": unref(l) ?? void 0,
      "data-max": unref(s)
    }, {
      default: withCtx(() => [
        renderSlot(i.$slots, "default", { modelValue: unref(l) })
      ]),
      _: 3
    }, 8, ["as-child", "as", "aria-valuemax", "aria-valuenow", "aria-valuetext", "aria-label", "data-state", "data-value", "data-max"]));
  }
});
var my = defineComponent({
  __name: "ProgressIndicator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = Vc();
    return R2(), (n, l) => {
      var s;
      return openBlock(), createBlock(unref(A2), mergeProps(t, {
        "data-state": unref(e).progressState.value,
        "data-value": ((s = unref(e).modelValue) == null ? void 0 : s.value) ?? void 0,
        "data-max": unref(e).max.value
      }), {
        default: withCtx(() => [
          renderSlot(n.$slots, "default")
        ]),
        _: 3
      }, 16, ["data-state", "data-value", "data-max"]);
    };
  }
});
var [zc, Kc] = Q("RadioGroupRoot");
var hy = defineComponent({
  __name: "RadioGroupRoot",
  props: {
    modelValue: {},
    defaultValue: {},
    disabled: { type: Boolean, default: false },
    name: {},
    required: { type: Boolean, default: false },
    orientation: { default: void 0 },
    dir: {},
    loop: { type: Boolean, default: true },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l } = R2(), s = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), { disabled: r, loop: i, orientation: u, name: d, required: p, dir: c } = toRefs(e), f = Ce(c);
    return Kc({
      modelValue: s,
      changeModelValue: (v2) => {
        s.value = v2;
      },
      disabled: r,
      loop: i,
      orientation: u,
      name: d == null ? void 0 : d.value,
      required: p
    }), (v2, g) => (openBlock(), createBlock(unref(At), {
      "as-child": "",
      orientation: unref(u),
      dir: unref(f),
      loop: unref(i)
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(l),
          role: "radiogroup",
          "data-disabled": unref(r) ? "" : void 0,
          "as-child": v2.asChild,
          as: v2.as,
          required: unref(p),
          "aria-orientation": unref(u),
          "aria-required": unref(p),
          dir: unref(f),
          name: unref(d)
        }, {
          default: withCtx(() => [
            renderSlot(v2.$slots, "default", { modelValue: unref(s) })
          ]),
          _: 3
        }, 8, ["data-disabled", "as-child", "as", "required", "aria-orientation", "aria-required", "dir", "name"])
      ]),
      _: 3
    }, 8, ["orientation", "dir", "loop"]));
  }
});
var Hc = ["value", "checked", "name", "disabled", "required"];
var Wc = defineComponent({
  __name: "Radio",
  props: {
    id: {},
    value: {},
    disabled: { type: Boolean, default: false },
    required: { type: Boolean },
    checked: { type: Boolean, default: void 0 },
    name: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  emits: ["update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, l = ae(e, "checked", t, {
      passive: e.checked === void 0
    }), { value: s } = toRefs(e), { forwardRef: r, currentElement: i } = R2(), u = Qe(i), d = computed(() => {
      var c;
      return e.id && i.value ? ((c = document.querySelector(`[for="${e.id}"]`)) == null ? void 0 : c.innerText) ?? e.value : void 0;
    });
    function p(c) {
      l.value = true, u.value && c.stopPropagation();
    }
    return (c, f) => (openBlock(), createBlock(unref(A2), mergeProps(c.$attrs, {
      id: c.id,
      ref: unref(r),
      role: "radio",
      type: c.as === "button" ? "button" : void 0,
      as: c.as,
      "aria-checked": unref(l),
      "aria-label": d.value,
      "as-child": c.asChild,
      disabled: c.disabled ? "" : void 0,
      "data-state": unref(l) ? "checked" : "unchecked",
      "data-disabled": c.disabled ? "" : void 0,
      value: unref(s),
      required: c.required,
      name: c.name,
      onClick: withModifiers(p, ["stop"])
    }), {
      default: withCtx(() => [
        renderSlot(c.$slots, "default", { checked: unref(l) }),
        unref(u) ? (openBlock(), createElementBlock("input", {
          key: 0,
          type: "radio",
          tabindex: "-1",
          "aria-hidden": "",
          value: unref(s),
          checked: !!unref(l),
          name: c.name,
          disabled: c.disabled,
          required: c.required,
          style: {
            transform: "translateX(-100%)",
            position: "absolute",
            pointerEvents: "none",
            opacity: 0,
            margin: 0
          }
        }, null, 8, Hc)) : createCommentVNode("", true)
      ]),
      _: 3
    }, 16, ["id", "type", "as", "aria-checked", "aria-label", "as-child", "disabled", "data-state", "data-disabled", "value", "required", "name"]));
  }
});
var [jc, Uc] = Q("RadioGroupItem");
var yy = defineComponent({
  inheritAttrs: false,
  __name: "RadioGroupItem",
  props: {
    id: {},
    value: {},
    disabled: { type: Boolean, default: false },
    required: { type: Boolean },
    name: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, { forwardRef: e, currentElement: n } = R2(), l = zc(), s = computed(() => l.disabled.value || t.disabled), r = computed(() => l.required.value || t.required), i = computed(() => {
      var c;
      return ((c = l.modelValue) == null ? void 0 : c.value) === t.value;
    });
    Uc({ disabled: s, checked: i });
    const u = ref(false), d = ["ArrowUp", "ArrowDown", "ArrowLeft", "ArrowRight"];
    je("keydown", (c) => {
      d.includes(c.key) && (u.value = true);
    }), je("keyup", () => {
      u.value = false;
    });
    function p() {
      setTimeout(() => {
        var c;
        u.value && ((c = n.value) == null || c.click());
      }, 0);
    }
    return (c, f) => (openBlock(), createBlock(unref(Ot), {
      checked: i.value,
      disabled: s.value,
      "as-child": "",
      focusable: !s.value,
      active: i.value
    }, {
      default: withCtx(() => [
        createVNode(Wc, mergeProps({ ...c.$attrs, ...t }, {
          ref: unref(e),
          checked: i.value,
          required: r.value,
          disabled: s.value,
          "onUpdate:checked": f[0] || (f[0] = (v2) => unref(l).changeModelValue(c.value)),
          onKeydown: f[1] || (f[1] = withKeys(withModifiers(() => {
          }, ["prevent"]), ["enter"])),
          onFocus: p
        }), {
          default: withCtx(() => [
            renderSlot(c.$slots, "default")
          ]),
          _: 3
        }, 16, ["checked", "required", "disabled"])
      ]),
      _: 3
    }, 8, ["checked", "disabled", "focusable", "active"]));
  }
});
var gy = defineComponent({
  __name: "RadioGroupIndicator",
  props: {
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const { forwardRef: t } = R2(), e = jc();
    return (n, l) => (openBlock(), createBlock(unref(Pe), {
      present: n.forceMount || unref(e).checked.value
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(t),
          "data-state": unref(e).checked.value ? "checked" : "unchecked",
          "data-disabled": unref(e).disabled.value ? "" : void 0,
          "as-child": n.asChild,
          as: n.as
        }, n.$attrs), {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 16, ["data-state", "data-disabled", "as-child", "as"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
function Gc(a2) {
  const t = computed(() => a2.start.value ? !!a2.isDateDisabled(a2.start.value) : false), e = computed(() => a2.end.value ? !!a2.isDateDisabled(a2.end.value) : false), n = computed(
    () => t.value || e.value ? false : !!(a2.start.value && a2.end.value && q(a2.end.value, a2.start.value))
  ), l = (u) => a2.start.value ? $14e0f24ef4ac5c92$export$ea39ec197993aef0(a2.start.value, u) : false, s = (u) => a2.end.value ? $14e0f24ef4ac5c92$export$ea39ec197993aef0(a2.end.value, u) : false, r = (u) => a2.start.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(a2.start.value, u) || a2.end.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(a2.end.value, u) ? true : a2.end.value && a2.start.value ? v(u, a2.start.value, a2.end.value) : false, i = computed(() => {
    if (a2.start.value && a2.end.value || !a2.start.value || !a2.focusedValue.value)
      return null;
    const u = q(a2.start.value, a2.focusedValue.value), d = u ? a2.start.value : a2.focusedValue.value, p = u ? a2.focusedValue.value : a2.start.value;
    return $14e0f24ef4ac5c92$export$ea39ec197993aef0(d.add({ days: 1 }), p) ? {
      start: d,
      end: p
    } : b(d, p, a2.isDateUnavailable, a2.isDateDisabled) ? {
      start: d,
      end: p
    } : null;
  });
  return {
    isInvalid: n,
    isSelected: r,
    highlightedRange: i,
    isSelectionStart: l,
    isSelectionEnd: s
  };
}
var qc = { style: { border: "0px", clip: "rect(0px, 0px, 0px, 0px)", "clip-path": "inset(50%)", height: "1px", margin: "-1px", overflow: "hidden", padding: "0px", position: "absolute", "white-space": "nowrap", width: "1px" } };
var Yc = {
  role: "heading",
  "aria-level": "2"
};
var [ea, Xc] = Q("RangeCalendarRoot");
var Zc = defineComponent({
  __name: "RangeCalendarRoot",
  props: {
    defaultPlaceholder: {},
    defaultValue: { default: () => ({ start: void 0, end: void 0 }) },
    modelValue: {},
    placeholder: { default: void 0 },
    pagedNavigation: { type: Boolean, default: false },
    preventDeselect: { type: Boolean, default: false },
    weekStartsOn: { default: 0 },
    weekdayFormat: { default: "narrow" },
    calendarLabel: {},
    fixedWeeks: { type: Boolean, default: false },
    maxValue: {},
    minValue: {},
    locale: { default: "en" },
    numberOfMonths: { default: 1 },
    disabled: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    initialFocus: { type: Boolean, default: false },
    isDateDisabled: { type: Function, default: void 0 },
    isDateUnavailable: { type: Function, default: void 0 },
    dir: {},
    nextPage: {},
    prevPage: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  emits: ["update:modelValue", "update:placeholder", "update:startValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, {
      disabled: l,
      readonly: s,
      initialFocus: r,
      pagedNavigation: i,
      weekStartsOn: u,
      weekdayFormat: d,
      fixedWeeks: p,
      numberOfMonths: c,
      preventDeselect: f,
      isDateUnavailable: v2,
      isDateDisabled: g,
      calendarLabel: m2,
      maxValue: S,
      minValue: x,
      locale: D,
      dir: h2,
      nextPage: E,
      prevPage: P2
    } = toRefs(e), { primitiveElement: $2, currentElement: I } = Re(), k = Ce(h2), L = ref(), O = ref(), V2 = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), H2 = jt({
      defaultPlaceholder: e.placeholder,
      defaultValue: V2.value.start
    }), Y = ref(V2.value.start), J2 = ref(V2.value.end), N2 = ae(e, "placeholder", n, {
      defaultValue: e.defaultPlaceholder ?? H2.copy(),
      passive: e.placeholder === void 0
    });
    function F(be) {
      N2.value = be.copy();
    }
    const {
      fullCalendarLabel: W2,
      headingValue: z2,
      isDateDisabled: Z,
      isDateUnavailable: U,
      isNextButtonDisabled: X,
      isPrevButtonDisabled: ee,
      grid: fe,
      weekdays: G2,
      isOutsideVisibleView: oe,
      nextPage: he,
      prevPage: we,
      formatter: ge
    } = Kl({
      locale: D,
      placeholder: N2,
      weekStartsOn: u,
      fixedWeeks: p,
      numberOfMonths: c,
      minValue: x,
      maxValue: S,
      disabled: l,
      weekdayFormat: d,
      pagedNavigation: i,
      isDateDisabled: g.value,
      isDateUnavailable: v2.value,
      calendarLabel: m2,
      nextPage: E,
      prevPage: P2
    }), {
      isInvalid: De,
      isSelected: ue,
      highlightedRange: Se,
      isSelectionStart: Ve,
      isSelectionEnd: Ke
    } = Gc({
      start: Y,
      end: J2,
      isDateDisabled: Z,
      isDateUnavailable: U,
      focusedValue: O
    });
    return watch(V2, (be) => {
      be.start && be.end && (Y.value && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(Y.value, be.start) && (Y.value = be.start.copy()), J2.value && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(J2.value, be.end) && (J2.value = be.end.copy()));
    }), watch(Y, (be) => {
      be && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(be, N2.value) && F(be), n("update:startValue", be);
    }), watch([Y, J2], ([be, ot]) => {
      const He = V2.value;
      if (!(He && He.start && He.end && be && ot && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(He.start, be) && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(He.end, ot)))
        if (be && ot) {
          if (He.start && He.end && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(He.start, be) && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(He.end, ot))
            return;
          q(ot, be) ? V2.value = {
            start: ot.copy(),
            end: be.copy()
          } : V2.value = {
            start: be.copy(),
            end: ot.copy()
          };
        } else He.start && He.end && (V2.value = {
          start: void 0,
          end: void 0
        });
    }), Xc({
      isDateUnavailable: U,
      startValue: Y,
      endValue: J2,
      formatter: ge,
      modelValue: V2,
      placeholder: N2,
      disabled: l,
      initialFocus: r,
      pagedNavigation: i,
      weekStartsOn: u,
      weekdayFormat: d,
      fixedWeeks: p,
      numberOfMonths: c,
      readonly: s,
      preventDeselect: f,
      fullCalendarLabel: W2,
      headingValue: z2,
      isInvalid: De,
      isDateDisabled: Z,
      highlightedRange: Se,
      focusedValue: O,
      lastPressedDateValue: L,
      isSelected: ue,
      isSelectionEnd: Ke,
      isSelectionStart: Ve,
      isNextButtonDisabled: X,
      isPrevButtonDisabled: ee,
      isOutsideVisibleView: oe,
      nextPage: he,
      prevPage: we,
      parentElement: I,
      onPlaceholderChange: F,
      locale: D,
      dir: k
    }), onMounted(() => {
      r.value && gl(I.value);
    }), (be, ot) => (openBlock(), createBlock(unref(A2), {
      ref_key: "primitiveElement",
      ref: $2,
      as: be.as,
      "as-child": be.asChild,
      role: "application",
      "aria-label": unref(W2),
      "data-readonly": unref(s) ? "" : void 0,
      "data-disabled": unref(l) ? "" : void 0,
      "data-invalid": unref(De) ? "" : void 0,
      dir: unref(k)
    }, {
      default: withCtx(() => [
        createBaseVNode("div", qc, [
          createBaseVNode("div", Yc, toDisplayString(unref(W2)), 1)
        ]),
        renderSlot(be.$slots, "default", {
          date: unref(N2),
          grid: unref(fe),
          weekDays: unref(G2),
          weekStartsOn: unref(u),
          locale: unref(D),
          fixedWeeks: unref(p)
        })
      ]),
      _: 3
    }, 8, ["as", "as-child", "aria-label", "data-readonly", "data-disabled", "data-invalid", "dir"]));
  }
});
var Jc = defineComponent({
  __name: "RangeCalendarHeader",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Qc = defineComponent({
  __name: "RangeCalendarHeading",
  props: {
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = ea();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "data-disabled": unref(e).disabled.value ? "" : void 0
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {
          headingValue: unref(e).headingValue.value
        }, () => [
          createTextVNode(toDisplayString(unref(e).headingValue.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["data-disabled"]));
  }
});
var ep = defineComponent({
  __name: "RangeCalendarGrid",
  props: {
    asChild: { type: Boolean },
    as: { default: "table" }
  },
  setup(a2) {
    const t = a2, e = ea();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      tabindex: "-1",
      role: "grid",
      "aria-readonly": unref(e).readonly ? true : void 0,
      "aria-disabled": unref(e).disabled ? true : void 0,
      "data-readonly": unref(e).readonly ? "" : void 0,
      "data-disabled": unref(e).disabled ? "" : void 0
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-readonly", "aria-disabled", "data-readonly", "data-disabled"]));
  }
});
var tp = defineComponent({
  __name: "RangeCalendarCell",
  props: {
    date: {},
    asChild: { type: Boolean },
    as: { default: "td" }
  },
  setup(a2) {
    const t = ea();
    return (e, n) => {
      var l, s;
      return openBlock(), createBlock(unref(A2), {
        as: e.as,
        "as-child": e.asChild,
        role: "gridcell",
        "aria-selected": unref(t).isSelected(e.date) ? true : void 0,
        "aria-disabled": unref(t).isDateDisabled(e.date) || ((s = (l = unref(t)).isDateUnavailable) == null ? void 0 : s.call(l, e.date)),
        "data-disabled": unref(t).isDateDisabled(e.date) ? "" : void 0
      }, {
        default: withCtx(() => [
          renderSlot(e.$slots, "default")
        ]),
        _: 3
      }, 8, ["as", "as-child", "aria-selected", "aria-disabled", "data-disabled"]);
    };
  }
});
var ap = defineComponent({
  __name: "RangeCalendarHeadCell",
  props: {
    asChild: { type: Boolean },
    as: { default: "th" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var np = defineComponent({
  __name: "RangeCalendarNext",
  props: {
    step: {},
    nextPage: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = ea();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "Next page",
      type: n.as === "button" ? "button" : void 0,
      "aria-disabled": unref(e).isNextButtonDisabled(t.step, t.nextPage) || void 0,
      "data-disabled": unref(e).isNextButtonDisabled(t.step, t.nextPage) || void 0,
      disabled: unref(e).isNextButtonDisabled(t.step, t.nextPage),
      onClick: l[0] || (l[0] = (s) => unref(e).nextPage(t.step, t.nextPage))
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Next page")
        ])
      ]),
      _: 3
    }, 16, ["type", "aria-disabled", "data-disabled", "disabled"]));
  }
});
var op = defineComponent({
  __name: "RangeCalendarPrev",
  props: {
    step: {},
    prevPage: {},
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = ea();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      "aria-label": "Previous page",
      type: n.as === "button" ? "button" : void 0,
      "aria-disabled": unref(e).isPrevButtonDisabled(t.step, t.prevPage) || void 0,
      "data-disabled": unref(e).isPrevButtonDisabled(t.step, t.prevPage) || void 0,
      disabled: unref(e).isPrevButtonDisabled(t.step, t.prevPage),
      onClick: l[0] || (l[0] = (s) => unref(e).prevPage(t.step, t.prevPage))
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode("Prev page")
        ])
      ]),
      _: 3
    }, 16, ["type", "aria-disabled", "data-disabled", "disabled"]));
  }
});
var lp = defineComponent({
  __name: "RangeCalendarGridHead",
  props: {
    asChild: { type: Boolean },
    as: { default: "thead" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), mergeProps(t, { "aria-hidden": "true" }), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var sp = defineComponent({
  __name: "RangeCalendarGridBody",
  props: {
    asChild: { type: Boolean },
    as: { default: "tbody" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var rp = defineComponent({
  __name: "RangeCalendarGridRow",
  props: {
    asChild: { type: Boolean },
    as: { default: "tr" }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var ip = defineComponent({
  __name: "RangeCalendarCellTrigger",
  props: {
    day: {},
    month: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = ea(), n = et(), { primitiveElement: l, currentElement: s } = Re(), r = computed(() => e.formatter.custom($(t.day), {
      weekday: "long",
      month: "long",
      day: "numeric",
      year: "numeric"
    })), i = computed(() => e.isDateDisabled(t.day)), u = computed(() => {
      var I;
      return (I = e.isDateUnavailable) == null ? void 0 : I.call(e, t.day);
    }), d = computed(() => e.isSelected(t.day)), p = computed(() => e.isSelectionStart(t.day)), c = computed(() => e.isSelectionEnd(t.day)), f = computed(() => e.highlightedRange.value ? V(t.day, e.highlightedRange.value.start, e.highlightedRange.value.end) : false), v2 = "[data-radix-vue-calendar-cell-trigger]:not([data-disabled]):not([data-outside-month]):not([data-outside-visible-months])", g = computed(() => $14e0f24ef4ac5c92$export$629b0a497aa65267(t.day, $14e0f24ef4ac5c92$export$aa8b41735afcabd2())), m2 = computed(() => !$14e0f24ef4ac5c92$export$a18c89cbd24170ff(t.day, t.month)), S = computed(
      () => e.isOutsideVisibleView(t.day)
    ), x = computed(() => t.day.day.toLocaleString(e.locale.value)), D = computed(() => $14e0f24ef4ac5c92$export$ea39ec197993aef0(t.day, e.placeholder.value));
    function h2(I) {
      var k;
      if (!e.readonly.value && !(e.isDateDisabled(I) || (k = e.isDateUnavailable) != null && k.call(e, I))) {
        if (e.lastPressedDateValue.value = I.copy(), e.startValue.value && e.highlightedRange.value === null) {
          if ($14e0f24ef4ac5c92$export$ea39ec197993aef0(I, e.startValue.value) && !e.preventDeselect.value && !e.endValue.value) {
            e.startValue.value = void 0, e.onPlaceholderChange(I);
            return;
          } else if (!e.endValue.value) {
            e.lastPressedDateValue.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(e.lastPressedDateValue.value, I) && (e.startValue.value = I.copy());
            return;
          }
        }
        if (e.startValue.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(e.startValue.value, I) && !e.preventDeselect.value && !e.endValue.value) {
          e.startValue.value = void 0, e.onPlaceholderChange(I);
          return;
        }
        e.startValue.value ? e.endValue.value ? e.endValue.value && e.startValue.value && (e.endValue.value = void 0, e.startValue.value = I.copy()) : e.endValue.value = I.copy() : e.startValue.value = I.copy();
      }
    }
    function E() {
      h2(t.day);
    }
    function P2() {
      var I;
      e.isDateDisabled(t.day) || (I = e.isDateUnavailable) != null && I.call(e, t.day) || (e.focusedValue.value = t.day.copy());
    }
    function $2(I) {
      I.preventDefault(), I.stopPropagation();
      const k = e.parentElement.value, L = k ? Array.from(k.querySelectorAll(v2)) : [];
      let V2 = L.indexOf(s.value);
      const H2 = 7, Y = e.dir.value === "rtl" ? -1 : 1;
      switch (I.code) {
        case n.ARROW_RIGHT:
          V2 += Y;
          break;
        case n.ARROW_LEFT:
          V2 -= Y;
          break;
        case n.ARROW_UP:
          V2 -= H2;
          break;
        case n.ARROW_DOWN:
          V2 += H2;
          break;
        case n.ENTER:
        case n.SPACE_CODE:
          h2(t.day);
          return;
        default:
          return;
      }
      if (V2 >= 0 && V2 < L.length) {
        L[V2].focus();
        return;
      }
      if (V2 < 0) {
        if (e.isPrevButtonDisabled("month"))
          return;
        e.prevPage(), nextTick(() => {
          const J2 = k ? Array.from(k.querySelectorAll(v2)) : [];
          J2[J2.length - Math.abs(V2)].focus();
        });
        return;
      }
      if (V2 >= L.length) {
        if (e.isNextButtonDisabled("month"))
          return;
        e.nextPage(), nextTick(() => {
          (k ? Array.from(k.querySelectorAll(v2)) : [])[V2 - L.length].focus();
        });
      }
    }
    return (I, k) => (openBlock(), createBlock(unref(A2), mergeProps({
      ref_key: "primitiveElement",
      ref: l
    }, t, {
      role: "button",
      "aria-label": r.value,
      "data-radix-vue-calendar-cell-trigger": "",
      "aria-selected": d.value ? true : void 0,
      "aria-disabled": m2.value || i.value || u.value ? true : void 0,
      "data-highlighted": f.value ? "" : void 0,
      "data-selection-start": p.value ? true : void 0,
      "data-selection-end": c.value ? true : void 0,
      "data-selected": d.value ? true : void 0,
      "data-outside-visible-view": S.value ? "" : void 0,
      "data-value": I.day.toString(),
      "data-disabled": i.value || m2.value ? "" : void 0,
      "data-unavailable": u.value ? "" : void 0,
      "data-today": g.value ? "" : void 0,
      "data-outside-month": m2.value ? "" : void 0,
      "data-focused": D.value ? "" : void 0,
      tabindex: D.value ? 0 : m2.value || i.value ? void 0 : -1,
      onClick: E,
      onFocusin: P2,
      onMouseenter: P2,
      onKeydown: withKeys($2, ["up", "down", "left", "right", "enter", "space"])
    }), {
      default: withCtx(() => [
        renderSlot(I.$slots, "default", { dayValue: x.value }, () => [
          createTextVNode(toDisplayString(x.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["aria-label", "aria-selected", "aria-disabled", "data-highlighted", "data-selection-start", "data-selection-end", "data-selected", "data-outside-visible-view", "data-value", "data-disabled", "data-unavailable", "data-today", "data-outside-month", "data-focused", "tabindex"]));
  }
});
var [ze, up] = Q("ScrollAreaRoot");
var by = defineComponent({
  __name: "ScrollAreaRoot",
  props: {
    type: { default: "hover" },
    dir: {},
    scrollHideDelay: { default: 600 },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2, { expose: t }) {
    const e = a2, n = ref(0), l = ref(0), s = ref(), r = ref(), i = ref(), u = ref(), d = ref(false), p = ref(false), { type: c, dir: f, scrollHideDelay: v2 } = toRefs(e), g = Ce(f);
    function m2() {
      var h2;
      (h2 = s.value) == null || h2.scrollTo({
        top: 0
      });
    }
    function S() {
      var h2;
      (h2 = s.value) == null || h2.scrollTo({
        top: 0,
        left: 0
      });
    }
    t({
      /** Viewport element within ScrollArea */
      viewport: s,
      /** Scroll viewport to top */
      scrollTop: m2,
      /** Scroll viewport to top-left */
      scrollTopLeft: S
    });
    const { forwardRef: x, currentElement: D } = R2();
    return up({
      type: c,
      dir: g,
      scrollHideDelay: v2,
      scrollArea: D,
      viewport: s,
      onViewportChange: (h2) => {
        s.value = h2 || void 0;
      },
      content: r,
      onContentChange: (h2) => {
        r.value = h2;
      },
      scrollbarX: i,
      scrollbarXEnabled: d,
      scrollbarY: u,
      scrollbarYEnabled: p,
      onScrollbarXChange: (h2) => {
        i.value = h2 || void 0;
      },
      onScrollbarYChange: (h2) => {
        u.value = h2 || void 0;
      },
      onScrollbarXEnabledChange: (h2) => {
        d.value = h2;
      },
      onScrollbarYEnabledChange: (h2) => {
        p.value = h2;
      },
      onCornerWidthChange: (h2) => {
        n.value = h2;
      },
      onCornerHeightChange: (h2) => {
        l.value = h2;
      }
    }), (h2, E) => (openBlock(), createBlock(unref(A2), {
      ref: unref(x),
      "as-child": e.asChild,
      as: h2.as,
      dir: unref(g),
      style: normalizeStyle({
        position: "relative",
        // Pass corner sizes as CSS vars to reduce re-renders of context consumers
        "--radix-scroll-area-corner-width": `${n.value}px`,
        "--radix-scroll-area-corner-height": `${l.value}px`
      })
    }, {
      default: withCtx(() => [
        renderSlot(h2.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as", "dir", "style"]));
  }
});
var Cy = defineComponent({
  inheritAttrs: false,
  __name: "ScrollAreaViewport",
  props: {
    nonce: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2, { expose: t }) {
    const e = a2, { nonce: n } = toRefs(e), l = qa(n), s = ze(), r = ref();
    onMounted(() => {
      s.onViewportChange(r.value), s.onContentChange(u.value);
    }), t({
      viewportElement: r
    });
    const { forwardRef: i, currentElement: u } = R2();
    return (d, p) => (openBlock(), createElementBlock(Fragment, null, [
      createBaseVNode("div", mergeProps({
        ref_key: "viewportElement",
        ref: r,
        "data-radix-scroll-area-viewport": "",
        style: {
          /**
           * We don't support `visible` because the intention is to have at least one scrollbar
           * if this component is used and `visible` will behave like `auto` in that case
           * https://developer.mozilla.org/en-US/docs/Web/CSS/overflowed#description
           *
           * We don't handle `auto` because the intention is for the native implementation
           * to be hidden if using this component. We just want to ensure the node is scrollable
           * so could have used either `scroll` or `auto` here. We picked `scroll` to prevent
           * the browser from having to work out whether to render native scrollbars or not,
           * we tell it to with the intention of hiding them in CSS.
           */
          overflowX: unref(s).scrollbarXEnabled.value ? "scroll" : "hidden",
          overflowY: unref(s).scrollbarYEnabled.value ? "scroll" : "hidden"
        }
      }, d.$attrs, { tabindex: 0 }), [
        createVNode(unref(A2), {
          ref: unref(i),
          style: { minWidth: "100%", display: "table" },
          "as-child": e.asChild,
          as: d.as
        }, {
          default: withCtx(() => [
            renderSlot(d.$slots, "default")
          ]),
          _: 3
        }, 8, ["as-child", "as"])
      ], 16),
      createVNode(unref(A2), {
        as: "style",
        nonce: unref(l)
      }, {
        default: withCtx(() => [
          createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-radix-scroll-area-viewport] { scrollbar-width:none; -ms-overflow-style:none; -webkit-overflow-scrolling:touch; } [data-radix-scroll-area-viewport]::-webkit-scrollbar { display:none; } ")
        ]),
        _: 1
      }, 8, ["nonce"])
    ], 64));
  }
});
function gs(a2, t) {
  return (e) => {
    if (a2[0] === a2[1] || t[0] === t[1])
      return t[0];
    const n = (t[1] - t[0]) / (a2[1] - a2[0]);
    return t[0] + n * (e - a2[0]);
  };
}
function tn(a2) {
  const t = bs(a2.viewport, a2.content), e = a2.scrollbar.paddingStart + a2.scrollbar.paddingEnd, n = (a2.scrollbar.size - e) * t;
  return Math.max(n, 18);
}
function bs(a2, t) {
  const e = a2 / t;
  return Number.isNaN(e) ? 0 : e;
}
function dp(a2, t = () => {
}) {
  let e = { left: a2.scrollLeft, top: a2.scrollTop }, n = 0;
  return function l() {
    const s = { left: a2.scrollLeft, top: a2.scrollTop }, r = e.left !== s.left, i = e.top !== s.top;
    (r || i) && t(), e = s, n = window.requestAnimationFrame(l);
  }(), () => window.cancelAnimationFrame(n);
}
function qo(a2, t, e = "ltr") {
  const n = tn(t), l = t.scrollbar.paddingStart + t.scrollbar.paddingEnd, s = t.scrollbar.size - l, r = t.content - t.viewport, i = s - n, u = e === "ltr" ? [0, r] : [r * -1, 0], d = Kt(
    a2,
    u[0],
    u[1]
  );
  return gs([0, r], [0, i])(d);
}
function Ba(a2) {
  return a2 ? Number.parseInt(a2, 10) : 0;
}
function cp(a2, t, e, n = "ltr") {
  const l = tn(e), s = l / 2, r = t || s, i = l - r, u = e.scrollbar.paddingStart + r, d = e.scrollbar.size - e.scrollbar.paddingEnd - i, p = e.content - e.viewport, c = n === "ltr" ? [0, p] : [p * -1, 0];
  return gs(
    [u, d],
    c
  )(a2);
}
function Yo(a2, t) {
  return a2 > 0 && a2 < t;
}
var Cs = defineComponent({
  __name: "ScrollAreaScrollbarImpl",
  props: {
    isHorizontal: { type: Boolean }
  },
  emits: ["onDragScroll", "onWheelScroll", "onThumbPointerDown"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = ze(), s = an(), r = nn(), { forwardRef: i, currentElement: u } = R2(), d = ref(""), p = ref();
    function c(x) {
      var D, h2;
      if (p.value) {
        const E = x.clientX - ((D = p.value) == null ? void 0 : D.left), P2 = x.clientY - ((h2 = p.value) == null ? void 0 : h2.top);
        n("onDragScroll", { x: E, y: P2 });
      }
    }
    function f(x) {
      x.button === 0 && (x.target.setPointerCapture(x.pointerId), p.value = u.value.getBoundingClientRect(), d.value = document.body.style.webkitUserSelect, document.body.style.webkitUserSelect = "none", l.viewport && (l.viewport.value.style.scrollBehavior = "auto"), c(x));
    }
    function v2(x) {
      c(x);
    }
    function g(x) {
      const D = x.target;
      D.hasPointerCapture(x.pointerId) && D.releasePointerCapture(x.pointerId), document.body.style.webkitUserSelect = d.value, l.viewport && (l.viewport.value.style.scrollBehavior = ""), p.value = void 0;
    }
    function m2(x) {
      var P2;
      const D = x.target, h2 = (P2 = u.value) == null ? void 0 : P2.contains(D), E = s.sizes.value.content - s.sizes.value.viewport;
      h2 && s.handleWheelScroll(x, E);
    }
    onMounted(() => {
      document.addEventListener("wheel", m2, { passive: false });
    }), onUnmounted(() => {
      document.removeEventListener("wheel", m2);
    });
    function S() {
      var x, D, h2, E, P2;
      u.value && (e.isHorizontal ? s.handleSizeChange({
        content: ((x = l.viewport.value) == null ? void 0 : x.scrollWidth) ?? 0,
        viewport: ((D = l.viewport.value) == null ? void 0 : D.offsetWidth) ?? 0,
        scrollbar: {
          size: u.value.clientWidth ?? 0,
          paddingStart: Ba(getComputedStyle(u.value).paddingLeft),
          paddingEnd: Ba(getComputedStyle(u.value).paddingRight)
        }
      }) : s.handleSizeChange({
        content: ((h2 = l.viewport.value) == null ? void 0 : h2.scrollHeight) ?? 0,
        viewport: ((E = l.viewport.value) == null ? void 0 : E.offsetHeight) ?? 0,
        scrollbar: {
          size: ((P2 = u.value) == null ? void 0 : P2.clientHeight) ?? 0,
          paddingStart: Ba(getComputedStyle(u.value).paddingLeft),
          paddingEnd: Ba(getComputedStyle(u.value).paddingRight)
        }
      }));
    }
    return Ze(u, S), Ze(l.content, S), (x, D) => (openBlock(), createBlock(unref(A2), {
      ref: unref(i),
      style: { position: "absolute" },
      "data-scrollbarimpl": "",
      as: unref(r).as.value,
      "as-child": unref(r).asChild.value,
      onPointerdown: f,
      onPointermove: v2,
      onPointerup: g
    }, {
      default: withCtx(() => [
        renderSlot(x.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "as-child"]));
  }
});
var pp = defineComponent({
  __name: "ScrollAreaScrollbarX",
  setup(a2) {
    const t = ze(), e = an(), { forwardRef: n, currentElement: l } = R2();
    onMounted(() => {
      l.value && t.onScrollbarXChange(l.value);
    });
    const s = computed(() => e.sizes.value);
    return (r, i) => (openBlock(), createBlock(Cs, {
      ref: unref(n),
      "is-horizontal": true,
      "data-orientation": "horizontal",
      style: normalizeStyle({
        bottom: 0,
        left: unref(t).dir.value === "rtl" ? "var(--radix-scroll-area-corner-width)" : 0,
        right: unref(t).dir.value === "ltr" ? "var(--radix-scroll-area-corner-width)" : 0,
        "--radix-scroll-area-thumb-width": s.value ? `${unref(tn)(s.value)}px` : void 0
      }),
      onOnDragScroll: i[0] || (i[0] = (u) => unref(e).onDragScroll(u.x))
    }, {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 8, ["style"]));
  }
});
var fp = defineComponent({
  __name: "ScrollAreaScrollbarY",
  setup(a2) {
    const t = ze(), e = an(), { forwardRef: n, currentElement: l } = R2();
    onMounted(() => {
      l.value && t.onScrollbarYChange(l.value);
    });
    const s = computed(() => e.sizes.value);
    return (r, i) => (openBlock(), createBlock(Cs, {
      ref: unref(n),
      "is-horizontal": false,
      "data-orientation": "vertical",
      style: normalizeStyle({
        top: 0,
        right: unref(t).dir.value === "ltr" ? 0 : void 0,
        left: unref(t).dir.value === "rtl" ? 0 : void 0,
        bottom: "var(--radix-scroll-area-corner-height)",
        "--radix-scroll-area-thumb-height": s.value ? `${unref(tn)(s.value)}px` : void 0
      }),
      onOnDragScroll: i[0] || (i[0] = (u) => unref(e).onDragScroll(u.y))
    }, {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 8, ["style"]));
  }
});
var [an, vp] = Q("ScrollAreaScrollbarVisible");
var Eo = defineComponent({
  __name: "ScrollAreaScrollbarVisible",
  setup(a2) {
    const t = ze(), e = nn(), { forwardRef: n } = R2(), l = ref({
      content: 0,
      viewport: 0,
      scrollbar: { size: 0, paddingStart: 0, paddingEnd: 0 }
    }), s = computed(() => {
      const x = bs(l.value.viewport, l.value.content);
      return x > 0 && x < 1;
    }), r = ref(), i = ref(0);
    function u(x, D) {
      if (v2.value) {
        const h2 = t.viewport.value.scrollLeft + x.deltaY;
        t.viewport.value.scrollLeft = h2, Yo(h2, D) && x.preventDefault();
      } else {
        const h2 = t.viewport.value.scrollTop + x.deltaY;
        t.viewport.value.scrollTop = h2, Yo(h2, D) && x.preventDefault();
      }
    }
    function d(x, D) {
      v2.value ? i.value = D.x : i.value = D.y;
    }
    function p(x) {
      i.value = 0;
    }
    function c(x) {
      l.value = x;
    }
    function f(x, D) {
      return cp(
        x,
        i.value,
        l.value,
        D
      );
    }
    const v2 = computed(
      () => e.isHorizontal.value
    );
    function g(x) {
      v2.value ? t.viewport.value.scrollLeft = f(
        x,
        t.dir.value
      ) : t.viewport.value.scrollTop = f(x);
    }
    function m2() {
      if (v2.value) {
        if (t.viewport.value && r.value) {
          const x = t.viewport.value.scrollLeft, D = qo(
            x,
            l.value,
            t.dir.value
          );
          r.value.style.transform = `translate3d(${D}px, 0, 0)`;
        }
      } else if (t.viewport.value && r.value) {
        const x = t.viewport.value.scrollTop, D = qo(x, l.value);
        r.value.style.transform = `translate3d(0, ${D}px, 0)`;
      }
    }
    function S(x) {
      r.value = x;
    }
    return vp({
      sizes: l,
      hasThumb: s,
      handleWheelScroll: u,
      handleThumbDown: d,
      handleThumbUp: p,
      handleSizeChange: c,
      onThumbPositionChange: m2,
      onThumbChange: S,
      onDragScroll: g
    }), (x, D) => v2.value ? (openBlock(), createBlock(pp, mergeProps({ key: 0 }, x.$attrs, { ref: unref(n) }), {
      default: withCtx(() => [
        renderSlot(x.$slots, "default")
      ]),
      _: 3
    }, 16)) : (openBlock(), createBlock(fp, mergeProps({ key: 1 }, x.$attrs, { ref: unref(n) }), {
      default: withCtx(() => [
        renderSlot(x.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var ws = defineComponent({
  __name: "ScrollAreaScrollbarAuto",
  props: {
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = ze(), e = nn(), { forwardRef: n } = R2(), l = ref(false), s = zn(() => {
      if (t.viewport.value) {
        const r = t.viewport.value.offsetWidth < t.viewport.value.scrollWidth, i = t.viewport.value.offsetHeight < t.viewport.value.scrollHeight;
        l.value = e.isHorizontal.value ? r : i;
      }
    }, 10);
    return onMounted(() => s()), Ze(t.viewport, s), Ze(t.content, s), (r, i) => (openBlock(), createBlock(unref(Pe), {
      present: r.forceMount || l.value
    }, {
      default: withCtx(() => [
        createVNode(Eo, mergeProps(r.$attrs, {
          ref: unref(n),
          "data-state": l.value ? "visible" : "hidden"
        }), {
          default: withCtx(() => [
            renderSlot(r.$slots, "default")
          ]),
          _: 3
        }, 16, ["data-state"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var mp = defineComponent({
  inheritAttrs: false,
  __name: "ScrollAreaScrollbarHover",
  props: {
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = ze(), { forwardRef: e } = R2();
    let n;
    const l = ref(false);
    function s() {
      window.clearTimeout(n), l.value = true;
    }
    function r() {
      n = window.setTimeout(() => {
        l.value = false;
      }, t.scrollHideDelay.value);
    }
    return onMounted(() => {
      const i = t.scrollArea.value;
      i && (i.addEventListener("pointerenter", s), i.addEventListener("pointerleave", r));
    }), onUnmounted(() => {
      const i = t.scrollArea.value;
      i && (window.clearTimeout(n), i.removeEventListener("pointerenter", s), i.removeEventListener("pointerleave", r));
    }), (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || l.value
    }, {
      default: withCtx(() => [
        createVNode(ws, mergeProps(i.$attrs, {
          ref: unref(e),
          "data-state": l.value ? "visible" : "hidden"
        }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16, ["data-state"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var hp = defineComponent({
  __name: "ScrollAreaScrollbarScroll",
  props: {
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = ze(), e = nn(), { forwardRef: n } = R2(), { state: l, dispatch: s } = Tl("hidden", {
      hidden: {
        SCROLL: "scrolling"
      },
      scrolling: {
        SCROLL_END: "idle",
        POINTER_ENTER: "interacting"
      },
      interacting: {
        SCROLL: "interacting",
        POINTER_LEAVE: "idle"
      },
      idle: {
        HIDE: "hidden",
        SCROLL: "scrolling",
        POINTER_ENTER: "interacting"
      }
    });
    watchEffect((i) => {
      if (l.value === "idle") {
        const u = window.setTimeout(
          () => s("HIDE"),
          t.scrollHideDelay.value
        );
        i(() => {
          window.clearTimeout(u);
        });
      }
    });
    const r = zn(() => s("SCROLL_END"), 100);
    return watchEffect((i) => {
      const u = t.viewport.value, d = e.isHorizontal.value ? "scrollLeft" : "scrollTop";
      if (u) {
        let p = u[d];
        const c = () => {
          const f = u[d];
          p !== f && (s("SCROLL"), r()), p = f;
        };
        u.addEventListener("scroll", c), i(() => {
          u.removeEventListener("scroll", c);
        });
      }
    }), (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(l) !== "hidden"
    }, {
      default: withCtx(() => [
        createVNode(Eo, mergeProps(i.$attrs, { ref: unref(n) }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var [nn, yp] = Q("ScrollAreaScrollbar");
var wy = defineComponent({
  inheritAttrs: false,
  __name: "ScrollAreaScrollbar",
  props: {
    orientation: { default: "vertical" },
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), n = ze(), l = computed(() => t.orientation === "horizontal");
    watch(
      l,
      () => {
        l.value ? n.onScrollbarXEnabledChange(true) : n.onScrollbarYEnabledChange(true);
      },
      { immediate: true }
    ), onUnmounted(() => {
      n.onScrollbarXEnabledChange(false), n.onScrollbarYEnabledChange(false);
    });
    const { orientation: s, forceMount: r, asChild: i, as: u } = toRefs(t);
    return yp({
      orientation: s,
      forceMount: r,
      isHorizontal: l,
      as: u,
      asChild: i
    }), (d, p) => unref(n).type.value === "hover" ? (openBlock(), createBlock(mp, mergeProps({ key: 0 }, d.$attrs, {
      ref: unref(e),
      "force-mount": unref(r)
    }), {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 16, ["force-mount"])) : unref(n).type.value === "scroll" ? (openBlock(), createBlock(hp, mergeProps({ key: 1 }, d.$attrs, {
      ref: unref(e),
      "force-mount": unref(r)
    }), {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 16, ["force-mount"])) : unref(n).type.value === "auto" ? (openBlock(), createBlock(ws, mergeProps({ key: 2 }, d.$attrs, {
      ref: unref(e),
      "force-mount": unref(r)
    }), {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 16, ["force-mount"])) : unref(n).type.value === "always" ? (openBlock(), createBlock(Eo, mergeProps({ key: 3 }, d.$attrs, {
      ref: unref(e),
      "data-state": "visible"
    }), {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
var _y = defineComponent({
  __name: "ScrollAreaThumb",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = ze(), n = an();
    function l(f) {
      const g = f.target.getBoundingClientRect(), m2 = f.clientX - g.left, S = f.clientY - g.top;
      n.handleThumbDown(f, { x: m2, y: S });
    }
    function s(f) {
      n.handleThumbUp(f);
    }
    const { forwardRef: r, currentElement: i } = R2(), u = ref(), d = computed(() => e.viewport.value);
    function p() {
      if (!u.value) {
        const f = dp(
          d.value,
          n.onThumbPositionChange
        );
        u.value = f, n.onThumbPositionChange();
      }
    }
    const c = computed(() => n.sizes.value);
    return li(c, () => {
      n.onThumbChange(i.value), d.value && (n.onThumbPositionChange(), d.value.addEventListener("scroll", p));
    }), onUnmounted(() => {
      var f;
      d.value.removeEventListener("scroll", p), (f = e.viewport.value) == null || f.removeEventListener("scroll", p);
    }), (f, v2) => (openBlock(), createBlock(unref(A2), {
      ref: unref(r),
      "data-state": unref(n).hasThumb ? "visible" : "hidden",
      style: {
        width: "var(--radix-scroll-area-thumb-width)",
        height: "var(--radix-scroll-area-thumb-height)"
      },
      "as-child": t.asChild,
      as: f.as,
      onPointerdown: l,
      onPointerup: s
    }, {
      default: withCtx(() => [
        renderSlot(f.$slots, "default")
      ]),
      _: 3
    }, 8, ["data-state", "as-child", "as"]));
  }
});
var gp = defineComponent({
  __name: "ScrollAreaCornerImpl",
  setup(a2) {
    const t = ze(), e = ref(0), n = ref(0), l = computed(() => !!e.value && !!n.value);
    function s() {
      var u;
      const i = ((u = t.scrollbarX.value) == null ? void 0 : u.offsetHeight) || 0;
      t.onCornerHeightChange(i), n.value = i;
    }
    function r() {
      var u;
      const i = ((u = t.scrollbarY.value) == null ? void 0 : u.offsetWidth) || 0;
      t.onCornerWidthChange(i), e.value = i;
    }
    return Ze(t.scrollbarX.value, s), Ze(t.scrollbarY.value, r), watch(() => t.scrollbarX.value, s), watch(() => t.scrollbarY.value, r), (i, u) => {
      var d;
      return l.value ? (openBlock(), createBlock(unref(A2), mergeProps({
        key: 0,
        style: {
          width: `${e.value}px`,
          height: `${n.value}px`,
          position: "absolute",
          right: unref(t).dir.value === "ltr" ? 0 : void 0,
          left: unref(t).dir.value === "rtl" ? 0 : void 0,
          bottom: 0
        }
      }, (d = i.$parent) == null ? void 0 : d.$props), {
        default: withCtx(() => [
          renderSlot(i.$slots, "default")
        ]),
        _: 3
      }, 16, ["style"])) : createCommentVNode("", true);
    };
  }
});
var xy = defineComponent({
  __name: "ScrollAreaCorner",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), n = ze(), l = computed(
      () => !!n.scrollbarX.value && !!n.scrollbarY.value
    ), s = computed(
      () => n.type.value !== "scroll" && l.value
    );
    return (r, i) => s.value ? (openBlock(), createBlock(gp, mergeProps({ key: 0 }, t, { ref: unref(e) }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
var bp = ["default-value"];
var Cp = defineComponent({
  __name: "BubbleSelect",
  props: {
    autocomplete: {},
    autofocus: { type: Boolean },
    disabled: { type: Boolean },
    form: {},
    multiple: { type: Boolean },
    name: {},
    required: { type: Boolean },
    size: {},
    value: {}
  },
  setup(a2) {
    const t = a2, { value: e } = toRefs(t), n = ref();
    return (l, s) => (openBlock(), createBlock(unref(Yt), { "as-child": "" }, {
      default: withCtx(() => [
        withDirectives(createBaseVNode("select", mergeProps({
          ref_key: "selectElement",
          ref: n
        }, t, {
          "onUpdate:modelValue": s[0] || (s[0] = (r) => isRef(e) ? e.value = r : null),
          "default-value": unref(e)
        }), [
          renderSlot(l.$slots, "default")
        ], 16, bp), [
          [vModelSelect, unref(e)]
        ])
      ]),
      _: 3
    }));
  }
});
var wp = {
  key: 0,
  value: ""
};
var [bt, _s] = Q("SelectRoot");
var [_p, xp] = Q("SelectRoot");
var Sy = defineComponent({
  __name: "SelectRoot",
  props: {
    open: { type: Boolean, default: void 0 },
    defaultOpen: { type: Boolean },
    defaultValue: { default: "" },
    modelValue: { default: void 0 },
    dir: {},
    name: {},
    autocomplete: {},
    disabled: { type: Boolean },
    required: { type: Boolean }
  },
  emits: ["update:modelValue", "update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), s = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    }), r = ref(), i = ref(), u = ref({
      x: 0,
      y: 0
    }), d = ref(false), { required: p, disabled: c, dir: f } = toRefs(e), v2 = Ce(f);
    _s({
      triggerElement: r,
      onTriggerChange: (x) => {
        r.value = x;
      },
      valueElement: i,
      onValueElementChange: (x) => {
        i.value = x;
      },
      valueElementHasChildren: d,
      onValueElementHasChildrenChange: (x) => {
        d.value = x;
      },
      contentId: "",
      modelValue: l,
      onValueChange: (x) => {
        l.value = x;
      },
      open: s,
      required: p,
      onOpenChange: (x) => {
        s.value = x;
      },
      dir: v2,
      triggerPointerDownPosRef: u,
      disabled: c
    });
    const g = Qe(r), m2 = ref(/* @__PURE__ */ new Set()), S = computed(() => Array.from(m2.value).map((x) => {
      var D;
      return (D = x.props) == null ? void 0 : D.value;
    }).join(";"));
    return xp({
      onNativeOptionAdd: (x) => {
        m2.value.add(x);
      },
      onNativeOptionRemove: (x) => {
        m2.value.delete(x);
      }
    }), (x, D) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        renderSlot(x.$slots, "default", {
          modelValue: unref(l),
          open: unref(s)
        }),
        unref(g) ? (openBlock(), createBlock(Cp, mergeProps({ key: S.value }, x.$attrs, {
          "aria-hidden": "",
          tabindex: "-1",
          required: unref(p),
          name: x.name,
          autocomplete: x.autocomplete,
          disabled: unref(c),
          value: unref(l),
          onChange: D[0] || (D[0] = (h2) => l.value = h2.target.value)
        }), {
          default: withCtx(() => [
            unref(l) === void 0 ? (openBlock(), createElementBlock("option", wp)) : createCommentVNode("", true),
            (openBlock(true), createElementBlock(Fragment, null, renderList(Array.from(m2.value), (h2) => (openBlock(), createBlock(resolveDynamicComponent(h2), mergeProps({ ref_for: true }, h2.props, {
              key: h2.key ?? ""
            }), null, 16))), 128))
          ]),
          _: 1
        }, 16, ["required", "name", "autocomplete", "disabled", "value"])) : createCommentVNode("", true)
      ]),
      _: 3
    }));
  }
});
var Sp = [" ", "Enter", "ArrowUp", "ArrowDown"];
var Ep = [" ", "Enter"];
var at = 10;
function xs(a2) {
  return a2 === "" || Nt(a2);
}
var Ey = defineComponent({
  __name: "SelectTrigger",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = bt(), n = computed(() => {
      var v2;
      return ((v2 = e.disabled) == null ? void 0 : v2.value) || t.disabled;
    }), { forwardRef: l, currentElement: s } = R2();
    e.contentId || (e.contentId = me(void 0, "radix-vue-select-content")), onMounted(() => {
      e.triggerElement = s;
    });
    const { injectCollection: r } = Me(), i = r(), { search: u, handleTypeaheadSearch: d, resetTypeahead: p } = ya(i);
    function c() {
      n.value || (e.onOpenChange(true), p());
    }
    function f(v2) {
      c(), e.triggerPointerDownPosRef.value = {
        x: Math.round(v2.pageX),
        y: Math.round(v2.pageY)
      };
    }
    return (v2, g) => (openBlock(), createBlock(unref(Tt), { "as-child": "" }, {
      default: withCtx(() => {
        var m2, S, x, D;
        return [
          createVNode(unref(A2), {
            ref: unref(l),
            role: "combobox",
            type: v2.as === "button" ? "button" : void 0,
            "aria-controls": unref(e).contentId,
            "aria-expanded": unref(e).open.value || false,
            "aria-required": (m2 = unref(e).required) == null ? void 0 : m2.value,
            "aria-autocomplete": "none",
            disabled: n.value,
            dir: (S = unref(e)) == null ? void 0 : S.dir.value,
            "data-state": (x = unref(e)) != null && x.open.value ? "open" : "closed",
            "data-disabled": n.value ? "" : void 0,
            "data-placeholder": unref(xs)((D = unref(e).modelValue) == null ? void 0 : D.value) ? "" : void 0,
            "as-child": v2.asChild,
            as: v2.as,
            onClick: g[0] || (g[0] = (h2) => {
              var E;
              (E = h2 == null ? void 0 : h2.currentTarget) == null || E.focus();
            }),
            onPointerdown: g[1] || (g[1] = (h2) => {
              if (h2.pointerType === "touch")
                return h2.preventDefault();
              const E = h2.target;
              E.hasPointerCapture(h2.pointerId) && E.releasePointerCapture(h2.pointerId), h2.button === 0 && h2.ctrlKey === false && (f(h2), h2.preventDefault());
            }),
            onPointerup: g[2] || (g[2] = withModifiers(
              (h2) => {
                h2.pointerType === "touch" && f(h2);
              },
              ["prevent"]
            )),
            onKeydown: g[3] || (g[3] = (h2) => {
              const E = unref(u) !== "";
              !(h2.ctrlKey || h2.altKey || h2.metaKey) && h2.key.length === 1 && E && h2.key === " " || (unref(d)(h2.key), unref(Sp).includes(h2.key) && (c(), h2.preventDefault()));
            })
          }, {
            default: withCtx(() => [
              renderSlot(v2.$slots, "default")
            ]),
            _: 3
          }, 8, ["type", "aria-controls", "aria-expanded", "aria-required", "disabled", "dir", "data-state", "data-disabled", "data-placeholder", "as-child", "as"])
        ];
      }),
      _: 3
    }));
  }
});
var Py = defineComponent({
  __name: "SelectPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [Po, Pp] = Q("SelectItemAlignedPosition");
var Dp = defineComponent({
  inheritAttrs: false,
  __name: "SelectItemAlignedPosition",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["placed"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { injectCollection: l } = Me(), s = bt(), r = Ct(), i = l(), u = ref(false), d = ref(true), p = ref(), { forwardRef: c, currentElement: f } = R2(), { viewport: v2, selectedItem: g, selectedItemText: m2, focusSelectedItem: S } = r;
    function x() {
      if (s.triggerElement.value && s.valueElement.value && p.value && f.value && (v2 != null && v2.value) && (g != null && g.value) && (m2 != null && m2.value)) {
        const E = s.triggerElement.value.getBoundingClientRect(), P2 = f.value.getBoundingClientRect(), $2 = s.valueElement.value.getBoundingClientRect(), I = m2.value.getBoundingClientRect();
        if (s.dir.value !== "rtl") {
          const ge = I.left - P2.left, De = $2.left - ge, ue = E.left - De, Se = E.width + ue, Ve = Math.max(Se, P2.width), Ke = window.innerWidth - at, be = Kt(De, at, Ke - Ve);
          p.value.style.minWidth = `${Se}px`, p.value.style.left = `${be}px`;
        } else {
          const ge = P2.right - I.right, De = window.innerWidth - $2.right - ge, ue = window.innerWidth - E.right - De, Se = E.width + ue, Ve = Math.max(Se, P2.width), Ke = window.innerWidth - at, be = Kt(
            De,
            at,
            Ke - Ve
          );
          p.value.style.minWidth = `${Se}px`, p.value.style.right = `${be}px`;
        }
        const k = i.value, L = window.innerHeight - at * 2, O = v2.value.scrollHeight, V2 = window.getComputedStyle(f.value), H2 = Number.parseInt(
          V2.borderTopWidth,
          10
        ), Y = Number.parseInt(V2.paddingTop, 10), J2 = Number.parseInt(
          V2.borderBottomWidth,
          10
        ), N2 = Number.parseInt(
          V2.paddingBottom,
          10
        ), F = H2 + Y + O + N2 + J2, W2 = Math.min(
          g.value.offsetHeight * 5,
          F
        ), z2 = window.getComputedStyle(v2.value), Z = Number.parseInt(z2.paddingTop, 10), U = Number.parseInt(
          z2.paddingBottom,
          10
        ), X = E.top + E.height / 2 - at, ee = L - X, fe = g.value.offsetHeight / 2, G2 = g.value.offsetTop + fe, oe = H2 + Y + G2, he = F - oe;
        if (oe <= X) {
          const ge = g.value === k[k.length - 1];
          p.value.style.bottom = "0px";
          const De = f.value.clientHeight - v2.value.offsetTop - v2.value.offsetHeight, ue = Math.max(
            ee,
            fe + (ge ? U : 0) + De + J2
          ), Se = oe + ue;
          p.value.style.height = `${Se}px`;
        } else {
          const ge = g.value === k[0];
          p.value.style.top = "0px";
          const ue = Math.max(
            X,
            H2 + v2.value.offsetTop + (ge ? Z : 0) + fe
          ) + he;
          p.value.style.height = `${ue}px`, v2.value.scrollTop = oe - X + v2.value.offsetTop;
        }
        p.value.style.margin = `${at}px 0`, p.value.style.minHeight = `${W2}px`, p.value.style.maxHeight = `${L}px`, n("placed"), requestAnimationFrame(() => u.value = true);
      }
    }
    const D = ref("");
    onMounted(async () => {
      await nextTick(), x(), f.value && (D.value = window.getComputedStyle(f.value).zIndex);
    });
    function h2(E) {
      E && d.value === true && (x(), S == null || S(), d.value = false);
    }
    return Pp({
      contentWrapper: p,
      shouldExpandOnScrollRef: u,
      onScrollButtonChange: h2
    }), (E, P2) => (openBlock(), createElementBlock("div", {
      ref_key: "contentWrapperElement",
      ref: p,
      style: normalizeStyle({
        display: "flex",
        flexDirection: "column",
        position: "fixed",
        zIndex: D.value
      })
    }, [
      createVNode(unref(A2), mergeProps({
        ref: unref(c),
        style: {
          // When we get the height of the content, it includes borders. If we were to set
          // the height without having `boxSizing: 'border-box'` it would be too big.
          boxSizing: "border-box",
          // We need to ensure the content doesn't get taller than the wrapper
          maxHeight: "100%"
        }
      }, { ...E.$attrs, ...e }), {
        default: withCtx(() => [
          renderSlot(E.$slots, "default")
        ]),
        _: 3
      }, 16)
    ], 4));
  }
});
var $p = defineComponent({
  __name: "SelectPopperPosition",
  props: {
    side: {},
    sideOffset: {},
    align: { default: "start" },
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: { default: at },
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const e = Bt(a2);
    return (n, l) => (openBlock(), createBlock(unref(Pt), mergeProps(unref(e), { style: {
      // Ensure border-box for floating-ui calculations
      boxSizing: "border-box",
      "--radix-select-content-transform-origin": "var(--radix-popper-transform-origin)",
      "--radix-select-content-available-width": "var(--radix-popper-available-width)",
      "--radix-select-content-available-height": "var(--radix-popper-available-height)",
      "--radix-select-trigger-width": "var(--radix-popper-anchor-width)",
      "--radix-select-trigger-height": "var(--radix-popper-anchor-height)"
    } }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var ta = {
  onViewportChange: () => {
  },
  itemTextRefCallback: () => {
  },
  itemRefCallback: () => {
  }
};
var [Ct, Bp] = Q("SelectContent");
var Ip = defineComponent({
  __name: "SelectContentImpl",
  props: {
    position: { default: "item-aligned" },
    bodyLock: { type: Boolean, default: true },
    side: {},
    sideOffset: {},
    align: { default: "start" },
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["closeAutoFocus", "escapeKeyDown", "pointerDownOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = bt();
    jn(), ma(e.bodyLock);
    const { createCollection: s } = Me(), r = ref();
    ha(r);
    const i = s(r), { search: u, handleTypeaheadSearch: d } = ya(i), p = ref(), c = ref(), f = ref(), v2 = ref(false), g = ref(false);
    function m2() {
      c.value && r.value && Pn([c.value, r.value]);
    }
    watch(v2, () => {
      m2();
    });
    const { onOpenChange: S, triggerPointerDownPosRef: x } = l;
    watchEffect((P2) => {
      if (!r.value)
        return;
      let $2 = { x: 0, y: 0 };
      const I = (L) => {
        var O, V2;
        $2 = {
          x: Math.abs(
            Math.round(L.pageX) - (((O = x.value) == null ? void 0 : O.x) ?? 0)
          ),
          y: Math.abs(
            Math.round(L.pageY) - (((V2 = x.value) == null ? void 0 : V2.y) ?? 0)
          )
        };
      }, k = (L) => {
        var O;
        L.pointerType !== "touch" && ($2.x <= 10 && $2.y <= 10 ? L.preventDefault() : (O = r.value) != null && O.contains(L.target) || S(false), document.removeEventListener("pointermove", I), x.value = null);
      };
      x.value !== null && (document.addEventListener("pointermove", I), document.addEventListener("pointerup", k, {
        capture: true,
        once: true
      })), P2(() => {
        document.removeEventListener("pointermove", I), document.removeEventListener("pointerup", k, {
          capture: true
        });
      });
    });
    function D(P2) {
      const $2 = P2.ctrlKey || P2.altKey || P2.metaKey;
      if (P2.key === "Tab" && P2.preventDefault(), !$2 && P2.key.length === 1 && d(P2.key), ["ArrowUp", "ArrowDown", "Home", "End"].includes(P2.key)) {
        let I = i.value;
        if (["ArrowUp", "End"].includes(P2.key) && (I = I.slice().reverse()), ["ArrowUp", "ArrowDown"].includes(P2.key)) {
          const k = P2.target, L = I.indexOf(k);
          I = I.slice(L + 1);
        }
        setTimeout(() => Pn(I)), P2.preventDefault();
      }
    }
    const h2 = computed(() => e.position === "popper" ? e : {}), E = Bt(h2.value);
    return Bp({
      content: r,
      viewport: p,
      onViewportChange: (P2) => {
        p.value = P2;
      },
      itemRefCallback: (P2, $2, I) => {
        var O, V2;
        const k = !g.value && !I;
        (((O = l.modelValue) == null ? void 0 : O.value) !== void 0 && ((V2 = l.modelValue) == null ? void 0 : V2.value) === $2 || k) && (c.value = P2, k && (g.value = true));
      },
      selectedItem: c,
      selectedItemText: f,
      onItemLeave: () => {
        var P2;
        (P2 = r.value) == null || P2.focus();
      },
      itemTextRefCallback: (P2, $2, I) => {
        var O, V2;
        const k = !g.value && !I;
        (((O = l.modelValue) == null ? void 0 : O.value) !== void 0 && ((V2 = l.modelValue) == null ? void 0 : V2.value) === $2 || k) && (f.value = P2);
      },
      focusSelectedItem: m2,
      position: e.position,
      isPositioned: v2,
      searchRef: u
    }), (P2, $2) => (openBlock(), createBlock(unref(Ga), {
      "as-child": "",
      onMountAutoFocus: $2[6] || ($2[6] = withModifiers(() => {
      }, ["prevent"])),
      onUnmountAutoFocus: $2[7] || ($2[7] = (I) => {
        var k;
        n("closeAutoFocus", I), !I.defaultPrevented && ((k = unref(l).triggerElement.value) == null || k.focus({ preventScroll: true }), I.preventDefault());
      })
    }, {
      default: withCtx(() => [
        createVNode(unref(yt), {
          "as-child": "",
          "disable-outside-pointer-events": "",
          onFocusOutside: $2[2] || ($2[2] = withModifiers(() => {
          }, ["prevent"])),
          onDismiss: $2[3] || ($2[3] = (I) => unref(l).onOpenChange(false)),
          onEscapeKeyDown: $2[4] || ($2[4] = (I) => n("escapeKeyDown", I)),
          onPointerDownOutside: $2[5] || ($2[5] = (I) => n("pointerDownOutside", I))
        }, {
          default: withCtx(() => [
            (openBlock(), createBlock(resolveDynamicComponent(
              P2.position === "popper" ? $p : Dp
            ), mergeProps({ ...P2.$attrs, ...unref(E) }, {
              id: unref(l).contentId,
              ref: (I) => {
                r.value = unref(Be)(I);
              },
              role: "listbox",
              "data-state": unref(l).open.value ? "open" : "closed",
              dir: unref(l).dir.value,
              style: {
                // flex layout so we can place the scroll buttons properly
                display: "flex",
                flexDirection: "column",
                // reset the outline by default as the content MAY get focused
                outline: "none"
              },
              onContextmenu: $2[0] || ($2[0] = withModifiers(() => {
              }, ["prevent"])),
              onPlaced: $2[1] || ($2[1] = (I) => v2.value = true),
              onKeydown: D
            }), {
              default: withCtx(() => [
                renderSlot(P2.$slots, "default")
              ]),
              _: 3
            }, 16, ["id", "data-state", "dir", "onKeydown"]))
          ]),
          _: 3
        })
      ]),
      _: 3
    }));
  }
});
var Tp = defineComponent({
  __name: "SelectProvider",
  props: {
    context: {}
  },
  setup(a2) {
    return _s(a2.context), (e, n) => renderSlot(e.$slots, "default");
  }
});
var Rp = { key: 1 };
var Dy = defineComponent({
  inheritAttrs: false,
  __name: "SelectContent",
  props: {
    forceMount: { type: Boolean },
    position: {},
    bodyLock: { type: Boolean },
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean },
    updatePositionStrategy: {},
    prioritizePosition: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["closeAutoFocus", "escapeKeyDown", "pointerDownOutside"],
  setup(a2, { emit: t }) {
    const e = a2, l = xe(e, t), s = bt(), r = ref();
    onMounted(() => {
      r.value = new DocumentFragment();
    });
    const i = ref(), u = computed(() => e.forceMount || s.open.value);
    return (d, p) => {
      var c;
      return u.value ? (openBlock(), createBlock(unref(Pe), {
        key: 0,
        ref_key: "presenceRef",
        ref: i,
        present: true
      }, {
        default: withCtx(() => [
          createVNode(Ip, normalizeProps(guardReactiveProps({ ...unref(l), ...d.$attrs })), {
            default: withCtx(() => [
              renderSlot(d.$slots, "default")
            ]),
            _: 3
          }, 16)
        ]),
        _: 3
      }, 512)) : !((c = i.value) != null && c.present) && r.value ? (openBlock(), createElementBlock("div", Rp, [
        (openBlock(), createBlock(Teleport, { to: r.value }, [
          createVNode(Tp, { context: unref(s) }, {
            default: withCtx(() => [
              renderSlot(d.$slots, "default")
            ]),
            _: 3
          }, 8, ["context"])
        ], 8, ["to"]))
      ])) : createCommentVNode("", true);
    };
  }
});
var $y = defineComponent({
  __name: "SelectArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2, e = bt(), n = Ct();
    return (l, s) => unref(e).open.value && unref(n).position === "popper" ? (openBlock(), createBlock(unref(qt), normalizeProps(mergeProps({ key: 0 }, t)), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
var By = defineComponent({
  __name: "SelectSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(A2), mergeProps({ "aria-hidden": "" }, t), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var [Ss, Ap] = Q("SelectItem");
var Iy = defineComponent({
  __name: "SelectItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    textValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { disabled: e } = toRefs(t), n = bt(), l = Ct(ta), { forwardRef: s, currentElement: r } = R2(), i = computed(() => {
      var m2;
      return ((m2 = n.modelValue) == null ? void 0 : m2.value) === t.value;
    }), u = ref(false), d = ref(t.textValue ?? ""), p = me(void 0, "radix-vue-select-item-text");
    async function c(m2) {
      await nextTick(), !(m2 != null && m2.defaultPrevented) && (e.value || (n.onValueChange(t.value), n.onOpenChange(false)));
    }
    async function f(m2) {
      var S;
      await nextTick(), !m2.defaultPrevented && (e.value ? (S = l.onItemLeave) == null || S.call(l) : m2.currentTarget.focus({ preventScroll: true }));
    }
    async function v2(m2) {
      var S;
      await nextTick(), !m2.defaultPrevented && m2.currentTarget === document.activeElement && ((S = l.onItemLeave) == null || S.call(l));
    }
    async function g(m2) {
      var x;
      await nextTick(), !(m2.defaultPrevented || ((x = l.searchRef) == null ? void 0 : x.value) !== "" && m2.key === " ") && (Ep.includes(m2.key) && c(), m2.key === " " && m2.preventDefault());
    }
    if (t.value === "")
      throw new Error(
        "A <SelectItem /> must have a value prop that is not an empty string. This is because the Select value can be set to an empty string to clear the selection and show the placeholder."
      );
    return onMounted(() => {
      r.value && l.itemRefCallback(
        r.value,
        t.value,
        t.disabled
      );
    }), Ap({
      value: t.value,
      disabled: e,
      textId: p,
      isSelected: i,
      onItemTextChange: (m2) => {
        d.value = ((d.value || (m2 == null ? void 0 : m2.textContent)) ?? "").trim();
      }
    }), (m2, S) => (openBlock(), createBlock(unref(A2), {
      ref: unref(s),
      role: "option",
      "data-radix-vue-collection-item": "",
      "aria-labelledby": unref(p),
      "data-highlighted": u.value ? "" : void 0,
      "aria-selected": i.value,
      "data-state": i.value ? "checked" : "unchecked",
      "aria-disabled": unref(e) || void 0,
      "data-disabled": unref(e) ? "" : void 0,
      tabindex: unref(e) ? void 0 : -1,
      as: m2.as,
      "as-child": m2.asChild,
      onFocus: S[0] || (S[0] = (x) => u.value = true),
      onBlur: S[1] || (S[1] = (x) => u.value = false),
      onPointerup: c,
      onPointerdown: S[2] || (S[2] = (x) => {
        x.currentTarget.focus({ preventScroll: true });
      }),
      onTouchend: S[3] || (S[3] = withModifiers(() => {
      }, ["prevent", "stop"])),
      onPointermove: f,
      onPointerleave: v2,
      onKeydown: g
    }, {
      default: withCtx(() => [
        renderSlot(m2.$slots, "default")
      ]),
      _: 3
    }, 8, ["aria-labelledby", "data-highlighted", "aria-selected", "data-state", "aria-disabled", "data-disabled", "tabindex", "as", "as-child"]));
  }
});
var Ty = defineComponent({
  __name: "SelectItemIndicator",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, e = Ss();
    return (n, l) => unref(e).isSelected.value ? (openBlock(), createBlock(unref(A2), mergeProps({
      key: 0,
      "aria-hidden": ""
    }, t), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16)) : createCommentVNode("", true);
  }
});
var [Op, kp] = Q("SelectGroup");
var Ry = defineComponent({
  __name: "SelectGroup",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = me(void 0, "radix-vue-select-group");
    return kp({ id: e }), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps({ role: "group" }, t, { "aria-labelledby": unref(e) }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-labelledby"]));
  }
});
var Ay = defineComponent({
  __name: "SelectLabel",
  props: {
    for: {},
    asChild: { type: Boolean },
    as: { default: "div" }
  },
  setup(a2) {
    const t = a2, e = Op({ id: "" });
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).id
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var Oy = defineComponent({
  inheritAttrs: false,
  __name: "SelectItemText",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, e = bt(), n = Ct(ta), l = _p(), s = Ss(), { forwardRef: r, currentElement: i } = R2(), u = computed(() => {
      var d;
      return h("option", {
        key: s.value,
        value: s.value,
        disabled: s.disabled.value,
        innerHTML: (d = i.value) == null ? void 0 : d.textContent
      });
    });
    return onMounted(() => {
      i.value && (s.onItemTextChange(i.value), n.itemTextRefCallback(
        i.value,
        s.value,
        s.disabled.value
      ), l.onNativeOptionAdd(u.value));
    }), onBeforeUnmount(() => {
      l.onNativeOptionRemove(u.value);
    }), (d, p) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps({
        id: unref(s).textId,
        ref: unref(r)
      }, { ...t, ...d.$attrs }), {
        default: withCtx(() => [
          renderSlot(d.$slots, "default")
        ]),
        _: 3
      }, 16, ["id"]),
      unref(s).isSelected.value && unref(e).valueElement.value && !unref(e).valueElementHasChildren.value ? (openBlock(), createBlock(Teleport, {
        key: 0,
        to: unref(e).valueElement.value
      }, [
        renderSlot(d.$slots, "default")
      ], 8, ["to"])) : createCommentVNode("", true)
    ], 64));
  }
});
var ky = defineComponent({
  __name: "SelectViewport",
  props: {
    nonce: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { nonce: e } = toRefs(t), n = qa(e), l = Ct(ta), s = l.position === "item-aligned" ? Po() : void 0, { forwardRef: r, currentElement: i } = R2();
    onMounted(() => {
      l == null || l.onViewportChange(i.value);
    });
    const u = ref(0);
    function d(p) {
      const c = p.currentTarget, { shouldExpandOnScrollRef: f, contentWrapper: v2 } = s ?? {};
      if (f != null && f.value && (v2 != null && v2.value)) {
        const g = Math.abs(u.value - c.scrollTop);
        if (g > 0) {
          const m2 = window.innerHeight - at * 2, S = Number.parseFloat(
            v2.value.style.minHeight
          ), x = Number.parseFloat(v2.value.style.height), D = Math.max(S, x);
          if (D < m2) {
            const h2 = D + g, E = Math.min(m2, h2), P2 = h2 - E;
            v2.value.style.height = `${E}px`, v2.value.style.bottom === "0px" && (c.scrollTop = P2 > 0 ? P2 : 0, v2.value.style.justifyContent = "flex-end");
          }
        }
      }
      u.value = c.scrollTop;
    }
    return (p, c) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps({
        ref: unref(r),
        "data-radix-select-viewport": "",
        role: "presentation"
      }, { ...p.$attrs, ...t }, {
        style: {
          // we use position: 'relative' here on the `viewport` so that when we call
          // `selectedItem.offsetTop` in calculations, the offset is relative to the viewport
          // (independent of the scrollUpButton).
          position: "relative",
          flex: 1,
          overflow: "auto"
        },
        onScroll: d
      }), {
        default: withCtx(() => [
          renderSlot(p.$slots, "default")
        ]),
        _: 3
      }, 16),
      createVNode(unref(A2), {
        as: "style",
        nonce: unref(n)
      }, {
        default: withCtx(() => [
          createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-radix-select-viewport] { scrollbar-width:none; -ms-overflow-style: none; -webkit-overflow-scrolling: touch; } [data-radix-select-viewport]::-webkit-scrollbar { display: none; } ")
        ]),
        _: 1
      }, 8, ["nonce"])
    ], 64));
  }
});
var Es = defineComponent({
  __name: "SelectScrollButtonImpl",
  emits: ["autoScroll"],
  setup(a2, { emit: t }) {
    const e = t, { injectCollection: n } = Me(), l = n(), s = Ct(ta), r = ref(null);
    function i() {
      r.value !== null && (window.clearInterval(r.value), r.value = null);
    }
    watchEffect(() => {
      const p = l.value.find(
        (c) => c === document.activeElement
      );
      p == null || p.scrollIntoView({ block: "nearest" });
    });
    function u() {
      r.value === null && (r.value = window.setInterval(() => {
        e("autoScroll");
      }, 50));
    }
    function d() {
      var p;
      (p = s.onItemLeave) == null || p.call(s), r.value === null && (r.value = window.setInterval(() => {
        e("autoScroll");
      }, 50));
    }
    return onBeforeUnmount(() => i()), (p, c) => {
      var f;
      return openBlock(), createBlock(unref(A2), mergeProps({
        "aria-hidden": "",
        style: {
          flexShrink: 0
        }
      }, (f = p.$parent) == null ? void 0 : f.$props, {
        onPointerdown: u,
        onPointermove: d,
        onPointerleave: c[0] || (c[0] = () => {
          i();
        })
      }), {
        default: withCtx(() => [
          renderSlot(p.$slots, "default")
        ]),
        _: 3
      }, 16);
    };
  }
});
var My = defineComponent({
  __name: "SelectScrollUpButton",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = Ct(ta), e = t.position === "item-aligned" ? Po() : void 0, { forwardRef: n, currentElement: l } = R2(), s = ref(false);
    return watchEffect((r) => {
      var i, u;
      if ((i = t.viewport) != null && i.value && ((u = t.isPositioned) != null && u.value)) {
        let d = function() {
          s.value = p.scrollTop > 0;
        };
        const p = t.viewport.value;
        d(), p.addEventListener("scroll", d), r(() => p.removeEventListener("scroll", d));
      }
    }), watch(l, () => {
      l.value && (e == null || e.onScrollButtonChange(l.value));
    }), (r, i) => s.value ? (openBlock(), createBlock(Es, {
      key: 0,
      ref: unref(n),
      onAutoScroll: i[0] || (i[0] = () => {
        const { viewport: u, selectedItem: d } = unref(t);
        u != null && u.value && (d != null && d.value) && (u.value.scrollTop = u.value.scrollTop - d.value.offsetHeight);
      })
    }, {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 512)) : createCommentVNode("", true);
  }
});
var Vy = defineComponent({
  __name: "SelectScrollDownButton",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = Ct(ta), e = t.position === "item-aligned" ? Po() : void 0, { forwardRef: n, currentElement: l } = R2(), s = ref(false);
    return watchEffect((r) => {
      var i, u;
      if ((i = t.viewport) != null && i.value && ((u = t.isPositioned) != null && u.value)) {
        let d = function() {
          const c = p.scrollHeight - p.clientHeight;
          s.value = Math.ceil(p.scrollTop) < c;
        };
        const p = t.viewport.value;
        d(), p.addEventListener("scroll", d), r(() => p.removeEventListener("scroll", d));
      }
    }), watch(l, () => {
      l.value && (e == null || e.onScrollButtonChange(l.value));
    }), (r, i) => s.value ? (openBlock(), createBlock(Es, {
      key: 0,
      ref: unref(n),
      onAutoScroll: i[0] || (i[0] = () => {
        const { viewport: u, selectedItem: d } = unref(t);
        u != null && u.value && (d != null && d.value) && (u.value.scrollTop = u.value.scrollTop + d.value.offsetHeight);
      })
    }, {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 512)) : createCommentVNode("", true);
  }
});
var Fy = defineComponent({
  __name: "SelectValue",
  props: {
    placeholder: { default: "" },
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const { forwardRef: t, currentElement: e } = R2(), n = bt(), l = useSlots();
    return onBeforeMount(() => {
      var r;
      const s = !!Wa((r = l == null ? void 0 : l.default) == null ? void 0 : r.call(l)).length;
      n.onValueElementHasChildrenChange(s);
    }), onMounted(() => {
      n.valueElement = e;
    }), (s, r) => (openBlock(), createBlock(unref(A2), {
      ref: unref(t),
      as: s.as,
      "as-child": s.asChild,
      style: { pointerEvents: "none" }
    }, {
      default: withCtx(() => {
        var i;
        return [
          unref(xs)((i = unref(n).modelValue) == null ? void 0 : i.value) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            createTextVNode(toDisplayString(s.placeholder), 1)
          ], 64)) : renderSlot(s.$slots, "default", { key: 1 })
        ];
      }),
      _: 3
    }, 8, ["as", "as-child"]));
  }
});
var Ly = defineComponent({
  __name: "SelectIcon",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    return (t, e) => (openBlock(), createBlock(unref(A2), {
      "aria-hidden": "",
      as: t.as,
      "as-child": t.asChild
    }, {
      default: withCtx(() => [
        renderSlot(t.$slots, "default", {}, () => [
          createTextVNode("▼")
        ])
      ]),
      _: 3
    }, 8, ["as", "as-child"]));
  }
});
var Ps = defineComponent({
  __name: "BaseSeparator",
  props: {
    orientation: { default: "horizontal" },
    decorative: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = ["horizontal", "vertical"];
    function n(i) {
      return e.includes(i);
    }
    const l = computed(
      () => n(t.orientation) ? t.orientation : "horizontal"
    ), s = computed(
      () => l.value === "vertical" ? t.orientation : void 0
    ), r = computed(
      () => t.decorative ? { role: "none" } : { "aria-orientation": s.value, role: "separator" }
    );
    return (i, u) => (openBlock(), createBlock(unref(A2), mergeProps({
      as: i.as,
      "as-child": i.asChild,
      "data-orientation": l.value
    }, r.value), {
      default: withCtx(() => [
        renderSlot(i.$slots, "default")
      ]),
      _: 3
    }, 16, ["as", "as-child", "data-orientation"]));
  }
});
var Mp = defineComponent({
  __name: "Separator",
  props: {
    orientation: { default: "horizontal" },
    decorative: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(Ps, normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
function Vp(a2 = [], t, e) {
  const n = [...a2];
  return n[e] = t, n.sort((l, s) => l - s);
}
function Ds(a2, t, e) {
  const s = 100 / (e - t) * (a2 - t);
  return Kt(s, 0, 100);
}
function Fp(a2, t) {
  return t > 2 ? `Value ${a2 + 1} of ${t}` : t === 2 ? ["Minimum", "Maximum"][a2] : void 0;
}
function Lp(a2, t) {
  if (a2.length === 1)
    return 0;
  const e = a2.map((l) => Math.abs(l - t)), n = Math.min(...e);
  return e.indexOf(n);
}
function Np(a2, t, e) {
  const n = a2 / 2, s = Do([0, 50], [0, n]);
  return (n - s(t) * e) * e;
}
function zp(a2) {
  return a2.slice(0, -1).map((t, e) => a2[e + 1] - t);
}
function Kp(a2, t) {
  if (t > 0) {
    const e = zp(a2);
    return Math.min(...e) >= t;
  }
  return true;
}
function Do(a2, t) {
  return (e) => {
    if (a2[0] === a2[1] || t[0] === t[1])
      return t[0];
    const n = (t[1] - t[0]) / (a2[1] - a2[0]);
    return t[0] + n * (e - a2[0]);
  };
}
function Hp(a2) {
  return (String(a2).split(".")[1] || "").length;
}
function Wp(a2, t) {
  const e = 10 ** t;
  return Math.round(a2 * e) / e;
}
var $s = ["PageUp", "PageDown"];
var Bs = ["ArrowUp", "ArrowDown", "ArrowLeft", "ArrowRight"];
var Is = {
  "from-left": ["Home", "PageDown", "ArrowDown", "ArrowLeft"],
  "from-right": ["Home", "PageDown", "ArrowDown", "ArrowRight"],
  "from-bottom": ["Home", "PageDown", "ArrowDown", "ArrowLeft"],
  "from-top": ["Home", "PageDown", "ArrowUp", "ArrowLeft"]
};
var [Ts, Rs] = Q(["SliderVertical", "SliderHorizontal"]);
var As = defineComponent({
  __name: "SliderImpl",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  emits: ["slideStart", "slideMove", "slideEnd", "homeKeyDown", "endKeyDown", "stepKeyDown"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = on();
    return (s, r) => (openBlock(), createBlock(unref(A2), mergeProps({ "data-slider-impl": "" }, e, {
      onKeydown: r[0] || (r[0] = (i) => {
        i.key === "Home" ? (n("homeKeyDown", i), i.preventDefault()) : i.key === "End" ? (n("endKeyDown", i), i.preventDefault()) : unref($s).concat(unref(Bs)).includes(i.key) && (n("stepKeyDown", i), i.preventDefault());
      }),
      onPointerdown: r[1] || (r[1] = (i) => {
        const u = i.target;
        u.setPointerCapture(i.pointerId), i.preventDefault(), unref(l).thumbElements.value.includes(u) ? u.focus() : n("slideStart", i);
      }),
      onPointermove: r[2] || (r[2] = (i) => {
        i.target.hasPointerCapture(i.pointerId) && n("slideMove", i);
      }),
      onPointerup: r[3] || (r[3] = (i) => {
        const u = i.target;
        u.hasPointerCapture(i.pointerId) && (u.releasePointerCapture(i.pointerId), n("slideEnd", i));
      })
    }), {
      default: withCtx(() => [
        renderSlot(s.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var jp = defineComponent({
  __name: "SliderHorizontal",
  props: {
    dir: {},
    min: {},
    max: {},
    inverted: { type: Boolean }
  },
  emits: ["slideEnd", "slideStart", "slideMove", "homeKeyDown", "endKeyDown", "stepKeyDown"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { max: l, min: s, dir: r, inverted: i } = toRefs(e), { forwardRef: u, currentElement: d } = R2(), p = ref(), c = computed(() => (r == null ? void 0 : r.value) === "ltr" && !i.value || (r == null ? void 0 : r.value) !== "ltr" && i.value);
    function f(v2) {
      const g = p.value || d.value.getBoundingClientRect(), m2 = [0, g.width], S = c.value ? [s.value, l.value] : [l.value, s.value], x = Do(m2, S);
      return p.value = g, x(v2 - g.left);
    }
    return Rs({
      startEdge: c.value ? "left" : "right",
      endEdge: c.value ? "right" : "left",
      direction: c.value ? 1 : -1,
      size: "width"
    }), (v2, g) => (openBlock(), createBlock(As, {
      ref: unref(u),
      dir: unref(r),
      "data-orientation": "horizontal",
      style: {
        "--radix-slider-thumb-transform": "translateX(-50%)"
      },
      onSlideStart: g[0] || (g[0] = (m2) => {
        const S = f(m2.clientX);
        n("slideStart", S);
      }),
      onSlideMove: g[1] || (g[1] = (m2) => {
        const S = f(m2.clientX);
        n("slideMove", S);
      }),
      onSlideEnd: g[2] || (g[2] = () => {
        p.value = void 0, n("slideEnd");
      }),
      onStepKeyDown: g[3] || (g[3] = (m2) => {
        const S = c.value ? "from-left" : "from-right", x = unref(Is)[S].includes(m2.key);
        n("stepKeyDown", m2, x ? -1 : 1);
      }),
      onEndKeyDown: g[4] || (g[4] = (m2) => n("endKeyDown", m2)),
      onHomeKeyDown: g[5] || (g[5] = (m2) => n("homeKeyDown", m2))
    }, {
      default: withCtx(() => [
        renderSlot(v2.$slots, "default")
      ]),
      _: 3
    }, 8, ["dir"]));
  }
});
var Up = defineComponent({
  __name: "SliderVertical",
  props: {
    min: {},
    max: {},
    inverted: { type: Boolean }
  },
  emits: ["slideEnd", "slideStart", "slideMove", "homeKeyDown", "endKeyDown", "stepKeyDown"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { max: l, min: s, inverted: r } = toRefs(e), { forwardRef: i, currentElement: u } = R2(), d = ref(), p = computed(() => !r.value);
    function c(f) {
      const v2 = d.value || u.value.getBoundingClientRect(), g = [0, v2.height], m2 = p.value ? [l.value, s.value] : [s.value, l.value], S = Do(g, m2);
      return d.value = v2, S(f - v2.top);
    }
    return Rs({
      startEdge: p.value ? "bottom" : "top",
      endEdge: p.value ? "top" : "bottom",
      size: "height",
      direction: p.value ? 1 : -1
    }), (f, v2) => (openBlock(), createBlock(As, {
      ref: unref(i),
      "data-orientation": "vertical",
      style: {
        "--radix-slider-thumb-transform": "translateY(50%)"
      },
      onSlideStart: v2[0] || (v2[0] = (g) => {
        const m2 = c(g.clientY);
        n("slideStart", m2);
      }),
      onSlideMove: v2[1] || (v2[1] = (g) => {
        const m2 = c(g.clientY);
        n("slideMove", m2);
      }),
      onSlideEnd: v2[2] || (v2[2] = () => {
        d.value = void 0, n("slideEnd");
      }),
      onStepKeyDown: v2[3] || (v2[3] = (g) => {
        const m2 = p.value ? "from-bottom" : "from-top", S = unref(Is)[m2].includes(g.key);
        n("stepKeyDown", g, S ? -1 : 1);
      }),
      onEndKeyDown: v2[4] || (v2[4] = (g) => n("endKeyDown", g)),
      onHomeKeyDown: v2[5] || (v2[5] = (g) => n("homeKeyDown", g))
    }, {
      default: withCtx(() => [
        renderSlot(f.$slots, "default")
      ]),
      _: 3
    }, 512));
  }
});
var Gp = ["value", "name", "disabled", "step"];
var [on, qp] = Q("SliderRoot");
var Ny = defineComponent({
  inheritAttrs: false,
  __name: "SliderRoot",
  props: {
    name: {},
    defaultValue: { default: () => [0] },
    modelValue: {},
    disabled: { type: Boolean, default: false },
    orientation: { default: "horizontal" },
    dir: {},
    inverted: { type: Boolean, default: false },
    min: { default: 0 },
    max: { default: 100 },
    step: { default: 1 },
    minStepsBetweenThumbs: { default: 0 },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "valueCommit"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { min: l, max: s, step: r, minStepsBetweenThumbs: i, orientation: u, disabled: d, dir: p } = toRefs(e), c = Ce(p), { forwardRef: f, currentElement: v2 } = R2(), g = Qe(v2);
    ga();
    const m2 = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), S = ref(0), x = ref(m2.value);
    function D(I) {
      const k = Lp(m2.value, I);
      P2(I, k);
    }
    function h2(I) {
      P2(I, S.value);
    }
    function E() {
      const I = x.value[S.value];
      m2.value[S.value] !== I && n("valueCommit", toRaw(m2.value));
    }
    function P2(I, k, { commit: L } = { commit: false }) {
      var J2;
      const O = Hp(r.value), V2 = Wp(Math.round((I - l.value) / r.value) * r.value + l.value, O), H2 = Kt(V2, l.value, s.value), Y = Vp(m2.value, H2, k);
      if (Kp(Y, i.value * r.value)) {
        S.value = Y.indexOf(H2);
        const N2 = String(Y) !== String(m2.value);
        N2 && L && n("valueCommit", Y), N2 && ((J2 = $2.value[S.value]) == null || J2.focus(), m2.value = Y);
      }
    }
    const $2 = ref([]);
    return qp({
      modelValue: m2,
      valueIndexToChangeRef: S,
      thumbElements: $2,
      orientation: u,
      min: l,
      max: s,
      disabled: d
    }), (I, k) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(ba), null, {
        default: withCtx(() => [
          (openBlock(), createBlock(resolveDynamicComponent(unref(u) === "horizontal" ? jp : Up), mergeProps(I.$attrs, {
            ref: unref(f),
            "as-child": I.asChild,
            as: I.as,
            min: unref(l),
            max: unref(s),
            dir: unref(c),
            inverted: I.inverted,
            "aria-disabled": unref(d),
            "data-disabled": unref(d) ? "" : void 0,
            onPointerdown: k[0] || (k[0] = () => {
              unref(d) || (x.value = unref(m2));
            }),
            onSlideStart: k[1] || (k[1] = (L) => !unref(d) && D(L)),
            onSlideMove: k[2] || (k[2] = (L) => !unref(d) && h2(L)),
            onSlideEnd: k[3] || (k[3] = (L) => !unref(d) && E()),
            onHomeKeyDown: k[4] || (k[4] = (L) => !unref(d) && P2(unref(l), 0, { commit: true })),
            onEndKeyDown: k[5] || (k[5] = (L) => !unref(d) && P2(unref(s), unref(m2).length - 1, { commit: true })),
            onStepKeyDown: k[6] || (k[6] = (L, O) => {
              if (!unref(d)) {
                const Y = unref($s).includes(L.key) || L.shiftKey && unref(Bs).includes(L.key) ? 10 : 1, J2 = S.value, N2 = unref(m2)[J2], F = unref(r) * Y * O;
                P2(N2 + F, J2, { commit: true });
              }
            })
          }), {
            default: withCtx(() => [
              renderSlot(I.$slots, "default", { modelValue: unref(m2) })
            ]),
            _: 3
          }, 16, ["as-child", "as", "min", "max", "dir", "inverted", "aria-disabled", "data-disabled"]))
        ]),
        _: 3
      }),
      unref(g) ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList(unref(m2), (L, O) => (openBlock(), createElementBlock("input", {
        key: O,
        value: L,
        type: "number",
        style: { display: "none" },
        name: I.name ? I.name + (unref(m2).length > 1 ? "[]" : "") : void 0,
        disabled: unref(d),
        step: unref(r)
      }, null, 8, Gp))), 128)) : createCommentVNode("", true)
    ], 64));
  }
});
var Yp = defineComponent({
  inheritAttrs: false,
  __name: "SliderThumbImpl",
  props: {
    index: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = on(), n = Ts(), { forwardRef: l, currentElement: s } = R2(), r = computed(() => {
      var v2, g;
      return (g = (v2 = e.modelValue) == null ? void 0 : v2.value) == null ? void 0 : g[t.index];
    }), i = computed(() => r.value === void 0 ? 0 : Ds(r.value, e.min.value ?? 0, e.max.value ?? 100)), u = computed(() => {
      var v2, g;
      return Fp(t.index, ((g = (v2 = e.modelValue) == null ? void 0 : v2.value) == null ? void 0 : g.length) ?? 0);
    }), d = Il(s), p = computed(() => d[n.size].value), c = computed(() => p.value ? Np(p.value, i.value, n.direction) : 0), f = Ha();
    return onMounted(() => {
      e.thumbElements.value.push(s.value);
    }), onUnmounted(() => {
      const v2 = e.thumbElements.value.findIndex((g) => g === s.value) ?? -1;
      e.thumbElements.value.splice(v2, 1);
    }), (v2, g) => (openBlock(), createBlock(unref(Xt), null, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps(v2.$attrs, {
          ref: unref(l),
          role: "slider",
          "data-radix-vue-collection-item": "",
          tabindex: unref(e).disabled.value ? void 0 : 0,
          "aria-label": v2.$attrs["aria-label"] || u.value,
          "data-disabled": unref(e).disabled.value ? "" : void 0,
          "data-orientation": unref(e).orientation.value,
          "aria-valuenow": r.value,
          "aria-valuemin": unref(e).min.value,
          "aria-valuemax": unref(e).max.value,
          "aria-orientation": unref(e).orientation.value,
          "as-child": v2.asChild,
          as: v2.as,
          style: {
            transform: "var(--radix-slider-thumb-transform)",
            position: "absolute",
            [unref(n).startEdge]: `calc(${i.value}% + ${c.value}px)`,
            /**
             * There will be no value on initial render while we work out the index so we hide thumbs
             * without a value, otherwise SSR will render them in the wrong position before they
             * snap into the correct position during hydration which would be visually jarring for
             * slower connections.
             */
            display: !unref(f) && r.value === void 0 ? "none" : void 0
          },
          onFocus: g[0] || (g[0] = () => {
            unref(e).valueIndexToChangeRef.value = v2.index;
          })
        }), {
          default: withCtx(() => [
            renderSlot(v2.$slots, "default")
          ]),
          _: 3
        }, 16, ["tabindex", "aria-label", "data-disabled", "data-orientation", "aria-valuenow", "aria-valuemin", "aria-valuemax", "aria-orientation", "as-child", "as", "style"])
      ]),
      _: 3
    }));
  }
});
var zy = defineComponent({
  __name: "SliderThumb",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { getItems: e } = Zt(), { forwardRef: n, currentElement: l } = R2(), s = computed(() => l.value ? e().findIndex((r) => r.ref === l.value) : -1);
    return (r, i) => (openBlock(), createBlock(Yp, mergeProps({ ref: unref(n) }, t, { index: s.value }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16, ["index"]));
  }
});
var Ky = defineComponent({
  __name: "SliderTrack",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = on();
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), {
      "as-child": e.asChild,
      as: e.as,
      "data-disabled": unref(t).disabled.value ? "" : void 0,
      "data-orientation": unref(t).orientation.value
    }, {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 8, ["as-child", "as", "data-disabled", "data-orientation"]));
  }
});
var Hy = defineComponent({
  __name: "SliderRange",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = on(), e = Ts();
    R2();
    const n = computed(() => {
      var r, i;
      return (i = (r = t.modelValue) == null ? void 0 : r.value) == null ? void 0 : i.map(
        (u) => Ds(u, t.min.value, t.max.value)
      );
    }), l = computed(() => t.modelValue.value.length > 1 ? Math.min(...n.value) : 0), s = computed(() => 100 - Math.max(...n.value));
    return (r, i) => (openBlock(), createBlock(unref(A2), {
      "data-disabled": unref(t).disabled.value ? "" : void 0,
      "data-orientation": unref(t).orientation.value,
      "as-child": r.asChild,
      as: r.as,
      style: normalizeStyle({
        [unref(e).startEdge]: `${l.value}%`,
        [unref(e).endEdge]: `${s.value}%`
      })
    }, {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 8, ["data-disabled", "data-orientation", "as-child", "as", "style"]));
  }
});
var Tn = null;
var xt = null;
function Xp(a2, t) {
  if (t) {
    const e = (t & Ls) !== 0, n = (t & Ns) !== 0, l = (t & zs) !== 0, s = (t & Ks) !== 0;
    if (e)
      return l ? "se-resize" : s ? "ne-resize" : "e-resize";
    if (n)
      return l ? "sw-resize" : s ? "nw-resize" : "w-resize";
    if (l)
      return "s-resize";
    if (s)
      return "n-resize";
  }
  switch (a2) {
    case "horizontal":
      return "ew-resize";
    case "intersection":
      return "move";
    case "vertical":
      return "ns-resize";
  }
}
function Zp() {
  xt !== null && (document.head.removeChild(xt), Tn = null, xt = null);
}
function _n(a2, t) {
  const e = Xp(a2, t);
  Tn !== e && (Tn = e, xt === null && (xt = document.createElement("style"), document.head.appendChild(xt)), xt.innerHTML = `*{cursor: ${e}!important;}`);
}
function Jp({
  defaultSize: a2,
  dragState: t,
  layout: e,
  panelData: n,
  panelIndex: l,
  precision: s = 3
}) {
  const r = e[l];
  let i;
  return r == null ? i = a2 !== void 0 ? a2.toPrecision(s) : "1" : n.length === 1 ? i = "1" : i = r.toPrecision(s), {
    flexBasis: 0,
    flexGrow: i,
    flexShrink: 1,
    // Without this, Panel sizes may be unintentionally overridden by their content
    overflow: "hidden",
    // Disable pointer events inside of a panel during resize
    // This avoid edge cases like nested iframes
    pointerEvents: t !== null ? "none" : void 0
  };
}
function Os(a2) {
  return a2.type === "keydown";
}
function ks(a2) {
  return a2.type.startsWith("mouse");
}
function Ms(a2) {
  return a2.type.startsWith("touch");
}
function ln(a2) {
  if (ks(a2))
    return {
      x: a2.clientX,
      y: a2.clientY
    };
  if (Ms(a2)) {
    const t = a2.touches[0];
    if (t && t.clientX && t.clientY)
      return {
        x: t.clientX,
        y: t.clientY
      };
  }
  return {
    x: Number.POSITIVE_INFINITY,
    y: Number.POSITIVE_INFINITY
  };
}
function Vs(a2, t) {
  const e = a2 === "horizontal", { x: n, y: l } = ln(t);
  return e ? n : l;
}
function Qp(a2, t, e) {
  return a2.x < t.x + t.width && a2.x + a2.width > t.x && a2.y < t.y + t.height && a2.y + a2.height > t.y;
}
function de(a2, t = "Assertion failed!") {
  if (!a2)
    throw console.error(t), new Error(t);
}
function ef(a2, t) {
  if (a2 === t)
    throw new Error("Cannot compare node with itself");
  const e = {
    a: Jo(a2),
    b: Jo(t)
  };
  let n;
  for (; e.a.at(-1) === e.b.at(-1); )
    a2 = e.a.pop(), t = e.b.pop(), n = a2;
  de(n);
  const l = {
    a: Zo(Xo(e.a)),
    b: Zo(Xo(e.b))
  };
  if (l.a === l.b) {
    const s = n.childNodes, r = {
      a: e.a.at(-1),
      b: e.b.at(-1)
    };
    let i = s.length;
    for (; i--; ) {
      const u = s[i];
      if (u === r.a)
        return 1;
      if (u === r.b)
        return -1;
    }
  }
  return Math.sign(l.a - l.b);
}
var tf = /\b(?:position|zIndex|opacity|transform|webkitTransform|mixBlendMode|filter|webkitFilter|isolation)\b/;
function af(a2) {
  const t = getComputedStyle(Fs(a2)).display;
  return t === "flex" || t === "inline-flex";
}
function nf(a2) {
  const t = getComputedStyle(a2);
  return !!(t.position === "fixed" || t.zIndex !== "auto" && (t.position !== "static" || af(a2)) || +t.opacity < 1 || "transform" in t && t.transform !== "none" || "webkitTransform" in t && t.webkitTransform !== "none" || "mixBlendMode" in t && t.mixBlendMode !== "normal" || "filter" in t && t.filter !== "none" || "webkitFilter" in t && t.webkitFilter !== "none" || "isolation" in t && t.isolation === "isolate" || tf.test(t.willChange) || t.webkitOverflowScrolling === "touch");
}
function Xo(a2) {
  let t = a2.length;
  for (; t--; ) {
    const e = a2[t];
    if (de(e), nf(e))
      return e;
  }
  return null;
}
function Zo(a2) {
  return a2 && Number(getComputedStyle(a2).zIndex) || 0;
}
function Jo(a2) {
  const t = [];
  for (; a2; )
    t.push(a2), a2 = Fs(a2);
  return t;
}
function Fs(a2) {
  var t;
  return ((t = a2.parentNode) == null ? void 0 : t.host) || a2.parentNode;
}
var Ls = 1;
var Ns = 2;
var zs = 4;
var Ks = 8;
function of() {
  if (typeof matchMedia == "function")
    return matchMedia("(pointer:coarse)").matches ? "coarse" : "fine";
}
var lf = of() === "coarse";
var ft = [];
var sn = false;
var ct = /* @__PURE__ */ new Map();
var rn = /* @__PURE__ */ new Map();
var da = /* @__PURE__ */ new Set();
function sf(a2, t, e, n, l) {
  const { ownerDocument: s } = t, r = {
    direction: e,
    element: t,
    hitAreaMargins: n,
    setResizeHandlerState: l
  }, i = ct.get(s) ?? 0;
  return ct.set(s, i + 1), da.add(r), La(), function() {
    rn.delete(a2), da.delete(r);
    const d = ct.get(s) ?? 1;
    ct.set(s, d - 1), La(), d === 1 && ct.delete(s);
  };
}
function Ia(a2) {
  const { target: t } = a2, { x: e, y: n } = ln(a2);
  sn = true, $o({ target: t, x: e, y: n }), La(), ft.length > 0 && (Bo("down", a2), a2.preventDefault());
}
function it(a2) {
  const { x: t, y: e } = ln(a2);
  if (!sn) {
    const { target: n } = a2;
    $o({ target: n, x: t, y: e });
  }
  Bo("move", a2), Hs(), ft.length > 0 && a2.preventDefault();
}
function ut(a2) {
  const { target: t } = a2, { x: e, y: n } = ln(a2);
  rn.clear(), sn = false, ft.length > 0 && a2.preventDefault(), Bo("up", a2), $o({ target: t, x: e, y: n }), Hs(), La();
}
function $o({
  target: a2,
  x: t,
  y: e
}) {
  ft.splice(0);
  let n = null;
  a2 instanceof HTMLElement && (n = a2), da.forEach((l) => {
    const { element: s, hitAreaMargins: r } = l, i = s.getBoundingClientRect(), { bottom: u, left: d, right: p, top: c } = i, f = lf ? r.coarse : r.fine;
    if (t >= d - f && t <= p + f && e >= c - f && e <= u + f) {
      if (n !== null && s !== n && !s.contains(n) && !n.contains(s) && ef(n, s) > 0) {
        let g = n, m2 = false;
        for (; g && !g.contains(s); ) {
          if (Qp(
            g.getBoundingClientRect(),
            i
          )) {
            m2 = true;
            break;
          }
          g = g.parentElement;
        }
        if (m2)
          return;
      }
      ft.push(l);
    }
  });
}
function xn(a2, t) {
  rn.set(a2, t);
}
function Hs() {
  let a2 = false, t = false;
  ft.forEach((n) => {
    const { direction: l } = n;
    l === "horizontal" ? a2 = true : t = true;
  });
  let e = 0;
  rn.forEach((n) => {
    e |= n;
  }), a2 && t ? _n("intersection", e) : a2 ? _n("horizontal", e) : t ? _n("vertical", e) : Zp();
}
function La() {
  ct.forEach((a2, t) => {
    const { body: e } = t;
    e.removeEventListener("contextmenu", ut), e.removeEventListener("mousedown", Ia), e.removeEventListener("mouseleave", it), e.removeEventListener("mousemove", it), e.removeEventListener("touchmove", it), e.removeEventListener("touchstart", Ia);
  }), window.removeEventListener("mouseup", ut), window.removeEventListener("touchcancel", ut), window.removeEventListener("touchend", ut), da.size > 0 && (sn ? (ft.length > 0 && ct.forEach((a2, t) => {
    const { body: e } = t;
    a2 > 0 && (e.addEventListener("contextmenu", ut), e.addEventListener("mouseleave", it), e.addEventListener("mousemove", it), e.addEventListener("touchmove", it, {
      passive: false
    }));
  }), window.addEventListener("mouseup", ut), window.addEventListener("touchcancel", ut), window.addEventListener("touchend", ut)) : ct.forEach((a2, t) => {
    const { body: e } = t;
    a2 > 0 && (e.addEventListener("mousedown", Ia), e.addEventListener("mousemove", it), e.addEventListener("touchmove", it, {
      passive: false
    }), e.addEventListener("touchstart", Ia));
  }));
}
function Bo(a2, t) {
  da.forEach((e) => {
    const { setResizeHandlerState: n } = e, l = ft.includes(e);
    n(a2, l, t);
  });
}
var Io = 10;
function ca(a2, t, e = Io) {
  a2 = Number.parseFloat(a2.toFixed(e)), t = Number.parseFloat(t.toFixed(e));
  const n = a2 - t;
  return n === 0 ? 0 : n > 0 ? 1 : -1;
}
function Fe(a2, t, e) {
  return ca(a2, t, e) === 0;
}
function Lt({
  panelConstraints: a2,
  panelIndex: t,
  size: e
}) {
  const n = a2[t];
  de(n != null);
  const { collapsedSize: l = 0, collapsible: s, maxSize: r = 100, minSize: i = 0 } = n;
  if (ca(e, i) < 0)
    if (s) {
      const u = (l + i) / 2;
      ca(e, u) < 0 ? e = l : e = i;
    } else
      e = i;
  return e = Math.min(r, e), e = Number.parseFloat(e.toFixed(Io)), e;
}
function Ta(a2, t) {
  if (a2.length !== t.length)
    return false;
  for (let e = 0; e < a2.length; e++)
    if (a2[e] !== t[e])
      return false;
  return true;
}
function oa({
  delta: a2,
  layout: t,
  panelConstraints: e,
  pivotIndices: n,
  trigger: l
}) {
  if (Fe(a2, 0))
    return t;
  const s = [...t], [r, i] = n;
  de(r != null), de(i != null);
  let u = 0;
  if (l === "keyboard") {
    {
      const p = a2 < 0 ? i : r, c = e[p];
      if (de(c), c.collapsible) {
        const f = t[p];
        de(f != null);
        const v2 = e[p];
        de(v2);
        const { collapsedSize: g = 0, minSize: m2 = 0 } = v2;
        if (Fe(f, g)) {
          const S = m2 - f;
          ca(S, Math.abs(a2)) > 0 && (a2 = a2 < 0 ? 0 - S : S);
        }
      }
    }
    {
      const p = a2 < 0 ? r : i, c = e[p];
      de(c);
      const { collapsible: f } = c;
      if (f) {
        const v2 = t[p];
        de(v2 != null);
        const g = e[p];
        de(g);
        const { collapsedSize: m2 = 0, minSize: S = 0 } = g;
        if (Fe(v2, S)) {
          const x = v2 - m2;
          ca(x, Math.abs(a2)) > 0 && (a2 = a2 < 0 ? 0 - x : x);
        }
      }
    }
  }
  {
    const p = a2 < 0 ? 1 : -1;
    let c = a2 < 0 ? i : r, f = 0;
    for (; ; ) {
      const g = t[c];
      de(g != null);
      const S = Lt({
        panelConstraints: e,
        panelIndex: c,
        size: 100
      }) - g;
      if (f += S, c += p, c < 0 || c >= e.length)
        break;
    }
    const v2 = Math.min(Math.abs(a2), Math.abs(f));
    a2 = a2 < 0 ? 0 - v2 : v2;
  }
  {
    let c = a2 < 0 ? r : i;
    for (; c >= 0 && c < e.length; ) {
      const f = Math.abs(a2) - Math.abs(u), v2 = t[c];
      de(v2 != null);
      const g = v2 - f, m2 = Lt({
        panelConstraints: e,
        panelIndex: c,
        size: g
      });
      if (!Fe(v2, m2) && (u += v2 - m2, s[c] = m2, u.toPrecision(3).localeCompare(Math.abs(a2).toPrecision(3), void 0, {
        numeric: true
      }) >= 0))
        break;
      a2 < 0 ? c-- : c++;
    }
  }
  if (Fe(u, 0))
    return t;
  {
    const p = a2 < 0 ? i : r, c = t[p];
    de(c != null);
    const f = c + u, v2 = Lt({
      panelConstraints: e,
      panelIndex: p,
      size: f
    });
    if (s[p] = v2, !Fe(v2, f)) {
      let g = f - v2, S = a2 < 0 ? i : r;
      for (; S >= 0 && S < e.length; ) {
        const x = s[S];
        de(x != null);
        const D = x + g, h2 = Lt({
          panelConstraints: e,
          panelIndex: S,
          size: D
        });
        if (Fe(x, h2) || (g -= h2 - x, s[S] = h2), Fe(g, 0))
          break;
        a2 > 0 ? S-- : S++;
      }
    }
  }
  const d = s.reduce((p, c) => c + p, 0);
  return Fe(d, 100) ? s : t;
}
function Ws(a2, t = document) {
  var n;
  if (!va)
    return null;
  if (t instanceof HTMLElement && ((n = t == null ? void 0 : t.dataset) == null ? void 0 : n.panelGroupId) === a2)
    return t;
  const e = t.querySelector(
    `[data-panel-group][data-panel-group-id="${a2}"]`
  );
  return e || null;
}
function un(a2, t = document) {
  if (!va)
    return null;
  const e = t.querySelector(`[data-panel-resize-handle-id="${a2}"]`);
  return e || null;
}
function js(a2, t, e = document) {
  return va ? pa(a2, e).findIndex(
    (s) => s.getAttribute("data-panel-resize-handle-id") === t
  ) ?? null : null;
}
function pa(a2, t = document) {
  return va ? Array.from(
    t.querySelectorAll(
      `[data-panel-resize-handle-id][data-panel-group-id="${a2}"]`
    )
  ) : [];
}
function rf(a2, t, e, n = document) {
  var d, p;
  const l = un(t, n), s = pa(a2, n), r = l ? s.indexOf(l) : -1, i = ((d = e[r]) == null ? void 0 : d.id) ?? null, u = ((p = e[r + 1]) == null ? void 0 : p.id) ?? null;
  return [i, u];
}
function uf(a2, t, e, n, l) {
  const s = e === "horizontal", r = un(t, l);
  de(r);
  const i = r.getAttribute("data-panel-group-id");
  de(i);
  const { initialCursorPosition: u } = n, d = Vs(e, a2), p = Ws(i, l);
  de(p);
  const c = p.getBoundingClientRect(), f = s ? c.width : c.height;
  return (d - u) / f * 100;
}
function df(a2, t, e, n, l, s) {
  if (Os(a2)) {
    const r = e === "horizontal";
    let i = 0;
    a2.shiftKey ? i = 100 : i = l ?? 10;
    let u = 0;
    switch (a2.key) {
      case "ArrowDown":
        u = r ? 0 : i;
        break;
      case "ArrowLeft":
        u = r ? -i : 0;
        break;
      case "ArrowRight":
        u = r ? i : 0;
        break;
      case "ArrowUp":
        u = r ? 0 : -i;
        break;
      case "End":
        u = 100;
        break;
      case "Home":
        u = -100;
        break;
    }
    return u;
  } else
    return n == null ? 0 : uf(
      a2,
      t,
      e,
      n,
      s
    );
}
function cf({
  layout: a2,
  panelsArray: t,
  pivotIndices: e
}) {
  let n = 0, l = 100, s = 0, r = 0;
  const i = e[0];
  de(i != null), t.forEach((c, f) => {
    const { constraints: v2 } = c, { maxSize: g = 100, minSize: m2 = 0 } = v2;
    f === i ? (n = m2, l = g) : (s += m2, r += g);
  });
  const u = Math.min(l, 100 - s), d = Math.max(n, 100 - r), p = a2[i];
  return {
    valueMax: u,
    valueMin: d,
    valueNow: p
  };
}
function pf({
  panelDataArray: a2
}) {
  const t = Array(a2.length), e = a2.map(
    (s) => s.constraints
  );
  let n = 0, l = 100;
  for (let s = 0; s < a2.length; s++) {
    const r = e[s];
    de(r);
    const { defaultSize: i } = r;
    i != null && (n++, t[s] = i, l -= i);
  }
  for (let s = 0; s < a2.length; s++) {
    const r = e[s];
    de(r);
    const { defaultSize: i } = r;
    if (i != null)
      continue;
    const u = a2.length - n, d = l / u;
    n++, t[s] = d, l -= d;
  }
  return t;
}
function na(a2, t, e) {
  t.forEach((n, l) => {
    const s = a2[l];
    de(s);
    const { callbacks: r, constraints: i, id: u } = s, { collapsedSize: d = 0, collapsible: p } = i, c = e[u];
    if (c == null || n !== c) {
      e[u] = n;
      const { onCollapse: f, onExpand: v2, onResize: g } = r;
      g && g(n, c), p && (f || v2) && (v2 && (c == null || c === d) && n !== d && v2(), f && (c == null || c !== d) && n === d && f());
    }
  });
}
function ff(a2, t = 10) {
  let e = null;
  return (...l) => {
    e !== null && clearTimeout(e), e = setTimeout(() => {
      a2(...l);
    }, t);
  };
}
function Us(a2, t, e) {
  const n = js(
    a2,
    t,
    e
  );
  return n != null ? [n, n + 1] : [-1, -1];
}
function vf({
  layout: a2,
  panelConstraints: t
}) {
  const e = [...a2], n = e.reduce(
    (s, r) => s + r,
    0
  );
  if (e.length !== t.length)
    throw new Error(
      `Invalid ${t.length} panel layout: ${e.map((s) => `${s}%`).join(", ")}`
    );
  if (!Fe(n, 100)) {
    console.warn(
      `WARNING: Invalid layout total size: ${e.map((s) => `${s}%`).join(", ")}. Layout normalization will be applied.`
    );
    for (let s = 0; s < t.length; s++) {
      const r = e[s];
      de(r != null);
      const i = 100 / n * r;
      e[s] = i;
    }
  }
  let l = 0;
  for (let s = 0; s < t.length; s++) {
    const r = e[s];
    de(r != null);
    const i = Lt({
      panelConstraints: t,
      panelIndex: s,
      size: r
    });
    r !== i && (l += r - i, e[s] = i);
  }
  if (!Fe(l, 0))
    for (let s = 0; s < t.length; s++) {
      const r = e[s];
      de(r != null);
      const i = r + l, u = Lt({
        panelConstraints: t,
        panelIndex: s,
        size: i
      });
      if (r !== u && (l -= u - r, e[s] = u, Fe(l, 0)))
        break;
    }
  return e;
}
function Qo(a2) {
  try {
    if (typeof localStorage < "u")
      a2.getItem = (t) => localStorage.getItem(t), a2.setItem = (t, e) => {
        localStorage.setItem(t, e);
      };
    else
      throw new TypeError("localStorage not supported in this environment");
  } catch (t) {
    console.error(t), a2.getItem = () => null, a2.setItem = () => {
    };
  }
}
function Gs(a2) {
  return `radix-vue:${a2}`;
}
function qs(a2) {
  return a2.map((t) => {
    const { constraints: e, id: n, idIsFromProps: l, order: s } = t;
    return l ? n : s ? `${s}:${JSON.stringify(e)}` : JSON.stringify(e);
  }).sort((t, e) => t.localeCompare(e)).join(",");
}
function Ys(a2, t) {
  try {
    const e = Gs(a2), n = t.getItem(e);
    if (n) {
      const l = JSON.parse(n);
      if (typeof l == "object" && l != null)
        return l;
    }
  } catch {
  }
  return null;
}
function mf(a2, t, e) {
  const n = Ys(a2, e) ?? {}, l = qs(t);
  return n[l] ?? null;
}
function hf(a2, t, e, n, l) {
  const s = Gs(a2), r = qs(t), i = Ys(a2, l) ?? {};
  i[r] = {
    expandToSizes: Object.fromEntries(e.entries()),
    layout: n
  };
  try {
    l.setItem(s, JSON.stringify(i));
  } catch (u) {
    console.error(u);
  }
}
function yf({
  eagerValuesRef: a2,
  groupId: t,
  layout: e,
  panelDataArray: n,
  panelGroupElement: l,
  setLayout: s
}) {
  watchEffect((r) => {
    const i = l.value;
    if (!i)
      return;
    const u = pa(
      t,
      i
    );
    for (let d = 0; d < n.length - 1; d++) {
      const { valueMax: p, valueMin: c, valueNow: f } = cf({
        layout: e.value,
        panelsArray: n,
        pivotIndices: [d, d + 1]
      }), v2 = u[d];
      if (v2 != null) {
        const g = n[d];
        de(g), v2.setAttribute("aria-controls", g.id), v2.setAttribute(
          "aria-valuemax",
          `${Math.round(p)}`
        ), v2.setAttribute(
          "aria-valuemin",
          `${Math.round(c)}`
        ), v2.setAttribute(
          "aria-valuenow",
          f != null ? `${Math.round(f)}` : ""
        );
      }
    }
    r(() => {
      u.forEach((d) => {
        d.removeAttribute("aria-controls"), d.removeAttribute("aria-valuemax"), d.removeAttribute("aria-valuemin"), d.removeAttribute("aria-valuenow");
      });
    });
  }), watchEffect((r) => {
    const i = l.value;
    if (!i)
      return;
    const u = a2.value;
    de(u);
    const { panelDataArray: d } = u, p = Ws(t, i);
    de(p != null, `No group found for id "${t}"`);
    const c = pa(t, i);
    de(c);
    const f = c.map((v2) => {
      const g = v2.getAttribute("data-panel-resize-handle-id");
      de(g);
      const [m2, S] = rf(
        t,
        g,
        d,
        i
      );
      if (m2 == null || S == null)
        return () => {
        };
      const x = (D) => {
        if (!D.defaultPrevented)
          switch (D.key) {
            case "Enter": {
              D.preventDefault();
              const h2 = d.findIndex(
                (E) => E.id === m2
              );
              if (h2 >= 0) {
                const E = d[h2];
                de(E);
                const P2 = e.value[h2], {
                  collapsedSize: $2 = 0,
                  collapsible: I,
                  minSize: k = 0
                } = E.constraints;
                if (P2 != null && I) {
                  const L = oa({
                    delta: Fe(P2, $2) ? k - $2 : $2 - P2,
                    layout: e.value,
                    panelConstraints: d.map(
                      (O) => O.constraints
                    ),
                    pivotIndices: Us(
                      t,
                      g,
                      i
                    ),
                    trigger: "keyboard"
                  });
                  e.value !== L && s(L);
                }
              }
              break;
            }
          }
      };
      return v2.addEventListener("keydown", x), () => {
        v2.removeEventListener("keydown", x);
      };
    });
    r(() => {
      f.forEach((v2) => v2());
    });
  });
}
var gf = 100;
var la = {
  getItem: (a2) => (Qo(la), la.getItem(a2)),
  setItem: (a2, t) => {
    Qo(la), la.setItem(a2, t);
  }
};
var [Xs, bf] = Q("PanelGroup");
var Wy = defineComponent({
  __name: "SplitterGroup",
  props: {
    id: {},
    autoSaveId: { default: null },
    direction: {},
    keyboardResizeBy: { default: 10 },
    storage: { default: () => la },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["layout"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = {}, s = me(e.id, "radix-vue-splitter-group"), r = Ce(), { forwardRef: i, currentElement: u } = R2(), d = ref(null), p = ref([]), c = ref({}), f = ref(/* @__PURE__ */ new Map()), v2 = ref(0), g = computed(() => ({
      autoSaveId: e.autoSaveId,
      direction: e.direction,
      dragState: d.value,
      id: s,
      keyboardResizeBy: e.keyboardResizeBy,
      storage: e.storage
    })), m2 = ref({
      layout: p.value,
      panelDataArray: [],
      panelDataArrayChanged: false
    }), S = (F) => p.value = F;
    yf({
      eagerValuesRef: m2,
      groupId: s,
      layout: p,
      panelDataArray: m2.value.panelDataArray,
      setLayout: S,
      panelGroupElement: u
    }), watchEffect(() => {
      const { panelDataArray: F } = m2.value, { autoSaveId: W2 } = e;
      if (W2) {
        if (p.value.length === 0 || p.value.length !== F.length)
          return;
        let z2 = l[W2];
        z2 || (z2 = ff(
          hf,
          gf
        ), l[W2] = z2);
        const Z = [...F], U = new Map(
          f.value
        );
        z2(
          W2,
          Z,
          U,
          p.value,
          e.storage
        );
      }
    });
    function x(F, W2) {
      const { panelDataArray: z2 } = m2.value, Z = J2(z2, F);
      return Jp({
        defaultSize: W2,
        dragState: d.value,
        layout: p.value,
        panelData: z2,
        panelIndex: Z
      });
    }
    function D(F) {
      const { panelDataArray: W2 } = m2.value;
      W2.push(F), W2.sort((z2, Z) => {
        const U = z2.order, X = Z.order;
        return U == null && X == null ? 0 : U == null ? -1 : X == null ? 1 : U - X;
      }), m2.value.panelDataArrayChanged = true;
    }
    watch(() => m2.value.panelDataArrayChanged, () => {
      if (m2.value.panelDataArrayChanged) {
        m2.value.panelDataArrayChanged = false;
        const { autoSaveId: F, storage: W2 } = g.value, { layout: z2, panelDataArray: Z } = m2.value;
        let U = null;
        if (F) {
          const ee = mf(F, Z, W2);
          ee && (f.value = new Map(
            Object.entries(ee.expandToSizes)
          ), U = ee.layout);
        }
        U === null && (U = pf({
          panelDataArray: Z
        }));
        const X = vf({
          layout: U,
          panelConstraints: Z.map(
            (ee) => ee.constraints
          )
        });
        Rr(z2, X) || (S(X), m2.value.layout = X, n("layout", X), na(
          Z,
          X,
          c.value
        ));
      }
    });
    function h2(F) {
      return function(z2) {
        z2.preventDefault();
        const Z = u.value;
        if (!Z)
          return () => null;
        const { direction: U, dragState: X, id: ee, keyboardResizeBy: fe } = g.value, { layout: G2, panelDataArray: oe } = m2.value, { initialLayout: he } = X ?? {}, we = Us(
          ee,
          F,
          Z
        );
        let ge = df(
          z2,
          F,
          U,
          X,
          fe,
          Z
        );
        if (ge === 0)
          return;
        const De = U === "horizontal";
        r.value === "rtl" && De && (ge = -ge);
        const ue = oe.map((Ke) => Ke.constraints), Se = oa({
          delta: ge,
          layout: he ?? G2,
          panelConstraints: ue,
          pivotIndices: we,
          trigger: Os(z2) ? "keyboard" : "mouse-or-touch"
        }), Ve = !Ta(G2, Se);
        (ks(z2) || Ms(z2)) && v2.value !== ge && (v2.value = ge, Ve ? xn(F, 0) : De ? xn(
          F,
          ge < 0 ? Ls : Ns
        ) : xn(
          F,
          ge < 0 ? zs : Ks
        )), Ve && (S(Se), m2.value.layout = Se, n("layout", Se), na(
          oe,
          Se,
          c.value
        ));
      };
    }
    function E(F, W2) {
      const { layout: z2, panelDataArray: Z } = m2.value, U = Z.map((he) => he.constraints), { panelSize: X, pivotIndices: ee } = N2(
        Z,
        F,
        z2
      );
      de(X != null);
      const G2 = J2(Z, F) === Z.length - 1 ? X - W2 : W2 - X, oe = oa({
        delta: G2,
        layout: z2,
        panelConstraints: U,
        pivotIndices: ee,
        trigger: "imperative-api"
      });
      Ta(z2, oe) || (S(oe), m2.value.layout = oe, n("layout", oe), na(
        Z,
        oe,
        c.value
      ));
    }
    function P2(F, W2) {
      const { layout: z2, panelDataArray: Z } = m2.value, U = J2(Z, F);
      Z[U] = F, m2.value.panelDataArrayChanged = true;
      const {
        collapsedSize: X = 0,
        collapsible: ee
      } = W2, {
        collapsedSize: fe = 0,
        collapsible: G2,
        maxSize: oe = 100,
        minSize: he = 0
      } = F.constraints, { panelSize: we } = N2(
        Z,
        F,
        z2
      );
      we !== null && (ee && G2 && we === X ? X !== fe && E(F, fe) : we < he ? E(F, he) : we > oe && E(F, oe));
    }
    function $2(F, W2) {
      const { direction: z2 } = g.value, { layout: Z } = m2.value;
      if (!u.value)
        return;
      const U = un(
        F,
        u.value
      );
      de(U);
      const X = Vs(
        z2,
        W2
      );
      d.value = {
        dragHandleId: F,
        dragHandleRect: U.getBoundingClientRect(),
        initialCursorPosition: X,
        initialLayout: Z
      };
    }
    function I() {
      d.value = null;
    }
    function k(F) {
      const { panelDataArray: W2 } = m2.value, z2 = J2(W2, F);
      z2 >= 0 && (W2.splice(z2, 1), delete c.value[F.id], m2.value.panelDataArrayChanged = true);
    }
    function L(F) {
      const { layout: W2, panelDataArray: z2 } = m2.value;
      if (F.constraints.collapsible) {
        const Z = z2.map(
          (fe) => fe.constraints
        ), {
          collapsedSize: U = 0,
          panelSize: X,
          pivotIndices: ee
        } = N2(z2, F, W2);
        if (de(
          X != null,
          `Panel size not found for panel "${F.id}"`
        ), X !== U) {
          f.value.set(F.id, X);
          const G2 = J2(z2, F) === z2.length - 1 ? X - U : U - X, oe = oa({
            delta: G2,
            layout: W2,
            panelConstraints: Z,
            pivotIndices: ee,
            trigger: "imperative-api"
          });
          Ta(W2, oe) || (S(oe), m2.value.layout = oe, n("layout", oe), na(
            z2,
            oe,
            c.value
          ));
        }
      }
    }
    function O(F) {
      const { layout: W2, panelDataArray: z2 } = m2.value;
      if (F.constraints.collapsible) {
        const Z = z2.map(
          (G2) => G2.constraints
        ), {
          collapsedSize: U = 0,
          panelSize: X,
          minSize: ee = 0,
          pivotIndices: fe
        } = N2(z2, F, W2);
        if (X === U) {
          const G2 = f.value.get(
            F.id
          ), oe = G2 != null && G2 >= ee ? G2 : ee, we = J2(z2, F) === z2.length - 1 ? X - oe : oe - X, ge = oa({
            delta: we,
            layout: W2,
            panelConstraints: Z,
            pivotIndices: fe,
            trigger: "imperative-api"
          });
          Ta(W2, ge) || (S(ge), m2.value.layout = ge, n("layout", ge), na(
            z2,
            ge,
            c.value
          ));
        }
      }
    }
    function V2(F) {
      const { layout: W2, panelDataArray: z2 } = m2.value, { panelSize: Z } = N2(z2, F, W2);
      return de(
        Z != null,
        `Panel size not found for panel "${F.id}"`
      ), Z;
    }
    function H2(F) {
      const { layout: W2, panelDataArray: z2 } = m2.value, {
        collapsedSize: Z = 0,
        collapsible: U,
        panelSize: X
      } = N2(z2, F, W2);
      return U === true && X === Z;
    }
    function Y(F) {
      const { layout: W2, panelDataArray: z2 } = m2.value, {
        collapsedSize: Z = 0,
        collapsible: U,
        panelSize: X
      } = N2(z2, F, W2);
      return de(
        X != null,
        `Panel size not found for panel "${F.id}"`
      ), !U || X > Z;
    }
    bf({
      direction: e.direction,
      dragState: d.value,
      groupId: s,
      reevaluatePanelConstraints: P2,
      registerPanel: D,
      registerResizeHandle: h2,
      resizePanel: E,
      startDragging: $2,
      stopDragging: I,
      unregisterPanel: k,
      panelGroupElement: u,
      collapsePanel: L,
      expandPanel: O,
      isPanelCollapsed: H2,
      isPanelExpanded: Y,
      getPanelSize: V2,
      getPanelStyle: x
    });
    function J2(F, W2) {
      return F.findIndex(
        (z2) => z2 === W2 || z2.id === W2.id
      );
    }
    function N2(F, W2, z2) {
      const Z = J2(F, W2), X = Z === F.length - 1 ? [Z - 1, Z] : [Z, Z + 1], ee = z2[Z];
      return {
        ...W2.constraints,
        panelSize: ee,
        pivotIndices: X
      };
    }
    return (F, W2) => (openBlock(), createBlock(unref(A2), {
      ref: unref(i),
      style: normalizeStyle({
        display: "flex",
        flexDirection: F.direction === "horizontal" ? "row" : "column",
        height: "100%",
        overflow: "hidden",
        width: "100%"
      }),
      "data-panel-group": "",
      "data-orientation": F.direction,
      "data-panel-group-id": unref(s)
    }, {
      default: withCtx(() => [
        renderSlot(F.$slots, "default", { layout: p.value })
      ]),
      _: 3
    }, 8, ["style", "data-orientation", "data-panel-group-id"]));
  }
});
var jy = defineComponent({
  __name: "SplitterPanel",
  props: {
    collapsedSize: {},
    collapsible: { type: Boolean },
    defaultSize: {},
    id: {},
    maxSize: {},
    minSize: {},
    order: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["collapse", "expand", "resize"],
  setup(a2, { expose: t, emit: e }) {
    const n = a2, l = e, s = Xs();
    if (s === null)
      throw new Error(
        "SplitterPanel components must be rendered within a SplitterGroup container"
      );
    const { collapsePanel: r, expandPanel: i, getPanelSize: u, getPanelStyle: d, isPanelCollapsed: p, resizePanel: c, groupId: f, reevaluatePanelConstraints: v2, registerPanel: g, unregisterPanel: m2 } = s, S = me(n.id, "radix-vue-splitter-panel"), x = computed(() => ({
      callbacks: {
        onCollapse: () => l("collapse"),
        onExpand: () => l("expand"),
        onResize: (...P2) => l("resize", ...P2)
      },
      constraints: {
        collapsedSize: n.collapsedSize && Number.parseFloat(n.collapsedSize.toFixed(Io)),
        collapsible: n.collapsible,
        defaultSize: n.defaultSize,
        /** Panel id (unique within group); falls back to useId when not provided */
        /** Panel id (unique within group); falls back to useId when not provided */
        maxSize: n.maxSize,
        minSize: n.minSize
      },
      id: S,
      idIsFromProps: n.id !== void 0,
      order: n.order
    }));
    watch(() => x.value.constraints, (P2, $2) => {
      ($2.collapsedSize !== P2.collapsedSize || $2.collapsible !== P2.collapsible || $2.maxSize !== P2.maxSize || $2.minSize !== P2.minSize) && v2(x.value, $2);
    }, { deep: true }), onMounted(() => {
      const P2 = x.value;
      g(P2), onUnmounted(() => {
        m2(P2);
      });
    });
    const D = computed(() => d(x.value, n.defaultSize)), h2 = computed(() => p(x.value)), E = computed(() => !h2.value);
    return t({
      /** If panel is `collapsible`, collapse it fully. */
      collapse: () => {
        r(x.value);
      },
      /** If panel is currently collapsed, expand it to its most recent size. */
      expand: () => {
        i(x.value);
      },
      /** Gets the current size of the panel as a percentage (1 - 100). */
      getSize() {
        return u(x.value);
      },
      /** Resize panel to the specified percentage (1 - 100). */
      resize: (P2) => {
        c(x.value, P2);
      },
      /** Returns `true` if the panel is currently collapsed */
      isCollapsed: h2,
      /** Returns `true` if the panel is currently not collapsed */
      isExpanded: E
    }), (P2, $2) => (openBlock(), createBlock(unref(A2), {
      id: unref(S),
      style: normalizeStyle(D.value),
      "data-panel": "",
      "data-panel-collapsible": P2.collapsible || void 0,
      "data-panel-group-id": unref(f),
      "data-panel-id": unref(S),
      "data-panel-size": Number.parseFloat(`${D.value.flexGrow}`).toFixed(1),
      "data-state": P2.collapsible ? h2.value ? "collapsed" : "expanded" : void 0
    }, {
      default: withCtx(() => [
        renderSlot(P2.$slots, "default", {
          isCollapsed: h2.value,
          isExpanded: E.value
        })
      ]),
      _: 3
    }, 8, ["id", "style", "data-panel-collapsible", "data-panel-group-id", "data-panel-id", "data-panel-size", "data-state"]));
  }
});
function Cf({
  disabled: a2,
  handleId: t,
  resizeHandler: e,
  panelGroupElement: n
}) {
  watchEffect((l) => {
    const s = n.value;
    if (a2.value || e.value === null || s === null)
      return;
    const r = un(t, s);
    if (r == null)
      return;
    const i = (u) => {
      var d;
      if (!u.defaultPrevented)
        switch (u.key) {
          case "ArrowDown":
          case "ArrowLeft":
          case "ArrowRight":
          case "ArrowUp":
          case "End":
          case "Home": {
            u.preventDefault(), (d = e.value) == null || d.call(e, u);
            break;
          }
          case "F6": {
            u.preventDefault();
            const p = r.getAttribute("data-panel-group-id");
            de(p);
            const c = pa(
              p,
              s
            ), f = js(
              p,
              t,
              s
            );
            de(f !== null);
            const v2 = u.shiftKey ? f > 0 ? f - 1 : c.length - 1 : f + 1 < c.length ? f + 1 : 0;
            c[v2].focus();
            break;
          }
        }
    };
    r.addEventListener("keydown", i), l(() => {
      r.removeEventListener("keydown", i);
    });
  });
}
var Uy = defineComponent({
  __name: "SplitterResizeHandle",
  props: {
    id: {},
    hitAreaMargins: {},
    tabindex: { default: 0 },
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["dragging"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l, currentElement: s } = R2(), { disabled: r } = toRefs(e), i = Xs();
    if (i === null)
      throw new Error(
        "PanelResizeHandle components must be rendered within a PanelGroup container"
      );
    const {
      direction: u,
      groupId: d,
      registerResizeHandle: p,
      startDragging: c,
      stopDragging: f,
      panelGroupElement: v2
    } = i, g = me(e.id, "radix-vue-splitter-resize-handle"), m2 = ref("inactive"), S = ref(false), x = ref(null);
    return watch(r, () => {
      va && (r.value ? x.value = null : x.value = p(g));
    }, { immediate: true }), watchEffect((D) => {
      var P2, $2;
      if (r.value || x.value === null)
        return;
      const h2 = s.value;
      if (!h2)
        return;
      de(h2);
      const E = (I, k, L) => {
        var O;
        if (k)
          switch (I) {
            case "down": {
              m2.value = "drag", c(g, L), n("dragging", true);
              break;
            }
            case "move": {
              m2.value !== "drag" && (m2.value = "hover"), (O = x.value) == null || O.call(x, L);
              break;
            }
            case "up": {
              m2.value = "hover", f(), n("dragging", false);
              break;
            }
          }
        else
          m2.value = "inactive";
      };
      D(sf(
        g,
        h2,
        u,
        {
          // Coarse inputs (e.g. finger/touch)
          coarse: ((P2 = e.hitAreaMargins) == null ? void 0 : P2.coarse) ?? 15,
          // Fine inputs (e.g. mouse)
          fine: (($2 = e.hitAreaMargins) == null ? void 0 : $2.fine) ?? 5
        },
        E
      ));
    }), Cf({
      disabled: r,
      resizeHandler: x,
      handleId: g,
      panelGroupElement: v2
    }), (D, h2) => (openBlock(), createBlock(unref(A2), {
      id: unref(g),
      ref: unref(l),
      style: {
        touchAction: "none",
        userSelect: "none"
      },
      role: "separator",
      "data-resize-handle": "",
      tabindex: D.tabindex,
      "data-state": m2.value,
      "data-disabled": unref(r) ? "" : void 0,
      "data-orientation": unref(u),
      "data-panel-group-id": unref(d),
      "data-resize-handle-active": m2.value === "drag" ? "pointer" : S.value ? "keyboard" : void 0,
      "data-resize-handle-state": m2.value,
      "data-panel-resize-handle-enabled": !unref(r),
      "data-panel-resize-handle-id": unref(g),
      onBlur: h2[0] || (h2[0] = (E) => S.value = false),
      onFocus: h2[1] || (h2[1] = (E) => S.value = false)
    }, {
      default: withCtx(() => [
        renderSlot(D.$slots, "default")
      ]),
      _: 3
    }, 8, ["id", "tabindex", "data-state", "data-disabled", "data-orientation", "data-panel-group-id", "data-resize-handle-active", "data-resize-handle-state", "data-panel-resize-handle-enabled", "data-panel-resize-handle-id"]));
  }
});
var wf = {
  "aria-live": "polite",
  "aria-atomic": "true",
  role: "status",
  style: {
    transform: "translateX(-100%)",
    position: "absolute",
    pointerEvents: "none",
    opacity: 0,
    margin: 0
  }
};
var [To, _f] = Q("StepperRoot");
var Gy = defineComponent({
  __name: "StepperRoot",
  props: {
    defaultValue: { default: 1 },
    orientation: { default: "horizontal" },
    dir: {},
    modelValue: {},
    linear: { type: Boolean, default: true },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { dir: l, orientation: s, linear: r } = toRefs(e), i = Ce(l);
    R2();
    const u = ref(/* @__PURE__ */ new Set()), d = ref(/* @__PURE__ */ new Set()), p = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    });
    return _f({
      modelValue: p,
      changeModelValue: (c) => {
        p.value = c;
      },
      orientation: s,
      dir: i,
      linear: r,
      stepperItems: u,
      totalStepperItems: d
    }), (c, f) => (openBlock(), createBlock(unref(A2), {
      role: "group",
      "aria-label": "progress",
      as: c.as,
      "as-child": c.asChild,
      "data-linear": unref(r) ? "" : void 0,
      "data-orientation": c.orientation
    }, {
      default: withCtx(() => [
        renderSlot(c.$slots, "default", { modelValue: unref(p) }),
        createBaseVNode("div", wf, " Step " + toDisplayString(unref(p)) + " of " + toDisplayString(d.value.size), 1)
      ]),
      _: 3
    }, 8, ["as", "as-child", "data-linear", "data-orientation"]));
  }
});
var [_a, xf] = Q("StepperItem");
var qy = defineComponent({
  __name: "StepperItem",
  props: {
    step: {},
    disabled: { type: Boolean, default: false },
    completed: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { disabled: e, step: n, completed: l } = toRefs(t), { forwardRef: s } = R2(), r = To(), i = me(void 0, "radix-vue-stepper-item-title"), u = me(void 0, "radix-vue-stepper-item-description"), d = computed(() => l.value ? "completed" : r.modelValue.value === n.value ? "active" : r.modelValue.value > n.value ? "completed" : "inactive"), p = computed(() => e.value ? false : r.linear.value ? n.value <= r.modelValue.value || n.value === r.modelValue.value + 1 : true);
    return xf({
      titleId: i,
      descriptionId: u,
      state: d,
      disabled: e,
      step: n,
      isFocusable: p
    }), (c, f) => (openBlock(), createBlock(unref(A2), {
      ref: unref(s),
      as: c.as,
      "as-child": c.asChild,
      "aria-current": d.value === "active" ? "true" : void 0,
      "data-state": d.value,
      disabled: unref(e) || !p.value ? "" : void 0,
      "data-disabled": unref(e) || !p.value ? "" : void 0,
      "data-orientation": unref(r).orientation.value
    }, {
      default: withCtx(() => [
        renderSlot(c.$slots, "default", { state: d.value })
      ]),
      _: 3
    }, 8, ["as", "as-child", "aria-current", "data-state", "disabled", "data-disabled", "data-orientation"]));
  }
});
var Yy = defineComponent({
  __name: "StepperTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = To(), e = _a(), n = et(), l = computed(() => Array.from(t.stepperItems.value));
    function s(d) {
      if (!e.disabled.value) {
        if (t.linear.value) {
          if ((e.step.value <= t.modelValue.value || e.step.value === t.modelValue.value + 1) && d.ctrlKey === false) {
            t.changeModelValue(e.step.value);
            return;
          }
        } else if (d.ctrlKey === false) {
          t.changeModelValue(e.step.value);
          return;
        }
        d.preventDefault();
      }
    }
    function r(d) {
      d.preventDefault(), !e.disabled.value && ((d.key === n.ENTER || d.key === n.SPACE) && !d.ctrlKey && !d.shiftKey && t.changeModelValue(e.step.value), [n.ARROW_LEFT, n.ARROW_RIGHT, n.ARROW_UP, n.ARROW_DOWN].includes(d.key) && $t(d, document.activeElement, void 0, {
        itemsArray: l.value,
        focus: true,
        loop: false,
        arrowKeyOptions: t.orientation.value,
        dir: t.dir.value
      }));
    }
    const { forwardRef: i, currentElement: u } = R2();
    return onMounted(() => {
      e.isFocusable.value && t.stepperItems.value.add(u.value), t.totalStepperItems.value.add(u.value);
    }), onUnmounted(() => {
      t.stepperItems.value.delete(u.value), t.totalStepperItems.value.delete(u.value);
    }), watch(e.isFocusable, (d) => {
      d ? t.stepperItems.value.add(u.value) : t.stepperItems.value.delete(u.value);
    }), (d, p) => (openBlock(), createBlock(unref(A2), {
      ref: unref(i),
      type: d.as === "button" ? "button" : void 0,
      as: d.as,
      "as-child": d.asChild,
      "data-state": unref(e).state.value,
      disabled: unref(e).disabled.value || !unref(e).isFocusable.value ? "" : void 0,
      "data-disabled": unref(e).disabled.value || !unref(e).isFocusable.value ? "" : void 0,
      "data-orientation": unref(t).orientation.value,
      tabindex: unref(e).isFocusable.value ? 0 : -1,
      "aria-describedby": unref(e).descriptionId,
      "aria-labelledby": unref(e).titleId,
      onMousedown: withModifiers(s, ["left"]),
      onKeydown: withKeys(r, ["enter", "space", "left", "right", "up", "down"])
    }, {
      default: withCtx(() => [
        renderSlot(d.$slots, "default")
      ]),
      _: 3
    }, 8, ["type", "as", "as-child", "data-state", "disabled", "data-disabled", "data-orientation", "tabindex", "aria-describedby", "aria-labelledby"]));
  }
});
var Xy = defineComponent({
  __name: "StepperDescription",
  props: {
    asChild: { type: Boolean },
    as: { default: "p" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = _a();
    return (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).descriptionId
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var Zy = defineComponent({
  __name: "StepperTitle",
  props: {
    asChild: { type: Boolean },
    as: { default: "h4" }
  },
  setup(a2) {
    const t = a2, e = _a();
    return R2(), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).titleId
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var Jy = defineComponent({
  __name: "StepperIndicator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = _a();
    return R2(), (n, l) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode(" Step " + toDisplayString(unref(e).step.value), 1)
        ])
      ]),
      _: 3
    }, 16));
  }
});
var Qy = defineComponent({
  __name: "StepperSeparator",
  props: {
    orientation: {},
    decorative: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = To(), n = _a();
    return R2(), (l, s) => (openBlock(), createBlock(unref(Mp), mergeProps(t, {
      decorative: "",
      orientation: unref(e).orientation.value,
      "data-state": unref(n).state.value
    }), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16, ["orientation", "data-state"]));
  }
});
var Sf = ["name", "disabled", "required", "value", "checked", "data-state", "data-disabled"];
var [Ef, Pf] = Q("SwitchRoot");
var eg = defineComponent({
  __name: "SwitchRoot",
  props: {
    defaultChecked: { type: Boolean },
    checked: { type: Boolean, default: void 0 },
    disabled: { type: Boolean },
    required: { type: Boolean },
    name: {},
    id: {},
    value: { default: "on" },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  emits: ["update:checked"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { disabled: l } = toRefs(e), s = ae(e, "checked", n, {
      defaultValue: e.defaultChecked,
      passive: e.checked === void 0
    });
    function r() {
      l.value || (s.value = !s.value);
    }
    const { forwardRef: i, currentElement: u } = R2(), d = Qe(u), p = computed(() => {
      var c;
      return e.id && u.value ? (c = document.querySelector(`[for="${e.id}"]`)) == null ? void 0 : c.innerText : void 0;
    });
    return Pf({
      checked: s,
      toggleCheck: r,
      disabled: l
    }), (c, f) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps(c.$attrs, {
        id: c.id,
        ref: unref(i),
        role: "switch",
        type: c.as === "button" ? "button" : void 0,
        value: c.value,
        "aria-label": c.$attrs["aria-label"] || p.value,
        "aria-checked": unref(s),
        "aria-required": c.required,
        "data-state": unref(s) ? "checked" : "unchecked",
        "data-disabled": unref(l) ? "" : void 0,
        "as-child": c.asChild,
        as: c.as,
        disabled: unref(l),
        onClick: r,
        onKeydown: withKeys(withModifiers(r, ["prevent"]), ["enter"])
      }), {
        default: withCtx(() => [
          renderSlot(c.$slots, "default", { checked: unref(s) })
        ]),
        _: 3
      }, 16, ["id", "type", "value", "aria-label", "aria-checked", "aria-required", "data-state", "data-disabled", "as-child", "as", "disabled", "onKeydown"]),
      unref(d) ? (openBlock(), createElementBlock("input", {
        key: 0,
        type: "checkbox",
        name: c.name,
        tabindex: "-1",
        "aria-hidden": "",
        disabled: unref(l),
        required: c.required,
        value: c.value,
        checked: !!unref(s),
        "data-state": unref(s) ? "checked" : "unchecked",
        "data-disabled": unref(l) ? "" : void 0,
        style: {
          transform: "translateX(-100%)",
          position: "absolute",
          pointerEvents: "none",
          opacity: 0,
          margin: 0
        }
      }, null, 8, Sf)) : createCommentVNode("", true)
    ], 64));
  }
});
var tg = defineComponent({
  __name: "SwitchThumb",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = Ef();
    return R2(), (e, n) => {
      var l;
      return openBlock(), createBlock(unref(A2), {
        "data-state": (l = unref(t).checked) != null && l.value ? "checked" : "unchecked",
        "data-disabled": unref(t).disabled.value ? "" : void 0,
        "as-child": e.asChild,
        as: e.as
      }, {
        default: withCtx(() => [
          renderSlot(e.$slots, "default")
        ]),
        _: 3
      }, 8, ["data-state", "data-disabled", "as-child", "as"]);
    };
  }
});
var [dn, Df] = Q("TabsRoot");
var ag = defineComponent({
  __name: "TabsRoot",
  props: {
    defaultValue: {},
    orientation: { default: "horizontal" },
    dir: {},
    activationMode: { default: "automatic" },
    modelValue: {},
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { orientation: l, dir: s } = toRefs(e), r = Ce(s);
    R2();
    const i = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: e.modelValue === void 0
    }), u = ref();
    return Df({
      modelValue: i,
      changeModelValue: (d) => {
        i.value = d;
      },
      orientation: l,
      dir: r,
      activationMode: e.activationMode,
      baseId: me(void 0, "radix-vue-tabs"),
      tabsList: u
    }), (d, p) => (openBlock(), createBlock(unref(A2), {
      dir: unref(r),
      "data-orientation": unref(l),
      "as-child": d.asChild,
      as: d.as
    }, {
      default: withCtx(() => [
        renderSlot(d.$slots, "default", { modelValue: unref(i) })
      ]),
      _: 3
    }, 8, ["dir", "data-orientation", "as-child", "as"]));
  }
});
var ng = defineComponent({
  __name: "TabsList",
  props: {
    loop: { type: Boolean, default: true },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { loop: e } = toRefs(t), { forwardRef: n, currentElement: l } = R2(), s = dn();
    return s.tabsList = l, (r, i) => (openBlock(), createBlock(unref(At), {
      "as-child": "",
      orientation: unref(s).orientation.value,
      dir: unref(s).dir.value,
      loop: unref(e)
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(n),
          role: "tablist",
          "as-child": r.asChild,
          as: r.as,
          "aria-orientation": unref(s).orientation.value
        }, {
          default: withCtx(() => [
            renderSlot(r.$slots, "default")
          ]),
          _: 3
        }, 8, ["as-child", "as", "aria-orientation"])
      ]),
      _: 3
    }, 8, ["orientation", "dir", "loop"]));
  }
});
function Zs(a2, t) {
  return `${a2}-trigger-${t}`;
}
function Js(a2, t) {
  return `${a2}-content-${t}`;
}
var og = defineComponent({
  __name: "TabsContent",
  props: {
    value: {},
    forceMount: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), n = dn(), l = computed(() => Zs(n.baseId, t.value)), s = computed(() => Js(n.baseId, t.value)), r = computed(() => t.value === n.modelValue.value), i = ref(r.value);
    return onMounted(() => {
      requestAnimationFrame(() => {
        i.value = false;
      });
    }), (u, d) => (openBlock(), createBlock(unref(Pe), {
      present: r.value,
      "force-mount": ""
    }, {
      default: withCtx(({ present: p }) => [
        createVNode(unref(A2), {
          id: s.value,
          ref: unref(e),
          "as-child": u.asChild,
          as: u.as,
          role: "tabpanel",
          "data-state": r.value ? "active" : "inactive",
          "data-orientation": unref(n).orientation.value,
          "aria-labelledby": l.value,
          hidden: !p.value,
          tabindex: "0",
          style: normalizeStyle({
            animationDuration: i.value ? "0s" : void 0
          })
        }, {
          default: withCtx(() => [
            u.forceMount || r.value ? renderSlot(u.$slots, "default", { key: 0 }) : createCommentVNode("", true)
          ]),
          _: 2
        }, 1032, ["id", "as-child", "as", "data-state", "data-orientation", "aria-labelledby", "hidden", "style"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var lg = defineComponent({
  __name: "TabsTrigger",
  props: {
    value: {},
    disabled: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), n = dn(), l = computed(() => Zs(n.baseId, t.value)), s = computed(() => Js(n.baseId, t.value)), r = computed(() => t.value === n.modelValue.value);
    return (i, u) => (openBlock(), createBlock(unref(Ot), {
      "as-child": "",
      focusable: !i.disabled,
      active: r.value
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          id: l.value,
          ref: unref(e),
          role: "tab",
          type: i.as === "button" ? "button" : void 0,
          as: i.as,
          "as-child": i.asChild,
          "aria-selected": r.value ? "true" : "false",
          "aria-controls": s.value,
          "data-state": r.value ? "active" : "inactive",
          disabled: i.disabled,
          "data-disabled": i.disabled ? "" : void 0,
          "data-orientation": unref(n).orientation.value,
          onMousedown: u[0] || (u[0] = withModifiers((d) => {
            !i.disabled && d.ctrlKey === false ? unref(n).changeModelValue(i.value) : d.preventDefault();
          }, ["left"])),
          onKeydown: u[1] || (u[1] = withKeys((d) => unref(n).changeModelValue(i.value), ["enter", "space"])),
          onFocus: u[2] || (u[2] = () => {
            const d = unref(n).activationMode !== "manual";
            !r.value && !i.disabled && d && unref(n).changeModelValue(i.value);
          })
        }, {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 8, ["id", "type", "as", "as-child", "aria-selected", "aria-controls", "data-state", "disabled", "data-disabled", "data-orientation"])
      ]),
      _: 3
    }, 8, ["focusable", "active"]));
  }
});
var sg = defineComponent({
  __name: "TabsIndicator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = dn();
    R2();
    const n = ref(), l = ref({
      size: null,
      position: null
    });
    watch(() => e.modelValue.value, async (r) => {
      await nextTick(), s();
    }, { immediate: true }), Ze([e.tabsList, n], s);
    function s() {
      var r;
      n.value = (r = e.tabsList.value) == null ? void 0 : r.querySelector('[role="tab"][data-state="active"]'), n.value && (e.orientation.value === "horizontal" ? l.value = {
        size: n.value.offsetWidth,
        position: n.value.offsetLeft
      } : l.value = {
        size: n.value.offsetHeight,
        position: n.value.offsetTop
      });
    }
    return (r, i) => typeof l.value.size == "number" ? (openBlock(), createBlock(unref(A2), mergeProps({ key: 0 }, t, {
      style: {
        "--radix-tabs-indicator-size": `${l.value.size}px`,
        "--radix-tabs-indicator-position": `${l.value.position}px`
      }
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16, ["style"])) : createCommentVNode("", true);
  }
});
var [cn, $f] = Q("TagsInputRoot");
var rg = defineComponent({
  __name: "TagsInputRoot",
  props: {
    modelValue: {},
    defaultValue: { default: () => [] },
    addOnPaste: { type: Boolean },
    addOnTab: { type: Boolean },
    addOnBlur: { type: Boolean },
    duplicate: { type: Boolean },
    disabled: { type: Boolean },
    delimiter: { default: "," },
    dir: {},
    max: { default: 0 },
    required: { type: Boolean },
    name: {},
    id: {},
    convertValue: {},
    displayValue: { type: Function, default: (a2) => a2.toString() },
    asChild: { type: Boolean },
    as: {}
  },
  emits: ["update:modelValue", "invalid"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { addOnPaste: l, disabled: s, delimiter: r, max: i, id: u, dir: d, addOnBlur: p, addOnTab: c } = toRefs(e), f = Ce(d), v2 = ae(e, "modelValue", n, {
      defaultValue: e.defaultValue,
      passive: true,
      deep: true
    }), { forwardRef: g, currentElement: m2 } = R2(), { focused: S } = di(m2), x = Qe(m2), { getItems: D } = ga(), h2 = ref(), E = ref(false);
    return $f({
      modelValue: v2,
      onAddValue: (P2) => {
        const $2 = v2.value.length > 0 && typeof v2.value[0] == "object", I = v2.value.length > 0 && typeof e.defaultValue[0] == "object";
        if (($2 || I) && typeof e.convertValue != "function")
          throw new Error("You must provide a `convertValue` function when using objects as values.");
        const k = e.convertValue ? e.convertValue(P2) : P2;
        if (v2.value.length >= i.value && i.value)
          return n("invalid", k), false;
        if (e.duplicate)
          return v2.value.push(k), true;
        if (v2.value.includes(k))
          E.value = true;
        else
          return v2.value.push(k), true;
        return n("invalid", k), false;
      },
      onRemoveValue: (P2) => {
        P2 !== -1 && v2.value.splice(P2, 1);
      },
      onInputKeydown: (P2) => {
        const $2 = P2.target, I = D().map((L) => L.ref).filter((L) => L.dataset.disabled !== "");
        if (!I.length)
          return;
        const k = I.at(-1);
        switch (P2.key) {
          case "Delete":
          case "Backspace": {
            if ($2.selectionStart !== 0 || $2.selectionEnd !== 0)
              break;
            if (h2.value) {
              const L = I.findIndex((O) => O === h2.value);
              v2.value.splice(L, 1), h2.value = h2.value === k ? I.at(L - 1) : I.at(L + 1), P2.preventDefault();
            } else P2.key === "Backspace" && (h2.value = k, P2.preventDefault());
            break;
          }
          case "Home":
          case "End":
          case "ArrowRight":
          case "ArrowLeft": {
            const L = P2.key === "ArrowRight" && f.value === "ltr" || P2.key === "ArrowLeft" && f.value === "rtl", O = !L;
            if ($2.selectionStart !== 0 || $2.selectionEnd !== 0)
              break;
            if (O && !h2.value)
              h2.value = k, P2.preventDefault();
            else if (L && k && h2.value === k)
              h2.value = void 0, P2.preventDefault();
            else if (h2.value) {
              const V2 = $t(P2, h2.value, void 0, {
                itemsArray: I,
                loop: false,
                dir: f.value
              });
              V2 && (h2.value = V2), P2.preventDefault();
            }
            break;
          }
          case "ArrowUp":
          case "ArrowDown": {
            h2.value && P2.preventDefault();
            break;
          }
          default:
            h2.value = void 0;
        }
      },
      selectedElement: h2,
      isInvalidInput: E,
      addOnPaste: l,
      addOnBlur: p,
      addOnTab: c,
      dir: f,
      disabled: s,
      delimiter: r,
      max: i,
      id: u,
      displayValue: e.displayValue
    }), (P2, $2) => (openBlock(), createBlock(unref(ba), null, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(g),
          dir: unref(f),
          as: P2.as,
          "as-child": P2.asChild,
          "data-invalid": E.value ? "" : void 0,
          "data-disabled": unref(s) ? "" : void 0,
          "data-focused": unref(S) ? "" : void 0
        }, {
          default: withCtx(() => [
            renderSlot(P2.$slots, "default", { modelValue: unref(v2) }),
            unref(x) && P2.name ? (openBlock(), createBlock(unref(Qn), {
              key: 0,
              name: P2.name,
              value: unref(v2),
              required: P2.required,
              disabled: unref(s)
            }, null, 8, ["name", "value", "required", "disabled"])) : createCommentVNode("", true)
          ]),
          _: 3
        }, 8, ["dir", "as", "as-child", "data-invalid", "data-disabled", "data-focused"])
      ]),
      _: 3
    }));
  }
});
var ig = defineComponent({
  __name: "TagsInputInput",
  props: {
    placeholder: {},
    autoFocus: { type: Boolean },
    maxLength: {},
    asChild: { type: Boolean },
    as: { default: "input" }
  },
  setup(a2) {
    const t = a2, e = cn(), { forwardRef: n, currentElement: l } = R2();
    function s(p) {
      if (!e.addOnBlur.value)
        return;
      const c = p.target;
      if (!c.value)
        return;
      e.onAddValue(c.value) && (c.value = "");
    }
    function r(p) {
      e.addOnTab.value && i(p);
    }
    async function i(p) {
      if (await nextTick(), p.defaultPrevented)
        return;
      const c = p.target;
      if (!c.value)
        return;
      e.onAddValue(c.value) && (c.value = ""), p.preventDefault();
    }
    function u(p) {
      e.isInvalidInput.value = false;
      const c = e.delimiter.value;
      if (c === p.data) {
        const f = p.target;
        f.value = f.value.replaceAll(c, ""), e.onAddValue(f.value) && (f.value = "");
      }
    }
    function d(p) {
      if (e.addOnPaste.value) {
        p.preventDefault();
        const c = p.clipboardData;
        if (!c)
          return;
        const f = c.getData("text");
        e.delimiter.value ? f.split(e.delimiter.value).forEach((g) => {
          e.onAddValue(g);
        }) : e.onAddValue(f);
      }
    }
    return onMounted(() => {
      const p = l.value.nodeName === "INPUT" ? l.value : l.value.querySelector("input");
      p && setTimeout(() => {
        t.autoFocus && (p == null || p.focus());
      }, 1);
    }), (p, c) => {
      var f;
      return openBlock(), createBlock(unref(A2), {
        id: (f = unref(e).id) == null ? void 0 : f.value,
        ref: unref(n),
        type: "text",
        autocomplete: "off",
        autocorrect: "off",
        autocapitalize: "off",
        as: p.as,
        "as-child": p.asChild,
        maxlength: p.maxLength,
        placeholder: p.placeholder,
        disabled: unref(e).disabled.value,
        "data-invalid": unref(e).isInvalidInput.value ? "" : void 0,
        onInput: u,
        onKeydown: [
          withKeys(i, ["enter"]),
          withKeys(r, ["tab"]),
          unref(e).onInputKeydown
        ],
        onBlur: s,
        onPaste: d
      }, {
        default: withCtx(() => [
          renderSlot(p.$slots, "default")
        ]),
        _: 3
      }, 8, ["id", "as", "as-child", "maxlength", "placeholder", "disabled", "data-invalid", "onKeydown"]);
    };
  }
});
var [Qs, Bf] = Q("TagsInputItem");
var ug = defineComponent({
  __name: "TagsInputItem",
  props: {
    value: {},
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { value: e } = toRefs(t), n = cn(), { forwardRef: l, currentElement: s } = R2(), r = computed(() => n.selectedElement.value === s.value), i = computed(() => t.disabled || n.disabled.value), u = Bf({
      value: e,
      isSelected: r,
      disabled: i,
      textId: "",
      displayValue: computed(() => n.displayValue(e.value))
    });
    return (d, p) => (openBlock(), createBlock(unref(Xt), null, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(l),
          as: d.as,
          "as-child": d.asChild,
          "aria-labelledby": unref(u).textId,
          "aria-current": r.value,
          "data-disabled": i.value ? "" : void 0,
          "data-state": r.value ? "active" : "inactive"
        }, {
          default: withCtx(() => [
            renderSlot(d.$slots, "default")
          ]),
          _: 3
        }, 8, ["as", "as-child", "aria-labelledby", "aria-current", "data-disabled", "data-state"])
      ]),
      _: 3
    }));
  }
});
var dg = defineComponent({
  __name: "TagsInputItemText",
  props: {
    asChild: { type: Boolean },
    as: { default: "span" }
  },
  setup(a2) {
    const t = a2, e = Qs();
    return R2(), e.textId || (e.textId = me(void 0, "radix-vue-tags-input-item-text")), (n, l) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      id: unref(e).textId
    }), {
      default: withCtx(() => [
        renderSlot(n.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(unref(e).displayValue.value), 1)
        ])
      ]),
      _: 3
    }, 16, ["id"]));
  }
});
var cg = defineComponent({
  __name: "TagsInputItemDelete",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = cn(), n = Qs(), l = computed(() => {
      var r;
      return ((r = n.disabled) == null ? void 0 : r.value) || e.disabled.value;
    });
    function s() {
      if (l.value)
        return;
      const r = e.modelValue.value.findIndex((i) => i === n.value.value);
      e.onRemoveValue(r);
    }
    return (r, i) => (openBlock(), createBlock(unref(A2), mergeProps({ tabindex: "-1" }, t, {
      "aria-labelledby": unref(n).textId,
      "aria-current": unref(n).isSelected.value,
      "data-state": unref(n).isSelected.value ? "active" : "inactive",
      "data-disabled": l.value ? "" : void 0,
      type: r.as === "button" ? "button" : void 0,
      onClick: s
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-labelledby", "aria-current", "data-state", "data-disabled", "type"]));
  }
});
var pg = defineComponent({
  __name: "TagsInputClear",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2;
    R2();
    const e = cn();
    function n() {
      e.disabled.value || (e.modelValue.value = []);
    }
    return (l, s) => (openBlock(), createBlock(unref(A2), mergeProps(t, {
      type: l.as === "button" ? "button" : void 0,
      "data-disabled": unref(e).disabled.value ? "" : void 0,
      onClick: n
    }), {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }, 16, ["type", "data-disabled"]));
  }
});
var [pn, If] = Q("ToastProvider");
var fg = defineComponent({
  __name: "ToastProvider",
  props: {
    label: { default: "Notification" },
    duration: { default: 5e3 },
    swipeDirection: { default: "right" },
    swipeThreshold: { default: 50 }
  },
  setup(a2) {
    const t = a2, { label: e, duration: n, swipeDirection: l, swipeThreshold: s } = toRefs(t), r = ref(), i = ref(0), u = ref(false), d = ref(false);
    if (t.label && typeof t.label == "string" && !t.label.trim()) {
      const p = "Invalid prop `label` supplied to `ToastProvider`. Expected non-empty `string`.";
      throw new Error(p);
    }
    return If({
      label: e,
      duration: n,
      swipeDirection: l,
      swipeThreshold: s,
      toastCount: i,
      viewport: r,
      onViewportChange(p) {
        r.value = p;
      },
      onToastAdd() {
        i.value++;
      },
      onToastRemove() {
        i.value--;
      },
      isFocusedToastEscapeKeyDownRef: u,
      isClosePausedRef: d
    }), (p, c) => renderSlot(p.$slots, "default");
  }
});
var Tf = "toast.swipeStart";
var Rf = "toast.swipeMove";
var Af = "toast.swipeCancel";
var Of = "toast.swipeEnd";
var Rn = "toast.viewportPause";
var An = "toast.viewportResume";
function Ra(a2, t, e) {
  const n = e.originalEvent.currentTarget, l = new CustomEvent(a2, {
    bubbles: false,
    cancelable: true,
    detail: e
  });
  t && n.addEventListener(a2, t, { once: true }), n.dispatchEvent(l);
}
function el(a2, t, e = 0) {
  const n = Math.abs(a2.x), l = Math.abs(a2.y), s = n > l;
  return t === "left" || t === "right" ? s && n > e : !s && l > e;
}
function kf(a2) {
  return a2.nodeType === a2.ELEMENT_NODE;
}
function er(a2) {
  const t = [];
  return Array.from(a2.childNodes).forEach((n) => {
    if (n.nodeType === n.TEXT_NODE && n.textContent && t.push(n.textContent), kf(n)) {
      const l = n.ariaHidden || n.hidden || n.style.display === "none", s = n.dataset.radixToastAnnounceExclude === "";
      if (!l)
        if (s) {
          const r = n.dataset.radixToastAnnounceAlt;
          r && t.push(r);
        } else
          t.push(...er(n));
    }
  }), t;
}
var Mf = defineComponent({
  __name: "ToastAnnounce",
  setup(a2) {
    const t = pn(), e = oi(1e3), n = ref(false);
    return El(() => {
      n.value = true;
    }), (l, s) => unref(e) || n.value ? (openBlock(), createBlock(unref(Yt), { key: 0 }, {
      default: withCtx(() => [
        createTextVNode(toDisplayString(unref(t).label.value) + " ", 1),
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    })) : createCommentVNode("", true);
  }
});
var [Vf, Ff] = Q("ToastRoot");
var Lf = defineComponent({
  inheritAttrs: false,
  __name: "ToastRootImpl",
  props: {
    type: {},
    open: { type: Boolean, default: false },
    duration: {},
    asChild: { type: Boolean },
    as: { default: "li" }
  },
  emits: ["close", "escapeKeyDown", "pause", "resume", "swipeStart", "swipeMove", "swipeCancel", "swipeEnd"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l, currentElement: s } = R2(), r = pn(), i = ref(null), u = ref(null), d = computed(() => e.duration || r.duration.value), p = ref(0), c = ref(d.value), f = ref(0), v2 = ref(d.value), g = El(() => {
      const D = (/* @__PURE__ */ new Date()).getTime() - p.value;
      v2.value = Math.max(c.value - D, 0);
    }, { fpsLimit: 60 });
    function m2(D) {
      !D || D === Number.POSITIVE_INFINITY || (window.clearTimeout(f.value), p.value = (/* @__PURE__ */ new Date()).getTime(), f.value = window.setTimeout(S, D));
    }
    function S() {
      var h2, E;
      ((h2 = s.value) == null ? void 0 : h2.contains(document.activeElement)) && ((E = r.viewport.value) == null || E.focus()), r.isClosePausedRef.value = false, n("close");
    }
    const x = computed(() => s.value ? er(s.value) : null);
    if (e.type && !["foreground", "background"].includes(e.type)) {
      const D = "Invalid prop `type` supplied to `Toast`. Expected `foreground | background`.";
      throw new Error(D);
    }
    return watchEffect((D) => {
      const h2 = r.viewport.value;
      if (h2) {
        const E = () => {
          m2(c.value), g.resume(), n("resume");
        }, P2 = () => {
          const $2 = (/* @__PURE__ */ new Date()).getTime() - p.value;
          c.value = c.value - $2, window.clearTimeout(f.value), g.pause(), n("pause");
        };
        return h2.addEventListener(Rn, P2), h2.addEventListener(An, E), () => {
          h2.removeEventListener(Rn, P2), h2.removeEventListener(An, E);
        };
      }
    }), watch(() => [e.open, d.value], () => {
      c.value = d.value, e.open && !r.isClosePausedRef.value && m2(d.value);
    }, { immediate: true }), Hn("Escape", (D) => {
      n("escapeKeyDown", D), D.defaultPrevented || (r.isFocusedToastEscapeKeyDownRef.value = true, S());
    }), onMounted(() => {
      r.onToastAdd();
    }), onUnmounted(() => {
      r.onToastRemove();
    }), Ff({ onClose: S }), (D, h2) => (openBlock(), createElementBlock(Fragment, null, [
      x.value ? (openBlock(), createBlock(Mf, {
        key: 0,
        role: "status",
        "aria-live": D.type === "foreground" ? "assertive" : "polite",
        "aria-atomic": ""
      }, {
        default: withCtx(() => [
          createTextVNode(toDisplayString(x.value), 1)
        ]),
        _: 1
      }, 8, ["aria-live"])) : createCommentVNode("", true),
      (openBlock(), createBlock(Teleport, {
        to: unref(r).viewport.value
      }, [
        createVNode(unref(A2), mergeProps({
          ref: unref(l),
          role: "status",
          "aria-live": "off",
          "aria-atomic": "",
          tabindex: "0",
          "data-radix-vue-collection-item": ""
        }, D.$attrs, {
          as: D.as,
          "as-child": D.asChild,
          "data-state": D.open ? "open" : "closed",
          "data-swipe-direction": unref(r).swipeDirection.value,
          style: { userSelect: "none", touchAction: "none" },
          onPointerdown: h2[0] || (h2[0] = withModifiers((E) => {
            i.value = { x: E.clientX, y: E.clientY };
          }, ["left"])),
          onPointermove: h2[1] || (h2[1] = (E) => {
            if (!i.value) return;
            const P2 = E.clientX - i.value.x, $2 = E.clientY - i.value.y, I = !!u.value, k = ["left", "right"].includes(unref(r).swipeDirection.value), L = ["left", "up"].includes(unref(r).swipeDirection.value) ? Math.min : Math.max, O = k ? L(0, P2) : 0, V2 = k ? 0 : L(0, $2), H2 = E.pointerType === "touch" ? 10 : 2, Y = { x: O, y: V2 }, J2 = { originalEvent: E, delta: Y };
            I ? (u.value = Y, unref(Ra)(unref(Rf), (N2) => n("swipeMove", N2), J2)) : unref(el)(Y, unref(r).swipeDirection.value, H2) ? (u.value = Y, unref(Ra)(unref(Tf), (N2) => n("swipeStart", N2), J2), E.target.setPointerCapture(E.pointerId)) : (Math.abs(P2) > H2 || Math.abs($2) > H2) && (i.value = null);
          }),
          onPointerup: h2[2] || (h2[2] = (E) => {
            const P2 = u.value, $2 = E.target;
            if ($2.hasPointerCapture(E.pointerId) && $2.releasePointerCapture(E.pointerId), u.value = null, i.value = null, P2) {
              const I = E.currentTarget, k = { originalEvent: E, delta: P2 };
              unref(el)(P2, unref(r).swipeDirection.value, unref(r).swipeThreshold.value) ? unref(Ra)(unref(Of), (L) => n("swipeEnd", L), k) : unref(Ra)(unref(Af), (L) => n("swipeCancel", L), k), I == null || I.addEventListener("click", (L) => L.preventDefault(), {
                once: true
              });
            }
          })
        }), {
          default: withCtx(() => [
            renderSlot(D.$slots, "default", {
              remaining: v2.value,
              duration: d.value
            })
          ]),
          _: 3
        }, 16, ["as", "as-child", "data-state", "data-swipe-direction"])
      ], 8, ["to"]))
    ], 64));
  }
});
var vg = defineComponent({
  __name: "ToastRoot",
  props: {
    defaultOpen: { type: Boolean, default: true },
    forceMount: { type: Boolean },
    type: { default: "foreground" },
    open: { type: Boolean, default: void 0 },
    duration: {},
    asChild: { type: Boolean },
    as: { default: "li" }
  },
  emits: ["escapeKeyDown", "pause", "resume", "swipeStart", "swipeMove", "swipeCancel", "swipeEnd", "update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { forwardRef: l } = R2(), s = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    });
    return (r, i) => (openBlock(), createBlock(unref(Pe), {
      present: r.forceMount || unref(s)
    }, {
      default: withCtx(() => [
        createVNode(Lf, mergeProps({
          ref: unref(l),
          open: unref(s),
          type: r.type,
          as: r.as,
          "as-child": r.asChild,
          duration: r.duration
        }, r.$attrs, {
          onClose: i[0] || (i[0] = (u) => s.value = false),
          onPause: i[1] || (i[1] = (u) => n("pause")),
          onResume: i[2] || (i[2] = (u) => n("resume")),
          onEscapeKeyDown: i[3] || (i[3] = (u) => n("escapeKeyDown", u)),
          onSwipeStart: i[4] || (i[4] = (u) => {
            n("swipeStart", u), u.currentTarget.setAttribute("data-swipe", "start");
          }),
          onSwipeMove: i[5] || (i[5] = (u) => {
            const { x: d, y: p } = u.detail.delta, c = u.currentTarget;
            c.setAttribute("data-swipe", "move"), c.style.setProperty("--radix-toast-swipe-move-x", `${d}px`), c.style.setProperty("--radix-toast-swipe-move-y", `${p}px`);
          }),
          onSwipeCancel: i[6] || (i[6] = (u) => {
            const d = u.currentTarget;
            d.setAttribute("data-swipe", "cancel"), d.style.removeProperty("--radix-toast-swipe-move-x"), d.style.removeProperty("--radix-toast-swipe-move-y"), d.style.removeProperty("--radix-toast-swipe-end-x"), d.style.removeProperty("--radix-toast-swipe-end-y");
          }),
          onSwipeEnd: i[7] || (i[7] = (u) => {
            const { x: d, y: p } = u.detail.delta, c = u.currentTarget;
            c.setAttribute("data-swipe", "end"), c.style.removeProperty("--radix-toast-swipe-move-x"), c.style.removeProperty("--radix-toast-swipe-move-y"), c.style.setProperty("--radix-toast-swipe-end-x", `${d}px`), c.style.setProperty("--radix-toast-swipe-end-y", `${p}px`), s.value = false;
          })
        }), {
          default: withCtx(({ remaining: u, duration: d }) => [
            renderSlot(r.$slots, "default", {
              remaining: u,
              duration: d,
              open: unref(s)
            })
          ]),
          _: 3
        }, 16, ["open", "type", "as", "as-child", "duration"])
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var tr = defineComponent({
  __name: "ToastAnnounceExclude",
  props: {
    altText: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    return (t, e) => (openBlock(), createBlock(unref(A2), {
      as: t.as,
      "as-child": t.asChild,
      "data-radix-toast-announce-exclude": "",
      "data-radix-toast-announce-alt": t.altText || void 0
    }, {
      default: withCtx(() => [
        renderSlot(t.$slots, "default")
      ]),
      _: 3
    }, 8, ["as", "as-child", "data-radix-toast-announce-alt"]));
  }
});
var Nf = defineComponent({
  __name: "ToastClose",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Vf(), { forwardRef: n } = R2();
    return (l, s) => (openBlock(), createBlock(tr, { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps(t, {
          ref: unref(n),
          type: l.as === "button" ? "button" : void 0,
          onClick: s[0] || (s[0] = (r) => unref(e).onClose())
        }), {
          default: withCtx(() => [
            renderSlot(l.$slots, "default")
          ]),
          _: 3
        }, 16, ["type"])
      ]),
      _: 3
    }));
  }
});
var mg = defineComponent({
  __name: "ToastAction",
  props: {
    altText: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    if (!a2.altText)
      throw new Error("Missing prop `altText` expected on `ToastAction`");
    const { forwardRef: e } = R2();
    return (n, l) => n.altText ? (openBlock(), createBlock(tr, {
      key: 0,
      "alt-text": n.altText,
      "as-child": ""
    }, {
      default: withCtx(() => [
        createVNode(Nf, {
          ref: unref(e),
          as: n.as,
          "as-child": n.asChild
        }, {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 8, ["as", "as-child"])
      ]),
      _: 3
    }, 8, ["alt-text"])) : createCommentVNode("", true);
  }
});
var tl = defineComponent({
  __name: "FocusProxy",
  emits: ["focusFromOutsideViewport"],
  setup(a2, { emit: t }) {
    const e = t, n = pn();
    return (l, s) => (openBlock(), createBlock(unref(Yt), {
      "aria-hidden": "",
      tabindex: "0",
      style: { position: "fixed" },
      onFocus: s[0] || (s[0] = (r) => {
        var d;
        const i = r.relatedTarget;
        !((d = unref(n).viewport.value) != null && d.contains(i)) && e("focusFromOutsideViewport");
      })
    }, {
      default: withCtx(() => [
        renderSlot(l.$slots, "default")
      ]),
      _: 3
    }));
  }
});
var hg = defineComponent({
  inheritAttrs: false,
  __name: "ToastViewport",
  props: {
    hotkey: { default: () => ["F8"] },
    label: { type: [String, Function], default: "Notifications ({hotkey})" },
    asChild: { type: Boolean },
    as: { default: "ol" }
  },
  setup(a2) {
    const t = a2, { hotkey: e, label: n } = toRefs(t), { forwardRef: l, currentElement: s } = R2(), { createCollection: r } = Me(), i = r(s), u = pn(), d = computed(() => u.toastCount.value > 0), p = ref(), c = ref(), f = computed(() => e.value.join("+").replace(/Key/g, "").replace(/Digit/g, ""));
    Hn(e.value, () => {
      s.value.focus();
    }), onMounted(() => {
      u.onViewportChange(s.value);
    }), watchEffect((g) => {
      const m2 = s.value;
      if (d.value && m2) {
        const S = () => {
          if (!u.isClosePausedRef.value) {
            const P2 = new CustomEvent(Rn);
            m2.dispatchEvent(P2), u.isClosePausedRef.value = true;
          }
        }, x = () => {
          if (u.isClosePausedRef.value) {
            const P2 = new CustomEvent(An);
            m2.dispatchEvent(P2), u.isClosePausedRef.value = false;
          }
        }, D = (P2) => {
          !m2.contains(P2.relatedTarget) && x();
        }, h2 = () => {
          m2.contains(document.activeElement) || x();
        }, E = (P2) => {
          var k, L, O;
          const $2 = P2.altKey || P2.ctrlKey || P2.metaKey;
          if (P2.key === "Tab" && !$2) {
            const V2 = document.activeElement, H2 = P2.shiftKey;
            if (P2.target === m2 && H2) {
              (k = p.value) == null || k.focus();
              return;
            }
            const N2 = v2({ tabbingDirection: H2 ? "backwards" : "forwards" }), F = N2.findIndex((W2) => W2 === V2);
            Aa(N2.slice(F + 1)) ? P2.preventDefault() : H2 ? (L = p.value) == null || L.focus() : (O = c.value) == null || O.focus();
          }
        };
        m2.addEventListener("focusin", S), m2.addEventListener("focusout", D), m2.addEventListener("pointermove", S), m2.addEventListener("pointerleave", h2), m2.addEventListener("keydown", E), window.addEventListener("blur", S), window.addEventListener("focus", x), g(() => {
          m2.removeEventListener("focusin", S), m2.removeEventListener("focusout", D), m2.removeEventListener("pointermove", S), m2.removeEventListener("pointerleave", h2), m2.removeEventListener("keydown", E), window.removeEventListener("blur", S), window.removeEventListener("focus", x);
        });
      }
    });
    function v2({ tabbingDirection: g }) {
      const S = i.value.map((x) => {
        const D = [x, ...Xn(x)];
        return g === "forwards" ? D : D.reverse();
      });
      return (g === "forwards" ? S.reverse() : S).flat();
    }
    return (g, m2) => (openBlock(), createBlock(unref(ji), {
      role: "region",
      "aria-label": typeof unref(n) == "string" ? unref(n).replace("{hotkey}", f.value) : unref(n)(f.value),
      tabindex: "-1",
      style: normalizeStyle({
        // incase list has size when empty (e.g. padding), we remove pointer events so
        // it doesn't prevent interactions with page elements that it overlays
        pointerEvents: d.value ? void 0 : "none"
      })
    }, {
      default: withCtx(() => [
        d.value ? (openBlock(), createBlock(tl, {
          key: 0,
          ref: (S) => {
            p.value = unref(Be)(S);
          },
          onFocusFromOutsideViewport: m2[0] || (m2[0] = () => {
            const S = v2({
              tabbingDirection: "forwards"
            });
            unref(Aa)(S);
          })
        }, null, 512)) : createCommentVNode("", true),
        createVNode(unref(A2), mergeProps({
          ref: unref(l),
          tabindex: "-1",
          as: g.as,
          "as-child": g.asChild
        }, g.$attrs), {
          default: withCtx(() => [
            renderSlot(g.$slots, "default")
          ]),
          _: 3
        }, 16, ["as", "as-child"]),
        d.value ? (openBlock(), createBlock(tl, {
          key: 1,
          ref: (S) => {
            c.value = unref(Be)(S);
          },
          onFocusFromOutsideViewport: m2[1] || (m2[1] = () => {
            const S = v2({
              tabbingDirection: "backwards"
            });
            unref(Aa)(S);
          })
        }, null, 512)) : createCommentVNode("", true)
      ]),
      _: 3
    }, 8, ["aria-label", "style"]));
  }
});
var yg = defineComponent({
  __name: "ToastTitle",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var gg = defineComponent({
  __name: "ToastDescription",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(A2), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var zf = defineComponent({
  __name: "Toggle",
  props: {
    defaultValue: { type: Boolean },
    pressed: { type: Boolean, default: void 0 },
    disabled: { type: Boolean, default: false },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  emits: ["update:pressed"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    const l = ae(e, "pressed", n, {
      defaultValue: e.defaultValue,
      passive: e.pressed === void 0
    });
    function s() {
      l.value = !l.value;
    }
    const r = computed(() => l.value ? "on" : "off");
    return (i, u) => (openBlock(), createBlock(unref(A2), {
      type: i.as === "button" ? "button" : void 0,
      "as-child": e.asChild,
      as: i.as,
      "aria-pressed": unref(l),
      "data-state": r.value,
      "data-disabled": i.disabled ? "" : void 0,
      disabled: i.disabled,
      onClick: s
    }, {
      default: withCtx(() => [
        renderSlot(i.$slots, "default", { pressed: unref(l) })
      ]),
      _: 3
    }, 8, ["type", "as-child", "as", "aria-pressed", "data-state", "data-disabled", "disabled"]));
  }
});
var [Kf, Hf] = Q("ToggleGroupRoot");
var Wf = defineComponent({
  __name: "ToggleGroupRoot",
  props: {
    rovingFocus: { type: Boolean, default: true },
    disabled: { type: Boolean, default: false },
    orientation: {},
    dir: {},
    loop: { type: Boolean, default: true },
    asChild: { type: Boolean },
    as: {},
    type: {},
    modelValue: {},
    defaultValue: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { loop: l, rovingFocus: s, disabled: r, dir: i } = toRefs(e), u = Ce(i), { forwardRef: d } = R2(), { modelValue: p, changeModelValue: c, isSingle: f } = Ol(e, n);
    return Hf({
      isSingle: f,
      modelValue: p,
      changeModelValue: c,
      dir: u,
      orientation: e.orientation,
      loop: l,
      rovingFocus: s,
      disabled: r
    }), (v2, g) => (openBlock(), createBlock(resolveDynamicComponent(unref(s) ? unref(At) : unref(A2)), {
      "as-child": "",
      orientation: unref(s) ? v2.orientation : void 0,
      dir: unref(u),
      loop: unref(s) ? unref(l) : void 0
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(d),
          role: "group",
          "as-child": v2.asChild,
          as: v2.as
        }, {
          default: withCtx(() => [
            renderSlot(v2.$slots, "default", { modelValue: unref(p) })
          ]),
          _: 3
        }, 8, ["as-child", "as"])
      ]),
      _: 3
    }, 8, ["orientation", "dir", "loop"]));
  }
});
var jf = defineComponent({
  __name: "ToggleGroupItem",
  props: {
    value: {},
    defaultValue: { type: Boolean },
    pressed: { type: Boolean },
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = Kf(), n = computed(() => {
      var i;
      return ((i = e.disabled) == null ? void 0 : i.value) || t.disabled;
    }), l = computed(() => {
      var i;
      return (i = e.modelValue.value) == null ? void 0 : i.includes(t.value);
    }), s = computed(() => {
      var i;
      return e.isSingle.value ? e.modelValue.value === t.value : (i = e.modelValue.value) == null ? void 0 : i.includes(t.value);
    }), { forwardRef: r } = R2();
    return (i, u) => (openBlock(), createBlock(resolveDynamicComponent(unref(e).rovingFocus.value ? unref(Ot) : unref(A2)), {
      "as-child": "",
      focusable: !n.value,
      active: l.value
    }, {
      default: withCtx(() => [
        createVNode(unref(zf), mergeProps(t, {
          ref: unref(r),
          disabled: n.value,
          pressed: s.value,
          "onUpdate:pressed": u[0] || (u[0] = (d) => unref(e).changeModelValue(i.value))
        }), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16, ["disabled", "pressed"])
      ]),
      _: 3
    }, 8, ["focusable", "active"]));
  }
});
var [ar, Uf] = Q("ToolbarRoot");
var bg = defineComponent({
  __name: "ToolbarRoot",
  props: {
    orientation: { default: "horizontal" },
    dir: {},
    loop: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { orientation: e, dir: n } = toRefs(t), l = Ce(n), { forwardRef: s } = R2();
    return Uf({ orientation: e, dir: l }), (r, i) => (openBlock(), createBlock(unref(At), {
      "as-child": "",
      orientation: unref(e),
      dir: unref(l),
      loop: r.loop
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          ref: unref(s),
          role: "toolbar",
          "aria-orientation": unref(e),
          "as-child": r.asChild,
          as: r.as
        }, {
          default: withCtx(() => [
            renderSlot(r.$slots, "default")
          ]),
          _: 3
        }, 8, ["aria-orientation", "as-child", "as"])
      ]),
      _: 3
    }, 8, ["orientation", "dir", "loop"]));
  }
});
var Gf = defineComponent({
  __name: "ToolbarButton",
  props: {
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2();
    return (n, l) => (openBlock(), createBlock(unref(Ot), {
      "as-child": "",
      focusable: !n.disabled
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(e),
          type: n.as === "button" ? "button" : void 0
        }, t), {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 16, ["type"])
      ]),
      _: 3
    }, 8, ["focusable"]));
  }
});
var Cg = defineComponent({
  __name: "ToolbarLink",
  props: {
    asChild: { type: Boolean },
    as: { default: "a" }
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2();
    return (n, l) => (openBlock(), createBlock(unref(Ot), {
      "as-child": "",
      focusable: ""
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps(t, {
          ref: unref(e),
          onKeydown: l[0] || (l[0] = (s) => {
            var r;
            s.key === " " && ((r = s.currentTarget) == null || r.click());
          })
        }), {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }));
  }
});
var wg = defineComponent({
  __name: "ToolbarToggleGroup",
  props: {
    rovingFocus: { type: Boolean },
    disabled: { type: Boolean },
    orientation: {},
    dir: {},
    loop: { type: Boolean },
    asChild: { type: Boolean },
    as: {},
    type: {},
    modelValue: {},
    defaultValue: {}
  },
  emits: ["update:modelValue"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = ar(), s = Te(n);
    return R2(), (r, i) => (openBlock(), createBlock(unref(Wf), mergeProps({ ...e, ...unref(s) }, {
      "data-orientation": unref(l).orientation.value,
      dir: unref(l).dir.value,
      "roving-focus": false
    }), {
      default: withCtx(() => [
        renderSlot(r.$slots, "default")
      ]),
      _: 3
    }, 16, ["data-orientation", "dir"]));
  }
});
var _g = defineComponent({
  __name: "ToolbarToggleItem",
  props: {
    value: {},
    defaultValue: { type: Boolean },
    pressed: { type: Boolean },
    disabled: { type: Boolean },
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2();
    return (n, l) => (openBlock(), createBlock(Gf, { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(jf), mergeProps(t, { ref: unref(e) }), {
          default: withCtx(() => [
            renderSlot(n.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    }));
  }
});
var xg = defineComponent({
  __name: "ToolbarSeparator",
  props: {
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, e = ar();
    return R2(), (n, l) => (openBlock(), createBlock(Ps, {
      orientation: unref(e).orientation.value,
      "as-child": t.asChild,
      as: n.as
    }, {
      default: withCtx(() => [
        renderSlot(n.$slots, "default")
      ]),
      _: 3
    }, 8, ["orientation", "as-child", "as"]));
  }
});
var nr = "tooltip.open";
var [Ro, qf] = Q("TooltipProvider");
var Sg = defineComponent({
  __name: "TooltipProvider",
  props: {
    delayDuration: { default: 700 },
    skipDelayDuration: { default: 300 },
    disableHoverableContent: { type: Boolean, default: false },
    disableClosingTrigger: { type: Boolean },
    disabled: { type: Boolean },
    ignoreNonKeyboardFocus: { type: Boolean, default: false }
  },
  setup(a2) {
    const t = a2, { delayDuration: e, skipDelayDuration: n, disableHoverableContent: l, disableClosingTrigger: s, ignoreNonKeyboardFocus: r, disabled: i } = toRefs(t);
    R2();
    const u = ref(true), d = ref(false), { start: p, stop: c } = Kn(() => {
      u.value = true;
    }, n, { immediate: false });
    return qf({
      isOpenDelayed: u,
      delayDuration: e,
      onOpen() {
        c(), u.value = false;
      },
      onClose() {
        p();
      },
      isPointerInTransitRef: d,
      disableHoverableContent: l,
      disableClosingTrigger: s,
      disabled: i,
      ignoreNonKeyboardFocus: r
    }), (f, v2) => renderSlot(f.$slots, "default");
  }
});
var [fn, Yf] = Q("TooltipRoot");
var Eg = defineComponent({
  __name: "TooltipRoot",
  props: {
    defaultOpen: { type: Boolean, default: false },
    open: { type: Boolean, default: void 0 },
    delayDuration: { default: void 0 },
    disableHoverableContent: { type: Boolean, default: void 0 },
    disableClosingTrigger: { type: Boolean, default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    ignoreNonKeyboardFocus: { type: Boolean, default: void 0 }
  },
  emits: ["update:open"],
  setup(a2, { emit: t }) {
    const e = a2, n = t;
    R2();
    const l = Ro(), s = computed(() => e.disableHoverableContent ?? l.disableHoverableContent.value), r = computed(() => e.disableClosingTrigger ?? l.disableClosingTrigger.value), i = computed(() => e.disabled ?? l.disabled.value), u = computed(() => e.delayDuration ?? l.delayDuration.value), d = computed(() => e.ignoreNonKeyboardFocus ?? l.ignoreNonKeyboardFocus.value), p = ae(e, "open", n, {
      defaultValue: e.defaultOpen,
      passive: e.open === void 0
    });
    watch(p, (h2) => {
      l.onClose && (h2 ? (l.onOpen(), document.dispatchEvent(new CustomEvent(nr))) : l.onClose());
    });
    const c = ref(false), f = ref(), v2 = computed(() => p.value ? c.value ? "delayed-open" : "instant-open" : "closed"), { start: g, stop: m2 } = Kn(() => {
      c.value = true, p.value = true;
    }, u, { immediate: false });
    function S() {
      m2(), c.value = false, p.value = true;
    }
    function x() {
      m2(), p.value = false;
    }
    function D() {
      g();
    }
    return Yf({
      contentId: "",
      open: p,
      stateAttribute: v2,
      trigger: f,
      onTriggerChange(h2) {
        f.value = h2;
      },
      onTriggerEnter() {
        l.isOpenDelayed.value ? D() : S();
      },
      onTriggerLeave() {
        s.value ? x() : m2();
      },
      onOpen: S,
      onClose: x,
      disableHoverableContent: s,
      disableClosingTrigger: r,
      disabled: i,
      ignoreNonKeyboardFocus: d
    }), (h2, E) => (openBlock(), createBlock(unref(It), null, {
      default: withCtx(() => [
        renderSlot(h2.$slots, "default", { open: unref(p) })
      ]),
      _: 3
    }));
  }
});
var Pg = defineComponent({
  __name: "TooltipTrigger",
  props: {
    asChild: { type: Boolean },
    as: { default: "button" }
  },
  setup(a2) {
    const t = a2, e = fn(), n = Ro();
    e.contentId || (e.contentId = me(void 0, "radix-vue-tooltip-content"));
    const { forwardRef: l, currentElement: s } = R2(), r = ref(false), i = ref(false), u = computed(() => e.disabled.value ? {} : {
      click: m2,
      focus: v2,
      pointermove: c,
      pointerleave: f,
      pointerdown: p,
      blur: g
    });
    onMounted(() => {
      e.onTriggerChange(s.value);
    });
    function d() {
      r.value = false;
    }
    function p() {
      r.value = true, document.addEventListener("pointerup", d, { once: true });
    }
    function c(S) {
      S.pointerType !== "touch" && !i.value && !n.isPointerInTransitRef.value && (e.onTriggerEnter(), i.value = true);
    }
    function f() {
      e.onTriggerLeave(), i.value = false;
    }
    function v2(S) {
      var x, D;
      r.value || e.ignoreNonKeyboardFocus.value && !((D = (x = S.target).matches) != null && D.call(x, ":focus-visible")) || e.onOpen();
    }
    function g() {
      e.onClose();
    }
    function m2() {
      e.disableClosingTrigger.value || e.onClose();
    }
    return (S, x) => (openBlock(), createBlock(unref(Tt), { "as-child": "" }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps({
          ref: unref(l),
          "aria-describedby": unref(e).open.value ? unref(e).contentId : void 0,
          "data-state": unref(e).stateAttribute.value,
          as: S.as,
          "as-child": t.asChild,
          "data-grace-area-trigger": ""
        }, toHandlers(u.value)), {
          default: withCtx(() => [
            renderSlot(S.$slots, "default")
          ]),
          _: 3
        }, 16, ["aria-describedby", "data-state", "as", "as-child"])
      ]),
      _: 3
    }));
  }
});
var or = defineComponent({
  __name: "TooltipContentImpl",
  props: {
    ariaLabel: {},
    asChild: { type: Boolean },
    as: {},
    side: { default: "top" },
    sideOffset: { default: 0 },
    align: { default: "center" },
    alignOffset: {},
    avoidCollisions: { type: Boolean, default: true },
    collisionBoundary: { default: () => [] },
    collisionPadding: { default: 0 },
    arrowPadding: { default: 0 },
    sticky: { default: "partial" },
    hideWhenDetached: { type: Boolean, default: false }
  },
  emits: ["escapeKeyDown", "pointerDownOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = fn(), { forwardRef: s } = R2(), r = useSlots(), i = computed(() => {
      var p;
      return (p = r.default) == null ? void 0 : p.call(r);
    }), u = computed(() => {
      var f;
      if (e.ariaLabel)
        return e.ariaLabel;
      let p = "";
      function c(v2) {
        typeof v2.children == "string" ? p += v2.children : Array.isArray(v2.children) && v2.children.forEach((g) => c(g));
      }
      return (f = i.value) == null || f.forEach((v2) => c(v2)), p;
    }), d = computed(() => {
      const { ariaLabel: p, ...c } = e;
      return c;
    });
    return onMounted(() => {
      je(window, "scroll", (p) => {
        const c = p.target;
        c != null && c.contains(l.trigger.value) && l.onClose();
      }), je(window, nr, l.onClose);
    }), (p, c) => (openBlock(), createBlock(unref(yt), {
      "as-child": "",
      "disable-outside-pointer-events": false,
      onEscapeKeyDown: c[0] || (c[0] = (f) => n("escapeKeyDown", f)),
      onPointerDownOutside: c[1] || (c[1] = (f) => {
        var v2;
        unref(l).disableClosingTrigger.value && ((v2 = unref(l).trigger.value) != null && v2.contains(f.target)) && f.preventDefault(), n("pointerDownOutside", f);
      }),
      onFocusOutside: c[2] || (c[2] = withModifiers(() => {
      }, ["prevent"])),
      onDismiss: c[3] || (c[3] = (f) => unref(l).onClose())
    }, {
      default: withCtx(() => [
        createVNode(unref(Pt), mergeProps({
          ref: unref(s),
          "data-state": unref(l).stateAttribute.value
        }, { ...p.$attrs, ...d.value }, { style: {
          "--radix-tooltip-content-transform-origin": "var(--radix-popper-transform-origin)",
          "--radix-tooltip-content-available-width": "var(--radix-popper-available-width)",
          "--radix-tooltip-content-available-height": "var(--radix-popper-available-height)",
          "--radix-tooltip-trigger-width": "var(--radix-popper-anchor-width)",
          "--radix-tooltip-trigger-height": "var(--radix-popper-anchor-height)"
        } }), {
          default: withCtx(() => [
            renderSlot(p.$slots, "default"),
            createVNode(unref(Yt), {
              id: unref(l).contentId,
              role: "tooltip"
            }, {
              default: withCtx(() => [
                createTextVNode(toDisplayString(u.value), 1)
              ]),
              _: 1
            }, 8, ["id"])
          ]),
          _: 3
        }, 16, ["data-state"])
      ]),
      _: 3
    }));
  }
});
var Xf = defineComponent({
  __name: "TooltipContentHoverable",
  props: {
    ariaLabel: {},
    asChild: { type: Boolean },
    as: {},
    side: {},
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean }
  },
  setup(a2) {
    const e = Bt(a2), { forwardRef: n, currentElement: l } = R2(), { trigger: s, onClose: r } = fn(), i = Ro(), { isPointerInTransit: u, onPointerExit: d } = $l(s, l);
    return i.isPointerInTransitRef = u, d(() => {
      r();
    }), (p, c) => (openBlock(), createBlock(or, mergeProps({ ref: unref(n) }, unref(e)), {
      default: withCtx(() => [
        renderSlot(p.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Dg = defineComponent({
  __name: "TooltipContent",
  props: {
    forceMount: { type: Boolean },
    ariaLabel: {},
    asChild: { type: Boolean },
    as: {},
    side: { default: "top" },
    sideOffset: {},
    align: {},
    alignOffset: {},
    avoidCollisions: { type: Boolean },
    collisionBoundary: {},
    collisionPadding: {},
    arrowPadding: {},
    sticky: {},
    hideWhenDetached: { type: Boolean }
  },
  emits: ["escapeKeyDown", "pointerDownOutside"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, l = fn(), s = xe(e, n), { forwardRef: r } = R2();
    return (i, u) => (openBlock(), createBlock(unref(Pe), {
      present: i.forceMount || unref(l).open.value
    }, {
      default: withCtx(() => [
        (openBlock(), createBlock(resolveDynamicComponent(unref(l).disableHoverableContent.value ? or : Xf), mergeProps({ ref: unref(r) }, unref(s)), {
          default: withCtx(() => [
            renderSlot(i.$slots, "default")
          ]),
          _: 3
        }, 16))
      ]),
      _: 3
    }, 8, ["present"]));
  }
});
var $g = defineComponent({
  __name: "TooltipArrow",
  props: {
    width: { default: 10 },
    height: { default: 5 },
    asChild: { type: Boolean },
    as: { default: "svg" }
  },
  setup(a2) {
    const t = a2;
    return R2(), (e, n) => (openBlock(), createBlock(unref(qt), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
var Bg = defineComponent({
  __name: "TooltipPortal",
  props: {
    to: {},
    disabled: { type: Boolean },
    forceMount: { type: Boolean }
  },
  setup(a2) {
    const t = a2;
    return (e, n) => (openBlock(), createBlock(unref(ht), normalizeProps(guardReactiveProps(t)), {
      default: withCtx(() => [
        renderSlot(e.$slots, "default")
      ]),
      _: 3
    }, 16));
  }
});
function Ao(a2) {
  return a2.reduce((t, e) => (t.push(e), e.children && t.push(...Ao(e.children)), t), []);
}
var [lr, Zf] = Q("TreeRoot");
var Ig = defineComponent({
  __name: "TreeRoot",
  props: {
    modelValue: {},
    defaultValue: {},
    items: {},
    expanded: {},
    defaultExpanded: {},
    getKey: {},
    selectionBehavior: { default: "toggle" },
    multiple: { type: Boolean },
    dir: {},
    disabled: { type: Boolean },
    propagateSelect: { type: Boolean },
    asChild: { type: Boolean },
    as: { default: "ul" }
  },
  emits: ["update:modelValue", "update:expanded"],
  setup(a2, { emit: t }) {
    const e = a2, n = t, { items: l, multiple: s, disabled: r, propagateSelect: i, dir: u } = toRefs(e), { handleTypeaheadSearch: d } = ya(), p = Ce(u), c = ref(), f = ref(false), v2 = ra(), g = ae(e, "modelValue", n, {
      // @ts-expect-error idk
      defaultValue: e.defaultValue ?? (s.value ? [] : void 0),
      passive: e.modelValue === void 0,
      deep: true
    }), m2 = ae(e, "expanded", n, {
      // @ts-expect-error idk
      defaultValue: e.defaultExpanded ?? [],
      passive: e.expanded === void 0,
      deep: true
    }), { onSelectItem: S, handleMultipleReplace: x } = Ii(g, e), D = computed(() => s.value && Array.isArray(g.value) ? g.value.map((I) => e.getKey(I)) : [e.getKey(g.value ?? {})]);
    function h2(I, k = 1, L) {
      return I.reduce((O, V2, H2) => {
        const Y = e.getKey(V2), J2 = m2.value.includes(Y), N2 = {
          _id: Y,
          value: V2,
          index: H2,
          level: k,
          parentItem: L,
          hasChildren: !!V2.children,
          bind: {
            value: V2,
            level: k,
            "aria-setsize": I.length,
            "aria-posinset": H2 + 1
          }
        };
        return O.push(N2), V2.children && J2 && O.push(...h2(V2.children, k + 1, V2)), O;
      }, []);
    }
    const E = computed(() => {
      const I = e.items;
      return m2.value.map((k) => k), h2(I ?? []);
    });
    function P2(I) {
      var k;
      if (f.value)
        v2.trigger(I);
      else {
        const L = (k = c.value) == null ? void 0 : k.getItems().map((O) => O.ref);
        d(I.key, L);
      }
    }
    function $2(I) {
      if (f.value)
        return;
      const k = Xa[I.key];
      nextTick(() => {
        var L;
        x(
          k,
          document.activeElement,
          (L = c.value) == null ? void 0 : L.getItems,
          E.value.map((O) => O.value)
        );
      });
    }
    return Zf({
      modelValue: g,
      selectedKeys: D,
      onSelect: (I) => {
        var O;
        const k = (V2) => e.getKey(V2 ?? {}) === e.getKey(I), L = e.multiple && Array.isArray(g.value) ? ((O = g.value) == null ? void 0 : O.findIndex(k)) !== -1 : void 0;
        if (S(I, k), e.propagateSelect && e.multiple && Array.isArray(g.value)) {
          const V2 = Ao(I.children ?? []);
          L ? g.value = [...g.value].filter((H2) => !V2.some((Y) => e.getKey(H2 ?? {}) === e.getKey(Y))) : g.value = [...g.value, ...V2];
        }
      },
      expanded: m2,
      onToggle(I) {
        if (!(I != null && I.children))
          return;
        const k = e.getKey(I) ?? I;
        m2.value.includes(k) ? m2.value = m2.value.filter((L) => L !== k) : m2.value.push(k);
      },
      getKey: e.getKey,
      items: l,
      expandedItems: E,
      disabled: r,
      multiple: s,
      dir: p,
      propagateSelect: i,
      isVirtual: f,
      virtualKeydownHook: v2,
      handleMultipleReplace: x
    }), (I, k) => (openBlock(), createBlock(unref(At), {
      ref_key: "rovingFocusGroupRef",
      ref: c,
      "as-child": "",
      orientation: "vertical",
      dir: unref(p)
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), {
          role: "tree",
          as: I.as,
          "as-child": I.asChild,
          "aria-multiselectable": unref(s) ? true : void 0,
          onKeydown: [
            P2,
            withKeys(withModifiers($2, ["shift"]), ["up", "down"])
          ]
        }, {
          default: withCtx(() => [
            renderSlot(I.$slots, "default", {
              flattenItems: E.value,
              modelValue: unref(g),
              expanded: unref(m2)
            })
          ]),
          _: 3
        }, 8, ["as", "as-child", "aria-multiselectable", "onKeydown"])
      ]),
      _: 3
    }, 8, ["dir"]));
  }
});
var Jf = "tree.select";
var Qf = "tree.toggle";
var Tg = defineComponent({
  inheritAttrs: false,
  __name: "TreeItem",
  props: {
    value: {},
    level: {},
    asChild: { type: Boolean },
    as: { default: "li" }
  },
  emits: ["select", "toggle"],
  setup(a2, { expose: t, emit: e }) {
    const n = a2, l = e, s = lr(), { getItems: r } = Zt(), i = computed(() => !!n.value.children), u = computed(() => {
      const x = s.getKey(n.value);
      return s.expanded.value.includes(x);
    }), d = computed(() => {
      const x = s.getKey(n.value);
      return s.selectedKeys.value.includes(x);
    }), p = computed(() => {
      if (s.propagateSelect.value && d.value && i.value && Array.isArray(s.modelValue.value))
        return !Ao(n.value.children).every((D) => s.modelValue.value.find((h2) => s.getKey(h2) === s.getKey(D)));
    });
    function c(x) {
      if (i.value)
        if (u.value) {
          const D = r().map((I) => I.ref), h2 = document.activeElement, E = D.indexOf(h2), $2 = [...D].slice(E).find((I) => Number(I.getAttribute("data-indent")) === n.level + 1);
          $2 && $2.focus();
        } else
          S(x);
    }
    function f(x) {
      if (u.value)
        S(x);
      else {
        const D = r().map((I) => I.ref), h2 = document.activeElement, E = D.indexOf(h2), $2 = [...D].slice(0, E).reverse().find((I) => Number(I.getAttribute("data-indent")) === n.level - 1);
        $2 && $2.focus();
      }
    }
    async function v2(x) {
      l("select", x), !(x != null && x.defaultPrevented) && s.onSelect(n.value);
    }
    async function g(x) {
      l("toggle", x), !(x != null && x.defaultPrevented) && s.onToggle(n.value);
    }
    async function m2(x) {
      if (!x)
        return;
      const D = { originalEvent: x, value: n.value, isExpanded: u.value, isSelected: d.value };
      zt(Jf, v2, D);
    }
    async function S(x) {
      if (!x)
        return;
      const D = { originalEvent: x, value: n.value, isExpanded: u.value, isSelected: d.value };
      zt(Qf, g, D);
    }
    return t({
      isExpanded: u,
      isSelected: d,
      isIndeterminate: p,
      handleToggle: () => s.onToggle(n.value),
      handleSelect: () => s.onSelect(n.value)
    }), (x, D) => (openBlock(), createBlock(unref(Ot), {
      "as-child": "",
      value: x.value,
      "allow-shift-key": ""
    }, {
      default: withCtx(() => [
        createVNode(unref(A2), mergeProps(x.$attrs, {
          role: "treeitem",
          as: x.as,
          "as-child": x.asChild,
          "aria-selected": d.value,
          "aria-expanded": i.value ? u.value : void 0,
          "aria-level": x.level,
          "data-indent": x.level,
          "data-selected": d.value ? "" : void 0,
          "data-expanded": u.value ? "" : void 0,
          onKeydown: [
            withKeys(withModifiers(m2, ["self", "prevent"]), ["enter", "space"]),
            D[0] || (D[0] = withKeys(withModifiers((h2) => unref(s).dir.value === "ltr" ? c(h2) : f(h2), ["prevent"]), ["right"])),
            D[1] || (D[1] = withKeys(withModifiers((h2) => unref(s).dir.value === "ltr" ? f(h2) : c(h2), ["prevent"]), ["left"]))
          ],
          onClick: D[2] || (D[2] = withModifiers((h2) => {
            m2(h2), S(h2);
          }, ["stop"]))
        }), {
          default: withCtx(() => [
            renderSlot(x.$slots, "default", {
              isExpanded: u.value,
              isSelected: d.value,
              isIndeterminate: p.value,
              handleSelect: () => unref(s).onSelect(x.value),
              handleToggle: () => unref(s).onToggle(x.value)
            })
          ]),
          _: 3
        }, 16, ["as", "as-child", "aria-selected", "aria-expanded", "aria-level", "data-indent", "data-selected", "data-expanded", "onKeydown"])
      ]),
      _: 3
    }, 8, ["value"]));
  }
});
var Rg = defineComponent({
  __name: "TreeVirtualizer",
  props: {
    estimateSize: {},
    textContent: { type: Function }
  },
  setup(a2) {
    const t = a2, e = useSlots(), n = lr(), l = Pl(), { getItems: s } = Zt(), r = Dt("", 1e3), i = computed(() => {
      const f = (v2) => t.textContent ? t.textContent(v2) : v2.toString().toLowerCase();
      return n.expandedItems.value.map((v2, g) => ({
        index: g,
        textContent: f(v2.value)
      }));
    });
    n.isVirtual.value = true;
    const u = computed(() => {
      const f = l.value;
      if (f) {
        const v2 = window.getComputedStyle(f);
        return {
          start: Number.parseFloat(v2.paddingBlockStart || v2.paddingTop),
          end: Number.parseFloat(v2.paddingBlockEnd || v2.paddingBottom)
        };
      } else
        return { start: 0, end: 0 };
    }), d = os(
      {
        get scrollPaddingStart() {
          return u.value.start;
        },
        get scrollPaddingEnd() {
          return u.value.end;
        },
        get count() {
          return n.expandedItems.value.length ?? 0;
        },
        get horizontal() {
          return false;
        },
        getItemKey(f) {
          return f + n.getKey(n.expandedItems.value[f].value);
        },
        estimateSize() {
          return t.estimateSize ?? 28;
        },
        getScrollElement() {
          return l.value;
        },
        overscan: 12
      }
    ), p = computed(() => d.value.getVirtualItems().map((f) => ({
      item: f,
      is: cloneVNode(e.default({
        item: n.expandedItems.value[f.index]
      })[0], {
        "data-index": f.index,
        style: {
          position: "absolute",
          top: 0,
          left: 0,
          transform: `translateY(${f.start}px)`,
          overflowAnchor: "none"
        }
      })
    })));
    function c(f) {
      d.value.scrollToIndex(f, { align: "start" }), requestAnimationFrame(() => {
        const v2 = l.value.querySelector(`[data-index="${f}"]`);
        v2 instanceof HTMLElement && v2.focus();
      });
    }
    return n.virtualKeydownHook.on((f) => {
      var S;
      const v2 = f.altKey || f.ctrlKey || f.metaKey;
      if (f.key === "Tab" && !v2)
        return;
      const m2 = Xa[f.key];
      if (["first", "last"].includes(m2)) {
        f.preventDefault();
        const x = m2 === "first" ? 0 : n.expandedItems.value.length - 1;
        d.value.scrollToIndex(x), requestAnimationFrame(() => {
          const D = s();
          (m2 === "first" ? D[0] : D[D.length - 1]).ref.focus();
        });
      } else if (m2 === "prev" && f.key !== "ArrowUp") {
        const x = document.activeElement, D = Number(x.getAttribute("data-index")), h2 = Number(x.getAttribute("data-indent")), P2 = n.expandedItems.value.slice(0, D).map(($2, I) => ({ ...$2, index: I })).reverse().find(($2) => $2.level === h2 - 1);
        P2 && c(P2.index);
      } else if (!m2 && !v2) {
        r.value += f.key;
        const x = Number((S = document.activeElement) == null ? void 0 : S.getAttribute("data-index")), D = i.value[x].textContent, h2 = i.value.map(($2) => $2.textContent), E = Gn(h2, r.value, D), P2 = i.value.find(($2) => $2.textContent === E);
        P2 && c(P2.index);
      }
      nextTick(() => {
        f.shiftKey && m2 && n.handleMultipleReplace(m2, document.activeElement, s, n.expandedItems.value.map((x) => x.value));
      });
    }), (f, v2) => (openBlock(), createElementBlock("div", {
      "data-radix-vue-virtualizer": "",
      style: normalizeStyle({
        position: "relative",
        width: "100%",
        height: `${unref(d).getTotalSize()}px`
      })
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(p.value, ({ is: g, item: m2 }) => (openBlock(), createBlock(resolveDynamicComponent(g), {
        key: m2.key
      }))), 128))
    ], 4));
  }
});
var Ag = defineComponent({
  __name: "Viewport",
  props: {
    nonce: {},
    asChild: { type: Boolean },
    as: {}
  },
  setup(a2) {
    const t = a2, { forwardRef: e } = R2(), { nonce: n } = toRefs(t), l = qa(n);
    return (s, r) => (openBlock(), createElementBlock(Fragment, null, [
      createVNode(unref(A2), mergeProps({ ...s.$attrs, ...t }, {
        ref: unref(e),
        "data-radix-viewport": "",
        role: "presentation",
        style: {
          // we use position: 'relative' here on the `viewport` so that when we call
          // `selectedItem.offsetTop` in calculations, the offset is relative to the viewport
          // (independent of the scrollUpButton).
          position: "relative",
          flex: 1,
          overflow: "auto"
        }
      }), {
        default: withCtx(() => [
          renderSlot(s.$slots, "default")
        ]),
        _: 3
      }, 16),
      createVNode(unref(A2), {
        as: "style",
        nonce: unref(l)
      }, {
        default: withCtx(() => [
          createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-radix-viewport] { scrollbar-width:none; -ms-overflow-style: none; -webkit-overflow-scrolling: touch; } [data-radix-viewport]::-webkit-scrollbar { display: none; } ")
        ]),
        _: 1
      }, 8, ["nonce"])
    ], 64));
  }
});
export {
  uv as AccordionContent,
  dv as AccordionHeader,
  iv as AccordionItem,
  rv as AccordionRoot,
  cv as AccordionTrigger,
  wv as AlertDialogAction,
  gv as AlertDialogCancel,
  hv as AlertDialogContent,
  Cv as AlertDialogDescription,
  yv as AlertDialogOverlay,
  mv as AlertDialogPortal,
  fv as AlertDialogRoot,
  bv as AlertDialogTitle,
  vv as AlertDialogTrigger,
  _v as AspectRatio,
  Ev as AvatarFallback,
  Sv as AvatarImage,
  xv as AvatarRoot,
  Tu as CalendarCell,
  Fu as CalendarCellTrigger,
  Iu as CalendarGrid,
  Mu as CalendarGridBody,
  ku as CalendarGridHead,
  Vu as CalendarGridRow,
  Ru as CalendarHeadCell,
  $u as CalendarHeader,
  Bu as CalendarHeading,
  Au as CalendarNext,
  Ou as CalendarPrev,
  Du as CalendarRoot,
  Dv as CheckboxIndicator,
  Pv as CheckboxRoot,
  ki as CollapsibleContent,
  Ri as CollapsibleRoot,
  Ai as CollapsibleTrigger,
  Iv as ComboboxAnchor,
  zv as ComboboxArrow,
  Rv as ComboboxCancel,
  kv as ComboboxContent,
  Mv as ComboboxEmpty,
  Av as ComboboxGroup,
  Bv as ComboboxInput,
  Fv as ComboboxItem,
  Lv as ComboboxItemIndicator,
  Ov as ComboboxLabel,
  Kv as ComboboxPortal,
  $v as ComboboxRoot,
  Nv as ComboboxSeparator,
  Tv as ComboboxTrigger,
  Vv as ComboboxViewport,
  lv as ConfigProvider,
  Gv as ContextMenuArrow,
  Zv as ContextMenuCheckboxItem,
  Uv as ContextMenuContent,
  Yv as ContextMenuGroup,
  qv as ContextMenuItem,
  Jv as ContextMenuItemIndicator,
  Qv as ContextMenuLabel,
  jv as ContextMenuPortal,
  em as ContextMenuRadioGroup,
  tm as ContextMenuRadioItem,
  Hv as ContextMenuRoot,
  Xv as ContextMenuSeparator,
  am as ContextMenuSub,
  nm as ContextMenuSubContent,
  om as ContextMenuSubTrigger,
  Wv as ContextMenuTrigger,
  Fd as DateFieldInput,
  Dd as DateFieldRoot,
  Cm as DatePickerAnchor,
  wm as DatePickerArrow,
  gm as DatePickerCalendar,
  im as DatePickerCell,
  mm as DatePickerCellTrigger,
  _m as DatePickerClose,
  Sm as DatePickerContent,
  bm as DatePickerField,
  rm as DatePickerGrid,
  fm as DatePickerGridBody,
  pm as DatePickerGridHead,
  vm as DatePickerGridRow,
  um as DatePickerHeadCell,
  lm as DatePickerHeader,
  sm as DatePickerHeading,
  hm as DatePickerInput,
  dm as DatePickerNext,
  cm as DatePickerPrev,
  ym as DatePickerRoot,
  xm as DatePickerTrigger,
  jd as DateRangeFieldInput,
  Wd as DateRangeFieldRoot,
  Nm as DateRangePickerAnchor,
  zm as DateRangePickerArrow,
  Fm as DateRangePickerCalendar,
  $m as DateRangePickerCell,
  km as DateRangePickerCellTrigger,
  Km as DateRangePickerClose,
  Wm as DateRangePickerContent,
  Lm as DateRangePickerField,
  Dm as DateRangePickerGrid,
  Am as DateRangePickerGridBody,
  Rm as DateRangePickerGridHead,
  Om as DateRangePickerGridRow,
  Bm as DateRangePickerHeadCell,
  Em as DateRangePickerHeader,
  Pm as DateRangePickerHeading,
  Mm as DateRangePickerInput,
  Im as DateRangePickerNext,
  Tm as DateRangePickerPrev,
  Vm as DateRangePickerRoot,
  Hm as DateRangePickerTrigger,
  Nl as DialogClose,
  du as DialogContent,
  vu as DialogDescription,
  pu as DialogOverlay,
  pv as DialogPortal,
  zi as DialogRoot,
  fu as DialogTitle,
  Ki as DialogTrigger,
  Ym as DropdownMenuArrow,
  Qm as DropdownMenuCheckboxItem,
  qm as DropdownMenuContent,
  Zm as DropdownMenuGroup,
  Xm as DropdownMenuItem,
  eh as DropdownMenuItemIndicator,
  th as DropdownMenuLabel,
  Gm as DropdownMenuPortal,
  ah as DropdownMenuRadioGroup,
  nh as DropdownMenuRadioItem,
  jm as DropdownMenuRoot,
  Jm as DropdownMenuSeparator,
  oh as DropdownMenuSub,
  lh as DropdownMenuSubContent,
  sh as DropdownMenuSubTrigger,
  Um as DropdownMenuTrigger,
  ih as EditableArea,
  ph as EditableCancelTrigger,
  fh as EditableEditTrigger,
  uh as EditableInput,
  dh as EditablePreview,
  rh as EditableRoot,
  ch as EditableSubmitTrigger,
  gh as HoverCardArrow,
  yh as HoverCardContent,
  hh as HoverCardPortal,
  vh as HoverCardRoot,
  mh as HoverCardTrigger,
  bh as Label,
  wh as ListboxContent,
  _h as ListboxFilter,
  Ph as ListboxGroup,
  Dh as ListboxGroupLabel,
  xh as ListboxItem,
  Sh as ListboxItemIndicator,
  Ch as ListboxRoot,
  Eh as ListboxVirtualizer,
  Ah as MenubarArrow,
  Vh as MenubarCheckboxItem,
  Rh as MenubarContent,
  kh as MenubarGroup,
  Oh as MenubarItem,
  Fh as MenubarItemIndicator,
  Lh as MenubarLabel,
  Bh as MenubarMenu,
  Th as MenubarPortal,
  Nh as MenubarRadioGroup,
  zh as MenubarRadioItem,
  $h as MenubarRoot,
  Mh as MenubarSeparator,
  Kh as MenubarSub,
  Hh as MenubarSubContent,
  Wh as MenubarSubTrigger,
  Ih as MenubarTrigger,
  Gh as NavigationMenuContent,
  qh as NavigationMenuIndicator,
  Uh as NavigationMenuItem,
  Yh as NavigationMenuLink,
  Xh as NavigationMenuList,
  jh as NavigationMenuRoot,
  Zh as NavigationMenuSub,
  Jh as NavigationMenuTrigger,
  Qh as NavigationMenuViewport,
  ny as NumberFieldDecrement,
  ay as NumberFieldIncrement,
  ty as NumberFieldInput,
  ey as NumberFieldRoot,
  ly as PaginationEllipsis,
  sy as PaginationFirst,
  ry as PaginationLast,
  iy as PaginationList,
  uy as PaginationListItem,
  dy as PaginationNext,
  cy as PaginationPrev,
  oy as PaginationRoot,
  fy as PinInputInput,
  py as PinInputRoot,
  ys as PopoverAnchor,
  ms as PopoverArrow,
  hs as PopoverClose,
  vs as PopoverContent,
  ps as PopoverPortal,
  ds as PopoverRoot,
  cs as PopoverTrigger,
  A2 as Primitive,
  my as ProgressIndicator,
  vy as ProgressRoot,
  gy as RadioGroupIndicator,
  yy as RadioGroupItem,
  hy as RadioGroupRoot,
  tp as RangeCalendarCell,
  ip as RangeCalendarCellTrigger,
  ep as RangeCalendarGrid,
  sp as RangeCalendarGridBody,
  lp as RangeCalendarGridHead,
  rp as RangeCalendarGridRow,
  ap as RangeCalendarHeadCell,
  Jc as RangeCalendarHeader,
  Qc as RangeCalendarHeading,
  np as RangeCalendarNext,
  op as RangeCalendarPrev,
  Zc as RangeCalendarRoot,
  xy as ScrollAreaCorner,
  by as ScrollAreaRoot,
  wy as ScrollAreaScrollbar,
  _y as ScrollAreaThumb,
  Cy as ScrollAreaViewport,
  $y as SelectArrow,
  Dy as SelectContent,
  Ry as SelectGroup,
  Ly as SelectIcon,
  Iy as SelectItem,
  Ty as SelectItemIndicator,
  Oy as SelectItemText,
  Ay as SelectLabel,
  Py as SelectPortal,
  Sy as SelectRoot,
  Vy as SelectScrollDownButton,
  My as SelectScrollUpButton,
  By as SelectSeparator,
  Ey as SelectTrigger,
  Fy as SelectValue,
  ky as SelectViewport,
  Mp as Separator,
  Hy as SliderRange,
  Ny as SliderRoot,
  zy as SliderThumb,
  Ky as SliderTrack,
  qn as Slot,
  Wy as SplitterGroup,
  jy as SplitterPanel,
  Uy as SplitterResizeHandle,
  Xy as StepperDescription,
  Jy as StepperIndicator,
  qy as StepperItem,
  Gy as StepperRoot,
  Qy as StepperSeparator,
  Zy as StepperTitle,
  Yy as StepperTrigger,
  eg as SwitchRoot,
  tg as SwitchThumb,
  og as TabsContent,
  sg as TabsIndicator,
  ng as TabsList,
  ag as TabsRoot,
  lg as TabsTrigger,
  pg as TagsInputClear,
  ig as TagsInputInput,
  ug as TagsInputItem,
  cg as TagsInputItemDelete,
  dg as TagsInputItemText,
  rg as TagsInputRoot,
  mg as ToastAction,
  Nf as ToastClose,
  gg as ToastDescription,
  fg as ToastProvider,
  vg as ToastRoot,
  yg as ToastTitle,
  hg as ToastViewport,
  zf as Toggle,
  jf as ToggleGroupItem,
  Wf as ToggleGroupRoot,
  Gf as ToolbarButton,
  Cg as ToolbarLink,
  bg as ToolbarRoot,
  xg as ToolbarSeparator,
  wg as ToolbarToggleGroup,
  _g as ToolbarToggleItem,
  $g as TooltipArrow,
  Dg as TooltipContent,
  Bg as TooltipPortal,
  Sg as TooltipProvider,
  Eg as TooltipRoot,
  Pg as TooltipTrigger,
  Tg as TreeItem,
  Ig as TreeRoot,
  Rg as TreeVirtualizer,
  Ag as Viewport,
  Yt as VisuallyHidden,
  Q as createContext,
  ma as useBodyScrollLock,
  Wn as useDateFormatter,
  Te as useEmitAsProps,
  R2 as useForwardExpose,
  Bt as useForwardProps,
  xe as useForwardPropsEmits,
  me as useId,
  Tl as useStateMachine,
  sv as withDefault
};
//# sourceMappingURL=radix-vue.js.map
