import "./chunk-PR4QN5HX.js";

// node_modules/seamless-scroll-polyfill/lib/common.js
var checkBehavior = (behavior) => {
  return behavior === void 0 || behavior === "auto" || behavior === "instant" || behavior === "smooth";
};
function elementScrollXY(x, y) {
  this.scrollLeft = x;
  this.scrollTop = y;
}
var failedExecute = (method, object, reason = "cannot convert to dictionary.") => `Failed to execute '${method}' on '${object}': ${reason}`;
var failedExecuteInvalidEnumValue = (method, object, value) => failedExecute(method, object, `The provided value '${value}' is not a valid enum value of type ScrollBehavior.`);
var backupMethod = (proto, method, fallback) => {
  var _a;
  const backup = `__SEAMLESS.BACKUP$${method}`;
  if (!proto[backup] && proto[method] && !((_a = proto[method]) === null || _a === void 0 ? void 0 : _a.__isPolyfill)) {
    proto[backup] = proto[method];
  }
  return proto[backup] || fallback;
};
var isObject = (value) => {
  const type = typeof value;
  return value !== null && (type === "object" || type === "function");
};
var isScrollBehaviorSupported = (config) => "scrollBehavior" in window.document.documentElement.style && (config === null || config === void 0 ? void 0 : config.forcePolyfill) !== true;
var markPolyfill = (method) => {
  Object.defineProperty(method, "__isPolyfill", { value: true });
};
var modifyPrototypes = (prop, func) => {
  markPolyfill(func);
  [HTMLElement.prototype, SVGElement.prototype, Element.prototype].forEach((prototype) => {
    backupMethod(prototype, prop);
    prototype[prop] = func;
  });
};
var scrollingElement = (element) => element.ownerDocument.scrollingElement || element.ownerDocument.documentElement;

// node_modules/seamless-scroll-polyfill/lib/scroll-end-event.js
function scrollEndEvent(bubbles) {
  if (typeof Event === "function") {
    return new Event("scrollend", {
      bubbles,
      cancelable: false
    });
  }
  const event = document.createEvent("Event");
  event.initEvent("scrollend", bubbles, false);
  return event;
}

// node_modules/seamless-scroll-polyfill/lib/scroll-step.js
var ease = (k) => {
  return 0.5 * (1 - Math.cos(Math.PI * k));
};
function now() {
  var _a;
  let fn;
  if ((_a = window.performance) === null || _a === void 0 ? void 0 : _a.now) {
    fn = () => window.performance.now();
  } else {
    fn = () => window.Date.now();
  }
  now = fn;
  return fn();
}
var DURATION = 500;
var step = (context) => {
  const currentTime = now();
  const elapsed = (currentTime - context.timeStamp) / (context.duration || DURATION);
  if (elapsed > 1) {
    context.method(context.targetX, context.targetY);
    context.callback();
    return;
  }
  const value = (context.timingFunc || ease)(elapsed);
  const currentX = context.startX + (context.targetX - context.startX) * value;
  const currentY = context.startY + (context.targetY - context.startY) * value;
  context.method(currentX, currentY);
  context.rafId = window.requestAnimationFrame(() => {
    step(context);
  });
};

// node_modules/seamless-scroll-polyfill/lib/scroll.js
var nonFinite = (value) => {
  if (!isFinite(value)) {
    return 0;
  }
  return Number(value);
};
var isConnected = (node) => {
  var _a;
  return (_a = node.isConnected) !== null && _a !== void 0 ? _a : !node.ownerDocument || // eslint-disable-next-line no-bitwise
  !(node.ownerDocument.compareDocumentPosition(node) & /** DOCUMENT_POSITION_DISCONNECTED */
  1);
};
var scrollWithOptions = (element, options, config) => {
  var _a, _b;
  if (!isConnected(element)) {
    return;
  }
  const startX = element.scrollLeft;
  const startY = element.scrollTop;
  const targetX = nonFinite((_a = options.left) !== null && _a !== void 0 ? _a : startX);
  const targetY = nonFinite((_b = options.top) !== null && _b !== void 0 ? _b : startY);
  if (targetX === startX && targetY === startY) {
    return;
  }
  const fallback = backupMethod(HTMLElement.prototype, "scroll", elementScrollXY);
  const method = backupMethod(Object.getPrototypeOf(element), "scroll", fallback).bind(element);
  if (options.behavior !== "smooth") {
    method(targetX, targetY);
    return;
  }
  const removeEventListener = () => {
    window.removeEventListener("wheel", cancelScroll);
    window.removeEventListener("touchmove", cancelScroll);
  };
  const callback = () => {
    removeEventListener();
    const isDocument = element.nodeType === /** Node.DOCUMENT_NODE */
    9;
    element.dispatchEvent(scrollEndEvent(isDocument));
  };
  const context = Object.assign(Object.assign({}, config), {
    timeStamp: now(),
    startX,
    startY,
    targetX,
    targetY,
    rafId: 0,
    method,
    callback
  });
  const cancelScroll = () => {
    window.cancelAnimationFrame(context.rafId);
    removeEventListener();
  };
  window.addEventListener("wheel", cancelScroll, {
    passive: true,
    once: true
  });
  window.addEventListener("touchmove", cancelScroll, {
    passive: true,
    once: true
  });
  step(context);
};
var isWindow = (obj) => obj.window === obj;
var createScroll = (scrollName) => (target, scrollOptions, config) => {
  const [element, scrollType] = isWindow(target) ? [scrollingElement(target.document.documentElement), "Window"] : [target, "Element"];
  const options = scrollOptions !== null && scrollOptions !== void 0 ? scrollOptions : {};
  if (!isObject(options)) {
    throw new TypeError(failedExecute(scrollName, scrollType));
  }
  if (!checkBehavior(options.behavior)) {
    throw new TypeError(failedExecuteInvalidEnumValue(scrollName, scrollType, options.behavior));
  }
  if (scrollName === "scrollBy") {
    options.left = nonFinite(options.left) + element.scrollLeft;
    options.top = nonFinite(options.top) + element.scrollTop;
  }
  scrollWithOptions(element, options, config);
};
var scroll = createScroll("scroll");
var scrollTo = createScroll("scrollTo");
var scrollBy = createScroll("scrollBy");
var elementScroll = scroll;
var elementScrollTo = scrollTo;
var elementScrollBy = scrollBy;
var windowScroll = scroll;
var windowScrollTo = scrollTo;
var windowScrollBy = scrollBy;

// node_modules/seamless-scroll-polyfill/lib/scrollIntoView.js
var normalizeWritingMode = (writingMode) => {
  switch (writingMode) {
    case "horizontal-tb":
    case "lr":
    case "lr-tb":
    case "rl":
    case "rl-tb":
      return 0;
    case "vertical-rl":
    case "tb":
    case "tb-rl":
      return 1;
    case "vertical-lr":
    case "tb-lr":
      return 2;
    case "sideways-rl":
      return 3;
    case "sideways-lr":
      return 4;
  }
  return 0;
};
var calcPhysicalAxis = (writingMode, isLTR, hPos, vPos) => {
  let layout = 0;
  if (!isLTR) {
    layout ^= 2;
  }
  switch (writingMode) {
    case 0:
      layout = layout >> 1 | (layout & 1) << 1;
      [hPos, vPos] = [vPos, hPos];
      break;
    case 1:
    case 3:
      layout ^= 1;
      break;
    case 4:
      layout ^= 2;
      break;
  }
  return [layout, hPos, vPos];
};
var isXReversed = (computedStyle) => {
  const layout = calcPhysicalAxis(normalizeWritingMode(computedStyle.writingMode), computedStyle.direction !== "rtl", void 0, void 0)[0];
  return (layout & 1) === 1;
};
var toPhysicalAlignment = (options, writingMode, isLTR) => {
  const [layout, hPos, vPos] = calcPhysicalAxis(writingMode, isLTR, options.block || "start", options.inline || "nearest");
  return [hPos, vPos].map((value, index) => {
    switch (value) {
      case "center":
        return 1;
      case "nearest":
        return 0;
      default: {
        const reverse = layout >> index & 1;
        return value === "start" === !reverse ? 2 : 3;
      }
    }
  });
};
var mapNearest = (align, scrollingEdgeStart, scrollingEdgeEnd, scrollingSize, elementEdgeStart, elementEdgeEnd, elementSize) => {
  if (align !== 0) {
    return align;
  }
  if (elementEdgeStart < scrollingEdgeStart && elementEdgeEnd > scrollingEdgeEnd || elementEdgeStart > scrollingEdgeStart && elementEdgeEnd < scrollingEdgeEnd) {
    return null;
  }
  if (elementEdgeStart <= scrollingEdgeStart && elementSize <= scrollingSize || elementEdgeEnd >= scrollingEdgeEnd && elementSize >= scrollingSize) {
    return 2;
  }
  if (elementEdgeEnd > scrollingEdgeEnd && elementSize < scrollingSize || elementEdgeStart < scrollingEdgeStart && elementSize > scrollingSize) {
    return 3;
  }
  return null;
};
var canOverflow = (overflow) => {
  return overflow !== "visible" && overflow !== "clip";
};
var getFrameElement = (element) => {
  var _a;
  try {
    return ((_a = element.ownerDocument.defaultView) === null || _a === void 0 ? void 0 : _a.frameElement) || null;
  } catch (_b) {
    return null;
  }
};
var isScrollable = (element, computedStyle) => {
  if (element.clientHeight < element.scrollHeight || element.clientWidth < element.scrollWidth) {
    return canOverflow(computedStyle.overflowY) || canOverflow(computedStyle.overflowX) || element === scrollingElement(element);
  }
  return false;
};
var parentElement = (element) => {
  const pNode = element.parentNode;
  const pElement = element.parentElement;
  if (pElement === null && pNode !== null) {
    if (pNode.nodeType === /** Node.DOCUMENT_FRAGMENT_NODE */
    11) {
      return pNode.host;
    }
    if (pNode.nodeType === /** Node.DOCUMENT_NODE */
    9) {
      return getFrameElement(element);
    }
  }
  return pElement;
};
var clamp = (value, min, max) => {
  if (value < min) {
    return min;
  }
  if (value > max) {
    return max;
  }
  return value;
};
var getSupportedScrollMarginProperty = (ownerDocument) => {
  return ["scroll-margin", "scroll-snap-margin"].filter((property) => property in ownerDocument.documentElement.style)[0];
};
var getElementScrollSnapArea = (element, elementRect, computedStyle) => {
  const { top, right, bottom, left } = elementRect;
  const scrollProperty = getSupportedScrollMarginProperty(element.ownerDocument);
  if (!scrollProperty) {
    return [top, right, bottom, left];
  }
  const scrollMarginValue = (edge) => {
    const value = computedStyle.getPropertyValue(`${scrollProperty}-${edge}`);
    return parseInt(value, 10) || 0;
  };
  return [
    top - scrollMarginValue("top"),
    right + scrollMarginValue("right"),
    bottom + scrollMarginValue("bottom"),
    left - scrollMarginValue("left")
  ];
};
var calcAlignEdge = (align, start, end) => {
  switch (align) {
    case 1:
      return (start + end) / 2;
    case 3:
      return end;
    case 2:
    case 0:
      return start;
  }
};
var getFrameViewport = (frame, frameRect) => {
  var _a, _b, _c;
  const visualViewport = (_a = frame.ownerDocument.defaultView) === null || _a === void 0 ? void 0 : _a.visualViewport;
  const [x, y, width, height] = frame === scrollingElement(frame) ? [0, 0, (_b = visualViewport === null || visualViewport === void 0 ? void 0 : visualViewport.width) !== null && _b !== void 0 ? _b : frame.clientWidth, (_c = visualViewport === null || visualViewport === void 0 ? void 0 : visualViewport.height) !== null && _c !== void 0 ? _c : frame.clientHeight] : [frameRect.left, frameRect.top, frame.clientWidth, frame.clientHeight];
  const left = x + frame.clientLeft;
  const top = y + frame.clientTop;
  const right = left + width;
  const bottom = top + height;
  return [top, right, bottom, left];
};
var computeScrollIntoView = (element, options) => {
  const actions = [];
  let ownerDocument = element.ownerDocument;
  let ownerWindow = ownerDocument.defaultView;
  if (!ownerWindow) {
    return actions;
  }
  const computedStyle = window.getComputedStyle(element);
  const isLTR = computedStyle.direction !== "rtl";
  const writingMode = normalizeWritingMode(computedStyle.writingMode || computedStyle.getPropertyValue("-webkit-writing-mode") || computedStyle.getPropertyValue("-ms-writing-mode"));
  const [alignH, alignV] = toPhysicalAlignment(options, writingMode, isLTR);
  let [top, right, bottom, left] = getElementScrollSnapArea(element, element.getBoundingClientRect(), computedStyle);
  for (let frame = parentElement(element); frame !== null; frame = parentElement(frame)) {
    if (ownerDocument !== frame.ownerDocument) {
      ownerDocument = frame.ownerDocument;
      ownerWindow = ownerDocument.defaultView;
      if (!ownerWindow) {
        break;
      }
      const { left: dX, top: dY } = frame.getBoundingClientRect();
      top += dY;
      right += dX;
      bottom += dY;
      left += dX;
    }
    const frameStyle = ownerWindow.getComputedStyle(frame);
    if (frameStyle.position === "fixed") {
      break;
    }
    if (!isScrollable(frame, frameStyle)) {
      continue;
    }
    const frameRect = frame.getBoundingClientRect();
    const [frameTop, frameRight, frameBottom, frameLeft] = getFrameViewport(frame, frameRect);
    const eAlignH = mapNearest(alignH, frameLeft, frameRight, frame.clientWidth, left, right, right - left);
    const eAlignV = mapNearest(alignV, frameTop, frameBottom, frame.clientHeight, top, bottom, bottom - top);
    const diffX = eAlignH === null ? 0 : calcAlignEdge(eAlignH, left, right) - calcAlignEdge(eAlignH, frameLeft, frameRight);
    const diffY = eAlignV === null ? 0 : calcAlignEdge(eAlignV, top, bottom) - calcAlignEdge(eAlignV, frameTop, frameBottom);
    const moveX = isXReversed(frameStyle) ? clamp(diffX, -frame.scrollWidth + frame.clientWidth - frame.scrollLeft, -frame.scrollLeft) : clamp(diffX, -frame.scrollLeft, frame.scrollWidth - frame.clientWidth - frame.scrollLeft);
    const moveY = clamp(diffY, -frame.scrollTop, frame.scrollHeight - frame.clientHeight - frame.scrollTop);
    actions.push([
      frame,
      { left: frame.scrollLeft + moveX, top: frame.scrollTop + moveY, behavior: options.behavior }
    ]);
    top = Math.max(top - moveY, frameTop);
    right = Math.min(right - moveX, frameRight);
    bottom = Math.min(bottom - moveY, frameBottom);
    left = Math.max(left - moveX, frameLeft);
  }
  return actions;
};
var scrollIntoView = (element, scrollIntoViewOptions, config) => {
  const options = scrollIntoViewOptions || {};
  if (!checkBehavior(options.behavior)) {
    throw new TypeError(failedExecuteInvalidEnumValue("scrollIntoView", "Element", options.behavior));
  }
  const actions = computeScrollIntoView(element, options);
  actions.forEach(([frame, scrollToOptions]) => {
    elementScroll(frame, scrollToOptions, config);
  });
};
var elementScrollIntoView = scrollIntoView;

// node_modules/seamless-scroll-polyfill/lib/scroll.polyfill.js
var createPolyfill = (scrollName, patch) => (config) => {
  if (isScrollBehaviorSupported(config)) {
    return;
  }
  const scrollMethod = {
    scroll,
    scrollTo,
    scrollBy
  }[scrollName];
  patch(scrollName, function() {
    const args = arguments;
    if (arguments.length === 1) {
      scrollMethod(this, args[0], config);
      return;
    }
    const left = args[0];
    const top = args[1];
    scrollMethod(this, { left, top });
  });
};
var elementScrollPolyfill = createPolyfill("scroll", modifyPrototypes);
var elementScrollToPolyfill = createPolyfill("scrollTo", modifyPrototypes);
var elementScrollByPolyfill = createPolyfill("scrollBy", modifyPrototypes);
var modifyWindow = (prop, func) => {
  markPolyfill(func);
  backupMethod(window, prop);
  window[prop] = func;
};
var windowScrollPolyfill = createPolyfill("scroll", modifyWindow);
var windowScrollToPolyfill = createPolyfill("scrollTo", modifyWindow);
var windowScrollByPolyfill = createPolyfill("scrollBy", modifyWindow);

// node_modules/seamless-scroll-polyfill/lib/scrollIntoView.polyfill.js
function elementScrollIntoViewBoolean(alignToTop) {
  elementScrollIntoView(this, {
    block: (alignToTop !== null && alignToTop !== void 0 ? alignToTop : true) ? "start" : "end",
    inline: "nearest"
  });
}
var elementScrollIntoViewPolyfill = (config) => {
  if (isScrollBehaviorSupported(config)) {
    return;
  }
  const originalFunc = backupMethod(window.HTMLElement.prototype, "scrollIntoView", elementScrollIntoViewBoolean);
  modifyPrototypes("scrollIntoView", function scrollIntoView2() {
    const args = arguments;
    const options = args[0];
    if (args.length === 1 && isObject(options)) {
      elementScrollIntoView(this, options, config);
      return;
    }
    originalFunc.apply(this, args);
  });
};

// node_modules/seamless-scroll-polyfill/lib/polyfill.js
var polyfill = (config) => {
  if (isScrollBehaviorSupported(config)) {
    return;
  }
  elementScrollPolyfill(config);
  elementScrollToPolyfill(config);
  elementScrollByPolyfill(config);
  elementScrollIntoViewPolyfill(config);
  windowScrollPolyfill(config);
  windowScrollToPolyfill(config);
  windowScrollByPolyfill(config);
};
export {
  elementScroll,
  elementScrollBy,
  elementScrollByPolyfill,
  elementScrollIntoView,
  elementScrollIntoViewPolyfill,
  elementScrollPolyfill,
  elementScrollTo,
  elementScrollToPolyfill,
  polyfill,
  scroll,
  scrollBy,
  scrollIntoView,
  scrollTo,
  windowScroll,
  windowScrollBy,
  windowScrollByPolyfill,
  windowScrollPolyfill,
  windowScrollTo,
  windowScrollToPolyfill
};
//# sourceMappingURL=seamless-scroll-polyfill.js.map
