import { css } from '@emotion/css';
import { getCssVarNames, injectGlobalCssVariables } from '../../utils/style.js';

const cssVarDefaults = {
    '--vis-annotations-text-color': '#282C34',
    '--vis-annotations-connector-stroke-color': '#444',
    '--vis-annotations-connector-stroke-width': '1px',
    '--vis-annotations-connector-stroke-dasharray': 'none',
    '--vis-annotations-subject-stroke-color': '#444',
    '--vis-annotations-subject-fill-color': 'none',
    '--vis-annotations-subject-stroke-dasharray': 'none',
    '--vis-dark-annotations-text-color': '#e8e9ef',
    '--vis-dark-annotations-connector-stroke-color': '#fff',
    '--vis-dark-annotations-subject-stroke-color': '#fff',
};
const root = css `
  label: annotations-component;
`;
const variables = getCssVarNames(cssVarDefaults);
injectGlobalCssVariables(cssVarDefaults, root);
const annotation = css `
  label: annotation;
`;
const annotationSubject = css `
  label: annotationSubject;

  line {
    stroke: var(${variables.annotationsConnectorStrokeColor});
    stroke-width: var(${variables.annotationsConnectorStrokeWidth});
    stroke-dasharray: var(${variables.annotationsConnectorStrokeDasharray});
  }

  circle {
    stroke: var(${variables.annotationsSubjectStrokeColor});
    fill: var(${variables.annotationsSubjectFillColor});
    stroke-dasharray: var(${variables.annotationsSubjectStrokeDasharray});
  }
`;
const annotationContent = css `
  label: annotationContent;
  > text {
    fill: var(--vis-annotations-text-color);
  }
`;

export { annotation, annotationContent, annotationSubject, root, variables };
//# sourceMappingURL=style.js.map
