import { SymbolType } from "../../types/symbol";
export interface BulletLegendItemInterface {
    name: string | number;
    color?: string;
    className?: string;
    shape?: BulletShape;
    inactive?: boolean;
    hidden?: boolean;
    pointer?: boolean;
}
export declare const BulletShape: {
    readonly Line: "line";
    readonly Circle: SymbolType.Circle;
    readonly Cross: SymbolType.Cross;
    readonly Diamond: SymbolType.Diamond;
    readonly Square: SymbolType.Square;
    readonly Star: SymbolType.Star;
    readonly Triangle: SymbolType.Triangle;
    readonly Wye: SymbolType.Wye;
};
export declare type BulletShape = typeof BulletShape[keyof typeof BulletShape];
export declare enum BulletLegendOrientation {
    Horizontal = "horizontal",
    Vertical = "vertical"
}
