import { BaseType, Selection } from 'd3-selection';
import { Arc } from 'd3-shape';
import { ColorAccessor, NumericAccessor } from "../../../../types/accessor";
import { GraphInputLink, GraphInputNode } from "../../../../types/graph";
import { GraphNode, GraphCircleLabel, GraphNodeAnimatedElement, GraphNodeAnimationState } from '../../types';
import { GraphConfigInterface } from '../../config';
export declare const NODE_SIZE = 30;
export declare const LABEL_RECT_HORIZONTAL_PADDING = 10;
export declare const LABEL_RECT_VERTICAL_PADDING = 4;
export declare function getNodeSize<T>(d: T, nodeSizeAccessor: NumericAccessor<T>, index: number): number;
export declare function arcTween<N extends GraphInputNode, L extends GraphInputLink>(d: GraphNode<N, L>, config: GraphConfigInterface<N, L>, arcConstructor: Arc<any, GraphNodeAnimationState>, el: GraphNodeAnimatedElement<SVGElement>): (t: number) => string;
export declare function polyTween<N extends GraphInputNode, L extends GraphInputLink>(d: GraphNode<N, L>, config: GraphConfigInterface<N, L>, polygonConstructor: (nodeSize: number, nEdges?: number, endAngle?: number, isOpen?: boolean) => string, el: GraphNodeAnimatedElement<SVGElement>): (t: number) => string;
export declare function setLabelRect<T, K extends BaseType, L>(labelSelection: Selection<SVGGElement, T, K, L>, label: string, selector: string): Selection<SVGRectElement, T, K, L>;
export declare function getX(node: GraphNode): number;
export declare function getY(node: GraphNode): number;
export declare function configuredNodeSize<T>(nodeSizeAccessor: NumericAccessor<T>): number;
export declare function getMaxNodeSize<T>(data: T[], nodeSize: NumericAccessor<T>): number;
export declare function getAverageNodeSize<T>(data: T[], nodeSize: NumericAccessor<T>): number;
export declare function getSideLabelTextColor(label: GraphCircleLabel, context: SVGElement): string;
export declare function getNodeColor<T>(d: T, colorAccessor: ColorAccessor<T>, index: number): string;
export declare function getNodeIconColor<T>(d: T, colorAccessor: ColorAccessor<T>, index: number, context: SVGElement): string;
export declare function isInternalHref(str: string): boolean;
