import { Selection } from 'd3-selection';
import type L from 'leaflet';
import { StyleSpecification } from 'maplibre-gl';
import { ComponentCore } from "../../core/component";
import { MapDataModel } from "../../data-models/map";
import { ComponentType } from "../../types/component";
import { GenericDataRecord } from "../../types/data";
import { Bounds, LeafletMapPoint } from './types';
import { LeafletMapConfigInterface } from './config';
import * as s from './style';
export declare class LeafletMap<Datum extends GenericDataRecord> extends ComponentCore<Datum[], LeafletMapConfigInterface<Datum>> {
    static selectors: typeof s;
    static cssVariables: {
        mapContainerBackgroundColor: "--vis-map-container-background-color";
        mapLabelFontFamily: "--vis-map-label-font-family";
        mapPointDefaultFillColor: "--vis-map-point-default-fill-color";
        mapPointRingFillColor: "--vis-map-point-ring-fill-color";
        mapPointDefaultStrokeColor: "--vis-map-point-default-stroke-color";
        mapPointDefaultStrokeWidth: "--vis-map-point-default-stroke-width";
        mapPointDefaultCursor: "--vis-map-point-default-cursor";
        mapClusterDefaultFillColor: "--vis-map-cluster-default-fill-color";
        mapClusterDefaultStrokeColor: "--vis-map-cluster-default-stroke-color";
        mapClusterDefaultStrokeWidth: "--vis-map-cluster-default-stroke-width";
        mapClusterDonutFillColor: "--vis-map-cluster-donut-fill-color";
        mapClusterInnerLabelTextColorDark: "--vis-map-cluster-inner-label-text-color-dark";
        mapClusterInnerLabelTextColorLight: "--vis-map-cluster-inner-label-text-color-light";
        mapPointInnerLabelTextColorDark: "--vis-map-point-inner-label-text-color-dark";
        mapPointInnerLabelTextColorLight: "--vis-map-point-inner-label-text-color-light";
        mapPointBottomLabelTextColor: "--vis-map-point-bottom-label-text-color";
        mapPointBottomLabelFontSize: "--vis-map-point-bottom-label-font-size";
        mapClusterExpandedBackgroundFillColor: "--vis-map-cluster-expanded-background-fill-color";
        darkMapContainerBackgroundColor: "--vis-dark-map-container-background-color";
        darkMapPointDefaultFillColor: "--vis-dark-map-point-default-fill-color";
        darkMapPointDefaultStrokeColor: "--vis-dark-map-point-default-stroke-color";
        darkMapPointRingFillColor: "--vis-dark-map-point-ring-fill-color";
        darkMapClusterDefaultFillColor: "--vis-dark-map-cluster-default-fill-color";
        darkMapClusterDefaultStrokeColor: "--vis-dark-map-cluster-default-stroke-color";
        darkMapClusterDonutFillColor: "--vis-dark-map-cluster-donut-fill-color";
        darkMapClusterInnerLabelTextColorDark: "--vis-dark-map-cluster-inner-label-text-color-dark";
        darkMapClusterInnerLabelTextColorLight: "--vis-dark-map-cluster-inner-label-text-color-light";
        darkMapPointInnerLabelTextColorDark: "--vis-dark-map-point-inner-label-text-color-dark";
        darkMapPointInnerLabelTextColorLight: "--vis-dark-map-point-inner-label-text-color-light";
        darkMapPointBottomLabelTextColor: "--vis-dark-map-point-bottom-label-text-color";
        darkMapClusterExpandedBackgroundFillColor: "--vis-dark-map-cluster-expanded-background-fill-color";
    };
    protected _defaultConfig: LeafletMapConfigInterface<Datum>;
    config: LeafletMapConfigInterface<Datum>;
    g: Selection<HTMLElement, unknown, null, undefined>;
    type: ComponentType;
    element: HTMLElement;
    datamodel: MapDataModel<Datum>;
    protected _container: HTMLElement;
    protected _containerSelection: Selection<HTMLElement, unknown, null, undefined>;
    _onMapMoveEndInternal: (leaflet: L.Map) => void;
    private _map;
    private _clusterIndex;
    private _expandedCluster;
    private _cancelBackgroundClick;
    private _hasBeenMoved;
    private _hasBeenZoomed;
    private _isMoving;
    private _isZooming;
    private _eventInitiatedByComponent;
    private _triggerBackgroundClick;
    private _externallySelectedPoint;
    private _zoomingToExternallySelectedPoint;
    private _forceExpandCluster;
    private _pointGroup;
    private _pointSelectionRing;
    private _clusterBackground;
    private _clusterBackgroundRadius;
    private _selectedPoint;
    private _currentZoomLevel;
    private _firstRender;
    private _isDarkThemeActive;
    private resizeObserver;
    private themeObserver;
    private _renderDataAnimationFrameId;
    private _flyToBoundsAnimationFrameId;
    readonly _leafletInitializationPromise: Promise<L.Map>;
    static DEFAULT_CONTAINER_HEIGHT: number;
    protected events: {
        [x: string]: {
            mouseup: (d: LeafletMapPoint<Datum>, event: MouseEvent) => void;
            mousedown: (d: LeafletMapPoint<Datum>, event: MouseEvent) => void;
            click: (d: LeafletMapPoint<Datum>, event: MouseEvent) => void;
        };
    };
    constructor(container: HTMLElement, config?: LeafletMapConfigInterface<Datum>, data?: Datum[]);
    setConfig(config: LeafletMapConfigInterface<Datum>): void;
    setData(data: Datum[]): void;
    setTheme(theme: StyleSpecification | string): void;
    render(): void;
    getLeafletInstancePromise(): Promise<L.Map>;
    fitToPoints(duration?: number, padding?: [number, number]): void;
    fitToBounds(bounds: Bounds, duration?: number, padding?: [number, number]): void;
    selectPointById(id: string, centerView?: boolean): void;
    getSelectedPointId(): string | number | undefined;
    unselectPoint(): void;
    /** Get the currently expanded cluster */
    getExpandedCluster(): {
        id: string;
        points: Datum[];
    } | undefined;
    zoomToPointById(id: string, selectPoint?: boolean, customZoomLevel?: number): void;
    getNodeRelativePosition(node: LeafletMapPoint<Datum>): {
        x: number;
        y: number;
    };
    hasBeenZoomed(): boolean;
    hasBeenMoved(): boolean;
    isZooming(): boolean;
    isMoving(): boolean;
    private _flyToBounds;
    private _renderData;
    private _zoomToExternallySelectedPoint;
    private _expandCluster;
    private _resetExpandedCluster;
    private _getPointData;
    private _getMapZoomState;
    private _onMapDragLeaflet;
    private _onMapMove;
    private _onMapMoveStart;
    private _onMapMoveEnd;
    private _onMapZoomStart;
    private _onMapZoomEnd;
    private _onMapZoom;
    private _onBackgroundClick;
    private _onPointClick;
    private _onPointMouseDown;
    private _onPointMouseUp;
    zoomIn(increment?: number): void;
    zoomOut(increment?: number): void;
    setZoom(zoomLevel: number): void;
    fitView(): void;
    destroy(): void;
}
