import { Selection } from 'd3-selection';
import { ScaleLinear } from 'd3-scale';
import { ComponentCore } from "../../core/component";
import { SeriesDataModel } from "../../data-models/series";
import { NestedDonutSegment } from './types';
import { NestedDonutConfigInterface } from './config';
import * as s from './style';
export declare class NestedDonut<Datum> extends ComponentCore<Datum[], NestedDonutConfigInterface<Datum>> {
    static selectors: typeof s;
    static cssVariables: {
        nestedDonutFontFamily: "--vis-nested-donut-font-family";
        nestedDonutBackgroundColor: "--vis-nested-donut-background-color";
        nestedDonutCentralLabelFontSize: "--vis-nested-donut-central-label-font-size";
        nestedDonutCentralLabelFontWeight: "--vis-nested-donut-central-label-font-weight";
        nestedDonutCentralLabelTextColor: "--vis-nested-donut-central-label-text-color";
        nestedDonutCentralSublabelFontSize: "--vis-nested-donut-central-sublabel-font-size";
        nestedDonutCentralSublabelFontWeight: "--vis-nested-donut-central-sublabel-font-weight";
        nestedDonutCentralSublabelTextColor: "--vis-nested-donut-central-sublabel-text-color";
        nestedDonutSegmentStrokeWidth: "--vis-nested-donut-segment-stroke-width";
        nestedDonutSegmentStrokeColor: "--vis-nested-donut-segment-stroke-color";
        nestedDonutSegmentLabelTextColorLight: "--vis-nested-donut-segment-label-text-color-light";
        nestedDonutSegmentLabelTextColorDark: "--vis-nested-donut-segment-label-text-color-dark";
        nestedDonutSegmentLabelFontSize: "--vis-nested-donut-segment-label-font-size";
        darkNestedDonutBackgroundColor: "--vis-dark-nested-donut-background-color";
        darkNestedDonutCentralLabelTextColor: "--vis-dark-nested-donut-central-label-text-color";
        darkNestedDonutCentralSublabelTextColor: "--vis-dark-nested-donut-central-sublabel-text-color";
    };
    protected _defaultConfig: NestedDonutConfigInterface<Datum>;
    config: NestedDonutConfigInterface<Datum>;
    datamodel: SeriesDataModel<Datum>;
    arcBackground: Selection<SVGGElement, unknown, SVGGElement, unknown>;
    arcGroup: Selection<SVGGElement, unknown, SVGGElement, unknown>;
    centralLabel: Selection<SVGTextElement, unknown, SVGGElement, unknown>;
    centralSubLabel: Selection<SVGTextElement, unknown, SVGGElement, unknown>;
    arcGen: import("d3-shape").Arc<any, Partial<NestedDonutSegment<Datum>>>;
    colorScale: ScaleLinear<string, string>;
    events: {};
    constructor(config?: NestedDonutConfigInterface<Datum>);
    _render(customDuration?: number): void;
    private _getHierarchyData;
    private _getLayerSettings;
}
