import { Selection } from 'd3-selection';
import { Spacing } from "../../../types/spacing";
import { SankeyInputLink, SankeyInputNode, SankeyNode } from '../types';
import { SankeyConfigInterface } from '../config';
export declare function createNodes<N extends SankeyInputNode, L extends SankeyInputLink>(sel: Selection<SVGGElement, SankeyNode<N, L>, SVGGElement, unknown>, config: SankeyConfigInterface<N, L>, width: number, bleed: Spacing): void;
export declare function updateNodes<N extends SankeyInputNode, L extends SankeyInputLink>(sel: Selection<SVGGElement, SankeyNode<N, L>, SVGGElement, unknown>, config: SankeyConfigInterface<N, L>, width: number, bleed: Spacing, hasLinks: boolean, duration: number): void;
export declare function renderNodeLabels<N extends SankeyInputNode, L extends SankeyInputLink>(sel: Selection<SVGGElement, SankeyNode<N, L>, SVGGElement, unknown>, config: SankeyConfigInterface<N, L>, width: number, duration: number, enforceNodeVisibility?: SankeyNode<N, L>): void;
export declare function removeNodes<N extends SankeyInputNode, L extends SankeyInputLink>(selection: Selection<SVGGElement, SankeyNode<N, L>, SVGGElement, unknown>, config: SankeyConfigInterface<N, L>, duration: number): void;
export declare function onNodeMouseOver<N extends SankeyInputNode, L extends SankeyInputLink>(d: SankeyNode<N, L>, nodeSelection: Selection<SVGGElement, SankeyNode<N, L>, SVGGElement, unknown>, config: SankeyConfigInterface<N, L>, width: number): void;
export declare function onNodeMouseOut<N extends SankeyInputNode, L extends SankeyInputLink>(d: SankeyNode<N, L>, nodeSelection: Selection<SVGGElement, SankeyNode<N, L>, SVGGElement, unknown>, config: SankeyConfigInterface<N, L>, width: number): void;
