import { Selection } from 'd3-selection';
import { D3ZoomEvent, ZoomTransform } from 'd3-zoom';
import { ComponentCore } from "../../core/component";
import { MapGraphDataModel } from "../../data-models/map-graph";
import { MapData } from './types';
import { TopoJSONMapConfigInterface } from './config';
import * as s from './style';
export declare class TopoJSONMap<AreaDatum, PointDatum = unknown, LinkDatum = unknown> extends ComponentCore<MapData<AreaDatum, PointDatum, LinkDatum>, TopoJSONMapConfigInterface<AreaDatum, PointDatum, LinkDatum>> {
    static selectors: typeof s;
    protected _defaultConfig: TopoJSONMapConfigInterface<AreaDatum, PointDatum, LinkDatum>;
    config: TopoJSONMapConfigInterface<AreaDatum, PointDatum, LinkDatum>;
    datamodel: MapGraphDataModel<AreaDatum, PointDatum, LinkDatum>;
    g: Selection<SVGGElement, unknown, null, undefined>;
    private _firstRender;
    private _isResizing;
    private _initialScale;
    private _center;
    private _currentZoomLevel;
    private _transform;
    private _path;
    private _projection;
    private _prevWidth;
    private _prevHeight;
    private _animFrameId;
    private _featureCollection;
    private _zoomBehavior;
    private _backgroundRect;
    private _featuresGroup;
    private _linksGroup;
    private _pointsGroup;
    events: {
        [x: string]: {};
    };
    constructor(config?: TopoJSONMapConfigInterface<AreaDatum, PointDatum, LinkDatum>, data?: MapData<AreaDatum, PointDatum, LinkDatum>);
    setData(data: MapData<AreaDatum, PointDatum, LinkDatum>): void;
    setConfig(config?: TopoJSONMapConfigInterface<AreaDatum, PointDatum, LinkDatum>): void;
    _render(customDuration?: number): void;
    _renderBackground(): void;
    _renderGroups(duration: number): void;
    _renderMap(duration: number): void;
    _renderLinks(duration: number): void;
    _renderPoints(duration: number): void;
    _fitToPoints(points?: PointDatum[], pad?: number): void;
    _applyZoom(): void;
    _onResize(): void;
    _onZoom(event: D3ZoomEvent<any, any>): void;
    _onZoomHandler(transform: ZoomTransform, isMouseEvent: boolean, isExternalEvent: boolean): void;
    zoomIn(increment?: number): void;
    zoomOut(increment?: number): void;
    setZoom(zoomLevel: number): void;
    fitView(): void;
    destroy(): void;
}
