import { getNumber } from '../../utils/data.js';

function getLonLat(d, pointLongitude, pointLatitude) {
    const lat = getNumber(d, pointLatitude);
    const lon = getNumber(d, pointLongitude);
    return [lon, lat];
}
function arc(source, target, curvature) {
    if (!target || !source)
        return 'M0,0,l0,0z';
    const d = 3;
    const angleOffset = curvature || 0;
    const s = { x: source[0], y: source[1] };
    const t = { x: target[0], y: target[1] };
    const ds = { x: (t.x - s.x) / d, y: (t.y - s.y) / d };
    const dt = { x: (s.x - t.x) / d, y: (s.y - t.y) / d };
    let angle = 0.16667 * Math.PI * (1 + angleOffset);
    if (s.x < t.x)
        angle = -angle;
    const cs = Math.cos(angle);
    const ss = Math.sin(angle);
    const ct = Math.cos(-angle);
    const st = Math.sin(-angle);
    const dds = { x: (cs * ds.x) - (ss * ds.y), y: (ss * ds.x) + (cs * ds.y) };
    const ddt = { x: (ct * dt.x) - (st * dt.y), y: (st * dt.x) + (ct * dt.y) };
    return `M${s.x},${s.y} C${s.x + dds.x},${s.y + dds.y} ${t.x + ddt.x},${t.y + ddt.y} ${t.x},${t.y}`;
}

export { arc, getLonLat };
//# sourceMappingURL=utils.js.map
