import { css, injectGlobal } from '@emotion/css';
import { UNOVIS_ICON_FONT_FAMILY_DEFAULT } from '../../styles/index.js';

const root = css `
  label: vis-controls-component;
`;
const variables = injectGlobal `
  :root {
    --vis-controls-buttons-border-color: rgba(108, 119, 140, 0.15);
    --vis-controls-buttons-background-color: rgba(255, 255, 255, 1);
    --vis-controls-button-color: #6c778c;
    --vis-controls-button-icon-font: ${UNOVIS_ICON_FONT_FAMILY_DEFAULT};

    --vis-dark-controls-buttons-border-color:  #6c778c;
    --vis-dark-controls-buttons-background-color: var(--vis-color-grey);
    --vis-dark-controls-button-color: #fff;
  }

  body.theme-dark ${`.${root}`} {
    --vis-controls-buttons-border-color: var(--vis-dark-controls.buttons-border-color);
    --vis-controls-buttons-background-color: var(--vis-dark-controls-buttons-background-color);
    --vis-controls-button-color: var(--vis-dark-controls-button-color);
  }
`;
const items = css `
  label: items;
  background-color: var(--vis-controls-buttons-background-color);
  border: 1px solid var(--vis-controls-buttons-border-color);
  border-radius: 4px;
  opacity: 1;
  transition: all 300ms;
`;
const horizontalItems = css `
  label: horizontal;
  display: inline-flex;
`;
const item = css `
  label: item;
`;
const itemButton = css `
  label: item-button;
  font-family: var(--vis-controls-button-icon-font);
  display: block;
  cursor: pointer;
  user-select: none;
  outline: none;
  width: 30px;
  height: 30px;
  line-height: 28px;
  border: none;
  border-radius: inherit;
  box-sizing: border-box;
  color: var(--vis-controls-button-color);
  background-color: inherit;
`;
const borderLeft = css `
  border-left: 1px solid var(--vis-controls-buttons-border-color);
`;
const borderTop = css `
  border-top: 1px solid var(--vis-controls-buttons-border-color);
`;
const borderRight = css `
  border-right: 1px solid var(--vis-controls-buttons-border-color);
`;
const borderBottom = css `
  border-bottom: 1px solid var(--vis-controls-buttons-border-color);
`;
const disabled = css `
  label: disabled;
  opacity: 0.4;
  pointer-events: none;
`;

export { borderBottom, borderLeft, borderRight, borderTop, disabled, horizontalItems, item, itemButton, items, root, variables };
//# sourceMappingURL=style.js.map
