import { throttle as _throttle } from 'throttle-debounce';
import { NumericAccessor, StringAccessor, BooleanAccessor, ColorAccessor, GenericAccessor } from "../types/accessor";
import { StackValuesRecord } from "../types/data";
export declare const isNumber: <T>(a: T) => a is T extends number ? T : never;
export declare const isFunction: <T>(a: T) => a is T extends Function ? T : never;
export declare const isUndefined: <T>(a: T) => a is T extends undefined ? T : never;
export declare const isNil: <T>(a: T) => a is null;
export declare const isString: <T>(a: T) => a is T extends string ? T : never;
export declare const isArray: <T>(a: T) => a is T extends any[] ? T : never;
export declare const isObject: <T>(a: T) => boolean;
export declare const isAClassInstance: <T>(a: T) => boolean;
export declare const isPlainObject: <T>(a: T) => boolean;
export declare const isEmpty: <T>(obj: T) => boolean;
export declare const isEqual: (a?: unknown | null, b?: unknown | null, visited?: Set<any>) => boolean;
export declare const without: <T>(arr: T[], ...args: T[]) => T[];
export declare const flatten: <T>(arr: (T | T[])[]) => T[];
export declare const cloneDeep: <T>(obj: T, stack?: Map<any, any>) => T;
export declare const merge: <T, K>(obj1: T, obj2: K, visited?: Map<any, any>) => T & K;
export declare const omit: <T extends Record<string | number | symbol, unknown>>(obj: T, props: (keyof T)[]) => Partial<T>;
export declare const groupBy: <T extends Record<string | number, any>>(arr: T[], accessor: (a: T) => string | number) => Record<string | number, T[]>;
export declare const sortBy: <T>(arr: T[], accessor: (a: T) => string | number) => T[];
export declare const throttle: <T extends (...args: any[]) => any>(f: T, delay: number, options?: {
    noTrailing?: boolean;
    noLeading?: boolean;
    debounceMode?: boolean;
}) => _throttle<T>;
export declare function getValue<T, ReturnType>(d: T, accessor: NumericAccessor<T> | StringAccessor<T> | BooleanAccessor<T> | ColorAccessor<T> | GenericAccessor<ReturnType, T>, index?: number): ReturnType;
export declare function getString<T>(d: T, accessor: StringAccessor<T>, i?: number): string | null | undefined;
export declare function getNumber<T>(d: T, accessor: NumericAccessor<T>, i?: number): number | null | undefined;
export declare function getBoolean<T>(d: T, accessor: BooleanAccessor<T>, i?: number): boolean | null | undefined;
export declare function clean<T>(data: T[]): T[];
export declare function clamp(d: number, min: number, max: number): number;
export declare function unique<T>(array: T[]): T[];
export declare function countUnique<T>(array: T[], accessor?: (d: unknown) => unknown): number;
export declare function arrayOfIndices(n: number): number[];
export declare function shallowDiff(o1?: Record<string, unknown>, o2?: Record<string, unknown>): Record<string, unknown>;
export declare function getStackedExtent<Datum>(data: Datum[], ...acs: NumericAccessor<Datum>[]): (number | undefined)[];
export declare function getStackedValues<Datum>(d: Datum, index: number, ...acs: NumericAccessor<Datum>[]): (number | undefined)[];
export declare function getStackedData<Datum>(data: Datum[], baseline: NumericAccessor<Datum>, acs: NumericAccessor<Datum>[], prevNegative?: boolean[]): StackValuesRecord[];
export declare function getMin<Datum>(data: Datum[], ...acs: NumericAccessor<Datum>[]): number | undefined;
export declare function getMax<Datum>(data: Datum[], ...acs: NumericAccessor<Datum>[]): number | undefined;
export declare function getExtent<Datum>(data: Datum[], ...acs: NumericAccessor<Datum>[]): (number | undefined)[];
export declare function getNearest<Datum>(data: Datum[], value: number, accessor: NumericAccessor<Datum>): Datum;
export declare function filterDataByRange<Datum>(data: Datum[], range: [number, number], accessor: NumericAccessor<Datum>): Datum[];
export declare function isNumberWithinRange(value: number, range: [number, number]): boolean;
