import { Graph, GraphInputNode, GraphInputLink } from '@unovis/ts';
export declare const VisGraphSelectors: {
    root: string;
    background: string;
    node: string;
    nodeShape: string;
    nodeGauge: string;
    nodeSideLabel: string;
    nodeLabel: string;
    dimmedNode: string;
    link: string;
    linkLine: string;
    dimmedLink: string;
    panel: string;
    panelRect: string;
    panelSelection: string;
    panelLabel: string;
    panelLabelText: string;
    panelSideIcon: string;
    panelSideIconShape: string;
    panelSideIconSymbol: string;
};
declare const _default: <N extends GraphInputNode, L extends GraphInputLink>(__VLS_props: any, __VLS_ctx?: {
    attrs: any;
    emit: any;
    slots: any;
}, __VLS_expose?: any, __VLS_setup?: Promise<{
    props: {
        duration?: number;
        events?: {
            [selector: string]: {
                touchstart?: import("@unovis/ts").VisEventCallback<any>;
                touchmove?: import("@unovis/ts").VisEventCallback<any>;
                touchend?: import("@unovis/ts").VisEventCallback<any>;
                mouseover?: import("@unovis/ts").VisEventCallback<any>;
                mousemove?: import("@unovis/ts").VisEventCallback<any>;
                mousedown?: import("@unovis/ts").VisEventCallback<any>;
                mouseup?: import("@unovis/ts").VisEventCallback<any>;
                click?: import("@unovis/ts").VisEventCallback<any>;
                auxclick?: import("@unovis/ts").VisEventCallback<any>;
                contextmenu?: import("@unovis/ts").VisEventCallback<any>;
                dblclick?: import("@unovis/ts").VisEventCallback<any>;
                mouseenter?: import("@unovis/ts").VisEventCallback<any>;
                mouseleave?: import("@unovis/ts").VisEventCallback<any>;
                mouseout?: import("@unovis/ts").VisEventCallback<any>;
                scroll?: import("@unovis/ts").VisEventCallback<any>;
                select?: import("@unovis/ts").VisEventCallback<any>;
                wheel?: import("@unovis/ts").VisEventCallback<any>;
                pointerdown?: import("@unovis/ts").VisEventCallback<any>;
                pointerup?: import("@unovis/ts").VisEventCallback<any>;
                pointerout?: import("@unovis/ts").VisEventCallback<any>;
                pointermove?: import("@unovis/ts").VisEventCallback<any>;
            };
        };
        attributes?: {
            [selector: string]: {
                [attr: string]: string | number | boolean | ((datum: any) => string | number | boolean);
            };
        };
        data?: {
            nodes: N[];
            links?: L[];
        };
        nodeLabel?: import("@unovis/ts").StringAccessor<N>;
        zoomScaleExtent?: [number, number];
        disableZoom?: boolean;
        disableDrag?: boolean;
        disableBrush?: boolean;
        zoomThrottledUpdateNodeThreshold?: number;
        layoutType?: string;
        layoutAutofit?: boolean;
        layoutAutofitTolerance?: number;
        layoutNonConnectedAside?: boolean;
        layoutNodeGroup?: import("@unovis/ts").StringAccessor<N>;
        layoutGroupOrder?: string[];
        layoutParallelNodesPerColumn?: number;
        layoutParallelNodeSubGroup?: import("@unovis/ts").StringAccessor<N>;
        layoutParallelSubGroupsPerRow?: number;
        layoutParallelGroupSpacing?: number;
        layoutParallelSortConnectionsByGroup?: string;
        forceLayoutSettings?: import("@unovis/ts").GraphForceLayoutSettings<N, L>;
        dagreLayoutSettings?: import("@unovis/ts").GraphDagreLayoutSetting;
        layoutElkSettings?: import("@unovis/ts").GenericAccessor<import("@unovis/ts").GraphElkLayoutSettings, string>;
        layoutElkNodeGroups?: import("@unovis/ts").StringAccessor<N>[];
        linkWidth?: import("@unovis/ts").NumericAccessor<L>;
        linkStyle?: import("@unovis/ts").GenericAccessor<import("@unovis/ts").GraphLinkStyle, L>;
        linkBandWidth?: import("@unovis/ts").NumericAccessor<L>;
        linkArrow?: import("@unovis/ts").GenericAccessor<string | boolean, L>;
        linkStroke?: import("@unovis/ts").ColorAccessor<L>;
        linkDisabled?: import("@unovis/ts").BooleanAccessor<L>;
        linkFlow?: import("@unovis/ts").BooleanAccessor<L>;
        linkFlowAnimDuration?: number;
        linkFlowParticleSize?: number;
        linkLabel?: import("@unovis/ts").GenericAccessor<import("@unovis/ts").GraphCircleLabel, L>;
        linkLabelShiftFromCenter?: import("@unovis/ts").BooleanAccessor<L>;
        linkNeighborSpacing?: number;
        linkCurvature?: import("@unovis/ts").NumericAccessor<L>;
        selectedLinkId?: string | number;
        nodeSize?: import("@unovis/ts").NumericAccessor<N>;
        nodeStrokeWidth?: import("@unovis/ts").NumericAccessor<N>;
        nodeShape?: import("@unovis/ts").GenericAccessor<string, N>;
        nodeGaugeValue?: import("@unovis/ts").NumericAccessor<N>;
        nodeGaugeFill?: import("@unovis/ts").ColorAccessor<N>;
        nodeGaugeAnimDuration?: number;
        nodeIcon?: import("@unovis/ts").StringAccessor<N>;
        nodeIconSize?: import("@unovis/ts").NumericAccessor<N>;
        nodeLabelTrim?: import("@unovis/ts").BooleanAccessor<N>;
        nodeLabelTrimMode?: import("@unovis/ts").GenericAccessor<string, N>;
        nodeLabelTrimLength?: import("@unovis/ts").NumericAccessor<N>;
        nodeSubLabel?: import("@unovis/ts").StringAccessor<N>;
        nodeSubLabelTrim?: import("@unovis/ts").BooleanAccessor<N>;
        nodeSubLabelTrimMode?: import("@unovis/ts").GenericAccessor<string, N>;
        nodeSubLabelTrimLength?: import("@unovis/ts").NumericAccessor<N>;
        nodeSideLabels?: import("@unovis/ts").GenericAccessor<import("@unovis/ts").GraphCircleLabel[], N>;
        nodeBottomIcon?: import("@unovis/ts").StringAccessor<N>;
        nodeDisabled?: import("@unovis/ts").BooleanAccessor<N>;
        nodeFill?: import("@unovis/ts").ColorAccessor<N>;
        nodeStroke?: import("@unovis/ts").ColorAccessor<N>;
        nodeSort?: (a: N, b: N) => number;
        nodeEnterPosition?: import("@unovis/ts").GenericAccessor<[number, number], N>;
        nodeEnterScale?: import("@unovis/ts").NumericAccessor<N>;
        nodeExitPosition?: import("@unovis/ts").GenericAccessor<[number, number], N>;
        nodeExitScale?: import("@unovis/ts").NumericAccessor<N>;
        selectedNodeId?: string | number;
        selectedNodeIds?: string[] | number[];
        panels?: import("@unovis/ts").GraphPanelConfig[];
        onNodeDragStart?: (n: import("@unovis/ts").GraphNode<N, L>, event: import("d3-drag").D3DragEvent<SVGGElement, import("@unovis/ts").GraphNode<N, L>, unknown>) => void;
        onNodeDrag?: (n: import("@unovis/ts").GraphNode<N, L>, event: import("d3-drag").D3DragEvent<SVGGElement, import("@unovis/ts").GraphNode<N, L>, unknown>) => void;
        onNodeDragEnd?: (n: import("@unovis/ts").GraphNode<N, L>, event: import("d3-drag").D3DragEvent<SVGGElement, import("@unovis/ts").GraphNode<N, L>, unknown>) => void;
        onZoom?: (zoomScale: number, zoomScaleExtent: [number, number], event: import("d3-zoom").D3ZoomEvent<SVGGElement, unknown>) => void;
        onLayoutCalculated?: (n: import("@unovis/ts").GraphNode<N, L>[], links: import("@unovis/ts").GraphLink<N, L>[]) => void;
        onNodeSelectionBrush?: (selectedNodes: import("@unovis/ts").GraphNode<N, L>[], event: import("d3-brush").D3BrushEvent<SVGGElement>) => void;
        onNodeSelectionDrag?: (selectedNodes: import("@unovis/ts").GraphNode<N, L>[], event: import("d3-drag").D3DragEvent<SVGGElement, import("@unovis/ts").GraphNode<N, L>, unknown>) => void;
    } & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps;
    expose(exposed: import("vue").ShallowUnwrapRef<{
        component: import("vue").Ref<Graph<N, L>>;
    }>): void;
    attrs: any;
    slots: {};
    emit: any;
}>) => import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
    [key: string]: any;
}> & {
    __ctx?: any;
};
export default _default;
