import { Ref, SlotsType, VNode } from 'vue';

export interface PresenceProps {
    /**
     * Conditional to mount or unmount the child element. Similar to `v-if`
     *
     * @required true
     */
    present: boolean;
    /**
     * Force the first child element to render all the time.
     * Useful for programmatically render grandchild component together with the exposed `present`
     *
     * @defaultValue false
     */
    forceMount?: boolean;
}
declare const _default: import('vue').DefineComponent<{
    present: {
        type: BooleanConstructor;
        required: true;
    };
    forceMount: {
        type: BooleanConstructor;
    };
}, () => VNode<import('vue').RendererNode, import('vue').RendererElement, {
    [key: string]: any;
}> | null, unknown, {}, {}, import('vue').ComponentOptionsMixin, import('vue').ComponentOptionsMixin, {}, string, import('vue').PublicProps, Readonly<import('vue').ExtractPropTypes<{
    present: {
        type: BooleanConstructor;
        required: true;
    };
    forceMount: {
        type: BooleanConstructor;
    };
}>>, {
    forceMount: boolean;
}, SlotsType<{
    default: (opts: {
        present: Ref<boolean>;
    }) => any;
}>>;
export default _default;
