import { EntryExitPropsType } from '../base/props/entry-exit-props-type';
declare const _default: import("vue").DefineComponent<{
    /**
     * Specifies the duration of the transition in milliseconds.
     * Also accepts separate values for enter and leave durations `e.g { enter: 500, leave: 800 }`
     */
    duration: {
        type: (ObjectConstructor | NumberConstructor)[];
        default: number;
    };
    /**
     * The entry style animation type.
     * Accepts `center` `left`
     */
    entry: {
        type: StringConstructor;
        default: string;
        validator: (value: string) => boolean;
    };
    /**
     * The exit style animation type.
     * Accepts `center` `left` `right` `top` `bottom`
     */
    exit: {
        type: StringConstructor;
        default: string;
        validator: (value: string) => boolean;
    };
    /**
     * Whether to apply the transition on initial render.
     */
    appear: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * Controls the timing sequence of leaving/entering transitions.
     * Accepts `out-in` or `in-out`
     * Required when used with router-view.
     * Only exposed when group is false
     */
    mode: {
        type: StringConstructor;
        required: false;
        validator: (value: string) => boolean;
    };
    /**
     * Whether transition effects are for multiple elements/components.
     * Every child in a group must be uniquely keyed for the animations to work properly.
     */
    group: {
        type: BooleanConstructor;
        required: false;
    };
    /**
     * If not defined, renders without a root element.
     * Only usable if group is true.
     */
    tag: {
        type: StringConstructor;
        required: false;
    };
    /**
     * Speed up transitions by skipping hooks.
     * Only to be used if elements are show/hidden, e.g v-show.
     * Does not work if elements are inserted/removed, e.g v-if
     */
    persisted: {
        type: BooleanConstructor;
        required: false;
    };
}, {
    props: EntryExitPropsType;
    transitionType: import("vue").Ref<string>;
    transitionName: import("vue").ComputedRef<string>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    duration: number;
    entry: string;
    exit: string;
    appear: boolean;
    group: boolean;
    persisted: boolean;
} & {
    mode?: string | undefined;
    tag?: string | undefined;
}>, {
    duration: number;
    entry: string;
    exit: string;
    appear: boolean;
    group: boolean;
    persisted: boolean;
}>;
export default _default;
