import { s as script$1 } from './base-transition-component-0a42ebdc.js';
import { defineComponent, ref, computed, resolveComponent, openBlock, createBlock, mergeProps, withCtx, renderSlot } from 'vue';
import { s as styleInject } from './style-inject.es-1f59c1d0.js';

var script = defineComponent({
  name: 'fade-in-out',
  components: {
    BaseTransitionComponent: script$1
  },
  props: {
    /**
     * Specifies the duration of the transition in milliseconds.
     * Also accepts separate values for enter and leave durations `e.g { enter: 500, leave: 800 }`
     */
    duration: {
      type: [Number, Object],
      "default": 500
    },

    /**
     * The entry style animation type.
     * Accepts `center` `left`
     */
    entry: {
      type: String,
      "default": 'center',
      validator: function validator(value) {
        return ['center', 'left'].includes(value);
      }
    },

    /**
     * The exit style animation type.
     * Accepts `center` `left` `right` `top` `bottom`
     */
    exit: {
      type: String,
      "default": 'center',
      validator: function validator(value) {
        return ['center', 'left', 'right', 'top', 'bottom'].includes(value);
      }
    },

    /**
     * Whether to apply the transition on initial render.
     */
    appear: {
      type: Boolean,
      required: false
    },

    /**
     * Controls the timing sequence of leaving/entering transitions.
     * Accepts `out-in` or `in-out`
     * Required when used with router-view.
     * Only exposed when group is false
     */
    mode: {
      type: String,
      required: false,
      validator: function validator(value) {
        return ['out-in', 'in-out'].includes(value);
      }
    },

    /**
     * Whether transition effects are for multiple elements/components.
     * Every child in a group must be uniquely keyed for the animations to work properly.
     */
    group: {
      type: Boolean,
      required: false
    },

    /**
     * If not defined, renders without a root element.
     * Only usable if group is true.
     */
    tag: {
      type: String,
      required: false
    },

    /**
     * Speed up transitions by skipping hooks.
     * Only to be used if elements are show/hidden, e.g v-show.
     * Does not work if elements are inserted/removed, e.g v-if
     */
    persisted: {
      type: Boolean,
      required: false
    }
  },
  setup: function setup(props) {
    var transitionType = ref('fio'); // FadeInOut

    var firstChar = function firstChar(type) {
      return type.substring(0, 1);
    };

    var transitionName = computed(function () {
      return "vt_" + transitionType.value + "-" + firstChar(props.entry) + "-" + firstChar(props.exit);
    });
    return {
      props: props,
      transitionType: transitionType,
      transitionName: transitionName
    };
  }
});

function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_BaseTransitionComponent = resolveComponent("BaseTransitionComponent");

  return openBlock(), createBlock(_component_BaseTransitionComponent, mergeProps(_ctx.props, {
    name: _ctx.transitionName
  }), {
    "default": withCtx(function () {
      return [renderSlot(_ctx.$slots, "default")];
    }),
    _: 3
  }, 16, ["name"]);
}

var css_248z = ".vt_fio-c-c-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-c-enter-from,.vt_fio-c-c-leave-to{opacity:0;-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-c-enter-to,.vt_fio-c-c-leave-from{opacity:1}.vt_fio-c-l-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-l-enter-from,.vt_fio-c-l-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-c-l-enter-to,.vt_fio-c-l-leave-from{opacity:1}.vt_fio-c-r-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-r-enter-from,.vt_fio-c-r-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(10%,0,0);transform:translate3d(10%,0,0)}.vt_fio-c-r-enter-to,.vt_fio-c-r-leave-from{opacity:1}.vt_fio-c-t-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-t-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(0,-10%,0);transform:translate3d(0,-10%,0)}.vt_fio-c-t-enter-from{opacity:0}.vt_fio-c-t-enter-to,.vt_fio-c-t-leave-from{opacity:1}.vt_fio-c-b-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-b-enter-from,.vt_fio-c-b-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(0,10%,0);transform:translate3d(0,10%,0)}.vt_fio-c-b-enter-to,.vt_fio-c-b-leave-from{opacity:1}.vt_fio-l-c-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-c-enter-active,.vt_fio-l-c-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-c-enter-from,.vt_fio-l-c-leave-to{opacity:0}.vt_fio-l-c-enter-to,.vt_fio-l-c-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-l-enter-active,.vt_fio-l-l-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-l-enter-from,.vt_fio-l-l-leave-to{opacity:0}.vt_fio-l-l-enter-to,.vt_fio-l-l-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-r-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-r-enter-active,.vt_fio-l-r-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-r-leave-to{opacity:0;-webkit-transform:translate3d(10%,0,0);transform:translate3d(10%,0,0)}.vt_fio-l-r-enter-from{opacity:0}.vt_fio-l-r-enter-to,.vt_fio-l-r-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-t-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-t-enter-active,.vt_fio-l-t-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-t-leave-to{opacity:0;-webkit-transform:translate3d(0,-10%,0);transform:translate3d(0,-10%,0)}.vt_fio-l-t-enter-from{opacity:0}.vt_fio-l-t-enter-to,.vt_fio-l-t-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-b-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-b-enter-active,.vt_fio-l-b-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-b-leave-to{opacity:0;-webkit-transform:translate3d(0,10%,0);transform:translate3d(0,10%,0)}.vt_fio-l-b-enter-from{opacity:0}.vt_fio-l-b-enter-to,.vt_fio-l-b-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}";
var stylesheet = ".vt_fio-c-c-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-c-enter-from,.vt_fio-c-c-leave-to{opacity:0;-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-c-enter-to,.vt_fio-c-c-leave-from{opacity:1}.vt_fio-c-l-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-l-enter-from,.vt_fio-c-l-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-c-l-enter-to,.vt_fio-c-l-leave-from{opacity:1}.vt_fio-c-r-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-r-enter-from,.vt_fio-c-r-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(10%,0,0);transform:translate3d(10%,0,0)}.vt_fio-c-r-enter-to,.vt_fio-c-r-leave-from{opacity:1}.vt_fio-c-t-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-t-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(0,-10%,0);transform:translate3d(0,-10%,0)}.vt_fio-c-t-enter-from{opacity:0}.vt_fio-c-t-enter-to,.vt_fio-c-t-leave-from{opacity:1}.vt_fio-c-b-enter-active{-webkit-transition:opacity ease-in;-o-transition:opacity ease-in;transition:opacity ease-in}.vt_fio-c-b-enter-from,.vt_fio-c-b-leave-to{opacity:0;-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(0,10%,0);transform:translate3d(0,10%,0)}.vt_fio-c-b-enter-to,.vt_fio-c-b-leave-from{opacity:1}.vt_fio-l-c-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-c-enter-active,.vt_fio-l-c-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-c-enter-from,.vt_fio-l-c-leave-to{opacity:0}.vt_fio-l-c-enter-to,.vt_fio-l-c-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-l-enter-active,.vt_fio-l-l-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-l-enter-from,.vt_fio-l-l-leave-to{opacity:0}.vt_fio-l-l-enter-to,.vt_fio-l-l-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-r-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-r-enter-active,.vt_fio-l-r-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-r-leave-to{opacity:0;-webkit-transform:translate3d(10%,0,0);transform:translate3d(10%,0,0)}.vt_fio-l-r-enter-from{opacity:0}.vt_fio-l-r-enter-to,.vt_fio-l-r-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-t-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-t-enter-active,.vt_fio-l-t-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-t-leave-to{opacity:0;-webkit-transform:translate3d(0,-10%,0);transform:translate3d(0,-10%,0)}.vt_fio-l-t-enter-from{opacity:0}.vt_fio-l-t-enter-to,.vt_fio-l-t-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_fio-l-b-enter-active{-webkit-transform:translate3d(-10%,0,0);transform:translate3d(-10%,0,0)}.vt_fio-l-b-enter-active,.vt_fio-l-b-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_fio-l-b-leave-to{opacity:0;-webkit-transform:translate3d(0,10%,0);transform:translate3d(0,10%,0)}.vt_fio-l-b-enter-from{opacity:0}.vt_fio-l-b-enter-to,.vt_fio-l-b-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}";
styleInject(css_248z);

script.render = render;

export { script as FadeInOut };
