import { s as script$1 } from './base-transition-component-0a42ebdc.js';
import { defineComponent, ref, computed, resolveComponent, openBlock, createBlock, mergeProps, withCtx, renderSlot } from 'vue';
import { s as styleInject } from './style-inject.es-1f59c1d0.js';

var script = defineComponent({
  name: 'slide-in-out',
  components: {
    BaseTransitionComponent: script$1
  },
  props: {
    /**
     * Specifies the duration of the transition in milliseconds.
     * Also accepts separate values for enter and leave durations `e.g { enter: 500, leave: 800 }`
     */
    duration: {
      type: [Number, Object],
      "default": 500
    },

    /**
     * The entry style animation type.
     * Accepts `left` `right`
     */
    entry: {
      type: String,
      "default": 'left',
      validator: function validator(value) {
        return ['left', 'right'].includes(value);
      }
    },

    /**
     * The exit style animation type.
     * Accepts left` `right` `top` `bottom`
     */
    exit: {
      type: String,
      "default": 'left',
      validator: function validator(value) {
        return ['left', 'right', 'top', 'bottom'].includes(value);
      }
    },

    /**
     * Whether to apply the transition on initial render.
     */
    appear: {
      type: Boolean,
      required: false
    },

    /**
     * Controls the timing sequence of leaving/entering transitions.
     * Accepts `out-in` or `in-out`
     * Required when used with router-view.
     * Only exposed when group is false
     */
    mode: {
      type: String,
      required: false,
      validator: function validator(value) {
        return ['out-in', 'in-out'].includes(value);
      }
    },

    /**
     * Whether transition effects are for multiple elements/components.
     * Every child in a group must be uniquely keyed for the animations to work properly.
     */
    group: {
      type: Boolean,
      required: false
    },

    /**
     * If not defined, renders without a root element.
     * Only usable if group is true.
     */
    tag: {
      type: String,
      required: false
    },

    /**
     * Speed up transitions by skipping hooks.
     * Only to be used if elements are show/hidden, e.g v-show.
     * Does not work if elements are inserted/removed, e.g v-if
     */
    persisted: {
      type: Boolean,
      required: false
    }
  },
  setup: function setup(props) {
    var transitionType = ref('sio'); // SlideInOut

    var firstChar = function firstChar(type) {
      return type.substring(0, 1);
    };

    var transitionName = computed(function () {
      return "vt_" + transitionType.value + "-" + firstChar(props.entry) + "-" + firstChar(props.exit);
    });
    return {
      props: props,
      transitionType: transitionType,
      transitionName: transitionName
    };
  }
});

function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_BaseTransitionComponent = resolveComponent("BaseTransitionComponent");

  return openBlock(), createBlock(_component_BaseTransitionComponent, mergeProps(_ctx.props, {
    name: _ctx.transitionName
  }), {
    "default": withCtx(function () {
      return [renderSlot(_ctx.$slots, "default")];
    }),
    _: 3
  }, 16, ["name"]);
}

var css_248z = ".vt_sio-l-r-enter-active{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-r-enter-active,.vt_sio-l-r-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-l-r-leave-to{opacity:0;-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-l-r-enter-from{opacity:0}.vt_sio-l-r-enter-to,.vt_sio-l-r-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-l-l-enter-active,.vt_sio-l-l-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-l-enter-from,.vt_sio-l-l-leave-to{opacity:0}.vt_sio-l-l-enter-to,.vt_sio-l-l-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-l-t-enter-active{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-t-enter-active,.vt_sio-l-t-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-l-t-leave-to{opacity:0;-webkit-transform:translate3d(0,-100%,0);transform:translate3d(0,-100%,0)}.vt_sio-l-t-enter-from{opacity:0}.vt_sio-l-t-enter-to,.vt_sio-l-t-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-l-b-enter-active{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-b-enter-active,.vt_sio-l-b-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-l-b-leave-to{opacity:0;-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0)}.vt_sio-l-b-enter-from{opacity:0}.vt_sio-l-b-enter-to,.vt_sio-l-b-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-r-enter-active,.vt_sio-r-r-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-r-enter-from,.vt_sio-r-r-leave-to{opacity:0}.vt_sio-r-r-enter-to,.vt_sio-r-r-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-l-enter-active{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-l-enter-active,.vt_sio-r-l-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-r-l-leave-to{opacity:0;-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-r-l-enter-from{opacity:0}.vt_sio-r-l-enter-to,.vt_sio-r-l-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-t-enter-active{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-t-enter-active,.vt_sio-r-t-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-r-t-leave-to{opacity:0;-webkit-transform:translate3d(0,-100%,0);transform:translate3d(0,-100%,0)}.vt_sio-r-t-enter-from{opacity:0}.vt_sio-r-t-enter-to,.vt_sio-r-t-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-b-enter-active{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-b-enter-active,.vt_sio-r-b-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-r-b-leave-to{opacity:0;-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0)}.vt_sio-r-b-enter-from{opacity:0}.vt_sio-r-b-enter-to,.vt_sio-r-b-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}";
var stylesheet = ".vt_sio-l-r-enter-active{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-r-enter-active,.vt_sio-l-r-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-l-r-leave-to{opacity:0;-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-l-r-enter-from{opacity:0}.vt_sio-l-r-enter-to,.vt_sio-l-r-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-l-l-enter-active,.vt_sio-l-l-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-l-enter-from,.vt_sio-l-l-leave-to{opacity:0}.vt_sio-l-l-enter-to,.vt_sio-l-l-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-l-t-enter-active{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-t-enter-active,.vt_sio-l-t-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-l-t-leave-to{opacity:0;-webkit-transform:translate3d(0,-100%,0);transform:translate3d(0,-100%,0)}.vt_sio-l-t-enter-from{opacity:0}.vt_sio-l-t-enter-to,.vt_sio-l-t-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-l-b-enter-active{-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-l-b-enter-active,.vt_sio-l-b-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-l-b-leave-to{opacity:0;-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0)}.vt_sio-l-b-enter-from{opacity:0}.vt_sio-l-b-enter-to,.vt_sio-l-b-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-r-enter-active,.vt_sio-r-r-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in;-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-r-enter-from,.vt_sio-r-r-leave-to{opacity:0}.vt_sio-r-r-enter-to,.vt_sio-r-r-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-l-enter-active{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-l-enter-active,.vt_sio-r-l-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-r-l-leave-to{opacity:0;-webkit-transform:translate3d(-100%,0,0);transform:translate3d(-100%,0,0)}.vt_sio-r-l-enter-from{opacity:0}.vt_sio-r-l-enter-to,.vt_sio-r-l-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-t-enter-active{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-t-enter-active,.vt_sio-r-t-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-r-t-leave-to{opacity:0;-webkit-transform:translate3d(0,-100%,0);transform:translate3d(0,-100%,0)}.vt_sio-r-t-enter-from{opacity:0}.vt_sio-r-t-enter-to,.vt_sio-r-t-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}.vt_sio-r-b-enter-active{-webkit-transform:translate3d(100%,0,0);transform:translate3d(100%,0,0)}.vt_sio-r-b-enter-active,.vt_sio-r-b-leave-to{-webkit-transition:all ease-in;-o-transition:all ease-in;transition:all ease-in}.vt_sio-r-b-leave-to{opacity:0;-webkit-transform:translate3d(0,100%,0);transform:translate3d(0,100%,0)}.vt_sio-r-b-enter-from{opacity:0}.vt_sio-r-b-enter-to,.vt_sio-r-b-leave-from{opacity:1;-webkit-transform:translateZ(0);transform:translateZ(0)}";
styleInject(css_248z);

script.render = render;

export { script as SlideInOut };
