import axios, { GenericAbortSignal } from "axios";
import { ContactUsFormsSubmission } from "@/typings/contactUsForms-submissions"
import { useErrorHandling } from "@/modules/core/composables";

export const getContactUsFormsSubmissions = async (
    page_number: number,
    page_size: number,
    signal?:GenericAbortSignal
) => {
    const request = axios.get<ContactUsFormsSubmission>(
        '/api/backoffice/form-submissions', 
        {
            params: { page_number, page_size },
            signal
        }
    )

    const response = await useErrorHandling(request)

    return response.data
}