import { useErrorHandling } from "@/modules/core/composables";
import type { CountrySDGProgressGoalItem } from "@/typings";
import axios from "axios";
import type { GenericAbortSignal } from 'axios'

export const getCountrySdgProgress = async (countryCode: string, signal?: GenericAbortSignal) => {
    const request = axios.get<CountrySDGProgressGoalItem[]>('/api/data-points/sdg-progress-tracker', {
        params: { country: countryCode },
        signal
    })

    const response = await useErrorHandling(request)

    return response.data
}