import { useErrorHandling } from "@/modules/core/composables";
import axios, { GenericAbortSignal } from "axios";

// /api/excel/escap-data-sources
export const uploadESCAPDataSources = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/escap-data-sources', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/goal-data
export const uploadGoalData = async (file: File, country_code: string, year: number, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/goal-data', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        params: { country_code, year},
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/sdg-data-availability
export const uploadSDGDataAvailability = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/sdg-data-availability', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/sdg-performers
export const uploadSDGPerformers = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/sdg-performers', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/sdg-performers-summary
export const uploadSDGPerformersSummary = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/sdg-performers-summary', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/indices-goal
export const uploadIndicesGoal = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/indices-goal', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/indices-target
export const uploadIndicesTarget = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/indices-target', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}

// /api/excel/indices-indicator
export const uploadIndicesIndicator = async (file: File, signal?:GenericAbortSignal) => {
    const formData = new FormData();
    formData.append('file', file);
    
    const request = axios.post('/api/excel/indices-indicator', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        signal,
    });
    return await useErrorHandling(request);
}