import './assets/fonts.css';
import './assets/css/backoffice.scss';

import { createApp } from 'vue';
import ContactUsListing from './modules/backoffice/ContactUsListing.vue';
import UpdateDataPool from './modules/backoffice/UpdateDataPool.vue';
import WebsiteSettings from './modules/backoffice/WebsiteSettings.vue';

const apps = [
    { component: ContactUsListing, selector: '#contactUs-app' },
    { component: UpdateDataPool, selector: '#updateDataPool-app' },
    { component: WebsiteSettings, selector: '#websiteSettings-app' },
];

apps.forEach(({ component, selector }) => {
    const container = document.querySelector(selector);
    if (container) {
        createApp(component).mount(selector);
    }
});
