import { defineStore } from "pinia";
import axios from "axios";
import { NationalDropdownData } from "../types";
import { useErrorHandling } from "@/modules/core/composables";

export const useNationalDropdownStore = defineStore('.national-dropdown', {
    state: () => ({
        selectedCountry: '',
        countriesData: [] as Array<NationalDropdownData>|null
    }),
    getters: {
        getFirstCountry: (state) => {
            return state.countriesData?.[0]?.isoCode || undefined
        },
        getSelectedCountry: (state) => {
            return state.selectedCountry
        }
    },
    actions: {
        async getCountries () {
            const request = axios.get<NationalDropdownData[]>(
                `/api/countries`
            )

            const response = await useErrorHandling(request);

            this.$patch({
                countriesData: response.data
            })
        },
        async setSelectedCountry(country: string) {
            this.selectedCountry = country;
        },
    }
})