import { defineStore } from "pinia";
import axios from "axios";
import { useErrorHandling } from "@/modules/core/composables";
import { RegionDropdownData } from "../types";

export const useRegionalDropdownStore = defineStore('regional-dropdown', {
    state: () => ({
        selectedRegionName: '',
        selectedRegionIsoCode: '',
        regionData: [] as Array<RegionDropdownData> | null
    }),
    getters: {
        getFirstRegion: (state) => {
            return state.regionData?.[0]?.countryGroups?.[0]?.isoCode || null;
        },
        getSelectedRegionName: (state) => {
            return state.selectedRegionName;
        },
        getSelectedRegionIsoCode: (state) => {
            return state.selectedRegionIsoCode;
        },
    },
    actions: {
        async getRegionDropdown() {
            const request = axios.get<RegionDropdownData[]>('/api/regions');
            const response = await useErrorHandling(request);

            this.$patch({
                regionData: response.data
            });
        },
        async setSelectedRegion(regionIsoCode: string) {
            const selectedRegion = this.regionData
                ?.flatMap(region => region.countryGroups || [])
                .find(group => group.isoCode === regionIsoCode);

            if (selectedRegion) {
                this.$patch({
                    selectedRegionName: selectedRegion.name,
                    selectedRegionIsoCode: selectedRegion.isoCode,
                });
            } else {
                this.$patch({
                    selectedRegionName: '',
                    selectedRegionIsoCode: '',
                });
            }
        }
    }
});
