import { defineStore } from "pinia";
import axios from "axios";
import { SnapshotData, SnapshotDetailsData } from "../types";
import { useErrorHandling } from "@/modules/core/composables";

export const useRegionalSnapshotStore = defineStore('regional-snapshot', {
    state: () => ({
        isBusy: {
            listing: true,
            details: true
        },
        goalId: null,
        region: null,
        snapshotGoals: [] as Array<SnapshotData>|null,
        snapshotGoalDetails: [] as Array<SnapshotDetailsData>|null,
    }),
    getters: {
        getImageUrl: (state) => (goalId: string) => {
            if (!state.snapshotGoals) return '';
            const goal = state.snapshotGoals.find(goal => goal.goal_number === goalId);
            return goal ? goal.image_url : '';
        }
    },
    actions: {
        async getSnapshotGoals (region: string) {
            this.isBusy.listing = true;

            const request = axios.get<SnapshotData[]>(
                `/api/data-points/regional/snapshot/goals`,
                { 
                    params: {
                        region: region
                    }
                }
            )

            const response = await useErrorHandling(request);

            this.$patch({
                isBusy: {
                    ...this.isBusy,
                    listing: false
                },
                snapshotGoals: response.data
            })
        },
        async getSnapshotGoalDetails (goal_number: string, region: string) {
            this.isBusy.details = true;

            const request = axios.get<SnapshotDetailsData[]>(
                `/api/data-points/regional/snapshot-chart`,
                { 
                    params: {
                        goal_number: goal_number,
                        region: region
                    }
                }
            )

            const response = await useErrorHandling(request);

            this.$patch({
                isBusy: {
                    ...this.isBusy,
                    details: false
                },
                snapshotGoalDetails: response.data
            })
        }
    }
})