export interface GoalData {
    goal_name: string;
    goal_number: string;
    image_url: string;
}

// types for goals dashboard chart
export interface GoalsData extends GoalData {
    target_number: string;
    target_color: string;
    target_long_name: string;
}

// types for goal details chart
export interface GoalDetailsData {
    target_color: string;
    indicator_data_id: string;
    indicator_id: string;
    indicator_short_name: string;
    year: string;
    snapshot_indicator: string;
    country_group: string;
}

// types for Snapshot Chart
export interface SnapshotData {
    goal_data_id: string;
    goal_number: string;
    year: string;
    snapshot_goal: string;
    indicator_percentage: string;
    country_group: string;
    goal_name: string;
    image_url: string;
}

// types for snapshot details chart
export interface SnapshotDetailsData {
    goal_name: string;
    image_url: string;
    goal_number: string;
    target_number: string;
    snapshot_indicator: string;
    target_long_name: string;
}

// National Analaysis - Priorities
export interface NationalPrioritiesData {
    category_name: string;
    data: NationalPrioritiesTargetData[];
}

export interface NationalPrioritiesTargetData {
    sdg_performers_data_id: string;
    ind_number: string;
    ind_short_name: string;
    series_name: string;
    area: string;
    unit_name: string;
    series: string;
    series_level: string;
    trend: string;
    year: string;
    data_value: string;
}

export interface FormattedPrioritiesTargetData {
    sdg_performers_data_id: string;
    ind_number: string;
    ind_short_name: string;
    series_name: string;
    area: string;
    unit_name: string;
    series: string;
    series_level: string;
    trend: string;
    data_points: PrioritiesDataPoints[];
}

export interface PrioritiesDataPoints {
    year: string;
    data_value: string;
}

// national data availability summary chart
export interface SummaryChartData {
    breakdown: DataAvailability[];
}

export interface DataAvailability {
    name: string;
    count: number;
    percentage: number;
}

// national data availability overview chart
export interface NationalOverviewGoals {
    goal_number: number;
    goal_name: string;
    image: string;
    category: string;
    count: number;
    percentage: number;
}

export interface OverviewDataAvailability {
    Sufficient?: OverviewData;
    Insufficient?: OverviewData;
    "No Data"?: OverviewData;
    "Not Applicable"?: OverviewData;
}

export interface OverviewData {
    count: number;
    percentage: number;
}

// national data availability indicator details chart
// export interface IndicatorDetailsData {
//     Sufficient: Indicator[];
//     Insufficient: Indicator[];
//     "No Data": Indicator[];
//     "Not Applicable": Indicator[];
// }
export interface IndicatorDetailsData {
    category: string;
    data: Indicator[];
}

export interface Indicator {
    indicatorNumber: string;
    indicatorName: string;
    latestYear: string;
    compiler: string;
    dataSource: string;
    sufficientCount: number;
    insufficientCount: number;
    noDataCount: number;
}

// National Analysis - Overview
export interface NationalOverviewData {
    data: NationalOverviewGoalsData[];
    summary_goals: NationalOverviewSummaryData;
}

export interface NationalOverviewSummaryData {
    best_performers: NationalOverviewGoalsData[];
    worst_performers: NationalOverviewGoalsData[];
}

export interface NationalOverviewGoalsData {
    goal_name: string;
    goal_number: string;
    image_url: string;
    star_level: string;
    Performer: number;
    Regressing: number;
    Stagnant: number;
    Insufficient: number;
    NA: number;
}

export interface NationalOverviewDetailData {
    category: string;
    data: OverviewCategoryData[];
}

export interface OverviewCategoryData {
    ind_number: string;
    ind_short_name: string;
    target_number: string;
    area: string;
    trend: string;
    series: string;
    series_name: string;
    series_tag: string;
    unit_name: string;
    series_level: string;
    year: string;
    data_value: number;
}

// export interface OverviewCategoryData {
//     area: string,
//     ind_number: string;
//     ind_short_name: string;
//     series_data: NationalOverviewSeriesDataPoint[]
//     target_number: string,
//     trend: string,
// }

// export interface NationalOverviewSeriesDataPoint {
//     data_points: DataPoint[];
//     series: string;
//     series_name: string;
//     unit_name: string;
//     series_level: string;
// }

// Regional Analysis - Data Availability
export interface RegionalAvailabilityData {
    year: string;
    availability: AvailabilityData;
}

export interface AvailabilityData {
    Insufficient: number;
    Sufficient: number;
    "No Data": number;
    "Not Applicable"?: number;
}

export interface RegionalOverviewGoalsData {
    formattedGoalNumber: string;
    goal_number: number;
    goal_name: string;
    image_url: string;
    dataAvailability: OverviewDataAvailability;
}

export interface RegionalIndicatorData {
  indicatorNumber: string;
  indicatorName: string;
  sufficientCount: number;
  insufficientCount: number;
  noDataCount: number;
}

// export interface AreaData {
//   category: 'Sufficient' | 'Insufficient' | 'No Data' | 'Not Applicable';
//   count: number;
// }

export interface RegionalCountryTerritoriesData {
  country: string;
  Sufficient: number;
  "Insufficient Data": number;
  "No Data": number;
  "Not Applicable"?: number;
}