import { object, ObjectSchema, string } from "yup";
import { ContactUsFormFields } from "./types";

export const ContactUsFormFieldsSchema: ObjectSchema<ContactUsFormFields> = object({
    purpose_of_enquiry: string().required().label('Purpose of Enquiry'),
    organisation: string().required().label('Your Organisation'),
    email: string().required().email().label('Email'),
    name: string().transform((value) => value || '').optional().default(null).label('Name'),
    organisation_name: string().transform((value) => value || '').optional().default(null).label('Organisation Name'),
    suggestion: string().required().label('Suggestion or Feedback'),
    page_url: string().transform((value) => value || '').required().default('url')
})