import { defineStore } from "pinia";
import axios from "axios";
import { RelatedUseCases } from "../types";
import { useErrorHandling } from "@/modules/core/composables";

export const useRelatedUseCasesStore = defineStore('related-use-cases', {
    state: () => ({
        isBusy: true,
        useCases: null as RelatedUseCases|null
    }),
    actions: {
        async getRelatedUseCases(epic_use_case_id: string, count: number) {
            this.isBusy = true

            const request = axios.get<RelatedUseCases>(
                `/api/epic-use-cases/related`,
                {
                    params: {
                        epic_use_case_id: epic_use_case_id,
                        count: count
                    }
                }
            )

            const response = await useErrorHandling(request)

            this.$patch({
                isBusy: false,
                useCases: response.data
            })
        }
    }
})