import { defineStore } from "pinia";
import axios from "axios";
import { useErrorHandling } from "@/modules/core/composables";
import { ResourceListingData, ResourceTags } from '../types'

export const useResourcesListingStore = defineStore('resources-listing', {
    state: () => ({
        isBusy: {
            tags: false,
            listing: false,
        }, 
        category: null,
        resourcesTags: [] as Array<ResourceTags>|null,
        resources: null as ResourceListingData|null,
        filters: {
            resource_category: '',
            page_number: 1,
            page_size: 12,
        }
    }),
    actions: {
        async getResourcesTags () {
            this.isBusy.tags = true

            const request = axios.get<ResourceTags[]>(
              `/api/resources/tags`,
            )

            const response = await useErrorHandling(request);

            this.$patch({
                isBusy: {
                    ...this.isBusy,
                    tags: false
                },
                resourcesTags: response.data
            })
        },
        async getResourcesListing () {
            this.isBusy.listing = true;

            const request = axios.get<ResourceListingData>(
                `api/resources`,
                { params: this.filters }
            )

            const response = await useErrorHandling(request);

            this.$patch({
                isBusy: {
                    ...this.isBusy,
                    listing: false
                },
                resources: response.data
            })
        }
    }
})